# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SsoTokenRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'email': 'str',
        'target': 'str',
        'url': 'str'
    }

    attribute_map = {
        'id': 'id',
        'email': 'email',
        'target': 'target',
        'url': 'url'
    }

    def __init__(self, id=None, email=None, target=None, url=None):  # noqa: E501
        """SsoTokenRequest - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._email = None
        self._target = None
        self._url = None
        self.discriminator = None

        self.id = id
        if email is not None:
            self.email = email
        if target is not None:
            self.target = target
        if url is not None:
            self.url = url

    @property
    def id(self):
        """Gets the id of this SsoTokenRequest.  # noqa: E501

        Id of the sub-account organization  # noqa: E501

        :return: The id of this SsoTokenRequest.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SsoTokenRequest.

        Id of the sub-account organization  # noqa: E501

        :param id: The id of this SsoTokenRequest.  # noqa: E501
        :type: int
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def email(self):
        """Gets the email of this SsoTokenRequest.  # noqa: E501

        User email of sub-account organization  # noqa: E501

        :return: The email of this SsoTokenRequest.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this SsoTokenRequest.

        User email of sub-account organization  # noqa: E501

        :param email: The email of this SsoTokenRequest.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def target(self):
        """Gets the target of this SsoTokenRequest.  # noqa: E501

        Set target after login success * automation - Redirect to Automation after login * email_campaign - Redirect to Email Campaign after login * contacts - Redirect to Contacts after login * landing_pages - Redirect to Landing Pages after login * email_transactional - Redirect to Email Transactional after login * senders - Redirect to Contacts after login * sms_campaign - Redirect to Sms Campaign after login * sms_transactional - Redirect to Sms Transactional after login   # noqa: E501

        :return: The target of this SsoTokenRequest.  # noqa: E501
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """Sets the target of this SsoTokenRequest.

        Set target after login success * automation - Redirect to Automation after login * email_campaign - Redirect to Email Campaign after login * contacts - Redirect to Contacts after login * landing_pages - Redirect to Landing Pages after login * email_transactional - Redirect to Email Transactional after login * senders - Redirect to Contacts after login * sms_campaign - Redirect to Sms Campaign after login * sms_transactional - Redirect to Sms Transactional after login   # noqa: E501

        :param target: The target of this SsoTokenRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["automation", "email_campaign", "contacts", "landing_pages", "email_transactional", "senders", "sms_campaign", "sms_transactional"]  # noqa: E501
        if target not in allowed_values:
            raise ValueError(
                "Invalid value for `target` ({0}), must be one of {1}"  # noqa: E501
                .format(target, allowed_values)
            )

        self._target = target

    @property
    def url(self):
        """Gets the url of this SsoTokenRequest.  # noqa: E501

        Set the full target URL after login success. The user will land directly on this target URL after login  # noqa: E501

        :return: The url of this SsoTokenRequest.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this SsoTokenRequest.

        Set the full target URL after login success. The user will land directly on this target URL after login  # noqa: E501

        :param url: The url of this SsoTokenRequest.  # noqa: E501
        :type: str
        """

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SsoTokenRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SsoTokenRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
