# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SubscriptionHandlerInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'balance': 'object',
        'members': 'list[MemberContact]',
        'reward': 'list[SubscriptionAttributedReward]',
        'tier': 'list[SubscriptionTier]'
    }

    attribute_map = {
        'balance': 'balance',
        'members': 'members',
        'reward': 'reward',
        'tier': 'tier'
    }

    def __init__(self, balance=None, members=None, reward=None, tier=None):  # noqa: E501
        """SubscriptionHandlerInfo - a model defined in Swagger"""  # noqa: E501

        self._balance = None
        self._members = None
        self._reward = None
        self._tier = None
        self.discriminator = None

        if balance is not None:
            self.balance = balance
        if members is not None:
            self.members = members
        if reward is not None:
            self.reward = reward
        if tier is not None:
            self.tier = tier

    @property
    def balance(self):
        """Gets the balance of this SubscriptionHandlerInfo.  # noqa: E501

        Balance details for the subscription.  # noqa: E501

        :return: The balance of this SubscriptionHandlerInfo.  # noqa: E501
        :rtype: object
        """
        return self._balance

    @balance.setter
    def balance(self, balance):
        """Sets the balance of this SubscriptionHandlerInfo.

        Balance details for the subscription.  # noqa: E501

        :param balance: The balance of this SubscriptionHandlerInfo.  # noqa: E501
        :type: object
        """

        self._balance = balance

    @property
    def members(self):
        """Gets the members of this SubscriptionHandlerInfo.  # noqa: E501

        List of members associated with the subscription.  # noqa: E501

        :return: The members of this SubscriptionHandlerInfo.  # noqa: E501
        :rtype: list[MemberContact]
        """
        return self._members

    @members.setter
    def members(self, members):
        """Sets the members of this SubscriptionHandlerInfo.

        List of members associated with the subscription.  # noqa: E501

        :param members: The members of this SubscriptionHandlerInfo.  # noqa: E501
        :type: list[MemberContact]
        """

        self._members = members

    @property
    def reward(self):
        """Gets the reward of this SubscriptionHandlerInfo.  # noqa: E501

        List of rewards associated with the subscription.  # noqa: E501

        :return: The reward of this SubscriptionHandlerInfo.  # noqa: E501
        :rtype: list[SubscriptionAttributedReward]
        """
        return self._reward

    @reward.setter
    def reward(self, reward):
        """Sets the reward of this SubscriptionHandlerInfo.

        List of rewards associated with the subscription.  # noqa: E501

        :param reward: The reward of this SubscriptionHandlerInfo.  # noqa: E501
        :type: list[SubscriptionAttributedReward]
        """

        self._reward = reward

    @property
    def tier(self):
        """Gets the tier of this SubscriptionHandlerInfo.  # noqa: E501

        List of tier assignments for the subscription.  # noqa: E501

        :return: The tier of this SubscriptionHandlerInfo.  # noqa: E501
        :rtype: list[SubscriptionTier]
        """
        return self._tier

    @tier.setter
    def tier(self, tier):
        """Sets the tier of this SubscriptionHandlerInfo.

        List of tier assignments for the subscription.  # noqa: E501

        :param tier: The tier of this SubscriptionHandlerInfo.  # noqa: E501
        :type: list[SubscriptionTier]
        """

        self._tier = tier

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SubscriptionHandlerInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SubscriptionHandlerInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
