# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Tier(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'tier_id': 'str',
        'name': 'str',
        'image_ref': 'str',
        'loyalty_program_id': 'str',
        'group_id': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'access_conditions': 'list[TierAccessConditions]',
        'tier_rewards': 'list[TierTierRewards]'
    }

    attribute_map = {
        'tier_id': 'tierId',
        'name': 'name',
        'image_ref': 'imageRef',
        'loyalty_program_id': 'loyaltyProgramId',
        'group_id': 'groupId',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'access_conditions': 'accessConditions',
        'tier_rewards': 'tierRewards'
    }

    def __init__(self, tier_id=None, name=None, image_ref=None, loyalty_program_id=None, group_id=None, created_at=None, updated_at=None, access_conditions=None, tier_rewards=None):  # noqa: E501
        """Tier - a model defined in Swagger"""  # noqa: E501

        self._tier_id = None
        self._name = None
        self._image_ref = None
        self._loyalty_program_id = None
        self._group_id = None
        self._created_at = None
        self._updated_at = None
        self._access_conditions = None
        self._tier_rewards = None
        self.discriminator = None

        if tier_id is not None:
            self.tier_id = tier_id
        if name is not None:
            self.name = name
        if image_ref is not None:
            self.image_ref = image_ref
        if loyalty_program_id is not None:
            self.loyalty_program_id = loyalty_program_id
        if group_id is not None:
            self.group_id = group_id
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if access_conditions is not None:
            self.access_conditions = access_conditions
        if tier_rewards is not None:
            self.tier_rewards = tier_rewards

    @property
    def tier_id(self):
        """Gets the tier_id of this Tier.  # noqa: E501

        Tier id  # noqa: E501

        :return: The tier_id of this Tier.  # noqa: E501
        :rtype: str
        """
        return self._tier_id

    @tier_id.setter
    def tier_id(self, tier_id):
        """Sets the tier_id of this Tier.

        Tier id  # noqa: E501

        :param tier_id: The tier_id of this Tier.  # noqa: E501
        :type: str
        """

        self._tier_id = tier_id

    @property
    def name(self):
        """Gets the name of this Tier.  # noqa: E501

        Tier name  # noqa: E501

        :return: The name of this Tier.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Tier.

        Tier name  # noqa: E501

        :param name: The name of this Tier.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def image_ref(self):
        """Gets the image_ref of this Tier.  # noqa: E501

        Tier image reference  # noqa: E501

        :return: The image_ref of this Tier.  # noqa: E501
        :rtype: str
        """
        return self._image_ref

    @image_ref.setter
    def image_ref(self, image_ref):
        """Sets the image_ref of this Tier.

        Tier image reference  # noqa: E501

        :param image_ref: The image_ref of this Tier.  # noqa: E501
        :type: str
        """

        self._image_ref = image_ref

    @property
    def loyalty_program_id(self):
        """Gets the loyalty_program_id of this Tier.  # noqa: E501

        Associated loyalty program Id  # noqa: E501

        :return: The loyalty_program_id of this Tier.  # noqa: E501
        :rtype: str
        """
        return self._loyalty_program_id

    @loyalty_program_id.setter
    def loyalty_program_id(self, loyalty_program_id):
        """Sets the loyalty_program_id of this Tier.

        Associated loyalty program Id  # noqa: E501

        :param loyalty_program_id: The loyalty_program_id of this Tier.  # noqa: E501
        :type: str
        """

        self._loyalty_program_id = loyalty_program_id

    @property
    def group_id(self):
        """Gets the group_id of this Tier.  # noqa: E501

        Associated group Id  # noqa: E501

        :return: The group_id of this Tier.  # noqa: E501
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """Sets the group_id of this Tier.

        Associated group Id  # noqa: E501

        :param group_id: The group_id of this Tier.  # noqa: E501
        :type: str
        """

        self._group_id = group_id

    @property
    def created_at(self):
        """Gets the created_at of this Tier.  # noqa: E501


        :return: The created_at of this Tier.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Tier.


        :param created_at: The created_at of this Tier.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Tier.  # noqa: E501


        :return: The updated_at of this Tier.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Tier.


        :param updated_at: The updated_at of this Tier.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def access_conditions(self):
        """Gets the access_conditions of this Tier.  # noqa: E501

        Conditions required to access this tier  # noqa: E501

        :return: The access_conditions of this Tier.  # noqa: E501
        :rtype: list[TierAccessConditions]
        """
        return self._access_conditions

    @access_conditions.setter
    def access_conditions(self, access_conditions):
        """Sets the access_conditions of this Tier.

        Conditions required to access this tier  # noqa: E501

        :param access_conditions: The access_conditions of this Tier.  # noqa: E501
        :type: list[TierAccessConditions]
        """

        self._access_conditions = access_conditions

    @property
    def tier_rewards(self):
        """Gets the tier_rewards of this Tier.  # noqa: E501

        Rewards associated with this tier  # noqa: E501

        :return: The tier_rewards of this Tier.  # noqa: E501
        :rtype: list[TierTierRewards]
        """
        return self._tier_rewards

    @tier_rewards.setter
    def tier_rewards(self, tier_rewards):
        """Sets the tier_rewards of this Tier.

        Rewards associated with this tier  # noqa: E501

        :param tier_rewards: The tier_rewards of this Tier.  # noqa: E501
        :type: list[TierTierRewards]
        """

        self._tier_rewards = tier_rewards

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Tier, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Tier):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
