# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class TierGroup(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'tier_order': 'list[str]',
        'loyalty_program_id': 'str',
        'upgrade_strategy': 'str',
        'downgrade_strategy': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'tier_order': 'tierOrder',
        'loyalty_program_id': 'loyaltyProgramId',
        'upgrade_strategy': 'upgradeStrategy',
        'downgrade_strategy': 'downgradeStrategy',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, id=None, name=None, tier_order=None, loyalty_program_id=None, upgrade_strategy='real_time', downgrade_strategy='real_time', created_at=None, updated_at=None):  # noqa: E501
        """TierGroup - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._name = None
        self._tier_order = None
        self._loyalty_program_id = None
        self._upgrade_strategy = None
        self._downgrade_strategy = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if tier_order is not None:
            self.tier_order = tier_order
        if loyalty_program_id is not None:
            self.loyalty_program_id = loyalty_program_id
        if upgrade_strategy is not None:
            self.upgrade_strategy = upgrade_strategy
        if downgrade_strategy is not None:
            self.downgrade_strategy = downgrade_strategy
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this TierGroup.  # noqa: E501

        Tier group unique identifier  # noqa: E501

        :return: The id of this TierGroup.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TierGroup.

        Tier group unique identifier  # noqa: E501

        :param id: The id of this TierGroup.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this TierGroup.  # noqa: E501

        Tier group name  # noqa: E501

        :return: The name of this TierGroup.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TierGroup.

        Tier group name  # noqa: E501

        :param name: The name of this TierGroup.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def tier_order(self):
        """Gets the tier_order of this TierGroup.  # noqa: E501

        Order of the tiers in the group in ascending order  # noqa: E501

        :return: The tier_order of this TierGroup.  # noqa: E501
        :rtype: list[str]
        """
        return self._tier_order

    @tier_order.setter
    def tier_order(self, tier_order):
        """Sets the tier_order of this TierGroup.

        Order of the tiers in the group in ascending order  # noqa: E501

        :param tier_order: The tier_order of this TierGroup.  # noqa: E501
        :type: list[str]
        """

        self._tier_order = tier_order

    @property
    def loyalty_program_id(self):
        """Gets the loyalty_program_id of this TierGroup.  # noqa: E501

        Associated loyalty program Id  # noqa: E501

        :return: The loyalty_program_id of this TierGroup.  # noqa: E501
        :rtype: str
        """
        return self._loyalty_program_id

    @loyalty_program_id.setter
    def loyalty_program_id(self, loyalty_program_id):
        """Sets the loyalty_program_id of this TierGroup.

        Associated loyalty program Id  # noqa: E501

        :param loyalty_program_id: The loyalty_program_id of this TierGroup.  # noqa: E501
        :type: str
        """

        self._loyalty_program_id = loyalty_program_id

    @property
    def upgrade_strategy(self):
        """Gets the upgrade_strategy of this TierGroup.  # noqa: E501

        Select real_time to upgrade tier on real time balance updates. Select membership_anniversary to upgrade tier on subscription anniversary. Select tier_anniversary to upgrade tier on tier anniversary.  # noqa: E501

        :return: The upgrade_strategy of this TierGroup.  # noqa: E501
        :rtype: str
        """
        return self._upgrade_strategy

    @upgrade_strategy.setter
    def upgrade_strategy(self, upgrade_strategy):
        """Sets the upgrade_strategy of this TierGroup.

        Select real_time to upgrade tier on real time balance updates. Select membership_anniversary to upgrade tier on subscription anniversary. Select tier_anniversary to upgrade tier on tier anniversary.  # noqa: E501

        :param upgrade_strategy: The upgrade_strategy of this TierGroup.  # noqa: E501
        :type: str
        """
        allowed_values = ["real_time", "membership_anniversary", "tier_anniversary"]  # noqa: E501
        if upgrade_strategy not in allowed_values:
            raise ValueError(
                "Invalid value for `upgrade_strategy` ({0}), must be one of {1}"  # noqa: E501
                .format(upgrade_strategy, allowed_values)
            )

        self._upgrade_strategy = upgrade_strategy

    @property
    def downgrade_strategy(self):
        """Gets the downgrade_strategy of this TierGroup.  # noqa: E501

        Select real_time to downgrade tier on real time balance updates. Select membership_anniversary to downgrade tier on subscription anniversary. Select tier_anniversary to downgrade tier on tier anniversary.  # noqa: E501

        :return: The downgrade_strategy of this TierGroup.  # noqa: E501
        :rtype: str
        """
        return self._downgrade_strategy

    @downgrade_strategy.setter
    def downgrade_strategy(self, downgrade_strategy):
        """Sets the downgrade_strategy of this TierGroup.

        Select real_time to downgrade tier on real time balance updates. Select membership_anniversary to downgrade tier on subscription anniversary. Select tier_anniversary to downgrade tier on tier anniversary.  # noqa: E501

        :param downgrade_strategy: The downgrade_strategy of this TierGroup.  # noqa: E501
        :type: str
        """
        allowed_values = ["real_time", "membership_anniversary", "tier_anniversary"]  # noqa: E501
        if downgrade_strategy not in allowed_values:
            raise ValueError(
                "Invalid value for `downgrade_strategy` ({0}), must be one of {1}"  # noqa: E501
                .format(downgrade_strategy, allowed_values)
            )

        self._downgrade_strategy = downgrade_strategy

    @property
    def created_at(self):
        """Gets the created_at of this TierGroup.  # noqa: E501

        Timestamp when the tier group was created  # noqa: E501

        :return: The created_at of this TierGroup.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this TierGroup.

        Timestamp when the tier group was created  # noqa: E501

        :param created_at: The created_at of this TierGroup.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this TierGroup.  # noqa: E501

        Timestamp when the tier group was last updated  # noqa: E501

        :return: The updated_at of this TierGroup.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this TierGroup.

        Timestamp when the tier group was last updated  # noqa: E501

        :param updated_at: The updated_at of this TierGroup.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TierGroup, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TierGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
