# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class TransactionHistoryResp(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'balance_definition_id': 'str',
        'contact_id': 'int',
        'count': 'int',
        'loyalty_program_id': 'str',
        'transaction_history': 'list[TransactionHistory]'
    }

    attribute_map = {
        'balance_definition_id': 'balanceDefinitionId',
        'contact_id': 'contactId',
        'count': 'count',
        'loyalty_program_id': 'loyaltyProgramId',
        'transaction_history': 'transactionHistory'
    }

    def __init__(self, balance_definition_id=None, contact_id=None, count=None, loyalty_program_id=None, transaction_history=None):  # noqa: E501
        """TransactionHistoryResp - a model defined in Swagger"""  # noqa: E501

        self._balance_definition_id = None
        self._contact_id = None
        self._count = None
        self._loyalty_program_id = None
        self._transaction_history = None
        self.discriminator = None

        if balance_definition_id is not None:
            self.balance_definition_id = balance_definition_id
        if contact_id is not None:
            self.contact_id = contact_id
        if count is not None:
            self.count = count
        if loyalty_program_id is not None:
            self.loyalty_program_id = loyalty_program_id
        if transaction_history is not None:
            self.transaction_history = transaction_history

    @property
    def balance_definition_id(self):
        """Gets the balance_definition_id of this TransactionHistoryResp.  # noqa: E501

        Unique identifier of the associated balance definition.  # noqa: E501

        :return: The balance_definition_id of this TransactionHistoryResp.  # noqa: E501
        :rtype: str
        """
        return self._balance_definition_id

    @balance_definition_id.setter
    def balance_definition_id(self, balance_definition_id):
        """Sets the balance_definition_id of this TransactionHistoryResp.

        Unique identifier of the associated balance definition.  # noqa: E501

        :param balance_definition_id: The balance_definition_id of this TransactionHistoryResp.  # noqa: E501
        :type: str
        """

        self._balance_definition_id = balance_definition_id

    @property
    def contact_id(self):
        """Gets the contact_id of this TransactionHistoryResp.  # noqa: E501

        Unique identifier of the contact related to the transactions.  # noqa: E501

        :return: The contact_id of this TransactionHistoryResp.  # noqa: E501
        :rtype: int
        """
        return self._contact_id

    @contact_id.setter
    def contact_id(self, contact_id):
        """Sets the contact_id of this TransactionHistoryResp.

        Unique identifier of the contact related to the transactions.  # noqa: E501

        :param contact_id: The contact_id of this TransactionHistoryResp.  # noqa: E501
        :type: int
        """

        self._contact_id = contact_id

    @property
    def count(self):
        """Gets the count of this TransactionHistoryResp.  # noqa: E501

        Total number of transactions in the history.  # noqa: E501

        :return: The count of this TransactionHistoryResp.  # noqa: E501
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """Sets the count of this TransactionHistoryResp.

        Total number of transactions in the history.  # noqa: E501

        :param count: The count of this TransactionHistoryResp.  # noqa: E501
        :type: int
        """

        self._count = count

    @property
    def loyalty_program_id(self):
        """Gets the loyalty_program_id of this TransactionHistoryResp.  # noqa: E501

        Unique identifier of the associated loyalty program.  # noqa: E501

        :return: The loyalty_program_id of this TransactionHistoryResp.  # noqa: E501
        :rtype: str
        """
        return self._loyalty_program_id

    @loyalty_program_id.setter
    def loyalty_program_id(self, loyalty_program_id):
        """Sets the loyalty_program_id of this TransactionHistoryResp.

        Unique identifier of the associated loyalty program.  # noqa: E501

        :param loyalty_program_id: The loyalty_program_id of this TransactionHistoryResp.  # noqa: E501
        :type: str
        """

        self._loyalty_program_id = loyalty_program_id

    @property
    def transaction_history(self):
        """Gets the transaction_history of this TransactionHistoryResp.  # noqa: E501

        List of past transactions associated with the balance.  # noqa: E501

        :return: The transaction_history of this TransactionHistoryResp.  # noqa: E501
        :rtype: list[TransactionHistory]
        """
        return self._transaction_history

    @transaction_history.setter
    def transaction_history(self, transaction_history):
        """Sets the transaction_history of this TransactionHistoryResp.

        List of past transactions associated with the balance.  # noqa: E501

        :param transaction_history: The transaction_history of this TransactionHistoryResp.  # noqa: E501
        :type: list[TransactionHistory]
        """

        self._transaction_history = transaction_history

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TransactionHistoryResp, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TransactionHistoryResp):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
