# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class UpdateTierGroupRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'tier_order': 'list[str]',
        'upgrade_strategy': 'str',
        'downgrade_strategy': 'str'
    }

    attribute_map = {
        'name': 'name',
        'tier_order': 'tierOrder',
        'upgrade_strategy': 'upgradeStrategy',
        'downgrade_strategy': 'downgradeStrategy'
    }

    def __init__(self, name=None, tier_order=None, upgrade_strategy='real_time', downgrade_strategy='real_time'):  # noqa: E501
        """UpdateTierGroupRequest - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._tier_order = None
        self._upgrade_strategy = None
        self._downgrade_strategy = None
        self.discriminator = None

        self.name = name
        self.tier_order = tier_order
        self.upgrade_strategy = upgrade_strategy
        self.downgrade_strategy = downgrade_strategy

    @property
    def name(self):
        """Gets the name of this UpdateTierGroupRequest.  # noqa: E501

        Name of the tier group  # noqa: E501

        :return: The name of this UpdateTierGroupRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this UpdateTierGroupRequest.

        Name of the tier group  # noqa: E501

        :param name: The name of this UpdateTierGroupRequest.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def tier_order(self):
        """Gets the tier_order of this UpdateTierGroupRequest.  # noqa: E501

        Order of the tiers in the group in ascending order  # noqa: E501

        :return: The tier_order of this UpdateTierGroupRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._tier_order

    @tier_order.setter
    def tier_order(self, tier_order):
        """Sets the tier_order of this UpdateTierGroupRequest.

        Order of the tiers in the group in ascending order  # noqa: E501

        :param tier_order: The tier_order of this UpdateTierGroupRequest.  # noqa: E501
        :type: list[str]
        """
        if tier_order is None:
            raise ValueError("Invalid value for `tier_order`, must not be `None`")  # noqa: E501

        self._tier_order = tier_order

    @property
    def upgrade_strategy(self):
        """Gets the upgrade_strategy of this UpdateTierGroupRequest.  # noqa: E501

        Select real_time to upgrade tier on real time balance updates. Select membership_anniversary to upgrade tier on subscription anniversary. Select tier_anniversary to upgrade tier on tier anniversary.  # noqa: E501

        :return: The upgrade_strategy of this UpdateTierGroupRequest.  # noqa: E501
        :rtype: str
        """
        return self._upgrade_strategy

    @upgrade_strategy.setter
    def upgrade_strategy(self, upgrade_strategy):
        """Sets the upgrade_strategy of this UpdateTierGroupRequest.

        Select real_time to upgrade tier on real time balance updates. Select membership_anniversary to upgrade tier on subscription anniversary. Select tier_anniversary to upgrade tier on tier anniversary.  # noqa: E501

        :param upgrade_strategy: The upgrade_strategy of this UpdateTierGroupRequest.  # noqa: E501
        :type: str
        """
        if upgrade_strategy is None:
            raise ValueError("Invalid value for `upgrade_strategy`, must not be `None`")  # noqa: E501
        allowed_values = ["real_time", "membership_anniversary", "tier_anniversary"]  # noqa: E501
        if upgrade_strategy not in allowed_values:
            raise ValueError(
                "Invalid value for `upgrade_strategy` ({0}), must be one of {1}"  # noqa: E501
                .format(upgrade_strategy, allowed_values)
            )

        self._upgrade_strategy = upgrade_strategy

    @property
    def downgrade_strategy(self):
        """Gets the downgrade_strategy of this UpdateTierGroupRequest.  # noqa: E501

        Select real_time to downgrade tier on real time balance updates. Select membership_anniversary to downgrade tier on subscription anniversary. Select tier_anniversary to downgrade tier on tier anniversary.  # noqa: E501

        :return: The downgrade_strategy of this UpdateTierGroupRequest.  # noqa: E501
        :rtype: str
        """
        return self._downgrade_strategy

    @downgrade_strategy.setter
    def downgrade_strategy(self, downgrade_strategy):
        """Sets the downgrade_strategy of this UpdateTierGroupRequest.

        Select real_time to downgrade tier on real time balance updates. Select membership_anniversary to downgrade tier on subscription anniversary. Select tier_anniversary to downgrade tier on tier anniversary.  # noqa: E501

        :param downgrade_strategy: The downgrade_strategy of this UpdateTierGroupRequest.  # noqa: E501
        :type: str
        """
        if downgrade_strategy is None:
            raise ValueError("Invalid value for `downgrade_strategy`, must not be `None`")  # noqa: E501
        allowed_values = ["real_time", "membership_anniversary", "tier_anniversary"]  # noqa: E501
        if downgrade_strategy not in allowed_values:
            raise ValueError(
                "Invalid value for `downgrade_strategy` ({0}), must be one of {1}"  # noqa: E501
                .format(downgrade_strategy, allowed_values)
            )

        self._downgrade_strategy = downgrade_strategy

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UpdateTierGroupRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateTierGroupRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
