"""initial schema

Revision ID: 4b4ff56edabe
Revises: 
Create Date: 2025-11-26 00:56:40.881088

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '4b4ff56edabe'
down_revision: Union[str, Sequence[str], None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('projects',
    sa.Column('project_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=200), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.CheckConstraint('length(name) <= 200', name='check_project_name_length'),
    sa.CheckConstraint('length(name) > 0', name='check_project_name_not_empty'),
    sa.PrimaryKeyConstraint('project_id')
    )
    op.create_index(op.f('ix_projects_name'), 'projects', ['name'], unique=True)
    op.create_index(op.f('ix_projects_project_id'), 'projects', ['project_id'], unique=False)
    op.create_table('tags',
    sa.Column('tag_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.CheckConstraint('length(name) <= 100', name='check_tag_name_length'),
    sa.CheckConstraint('length(name) > 0', name='check_tag_name_not_empty'),
    sa.PrimaryKeyConstraint('tag_id')
    )
    op.create_index(op.f('ix_tags_name'), 'tags', ['name'], unique=True)
    op.create_table('issues',
    sa.Column('issue_id', sa.Integer(), nullable=False),
    sa.Column('project_id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=100), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('log', sa.Text(), nullable=True),
    sa.Column('summary', sa.Text(), nullable=True),
    sa.Column('priority', sa.String(length=6), nullable=False),
    sa.Column('status', sa.String(length=11), nullable=False),
    sa.Column('assignee', sa.String(length=100), nullable=True),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.CheckConstraint("priority IN ('low','medium','high')", name='check_issue_priority'),
    sa.CheckConstraint("status IN ('open','in_progress','closed')", name='check_issue_status'),
    sa.CheckConstraint('assignee IS NULL OR length(assignee) <= 100', name='check_assignee_length'),
    sa.CheckConstraint('assignee IS NULL OR length(assignee) > 0', name='check_assignee_not_empty'),
    sa.CheckConstraint('length(title) <= 100', name='check_issue_title_length'),
    sa.CheckConstraint('length(title) > 0', name='check_issue_title_not_empty'),
    sa.ForeignKeyConstraint(['project_id'], ['projects.project_id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('issue_id')
    )
    op.create_index('idx_issues_assignee_status', 'issues', ['assignee', 'status'], unique=False)
    op.create_index('idx_issues_status_priority', 'issues', ['status', 'priority'], unique=False)
    op.create_index(op.f('ix_issues_assignee'), 'issues', ['assignee'], unique=False)
    op.create_index(op.f('ix_issues_created_at'), 'issues', ['created_at'], unique=False)
    op.create_index(op.f('ix_issues_priority'), 'issues', ['priority'], unique=False)
    op.create_index(op.f('ix_issues_project_id'), 'issues', ['project_id'], unique=False)
    op.create_index(op.f('ix_issues_status'), 'issues', ['status'], unique=False)
    op.create_table('issue_tags',
    sa.Column('issue_id', sa.Integer(), nullable=False),
    sa.Column('tag_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['issue_id'], ['issues.issue_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['tag_id'], ['tags.tag_id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('issue_id', 'tag_id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('issue_tags')
    op.drop_index(op.f('ix_issues_status'), table_name='issues')
    op.drop_index(op.f('ix_issues_project_id'), table_name='issues')
    op.drop_index(op.f('ix_issues_priority'), table_name='issues')
    op.drop_index(op.f('ix_issues_created_at'), table_name='issues')
    op.drop_index(op.f('ix_issues_assignee'), table_name='issues')
    op.drop_index('idx_issues_status_priority', table_name='issues')
    op.drop_index('idx_issues_assignee_status', table_name='issues')
    op.drop_table('issues')
    op.drop_index(op.f('ix_tags_name'), table_name='tags')
    op.drop_table('tags')
    op.drop_index(op.f('ix_projects_project_id'), table_name='projects')
    op.drop_index(op.f('ix_projects_name'), table_name='projects')
    op.drop_table('projects')
    # ### end Alembic commands ###
