import numpy as np
from numpy.typing import NDArray

class LogLevel:
    NONE: int
    ERROR: int
    WARN: int
    INFO: int
    DEBUG: int

class Bungee:
    def __init__(
        self,
        sample_rate: int,
        channels: int,
        speed: float = 1.0,
        pitch: float = 1.0,
        log2_synthesis_hop_adjust: int = -1,
    ) -> None: ...
    def process(self, input: NDArray[np.float32]) -> NDArray[np.float32]: ...
    def set_debug(self, enabled: bool) -> None: ...
    def get_debug(self) -> bool: ...
    def set_speed(self, speed: float) -> None: ...
    def set_pitch(self, pitch: float) -> None: ...
    def get_latency(self) -> float: ...
    def preroll(self) -> None: ...
    def time_stretch(
        self, input: NDArray[np.float32], stretch_factor: float
    ) -> NDArray[np.float32]: ...
    def pitch_shift(
        self, input: NDArray[np.float32], semitones: float
    ) -> NDArray[np.float32]: ...
    def set_log_level(self, level: int) -> None: ...
    def get_log_level(self) -> int: ...
    def log(self, level: int, message: str) -> None: ...
