"""
Tests for `bx.seq.seq`.
"""

import unittest

import bx.seq
from bx.seq import (
    fasta_tests,
    nib_tests,
    qdna_tests,
)

test_fa = "test_data/seq_tests/test.fa"
test2_fa = "test_data/seq_tests/test2.fa"
test_nib = "test_data/seq_tests/test.nib"
test_qdna = "test_data/seq_tests/test.qdna"

valid_fasta = fasta_tests.valid_seq
valid_nib = nib_tests.valid_seq
valid_qdna = qdna_tests.valid_seq

# Same sequences as stored in test2.fa

valid2_fa = [
    ("apple", "GGCGCTGCGATAAGGTTGCGACAACACGGACCTTCTTTTGCCTACCTCTGTTCTTGGCACG"),
    ("orange", "CGTGCCGAGAACAGAAAATACGCCGGGCGGTGCAGTAGTATCTTGGTATCCGATATGCAGG"),
    ("grapefruit", "CCTGCATATCGACTAGTACACCCTCCCGAGGTACCCCACCCATCCCTCTTTTCTCGGCGCG"),
]


class SEQTestCase(unittest.TestCase):
    def test_get_fasta(self):
        fastafile = bx.seq.seq_file(open(test_fa, "rb"))
        check_get(fastafile, valid_fasta, 3, 40)

    def test_get_nib(self):
        nibfile = bx.seq.seq_file(open(test_nib, "rb"))
        check_get(nibfile, valid_nib, 3, 40)

    def test_get_qdna(self):
        qdnafile = bx.seq.seq_file(open(test_qdna, "rb"))
        check_get(qdnafile, valid_qdna, 3, 40)

    def test_get_reader(self):
        reader = bx.seq.seq_reader(open(test2_fa, "rb"))
        for ix, seq in enumerate(reader):
            assert ix < len(valid2_fa), "FastaReader returns too many sequences"
            text = f"{seq}"
            fields = text.split()
            assert len(fields) == 2, f'SeqReader.__str__ returns incorrect sequence string "{text}"'
            assert (
                fields[0] == valid2_fa[ix][0]
            ), f"FastaReader returned the wrong name ({fields[0]},{valid2_fa[ix][0]})"
            assert (
                fields[1] == valid2_fa[ix][1]
            ), f"FastaReader returned the wrong text ({fields[1]},{valid2_fa[ix][1]})"


def check_get(seqfile, valid_seq, start, len):
    assert seqfile.get(start, len) == valid_seq[start : start + len]
