#   Copyright 1999-2000 Michael Hudson mwh@python.net
#
#                        All Rights Reserved
#
#
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and
# that both that copyright notice and this permission notice appear in
# supporting documentation.
#
# THE AUTHOR MICHAEL HUDSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS, IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,
# INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
# RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
# CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

import dis,re,sys,os,string

from bytecodehacks.code_gen import method_spec

temphead="""\
#   Copyright 1999-2000 Michael Hudson mwh@python.net
#
#                        All Rights Reserved
#
#
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and
# that both that copyright notice and this permission notice appear in
# supporting documentation.
#
# THE AUTHOR MICHAEL HUDSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS, IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,
# INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
# RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
# CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# this file is autogenerated by running
# from bytecodehacks.code_gen import write_ops
# write_ops.Main()

from bytecodehacks import opbases
from bytecodehacks.label import Label

_opbases = opbases
_Label = Label

del Label
del opbases

_bytecodes={}

"""

noargtemplate="""\
class %(name)s(_opbases.%(base)s):
    op = %(index)d
    opc = '\\%(index)03o'

    def __init__(self,cs=None,code=None):
        if cs is not None:
            _opbases.%(base)s.__init__(self,cs,code)
%(execute_method)s
%(stack_bump_method)s

_bytecodes[%(name)s.opc]=%(name)s

"""

argtemplate="""\
class %(name)s(_opbases.%(base)s):
    op = %(index)d
    opc = '\\%(index)03o'

    def __init__(self,csorarg,code=None):
        if code is not None:
            _opbases.%(base)s.__init__(self,csorarg,code)
        else:
            self.user_init(csorarg)
%(execute_method)s
%(stack_bump_method)s

_bytecodes[%(name)s.opc]=%(name)s

"""
jumptemplate="""\
class %(name)s(_opbases.%(base)s):
    op = %(index)d
    opc = '\\%(index)03o'

    def __init__(self,csorarg=None,code=None):
        if csorarg is not None:
            if code is not None:
                _opbases.%(base)s.__init__(self,csorarg,code)
            else:
                self.label = _Label()
                self.user_init(csorarg)
        else:
            self.label = _Label()
%(execute_method)s
%(stack_bump_method)s


_bytecodes[%(name)s.opc]=%(name)s

"""

execute_template = """\
    def execute(self,stack):
%s"""

stack_bump_template = """\
    def stack_manipulate(self,push,pop,block_push,block_pop,tracker):
%s"""

idprog=re.compile('^[_a-zA-Z][_a-zA-Z0-9]*$')
notopprog=re.compile('^<[0-9]+>$')

def choose_base_class_and_template(opc):
    if opc < dis.HAVE_ARGUMENT:
        return noargtemplate, "GenericOneByteCode"
    elif opc in dis.hasjrel:
        return jumptemplate,"JRel"
    elif opc in dis.hasjabs:
        return jumptemplate,"JAbs"
    elif opc in dis.hasname:
        return argtemplate,"NameOpcode"
    elif opc in dis.haslocal:
        return argtemplate,"LocalOpcode"
    else:
        return argtemplate,"GenericThreeByteCode"

execute_methods = method_spec.MethodSpecifier(
    os.path.join(os.path.dirname(__file__),
                 "execute_methods"))
stack_bump_methods = method_spec.MethodSpecifier(
    os.path.join(os.path.dirname(__file__),
                 "stack_bump_methods"))

execute_methods.set_template(execute_template)
stack_bump_methods.set_template(stack_bump_template)

def main(file=sys.stdout):
    file.write(temphead)
    trans=string.maketrans('+','_')
    for index in range(len(dis.opname)):
        name=string.translate(dis.opname[index],trans)
        
        if notopprog.match(name):
            continue
        if not idprog.match(name):
            name="Opcode_%d"%index

        s = "generating %s ..."%name
        pad = " " * (30-len(s))
        #print s,pad,

        template, base = choose_base_class_and_template(index)

        execute_method = execute_methods.get_method(name)
        stack_bump_method = stack_bump_methods.get_method(name)

        file.write(template%locals())

        #print "done"

def Main():
    opsfile = os.path.join(os.path.dirname(__file__),os.pardir,'ops.py')
    main(open(opsfile,'w'))
