__all__ = ["ContentGenerationTask"]

from byteplussdkarkruntime._models import BaseModel


class Usage(BaseModel):
    completion_tokens: int
    """The number of tokens used for completion."""


class Content(BaseModel):
    video_url: str
    """The URL of the generated video, if any."""

    last_frame_url: str
    """The URL of the last frame of the generated video, if any."""

    file_url: str
    """The URL of the generated file, if any."""


class ContentGenerationError(BaseModel):
    message: str
    """The reason for task failure"""

    code: str
    """The error code for task failure"""


class ContentGenerationTask(BaseModel):
    id: str
    """A unique identifier for the task."""

    model: str
    """The model used for the task."""

    status: str
    """The status of the task (running, failed, queued, succeeded, cancelled)."""

    error: ContentGenerationError
    """The error body, if applicable."""

    content: Content
    """The content generated by the task."""

    usage: Usage
    """The usage information for the task."""

    subdivisionlevel: str
    """The subdivision level of the task."""

    fileformat: str
    """The file format of the generated content."""

    frames: int
    """The number of frames in the generated content."""

    framespersecond: int
    """The number of frames per second in the generated content."""

    created_at: int
    """The Unix timestamp when the task was created."""

    updated_at: int
    """The Unix timestamp when the task was last updated."""

    seed: int
    """The seed used in the model."""

    revised_prompt: str
    """The revised prompt the model uses to generate content"""
