from byteplussdkarkruntime import Ark

# Authentication
# 1.If you authorize your endpoint using an API key, you can set your api key to environment variable "ARK_API_KEY"
# or specify api key by Ark(api_key="${YOUR_API_KEY}").
# Note: If you use an API key, this API key will not be refreshed.
# To prevent the API from expiring and failing after some time, choose an API key with no expiration date.
client = Ark()

if __name__ == "__main__":
    print("----- create request -----")
    create_result = client.content_generation.tasks.create(
        model="${YOUR_MODEL_EP}",
        content=[
            {
                "type": "text",
                "text": "Bird soaring above vast grasslands"
            },
            {
                "type": "image_url",
                "image_url": {
                    "url": "${YOUR_IMAGE_URL}"
                },
            }
        ],
        # callback_url="${YOUR_CALLBACK_URL}"
    )
    print(create_result)

    print("----- get request -----")
    get_result = client.content_generation.tasks.get(task_id=create_result.id)
    print(get_result)

    print("----- list request -----")
    list_result = client.content_generation.tasks.list(
        page_num=1,
        page_size=10,
        status="queued",  # succeeded, failed, running, cancelled
        # model="${YOUR_MODEL_EP}", # Filter by model
        # task_ids=["test-id-1", "test-id-2"] # Filter by task_ids
    )
    print(list_result)

    print("----- delete request -----")
    try:
        client.content_generation.tasks.delete(task_id=create_result.id)
        print(create_result.id)
    except Exception as e:
        print(f"failed to delete task: {e}")

    print("----- create request (service_tier='flex') -----")
    create_result_flex = client.content_generation.tasks.create(
        model="ep-20251209175451-tctqz",
        service_tier="flex",
        execution_expires_after=12200,
        content=[
            {
                "type": "text",
                "text": "Bird soaring above vast grasslands"
            },
            {
                "type": "image_url",
                "image_url": {
                    "url": "https://ark-doc.tos-ap-southeast-1.bytepluses.com/seepro_i2v%20.png"
                },
            }
        ],
        # callback_url="${YOUR_CALLBACK_URL}"
    )
    print(create_result_flex)

    print("----- get request (service_tier='flex') -----")
    get_result_flex = client.content_generation.tasks.get(task_id=create_result_flex.id)
    print(get_result_flex)

    print("----- list request (service_tier='flex') -----")
    list_result_flex = client.content_generation.tasks.list(
        page_num=1,
        page_size=2,
#         status="queued",  # succeeded, failed, running, cancelled
        # model="${YOUR_MODEL_EP}", # Filter by model
        # task_ids=["test-id-1", "test-id-2"] # Filter by task_ids
        service_tier="flex",
    )
    print(list_result_flex)

    print("----- delete request -----")
    try:
        client.content_generation.tasks.delete(task_id=create_result_flex.id)
        print(create_result_flex.id)
    except Exception as e:
        print(f"failed to delete task: {e}")
