# CALFEM for Python

## Documentation

[https://calfem-for-python.readthedocs.io/en/latest/](https://calfem-for-python.readthedocs.io/en/latest/)

## Manuals

Original manual: [manual.pdf](https://github.com/CALFEM/calfem-python/tree/master/reports/manual.pdf)

Manual for with improved mesh: [manual-mesh-module.pdf](https://github.com/CALFEM/calfem-python/tree/master/reports/manual-mesh-module.pdf)

## Background

The computer program CALFEM is written for the software MATLAB and is an interactive tool for learning the finite element method. CALFEM is an abbreviation
of ”Computer Aided Learning of the Finite Element Method” and been developed by the Division of Structural Mechanics at Lund University since the late 70’s.

## Why CALFEM for Python?

While both the MATLAB and Python versions of CALFEM are open-source (MIT Licensed), the key difference lies in the environments they operate in. MATLAB is not open-source and requires expensive licenses (for commercial use), which can be a barrier for many users. In contrast, Python is a free, open-source programming language, making CALFEM for Python more accessible and cost-effective for a broader audience, including those in academic, personal, or commercial settings. 

CALFEM for Python is released under the MIT license, which enables its use in open-source as well as commercial projects.

## Installation

Install CALFEM for python using 
`pip install calfem-python`

## Dependencies

Mesh Generation Software: GMSH.
Install GMSH [here](http://gmsh.info/) and add to the PATH of your file or instead add contents of GMSH to the file folder.

## References

* Forsman, K, 2017. VisCon: Ett visualiseringsverktyg för tvådimensionell konsolidering i undervisningssammanhang - http://www.byggmek.lth.se/fileadmin/byggnadsmekanik/publications/tvsm5000/web5225.pdf 

* Edholm, A., 2013. Meshing and visualisation routines in the Python version of CALFEM.  - http://www.byggmek.lth.se/fileadmin/byggnadsmekanik/publications/tvsm5000/web5187.pdf 

* Ottosson, A., 2010. Implementation of CALFEM for Python - http://www.byggmek.lth.se/fileadmin/byggnadsmekanik/publications/tvsm5000/web5167.pdf 

* Eriksson, K, 2021. CALFEM Geometry Editor - An interactive geometry editor for CALFEM

* Åmand, A, 2022. Development of visualisation functions for CALFEM for Python


