import asyncio
from collections.abc import AsyncIterator, Awaitable
from reactivex import Observable, abc as abc
from reactivex.disposable import Disposable
from typing import Any, Callable, Generic, TypeVar

T = TypeVar('T')
TSource = TypeVar('TSource')
TResult = TypeVar('TResult')

class HybridObservable(Observable[T], Generic[T]):
    def __init__(self, observable: Observable[T]) -> None: ...
    def run(self) -> T: ...
    def pipe(self, *operators: Callable[[Observable[Any]], Observable[Any]]) -> HybridObservable[T]: ...
    def subscribe(self, on_next: abc.ObserverBase[T] | Callable[[T], None] | None = None, on_error: Callable[[Exception], None] | None = None, on_completed: Callable[[], None] | None = None, *, scheduler: abc.SchedulerBase | None = None) -> abc.DisposableBase: ...
    async def arun(self) -> T: ...
    async def apipe(self, *operators: Callable[[Observable[Any]], Observable[Any]]) -> HybridObservable[Any]: ...
    async def asubscribe(self, on_next: Callable[[T], Awaitable[Any]] | None = None, on_error: Callable[[Exception], Awaitable[Any]] | None = None, on_completed: Callable[[], Awaitable[Any]] | None = None) -> Disposable: ...
    async def __aiter__(self) -> AsyncIterator[T]: ...
    @classmethod
    def from_iterable(cls, iterable: list[TSource] | tuple[TSource, ...] | set[TSource]) -> HybridObservable[TSource]: ...
    @classmethod
    async def from_async_iterable(cls, async_iterable: AsyncIterator[TSource]) -> HybridObservable[TSource]: ...
    @classmethod
    def from_future(cls, future: asyncio.Future[TSource]) -> HybridObservable[TSource]: ...
