"""
camera.ui Python Types

This package provides Python type definitions for camera.ui plugins.
These types match the TypeScript @camera.ui/types package.

Version 3.0.0 - Complete refactoring with modular structure.
"""

# Base utilities
from ._base import Callback, HybridObservable

# Camera module
from .camera import (
    AssignedPlugin,
    AudioCodec,
    AudioCodecProperties,
    AudioFFmpegCodec,
    AudioStreamInfo,
    BaseCamera,
    BaseCameraConfig,
    CameraAspectRatio,
    CameraConfig,
    CameraConfigInputSettings,
    CameraDetectionSettings,
    CameraDevice,
    CameraFrameWorkerDecoder,
    CameraFrameWorkerResolution,
    CameraFrameWorkerSettings,
    CameraInformation,
    CameraInput,
    CameraInputSettings,
    CameraPluginInfo,
    CameraRecordingSettings,
    CameraRole,
    CameraSource,
    CameraType,
    CameraUiSettings,
    DecoderFormat,
    DetectionZone,
    FMTPInfo,
    FrameBuffer,
    FrameData,
    FrameMetadata,
    FrameType,
    Go2RtcRTSPSource,
    Go2RtcSnapshotSource,
    Go2RtcWSSource,
    HwAccelMethod,
    IceServer,
    ImageCrop,
    ImageFormat,
    ImageInformation,
    ImageInputFormat,
    ImageOptions,
    ImageOutputFormat,
    ImageResize,
    MotionDetectionSettings,
    ObjectDetectionSettings,
    PluginAssignments,
    Point,
    ProbeAudioCodec,
    ProbeConfig,
    ProbeStream,
    PythonVersion,
    RTSPAudioCodec,
    RTSPUrlOptions,
    SnapshotInterface,
    StreamingInterface,
    StreamingRole,
    StreamUrls,
    VideoCodec,
    VideoCodecProperties,
    VideoFFmpegCodec,
    VideoStreamInfo,
    VideoStreamingMode,
    ZoneFilter,
    ZoneType,
)

# Manager module
from .manager import (
    CoreManager,
    DeviceManager,
    FfmpegArgs,
    HWAccelOptions,
    LoggerService,
)

# Plugin module
from .plugin import (
    AudioDetectionPluginResponse,
    AudioFrameData,
    AudioMetadata,
    AudioResult,
    CuiPlugin,
    FaceResult,
    ImageMetadata,
    LicensePlateResult,
    MotionDetectionPluginResponse,
    MotionResult,
    ObjectDetectionPluginResponse,
    ObjectResult,
    PluginAPI,
    VideoFrameData,
)

# Sensor module
from .sensor import (
    AudioDetectorSensor,
    AudioDetectorSensorLike,
    AudioInputProperties,
    AudioProperty,
    AudioSensor,
    AudioSensorLike,
    BatteryCapability,
    BatteryInfo,
    BatteryInfoLike,
    BatteryProperty,
    BoundingBox,
    ChargingState,
    ContactProperty,
    ContactSensor,
    ContactSensorLike,
    Detection,
    DoorbellProperty,
    DoorbellTrigger,
    DoorbellTriggerLike,
    FaceDetection,
    FaceDetectorSensor,
    FaceDetectorSensorLike,
    FaceLandmarks,
    FaceProperty,
    FaceSensor,
    FaceSensorLike,
    LicensePlateDetection,
    LicensePlateDetectorSensor,
    LicensePlateDetectorSensorLike,
    LicensePlateProperty,
    LicensePlateSensor,
    LicensePlateSensorLike,
    LightCapability,
    LightControl,
    LightControlLike,
    LightProperty,
    MotionDetectorSensor,
    MotionDetectorSensorLike,
    MotionProperty,
    MotionSensor,
    MotionSensorLike,
    ObjectClassLabel,
    ObjectDetectorSensor,
    ObjectDetectorSensorLike,
    ObjectProperty,
    ObjectSensor,
    ObjectSensorLike,
    PropertyChangedEvent,
    PTZCapability,
    PTZControl,
    PTZControlLike,
    PTZDirection,
    PTZPosition,
    PTZProperty,
    Sensor,
    SensorAddedEvent,
    SensorCapabilitiesChangedEvent,
    SensorCategory,
    SensorLike,
    SensorOnlineEvent,
    SensorRefreshedState,
    SensorRemovedEvent,
    SensorType,
    SirenCapability,
    SirenControl,
    SirenControlLike,
    SirenProperty,
    StoredSensorData,
    VideoInputProperties,
    isAudioSensor,
    isBatteryInfo,
    isContactSensor,
    isDoorbellTrigger,
    isFaceSensor,
    isLicensePlateSensor,
    isLightControl,
    isMotionSensor,
    isObjectSensor,
    isPTZControl,
    isSirenControl,
)

# Service module
from .service import (
    AnyService,
    CameraService,
    Service,
    ServiceOnlineEvent,
    ServiceRegistration,
    ServiceType,
    SnapshotService,
    StreamingService,
)

# Storage module
from .storage import (
    DeviceStorage,
    FormSubmitResponse,
    FormSubmitSchema,
    JSONArray,
    JsonArraySchema,
    JsonBaseSchema,
    JsonBaseSchemaWithoutCallbacks,
    JsonBooleanSchema,
    JsonEnumSchema,
    JsonFactorySchema,
    JsonNumberSchema,
    JSONObject,
    JsonSchema,
    JsonSchemaType,
    JsonSchemaWithoutCallbacks,
    JsonSchemaWithoutKey,
    JsonStringSchema,
    JSONValue,
    Path,
    PluginConfig,
    SchemaConfig,
    StorageController,
    ToastMessage,
)

__all__ = [
    # Base
    "HybridObservable",
    "Callback",
    # Camera
    "CameraType",
    "ZoneType",
    "ZoneFilter",
    "CameraRole",
    "StreamingRole",
    "DecoderFormat",
    "ImageInputFormat",
    "ImageOutputFormat",
    "CameraFrameWorkerDecoder",
    "CameraFrameWorkerResolution",
    "AudioCodec",
    "AudioFFmpegCodec",
    "VideoCodec",
    "VideoFFmpegCodec",
    "RTSPAudioCodec",
    "ProbeAudioCodec",
    "HwAccelMethod",
    "PythonVersion",
    "VideoStreamingMode",
    "CameraAspectRatio",
    "FrameType",
    "Point",
    "CameraInformation",
    "CameraFrameWorkerSettings",
    "CameraInput",
    "CameraInputSettings",
    "CameraConfigInputSettings",
    "BaseCameraConfig",
    "CameraConfig",
    "CameraUiSettings",
    "CameraRecordingSettings",
    "CameraSource",
    "SnapshotInterface",
    "StreamingInterface",
    "DetectionZone",
    "MotionDetectionSettings",
    "ObjectDetectionSettings",
    "CameraDetectionSettings",
    "Go2RtcWSSource",
    "Go2RtcRTSPSource",
    "Go2RtcSnapshotSource",
    "StreamUrls",
    "ProbeConfig",
    "FMTPInfo",
    "AudioCodecProperties",
    "VideoCodecProperties",
    "AudioStreamInfo",
    "VideoStreamInfo",
    "ProbeStream",
    "RTSPUrlOptions",
    "FrameMetadata",
    "ImageInformation",
    "FrameData",
    "ImageCrop",
    "ImageResize",
    "ImageFormat",
    "ImageOptions",
    "FrameBuffer",
    "IceServer",
    "AssignedPlugin",
    "PluginAssignments",
    "CameraPluginInfo",
    "BaseCamera",
    "CameraDevice",
    # Sensor
    "SensorType",
    "SensorCategory",
    "VideoInputProperties",
    "AudioInputProperties",
    "BoundingBox",
    "ObjectClassLabel",
    "Detection",
    "FaceLandmarks",
    "FaceDetection",
    "LicensePlateDetection",
    "PTZPosition",
    "PTZDirection",
    "ChargingState",
    "PropertyChangedEvent",
    "SensorOnlineEvent",
    "StoredSensorData",
    "SensorRefreshedState",
    "SensorAddedEvent",
    "SensorRemovedEvent",
    "SensorCapabilitiesChangedEvent",
    "Sensor",
    "SensorLike",
    "MotionProperty",
    "MotionSensorLike",
    "MotionDetectorSensorLike",
    "MotionSensor",
    "MotionDetectorSensor",
    "ObjectProperty",
    "ObjectSensorLike",
    "ObjectDetectorSensorLike",
    "ObjectSensor",
    "ObjectDetectorSensor",
    "AudioProperty",
    "AudioSensorLike",
    "AudioDetectorSensorLike",
    "AudioSensor",
    "AudioDetectorSensor",
    "FaceProperty",
    "FaceSensorLike",
    "FaceDetectorSensorLike",
    "FaceSensor",
    "FaceDetectorSensor",
    "LicensePlateProperty",
    "LicensePlateSensorLike",
    "LicensePlateDetectorSensorLike",
    "LicensePlateSensor",
    "LicensePlateDetectorSensor",
    "ContactProperty",
    "ContactSensorLike",
    "ContactSensor",
    "LightCapability",
    "LightProperty",
    "LightControlLike",
    "LightControl",
    "SirenCapability",
    "SirenProperty",
    "SirenControlLike",
    "SirenControl",
    "PTZCapability",
    "PTZProperty",
    "PTZControlLike",
    "PTZControl",
    "DoorbellProperty",
    "DoorbellTriggerLike",
    "DoorbellTrigger",
    "BatteryCapability",
    "BatteryProperty",
    "BatteryInfoLike",
    "BatteryInfo",
    "isMotionSensor",
    "isObjectSensor",
    "isAudioSensor",
    "isFaceSensor",
    "isLicensePlateSensor",
    "isContactSensor",
    "isLightControl",
    "isSirenControl",
    "isPTZControl",
    "isDoorbellTrigger",
    "isBatteryInfo",
    # Service
    "ServiceType",
    "ServiceRegistration",
    "ServiceOnlineEvent",
    "CameraService",
    "Service",
    "StreamingService",
    "SnapshotService",
    "AnyService",
    # Storage
    "JSONValue",
    "JSONObject",
    "JSONArray",
    "Path",
    "PluginConfig",
    "JsonSchemaType",
    "JsonFactorySchema",
    "JsonBaseSchemaWithoutCallbacks",
    "JsonBaseSchema",
    "JsonStringSchema",
    "JsonNumberSchema",
    "JsonBooleanSchema",
    "JsonEnumSchema",
    "JsonArraySchema",
    "JsonSchema",
    "JsonSchemaWithoutKey",
    "JsonSchemaWithoutCallbacks",
    "ToastMessage",
    "FormSubmitSchema",
    "FormSubmitResponse",
    "SchemaConfig",
    "DeviceStorage",
    "StorageController",
    # Manager
    "LoggerService",
    "DeviceManager",
    "HWAccelOptions",
    "FfmpegArgs",
    "CoreManager",
    # Plugin
    "VideoFrameData",
    "AudioFrameData",
    "MotionResult",
    "ObjectResult",
    "FaceResult",
    "AudioResult",
    "LicensePlateResult",
    "ImageMetadata",
    "AudioMetadata",
    "MotionDetectionPluginResponse",
    "ObjectDetectionPluginResponse",
    "AudioDetectionPluginResponse",
    "PluginAPI",
    "CuiPlugin",
]
