"""Camera module exports."""

from .config import (
    BaseCameraConfig,
    CameraConfig,
    CameraConfigInputSettings,
    CameraFrameWorkerSettings,
    CameraInformation,
    CameraInput,
    CameraInputSettings,
    CameraRecordingSettings,
    CameraSource,
    CameraUiSettings,
    SnapshotInterface,
    StreamingInterface,
)
from .detection import (
    CameraDetectionSettings,
    DetectionZone,
    MotionDetectionSettings,
    ObjectDetectionSettings,
)
from .device import (
    AssignedPlugin,
    BaseCamera,
    CameraDevice,
    CameraPluginInfo,
    PluginAssignments,
)
from .streaming import (
    AudioCodecProperties,
    AudioStreamInfo,
    FMTPInfo,
    FrameBuffer,
    FrameData,
    FrameMetadata,
    Go2RtcRTSPSource,
    Go2RtcSnapshotSource,
    Go2RtcWSSource,
    IceServer,
    ImageCrop,
    ImageFormat,
    ImageInformation,
    ImageOptions,
    ImageResize,
    ProbeConfig,
    ProbeStream,
    RTSPUrlOptions,
    StreamUrls,
    VideoCodecProperties,
    VideoStreamInfo,
)
from .types import (
    AudioCodec,
    AudioFFmpegCodec,
    CameraAspectRatio,
    CameraFrameWorkerDecoder,
    CameraFrameWorkerResolution,
    CameraRole,
    CameraType,
    DecoderFormat,
    FrameType,
    HwAccelMethod,
    ImageInputFormat,
    ImageOutputFormat,
    Point,
    ProbeAudioCodec,
    PythonVersion,
    RTSPAudioCodec,
    StreamingRole,
    VideoCodec,
    VideoFFmpegCodec,
    VideoStreamingMode,
    ZoneFilter,
    ZoneType,
)

__all__ = [
    # Types
    "CameraType",
    "ZoneType",
    "ZoneFilter",
    "CameraRole",
    "StreamingRole",
    "DecoderFormat",
    "ImageInputFormat",
    "ImageOutputFormat",
    "CameraFrameWorkerDecoder",
    "CameraFrameWorkerResolution",
    "AudioCodec",
    "AudioFFmpegCodec",
    "VideoCodec",
    "VideoFFmpegCodec",
    "RTSPAudioCodec",
    "ProbeAudioCodec",
    "HwAccelMethod",
    "PythonVersion",
    "VideoStreamingMode",
    "CameraAspectRatio",
    "FrameType",
    "Point",
    # Config
    "CameraInformation",
    "CameraFrameWorkerSettings",
    "CameraInput",
    "CameraInputSettings",
    "CameraConfigInputSettings",
    "BaseCameraConfig",
    "CameraConfig",
    "CameraUiSettings",
    "CameraRecordingSettings",
    "CameraSource",
    "SnapshotInterface",
    "StreamingInterface",
    # Detection
    "DetectionZone",
    "MotionDetectionSettings",
    "ObjectDetectionSettings",
    "CameraDetectionSettings",
    # Streaming
    "Go2RtcWSSource",
    "Go2RtcRTSPSource",
    "Go2RtcSnapshotSource",
    "StreamUrls",
    "ProbeConfig",
    "FMTPInfo",
    "AudioCodecProperties",
    "VideoCodecProperties",
    "AudioStreamInfo",
    "VideoStreamInfo",
    "ProbeStream",
    "RTSPUrlOptions",
    "FrameMetadata",
    "ImageInformation",
    "FrameData",
    "ImageCrop",
    "ImageResize",
    "ImageFormat",
    "ImageOptions",
    "FrameBuffer",
    "IceServer",
    # Device
    "AssignedPlugin",
    "PluginAssignments",
    "CameraPluginInfo",
    "BaseCamera",
    "CameraDevice",
]
