/******/ var __webpack_modules__ = ({

/***/ "../node_modules/@fireflysemantics/join/fesm2015/fireflysemantics-join.js":
/*!********************************************************************************!*\
  !*** ../node_modules/@fireflysemantics/join/fesm2015/fireflysemantics-join.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   join: () => (/* binding */ join)
/* harmony export */ });
/**
MIT License

Copyright (c) Firefly Semantics Corporation
Copyright (c) 2020 Ole K. Ersoy
Copyright (c) 2015 José F. Romaniello

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. */
/**
 * @param args The components of the URL
 * @throws TypeError if the args URL components are not all of type string
 * @return The URL string
 */
function join(...args) {
    let components = [];
    /**
     * If an empty array is received then
     * the URL is just ''.
     */
    if (args.length === 0) {
        return '';
    }
    /** The args values must be of type string */
    args.forEach(component => {
        if (typeof component !== 'string') {
            throw new TypeError(`Url components must be of type string. 
                    The ${component} component is of type ${typeof component}`);
        }
    });
    /**
     * If the protocol is specified by itself,
     * then the protocol is combined with the
     * subsequent array value.
     */
    const protocol = args[0];
    if (protocol.match(/^[^/:]+:\/*$/) && args.length > 1) {
        var first = args.shift();
        args[0] = first + args[0];
    }
    /**
     * The file protocol should have two or three slashes.
     * Other protocols should have 2.
     */
    if (args[0].match(/^file:\/\/\//)) {
        args[0] = args[0].replace(/^([^/:]+):\/*/, '$1:///');
    }
    else {
        args[0] = args[0].replace(/^([^/:]+):\/*/, '$1://');
    }
    /** The args values must be of type string */
    args.forEach((component, i) => {
        if (component === '') {
            return;
        }
        /**
         * Remove starting slashes for all but the first component
         */
        if (i > 0) {
            component = component.replace(/^[\/]+/, '');
        }
        /**
         * Remove the ending slashes for each component but the last.
         */
        if (i < args.length - 1) {
            component = component.replace(/[\/]+$/, '');
        }
        else {
            // For the last combine multiple slashes into one.
            component = component.replace(/[\/]+$/, '/');
        }
        components.push(component);
    });
    /**
     * Separate all the components by a single /
     */
    let url = components.join('/');
    // remove trailing slash before parameters or hash
    url = url.replace(/\/(\?|&|#[^!])/g, '$1');
    // replace ? in parameters with &
    var parts = url.split('?');
    url = parts.shift() + (parts.length > 0 ? '?' : '') + parts.join('&');
    return url;
}

/*
 * Public API Surface of join
 */

/**
 * Generated bundle index. Do not edit.
 */


//# sourceMappingURL=fireflysemantics-join.js.map


/***/ }),

/***/ "../node_modules/@fortawesome/free-brands-svg-icons/faGithub.js":
/*!**********************************************************************!*\
  !*** ../node_modules/@fortawesome/free-brands-svg-icons/faGithub.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fab';
var iconName = 'github';
var width = 496;
var height = 512;
var ligatures = [];
var unicode = 'f09b';
var svgPathData = 'M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faGithub = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../node_modules/@fortawesome/free-solid-svg-icons/faChartBar.js":
/*!***********************************************************************!*\
  !*** ../node_modules/@fortawesome/free-solid-svg-icons/faChartBar.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'chart-bar';
var width = 512;
var height = 512;
var ligatures = [];
var unicode = 'f080';
var svgPathData = 'M332.8 320h38.4c6.4 0 12.8-6.4 12.8-12.8V172.8c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v134.4c0 6.4 6.4 12.8 12.8 12.8zm96 0h38.4c6.4 0 12.8-6.4 12.8-12.8V76.8c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v230.4c0 6.4 6.4 12.8 12.8 12.8zm-288 0h38.4c6.4 0 12.8-6.4 12.8-12.8v-70.4c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v70.4c0 6.4 6.4 12.8 12.8 12.8zm96 0h38.4c6.4 0 12.8-6.4 12.8-12.8V108.8c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v198.4c0 6.4 6.4 12.8 12.8 12.8zM496 384H64V80c0-8.84-7.16-16-16-16H16C7.16 64 0 71.16 0 80v336c0 17.67 14.33 32 32 32h464c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faChartBar = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../node_modules/@fortawesome/free-solid-svg-icons/faCheckSquare.js":
/*!**************************************************************************!*\
  !*** ../node_modules/@fortawesome/free-solid-svg-icons/faCheckSquare.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'check-square';
var width = 448;
var height = 512;
var ligatures = [];
var unicode = 'f14a';
var svgPathData = 'M400 480H48c-26.51 0-48-21.49-48-48V80c0-26.51 21.49-48 48-48h352c26.51 0 48 21.49 48 48v352c0 26.51-21.49 48-48 48zm-204.686-98.059l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.248-16.379-6.249-22.628 0L184 302.745l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.25 16.379 6.25 22.628.001z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faCheckSquare = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../node_modules/@fortawesome/free-solid-svg-icons/faCopy.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@fortawesome/free-solid-svg-icons/faCopy.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'copy';
var width = 448;
var height = 512;
var ligatures = [];
var unicode = 'f0c5';
var svgPathData = 'M320 448v40c0 13.255-10.745 24-24 24H24c-13.255 0-24-10.745-24-24V120c0-13.255 10.745-24 24-24h72v296c0 30.879 25.121 56 56 56h168zm0-344V0H152c-13.255 0-24 10.745-24 24v368c0 13.255 10.745 24 24 24h272c13.255 0 24-10.745 24-24V128H344c-13.2 0-24-10.8-24-24zm120.971-31.029L375.029 7.029A24 24 0 0 0 358.059 0H352v96h96v-6.059a24 24 0 0 0-7.029-16.97z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faCopy = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../node_modules/@fortawesome/free-solid-svg-icons/faFilter.js":
/*!*********************************************************************!*\
  !*** ../node_modules/@fortawesome/free-solid-svg-icons/faFilter.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'filter';
var width = 512;
var height = 512;
var ligatures = [];
var unicode = 'f0b0';
var svgPathData = 'M487.976 0H24.028C2.71 0-8.047 25.866 7.058 40.971L192 225.941V432c0 7.831 3.821 15.17 10.237 19.662l80 55.98C298.02 518.69 320 507.493 320 487.98V225.941l184.947-184.97C520.021 25.896 509.338 0 487.976 0z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faFilter = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../node_modules/@fortawesome/free-solid-svg-icons/faLayerGroup.js":
/*!*************************************************************************!*\
  !*** ../node_modules/@fortawesome/free-solid-svg-icons/faLayerGroup.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'layer-group';
var width = 512;
var height = 512;
var ligatures = [];
var unicode = 'f5fd';
var svgPathData = 'M12.41 148.02l232.94 105.67c6.8 3.09 14.49 3.09 21.29 0l232.94-105.67c16.55-7.51 16.55-32.52 0-40.03L266.65 2.31a25.607 25.607 0 0 0-21.29 0L12.41 107.98c-16.55 7.51-16.55 32.53 0 40.04zm487.18 88.28l-58.09-26.33-161.64 73.27c-7.56 3.43-15.59 5.17-23.86 5.17s-16.29-1.74-23.86-5.17L70.51 209.97l-58.1 26.33c-16.55 7.5-16.55 32.5 0 40l232.94 105.59c6.8 3.08 14.49 3.08 21.29 0L499.59 276.3c16.55-7.5 16.55-32.5 0-40zm0 127.8l-57.87-26.23-161.86 73.37c-7.56 3.43-15.59 5.17-23.86 5.17s-16.29-1.74-23.86-5.17L70.29 337.87 12.41 364.1c-16.55 7.5-16.55 32.5 0 40l232.94 105.59c6.8 3.08 14.49 3.08 21.29 0L499.59 404.1c16.55-7.5 16.55-32.5 0-40z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faLayerGroup = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../node_modules/@fortawesome/free-solid-svg-icons/faPause.js":
/*!********************************************************************!*\
  !*** ../node_modules/@fortawesome/free-solid-svg-icons/faPause.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'pause';
var width = 448;
var height = 512;
var ligatures = [];
var unicode = 'f04c';
var svgPathData = 'M144 479H48c-26.5 0-48-21.5-48-48V79c0-26.5 21.5-48 48-48h96c26.5 0 48 21.5 48 48v352c0 26.5-21.5 48-48 48zm304-48V79c0-26.5-21.5-48-48-48h-96c-26.5 0-48 21.5-48 48v352c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faPause = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../node_modules/@fortawesome/free-solid-svg-icons/faPlay.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@fortawesome/free-solid-svg-icons/faPlay.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'play';
var width = 448;
var height = 512;
var ligatures = [];
var unicode = 'f04b';
var svgPathData = 'M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faPlay = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../node_modules/@fortawesome/free-solid-svg-icons/faTable.js":
/*!********************************************************************!*\
  !*** ../node_modules/@fortawesome/free-solid-svg-icons/faTable.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'table';
var width = 512;
var height = 512;
var ligatures = [];
var unicode = 'f0ce';
var svgPathData = 'M464 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V80c0-26.51-21.49-48-48-48zM224 416H64v-96h160v96zm0-160H64v-96h160v96zm224 160H288v-96h160v96zm0-160H288v-96h160v96z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faTable = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../node_modules/@fortawesome/free-solid-svg-icons/faTimes.js":
/*!********************************************************************!*\
  !*** ../node_modules/@fortawesome/free-solid-svg-icons/faTimes.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'times';
var width = 352;
var height = 512;
var ligatures = [];
var unicode = 'f00d';
var svgPathData = 'M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faTimes = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/activitymonitor.js":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/activitymonitor.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ActivityMonitor = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
/**
 * A class that monitors activity on a signal.
 */
class ActivityMonitor {
    /**
     * Construct a new activity monitor.
     */
    constructor(options) {
        this._timer = -1;
        this._timeout = -1;
        this._isDisposed = false;
        this._activityStopped = new signaling_1.Signal(this);
        options.signal.connect(this._onSignalFired, this);
        this._timeout = options.timeout || 1000;
    }
    /**
     * A signal emitted when activity has ceased.
     */
    get activityStopped() {
        return this._activityStopped;
    }
    /**
     * The timeout associated with the monitor, in milliseconds.
     */
    get timeout() {
        return this._timeout;
    }
    set timeout(value) {
        this._timeout = value;
    }
    /**
     * Test whether the monitor has been disposed.
     *
     * #### Notes
     * This is a read-only property.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources used by the activity monitor.
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        signaling_1.Signal.clearData(this);
    }
    /**
     * A signal handler for the monitored signal.
     */
    _onSignalFired(sender, args) {
        clearTimeout(this._timer);
        this._sender = sender;
        this._args = args;
        this._timer = setTimeout(() => {
            this._activityStopped.emit({
                sender: this._sender,
                args: this._args
            });
        }, this._timeout);
    }
}
exports.ActivityMonitor = ActivityMonitor;
//# sourceMappingURL=activitymonitor.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/index.js":
/*!**********************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/index.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module coreutils
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./activitymonitor */ "../node_modules/@jupyterlab/coreutils/lib/activitymonitor.js"), exports);
__exportStar(__webpack_require__(/*! ./interfaces */ "../node_modules/@jupyterlab/coreutils/lib/interfaces.js"), exports);
__exportStar(__webpack_require__(/*! ./lru */ "../node_modules/@jupyterlab/coreutils/lib/lru.js"), exports);
__exportStar(__webpack_require__(/*! ./markdowncodeblocks */ "../node_modules/@jupyterlab/coreutils/lib/markdowncodeblocks.js"), exports);
__exportStar(__webpack_require__(/*! ./pageconfig */ "../node_modules/@jupyterlab/coreutils/lib/pageconfig.js"), exports);
__exportStar(__webpack_require__(/*! ./path */ "../node_modules/@jupyterlab/coreutils/lib/path.js"), exports);
__exportStar(__webpack_require__(/*! ./signal */ "../node_modules/@jupyterlab/coreutils/lib/signal.js"), exports);
__exportStar(__webpack_require__(/*! ./text */ "../node_modules/@jupyterlab/coreutils/lib/text.js"), exports);
__exportStar(__webpack_require__(/*! ./time */ "../node_modules/@jupyterlab/coreutils/lib/time.js"), exports);
__exportStar(__webpack_require__(/*! ./url */ "../node_modules/@jupyterlab/coreutils/lib/url.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/interfaces.js":
/*!***************************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/interfaces.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=interfaces.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/lru.js":
/*!********************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/lru.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LruCache = void 0;
const DEFAULT_MAX_SIZE = 128;
/** A least-recently-used cache. */
class LruCache {
    constructor(options = {}) {
        this._map = new Map();
        this._maxSize = (options === null || options === void 0 ? void 0 : options.maxSize) || DEFAULT_MAX_SIZE;
    }
    /**
     * Return the current size of the cache.
     */
    get size() {
        return this._map.size;
    }
    /**
     * Clear the values in the cache.
     */
    clear() {
        this._map.clear();
    }
    /**
     * Get a value (or null) from the cache, pushing the item to the front of the cache.
     */
    get(key) {
        const item = this._map.get(key) || null;
        if (item != null) {
            this._map.delete(key);
            this._map.set(key, item);
        }
        return item;
    }
    /**
     * Set a value in the cache, potentially evicting an old item.
     */
    set(key, value) {
        if (this._map.size >= this._maxSize) {
            this._map.delete(this._map.keys().next().value);
        }
        this._map.set(key, value);
    }
}
exports.LruCache = LruCache;
//# sourceMappingURL=lru.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/markdowncodeblocks.js":
/*!***********************************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/markdowncodeblocks.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MarkdownCodeBlocks = void 0;
/**
 * The namespace for code block functions which help
 * in extract code from markdown text
 */
var MarkdownCodeBlocks;
(function (MarkdownCodeBlocks) {
    MarkdownCodeBlocks.CODE_BLOCK_MARKER = '```';
    const markdownExtensions = [
        '.markdown',
        '.mdown',
        '.mkdn',
        '.md',
        '.mkd',
        '.mdwn',
        '.mdtxt',
        '.mdtext',
        '.text',
        '.txt',
        '.Rmd'
    ];
    class MarkdownCodeBlock {
        constructor(startLine) {
            this.startLine = startLine;
            this.code = '';
            this.endLine = -1;
        }
    }
    MarkdownCodeBlocks.MarkdownCodeBlock = MarkdownCodeBlock;
    /**
     * Check whether the given file extension is a markdown extension
     * @param extension - A file extension
     *
     * @returns true/false depending on whether this is a supported markdown extension
     */
    function isMarkdown(extension) {
        return markdownExtensions.indexOf(extension) > -1;
    }
    MarkdownCodeBlocks.isMarkdown = isMarkdown;
    /**
     * Construct all code snippets from current text
     * (this could be potentially optimized if we can cache and detect differences)
     * @param text - A string to parse codeblocks from
     *
     * @returns An array of MarkdownCodeBlocks.
     */
    function findMarkdownCodeBlocks(text) {
        if (!text || text === '') {
            return [];
        }
        const lines = text.split('\n');
        const codeBlocks = [];
        let currentBlock = null;
        for (let lineIndex = 0; lineIndex < lines.length; lineIndex++) {
            const line = lines[lineIndex];
            const lineContainsMarker = line.indexOf(MarkdownCodeBlocks.CODE_BLOCK_MARKER) === 0;
            const constructingBlock = currentBlock != null;
            // Skip this line if it is not part of any code block and doesn't contain a marker.
            if (!lineContainsMarker && !constructingBlock) {
                continue;
            }
            // Check if we are already constructing a code block.
            if (!constructingBlock) {
                // Start constructing a new code block.
                currentBlock = new MarkdownCodeBlock(lineIndex);
                // Check whether this is a single line code block of the form ```a = 10```.
                const firstIndex = line.indexOf(MarkdownCodeBlocks.CODE_BLOCK_MARKER);
                const lastIndex = line.lastIndexOf(MarkdownCodeBlocks.CODE_BLOCK_MARKER);
                const isSingleLine = firstIndex !== lastIndex;
                if (isSingleLine) {
                    currentBlock.code = line.substring(firstIndex + MarkdownCodeBlocks.CODE_BLOCK_MARKER.length, lastIndex);
                    currentBlock.endLine = lineIndex;
                    codeBlocks.push(currentBlock);
                    currentBlock = null;
                }
            }
            else if (currentBlock) {
                if (lineContainsMarker) {
                    // End of block, finish it up.
                    currentBlock.endLine = lineIndex - 1;
                    codeBlocks.push(currentBlock);
                    currentBlock = null;
                }
                else {
                    // Append the current line.
                    currentBlock.code += line + '\n';
                }
            }
        }
        return codeBlocks;
    }
    MarkdownCodeBlocks.findMarkdownCodeBlocks = findMarkdownCodeBlocks;
})(MarkdownCodeBlocks || (exports.MarkdownCodeBlocks = MarkdownCodeBlocks = {}));
//# sourceMappingURL=markdowncodeblocks.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/pageconfig.js":
/*!***************************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/pageconfig.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PageConfig = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
const minimist_1 = __importDefault(__webpack_require__(/*! minimist */ "../node_modules/minimist/index.js"));
const url_1 = __webpack_require__(/*! ./url */ "../node_modules/@jupyterlab/coreutils/lib/url.js");
/**
 * The namespace for `PageConfig` functions.
 */
var PageConfig;
(function (PageConfig) {
    /**
     * Get global configuration data for the Jupyter application.
     *
     * @param name - The name of the configuration option.
     *
     * @returns The config value or an empty string if not found.
     *
     * #### Notes
     * All values are treated as strings.
     * For browser based applications, it is assumed that the page HTML
     * includes a script tag with the id `jupyter-config-data` containing the
     * configuration as valid JSON.  In order to support the classic Notebook,
     * we fall back on checking for `body` data of the given `name`.
     *
     * For node applications, it is assumed that the process was launched
     * with a `--jupyter-config-data` option pointing to a JSON settings
     * file.
     */
    function getOption(name) {
        if (configData) {
            return configData[name] || getBodyData(name);
        }
        configData = Object.create(null);
        let found = false;
        // Use script tag if available.
        if (typeof document !== 'undefined' && document) {
            const el = document.getElementById('jupyter-config-data');
            if (el) {
                configData = JSON.parse(el.textContent || '');
                found = true;
            }
        }
        // Otherwise use CLI if given.
        if (!found && typeof process !== 'undefined' && process.argv) {
            try {
                const cli = (0, minimist_1.default)(process.argv.slice(2));
                const path = __webpack_require__(/*! path */ "../node_modules/path-browserify/index.js");
                let fullPath = '';
                if ('jupyter-config-data' in cli) {
                    fullPath = path.resolve(cli['jupyter-config-data']);
                }
                else if ('JUPYTER_CONFIG_DATA' in process.env) {
                    fullPath = path.resolve(process.env['JUPYTER_CONFIG_DATA']);
                }
                if (fullPath) {
                    // Force Webpack to ignore this require.
                    // eslint-disable-next-line
                    configData = eval('require')(fullPath);
                }
            }
            catch (e) {
                console.error(e);
            }
        }
        if (!coreutils_1.JSONExt.isObject(configData)) {
            configData = Object.create(null);
        }
        else {
            for (const key in configData) {
                // PageConfig expects strings
                if (typeof configData[key] !== 'string') {
                    configData[key] = JSON.stringify(configData[key]);
                }
            }
        }
        return configData[name] || getBodyData(name);
    }
    PageConfig.getOption = getOption;
    /**
     * Set global configuration data for the Jupyter application.
     *
     * @param name - The name of the configuration option.
     * @param value - The value to set the option to.
     *
     * @returns The last config value or an empty string if it doesn't exist.
     */
    function setOption(name, value) {
        const last = getOption(name);
        configData[name] = value;
        return last;
    }
    PageConfig.setOption = setOption;
    /**
     * Get the base url for a Jupyter application, or the base url of the page.
     */
    function getBaseUrl() {
        return url_1.URLExt.normalize(getOption('baseUrl') || '/');
    }
    PageConfig.getBaseUrl = getBaseUrl;
    /**
     * Get the tree url for a JupyterLab application.
     */
    function getTreeUrl() {
        return url_1.URLExt.join(getBaseUrl(), getOption('treeUrl'));
    }
    PageConfig.getTreeUrl = getTreeUrl;
    /**
     * Get the base url for sharing links (usually baseUrl)
     */
    function getShareUrl() {
        return url_1.URLExt.normalize(getOption('shareUrl') || getBaseUrl());
    }
    PageConfig.getShareUrl = getShareUrl;
    /**
     * Get the tree url for shareable links.
     * Usually the same as treeUrl,
     * but overridable e.g. when sharing with JupyterHub.
     */
    function getTreeShareUrl() {
        return url_1.URLExt.normalize(url_1.URLExt.join(getShareUrl(), getOption('treeUrl')));
    }
    PageConfig.getTreeShareUrl = getTreeShareUrl;
    /**
     * Create a new URL given an optional mode and tree path.
     *
     * This is used to create URLS when the mode or tree path change as the user
     * changes mode or the current document in the main area. If fields in
     * options are omitted, the value in PageConfig will be used.
     *
     * @param options - IGetUrlOptions for the new path.
     */
    function getUrl(options) {
        var _a, _b, _c, _d;
        let path = options.toShare ? getShareUrl() : getBaseUrl();
        const mode = (_a = options.mode) !== null && _a !== void 0 ? _a : getOption('mode');
        const workspace = (_b = options.workspace) !== null && _b !== void 0 ? _b : getOption('workspace');
        const labOrDoc = mode === 'single-document' ? 'doc' : 'lab';
        path = url_1.URLExt.join(path, labOrDoc);
        if (workspace !== PageConfig.defaultWorkspace) {
            path = url_1.URLExt.join(path, 'workspaces', encodeURIComponent((_c = getOption('workspace')) !== null && _c !== void 0 ? _c : PageConfig.defaultWorkspace));
        }
        const treePath = (_d = options.treePath) !== null && _d !== void 0 ? _d : getOption('treePath');
        if (treePath) {
            path = url_1.URLExt.join(path, 'tree', url_1.URLExt.encodeParts(treePath));
        }
        return path;
    }
    PageConfig.getUrl = getUrl;
    PageConfig.defaultWorkspace = 'default';
    /**
     * Get the base websocket url for a Jupyter application, or an empty string.
     */
    function getWsUrl(baseUrl) {
        let wsUrl = getOption('wsUrl');
        if (!wsUrl) {
            baseUrl = baseUrl ? url_1.URLExt.normalize(baseUrl) : getBaseUrl();
            if (baseUrl.indexOf('http') !== 0) {
                return '';
            }
            wsUrl = 'ws' + baseUrl.slice(4);
        }
        return url_1.URLExt.normalize(wsUrl);
    }
    PageConfig.getWsUrl = getWsUrl;
    /**
     * Returns the URL converting this notebook to a certain
     * format with nbconvert.
     */
    function getNBConvertURL({ path, format, download }) {
        const notebookPath = url_1.URLExt.encodeParts(path);
        const url = url_1.URLExt.join(getBaseUrl(), 'nbconvert', format, notebookPath);
        if (download) {
            return url + '?download=true';
        }
        return url;
    }
    PageConfig.getNBConvertURL = getNBConvertURL;
    /**
     * Get the authorization token for a Jupyter application.
     */
    function getToken() {
        return getOption('token') || getBodyData('jupyterApiToken');
    }
    PageConfig.getToken = getToken;
    /**
     * Get the Notebook version info [major, minor, patch].
     */
    function getNotebookVersion() {
        const notebookVersion = getOption('notebookVersion');
        if (notebookVersion === '') {
            return [0, 0, 0];
        }
        return JSON.parse(notebookVersion);
    }
    PageConfig.getNotebookVersion = getNotebookVersion;
    /**
     * Private page config data for the Jupyter application.
     */
    let configData = null;
    /**
     * Get a url-encoded item from `body.data` and decode it
     * We should never have any encoded URLs anywhere else in code
     * until we are building an actual request.
     */
    function getBodyData(key) {
        if (typeof document === 'undefined' || !document.body) {
            return '';
        }
        const val = document.body.dataset[key];
        if (typeof val === 'undefined') {
            return '';
        }
        return decodeURIComponent(val);
    }
    /**
     * The namespace for page config `Extension` functions.
     */
    let Extension;
    (function (Extension) {
        /**
         * Populate an array from page config.
         *
         * @param key - The page config key (e.g., `deferredExtensions`).
         *
         * #### Notes
         * This is intended for `deferredExtensions` and `disabledExtensions`.
         */
        function populate(key) {
            try {
                const raw = getOption(key);
                if (raw) {
                    return JSON.parse(raw);
                }
            }
            catch (error) {
                console.warn(`Unable to parse ${key}.`, error);
            }
            return [];
        }
        /**
         * The collection of deferred extensions in page config.
         */
        Extension.deferred = populate('deferredExtensions');
        /**
         * The collection of disabled extensions in page config.
         */
        Extension.disabled = populate('disabledExtensions');
        /**
         * Returns whether a plugin is deferred.
         *
         * @param id - The plugin ID.
         */
        function isDeferred(id) {
            // Check for either a full plugin id match or an extension
            // name match.
            const separatorIndex = id.indexOf(':');
            let extName = '';
            if (separatorIndex !== -1) {
                extName = id.slice(0, separatorIndex);
            }
            return Extension.deferred.some(val => val === id || (extName && val === extName));
        }
        Extension.isDeferred = isDeferred;
        /**
         * Returns whether a plugin is disabled.
         *
         * @param id - The plugin ID.
         */
        function isDisabled(id) {
            // Check for either a full plugin id match or an extension
            // name match.
            const separatorIndex = id.indexOf(':');
            let extName = '';
            if (separatorIndex !== -1) {
                extName = id.slice(0, separatorIndex);
            }
            return Extension.disabled.some(val => val === id || (extName && val === extName));
        }
        Extension.isDisabled = isDisabled;
    })(Extension = PageConfig.Extension || (PageConfig.Extension = {}));
})(PageConfig || (exports.PageConfig = PageConfig = {}));
//# sourceMappingURL=pageconfig.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/path.js":
/*!*********************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/path.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PathExt = void 0;
const path_1 = __webpack_require__(/*! path */ "../node_modules/path-browserify/index.js");
/**
 * The namespace for path-related functions.
 *
 * Note that Jupyter server paths do not start with a leading slash.
 */
var PathExt;
(function (PathExt) {
    /**
     * Join all arguments together and normalize the resulting path.
     * Arguments must be strings. In v0.8, non-string arguments were silently ignored. In v0.10 and up, an exception is thrown.
     *
     * @param paths - The string paths to join.
     */
    function join(...paths) {
        const path = path_1.posix.join(...paths);
        return path === '.' ? '' : removeSlash(path);
    }
    PathExt.join = join;
    /**
     * Join all arguments together and normalize the resulting path and preserve the leading slash.
     *
     * @param paths - The string paths to join.
     */
    function joinWithLeadingSlash(...paths) {
        const path = path_1.posix.join(...paths);
        return path === '.' ? '' : path;
    }
    PathExt.joinWithLeadingSlash = joinWithLeadingSlash;
    /**
     * Return the last portion of a path. Similar to the Unix basename command.
     * Often used to extract the file name from a fully qualified path.
     *
     * @param path - The path to evaluate.
     *
     * @param ext - An extension to remove from the result.
     */
    function basename(path, ext) {
        return path_1.posix.basename(path, ext);
    }
    PathExt.basename = basename;
    /**
     * Get the directory name of a path, similar to the Unix dirname command.
     * When an empty path is given, returns the root path.
     *
     * @param path - The file path.
     */
    function dirname(path) {
        const dir = removeSlash(path_1.posix.dirname(path));
        return dir === '.' ? '' : dir;
    }
    PathExt.dirname = dirname;
    /**
     * Get the extension of the path.
     *
     * @param path - The file path.
     *
     * @returns the extension of the file.
     *
     * #### Notes
     * The extension is the string from the last occurrence of the `.`
     * character to end of string in the last portion of the path, inclusive.
     * If there is no `.` in the last portion of the path, or if the first
     * character of the basename of path [[basename]] is `.`, then an
     * empty string is returned.
     */
    function extname(path) {
        return path_1.posix.extname(path);
    }
    PathExt.extname = extname;
    /**
     * Normalize a string path, reducing '..' and '.' parts.
     * When multiple slashes are found, they're replaced by a single one; when the path contains a trailing slash, it is preserved. On Windows backslashes are used.
     * When an empty path is given, returns the root path.
     *
     * @param path - The string path to normalize.
     */
    function normalize(path) {
        if (path === '') {
            return '';
        }
        return removeSlash(path_1.posix.normalize(path));
    }
    PathExt.normalize = normalize;
    /**
     * Resolve a sequence of paths or path segments into an absolute path.
     * The root path in the application has no leading slash, so it is removed.
     *
     * @param parts - The paths to join.
     *
     * #### Notes
     * The right-most parameter is considered \{to\}.  Other parameters are considered an array of \{from\}.
     *
     * Starting from leftmost \{from\} parameter, resolves \{to\} to an absolute path.
     *
     * If \{to\} isn't already absolute, \{from\} arguments are prepended in right to left order, until an absolute path is found. If after using all \{from\} paths still no absolute path is found, the current working directory is used as well. The resulting path is normalized, and trailing slashes are removed unless the path gets resolved to the root directory.
     */
    function resolve(...parts) {
        return removeSlash(path_1.posix.resolve(...parts));
    }
    PathExt.resolve = resolve;
    /**
     * Solve the relative path from \{from\} to \{to\}.
     *
     * @param from - The source path.
     *
     * @param to - The target path.
     *
     * #### Notes
     * If from and to each resolve to the same path (after calling
     * path.resolve() on each), a zero-length string is returned.
     * If a zero-length string is passed as from or to, `/`
     * will be used instead of the zero-length strings.
     */
    function relative(from, to) {
        return removeSlash(path_1.posix.relative(from, to));
    }
    PathExt.relative = relative;
    /**
     * Normalize a file extension to be of the type `'.foo'`.
     *
     * @param extension - the file extension.
     *
     * #### Notes
     * Adds a leading dot if not present and converts to lower case.
     */
    function normalizeExtension(extension) {
        if (extension.length > 0 && extension.indexOf('.') !== 0) {
            extension = `.${extension}`;
        }
        return extension;
    }
    PathExt.normalizeExtension = normalizeExtension;
    /**
     * Remove the leading slash from a path.
     *
     * @param path the path from which to remove a leading slash.
     */
    function removeSlash(path) {
        if (path.indexOf('/') === 0) {
            path = path.slice(1);
        }
        return path;
    }
    PathExt.removeSlash = removeSlash;
})(PathExt || (exports.PathExt = PathExt = {}));
//# sourceMappingURL=path.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/signal.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/signal.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.signalToPromise = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
/**
 * Convert a signal into a promise for the first emitted value.
 *
 * @param signal - The signal we are listening to.
 * @param timeout - Timeout to wait for signal in ms (not timeout if not defined or 0)
 *
 * @returns a Promise that resolves with a `(sender, args)` pair.
 */
function signalToPromise(signal, timeout) {
    const waitForSignal = new coreutils_1.PromiseDelegate();
    function cleanup() {
        signal.disconnect(slot);
    }
    function slot(sender, args) {
        cleanup();
        waitForSignal.resolve([sender, args]);
    }
    signal.connect(slot);
    if ((timeout !== null && timeout !== void 0 ? timeout : 0) > 0) {
        setTimeout(() => {
            cleanup();
            waitForSignal.reject(`Signal not emitted within ${timeout} ms.`);
        }, timeout);
    }
    return waitForSignal.promise;
}
exports.signalToPromise = signalToPromise;
//# sourceMappingURL=signal.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/text.js":
/*!*********************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/text.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Text = void 0;
/**
 * The namespace for text-related functions.
 */
var Text;
(function (Text) {
    // javascript stores text as utf16 and string indices use "code units",
    // which stores high-codepoint characters as "surrogate pairs",
    // which occupy two indices in the javascript string.
    // We need to translate cursor_pos in the Jupyter protocol (in characters)
    // to js offset (with surrogate pairs taking two spots).
    const HAS_SURROGATES = '𝐚'.length > 1;
    /**
     * Convert a javascript string index into a unicode character offset
     *
     * @param jsIdx - The javascript string index (counting surrogate pairs)
     *
     * @param text - The text in which the offset is calculated
     *
     * @returns The unicode character offset
     */
    function jsIndexToCharIndex(jsIdx, text) {
        if (HAS_SURROGATES) {
            // not using surrogates, nothing to do
            return jsIdx;
        }
        let charIdx = jsIdx;
        for (let i = 0; i + 1 < text.length && i < jsIdx; i++) {
            const charCode = text.charCodeAt(i);
            // check for surrogate pair
            if (charCode >= 0xd800 && charCode <= 0xdbff) {
                const nextCharCode = text.charCodeAt(i + 1);
                if (nextCharCode >= 0xdc00 && nextCharCode <= 0xdfff) {
                    charIdx--;
                    i++;
                }
            }
        }
        return charIdx;
    }
    Text.jsIndexToCharIndex = jsIndexToCharIndex;
    /**
     * Convert a unicode character offset to a javascript string index.
     *
     * @param charIdx - The index in unicode characters
     *
     * @param text - The text in which the offset is calculated
     *
     * @returns The js-native index
     */
    function charIndexToJsIndex(charIdx, text) {
        if (HAS_SURROGATES) {
            // not using surrogates, nothing to do
            return charIdx;
        }
        let jsIdx = charIdx;
        for (let i = 0; i + 1 < text.length && i < jsIdx; i++) {
            const charCode = text.charCodeAt(i);
            // check for surrogate pair
            if (charCode >= 0xd800 && charCode <= 0xdbff) {
                const nextCharCode = text.charCodeAt(i + 1);
                if (nextCharCode >= 0xdc00 && nextCharCode <= 0xdfff) {
                    jsIdx++;
                    i++;
                }
            }
        }
        return jsIdx;
    }
    Text.charIndexToJsIndex = charIndexToJsIndex;
    /**
     * Given a 'snake-case', 'snake_case', 'snake:case', or
     * 'snake case' string, will return the camel case version: 'snakeCase'.
     *
     * @param str the snake-case input string.
     *
     * @param upper default = false. If true, the first letter of the
     * returned string will be capitalized.
     *
     * @returns the camel case version of the input string.
     */
    function camelCase(str, upper = false) {
        return str.replace(/^(\w)|[\s-_:]+(\w)/g, function (match, p1, p2) {
            if (p2) {
                return p2.toUpperCase();
            }
            else {
                return upper ? p1.toUpperCase() : p1.toLowerCase();
            }
        });
    }
    Text.camelCase = camelCase;
    /**
     * Given a string, title case the words in the string.
     *
     * @param str the string to title case.
     *
     * @returns the same string, but with each word capitalized.
     */
    function titleCase(str) {
        return (str || '')
            .toLowerCase()
            .split(' ')
            .map(word => word.charAt(0).toUpperCase() + word.slice(1))
            .join(' ');
    }
    Text.titleCase = titleCase;
})(Text || (exports.Text = Text = {}));
//# sourceMappingURL=text.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/time.js":
/*!*********************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/time.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Time = void 0;
/**
 * A list of time units with their associated value in milliseconds.
 */
const UNITS = [
    { name: 'years', milliseconds: 365 * 24 * 60 * 60 * 1000 },
    { name: 'months', milliseconds: 30 * 24 * 60 * 60 * 1000 },
    { name: 'days', milliseconds: 24 * 60 * 60 * 1000 },
    { name: 'hours', milliseconds: 60 * 60 * 1000 },
    { name: 'minutes', milliseconds: 60 * 1000 },
    { name: 'seconds', milliseconds: 1000 }
];
/**
 * The namespace for date functions.
 */
var Time;
(function (Time) {
    /**
     * Convert a timestring to a human readable string (e.g. 'two minutes ago').
     *
     * @param value - The date timestring or date object.
     *
     * @returns A formatted date.
     */
    function formatHuman(value, format = 'long') {
        const lang = document.documentElement.lang || 'en';
        const formatter = new Intl.RelativeTimeFormat(lang, {
            numeric: 'auto',
            style: format
        });
        const delta = new Date(value).getTime() - Date.now();
        for (let unit of UNITS) {
            const amount = Math.ceil(delta / unit.milliseconds);
            if (amount === 0) {
                continue;
            }
            return formatter.format(amount, unit.name);
        }
        return formatter.format(0, 'seconds');
    }
    Time.formatHuman = formatHuman;
    /**
     * Convenient helper to convert a timestring to a date format.
     *
     * @param value - The date timestring or date object.
     *
     * @returns A formatted date.
     */
    function format(value) {
        const lang = document.documentElement.lang || 'en';
        const formatter = new Intl.DateTimeFormat(lang, {
            dateStyle: 'short',
            timeStyle: 'short'
        });
        return formatter.format(new Date(value));
    }
    Time.format = format;
})(Time || (exports.Time = Time = {}));
//# sourceMappingURL=time.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/coreutils/lib/url.js":
/*!********************************************************!*\
  !*** ../node_modules/@jupyterlab/coreutils/lib/url.js ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.URLExt = void 0;
const path_1 = __webpack_require__(/*! path */ "../node_modules/path-browserify/index.js");
const url_parse_1 = __importDefault(__webpack_require__(/*! url-parse */ "../node_modules/url-parse/index.js"));
/**
 * The namespace for URL-related functions.
 */
var URLExt;
(function (URLExt) {
    /**
     * Parse a url into a URL object.
     *
     * @param url - The URL string to parse.
     *
     * @returns A URL object.
     */
    function parse(url) {
        if (typeof document !== 'undefined' && document) {
            const a = document.createElement('a');
            a.href = url;
            return a;
        }
        return (0, url_parse_1.default)(url);
    }
    URLExt.parse = parse;
    /**
     * Parse URL and retrieve hostname
     *
     * @param url - The URL string to parse
     *
     * @returns a hostname string value
     */
    function getHostName(url) {
        return (0, url_parse_1.default)(url).hostname;
    }
    URLExt.getHostName = getHostName;
    function normalize(url) {
        return url && parse(url).toString();
    }
    URLExt.normalize = normalize;
    /**
     * Join a sequence of url components and normalizes as in node `path.join`.
     *
     * @param parts - The url components.
     *
     * @returns the joined url.
     */
    function join(...parts) {
        let u = (0, url_parse_1.default)(parts[0], {});
        // Schema-less URL can be only parsed as relative to a base URL
        // see https://github.com/unshiftio/url-parse/issues/219#issuecomment-1002219326
        const isSchemaLess = u.protocol === '' && u.slashes;
        if (isSchemaLess) {
            u = (0, url_parse_1.default)(parts[0], 'https:' + parts[0]);
        }
        const prefix = `${isSchemaLess ? '' : u.protocol}${u.slashes ? '//' : ''}${u.auth}${u.auth ? '@' : ''}${u.host}`;
        // If there was a prefix, then the first path must start at the root.
        const path = path_1.posix.join(`${!!prefix && u.pathname[0] !== '/' ? '/' : ''}${u.pathname}`, ...parts.slice(1));
        return `${prefix}${path === '.' ? '' : path}`;
    }
    URLExt.join = join;
    /**
     * Encode the components of a multi-segment url.
     *
     * @param url - The url to encode.
     *
     * @returns the encoded url.
     *
     * #### Notes
     * Preserves the `'/'` separators.
     * Should not include the base url, since all parts are escaped.
     */
    function encodeParts(url) {
        return join(...url.split('/').map(encodeURIComponent));
    }
    URLExt.encodeParts = encodeParts;
    /**
     * Return a serialized object string suitable for a query.
     *
     * @param value The source object.
     *
     * @returns an encoded url query.
     *
     * #### Notes
     * Modified version of [stackoverflow](http://stackoverflow.com/a/30707423).
     */
    function objectToQueryString(value) {
        const keys = Object.keys(value).filter(key => key.length > 0);
        if (!keys.length) {
            return '';
        }
        return ('?' +
            keys
                .map(key => {
                const content = encodeURIComponent(String(value[key]));
                return key + (content ? '=' + content : '');
            })
                .join('&'));
    }
    URLExt.objectToQueryString = objectToQueryString;
    /**
     * Return a parsed object that represents the values in a query string.
     */
    function queryStringToObject(value) {
        return value
            .replace(/^\?/, '')
            .split('&')
            .reduce((acc, val) => {
            const [key, value] = val.split('=');
            if (key.length > 0) {
                acc[key] = decodeURIComponent(value || '');
            }
            return acc;
        }, {});
    }
    URLExt.queryStringToObject = queryStringToObject;
    /**
     * Test whether the url is a local url.
     *
     * @param allowRoot - Whether the paths starting at Unix-style filesystem root (`/`) are permitted.
     *
     * #### Notes
     * This function returns `false` for any fully qualified url, including
     * `data:`, `file:`, and `//` protocol URLs.
     */
    function isLocal(url, allowRoot = false) {
        const { protocol } = parse(url);
        return ((!protocol || url.toLowerCase().indexOf(protocol) !== 0) &&
            (allowRoot ? url.indexOf('//') !== 0 : url.indexOf('/') !== 0));
    }
    URLExt.isLocal = isLocal;
})(URLExt || (exports.URLExt = URLExt = {}));
//# sourceMappingURL=url.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/basemanager.js":
/*!***************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/basemanager.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseManager = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const serverconnection_1 = __webpack_require__(/*! ./serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
class BaseManager {
    constructor(options) {
        var _a;
        this._isDisposed = false;
        this._disposed = new signaling_1.Signal(this);
        this.serverSettings =
            (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
    }
    /**
     * A signal emitted when the delegate is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * Test whether the delegate has been disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Whether the manager is active.
     */
    get isActive() {
        return true;
    }
    /**
     * Dispose of the delegate and invoke the callback function.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._disposed.emit(undefined);
        signaling_1.Signal.clearData(this);
    }
}
exports.BaseManager = BaseManager;
//# sourceMappingURL=basemanager.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/builder/index.js":
/*!*****************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/builder/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BuildManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
/**
 * The url for the lab build service.
 */
const BUILD_SETTINGS_URL = 'api/build';
/**
 * The build API service manager.
 */
class BuildManager {
    /**
     * Create a new setting manager.
     */
    constructor(options = {}) {
        var _a;
        this._url = '';
        this.serverSettings =
            (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
        const { baseUrl, appUrl } = this.serverSettings;
        this._url = coreutils_1.URLExt.join(baseUrl, appUrl, BUILD_SETTINGS_URL);
    }
    /**
     * Test whether the build service is available.
     */
    get isAvailable() {
        return coreutils_1.PageConfig.getOption('buildAvailable').toLowerCase() === 'true';
    }
    /**
     * Test whether to check build status automatically.
     */
    get shouldCheck() {
        return coreutils_1.PageConfig.getOption('buildCheck').toLowerCase() === 'true';
    }
    /**
     * Get whether the application should be built.
     */
    getStatus() {
        const { _url, serverSettings } = this;
        const promise = serverconnection_1.ServerConnection.makeRequest(_url, {}, serverSettings);
        return promise
            .then(response => {
            if (response.status !== 200) {
                throw new serverconnection_1.ServerConnection.ResponseError(response);
            }
            return response.json();
        })
            .then(data => {
            if (typeof data.status !== 'string') {
                throw new Error('Invalid data');
            }
            if (typeof data.message !== 'string') {
                throw new Error('Invalid data');
            }
            return data;
        });
    }
    /**
     * Build the application.
     */
    build() {
        const { _url, serverSettings } = this;
        const init = { method: 'POST' };
        const promise = serverconnection_1.ServerConnection.makeRequest(_url, init, serverSettings);
        return promise.then(response => {
            if (response.status === 400) {
                throw new serverconnection_1.ServerConnection.ResponseError(response, 'Build aborted');
            }
            if (response.status !== 200) {
                const message = `Build failed with ${response.status}.

        If you are experiencing the build failure after installing an extension (or trying to include previously installed extension after updating JupyterLab) please check the extension repository for new installation instructions as many extensions migrated to the prebuilt extensions system which no longer requires rebuilding JupyterLab (but uses a different installation procedure, typically involving a package manager such as 'pip' or 'conda').

        If you specifically intended to install a source extension, please run 'jupyter lab build' on the server for full output.`;
                throw new serverconnection_1.ServerConnection.ResponseError(response, message);
            }
        });
    }
    /**
     * Cancel an active build.
     */
    cancel() {
        const { _url, serverSettings } = this;
        const init = { method: 'DELETE' };
        const promise = serverconnection_1.ServerConnection.makeRequest(_url, init, serverSettings);
        return promise.then(response => {
            if (response.status !== 204) {
                throw new serverconnection_1.ServerConnection.ResponseError(response);
            }
        });
    }
}
exports.BuildManager = BuildManager;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/config/index.js":
/*!****************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/config/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConfigWithDefaults = exports.ConfigSection = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const __1 = __webpack_require__(/*! .. */ "../node_modules/@jupyterlab/services/lib/index.js");
/**
 * The url for the config service.
 */
const SERVICE_CONFIG_URL = 'api/config';
/**
 * The namespace for ConfigSection statics.
 */
var ConfigSection;
(function (ConfigSection) {
    /**
     * Create a config section.
     *
     * @returns A Promise that is fulfilled with the config section is loaded.
     */
    function create(options) {
        const section = new DefaultConfigSection(options);
        return section.load().then(() => {
            return section;
        });
    }
    ConfigSection.create = create;
})(ConfigSection || (exports.ConfigSection = ConfigSection = {}));
/**
 * Implementation of the Configurable data section.
 */
class DefaultConfigSection {
    /**
     * Construct a new config section.
     */
    constructor(options) {
        var _a;
        this._url = 'unknown';
        const settings = (this.serverSettings =
            (_a = options.serverSettings) !== null && _a !== void 0 ? _a : __1.ServerConnection.makeSettings());
        this._url = coreutils_1.URLExt.join(settings.baseUrl, SERVICE_CONFIG_URL, encodeURIComponent(options.name));
    }
    /**
     * Get the data for this section.
     */
    get data() {
        return this._data;
    }
    /**
     * Load the initial data for this section.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/config).
     *
     * The promise is fulfilled on a valid response and rejected otherwise.
     */
    async load() {
        const response = await __1.ServerConnection.makeRequest(this._url, {}, this.serverSettings);
        if (response.status !== 200) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        this._data = await response.json();
    }
    /**
     * Modify the stored config values.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/config).
     *
     * The promise is fulfilled on a valid response and rejected otherwise.
     *
     * Updates the local data immediately, sends the change to the server,
     * and updates the local data with the response, and fulfils the promise
     * with that data.
     */
    async update(newdata) {
        this._data = { ...this._data, ...newdata };
        const init = {
            method: 'PATCH',
            body: JSON.stringify(newdata)
        };
        const response = await __1.ServerConnection.makeRequest(this._url, init, this.serverSettings);
        if (response.status !== 200) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        this._data = await response.json();
        return this._data;
    }
}
/**
 * Configurable object with defaults.
 */
class ConfigWithDefaults {
    /**
     * Create a new config with defaults.
     */
    constructor(options) {
        var _a, _b;
        this._className = '';
        this._section = options.section;
        this._defaults = (_a = options.defaults) !== null && _a !== void 0 ? _a : {};
        this._className = (_b = options.className) !== null && _b !== void 0 ? _b : '';
    }
    /**
     * Get data from the config section or fall back to defaults.
     */
    get(key) {
        const data = this._classData();
        return key in data ? data[key] : this._defaults[key];
    }
    /**
     * Set a config value.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/config).
     *
     * The promise is fulfilled on a valid response and rejected otherwise.
     *
     * Sends the update to the server, and changes our local copy of the data
     * immediately.
     */
    set(key, value) {
        const d = {};
        d[key] = value;
        if (this._className) {
            const d2 = {};
            d2[this._className] = d;
            return this._section.update(d2);
        }
        else {
            return this._section.update(d);
        }
    }
    /**
     * Get data from the Section with our classname, if available.
     *
     * #### Notes
     * If we have no classname, get all of the data in the Section
     */
    _classData() {
        const data = this._section.data;
        if (this._className && this._className in data) {
            return data[this._className];
        }
        return data;
    }
}
exports.ConfigWithDefaults = ConfigWithDefaults;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/contents/index.js":
/*!******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/contents/index.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Drive = exports.ContentsManager = exports.Contents = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "../node_modules/@jupyterlab/services/lib/index.js");
const validate = __importStar(__webpack_require__(/*! ./validate */ "../node_modules/@jupyterlab/services/lib/contents/validate.js"));
/**
 * The url for the default drive service.
 */
const SERVICE_DRIVE_URL = 'api/contents';
/**
 * The url for the file access.
 */
const FILES_URL = 'files';
/**
 * A namespace for contents interfaces.
 */
var Contents;
(function (Contents) {
    /**
     * Validates an IModel, throwing an error if it does not pass.
     */
    function validateContentsModel(contents) {
        validate.validateContentsModel(contents);
    }
    Contents.validateContentsModel = validateContentsModel;
    /**
     * Validates an ICheckpointModel, throwing an error if it does not pass.
     */
    function validateCheckpointModel(checkpoint) {
        validate.validateCheckpointModel(checkpoint);
    }
    Contents.validateCheckpointModel = validateCheckpointModel;
})(Contents || (exports.Contents = Contents = {}));
/**
 * A contents manager that passes file operations to the server.
 * Multiple servers implementing the `IDrive` interface can be
 * attached to the contents manager, so that the same session can
 * perform file operations on multiple backends.
 *
 * This includes checkpointing with the normal file operations.
 */
class ContentsManager {
    /**
     * Construct a new contents manager object.
     *
     * @param options - The options used to initialize the object.
     */
    constructor(options = {}) {
        var _a, _b;
        this._isDisposed = false;
        this._additionalDrives = new Map();
        this._fileChanged = new signaling_1.Signal(this);
        const serverSettings = (this.serverSettings =
            (_a = options.serverSettings) !== null && _a !== void 0 ? _a : __1.ServerConnection.makeSettings());
        this._defaultDrive = (_b = options.defaultDrive) !== null && _b !== void 0 ? _b : new Drive({ serverSettings });
        this._defaultDrive.fileChanged.connect(this._onFileChanged, this);
    }
    /**
     * A signal emitted when a file operation takes place.
     */
    get fileChanged() {
        return this._fileChanged;
    }
    /**
     * Test whether the manager has been disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the manager.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        signaling_1.Signal.clearData(this);
    }
    /**
     * Add an `IDrive` to the manager.
     */
    addDrive(drive) {
        this._additionalDrives.set(drive.name, drive);
        drive.fileChanged.connect(this._onFileChanged, this);
    }
    /**
     * Given a path, get a shared model factory from the
     * relevant backend. Returns `null` if the backend
     * does not provide one.
     */
    getSharedModelFactory(path) {
        var _a;
        const [drive] = this._driveForPath(path);
        return (_a = drive === null || drive === void 0 ? void 0 : drive.sharedModelFactory) !== null && _a !== void 0 ? _a : null;
    }
    /**
     * Given a path of the form `drive:local/portion/of/it.txt`
     * get the local part of it.
     *
     * @param path the path.
     *
     * @returns The local part of the path.
     */
    localPath(path) {
        const parts = path.split('/');
        const firstParts = parts[0].split(':');
        if (firstParts.length === 1 || !this._additionalDrives.has(firstParts[0])) {
            return coreutils_1.PathExt.removeSlash(path);
        }
        return coreutils_1.PathExt.join(firstParts.slice(1).join(':'), ...parts.slice(1));
    }
    /**
     * Normalize a global path. Reduces '..' and '.' parts, and removes
     * leading slashes from the local part of the path, while retaining
     * the drive name if it exists.
     *
     * @param path the path.
     *
     * @returns The normalized path.
     */
    normalize(path) {
        const parts = path.split(':');
        if (parts.length === 1) {
            return coreutils_1.PathExt.normalize(path);
        }
        return `${parts[0]}:${coreutils_1.PathExt.normalize(parts.slice(1).join(':'))}`;
    }
    /**
     * Resolve a global path, starting from the root path. Behaves like
     * posix-path.resolve, with 3 differences:
     *  - will never prepend cwd
     *  - if root has a drive name, the result is prefixed with "<drive>:"
     *  - before adding drive name, leading slashes are removed
     *
     * @param path the path.
     *
     * @returns The normalized path.
     */
    resolvePath(root, path) {
        const driveName = this.driveName(root);
        const localPath = this.localPath(root);
        const resolved = coreutils_1.PathExt.resolve('/', localPath, path);
        return driveName ? `${driveName}:${resolved}` : resolved;
    }
    /**
     * Given a path of the form `drive:local/portion/of/it.txt`
     * get the name of the drive. If the path is missing
     * a drive portion, returns an empty string.
     *
     * @param path the path.
     *
     * @returns The drive name for the path, or the empty string.
     */
    driveName(path) {
        const parts = path.split('/');
        const firstParts = parts[0].split(':');
        if (firstParts.length === 1) {
            return '';
        }
        if (this._additionalDrives.has(firstParts[0])) {
            return firstParts[0];
        }
        return '';
    }
    /**
     * Get a file or directory.
     *
     * @param path The path to the file.
     *
     * @param options The options used to fetch the file.
     *
     * @returns A promise which resolves with the file content.
     */
    get(path, options) {
        const [drive, localPath] = this._driveForPath(path);
        return drive.get(localPath, options).then(contentsModel => {
            const listing = [];
            if (contentsModel.type === 'directory' && contentsModel.content) {
                for (const item of contentsModel.content) {
                    listing.push({ ...item, path: this._toGlobalPath(drive, item.path) });
                }
                return {
                    ...contentsModel,
                    path: this._toGlobalPath(drive, localPath),
                    content: listing,
                    serverPath: contentsModel.path
                };
            }
            else {
                return {
                    ...contentsModel,
                    path: this._toGlobalPath(drive, localPath),
                    serverPath: contentsModel.path
                };
            }
        });
    }
    /**
     * Get an encoded download url given a file path.
     *
     * @param path - An absolute POSIX file path on the server.
     *
     * #### Notes
     * It is expected that the path contains no relative paths.
     *
     * The returned URL may include a query parameter.
     */
    getDownloadUrl(path) {
        const [drive, localPath] = this._driveForPath(path);
        return drive.getDownloadUrl(localPath);
    }
    /**
     * Create a new untitled file or directory in the specified directory path.
     *
     * @param options The options used to create the file.
     *
     * @returns A promise which resolves with the created file content when the
     *    file is created.
     */
    newUntitled(options = {}) {
        if (options.path) {
            const globalPath = this.normalize(options.path);
            const [drive, localPath] = this._driveForPath(globalPath);
            return drive
                .newUntitled({ ...options, path: localPath })
                .then(contentsModel => {
                return {
                    ...contentsModel,
                    path: coreutils_1.PathExt.join(globalPath, contentsModel.name),
                    serverPath: contentsModel.path
                };
            });
        }
        else {
            return this._defaultDrive.newUntitled(options);
        }
    }
    /**
     * Delete a file.
     *
     * @param path - The path to the file.
     *
     * @returns A promise which resolves when the file is deleted.
     */
    delete(path) {
        const [drive, localPath] = this._driveForPath(path);
        return drive.delete(localPath);
    }
    /**
     * Rename a file or directory.
     *
     * @param path - The original file path.
     *
     * @param newPath - The new file path.
     *
     * @returns A promise which resolves with the new file contents model when
     *   the file is renamed.
     */
    rename(path, newPath) {
        const [drive1, path1] = this._driveForPath(path);
        const [drive2, path2] = this._driveForPath(newPath);
        if (drive1 !== drive2) {
            throw Error('ContentsManager: renaming files must occur within a Drive');
        }
        return drive1.rename(path1, path2).then(contentsModel => {
            return {
                ...contentsModel,
                path: this._toGlobalPath(drive1, path2),
                serverPath: contentsModel.path
            };
        });
    }
    /**
     * Save a file.
     *
     * @param path - The desired file path.
     *
     * @param options - Optional overrides to the model.
     *
     * @returns A promise which resolves with the file content model when the
     *   file is saved.
     *
     * #### Notes
     * Ensure that `model.content` is populated for the file.
     */
    save(path, options = {}) {
        const globalPath = this.normalize(path);
        const [drive, localPath] = this._driveForPath(path);
        return drive
            .save(localPath, { ...options, path: localPath })
            .then(contentsModel => {
            return {
                ...contentsModel,
                path: globalPath,
                serverPath: contentsModel.path
            };
        });
    }
    /**
     * Copy a file into a given directory.
     *
     * @param path - The original file path.
     *
     * @param toDir - The destination directory path.
     *
     * @returns A promise which resolves with the new contents model when the
     *  file is copied.
     *
     * #### Notes
     * The server will select the name of the copied file.
     */
    copy(fromFile, toDir) {
        const [drive1, path1] = this._driveForPath(fromFile);
        const [drive2, path2] = this._driveForPath(toDir);
        if (drive1 === drive2) {
            return drive1.copy(path1, path2).then(contentsModel => {
                return {
                    ...contentsModel,
                    path: this._toGlobalPath(drive1, contentsModel.path),
                    serverPath: contentsModel.path
                };
            });
        }
        else {
            throw Error('Copying files between drives is not currently implemented');
        }
    }
    /**
     * Create a checkpoint for a file.
     *
     * @param path - The path of the file.
     *
     * @returns A promise which resolves with the new checkpoint model when the
     *   checkpoint is created.
     */
    createCheckpoint(path) {
        const [drive, localPath] = this._driveForPath(path);
        return drive.createCheckpoint(localPath);
    }
    /**
     * List available checkpoints for a file.
     *
     * @param path - The path of the file.
     *
     * @returns A promise which resolves with a list of checkpoint models for
     *    the file.
     */
    listCheckpoints(path) {
        const [drive, localPath] = this._driveForPath(path);
        return drive.listCheckpoints(localPath);
    }
    /**
     * Restore a file to a known checkpoint state.
     *
     * @param path - The path of the file.
     *
     * @param checkpointID - The id of the checkpoint to restore.
     *
     * @returns A promise which resolves when the checkpoint is restored.
     */
    restoreCheckpoint(path, checkpointID) {
        const [drive, localPath] = this._driveForPath(path);
        return drive.restoreCheckpoint(localPath, checkpointID);
    }
    /**
     * Delete a checkpoint for a file.
     *
     * @param path - The path of the file.
     *
     * @param checkpointID - The id of the checkpoint to delete.
     *
     * @returns A promise which resolves when the checkpoint is deleted.
     */
    deleteCheckpoint(path, checkpointID) {
        const [drive, localPath] = this._driveForPath(path);
        return drive.deleteCheckpoint(localPath, checkpointID);
    }
    /**
     * Given a drive and a local path, construct a fully qualified
     * path. The inverse of `_driveForPath`.
     *
     * @param drive an `IDrive`.
     *
     * @param localPath the local path on the drive.
     *
     * @returns the fully qualified path.
     */
    _toGlobalPath(drive, localPath) {
        if (drive === this._defaultDrive) {
            return coreutils_1.PathExt.removeSlash(localPath);
        }
        else {
            return `${drive.name}:${coreutils_1.PathExt.removeSlash(localPath)}`;
        }
    }
    /**
     * Given a path, get the `IDrive to which it refers,
     * where the path satisfies the pattern
     * `'driveName:path/to/file'`. If there is no `driveName`
     * prepended to the path, it returns the default drive.
     *
     * @param path a path to a file.
     *
     * @returns A tuple containing an `IDrive` object for the path,
     * and a local path for that drive.
     */
    _driveForPath(path) {
        const driveName = this.driveName(path);
        const localPath = this.localPath(path);
        if (driveName) {
            return [this._additionalDrives.get(driveName), localPath];
        }
        else {
            return [this._defaultDrive, localPath];
        }
    }
    /**
     * Respond to fileChanged signals from the drives attached to
     * the manager. This prepends the drive name to the path if necessary,
     * and then forwards the signal.
     */
    _onFileChanged(sender, args) {
        var _a, _b;
        if (sender === this._defaultDrive) {
            this._fileChanged.emit(args);
        }
        else {
            let newValue = null;
            let oldValue = null;
            if ((_a = args.newValue) === null || _a === void 0 ? void 0 : _a.path) {
                newValue = {
                    ...args.newValue,
                    path: this._toGlobalPath(sender, args.newValue.path)
                };
            }
            if ((_b = args.oldValue) === null || _b === void 0 ? void 0 : _b.path) {
                oldValue = {
                    ...args.oldValue,
                    path: this._toGlobalPath(sender, args.oldValue.path)
                };
            }
            this._fileChanged.emit({
                type: args.type,
                newValue,
                oldValue
            });
        }
    }
}
exports.ContentsManager = ContentsManager;
/**
 * A default implementation for an `IDrive`, talking to the
 * server using the Jupyter REST API.
 */
class Drive {
    /**
     * Construct a new contents manager object.
     *
     * @param options - The options used to initialize the object.
     */
    constructor(options = {}) {
        var _a, _b, _c;
        this._isDisposed = false;
        this._fileChanged = new signaling_1.Signal(this);
        this.name = (_a = options.name) !== null && _a !== void 0 ? _a : 'Default';
        this._apiEndpoint = (_b = options.apiEndpoint) !== null && _b !== void 0 ? _b : SERVICE_DRIVE_URL;
        this.serverSettings =
            (_c = options.serverSettings) !== null && _c !== void 0 ? _c : __1.ServerConnection.makeSettings();
    }
    /**
     * A signal emitted when a file operation takes place.
     */
    get fileChanged() {
        return this._fileChanged;
    }
    /**
     * Test whether the manager has been disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the manager.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        signaling_1.Signal.clearData(this);
    }
    /**
     * Get a file or directory.
     *
     * @param localPath The path to the file.
     *
     * @param options The options used to fetch the file.
     *
     * @returns A promise which resolves with the file content.
     *
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
     */
    async get(localPath, options) {
        let url = this._getUrl(localPath);
        if (options) {
            // The notebook type cannot take an format option.
            if (options.type === 'notebook') {
                delete options['format'];
            }
            const content = options.content ? '1' : '0';
            const hash = options.hash ? '1' : '0';
            const params = { ...options, content, hash };
            url += coreutils_1.URLExt.objectToQueryString(params);
        }
        const settings = this.serverSettings;
        const response = await __1.ServerConnection.makeRequest(url, {}, settings);
        if (response.status !== 200) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        const data = await response.json();
        validate.validateContentsModel(data);
        return data;
    }
    /**
     * Get an encoded download url given a file path.
     *
     * @param localPath - An absolute POSIX file path on the server.
     *
     * #### Notes
     * It is expected that the path contains no relative paths.
     *
     * The returned URL may include a query parameter.
     */
    getDownloadUrl(localPath) {
        const baseUrl = this.serverSettings.baseUrl;
        let url = coreutils_1.URLExt.join(baseUrl, FILES_URL, coreutils_1.URLExt.encodeParts(localPath));
        let cookie = '';
        try {
            cookie = document.cookie;
        }
        catch (e) {
            // e.g. SecurityError in case of CSP Sandbox
        }
        const xsrfTokenMatch = cookie.match('\\b_xsrf=([^;]*)\\b');
        if (xsrfTokenMatch) {
            const fullUrl = new URL(url);
            fullUrl.searchParams.append('_xsrf', xsrfTokenMatch[1]);
            url = fullUrl.toString();
        }
        return Promise.resolve(url);
    }
    /**
     * Create a new untitled file or directory in the specified directory path.
     *
     * @param options The options used to create the file.
     *
     * @returns A promise which resolves with the created file content when the
     *    file is created.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
     */
    async newUntitled(options = {}) {
        var _a;
        let body = '{}';
        if (options) {
            if (options.ext) {
                options.ext = Private.normalizeExtension(options.ext);
            }
            body = JSON.stringify(options);
        }
        const settings = this.serverSettings;
        const url = this._getUrl((_a = options.path) !== null && _a !== void 0 ? _a : '');
        const init = {
            method: 'POST',
            body
        };
        const response = await __1.ServerConnection.makeRequest(url, init, settings);
        if (response.status !== 201) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        const data = await response.json();
        validate.validateContentsModel(data);
        this._fileChanged.emit({
            type: 'new',
            oldValue: null,
            newValue: data
        });
        return data;
    }
    /**
     * Delete a file.
     *
     * @param localPath - The path to the file.
     *
     * @returns A promise which resolves when the file is deleted.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents).
     */
    async delete(localPath) {
        const url = this._getUrl(localPath);
        const settings = this.serverSettings;
        const init = { method: 'DELETE' };
        const response = await __1.ServerConnection.makeRequest(url, init, settings);
        // TODO: update IPEP27 to specify errors more precisely, so
        // that error types can be detected here with certainty.
        if (response.status !== 204) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        this._fileChanged.emit({
            type: 'delete',
            oldValue: { path: localPath },
            newValue: null
        });
    }
    /**
     * Rename a file or directory.
     *
     * @param oldLocalPath - The original file path.
     *
     * @param newLocalPath - The new file path.
     *
     * @returns A promise which resolves with the new file contents model when
     *   the file is renamed.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
     */
    async rename(oldLocalPath, newLocalPath) {
        const settings = this.serverSettings;
        const url = this._getUrl(oldLocalPath);
        const init = {
            method: 'PATCH',
            body: JSON.stringify({ path: newLocalPath })
        };
        const response = await __1.ServerConnection.makeRequest(url, init, settings);
        if (response.status !== 200) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        const data = await response.json();
        validate.validateContentsModel(data);
        this._fileChanged.emit({
            type: 'rename',
            oldValue: { path: oldLocalPath },
            newValue: data
        });
        return data;
    }
    /**
     * Save a file.
     *
     * @param localPath - The desired file path.
     *
     * @param options - Optional overrides to the model.
     *
     * @returns A promise which resolves with the file content model when the
     *   file is saved.
     *
     * #### Notes
     * Ensure that `model.content` is populated for the file.
     *
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
     */
    async save(localPath, options = {}) {
        const settings = this.serverSettings;
        const url = this._getUrl(localPath);
        const init = {
            method: 'PUT',
            body: JSON.stringify(options)
        };
        const response = await __1.ServerConnection.makeRequest(url, init, settings);
        // will return 200 for an existing file and 201 for a new file
        if (response.status !== 200 && response.status !== 201) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        const data = await response.json();
        validate.validateContentsModel(data);
        this._fileChanged.emit({
            type: 'save',
            oldValue: null,
            newValue: data
        });
        return data;
    }
    /**
     * Copy a file into a given directory.
     *
     * @param localPath - The original file path.
     *
     * @param toDir - The destination directory path.
     *
     * @returns A promise which resolves with the new contents model when the
     *  file is copied.
     *
     * #### Notes
     * The server will select the name of the copied file.
     *
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
     */
    async copy(fromFile, toDir) {
        const settings = this.serverSettings;
        const url = this._getUrl(toDir);
        const init = {
            method: 'POST',
            body: JSON.stringify({ copy_from: fromFile })
        };
        const response = await __1.ServerConnection.makeRequest(url, init, settings);
        if (response.status !== 201) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        const data = await response.json();
        validate.validateContentsModel(data);
        this._fileChanged.emit({
            type: 'new',
            oldValue: null,
            newValue: data
        });
        return data;
    }
    /**
     * Create a checkpoint for a file.
     *
     * @param localPath - The path of the file.
     *
     * @returns A promise which resolves with the new checkpoint model when the
     *   checkpoint is created.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
     */
    async createCheckpoint(localPath) {
        const url = this._getUrl(localPath, 'checkpoints');
        const init = { method: 'POST' };
        const response = await __1.ServerConnection.makeRequest(url, init, this.serverSettings);
        if (response.status !== 201) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        const data = await response.json();
        validate.validateCheckpointModel(data);
        return data;
    }
    /**
     * List available checkpoints for a file.
     *
     * @param localPath - The path of the file.
     *
     * @returns A promise which resolves with a list of checkpoint models for
     *    the file.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
     */
    async listCheckpoints(localPath) {
        const url = this._getUrl(localPath, 'checkpoints');
        const response = await __1.ServerConnection.makeRequest(url, {}, this.serverSettings);
        if (response.status !== 200) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        const data = await response.json();
        if (!Array.isArray(data)) {
            throw new Error('Invalid Checkpoint list');
        }
        for (let i = 0; i < data.length; i++) {
            validate.validateCheckpointModel(data[i]);
        }
        return data;
    }
    /**
     * Restore a file to a known checkpoint state.
     *
     * @param localPath - The path of the file.
     *
     * @param checkpointID - The id of the checkpoint to restore.
     *
     * @returns A promise which resolves when the checkpoint is restored.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents).
     */
    async restoreCheckpoint(localPath, checkpointID) {
        const url = this._getUrl(localPath, 'checkpoints', checkpointID);
        const init = { method: 'POST' };
        const response = await __1.ServerConnection.makeRequest(url, init, this.serverSettings);
        if (response.status !== 204) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
    }
    /**
     * Delete a checkpoint for a file.
     *
     * @param localPath - The path of the file.
     *
     * @param checkpointID - The id of the checkpoint to delete.
     *
     * @returns A promise which resolves when the checkpoint is deleted.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents).
     */
    async deleteCheckpoint(localPath, checkpointID) {
        const url = this._getUrl(localPath, 'checkpoints', checkpointID);
        const init = { method: 'DELETE' };
        const response = await __1.ServerConnection.makeRequest(url, init, this.serverSettings);
        if (response.status !== 204) {
            const err = await __1.ServerConnection.ResponseError.create(response);
            throw err;
        }
    }
    /**
     * Get a REST url for a file given a path.
     */
    _getUrl(...args) {
        const parts = args.map(path => coreutils_1.URLExt.encodeParts(path));
        const baseUrl = this.serverSettings.baseUrl;
        return coreutils_1.URLExt.join(baseUrl, this._apiEndpoint, ...parts);
    }
}
exports.Drive = Drive;
/**
 * A namespace for module private data.
 */
var Private;
(function (Private) {
    /**
     * Normalize a file extension to be of the type `'.foo'`.
     *
     * Adds a leading dot if not present and converts to lower case.
     */
    function normalizeExtension(extension) {
        if (extension.length > 0 && extension.indexOf('.') !== 0) {
            extension = `.${extension}`;
        }
        return extension;
    }
    Private.normalizeExtension = normalizeExtension;
})(Private || (Private = {}));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/contents/validate.js":
/*!*********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/contents/validate.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateCheckpointModel = exports.validateContentsModel = void 0;
const validate_1 = __webpack_require__(/*! ../validate */ "../node_modules/@jupyterlab/services/lib/validate.js");
/**
 * Validate an `Contents.IModel` object.
 */
function validateContentsModel(model) {
    (0, validate_1.validateProperty)(model, 'name', 'string');
    (0, validate_1.validateProperty)(model, 'path', 'string');
    (0, validate_1.validateProperty)(model, 'type', 'string');
    (0, validate_1.validateProperty)(model, 'created', 'string');
    (0, validate_1.validateProperty)(model, 'last_modified', 'string');
    (0, validate_1.validateProperty)(model, 'mimetype', 'object');
    (0, validate_1.validateProperty)(model, 'content', 'object');
    (0, validate_1.validateProperty)(model, 'format', 'object');
}
exports.validateContentsModel = validateContentsModel;
/**
 * Validate an `Contents.ICheckpointModel` object.
 */
function validateCheckpointModel(model) {
    (0, validate_1.validateProperty)(model, 'id', 'string');
    (0, validate_1.validateProperty)(model, 'last_modified', 'string');
}
exports.validateCheckpointModel = validateCheckpointModel;
//# sourceMappingURL=validate.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/event/index.js":
/*!***************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/event/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const polling_1 = __webpack_require__(/*! @lumino/polling */ "../node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
/**
 * The url for the jupyter-server events service.
 */
const SERVICE_EVENTS_URL = 'api/events';
/**
 * The events API service manager.
 */
class EventManager {
    /**
     * Create a new event manager.
     */
    constructor(options = {}) {
        var _a;
        this._socket = null;
        this.serverSettings =
            (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
        // If subscription fails, the poll attempts to reconnect and backs off.
        this._poll = new polling_1.Poll({ factory: () => this._subscribe() });
        this._stream = new signaling_1.Stream(this);
        // Subscribe to the events socket.
        void this._poll.start();
    }
    /**
     * Whether the event manager is disposed.
     */
    get isDisposed() {
        return this._poll.isDisposed;
    }
    /**
     * An event stream that emits and yields each new event.
     */
    get stream() {
        return this._stream;
    }
    /**
     * Dispose the event manager.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        // Clean up poll.
        this._poll.dispose();
        // Clean up socket.
        const socket = this._socket;
        if (socket) {
            this._socket = null;
            socket.onopen = () => undefined;
            socket.onerror = () => undefined;
            socket.onmessage = () => undefined;
            socket.onclose = () => undefined;
            socket.close();
        }
        // Clean up stream.
        signaling_1.Signal.clearData(this);
        this._stream.stop();
    }
    /**
     * Post an event request to be emitted by the event bus.
     */
    async emit(event) {
        const { serverSettings } = this;
        const { baseUrl } = serverSettings;
        const { makeRequest, ResponseError } = serverconnection_1.ServerConnection;
        const url = coreutils_1.URLExt.join(baseUrl, SERVICE_EVENTS_URL);
        const init = { body: JSON.stringify(event), method: 'POST' };
        const response = await makeRequest(url, init, serverSettings);
        if (response.status !== 204) {
            throw new ResponseError(response);
        }
    }
    /**
     * Subscribe to event bus emissions.
     */
    _subscribe() {
        return new Promise((_, reject) => {
            if (this.isDisposed) {
                return;
            }
            const { appendToken, token, WebSocket, wsUrl } = this.serverSettings;
            let url = coreutils_1.URLExt.join(wsUrl, SERVICE_EVENTS_URL, 'subscribe');
            if (appendToken && token !== '') {
                url += `?token=${encodeURIComponent(token)}`;
            }
            const socket = (this._socket = new WebSocket(url));
            const stream = this._stream;
            socket.onclose = () => reject(new Error('EventManager socket closed'));
            socket.onmessage = msg => msg.data && stream.emit(JSON.parse(msg.data));
        });
    }
}
exports.EventManager = EventManager;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/index.js":
/*!*********************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/index.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module services
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./basemanager */ "../node_modules/@jupyterlab/services/lib/basemanager.js"), exports);
__exportStar(__webpack_require__(/*! ./config */ "../node_modules/@jupyterlab/services/lib/config/index.js"), exports);
__exportStar(__webpack_require__(/*! ./contents */ "../node_modules/@jupyterlab/services/lib/contents/index.js"), exports);
__exportStar(__webpack_require__(/*! ./event */ "../node_modules/@jupyterlab/services/lib/event/index.js"), exports);
__exportStar(__webpack_require__(/*! ./kernel */ "../node_modules/@jupyterlab/services/lib/kernel/index.js"), exports);
__exportStar(__webpack_require__(/*! ./kernelspec */ "../node_modules/@jupyterlab/services/lib/kernelspec/index.js"), exports);
__exportStar(__webpack_require__(/*! ./manager */ "../node_modules/@jupyterlab/services/lib/manager.js"), exports);
__exportStar(__webpack_require__(/*! ./serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js"), exports);
__exportStar(__webpack_require__(/*! ./session */ "../node_modules/@jupyterlab/services/lib/session/index.js"), exports);
__exportStar(__webpack_require__(/*! ./setting */ "../node_modules/@jupyterlab/services/lib/setting/index.js"), exports);
__exportStar(__webpack_require__(/*! ./terminal */ "../node_modules/@jupyterlab/services/lib/terminal/index.js"), exports);
__exportStar(__webpack_require__(/*! ./user */ "../node_modules/@jupyterlab/services/lib/user/index.js"), exports);
__exportStar(__webpack_require__(/*! ./workspace */ "../node_modules/@jupyterlab/services/lib/workspace/index.js"), exports);
__exportStar(__webpack_require__(/*! ./nbconvert */ "../node_modules/@jupyterlab/services/lib/nbconvert/index.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernel/comm.js":
/*!***************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernel/comm.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommHandler = void 0;
const disposable_1 = __webpack_require__(/*! @lumino/disposable */ "../node_modules/@lumino/disposable/dist/index.es6.js");
const KernelMessage = __importStar(__webpack_require__(/*! ./messages */ "../node_modules/@jupyterlab/services/lib/kernel/messages.js"));
/**
 * Comm channel handler.
 */
class CommHandler extends disposable_1.DisposableDelegate {
    /**
     * Construct a new comm channel.
     */
    constructor(target, id, kernel, disposeCb) {
        super(disposeCb);
        this._target = '';
        this._id = '';
        this._id = id;
        this._target = target;
        this._kernel = kernel;
    }
    /**
     * The unique id for the comm channel.
     */
    get commId() {
        return this._id;
    }
    /**
     * The target name for the comm channel.
     */
    get targetName() {
        return this._target;
    }
    /**
     * Get the callback for a comm close event.
     *
     * #### Notes
     * This is called when the comm is closed from either the server or client.
     *
     * **See also:** [[ICommClose]], [[close]]
     */
    get onClose() {
        return this._onClose;
    }
    /**
     * Set the callback for a comm close event.
     *
     * #### Notes
     * This is called when the comm is closed from either the server or client. If
     * the function returns a promise, and the kernel was closed from the server,
     * kernel message processing will pause until the returned promise is
     * fulfilled.
     *
     * **See also:** [[close]]
     */
    set onClose(cb) {
        this._onClose = cb;
    }
    /**
     * Get the callback for a comm message received event.
     */
    get onMsg() {
        return this._onMsg;
    }
    /**
     * Set the callback for a comm message received event.
     *
     * #### Notes
     * This is called when a comm message is received. If the function returns a
     * promise, kernel message processing will pause until it is fulfilled.
     */
    set onMsg(cb) {
        this._onMsg = cb;
    }
    /**
     * Open a comm with optional data and metadata.
     *
     * #### Notes
     * This sends a `comm_open` message to the server.
     *
     * **See also:** [[ICommOpen]]
     */
    open(data, metadata, buffers = []) {
        if (this.isDisposed || this._kernel.isDisposed) {
            throw new Error('Cannot open');
        }
        const msg = KernelMessage.createMessage({
            msgType: 'comm_open',
            channel: 'shell',
            username: this._kernel.username,
            session: this._kernel.clientId,
            content: {
                comm_id: this._id,
                target_name: this._target,
                data: data !== null && data !== void 0 ? data : {}
            },
            metadata,
            buffers
        });
        return this._kernel.sendShellMessage(msg, false, true);
    }
    /**
     * Send a `comm_msg` message to the kernel.
     *
     * #### Notes
     * This is a no-op if the comm has been closed.
     *
     * **See also:** [[ICommMsg]]
     */
    send(data, metadata, buffers = [], disposeOnDone = true) {
        if (this.isDisposed || this._kernel.isDisposed) {
            throw new Error('Cannot send');
        }
        const msg = KernelMessage.createMessage({
            msgType: 'comm_msg',
            channel: 'shell',
            username: this._kernel.username,
            session: this._kernel.clientId,
            content: {
                comm_id: this._id,
                data: data
            },
            metadata,
            buffers
        });
        return this._kernel.sendShellMessage(msg, false, disposeOnDone);
    }
    /**
     * Close the comm.
     *
     * #### Notes
     * This will send a `comm_close` message to the kernel, and call the
     * `onClose` callback if set.
     *
     * This is a no-op if the comm is already closed.
     *
     * **See also:** [[ICommClose]], [[onClose]]
     */
    close(data, metadata, buffers = []) {
        if (this.isDisposed || this._kernel.isDisposed) {
            throw new Error('Cannot close');
        }
        const msg = KernelMessage.createMessage({
            msgType: 'comm_close',
            channel: 'shell',
            username: this._kernel.username,
            session: this._kernel.clientId,
            content: {
                comm_id: this._id,
                data: data !== null && data !== void 0 ? data : {}
            },
            metadata,
            buffers
        });
        const future = this._kernel.sendShellMessage(msg, false, true);
        const onClose = this._onClose;
        if (onClose) {
            const ioMsg = KernelMessage.createMessage({
                msgType: 'comm_close',
                channel: 'iopub',
                username: this._kernel.username,
                session: this._kernel.clientId,
                content: {
                    comm_id: this._id,
                    data: data !== null && data !== void 0 ? data : {}
                },
                metadata,
                buffers
            });
            // In the future, we may want to communicate back to the user the possible
            // promise returned from onClose.
            void onClose(ioMsg);
        }
        this.dispose();
        return future;
    }
}
exports.CommHandler = CommHandler;
//# sourceMappingURL=comm.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernel/default.js":
/*!******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernel/default.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KernelConnection = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const coreutils_2 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "../node_modules/@jupyterlab/services/lib/index.js");
const comm_1 = __webpack_require__(/*! ./comm */ "../node_modules/@jupyterlab/services/lib/kernel/comm.js");
const KernelMessage = __importStar(__webpack_require__(/*! ./messages */ "../node_modules/@jupyterlab/services/lib/kernel/messages.js"));
const future_1 = __webpack_require__(/*! ./future */ "../node_modules/@jupyterlab/services/lib/kernel/future.js");
const validate = __importStar(__webpack_require__(/*! ./validate */ "../node_modules/@jupyterlab/services/lib/kernel/validate.js"));
const kernelspec_1 = __webpack_require__(/*! ../kernelspec */ "../node_modules/@jupyterlab/services/lib/kernelspec/index.js");
const restapi = __importStar(__webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/kernel/restapi.js"));
const KERNEL_INFO_TIMEOUT = 3000;
const RESTARTING_KERNEL_SESSION = '_RESTARTING_';
const STARTING_KERNEL_SESSION = '';
/**
 * Implementation of the Kernel object.
 *
 * #### Notes
 * Messages from the server are handled in the order they were received and
 * asynchronously. Any message handler can return a promise, and message
 * handling will pause until the promise is fulfilled.
 */
class KernelConnection {
    /**
     * Construct a kernel object.
     */
    constructor(options) {
        var _a, _b, _c, _d;
        /**
         * Create the kernel websocket connection and add socket status handlers.
         */
        this._createSocket = (useProtocols = true) => {
            this._errorIfDisposed();
            // Make sure the socket is clear
            this._clearSocket();
            // Update the connection status to reflect opening a new connection.
            this._updateConnectionStatus('connecting');
            const settings = this.serverSettings;
            const partialUrl = coreutils_1.URLExt.join(settings.wsUrl, restapi.KERNEL_SERVICE_URL, encodeURIComponent(this._id));
            // Strip any authentication from the display string.
            const display = partialUrl.replace(/^((?:\w+:)?\/\/)(?:[^@\/]+@)/, '$1');
            console.debug(`Starting WebSocket: ${display}`);
            let url = coreutils_1.URLExt.join(partialUrl, 'channels?session_id=' + encodeURIComponent(this._clientId));
            // If token authentication is in use.
            const token = settings.token;
            if (settings.appendToken && token !== '') {
                url = url + `&token=${encodeURIComponent(token)}`;
            }
            // Try opening the websocket with our list of subprotocols.
            // If the server doesn't handle subprotocols,
            // the accepted protocol will be ''.
            // But we cannot send '' as a subprotocol, so if connection fails,
            // reconnect without subprotocols.
            const supportedProtocols = useProtocols ? this._supportedProtocols : [];
            this._ws = new settings.WebSocket(url, supportedProtocols);
            // Ensure incoming binary messages are not Blobs
            this._ws.binaryType = 'arraybuffer';
            let alreadyCalledOnclose = false;
            const getKernelModel = async (evt) => {
                var _a, _b;
                if (this._isDisposed) {
                    return;
                }
                this._reason = '';
                this._model = undefined;
                try {
                    const model = await restapi.getKernelModel(this._id, settings);
                    this._model = model;
                    if ((model === null || model === void 0 ? void 0 : model.execution_state) === 'dead') {
                        this._updateStatus('dead');
                    }
                    else {
                        this._onWSClose(evt);
                    }
                }
                catch (err) {
                    // Try again, if there is a network failure
                    // Handle network errors, as well as cases where we are on a
                    // JupyterHub and the server is not running. JupyterHub returns a
                    // 503 (<2.0) or 424 (>2.0) in that case.
                    if (err instanceof __1.ServerConnection.NetworkError ||
                        ((_a = err.response) === null || _a === void 0 ? void 0 : _a.status) === 503 ||
                        ((_b = err.response) === null || _b === void 0 ? void 0 : _b.status) === 424) {
                        const timeout = Private.getRandomIntInclusive(10, 30) * 1e3;
                        setTimeout(getKernelModel, timeout, evt);
                    }
                    else {
                        this._reason = 'Kernel died unexpectedly';
                        this._updateStatus('dead');
                    }
                }
                return;
            };
            const earlyClose = async (evt) => {
                // If the websocket was closed early, that could mean
                // that the kernel is actually dead. Try getting
                // information about the kernel from the API call,
                // if that fails, then assume the kernel is dead,
                // otherwise just follow the typical websocket closed
                // protocol.
                if (alreadyCalledOnclose) {
                    return;
                }
                alreadyCalledOnclose = true;
                await getKernelModel(evt);
                return;
            };
            this._ws.onmessage = this._onWSMessage;
            this._ws.onopen = this._onWSOpen;
            this._ws.onclose = earlyClose;
            this._ws.onerror = earlyClose;
        };
        // Make websocket callbacks arrow functions so they bind `this`.
        /**
         * Handle a websocket open event.
         */
        this._onWSOpen = (evt) => {
            if (this._ws.protocol !== '' &&
                !this._supportedProtocols.includes(this._ws.protocol)) {
                console.log('Server selected unknown kernel wire protocol:', this._ws.protocol);
                this._updateStatus('dead');
                throw new Error(`Unknown kernel wire protocol:  ${this._ws.protocol}`);
            }
            // Remember the kernel wire protocol selected by the server.
            this._selectedProtocol = this._ws.protocol;
            this._ws.onclose = this._onWSClose;
            this._ws.onerror = this._onWSClose;
            this._updateConnectionStatus('connected');
        };
        /**
         * Handle a websocket message, validating and routing appropriately.
         */
        this._onWSMessage = (evt) => {
            // Notify immediately if there is an error with the message.
            let msg;
            try {
                msg = this.serverSettings.serializer.deserialize(evt.data, this._ws.protocol);
                validate.validateMessage(msg);
            }
            catch (error) {
                error.message = `Kernel message validation error: ${error.message}`;
                // We throw the error so that it bubbles up to the top, and displays the right stack.
                throw error;
            }
            // Update the current kernel session id
            this._kernelSession = msg.header.session;
            // Handle the message asynchronously, in the order received.
            this._msgChain = this._msgChain
                .then(() => {
                // Return so that any promises from handling a message are fulfilled
                // before proceeding to the next message.
                return this._handleMessage(msg);
            })
                .catch(error => {
                // Log any errors in handling the message, thus resetting the _msgChain
                // promise so we can process more messages.
                // Ignore the "Canceled" errors that are thrown during kernel dispose.
                if (error.message.startsWith('Canceled future for ')) {
                    console.error(error);
                }
            });
            // Emit the message receive signal
            this._anyMessage.emit({ msg, direction: 'recv' });
        };
        /**
         * Handle a websocket close event.
         */
        this._onWSClose = (evt) => {
            if (!this.isDisposed) {
                this._reconnect();
            }
        };
        this._id = '';
        this._name = '';
        this._status = 'unknown';
        this._connectionStatus = 'connecting';
        this._kernelSession = '';
        this._isDisposed = false;
        /**
         * Websocket to communicate with kernel.
         */
        this._ws = null;
        this._username = '';
        this._reconnectLimit = 7;
        this._reconnectAttempt = 0;
        this._reconnectTimeout = null;
        this._supportedProtocols = Object.values(KernelMessage.supportedKernelWebSocketProtocols);
        this._selectedProtocol = '';
        this._futures = new Map();
        this._comms = new Map();
        this._targetRegistry = Object.create(null);
        this._info = new coreutils_2.PromiseDelegate();
        this._pendingMessages = [];
        this._statusChanged = new signaling_1.Signal(this);
        this._connectionStatusChanged = new signaling_1.Signal(this);
        this._disposed = new signaling_1.Signal(this);
        this._iopubMessage = new signaling_1.Signal(this);
        this._anyMessage = new signaling_1.Signal(this);
        this._pendingInput = new signaling_1.Signal(this);
        this._unhandledMessage = new signaling_1.Signal(this);
        this._displayIdToParentIds = new Map();
        this._msgIdToDisplayIds = new Map();
        this._msgChain = Promise.resolve();
        this._hasPendingInput = false;
        this._reason = '';
        this._noOp = () => {
            /* no-op */
        };
        this._name = options.model.name;
        this._id = options.model.id;
        this.serverSettings =
            (_a = options.serverSettings) !== null && _a !== void 0 ? _a : __1.ServerConnection.makeSettings();
        this._clientId = (_b = options.clientId) !== null && _b !== void 0 ? _b : coreutils_2.UUID.uuid4();
        this._username = (_c = options.username) !== null && _c !== void 0 ? _c : '';
        this.handleComms = (_d = options.handleComms) !== null && _d !== void 0 ? _d : true;
        this._createSocket();
    }
    get disposed() {
        return this._disposed;
    }
    /**
     * A signal emitted when the kernel status changes.
     */
    get statusChanged() {
        return this._statusChanged;
    }
    /**
     * A signal emitted when the kernel status changes.
     */
    get connectionStatusChanged() {
        return this._connectionStatusChanged;
    }
    /**
     * A signal emitted for iopub kernel messages.
     *
     * #### Notes
     * This signal is emitted after the iopub message is handled asynchronously.
     */
    get iopubMessage() {
        return this._iopubMessage;
    }
    /**
     * A signal emitted for unhandled kernel message.
     *
     * #### Notes
     * This signal is emitted for a message that was not handled. It is emitted
     * during the asynchronous message handling code.
     */
    get unhandledMessage() {
        return this._unhandledMessage;
    }
    /**
     * The kernel model
     */
    get model() {
        return (this._model || {
            id: this.id,
            name: this.name,
            reason: this._reason
        });
    }
    /**
     * A signal emitted for any kernel message.
     *
     * #### Notes
     * This signal is emitted when a message is received, before it is handled
     * asynchronously.
     *
     * This message is emitted when a message is queued for sending (either in
     * the websocket buffer, or our own pending message buffer). The message may
     * actually be sent across the wire at a later time.
     *
     * The message emitted in this signal should not be modified in any way.
     */
    get anyMessage() {
        return this._anyMessage;
    }
    /**
     * A signal emitted when a kernel has pending inputs from the user.
     */
    get pendingInput() {
        return this._pendingInput;
    }
    /**
     * The id of the server-side kernel.
     */
    get id() {
        return this._id;
    }
    /**
     * The name of the server-side kernel.
     */
    get name() {
        return this._name;
    }
    /**
     * The client username.
     */
    get username() {
        return this._username;
    }
    /**
     * The client unique id.
     */
    get clientId() {
        return this._clientId;
    }
    /**
     * The current status of the kernel.
     */
    get status() {
        return this._status;
    }
    /**
     * The current connection status of the kernel connection.
     */
    get connectionStatus() {
        return this._connectionStatus;
    }
    /**
     * Test whether the kernel has been disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * The cached kernel info.
     *
     * @returns A promise that resolves to the kernel info.
     */
    get info() {
        return this._info.promise;
    }
    /**
     * The kernel spec.
     *
     * @returns A promise that resolves to the kernel spec.
     */
    get spec() {
        if (this._specPromise) {
            return this._specPromise;
        }
        this._specPromise = kernelspec_1.KernelSpecAPI.getSpecs(this.serverSettings).then(specs => {
            return specs.kernelspecs[this._name];
        });
        return this._specPromise;
    }
    /**
     * Clone the current kernel with a new clientId.
     */
    clone(options = {}) {
        return new KernelConnection({
            model: this.model,
            username: this.username,
            serverSettings: this.serverSettings,
            // handleComms defaults to false since that is safer
            handleComms: false,
            ...options
        });
    }
    /**
     * Dispose of the resources held by the kernel.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._disposed.emit();
        this._updateConnectionStatus('disconnected');
        this._clearKernelState();
        this._pendingMessages = [];
        this._clearSocket();
        // Clear Lumino signals
        signaling_1.Signal.clearData(this);
    }
    /**
     * Send a shell message to the kernel.
     *
     * #### Notes
     * Send a message to the kernel's shell channel, yielding a future object
     * for accepting replies.
     *
     * If `expectReply` is given and `true`, the future is disposed when both a
     * shell reply and an idle status message are received. If `expectReply`
     * is not given or is `false`, the future is resolved when an idle status
     * message is received.
     * If `disposeOnDone` is not given or is `true`, the Future is disposed at this point.
     * If `disposeOnDone` is given and `false`, it is up to the caller to dispose of the Future.
     *
     * All replies are validated as valid kernel messages.
     *
     * If the kernel status is `dead`, this will throw an error.
     */
    sendShellMessage(msg, expectReply = false, disposeOnDone = true) {
        return this._sendKernelShellControl(future_1.KernelShellFutureHandler, msg, expectReply, disposeOnDone);
    }
    /**
     * Send a control message to the kernel.
     *
     * #### Notes
     * Send a message to the kernel's control channel, yielding a future object
     * for accepting replies.
     *
     * If `expectReply` is given and `true`, the future is disposed when both a
     * control reply and an idle status message are received. If `expectReply`
     * is not given or is `false`, the future is resolved when an idle status
     * message is received.
     * If `disposeOnDone` is not given or is `true`, the Future is disposed at this point.
     * If `disposeOnDone` is given and `false`, it is up to the caller to dispose of the Future.
     *
     * All replies are validated as valid kernel messages.
     *
     * If the kernel status is `dead`, this will throw an error.
     */
    sendControlMessage(msg, expectReply = false, disposeOnDone = true) {
        return this._sendKernelShellControl(future_1.KernelControlFutureHandler, msg, expectReply, disposeOnDone);
    }
    _sendKernelShellControl(ctor, msg, expectReply = false, disposeOnDone = true) {
        this._sendMessage(msg);
        this._anyMessage.emit({ msg, direction: 'send' });
        const future = new ctor(() => {
            const msgId = msg.header.msg_id;
            this._futures.delete(msgId);
            // Remove stored display id information.
            const displayIds = this._msgIdToDisplayIds.get(msgId);
            if (!displayIds) {
                return;
            }
            displayIds.forEach(displayId => {
                const msgIds = this._displayIdToParentIds.get(displayId);
                if (msgIds) {
                    const idx = msgIds.indexOf(msgId);
                    if (idx === -1) {
                        return;
                    }
                    if (msgIds.length === 1) {
                        this._displayIdToParentIds.delete(displayId);
                    }
                    else {
                        msgIds.splice(idx, 1);
                        this._displayIdToParentIds.set(displayId, msgIds);
                    }
                }
            });
            this._msgIdToDisplayIds.delete(msgId);
        }, msg, expectReply, disposeOnDone, this);
        this._futures.set(msg.header.msg_id, future);
        return future;
    }
    /**
     * Send a message on the websocket.
     *
     * If queue is true, queue the message for later sending if we cannot send
     * now. Otherwise throw an error.
     *
     * #### Notes
     * As an exception to the queueing, if we are sending a kernel_info_request
     * message while we think the kernel is restarting, we send the message
     * immediately without queueing. This is so that we can trigger a message
     * back, which will then clear the kernel restarting state.
     */
    _sendMessage(msg, queue = true) {
        if (this.status === 'dead') {
            throw new Error('Kernel is dead');
        }
        // If we have a kernel_info_request and we are starting or restarting, send the
        // kernel_info_request immediately if we can, and if not throw an error so
        // we can retry later. On restarting we do this because we must get at least one message
        // from the kernel to reset the kernel session (thus clearing the restart
        // status sentinel).
        if ((this._kernelSession === STARTING_KERNEL_SESSION ||
            this._kernelSession === RESTARTING_KERNEL_SESSION) &&
            KernelMessage.isInfoRequestMsg(msg)) {
            if (this.connectionStatus === 'connected') {
                this._ws.send(this.serverSettings.serializer.serialize(msg, this._ws.protocol));
                return;
            }
            else {
                throw new Error('Could not send message: status is not connected');
            }
        }
        // If there are pending messages, add to the queue so we keep messages in order
        if (queue && this._pendingMessages.length > 0) {
            this._pendingMessages.push(msg);
            return;
        }
        // Send if the ws allows it, otherwise queue the message.
        if (this.connectionStatus === 'connected' &&
            this._kernelSession !== RESTARTING_KERNEL_SESSION) {
            this._ws.send(this.serverSettings.serializer.serialize(msg, this._ws.protocol));
        }
        else if (queue) {
            this._pendingMessages.push(msg);
        }
        else {
            throw new Error('Could not send message');
        }
    }
    /**
     * Interrupt a kernel.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels).
     *
     * The promise is fulfilled on a valid response and rejected otherwise.
     *
     * It is assumed that the API call does not mutate the kernel id or name.
     *
     * The promise will be rejected if the kernel status is `Dead` or if the
     * request fails or the response is invalid.
     */
    async interrupt() {
        this.hasPendingInput = false;
        if (this.status === 'dead') {
            throw new Error('Kernel is dead');
        }
        return restapi.interruptKernel(this.id, this.serverSettings);
    }
    /**
     * Request a kernel restart.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels)
     * and validates the response model.
     *
     * Any existing Future or Comm objects are cleared once the kernel has
     * actually be restarted.
     *
     * The promise is fulfilled on a valid server response (after the kernel restarts)
     * and rejected otherwise.
     *
     * It is assumed that the API call does not mutate the kernel id or name.
     *
     * The promise will be rejected if the request fails or the response is
     * invalid.
     */
    async restart() {
        if (this.status === 'dead') {
            throw new Error('Kernel is dead');
        }
        this._updateStatus('restarting');
        this._clearKernelState();
        this._kernelSession = RESTARTING_KERNEL_SESSION;
        await restapi.restartKernel(this.id, this.serverSettings);
        // Reconnect to the kernel to address cases where kernel ports
        // have changed during the restart.
        await this.reconnect();
        this.hasPendingInput = false;
    }
    /**
     * Reconnect to a kernel.
     *
     * #### Notes
     * This may try multiple times to reconnect to a kernel, and will sever any
     * existing connection.
     */
    reconnect() {
        this._errorIfDisposed();
        const result = new coreutils_2.PromiseDelegate();
        // Set up a listener for the connection status changing, which accepts or
        // rejects after the retries are done.
        const fulfill = (sender, status) => {
            if (status === 'connected') {
                result.resolve();
                this.connectionStatusChanged.disconnect(fulfill, this);
            }
            else if (status === 'disconnected') {
                result.reject(new Error('Kernel connection disconnected'));
                this.connectionStatusChanged.disconnect(fulfill, this);
            }
        };
        this.connectionStatusChanged.connect(fulfill, this);
        // Reset the reconnect limit so we start the connection attempts fresh
        this._reconnectAttempt = 0;
        // Start the reconnection process, which will also clear any existing
        // connection.
        this._reconnect();
        // Return the promise that should resolve on connection or reject if the
        // retries don't work.
        return result.promise;
    }
    /**
     * Shutdown a kernel.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels).
     *
     * The promise is fulfilled on a valid response and rejected otherwise.
     *
     * On a valid response, disposes this kernel connection.
     *
     * If the kernel is already `dead`, disposes this kernel connection without
     * a server request.
     */
    async shutdown() {
        if (this.status !== 'dead') {
            await restapi.shutdownKernel(this.id, this.serverSettings);
        }
        this.handleShutdown();
    }
    /**
     * Handles a kernel shutdown.
     *
     * #### Notes
     * This method should be called if we know from outside information that a
     * kernel is dead (for example, we cannot find the kernel model on the
     * server).
     */
    handleShutdown() {
        this._updateStatus('dead');
        this.dispose();
    }
    /**
     * Send a `kernel_info_request` message.
     *
     * #### Notes
     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#kernel-info).
     *
     * Fulfills with the `kernel_info_response` content when the shell reply is
     * received and validated.
     */
    async requestKernelInfo() {
        const msg = KernelMessage.createMessage({
            msgType: 'kernel_info_request',
            channel: 'shell',
            username: this._username,
            session: this._clientId,
            content: {}
        });
        let reply;
        try {
            reply = (await Private.handleShellMessage(this, msg));
        }
        catch (e) {
            // If we rejected because the future was disposed, ignore and return.
            if (this.isDisposed) {
                return;
            }
            else {
                throw e;
            }
        }
        this._errorIfDisposed();
        if (!reply) {
            return;
        }
        // Kernels sometimes do not include a status field on kernel_info_reply
        // messages, so set a default for now.
        // See https://github.com/jupyterlab/jupyterlab/issues/6760
        if (reply.content.status === undefined) {
            reply.content.status = 'ok';
        }
        if (reply.content.status !== 'ok') {
            this._info.reject('Kernel info reply errored');
            return reply;
        }
        this._info.resolve(reply.content);
        this._kernelSession = reply.header.session;
        return reply;
    }
    /**
     * Send a `complete_request` message.
     *
     * #### Notes
     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#completion).
     *
     * Fulfills with the `complete_reply` content when the shell reply is
     * received and validated.
     */
    requestComplete(content) {
        const msg = KernelMessage.createMessage({
            msgType: 'complete_request',
            channel: 'shell',
            username: this._username,
            session: this._clientId,
            content
        });
        return Private.handleShellMessage(this, msg);
    }
    /**
     * Send an `inspect_request` message.
     *
     * #### Notes
     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#introspection).
     *
     * Fulfills with the `inspect_reply` content when the shell reply is
     * received and validated.
     */
    requestInspect(content) {
        const msg = KernelMessage.createMessage({
            msgType: 'inspect_request',
            channel: 'shell',
            username: this._username,
            session: this._clientId,
            content: content
        });
        return Private.handleShellMessage(this, msg);
    }
    /**
     * Send a `history_request` message.
     *
     * #### Notes
     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#history).
     *
     * Fulfills with the `history_reply` content when the shell reply is
     * received and validated.
     */
    requestHistory(content) {
        const msg = KernelMessage.createMessage({
            msgType: 'history_request',
            channel: 'shell',
            username: this._username,
            session: this._clientId,
            content
        });
        return Private.handleShellMessage(this, msg);
    }
    /**
     * Send an `execute_request` message.
     *
     * #### Notes
     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#execute).
     *
     * Future `onReply` is called with the `execute_reply` content when the
     * shell reply is received and validated. The future will resolve when
     * this message is received and the `idle` iopub status is received.
     * The future will also be disposed at this point unless `disposeOnDone`
     * is specified and `false`, in which case it is up to the caller to dispose
     * of the future.
     *
     * **See also:** [[IExecuteReply]]
     */
    requestExecute(content, disposeOnDone = true, metadata) {
        const defaults = {
            silent: false,
            store_history: true,
            user_expressions: {},
            allow_stdin: true,
            stop_on_error: false
        };
        const msg = KernelMessage.createMessage({
            msgType: 'execute_request',
            channel: 'shell',
            username: this._username,
            session: this._clientId,
            content: { ...defaults, ...content },
            metadata
        });
        return this.sendShellMessage(msg, true, disposeOnDone);
    }
    /**
     * Send an experimental `debug_request` message.
     *
     * @hidden
     *
     * #### Notes
     * Debug messages are experimental messages that are not in the official
     * kernel message specification. As such, this function is *NOT* considered
     * part of the public API, and may change without notice.
     */
    requestDebug(content, disposeOnDone = true) {
        const msg = KernelMessage.createMessage({
            msgType: 'debug_request',
            channel: 'control',
            username: this._username,
            session: this._clientId,
            content
        });
        return this.sendControlMessage(msg, true, disposeOnDone);
    }
    /**
     * Send an `is_complete_request` message.
     *
     * #### Notes
     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#code-completeness).
     *
     * Fulfills with the `is_complete_response` content when the shell reply is
     * received and validated.
     */
    requestIsComplete(content) {
        const msg = KernelMessage.createMessage({
            msgType: 'is_complete_request',
            channel: 'shell',
            username: this._username,
            session: this._clientId,
            content
        });
        return Private.handleShellMessage(this, msg);
    }
    /**
     * Send a `comm_info_request` message.
     *
     * #### Notes
     * Fulfills with the `comm_info_reply` content when the shell reply is
     * received and validated.
     */
    requestCommInfo(content) {
        const msg = KernelMessage.createMessage({
            msgType: 'comm_info_request',
            channel: 'shell',
            username: this._username,
            session: this._clientId,
            content
        });
        return Private.handleShellMessage(this, msg);
    }
    /**
     * Send an `input_reply` message.
     *
     * #### Notes
     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#messages-on-the-stdin-router-dealer-sockets).
     */
    sendInputReply(content, parent_header) {
        const msg = KernelMessage.createMessage({
            msgType: 'input_reply',
            channel: 'stdin',
            username: this._username,
            session: this._clientId,
            content
        });
        msg.parent_header = parent_header;
        this._sendMessage(msg);
        this._anyMessage.emit({ msg, direction: 'send' });
        this.hasPendingInput = false;
    }
    /**
     * Create a new comm.
     *
     * #### Notes
     * If a client-side comm already exists with the given commId, an error is thrown.
     * If the kernel does not handle comms, an error is thrown.
     */
    createComm(targetName, commId = coreutils_2.UUID.uuid4()) {
        if (!this.handleComms) {
            throw new Error('Comms are disabled on this kernel connection');
        }
        if (this._comms.has(commId)) {
            throw new Error('Comm is already created');
        }
        const comm = new comm_1.CommHandler(targetName, commId, this, () => {
            this._unregisterComm(commId);
        });
        this._comms.set(commId, comm);
        return comm;
    }
    /**
     * Check if a comm exists.
     */
    hasComm(commId) {
        return this._comms.has(commId);
    }
    /**
     * Register a comm target handler.
     *
     * @param targetName - The name of the comm target.
     *
     * @param callback - The callback invoked for a comm open message.
     *
     * @returns A disposable used to unregister the comm target.
     *
     * #### Notes
     * Only one comm target can be registered to a target name at a time, an
     * existing callback for the same target name will be overridden.  A registered
     * comm target handler will take precedence over a comm which specifies a
     * `target_module`.
     *
     * If the callback returns a promise, kernel message processing will pause
     * until the returned promise is fulfilled.
     */
    registerCommTarget(targetName, callback) {
        if (!this.handleComms) {
            return;
        }
        this._targetRegistry[targetName] = callback;
    }
    /**
     * Remove a comm target handler.
     *
     * @param targetName - The name of the comm target to remove.
     *
     * @param callback - The callback to remove.
     *
     * #### Notes
     * The comm target is only removed if the callback argument matches.
     */
    removeCommTarget(targetName, callback) {
        if (!this.handleComms) {
            return;
        }
        if (!this.isDisposed && this._targetRegistry[targetName] === callback) {
            delete this._targetRegistry[targetName];
        }
    }
    /**
     * Register an IOPub message hook.
     *
     * @param msg_id - The parent_header message id the hook will intercept.
     *
     * @param hook - The callback invoked for the message.
     *
     * #### Notes
     * The IOPub hook system allows you to preempt the handlers for IOPub
     * messages that are responses to a given message id.
     *
     * The most recently registered hook is run first. A hook can return a
     * boolean or a promise to a boolean, in which case all kernel message
     * processing pauses until the promise is fulfilled. If a hook return value
     * resolves to false, any later hooks will not run and the function will
     * return a promise resolving to false. If a hook throws an error, the error
     * is logged to the console and the next hook is run. If a hook is
     * registered during the hook processing, it will not run until the next
     * message. If a hook is removed during the hook processing, it will be
     * deactivated immediately.
     *
     * See also [[IFuture.registerMessageHook]].
     */
    registerMessageHook(msgId, hook) {
        var _a;
        const future = (_a = this._futures) === null || _a === void 0 ? void 0 : _a.get(msgId);
        if (future) {
            future.registerMessageHook(hook);
        }
    }
    /**
     * Remove an IOPub message hook.
     *
     * @param msg_id - The parent_header message id the hook intercepted.
     *
     * @param hook - The callback invoked for the message.
     *
     */
    removeMessageHook(msgId, hook) {
        var _a;
        const future = (_a = this._futures) === null || _a === void 0 ? void 0 : _a.get(msgId);
        if (future) {
            future.removeMessageHook(hook);
        }
    }
    /**
     * Remove the input guard, if any.
     */
    removeInputGuard() {
        this.hasPendingInput = false;
    }
    /**
     * Handle a message with a display id.
     *
     * @returns Whether the message was handled.
     */
    async _handleDisplayId(displayId, msg) {
        var _a, _b;
        const msgId = msg.parent_header.msg_id;
        let parentIds = this._displayIdToParentIds.get(displayId);
        if (parentIds) {
            // We've seen it before, update existing outputs with same display_id
            // by handling display_data as update_display_data.
            const updateMsg = {
                header: coreutils_2.JSONExt.deepCopy(msg.header),
                parent_header: coreutils_2.JSONExt.deepCopy(msg.parent_header),
                metadata: coreutils_2.JSONExt.deepCopy(msg.metadata),
                content: coreutils_2.JSONExt.deepCopy(msg.content),
                channel: msg.channel,
                buffers: msg.buffers ? msg.buffers.slice() : []
            };
            updateMsg.header.msg_type = 'update_display_data';
            await Promise.all(parentIds.map(async (parentId) => {
                const future = this._futures && this._futures.get(parentId);
                if (future) {
                    await future.handleMsg(updateMsg);
                }
            }));
        }
        // We're done here if it's update_display.
        if (msg.header.msg_type === 'update_display_data') {
            // It's an update, don't proceed to the normal display.
            return true;
        }
        // Regular display_data with id, record it for future updating
        // in _displayIdToParentIds for future lookup.
        parentIds = (_a = this._displayIdToParentIds.get(displayId)) !== null && _a !== void 0 ? _a : [];
        if (parentIds.indexOf(msgId) === -1) {
            parentIds.push(msgId);
        }
        this._displayIdToParentIds.set(displayId, parentIds);
        // Add to our map of display ids for this message.
        const displayIds = (_b = this._msgIdToDisplayIds.get(msgId)) !== null && _b !== void 0 ? _b : [];
        if (displayIds.indexOf(msgId) === -1) {
            displayIds.push(msgId);
        }
        this._msgIdToDisplayIds.set(msgId, displayIds);
        // Let the message propagate to the intended recipient.
        return false;
    }
    /**
     * Forcefully clear the socket state.
     *
     * #### Notes
     * This will clear all socket state without calling any handlers and will
     * not update the connection status. If you call this method, you are
     * responsible for updating the connection status as needed and recreating
     * the socket if you plan to reconnect.
     */
    _clearSocket() {
        if (this._ws !== null) {
            // Clear the websocket event handlers and the socket itself.
            this._ws.onopen = this._noOp;
            this._ws.onclose = this._noOp;
            this._ws.onerror = this._noOp;
            this._ws.onmessage = this._noOp;
            this._ws.close();
            this._ws = null;
        }
    }
    /**
     * Handle status iopub messages from the kernel.
     */
    _updateStatus(status) {
        if (this._status === status || this._status === 'dead') {
            return;
        }
        this._status = status;
        Private.logKernelStatus(this);
        this._statusChanged.emit(status);
        if (status === 'dead') {
            this.dispose();
        }
    }
    /**
     * Send pending messages to the kernel.
     */
    _sendPending() {
        // We check to make sure we are still connected each time. For
        // example, if a websocket buffer overflows, it may close, so we should
        // stop sending messages.
        while (this.connectionStatus === 'connected' &&
            this._kernelSession !== RESTARTING_KERNEL_SESSION &&
            this._pendingMessages.length > 0) {
            this._sendMessage(this._pendingMessages[0], false);
            // We shift the message off the queue after the message is sent so that
            // if there is an exception, the message is still pending.
            this._pendingMessages.shift();
        }
    }
    /**
     * Clear the internal state.
     */
    _clearKernelState() {
        this._kernelSession = '';
        this._pendingMessages = [];
        this._futures.forEach(future => {
            future.dispose();
        });
        this._comms.forEach(comm => {
            comm.dispose();
        });
        this._msgChain = Promise.resolve();
        this._futures = new Map();
        this._comms = new Map();
        this._displayIdToParentIds.clear();
        this._msgIdToDisplayIds.clear();
    }
    /**
     * Check to make sure it is okay to proceed to handle a message.
     *
     * #### Notes
     * Because we handle messages asynchronously, before a message is handled the
     * kernel might be disposed or restarted (and have a different session id).
     * This function throws an error in each of these cases. This is meant to be
     * called at the start of an asynchronous message handler to cancel message
     * processing if the message no longer is valid.
     */
    _assertCurrentMessage(msg) {
        this._errorIfDisposed();
        if (msg.header.session !== this._kernelSession) {
            throw new Error(`Canceling handling of old message: ${msg.header.msg_type}`);
        }
    }
    /**
     * Handle a `comm_open` kernel message.
     */
    async _handleCommOpen(msg) {
        this._assertCurrentMessage(msg);
        const content = msg.content;
        const comm = new comm_1.CommHandler(content.target_name, content.comm_id, this, () => {
            this._unregisterComm(content.comm_id);
        });
        this._comms.set(content.comm_id, comm);
        try {
            const target = await Private.loadObject(content.target_name, content.target_module, this._targetRegistry);
            await target(comm, msg);
        }
        catch (e) {
            // Close the comm asynchronously. We cannot block message processing on
            // kernel messages to wait for another kernel message.
            comm.close();
            console.error('Exception opening new comm');
            throw e;
        }
    }
    /**
     * Handle 'comm_close' kernel message.
     */
    async _handleCommClose(msg) {
        this._assertCurrentMessage(msg);
        const content = msg.content;
        const comm = this._comms.get(content.comm_id);
        if (!comm) {
            console.error('Comm not found for comm id ' + content.comm_id);
            return;
        }
        this._unregisterComm(comm.commId);
        const onClose = comm.onClose;
        if (onClose) {
            // tslint:disable-next-line:await-promise
            await onClose(msg);
        }
        comm.dispose();
    }
    /**
     * Handle a 'comm_msg' kernel message.
     */
    async _handleCommMsg(msg) {
        this._assertCurrentMessage(msg);
        const content = msg.content;
        const comm = this._comms.get(content.comm_id);
        if (!comm) {
            return;
        }
        const onMsg = comm.onMsg;
        if (onMsg) {
            // tslint:disable-next-line:await-promise
            await onMsg(msg);
        }
    }
    /**
     * Unregister a comm instance.
     */
    _unregisterComm(commId) {
        this._comms.delete(commId);
    }
    /**
     * Handle connection status changes.
     */
    _updateConnectionStatus(connectionStatus) {
        if (this._connectionStatus === connectionStatus) {
            return;
        }
        this._connectionStatus = connectionStatus;
        // If we are not 'connecting', reset any reconnection attempts.
        if (connectionStatus !== 'connecting') {
            this._reconnectAttempt = 0;
            clearTimeout(this._reconnectTimeout);
        }
        if (this.status !== 'dead') {
            if (connectionStatus === 'connected') {
                let restarting = this._kernelSession === RESTARTING_KERNEL_SESSION;
                // Send a kernel info request to make sure we send at least one
                // message to get kernel status back. Always request kernel info
                // first, to get kernel status back and ensure iopub is fully
                // established. If we are restarting, this message will skip the queue
                // and be sent immediately.
                let p = this.requestKernelInfo();
                // Send any pending messages after the kernelInfo resolves, or after a
                // timeout as a failsafe.
                let sendPendingCalled = false;
                let sendPendingOnce = () => {
                    if (sendPendingCalled) {
                        return;
                    }
                    sendPendingCalled = true;
                    if (restarting && this._kernelSession === RESTARTING_KERNEL_SESSION) {
                        // We were restarting and a message didn't arrive to set the
                        // session, but we just assume the restart succeeded and send any
                        // pending messages.
                        // FIXME: it would be better to retry the kernel_info_request here
                        this._kernelSession = '';
                    }
                    clearTimeout(timeoutHandle);
                    if (this._pendingMessages.length > 0) {
                        this._sendPending();
                    }
                };
                void p.then(sendPendingOnce);
                // FIXME: if sent while zmq subscriptions are not established,
                // kernelInfo may not resolve, so use a timeout to ensure we don't hang forever.
                // It may be preferable to retry kernelInfo rather than give up after one timeout.
                let timeoutHandle = setTimeout(sendPendingOnce, KERNEL_INFO_TIMEOUT);
            }
            else {
                // If the connection is down, then we do not know what is happening
                // with the kernel, so set the status to unknown.
                this._updateStatus('unknown');
            }
        }
        // Notify others that the connection status changed.
        this._connectionStatusChanged.emit(connectionStatus);
    }
    async _handleMessage(msg) {
        var _a, _b;
        let handled = false;
        // Check to see if we have a display_id we need to reroute.
        if (msg.parent_header &&
            msg.channel === 'iopub' &&
            (KernelMessage.isDisplayDataMsg(msg) ||
                KernelMessage.isUpdateDisplayDataMsg(msg) ||
                KernelMessage.isExecuteResultMsg(msg))) {
            // display_data messages may re-route based on their display_id.
            const transient = ((_a = msg.content.transient) !== null && _a !== void 0 ? _a : {});
            const displayId = transient['display_id'];
            if (displayId) {
                handled = await this._handleDisplayId(displayId, msg);
                // The await above may make this message out of date, so check again.
                this._assertCurrentMessage(msg);
            }
        }
        if (!handled && msg.parent_header) {
            const parentHeader = msg.parent_header;
            const future = (_b = this._futures) === null || _b === void 0 ? void 0 : _b.get(parentHeader.msg_id);
            if (future) {
                await future.handleMsg(msg);
                this._assertCurrentMessage(msg);
            }
            else {
                // If the message was sent by us and was not iopub, it is orphaned.
                const owned = parentHeader.session === this.clientId;
                if (msg.channel !== 'iopub' && owned) {
                    this._unhandledMessage.emit(msg);
                }
            }
        }
        if (msg.channel === 'iopub') {
            switch (msg.header.msg_type) {
                case 'status': {
                    // Updating the status is synchronous, and we call no async user code
                    const executionState = msg.content
                        .execution_state;
                    if (executionState === 'restarting') {
                        // The kernel has been auto-restarted by the server. After
                        // processing for this message is completely done, we want to
                        // handle this restart, so we don't await, but instead schedule
                        // the work as a microtask (i.e., in a promise resolution). We
                        // schedule this here so that it comes before any microtasks that
                        // might be scheduled in the status signal emission below.
                        void Promise.resolve().then(async () => {
                            this._updateStatus('autorestarting');
                            this._clearKernelState();
                            // We must reconnect since the kernel connection information may have
                            // changed, and the server only refreshes its zmq connection when a new
                            // websocket is opened.
                            await this.reconnect();
                        });
                    }
                    this._updateStatus(executionState);
                    break;
                }
                case 'comm_open':
                    if (this.handleComms) {
                        await this._handleCommOpen(msg);
                    }
                    break;
                case 'comm_msg':
                    if (this.handleComms) {
                        await this._handleCommMsg(msg);
                    }
                    break;
                case 'comm_close':
                    if (this.handleComms) {
                        await this._handleCommClose(msg);
                    }
                    break;
                default:
                    break;
            }
            // If the message was a status dead message, we might have disposed ourselves.
            if (!this.isDisposed) {
                this._assertCurrentMessage(msg);
                // the message wouldn't be emitted if we were disposed anyway.
                this._iopubMessage.emit(msg);
            }
        }
    }
    /**
     * Attempt a connection if we have not exhausted connection attempts.
     */
    _reconnect() {
        this._errorIfDisposed();
        // Clear any existing reconnection attempt
        clearTimeout(this._reconnectTimeout);
        // Update the connection status and schedule a possible reconnection.
        if (this._reconnectAttempt < this._reconnectLimit) {
            this._updateConnectionStatus('connecting');
            // The first reconnect attempt should happen immediately, and subsequent
            // attempts should pick a random number in a growing range so that we
            // don't overload the server with synchronized reconnection attempts
            // across multiple kernels.
            const timeout = Private.getRandomIntInclusive(0, 1e3 * (Math.pow(2, this._reconnectAttempt) - 1));
            console.warn(`Connection lost, reconnecting in ${Math.floor(timeout / 1000)} seconds.`);
            // Try reconnection with subprotocols if the server had supported them.
            // Otherwise, try reconnection without subprotocols.
            const useProtocols = this._selectedProtocol !== '' ? true : false;
            this._reconnectTimeout = setTimeout(this._createSocket, timeout, useProtocols);
            this._reconnectAttempt += 1;
        }
        else {
            this._updateConnectionStatus('disconnected');
        }
        // Clear the websocket event handlers and the socket itself.
        this._clearSocket();
    }
    /**
     * Utility function to throw an error if this instance is disposed.
     */
    _errorIfDisposed() {
        if (this.isDisposed) {
            throw new Error('Kernel connection is disposed');
        }
    }
    get hasPendingInput() {
        return this._hasPendingInput;
    }
    set hasPendingInput(value) {
        this._hasPendingInput = value;
        this._pendingInput.emit(value);
    }
}
exports.KernelConnection = KernelConnection;
/**
 * A private namespace for the Kernel.
 */
var Private;
(function (Private) {
    /**
     * Log the current kernel status.
     */
    function logKernelStatus(kernel) {
        switch (kernel.status) {
            case 'idle':
            case 'busy':
            case 'unknown':
                return;
            default:
                console.debug(`Kernel: ${kernel.status} (${kernel.id})`);
                break;
        }
    }
    Private.logKernelStatus = logKernelStatus;
    /**
     * Send a kernel message to the kernel and resolve the reply message.
     */
    async function handleShellMessage(kernel, msg) {
        const future = kernel.sendShellMessage(msg, true);
        return future.done;
    }
    Private.handleShellMessage = handleShellMessage;
    /**
     * Try to load an object from a module or a registry.
     *
     * Try to load an object from a module asynchronously if a module
     * is specified, otherwise tries to load an object from the global
     * registry, if the global registry is provided.
     *
     * #### Notes
     * Loading a module uses requirejs.
     */
    function loadObject(name, moduleName, registry) {
        return new Promise((resolve, reject) => {
            // Try loading the module using require.js
            if (moduleName) {
                if (typeof requirejs === 'undefined') {
                    throw new Error('requirejs not found');
                }
                requirejs([moduleName], (mod) => {
                    if (mod[name] === void 0) {
                        const msg = `Object '${name}' not found in module '${moduleName}'`;
                        reject(new Error(msg));
                    }
                    else {
                        resolve(mod[name]);
                    }
                }, reject);
            }
            else {
                if (registry === null || registry === void 0 ? void 0 : registry[name]) {
                    resolve(registry[name]);
                }
                else {
                    reject(new Error(`Object '${name}' not found in registry`));
                }
            }
        });
    }
    Private.loadObject = loadObject;
    /**
     * Get a random integer between min and max, inclusive of both.
     *
     * #### Notes
     * From
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/random#Getting_a_random_integer_between_two_values_inclusive
     *
     * From the MDN page: It might be tempting to use Math.round() to accomplish
     * that, but doing so would cause your random numbers to follow a non-uniform
     * distribution, which may not be acceptable for your needs.
     */
    function getRandomIntInclusive(min, max) {
        min = Math.ceil(min);
        max = Math.floor(max);
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }
    Private.getRandomIntInclusive = getRandomIntInclusive;
})(Private || (Private = {}));
//# sourceMappingURL=default.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernel/future.js":
/*!*****************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernel/future.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KernelShellFutureHandler = exports.KernelControlFutureHandler = exports.KernelFutureHandler = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
const disposable_1 = __webpack_require__(/*! @lumino/disposable */ "../node_modules/@lumino/disposable/dist/index.es6.js");
const KernelMessage = __importStar(__webpack_require__(/*! ./messages */ "../node_modules/@jupyterlab/services/lib/kernel/messages.js"));
/**
 * Implementation of a kernel future.
 *
 * If a reply is expected, the Future is considered done when both a `reply`
 * message and an `idle` iopub status message have been received.  Otherwise, it
 * is considered done when the `idle` status is received.
 *
 */
class KernelFutureHandler extends disposable_1.DisposableDelegate {
    /**
     * Construct a new KernelFutureHandler.
     */
    constructor(cb, msg, expectReply, disposeOnDone, kernel) {
        super(cb);
        this._status = 0;
        this._stdin = Private.noOp;
        this._iopub = Private.noOp;
        this._reply = Private.noOp;
        this._done = new coreutils_1.PromiseDelegate();
        this._hooks = new Private.HookList();
        this._disposeOnDone = true;
        this._msg = msg;
        if (!expectReply) {
            this._setFlag(Private.KernelFutureFlag.GotReply);
        }
        this._disposeOnDone = disposeOnDone;
        this._kernel = kernel;
    }
    /**
     * Get the original outgoing message.
     */
    get msg() {
        return this._msg;
    }
    /**
     * A promise that resolves when the future is done.
     */
    get done() {
        return this._done.promise;
    }
    /**
     * Get the reply handler.
     */
    get onReply() {
        return this._reply;
    }
    /**
     * Set the reply handler.
     */
    set onReply(cb) {
        this._reply = cb;
    }
    /**
     * Get the iopub handler.
     */
    get onIOPub() {
        return this._iopub;
    }
    /**
     * Set the iopub handler.
     */
    set onIOPub(cb) {
        this._iopub = cb;
    }
    /**
     * Get the stdin handler.
     */
    get onStdin() {
        return this._stdin;
    }
    /**
     * Set the stdin handler.
     */
    set onStdin(cb) {
        this._stdin = cb;
    }
    /**
     * Register hook for IOPub messages.
     *
     * @param hook - The callback invoked for an IOPub message.
     *
     * #### Notes
     * The IOPub hook system allows you to preempt the handlers for IOPub
     * messages handled by the future.
     *
     * The most recently registered hook is run first. A hook can return a
     * boolean or a promise to a boolean, in which case all kernel message
     * processing pauses until the promise is fulfilled. If a hook return value
     * resolves to false, any later hooks will not run and the function will
     * return a promise resolving to false. If a hook throws an error, the error
     * is logged to the console and the next hook is run. If a hook is
     * registered during the hook processing, it will not run until the next
     * message. If a hook is removed during the hook processing, it will be
     * deactivated immediately.
     */
    registerMessageHook(hook) {
        if (this.isDisposed) {
            throw new Error('Kernel future is disposed');
        }
        this._hooks.add(hook);
    }
    /**
     * Remove a hook for IOPub messages.
     *
     * @param hook - The hook to remove.
     *
     * #### Notes
     * If a hook is removed during the hook processing, it will be deactivated immediately.
     */
    removeMessageHook(hook) {
        if (this.isDisposed) {
            return;
        }
        this._hooks.remove(hook);
    }
    /**
     * Send an `input_reply` message.
     */
    sendInputReply(content, parent_header) {
        this._kernel.sendInputReply(content, parent_header);
    }
    /**
     * Dispose and unregister the future.
     */
    dispose() {
        this._stdin = Private.noOp;
        this._iopub = Private.noOp;
        this._reply = Private.noOp;
        this._hooks = null;
        if (!this._testFlag(Private.KernelFutureFlag.IsDone)) {
            // TODO: Uncomment the following logging code, and check for any tests that trigger it.
            // let status = [];
            // if (!this._testFlag(Private.KernelFutureFlag.GotIdle)) {
            //   status.push('idle');
            // }
            // if (!this._testFlag(Private.KernelFutureFlag.GotReply)) {
            //   status.push('reply');
            // }
            // console.warn(
            //   `*************** DISPOSED BEFORE DONE: K${this._kernel.id.slice(
            //     0,
            //     6
            //   )} M${this._msg.header.msg_id.slice(0, 6)} missing ${status.join(' ')}`
            // );
            // Reject the `done` promise, but catch its error here in case no one else
            // is waiting for the promise to resolve. This prevents the error from
            // being displayed in the console, but does not prevent it from being
            // caught by a client who is waiting for it.
            // Note: any `.then` and `.finally` attached to the `done` promise
            // will cause the error to be thrown as uncaught anyways.
            this._done.promise.catch(() => {
                /* no-op */
            });
            this._done.reject(new Error(`Canceled future for ${this.msg.header.msg_type} message before replies were done`));
        }
        super.dispose();
    }
    /**
     * Handle an incoming kernel message.
     */
    async handleMsg(msg) {
        switch (msg.channel) {
            case 'control':
            case 'shell':
                if (msg.channel === this.msg.channel &&
                    msg.parent_header.msg_id === this.msg.header.msg_id) {
                    await this._handleReply(msg);
                }
                break;
            case 'stdin':
                await this._handleStdin(msg);
                break;
            case 'iopub':
                await this._handleIOPub(msg);
                break;
            default:
                break;
        }
    }
    async _handleReply(msg) {
        const reply = this._reply;
        if (reply) {
            // tslint:disable-next-line:await-promise
            await reply(msg);
        }
        this._replyMsg = msg;
        this._setFlag(Private.KernelFutureFlag.GotReply);
        if (this._testFlag(Private.KernelFutureFlag.GotIdle)) {
            this._handleDone();
        }
    }
    async _handleStdin(msg) {
        this._kernel.hasPendingInput = true;
        const stdin = this._stdin;
        if (stdin) {
            // tslint:disable-next-line:await-promise
            await stdin(msg);
        }
    }
    async _handleIOPub(msg) {
        const process = await this._hooks.process(msg);
        const iopub = this._iopub;
        if (process && iopub) {
            // tslint:disable-next-line:await-promise
            await iopub(msg);
        }
        if (KernelMessage.isStatusMsg(msg) &&
            msg.content.execution_state === 'idle') {
            this._setFlag(Private.KernelFutureFlag.GotIdle);
            if (this._testFlag(Private.KernelFutureFlag.GotReply)) {
                this._handleDone();
            }
        }
    }
    _handleDone() {
        if (this._testFlag(Private.KernelFutureFlag.IsDone)) {
            return;
        }
        this._setFlag(Private.KernelFutureFlag.IsDone);
        this._done.resolve(this._replyMsg);
        if (this._disposeOnDone) {
            this.dispose();
        }
    }
    /**
     * Test whether the given future flag is set.
     */
    _testFlag(flag) {
        // tslint:disable-next-line
        return (this._status & flag) !== 0;
    }
    /**
     * Set the given future flag.
     */
    _setFlag(flag) {
        // tslint:disable-next-line
        this._status |= flag;
    }
}
exports.KernelFutureHandler = KernelFutureHandler;
class KernelControlFutureHandler extends KernelFutureHandler {
}
exports.KernelControlFutureHandler = KernelControlFutureHandler;
class KernelShellFutureHandler extends KernelFutureHandler {
}
exports.KernelShellFutureHandler = KernelShellFutureHandler;
var Private;
(function (Private) {
    /**
     * A no-op function.
     */
    Private.noOp = () => {
        /* no-op */
    };
    /**
     * Defer a computation.
     *
     * #### NOTES
     * We can't just use requestAnimationFrame since it is not available in node.
     * This implementation is from Phosphor:
     * https://github.com/phosphorjs/phosphor/blob/e88e4321289bb1198f3098e7bda40736501f2ed8/tests/test-messaging/src/index.spec.ts#L63
     */
    const defer = (() => {
        const ok = typeof requestAnimationFrame === 'function';
        return ok ? requestAnimationFrame : setImmediate;
    })();
    class HookList {
        constructor() {
            this._hooks = [];
        }
        /**
         * Register a hook.
         *
         * @param hook - The callback to register.
         */
        add(hook) {
            this.remove(hook);
            this._hooks.push(hook);
        }
        /**
         * Remove a hook, if it exists in the hook list.
         *
         * @param hook - The callback to remove.
         */
        remove(hook) {
            const index = this._hooks.indexOf(hook);
            if (index >= 0) {
                this._hooks[index] = null;
                this._scheduleCompact();
            }
        }
        /**
         * Process a message through the hooks.
         *
         * @returns a promise resolving to false if any hook resolved as false,
         * otherwise true
         *
         * #### Notes
         * The most recently registered hook is run first. A hook can return a
         * boolean or a promise to a boolean, in which case processing pauses until
         * the promise is fulfilled. If a hook return value resolves to false, any
         * later hooks will not run and the function will return a promise resolving
         * to false. If a hook throws an error, the error is logged to the console
         * and the next hook is run. If a hook is registered during the hook
         * processing, it will not run until the next message. If a hook is removed
         * during the hook processing, it will be deactivated immediately.
         */
        async process(msg) {
            // Wait until we can start a new process run.
            await this._processing;
            // Start the next process run.
            const processing = new coreutils_1.PromiseDelegate();
            this._processing = processing.promise;
            let continueHandling;
            // Call the end hook (most recently-added) first. Starting at the end also
            // guarantees that hooks added during the processing will not be run in
            // this process run.
            for (let i = this._hooks.length - 1; i >= 0; i--) {
                const hook = this._hooks[i];
                // If the hook has been removed, continue to the next one.
                if (hook === null) {
                    continue;
                }
                // Execute the hook and log any errors.
                try {
                    // tslint:disable-next-line:await-promise
                    continueHandling = await hook(msg);
                }
                catch (err) {
                    continueHandling = true;
                    console.error(err);
                }
                // If the hook resolved to false, stop processing and return.
                if (continueHandling === false) {
                    processing.resolve(undefined);
                    return false;
                }
            }
            // All hooks returned true (or errored out), so return true.
            processing.resolve(undefined);
            return true;
        }
        /**
         * Schedule a cleanup of the list, removing any hooks that have been nulled out.
         */
        _scheduleCompact() {
            if (!this._compactScheduled) {
                this._compactScheduled = true;
                // Schedule a compaction in between processing runs. We do the
                // scheduling in an animation frame to rate-limit our compactions. If we
                // need to compact more frequently, we can change this to directly
                // schedule the compaction.
                defer(() => {
                    this._processing = this._processing.then(() => {
                        this._compactScheduled = false;
                        this._compact();
                    });
                });
            }
        }
        /**
         * Compact the list, removing any nulls.
         */
        _compact() {
            let numNulls = 0;
            for (let i = 0, len = this._hooks.length; i < len; i++) {
                const hook = this._hooks[i];
                if (this._hooks[i] === null) {
                    numNulls++;
                }
                else {
                    this._hooks[i - numNulls] = hook;
                }
            }
            this._hooks.length -= numNulls;
        }
    }
    Private.HookList = HookList;
    /**
     * Bit flags for the kernel future state.
     */
    let KernelFutureFlag;
    (function (KernelFutureFlag) {
        KernelFutureFlag[KernelFutureFlag["GotReply"] = 1] = "GotReply";
        KernelFutureFlag[KernelFutureFlag["GotIdle"] = 2] = "GotIdle";
        KernelFutureFlag[KernelFutureFlag["IsDone"] = 4] = "IsDone";
        KernelFutureFlag[KernelFutureFlag["DisposeOnDone"] = 8] = "DisposeOnDone";
    })(KernelFutureFlag = Private.KernelFutureFlag || (Private.KernelFutureFlag = {}));
})(Private || (Private = {}));
//# sourceMappingURL=future.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernel/index.js":
/*!****************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernel/index.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KernelConnection = exports.KernelAPI = exports.KernelMessage = exports.Kernel = void 0;
// Namespace some of our modules for convenience and backwards compatibility.
const Kernel = __importStar(__webpack_require__(/*! ./kernel */ "../node_modules/@jupyterlab/services/lib/kernel/kernel.js"));
exports.Kernel = Kernel;
const KernelMessage = __importStar(__webpack_require__(/*! ./messages */ "../node_modules/@jupyterlab/services/lib/kernel/messages.js"));
exports.KernelMessage = KernelMessage;
const KernelAPI = __importStar(__webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/kernel/restapi.js"));
exports.KernelAPI = KernelAPI;
const default_1 = __webpack_require__(/*! ./default */ "../node_modules/@jupyterlab/services/lib/kernel/default.js");
Object.defineProperty(exports, "KernelConnection", ({ enumerable: true, get: function () { return default_1.KernelConnection; } }));
__exportStar(__webpack_require__(/*! ./manager */ "../node_modules/@jupyterlab/services/lib/kernel/manager.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernel/kernel.js":
/*!*****************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernel/kernel.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=kernel.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernel/manager.js":
/*!******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernel/manager.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KernelManager = void 0;
const polling_1 = __webpack_require__(/*! @lumino/polling */ "../node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "../node_modules/@jupyterlab/services/lib/index.js");
const basemanager_1 = __webpack_require__(/*! ../basemanager */ "../node_modules/@jupyterlab/services/lib/basemanager.js");
const restapi_1 = __webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/kernel/restapi.js");
const default_1 = __webpack_require__(/*! ./default */ "../node_modules/@jupyterlab/services/lib/kernel/default.js");
/**
 * An implementation of a kernel manager.
 */
class KernelManager extends basemanager_1.BaseManager {
    /**
     * Construct a new kernel manager.
     *
     * @param options - The default options for kernel.
     */
    constructor(options = {}) {
        var _a;
        super(options);
        this._isReady = false;
        this._kernelConnections = new Set();
        this._models = new Map();
        this._runningChanged = new signaling_1.Signal(this);
        this._connectionFailure = new signaling_1.Signal(this);
        // Start model and specs polling with exponential backoff.
        this._pollModels = new polling_1.Poll({
            auto: false,
            factory: () => this.requestRunning(),
            frequency: {
                interval: 10 * 1000,
                backoff: true,
                max: 300 * 1000
            },
            name: `@jupyterlab/services:KernelManager#models`,
            standby: (_a = options.standby) !== null && _a !== void 0 ? _a : 'when-hidden'
        });
        // Initialize internal data.
        this._ready = (async () => {
            await this._pollModels.start();
            await this._pollModels.tick;
            this._isReady = true;
        })();
    }
    /**
     * Test whether the manager is ready.
     */
    get isReady() {
        return this._isReady;
    }
    /**
     * A promise that fulfills when the manager is ready.
     */
    get ready() {
        return this._ready;
    }
    /**
     * A signal emitted when the running kernels change.
     */
    get runningChanged() {
        return this._runningChanged;
    }
    /**
     * A signal emitted when there is a connection failure.
     */
    get connectionFailure() {
        return this._connectionFailure;
    }
    /**
     * Dispose of the resources used by the manager.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._models.clear();
        this._kernelConnections.forEach(x => x.dispose());
        this._pollModels.dispose();
        super.dispose();
    }
    /**
     * Connect to an existing kernel.
     *
     * @returns The new kernel connection.
     *
     * #### Notes
     * This will use the manager's server settings and ignore any server
     * settings passed in the options.
     */
    connectTo(options) {
        var _a;
        const { id } = options.model;
        let handleComms = (_a = options.handleComms) !== null && _a !== void 0 ? _a : true;
        // By default, handle comms only if no other kernel connection is.
        if (options.handleComms === undefined) {
            for (const kc of this._kernelConnections) {
                if (kc.id === id && kc.handleComms) {
                    handleComms = false;
                    break;
                }
            }
        }
        const kernelConnection = new default_1.KernelConnection({
            handleComms,
            ...options,
            serverSettings: this.serverSettings
        });
        this._onStarted(kernelConnection);
        if (!this._models.has(id)) {
            // We trust the user to connect to an existing kernel, but we verify
            // asynchronously.
            void this.refreshRunning().catch(() => {
                /* no-op */
            });
        }
        return kernelConnection;
    }
    /**
     * Create an iterator over the most recent running kernels.
     *
     * @returns A new iterator over the running kernels.
     */
    running() {
        return this._models.values();
    }
    /**
     * The number of running kernels.
     */
    get runningCount() {
        return this._models.size;
    }
    /**
     * Force a refresh of the running kernels.
     *
     * @returns A promise that resolves when the running list has been refreshed.
     *
     * #### Notes
     * This is not typically meant to be called by the user, since the
     * manager maintains its own internal state.
     */
    async refreshRunning() {
        await this._pollModels.refresh();
        await this._pollModels.tick;
    }
    /**
     * Start a new kernel.
     *
     * @param createOptions - The kernel creation options
     *
     * @param connectOptions - The kernel connection options
     *
     * @returns A promise that resolves with the kernel connection.
     *
     * #### Notes
     * The manager `serverSettings` will be always be used.
     */
    async startNew(createOptions = {}, connectOptions = {}) {
        const model = await (0, restapi_1.startNew)(createOptions, this.serverSettings);
        return this.connectTo({
            ...connectOptions,
            model
        });
    }
    /**
     * Shut down a kernel by id.
     *
     * @param id - The id of the target kernel.
     *
     * @returns A promise that resolves when the operation is complete.
     */
    async shutdown(id) {
        await (0, restapi_1.shutdownKernel)(id, this.serverSettings);
        await this.refreshRunning();
    }
    /**
     * Shut down all kernels.
     *
     * @returns A promise that resolves when all of the kernels are shut down.
     */
    async shutdownAll() {
        // Update the list of models to make sure our list is current.
        await this.refreshRunning();
        // Shut down all models.
        await Promise.all([...this._models.keys()].map(id => (0, restapi_1.shutdownKernel)(id, this.serverSettings)));
        // Update the list of models to clear out our state.
        await this.refreshRunning();
    }
    /**
     * Find a kernel by id.
     *
     * @param id - The id of the target kernel.
     *
     * @returns A promise that resolves with the kernel's model.
     */
    async findById(id) {
        if (this._models.has(id)) {
            return this._models.get(id);
        }
        await this.refreshRunning();
        return this._models.get(id);
    }
    /**
     * Execute a request to the server to poll running kernels and update state.
     */
    async requestRunning() {
        var _a, _b;
        let models;
        try {
            models = await (0, restapi_1.listRunning)(this.serverSettings);
        }
        catch (err) {
            // Handle network errors, as well as cases where we are on a
            // JupyterHub and the server is not running. JupyterHub returns a
            // 503 (<2.0) or 424 (>2.0) in that case.
            if (err instanceof __1.ServerConnection.NetworkError ||
                ((_a = err.response) === null || _a === void 0 ? void 0 : _a.status) === 503 ||
                ((_b = err.response) === null || _b === void 0 ? void 0 : _b.status) === 424) {
                this._connectionFailure.emit(err);
            }
            throw err;
        }
        if (this.isDisposed) {
            return;
        }
        if (this._models.size === models.length &&
            models.every(model => {
                const existing = this._models.get(model.id);
                if (!existing) {
                    return false;
                }
                return (existing.connections === model.connections &&
                    existing.execution_state === model.execution_state &&
                    existing.last_activity === model.last_activity &&
                    existing.name === model.name &&
                    existing.reason === model.reason &&
                    existing.traceback === model.traceback);
            })) {
            // Identical models list (presuming models does not contain duplicate
            // ids), so just return
            return;
        }
        this._models = new Map(models.map(x => [x.id, x]));
        // For any kernel connection to a kernel that doesn't exist, notify it of
        // the shutdown.
        this._kernelConnections.forEach(kc => {
            if (!this._models.has(kc.id)) {
                kc.handleShutdown();
            }
        });
        this._runningChanged.emit(models);
    }
    /**
     * Handle a kernel starting.
     */
    _onStarted(kernelConnection) {
        this._kernelConnections.add(kernelConnection);
        kernelConnection.statusChanged.connect(this._onStatusChanged, this);
        kernelConnection.disposed.connect(this._onDisposed, this);
    }
    _onDisposed(kernelConnection) {
        this._kernelConnections.delete(kernelConnection);
        // A dispose emission could mean the server session is deleted, or that
        // the kernel JS object is disposed and the kernel still exists on the
        // server, so we refresh from the server to make sure we reflect the
        // server state.
        void this.refreshRunning().catch(() => {
            /* no-op */
        });
    }
    _onStatusChanged(kernelConnection, status) {
        if (status === 'dead') {
            // We asynchronously update our list of kernels, which asynchronously
            // will dispose them. We do not want to immediately dispose them because
            // there may be other signal handlers that want to be called.
            void this.refreshRunning().catch(() => {
                /* no-op */
            });
        }
    }
}
exports.KernelManager = KernelManager;
/**
 * The namespace for `KernelManager` class statics.
 */
(function (KernelManager) {
    /**
     * A no-op kernel manager to be used when starting kernels.
     */
    class NoopManager extends KernelManager {
        constructor() {
            super(...arguments);
            this._readyPromise = new Promise(() => {
                /* no-op */
            });
        }
        /**
         * Whether the manager is active.
         */
        get isActive() {
            return false;
        }
        /**
         * Used for testing.
         */
        get parentReady() {
            return super.ready;
        }
        /**
         * Start a new kernel - throws an error since it is not supported.
         */
        async startNew(createOptions = {}, connectOptions = {}) {
            return Promise.reject(new Error('Not implemented in no-op Kernel Manager'));
        }
        /**
         * Connect to an existing kernel - throws an error since it is not supported.
         */
        connectTo(options) {
            throw new Error('Not implemented in no-op Kernel Manager');
        }
        /**
         * Shut down a kernel by id - throws an error since it is not supported.
         */
        async shutdown(id) {
            return Promise.reject(new Error('Not implemented in no-op Kernel Manager'));
        }
        /**
         * A promise that fulfills when the manager is ready (never).
         */
        get ready() {
            return this.parentReady.then(() => this._readyPromise);
        }
        /**
         * Execute a request to the server to poll running kernels and update state.
         */
        async requestRunning() {
            return Promise.resolve();
        }
    }
    KernelManager.NoopManager = NoopManager;
})(KernelManager || (exports.KernelManager = KernelManager = {}));
//# sourceMappingURL=manager.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernel/messages.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernel/messages.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.supportedKernelWebSocketProtocols = exports.isInputReplyMsg = exports.isInputRequestMsg = exports.isDebugReplyMsg = exports.isDebugRequestMsg = exports.isExecuteReplyMsg = exports.isInfoRequestMsg = exports.isCommMsgMsg = exports.isCommCloseMsg = exports.isCommOpenMsg = exports.isDebugEventMsg = exports.isClearOutputMsg = exports.isStatusMsg = exports.isErrorMsg = exports.isExecuteResultMsg = exports.isExecuteInputMsg = exports.isUpdateDisplayDataMsg = exports.isDisplayDataMsg = exports.isStreamMsg = exports.createMessage = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
function createMessage(options) {
    var _a, _b, _c, _d, _e;
    return {
        buffers: (_a = options.buffers) !== null && _a !== void 0 ? _a : [],
        channel: options.channel,
        content: options.content,
        header: {
            date: new Date().toISOString(),
            msg_id: (_b = options.msgId) !== null && _b !== void 0 ? _b : coreutils_1.UUID.uuid4(),
            msg_type: options.msgType,
            session: options.session,
            username: (_c = options.username) !== null && _c !== void 0 ? _c : '',
            version: '5.2'
        },
        metadata: (_d = options.metadata) !== null && _d !== void 0 ? _d : {},
        parent_header: (_e = options.parentHeader) !== null && _e !== void 0 ? _e : {}
    };
}
exports.createMessage = createMessage;
/**
 * Test whether a kernel message is a `'stream'` message.
 */
function isStreamMsg(msg) {
    return msg.header.msg_type === 'stream';
}
exports.isStreamMsg = isStreamMsg;
/**
 * Test whether a kernel message is an `'display_data'` message.
 */
function isDisplayDataMsg(msg) {
    return msg.header.msg_type === 'display_data';
}
exports.isDisplayDataMsg = isDisplayDataMsg;
/**
 * Test whether a kernel message is an `'update_display_data'` message.
 */
function isUpdateDisplayDataMsg(msg) {
    return msg.header.msg_type === 'update_display_data';
}
exports.isUpdateDisplayDataMsg = isUpdateDisplayDataMsg;
/**
 * Test whether a kernel message is an `'execute_input'` message.
 */
function isExecuteInputMsg(msg) {
    return msg.header.msg_type === 'execute_input';
}
exports.isExecuteInputMsg = isExecuteInputMsg;
/**
 * Test whether a kernel message is an `'execute_result'` message.
 */
function isExecuteResultMsg(msg) {
    return msg.header.msg_type === 'execute_result';
}
exports.isExecuteResultMsg = isExecuteResultMsg;
/**
 * Test whether a kernel message is an `'error'` message.
 */
function isErrorMsg(msg) {
    return msg.header.msg_type === 'error';
}
exports.isErrorMsg = isErrorMsg;
/**
 * Test whether a kernel message is a `'status'` message.
 */
function isStatusMsg(msg) {
    return msg.header.msg_type === 'status';
}
exports.isStatusMsg = isStatusMsg;
/**
 * Test whether a kernel message is a `'clear_output'` message.
 */
function isClearOutputMsg(msg) {
    return msg.header.msg_type === 'clear_output';
}
exports.isClearOutputMsg = isClearOutputMsg;
/**
 * Test whether a kernel message is an experimental `'debug_event'` message.
 *
 * @hidden
 *
 * #### Notes
 * Debug messages are experimental messages that are not in the official
 * kernel message specification. As such, this is *NOT* considered
 * part of the public API, and may change without notice.
 */
function isDebugEventMsg(msg) {
    return msg.header.msg_type === 'debug_event';
}
exports.isDebugEventMsg = isDebugEventMsg;
/**
 * Test whether a kernel message is a `'comm_open'` message.
 */
function isCommOpenMsg(msg) {
    return msg.header.msg_type === 'comm_open';
}
exports.isCommOpenMsg = isCommOpenMsg;
/**
 * Test whether a kernel message is a `'comm_close'` message.
 */
function isCommCloseMsg(msg) {
    return msg.header.msg_type === 'comm_close';
}
exports.isCommCloseMsg = isCommCloseMsg;
/**
 * Test whether a kernel message is a `'comm_msg'` message.
 */
function isCommMsgMsg(msg) {
    return msg.header.msg_type === 'comm_msg';
}
exports.isCommMsgMsg = isCommMsgMsg;
/**
 * Test whether a kernel message is a `'kernel_info_request'` message.
 */
function isInfoRequestMsg(msg) {
    return msg.header.msg_type === 'kernel_info_request';
}
exports.isInfoRequestMsg = isInfoRequestMsg;
/**
 * Test whether a kernel message is an `'execute_reply'` message.
 */
function isExecuteReplyMsg(msg) {
    return msg.header.msg_type === 'execute_reply';
}
exports.isExecuteReplyMsg = isExecuteReplyMsg;
/**
 * Test whether a kernel message is an experimental `'debug_request'` message.
 *
 * @hidden
 *
 * #### Notes
 * Debug messages are experimental messages that are not in the official
 * kernel message specification. As such, this is *NOT* considered
 * part of the public API, and may change without notice.
 */
function isDebugRequestMsg(msg) {
    return msg.header.msg_type === 'debug_request';
}
exports.isDebugRequestMsg = isDebugRequestMsg;
/**
 * Test whether a kernel message is an experimental `'debug_reply'` message.
 *
 * @hidden
 *
 * #### Notes
 * Debug messages are experimental messages that are not in the official
 * kernel message specification. As such, this is *NOT* considered
 * part of the public API, and may change without notice.
 */
function isDebugReplyMsg(msg) {
    return msg.header.msg_type === 'debug_reply';
}
exports.isDebugReplyMsg = isDebugReplyMsg;
/**
 * Test whether a kernel message is an `'input_request'` message.
 */
function isInputRequestMsg(msg) {
    return msg.header.msg_type === 'input_request';
}
exports.isInputRequestMsg = isInputRequestMsg;
/**
 * Test whether a kernel message is an `'input_reply'` message.
 */
function isInputReplyMsg(msg) {
    return msg.header.msg_type === 'input_reply';
}
exports.isInputReplyMsg = isInputReplyMsg;
// ///////////////////////////////////////////////
// Message (de)serialization
// ///////////////////////////////////////////////
/**
 * The list of supported kernel wire protocols over websocket.
 */
var supportedKernelWebSocketProtocols;
(function (supportedKernelWebSocketProtocols) {
    supportedKernelWebSocketProtocols["v1KernelWebsocketJupyterOrg"] = "v1.kernel.websocket.jupyter.org";
})(supportedKernelWebSocketProtocols || (exports.supportedKernelWebSocketProtocols = supportedKernelWebSocketProtocols = {}));
//# sourceMappingURL=messages.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernel/restapi.js":
/*!******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernel/restapi.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getKernelModel = exports.shutdownKernel = exports.interruptKernel = exports.restartKernel = exports.startNew = exports.listRunning = exports.KERNEL_SERVICE_URL = void 0;
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const validate_1 = __webpack_require__(/*! ./validate */ "../node_modules/@jupyterlab/services/lib/kernel/validate.js");
/**
 * The url for the kernel service.
 */
exports.KERNEL_SERVICE_URL = 'api/kernels';
/**
 * Fetch the running kernels.
 *
 * @param settings - The optional server settings.
 *
 * @returns A promise that resolves with the list of running kernels.
 *
 * #### Notes
 * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response and rejected otherwise.
 */
async function listRunning(settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL);
    const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
    if (response.status !== 200) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    (0, validate_1.validateModels)(data);
    return data;
}
exports.listRunning = listRunning;
/**
 * Start a new kernel.
 *
 * @param options - The options used to create the kernel.
 *
 * @returns A promise that resolves with a kernel connection object.
 *
 * #### Notes
 * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response and rejected otherwise.
 */
async function startNew(options = {}, settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL);
    const init = {
        method: 'POST',
        body: JSON.stringify(options)
    };
    const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
    if (response.status !== 201) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    (0, validate_1.validateModel)(data);
    return data;
}
exports.startNew = startNew;
/**
 * Restart a kernel.
 *
 * #### Notes
 * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response (and thus after a restart) and rejected otherwise.
 */
async function restartKernel(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL, encodeURIComponent(id), 'restart');
    const init = { method: 'POST' };
    const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
    if (response.status !== 200) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    (0, validate_1.validateModel)(data);
}
exports.restartKernel = restartKernel;
/**
 * Interrupt a kernel.
 *
 * #### Notes
 * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response and rejected otherwise.
 */
async function interruptKernel(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL, encodeURIComponent(id), 'interrupt');
    const init = { method: 'POST' };
    const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
    if (response.status !== 204) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
}
exports.interruptKernel = interruptKernel;
/**
 * Shut down a kernel.
 *
 * @param id - The id of the running kernel.
 *
 * @param settings - The server settings for the request.
 *
 * @returns A promise that resolves when the kernel is shut down.
 *
 *
 * #### Notes
 * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response and rejected otherwise.
 */
async function shutdownKernel(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL, encodeURIComponent(id));
    const init = { method: 'DELETE' };
    const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
    if (response.status === 404) {
        const msg = `The kernel "${id}" does not exist on the server`;
        console.warn(msg);
    }
    else if (response.status !== 204) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
}
exports.shutdownKernel = shutdownKernel;
/**
 * Get a full kernel model from the server by kernel id string.
 *
 * #### Notes
 * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response and rejected otherwise.
 */
async function getKernelModel(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL, encodeURIComponent(id));
    const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
    if (response.status === 404) {
        return undefined;
    }
    else if (response.status !== 200) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    (0, validate_1.validateModel)(data);
    return data;
}
exports.getKernelModel = getKernelModel;
//# sourceMappingURL=restapi.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernel/serialize.js":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernel/serialize.js ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.deserialize = exports.serialize = void 0;
const KernelMessage = __importStar(__webpack_require__(/*! ./messages */ "../node_modules/@jupyterlab/services/lib/kernel/messages.js"));
/**
 * Serialize a kernel message for transport.
 */
function serialize(msg, protocol = '') {
    switch (protocol) {
        case KernelMessage.supportedKernelWebSocketProtocols
            .v1KernelWebsocketJupyterOrg:
            return Private.serializeV1KernelWebsocketJupyterOrg(msg);
        default:
            return Private.serializeDefault(msg);
    }
}
exports.serialize = serialize;
/**
 * Deserialize and return the unpacked message.
 */
function deserialize(data, protocol = '') {
    switch (protocol) {
        case KernelMessage.supportedKernelWebSocketProtocols
            .v1KernelWebsocketJupyterOrg:
            return Private.deserializeV1KernelWebsocketJupyterOrg(data);
        default:
            return Private.deserializeDefault(data);
    }
}
exports.deserialize = deserialize;
var Private;
(function (Private) {
    /**
     * Deserialize and return the unpacked message.
     * Protocol `v1.kernel.websocket.jupyter.org`
     */
    function deserializeV1KernelWebsocketJupyterOrg(binMsg) {
        let msg;
        const data = new DataView(binMsg);
        const offsetNumber = Number(data.getBigUint64(0, true /* littleEndian */));
        let offsets = [];
        for (let i = 0; i < offsetNumber; i++) {
            // WARNING: we cast our 64-bit unsigned int to a number!
            // so offsets cannot index up to 2**64 bytes
            offsets.push(Number(data.getBigUint64(8 * (i + 1), true /* littleEndian */)));
        }
        const decoder = new TextDecoder('utf8');
        const channel = decoder.decode(binMsg.slice(offsets[0], offsets[1]));
        const header = JSON.parse(decoder.decode(binMsg.slice(offsets[1], offsets[2])));
        const parent_header = JSON.parse(decoder.decode(binMsg.slice(offsets[2], offsets[3])));
        const metadata = JSON.parse(decoder.decode(binMsg.slice(offsets[3], offsets[4])));
        const content = JSON.parse(decoder.decode(binMsg.slice(offsets[4], offsets[5])));
        let buffers = [];
        for (let i = 5; i < offsets.length - 1; i++) {
            buffers.push(new DataView(binMsg.slice(offsets[i], offsets[i + 1])));
        }
        msg = {
            channel,
            header,
            parent_header,
            metadata,
            content,
            buffers
        };
        return msg;
    }
    Private.deserializeV1KernelWebsocketJupyterOrg = deserializeV1KernelWebsocketJupyterOrg;
    /**
     * Serialize a kernel message for transport.
     * Protocol `v1.kernel.websocket.jupyter.org`
     */
    function serializeV1KernelWebsocketJupyterOrg(msg) {
        const header = JSON.stringify(msg.header);
        const parentHeader = msg.parent_header == null ? '{}' : JSON.stringify(msg.parent_header);
        const metadata = JSON.stringify(msg.metadata);
        const content = JSON.stringify(msg.content);
        const buffers = msg.buffers !== undefined ? msg.buffers : [];
        const offsetNumber = 1 + 4 + buffers.length + 1;
        let offsets = [];
        offsets.push(8 * (1 + offsetNumber));
        offsets.push(msg.channel.length + offsets[offsets.length - 1]);
        const encoder = new TextEncoder();
        const channelEncoded = encoder.encode(msg.channel);
        const headerEncoded = encoder.encode(header);
        const parentHeaderEncoded = encoder.encode(parentHeader);
        const metadataEncoded = encoder.encode(metadata);
        const contentEncoded = encoder.encode(content);
        const binMsgNoBuff = new Uint8Array(channelEncoded.length +
            headerEncoded.length +
            parentHeaderEncoded.length +
            metadataEncoded.length +
            contentEncoded.length);
        binMsgNoBuff.set(channelEncoded);
        binMsgNoBuff.set(headerEncoded, channelEncoded.length);
        binMsgNoBuff.set(parentHeaderEncoded, channelEncoded.length + headerEncoded.length);
        binMsgNoBuff.set(metadataEncoded, channelEncoded.length + headerEncoded.length + parentHeaderEncoded.length);
        binMsgNoBuff.set(contentEncoded, channelEncoded.length +
            headerEncoded.length +
            parentHeaderEncoded.length +
            metadataEncoded.length);
        for (let length of [
            headerEncoded.length,
            parentHeaderEncoded.length,
            metadataEncoded.length,
            contentEncoded.length
        ]) {
            offsets.push(length + offsets[offsets.length - 1]);
        }
        let buffersByteLength = 0;
        for (let buffer of buffers) {
            let length = buffer.byteLength;
            offsets.push(length + offsets[offsets.length - 1]);
            buffersByteLength += length;
        }
        const binMsg = new Uint8Array(8 * (1 + offsetNumber) + binMsgNoBuff.byteLength + buffersByteLength);
        const word = new ArrayBuffer(8);
        const data = new DataView(word);
        data.setBigUint64(0, BigInt(offsetNumber), true /* littleEndian */);
        binMsg.set(new Uint8Array(word), 0);
        for (let i = 0; i < offsets.length; i++) {
            data.setBigUint64(0, BigInt(offsets[i]), true /* littleEndian */);
            binMsg.set(new Uint8Array(word), 8 * (i + 1));
        }
        binMsg.set(binMsgNoBuff, offsets[0]);
        for (let i = 0; i < buffers.length; i++) {
            const buffer = buffers[i];
            binMsg.set(new Uint8Array(ArrayBuffer.isView(buffer) ? buffer.buffer : buffer), offsets[5 + i]);
        }
        return binMsg.buffer;
    }
    Private.serializeV1KernelWebsocketJupyterOrg = serializeV1KernelWebsocketJupyterOrg;
    /**
     * Deserialize and return the unpacked message.
     * Default protocol
     *
     * #### Notes
     * Handles JSON blob strings and binary messages.
     */
    function deserializeDefault(data) {
        let value;
        if (typeof data === 'string') {
            value = JSON.parse(data);
        }
        else {
            value = deserializeBinary(data);
        }
        return value;
    }
    Private.deserializeDefault = deserializeDefault;
    /**
     * Serialize a kernel message for transport.
     * Default protocol
     *
     * #### Notes
     * If there is binary content, an `ArrayBuffer` is returned,
     * otherwise the message is converted to a JSON string.
     */
    function serializeDefault(msg) {
        var _a;
        let value;
        if ((_a = msg.buffers) === null || _a === void 0 ? void 0 : _a.length) {
            value = serializeBinary(msg);
        }
        else {
            value = JSON.stringify(msg);
        }
        return value;
    }
    Private.serializeDefault = serializeDefault;
    /**
     * Deserialize a binary message to a Kernel Message.
     */
    function deserializeBinary(buf) {
        const data = new DataView(buf);
        // read the header: 1 + nbufs 32b integers
        const nbufs = data.getUint32(0);
        const offsets = [];
        if (nbufs < 2) {
            throw new Error('Invalid incoming Kernel Message');
        }
        for (let i = 1; i <= nbufs; i++) {
            offsets.push(data.getUint32(i * 4));
        }
        const jsonBytes = new Uint8Array(buf.slice(offsets[0], offsets[1]));
        const msg = JSON.parse(new TextDecoder('utf8').decode(jsonBytes));
        // the remaining chunks are stored as DataViews in msg.buffers
        msg.buffers = [];
        for (let i = 1; i < nbufs; i++) {
            const start = offsets[i];
            const stop = offsets[i + 1] || buf.byteLength;
            msg.buffers.push(new DataView(buf.slice(start, stop)));
        }
        return msg;
    }
    /**
     * Implement the binary serialization protocol.
     *
     * Serialize Kernel message to ArrayBuffer.
     */
    function serializeBinary(msg) {
        const offsets = [];
        const buffers = [];
        const encoder = new TextEncoder();
        let origBuffers = [];
        if (msg.buffers !== undefined) {
            origBuffers = msg.buffers;
            delete msg['buffers'];
        }
        const jsonUtf8 = encoder.encode(JSON.stringify(msg));
        buffers.push(jsonUtf8.buffer);
        for (let i = 0; i < origBuffers.length; i++) {
            // msg.buffers elements could be either views or ArrayBuffers
            // buffers elements are ArrayBuffers
            const b = origBuffers[i];
            buffers.push(ArrayBuffer.isView(b) ? b.buffer : b);
        }
        const nbufs = buffers.length;
        offsets.push(4 * (nbufs + 1));
        for (let i = 0; i + 1 < buffers.length; i++) {
            offsets.push(offsets[offsets.length - 1] + buffers[i].byteLength);
        }
        const msgBuf = new Uint8Array(offsets[offsets.length - 1] + buffers[buffers.length - 1].byteLength);
        // use DataView.setUint32 for network byte-order
        const view = new DataView(msgBuf.buffer);
        // write nbufs to first 4 bytes
        view.setUint32(0, nbufs);
        // write offsets to next 4 * nbufs bytes
        for (let i = 0; i < offsets.length; i++) {
            view.setUint32(4 * (i + 1), offsets[i]);
        }
        // write all the buffers at their respective offsets
        for (let i = 0; i < buffers.length; i++) {
            msgBuf.set(new Uint8Array(buffers[i]), offsets[i]);
        }
        return msgBuf.buffer;
    }
})(Private || (Private = {}));
//# sourceMappingURL=serialize.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernel/validate.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernel/validate.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateModels = exports.validateModel = exports.validateMessage = void 0;
const validate_1 = __webpack_require__(/*! ../validate */ "../node_modules/@jupyterlab/services/lib/validate.js");
/**
 * Required fields for `IKernelHeader`.
 */
const HEADER_FIELDS = ['username', 'version', 'session', 'msg_id', 'msg_type'];
/**
 * Required fields and types for contents of various types of `kernel.IMessage`
 * messages on the iopub channel.
 */
const IOPUB_CONTENT_FIELDS = {
    stream: { name: 'string', text: 'string' },
    display_data: { data: 'object', metadata: 'object' },
    execute_input: { code: 'string', execution_count: 'number' },
    execute_result: {
        execution_count: 'number',
        data: 'object',
        metadata: 'object'
    },
    error: { ename: 'string', evalue: 'string', traceback: 'object' },
    status: {
        execution_state: [
            'string',
            ['starting', 'idle', 'busy', 'restarting', 'dead']
        ]
    },
    clear_output: { wait: 'boolean' },
    comm_open: { comm_id: 'string', target_name: 'string', data: 'object' },
    comm_msg: { comm_id: 'string', data: 'object' },
    comm_close: { comm_id: 'string' },
    shutdown_reply: { restart: 'boolean' } // Emitted by the IPython kernel.
};
/**
 * Validate the header of a kernel message.
 */
function validateHeader(header) {
    for (let i = 0; i < HEADER_FIELDS.length; i++) {
        (0, validate_1.validateProperty)(header, HEADER_FIELDS[i], 'string');
    }
}
/**
 * Validate a kernel message object.
 */
function validateMessage(msg) {
    (0, validate_1.validateProperty)(msg, 'metadata', 'object');
    (0, validate_1.validateProperty)(msg, 'content', 'object');
    (0, validate_1.validateProperty)(msg, 'channel', 'string');
    validateHeader(msg.header);
    if (msg.channel === 'iopub') {
        validateIOPubContent(msg);
    }
}
exports.validateMessage = validateMessage;
/**
 * Validate content an kernel message on the iopub channel.
 */
function validateIOPubContent(msg) {
    if (msg.channel === 'iopub') {
        const fields = IOPUB_CONTENT_FIELDS[msg.header.msg_type];
        // Check for unknown message type.
        if (fields === undefined) {
            return;
        }
        const names = Object.keys(fields);
        const content = msg.content;
        for (let i = 0; i < names.length; i++) {
            let args = fields[names[i]];
            if (!Array.isArray(args)) {
                args = [args];
            }
            (0, validate_1.validateProperty)(content, names[i], ...args);
        }
    }
}
/**
 * Validate a `Kernel.IModel` object.
 */
function validateModel(model) {
    (0, validate_1.validateProperty)(model, 'name', 'string');
    (0, validate_1.validateProperty)(model, 'id', 'string');
}
exports.validateModel = validateModel;
/**
 * Validate an array of `IModel` objects.
 */
function validateModels(models) {
    if (!Array.isArray(models)) {
        throw new Error('Invalid kernel list');
    }
    models.forEach(d => validateModel(d));
}
exports.validateModels = validateModels;
//# sourceMappingURL=validate.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernelspec/index.js":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernelspec/index.js ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KernelSpecAPI = exports.KernelSpec = void 0;
const KernelSpec = __importStar(__webpack_require__(/*! ./kernelspec */ "../node_modules/@jupyterlab/services/lib/kernelspec/kernelspec.js"));
exports.KernelSpec = KernelSpec;
const KernelSpecAPI = __importStar(__webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/kernelspec/restapi.js"));
exports.KernelSpecAPI = KernelSpecAPI;
__exportStar(__webpack_require__(/*! ./manager */ "../node_modules/@jupyterlab/services/lib/kernelspec/manager.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernelspec/kernelspec.js":
/*!*************************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernelspec/kernelspec.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=kernelspec.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernelspec/manager.js":
/*!**********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernelspec/manager.js ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KernelSpecManager = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
const polling_1 = __webpack_require__(/*! @lumino/polling */ "../node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const restapi = __importStar(__webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/kernelspec/restapi.js"));
const basemanager_1 = __webpack_require__(/*! ../basemanager */ "../node_modules/@jupyterlab/services/lib/basemanager.js");
/**
 * An implementation of a kernel spec manager.
 */
class KernelSpecManager extends basemanager_1.BaseManager {
    /**
     * Construct a new kernel spec manager.
     *
     * @param options - The default options for kernel.
     */
    constructor(options = {}) {
        var _a;
        super(options);
        this._isReady = false;
        this._connectionFailure = new signaling_1.Signal(this);
        this._specs = null;
        this._specsChanged = new signaling_1.Signal(this);
        // Initialize internal data.
        this._ready = Promise.all([this.requestSpecs()])
            .then(_ => undefined)
            .catch(_ => undefined)
            .then(() => {
            if (this.isDisposed) {
                return;
            }
            this._isReady = true;
        });
        this._pollSpecs = new polling_1.Poll({
            auto: false,
            factory: () => this.requestSpecs(),
            frequency: {
                interval: 61 * 1000,
                backoff: true,
                max: 300 * 1000
            },
            name: `@jupyterlab/services:KernelSpecManager#specs`,
            standby: (_a = options.standby) !== null && _a !== void 0 ? _a : 'when-hidden'
        });
        void this.ready.then(() => {
            void this._pollSpecs.start();
        });
    }
    /**
     * Test whether the manager is ready.
     */
    get isReady() {
        return this._isReady;
    }
    /**
     * A promise that fulfills when the manager is ready.
     */
    get ready() {
        return this._ready;
    }
    /**
     * Get the most recently fetched kernel specs.
     */
    get specs() {
        return this._specs;
    }
    /**
     * A signal emitted when the specs change.
     */
    get specsChanged() {
        return this._specsChanged;
    }
    /**
     * A signal emitted when there is a connection failure.
     */
    get connectionFailure() {
        return this._connectionFailure;
    }
    /**
     * Dispose of the resources used by the manager.
     */
    dispose() {
        this._pollSpecs.dispose();
        super.dispose();
    }
    /**
     * Force a refresh of the specs from the server.
     *
     * @returns A promise that resolves when the specs are fetched.
     *
     * #### Notes
     * This is intended to be called only in response to a user action,
     * since the manager maintains its internal state.
     */
    async refreshSpecs() {
        await this._pollSpecs.refresh();
        await this._pollSpecs.tick;
    }
    /**
     * Execute a request to the server to poll specs and update state.
     */
    async requestSpecs() {
        const specs = await restapi.getSpecs(this.serverSettings);
        if (this.isDisposed) {
            return;
        }
        if (!coreutils_1.JSONExt.deepEqual(specs, this._specs)) {
            this._specs = specs;
            this._specsChanged.emit(specs);
        }
    }
}
exports.KernelSpecManager = KernelSpecManager;
//# sourceMappingURL=manager.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernelspec/restapi.js":
/*!**********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernelspec/restapi.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getSpecs = void 0;
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
const validate_1 = __webpack_require__(/*! ./validate */ "../node_modules/@jupyterlab/services/lib/kernelspec/validate.js");
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
/**
 * The url for the kernelspec service.
 */
const KERNELSPEC_SERVICE_URL = 'api/kernelspecs';
/**
 * Fetch all of the kernel specs.
 *
 * @param settings - The optional server settings.
 * @param useCache - Whether to use the cache. If false, always request.
 *
 * @returns A promise that resolves with the kernel specs.
 *
 * #### Notes
 * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernelspecs).
 */
async function getSpecs(settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = coreutils_1.URLExt.join(settings.baseUrl, KERNELSPEC_SERVICE_URL);
    const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
    if (response.status !== 200) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    return (0, validate_1.validateSpecModels)(data);
}
exports.getSpecs = getSpecs;
//# sourceMappingURL=restapi.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/kernelspec/validate.js":
/*!***********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/kernelspec/validate.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateSpecModels = exports.validateSpecModel = void 0;
const validate_1 = __webpack_require__(/*! ../validate */ "../node_modules/@jupyterlab/services/lib/validate.js");
/**
 * Validate a server kernelspec model to a client side model.
 */
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function validateSpecModel(data) {
    const spec = data.spec;
    if (!spec) {
        throw new Error('Invalid kernel spec');
    }
    (0, validate_1.validateProperty)(data, 'name', 'string');
    (0, validate_1.validateProperty)(data, 'resources', 'object');
    (0, validate_1.validateProperty)(spec, 'language', 'string');
    (0, validate_1.validateProperty)(spec, 'display_name', 'string');
    (0, validate_1.validateProperty)(spec, 'argv', 'array');
    let metadata = null;
    if (spec.hasOwnProperty('metadata')) {
        (0, validate_1.validateProperty)(spec, 'metadata', 'object');
        metadata = spec.metadata;
    }
    let env = null;
    if (spec.hasOwnProperty('env')) {
        (0, validate_1.validateProperty)(spec, 'env', 'object');
        env = spec.env;
    }
    return {
        name: data.name,
        resources: data.resources,
        language: spec.language,
        display_name: spec.display_name,
        argv: spec.argv,
        metadata,
        env
    };
}
exports.validateSpecModel = validateSpecModel;
/**
 * Validate a `Kernel.ISpecModels` object.
 */
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function validateSpecModels(data) {
    if (!data.hasOwnProperty('kernelspecs')) {
        throw new Error('No kernelspecs found');
    }
    let keys = Object.keys(data.kernelspecs);
    const kernelspecs = Object.create(null);
    let defaultSpec = data.default;
    for (let i = 0; i < keys.length; i++) {
        const ks = data.kernelspecs[keys[i]];
        try {
            kernelspecs[keys[i]] = validateSpecModel(ks);
        }
        catch (err) {
            // Remove the errant kernel spec.
            console.warn(`Removing errant kernel spec: ${keys[i]}`);
        }
    }
    keys = Object.keys(kernelspecs);
    if (!keys.length) {
        throw new Error('No valid kernelspecs found');
    }
    if (!defaultSpec ||
        typeof defaultSpec !== 'string' ||
        !(defaultSpec in kernelspecs)) {
        defaultSpec = keys[0];
        console.warn(`Default kernel not found, using '${keys[0]}'`);
    }
    return {
        default: defaultSpec,
        kernelspecs
    };
}
exports.validateSpecModels = validateSpecModels;
//# sourceMappingURL=validate.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/manager.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/manager.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ServiceManager = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const builder_1 = __webpack_require__(/*! ./builder */ "../node_modules/@jupyterlab/services/lib/builder/index.js");
const contents_1 = __webpack_require__(/*! ./contents */ "../node_modules/@jupyterlab/services/lib/contents/index.js");
const event_1 = __webpack_require__(/*! ./event */ "../node_modules/@jupyterlab/services/lib/event/index.js");
const kernel_1 = __webpack_require__(/*! ./kernel */ "../node_modules/@jupyterlab/services/lib/kernel/index.js");
const kernelspec_1 = __webpack_require__(/*! ./kernelspec */ "../node_modules/@jupyterlab/services/lib/kernelspec/index.js");
const nbconvert_1 = __webpack_require__(/*! ./nbconvert */ "../node_modules/@jupyterlab/services/lib/nbconvert/index.js");
const serverconnection_1 = __webpack_require__(/*! ./serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
const session_1 = __webpack_require__(/*! ./session */ "../node_modules/@jupyterlab/services/lib/session/index.js");
const setting_1 = __webpack_require__(/*! ./setting */ "../node_modules/@jupyterlab/services/lib/setting/index.js");
const terminal_1 = __webpack_require__(/*! ./terminal */ "../node_modules/@jupyterlab/services/lib/terminal/index.js");
const user_1 = __webpack_require__(/*! ./user */ "../node_modules/@jupyterlab/services/lib/user/index.js");
const workspace_1 = __webpack_require__(/*! ./workspace */ "../node_modules/@jupyterlab/services/lib/workspace/index.js");
/**
 * A Jupyter services manager.
 */
class ServiceManager {
    /**
     * Construct a new services provider.
     */
    constructor(options = {}) {
        var _a, _b;
        this._isDisposed = false;
        this._connectionFailure = new signaling_1.Signal(this);
        this._isReady = false;
        const defaultDrive = options.defaultDrive;
        const serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
        const standby = (_b = options.standby) !== null && _b !== void 0 ? _b : 'when-hidden';
        const normalized = { defaultDrive, serverSettings, standby };
        this.serverSettings = serverSettings;
        this.contents = options.contents || new contents_1.ContentsManager(normalized);
        this.events = options.events || new event_1.EventManager(normalized);
        this.kernels = options.kernels || new kernel_1.KernelManager(normalized);
        this.sessions =
            options.sessions ||
                new session_1.SessionManager({
                    ...normalized,
                    kernelManager: this.kernels
                });
        this.settings = options.settings || new setting_1.SettingManager(normalized);
        this.terminals = options.terminals || new terminal_1.TerminalManager(normalized);
        this.builder = options.builder || new builder_1.BuildManager(normalized);
        this.workspaces = options.workspaces || new workspace_1.WorkspaceManager(normalized);
        this.nbconvert = options.nbconvert || new nbconvert_1.NbConvertManager(normalized);
        this.kernelspecs = options.kernelspecs || new kernelspec_1.KernelSpecManager(normalized);
        this.user = options.user || new user_1.UserManager(normalized);
        // Proxy all connection failures from the individual service managers.
        this.kernelspecs.connectionFailure.connect(this._onConnectionFailure, this);
        this.sessions.connectionFailure.connect(this._onConnectionFailure, this);
        this.terminals.connectionFailure.connect(this._onConnectionFailure, this);
        // Define promises that need to be resolved before service manager is ready.
        const readyList = [this.sessions.ready, this.kernelspecs.ready];
        if (this.terminals.isAvailable()) {
            readyList.push(this.terminals.ready);
        }
        this._readyPromise = Promise.all(readyList).then(() => {
            this._isReady = true;
        });
    }
    /**
     * A signal emitted when there is a connection failure with the kernel.
     */
    get connectionFailure() {
        return this._connectionFailure;
    }
    /**
     * Test whether the service manager is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources used by the manager.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        signaling_1.Signal.clearData(this);
        this.contents.dispose();
        this.events.dispose();
        this.sessions.dispose();
        this.terminals.dispose();
    }
    /**
     * Test whether the manager is ready.
     */
    get isReady() {
        return this._isReady;
    }
    /**
     * A promise that fulfills when the manager is ready.
     */
    get ready() {
        return this._readyPromise;
    }
    _onConnectionFailure(sender, err) {
        this._connectionFailure.emit(err);
    }
}
exports.ServiceManager = ServiceManager;
//# sourceMappingURL=manager.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/nbconvert/index.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/nbconvert/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NbConvertManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
const coreutils_2 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
/**
 * The url for the lab nbconvert service.
 */
const NBCONVERT_SETTINGS_URL = 'api/nbconvert';
/**
 * The nbconvert API service manager.
 */
class NbConvertManager {
    /**
     * Create a new nbconvert manager.
     */
    constructor(options = {}) {
        var _a;
        this._exportFormats = null;
        this.serverSettings =
            (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
    }
    /**
     * Fetch and cache the export formats from the expensive nbconvert handler.
     */
    async fetchExportFormats() {
        this._requestingFormats = new coreutils_2.PromiseDelegate();
        this._exportFormats = null;
        const base = this.serverSettings.baseUrl;
        const url = coreutils_1.URLExt.join(base, NBCONVERT_SETTINGS_URL);
        const { serverSettings } = this;
        const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, serverSettings);
        if (response.status !== 200) {
            const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
            throw err;
        }
        const data = await response.json();
        const exportList = {};
        const keys = Object.keys(data);
        keys.forEach(function (key) {
            const mimeType = data[key].output_mimetype;
            exportList[key] = { output_mimetype: mimeType };
        });
        this._exportFormats = exportList;
        this._requestingFormats.resolve(exportList);
        return exportList;
    }
    /**
     * Get the list of export formats, preferring pre-cached ones.
     */
    async getExportFormats(force = true) {
        if (this._requestingFormats) {
            return this._requestingFormats.promise;
        }
        if (force || !this._exportFormats) {
            return await this.fetchExportFormats();
        }
        return this._exportFormats;
    }
}
exports.NbConvertManager = NbConvertManager;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/serverconnection.js":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/serverconnection.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ServerConnection = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const serialize_1 = __webpack_require__(/*! ./kernel/serialize */ "../node_modules/@jupyterlab/services/lib/kernel/serialize.js");
let WEBSOCKET;
if (typeof window === 'undefined') {
    // Mangle the require statements so it does not get picked up in the
    // browser assets.
    WEBSOCKET = __webpack_require__(/*! ws */ "../node_modules/@jupyterlab/services/lib/shim/ws.js");
}
else {
    WEBSOCKET = WebSocket;
}
/**
 * The namespace for ServerConnection functions.
 *
 * #### Notes
 * This is only intended to manage communication with the Jupyter server.
 *
 * The default values can be used in a JupyterLab or Jupyter Notebook context.
 *
 * We use `token` authentication if available, falling back on an XSRF
 * cookie if one has been provided on the `document`.
 *
 * A content type of `'application/json'` is added when using authentication
 * and there is no body data to allow the server to prevent malicious forms.
 */
var ServerConnection;
(function (ServerConnection) {
    /**
     * Create a settings object given a subset of options.
     *
     * @param options - An optional partial set of options.
     *
     * @returns The full settings object.
     */
    function makeSettings(options) {
        return Private.makeSettings(options);
    }
    ServerConnection.makeSettings = makeSettings;
    /**
     * Make an request to the notebook server.
     *
     * @param url - The url for the request.
     *
     * @param init - The initialization options for the request.
     *
     * @param settings - The server settings to apply to the request.
     *
     * @returns a Promise that resolves with the response.
     *
     * @throws If the url of the request is not a notebook server url.
     *
     * #### Notes
     * The `url` must start with `settings.baseUrl`.  The `init` settings are
     * merged with `settings.init`, with `init` taking precedence.
     * The headers in the two objects are not merged.
     * If there is no body data, we set the content type to `application/json`
     * because it is required by the Notebook server.
     */
    function makeRequest(url, init, settings) {
        return Private.handleRequest(url, init, settings);
    }
    ServerConnection.makeRequest = makeRequest;
    /**
     * A wrapped error for a fetch response.
     */
    class ResponseError extends Error {
        /**
         * Create a ResponseError from a response, handling the traceback and message
         * as appropriate.
         *
         * @param response The response object.
         *
         * @returns A promise that resolves with a `ResponseError` object.
         */
        static async create(response) {
            try {
                const data = await response.json();
                const { message, traceback } = data;
                if (traceback) {
                    console.error(traceback);
                }
                return new ResponseError(response, message !== null && message !== void 0 ? message : ResponseError._defaultMessage(response), traceback !== null && traceback !== void 0 ? traceback : '');
            }
            catch (e) {
                console.debug(e);
                return new ResponseError(response);
            }
        }
        /**
         * Create a new response error.
         */
        constructor(response, message = ResponseError._defaultMessage(response), traceback = '') {
            super(message);
            this.response = response;
            this.traceback = traceback;
        }
        static _defaultMessage(response) {
            return `Invalid response: ${response.status} ${response.statusText}`;
        }
    }
    ServerConnection.ResponseError = ResponseError;
    /**
     * A wrapped error for a network error.
     */
    class NetworkError extends TypeError {
        /**
         * Create a new network error.
         */
        constructor(original) {
            super(original.message);
            this.stack = original.stack;
        }
    }
    ServerConnection.NetworkError = NetworkError;
})(ServerConnection || (exports.ServerConnection = ServerConnection = {}));
/**
 * The namespace for module private data.
 */
var Private;
(function (Private) {
    /**
     * Handle the server connection settings, returning a new value.
     */
    function makeSettings(options = {}) {
        var _a;
        const pageBaseUrl = coreutils_1.PageConfig.getBaseUrl();
        const pageWsUrl = coreutils_1.PageConfig.getWsUrl();
        const baseUrl = coreutils_1.URLExt.normalize(options.baseUrl) || pageBaseUrl;
        let wsUrl = options.wsUrl;
        // Prefer the default wsUrl if we are using the default baseUrl.
        if (!wsUrl && baseUrl === pageBaseUrl) {
            wsUrl = pageWsUrl;
        }
        // Otherwise convert the baseUrl to a wsUrl if possible.
        if (!wsUrl && baseUrl.indexOf('http') === 0) {
            wsUrl = 'ws' + baseUrl.slice(4);
        }
        // Otherwise fall back on the default wsUrl.
        wsUrl = wsUrl !== null && wsUrl !== void 0 ? wsUrl : pageWsUrl;
        const appendTokenConfig = coreutils_1.PageConfig.getOption('appendToken').toLowerCase();
        let appendToken;
        if (appendTokenConfig === '') {
            appendToken =
                typeof window === 'undefined' ||
                    (typeof process !== 'undefined' &&
                        ((_a = process === null || process === void 0 ? void 0 : process.env) === null || _a === void 0 ? void 0 : _a.JEST_WORKER_ID) !== undefined) ||
                    coreutils_1.URLExt.getHostName(pageBaseUrl) !== coreutils_1.URLExt.getHostName(wsUrl);
        }
        else {
            appendToken = appendTokenConfig === 'true';
        }
        return {
            init: { cache: 'no-store', credentials: 'same-origin' },
            fetch,
            Headers,
            Request,
            WebSocket: WEBSOCKET,
            token: coreutils_1.PageConfig.getToken(),
            appUrl: coreutils_1.PageConfig.getOption('appUrl'),
            appendToken,
            serializer: { serialize: serialize_1.serialize, deserialize: serialize_1.deserialize },
            ...options,
            baseUrl,
            wsUrl
        };
    }
    Private.makeSettings = makeSettings;
    /**
     * Handle a request.
     *
     * @param url - The url for the request.
     *
     * @param init - The overrides for the request init.
     *
     * @param settings - The settings object for the request.
     *
     * #### Notes
     * The `url` must start with `settings.baseUrl`.  The `init` settings
     * take precedence over `settings.init`.
     */
    function handleRequest(url, init, settings) {
        var _a;
        // Handle notebook server requests.
        if (url.indexOf(settings.baseUrl) !== 0) {
            throw new Error('Can only be used for notebook server requests');
        }
        // Use explicit cache buster when `no-store` is set since
        // not all browsers use it properly.
        const cache = (_a = init.cache) !== null && _a !== void 0 ? _a : settings.init.cache;
        if (cache === 'no-store') {
            // https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/Using_XMLHttpRequest#Bypassing_the_cache
            url += (/\?/.test(url) ? '&' : '?') + new Date().getTime();
        }
        const request = new settings.Request(url, { ...settings.init, ...init });
        // Handle authentication. Authentication can be overdetermined by
        // settings token and XSRF token.
        let authenticated = false;
        if (settings.token) {
            authenticated = true;
            request.headers.append('Authorization', `token ${settings.token}`);
        }
        if (typeof document !== 'undefined') {
            const xsrfToken = getCookie('_xsrf');
            if (xsrfToken !== undefined) {
                authenticated = true;
                request.headers.append('X-XSRFToken', xsrfToken);
            }
        }
        // Set the content type if there is no given data and we are
        // using an authenticated connection.
        if (!request.headers.has('Content-Type') && authenticated) {
            request.headers.set('Content-Type', 'application/json');
        }
        // Use `call` to avoid a `TypeError` in the browser.
        return settings.fetch.call(null, request).catch((e) => {
            // Convert the TypeError into a more specific error.
            throw new ServerConnection.NetworkError(e);
        });
        // TODO: *this* is probably where we need a system-wide connectionFailure
        // signal we can hook into.
    }
    Private.handleRequest = handleRequest;
    /**
     * Get a cookie from the document.
     */
    function getCookie(name) {
        // From http://www.tornadoweb.org/en/stable/guide/security.html
        let cookie = '';
        try {
            cookie = document.cookie;
        }
        catch (e) {
            // e.g. SecurityError in case of CSP Sandbox
            return;
        }
        const matches = cookie.match('\\b' + name + '=([^;]*)\\b');
        return matches === null || matches === void 0 ? void 0 : matches[1];
    }
})(Private || (Private = {}));
//# sourceMappingURL=serverconnection.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/session/default.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/session/default.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SessionConnection = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "../node_modules/@jupyterlab/services/lib/index.js");
const restapi_1 = __webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/session/restapi.js");
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
/**
 * Session object for accessing the session REST api. The session
 * should be used to start kernels and then shut them down -- for
 * all other kernel operations, the kernel object should be used.
 */
class SessionConnection {
    /**
     * Construct a new session.
     */
    constructor(options) {
        var _a, _b, _c, _d;
        this._id = '';
        this._path = '';
        this._name = '';
        this._type = '';
        this._kernel = null;
        this._isDisposed = false;
        this._disposed = new signaling_1.Signal(this);
        this._kernelChanged = new signaling_1.Signal(this);
        this._statusChanged = new signaling_1.Signal(this);
        this._connectionStatusChanged = new signaling_1.Signal(this);
        this._pendingInput = new signaling_1.Signal(this);
        this._iopubMessage = new signaling_1.Signal(this);
        this._unhandledMessage = new signaling_1.Signal(this);
        this._anyMessage = new signaling_1.Signal(this);
        this._propertyChanged = new signaling_1.Signal(this);
        this._id = options.model.id;
        this._name = options.model.name;
        this._path = options.model.path;
        this._type = options.model.type;
        this._username = (_a = options.username) !== null && _a !== void 0 ? _a : '';
        this._clientId = (_b = options.clientId) !== null && _b !== void 0 ? _b : coreutils_1.UUID.uuid4();
        this._connectToKernel = options.connectToKernel;
        this._kernelConnectionOptions = (_c = options.kernelConnectionOptions) !== null && _c !== void 0 ? _c : {};
        this.serverSettings =
            (_d = options.serverSettings) !== null && _d !== void 0 ? _d : __1.ServerConnection.makeSettings();
        this.setupKernel(options.model.kernel);
    }
    /**
     * A signal emitted when the session is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * A signal emitted when the kernel changes.
     */
    get kernelChanged() {
        return this._kernelChanged;
    }
    /**
     * A signal proxied from the connection about the kernel status.
     */
    get statusChanged() {
        return this._statusChanged;
    }
    /**
     * A signal proxied from the kernel about the connection status.
     */
    get connectionStatusChanged() {
        return this._connectionStatusChanged;
    }
    /**
     * A signal proxied from the kernel pending input.
     */
    get pendingInput() {
        return this._pendingInput;
    }
    /**
     * A signal proxied from the kernel about iopub kernel messages.
     */
    get iopubMessage() {
        return this._iopubMessage;
    }
    /**
     * A signal proxied from the kernel for an unhandled kernel message.
     */
    get unhandledMessage() {
        return this._unhandledMessage;
    }
    /**
     * A signal proxied from the kernel emitted for any kernel message.
     *
     * #### Notes
     * The behavior is undefined if the message is modified during message
     * handling. As such, it should be treated as read-only.
     */
    get anyMessage() {
        return this._anyMessage;
    }
    /**
     * A signal emitted when a session property changes.
     */
    get propertyChanged() {
        return this._propertyChanged;
    }
    /**
     * Get the session id.
     */
    get id() {
        return this._id;
    }
    /**
     * Get the session kernel connection object.
     *
     * #### Notes
     * This is a read-only property, and can be altered by [changeKernel].
     */
    get kernel() {
        return this._kernel;
    }
    /**
     * Get the session path.
     */
    get path() {
        return this._path;
    }
    /**
     * Get the session type.
     */
    get type() {
        return this._type;
    }
    /**
     * Get the session name.
     */
    get name() {
        return this._name;
    }
    /**
     * Get the model associated with the session.
     */
    get model() {
        return {
            id: this.id,
            kernel: this.kernel && { id: this.kernel.id, name: this.kernel.name },
            path: this._path,
            type: this._type,
            name: this._name
        };
    }
    /**
     * Test whether the session has been disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Update the session based on a session model from the server.
     *
     * #### Notes
     * This only updates this session connection instance. Use `setPath`,
     * `setName`, `setType`, and `changeKernel` to change the session values on
     * the server.
     */
    update(model) {
        const oldModel = this.model;
        this._path = model.path;
        this._name = model.name;
        this._type = model.type;
        if ((this._kernel === null && model.kernel !== null) ||
            (this._kernel !== null && model.kernel === null) ||
            (this._kernel !== null &&
                model.kernel !== null &&
                this._kernel.id !== model.kernel.id)) {
            if (this._kernel !== null) {
                this._kernel.dispose();
            }
            const oldValue = this._kernel || null;
            this.setupKernel(model.kernel);
            const newValue = this._kernel || null;
            this._kernelChanged.emit({ name: 'kernel', oldValue, newValue });
        }
        this._handleModelChange(oldModel);
    }
    /**
     * Dispose of the resources held by the session.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._disposed.emit();
        if (this._kernel) {
            this._kernel.dispose();
            const oldValue = this._kernel;
            this._kernel = null;
            const newValue = this._kernel;
            this._kernelChanged.emit({ name: 'kernel', oldValue, newValue });
        }
        signaling_1.Signal.clearData(this);
    }
    /**
     * Change the session path.
     *
     * @param path - The new session path.
     *
     * @returns A promise that resolves when the session has renamed.
     *
     * #### Notes
     * This uses the Jupyter REST API, and the response is validated.
     * The promise is fulfilled on a valid response and rejected otherwise.
     */
    async setPath(path) {
        if (this.isDisposed) {
            throw new Error('Session is disposed');
        }
        await this._patch({ path });
    }
    /**
     * Change the session name.
     */
    async setName(name) {
        if (this.isDisposed) {
            throw new Error('Session is disposed');
        }
        await this._patch({ name });
    }
    /**
     * Change the session type.
     */
    async setType(type) {
        if (this.isDisposed) {
            throw new Error('Session is disposed');
        }
        await this._patch({ type });
    }
    /**
     * Change the kernel.
     *
     * @param options - The name or id of the new kernel.
     *
     * #### Notes
     * This shuts down the existing kernel and creates a new kernel,
     * keeping the existing session ID and session path.
     */
    async changeKernel(options) {
        if (this.isDisposed) {
            throw new Error('Session is disposed');
        }
        await this._patch({ kernel: options });
        return this.kernel;
    }
    /**
     * Kill the kernel and shutdown the session.
     *
     * @returns - The promise fulfilled on a valid response from the server.
     *
     * #### Notes
     * Uses the [Jupyter Server API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/sessions), and validates the response.
     * Disposes of the session and emits a [sessionDied] signal on success.
     */
    async shutdown() {
        if (this.isDisposed) {
            throw new Error('Session is disposed');
        }
        await (0, restapi_1.shutdownSession)(this.id, this.serverSettings);
        this.dispose();
    }
    /**
     * Create a new kernel connection and connect to its signals.
     *
     * #### Notes
     * This method is not meant to be subclassed.
     */
    setupKernel(model) {
        if (model === null) {
            this._kernel = null;
            return;
        }
        const kc = this._connectToKernel({
            ...this._kernelConnectionOptions,
            model,
            username: this._username,
            clientId: this._clientId,
            serverSettings: this.serverSettings
        });
        this._kernel = kc;
        kc.statusChanged.connect(this.onKernelStatus, this);
        kc.connectionStatusChanged.connect(this.onKernelConnectionStatus, this);
        kc.pendingInput.connect(this.onPendingInput, this);
        kc.unhandledMessage.connect(this.onUnhandledMessage, this);
        kc.iopubMessage.connect(this.onIOPubMessage, this);
        kc.anyMessage.connect(this.onAnyMessage, this);
    }
    /**
     * Handle to changes in the Kernel status.
     */
    onKernelStatus(sender, state) {
        this._statusChanged.emit(state);
    }
    /**
     * Handle to changes in the Kernel status.
     */
    onKernelConnectionStatus(sender, state) {
        this._connectionStatusChanged.emit(state);
    }
    /**
     * Handle a change in the pendingInput.
     */
    onPendingInput(sender, state) {
        this._pendingInput.emit(state);
    }
    /**
     * Handle iopub kernel messages.
     */
    onIOPubMessage(sender, msg) {
        this._iopubMessage.emit(msg);
    }
    /**
     * Handle unhandled kernel messages.
     */
    onUnhandledMessage(sender, msg) {
        this._unhandledMessage.emit(msg);
    }
    /**
     * Handle any kernel messages.
     */
    onAnyMessage(sender, args) {
        this._anyMessage.emit(args);
    }
    /**
     * Send a PATCH to the server, updating the session path or the kernel.
     */
    async _patch(body) {
        const model = await (0, restapi_1.updateSession)({ ...body, id: this._id }, this.serverSettings);
        this.update(model);
        return model;
    }
    /**
     * Handle a change to the model.
     */
    _handleModelChange(oldModel) {
        if (oldModel.name !== this._name) {
            this._propertyChanged.emit('name');
        }
        if (oldModel.type !== this._type) {
            this._propertyChanged.emit('type');
        }
        if (oldModel.path !== this._path) {
            this._propertyChanged.emit('path');
        }
    }
}
exports.SessionConnection = SessionConnection;
//# sourceMappingURL=default.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/session/index.js":
/*!*****************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/session/index.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SessionAPI = exports.Session = void 0;
const Session = __importStar(__webpack_require__(/*! ./session */ "../node_modules/@jupyterlab/services/lib/session/session.js"));
exports.Session = Session;
const SessionAPI = __importStar(__webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/session/restapi.js"));
exports.SessionAPI = SessionAPI;
__exportStar(__webpack_require__(/*! ./manager */ "../node_modules/@jupyterlab/services/lib/session/manager.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/session/manager.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/session/manager.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SessionManager = void 0;
const polling_1 = __webpack_require__(/*! @lumino/polling */ "../node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
const basemanager_1 = __webpack_require__(/*! ../basemanager */ "../node_modules/@jupyterlab/services/lib/basemanager.js");
const default_1 = __webpack_require__(/*! ./default */ "../node_modules/@jupyterlab/services/lib/session/default.js");
const restapi_1 = __webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/session/restapi.js");
/**
 * An implementation of a session manager.
 */
class SessionManager extends basemanager_1.BaseManager {
    /**
     * Construct a new session manager.
     *
     * @param options - The default options for each session.
     */
    constructor(options) {
        var _a;
        super(options);
        this._isReady = false;
        this._sessionConnections = new Set();
        this._models = new Map();
        this._runningChanged = new signaling_1.Signal(this);
        this._connectionFailure = new signaling_1.Signal(this);
        // We define these here so they bind `this` correctly
        this._connectToKernel = (options) => {
            return this._kernelManager.connectTo(options);
        };
        this._kernelManager = options.kernelManager;
        // Start model polling with exponential backoff.
        this._pollModels = new polling_1.Poll({
            auto: false,
            factory: () => this.requestRunning(),
            frequency: {
                interval: 10 * 1000,
                backoff: true,
                max: 300 * 1000
            },
            name: `@jupyterlab/services:SessionManager#models`,
            standby: (_a = options.standby) !== null && _a !== void 0 ? _a : 'when-hidden'
        });
        // Initialize internal data.
        this._ready = (async () => {
            await this._pollModels.start();
            await this._pollModels.tick;
            if (this._kernelManager.isActive) {
                await this._kernelManager.ready;
            }
            this._isReady = true;
        })();
    }
    /**
     * Test whether the manager is ready.
     */
    get isReady() {
        return this._isReady;
    }
    /**
     * A promise that fulfills when the manager is ready.
     */
    get ready() {
        return this._ready;
    }
    /**
     * A signal emitted when the running sessions change.
     */
    get runningChanged() {
        return this._runningChanged;
    }
    /**
     * A signal emitted when there is a connection failure.
     */
    get connectionFailure() {
        return this._connectionFailure;
    }
    /**
     * Dispose of the resources used by the manager.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._models.clear();
        this._sessionConnections.forEach(x => x.dispose());
        this._pollModels.dispose();
        super.dispose();
    }
    /*
     * Connect to a running session.  See also [[connectToSession]].
     */
    connectTo(options) {
        const sessionConnection = new default_1.SessionConnection({
            ...options,
            connectToKernel: this._connectToKernel,
            serverSettings: this.serverSettings
        });
        this._onStarted(sessionConnection);
        if (!this._models.has(options.model.id)) {
            // We trust the user to connect to an existing session, but we verify
            // asynchronously.
            void this.refreshRunning().catch(() => {
                /* no-op */
            });
        }
        return sessionConnection;
    }
    /**
     * Create an iterator over the most recent running sessions.
     *
     * @returns A new iterator over the running sessions.
     */
    running() {
        return this._models.values();
    }
    /**
     * Force a refresh of the running sessions.
     *
     * @returns A promise that with the list of running sessions.
     *
     * #### Notes
     * This is not typically meant to be called by the user, since the
     * manager maintains its own internal state.
     */
    async refreshRunning() {
        await this._pollModels.refresh();
        await this._pollModels.tick;
    }
    /**
     * Start a new session.  See also [[startNewSession]].
     *
     * @param createOptions - Options for creating the session
     *
     * @param connectOptions - Options for connecting to the session
     */
    async startNew(createOptions, connectOptions = {}) {
        const model = await (0, restapi_1.startSession)(createOptions, this.serverSettings);
        await this.refreshRunning();
        return this.connectTo({ ...connectOptions, model });
    }
    /**
     * Shut down a session by id.
     */
    async shutdown(id) {
        await (0, restapi_1.shutdownSession)(id, this.serverSettings);
        await this.refreshRunning();
    }
    /**
     * Shut down all sessions.
     *
     * @returns A promise that resolves when all of the kernels are shut down.
     */
    async shutdownAll() {
        // Update the list of models to make sure our list is current.
        await this.refreshRunning();
        // Shut down all models.
        await Promise.all([...this._models.keys()].map(id => (0, restapi_1.shutdownSession)(id, this.serverSettings)));
        // Update the list of models to clear out our state.
        await this.refreshRunning();
    }
    /**
     * Find a session associated with a path and stop it if it is the only session
     * using that kernel.
     *
     * @param path - The path in question.
     *
     * @returns A promise that resolves when the relevant sessions are stopped.
     */
    async stopIfNeeded(path) {
        try {
            const sessions = await (0, restapi_1.listRunning)(this.serverSettings);
            const matches = sessions.filter(value => value.path === path);
            if (matches.length === 1) {
                const id = matches[0].id;
                await this.shutdown(id);
            }
        }
        catch (error) {
            /* Always succeed. */
        }
    }
    /**
     * Find a session by id.
     */
    async findById(id) {
        if (this._models.has(id)) {
            return this._models.get(id);
        }
        await this.refreshRunning();
        return this._models.get(id);
    }
    /**
     * Find a session by path.
     */
    async findByPath(path) {
        for (const m of this._models.values()) {
            if (m.path === path) {
                return m;
            }
        }
        await this.refreshRunning();
        for (const m of this._models.values()) {
            if (m.path === path) {
                return m;
            }
        }
        return undefined;
    }
    /**
     * Execute a request to the server to poll running kernels and update state.
     */
    async requestRunning() {
        var _a, _b;
        let models;
        try {
            models = await (0, restapi_1.listRunning)(this.serverSettings);
        }
        catch (err) {
            // Handle network errors, as well as cases where we are on a
            // JupyterHub and the server is not running. JupyterHub returns a
            // 503 (<2.0) or 424 (>2.0) in that case.
            if (err instanceof serverconnection_1.ServerConnection.NetworkError ||
                ((_a = err.response) === null || _a === void 0 ? void 0 : _a.status) === 503 ||
                ((_b = err.response) === null || _b === void 0 ? void 0 : _b.status) === 424) {
                this._connectionFailure.emit(err);
            }
            throw err;
        }
        if (this.isDisposed) {
            return;
        }
        if (this._models.size === models.length &&
            models.every(model => {
                var _a, _b, _c, _d;
                const existing = this._models.get(model.id);
                if (!existing) {
                    return false;
                }
                return (((_a = existing.kernel) === null || _a === void 0 ? void 0 : _a.id) === ((_b = model.kernel) === null || _b === void 0 ? void 0 : _b.id) &&
                    ((_c = existing.kernel) === null || _c === void 0 ? void 0 : _c.name) === ((_d = model.kernel) === null || _d === void 0 ? void 0 : _d.name) &&
                    existing.name === model.name &&
                    existing.path === model.path &&
                    existing.type === model.type);
            })) {
            // Identical models list (presuming models does not contain duplicate
            // ids), so just return
            return;
        }
        this._models = new Map(models.map(x => [x.id, x]));
        this._sessionConnections.forEach(sc => {
            if (this._models.has(sc.id)) {
                sc.update(this._models.get(sc.id));
            }
            else {
                sc.dispose();
            }
        });
        this._runningChanged.emit(models);
    }
    /**
     * Handle a session starting.
     */
    _onStarted(sessionConnection) {
        this._sessionConnections.add(sessionConnection);
        sessionConnection.disposed.connect(this._onDisposed, this);
        sessionConnection.propertyChanged.connect(this._onChanged, this);
        sessionConnection.kernelChanged.connect(this._onChanged, this);
    }
    _onDisposed(sessionConnection) {
        this._sessionConnections.delete(sessionConnection);
        // A session termination emission could mean the server session is deleted,
        // or that the session JS object is disposed and the session still exists on
        // the server, so we refresh from the server to make sure we reflect the
        // server state.
        void this.refreshRunning().catch(() => {
            /* no-op */
        });
    }
    _onChanged() {
        void this.refreshRunning().catch(() => {
            /* no-op */
        });
    }
}
exports.SessionManager = SessionManager;
/**
 * The namespace for `SessionManager` class statics.
 */
(function (SessionManager) {
    /**
     * A no-op session manager to be used when starting sessions is not supported.
     */
    class NoopManager extends SessionManager {
        constructor() {
            super(...arguments);
            this._readyPromise = new Promise(() => {
                /* no-op */
            });
        }
        /**
         * Whether the manager is active.
         */
        get isActive() {
            return false;
        }
        /**
         * Used for testing.
         */
        get parentReady() {
            return super.ready;
        }
        /**
         * Start a new session - throw an error since it is not supported.
         */
        async startNew(createOptions, connectOptions = {}) {
            return Promise.reject(new Error('Not implemented in no-op Session Manager'));
        }
        /*
         * Connect to a running session - throw an error since it is not supported.
         */
        connectTo(options) {
            throw Error('Not implemented in no-op Session Manager');
        }
        /**
         * A promise that fulfills when the manager is ready (never).
         */
        get ready() {
            return this.parentReady.then(() => this._readyPromise);
        }
        /**
         * Shut down a session by id - throw an error since it is not supported.
         */
        async shutdown(id) {
            return Promise.reject(new Error('Not implemented in no-op Session Manager'));
        }
        /**
         * Execute a request to the server to poll running sessions and update state.
         */
        async requestRunning() {
            return Promise.resolve();
        }
    }
    SessionManager.NoopManager = NoopManager;
})(SessionManager || (exports.SessionManager = SessionManager = {}));
//# sourceMappingURL=manager.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/session/restapi.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/session/restapi.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.updateSession = exports.startSession = exports.getSessionModel = exports.shutdownSession = exports.getSessionUrl = exports.listRunning = exports.SESSION_SERVICE_URL = void 0;
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const validate_1 = __webpack_require__(/*! ./validate */ "../node_modules/@jupyterlab/services/lib/session/validate.js");
/**
 * The url for the session service.
 */
exports.SESSION_SERVICE_URL = 'api/sessions';
/**
 * List the running sessions.
 */
async function listRunning(settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = coreutils_1.URLExt.join(settings.baseUrl, exports.SESSION_SERVICE_URL);
    const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
    if (response.status !== 200) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    if (!Array.isArray(data)) {
        throw new Error('Invalid Session list');
    }
    data.forEach(m => {
        (0, validate_1.updateLegacySessionModel)(m);
        (0, validate_1.validateModel)(m);
    });
    return data;
}
exports.listRunning = listRunning;
/**
 * Get a session url.
 */
function getSessionUrl(baseUrl, id) {
    const servicesBase = coreutils_1.URLExt.join(baseUrl, exports.SESSION_SERVICE_URL);
    const result = coreutils_1.URLExt.join(servicesBase, id);
    if (!result.startsWith(servicesBase)) {
        throw new Error('Can only be used for services requests');
    }
    return result;
}
exports.getSessionUrl = getSessionUrl;
/**
 * Shut down a session by id.
 */
async function shutdownSession(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
    var _a;
    const url = getSessionUrl(settings.baseUrl, id);
    const init = { method: 'DELETE' };
    const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
    if (response.status === 404) {
        const data = await response.json();
        const msg = (_a = data.message) !== null && _a !== void 0 ? _a : `The session "${id}"" does not exist on the server`;
        console.warn(msg);
    }
    else if (response.status === 410) {
        throw new serverconnection_1.ServerConnection.ResponseError(response, 'The kernel was deleted but the session was not');
    }
    else if (response.status !== 204) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
}
exports.shutdownSession = shutdownSession;
/**
 * Get a full session model from the server by session id string.
 */
async function getSessionModel(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = getSessionUrl(settings.baseUrl, id);
    const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
    if (response.status !== 200) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    (0, validate_1.updateLegacySessionModel)(data);
    (0, validate_1.validateModel)(data);
    return data;
}
exports.getSessionModel = getSessionModel;
/**
 * Create a new session, or return an existing session if the session path
 * already exists.
 */
async function startSession(options, settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = coreutils_1.URLExt.join(settings.baseUrl, exports.SESSION_SERVICE_URL);
    const init = {
        method: 'POST',
        body: JSON.stringify(options)
    };
    const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
    if (response.status !== 201) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    (0, validate_1.updateLegacySessionModel)(data);
    (0, validate_1.validateModel)(data);
    return data;
}
exports.startSession = startSession;
/**
 * Send a PATCH to the server, updating the session path or the kernel.
 */
async function updateSession(model, settings = serverconnection_1.ServerConnection.makeSettings()) {
    const url = getSessionUrl(settings.baseUrl, model.id);
    const init = {
        method: 'PATCH',
        body: JSON.stringify(model)
    };
    const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
    if (response.status !== 200) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    (0, validate_1.updateLegacySessionModel)(data);
    (0, validate_1.validateModel)(data);
    return data;
}
exports.updateSession = updateSession;
//# sourceMappingURL=restapi.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/session/session.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/session/session.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=session.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/session/validate.js":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/session/validate.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateModels = exports.updateLegacySessionModel = exports.validateModel = void 0;
const validate_1 = __webpack_require__(/*! ../kernel/validate */ "../node_modules/@jupyterlab/services/lib/kernel/validate.js");
const validate_2 = __webpack_require__(/*! ../validate */ "../node_modules/@jupyterlab/services/lib/validate.js");
/**
 * Validate an `Session.IModel` object.
 */
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function validateModel(data) {
    (0, validate_2.validateProperty)(data, 'id', 'string');
    (0, validate_2.validateProperty)(data, 'type', 'string');
    (0, validate_2.validateProperty)(data, 'name', 'string');
    (0, validate_2.validateProperty)(data, 'path', 'string');
    (0, validate_2.validateProperty)(data, 'kernel', 'object');
    (0, validate_1.validateModel)(data.kernel);
}
exports.validateModel = validateModel;
/**
 * Update model from legacy session data.
 */
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function updateLegacySessionModel(data) {
    if (data.path === undefined && data.notebook !== undefined) {
        data.path = data.notebook.path;
        data.type = 'notebook';
        data.name = '';
    }
}
exports.updateLegacySessionModel = updateLegacySessionModel;
/**
 * Validate an array of `Session.IModel` objects.
 */
function validateModels(models) {
    if (!Array.isArray(models)) {
        throw new Error('Invalid session list');
    }
    models.forEach(d => validateModel(d));
}
exports.validateModels = validateModels;
//# sourceMappingURL=validate.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/setting/index.js":
/*!*****************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/setting/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SettingManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const statedb_1 = __webpack_require__(/*! @jupyterlab/statedb */ "../node_modules/@jupyterlab/statedb/lib/index.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
/**
 * The url for the lab settings service.
 */
const SERVICE_SETTINGS_URL = 'api/settings';
/**
 * The settings API service manager.
 */
class SettingManager extends statedb_1.DataConnector {
    /**
     * Create a new setting manager.
     */
    constructor(options = {}) {
        var _a;
        super();
        this.serverSettings =
            (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
    }
    /**
     * Fetch a plugin's settings.
     *
     * @param id - The plugin's ID.
     *
     * @returns A promise that resolves if successful.
     */
    async fetch(id) {
        if (!id) {
            throw new Error('Plugin `id` parameter is required for settings fetch.');
        }
        const { serverSettings } = this;
        const { baseUrl, appUrl } = serverSettings;
        const { makeRequest, ResponseError } = serverconnection_1.ServerConnection;
        const base = baseUrl + appUrl;
        const url = Private.url(base, id);
        const response = await makeRequest(url, {}, serverSettings);
        if (response.status !== 200) {
            const err = await ResponseError.create(response);
            throw err;
        }
        // Assert what type the server response is returning.
        return response.json();
    }
    /**
     * Fetch the list of all plugin setting bundles.
     *
     * @returns A promise that resolves if successful.
     */
    async list(query) {
        var _a, _b, _c, _d;
        const { serverSettings } = this;
        const { baseUrl, appUrl } = serverSettings;
        const { makeRequest, ResponseError } = serverconnection_1.ServerConnection;
        const base = baseUrl + appUrl;
        const url = Private.url(base, '', query === 'ids');
        const response = await makeRequest(url, {}, serverSettings);
        if (response.status !== 200) {
            throw new ResponseError(response);
        }
        const json = await response.json();
        const ids = (_b = (_a = json === null || json === void 0 ? void 0 : json['settings']) === null || _a === void 0 ? void 0 : _a.map((plugin) => plugin.id)) !== null && _b !== void 0 ? _b : [];
        let values = [];
        if (!query) {
            values =
                (_d = (_c = json === null || json === void 0 ? void 0 : json['settings']) === null || _c === void 0 ? void 0 : _c.map((plugin) => {
                    plugin.data = { composite: {}, user: {} };
                    return plugin;
                })) !== null && _d !== void 0 ? _d : [];
        }
        return { ids, values };
    }
    /**
     * Save a plugin's settings.
     *
     * @param id - The plugin's ID.
     *
     * @param raw - The user setting values as a raw string of JSON with comments.
     *
     * @returns A promise that resolves if successful.
     */
    async save(id, raw) {
        const { serverSettings } = this;
        const { baseUrl, appUrl } = serverSettings;
        const { makeRequest, ResponseError } = serverconnection_1.ServerConnection;
        const base = baseUrl + appUrl;
        const url = Private.url(base, id);
        // NOTE: 'raw' is JSON5 (not valid JSON), so we encode it as a string in a valid JSON body
        const init = { body: JSON.stringify({ raw }), method: 'PUT' };
        const response = await makeRequest(url, init, serverSettings);
        if (response.status !== 204) {
            throw new ResponseError(response);
        }
    }
}
exports.SettingManager = SettingManager;
/**
 * A namespace for private data.
 */
var Private;
(function (Private) {
    /**
     * Get the url for a plugin's settings.
     */
    function url(base, id, idsOnly) {
        const idsOnlyParam = idsOnly
            ? coreutils_1.URLExt.objectToQueryString({ ids_only: true })
            : '';
        const settingsBase = coreutils_1.URLExt.join(base, SERVICE_SETTINGS_URL);
        const result = coreutils_1.URLExt.join(settingsBase, id);
        if (!result.startsWith(settingsBase)) {
            throw new Error('Can only be used for workspaces requests');
        }
        return `${result}${idsOnlyParam}`;
    }
    Private.url = url;
})(Private || (Private = {}));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/shim/ws.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/shim/ws.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports["default"] = WebSocket;
//# sourceMappingURL=ws.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/terminal/default.js":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/terminal/default.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalConnection = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const coreutils_2 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "../node_modules/@jupyterlab/services/lib/index.js");
const restapi_1 = __webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/terminal/restapi.js");
/**
 * An implementation of a terminal interface.
 */
class TerminalConnection {
    /**
     * Construct a new terminal session.
     */
    constructor(options) {
        var _a;
        /**
         * Create the terminal websocket connection and add socket status handlers.
         *
         * #### Notes
         * You are responsible for updating the connection status as appropriate.
         */
        this._createSocket = () => {
            this._errorIfDisposed();
            // Make sure the socket is clear
            this._clearSocket();
            // Update the connection status to reflect opening a new connection.
            this._updateConnectionStatus('connecting');
            const name = this._name;
            const settings = this.serverSettings;
            let url = coreutils_1.URLExt.join(settings.wsUrl, 'terminals', 'websocket', encodeURIComponent(name));
            // If token authentication is in use.
            const token = settings.token;
            if (settings.appendToken && token !== '') {
                url = url + `?token=${encodeURIComponent(token)}`;
            }
            this._ws = new settings.WebSocket(url);
            this._ws.onmessage = this._onWSMessage;
            this._ws.onclose = this._onWSClose;
            this._ws.onerror = this._onWSClose;
        };
        // Websocket messages events are defined as variables to bind `this`
        this._onWSMessage = (event) => {
            if (this._isDisposed) {
                return;
            }
            const data = JSON.parse(event.data);
            // Handle a disconnect message.
            if (data[0] === 'disconnect') {
                this.dispose();
            }
            if (this._connectionStatus === 'connecting') {
                // After reconnection, ignore all messages until a 'setup' message
                // before we are truly connected. Setting the connection status to
                // connected only then means that if we do not get a setup message
                // before our retry timeout, we will delete the websocket and try again.
                if (data[0] === 'setup') {
                    this._updateConnectionStatus('connected');
                }
                return;
            }
            this._messageReceived.emit({
                type: data[0],
                content: data.slice(1)
            });
        };
        this._onWSClose = (event) => {
            console.warn(`Terminal websocket closed: ${event.code}`);
            if (!this.isDisposed) {
                this._reconnect();
            }
        };
        this._connectionStatus = 'connecting';
        this._connectionStatusChanged = new signaling_1.Signal(this);
        this._isDisposed = false;
        this._disposed = new signaling_1.Signal(this);
        this._messageReceived = new signaling_1.Signal(this);
        this._reconnectTimeout = null;
        this._ws = null;
        this._noOp = () => {
            /* no-op */
        };
        this._reconnectLimit = 7;
        this._reconnectAttempt = 0;
        this._pendingMessages = [];
        this._name = options.model.name;
        this.serverSettings =
            (_a = options.serverSettings) !== null && _a !== void 0 ? _a : __1.ServerConnection.makeSettings();
        this._createSocket();
    }
    /**
     * A signal emitted when the session is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * A signal emitted when a message is received from the server.
     */
    get messageReceived() {
        return this._messageReceived;
    }
    /**
     * Get the name of the terminal session.
     */
    get name() {
        return this._name;
    }
    /**
     * Get the model for the terminal session.
     */
    get model() {
        return { name: this._name };
    }
    /**
     * Test whether the session is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the session.
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._disposed.emit();
        this._updateConnectionStatus('disconnected');
        this._clearSocket();
        signaling_1.Signal.clearData(this);
    }
    /**
     * Send a message to the terminal session.
     *
     * #### Notes
     * If the connection is down, the message will be queued for sending when
     * the connection comes back up.
     */
    send(message) {
        this._sendMessage(message);
    }
    /**
     * Send a message on the websocket, or possibly queue for later sending.
     *
     * @param queue - whether to queue the message if it cannot be sent
     */
    _sendMessage(message, queue = true) {
        if (this._isDisposed || !message.content) {
            return;
        }
        if (this.connectionStatus === 'connected' && this._ws) {
            const msg = [message.type, ...message.content];
            this._ws.send(JSON.stringify(msg));
        }
        else if (queue) {
            this._pendingMessages.push(message);
        }
        else {
            throw new Error(`Could not send message: ${JSON.stringify(message)}`);
        }
    }
    /**
     * Send pending messages to the kernel.
     */
    _sendPending() {
        // We check to make sure we are still connected each time. For
        // example, if a websocket buffer overflows, it may close, so we should
        // stop sending messages.
        while (this.connectionStatus === 'connected' &&
            this._pendingMessages.length > 0) {
            this._sendMessage(this._pendingMessages[0], false);
            // We shift the message off the queue after the message is sent so that
            // if there is an exception, the message is still pending.
            this._pendingMessages.shift();
        }
    }
    /**
     * Reconnect to a terminal.
     *
     * #### Notes
     * This may try multiple times to reconnect to a terminal, and will sever
     * any existing connection.
     */
    reconnect() {
        this._errorIfDisposed();
        const result = new coreutils_2.PromiseDelegate();
        // Set up a listener for the connection status changing, which accepts or
        // rejects after the retries are done.
        const fulfill = (sender, status) => {
            if (status === 'connected') {
                result.resolve();
                this.connectionStatusChanged.disconnect(fulfill, this);
            }
            else if (status === 'disconnected') {
                result.reject(new Error('Terminal connection disconnected'));
                this.connectionStatusChanged.disconnect(fulfill, this);
            }
        };
        this.connectionStatusChanged.connect(fulfill, this);
        // Reset the reconnect limit so we start the connection attempts fresh
        this._reconnectAttempt = 0;
        // Start the reconnection process, which will also clear any existing
        // connection.
        this._reconnect();
        // Return the promise that should resolve on connection or reject if the
        // retries don't work.
        return result.promise;
    }
    /**
     * Attempt a connection if we have not exhausted connection attempts.
     */
    _reconnect() {
        this._errorIfDisposed();
        // Clear any existing reconnection attempt
        clearTimeout(this._reconnectTimeout);
        // Update the connection status and schedule a possible reconnection.
        if (this._reconnectAttempt < this._reconnectLimit) {
            this._updateConnectionStatus('connecting');
            // The first reconnect attempt should happen immediately, and subsequent
            // attempts should pick a random number in a growing range so that we
            // don't overload the server with synchronized reconnection attempts
            // across multiple kernels.
            const timeout = Private.getRandomIntInclusive(0, 1e3 * (Math.pow(2, this._reconnectAttempt) - 1));
            console.error(`Connection lost, reconnecting in ${Math.floor(timeout / 1000)} seconds.`);
            this._reconnectTimeout = setTimeout(this._createSocket, timeout);
            this._reconnectAttempt += 1;
        }
        else {
            this._updateConnectionStatus('disconnected');
        }
        // Clear the websocket event handlers and the socket itself.
        this._clearSocket();
    }
    /**
     * Forcefully clear the socket state.
     *
     * #### Notes
     * This will clear all socket state without calling any handlers and will
     * not update the connection status. If you call this method, you are
     * responsible for updating the connection status as needed and recreating
     * the socket if you plan to reconnect.
     */
    _clearSocket() {
        if (this._ws !== null) {
            // Clear the websocket event handlers and the socket itself.
            this._ws.onopen = this._noOp;
            this._ws.onclose = this._noOp;
            this._ws.onerror = this._noOp;
            this._ws.onmessage = this._noOp;
            this._ws.close();
            this._ws = null;
        }
    }
    /**
     * Shut down the terminal session.
     */
    async shutdown() {
        await (0, restapi_1.shutdownTerminal)(this.name, this.serverSettings);
        this.dispose();
    }
    /**
     * Clone the current terminal connection.
     */
    clone() {
        return new TerminalConnection(this);
    }
    /**
     * Handle connection status changes.
     */
    _updateConnectionStatus(connectionStatus) {
        if (this._connectionStatus === connectionStatus) {
            return;
        }
        this._connectionStatus = connectionStatus;
        // If we are not 'connecting', stop any reconnection attempts.
        if (connectionStatus !== 'connecting') {
            this._reconnectAttempt = 0;
            clearTimeout(this._reconnectTimeout);
        }
        // Send the pending messages if we just connected.
        if (connectionStatus === 'connected') {
            this._sendPending();
        }
        // Notify others that the connection status changed.
        this._connectionStatusChanged.emit(connectionStatus);
    }
    /**
     * Utility function to throw an error if this instance is disposed.
     */
    _errorIfDisposed() {
        if (this.isDisposed) {
            throw new Error('Terminal connection is disposed');
        }
    }
    /**
     * A signal emitted when the terminal connection status changes.
     */
    get connectionStatusChanged() {
        return this._connectionStatusChanged;
    }
    /**
     * The current connection status of the terminal connection.
     */
    get connectionStatus() {
        return this._connectionStatus;
    }
}
exports.TerminalConnection = TerminalConnection;
var Private;
(function (Private) {
    /**
     * Get the url for a terminal.
     */
    function getTermUrl(baseUrl, name) {
        return coreutils_1.URLExt.join(baseUrl, restapi_1.TERMINAL_SERVICE_URL, encodeURIComponent(name));
    }
    Private.getTermUrl = getTermUrl;
    /**
     * Get a random integer between min and max, inclusive of both.
     *
     * #### Notes
     * From
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/random#Getting_a_random_integer_between_two_values_inclusive
     *
     * From the MDN page: It might be tempting to use Math.round() to accomplish
     * that, but doing so would cause your random numbers to follow a non-uniform
     * distribution, which may not be acceptable for your needs.
     */
    function getRandomIntInclusive(min, max) {
        min = Math.ceil(min);
        max = Math.floor(max);
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }
    Private.getRandomIntInclusive = getRandomIntInclusive;
})(Private || (Private = {}));
//# sourceMappingURL=default.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/terminal/index.js":
/*!******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/terminal/index.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalAPI = exports.Terminal = void 0;
const Terminal = __importStar(__webpack_require__(/*! ./terminal */ "../node_modules/@jupyterlab/services/lib/terminal/terminal.js"));
exports.Terminal = Terminal;
const TerminalAPI = __importStar(__webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/terminal/restapi.js"));
exports.TerminalAPI = TerminalAPI;
__exportStar(__webpack_require__(/*! ./manager */ "../node_modules/@jupyterlab/services/lib/terminal/manager.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/terminal/manager.js":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/terminal/manager.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalManager = void 0;
const polling_1 = __webpack_require__(/*! @lumino/polling */ "../node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "../node_modules/@jupyterlab/services/lib/index.js");
const basemanager_1 = __webpack_require__(/*! ../basemanager */ "../node_modules/@jupyterlab/services/lib/basemanager.js");
const restapi_1 = __webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/terminal/restapi.js");
const default_1 = __webpack_require__(/*! ./default */ "../node_modules/@jupyterlab/services/lib/terminal/default.js");
/**
 * A terminal session manager.
 */
class TerminalManager extends basemanager_1.BaseManager {
    /**
     * Construct a new terminal manager.
     */
    constructor(options = {}) {
        var _a;
        super(options);
        this._isReady = false;
        // As an optimization, we unwrap the models to just store the names.
        this._names = [];
        this._terminalConnections = new Set();
        this._runningChanged = new signaling_1.Signal(this);
        this._connectionFailure = new signaling_1.Signal(this);
        // Check if terminals are available
        if (!this.isAvailable()) {
            this._ready = Promise.reject('Terminals unavailable');
            this._ready.catch(_ => undefined);
            return;
        }
        // Start polling with exponential backoff.
        this._pollModels = new polling_1.Poll({
            auto: false,
            factory: () => this.requestRunning(),
            frequency: {
                interval: 10 * 1000,
                backoff: true,
                max: 300 * 1000
            },
            name: `@jupyterlab/services:TerminalManager#models`,
            standby: (_a = options.standby) !== null && _a !== void 0 ? _a : 'when-hidden'
        });
        // Initialize internal data.
        this._ready = (async () => {
            await this._pollModels.start();
            await this._pollModels.tick;
            this._isReady = true;
        })();
    }
    /**
     * Test whether the manager is ready.
     */
    get isReady() {
        return this._isReady;
    }
    /**
     * A promise that fulfills when the manager is ready.
     */
    get ready() {
        return this._ready;
    }
    /**
     * A signal emitted when the running terminals change.
     */
    get runningChanged() {
        return this._runningChanged;
    }
    /**
     * A signal emitted when there is a connection failure.
     */
    get connectionFailure() {
        return this._connectionFailure;
    }
    /**
     * Dispose of the resources used by the manager.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._names.length = 0;
        this._terminalConnections.forEach(x => x.dispose());
        this._pollModels.dispose();
        super.dispose();
    }
    /**
     * Whether the terminal service is available.
     */
    isAvailable() {
        return (0, restapi_1.isAvailable)();
    }
    /*
     * Connect to a running terminal.
     *
     * @param options - The options used to connect to the terminal.
     *
     * @returns The new terminal connection instance.
     *
     * #### Notes
     * The manager `serverSettings` will be used.
     */
    connectTo(options) {
        const terminalConnection = new default_1.TerminalConnection({
            ...options,
            serverSettings: this.serverSettings
        });
        this._onStarted(terminalConnection);
        if (!this._names.includes(options.model.name)) {
            // We trust the user to connect to an existing session, but we verify
            // asynchronously.
            void this.refreshRunning().catch(() => {
                /* no-op */
            });
        }
        return terminalConnection;
    }
    /**
     * Create an iterator over the most recent running terminals.
     *
     * @returns A new iterator over the running terminals.
     */
    running() {
        return this._models[Symbol.iterator]();
    }
    /**
     * Force a refresh of the running terminals.
     *
     * @returns A promise that with the list of running terminals.
     *
     * #### Notes
     * This is intended to be called only in response to a user action,
     * since the manager maintains its internal state.
     */
    async refreshRunning() {
        await this._pollModels.refresh();
        await this._pollModels.tick;
    }
    /**
     * Create a new terminal session.
     *
     * @param options - The options used to create the terminal.
     *
     * @returns A promise that resolves with the terminal connection instance.
     *
     * #### Notes
     * The manager `serverSettings` will be used unless overridden in the
     * options.
     */
    async startNew(options) {
        const model = await (0, restapi_1.startNew)(this.serverSettings, options === null || options === void 0 ? void 0 : options.name, options === null || options === void 0 ? void 0 : options.cwd);
        await this.refreshRunning();
        return this.connectTo({ model });
    }
    /**
     * Shut down a terminal session by name.
     */
    async shutdown(name) {
        await (0, restapi_1.shutdownTerminal)(name, this.serverSettings);
        await this.refreshRunning();
    }
    /**
     * Shut down all terminal sessions.
     *
     * @returns A promise that resolves when all of the sessions are shut down.
     */
    async shutdownAll() {
        // Update the list of models to make sure our list is current.
        await this.refreshRunning();
        // Shut down all models.
        await Promise.all(this._names.map(name => (0, restapi_1.shutdownTerminal)(name, this.serverSettings)));
        // Update the list of models to clear out our state.
        await this.refreshRunning();
    }
    /**
     * Execute a request to the server to poll running terminals and update state.
     */
    async requestRunning() {
        var _a, _b;
        let models;
        try {
            models = await (0, restapi_1.listRunning)(this.serverSettings);
        }
        catch (err) {
            // Handle network errors, as well as cases where we are on a
            // JupyterHub and the server is not running. JupyterHub returns a
            // 503 (<2.0) or 424 (>2.0) in that case.
            if (err instanceof __1.ServerConnection.NetworkError ||
                ((_a = err.response) === null || _a === void 0 ? void 0 : _a.status) === 503 ||
                ((_b = err.response) === null || _b === void 0 ? void 0 : _b.status) === 424) {
                this._connectionFailure.emit(err);
            }
            throw err;
        }
        if (this.isDisposed) {
            return;
        }
        const names = models.map(({ name }) => name).sort();
        if (names === this._names) {
            // Identical models list, so just return
            return;
        }
        this._names = names;
        this._terminalConnections.forEach(tc => {
            if (!names.includes(tc.name)) {
                tc.dispose();
            }
        });
        this._runningChanged.emit(this._models);
    }
    /**
     * Handle a session starting.
     */
    _onStarted(terminalConnection) {
        this._terminalConnections.add(terminalConnection);
        terminalConnection.disposed.connect(this._onDisposed, this);
    }
    /**
     * Handle a session terminating.
     */
    _onDisposed(terminalConnection) {
        this._terminalConnections.delete(terminalConnection);
        // Update the running models to make sure we reflect the server state
        void this.refreshRunning().catch(() => {
            /* no-op */
        });
    }
    get _models() {
        return this._names.map(name => {
            return { name };
        });
    }
}
exports.TerminalManager = TerminalManager;
/**
 * The namespace for TerminalManager statics.
 */
(function (TerminalManager) {
    /**
     * A no-op terminal manager to be used when starting terminals is not supported.
     */
    class NoopManager extends TerminalManager {
        constructor() {
            super(...arguments);
            this._readyPromise = new Promise(() => {
                /* no-op */
            });
        }
        /**
         * Whether the manager is active.
         */
        get isActive() {
            return false;
        }
        /**
         * Used for testing.
         */
        get parentReady() {
            return super.ready;
        }
        /**
         * A promise that fulfills when the manager is ready (never).
         */
        get ready() {
            return this.parentReady.then(() => this._readyPromise);
        }
        /**
         * Create a new terminal session - throw an error since it is not supported.
         *
         */
        async startNew(options) {
            return Promise.reject(new Error('Not implemented in no-op Terminal Manager'));
        }
        /*
         * Connect to a running terminal - throw an error since it is not supported.
         */
        connectTo(options) {
            throw Error('Not implemented in no-op Terminal Manager');
        }
        /**
         * Shut down a session by id - throw an error since it is not supported.
         */
        async shutdown(id) {
            return Promise.reject(new Error('Not implemented in no-op Terminal Manager'));
        }
        /**
         * Execute a request to the server to poll running sessions and update state.
         */
        async requestRunning() {
            return Promise.resolve();
        }
    }
    TerminalManager.NoopManager = NoopManager;
})(TerminalManager || (exports.TerminalManager = TerminalManager = {}));
//# sourceMappingURL=manager.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/terminal/restapi.js":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/terminal/restapi.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.shutdownTerminal = exports.listRunning = exports.startNew = exports.isAvailable = exports.TERMINAL_SERVICE_URL = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
/**
 * The url for the terminal service.
 */
exports.TERMINAL_SERVICE_URL = 'api/terminals';
/**
 * Whether the terminal service is available.
 */
function isAvailable() {
    const available = String(coreutils_1.PageConfig.getOption('terminalsAvailable'));
    return available.toLowerCase() === 'true';
}
exports.isAvailable = isAvailable;
/**
 * Start a new terminal session.
 *
 * @param settings - The server settings to use.
 *
 * @param name - The name of the target terminal.
 *
 * @param cwd - The path in which the terminal will start.
 *
 * @returns A promise that resolves with the session model.
 */
async function startNew(settings = serverconnection_1.ServerConnection.makeSettings(), name, cwd) {
    Private.errorIfNotAvailable();
    const url = coreutils_1.URLExt.join(settings.baseUrl, exports.TERMINAL_SERVICE_URL);
    const init = {
        method: 'POST',
        body: JSON.stringify({ name, cwd })
    };
    const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
    if (response.status !== 200) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    // TODO: Validate model
    return data;
}
exports.startNew = startNew;
/**
 * List the running terminal sessions.
 *
 * @param settings - The server settings to use.
 *
 * @returns A promise that resolves with the list of running session models.
 */
async function listRunning(settings = serverconnection_1.ServerConnection.makeSettings()) {
    Private.errorIfNotAvailable();
    const url = coreutils_1.URLExt.join(settings.baseUrl, exports.TERMINAL_SERVICE_URL);
    const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
    if (response.status !== 200) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
    const data = await response.json();
    if (!Array.isArray(data)) {
        throw new Error('Invalid terminal list');
    }
    // TODO: validate each model
    return data;
}
exports.listRunning = listRunning;
/**
 * Shut down a terminal session by name.
 *
 * @param name - The name of the target session.
 *
 * @param settings - The server settings to use.
 *
 * @returns A promise that resolves when the session is shut down.
 */
async function shutdownTerminal(name, settings = serverconnection_1.ServerConnection.makeSettings()) {
    var _a;
    Private.errorIfNotAvailable();
    const workspacesBase = coreutils_1.URLExt.join(settings.baseUrl, exports.TERMINAL_SERVICE_URL);
    const url = coreutils_1.URLExt.join(workspacesBase, name);
    if (!url.startsWith(workspacesBase)) {
        throw new Error('Can only be used for terminal requests');
    }
    const init = { method: 'DELETE' };
    const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
    if (response.status === 404) {
        const data = await response.json();
        const msg = (_a = data.message) !== null && _a !== void 0 ? _a : `The terminal session "${name}"" does not exist on the server`;
        console.warn(msg);
    }
    else if (response.status !== 204) {
        const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
        throw err;
    }
}
exports.shutdownTerminal = shutdownTerminal;
var Private;
(function (Private) {
    /**
     * Throw an error if terminals are not available.
     */
    function errorIfNotAvailable() {
        if (!isAvailable()) {
            throw new Error('Terminals Unavailable');
        }
    }
    Private.errorIfNotAvailable = errorIfNotAvailable;
})(Private || (Private = {}));
//# sourceMappingURL=restapi.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/terminal/terminal.js":
/*!*********************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/terminal/terminal.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isAvailable = void 0;
const restapi_1 = __webpack_require__(/*! ./restapi */ "../node_modules/@jupyterlab/services/lib/terminal/restapi.js");
Object.defineProperty(exports, "isAvailable", ({ enumerable: true, get: function () { return restapi_1.isAvailable; } }));
//# sourceMappingURL=terminal.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/user/index.js":
/*!**************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/user/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const coreutils_2 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
const polling_1 = __webpack_require__(/*! @lumino/polling */ "../node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
const basemanager_1 = __webpack_require__(/*! ../basemanager */ "../node_modules/@jupyterlab/services/lib/basemanager.js");
/**
 * The url for the lab workspaces service.
 */
const SERVICE_USER_URL = 'api/me';
/**
 * The service's ID.
 * Used to uniquely identify the poll, and
 * the item in local storage.
 */
const SERVICE_ID = '@jupyterlab/services:UserManager#user';
/**
 * The user API service manager.
 */
class UserManager extends basemanager_1.BaseManager {
    /**
     * Create a new user manager.
     */
    constructor(options = {}) {
        var _a;
        super(options);
        this._isReady = false;
        this._userChanged = new signaling_1.Signal(this);
        this._connectionFailure = new signaling_1.Signal(this);
        // Initialize internal data.
        this._ready = this.requestUser()
            .then(() => {
            if (this.isDisposed) {
                return;
            }
            this._isReady = true;
        })
            .catch(_ => 
        // Return a promise that will never resolve, so user service is never ready
        // This typically occurs when the backend has no user service
        new Promise(() => {
            // no-op
        }));
        this._pollSpecs = new polling_1.Poll({
            auto: false,
            factory: () => this.requestUser(),
            frequency: {
                interval: 61 * 1000,
                backoff: true,
                max: 300 * 1000
            },
            name: SERVICE_ID,
            standby: (_a = options.standby) !== null && _a !== void 0 ? _a : 'when-hidden'
        });
        void this.ready.then(() => {
            void this._pollSpecs.start();
        });
    }
    /**
     * Test whether the manager is ready.
     */
    get isReady() {
        return this._isReady;
    }
    /**
     * A promise that fulfills when the manager is ready.
     */
    get ready() {
        return this._ready;
    }
    /**
     * Get the most recently fetched identity.
     */
    get identity() {
        return this._identity;
    }
    /**
     * Get the most recently fetched permissions.
     */
    get permissions() {
        return this._permissions;
    }
    /**
     * A signal emitted when the user changes.
     */
    get userChanged() {
        return this._userChanged;
    }
    /**
     * A signal emitted when there is a connection failure.
     */
    get connectionFailure() {
        return this._connectionFailure;
    }
    /**
     * Dispose of the resources used by the manager.
     */
    dispose() {
        this._pollSpecs.dispose();
        super.dispose();
    }
    /**
     * Force a refresh of the specs from the server.
     *
     * @returns A promise that resolves when the specs are fetched.
     *
     * #### Notes
     * This is intended to be called only in response to a user action,
     * since the manager maintains its internal state.
     */
    async refreshUser() {
        await this._pollSpecs.refresh();
        await this._pollSpecs.tick;
    }
    /**
     * Execute a request to the server to poll the user and update state.
     */
    async requestUser() {
        if (this.isDisposed) {
            return;
        }
        const { baseUrl } = this.serverSettings;
        const { makeRequest, ResponseError } = serverconnection_1.ServerConnection;
        const url = coreutils_1.URLExt.join(baseUrl, SERVICE_USER_URL);
        const response = await makeRequest(url, {}, this.serverSettings);
        if (response.status !== 200) {
            const err = await ResponseError.create(response);
            throw err;
        }
        const oldUser = {
            identity: this._identity,
            permissions: this._permissions
        };
        const newUser = await response.json();
        const identity = newUser.identity;
        // store the color and initials for the user
        // this info is not provided by the server
        const { localStorage } = window;
        const data = localStorage.getItem(SERVICE_ID);
        if (data && (!identity.initials || !identity.color)) {
            const localUser = JSON.parse(data);
            identity.initials =
                identity.initials ||
                    localUser.initials ||
                    identity.name.substring(0, 1);
            identity.color =
                identity.color || localUser.color || Private.getRandomColor();
        }
        if (!coreutils_2.JSONExt.deepEqual(newUser, oldUser)) {
            this._identity = identity;
            this._permissions = newUser.permissions;
            localStorage.setItem(SERVICE_ID, JSON.stringify(identity));
            this._userChanged.emit(newUser);
        }
    }
}
exports.UserManager = UserManager;
/**
 * A namespace for module-private functionality.
 *
 * Note: We do not want to export this function
 * to move it to css variables in the Theme.
 */
var Private;
(function (Private) {
    /**
     * Predefined colors for users
     */
    const userColors = [
        'var(--jp-collaborator-color1)',
        'var(--jp-collaborator-color2)',
        'var(--jp-collaborator-color3)',
        'var(--jp-collaborator-color4)',
        'var(--jp-collaborator-color5)',
        'var(--jp-collaborator-color6)',
        'var(--jp-collaborator-color7)'
    ];
    /**
     * Get a random color from the list of colors.
     */
    Private.getRandomColor = () => userColors[Math.floor(Math.random() * userColors.length)];
})(Private || (Private = {}));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/validate.js":
/*!************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/validate.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateProperty = void 0;
/**
 * Validate a property as being on an object, and optionally
 * of a given type and among a given set of values.
 */
function validateProperty(
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
object, name, typeName, values = []) {
    if (!object.hasOwnProperty(name)) {
        throw Error(`Missing property '${name}'`);
    }
    const value = object[name];
    if (typeName !== void 0) {
        let valid = true;
        switch (typeName) {
            case 'array':
                valid = Array.isArray(value);
                break;
            case 'object':
                valid = typeof value !== 'undefined';
                break;
            default:
                valid = typeof value === typeName;
        }
        if (!valid) {
            throw new Error(`Property '${name}' is not of type '${typeName}'`);
        }
        if (values.length > 0) {
            let valid = true;
            switch (typeName) {
                case 'string':
                case 'number':
                case 'boolean':
                    valid = values.includes(value);
                    break;
                default:
                    valid = values.findIndex(v => v === value) >= 0;
                    break;
            }
            if (!valid) {
                throw new Error(`Property '${name}' is not one of the valid values ${JSON.stringify(values)}`);
            }
        }
    }
}
exports.validateProperty = validateProperty;
//# sourceMappingURL=validate.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/services/lib/workspace/index.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/services/lib/workspace/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "../node_modules/@jupyterlab/coreutils/lib/index.js");
const statedb_1 = __webpack_require__(/*! @jupyterlab/statedb */ "../node_modules/@jupyterlab/statedb/lib/index.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "../node_modules/@jupyterlab/services/lib/serverconnection.js");
/**
 * The url for the lab workspaces service.
 */
const SERVICE_WORKSPACES_URL = 'api/workspaces';
/**
 * The workspaces API service manager.
 */
class WorkspaceManager extends statedb_1.DataConnector {
    /**
     * Create a new workspace manager.
     */
    constructor(options = {}) {
        var _a;
        super();
        this.serverSettings =
            (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
    }
    /**
     * Fetch a workspace.
     *
     * @param id - The workspace's ID.
     *
     * @returns A promise that resolves if successful.
     */
    async fetch(id) {
        const { serverSettings } = this;
        const { baseUrl, appUrl } = serverSettings;
        const { makeRequest, ResponseError } = serverconnection_1.ServerConnection;
        const base = baseUrl + appUrl;
        const url = Private.url(base, id);
        const response = await makeRequest(url, {}, serverSettings);
        if (response.status !== 200) {
            const err = await ResponseError.create(response);
            throw err;
        }
        return response.json();
    }
    /**
     * Fetch the list of workspace IDs that exist on the server.
     *
     * @returns A promise that resolves if successful.
     */
    async list() {
        const { serverSettings } = this;
        const { baseUrl, appUrl } = serverSettings;
        const { makeRequest, ResponseError } = serverconnection_1.ServerConnection;
        const base = baseUrl + appUrl;
        const url = Private.url(base, '');
        const response = await makeRequest(url, {}, serverSettings);
        if (response.status !== 200) {
            const err = await ResponseError.create(response);
            throw err;
        }
        const result = await response.json();
        return result.workspaces;
    }
    /**
     * Remove a workspace from the server.
     *
     * @param id - The workspaces's ID.
     *
     * @returns A promise that resolves if successful.
     */
    async remove(id) {
        const { serverSettings } = this;
        const { baseUrl, appUrl } = serverSettings;
        const { makeRequest, ResponseError } = serverconnection_1.ServerConnection;
        const base = baseUrl + appUrl;
        const url = Private.url(base, id);
        const init = { method: 'DELETE' };
        const response = await makeRequest(url, init, serverSettings);
        if (response.status !== 204) {
            const err = await ResponseError.create(response);
            throw err;
        }
    }
    /**
     * Save a workspace.
     *
     * @param id - The workspace's ID.
     *
     * @param workspace - The workspace being saved.
     *
     * @returns A promise that resolves if successful.
     */
    async save(id, workspace) {
        const { serverSettings } = this;
        const { baseUrl, appUrl } = serverSettings;
        const { makeRequest, ResponseError } = serverconnection_1.ServerConnection;
        const base = baseUrl + appUrl;
        const url = Private.url(base, id);
        const init = { body: JSON.stringify(workspace), method: 'PUT' };
        const response = await makeRequest(url, init, serverSettings);
        if (response.status !== 204) {
            const err = await ResponseError.create(response);
            throw err;
        }
    }
}
exports.WorkspaceManager = WorkspaceManager;
/**
 * A namespace for private data.
 */
var Private;
(function (Private) {
    /**
     * Get the url for a workspace.
     */
    function url(base, id) {
        const workspacesBase = coreutils_1.URLExt.join(base, SERVICE_WORKSPACES_URL);
        const result = coreutils_1.URLExt.join(workspacesBase, id);
        if (!result.startsWith(workspacesBase)) {
            throw new Error('Can only be used for workspaces requests');
        }
        return result;
    }
    Private.url = url;
})(Private || (Private = {}));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/statedb/lib/dataconnector.js":
/*!****************************************************************!*\
  !*** ../node_modules/@jupyterlab/statedb/lib/dataconnector.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataConnector = void 0;
/**
 * An abstract class that adheres to the data connector interface.
 *
 * @typeparam T - The basic entity response type a service's connector.
 *
 * @typeparam U - The basic entity request type, which is conventionally the
 * same as the response type but may be different if a service's implementation
 * requires input data to be different from output responses. Defaults to `T`.
 *
 * @typeparam V - The basic token applied to a request, conventionally a string
 * ID or filter, but may be set to a different type when an implementation
 * requires it. Defaults to `string`.
 *
 * @typeparam W - The type of the optional `query` parameter of the `list`
 * method. Defaults to `string`.
 *
 * #### Notes
 * The only abstract method in this class is the `fetch` method, which must be
 * reimplemented by all subclasses. The `remove` and `save` methods have a
 * default implementation that returns a promise that will always reject. This
 * class is a convenience superclass for connectors that only need to `fetch`.
 */
class DataConnector {
    /**
     * Retrieve the list of items available from the data connector.
     *
     * @param query - The optional query filter to apply to the connector request.
     *
     * @returns A promise that always rejects with an error.
     *
     * #### Notes
     * Subclasses should reimplement if they support a back-end that can list.
     */
    async list(query) {
        throw new Error('DataConnector#list method has not been implemented.');
    }
    /**
     * Remove a value using the data connector.
     *
     * @param id - The identifier for the data being removed.
     *
     * @returns A promise that always rejects with an error.
     *
     * #### Notes
     * Subclasses should reimplement if they support a back-end that can remove.
     */
    async remove(id) {
        throw new Error('DataConnector#remove method has not been implemented.');
    }
    /**
     * Save a value using the data connector.
     *
     * @param id - The identifier for the data being saved.
     *
     * @param value - The data being saved.
     *
     * @returns A promise that always rejects with an error.
     *
     * #### Notes
     * Subclasses should reimplement if they support a back-end that can save.
     */
    async save(id, value) {
        throw new Error('DataConnector#save method has not been implemented.');
    }
}
exports.DataConnector = DataConnector;
//# sourceMappingURL=dataconnector.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/statedb/lib/index.js":
/*!********************************************************!*\
  !*** ../node_modules/@jupyterlab/statedb/lib/index.js ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module statedb
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./dataconnector */ "../node_modules/@jupyterlab/statedb/lib/dataconnector.js"), exports);
__exportStar(__webpack_require__(/*! ./interfaces */ "../node_modules/@jupyterlab/statedb/lib/interfaces.js"), exports);
__exportStar(__webpack_require__(/*! ./restorablepool */ "../node_modules/@jupyterlab/statedb/lib/restorablepool.js"), exports);
__exportStar(__webpack_require__(/*! ./statedb */ "../node_modules/@jupyterlab/statedb/lib/statedb.js"), exports);
__exportStar(__webpack_require__(/*! ./tokens */ "../node_modules/@jupyterlab/statedb/lib/tokens.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/statedb/lib/interfaces.js":
/*!*************************************************************!*\
  !*** ../node_modules/@jupyterlab/statedb/lib/interfaces.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=interfaces.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/statedb/lib/restorablepool.js":
/*!*****************************************************************!*\
  !*** ../node_modules/@jupyterlab/statedb/lib/restorablepool.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RestorablePool = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
const properties_1 = __webpack_require__(/*! @lumino/properties */ "../node_modules/@lumino/properties/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
/**
 * An object pool that supports restoration.
 *
 * @typeparam T - The type of object being tracked.
 */
class RestorablePool {
    /**
     * Create a new restorable pool.
     *
     * @param options - The instantiation options for a restorable pool.
     */
    constructor(options) {
        this._added = new signaling_1.Signal(this);
        this._current = null;
        this._currentChanged = new signaling_1.Signal(this);
        this._hasRestored = false;
        this._isDisposed = false;
        this._objects = new Set();
        this._restore = null;
        this._restored = new coreutils_1.PromiseDelegate();
        this._updated = new signaling_1.Signal(this);
        this.namespace = options.namespace;
    }
    /**
     * A signal emitted when an object object is added.
     *
     * #### Notes
     * This signal will only fire when an object is added to the pool.
     * It will not fire if an object injected into the pool.
     */
    get added() {
        return this._added;
    }
    /**
     * The current object.
     *
     * #### Notes
     * The restorable pool does not set `current`. It is intended for client use.
     *
     * If `current` is set to an object that does not exist in the pool, it is a
     * no-op.
     */
    get current() {
        return this._current;
    }
    set current(obj) {
        if (this._current === obj) {
            return;
        }
        if (obj !== null && this._objects.has(obj)) {
            this._current = obj;
            this._currentChanged.emit(this._current);
        }
    }
    /**
     * A signal emitted when the current widget changes.
     */
    get currentChanged() {
        return this._currentChanged;
    }
    /**
     * Test whether the pool is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * A promise resolved when the restorable pool has been restored.
     */
    get restored() {
        return this._restored.promise;
    }
    /**
     * The number of objects held by the pool.
     */
    get size() {
        return this._objects.size;
    }
    /**
     * A signal emitted when an object is updated.
     */
    get updated() {
        return this._updated;
    }
    /**
     * Add a new object to the pool.
     *
     * @param obj - The object object being added.
     *
     * #### Notes
     * The object passed into the pool is added synchronously; its existence in
     * the pool can be checked with the `has()` method. The promise this method
     * returns resolves after the object has been added and saved to an underlying
     * restoration connector, if one is available.
     */
    async add(obj) {
        var _a, _b;
        if (obj.isDisposed) {
            const warning = 'A disposed object cannot be added.';
            console.warn(warning, obj);
            throw new Error(warning);
        }
        if (this._objects.has(obj)) {
            const warning = 'This object already exists in the pool.';
            console.warn(warning, obj);
            throw new Error(warning);
        }
        this._objects.add(obj);
        obj.disposed.connect(this._onInstanceDisposed, this);
        if (Private.injectedProperty.get(obj)) {
            return;
        }
        if (this._restore) {
            const { connector } = this._restore;
            const objName = this._restore.name(obj);
            if (objName) {
                const name = `${this.namespace}:${objName}`;
                const data = (_b = (_a = this._restore).args) === null || _b === void 0 ? void 0 : _b.call(_a, obj);
                Private.nameProperty.set(obj, name);
                await connector.save(name, { data });
            }
        }
        // Emit the added signal.
        this._added.emit(obj);
    }
    /**
     * Dispose of the resources held by the pool.
     *
     * #### Notes
     * Disposing a pool does not affect the underlying data in the data connector,
     * it simply disposes the client-side pool without making any connector calls.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._current = null;
        this._isDisposed = true;
        this._objects.clear();
        signaling_1.Signal.clearData(this);
    }
    /**
     * Find the first object in the pool that satisfies a filter function.
     *
     * @param fn The filter function to call on each object.
     */
    find(fn) {
        const values = this._objects.values();
        for (const value of values) {
            if (fn(value)) {
                return value;
            }
        }
        return undefined;
    }
    /**
     * Iterate through each object in the pool.
     *
     * @param fn - The function to call on each object.
     */
    forEach(fn) {
        this._objects.forEach(fn);
    }
    /**
     * Filter the objects in the pool based on a predicate.
     *
     * @param fn - The function by which to filter.
     */
    filter(fn) {
        const filtered = [];
        this.forEach(obj => {
            if (fn(obj)) {
                filtered.push(obj);
            }
        });
        return filtered;
    }
    /**
     * Inject an object into the restorable pool without the pool handling its
     * restoration lifecycle.
     *
     * @param obj - The object to inject into the pool.
     */
    inject(obj) {
        Private.injectedProperty.set(obj, true);
        return this.add(obj);
    }
    /**
     * Check if this pool has the specified object.
     *
     * @param obj - The object whose existence is being checked.
     */
    has(obj) {
        return this._objects.has(obj);
    }
    /**
     * Restore the objects in this pool's namespace.
     *
     * @param options - The configuration options that describe restoration.
     *
     * @returns A promise that resolves when restoration has completed.
     *
     * #### Notes
     * This function should almost never be invoked by client code. Its primary
     * use case is to be invoked by a layout restorer plugin that handles
     * multiple restorable pools and, when ready, asks them each to restore their
     * respective objects.
     */
    async restore(options) {
        if (this._hasRestored) {
            throw new Error('This pool has already been restored.');
        }
        this._hasRestored = true;
        const { command, connector, registry, when } = options;
        const namespace = this.namespace;
        const promises = when
            ? [connector.list(namespace)].concat(when)
            : [connector.list(namespace)];
        this._restore = options;
        const [saved] = await Promise.all(promises);
        const values = await Promise.all(saved.ids.map(async (id, index) => {
            const value = saved.values[index];
            const args = value && value.data;
            if (args === undefined) {
                return connector.remove(id);
            }
            // Execute the command and if it fails, delete the state restore data.
            return registry
                .execute(command, args)
                .catch(() => connector.remove(id));
        }));
        this._restored.resolve();
        return values;
    }
    /**
     * Save the restore data for a given object.
     *
     * @param obj - The object being saved.
     */
    async save(obj) {
        var _a, _b;
        const injected = Private.injectedProperty.get(obj);
        if (!this._restore || !this.has(obj) || injected) {
            return;
        }
        const { connector } = this._restore;
        const objName = this._restore.name(obj);
        const oldName = Private.nameProperty.get(obj);
        const newName = objName ? `${this.namespace}:${objName}` : '';
        if (oldName && oldName !== newName) {
            await connector.remove(oldName);
        }
        // Set the name property irrespective of whether the new name is null.
        Private.nameProperty.set(obj, newName);
        if (newName) {
            const data = (_b = (_a = this._restore).args) === null || _b === void 0 ? void 0 : _b.call(_a, obj);
            await connector.save(newName, { data });
        }
        if (oldName !== newName) {
            this._updated.emit(obj);
        }
    }
    /**
     * Clean up after disposed objects.
     */
    _onInstanceDisposed(obj) {
        this._objects.delete(obj);
        if (obj === this._current) {
            this._current = null;
            this._currentChanged.emit(this._current);
        }
        if (Private.injectedProperty.get(obj)) {
            return;
        }
        if (!this._restore) {
            return;
        }
        const { connector } = this._restore;
        const name = Private.nameProperty.get(obj);
        if (name) {
            void connector.remove(name);
        }
    }
}
exports.RestorablePool = RestorablePool;
/*
 * A namespace for private data.
 */
var Private;
(function (Private) {
    /**
     * An attached property to indicate whether an object has been injected.
     */
    Private.injectedProperty = new properties_1.AttachedProperty({
        name: 'injected',
        create: () => false
    });
    /**
     * An attached property for an object's ID.
     */
    Private.nameProperty = new properties_1.AttachedProperty({
        name: 'name',
        create: () => ''
    });
})(Private || (Private = {}));
//# sourceMappingURL=restorablepool.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/statedb/lib/statedb.js":
/*!**********************************************************!*\
  !*** ../node_modules/@jupyterlab/statedb/lib/statedb.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StateDB = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");
/**
 * The default concrete implementation of a state database.
 */
class StateDB {
    /**
     * Create a new state database.
     *
     * @param options - The instantiation options for a state database.
     */
    constructor(options = {}) {
        this._changed = new signaling_1.Signal(this);
        const { connector, transform } = options;
        this._connector = connector || new StateDB.Connector();
        if (!transform) {
            this._ready = Promise.resolve(undefined);
        }
        else {
            this._ready = transform.then(transformation => {
                const { contents, type } = transformation;
                switch (type) {
                    case 'cancel':
                        return;
                    case 'clear':
                        return this._clear();
                    case 'merge':
                        return this._merge(contents || {});
                    case 'overwrite':
                        return this._overwrite(contents || {});
                    default:
                        return;
                }
            });
        }
    }
    /**
     * A signal that emits the change type any time a value changes.
     */
    get changed() {
        return this._changed;
    }
    /**
     * Clear the entire database.
     */
    async clear() {
        await this._ready;
        await this._clear();
    }
    /**
     * Retrieve a saved bundle from the database.
     *
     * @param id - The identifier used to retrieve a data bundle.
     *
     * @returns A promise that bears a data payload if available.
     *
     * #### Notes
     * The `id` values of stored items in the state database are formatted:
     * `'namespace:identifier'`, which is the same convention that command
     * identifiers in JupyterLab use as well. While this is not a technical
     * requirement for `fetch()`, `remove()`, and `save()`, it *is* necessary for
     * using the `list(namespace: string)` method.
     *
     * The promise returned by this method may be rejected if an error occurs in
     * retrieving the data. Non-existence of an `id` will succeed with the `value`
     * `undefined`.
     */
    async fetch(id) {
        await this._ready;
        return this._fetch(id);
    }
    /**
     * Retrieve all the saved bundles for a namespace.
     *
     * @param namespace The namespace prefix to retrieve.
     *
     * @returns A promise that bears a collection of payloads for a namespace.
     *
     * #### Notes
     * Namespaces are entirely conventional entities. The `id` values of stored
     * items in the state database are formatted: `'namespace:identifier'`, which
     * is the same convention that command identifiers in JupyterLab use as well.
     *
     * If there are any errors in retrieving the data, they will be logged to the
     * console in order to optimistically return any extant data without failing.
     * This promise will always succeed.
     */
    async list(namespace) {
        await this._ready;
        return this._list(namespace);
    }
    /**
     * Remove a value from the database.
     *
     * @param id - The identifier for the data being removed.
     *
     * @returns A promise that is rejected if remove fails and succeeds otherwise.
     */
    async remove(id) {
        await this._ready;
        await this._remove(id);
        this._changed.emit({ id, type: 'remove' });
    }
    /**
     * Save a value in the database.
     *
     * @param id - The identifier for the data being saved.
     *
     * @param value - The data being saved.
     *
     * @returns A promise that is rejected if saving fails and succeeds otherwise.
     *
     * #### Notes
     * The `id` values of stored items in the state database are formatted:
     * `'namespace:identifier'`, which is the same convention that command
     * identifiers in JupyterLab use as well. While this is not a technical
     * requirement for `fetch()`, `remove()`, and `save()`, it *is* necessary for
     * using the `list(namespace: string)` method.
     */
    async save(id, value) {
        await this._ready;
        await this._save(id, value);
        this._changed.emit({ id, type: 'save' });
    }
    /**
     * Return a serialized copy of the state database's entire contents.
     *
     * @returns A promise that resolves with the database contents as JSON.
     */
    async toJSON() {
        await this._ready;
        const { ids, values } = await this._list();
        return values.reduce((acc, val, idx) => {
            acc[ids[idx]] = val;
            return acc;
        }, {});
    }
    /**
     * Clear the entire database.
     */
    async _clear() {
        await Promise.all((await this._list()).ids.map(id => this._remove(id)));
    }
    /**
     * Fetch a value from the database.
     */
    async _fetch(id) {
        const value = await this._connector.fetch(id);
        if (value) {
            return JSON.parse(value).v;
        }
    }
    /**
     * Fetch a list from the database.
     */
    async _list(namespace = '') {
        const { ids, values } = await this._connector.list(namespace);
        return {
            ids,
            values: values.map(val => JSON.parse(val).v)
        };
    }
    /**
     * Merge data into the state database.
     */
    async _merge(contents) {
        await Promise.all(Object.keys(contents).map(key => contents[key] && this._save(key, contents[key])));
    }
    /**
     * Overwrite the entire database with new contents.
     */
    async _overwrite(contents) {
        await this._clear();
        await this._merge(contents);
    }
    /**
     * Remove a key in the database.
     */
    async _remove(id) {
        return this._connector.remove(id);
    }
    /**
     * Save a key and its value in the database.
     */
    async _save(id, value) {
        return this._connector.save(id, JSON.stringify({ v: value }));
    }
}
exports.StateDB = StateDB;
/**
 * A namespace for StateDB statics.
 */
(function (StateDB) {
    /**
     * An in-memory string key/value data connector.
     */
    class Connector {
        constructor() {
            this._storage = {};
        }
        /**
         * Retrieve an item from the data connector.
         */
        async fetch(id) {
            return this._storage[id];
        }
        /**
         * Retrieve the list of items available from the data connector.
         *
         * @param namespace - If not empty, only keys whose first token before `:`
         * exactly match `namespace` will be returned, e.g. `foo` in `foo:bar`.
         */
        async list(namespace = '') {
            return Object.keys(this._storage).reduce((acc, val) => {
                if (namespace === '' ? true : namespace === val.split(':')[0]) {
                    acc.ids.push(val);
                    acc.values.push(this._storage[val]);
                }
                return acc;
            }, { ids: [], values: [] });
        }
        /**
         * Remove a value using the data connector.
         */
        async remove(id) {
            delete this._storage[id];
        }
        /**
         * Save a value using the data connector.
         */
        async save(id, value) {
            this._storage[id] = value;
        }
    }
    StateDB.Connector = Connector;
})(StateDB || (exports.StateDB = StateDB = {}));
//# sourceMappingURL=statedb.js.map

/***/ }),

/***/ "../node_modules/@jupyterlab/statedb/lib/tokens.js":
/*!*********************************************************!*\
  !*** ../node_modules/@jupyterlab/statedb/lib/tokens.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IStateDB = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
/**
 * The default state database token.
 */
exports.IStateDB = new coreutils_1.Token('@jupyterlab/coreutils:IStateDB', `A service for the JupyterLab state database.
  Use this if you want to store data that will persist across page loads.
  See "state database" for more information.`);
//# sourceMappingURL=tokens.js.map

/***/ }),

/***/ "../node_modules/@lumino/algorithm/dist/index.es6.js":
/*!***********************************************************!*\
  !*** ../node_modules/@lumino/algorithm/dist/index.es6.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArrayExt: () => (/* binding */ ArrayExt),
/* harmony export */   StringExt: () => (/* binding */ StringExt),
/* harmony export */   chain: () => (/* binding */ chain),
/* harmony export */   each: () => (/* binding */ each),
/* harmony export */   empty: () => (/* binding */ empty),
/* harmony export */   enumerate: () => (/* binding */ enumerate),
/* harmony export */   every: () => (/* binding */ every),
/* harmony export */   filter: () => (/* binding */ filter),
/* harmony export */   find: () => (/* binding */ find),
/* harmony export */   findIndex: () => (/* binding */ findIndex),
/* harmony export */   map: () => (/* binding */ map),
/* harmony export */   max: () => (/* binding */ max),
/* harmony export */   min: () => (/* binding */ min),
/* harmony export */   minmax: () => (/* binding */ minmax),
/* harmony export */   once: () => (/* binding */ once),
/* harmony export */   range: () => (/* binding */ range),
/* harmony export */   reduce: () => (/* binding */ reduce),
/* harmony export */   repeat: () => (/* binding */ repeat),
/* harmony export */   retro: () => (/* binding */ retro),
/* harmony export */   some: () => (/* binding */ some),
/* harmony export */   stride: () => (/* binding */ stride),
/* harmony export */   take: () => (/* binding */ take),
/* harmony export */   toArray: () => (/* binding */ toArray),
/* harmony export */   toObject: () => (/* binding */ toObject),
/* harmony export */   topologicSort: () => (/* binding */ topologicSort),
/* harmony export */   zip: () => (/* binding */ zip)
/* harmony export */ });
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * The namespace for array-specific algorithms.
 */
var ArrayExt;
(function (ArrayExt) {
    /**
     * Find the index of the first occurrence of a value in an array.
     *
     * @param array - The array-like object to search.
     *
     * @param value - The value to locate in the array. Values are
     *   compared using strict `===` equality.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The index of the first occurrence of the value, or `-1`
     *   if the value is not found.
     *
     * #### Notes
     * If `stop < start` the search will wrap at the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `start` or `stop` which is non-integral.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = ['one', 'two', 'three', 'four', 'one'];
     * ArrayExt.firstIndexOf(data, 'red');        // -1
     * ArrayExt.firstIndexOf(data, 'one');        // 0
     * ArrayExt.firstIndexOf(data, 'one', 1);     // 4
     * ArrayExt.firstIndexOf(data, 'two', 2);     // -1
     * ArrayExt.firstIndexOf(data, 'two', 2, 1);  // 1
     * ```
     */
    function firstIndexOf(array, value, start = 0, stop = -1) {
        let n = array.length;
        if (n === 0) {
            return -1;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        let span;
        if (stop < start) {
            span = stop + 1 + (n - start);
        }
        else {
            span = stop - start + 1;
        }
        for (let i = 0; i < span; ++i) {
            let j = (start + i) % n;
            if (array[j] === value) {
                return j;
            }
        }
        return -1;
    }
    ArrayExt.firstIndexOf = firstIndexOf;
    /**
     * Find the index of the last occurrence of a value in an array.
     *
     * @param array - The array-like object to search.
     *
     * @param value - The value to locate in the array. Values are
     *   compared using strict `===` equality.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The index of the last occurrence of the value, or `-1`
     *   if the value is not found.
     *
     * #### Notes
     * If `start < stop` the search will wrap at the front of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `start` or `stop` which is non-integral.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = ['one', 'two', 'three', 'four', 'one'];
     * ArrayExt.lastIndexOf(data, 'red');        // -1
     * ArrayExt.lastIndexOf(data, 'one');        // 4
     * ArrayExt.lastIndexOf(data, 'one', 1);     // 0
     * ArrayExt.lastIndexOf(data, 'two', 0);     // -1
     * ArrayExt.lastIndexOf(data, 'two', 0, 1);  // 1
     * ```
     */
    function lastIndexOf(array, value, start = -1, stop = 0) {
        let n = array.length;
        if (n === 0) {
            return -1;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        let span;
        if (start < stop) {
            span = start + 1 + (n - stop);
        }
        else {
            span = start - stop + 1;
        }
        for (let i = 0; i < span; ++i) {
            let j = (start - i + n) % n;
            if (array[j] === value) {
                return j;
            }
        }
        return -1;
    }
    ArrayExt.lastIndexOf = lastIndexOf;
    /**
     * Find the index of the first value which matches a predicate.
     *
     * @param array - The array-like object to search.
     *
     * @param fn - The predicate function to apply to the values.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The index of the first matching value, or `-1` if no
     *   matching value is found.
     *
     * #### Notes
     * If `stop < start` the search will wrap at the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `start` or `stop` which is non-integral.
     *
     * Modifying the length of the array while searching.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * function isEven(value: number): boolean {
     *   return value % 2 === 0;
     * }
     *
     * let data = [1, 2, 3, 4, 3, 2, 1];
     * ArrayExt.findFirstIndex(data, isEven);       // 1
     * ArrayExt.findFirstIndex(data, isEven, 4);    // 5
     * ArrayExt.findFirstIndex(data, isEven, 6);    // -1
     * ArrayExt.findFirstIndex(data, isEven, 6, 5); // 1
     * ```
     */
    function findFirstIndex(array, fn, start = 0, stop = -1) {
        let n = array.length;
        if (n === 0) {
            return -1;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        let span;
        if (stop < start) {
            span = stop + 1 + (n - start);
        }
        else {
            span = stop - start + 1;
        }
        for (let i = 0; i < span; ++i) {
            let j = (start + i) % n;
            if (fn(array[j], j)) {
                return j;
            }
        }
        return -1;
    }
    ArrayExt.findFirstIndex = findFirstIndex;
    /**
     * Find the index of the last value which matches a predicate.
     *
     * @param array - The array-like object to search.
     *
     * @param fn - The predicate function to apply to the values.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The index of the last matching value, or `-1` if no
     *   matching value is found.
     *
     * #### Notes
     * If `start < stop` the search will wrap at the front of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `start` or `stop` which is non-integral.
     *
     * Modifying the length of the array while searching.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * function isEven(value: number): boolean {
     *   return value % 2 === 0;
     * }
     *
     * let data = [1, 2, 3, 4, 3, 2, 1];
     * ArrayExt.findLastIndex(data, isEven);        // 5
     * ArrayExt.findLastIndex(data, isEven, 4);     // 3
     * ArrayExt.findLastIndex(data, isEven, 0);     // -1
     * ArrayExt.findLastIndex(data, isEven, 0, 1);  // 5
     * ```
     */
    function findLastIndex(array, fn, start = -1, stop = 0) {
        let n = array.length;
        if (n === 0) {
            return -1;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        let d;
        if (start < stop) {
            d = start + 1 + (n - stop);
        }
        else {
            d = start - stop + 1;
        }
        for (let i = 0; i < d; ++i) {
            let j = (start - i + n) % n;
            if (fn(array[j], j)) {
                return j;
            }
        }
        return -1;
    }
    ArrayExt.findLastIndex = findLastIndex;
    /**
     * Find the first value which matches a predicate.
     *
     * @param array - The array-like object to search.
     *
     * @param fn - The predicate function to apply to the values.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The first matching value, or `undefined` if no matching
     *   value is found.
     *
     * #### Notes
     * If `stop < start` the search will wrap at the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `start` or `stop` which is non-integral.
     *
     * Modifying the length of the array while searching.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * function isEven(value: number): boolean {
     *   return value % 2 === 0;
     * }
     *
     * let data = [1, 2, 3, 4, 3, 2, 1];
     * ArrayExt.findFirstValue(data, isEven);       // 2
     * ArrayExt.findFirstValue(data, isEven, 2);    // 4
     * ArrayExt.findFirstValue(data, isEven, 6);    // undefined
     * ArrayExt.findFirstValue(data, isEven, 6, 5); // 2
     * ```
     */
    function findFirstValue(array, fn, start = 0, stop = -1) {
        let index = findFirstIndex(array, fn, start, stop);
        return index !== -1 ? array[index] : undefined;
    }
    ArrayExt.findFirstValue = findFirstValue;
    /**
     * Find the last value which matches a predicate.
     *
     * @param object - The array-like object to search.
     *
     * @param fn - The predicate function to apply to the values.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The last matching value, or `undefined` if no matching
     *   value is found.
     *
     * #### Notes
     * If `start < stop` the search will wrap at the front of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `start` or `stop` which is non-integral.
     *
     * Modifying the length of the array while searching.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * function isEven(value: number): boolean {
     *   return value % 2 === 0;
     * }
     *
     * let data = [1, 2, 3, 4, 3, 2, 1];
     * ArrayExt.findLastValue(data, isEven);        // 2
     * ArrayExt.findLastValue(data, isEven, 4);     // 4
     * ArrayExt.findLastValue(data, isEven, 0);     // undefined
     * ArrayExt.findLastValue(data, isEven, 0, 1);  // 2
     * ```
     */
    function findLastValue(array, fn, start = -1, stop = 0) {
        let index = findLastIndex(array, fn, start, stop);
        return index !== -1 ? array[index] : undefined;
    }
    ArrayExt.findLastValue = findLastValue;
    /**
     * Find the index of the first element which compares `>=` to a value.
     *
     * @param array - The sorted array-like object to search.
     *
     * @param value - The value to locate in the array.
     *
     * @param fn - The 3-way comparison function to apply to the values.
     *   It should return `< 0` if an element is less than a value, `0` if
     *   an element is equal to a value, or `> 0` if an element is greater
     *   than a value.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The index of the first element which compares `>=` to the
     *   value, or `length` if there is no such element. If the computed
     *   index for `stop` is less than `start`, then the computed index
     *   for `start` is returned.
     *
     * #### Notes
     * The array must already be sorted in ascending order according to
     * the comparison function.
     *
     * #### Complexity
     * Logarithmic.
     *
     * #### Undefined Behavior
     * Searching a range which is not sorted in ascending order.
     *
     * A `start` or `stop` which is non-integral.
     *
     * Modifying the length of the array while searching.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * function numberCmp(a: number, b: number): number {
     *   return a - b;
     * }
     *
     * let data = [0, 3, 4, 7, 7, 9];
     * ArrayExt.lowerBound(data, 0, numberCmp);   // 0
     * ArrayExt.lowerBound(data, 6, numberCmp);   // 3
     * ArrayExt.lowerBound(data, 7, numberCmp);   // 3
     * ArrayExt.lowerBound(data, -1, numberCmp);  // 0
     * ArrayExt.lowerBound(data, 10, numberCmp);  // 6
     * ```
     */
    function lowerBound(array, value, fn, start = 0, stop = -1) {
        let n = array.length;
        if (n === 0) {
            return 0;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        let begin = start;
        let span = stop - start + 1;
        while (span > 0) {
            let half = span >> 1;
            let middle = begin + half;
            if (fn(array[middle], value) < 0) {
                begin = middle + 1;
                span -= half + 1;
            }
            else {
                span = half;
            }
        }
        return begin;
    }
    ArrayExt.lowerBound = lowerBound;
    /**
     * Find the index of the first element which compares `>` than a value.
     *
     * @param array - The sorted array-like object to search.
     *
     * @param value - The value to locate in the array.
     *
     * @param fn - The 3-way comparison function to apply to the values.
     *   It should return `< 0` if an element is less than a value, `0` if
     *   an element is equal to a value, or `> 0` if an element is greater
     *   than a value.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The index of the first element which compares `>` than the
     *   value, or `length` if there is no such element. If the computed
     *   index for `stop` is less than `start`, then the computed index
     *   for `start` is returned.
     *
     * #### Notes
     * The array must already be sorted in ascending order according to
     * the comparison function.
     *
     * #### Complexity
     * Logarithmic.
     *
     * #### Undefined Behavior
     * Searching a range which is not sorted in ascending order.
     *
     * A `start` or `stop` which is non-integral.
     *
     * Modifying the length of the array while searching.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * function numberCmp(a: number, b: number): number {
     *   return a - b;
     * }
     *
     * let data = [0, 3, 4, 7, 7, 9];
     * ArrayExt.upperBound(data, 0, numberCmp);   // 1
     * ArrayExt.upperBound(data, 6, numberCmp);   // 3
     * ArrayExt.upperBound(data, 7, numberCmp);   // 5
     * ArrayExt.upperBound(data, -1, numberCmp);  // 0
     * ArrayExt.upperBound(data, 10, numberCmp);  // 6
     * ```
     */
    function upperBound(array, value, fn, start = 0, stop = -1) {
        let n = array.length;
        if (n === 0) {
            return 0;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        let begin = start;
        let span = stop - start + 1;
        while (span > 0) {
            let half = span >> 1;
            let middle = begin + half;
            if (fn(array[middle], value) > 0) {
                span = half;
            }
            else {
                begin = middle + 1;
                span -= half + 1;
            }
        }
        return begin;
    }
    ArrayExt.upperBound = upperBound;
    /**
     * Test whether two arrays are shallowly equal.
     *
     * @param a - The first array-like object to compare.
     *
     * @param b - The second array-like object to compare.
     *
     * @param fn - The comparison function to apply to the elements. It
     *   should return `true` if the elements are "equal". The default
     *   compares elements using strict `===` equality.
     *
     * @returns Whether the two arrays are shallowly equal.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * Modifying the length of the arrays while comparing.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let d1 = [0, 3, 4, 7, 7, 9];
     * let d2 = [0, 3, 4, 7, 7, 9];
     * let d3 = [42];
     * ArrayExt.shallowEqual(d1, d2);  // true
     * ArrayExt.shallowEqual(d2, d3);  // false
     * ```
     */
    function shallowEqual(a, b, fn) {
        // Check for object identity first.
        if (a === b) {
            return true;
        }
        // Bail early if the lengths are different.
        if (a.length !== b.length) {
            return false;
        }
        // Compare each element for equality.
        for (let i = 0, n = a.length; i < n; ++i) {
            if (fn ? !fn(a[i], b[i]) : a[i] !== b[i]) {
                return false;
            }
        }
        // The array are shallowly equal.
        return true;
    }
    ArrayExt.shallowEqual = shallowEqual;
    /**
     * Create a slice of an array subject to an optional step.
     *
     * @param array - The array-like object of interest.
     *
     * @param options - The options for configuring the slice.
     *
     * @returns A new array with the specified values.
     *
     * @throws An exception if the slice `step` is `0`.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `start`, `stop`, or `step` which is non-integral.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = [0, 3, 4, 7, 7, 9];
     * ArrayExt.slice(data);                         // [0, 3, 4, 7, 7, 9]
     * ArrayExt.slice(data, { start: 2 });           // [4, 7, 7, 9]
     * ArrayExt.slice(data, { start: 0, stop: 4 });  // [0, 3, 4, 7]
     * ArrayExt.slice(data, { step: 2 });            // [0, 4, 7]
     * ArrayExt.slice(data, { step: -1 });           // [9, 7, 7, 4, 3, 0]
     * ```
     */
    function slice(array, options = {}) {
        // Extract the options.
        let { start, stop, step } = options;
        // Set up the `step` value.
        if (step === undefined) {
            step = 1;
        }
        // Validate the step size.
        if (step === 0) {
            throw new Error('Slice `step` cannot be zero.');
        }
        // Look up the length of the array.
        let n = array.length;
        // Set up the `start` value.
        if (start === undefined) {
            start = step < 0 ? n - 1 : 0;
        }
        else if (start < 0) {
            start = Math.max(start + n, step < 0 ? -1 : 0);
        }
        else if (start >= n) {
            start = step < 0 ? n - 1 : n;
        }
        // Set up the `stop` value.
        if (stop === undefined) {
            stop = step < 0 ? -1 : n;
        }
        else if (stop < 0) {
            stop = Math.max(stop + n, step < 0 ? -1 : 0);
        }
        else if (stop >= n) {
            stop = step < 0 ? n - 1 : n;
        }
        // Compute the slice length.
        let length;
        if ((step < 0 && stop >= start) || (step > 0 && start >= stop)) {
            length = 0;
        }
        else if (step < 0) {
            length = Math.floor((stop - start + 1) / step + 1);
        }
        else {
            length = Math.floor((stop - start - 1) / step + 1);
        }
        // Compute the sliced result.
        let result = [];
        for (let i = 0; i < length; ++i) {
            result[i] = array[start + i * step];
        }
        // Return the result.
        return result;
    }
    ArrayExt.slice = slice;
    /**
     * Move an element in an array from one index to another.
     *
     * @param array - The mutable array-like object of interest.
     *
     * @param fromIndex - The index of the element to move. Negative
     *   values are taken as an offset from the end of the array.
     *
     * @param toIndex - The target index of the element. Negative
     *   values are taken as an offset from the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `fromIndex` or `toIndex` which is non-integral.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from from '@lumino/algorithm';
     *
     * let data = [0, 1, 2, 3, 4];
     * ArrayExt.move(data, 1, 2);  // [0, 2, 1, 3, 4]
     * ArrayExt.move(data, 4, 2);  // [0, 2, 4, 1, 3]
     * ```
     */
    function move(array, fromIndex, toIndex) {
        let n = array.length;
        if (n <= 1) {
            return;
        }
        if (fromIndex < 0) {
            fromIndex = Math.max(0, fromIndex + n);
        }
        else {
            fromIndex = Math.min(fromIndex, n - 1);
        }
        if (toIndex < 0) {
            toIndex = Math.max(0, toIndex + n);
        }
        else {
            toIndex = Math.min(toIndex, n - 1);
        }
        if (fromIndex === toIndex) {
            return;
        }
        let value = array[fromIndex];
        let d = fromIndex < toIndex ? 1 : -1;
        for (let i = fromIndex; i !== toIndex; i += d) {
            array[i] = array[i + d];
        }
        array[toIndex] = value;
    }
    ArrayExt.move = move;
    /**
     * Reverse an array in-place.
     *
     * @param array - The mutable array-like object of interest.
     *
     * @param start - The index of the first element in the range to be
     *   reversed, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   reversed, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `start` or  `stop` index which is non-integral.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = [0, 1, 2, 3, 4];
     * ArrayExt.reverse(data, 1, 3);  // [0, 3, 2, 1, 4]
     * ArrayExt.reverse(data, 3);     // [0, 3, 2, 4, 1]
     * ArrayExt.reverse(data);        // [1, 4, 2, 3, 0]
     * ```
     */
    function reverse(array, start = 0, stop = -1) {
        let n = array.length;
        if (n <= 1) {
            return;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        while (start < stop) {
            let a = array[start];
            let b = array[stop];
            array[start++] = b;
            array[stop--] = a;
        }
    }
    ArrayExt.reverse = reverse;
    /**
     * Rotate the elements of an array in-place.
     *
     * @param array - The mutable array-like object of interest.
     *
     * @param delta - The amount of rotation to apply to the elements. A
     *   positive value will rotate the elements to the left. A negative
     *   value will rotate the elements to the right.
     *
     * @param start - The index of the first element in the range to be
     *   rotated, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   rotated, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `delta`, `start`, or `stop` which is non-integral.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = [0, 1, 2, 3, 4];
     * ArrayExt.rotate(data, 2);        // [2, 3, 4, 0, 1]
     * ArrayExt.rotate(data, -2);       // [0, 1, 2, 3, 4]
     * ArrayExt.rotate(data, 10);       // [0, 1, 2, 3, 4]
     * ArrayExt.rotate(data, 9);        // [4, 0, 1, 2, 3]
     * ArrayExt.rotate(data, 2, 1, 3);  // [4, 2, 0, 1, 3]
     * ```
     */
    function rotate(array, delta, start = 0, stop = -1) {
        let n = array.length;
        if (n <= 1) {
            return;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        if (start >= stop) {
            return;
        }
        let length = stop - start + 1;
        if (delta > 0) {
            delta = delta % length;
        }
        else if (delta < 0) {
            delta = ((delta % length) + length) % length;
        }
        if (delta === 0) {
            return;
        }
        let pivot = start + delta;
        reverse(array, start, pivot - 1);
        reverse(array, pivot, stop);
        reverse(array, start, stop);
    }
    ArrayExt.rotate = rotate;
    /**
     * Fill an array with a static value.
     *
     * @param array - The mutable array-like object to fill.
     *
     * @param value - The static value to use to fill the array.
     *
     * @param start - The index of the first element in the range to be
     *   filled, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   filled, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * #### Notes
     * If `stop < start` the fill will wrap at the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * A `start` or `stop` which is non-integral.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = ['one', 'two', 'three', 'four'];
     * ArrayExt.fill(data, 'r');        // ['r', 'r', 'r', 'r']
     * ArrayExt.fill(data, 'g', 1);     // ['r', 'g', 'g', 'g']
     * ArrayExt.fill(data, 'b', 2, 3);  // ['r', 'g', 'b', 'b']
     * ArrayExt.fill(data, 'z', 3, 1);  // ['z', 'z', 'b', 'z']
     * ```
     */
    function fill(array, value, start = 0, stop = -1) {
        let n = array.length;
        if (n === 0) {
            return;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        let span;
        if (stop < start) {
            span = stop + 1 + (n - start);
        }
        else {
            span = stop - start + 1;
        }
        for (let i = 0; i < span; ++i) {
            array[(start + i) % n] = value;
        }
    }
    ArrayExt.fill = fill;
    /**
     * Insert a value into an array at a specific index.
     *
     * @param array - The array of interest.
     *
     * @param index - The index at which to insert the value. Negative
     *   values are taken as an offset from the end of the array.
     *
     * @param value - The value to set at the specified index.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * An `index` which is non-integral.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = [0, 1, 2];
     * ArrayExt.insert(data, 0, -1);  // [-1, 0, 1, 2]
     * ArrayExt.insert(data, 2, 12);  // [-1, 0, 12, 1, 2]
     * ArrayExt.insert(data, -1, 7);  // [-1, 0, 12, 1, 7, 2]
     * ArrayExt.insert(data, 6, 19);  // [-1, 0, 12, 1, 7, 2, 19]
     * ```
     */
    function insert(array, index, value) {
        let n = array.length;
        if (index < 0) {
            index = Math.max(0, index + n);
        }
        else {
            index = Math.min(index, n);
        }
        for (let i = n; i > index; --i) {
            array[i] = array[i - 1];
        }
        array[index] = value;
    }
    ArrayExt.insert = insert;
    /**
     * Remove and return a value at a specific index in an array.
     *
     * @param array - The array of interest.
     *
     * @param index - The index of the value to remove. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The value at the specified index, or `undefined` if the
     *   index is out of range.
     *
     * #### Complexity
     * Linear.
     *
     * #### Undefined Behavior
     * An `index` which is non-integral.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = [0, 12, 23, 39, 14, 12, 75];
     * ArrayExt.removeAt(data, 2);   // 23
     * ArrayExt.removeAt(data, -2);  // 12
     * ArrayExt.removeAt(data, 10);  // undefined;
     * ```
     */
    function removeAt(array, index) {
        let n = array.length;
        if (index < 0) {
            index += n;
        }
        if (index < 0 || index >= n) {
            return undefined;
        }
        let value = array[index];
        for (let i = index + 1; i < n; ++i) {
            array[i - 1] = array[i];
        }
        array.length = n - 1;
        return value;
    }
    ArrayExt.removeAt = removeAt;
    /**
     * Remove the first occurrence of a value from an array.
     *
     * @param array - The array of interest.
     *
     * @param value - The value to remove from the array. Values are
     *   compared using strict `===` equality.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The index of the removed value, or `-1` if the value
     *   is not contained in the array.
     *
     * #### Notes
     * If `stop < start` the search will wrap at the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = [0, 12, 23, 39, 14, 12, 75];
     * ArrayExt.removeFirstOf(data, 12);        // 1
     * ArrayExt.removeFirstOf(data, 17);        // -1
     * ArrayExt.removeFirstOf(data, 39, 3);     // -1
     * ArrayExt.removeFirstOf(data, 39, 3, 2);  // 2
     * ```
     */
    function removeFirstOf(array, value, start = 0, stop = -1) {
        let index = firstIndexOf(array, value, start, stop);
        if (index !== -1) {
            removeAt(array, index);
        }
        return index;
    }
    ArrayExt.removeFirstOf = removeFirstOf;
    /**
     * Remove the last occurrence of a value from an array.
     *
     * @param array - The array of interest.
     *
     * @param value - The value to remove from the array. Values are
     *   compared using strict `===` equality.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The index of the removed value, or `-1` if the value
     *   is not contained in the array.
     *
     * #### Notes
     * If `start < stop` the search will wrap at the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = [0, 12, 23, 39, 14, 12, 75];
     * ArrayExt.removeLastOf(data, 12);        // 5
     * ArrayExt.removeLastOf(data, 17);        // -1
     * ArrayExt.removeLastOf(data, 39, 2);     // -1
     * ArrayExt.removeLastOf(data, 39, 2, 3);  // 3
     * ```
     */
    function removeLastOf(array, value, start = -1, stop = 0) {
        let index = lastIndexOf(array, value, start, stop);
        if (index !== -1) {
            removeAt(array, index);
        }
        return index;
    }
    ArrayExt.removeLastOf = removeLastOf;
    /**
     * Remove all occurrences of a value from an array.
     *
     * @param array - The array of interest.
     *
     * @param value - The value to remove from the array. Values are
     *   compared using strict `===` equality.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The number of elements removed from the array.
     *
     * #### Notes
     * If `stop < start` the search will conceptually wrap at the end of
     * the array, however the array will be traversed front-to-back.
     *
     * #### Complexity
     * Linear.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * let data = [14, 12, 23, 39, 14, 12, 19, 14];
     * ArrayExt.removeAllOf(data, 12);        // 2
     * ArrayExt.removeAllOf(data, 17);        // 0
     * ArrayExt.removeAllOf(data, 14, 1, 4);  // 1
     * ```
     */
    function removeAllOf(array, value, start = 0, stop = -1) {
        let n = array.length;
        if (n === 0) {
            return 0;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        let count = 0;
        for (let i = 0; i < n; ++i) {
            if (start <= stop && i >= start && i <= stop && array[i] === value) {
                count++;
            }
            else if (stop < start &&
                (i <= stop || i >= start) &&
                array[i] === value) {
                count++;
            }
            else if (count > 0) {
                array[i - count] = array[i];
            }
        }
        if (count > 0) {
            array.length = n - count;
        }
        return count;
    }
    ArrayExt.removeAllOf = removeAllOf;
    /**
     * Remove the first occurrence of a value which matches a predicate.
     *
     * @param array - The array of interest.
     *
     * @param fn - The predicate function to apply to the values.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The removed `{ index, value }`, which will be `-1` and
     *   `undefined` if the value is not contained in the array.
     *
     * #### Notes
     * If `stop < start` the search will wrap at the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * function isEven(value: number): boolean {
     *   return value % 2 === 0;
     * }
     *
     * let data = [0, 12, 23, 39, 14, 12, 75];
     * ArrayExt.removeFirstWhere(data, isEven);     // { index: 0, value: 0 }
     * ArrayExt.removeFirstWhere(data, isEven, 2);  // { index: 3, value: 14 }
     * ArrayExt.removeFirstWhere(data, isEven, 4);  // { index: -1, value: undefined }
     * ```
     */
    function removeFirstWhere(array, fn, start = 0, stop = -1) {
        let value;
        let index = findFirstIndex(array, fn, start, stop);
        if (index !== -1) {
            value = removeAt(array, index);
        }
        return { index, value };
    }
    ArrayExt.removeFirstWhere = removeFirstWhere;
    /**
     * Remove the last occurrence of a value which matches a predicate.
     *
     * @param array - The array of interest.
     *
     * @param fn - The predicate function to apply to the values.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The removed `{ index, value }`, which will be `-1` and
     *   `undefined` if the value is not contained in the array.
     *
     * #### Notes
     * If `start < stop` the search will wrap at the end of the array.
     *
     * #### Complexity
     * Linear.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * function isEven(value: number): boolean {
     *   return value % 2 === 0;
     * }
     *
     * let data = [0, 12, 23, 39, 14, 12, 75];
     * ArrayExt.removeLastWhere(data, isEven);        // { index: 5, value: 12 }
     * ArrayExt.removeLastWhere(data, isEven, 2);     // { index: 1, value: 12 }
     * ArrayExt.removeLastWhere(data, isEven, 2, 1);  // { index: -1, value: undefined }
     * ```
     */
    function removeLastWhere(array, fn, start = -1, stop = 0) {
        let value;
        let index = findLastIndex(array, fn, start, stop);
        if (index !== -1) {
            value = removeAt(array, index);
        }
        return { index, value };
    }
    ArrayExt.removeLastWhere = removeLastWhere;
    /**
     * Remove all occurrences of values which match a predicate.
     *
     * @param array - The array of interest.
     *
     * @param fn - The predicate function to apply to the values.
     *
     * @param start - The index of the first element in the range to be
     *   searched, inclusive. The default value is `0`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @param stop - The index of the last element in the range to be
     *   searched, inclusive. The default value is `-1`. Negative values
     *   are taken as an offset from the end of the array.
     *
     * @returns The number of elements removed from the array.
     *
     * #### Notes
     * If `stop < start` the search will conceptually wrap at the end of
     * the array, however the array will be traversed front-to-back.
     *
     * #### Complexity
     * Linear.
     *
     * #### Example
     * ```typescript
     * import { ArrayExt } from '@lumino/algorithm';
     *
     * function isEven(value: number): boolean {
     *   return value % 2 === 0;
     * }
     *
     * function isNegative(value: number): boolean {
     *   return value < 0;
     * }
     *
     * let data = [0, 12, -13, -9, 23, 39, 14, -15, 12, 75];
     * ArrayExt.removeAllWhere(data, isEven);            // 4
     * ArrayExt.removeAllWhere(data, isNegative, 0, 3);  // 2
     * ```
     */
    function removeAllWhere(array, fn, start = 0, stop = -1) {
        let n = array.length;
        if (n === 0) {
            return 0;
        }
        if (start < 0) {
            start = Math.max(0, start + n);
        }
        else {
            start = Math.min(start, n - 1);
        }
        if (stop < 0) {
            stop = Math.max(0, stop + n);
        }
        else {
            stop = Math.min(stop, n - 1);
        }
        let count = 0;
        for (let i = 0; i < n; ++i) {
            if (start <= stop && i >= start && i <= stop && fn(array[i], i)) {
                count++;
            }
            else if (stop < start && (i <= stop || i >= start) && fn(array[i], i)) {
                count++;
            }
            else if (count > 0) {
                array[i - count] = array[i];
            }
        }
        if (count > 0) {
            array.length = n - count;
        }
        return count;
    }
    ArrayExt.removeAllWhere = removeAllWhere;
})(ArrayExt || (ArrayExt = {}));

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Chain together several iterables.
 *
 * @deprecated
 *
 * @param objects - The iterable objects of interest.
 *
 * @returns An iterator which yields the values of the iterables
 *   in the order in which they are supplied.
 *
 * #### Example
 * ```typescript
 * import { chain } from '@lumino/algorithm';
 *
 * let data1 = [1, 2, 3];
 * let data2 = [4, 5, 6];
 *
 * let stream = chain(data1, data2);
 *
 * Array.from(stream);  // [1, 2, 3, 4, 5, 6]
 * ```
 */
function* chain(...objects) {
    for (const object of objects) {
        yield* object;
    }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Create an empty iterator.
 *
 * @returns A new iterator which yields nothing.
 *
 * #### Example
 * ```typescript
 * import { empty } from '@lumino/algorithm';
 *
 * let stream = empty<number>();
 *
 * Array.from(stream);  // []
 * ```
 */
// eslint-disable-next-line require-yield
function* empty() {
    return;
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Enumerate an iterable object.
 *
 * @param object - The iterable object of interest.
 *
 * @param start - The starting enum value. The default is `0`.
 *
 * @returns An iterator which yields the enumerated values.
 *
 * #### Example
 * ```typescript
 * import { enumerate } from '@lumino/algorithm';
 *
 * let data = ['foo', 'bar', 'baz'];
 *
 * let stream = enumerate(data, 1);
 *
 * Array.from(stream);  // [[1, 'foo'], [2, 'bar'], [3, 'baz']]
 * ```
 */
function* enumerate(object, start = 0) {
    for (const value of object) {
        yield [start++, value];
    }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Filter an iterable for values which pass a test.
 *
 * @param object - The iterable object of interest.
 *
 * @param fn - The predicate function to invoke for each value.
 *
 * @returns An iterator which yields the values which pass the test.
 *
 * #### Example
 * ```typescript
 * import { filter } from '@lumino/algorithm';
 *
 * let data = [1, 2, 3, 4, 5, 6];
 *
 * let stream = filter(data, value => value % 2 === 0);
 *
 * Array.from(stream);  // [2, 4, 6]
 * ```
 */
function* filter(object, fn) {
    let index = 0;
    for (const value of object) {
        if (fn(value, index++)) {
            yield value;
        }
    }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Find the first value in an iterable which matches a predicate.
 *
 * @param object - The iterable object to search.
 *
 * @param fn - The predicate function to apply to the values.
 *
 * @returns The first matching value, or `undefined` if no matching
 *   value is found.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { find } from '@lumino/algorithm';
 *
 * interface IAnimal { species: string, name: string };
 *
 * function isCat(value: IAnimal): boolean {
 *   return value.species === 'cat';
 * }
 *
 * let data: IAnimal[] = [
 *   { species: 'dog', name: 'spot' },
 *   { species: 'cat', name: 'fluffy' },
 *   { species: 'alligator', name: 'pocho' }
 * ];
 *
 * find(data, isCat).name;  // 'fluffy'
 * ```
 */
function find(object, fn) {
    let index = 0;
    for (const value of object) {
        if (fn(value, index++)) {
            return value;
        }
    }
    return undefined;
}
/**
 * Find the index of the first value which matches a predicate.
 *
 * @param object - The iterable object to search.
 *
 * @param fn - The predicate function to apply to the values.
 *
 * @returns The index of the first matching value, or `-1` if no
 *   matching value is found.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { findIndex } from '@lumino/algorithm';
 *
 * interface IAnimal { species: string, name: string };
 *
 * function isCat(value: IAnimal): boolean {
 *   return value.species === 'cat';
 * }
 *
 * let data: IAnimal[] = [
 *   { species: 'dog', name: 'spot' },
 *   { species: 'cat', name: 'fluffy' },
 *   { species: 'alligator', name: 'pocho' }
 * ];
 *
 * findIndex(data, isCat);  // 1
 * ```
 */
function findIndex(object, fn) {
    let index = 0;
    for (const value of object) {
        if (fn(value, index++)) {
            return index - 1;
        }
    }
    return -1;
}
/**
 * Find the minimum value in an iterable.
 *
 * @param object - The iterable object to search.
 *
 * @param fn - The 3-way comparison function to apply to the values.
 *   It should return `< 0` if the first value is less than the second.
 *   `0` if the values are equivalent, or `> 0` if the first value is
 *   greater than the second.
 *
 * @returns The minimum value in the iterable. If multiple values are
 *   equivalent to the minimum, the left-most value is returned. If
 *   the iterable is empty, this returns `undefined`.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { min } from '@lumino/algorithm';
 *
 * function numberCmp(a: number, b: number): number {
 *   return a - b;
 * }
 *
 * min([7, 4, 0, 3, 9, 4], numberCmp);  // 0
 * ```
 */
function min(object, fn) {
    let result = undefined;
    for (const value of object) {
        if (result === undefined) {
            result = value;
            continue;
        }
        if (fn(value, result) < 0) {
            result = value;
        }
    }
    return result;
}
/**
 * Find the maximum value in an iterable.
 *
 * @param object - The iterable object to search.
 *
 * @param fn - The 3-way comparison function to apply to the values.
 *   It should return `< 0` if the first value is less than the second.
 *   `0` if the values are equivalent, or `> 0` if the first value is
 *   greater than the second.
 *
 * @returns The maximum value in the iterable. If multiple values are
 *   equivalent to the maximum, the left-most value is returned. If
 *   the iterable is empty, this returns `undefined`.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { max } from '@lumino/algorithm';
 *
 * function numberCmp(a: number, b: number): number {
 *   return a - b;
 * }
 *
 * max([7, 4, 0, 3, 9, 4], numberCmp);  // 9
 * ```
 */
function max(object, fn) {
    let result = undefined;
    for (const value of object) {
        if (result === undefined) {
            result = value;
            continue;
        }
        if (fn(value, result) > 0) {
            result = value;
        }
    }
    return result;
}
/**
 * Find the minimum and maximum values in an iterable.
 *
 * @param object - The iterable object to search.
 *
 * @param fn - The 3-way comparison function to apply to the values.
 *   It should return `< 0` if the first value is less than the second.
 *   `0` if the values are equivalent, or `> 0` if the first value is
 *   greater than the second.
 *
 * @returns A 2-tuple of the `[min, max]` values in the iterable. If
 *   multiple values are equivalent, the left-most values are returned.
 *   If the iterable is empty, this returns `undefined`.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { minmax } from '@lumino/algorithm';
 *
 * function numberCmp(a: number, b: number): number {
 *   return a - b;
 * }
 *
 * minmax([7, 4, 0, 3, 9, 4], numberCmp);  // [0, 9]
 * ```
 */
function minmax(object, fn) {
    let empty = true;
    let vmin;
    let vmax;
    for (const value of object) {
        if (empty) {
            vmin = value;
            vmax = value;
            empty = false;
        }
        else if (fn(value, vmin) < 0) {
            vmin = value;
        }
        else if (fn(value, vmax) > 0) {
            vmax = value;
        }
    }
    return empty ? undefined : [vmin, vmax];
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Create an array from an iterable of values.
 *
 * @deprecated
 *
 * @param object - The iterable object of interest.
 *
 * @returns A new array of values from the given object.
 *
 * #### Example
 * ```typescript
 * import { toArray } from '@lumino/algorithm';
 *
 * let stream = [1, 2, 3, 4, 5, 6][Symbol.iterator]();
 *
 * toArray(stream);  // [1, 2, 3, 4, 5, 6];
 * ```
 */
function toArray(object) {
    return Array.from(object);
}
/**
 * Create an object from an iterable of key/value pairs.
 *
 * @param object - The iterable object of interest.
 *
 * @returns A new object mapping keys to values.
 *
 * #### Example
 * ```typescript
 * import { toObject } from '@lumino/algorithm';
 *
 * let data: [string, number][] = [['one', 1], ['two', 2], ['three', 3]];
 *
 * toObject(data);  // { one: 1, two: 2, three: 3 }
 * ```
 */
function toObject(object) {
    const result = {};
    for (const [key, value] of object) {
        result[key] = value;
    }
    return result;
}
/**
 * Invoke a function for each value in an iterable.
 *
 * @deprecated
 *
 * @param object - The iterable object of interest.
 *
 * @param fn - The callback function to invoke for each value.
 *
 * #### Notes
 * Iteration can be terminated early by returning `false` from the
 * callback function.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { each } from '@lumino/algorithm';
 *
 * let data = [5, 7, 0, -2, 9];
 *
 * each(data, value => { console.log(value); });
 * ```
 */
function each(object, fn) {
    let index = 0;
    for (const value of object) {
        if (false === fn(value, index++)) {
            return;
        }
    }
}
/**
 * Test whether all values in an iterable satisfy a predicate.
 *
 * @param object - The iterable object of interest.
 *
 * @param fn - The predicate function to invoke for each value.
 *
 * @returns `true` if all values pass the test, `false` otherwise.
 *
 * #### Notes
 * Iteration terminates on the first `false` predicate result.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { every } from '@lumino/algorithm';
 *
 * let data = [5, 7, 1];
 *
 * every(data, value => value % 2 === 0);  // false
 * every(data, value => value % 2 === 1);  // true
 * ```
 */
function every(object, fn) {
    let index = 0;
    for (const value of object) {
        if (false === fn(value, index++)) {
            return false;
        }
    }
    return true;
}
/**
 * Test whether any value in an iterable satisfies a predicate.
 *
 * @param object - The iterable object of interest.
 *
 * @param fn - The predicate function to invoke for each value.
 *
 * @returns `true` if any value passes the test, `false` otherwise.
 *
 * #### Notes
 * Iteration terminates on the first `true` predicate result.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { some } from '@lumino/algorithm';
 *
 * let data = [5, 7, 1];
 *
 * some(data, value => value === 7);  // true
 * some(data, value => value === 3);  // false
 * ```
 */
function some(object, fn) {
    let index = 0;
    for (const value of object) {
        if (fn(value, index++)) {
            return true;
        }
    }
    return false;
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Transform the values of an iterable with a mapping function.
 *
 * @param object - The iterable object of interest.
 *
 * @param fn - The mapping function to invoke for each value.
 *
 * @returns An iterator which yields the transformed values.
 *
 * #### Example
 * ```typescript
 * import { map } from '@lumino/algorithm';
 *
 * let data = [1, 2, 3];
 *
 * let stream = map(data, value => value * 2);
 *
 * Array.from(stream);  // [2, 4, 6]
 * ```
 */
function* map(object, fn) {
    let index = 0;
    for (const value of object) {
        yield fn(value, index++);
    }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Create an iterator of evenly spaced values.
 *
 * @param start - The starting value for the range, inclusive.
 *
 * @param stop - The stopping value for the range, exclusive.
 *
 * @param step - The distance between each value.
 *
 * @returns An iterator which produces evenly spaced values.
 *
 * #### Notes
 * In the single argument form of `range(stop)`, `start` defaults to
 * `0` and `step` defaults to `1`.
 *
 * In the two argument form of `range(start, stop)`, `step` defaults
 * to `1`.
 *
 * #### Example
 * ```typescript
 * import { range } from '@lumino/algorithm';
 *
 * let stream = range(2, 4);
 *
 * Array.from(stream);  // [2, 3]
 * ```
 */
function* range(start, stop, step) {
    if (stop === undefined) {
        stop = start;
        start = 0;
        step = 1;
    }
    else if (step === undefined) {
        step = 1;
    }
    const length = Private.rangeLength(start, stop, step);
    for (let index = 0; index < length; index++) {
        yield start + step * index;
    }
}
/**
 * The namespace for the module implementation details.
 */
var Private;
(function (Private) {
    /**
     * Compute the effective length of a range.
     *
     * @param start - The starting value for the range, inclusive.
     *
     * @param stop - The stopping value for the range, exclusive.
     *
     * @param step - The distance between each value.
     *
     * @returns The number of steps need to traverse the range.
     */
    function rangeLength(start, stop, step) {
        if (step === 0) {
            return Infinity;
        }
        if (start > stop && step > 0) {
            return 0;
        }
        if (start < stop && step < 0) {
            return 0;
        }
        return Math.ceil((stop - start) / step);
    }
    Private.rangeLength = rangeLength;
})(Private || (Private = {}));

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
function reduce(object, fn, initial) {
    // Setup the iterator and fetch the first value.
    const it = object[Symbol.iterator]();
    let index = 0;
    let first = it.next();
    // An empty iterator and no initial value is an error.
    if (first.done && initial === undefined) {
        throw new TypeError('Reduce of empty iterable with no initial value.');
    }
    // If the iterator is empty, return the initial value.
    if (first.done) {
        return initial;
    }
    // If the iterator has a single item and no initial value, the
    // reducer is not invoked and the first item is the return value.
    let second = it.next();
    if (second.done && initial === undefined) {
        return first.value;
    }
    // If iterator has a single item and an initial value is provided,
    // the reducer is invoked and that result is the return value.
    if (second.done) {
        return fn(initial, first.value, index++);
    }
    // Setup the initial accumlated value.
    let accumulator;
    if (initial === undefined) {
        accumulator = fn(first.value, second.value, index++);
    }
    else {
        accumulator = fn(fn(initial, first.value, index++), second.value, index++);
    }
    // Iterate the rest of the values, updating the accumulator.
    let next;
    while (!(next = it.next()).done) {
        accumulator = fn(accumulator, next.value, index++);
    }
    // Return the final accumulated value.
    return accumulator;
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Create an iterator which repeats a value a number of times.
 *
 * @deprecated
 *
 * @param value - The value to repeat.
 *
 * @param count - The number of times to repeat the value.
 *
 * @returns A new iterator which repeats the specified value.
 *
 * #### Example
 * ```typescript
 * import { repeat } from '@lumino/algorithm';
 *
 * let stream = repeat(7, 3);
 *
 * Array.from(stream);  // [7, 7, 7]
 * ```
 */
function* repeat(value, count) {
    while (0 < count--) {
        yield value;
    }
}
/**
 * Create an iterator which yields a value a single time.
 *
 * @deprecated
 *
 * @param value - The value to wrap in an iterator.
 *
 * @returns A new iterator which yields the value a single time.
 *
 * #### Example
 * ```typescript
 * import { once } from '@lumino/algorithm';
 *
 * let stream = once(7);
 *
 * Array.from(stream);  // [7]
 * ```
 */
function* once(value) {
    yield value;
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Create an iterator for a retroable object.
 *
 * @param object - The retroable or array-like object of interest.
 *
 * @returns An iterator which traverses the object's values in reverse.
 *
 * #### Example
 * ```typescript
 * import { retro } from '@lumino/algorithm';
 *
 * let data = [1, 2, 3, 4, 5, 6];
 *
 * let stream = retro(data);
 *
 * Array.from(stream);  // [6, 5, 4, 3, 2, 1]
 * ```
 */
function* retro(object) {
    if (typeof object.retro === 'function') {
        yield* object.retro();
    }
    else {
        for (let index = object.length - 1; index > -1; index--) {
            yield object[index];
        }
    }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Topologically sort an iterable of edges.
 *
 * @param edges - The iterable object of edges to sort.
 *   An edge is represented as a 2-tuple of `[fromNode, toNode]`.
 *
 * @returns The topologically sorted array of nodes.
 *
 * #### Notes
 * If a cycle is present in the graph, the cycle will be ignored and
 * the return value will be only approximately sorted.
 *
 * #### Example
 * ```typescript
 * import { topologicSort } from '@lumino/algorithm';
 *
 * let data = [
 *   ['d', 'e'],
 *   ['c', 'd'],
 *   ['a', 'b'],
 *   ['b', 'c']
 * ];
 *
 * topologicSort(data);  // ['a', 'b', 'c', 'd', 'e']
 * ```
 */
function topologicSort(edges) {
    // Setup the shared sorting state.
    let sorted = [];
    let visited = new Set();
    let graph = new Map();
    // Add the edges to the graph.
    for (const edge of edges) {
        addEdge(edge);
    }
    // Visit each node in the graph.
    for (const [k] of graph) {
        visit(k);
    }
    // Return the sorted results.
    return sorted;
    // Add an edge to the graph.
    function addEdge(edge) {
        let [fromNode, toNode] = edge;
        let children = graph.get(toNode);
        if (children) {
            children.push(fromNode);
        }
        else {
            graph.set(toNode, [fromNode]);
        }
    }
    // Recursively visit the node.
    function visit(node) {
        if (visited.has(node)) {
            return;
        }
        visited.add(node);
        let children = graph.get(node);
        if (children) {
            for (const child of children) {
                visit(child);
            }
        }
        sorted.push(node);
    }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Iterate over an iterable using a stepped increment.
 *
 * @param object - The iterable object of interest.
 *
 * @param step - The distance to step on each iteration. A value
 *   of less than `1` will behave the same as a value of `1`.
 *
 * @returns An iterator which traverses the iterable step-wise.
 *
 * #### Example
 * ```typescript
 * import { stride } from '@lumino/algorithm';
 *
 * let data = [1, 2, 3, 4, 5, 6];
 *
 * let stream = stride(data, 2);
 *
 * Array.from(stream);  // [1, 3, 5];
 * ```
 */
function* stride(object, step) {
    let count = 0;
    for (const value of object) {
        if (0 === count++ % step) {
            yield value;
        }
    }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * The namespace for string-specific algorithms.
 */
var StringExt;
(function (StringExt) {
    /**
     * Find the indices of characters in a source text.
     *
     * @param source - The source text which should be searched.
     *
     * @param query - The characters to locate in the source text.
     *
     * @param start - The index to start the search.
     *
     * @returns The matched indices, or `null` if there is no match.
     *
     * #### Complexity
     * Linear on `sourceText`.
     *
     * #### Notes
     * In order for there to be a match, all of the characters in `query`
     * **must** appear in `source` in the order given by `query`.
     *
     * Characters are matched using strict `===` equality.
     */
    function findIndices(source, query, start = 0) {
        let indices = new Array(query.length);
        for (let i = 0, j = start, n = query.length; i < n; ++i, ++j) {
            j = source.indexOf(query[i], j);
            if (j === -1) {
                return null;
            }
            indices[i] = j;
        }
        return indices;
    }
    StringExt.findIndices = findIndices;
    /**
     * A string matcher which uses a sum-of-squares algorithm.
     *
     * @param source - The source text which should be searched.
     *
     * @param query - The characters to locate in the source text.
     *
     * @param start - The index to start the search.
     *
     * @returns The match result, or `null` if there is no match.
     *   A lower `score` represents a stronger match.
     *
     * #### Complexity
     * Linear on `sourceText`.
     *
     * #### Notes
     * This scoring algorithm uses a sum-of-squares approach to determine
     * the score. In order for there to be a match, all of the characters
     * in `query` **must** appear in `source` in order. The index of each
     * matching character is squared and added to the score. This means
     * that early and consecutive character matches are preferred, while
     * late matches are heavily penalized.
     */
    function matchSumOfSquares(source, query, start = 0) {
        let indices = findIndices(source, query, start);
        if (!indices) {
            return null;
        }
        let score = 0;
        for (let i = 0, n = indices.length; i < n; ++i) {
            let j = indices[i] - start;
            score += j * j;
        }
        return { score, indices };
    }
    StringExt.matchSumOfSquares = matchSumOfSquares;
    /**
     * A string matcher which uses a sum-of-deltas algorithm.
     *
     * @param source - The source text which should be searched.
     *
     * @param query - The characters to locate in the source text.
     *
     * @param start - The index to start the search.
     *
     * @returns The match result, or `null` if there is no match.
     *   A lower `score` represents a stronger match.
     *
     * #### Complexity
     * Linear on `sourceText`.
     *
     * #### Notes
     * This scoring algorithm uses a sum-of-deltas approach to determine
     * the score. In order for there to be a match, all of the characters
     * in `query` **must** appear in `source` in order. The delta between
     * the indices are summed to create the score. This means that groups
     * of matched characters are preferred, while fragmented matches are
     * penalized.
     */
    function matchSumOfDeltas(source, query, start = 0) {
        let indices = findIndices(source, query, start);
        if (!indices) {
            return null;
        }
        let score = 0;
        let last = start - 1;
        for (let i = 0, n = indices.length; i < n; ++i) {
            let j = indices[i];
            score += j - last - 1;
            last = j;
        }
        return { score, indices };
    }
    StringExt.matchSumOfDeltas = matchSumOfDeltas;
    /**
     * Highlight the matched characters of a source text.
     *
     * @param source - The text which should be highlighted.
     *
     * @param indices - The indices of the matched characters. They must
     *   appear in increasing order and must be in bounds of the source.
     *
     * @param fn - The function to apply to the matched chunks.
     *
     * @returns An array of unmatched and highlighted chunks.
     */
    function highlight(source, indices, fn) {
        // Set up the result array.
        let result = [];
        // Set up the counter variables.
        let k = 0;
        let last = 0;
        let n = indices.length;
        // Iterator over each index.
        while (k < n) {
            // Set up the chunk indices.
            let i = indices[k];
            let j = indices[k];
            // Advance the right chunk index until it's non-contiguous.
            while (++k < n && indices[k] === j + 1) {
                j++;
            }
            // Extract the unmatched text.
            if (last < i) {
                result.push(source.slice(last, i));
            }
            // Extract and highlight the matched text.
            if (i < j + 1) {
                result.push(fn(source.slice(i, j + 1)));
            }
            // Update the last visited index.
            last = j + 1;
        }
        // Extract any remaining unmatched text.
        if (last < source.length) {
            result.push(source.slice(last));
        }
        // Return the highlighted result.
        return result;
    }
    StringExt.highlight = highlight;
    /**
     * A 3-way string comparison function.
     *
     * @param a - The first string of interest.
     *
     * @param b - The second string of interest.
     *
     * @returns `-1` if `a < b`, else `1` if `a > b`, else `0`.
     */
    function cmp(a, b) {
        return a < b ? -1 : a > b ? 1 : 0;
    }
    StringExt.cmp = cmp;
})(StringExt || (StringExt = {}));

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Take a fixed number of items from an iterable.
 *
 * @param object - The iterable object of interest.
 *
 * @param count - The number of items to take from the iterable.
 *
 * @returns An iterator which yields the specified number of items
 *   from the source iterable.
 *
 * #### Notes
 * The returned iterator will exhaust early if the source iterable
 * contains an insufficient number of items.
 *
 * #### Example
 * ```typescript
 * import { take } from '@lumino/algorithm';
 *
 * let stream = take([5, 4, 3, 2, 1, 0, -1], 3);
 *
 * Array.from(stream);  // [5, 4, 3]
 * ```
 */
function* take(object, count) {
    if (count < 1) {
        return;
    }
    const it = object[Symbol.iterator]();
    let item;
    while (0 < count-- && !(item = it.next()).done) {
        yield item.value;
    }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Iterate several iterables in lockstep.
 *
 * @param objects - The iterable objects of interest.
 *
 * @returns An iterator which yields successive tuples of values where
 *   each value is taken in turn from the provided iterables. It will
 *   be as long as the shortest provided iterable.
 *
 * #### Example
 * ```typescript
 * import { zip } from '@lumino/algorithm';
 *
 * let data1 = [1, 2, 3];
 * let data2 = [4, 5, 6];
 *
 * let stream = zip(data1, data2);
 *
 * Array.from(stream);  // [[1, 4], [2, 5], [3, 6]]
 * ```
 */
function* zip(...objects) {
    const iters = objects.map(obj => obj[Symbol.iterator]());
    let tuple = iters.map(it => it.next());
    for (; every(tuple, item => !item.done); tuple = iters.map(it => it.next())) {
        yield tuple.map(item => item.value);
    }
}


//# sourceMappingURL=index.es6.js.map


/***/ }),

/***/ "../node_modules/@lumino/coreutils/dist/index.js":
/*!*******************************************************!*\
  !*** ../node_modules/@lumino/coreutils/dist/index.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

(function (global, factory) {
     true ? factory(exports, __webpack_require__(/*! @lumino/algorithm */ "../node_modules/@lumino/algorithm/dist/index.es6.js")) :
    0;
})(this, (function (exports, algorithm) { 'use strict';

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for JSON-specific functions.
     */
    exports.JSONExt = void 0;
    (function (JSONExt) {
        /**
         * A shared frozen empty JSONObject
         */
        JSONExt.emptyObject = Object.freeze({});
        /**
         * A shared frozen empty JSONArray
         */
        JSONExt.emptyArray = Object.freeze([]);
        /**
         * Test whether a JSON value is a primitive.
         *
         * @param value - The JSON value of interest.
         *
         * @returns `true` if the value is a primitive,`false` otherwise.
         */
        function isPrimitive(value) {
            return (value === null ||
                typeof value === 'boolean' ||
                typeof value === 'number' ||
                typeof value === 'string');
        }
        JSONExt.isPrimitive = isPrimitive;
        function isArray(value) {
            return Array.isArray(value);
        }
        JSONExt.isArray = isArray;
        function isObject(value) {
            return !isPrimitive(value) && !isArray(value);
        }
        JSONExt.isObject = isObject;
        /**
         * Compare two JSON values for deep equality.
         *
         * @param first - The first JSON value of interest.
         *
         * @param second - The second JSON value of interest.
         *
         * @returns `true` if the values are equivalent, `false` otherwise.
         */
        function deepEqual(first, second) {
            // Check referential and primitive equality first.
            if (first === second) {
                return true;
            }
            // If one is a primitive, the `===` check ruled out the other.
            if (isPrimitive(first) || isPrimitive(second)) {
                return false;
            }
            // Test whether they are arrays.
            let a1 = isArray(first);
            let a2 = isArray(second);
            // Bail if the types are different.
            if (a1 !== a2) {
                return false;
            }
            // If they are both arrays, compare them.
            if (a1 && a2) {
                return deepArrayEqual(first, second);
            }
            // At this point, they must both be objects.
            return deepObjectEqual(first, second);
        }
        JSONExt.deepEqual = deepEqual;
        /**
         * Create a deep copy of a JSON value.
         *
         * @param value - The JSON value to copy.
         *
         * @returns A deep copy of the given JSON value.
         */
        function deepCopy(value) {
            // Do nothing for primitive values.
            if (isPrimitive(value)) {
                return value;
            }
            // Deep copy an array.
            if (isArray(value)) {
                return deepArrayCopy(value);
            }
            // Deep copy an object.
            return deepObjectCopy(value);
        }
        JSONExt.deepCopy = deepCopy;
        /**
         * Compare two JSON arrays for deep equality.
         */
        function deepArrayEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Test the arrays for equal length.
            if (first.length !== second.length) {
                return false;
            }
            // Compare the values for equality.
            for (let i = 0, n = first.length; i < n; ++i) {
                if (!deepEqual(first[i], second[i])) {
                    return false;
                }
            }
            // At this point, the arrays are equal.
            return true;
        }
        /**
         * Compare two JSON objects for deep equality.
         */
        function deepObjectEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Check for the first object's keys in the second object.
            for (let key in first) {
                if (first[key] !== undefined && !(key in second)) {
                    return false;
                }
            }
            // Check for the second object's keys in the first object.
            for (let key in second) {
                if (second[key] !== undefined && !(key in first)) {
                    return false;
                }
            }
            // Compare the values for equality.
            for (let key in first) {
                // Get the values.
                let firstValue = first[key];
                let secondValue = second[key];
                // If both are undefined, ignore the key.
                if (firstValue === undefined && secondValue === undefined) {
                    continue;
                }
                // If only one value is undefined, the objects are not equal.
                if (firstValue === undefined || secondValue === undefined) {
                    return false;
                }
                // Compare the values.
                if (!deepEqual(firstValue, secondValue)) {
                    return false;
                }
            }
            // At this point, the objects are equal.
            return true;
        }
        /**
         * Create a deep copy of a JSON array.
         */
        function deepArrayCopy(value) {
            let result = new Array(value.length);
            for (let i = 0, n = value.length; i < n; ++i) {
                result[i] = deepCopy(value[i]);
            }
            return result;
        }
        /**
         * Create a deep copy of a JSON object.
         */
        function deepObjectCopy(value) {
            let result = {};
            for (let key in value) {
                // Ignore undefined values.
                let subvalue = value[key];
                if (subvalue === undefined) {
                    continue;
                }
                result[key] = deepCopy(subvalue);
            }
            return result;
        }
    })(exports.JSONExt || (exports.JSONExt = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * An object which stores MIME data for general application use.
     *
     * #### Notes
     * This class does not attempt to enforce "correctness" of MIME types
     * and their associated data. Since this class is designed to transfer
     * arbitrary data and objects within the same application, it assumes
     * that the user provides correct and accurate data.
     */
    class MimeData {
        constructor() {
            this._types = [];
            this._values = [];
        }
        /**
         * Get an array of the MIME types contained within the dataset.
         *
         * @returns A new array of the MIME types, in order of insertion.
         */
        types() {
            return this._types.slice();
        }
        /**
         * Test whether the dataset has an entry for the given type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns `true` if the dataset contains a value for the given
         *   MIME type, `false` otherwise.
         */
        hasData(mime) {
            return this._types.indexOf(mime) !== -1;
        }
        /**
         * Get the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns The value for the given MIME type, or `undefined` if
         *   the dataset does not contain a value for the type.
         */
        getData(mime) {
            let i = this._types.indexOf(mime);
            return i !== -1 ? this._values[i] : undefined;
        }
        /**
         * Set the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @param data - The data value for the given MIME type.
         *
         * #### Notes
         * This will overwrite any previous entry for the MIME type.
         */
        setData(mime, data) {
            this.clearData(mime);
            this._types.push(mime);
            this._values.push(data);
        }
        /**
         * Remove the data entry for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * #### Notes
         * This is a no-op if there is no entry for the given MIME type.
         */
        clearData(mime) {
            let i = this._types.indexOf(mime);
            if (i !== -1) {
                this._types.splice(i, 1);
                this._values.splice(i, 1);
            }
        }
        /**
         * Remove all data entries from the dataset.
         */
        clear() {
            this._types.length = 0;
            this._values.length = 0;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /**
     * Plugin registry.
     */
    class PluginRegistry {
        constructor(options = {}) {
            this._application = null;
            this._validatePlugin = () => true;
            this._plugins = new Map();
            this._services = new Map();
            if (options.validatePlugin) {
                console.info('Plugins may be rejected by the custom validation plugin method.');
                this._validatePlugin = options.validatePlugin;
            }
        }
        /**
         * The application object.
         *
         * It will be provided as first argument to the
         * plugins activation and deactivation functions.
         *
         * It can only be set once.
         *
         * By default, it is `null`.
         */
        get application() {
            return this._application;
        }
        set application(v) {
            if (this._application !== null) {
                throw Error('PluginRegistry.application is already set. It cannot be overridden.');
            }
            this._application = v;
        }
        /**
         * The list of all the deferred plugins.
         */
        get deferredPlugins() {
            return Array.from(this._plugins)
                .filter(([id, plugin]) => plugin.autoStart === 'defer')
                .map(([id, plugin]) => id);
        }
        /**
         * Get a plugin description.
         *
         * @param id - The ID of the plugin of interest.
         *
         * @returns The plugin description.
         */
        getPluginDescription(id) {
            var _a, _b;
            return (_b = (_a = this._plugins.get(id)) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : '';
        }
        /**
         * Test whether a plugin is registered with the application.
         *
         * @param id - The ID of the plugin of interest.
         *
         * @returns `true` if the plugin is registered, `false` otherwise.
         */
        hasPlugin(id) {
            return this._plugins.has(id);
        }
        /**
         * Test whether a plugin is activated with the application.
         *
         * @param id - The ID of the plugin of interest.
         *
         * @returns `true` if the plugin is activated, `false` otherwise.
         */
        isPluginActivated(id) {
            var _a, _b;
            return (_b = (_a = this._plugins.get(id)) === null || _a === void 0 ? void 0 : _a.activated) !== null && _b !== void 0 ? _b : false;
        }
        /**
         * List the IDs of the plugins registered with the application.
         *
         * @returns A new array of the registered plugin IDs.
         */
        listPlugins() {
            return Array.from(this._plugins.keys());
        }
        /**
         * Register a plugin with the application.
         *
         * @param plugin - The plugin to register.
         *
         * #### Notes
         * An error will be thrown if a plugin with the same ID is already
         * registered, or if the plugin has a circular dependency.
         *
         * If the plugin provides a service which has already been provided
         * by another plugin, the new service will override the old service.
         */
        registerPlugin(plugin) {
            // Throw an error if the plugin ID is already registered.
            if (this._plugins.has(plugin.id)) {
                throw new TypeError(`Plugin '${plugin.id}' is already registered.`);
            }
            if (!this._validatePlugin(plugin)) {
                throw new Error(`Plugin '${plugin.id}' is not valid.`);
            }
            // Create the normalized plugin data.
            const data = Private.createPluginData(plugin);
            // Ensure the plugin does not cause a cyclic dependency.
            Private.ensureNoCycle(data, this._plugins, this._services);
            // Add the service token to the service map.
            if (data.provides) {
                this._services.set(data.provides, data.id);
            }
            // Add the plugin to the plugin map.
            this._plugins.set(data.id, data);
        }
        /**
         * Register multiple plugins with the application.
         *
         * @param plugins - The plugins to register.
         *
         * #### Notes
         * This calls `registerPlugin()` for each of the given plugins.
         */
        registerPlugins(plugins) {
            for (const plugin of plugins) {
                this.registerPlugin(plugin);
            }
        }
        /**
         * Deregister a plugin with the application.
         *
         * @param id - The ID of the plugin of interest.
         *
         * @param force - Whether to deregister the plugin even if it is active.
         */
        deregisterPlugin(id, force) {
            const plugin = this._plugins.get(id);
            if (!plugin) {
                return;
            }
            if (plugin.activated && !force) {
                throw new Error(`Plugin '${id}' is still active.`);
            }
            this._plugins.delete(id);
        }
        /**
         * Activate the plugin with the given ID.
         *
         * @param id - The ID of the plugin of interest.
         *
         * @returns A promise which resolves when the plugin is activated
         *   or rejects with an error if it cannot be activated.
         */
        async activatePlugin(id) {
            // Reject the promise if the plugin is not registered.
            const plugin = this._plugins.get(id);
            if (!plugin) {
                throw new ReferenceError(`Plugin '${id}' is not registered.`);
            }
            // Resolve immediately if the plugin is already activated.
            if (plugin.activated) {
                return;
            }
            // Return the pending resolver promise if it exists.
            if (plugin.promise) {
                return plugin.promise;
            }
            // Resolve the required services for the plugin.
            const required = plugin.requires.map(t => this.resolveRequiredService(t));
            // Resolve the optional services for the plugin.
            const optional = plugin.optional.map(t => this.resolveOptionalService(t));
            // Setup the resolver promise for the plugin.
            plugin.promise = Promise.all([...required, ...optional])
                .then(services => plugin.activate.apply(undefined, [this.application, ...services]))
                .then(service => {
                plugin.service = service;
                plugin.activated = true;
                plugin.promise = null;
            })
                .catch(error => {
                plugin.promise = null;
                throw error;
            });
            // Return the pending resolver promise.
            return plugin.promise;
        }
        /**
         * Activate all the deferred plugins.
         *
         * @returns A promise which will resolve when each plugin is activated
         * or rejects with an error if one cannot be activated.
         */
        async activatePlugins(kind, options = {}) {
            switch (kind) {
                case 'defer': {
                    const promises = this.deferredPlugins
                        .filter(pluginId => this._plugins.get(pluginId).autoStart)
                        .map(pluginId => {
                        return this.activatePlugin(pluginId);
                    });
                    await Promise.all(promises);
                    break;
                }
                case 'startUp': {
                    // Collect the ids of the startup plugins.
                    const startups = Private.collectStartupPlugins(this._plugins, options);
                    // Generate the activation promises.
                    const promises = startups.map(async (id) => {
                        try {
                            return await this.activatePlugin(id);
                        }
                        catch (error) {
                            console.error(`Plugin '${id}' failed to activate.`, error);
                        }
                    });
                    await Promise.all(promises);
                    break;
                }
            }
        }
        /**
         * Deactivate the plugin and its downstream dependents if and only if the
         * plugin and its dependents all support `deactivate`.
         *
         * @param id - The ID of the plugin of interest.
         *
         * @returns A list of IDs of downstream plugins deactivated with this one.
         */
        async deactivatePlugin(id) {
            // Reject the promise if the plugin is not registered.
            const plugin = this._plugins.get(id);
            if (!plugin) {
                throw new ReferenceError(`Plugin '${id}' is not registered.`);
            }
            // Bail early if the plugin is not activated.
            if (!plugin.activated) {
                return [];
            }
            // Check that this plugin can deactivate.
            if (!plugin.deactivate) {
                throw new TypeError(`Plugin '${id}'#deactivate() method missing`);
            }
            // Find the optimal deactivation order for plugins downstream of this one.
            const manifest = Private.findDependents(id, this._plugins, this._services);
            const downstream = manifest.map(id => this._plugins.get(id));
            // Check that all downstream plugins can deactivate.
            for (const plugin of downstream) {
                if (!plugin.deactivate) {
                    throw new TypeError(`Plugin ${plugin.id}#deactivate() method missing (depends on ${id})`);
                }
            }
            // Deactivate all downstream plugins.
            for (const plugin of downstream) {
                const services = [...plugin.requires, ...plugin.optional].map(service => {
                    const id = this._services.get(service);
                    return id ? this._plugins.get(id).service : null;
                });
                // Await deactivation so the next plugins only receive active services.
                await plugin.deactivate(this.application, ...services);
                plugin.service = null;
                plugin.activated = false;
            }
            // Remove plugin ID and return manifest of deactivated plugins.
            manifest.pop();
            return manifest;
        }
        /**
         * Resolve a required service of a given type.
         *
         * @param token - The token for the service type of interest.
         *
         * @returns A promise which resolves to an instance of the requested
         *   service, or rejects with an error if it cannot be resolved.
         *
         * #### Notes
         * Services are singletons. The same instance will be returned each
         * time a given service token is resolved.
         *
         * If the plugin which provides the service has not been activated,
         * resolving the service will automatically activate the plugin.
         *
         * User code will not typically call this method directly. Instead,
         * the required services for the user's plugins will be resolved
         * automatically when the plugin is activated.
         */
        async resolveRequiredService(token) {
            // Reject the promise if there is no provider for the type.
            const id = this._services.get(token);
            if (!id) {
                throw new TypeError(`No provider for: ${token.name}.`);
            }
            // Activate the plugin if necessary.
            const plugin = this._plugins.get(id);
            if (!plugin.activated) {
                await this.activatePlugin(id);
            }
            return plugin.service;
        }
        /**
         * Resolve an optional service of a given type.
         *
         * @param token - The token for the service type of interest.
         *
         * @returns A promise which resolves to an instance of the requested
         *   service, or `null` if it cannot be resolved.
         *
         * #### Notes
         * Services are singletons. The same instance will be returned each
         * time a given service token is resolved.
         *
         * If the plugin which provides the service has not been activated,
         * resolving the service will automatically activate the plugin.
         *
         * User code will not typically call this method directly. Instead,
         * the optional services for the user's plugins will be resolved
         * automatically when the plugin is activated.
         */
        async resolveOptionalService(token) {
            // Resolve with `null` if there is no provider for the type.
            const id = this._services.get(token);
            if (!id) {
                return null;
            }
            // Activate the plugin if necessary.
            const plugin = this._plugins.get(id);
            if (!plugin.activated) {
                try {
                    await this.activatePlugin(id);
                }
                catch (reason) {
                    console.error(reason);
                    return null;
                }
            }
            return plugin.service;
        }
    }
    /**
     * The namespace for the module implementation details.
     */
    var Private;
    (function (Private) {
        class PluginData {
            constructor(plugin) {
                var _a, _b, _c, _d;
                this._activated = false;
                this._promise = null;
                this._service = null;
                this.id = plugin.id;
                this.description = (_a = plugin.description) !== null && _a !== void 0 ? _a : '';
                this.activate = plugin.activate;
                this.deactivate = (_b = plugin.deactivate) !== null && _b !== void 0 ? _b : null;
                this.provides = (_c = plugin.provides) !== null && _c !== void 0 ? _c : null;
                this.autoStart = (_d = plugin.autoStart) !== null && _d !== void 0 ? _d : false;
                this.requires = plugin.requires ? plugin.requires.slice() : [];
                this.optional = plugin.optional ? plugin.optional.slice() : [];
            }
            /**
             * Whether the plugin has been activated.
             */
            get activated() {
                return this._activated;
            }
            set activated(a) {
                this._activated = a;
            }
            /**
             * The resolved service for the plugin, or `null`.
             */
            get service() {
                return this._service;
            }
            set service(s) {
                this._service = s;
            }
            /**
             * The pending resolver promise, or `null`.
             */
            get promise() {
                return this._promise;
            }
            set promise(p) {
                this._promise = p;
            }
        }
        /**
         * Create a normalized plugin data object for the given plugin.
         */
        function createPluginData(plugin) {
            return new PluginData(plugin);
        }
        Private.createPluginData = createPluginData;
        /**
         * Ensure no cycle is present in the plugin resolution graph.
         *
         * If a cycle is detected, an error will be thrown.
         */
        function ensureNoCycle(plugin, plugins, services) {
            const dependencies = [...plugin.requires, ...plugin.optional];
            const visit = (token) => {
                if (token === plugin.provides) {
                    return true;
                }
                const id = services.get(token);
                if (!id) {
                    return false;
                }
                const visited = plugins.get(id);
                const dependencies = [...visited.requires, ...visited.optional];
                if (dependencies.length === 0) {
                    return false;
                }
                trace.push(id);
                if (dependencies.some(visit)) {
                    return true;
                }
                trace.pop();
                return false;
            };
            // Bail early if there cannot be a cycle.
            if (!plugin.provides || dependencies.length === 0) {
                return;
            }
            // Setup a stack to trace service resolution.
            const trace = [plugin.id];
            // Throw an exception if a cycle is present.
            if (dependencies.some(visit)) {
                throw new ReferenceError(`Cycle detected: ${trace.join(' -> ')}.`);
            }
        }
        Private.ensureNoCycle = ensureNoCycle;
        /**
         * Find dependents in deactivation order.
         *
         * @param id - The ID of the plugin of interest.
         *
         * @param plugins - The map containing all plugins.
         *
         * @param services - The map containing all services.
         *
         * @returns A list of dependent plugin IDs in order of deactivation
         *
         * #### Notes
         * The final item of the returned list is always the plugin of interest.
         */
        function findDependents(id, plugins, services) {
            const edges = new Array();
            const add = (id) => {
                const plugin = plugins.get(id);
                // FIXME In the case of missing optional dependencies, we may consider
                // deactivating and reactivating the plugin without the missing service.
                const dependencies = [...plugin.requires, ...plugin.optional];
                edges.push(...dependencies.reduce((acc, dep) => {
                    const service = services.get(dep);
                    if (service) {
                        // An edge is oriented from dependent to provider.
                        acc.push([id, service]);
                    }
                    return acc;
                }, []));
            };
            for (const id of plugins.keys()) {
                add(id);
            }
            // Filter edges
            // - Get all packages that dependent on the package to be deactivated
            const newEdges = edges.filter(edge => edge[1] === id);
            let oldSize = 0;
            while (newEdges.length > oldSize) {
                const previousSize = newEdges.length;
                // Get all packages that dependent on packages that will be deactivated
                const packagesOfInterest = new Set(newEdges.map(edge => edge[0]));
                for (const poi of packagesOfInterest) {
                    edges
                        .filter(edge => edge[1] === poi)
                        .forEach(edge => {
                        // We check it is not already included to deal with circular dependencies
                        if (!newEdges.includes(edge)) {
                            newEdges.push(edge);
                        }
                    });
                }
                oldSize = previousSize;
            }
            const sorted = algorithm.topologicSort(newEdges);
            const index = sorted.findIndex(candidate => candidate === id);
            if (index === -1) {
                return [id];
            }
            return sorted.slice(0, index + 1);
        }
        Private.findDependents = findDependents;
        /**
         * Collect the IDs of the plugins to activate on startup.
         */
        function collectStartupPlugins(plugins, options) {
            // Create a set to hold the plugin IDs.
            const collection = new Set();
            // Collect the auto-start (non deferred) plugins.
            for (const id of plugins.keys()) {
                if (plugins.get(id).autoStart === true) {
                    collection.add(id);
                }
            }
            // Add the startup plugins.
            if (options.startPlugins) {
                for (const id of options.startPlugins) {
                    collection.add(id);
                }
            }
            // Remove the ignored plugins.
            if (options.ignorePlugins) {
                for (const id of options.ignorePlugins) {
                    collection.delete(id);
                }
            }
            // Return the collected startup plugins.
            return Array.from(collection);
        }
        Private.collectStartupPlugins = collectStartupPlugins;
    })(Private || (Private = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A class which wraps a promise into a delegate object.
     *
     * #### Notes
     * This class is useful when the logic to resolve or reject a promise
     * cannot be defined at the point where the promise is created.
     */
    class PromiseDelegate {
        /**
         * Construct a new promise delegate.
         */
        constructor() {
            this.promise = new Promise((resolve, reject) => {
                this._resolve = resolve;
                this._reject = reject;
            });
        }
        /**
         * Resolve the wrapped promise with the given value.
         *
         * @param value - The value to use for resolving the promise.
         */
        resolve(value) {
            let resolve = this._resolve;
            resolve(value);
        }
        /**
         * Reject the wrapped promise with the given value.
         *
         * @reason - The reason for rejecting the promise.
         */
        reject(reason) {
            let reject = this._reject;
            reject(reason);
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A runtime object which captures compile-time type information.
     *
     * #### Notes
     * A token captures the compile-time type of an interface or class in
     * an object which can be used at runtime in a type-safe fashion.
     */
    class Token {
        /**
         * Construct a new token.
         *
         * @param name - A human readable name for the token.
         * @param description - Token purpose description for documentation.
         */
        constructor(name, description) {
            this.name = name;
            this.description = description !== null && description !== void 0 ? description : '';
            this._tokenStructuralPropertyT = null;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    // Fallback
    function fallbackRandomValues(buffer) {
        let value = 0;
        for (let i = 0, n = buffer.length; i < n; ++i) {
            if (i % 4 === 0) {
                value = (Math.random() * 0xffffffff) >>> 0;
            }
            buffer[i] = value & 0xff;
            value >>>= 8;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for random number related functionality.
     */
    exports.Random = void 0;
    (function (Random) {
        /**
         * A function which generates random bytes.
         *
         * @param buffer - The `Uint8Array` to fill with random bytes.
         *
         * #### Notes
         * A cryptographically strong random number generator will be used if
         * available. Otherwise, `Math.random` will be used as a fallback for
         * randomness.
         *
         * The following RNGs are supported, listed in order of precedence:
         *   - `window.crypto.getRandomValues`
         *   - `window.msCrypto.getRandomValues`
         *   - `require('crypto').randomFillSync
         *   - `require('crypto').randomBytes
         *   - `Math.random`
         */
        Random.getRandomValues = (() => {
            // Look up the crypto module if available.
            const crypto = (typeof window !== 'undefined' && (window.crypto || window.msCrypto)) ||
                null;
            // Modern browsers and IE 11
            if (crypto && typeof crypto.getRandomValues === 'function') {
                return function getRandomValues(buffer) {
                    return crypto.getRandomValues(buffer);
                };
            }
            // Fallback
            return fallbackRandomValues;
        })();
    })(exports.Random || (exports.Random = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A function which creates a function that generates UUID v4 identifiers.
     *
     * @returns A new function that creates a UUID v4 string.
     *
     * #### Notes
     * This implementation complies with RFC 4122.
     *
     * This uses `Random.getRandomValues()` for random bytes, which in
     * turn will use the underlying `crypto` module of the platform if
     * it is available. The fallback for randomness is `Math.random`.
     */
    function uuid4Factory(getRandomValues) {
        // Create a 16 byte array to hold the random values.
        const bytes = new Uint8Array(16);
        // Create a look up table from bytes to hex strings.
        const lut = new Array(256);
        // Pad the single character hex digits with a leading zero.
        for (let i = 0; i < 16; ++i) {
            lut[i] = '0' + i.toString(16);
        }
        // Populate the rest of the hex digits.
        for (let i = 16; i < 256; ++i) {
            lut[i] = i.toString(16);
        }
        // Return a function which generates the UUID.
        return function uuid4() {
            // Get a new batch of random values.
            getRandomValues(bytes);
            // Set the UUID version number to 4.
            bytes[6] = 0x40 | (bytes[6] & 0x0f);
            // Set the clock sequence bit to the RFC spec.
            bytes[8] = 0x80 | (bytes[8] & 0x3f);
            // Assemble the UUID string.
            return (lut[bytes[0]] +
                lut[bytes[1]] +
                lut[bytes[2]] +
                lut[bytes[3]] +
                '-' +
                lut[bytes[4]] +
                lut[bytes[5]] +
                '-' +
                lut[bytes[6]] +
                lut[bytes[7]] +
                '-' +
                lut[bytes[8]] +
                lut[bytes[9]] +
                '-' +
                lut[bytes[10]] +
                lut[bytes[11]] +
                lut[bytes[12]] +
                lut[bytes[13]] +
                lut[bytes[14]] +
                lut[bytes[15]]);
        };
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for UUID related functionality.
     */
    exports.UUID = void 0;
    (function (UUID) {
        /**
         * A function which generates UUID v4 identifiers.
         *
         * @returns A new UUID v4 string.
         *
         * #### Notes
         * This implementation complies with RFC 4122.
         *
         * This uses `Random.getRandomValues()` for random bytes, which in
         * turn will use the underlying `crypto` module of the platform if
         * it is available. The fallback for randomness is `Math.random`.
         */
        UUID.uuid4 = uuid4Factory(exports.Random.getRandomValues);
    })(exports.UUID || (exports.UUID = {}));

    exports.MimeData = MimeData;
    exports.PluginRegistry = PluginRegistry;
    exports.PromiseDelegate = PromiseDelegate;
    exports.Token = Token;

}));
//# sourceMappingURL=index.js.map


/***/ }),

/***/ "../node_modules/@lumino/disposable/dist/index.es6.js":
/*!************************************************************!*\
  !*** ../node_modules/@lumino/disposable/dist/index.es6.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DisposableDelegate: () => (/* binding */ DisposableDelegate),
/* harmony export */   DisposableSet: () => (/* binding */ DisposableSet),
/* harmony export */   ObservableDisposableDelegate: () => (/* binding */ ObservableDisposableDelegate),
/* harmony export */   ObservableDisposableSet: () => (/* binding */ ObservableDisposableSet)
/* harmony export */ });
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module disposable
 */
/**
 * A disposable object which delegates to a callback function.
 */
class DisposableDelegate {
    /**
     * Construct a new disposable delegate.
     *
     * @param fn - The callback function to invoke on dispose.
     */
    constructor(fn) {
        this._fn = fn;
    }
    /**
     * Test whether the delegate has been disposed.
     */
    get isDisposed() {
        return !this._fn;
    }
    /**
     * Dispose of the delegate and invoke the callback function.
     */
    dispose() {
        if (!this._fn) {
            return;
        }
        let fn = this._fn;
        this._fn = null;
        fn();
    }
}
/**
 * An observable disposable object which delegates to a callback function.
 */
class ObservableDisposableDelegate extends DisposableDelegate {
    constructor() {
        super(...arguments);
        this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
    }
    /**
     * A signal emitted when the delegate is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * Dispose of the delegate and invoke the callback function.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        super.dispose();
        this._disposed.emit(undefined);
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);
    }
}
/**
 * An object which manages a collection of disposable items.
 */
class DisposableSet {
    constructor() {
        this._isDisposed = false;
        this._items = new Set();
    }
    /**
     * Test whether the set has been disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the set and the items it contains.
     *
     * #### Notes
     * Items are disposed in the order they are added to the set.
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._items.forEach(item => {
            item.dispose();
        });
        this._items.clear();
    }
    /**
     * Test whether the set contains a specific item.
     *
     * @param item - The item of interest.
     *
     * @returns `true` if the set contains the item, `false` otherwise.
     */
    contains(item) {
        return this._items.has(item);
    }
    /**
     * Add a disposable item to the set.
     *
     * @param item - The item to add to the set.
     *
     * #### Notes
     * If the item is already contained in the set, this is a no-op.
     */
    add(item) {
        this._items.add(item);
    }
    /**
     * Remove a disposable item from the set.
     *
     * @param item - The item to remove from the set.
     *
     * #### Notes
     * If the item is not contained in the set, this is a no-op.
     */
    remove(item) {
        this._items.delete(item);
    }
    /**
     * Remove all items from the set.
     */
    clear() {
        this._items.clear();
    }
}
/**
 * The namespace for the `DisposableSet` class statics.
 */
(function (DisposableSet) {
    /**
     * Create a disposable set from an iterable of items.
     *
     * @param items - The iterable object of interest.
     *
     * @returns A new disposable initialized with the given items.
     */
    function from(items) {
        let set = new DisposableSet();
        for (const item of items) {
            set.add(item);
        }
        return set;
    }
    DisposableSet.from = from;
})(DisposableSet || (DisposableSet = {}));
/**
 * An observable object which manages a collection of disposable items.
 */
class ObservableDisposableSet extends DisposableSet {
    constructor() {
        super(...arguments);
        this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
    }
    /**
     * A signal emitted when the set is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * Dispose of the set and the items it contains.
     *
     * #### Notes
     * Items are disposed in the order they are added to the set.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        super.dispose();
        this._disposed.emit(undefined);
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);
    }
}
/**
 * The namespace for the `ObservableDisposableSet` class statics.
 */
(function (ObservableDisposableSet) {
    /**
     * Create an observable disposable set from an iterable of items.
     *
     * @param items - The iterable object of interest.
     *
     * @returns A new disposable initialized with the given items.
     */
    function from(items) {
        let set = new ObservableDisposableSet();
        for (const item of items) {
            set.add(item);
        }
        return set;
    }
    ObservableDisposableSet.from = from;
})(ObservableDisposableSet || (ObservableDisposableSet = {}));


//# sourceMappingURL=index.es6.js.map


/***/ }),

/***/ "../node_modules/@lumino/polling/dist/index.es6.js":
/*!*********************************************************!*\
  !*** ../node_modules/@lumino/polling/dist/index.es6.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Debouncer: () => (/* binding */ Debouncer),
/* harmony export */   Poll: () => (/* binding */ Poll),
/* harmony export */   RateLimiter: () => (/* binding */ RateLimiter),
/* harmony export */   Throttler: () => (/* binding */ Throttler)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "../node_modules/@lumino/signaling/dist/index.es6.js");



// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * A class that wraps an asynchronous function to poll at a regular interval
 * with exponential increases to the interval length if the poll fails.
 *
 * @typeparam T - The resolved type of the factory's promises.
 * Defaults to `any`.
 *
 * @typeparam U - The rejected type of the factory's promises.
 * Defaults to `any`.
 *
 * @typeparam V - An optional type to extend the phases supported by a poll.
 * Defaults to `standby`, which already exists in the `Phase` type.
 */
class Poll {
    /**
     * Instantiate a new poll with exponential backoff in case of failure.
     *
     * @param options - The poll instantiation options.
     */
    constructor(options) {
        var _a;
        this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._lingered = 0;
        this._tick = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
        this._ticked = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._factory = options.factory;
        this._linger = (_a = options.linger) !== null && _a !== void 0 ? _a : Private.DEFAULT_LINGER;
        this._standby = options.standby || Private.DEFAULT_STANDBY;
        this._state = { ...Private.DEFAULT_STATE, timestamp: new Date().getTime() };
        // Normalize poll frequency `max` to be the greater of
        // default `max`, `options.frequency.max`, or `options.frequency.interval`.
        const frequency = options.frequency || {};
        const max = Math.max(frequency.interval || 0, frequency.max || 0, Private.DEFAULT_FREQUENCY.max);
        this.frequency = { ...Private.DEFAULT_FREQUENCY, ...frequency, ...{ max } };
        this.name = options.name || Private.DEFAULT_NAME;
        if ('auto' in options ? options.auto : true) {
            setTimeout(() => this.start());
        }
    }
    /**
     * A signal emitted when the poll is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * The polling frequency parameters.
     */
    get frequency() {
        return this._frequency;
    }
    set frequency(frequency) {
        if (this.isDisposed || _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.JSONExt.deepEqual(frequency, this.frequency || {})) {
            return;
        }
        let { backoff, interval, max } = frequency;
        interval = Math.round(interval);
        max = Math.round(max);
        if (typeof backoff === 'number' && backoff < 1) {
            throw new Error('Poll backoff growth factor must be at least 1');
        }
        if ((interval < 0 || interval > max) && interval !== Poll.NEVER) {
            throw new Error('Poll interval must be between 0 and max');
        }
        if (max > Poll.MAX_INTERVAL && max !== Poll.NEVER) {
            throw new Error(`Max interval must be less than ${Poll.MAX_INTERVAL}`);
        }
        this._frequency = { backoff, interval, max };
    }
    /**
     * Whether the poll is disposed.
     */
    get isDisposed() {
        return this.state.phase === 'disposed';
    }
    /**
     * Indicates when the poll switches to standby.
     */
    get standby() {
        return this._standby;
    }
    set standby(standby) {
        if (this.isDisposed || this.standby === standby) {
            return;
        }
        this._standby = standby;
    }
    /**
     * The poll state, which is the content of the current poll tick.
     */
    get state() {
        return this._state;
    }
    /**
     * A promise that resolves when the poll next ticks.
     */
    get tick() {
        return this._tick.promise;
    }
    /**
     * A signal emitted when the poll ticks and fires off a new request.
     */
    get ticked() {
        return this._ticked;
    }
    /**
     * Return an async iterator that yields every tick.
     */
    async *[Symbol.asyncIterator]() {
        while (!this.isDisposed) {
            yield this.state;
            await this.tick.catch(() => undefined);
        }
    }
    /**
     * Dispose the poll.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._state = {
            ...Private.DISPOSED_STATE,
            timestamp: new Date().getTime()
        };
        this._tick.promise.catch(_ => undefined);
        this._tick.reject(new Error(`Poll (${this.name}) is disposed.`));
        this._disposed.emit(undefined);
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);
    }
    /**
     * Refreshes the poll. Schedules `refreshed` tick if necessary.
     *
     * @returns A promise that resolves after tick is scheduled and never rejects.
     *
     * #### Notes
     * The returned promise resolves after the tick is scheduled, but before
     * the polling action is run. To wait until after the poll action executes,
     * await the `poll.tick` promise: `await poll.refresh(); await poll.tick;`
     */
    refresh() {
        return this.schedule({
            cancel: ({ phase }) => phase === 'refreshed',
            interval: Poll.IMMEDIATE,
            phase: 'refreshed'
        });
    }
    /**
     * Schedule the next poll tick.
     *
     * @param next - The next poll state data to schedule. Defaults to standby.
     *
     * @param next.cancel - Cancels state transition if function returns `true`.
     *
     * @returns A promise that resolves when the next poll state is active.
     *
     * #### Notes
     * This method is not meant to be invoked by user code typically. It is public
     * to allow poll instances to be composed into classes that schedule ticks.
     */
    async schedule(next = {}) {
        if (this.isDisposed) {
            return;
        }
        // Check if the phase transition should be canceled.
        if (next.cancel && next.cancel(this.state)) {
            return;
        }
        // Update poll state.
        const pending = this._tick;
        const scheduled = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
        const state = {
            interval: this.frequency.interval,
            payload: null,
            phase: 'standby',
            timestamp: new Date().getTime(),
            ...next
        };
        this._state = state;
        this._tick = scheduled;
        // Clear the schedule if possible.
        clearTimeout(this._timeout);
        // Emit ticked signal, resolve pending promise, and await its settlement.
        this._ticked.emit(this.state);
        pending.resolve(this);
        await pending.promise;
        if (state.interval === Poll.NEVER) {
            this._timeout = undefined;
            return;
        }
        // Schedule next execution and cache its timeout handle.
        const execute = () => {
            if (this.isDisposed || this.tick !== scheduled.promise) {
                return;
            }
            this._execute();
        };
        // Cache the handle in case it needs to be unscheduled.
        this._timeout = setTimeout(execute, state.interval);
    }
    /**
     * Starts the poll. Schedules `started` tick if necessary.
     *
     * @returns A promise that resolves after tick is scheduled and never rejects.
     */
    start() {
        return this.schedule({
            cancel: ({ phase }) => phase !== 'constructed' && phase !== 'standby' && phase !== 'stopped',
            interval: Poll.IMMEDIATE,
            phase: 'started'
        });
    }
    /**
     * Stops the poll. Schedules `stopped` tick if necessary.
     *
     * @returns A promise that resolves after tick is scheduled and never rejects.
     */
    stop() {
        return this.schedule({
            cancel: ({ phase }) => phase === 'stopped',
            interval: Poll.NEVER,
            phase: 'stopped'
        });
    }
    /**
     * Whether the poll is hidden.
     *
     * #### Notes
     * This property is only relevant in a browser context.
     */
    get hidden() {
        return Private.hidden;
    }
    /**
     * Execute a new poll factory promise or stand by if necessary.
     */
    _execute() {
        let standby = typeof this.standby === 'function' ? this.standby() : this.standby;
        // Check if execution should proceed, linger, or stand by.
        if (standby === 'never') {
            standby = false;
        }
        else if (standby === 'when-hidden') {
            if (this.hidden) {
                standby = ++this._lingered > this._linger;
            }
            else {
                this._lingered = 0;
                standby = false;
            }
        }
        // If in standby mode schedule next tick without calling the factory.
        if (standby) {
            void this.schedule();
            return;
        }
        const pending = this.tick;
        this._factory(this.state)
            .then((resolved) => {
            if (this.isDisposed || this.tick !== pending) {
                return;
            }
            void this.schedule({
                payload: resolved,
                phase: this.state.phase === 'rejected' ? 'reconnected' : 'resolved'
            });
        })
            .catch((rejected) => {
            if (this.isDisposed || this.tick !== pending) {
                return;
            }
            void this.schedule({
                interval: Private.sleep(this.frequency, this.state),
                payload: rejected,
                phase: 'rejected'
            });
        });
    }
}
/**
 * A namespace for `Poll` types, interfaces, and statics.
 */
(function (Poll) {
    /**
     * An interval value in ms that indicates the poll should tick immediately.
     */
    Poll.IMMEDIATE = 0;
    /**
     * Delays are 32-bit integers in many browsers so intervals need to be capped.
     *
     * #### Notes
     * https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/setTimeout#Maximum_delay_value
     */
    Poll.MAX_INTERVAL = 2147483647;
    /**
     * An interval value that indicates the poll should never tick.
     */
    Poll.NEVER = Infinity;
})(Poll || (Poll = {}));
/**
 * A namespace for private module data.
 */
var Private;
(function (Private) {
    /**
     * The default backoff growth rate if `backoff` is `true`.
     */
    Private.DEFAULT_BACKOFF = 3;
    /**
     * The default polling frequency.
     */
    Private.DEFAULT_FREQUENCY = {
        backoff: true,
        interval: 1000,
        max: 30 * 1000
    };
    /**
     * The default number of times to `linger` when a poll is hidden.
     */
    Private.DEFAULT_LINGER = 1;
    /**
     * The default poll name.
     */
    Private.DEFAULT_NAME = 'unknown';
    /**
     * The default poll standby behavior.
     */
    Private.DEFAULT_STANDBY = 'when-hidden';
    /**
     * The first poll tick state's default values superseded in constructor.
     */
    Private.DEFAULT_STATE = {
        interval: Poll.NEVER,
        payload: null,
        phase: 'constructed',
        timestamp: new Date(0).getTime()
    };
    /**
     * The disposed tick state values.
     */
    Private.DISPOSED_STATE = {
        interval: Poll.NEVER,
        payload: null,
        phase: 'disposed',
        timestamp: new Date(0).getTime()
    };
    /**
     * Returns the number of milliseconds to sleep before the next tick.
     *
     * @param frequency - The poll's base frequency.
     * @param last - The poll's last tick.
     */
    function sleep(frequency, last) {
        const { backoff, interval, max } = frequency;
        if (interval === Poll.NEVER) {
            return interval;
        }
        const growth = backoff === true ? Private.DEFAULT_BACKOFF : backoff === false ? 1 : backoff;
        const random = getRandomIntInclusive(interval, last.interval * growth);
        return Math.min(max, random);
    }
    Private.sleep = sleep;
    /**
     * Keep track of whether the document is hidden. This flag is only relevant in
     * a browser context.
     *
     * Listen to `visibilitychange` event to set the `hidden` flag.
     *
     * Listening to `pagehide` is also necessary because Safari support for
     * `visibilitychange` events is partial, cf.
     * https://developer.mozilla.org/docs/Web/API/Document/visibilitychange_event
     */
    Private.hidden = (() => {
        if (typeof document === 'undefined') {
            return false;
        }
        document.addEventListener('visibilitychange', () => {
            Private.hidden = document.visibilityState === 'hidden';
        });
        document.addEventListener('pagehide', () => {
            Private.hidden = document.visibilityState === 'hidden';
        });
        return document.visibilityState === 'hidden';
    })();
    /**
     * Get a random integer between min and max, inclusive of both.
     *
     * #### Notes
     * From
     * https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Math/random#Getting_a_random_integer_between_two_values_inclusive
     *
     * From the MDN page: It might be tempting to use Math.round() to accomplish
     * that, but doing so would cause your random numbers to follow a non-uniform
     * distribution, which may not be acceptable for your needs.
     */
    function getRandomIntInclusive(min, max) {
        min = Math.ceil(min);
        max = Math.floor(max);
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }
})(Private || (Private = {}));

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * A base class to implement rate limiters with different invocation strategies.
 *
 * @typeparam T - The resolved type of the underlying function.
 *
 * @typeparam U - The rejected type of the underlying function.
 *
 * @typeparam V - Arguments for the underlying function.
 */
class RateLimiter {
    /**
     * Instantiate a rate limiter.
     *
     * @param fn - The function to rate limit.
     *
     * @param limit - The rate limit; defaults to 500ms.
     */
    constructor(fn, limit = 500) {
        /**
         * Arguments for the underlying function.
         */
        this.args = undefined;
        /**
         * A promise that resolves on each successful invocation.
         */
        this.payload = null;
        this.limit = limit;
        this.poll = new Poll({
            auto: false,
            factory: async () => {
                const { args } = this;
                this.args = undefined;
                return fn(...args);
            },
            frequency: { backoff: false, interval: Poll.NEVER, max: Poll.NEVER },
            standby: 'never'
        });
        this.payload = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
        this.poll.ticked.connect((_, state) => {
            const { payload } = this;
            if (state.phase === 'resolved') {
                this.payload = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
                payload.resolve(state.payload);
                return;
            }
            if (state.phase === 'rejected' || state.phase === 'stopped') {
                this.payload = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
                payload.promise.catch(_ => undefined);
                payload.reject(state.payload);
                return;
            }
        }, this);
    }
    /**
     * Whether the rate limiter is disposed.
     */
    get isDisposed() {
        return this.payload === null;
    }
    /**
     * Disposes the rate limiter.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this.args = undefined;
        this.payload = null;
        this.poll.dispose();
    }
    /**
     * Stop the function if it is mid-flight.
     */
    async stop() {
        return this.poll.stop();
    }
}
/**
 * Wraps and debounces a function that can be called multiple times and only
 * executes the underlying function one `interval` after the last invocation.
 *
 * @typeparam T - The resolved type of the underlying function. Defaults to any.
 *
 * @typeparam U - The rejected type of the underlying function. Defaults to any.
 *
 * @typeparam V - Arguments for the underlying function. Defaults to any[].
 */
class Debouncer extends RateLimiter {
    /**
     * Invokes the function and only executes after rate limit has elapsed.
     * Each invocation resets the timer.
     */
    invoke(...args) {
        this.args = args;
        void this.poll.schedule({ interval: this.limit, phase: 'invoked' });
        return this.payload.promise;
    }
}
/**
 * Wraps and throttles a function that can be called multiple times and only
 * executes the underlying function once per `interval`.
 *
 * @typeparam T - The resolved type of the underlying function. Defaults to any.
 *
 * @typeparam U - The rejected type of the underlying function. Defaults to any.
 *
 * @typeparam V - Arguments for the underlying function. Defaults to any[].
 */
class Throttler extends RateLimiter {
    /**
     * Instantiate a throttler.
     *
     * @param fn - The function being throttled.
     *
     * @param options - Throttling configuration or throttling limit in ms.
     *
     * #### Notes
     * The `edge` defaults to `leading`; the `limit` defaults to `500`.
     */
    constructor(fn, options) {
        super(fn, typeof options === 'number' ? options : options && options.limit);
        this._trailing = false;
        if (typeof options !== 'number' && options && options.edge === 'trailing') {
            this._trailing = true;
        }
        this._interval = this._trailing ? this.limit : Poll.IMMEDIATE;
    }
    /**
     * Throttles function invocations if one is currently in flight.
     */
    invoke(...args) {
        const idle = this.poll.state.phase !== 'invoked';
        if (idle || this._trailing) {
            this.args = args;
        }
        if (idle) {
            void this.poll.schedule({ interval: this._interval, phase: 'invoked' });
        }
        return this.payload.promise;
    }
}


//# sourceMappingURL=index.es6.js.map


/***/ }),

/***/ "../node_modules/@lumino/properties/dist/index.es6.js":
/*!************************************************************!*\
  !*** ../node_modules/@lumino/properties/dist/index.es6.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AttachedProperty: () => (/* binding */ AttachedProperty)
/* harmony export */ });
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module properties
 */
/**
 * A class which attaches a value to an external object.
 *
 * #### Notes
 * Attached properties are used to extend the state of an object with
 * semantic data from an unrelated class. They also encapsulate value
 * creation, coercion, and notification.
 *
 * Because attached property values are stored in a hash table, which
 * in turn is stored in a WeakMap keyed on the owner object, there is
 * non-trivial storage overhead involved in their use. The pattern is
 * therefore best used for the storage of rare data.
 */
class AttachedProperty {
    /**
     * Construct a new attached property.
     *
     * @param options - The options for initializing the property.
     */
    constructor(options) {
        this._pid = Private.nextPID();
        this.name = options.name;
        this._create = options.create;
        this._coerce = options.coerce || null;
        this._compare = options.compare || null;
        this._changed = options.changed || null;
    }
    /**
     * Get the current value of the property for a given owner.
     *
     * @param owner - The property owner of interest.
     *
     * @returns The current value of the property.
     *
     * #### Notes
     * If the value has not yet been set, the default value will be
     * computed and assigned as the current value of the property.
     */
    get(owner) {
        let value;
        let map = Private.ensureMap(owner);
        if (this._pid in map) {
            value = map[this._pid];
        }
        else {
            value = map[this._pid] = this._createValue(owner);
        }
        return value;
    }
    /**
     * Set the current value of the property for a given owner.
     *
     * @param owner - The property owner of interest.
     *
     * @param value - The value for the property.
     *
     * #### Notes
     * If the value has not yet been set, the default value will be
     * computed and used as the previous value for the comparison.
     */
    set(owner, value) {
        let oldValue;
        let map = Private.ensureMap(owner);
        if (this._pid in map) {
            oldValue = map[this._pid];
        }
        else {
            oldValue = map[this._pid] = this._createValue(owner);
        }
        let newValue = this._coerceValue(owner, value);
        this._maybeNotify(owner, oldValue, (map[this._pid] = newValue));
    }
    /**
     * Explicitly coerce the current property value for a given owner.
     *
     * @param owner - The property owner of interest.
     *
     * #### Notes
     * If the value has not yet been set, the default value will be
     * computed and used as the previous value for the comparison.
     */
    coerce(owner) {
        let oldValue;
        let map = Private.ensureMap(owner);
        if (this._pid in map) {
            oldValue = map[this._pid];
        }
        else {
            oldValue = map[this._pid] = this._createValue(owner);
        }
        let newValue = this._coerceValue(owner, oldValue);
        this._maybeNotify(owner, oldValue, (map[this._pid] = newValue));
    }
    /**
     * Get or create the default value for the given owner.
     */
    _createValue(owner) {
        let create = this._create;
        return create(owner);
    }
    /**
     * Coerce the value for the given owner.
     */
    _coerceValue(owner, value) {
        let coerce = this._coerce;
        return coerce ? coerce(owner, value) : value;
    }
    /**
     * Compare the old value and new value for equality.
     */
    _compareValue(oldValue, newValue) {
        let compare = this._compare;
        return compare ? compare(oldValue, newValue) : oldValue === newValue;
    }
    /**
     * Run the change notification if the given values are different.
     */
    _maybeNotify(owner, oldValue, newValue) {
        let changed = this._changed;
        if (changed && !this._compareValue(oldValue, newValue)) {
            changed(owner, oldValue, newValue);
        }
    }
}
/**
 * The namespace for the `AttachedProperty` class statics.
 */
(function (AttachedProperty) {
    /**
     * Clear the stored property data for the given owner.
     *
     * @param owner - The property owner of interest.
     *
     * #### Notes
     * This will clear all property values for the owner, but it will
     * **not** run the change notification for any of the properties.
     */
    function clearData(owner) {
        Private.ownerData.delete(owner);
    }
    AttachedProperty.clearData = clearData;
})(AttachedProperty || (AttachedProperty = {}));
/**
 * The namespace for the module implementation details.
 */
var Private;
(function (Private) {
    /**
     * A weak mapping of property owner to property map.
     */
    Private.ownerData = new WeakMap();
    /**
     * A function which computes successive unique property ids.
     */
    Private.nextPID = (() => {
        let id = 0;
        return () => {
            let rand = Math.random();
            let stem = `${rand}`.slice(2);
            return `pid-${stem}-${id++}`;
        };
    })();
    /**
     * Lookup the data map for the property owner.
     *
     * This will create the map if one does not already exist.
     */
    function ensureMap(owner) {
        let map = Private.ownerData.get(owner);
        if (map) {
            return map;
        }
        map = Object.create(null);
        Private.ownerData.set(owner, map);
        return map;
    }
    Private.ensureMap = ensureMap;
})(Private || (Private = {}));


//# sourceMappingURL=index.es6.js.map


/***/ }),

/***/ "../node_modules/@lumino/signaling/dist/index.es6.js":
/*!***********************************************************!*\
  !*** ../node_modules/@lumino/signaling/dist/index.es6.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Signal: () => (/* binding */ Signal),
/* harmony export */   Stream: () => (/* binding */ Stream)
/* harmony export */ });
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ "../node_modules/@lumino/algorithm/dist/index.es6.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "../node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);



// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module signaling
 */
/**
 * A concrete implementation of `ISignal`.
 *
 * #### Example
 * ```typescript
 * import { ISignal, Signal } from '@lumino/signaling';
 *
 * class SomeClass {
 *
 *   constructor(name: string) {
 *     this.name = name;
 *   }
 *
 *   readonly name: string;
 *
 *   get valueChanged: ISignal<this, number> {
 *     return this._valueChanged;
 *   }
 *
 *   get value(): number {
 *     return this._value;
 *   }
 *
 *   set value(value: number) {
 *     if (value === this._value) {
 *       return;
 *     }
 *     this._value = value;
 *     this._valueChanged.emit(value);
 *   }
 *
 *   private _value = 0;
 *   private _valueChanged = new Signal<this, number>(this);
 * }
 *
 * function logger(sender: SomeClass, value: number): void {
 *   console.log(sender.name, value);
 * }
 *
 * let m1 = new SomeClass('foo');
 * let m2 = new SomeClass('bar');
 *
 * m1.valueChanged.connect(logger);
 * m2.valueChanged.connect(logger);
 *
 * m1.value = 42;  // logs: foo 42
 * m2.value = 17;  // logs: bar 17
 * ```
 */
class Signal {
    /**
     * Construct a new signal.
     *
     * @param sender - The sender which owns the signal.
     */
    constructor(sender) {
        this.sender = sender;
    }
    /**
     * Connect a slot to the signal.
     *
     * @param slot - The slot to invoke when the signal is emitted.
     *
     * @param thisArg - The `this` context for the slot. If provided,
     *   this must be a non-primitive object.
     *
     * @returns `true` if the connection succeeds, `false` otherwise.
     */
    connect(slot, thisArg) {
        return Private.connect(this, slot, thisArg);
    }
    /**
     * Disconnect a slot from the signal.
     *
     * @param slot - The slot to disconnect from the signal.
     *
     * @param thisArg - The `this` context for the slot. If provided,
     *   this must be a non-primitive object.
     *
     * @returns `true` if the connection is removed, `false` otherwise.
     */
    disconnect(slot, thisArg) {
        return Private.disconnect(this, slot, thisArg);
    }
    /**
     * Emit the signal and invoke the connected slots.
     *
     * @param args - The args to pass to the connected slots.
     *
     * #### Notes
     * Slots are invoked synchronously in connection order.
     *
     * Exceptions thrown by connected slots will be caught and logged.
     */
    emit(args) {
        Private.emit(this, args);
    }
}
/**
 * The namespace for the `Signal` class statics.
 */
(function (Signal) {
    /**
     * Remove all connections between a sender and receiver.
     *
     * @param sender - The sender object of interest.
     *
     * @param receiver - The receiver object of interest.
     *
     * #### Notes
     * If a `thisArg` is provided when connecting a signal, that object
     * is considered the receiver. Otherwise, the `slot` is considered
     * the receiver.
     */
    function disconnectBetween(sender, receiver) {
        Private.disconnectBetween(sender, receiver);
    }
    Signal.disconnectBetween = disconnectBetween;
    /**
     * Remove all connections where the given object is the sender.
     *
     * @param sender - The sender object of interest.
     */
    function disconnectSender(sender) {
        Private.disconnectSender(sender);
    }
    Signal.disconnectSender = disconnectSender;
    /**
     * Remove all connections where the given object is the receiver.
     *
     * @param receiver - The receiver object of interest.
     *
     * #### Notes
     * If a `thisArg` is provided when connecting a signal, that object
     * is considered the receiver. Otherwise, the `slot` is considered
     * the receiver.
     */
    function disconnectReceiver(receiver) {
        Private.disconnectReceiver(receiver);
    }
    Signal.disconnectReceiver = disconnectReceiver;
    /**
     * Remove all connections where an object is the sender or receiver.
     *
     * @param object - The object of interest.
     *
     * #### Notes
     * If a `thisArg` is provided when connecting a signal, that object
     * is considered the receiver. Otherwise, the `slot` is considered
     * the receiver.
     */
    function disconnectAll(object) {
        Private.disconnectAll(object);
    }
    Signal.disconnectAll = disconnectAll;
    /**
     * Clear all signal data associated with the given object.
     *
     * @param object - The object for which the data should be cleared.
     *
     * #### Notes
     * This removes all signal connections and any other signal data
     * associated with the object.
     */
    function clearData(object) {
        Private.disconnectAll(object);
    }
    Signal.clearData = clearData;
    /**
     * Get the signal exception handler.
     *
     * @returns The current exception handler.
     *
     * #### Notes
     * The default exception handler is `console.error`.
     */
    function getExceptionHandler() {
        return Private.exceptionHandler;
    }
    Signal.getExceptionHandler = getExceptionHandler;
    /**
     * Set the signal exception handler.
     *
     * @param handler - The function to use as the exception handler.
     *
     * @returns The old exception handler.
     *
     * #### Notes
     * The exception handler is invoked when a slot throws an exception.
     */
    function setExceptionHandler(handler) {
        let old = Private.exceptionHandler;
        Private.exceptionHandler = handler;
        return old;
    }
    Signal.setExceptionHandler = setExceptionHandler;
})(Signal || (Signal = {}));
/**
 * A concrete implementation of `IStream`.
 *
 * #### Example
 * ```typescript
 * import { IStream, Stream } from '@lumino/signaling';
 *
 * class SomeClass {
 *
 *   constructor(name: string) {
 *     this.name = name;
 *   }
 *
 *   readonly name: string;
 *
 *   get pings(): IStream<this, string> {
 *     return this._pings;
 *   }
 *
 *   ping(value: string) {
 *     this._pings.emit(value);
 *   }
 *
 *   private _pings = new Stream<this, string>(this);
 * }
 *
 * let m1 = new SomeClass('foo');
 *
 * m1.pings.connect((_, value: string) => {
 *   console.log('connect', value);
 * });
 *
 * void (async () => {
 *   for await (const ping of m1.pings) {
 *     console.log('iterator', ping);
 *   }
 * })();
 *
 * m1.ping('alpha');  // logs: connect alpha
 *                    // logs: iterator alpha
 * m1.ping('beta');   // logs: connect beta
 *                    // logs: iterator beta
 * ```
 */
class Stream extends Signal {
    constructor() {
        super(...arguments);
        this._pending = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();
    }
    /**
     * Return an async iterator that yields every emission.
     */
    async *[Symbol.asyncIterator]() {
        let pending = this._pending;
        while (true) {
            try {
                const { args, next } = await pending.promise;
                pending = next;
                yield args;
            }
            catch (_) {
                return; // Any promise rejection stops the iterator.
            }
        }
    }
    /**
     * Emit the signal, invoke the connected slots, and yield the emission.
     *
     * @param args - The args to pass to the connected slots.
     */
    emit(args) {
        const pending = this._pending;
        const next = (this._pending = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate());
        pending.resolve({ args, next });
        super.emit(args);
    }
    /**
     * Stop the stream's async iteration.
     */
    stop() {
        this._pending.promise.catch(() => undefined);
        this._pending.reject('stop');
        this._pending = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();
    }
}
/**
 * The namespace for the module implementation details.
 */
var Private;
(function (Private) {
    /**
     * The signal exception handler function.
     */
    Private.exceptionHandler = (err) => {
        console.error(err);
    };
    /**
     * Connect a slot to a signal.
     *
     * @param signal - The signal of interest.
     *
     * @param slot - The slot to invoke when the signal is emitted.
     *
     * @param thisArg - The `this` context for the slot. If provided,
     *   this must be a non-primitive object.
     *
     * @returns `true` if the connection succeeds, `false` otherwise.
     */
    function connect(signal, slot, thisArg) {
        // Coerce a `null` `thisArg` to `undefined`.
        thisArg = thisArg || undefined;
        // Ensure the sender's array of receivers is created.
        let receivers = receiversForSender.get(signal.sender);
        if (!receivers) {
            receivers = [];
            receiversForSender.set(signal.sender, receivers);
        }
        // Bail if a matching connection already exists.
        if (findConnection(receivers, signal, slot, thisArg)) {
            return false;
        }
        // Choose the best object for the receiver.
        let receiver = thisArg || slot;
        // Ensure the receiver's array of senders is created.
        let senders = sendersForReceiver.get(receiver);
        if (!senders) {
            senders = [];
            sendersForReceiver.set(receiver, senders);
        }
        // Create a new connection and add it to the end of each array.
        let connection = { signal, slot, thisArg };
        receivers.push(connection);
        senders.push(connection);
        // Indicate a successful connection.
        return true;
    }
    Private.connect = connect;
    /**
     * Disconnect a slot from a signal.
     *
     * @param signal - The signal of interest.
     *
     * @param slot - The slot to disconnect from the signal.
     *
     * @param thisArg - The `this` context for the slot. If provided,
     *   this must be a non-primitive object.
     *
     * @returns `true` if the connection is removed, `false` otherwise.
     */
    function disconnect(signal, slot, thisArg) {
        // Coerce a `null` `thisArg` to `undefined`.
        thisArg = thisArg || undefined;
        // Lookup the list of receivers, and bail if none exist.
        let receivers = receiversForSender.get(signal.sender);
        if (!receivers || receivers.length === 0) {
            return false;
        }
        // Bail if no matching connection exits.
        let connection = findConnection(receivers, signal, slot, thisArg);
        if (!connection) {
            return false;
        }
        // Choose the best object for the receiver.
        let receiver = thisArg || slot;
        // Lookup the array of senders, which is now known to exist.
        let senders = sendersForReceiver.get(receiver);
        // Clear the connection and schedule cleanup of the arrays.
        connection.signal = null;
        scheduleCleanup(receivers);
        scheduleCleanup(senders);
        // Indicate a successful disconnection.
        return true;
    }
    Private.disconnect = disconnect;
    /**
     * Remove all connections between a sender and receiver.
     *
     * @param sender - The sender object of interest.
     *
     * @param receiver - The receiver object of interest.
     */
    function disconnectBetween(sender, receiver) {
        // If there are no receivers, there is nothing to do.
        let receivers = receiversForSender.get(sender);
        if (!receivers || receivers.length === 0) {
            return;
        }
        // If there are no senders, there is nothing to do.
        let senders = sendersForReceiver.get(receiver);
        if (!senders || senders.length === 0) {
            return;
        }
        // Clear each connection between the sender and receiver.
        for (const connection of senders) {
            // Skip connections which have already been cleared.
            if (!connection.signal) {
                continue;
            }
            // Clear the connection if it matches the sender.
            if (connection.signal.sender === sender) {
                connection.signal = null;
            }
        }
        // Schedule a cleanup of the senders and receivers.
        scheduleCleanup(receivers);
        scheduleCleanup(senders);
    }
    Private.disconnectBetween = disconnectBetween;
    /**
     * Remove all connections where the given object is the sender.
     *
     * @param sender - The sender object of interest.
     */
    function disconnectSender(sender) {
        // If there are no receivers, there is nothing to do.
        let receivers = receiversForSender.get(sender);
        if (!receivers || receivers.length === 0) {
            return;
        }
        // Clear each receiver connection.
        for (const connection of receivers) {
            // Skip connections which have already been cleared.
            if (!connection.signal) {
                continue;
            }
            // Choose the best object for the receiver.
            let receiver = connection.thisArg || connection.slot;
            // Clear the connection.
            connection.signal = null;
            // Cleanup the array of senders, which is now known to exist.
            scheduleCleanup(sendersForReceiver.get(receiver));
        }
        // Schedule a cleanup of the receivers.
        scheduleCleanup(receivers);
    }
    Private.disconnectSender = disconnectSender;
    /**
     * Remove all connections where the given object is the receiver.
     *
     * @param receiver - The receiver object of interest.
     */
    function disconnectReceiver(receiver) {
        // If there are no senders, there is nothing to do.
        let senders = sendersForReceiver.get(receiver);
        if (!senders || senders.length === 0) {
            return;
        }
        // Clear each sender connection.
        for (const connection of senders) {
            // Skip connections which have already been cleared.
            if (!connection.signal) {
                continue;
            }
            // Lookup the sender for the connection.
            let sender = connection.signal.sender;
            // Clear the connection.
            connection.signal = null;
            // Cleanup the array of receivers, which is now known to exist.
            scheduleCleanup(receiversForSender.get(sender));
        }
        // Schedule a cleanup of the list of senders.
        scheduleCleanup(senders);
    }
    Private.disconnectReceiver = disconnectReceiver;
    /**
     * Remove all connections where an object is the sender or receiver.
     *
     * @param object - The object of interest.
     */
    function disconnectAll(object) {
        // Remove all connections where the given object is the sender.
        disconnectSender(object);
        // Remove all connections where the given object is the receiver.
        disconnectReceiver(object);
    }
    Private.disconnectAll = disconnectAll;
    /**
     * Emit a signal and invoke its connected slots.
     *
     * @param signal - The signal of interest.
     *
     * @param args - The args to pass to the connected slots.
     *
     * #### Notes
     * Slots are invoked synchronously in connection order.
     *
     * Exceptions thrown by connected slots will be caught and logged.
     */
    function emit(signal, args) {
        // If there are no receivers, there is nothing to do.
        let receivers = receiversForSender.get(signal.sender);
        if (!receivers || receivers.length === 0) {
            return;
        }
        // Invoke the slots for connections with a matching signal.
        // Any connections added during emission are not invoked.
        for (let i = 0, n = receivers.length; i < n; ++i) {
            let connection = receivers[i];
            if (connection.signal === signal) {
                invokeSlot(connection, args);
            }
        }
    }
    Private.emit = emit;
    /**
     * A weak mapping of sender to array of receiver connections.
     */
    const receiversForSender = new WeakMap();
    /**
     * A weak mapping of receiver to array of sender connections.
     */
    const sendersForReceiver = new WeakMap();
    /**
     * A set of connection arrays which are pending cleanup.
     */
    const dirtySet = new Set();
    /**
     * A function to schedule an event loop callback.
     */
    const schedule = (() => {
        let ok = typeof requestAnimationFrame === 'function';
        return ok ? requestAnimationFrame : setImmediate;
    })();
    /**
     * Find a connection which matches the given parameters.
     */
    function findConnection(connections, signal, slot, thisArg) {
        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.find)(connections, connection => connection.signal === signal &&
            connection.slot === slot &&
            connection.thisArg === thisArg);
    }
    /**
     * Invoke a slot with the given parameters.
     *
     * The connection is assumed to be valid.
     *
     * Exceptions in the slot will be caught and logged.
     */
    function invokeSlot(connection, args) {
        let { signal, slot, thisArg } = connection;
        try {
            slot.call(thisArg, signal.sender, args);
        }
        catch (err) {
            Private.exceptionHandler(err);
        }
    }
    /**
     * Schedule a cleanup of a connection array.
     *
     * This will add the array to the dirty set and schedule a deferred
     * cleanup of the array contents. On cleanup, any connection with a
     * `null` signal will be removed from the array.
     */
    function scheduleCleanup(array) {
        if (dirtySet.size === 0) {
            schedule(cleanupDirtySet);
        }
        dirtySet.add(array);
    }
    /**
     * Cleanup the connection lists in the dirty set.
     *
     * This function should only be invoked asynchronously, when the
     * stack frame is guaranteed to not be on the path of user code.
     */
    function cleanupDirtySet() {
        dirtySet.forEach(cleanupConnections);
        dirtySet.clear();
    }
    /**
     * Cleanup the dirty connections in a connections array.
     *
     * This will remove any connection with a `null` signal.
     *
     * This function should only be invoked asynchronously, when the
     * stack frame is guaranteed to not be on the path of user code.
     */
    function cleanupConnections(connections) {
        _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAllWhere(connections, isDeadConnection);
    }
    /**
     * Test whether a connection is dead.
     *
     * A dead connection has a `null` signal.
     */
    function isDeadConnection(connection) {
        return connection.signal === null;
    }
})(Private || (Private = {}));


//# sourceMappingURL=index.es6.js.map


/***/ }),

/***/ "../node_modules/arquero/src/arrow/arrow-column.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/arrow/arrow-column.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ arrowColumn)
/* harmony export */ });
/* harmony import */ var _arrow_dictionary__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrow-dictionary */ "../node_modules/arquero/src/arrow/arrow-dictionary.js");
/* harmony import */ var _arrow_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./arrow-types */ "../node_modules/arquero/src/arrow/arrow-types.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_repeat__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/repeat */ "../node_modules/arquero/src/util/repeat.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/to-string */ "../node_modules/arquero/src/util/to-string.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/unroll */ "../node_modules/arquero/src/util/unroll.js");







const isList = id => id === _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].List || id === _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].FixedSizeList;

/**
 * Create an Arquero column that proxies access to an Arrow column.
 * @param {object} arrow An Apache Arrow column.
 * @return {import('../table/column').ColumnType} An Arquero-compatible column.
 */
function arrowColumn(arrow, nested) {
  if (arrow.dictionary) return (0,_arrow_dictionary__WEBPACK_IMPORTED_MODULE_0__["default"])(arrow);
  const { typeId, chunks, length, numChildren } = arrow;
  const vector = chunks && chunks.length === 1 ? chunks[0] : arrow;
  const get = numChildren && nested ? getNested(vector)
    : numChildren ? memoize(getNested(vector))
    : typeId === _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Utf8 ? memoize(row => vector.get(row))
    : null;

  return get
    ? { vector, length, get, [Symbol.iterator]: () => iterator(length, get) }
    : vector;
}

function memoize(get) {
  const values = [];
  return row => {
    const v = values[row];
    return v !== undefined ? v : (values[row] = get(row));
  };
}

function* iterator(n, get) {
  for (let i = 0; i < n; ++i) {
    yield get(i);
  }
}

const arrayFrom = vector => vector.numChildren
  ? (0,_util_repeat__WEBPACK_IMPORTED_MODULE_3__["default"])(vector.length, getNested(vector))
  : vector.nullCount ? [...vector]
  : vector.toArray();

const getNested = vector => isList(vector.typeId) ? getList(vector)
  : vector.typeId === _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Struct ? getStruct(vector)
  : (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])(`Unsupported Arrow type: ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_4__["default"])(vector.VectorName)}`);

const getList = vector => vector.nullCount
  ? row => vector.isValid(row) ? arrayFrom(vector.get(row)) : null
  : row => arrayFrom(vector.get(row));

function getStruct(vector) {
  const props = [];
  const code = [];
  vector.type.children.forEach((field, i) => {
    props.push(arrowColumn(vector.getChildAt(i), true));
    code.push(`${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_4__["default"])(field.name)}:_${i}.get(row)`);
  });
  const get = (0,_util_unroll__WEBPACK_IMPORTED_MODULE_5__["default"])('row', '({' + code + '})', props);

  return vector.nullCount
    ? row => vector.isValid(row) ? get(row) : null
    : get;
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/arrow-dictionary.js":
/*!*************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/arrow-dictionary.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _op_functions_sequence__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../op/functions/sequence */ "../node_modules/arquero/src/op/functions/sequence.js");


/**
 * Create a new Arquero column that proxies access to an
 * Apache Arrow dictionary column.
 * @param {object} vector An Apache Arrow dictionary column.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(vector) {
  const { chunks, dictionary, length, nullCount } = vector;
  const size = dictionary.length;
  const keys = dictKeys(chunks || [vector], length, nullCount, size);
  const values = Array(size);

  const value = k => k == null || k < 0 || k >= size ? null
    : values[k] !== undefined ? values[k]
    : (values[k] = dictionary.get(k));

  return {
    vector,
    length,

    get: row => value(keys[row]),

    key: row => keys[row],

    keyFor(value) {
      if (value === null) return nullCount ? size : -1;
      for (let i = 0; i < size; ++i) {
        if (values[i] === undefined) values[i] = dictionary.get(i);
        if (values[i] === value) return i;
      }
      return -1;
    },

    groups(names) {
      const s = size + (nullCount ? 1 : 0);
      return { keys, get: [value], names, rows: (0,_op_functions_sequence__WEBPACK_IMPORTED_MODULE_0__["default"])(0, s), size: s };
    },

    [Symbol.iterator]() {
      return vector[Symbol.iterator]();
    }
  };
}

/**
 * Generate a dictionary key array
 * @param {object[]} chunks Arrow column chunks
 * @param {number} length The length of the Arrow column
 * @param {number} nulls The count of column null values
 * @param {number} size The backing dictionary size
 */
function dictKeys(chunks, length, nulls, size) {
  const v = chunks.length > 1 || nulls
    ? flatten(chunks, length, chunks[0].type.indices)
    : chunks[0].values;
  return nulls ? nullKeys(chunks, v, size) : v;
}

/**
 * Flatten Arrow column chunks into a single array.
 */
function flatten(chunks, length, type) {
  const array = new type.ArrayType(length);
  const n = chunks.length;
  for (let i = 0, idx = 0, len; i < n; ++i) {
    len = chunks[i].length;
    array.set(chunks[i].values.subarray(0, len), idx);
    idx += len;
  }
  return array;
}

/**
 * Encode null values as an additional dictionary key.
 * Returns a new key array with null values added.
 * TODO: safeguard against integer overflow?
 */
function nullKeys(chunks, keys, key) {
  // iterate over null bitmaps, encode null values as key
  const n = chunks.length;
  for (let i = 0, idx = 0, m, base, bits, byte; i < n; ++i) {
    bits = chunks[i].nullBitmap;
    m = chunks[i].length >> 3;
    if (bits && bits.length) {
      for (let j = 0; j <= m; ++j) {
        if ((byte = bits[j]) !== 255) {
          base = idx + (j << 3);
          if ((byte & (1 << 0)) === 0) keys[base + 0] = key;
          if ((byte & (1 << 1)) === 0) keys[base + 1] = key;
          if ((byte & (1 << 2)) === 0) keys[base + 2] = key;
          if ((byte & (1 << 3)) === 0) keys[base + 3] = key;
          if ((byte & (1 << 4)) === 0) keys[base + 4] = key;
          if ((byte & (1 << 5)) === 0) keys[base + 5] = key;
          if ((byte & (1 << 6)) === 0) keys[base + 6] = key;
          if ((byte & (1 << 7)) === 0) keys[base + 7] = key;
        }
      }
    }
    idx += chunks[i].length;
  }
  return keys;
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/arrow-table.js":
/*!********************************************************!*\
  !*** ../node_modules/arquero/src/arrow/arrow-table.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   from: () => (/* binding */ from),
/* harmony export */   table: () => (/* binding */ table)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../node_modules/apache-arrow/Arrow.dom.mjs");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");



function table() {
  // trap Table access to provide a helpful message
  // when Apache Arrow has not been imported
  try {
    return apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Table;
  } catch (err) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])(
      'Apache Arrow not imported, ' +
      'see https://github.com/uwdata/arquero#usage'
    );
  }
}

function from(arrow) {
  return arrow && arrow.chunks ? arrow : table().from(arrow);
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/arrow-types.js":
/*!********************************************************!*\
  !*** ../node_modules/arquero/src/arrow/arrow-types.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// Hardwire Arrow type ids to sidestep dependency
// https://github.com/apache/arrow/blob/master/js/src/enum.ts

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /** The default placeholder type */
  NONE: 0,
  /** A NULL type having no physical storage */
  Null: 1,
  /** Signed or unsigned 8, 16, 32, or 64-bit little-endian integer */
  Int: 2,
  /** 2, 4, or 8-byte floating point value */
  Float: 3,
  /** Variable-length bytes (no guarantee of UTF8-ness) */
  Binary: 4,
  /** UTF8 variable-length string as List<Char> */
  Utf8: 5,
  /** Boolean as 1 bit, LSB bit-packed ordering */
  Bool: 6,
  /** Precision-and-scale-based decimal type. Storage type depends on the parameters. */
  Decimal: 7,
  /** int32_t days or int64_t milliseconds since the UNIX epoch */
  Date: 8,
  /** Time as signed 32 or 64-bit integer, representing either seconds, milliseconds, microseconds, or nanoseconds since midnight since midnight */
  Time: 9,
  /** Exact timestamp encoded with int64 since UNIX epoch (Default unit millisecond) */
  Timestamp: 10,
  /** YEAR_MONTH or DAY_TIME interval in SQL style */
  Interval: 11,
  /** A list of some logical data type */
  List: 12,
  /** Struct of logical types */
  Struct: 13,
  /** Union of logical types */
  Union: 14,
  /** Fixed-size binary. Each value occupies the same number of bytes */
  FixedSizeBinary: 15,
  /** Fixed-size list. Each value occupies the same number of bytes */
  FixedSizeList: 16,
  /** Map of named logical types */
  Map: 17,

  /** Dictionary aka Category type */
  Dictionary: -1,
  Int8: -2,
  Int16: -3,
  Int32: -4,
  Int64: -5,
  Uint8: -6,
  Uint16: -7,
  Uint32: -8,
  Uint64: -9,
  Float16: -10,
  Float32: -11,
  Float64: -12,
  DateDay: -13,
  DateMillisecond: -14,
  TimestampSecond: -15,
  TimestampMillisecond: -16,
  TimestampMicrosecond: -17,
  TimestampNanosecond: -18,
  TimeSecond: -19,
  TimeMillisecond: -20,
  TimeMicrosecond: -21,
  TimeNanosecond: -22,
  DenseUnion: -23,
  SparseUnion: -24,
  IntervalDayTime: -25,
  IntervalYearMonth: -26
});

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/array-builder.js":
/*!******************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/array-builder.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length) {
  const data = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(type.ArrayType, length);
  return {
    set(value, index) { data[index] = value; },
    data: () => ({ type, length, buffers: [null, data] })
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/bool-builder.js":
/*!*****************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/bool-builder.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length) {
  const data = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(type.ArrayType, length / 8);
  return {
    set(value, index) {
      if (value) data[index >> 3] |= (1 << (index % 8));
    },
    data: () => ({ type, length, buffers: [null, data] })
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/date-day-builder.js":
/*!*********************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/date-day-builder.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length) {
  const data = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(type.ArrayType, length);
  return {
    set(value, index) { data[index] = (value / 86400000) | 0; },
    data: () => ({ type, length, buffers: [null, data] })
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/date-millis-builder.js":
/*!************************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/date-millis-builder.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length) {
  const data = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(type.ArrayType, length << 1);
  return {
    set(value, index) {
      const i = index << 1;
      data[  i] = (value % 4294967296) | 0;
      data[i+1] = (value / 4294967296) | 0;
    },
    data: () => ({ type, length, buffers: [null, data] })
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/default-builder.js":
/*!********************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/default-builder.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../node_modules/apache-arrow/Arrow.dom.mjs");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type) {
  const b = apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Builder.new({
    type,
    nullValues: [null, undefined],
    highWaterMark: Infinity
  });
  return {
    set(value, index) { b.set(index, value); },
    data: () => b.finish().flush()
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/dictionary-builder.js":
/*!***********************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/dictionary-builder.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utf8_builder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utf8-builder */ "../node_modules/arquero/src/arrow/builder/utf8-builder.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/arrow/builder/util.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length) {
  const values = [];
  const data = (0,_util__WEBPACK_IMPORTED_MODULE_1__.array)(type.indices.ArrayType, length);
  const keys = Object.create(null);

  let next = -1;
  let strlen = 0;

  return {
    set(value, index) {
      const v = String(value);
      let k = keys[v];
      if (k === undefined) {
        strlen += v.length;
        keys[v] = k = ++next;
        values.push(v);
      }
      data[index] = k;
    },
    data: () => ({
      type,
      length,
      buffers: [null, data],
      dict: dictionary(type.dictionary, values, strlen)
    })
  };
}

function dictionary(type, values, strlen) {
  const b = (0,_utf8_builder__WEBPACK_IMPORTED_MODULE_0__["default"])(type, values.length, strlen);
  values.forEach(b.set);
  return (0,_util__WEBPACK_IMPORTED_MODULE_1__.arrowVector)(b.data());
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/index.js":
/*!**********************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrow_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../arrow-types */ "../node_modules/arquero/src/arrow/arrow-types.js");
/* harmony import */ var _array_builder__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./array-builder */ "../node_modules/arquero/src/arrow/builder/array-builder.js");
/* harmony import */ var _bool_builder__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./bool-builder */ "../node_modules/arquero/src/arrow/builder/bool-builder.js");
/* harmony import */ var _date_day_builder__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./date-day-builder */ "../node_modules/arquero/src/arrow/builder/date-day-builder.js");
/* harmony import */ var _date_millis_builder__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./date-millis-builder */ "../node_modules/arquero/src/arrow/builder/date-millis-builder.js");
/* harmony import */ var _default_builder__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./default-builder */ "../node_modules/arquero/src/arrow/builder/default-builder.js");
/* harmony import */ var _dictionary_builder__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./dictionary-builder */ "../node_modules/arquero/src/arrow/builder/dictionary-builder.js");
/* harmony import */ var _valid_builder__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./valid-builder */ "../node_modules/arquero/src/arrow/builder/valid-builder.js");









/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, nrows, nullable = true) {
  let method;

  switch (type.typeId) {
    case _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Int:
      method = type.bitWidth < 64 ? _array_builder__WEBPACK_IMPORTED_MODULE_1__["default"] : null;
      break;
    case _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Float:
      method = type.precision > 0 ? _array_builder__WEBPACK_IMPORTED_MODULE_1__["default"] : null;
      break;
    case _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Dictionary:
      // check sub-types against builder assumptions
      // if check fails, fallback to default builder
      method = (
        type.dictionary.typeId === _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Utf8 &&
        type.indices.typeId === _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Int &&
        type.indices.bitWidth < 64
      ) ? _dictionary_builder__WEBPACK_IMPORTED_MODULE_6__["default"] : null;
      break;
    case _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Bool:
      method = _bool_builder__WEBPACK_IMPORTED_MODULE_2__["default"];
      break;
    case _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Date:
      method = type.unit ? _date_millis_builder__WEBPACK_IMPORTED_MODULE_4__["default"] : _date_day_builder__WEBPACK_IMPORTED_MODULE_3__["default"];
      break;
  }

  return method == null ? (0,_default_builder__WEBPACK_IMPORTED_MODULE_5__["default"])(type)
    : nullable ? (0,_valid_builder__WEBPACK_IMPORTED_MODULE_7__["default"])(method(type, nrows), nrows)
    : method(type, nrows);
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/resolve-type.js":
/*!*****************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/resolve-type.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../node_modules/apache-arrow/Arrow.dom.mjs");
/* harmony import */ var _arrow_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../arrow-types */ "../node_modules/arquero/src/arrow/arrow-types.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/to-string */ "../node_modules/arquero/src/util/to-string.js");





/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type) {
  if (type instanceof apache_arrow__WEBPACK_IMPORTED_MODULE_0__.DataType || type == null) {
    return type;
  }

  switch (type) {
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Binary:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Binary();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Bool:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Bool();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].DateDay:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.DateDay();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].DateMillisecond:
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Date:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.DateMillisecond();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Dictionary:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Dictionary(new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Utf8(), new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int32());
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float16:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Float16();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float32:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Float32();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float64:
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Float64();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int8:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int8();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int16:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int16();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int32:
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int32();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int64:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int64();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].IntervalDayTime:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.IntervalDayTime();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Interval:
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].IntervalYearMonth:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.IntervalYearMonth();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Null:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Null();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].TimeMicrosecond:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.TimeMicrosecond();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].TimeMillisecond:
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Time:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.TimeMillisecond();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].TimeNanosecond:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.TimeNanosecond();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].TimeSecond:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.TimeSecond();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint8:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint8();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint16:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint16();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint32:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint32();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint64:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint64();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Utf8:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Utf8();
    default:
      (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])(
        `Unsupported type code: ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_3__["default"])(type)}. ` +
        'Use a data type constructor instead?'
      );
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/utf8-builder.js":
/*!*****************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/utf8-builder.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length, strlen) {
  const offset = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(Int32Array, length + 1);
  const buf = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(Uint8Array, 3 * strlen);

  let idx = 0;

  return {
    set(value, index) {
      idx += (0,_util__WEBPACK_IMPORTED_MODULE_0__.writeUtf8)(buf, idx, value);
      offset[index + 1] = idx;
    },
    data: () => {
      // slice utf buffer if over-allocated
      const dlen = (0,_util__WEBPACK_IMPORTED_MODULE_0__.ceil64Bytes)(idx);
      const data = buf.length > dlen ? buf.subarray(0, dlen) : buf;
      return { type, length, buffers: [offset, data] };
    }
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/util.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/util.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   array: () => (/* binding */ array),
/* harmony export */   arrowData: () => (/* binding */ arrowData),
/* harmony export */   arrowVector: () => (/* binding */ arrowVector),
/* harmony export */   ceil64Bytes: () => (/* binding */ ceil64Bytes),
/* harmony export */   encode: () => (/* binding */ encode),
/* harmony export */   encodeInto: () => (/* binding */ encodeInto),
/* harmony export */   encoder: () => (/* binding */ encoder),
/* harmony export */   writeUtf8: () => (/* binding */ writeUtf8)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../node_modules/apache-arrow/Arrow.dom.mjs");


function ceil64Bytes(length, bpe = 1) {
  return ((((length * bpe) + 63) & ~63) || 64) / bpe;
}

function array(Type, length, bpe = Type.BYTES_PER_ELEMENT) {
  return new Type(ceil64Bytes(length, bpe));
}

function arrowData(d) {
  return d instanceof apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Data
    ? d
    : apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Data.new(d.type, 0, d.length, d.nulls, d.buffers, null, d.dict);
}

function arrowVector(data) {
  return apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Vector.new(arrowData(data));
}

const encoder = new TextEncoder();

function encode(data, idx, str) {
  const bytes = encoder.encode(str);
  data.set(bytes, idx);
  return bytes.length;
}

function encodeInto(data, idx, str) {
  return encoder.encodeInto(str, data.subarray(idx)).written;
}

const writeUtf8 = encoder.encodeInto ? encodeInto : encode;

/***/ }),

/***/ "../node_modules/arquero/src/arrow/builder/valid-builder.js":
/*!******************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/builder/valid-builder.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(builder, length) {
  const valid = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(Uint8Array, length / 8);
  let nulls = 0;

  return {
    set(value, index) {
      if (value == null) {
        ++nulls;
      } else {
        builder.set(value, index);
        valid[index >> 3] |= (1 << (index % 8));
      }
    },
    data: () => {
      const d = builder.data();
      if (nulls) {
        d.nulls = nulls;
        d.buffers[2] = valid;
      }
      return d;
    }
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/encode/data-from-objects.js":
/*!*********************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/encode/data-from-objects.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _data_from__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./data-from */ "../node_modules/arquero/src/arrow/encode/data-from.js");
/* harmony import */ var _profiler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./profiler */ "../node_modules/arquero/src/arrow/encode/profiler.js");
/* harmony import */ var _builder_resolve_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../builder/resolve-type */ "../node_modules/arquero/src/arrow/builder/resolve-type.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(data, name, nrows, scan, type, nullable = true) {
  type = (0,_builder_resolve_type__WEBPACK_IMPORTED_MODULE_2__["default"])(type);

  // perform type inference if needed
  if (!type) {
    const p = (0,_profiler__WEBPACK_IMPORTED_MODULE_1__.profile)(scan, name);
    nullable = p.nulls > 0;
    type = p.type();
  }

  return (0,_data_from__WEBPACK_IMPORTED_MODULE_0__.dataFromScan)(nrows, scan, name, type, nullable);
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/encode/data-from-table.js":
/*!*******************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/encode/data-from-table.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../node_modules/apache-arrow/Arrow.dom.mjs");
/* harmony import */ var _data_from__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./data-from */ "../node_modules/arquero/src/arrow/encode/data-from.js");
/* harmony import */ var _profiler__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./profiler */ "../node_modules/arquero/src/arrow/encode/profiler.js");
/* harmony import */ var _builder_resolve_type__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../builder/resolve-type */ "../node_modules/arquero/src/arrow/builder/resolve-type.js");
/* harmony import */ var _util_is_typed_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/is-typed-array */ "../node_modules/arquero/src/util/is-typed-array.js");






/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, name, nrows, scan, type, nullable = true) {
  type = (0,_builder_resolve_type__WEBPACK_IMPORTED_MODULE_3__["default"])(type);
  const column = table.column(name);
  const reified = !(table.isFiltered() || table.isOrdered());

  // use existing arrow data if types match
  const vec = arrowVector(column);
  if (vec && reified && typeCompatible(vec.type, type)) {
    return vec;
  }

  // if backing data is a typed array, leverage that
  const data = column.data;
  if ((0,_util_is_typed_array__WEBPACK_IMPORTED_MODULE_4__["default"])(data)) {
    const dtype = typeFromArray(data);
    if (reified && dtype && typeCompatible(dtype, type)) {
      return (0,_data_from__WEBPACK_IMPORTED_MODULE_1__.dataFromArray)(data, dtype);
    } else {
      type = type || dtype;
      nullable = false;
    }
  }

  // perform type inference if needed
  if (!type) {
    const p = (0,_profiler__WEBPACK_IMPORTED_MODULE_2__.profile)(scan, column);
    nullable = p.nulls > 0;
    type = p.type();
  }

  return (0,_data_from__WEBPACK_IMPORTED_MODULE_1__.dataFromScan)(nrows, scan, column, type, nullable);
}

function arrowVector(value) {
  return value instanceof apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Vector ? value
    : value.vector instanceof apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Vector ? value.vector
    : null;
}

function typeFromArray(data) {
  const types = {
    Float32Array:    apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Float32,
    Float64Array:    apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Float64,
    Int8Array:       apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int8,
    Int16Array:      apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int16,
    Int32Array:      apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int32,
    Uint8Array:      apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint8,
    Uint16Array:     apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint16,
    Uint32Array:     apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint32,
    BigInt64Array:   apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int64,
    BigUint64Array:  apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint64
  };
  const Type = types[data.constructor.name];
  return Type ? new Type() : null;
}

function typeCompatible(a, b) {
  return !a || !b ? true : a.compareTo(b);
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/encode/data-from.js":
/*!*************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/encode/data-from.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dataFromArray: () => (/* binding */ dataFromArray),
/* harmony export */   dataFromScan: () => (/* binding */ dataFromScan)
/* harmony export */ });
/* harmony import */ var _builder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../builder */ "../node_modules/arquero/src/arrow/builder/index.js");
/* harmony import */ var _builder_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../builder/util */ "../node_modules/arquero/src/arrow/builder/util.js");



function dataFromArray(array, type) {
  const length = array.length;
  const size = (0,_builder_util__WEBPACK_IMPORTED_MODULE_1__.ceil64Bytes)(length, array.BYTES_PER_ELEMENT);

  let data = array;
  if (length !== size) {
    data = new array.constructor(size);
    data.set(array);
  }

  return (0,_builder_util__WEBPACK_IMPORTED_MODULE_1__.arrowData)({ type, length, buffers: [null, data] });
}

function dataFromScan(nrows, scan, column, type, nullable = true) {
  const b = (0,_builder__WEBPACK_IMPORTED_MODULE_0__["default"])(type, nrows, nullable);
  scan(column, b.set);
  return (0,_builder_util__WEBPACK_IMPORTED_MODULE_1__.arrowData)(b.data());
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/encode/index.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/arrow/encode/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../node_modules/apache-arrow/Arrow.dom.mjs");
/* harmony import */ var _data_from_objects__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./data-from-objects */ "../node_modules/arquero/src/arrow/encode/data-from-objects.js");
/* harmony import */ var _data_from_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./data-from-table */ "../node_modules/arquero/src/arrow/encode/data-from-table.js");
/* harmony import */ var _scan__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./scan */ "../node_modules/arquero/src/arrow/encode/scan.js");
/* harmony import */ var _arrow_table__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../arrow-table */ "../node_modules/arquero/src/arrow/arrow-table.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/is-array */ "../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/is-function */ "../node_modules/arquero/src/util/is-function.js");
 // eslint-disable-line no-unused-vars









/**
 * Options for Arrow encoding.
 * @typedef {object} ArrowFormatOptions
 * @property {number} [limit=Infinity] The maximum number of rows to include.
 * @property {number} [offset=0] The row offset indicating how many initial
 *  rows to skip.
 * @property {string[]|(data: object) => string[]} [columns] Ordered list of
 *  column names to include. If function-valued, the function should accept
 *  a dataset as input and return an array of column name strings.
 * @property {object} [types] The Arrow data types to use. If specified,
 *  the input should be an object with column names for keys and Arrow data
 *  types for values. If a column type is not explicitly provided, type
 *  inference will be performed to guess an appropriate type.
 */

/**
 * Create an Apache Arrow table for an input dataset.
 * @param {Array|object} data An input dataset to convert to Arrow format.
 *  If array-valued, the data should consist of an array of objects where
 *  each entry represents a row and named properties represent columns.
 *  Otherwise, the input data should be an Arquero table.
 * @param {ArrowFormatOptions} [options] Encoding options, including
 *  column data types.
 * @return {Table} An Apache Arrow Table instance.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(data, options = {}) {
  const { types = {} } = options;
  const { dataFrom, names, nrows, scan } = init(data, options);
  return (0,_arrow_table__WEBPACK_IMPORTED_MODULE_4__.table)().new(
    names.map(name => {
      const col = dataFrom(data, name, nrows, scan, types[name]);
      return col.length === nrows
        ? col
        : (0,_util_error__WEBPACK_IMPORTED_MODULE_5__["default"])('Column length mismatch');
    }),
    names
  );
}

function init(data, options) {
  const { columns, limit = Infinity, offset = 0 } = options;
  const names = (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(columns) ? columns(data)
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(columns) ? columns
    : null;
  if ((0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(data)) {
    return {
      dataFrom: _data_from_objects__WEBPACK_IMPORTED_MODULE_1__["default"],
      names: names || Object.keys(data[0]),
      nrows: Math.min(limit, data.length - offset),
      scan: (0,_scan__WEBPACK_IMPORTED_MODULE_3__.scanArray)(data, limit, offset)
    };
  } else if (isTable(data)) {
    return {
      dataFrom: _data_from_table__WEBPACK_IMPORTED_MODULE_2__["default"],
      names: names || data.columnNames(),
      nrows: Math.min(limit, data.numRows() - offset),
      scan: (0,_scan__WEBPACK_IMPORTED_MODULE_3__.scanTable)(data, limit, offset)
    };
  } else {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_5__["default"])('Unsupported input data type');
  }
}

function isTable(data) {
  return data && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(data.reify);
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/encode/profiler.js":
/*!************************************************************!*\
  !*** ../node_modules/arquero/src/arrow/encode/profiler.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   profile: () => (/* binding */ profile),
/* harmony export */   profiler: () => (/* binding */ profiler)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../node_modules/apache-arrow/Arrow.dom.mjs");
/* harmony import */ var _arrow_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../arrow-types */ "../node_modules/arquero/src/arrow/arrow-types.js");
/* harmony import */ var _builder_resolve_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../builder/resolve-type */ "../node_modules/arquero/src/arrow/builder/resolve-type.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_array_type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/is-array-type */ "../node_modules/arquero/src/util/is-array-type.js");
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/is-date */ "../node_modules/arquero/src/util/is-date.js");
/* harmony import */ var _util_is_exact_utc_date__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/is-exact-utc-date */ "../node_modules/arquero/src/util/is-exact-utc-date.js");








function profile(scan, column) {
  const p = profiler();
  scan(column, p.add);
  return p;
}

function profiler() {
  const p = {
    count: 0,
    nulls: 0,
    bools: 0,
    nums: 0,
    ints: 0,
    bigints: 0,
    min: Infinity,
    max: -Infinity,
    digits: 0,
    dates: 0,
    utcdays: 0,
    strings: 0,
    strlen: 0,
    arrays: 0,
    minlen: Infinity,
    maxlen: 0,
    structs: 0,

    add(value) {
      ++p.count;
      if (value == null) {
        ++p.nulls;
        return;
      }

      const type = typeof value;
      if (type === 'string') {
        ++p.strings;
      } else if (type === 'number') {
        ++p.nums;
        if (value < p.min) p.min = value;
        if (value > p.max) p.max = value;
        if (Number.isInteger(value)) ++p.ints;
      } else if (type === 'boolean') {
        ++p.bools;
      } else if (type === 'object') {
        if ((0,_util_is_date__WEBPACK_IMPORTED_MODULE_5__["default"])(value)) {
          ++p.dates;
          if ((0,_util_is_exact_utc_date__WEBPACK_IMPORTED_MODULE_6__["default"])(value)) {
            ++p.utcdays;
          }
        } else if ((0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_4__["default"])(value)) {
          ++p.arrays;
          if (value.length < p.minlen) p.minlen = value.length;
          if (value.length > p.maxlen) p.maxlen = value.length;
          const ap = p.array_prof || (p.array_prof = profiler());
          value.forEach(ap.add);
        } else {
          ++p.structs;
          const sp = p.struct_prof || (p.struct_prof = {});
          for (const key in value) {
            const fp = sp[key] || (sp[key] = profiler());
            fp.add(value[key]);
          }
        }
      } else if (type === 'bigint') {
        ++p.bigints;
        if (value < p.min) p.min = value;
        if (value > p.max) p.max = value;
      }
    },
    type() {
      return (0,_builder_resolve_type__WEBPACK_IMPORTED_MODULE_2__["default"])(infer(p));
    }
  };

  return p;
}

function infer(p) {
  const valid = p.count - p.nulls;

  if (valid === 0) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Null;
  }
  else if (p.ints === valid) {
    const v = Math.max(Math.abs(p.min) - 1, p.max);
    return p.min < 0
      ? v >= 2 ** 31 ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float64
        : v < (1 << 7) ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int8 : v < (1 << 15) ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int16 : _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int32
      : v >= 2 ** 32 ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float64
        : v < (1 << 8) ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint8 : v < (1 << 16) ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint16 : _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint32;
  }
  else if (p.nums === valid) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float64;
  }
  else if (p.bigints === valid) {
    const v = -p.min > p.max ? -p.min - 1n : p.max;
    return p.min < 0
      ? v < 2 ** 63 ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int64
        : (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])(`BigInt exceeds 64 bits: ${v}`)
      : p.max < 2 ** 64 ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint64
        : (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])(`BigInt exceeds 64 bits: ${p.max}`);
  }
  else if (p.bools === valid) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Bool;
  }
  else if (p.utcdays === valid) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].DateDay;
  }
  else if (p.dates === valid) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].DateMillisecond;
  }
  else if (p.arrays === valid) {
    const type = apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Field.new('value', p.array_prof.type(), true);
    return p.minlen === p.maxlen
      ? new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.FixedSizeList(p.minlen, type)
      : new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.List(type);
  }
  else if (p.structs === valid) {
    const sp = p.struct_prof;
    return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Struct(
      Object.keys(sp).map(name => apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Field.new(name, sp[name].type(), true))
    );
  }
  else if (p.strings > 0) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Dictionary;
  }
  else {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])('Type inference failure');
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/arrow/encode/scan.js":
/*!********************************************************!*\
  !*** ../node_modules/arquero/src/arrow/encode/scan.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   scanArray: () => (/* binding */ scanArray),
/* harmony export */   scanTable: () => (/* binding */ scanTable)
/* harmony export */ });
/* harmony import */ var _util_is_array_type__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/is-array-type */ "../node_modules/arquero/src/util/is-array-type.js");


function scanArray(data, limit, offset) {
  const n = Math.min(data.length, offset + limit);
  return (name, visit) => {
    for (let i = offset; i < n; ++i) {
      visit(data[i][name], i);
    }
  };
}

function scanTable(table, limit, offset) {
  const scanAll = offset === 0 && table.numRows() <= limit
               && !table.isFiltered() && !table.isOrdered();

  return (column, visit) => {
    let i = -1;
    scanAll && (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_0__["default"])(column.data)
      ? column.data.forEach(visit)
      : table.scan(
          row => visit(column.get(row), ++i),
          true, limit, offset
        );
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/concat.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/concat.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/null */ "../node_modules/arquero/src/util/null.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, others) {
  const trows = table.numRows();
  const nrows = trows + others.reduce((n, t) => n + t.numRows(), 0);
  if (trows === nrows) return table;

  const tables = [table, ...others];
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_0__["default"])();

  table.columnNames().forEach(name => {
    const arr = Array(nrows);
    let row = 0;
    tables.forEach(table => {
      const col = table.column(name) || { get: () => _util_null__WEBPACK_IMPORTED_MODULE_1__["default"] };
      table.scan(trow => arr[row++] = col.get(trow));
    });
    cols.add(name, arr);
  });

  return table.create(cols.new());
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/derive.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/derive.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _window_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./window/window */ "../node_modules/arquero/src/engine/window/window.js");
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../op */ "../node_modules/arquero/src/op/index.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_repeat__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/repeat */ "../node_modules/arquero/src/util/repeat.js");






function isWindowed(op) {
  return (0,_op__WEBPACK_IMPORTED_MODULE_2__.hasWindow)(op.name) ||
    op.frame && (
      Number.isFinite(op.frame[0]) ||
      Number.isFinite(op.frame[1])
    );
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, { names, exprs, ops }, options = {}) {
  // instantiate output data
  const total = table.totalRows();
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_3__["default"])(options.drop ? null : table);
  const data = names.map(name => cols.add(name, Array(total)));

  // analyze operations, compute non-windowed aggregates
  const [ aggOps, winOps ] = segmentOps(ops);

  const size = table.isGrouped() ? table.groups().size : 1;
  const result = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_1__.aggregate)(
    table, aggOps,
    (0,_util_repeat__WEBPACK_IMPORTED_MODULE_4__["default"])(ops.length, () => Array(size))
  );

  // perform table scans to generate output values
  winOps.length
    ? (0,_window_window__WEBPACK_IMPORTED_MODULE_0__.window)(table, data, exprs, result, winOps)
    : output(table, data, exprs, result);

  return table.create(cols);
}

function segmentOps(ops) {
  const aggOps = [];
  const winOps = [];
  const n = ops.length;

  for (let i = 0; i < n; ++i) {
    const op = ops[i];
    op.id = i;
    (isWindowed(op) ? winOps : aggOps).push(op);
  }

  return [aggOps, winOps];
}

function output(table, cols, exprs, result) {
  const bits = table.mask();
  const data = table.data();
  const { keys } = table.groups() || {};
  const op = keys
    ? (id, row) => result[id][keys[row]]
    : id => result[id][0];

  const m = cols.length;
  for (let j = 0; j < m; ++j) {
    const get = exprs[j];
    const col = cols[j];

    // inline the following for performance:
    // table.scan((i, data) => col[i] = get(i, data, op));
    if (bits) {
      for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
        col[i] = get(i, data, op);
      }
    } else {
      const n = table.totalRows();
      for (let i = 0; i < n; ++i) {
        col[i] = get(i, data, op);
      }
    }
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/filter.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/filter.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_bit_set__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/bit-set */ "../node_modules/arquero/src/table/bit-set.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, predicate) {
  const n = table.totalRows();
  const bits = table.mask();
  const data = table.data();
  const filter = new _table_bit_set__WEBPACK_IMPORTED_MODULE_0__["default"](n);

  // inline the following for performance:
  // table.scan((row, data) => { if (predicate(row, data)) filter.set(row); });
  if (bits) {
    for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
      if (predicate(i, data)) filter.set(i);
    }
  } else {
    for (let i = 0; i < n; ++i) {
      if (predicate(i, data)) filter.set(i);
    }
  }

  return table.create({ filter });
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/fold.js":
/*!**************************************************!*\
  !*** ../node_modules/arquero/src/engine/fold.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _unroll__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./unroll */ "../node_modules/arquero/src/engine/unroll.js");
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, { names = [], exprs = [], ops = [] }, options = {}) {
  if (names.length === 0) return table;

  const [k = 'key', v = 'value'] = options.as || [];
  const vals = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_1__.aggregateGet)(table, ops, exprs);

  return (0,_unroll__WEBPACK_IMPORTED_MODULE_0__["default"])(
    table,
    {
      names: [k, v],
      exprs: [() => names, (row, data) => vals.map(fn => fn(row, data))]
    },
    { ...options, drop: names }
  );
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/groupby.js":
/*!*****************************************************!*\
  !*** ../node_modules/arquero/src/engine/groupby.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _util_key_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/key-function */ "../node_modules/arquero/src/util/key-function.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, exprs) {
  return table.create({
    groups: createGroups(table, exprs)
  });
}

function createGroups(table, { names = [], exprs = [], ops = [] }) {
  const n = names.length;
  if (n === 0) return null;

  // check for optimized path when grouping by a single field
  // use pre-calculated groups if available
  if (n === 1 && !table.isFiltered() && exprs[0].field) {
    const col = table.column(exprs[0].field);
    if (col.groups) return col.groups(names);
  }

  let get = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregateGet)(table, ops, exprs);
  const getKey = (0,_util_key_function__WEBPACK_IMPORTED_MODULE_1__["default"])(get);
  const nrows = table.totalRows();
  const keys = new Uint32Array(nrows);
  const index = {};
  const rows = [];

  // inline table scan for performance
  const data = table.data();
  const bits = table.mask();
  if (bits) {
    for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
      const key = getKey(i, data) + '';
      const val = index[key];
      keys[i] = val != null ? val : (index[key] = rows.push(i) - 1);
    }
  } else {
    for (let i = 0; i < nrows; ++i) {
      const key = getKey(i, data) + '';
      const val = index[key];
      keys[i] = val != null ? val : (index[key] = rows.push(i) - 1);
    }
  }

  if (!ops.length) {
    // capture data in closure, so no interaction with select
    get = get.map(f => row => f(row, data));
  }

  return { keys, get, names, rows, size: rows.length };
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/impute.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/impute.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_is_valid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-valid */ "../node_modules/arquero/src/util/is-valid.js");
/* harmony import */ var _util_key_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/key-function */ "../node_modules/arquero/src/util/key-function.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/unroll */ "../node_modules/arquero/src/util/unroll.js");






/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, values, keys, arrays) {
  const write = keys && keys.length;
  return impute(
    write ? expand(table, keys, arrays) : table,
    values,
    write
  );
}

function impute(table, { names, exprs, ops }, write) {
  const gets = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregateGet)(table, ops, exprs);
  const cols = write ? null : (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])(table);
  const rows = table.totalRows();

  names.forEach((name, i) => {
    const col = table.column(name);
    const out = write ? col.data : cols.add(name, Array(rows));
    const get = gets[i];

    table.scan(idx => {
      const v = col.get(idx);
      out[idx] = !(0,_util_is_valid__WEBPACK_IMPORTED_MODULE_2__["default"])(v) ? get(idx) : v;
    });
  });

  return write ? table : table.create(cols);
}

function expand(table, keys, values) {
  const groups = table.groups();
  const data = table.data();

  // expansion keys and accessors
  const keyNames = (groups ? groups.names : []).concat(keys);
  const keyGet = (groups ? groups.get : [])
    .concat(keys.map(key => table.getter(key)));

  // build hash of existing rows
  const hash = new Set();
  const keyTable = (0,_util_key_function__WEBPACK_IMPORTED_MODULE_3__["default"])(keyGet);
  table.scan((idx, data) => hash.add(keyTable(idx, data)));

  // initialize output table data
  const names = table.columnNames();
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const out = names.map(name => cols.add(name, []));
  names.forEach((name, i) => {
    const old = data[name];
    const col = out[i];
    table.scan(row => col.push(old.get(row)));
  });

  // enumerate expanded value sets and augment output table
  const keyEnum = (0,_util_key_function__WEBPACK_IMPORTED_MODULE_3__["default"])(keyGet.map((k, i) => a => a[i]));
  const set = (0,_util_unroll__WEBPACK_IMPORTED_MODULE_4__["default"])(
    'v',
    '{' + out.map((_, i) => `_${i}.push(v[$${i}]);`).join('') + '}',
    out, names.map(name => keyNames.indexOf(name))
  );

  if (groups) {
    let row = groups.keys.length;
    const prod = values.reduce((p, a) => p * a.length, groups.size);
    const keys = new Uint32Array(prod + (row - hash.size));
    keys.set(groups.keys);
    enumerate(groups, values, (vec, idx) => {
      if (!hash.has(keyEnum(vec))) {
        set(vec);
        keys[row++] = idx[0];
      }
    });
    cols.groupby({ ...groups, keys });
  } else {
    enumerate(groups, values, vec => {
      if (!hash.has(keyEnum(vec))) set(vec);
    });
  }

  return table.create(cols.new());
}

function enumerate(groups, values, callback) {
  const offset = groups ? groups.get.length : 0;
  const pad = groups ? 1 : 0;
  const len = pad + values.length;
  const lens = new Int32Array(len);
  const idxs = new Int32Array(len);
  const set = [];

  if (groups) {
    const { get, rows, size } = groups;
    lens[0] = size;
    set.push((vec, idx) => {
      const row = rows[idx];
      for (let i = 0; i < offset; ++i) {
        vec[i] = get[i](row);
      }
    });
  }

  values.forEach((a, i) => {
    const j = i + offset;
    lens[i + pad] = a.length;
    set.push((vec, idx) => vec[j] = a[idx]);
  });

  const vec = Array(offset + values.length);

  // initialize value vector
  for (let i = 0; i < len; ++i) {
    set[i](vec, 0);
  }
  callback(vec, idxs);

  // enumerate all combinations of values
  for (let i = len - 1; i >= 0;) {
    const idx = ++idxs[i];
    if (idx < lens[i]) {
      set[i](vec, idx);
      callback(vec, idxs);
      i = len - 1;
    } else {
      idxs[i] = 0;
      set[i](vec, 0);
      --i;
    }
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/join-filter.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/engine/join-filter.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _join_lookup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./join/lookup */ "../node_modules/arquero/src/engine/join/lookup.js");
/* harmony import */ var _table_bit_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/bit-set */ "../node_modules/arquero/src/table/bit-set.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-array */ "../node_modules/arquero/src/util/is-array.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(tableL, tableR, predicate, options = {}) {
  // calculate semi-join filter mask
  const filter = new _table_bit_set__WEBPACK_IMPORTED_MODULE_1__["default"](tableL.totalRows());
  const join = (0,_util_is_array__WEBPACK_IMPORTED_MODULE_2__["default"])(predicate) ? hashSemiJoin : loopSemiJoin;
  join(filter, tableL, tableR, predicate);

  // if anti-join, negate the filter
  if (options.anti) {
    filter.not().and(tableL.mask());
  }

  return tableL.create({ filter });
}

function hashSemiJoin(filter, tableL, tableR, [keyL, keyR]) {
  // build lookup table
  const lut = (0,_join_lookup__WEBPACK_IMPORTED_MODULE_0__.rowLookup)(tableR, keyR);

  // scan table, update filter with matches
  tableL.scan((rowL, data) => {
    const rowR = lut.get(keyL(rowL, data));
    if (rowR >= 0) filter.set(rowL);
  });
}

function loopSemiJoin(filter, tableL, tableR, predicate) {
  const nL = tableL.numRows();
  const nR = tableR.numRows();
  const dataL = tableL.data();
  const dataR = tableR.data();

  if (tableL.isFiltered() || tableR.isFiltered()) {
    // use indices as at least one table is filtered
    const idxL = tableL.indices(false);
    const idxR = tableR.indices(false);
    for (let i = 0; i < nL; ++i) {
      const rowL = idxL[i];
      for (let j = 0; j < nR; ++j) {
        if (predicate(rowL, dataL, idxR[j], dataR)) {
          filter.set(rowL);
          break;
        }
      }
    }
  } else {
    // no filters, enumerate row indices directly
    for (let i = 0; i < nL; ++i) {
      for (let j = 0; j < nR; ++j) {
        if (predicate(i, dataL, j, dataR)) {
          filter.set(i);
          break;
        }
      }
    }
  }
}

// export default function(tableL, tableR, predicate, options = {}) {
//   const filter = new BitSet(tableL.totalRows());
//   const nL = tableL.numRows();
//   const nR = tableR.numRows();
//   const dataL = tableL.data();
//   const dataR = tableR.data();

//   if (tableL.isFiltered() || tableR.isFiltered()) {
//     // use indices as at least one table is filtered
//     const idxL = tableL.indices(false);
//     const idxR = tableR.indices(false);
//     for (let i = 0; i < nL; ++i) {
//       const rowL = idxL[i];
//       for (let j = 0; j < nR; ++j) {
//         if (predicate(rowL, dataL, idxR[j], dataR)) {
//           filter.set(rowL);
//           break;
//         }
//       }
//     }
//   } else {
//     // no filters, enumerate row indices directly
//     for (let i = 0; i < nL; ++i) {
//       for (let j = 0; j < nR; ++j) {
//         if (predicate(i, dataL, j, dataR)) {
//           filter.set(i);
//           break;
//         }
//       }
//     }
//   }

//   // if anti-join, negate the filter
//   if (options.anti) {
//     filter.not().and(tableL.mask());
//   }

//   return tableL.create({ filter });
// }

/***/ }),

/***/ "../node_modules/arquero/src/engine/join.js":
/*!**************************************************!*\
  !*** ../node_modules/arquero/src/engine/join.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _join_lookup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./join/lookup */ "../node_modules/arquero/src/engine/join/lookup.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_concat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/concat */ "../node_modules/arquero/src/util/concat.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-array */ "../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/unroll */ "../node_modules/arquero/src/util/unroll.js");






function emitter(columns, getters) {
  const args = ['i', 'a', 'j', 'b'];
  return (0,_util_unroll__WEBPACK_IMPORTED_MODULE_4__["default"])(
    args,
    '{' + (0,_util_concat__WEBPACK_IMPORTED_MODULE_2__["default"])(columns, (_, i) => `_${i}.push($${i}(${args}));`) + '}',
    columns, getters
  );
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(tableL, tableR, predicate, { names, exprs }, options = {}) {
  // initialize data for left table
  const dataL = tableL.data();
  const idxL = tableL.indices(false);
  const nL = idxL.length;
  const hitL = new Int32Array(nL);

  // initialize data for right table
  const dataR = tableR.data();
  const idxR = tableR.indices(false);
  const nR = idxR.length;
  const hitR = new Int32Array(nR);

  // initialize output data
  const ncols = names.length;
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const columns = Array(ncols);
  const getters = Array(ncols);
  for (let i = 0; i < names.length; ++i) {
    columns[i] = cols.add(names[i], []);
    getters[i] = exprs[i];
  }
  const emit = emitter(columns, getters);

  // perform join
  const join = (0,_util_is_array__WEBPACK_IMPORTED_MODULE_3__["default"])(predicate) ? hashJoin : loopJoin;
  join(emit, predicate, dataL, dataR, idxL, idxR, hitL, hitR, nL, nR);

  if (options.left) {
    for (let i = 0; i < nL; ++i) {
      if (!hitL[i]) {
        emit(idxL[i], dataL, -1, dataR);
      }
    }
  }

  if (options.right) {
    for (let j = 0; j < nR; ++j) {
      if (!hitR[j]) {
        emit(-1, dataL, idxR[j], dataR);
      }
    }
  }

  return tableL.create(cols.new());
}

function loopJoin(emit, predicate, dataL, dataR, idxL, idxR, hitL, hitR, nL, nR) {
  // perform nested-loops join
  for (let i = 0; i < nL; ++i) {
    const rowL = idxL[i];
    for (let j = 0; j < nR; ++j) {
      const rowR = idxR[j];
      if (predicate(rowL, dataL, rowR, dataR)) {
        emit(rowL, dataL, rowR, dataR);
        hitL[i] = 1;
        hitR[j] = 1;
      }
    }
  }
}

function hashJoin(emit, [keyL, keyR], dataL, dataR, idxL, idxR, hitL, hitR, nL, nR) {
  // determine which table to hash
  let dataScan, keyScan, hitScan, idxScan;
  let dataHash, keyHash, hitHash, idxHash;
  let emitScan = emit;
  if (nL >= nR) {
    dataScan = dataL; keyScan = keyL; hitScan = hitL; idxScan = idxL;
    dataHash = dataR; keyHash = keyR; hitHash = hitR; idxHash = idxR;
  } else {
    dataScan = dataR; keyScan = keyR; hitScan = hitR; idxScan = idxR;
    dataHash = dataL; keyHash = keyL; hitHash = hitL; idxHash = idxL;
    emitScan = (i, a, j, b) => emit(j, b, i, a);
  }

  // build lookup table
  const lut = (0,_join_lookup__WEBPACK_IMPORTED_MODULE_0__.indexLookup)(idxHash, dataHash, keyHash);

  // scan other table
  const m = idxScan.length;
  for (let j = 0; j < m; ++j) {
    const rowScan = idxScan[j];
    const list = lut.get(keyScan(rowScan, dataScan));
    if (list) {
      const n = list.length;
      for (let k = 0; k < n; ++k) {
        const i = list[k];
        emitScan(rowScan, dataScan, idxHash[i], dataHash);
        hitHash[i] = 1;
      }
      hitScan[j] = 1;
    }
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/join/lookup.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/engine/join/lookup.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   indexLookup: () => (/* binding */ indexLookup),
/* harmony export */   rowLookup: () => (/* binding */ rowLookup)
/* harmony export */ });
function rowLookup(table, hash) {
  const lut = new Map();
  table.scan((row, data) => {
    const key = hash(row, data);
    if (key != null && key === key) {
      lut.set(key, row);
    }
  });
  return lut;
}

function indexLookup(idx, data, hash) {
  const lut = new Map();
  const n = idx.length;
  for (let i = 0; i < n; ++i) {
    const row = idx[i];
    const key = hash(row, data);
    if (key != null && key === key) {
      lut.has(key)
        ? lut.get(key).push(i)
        : lut.set(key, [i]);
    }
  }
  return lut;
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/lookup.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/lookup.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _join_lookup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./join/lookup */ "../node_modules/arquero/src/engine/join/lookup.js");
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/null */ "../node_modules/arquero/src/util/null.js");
/* harmony import */ var _util_concat__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/concat */ "../node_modules/arquero/src/util/concat.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/unroll */ "../node_modules/arquero/src/util/unroll.js");







/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(tableL, tableR, [keyL, keyR], { names, exprs, ops }) {
  // instantiate output data
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_2__["default"])(tableL);
  const total = tableL.totalRows();
  names.forEach(name => cols.add(name, Array(total).fill(_util_null__WEBPACK_IMPORTED_MODULE_3__["default"])));

  // build lookup table
  const lut = (0,_join_lookup__WEBPACK_IMPORTED_MODULE_0__.rowLookup)(tableR, keyR);

  // generate setter function for lookup match
  const set = (0,_util_unroll__WEBPACK_IMPORTED_MODULE_5__["default"])(
    ['lr', 'rr', 'data'],
    '{' + (0,_util_concat__WEBPACK_IMPORTED_MODULE_4__["default"])(names, (_, i) => `_[${i}][lr] = $[${i}](rr, data);`) + '}',
    names.map(name => cols.data[name]),
    (0,_reduce_util__WEBPACK_IMPORTED_MODULE_1__.aggregateGet)(tableR, ops, exprs)
  );

  // find matching rows, set values on match
  const dataR = tableR.data();
  tableL.scan((lrow, data) => {
    const rrow = lut.get(keyL(lrow, data));
    if (rrow >= 0) set(lrow, rrow, dataR);
  });

  return tableL.create(cols);
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/orderby.js":
/*!*****************************************************!*\
  !*** ../node_modules/arquero/src/engine/orderby.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, comparator) {
  return table.create({ order: comparator });
}


/***/ }),

/***/ "../node_modules/arquero/src/engine/pivot.js":
/*!***************************************************!*\
  !*** ../node_modules/arquero/src/engine/pivot.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");



const opt = (value, defaultValue) => value != null ? value : defaultValue;

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, on, values, options = {}) {
  const { keys, keyColumn } = pivotKeys(table, on, options);
  const vsep = opt(options.valueSeparator, '_');
  const namefn = values.names.length > 1
    ? (i, name) => name + vsep + keys[i]
    : i => keys[i];

  // perform separate aggregate operations for each key
  // if keys do not match, emit NaN so aggregate skips it
  // use custom toString method for proper field resolution
  const results = keys.map(
    k => (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregate)(table, values.ops.map(op => {
      const fields = op.fields.map(f => {
        const fn = (r, d) => k === keyColumn[r] ? f(r, d) : NaN;
        fn.toString = () => k + ':' + f + '';
        return fn;
      });
      return { ...op, fields };
    }))
  );

  return table.create(output(values, namefn, table.groups(), results));
}

function pivotKeys(table, on, options) {
  const limit = options.limit > 0 ? +options.limit : Infinity;
  const sort = opt(options.sort, true);
  const ksep = opt(options.keySeparator, '_');

  // construct key accessor function
  const get = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregateGet)(table, on.ops, on.exprs);
  const key = get.length === 1
    ? get[0]
    : (row, data) => get.map(fn => fn(row, data)).join(ksep);

  // generate vector of per-row key values
  const kcol = Array(table.totalRows());
  table.scan((row, data) => kcol[row] = key(row, data));

  // collect unique key values
  const uniq = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregate)(
    table.ungroup(),
    [ {
      id: 0,
      name: 'array_agg_distinct',
      fields: [(row => kcol[row])], params: []
    } ]
  )[0][0];

  // get ordered set of unique key values
  const keys = sort ? uniq.sort() : uniq;

  // return key values
  return {
    keys: Number.isFinite(limit) ? keys.slice(0, limit) : keys,
    keyColumn: kcol
  };
}

function output({ names, exprs }, namefn, groups, results) {
  const size = groups ? groups.size : 1;
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const m = results.length;
  const n = names.length;

  let result;
  const op = (id, row) => result[id][row];

  // write groupby fields to output
  if (groups) (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.groupOutput)(cols, groups);

  // write pivot values to output
  for (let i = 0; i < n; ++i) {
    const get = exprs[i];
    if (get.field != null) {
      // if expression is op only, use aggregates directly
      for (let j = 0; j < m; ++j) {
        cols.add(namefn(j, names[i]), results[j][get.field]);
      }
    } else if (size > 1) {
      // if multiple groups, evaluate expression for each
      for (let j = 0; j < m; ++j) {
        result = results[j];
        const col = cols.add(namefn(j, names[i]), Array(size));
        for (let k = 0; k < size; ++k) {
          col[k] = get(k, null, op);
        }
      }
    } else {
      // if only one group, no need to loop
      for (let j = 0; j < m; ++j) {
        result = results[j];
        cols.add(namefn(j, names[i]), [ get(0, null, op) ]);
      }
    }
  }

  return cols.new();
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/reduce.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/reduce.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, reducer) {
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const groups = table.groups();

  // initialize groups
  const { get, names = [], rows, size = 1 } = groups || {};
  const counts = new Uint32Array(size + 1);
  names.forEach(name => cols.add(name, null));

  // compute reduced values
  const cells = groups
    ? (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.reduceGroups)(table, reducer, groups)
    : [ (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.reduceFlat)(table, reducer) ];

  // initialize output columns
  reducer.outputs().map(name => cols.add(name, []));

  // write reduced values to output columns
  const n = counts.length - 1;
  let len = 0;
  for (let i = 0; i < n; ++i) {
    len += counts[i + 1] = reducer.write(cells[i], cols.data, counts[i]);
  }

  // write group values to output columns
  if (groups) {
    const data = table.data();
    names.forEach((name, index) => {
      const column = cols.data[name] = Array(len);
      const getter = get[index];
      for (let i = 0, j = 0; i < size; ++i) {
        column.fill(getter(rows[i], data), j, j += counts[i + 1]);
      }
    });
  }

  return table.create(cols.new());
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/reduce/field-reducer.js":
/*!******************************************************************!*\
  !*** ../node_modules/arquero/src/engine/reduce/field-reducer.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reducer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reducer */ "../node_modules/arquero/src/engine/reduce/reducer.js");
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../op */ "../node_modules/arquero/src/op/index.js");
/* harmony import */ var _util_concat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/concat */ "../node_modules/arquero/src/util/concat.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_valid__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/is-valid */ "../node_modules/arquero/src/util/is-valid.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/unroll */ "../node_modules/arquero/src/util/unroll.js");
/* harmony import */ var _util_value_list__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/value-list */ "../node_modules/arquero/src/util/value-list.js");








const update = (ops, args, fn) => (0,_util_unroll__WEBPACK_IMPORTED_MODULE_5__["default"])(
  args,
  '{' + (0,_util_concat__WEBPACK_IMPORTED_MODULE_2__["default"])(ops, (_, i) => `_${i}.${fn}(${args});`) + '}',
  ops
);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(oplist, stream) {
  const { ops, output } = expand(oplist, stream);
  const fields = oplist[0].fields;
  const n = fields.length;
  const cls = n === 0 ? FieldReducer
    : n === 1 ? Field1Reducer
    : n === 2 ? Field2Reducer
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])('Unsupported field count: ' + n);
  return new cls(fields, ops, output, stream);
}

function expand(oplist, stream) {
  const has = {};
  const ops = [];

  function add(name, params = []) {
    // check key
    const key = name + ':' + params;
    if (has[key]) return has[key];

    // get op instance
    const def = (0,_op__WEBPACK_IMPORTED_MODULE_1__.getAggregate)(name);
    const op = def.create(...params);

    // add required dependencies
    if (stream < 0 && def.stream) {
      def.stream.forEach(name => add(name, []));
    }
    if (def.req) {
      def.req.forEach(name => add(name, []));
    }

    // update state
    has[key] = op;
    ops.push(op);

    return op;
  }

  const output = oplist.map(item => {
    const op = add(item.name, item.params);
    op.output = item.id;
    return op;
  });

  return { ops, output };
}

class FieldReducer extends _reducer__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(fields, ops, outputs, stream) {
    super(outputs);
    this._op = ops;
    this._fields = fields;
    this._stream = !!stream;
  }

  init() {
    const state = { count: 0, valid: 0, stream: this._stream };
    this._op.forEach(op => op.init(state));

    // value list requested
    if (state.values) {
      state.list = new _util_value_list__WEBPACK_IMPORTED_MODULE_6__["default"]();
    }

    return state;
  }

  write(state, values, index) {
    const op = this._outputs;
    const n = op.length;
    for (let i = 0; i < n; ++i) {
      values[op[i].output][index] = op[i].value(state);
    }
    return 1;
  }

  _add() {
  }

  _rem() {
  }

  add(state) {
    ++state.count;
  }

  rem(state) {
    --state.count;
  }
}

class Field1Reducer extends FieldReducer {
  constructor(fields, ops, outputs, stream) {
    super(fields, ops, outputs, stream);

    // unroll op invocations for performance
    const args = ['state', 'v1', 'v2'];
    this._add = update(ops, args, 'add');
    this._rem = update(ops, args, 'rem');
  }

  add(state, row, data) {
    const value = this._fields[0](row, data);
    ++state.count;
    if ((0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value)) {
      ++state.valid;
      if (state.list) state.list.add(value);
      this._add(state, value);
    }
  }

  rem(state, row, data) {
    const value = this._fields[0](row, data);
    --state.count;
    if ((0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value)) {
      --state.valid;
      if (state.list) state.list.rem();
      this._rem(state, value);
    }
  }
}

class Field2Reducer extends FieldReducer {
  constructor(fields, ops, outputs, stream) {
    super(fields, ops, outputs, stream);

    // unroll op invocations for performance
    const args = ['state', 'v1', 'v2'];
    this._add = update(ops, args, 'add');
    this._rem = update(ops, args, 'rem');
  }

  add(state, row, data) {
    const value1 = this._fields[0](row, data);
    const value2 = this._fields[1](row, data);
    ++state.count;
    if ((0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value1) && (0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value2)) {
      ++state.valid;
      if (state.list) state.list.add([value1, value2]);
      this._add(state, value1, value2);
    }
  }

  rem(state, row, data) {
    const value1 = this._fields[0](row, data);
    const value2 = this._fields[1](row, data);
    --state.count;
    if ((0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value1) && (0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value2)) {
      --state.valid;
      if (state.list) state.list.rem();
      this._rem(state, value1, value2);
    }
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/reduce/reducer.js":
/*!************************************************************!*\
  !*** ../node_modules/arquero/src/engine/reduce/reducer.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Reducer)
/* harmony export */ });
/**
 * Abstract class for custom aggregation operations.
 */
class Reducer {
  constructor(outputs) {
    this._outputs = outputs;
  }

  size() {
    return this._outputs.length;
  }

  outputs() {
    return this._outputs;
  }

  init(/* columns */) {
    return {};
  }

  add(/* state, row, data */) {
    // no-op, subclasses should override
  }

  rem(/* state, row, data */) {
    // no-op, subclasses should override
  }

  write(/* state, values, index */) {
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/reduce/util.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/engine/reduce/util.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   aggregate: () => (/* binding */ aggregate),
/* harmony export */   aggregateGet: () => (/* binding */ aggregateGet),
/* harmony export */   groupOutput: () => (/* binding */ groupOutput),
/* harmony export */   reduceFlat: () => (/* binding */ reduceFlat),
/* harmony export */   reduceGroups: () => (/* binding */ reduceGroups),
/* harmony export */   reducers: () => (/* binding */ reducers)
/* harmony export */ });
/* harmony import */ var _field_reducer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./field-reducer */ "../node_modules/arquero/src/engine/reduce/field-reducer.js");
/* harmony import */ var _util_repeat__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/repeat */ "../node_modules/arquero/src/util/repeat.js");



function aggregateGet(table, ops, get) {
  if (ops.length) {
    const data = table.data();
    const { keys } = table.groups() || {};
    const result = aggregate(table, ops);
    const op = keys
      ? (name, row) => result[name][keys[row]]
      : name => result[name][0];
    get = get.map(f => row => f(row, data, op));
  }

  return get;
}

function aggregate(table, ops, result) {
  if (!ops.length) return result; // early exit

  // instantiate aggregators and result store
  const aggrs = reducers(ops);
  const groups = table.groups();
  const size = groups ? groups.size : 1;
  result = result || (0,_util_repeat__WEBPACK_IMPORTED_MODULE_1__["default"])(ops.length, () => Array(size));

  // compute aggregates, extract results
  if (size > 1) {
    aggrs.forEach(aggr => {
      const cells = reduceGroups(table, aggr, groups);
      for (let i = 0; i < size; ++i) {
        aggr.write(cells[i], result, i);
      }
    });
  } else {
    aggrs.forEach(aggr => {
      const cell = reduceFlat(table, aggr);
      aggr.write(cell, result, 0);
    });
  }

  return result;
}

function reducers(ops, stream) {
  const aggrs = [];
  const fields = {};

  // group operators by field inputs
  for (const op of ops) {
    const key = op.fields.map(f => f + '').join(',');
    (fields[key] || (fields[key] = [])).push(op);
  }

  // generate a field reducer for each field
  for (const key in fields) {
    aggrs.push((0,_field_reducer__WEBPACK_IMPORTED_MODULE_0__["default"])(fields[key], stream));
  }

  return aggrs;
}

function reduceFlat(table, reducer) {
  // initialize aggregation cell
  const cell = reducer.init();

  // compute aggregate values
  // inline the following for performance:
  // table.scan((row, data) => reducer.add(cell, row, data));
  const n = table.totalRows();
  const data = table.data();
  const bits = table.mask();

  if (table.isOrdered()) {
    const idx = table.indices();
    for (let i = 0; i < n; ++i) {
      reducer.add(cell, idx[i], data);
    }
  } else if (bits) {
    for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
      reducer.add(cell, i, data);
    }
  } else {
    for (let i = 0; i < n; ++i) {
      reducer.add(cell, i, data);
    }
  }

  return cell;
}

function reduceGroups(table, reducer, groups) {
  const { keys, size } = groups;

  // initialize aggregation cells
  const cells = (0,_util_repeat__WEBPACK_IMPORTED_MODULE_1__["default"])(size, () => reducer.init());

  // compute aggregate values
  // inline the following for performance:
  // table.scan((row, data) => reducer.add(cells[keys[row]], row, data));
  const data = table.data();

  if (table.isOrdered()) {
    const idx = table.indices();
    const m = idx.length;
    for (let i = 0; i < m; ++i) {
      const row = idx[i];
      reducer.add(cells[keys[row]], row, data);
    }
  } else if (table.isFiltered()) {
    const bits = table.mask();
    for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
      reducer.add(cells[keys[i]], i, data);
    }
  } else {
    const n = table.totalRows();
    for (let i = 0; i < n; ++i) {
      reducer.add(cells[keys[i]], i, data);
    }
  }

  return cells;
}

function groupOutput(cols, groups) {
  const { get, names, rows, size } = groups;

  // write group values to output columns
  const m = names.length;
  for (let j = 0; j < m; ++j) {
    const col = cols.add(names[j], Array(size));
    const val = get[j];
    for (let i = 0; i < size; ++i) {
      col[i] = val(rows[i]);
    }
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/rollup.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/rollup.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, { names, exprs, ops }) {
  // output data
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const groups = table.groups();

  // write groupby fields to output
  if (groups) (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.groupOutput)(cols, groups);

  // compute and write aggregate output
  output(names, exprs, groups, (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregate)(table, ops), cols);

  // return output table
  return table.create(cols.new());
}

function output(names, exprs, groups, result = [], cols) {
  if (!exprs.length) return;
  const size = groups ? groups.size : 1;
  const op = (id, row) => result[id][row];
  const n = names.length;

  for (let i = 0; i < n; ++i) {
    const get = exprs[i];
    if (get.field != null) {
      // if expression is op only, use aggregates directly
      cols.add(names[i], result[get.field]);
    } else if (size > 1) {
      // if multiple groups, evaluate expression for each
      const col = cols.add(names[i], Array(size));
      for (let j = 0; j < size; ++j) {
        col[j] = get(j, null, op);
      }
    } else {
      // if only one group, no need to loop
      cols.add(names[i], [ get(0, null, op) ]);
    }
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/sample.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/sample.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_sample__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/sample */ "../node_modules/arquero/src/util/sample.js");
/* harmony import */ var _util_shuffle__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/shuffle */ "../node_modules/arquero/src/util/shuffle.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, size, weight, options = {}) {
  const { replace, shuffle } = options;
  const parts = table.partitions(false);

  let total = 0;
  size = parts.map((idx, group) => {
    let s = size(group);
    total += (s = (replace ? s : Math.min(idx.length, s)));
    return s;
  });

  const samples = new Uint32Array(total);
  let curr = 0;

  parts.forEach((idx, group) => {
    const sz = size[group];
    const buf = samples.subarray(curr, curr += sz);

    if (!replace && sz === idx.length) {
      // sample size === data size, no replacement
      // no need to sample, just copy indices
      buf.set(idx);
    } else {
      (0,_util_sample__WEBPACK_IMPORTED_MODULE_0__["default"])(buf, replace, idx, weight);
    }
  });

  if (shuffle !== false && (parts.length > 1 || !replace)) {
    // sampling with replacement methods shuffle, so in
    // that case a single partition is already good to go
    (0,_util_shuffle__WEBPACK_IMPORTED_MODULE_1__["default"])(samples);
  }

  return table.reify(samples);
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/select.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/select.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-string */ "../node_modules/arquero/src/util/is-string.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, columns) {
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_0__["default"])();

  columns.forEach((value, curr) => {
    const next = (0,_util_is_string__WEBPACK_IMPORTED_MODULE_2__["default"])(value) ? value : curr;
    if (next) {
      const col = table.column(curr) || (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])(`Unrecognized column: ${curr}`);
      cols.add(next, col);
    }
  });

  return table.create(cols);
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/spread.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/spread.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/null */ "../node_modules/arquero/src/util/null.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/to-array */ "../node_modules/arquero/src/util/to-array.js");





/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, { names, exprs, ops = [] }, options = {}) {
  if (names.length === 0) return table;

  // ignore 'as' if there are multiple field names
  const as = (names.length === 1 && options.as) || [];
  const drop = options.drop == null ? true : !!options.drop;
  const limit = options.limit == null
    ? as.length || Infinity
    : Math.max(1, +options.limit || 1);

  const get = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregateGet)(table, ops, exprs);
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const map = names.reduce((map, name, i) => map.set(name, i), new Map());

  const add = (index, name) => {
    const columns = spread(table, get[index], limit);
    const n = columns.length;
    for (let i = 0; i < n; ++i) {
      cols.add(as[i] || `${name}_${i + 1}`, columns[i]);
    }
  };

  table.columnNames().forEach(name => {
    if (map.has(name)) {
      if (!drop) cols.add(name, table.column(name));
      add(map.get(name), name);
      map.delete(name);
    } else {
      cols.add(name, table.column(name));
    }
  });

  map.forEach(add);

  return table.create(cols);
}

function spread(table, get, limit) {
  const nrows = table.totalRows();
  const columns = [];

  table.scan((row, data) => {
    const values = (0,_util_to_array__WEBPACK_IMPORTED_MODULE_3__["default"])(get(row, data));
    const n = Math.min(values.length, limit);
    while (columns.length < n) {
      columns.push(Array(nrows).fill(_util_null__WEBPACK_IMPORTED_MODULE_2__["default"]));
    }
    for (let i = 0; i < n; ++i) {
      columns[i][row] = values[i];
    }
  });

  return columns;
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/ungroup.js":
/*!*****************************************************!*\
  !*** ../node_modules/arquero/src/engine/ungroup.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table) {
  return table.isGrouped()
    ? table.create({ groups: null })
    : table;
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/unorder.js":
/*!*****************************************************!*\
  !*** ../node_modules/arquero/src/engine/unorder.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table) {
  return table.isOrdered()
    ? table.create({ order: null })
    : table;
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/unroll.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/engine/unroll.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/to-array */ "../node_modules/arquero/src/util/to-array.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, { names = [], exprs = [], ops = [] }, options = {}) {
  if (!names.length) return table;

  const limit = options.limit > 0 ? +options.limit : Infinity;
  const index = options.index
    ? options.index === true ? 'index' : options.index + ''
    : null;
  const drop = new Set(options.drop);
  const get = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregateGet)(table, ops, exprs);

  // initialize output columns
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const nset = new Set(names);
  const priors = [];
  const copies = [];
  const unroll = [];

  // original and copied columns
  table.columnNames().forEach(name => {
    if (!drop.has(name)) {
      const col = cols.add(name, []);
      if (!nset.has(name)) {
        priors.push(table.column(name));
        copies.push(col);
      }
    }
  });

  // unrolled output columns
  names.forEach(name => {
    if (!drop.has(name)) {
      if (!cols.has(name)) cols.add(name, []);
      unroll.push(cols.data[name]);
    }
  });

  // index column, if requested
  const icol = index ? cols.add(index, []) : null;

  let start = 0;
  const m = priors.length;
  const n = unroll.length;

  const copy = (row, maxlen) => {
    for (let i = 0; i < m; ++i) {
      copies[i].length = start + maxlen;
      copies[i].fill(priors[i].get(row), start, start + maxlen);
    }
  };

  const indices = icol
    ? (row, maxlen) => {
        for (let i = 0; i < maxlen; ++i) {
          icol[row + i] = i;
        }
      }
    : () => {};

  if (n === 1) {
    // optimize common case of one array-valued column
    const fn = get[0];
    const col = unroll[0];

    table.scan((row, data) => {
      // extract array data
      const array = (0,_util_to_array__WEBPACK_IMPORTED_MODULE_2__["default"])(fn(row, data));
      const maxlen = Math.min(array.length, limit);

      // copy original table data
      copy(row, maxlen);

      // copy unrolled array data
      for (let j = 0; j < maxlen; ++j) {
        col[start + j] = array[j];
      }

      // fill in array indices
      indices(start, maxlen);

      start += maxlen;
    });
  } else {
    table.scan((row, data) => {
      let maxlen = 0;

      // extract parallel array data
      const arrays = get.map(fn => {
        const value = (0,_util_to_array__WEBPACK_IMPORTED_MODULE_2__["default"])(fn(row, data));
        maxlen = Math.min(Math.max(maxlen, value.length), limit);
        return value;
      });

      // copy original table data
      copy(row, maxlen);

      // copy unrolled array data
      for (let i = 0; i < n; ++i) {
        const col = unroll[i];
        const arr = arrays[i];
        for (let j = 0; j < maxlen; ++j) {
          col[start + j] = arr[j];
        }
      }

      // fill in array indices
      indices(start, maxlen);

      start += maxlen;
    });
  }

  return table.create(cols.new());
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/window/window-state.js":
/*!*****************************************************************!*\
  !*** ../node_modules/arquero/src/engine/window/window-state.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/ascending */ "../node_modules/arquero/src/util/ascending.js");
/* harmony import */ var _util_bisector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/bisector */ "../node_modules/arquero/src/util/bisector.js");
/* harmony import */ var _util_concat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/concat */ "../node_modules/arquero/src/util/concat.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/unroll */ "../node_modules/arquero/src/util/unroll.js");





const bisect = (0,_util_bisector__WEBPACK_IMPORTED_MODULE_1__["default"])(_util_ascending__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(data, frame, adjust, ops, aggrs) {
  let rows, peer, cells, result, key;
  const isPeer = index => peer[index - 1] === peer[index];
  const numOps = ops.length;
  const numAgg = aggrs.length;

  const evaluate = ops.length
    ? (0,_util_unroll__WEBPACK_IMPORTED_MODULE_3__["default"])(
        ['w', 'r', 'k'],
        '{' + (0,_util_concat__WEBPACK_IMPORTED_MODULE_2__["default"])(ops, (_, i) => `r[_${i}.id][k]=_${i}.value(w,_${i}.get);`) + '}',
        ops
      )
    : () => {};

  const w = {
    i0: 0,
    i1: 0,
    index: 0,
    size: 0,
    peer: isPeer,

    init(partition, peers, results, group) {
      w.index = w.i0 = w.i1 = 0;
      w.size = peers.length;
      rows = partition;
      peer = peers;
      result = results;
      key = group;

      // initialize aggregates
      cells = aggrs ? aggrs.map(aggr => aggr.init()) : null;

      // initialize window ops
      for (let i = 0; i < numOps; ++i) {
        ops[i].init();
      }

      return w;
    },

    value(index, get) {
      return get(rows[index], data);
    },

    step(idx) {
      const [f0, f1] = frame;
      const n = w.size;
      const p0 = w.i0;
      const p1 = w.i1;

      w.i0 = f0 != null ? Math.max(0, idx - Math.abs(f0)) : 0;
      w.i1 = f1 != null ? Math.min(n, idx + Math.abs(f1) + 1) : n;
      w.index = idx;

      if (adjust) {
        if (w.i0 > 0 && isPeer(w.i0)) {
          w.i0 = bisect.left(peer, peer[w.i0]);
        }
        if (w.i1 < n && isPeer(w.i1)) {
          w.i1 = bisect.right(peer, peer[w.i1 - 1]);
        }
      }

      // evaluate aggregates
      for (let i = 0; i < numAgg; ++i) {
        const aggr = aggrs[i];
        const cell = cells[i];
        for (let j = p0; j < w.i0; ++j) {
          aggr.rem(cell, rows[j], data);
        }
        for (let j = p1; j < w.i1; ++j) {
          aggr.add(cell, rows[j], data);
        }
        aggr.write(cell, result, key);
      }

      // evaluate window ops
      evaluate(w, result, key);

      return result;
    }
  };

  return w;
}

/***/ }),

/***/ "../node_modules/arquero/src/engine/window/window.js":
/*!***********************************************************!*\
  !*** ../node_modules/arquero/src/engine/window/window.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   window: () => (/* binding */ window)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../op */ "../node_modules/arquero/src/op/index.js");
/* harmony import */ var _util_concat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/concat */ "../node_modules/arquero/src/util/concat.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/unroll */ "../node_modules/arquero/src/util/unroll.js");
/* harmony import */ var _window_state__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./window-state */ "../node_modules/arquero/src/engine/window/window-state.js");






const frameValue = op =>
  (op.frame || [null, null]).map(v => Number.isFinite(v) ? Math.abs(v) : null);

const peersValue = op => !!op.peers;

function windowOp(spec) {
  const { id, name, fields = [], params = [] } = spec;
  const op = (0,_op__WEBPACK_IMPORTED_MODULE_1__.getWindow)(name).create(...params);
  if (fields.length) op.get = fields[0];
  op.id = id;
  return op;
}

function window(table, cols, exprs, result = {}, ops) {
  // instantiate window states
  const data = table.data();
  const states = windowStates(ops, data);
  const nstate = states.length;

  const write = (0,_util_unroll__WEBPACK_IMPORTED_MODULE_3__["default"])(
    ['r', 'd', 'op'],
    '{' + (0,_util_concat__WEBPACK_IMPORTED_MODULE_2__["default"])(cols, (_, i) => `_${i}[r] = $${i}(r, d, op);`) + '}',
    cols, exprs
  );

  // scan each ordered partition
  table.partitions().forEach((rows, key) => {
    const size = rows.length;
    const peers = windowPeers(table, rows);

    // initialize window states
    for (let i = 0; i < nstate; ++i) {
      states[i].init(rows, peers, result, key);
    }

    // calculate window values per-row
    const op = id => result[id][key];
    for (let index = 0; index < size; ++index) {
      // advance window frame, updates result object
      for (let i = 0; i < nstate; ++i) {
        states[i].step(index);
      }
      write(rows[index], data, op);
    }
  });
}

function windowStates(ops, data) {
  const map = {};

  // group operations by window frame parameters
  ops.forEach(op => {
    const frame = frameValue(op);
    const peers = peersValue(op);
    const key = `${frame},${peers}`;
    const { aggOps, winOps } = map[key] || (map[key] = {
      frame,
      peers,
      aggOps: [],
      winOps: []
    });
    (0,_op__WEBPACK_IMPORTED_MODULE_1__.hasAggregate)(op.name)
      ? aggOps.push(op)
      : winOps.push(windowOp(op));
  });

  return Object.values(map).map(_ => (0,_window_state__WEBPACK_IMPORTED_MODULE_4__["default"])(
    data, _.frame, _.peers, _.winOps,
    (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.reducers)(_.aggOps, _.frame[0] != null ? -1 : 1)
  ));
}

function windowPeers(table, rows) {
  if (table.isOrdered()) {
    // generate peer ids for sort equality checking
    const compare = table.comparator();
    const data = table.data();
    const nrows = rows.length;
    const peers = new Uint32Array(nrows);
    for (let i = 1, index = 0; i < nrows; ++i) {
      peers[i] = compare(rows[i - 1], rows[i], data) ? ++index : index;
    }
    return peers;
  } else {
    // no sort, no peers: reuse row indices as peer ids
    return rows;
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/expression/ast/clean.js":
/*!***********************************************************!*\
  !*** ../node_modules/arquero/src/expression/ast/clean.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _walk__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./walk */ "../node_modules/arquero/src/expression/ast/walk.js");


function strip(node) {
  delete node.start;
  delete node.end;
  delete node.optional;
}

function stripMember(node) {
  strip(node);
  delete node.object;
  delete node.property;
  delete node.computed;
  if (!node.table) delete node.table;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(ast) {
  (0,_walk__WEBPACK_IMPORTED_MODULE_0__["default"])(ast, null, {
    Column: stripMember,
    Constant: stripMember,
    Default: strip
  });
  return ast;
}

/***/ }),

/***/ "../node_modules/arquero/src/expression/ast/constants.js":
/*!***************************************************************!*\
  !*** ../node_modules/arquero/src/expression/ast/constants.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArrayPattern: () => (/* binding */ ArrayPattern),
/* harmony export */   ArrowFunctionExpression: () => (/* binding */ ArrowFunctionExpression),
/* harmony export */   Column: () => (/* binding */ Column),
/* harmony export */   Constant: () => (/* binding */ Constant),
/* harmony export */   Dictionary: () => (/* binding */ Dictionary),
/* harmony export */   Function: () => (/* binding */ Function),
/* harmony export */   FunctionExpression: () => (/* binding */ FunctionExpression),
/* harmony export */   Identifier: () => (/* binding */ Identifier),
/* harmony export */   Literal: () => (/* binding */ Literal),
/* harmony export */   MemberExpression: () => (/* binding */ MemberExpression),
/* harmony export */   ObjectExpression: () => (/* binding */ ObjectExpression),
/* harmony export */   ObjectPattern: () => (/* binding */ ObjectPattern),
/* harmony export */   Op: () => (/* binding */ Op),
/* harmony export */   Parameter: () => (/* binding */ Parameter),
/* harmony export */   Property: () => (/* binding */ Property)
/* harmony export */ });
const ArrayPattern = 'ArrayPattern';
const ArrowFunctionExpression = 'ArrowFunctionExpression';
const FunctionExpression = 'FunctionExpression';
const Identifier = 'Identifier';
const Literal = 'Literal';
const MemberExpression = 'MemberExpression';
const ObjectExpression = 'ObjectExpression';
const ObjectPattern = 'ObjectPattern';
const Property = 'Property';

const Column = 'Column';
const Constant = 'Constant';
const Dictionary = 'Dictionary';
const Function = 'Function';
const Parameter = 'Parameter';
const Op = 'Op';

/***/ }),

/***/ "../node_modules/arquero/src/expression/ast/util.js":
/*!**********************************************************!*\
  !*** ../node_modules/arquero/src/expression/ast/util.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   is: () => (/* binding */ is),
/* harmony export */   isFunctionExpression: () => (/* binding */ isFunctionExpression)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../node_modules/arquero/src/expression/ast/constants.js");


function is(type, node) {
  return node && node.type === type;
}

function isFunctionExpression(node) {
  return is(_constants__WEBPACK_IMPORTED_MODULE_0__.FunctionExpression, node)
    || is(_constants__WEBPACK_IMPORTED_MODULE_0__.ArrowFunctionExpression, node);
}

/***/ }),

/***/ "../node_modules/arquero/src/expression/ast/walk.js":
/*!**********************************************************!*\
  !*** ../node_modules/arquero/src/expression/ast/walk.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ walk)
/* harmony export */ });
function walk(node, ctx, visitors, parent) {
  const visit = visitors[node.type] || visitors['Default'];
  if (visit && visit(node, ctx, parent) === false) return;

  const walker = walkers[node.type];
  if (walker) walker(node, ctx, visitors);
}

const unary = (node, ctx, visitors) => {
  walk(node.argument, ctx, visitors, node);
};

const binary = (node, ctx, visitors) => {
  walk(node.left, ctx, visitors, node);
  walk(node.right, ctx, visitors, node);
};

const ternary = (node, ctx, visitors) => {
  walk(node.test, ctx, visitors, node);
  walk(node.consequent, ctx, visitors, node);
  if (node.alternate) walk(node.alternate, ctx, visitors, node);
};

const func = (node, ctx, visitors) => {
  list(node.params, ctx, visitors, node);
  walk(node.body, ctx, visitors, node);
};

const call = (node, ctx, visitors) => {
  walk(node.callee, ctx, visitors, node);
  list(node.arguments, ctx, visitors, node);
};

const list = (nodes, ctx, visitors, node) => {
  nodes.forEach(item => walk(item, ctx, visitors, node));
};

const walkers = {
  TemplateLiteral: (node, ctx, visitors) => {
    list(node.expressions, ctx, visitors, node);
    list(node.quasis, ctx, visitors, node);
  },
  MemberExpression: (node, ctx, visitors) => {
    walk(node.object, ctx, visitors, node);
    walk(node.property, ctx, visitors, node);
  },
  CallExpression: call,
  NewExpression: call,
  ArrayExpression: (node, ctx, visitors) => {
    list(node.elements, ctx, visitors, node);
  },
  AssignmentExpression: binary,
  AwaitExpression: unary,
  BinaryExpression: binary,
  LogicalExpression: binary,
  UnaryExpression: unary,
  UpdateExpression: unary,
  ConditionalExpression: ternary,
  ObjectExpression: (node, ctx, visitors) => {
    list(node.properties, ctx, visitors, node);
  },
  Property: (node, ctx, visitors) => {
    walk(node.key, ctx, visitors, node);
    walk(node.value, ctx, visitors, node);
  },

  ArrowFunctionExpression: func,
  FunctionExpression: func,
  FunctionDeclaration: func,

  VariableDeclaration: (node, ctx, visitors) => {
    list(node.declarations, ctx, visitors, node);
  },
  VariableDeclarator: (node, ctx, visitors) => {
    walk(node.id, ctx, visitors, node);
    walk(node.init, ctx, visitors, node);
  },
  SpreadElement: (node, ctx, visitors) => {
    walk(node.argument, ctx, visitors, node);
  },

  BlockStatement: (node, ctx, visitors) => {
    list(node.body, ctx, visitors, node);
  },
  ExpressionStatement: (node, ctx, visitors) => {
    walk(node.expression, ctx, visitors, node);
  },
  IfStatement: ternary,
  ForStatement: (node, ctx, visitors) => {
    walk(node.init, ctx, visitors, node);
    walk(node.test, ctx, visitors, node);
    walk(node.update, ctx, visitors, node);
    walk(node.body, ctx, visitors, node);
  },
  WhileStatement: (node, ctx, visitors) => {
    walk(node.test, ctx, visitors, node);
    walk(node.body, ctx, visitors, node);
  },
  DoWhileStatement: (node, ctx, visitors) => {
    walk(node.body, ctx, visitors, node);
    walk(node.test, ctx, visitors, node);
  },
  SwitchStatement: (node, ctx, visitors) => {
    walk(node.discriminant, ctx, visitors, node);
    list(node.cases, ctx, visitors, node);
  },
  SwitchCase: (node, ctx, visitors) => {
    if (node.test) walk(node.test, ctx, visitors, node);
    list(node.consequent, ctx, visitors, node);
  },
  ReturnStatement: unary,

  Program: (node, ctx, visitors) => {
    walk(node.body[0], ctx, visitors, node);
  }
};

/***/ }),

/***/ "../node_modules/arquero/src/expression/codegen.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/expression/codegen.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/to-string */ "../node_modules/arquero/src/util/to-string.js");



const visit = (node, opt) => {
  const f = visitors[node.type];
  return f
    ? f(node, opt)
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])(`Unsupported expression construct: ${node.type}`);
};

const binary = (node, opt) => {
  return '(' + visit(node.left, opt) + ' ' + node.operator + ' ' + visit(node.right, opt) + ')';
};

const func = (node, opt) => {
  return '(' + list(node.params, opt) + ')=>' + visit(node.body, opt);
};

const call = (node, opt) => {
  return visit(node.callee, opt) + '(' + list(node.arguments, opt) + ')';
};

const list = (array, opt, delim = ',') => {
  return array.map(node => visit(node, opt)).join(delim);
};

const name = node => node.computed
  ? `[${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_1__["default"])(node.name)}]`
  : `.${node.name}`;

const ref = (node, opt, method) => {
  const table = node.table || '';
  return `data${table}${name(node)}.${method}(${opt.index}${table})`;
};

const visitors = {
  Constant: node => node.raw,
  Column: (node, opt) => ref(node, opt, 'get'),
  Dictionary: (node, opt) => ref(node, opt, 'key'),
  Function: node => `fn.${node.name}`,
  Parameter: node => `$${name(node)}`,
  Op: (node, opt) => `op(${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_1__["default"])(node.name)},${opt.op || opt.index})`,
  Literal: node => node.raw,
  Identifier: node => node.name,
  TemplateLiteral: (node, opt) => {
    const { quasis, expressions } = node;
    const n = expressions.length;
    let t = quasis[0].value.raw;
    for (let i = 0; i < n;) {
      t += '${' + visit(expressions[i], opt) + '}' + quasis[++i].value.raw;
    }
    return '`' + t + '`';
  },
  MemberExpression: (node, opt) => {
    const d = !node.computed;
    const o = visit(node.object, opt);
    const p = visit(node.property, opt);
    return o + (d ? '.' + p : '[' + p + ']');
  },
  CallExpression: call,
  NewExpression: (node, opt) => {
    return 'new ' + call(node, opt);
  },
  ArrayExpression: (node, opt) => {
    return '[' + list(node.elements, opt) + ']';
  },
  AssignmentExpression: binary,
  BinaryExpression: binary,
  LogicalExpression: binary,
  UnaryExpression: (node, opt) => {
    return '(' + node.operator + visit(node.argument, opt) + ')';
  },
  ConditionalExpression: (node, opt) => {
    return '(' + visit(node.test, opt) +
      '?' + visit(node.consequent, opt) +
      ':' + visit(node.alternate, opt) + ')';
  },
  ObjectExpression: (node, opt) => {
    return '({' + list(node.properties, opt) + '})';
  },
  Property: (node, opt) => {
    const key = visit(node.key, opt);
    return (node.computed ? `[${key}]` : key) + ':' + visit(node.value, opt);
  },

  ArrowFunctionExpression: func,
  FunctionExpression: func,
  FunctionDeclaration: func,

  ArrayPattern: (node, opt) => {
    return '[' + list(node.elements, opt) + ']';
  },
  ObjectPattern: (node, opt) => {
    return '{' + list(node.properties, opt) + '}';
  },
  VariableDeclaration: (node, opt) => {
    return node.kind + ' ' + list(node.declarations, opt, ',');
  },
  VariableDeclarator: (node, opt) => {
    return visit(node.id, opt) + '=' + visit(node.init, opt);
  },
  SpreadElement: (node, opt) => {
    return '...' + visit(node.argument, opt);
  },

  BlockStatement: (node, opt) => {
    return '{' + list(node.body, opt, ';') + ';}';
  },
  BreakStatement: () => {
    return 'break';
  },
  ExpressionStatement: (node, opt) => {
    return visit(node.expression, opt);
  },
  IfStatement: (node, opt) => {
    return 'if (' + visit(node.test, opt) + ')'
      + visit(node.consequent, opt)
      + (node.alternate ? ' else ' + visit(node.alternate, opt) : '');
  },
  SwitchStatement: (node, opt) => {
    return 'switch (' + visit(node.discriminant, opt) + ') {'
     + list(node.cases, opt, '')
     + '}';
  },
  SwitchCase: (node, opt) => {
    return (node.test ? 'case ' + visit(node.test, opt) : 'default')
      + ': '
      + list(node.consequent, opt, ';') + ';';
  },
  ReturnStatement: (node, opt) => {
    return 'return ' + visit(node.argument, opt);
  },
  Program: (node, opt) => visit(node.body[0], opt)
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(node, opt = { index: 'row' }) {
  return visit(node, opt);
}

/***/ }),

/***/ "../node_modules/arquero/src/expression/compare.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/expression/compare.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _codegen__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./codegen */ "../node_modules/arquero/src/expression/codegen.js");
/* harmony import */ var _parse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parse */ "../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _engine_reduce_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../engine/reduce/util */ "../node_modules/arquero/src/engine/reduce/util.js");




// generate code to compare a single field
const _compare = (u, v, lt, gt) =>
  `((u = ${u}) < (v = ${v}) || u == null) && v != null ? ${lt}
    : (u > v || v == null) && u != null ? ${gt}
    : ((v = v instanceof Date ? +v : v), (u = u instanceof Date ? +u : u)) !== u && v === v ? ${lt}
    : v !== v && u === u ? ${gt} : `;

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, fields) {
  // parse expressions, generate code for both a and b values
  const names = [];
  const exprs = [];
  const fn = [];
  let keys = null, opA = '0', opB = '0';
  if (table.isGrouped()) {
    keys = table.groups().keys;
    opA = 'ka';
    opB = 'kb';
  }
  const { ops } = (0,_parse__WEBPACK_IMPORTED_MODULE_1__["default"])(fields, {
    table,
    value: (name, node) => {
      names.push(name);
      if (node.escape) {
        // if an escaped function, invoke it directly
        const f = i => `fn[${fn.length}](${i}, data)`;
        exprs.push([f('a'), f('b')]);
        fn.push(node.escape);
      } else {
        // generate code to extract values to compare
        exprs.push([
          (0,_codegen__WEBPACK_IMPORTED_MODULE_0__["default"])(node, { index: 'a', op: opA }),
          (0,_codegen__WEBPACK_IMPORTED_MODULE_0__["default"])(node, { index: 'b', op: opB })
        ]);
      }
    },
    window: false
  });

  // calculate aggregate values if needed
  const result = (0,_engine_reduce_util__WEBPACK_IMPORTED_MODULE_2__.aggregate)(table, ops);
  const op = (id, row) => result[id][row];

  // generate comparison code for each field
  const n = names.length;
  let code = 'return (a, b) => {'
    + (op && table.isGrouped() ? 'const ka = keys[a], kb = keys[b];' : '')
    + 'let u, v; return ';
  for (let i = 0; i < n; ++i) {
    const o = fields.get(names[i]).desc ? -1 : 1;
    const [u, v] = exprs[i];
    code += _compare(u, v, -o, o);
  }
  code += '0;};';

  // instantiate and return comparator function
  return Function('op', 'keys', 'fn', 'data', code)(op, keys, fn, table.data());
}

/***/ }),

/***/ "../node_modules/arquero/src/expression/compile.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/expression/compile.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../op */ "../node_modules/arquero/src/op/index.js");


function compile(code, fn, params) {
  code = `"use strict"; return ${code};`;
  return (Function('fn', '$', code))(fn, params);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  escape: (code, func, params) => compile(code, func, params),
  expr:   (code, params) => compile(`(row,data,op)=>${code}`, _op__WEBPACK_IMPORTED_MODULE_0__.functions, params),
  expr2:  (code, params) => compile(`(row0,data0,row,data)=>${code}`, _op__WEBPACK_IMPORTED_MODULE_0__.functions, params),
  join:   (code, params) => compile(`(row1,data1,row2,data2)=>${code}`, _op__WEBPACK_IMPORTED_MODULE_0__.functions, params),
  param:  (code, params) => compile(code, _op__WEBPACK_IMPORTED_MODULE_0__.functions, params)
});

/***/ }),

/***/ "../node_modules/arquero/src/expression/constants.js":
/*!***********************************************************!*\
  !*** ../node_modules/arquero/src/expression/constants.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  undefined: 'void(0)',
  Infinity:  'Number.POSITIVE_INFINITY',
  NaN:       'Number.NaN',
  E:         'Math.E',
  LN2:       'Math.LN2',
  LN10:      'Math.LN10',
  LOG2E:     'Math.LOG2E',
  LOG10E:    'Math.LOG10E',
  PI:        'Math.PI',
  SQRT1_2:   'Math.SQRT1_2',
  SQRT2:     'Math.SQRT2'
});

/***/ }),

/***/ "../node_modules/arquero/src/expression/parse-escape.js":
/*!**************************************************************!*\
  !*** ../node_modules/arquero/src/expression/parse-escape.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _compile__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./compile */ "../node_modules/arquero/src/expression/compile.js");
/* harmony import */ var _row_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./row-object */ "../node_modules/arquero/src/expression/row-object.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_to_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/to-function */ "../node_modules/arquero/src/util/to-function.js");





const ERROR_ESC_AGGRONLY = 'Escaped functions are not valid as rollup or pivot values.';

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(ctx, spec, params) {
  if (ctx.aggronly) (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])(ERROR_ESC_AGGRONLY);

  // generate escaped function invocation code
  const code = '(row,data)=>fn('
    + (0,_row_object__WEBPACK_IMPORTED_MODULE_1__.rowObjectCode)(ctx.table.columnNames())
    + ',$)';

  return { escape: _compile__WEBPACK_IMPORTED_MODULE_0__["default"].escape(code, (0,_util_to_function__WEBPACK_IMPORTED_MODULE_3__["default"])(spec.expr), params) };
}

/***/ }),

/***/ "../node_modules/arquero/src/expression/parse-expression.js":
/*!******************************************************************!*\
  !*** ../node_modules/arquero/src/expression/parse-expression.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ parseExpression)
/* harmony export */ });
/* harmony import */ var acorn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! acorn */ "../node_modules/acorn/dist/acorn.mjs");
/* harmony import */ var _ast_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ast/constants */ "../node_modules/arquero/src/expression/ast/constants.js");
/* harmony import */ var _ast_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ast/util */ "../node_modules/arquero/src/expression/ast/util.js");
/* harmony import */ var _ast_walk__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ast/walk */ "../node_modules/arquero/src/expression/ast/walk.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "../node_modules/arquero/src/expression/constants.js");
/* harmony import */ var _rewrite__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./rewrite */ "../node_modules/arquero/src/expression/rewrite.js");
/* harmony import */ var _row_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./row-object */ "../node_modules/arquero/src/expression/row-object.js");
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../op */ "../node_modules/arquero/src/op/index.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../util/has */ "../node_modules/arquero/src/util/has.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../util/is-array */ "../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../util/is-number */ "../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../util/to-string */ "../node_modules/arquero/src/util/to-string.js");















const PARSER_OPT = { ecmaVersion: 11 };
const DEFAULT_PARAM_ID = '$';
const DEFAULT_TUPLE_ID = 'd';
const DEFAULT_TUPLE_ID1 = 'd1';
const DEFAULT_TUPLE_ID2 = 'd2';

const NO = msg => (node, ctx) => ctx.error(node, msg + ' not allowed');
const ERROR_AGGREGATE = NO('Aggregate function');
const ERROR_WINDOW = NO('Window function');
const ERROR_ARGUMENT = 'Invalid argument';
const ERROR_COLUMN = 'Invalid column reference';
const ERROR_AGGRONLY = ERROR_COLUMN + ' (must be input to an aggregate function)';
const ERROR_FUNCTION = 'Invalid function call';
const ERROR_MEMBER = 'Invalid member expression';
const ERROR_OP_PARAMETER = 'Invalid operator parameter';
const ERROR_PARAM = 'Invalid param reference';
const ERROR_VARIABLE = 'Invalid variable reference';
const ERROR_VARIABLE_OP = 'Variable not accessible in operator call';
const ERROR_DECLARATION = 'Unsupported variable declaration';
const ERROR_DESTRUCTURE = 'Unsupported destructuring pattern';
const ERROR_CLOSURE = 'Table expressions do not support closures';
const ERROR_ESCAPE = 'Use aq.escape(fn) to use a function as-is (including closures)';
const ERROR_USE_PARAMS = 'use table.params({ name: value }) to define dynamic parameters';
const ERROR_ADD_FUNCTION = 'use aq.addFunction(name, fn) to add new op functions';
const ERROR_VARIABLE_NOTE = `\nNote: ${ERROR_CLOSURE}. ${ERROR_ESCAPE}, or ${ERROR_USE_PARAMS}.`;
const ERROR_FUNCTION_NOTE = `\nNote: ${ERROR_CLOSURE}. ${ERROR_ESCAPE}, or ${ERROR_ADD_FUNCTION}.`;
const ERROR_ROW_OBJECT = `The ${_row_object__WEBPACK_IMPORTED_MODULE_6__.ROW_OBJECT} method is not valid in multi-table expressions.`;

function parseExpression(ctx, spec) {
  const ast = parseAST(spec);
  let node = ctx.root = ast;
  ctx.spec = spec;
  ctx.tuple = null;
  ctx.tuple1 = null;
  ctx.tuple2 = null;
  ctx.$param = null;
  ctx.$op = 0;
  ctx.scope = new Set();
  ctx.paramsRef = new Map();
  ctx.columnRef = new Map();

  // parse input column parameters
  // if no function def, assume default tuple identifiers
  if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.isFunctionExpression)(node)) {
    parseFunction(node, ctx);
    node = node.body;
  } else if (ctx.join) {
    ctx.scope.add(ctx.tuple1 = DEFAULT_TUPLE_ID1);
    ctx.scope.add(ctx.tuple2 = DEFAULT_TUPLE_ID2);
    ctx.scope.add(ctx.$param = DEFAULT_PARAM_ID);
  } else {
    ctx.scope.add(ctx.tuple = DEFAULT_TUPLE_ID);
    ctx.scope.add(ctx.$param = DEFAULT_PARAM_ID);
  }

  // rewrite column references & function calls
  (0,_ast_walk__WEBPACK_IMPORTED_MODULE_3__["default"])(node, ctx, visitors);

  return ctx.root;
}

function parseAST(expr) {
  try {
    const code = expr.field ? fieldRef(expr)
      : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_10__["default"])(expr) ? (0,_util_to_string__WEBPACK_IMPORTED_MODULE_12__["default"])(expr)
      : expr;
    return (0,acorn__WEBPACK_IMPORTED_MODULE_0__.parse)(`expr=(${code})`, PARSER_OPT).body[0].expression.right;
  } catch (err) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_8__["default"])(`Expression parse error: ${expr+''}`, err);
  }
}

function fieldRef(expr) {
  const col = JSON.stringify(expr+'');
  return !(expr.table || 0) ? `d=>d[${col}]` : `(a,b)=>b[${col}]`;
}

const visitors = {
  FunctionDeclaration: NO('Function definitions'),
  ForStatement: NO('For loops'),
  ForOfStatement: NO('For-of loops'),
  ForInStatement: NO('For-in loops'),
  WhileStatement: NO('While loops'),
  DoWhileStatement: NO('Do-while loops'),
  AwaitExpression: NO('Await expressions'),
  ArrowFunctionExpression: NO('Function definitions'),
  AssignmentExpression: NO('Assignments'),
  FunctionExpression: NO('Function definitions'),
  NewExpression: NO('Use of "new"'),
  UpdateExpression: NO('Update expressions'),

  VariableDeclarator(node, ctx) {
    handleDeclaration(node.id, ctx);
  },
  Identifier(node, ctx, parent) {
    if (handleIdentifier(node, ctx, parent) && !ctx.scope.has(node.name)) {
      // handle identifier passed responsibility here
      // raise error if identifier not defined in scope
      ctx.error(node, ERROR_VARIABLE, ERROR_VARIABLE_NOTE);
    }
  },
  CallExpression(node, ctx) {
    const name = functionName(node.callee);
    const def = (0,_op__WEBPACK_IMPORTED_MODULE_7__.getAggregate)(name) || (0,_op__WEBPACK_IMPORTED_MODULE_7__.getWindow)(name);

    // parse operator and rewrite invocation
    if (def) {
      if ((ctx.join || ctx.aggregate === false) && (0,_op__WEBPACK_IMPORTED_MODULE_7__.hasAggregate)(def)) {
        ERROR_AGGREGATE(node, ctx);
      }
      if ((ctx.join || ctx.window === false) && (0,_op__WEBPACK_IMPORTED_MODULE_7__.hasWindow)(def)) {
        ERROR_WINDOW(node, ctx);
      }

      ctx.$op = 1;
      if (ctx.ast) {
        updateFunctionNode(node, name, ctx);
        node.arguments.forEach(arg => (0,_ast_walk__WEBPACK_IMPORTED_MODULE_3__["default"])(arg, ctx, opVisitors));
      } else {
        const op = ctx.op(parseOperator(ctx, def, name, node.arguments));
        Object.assign(node, { type: _ast_constants__WEBPACK_IMPORTED_MODULE_1__.Op, name: op.id });
      }
      ctx.$op = 0;
      return false;
    } else if ((0,_op__WEBPACK_IMPORTED_MODULE_7__.hasFunction)(name)) {
      updateFunctionNode(node, name, ctx);
    } else {
      ctx.error(node, ERROR_FUNCTION, ERROR_FUNCTION_NOTE);
    }
  },
  MemberExpression(node, ctx, parent) {
    const { object, property } = node;

    // bail if left head is not an identifier
    // in this case we will recurse and handle it later
    if (!(0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, object)) return;
    const { name } = object;

    // allow use of Math prefix to access constant values
    if (isMath(node) && (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, property)
        && (0,_util_has__WEBPACK_IMPORTED_MODULE_9__["default"])(_constants__WEBPACK_IMPORTED_MODULE_4__["default"], property.name)) {
      updateConstantNode(node, property.name);
      return;
    }

    const index = name === ctx.tuple ? 0
      : name === ctx.tuple1 ? 1
      : name === ctx.tuple2 ? 2
      : -1;

    if (index >= 0) {
      // replace member expression with column ref
      return spliceMember(node, index, ctx, checkColumn, parent);
    } else if (name === ctx.$param) {
      // replace member expression with param ref
      return spliceMember(node, index, ctx, checkParam);
    } else if (ctx.paramsRef.has(name)) {
      updateParameterNode(node, ctx.paramsRef.get(name));
    } else if (ctx.columnRef.has(name)) {
      updateColumnNode(object, name, ctx, node);
    } else if ((0,_util_has__WEBPACK_IMPORTED_MODULE_9__["default"])(ctx.params, name)) {
      updateParameterNode(object, name);
    }
  }
};

function spliceMember(node, index, ctx, check, parent) {
  const { property, computed } = node;
  let name;

  if (!computed) {
    name = property.name;
  } else if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Literal, property)) {
    name = property.value;
  } else try {
    name = ctx.param(property);
  } catch (e) {
    ctx.error(node, ERROR_MEMBER);
  }

  check(node, name, index, ctx, parent);
  return false;
}

const opVisitors = {
  ...visitors,
  VariableDeclarator: NO('Variable declaration in operator call'),
  Identifier(node, ctx, parent) {
    if (handleIdentifier(node, ctx, parent)) {
      ctx.error(node, ERROR_VARIABLE_OP);
    }
  },
  CallExpression(node, ctx) {
    const name = functionName(node.callee);

    // rewrite if built-in function
    if ((0,_op__WEBPACK_IMPORTED_MODULE_7__.hasFunction)(name)) {
      updateFunctionNode(node, name, ctx);
    } else {
      ctx.error(node, ERROR_FUNCTION, ERROR_FUNCTION_NOTE);
    }
  }
};

function parseFunction(node, ctx) {
  if (node.generator) NO('Generator functions')(node, ctx);
  if (node.async) NO('Async functions')(node, ctx);

  const { params } = node;
  const len = params.length;
  const setc = index => (name, key) => ctx.columnRef.set(name, [key, index]);
  const setp = (name, key) => ctx.paramsRef.set(name, key);

  if (!len) {
    // do nothing
  } else if (ctx.join) {
    parseRef(ctx, params[0], 'tuple1', setc(1));
    if (len > 1) parseRef(ctx, params[1], 'tuple2', setc(2));
    if (len > 2) parseRef(ctx, params[2], '$param', setp);
  } else {
    parseRef(ctx, params[0], 'tuple', setc(0));
    if (len > 1) parseRef(ctx, params[1], '$param', setp);
  }

  ctx.root = node.body;
}

function parseRef(ctx, node, refName, alias) {
  if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, node)) {
    ctx.scope.add(node.name);
    ctx[refName] = node.name;
  } else if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.ObjectPattern, node)) {
    node.properties.forEach(p => {
      const key = (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, p.key) ? p.key.name
        : (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Literal, p.key) ? p.key.value
        : ctx.error(p, ERROR_ARGUMENT);
      if (!(0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, p.value)) {
        ctx.error(p.value, ERROR_DESTRUCTURE);
      }
      alias(p.value.name, key);
    });
  }
}

function parseOperator(ctx, def, name, args) {
  const fields = [];
  const params = [];
  const idxFields = def.param[0] || 0;
  const idxParams = idxFields + (def.param[1] || 0);

  args.forEach((arg, index) => {
    if (index < idxFields) {
      (0,_ast_walk__WEBPACK_IMPORTED_MODULE_3__["default"])(arg, ctx, opVisitors);
      fields.push(ctx.field(arg));
    } else if (index < idxParams) {
      (0,_ast_walk__WEBPACK_IMPORTED_MODULE_3__["default"])(arg, ctx, opVisitors);
      params.push(ctx.param(arg));
    } else {
      ctx.error(arg, ERROR_OP_PARAMETER);
    }
  });

  return { name, fields, params, ...(ctx.spec.window || {}) };
}

function functionName(node) {
  return (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, node) ? node.name
    : !(0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.MemberExpression, node) ? null
    : isMath(node) ? rewriteMath(node.property.name)
    : node.property.name;
}

function isMath(node) {
  return (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, node.object) && node.object.name === 'Math';
}

function rewriteMath(name) {
  return name === 'max' ? 'greatest'
    : name === 'min' ? 'least'
    : name;
}

function handleIdentifier(node, ctx, parent) {
  const { name } = node;

  if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.MemberExpression, parent) && parent.property === node) {
    // do nothing: check head node, not nested properties
  } else if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Property, parent) && parent.key === node) {
    // do nothing: identifiers allowed in object expressions
  } else if (ctx.paramsRef.has(name)) {
    updateParameterNode(node, ctx.paramsRef.get(name));
  } else if (ctx.columnRef.has(name)) {
    updateColumnNode(node, name, ctx, parent);
  } else if ((0,_util_has__WEBPACK_IMPORTED_MODULE_9__["default"])(ctx.params, name)) {
    updateParameterNode(node, name);
  } else if ((0,_util_has__WEBPACK_IMPORTED_MODULE_9__["default"])(_constants__WEBPACK_IMPORTED_MODULE_4__["default"], name)) {
    updateConstantNode(node, name);
  } else {
    return true;
  }
}

function checkColumn(node, name, index, ctx, parent) {
  // check column existence if we have a backing table
  const table = index === 0 ? ctx.table
    : index > 0 ? ctx.join[index - 1]
    : null;
  const col = table && table.column(name);
  if (table && !col) {
    ctx.error(node, ERROR_COLUMN);
  }

  // check if column reference is valid in current context
  if (ctx.aggronly && !ctx.$op) {
    ctx.error(node, ERROR_AGGRONLY);
  }

  // rewrite ast node as a column access
  (0,_rewrite__WEBPACK_IMPORTED_MODULE_5__["default"])(node, name, index, col, parent);
}

function updateColumnNode(node, key, ctx, parent) {
  const [name, index] = ctx.columnRef.get(key);
  checkColumn(node, name, index, ctx, parent);
}

function checkParam(node, name, index, ctx) {
  if (ctx.params && !(0,_util_has__WEBPACK_IMPORTED_MODULE_9__["default"])(ctx.params, name)) {
    ctx.error(node, ERROR_PARAM);
  }
  updateParameterNode(node, name);
}

function updateParameterNode(node, name) {
  node.type = _ast_constants__WEBPACK_IMPORTED_MODULE_1__.Parameter;
  node.name = name;
}

function updateConstantNode(node, name) {
  node.type = _ast_constants__WEBPACK_IMPORTED_MODULE_1__.Constant;
  node.name = name;
  node.raw = _constants__WEBPACK_IMPORTED_MODULE_4__["default"][name];
}

function updateFunctionNode(node, name, ctx) {
  if (name === _row_object__WEBPACK_IMPORTED_MODULE_6__.ROW_OBJECT) {
    const t = ctx.table;
    if (!t) ctx.error(node, ERROR_ROW_OBJECT);
    (0,_row_object__WEBPACK_IMPORTED_MODULE_6__.rowObjectExpression)(node,
      node.arguments.length
        ? node.arguments.map(node => {
            const col = ctx.param(node);
            const name = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_11__["default"])(col) ? t.columnName(col) : col;
            if (!t.column(name)) ctx.error(node, ERROR_COLUMN);
            return name;
          })
        : t.columnNames()
    );
  } else {
    node.callee = { type: _ast_constants__WEBPACK_IMPORTED_MODULE_1__.Function, name };
  }
}

function handleDeclaration(node, ctx) {
  if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, node)) {
    ctx.scope.add(node.name);
  } else if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.ArrayPattern, node)) {
    node.elements.forEach(elm => handleDeclaration(elm, ctx));
  } else if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.ObjectPattern, node)) {
    node.properties.forEach(prop => handleDeclaration(prop.value, ctx));
  } else {
    ctx.error(node.id, ERROR_DECLARATION);
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/expression/parse.js":
/*!*******************************************************!*\
  !*** ../node_modules/arquero/src/expression/parse.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ast_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ast/constants */ "../node_modules/arquero/src/expression/ast/constants.js");
/* harmony import */ var _ast_clean__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ast/clean */ "../node_modules/arquero/src/expression/ast/clean.js");
/* harmony import */ var _ast_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ast/util */ "../node_modules/arquero/src/expression/ast/util.js");
/* harmony import */ var _codegen__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./codegen */ "../node_modules/arquero/src/expression/codegen.js");
/* harmony import */ var _compile__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./compile */ "../node_modules/arquero/src/expression/compile.js");
/* harmony import */ var _util_entries__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/entries */ "../node_modules/arquero/src/util/entries.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util/is-object */ "../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _parse_escape__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./parse-escape */ "../node_modules/arquero/src/expression/parse-escape.js");
/* harmony import */ var _parse_expression__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./parse-expression */ "../node_modules/arquero/src/expression/parse-expression.js");












const ANNOTATE = { [_ast_constants__WEBPACK_IMPORTED_MODULE_0__.Column]: 1, [_ast_constants__WEBPACK_IMPORTED_MODULE_0__.Op]: 1 };

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(input, opt = {}) {
  const generate = opt.generate || _codegen__WEBPACK_IMPORTED_MODULE_3__["default"];
  const compiler = opt.compiler || _compile__WEBPACK_IMPORTED_MODULE_4__["default"];
  const params = getParams(opt);
  const fields = {};
  const opcall = {};
  const names = [];
  const exprs = [];
  let fieldId = 0;
  let opId = -1;

  const compileExpr = opt.join ? compiler.join
    : opt.index == 1 ? compiler.expr2
    : compiler.expr;

  // parser context
  const ctx = {
    op(op) {
      const key = opKey(op);
      return opcall[key] || (op.id = ++opId, opcall[key] = op);
    },
    field(node) {
      const code = generate(node);
      return fields[code] || (fields[code] = ++fieldId);
    },
    param(node) {
      return (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_0__.Literal, node)
        ? node.value
        : compiler.param(generate(node), params);
    },
    value(name, node) {
      names.push(name);
      const e = node.escape || (opt.ast
        ? (0,_ast_clean__WEBPACK_IMPORTED_MODULE_1__["default"])(node)
        : compileExpr(generate(node), params));
      exprs.push(e);
      // annotate expression if it is a direct column or op access
      // this permits downstream optimizations
      if (ANNOTATE[node.type] && e !== node && (0,_util_is_object__WEBPACK_IMPORTED_MODULE_8__["default"])(e)) {
        e.field = node.name;
      }
    },
    error(node, msg, note = '') {
      // both expresions and fields are parsed
      // with added code prefixes of length 6!
      const i = node.start - 6;
      const j = node.end - 6;
      const snippet = String(ctx.spec).slice(i, j);
      (0,_util_error__WEBPACK_IMPORTED_MODULE_6__["default"])(`${msg}: "${snippet}"${note}`);
    }
  };

  // copy all options to context, potentially overwriting methods
  Object.assign(ctx, opt, { params });

  // parse each expression
  for (const [name, value] of (0,_util_entries__WEBPACK_IMPORTED_MODULE_5__["default"])(input)) {
    ctx.value(
      name + '',
      value.escape
        ? (0,_parse_escape__WEBPACK_IMPORTED_MODULE_9__["default"])(ctx, value, params)
        : (0,_parse_expression__WEBPACK_IMPORTED_MODULE_10__["default"])(ctx, value)
    );
  }

  // return expression asts if requested
  if (opt.ast) {
    return { names, exprs };
  }

  // compile input field accessors
  const f = [];
  for (const key in fields) {
    f[fields[key]] = compiler.expr(key, params);
  }

  // resolve input fields to operations
  const ops = Object.values(opcall);
  ops.forEach(op => op.fields = op.fields.map(id => f[id]));

  return { names, exprs, ops };
}

function opKey(op) {
  let key = `${op.name}(${op.fields.concat(op.params).join(',')})`;
  if (op.frame) {
    const frame = op.frame.map(v => Number.isFinite(v) ? Math.abs(v) : -1);
    key += `[${frame},${!!op.peers}]`;
  }
  return key;
}

function getParams(opt) {
  return (opt.table ? getTableParams(opt.table)
    : opt.join ? {
        ...getTableParams(opt.join[1]),
        ...getTableParams(opt.join[0])
      }
    : {}) || {};
}

function getTableParams(table) {
  return table && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(table.params) ? table.params() : {};
}

/***/ }),

/***/ "../node_modules/arquero/src/expression/rewrite.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/expression/rewrite.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ast_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ast/constants */ "../node_modules/arquero/src/expression/ast/constants.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");



const dictOps = {
  '==': 1,
  '!=': 1,
  '===': 1,
  '!==': 1
};

/**
 * Rewrite AST node to be a table column reference.
 * Additionally optimizes dictionary column operations.
 * @param {object} ref AST node to rewrite to a column reference.
 * @param {string} name The name of the column.
 * @param {number} index The table index of the column.
 * @param {object} col The actual table column instance.
 * @param {object} op Parent AST node operating on the column reference.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(ref, name, index = 0, col, op) {
  ref.type = _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Column;
  ref.name = name;
  ref.table = index;

  // proceed only if has parent op and is a dictionary column
  if (op && col && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_1__["default"])(col.keyFor)) {
    // get other arg if op is an optimizeable operation
    const lit = dictOps[op.operator]
      ? op.left === ref ? op.right : op.left
      : op.callee && op.callee.name === 'equal'
      ? op.arguments[op.arguments[0] === ref ? 1 : 0]
      : null;

    // rewrite as dictionary lookup if other arg is a literal
    if (lit && lit.type === _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Literal) {
      rewriteDictionary(op, ref, lit, col.keyFor(lit.value));
    }
  }

  return ref;
}

function rewriteDictionary(op, ref, lit, key) {
  if (key < 0) {
    // value not in dictionary, rewrite op as false literal
    op.type = _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Literal;
    op.value = false;
    op.raw = 'false';
  } else {
    // rewrite ref as dict key access
    ref.type = _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Dictionary;

    // rewrite literal as target dict key
    lit.value = key;
    lit.raw = key + '';
  }

  return true;
}

/***/ }),

/***/ "../node_modules/arquero/src/expression/row-object.js":
/*!************************************************************!*\
  !*** ../node_modules/arquero/src/expression/row-object.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ROW_OBJECT: () => (/* binding */ ROW_OBJECT),
/* harmony export */   rowObjectBuilder: () => (/* binding */ rowObjectBuilder),
/* harmony export */   rowObjectCode: () => (/* binding */ rowObjectCode),
/* harmony export */   rowObjectExpression: () => (/* binding */ rowObjectExpression)
/* harmony export */ });
/* harmony import */ var _ast_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ast/constants */ "../node_modules/arquero/src/expression/ast/constants.js");
/* harmony import */ var _codegen__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./codegen */ "../node_modules/arquero/src/expression/codegen.js");
/* harmony import */ var _compile__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./compile */ "../node_modules/arquero/src/expression/compile.js");
/* harmony import */ var _rewrite__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./rewrite */ "../node_modules/arquero/src/expression/rewrite.js");
/* harmony import */ var _util_entries__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/entries */ "../node_modules/arquero/src/util/entries.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-array */ "../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/to-string */ "../node_modules/arquero/src/util/to-string.js");








const ROW_OBJECT = 'row_object';

function rowObjectExpression(node, props) {
  node.type = _ast_constants__WEBPACK_IMPORTED_MODULE_0__.ObjectExpression;

  const p = node.properties = [];
  for (const prop of (0,_util_entries__WEBPACK_IMPORTED_MODULE_4__["default"])(props)) {
    const [name, key] = (0,_util_is_array__WEBPACK_IMPORTED_MODULE_5__["default"])(prop) ? prop : [prop, prop];
    p.push({
      type: _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Property,
      key: { type: _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Literal, raw: (0,_util_to_string__WEBPACK_IMPORTED_MODULE_6__["default"])(key) },
      value: (0,_rewrite__WEBPACK_IMPORTED_MODULE_3__["default"])({ computed: true }, name)
    });
  }

  return node;
}

function rowObjectCode(props) {
  return (0,_codegen__WEBPACK_IMPORTED_MODULE_1__["default"])(rowObjectExpression({}, props));
}

function rowObjectBuilder(props) {
  return _compile__WEBPACK_IMPORTED_MODULE_2__["default"].expr(rowObjectCode(props));
}

/***/ }),

/***/ "../node_modules/arquero/src/format/from-arrow.js":
/*!********************************************************!*\
  !*** ../node_modules/arquero/src/format/from-arrow.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrow_arrow_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../arrow/arrow-table */ "../node_modules/arquero/src/arrow/arrow-table.js");
/* harmony import */ var _arrow_arrow_column__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../arrow/arrow-column */ "../node_modules/arquero/src/arrow/arrow-column.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../helpers/selection */ "../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _table_bit_set__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../table/bit-set */ "../node_modules/arquero/src/table/bit-set.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../table/column-set */ "../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../table/column-table */ "../node_modules/arquero/src/table/column-table.js");







/**
 * Options for Apache Arrow import.
 * @typedef {object} ArrowOptions
 * @property {import('../table/transformable').Select} columns
 *  An ordered set of columns to import. The input may consist of column name
 *  strings, column integer indices, objects with current column names as keys
 *  and new column names as values (for renaming), or selection helper
 *  functions such as {@link all}, {@link not}, or {@link range}.
 */

/**
 * Create a new table backed by an Apache Arrow table instance.
 * @param {object} arrow An Apache Arrow data table or byte buffer.
 * @param {ArrowOptions} options Options for Arrow import.
 * @return {ColumnTable} A new table containing the imported values.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(arrow, options = {}) {
  arrow = (0,_arrow_arrow_table__WEBPACK_IMPORTED_MODULE_0__.from)(arrow);
  const { chunks, length, schema } = arrow;

  // resolve column selection
  const fields = schema.fields.map(f => f.name);
  const sel = (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_2__["default"])({
    columnNames: test => test ? fields.filter(test) : fields.slice(),
    columnIndex: name => fields.indexOf(name)
  }, options.columns || (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_2__.all)());

  // build Arquero columns for backing Arrow columns
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_4__["default"])();
  sel.forEach((name, key) => {
    cols.add(name, (0,_arrow_arrow_column__WEBPACK_IMPORTED_MODULE_1__["default"])(arrow.getColumn(key)));
  });

  // build row filter bit mask as needed
  const bits = arrow.count() !== length ? new _table_bit_set__WEBPACK_IMPORTED_MODULE_3__["default"](length) : null;
  if (bits) {
    let b = 0;
    let c = 0;
    arrow.scan(
      idx => bits.set(b + idx),
      batch => { while (chunks[c] !== batch) b += chunks[c++].length; }
    );
  }

  return new _table_column_table__WEBPACK_IMPORTED_MODULE_5__["default"](cols.data, cols.names, bits);
}

/***/ }),

/***/ "../node_modules/arquero/src/format/from-csv.js":
/*!******************************************************!*\
  !*** ../node_modules/arquero/src/format/from-csv.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _from_text_rows__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./from-text-rows */ "../node_modules/arquero/src/format/from-text-rows.js");
/* harmony import */ var _parse_parse_delimited__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parse/parse-delimited */ "../node_modules/arquero/src/format/parse/parse-delimited.js");
 // eslint-disable-line no-unused-vars




/**
 * Options for CSV parsing.
 * @typedef {object} CSVParseOptions
 * @property {string} [delimiter=','] Single-character delimiter between values.
 * @property {string} [decimal='.'] Single-character numeric decimal separator.
 * @property {boolean} [header=true] Flag to specify presence of header row.
 *  If true, assumes the CSV contains a header row with column names. If false,
 *  indicates the CSV does not contain a header row; columns are given the
 *  names 'col1', 'col2', etc unless the *names* option is specified.
 * @property {string[]} [names] An array of column names to use for header-less
 *  CSV files. This option is ignored if the header option is true.
 * @property {number} [skip=0] The number of lines to skip before reading data.
 * @property {string} [comment] A string used to identify comment lines. Any
 *  lines that start with the comment pattern are skipped.
 * @property {boolean} [autoType=true] Flag for automatic type inference.
 * @property {number} [autoMax=1000] Maximum number of initial values to use
 *  for type inference.
 * @property {Object.<string, (value: string) => any>} [parse] Object of
 *  column parsing options. The object keys should be column names. The object
 *  values should be parsing functions that transform values upon input.
 */

/**
 * Parse a comma-separated values (CSV) string into a table. Other
 * delimiters, such as tabs or pipes ('|'), can be specified using
 * the options argument. By default, automatic type inference is performed
 * for input values; string values that match the ISO standard
 * date format are parsed into JavaScript Date objects. To disable this
 * behavior, set the autoType option to false. To perform custom parsing
 * of input column values, use the parse option.
 * @param {string} text A string in a delimited-value format.
 * @param {CSVParseOptions} options The formatting options.
 * @return {ColumnTable} A new table containing the parsed values.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(text, options = {}) {
  const next = (0,_parse_parse_delimited__WEBPACK_IMPORTED_MODULE_2__["default"])(text, options);
  return (0,_from_text_rows__WEBPACK_IMPORTED_MODULE_1__["default"])(
    next,
    options.header !== false ? next() : options.names,
    options
  );
}

/***/ }),

/***/ "../node_modules/arquero/src/format/from-fixed.js":
/*!********************************************************!*\
  !*** ../node_modules/arquero/src/format/from-fixed.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _from_text_rows__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./from-text-rows */ "../node_modules/arquero/src/format/from-text-rows.js");
/* harmony import */ var _parse_parse_lines__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parse/parse-lines */ "../node_modules/arquero/src/format/parse/parse-lines.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
 // eslint-disable-line no-unused-vars





/**
 * Options for fixed width file parsing.
 * @typedef {object} FixedParseOptions
 * @property {[number, number][]} [positions] Array of start, end indices for
 *  fixed-width columns.
 * @property {number[]} [widths] Array of fixed column widths. This option is
 *  ignored if the positions property is specified.
 * @property {string[]} [names] An array of column names. The array length
 *  should match the length of the positions array. If not specified or
 *  shorter than the positions array, default column names are generated.
 * @property {string} [decimal='.'] Single-character numeric decimal separator.
 * @property {number} [skip=0] The number of lines to skip before reading data.
 * @property {string} [comment] A string used to identify comment lines. Any
 *  lines that start with the comment pattern are skipped.
 * @property {boolean} [autoType=true] Flag for automatic type inference.
 * @property {number} [autoMax=1000] Maximum number of initial values to use
 *  for type inference.
 * @property {Object.<string, (value: string) => any>} [parse] Object of
 *  column parsing options. The object keys should be column names. The object
 *  values should be parsing functions that transform values upon input.
 */

/**
 * Parse a fixed-width file (FWF) string into a table. By default, automatic
 * type inference is performed for input values; string values that match the
 * ISO standard date format are parsed into JavaScript Date objects. To
 * disable this behavior, set the autoType option to false. To perform custom
 * parsing of input column values, use the parse option.
 * @param {string} text A string in a fixed-width file format.
 * @param {FixedParseOptions} options The formatting options.
 * @return {ColumnTable} A new table containing the parsed values.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(text, options = {}) {
  const read = (0,_parse_parse_lines__WEBPACK_IMPORTED_MODULE_2__["default"])(text, options);
  const p = positions(options);
  return (0,_from_text_rows__WEBPACK_IMPORTED_MODULE_1__["default"])(
    () => {
      const line = read();
      if (line) {
        return p.map(([i, j]) => line.slice(i, j).trim());
      }
    },
    options.names,
    options
  );
}

function positions({ positions, widths }) {
  if (!positions && !widths) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])('Fixed width files require a "positions" or "widths" option');
  }
  let i = 0;
  return positions || widths.map(w => [i, i += w]);
}

/***/ }),

/***/ "../node_modules/arquero/src/format/from-json.js":
/*!*******************************************************!*\
  !*** ../node_modules/arquero/src/format/from-json.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _util_default_true__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/default-true */ "../node_modules/arquero/src/util/default-true.js");
/* harmony import */ var _util_is_array_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-array-type */ "../node_modules/arquero/src/util/is-array-type.js");
/* harmony import */ var _util_is_digit_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-digit-string */ "../node_modules/arquero/src/util/is-digit-string.js");
/* harmony import */ var _util_is_iso_date_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-iso-date-string */ "../node_modules/arquero/src/util/is-iso-date-string.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-object */ "../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-string */ "../node_modules/arquero/src/util/is-string.js");








/**
 * Options for JSON parsing.
 * @typedef {object} JSONParseOptions
 * @property {boolean} [autoType=true] Flag controlling automatic type
 *  inference. If false, date parsing for input JSON strings is disabled.
 * @property {Object.<string, (value: any) => any>} [parse] Object of column
 *  parsing options. The object keys should be column names. The object values
 *  should be parsing functions that transform values upon input.
 */

/**
 * Parse JavaScript Object Notation (JSON) data into a table.
 * The expected JSON data format is an object with column names for keys
 * and column value arrays for values. By default string values that match
 * the ISO standard date format are parsed into JavaScript Date objects.
 * To disable this behavior, set the autoType option to false. To perform
 * custom parsing of input column values, use the parse option. Auto-type
 * parsing is not performed for columns with custom parse options.
 * The data payload can also be provided as the "data" property of an
 * enclosing object, with an optional "schema" property containing table
 * metadata such as a "fields" array of ordered column information.
 * @param {string|object} data A string in JSON format, or pre-parsed object.
 * @param {JSONParseOptions} options The formatting options.
 * @return {ColumnTable} A new table containing the parsed values.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(json, options = {}) {
  const autoType = (0,_util_default_true__WEBPACK_IMPORTED_MODULE_1__["default"])(options.autoType);

  // parse string input
  if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_6__["default"])(json)) {
    json = JSON.parse(json);
  }

  // separate schema and data, as needed
  let data = json.data, names;
  if ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_5__["default"])(data) && !(0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_2__["default"])(data)) {
    if (json.schema && json.schema.fields) {
      names = json.schema.fields.map(f => f.name);
    }
  } else {
    data = json;
  }

  // parse values as necessary
  if (autoType || options.parse) {
    const parsers = options.parse || {};
    for (const name in data) {
      const col = data[name];
      const len = col.length;
      if (parsers[name]) {
        // apply custom parser
        for (let i = 0; i < len; ++i) {
          col[i] = parsers[name](col[i]);
        }
      } else if (autoType) {
        // apply autoType parser
        for (let i = 0; i < len; ++i) {
          const val = col[i];
          if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_6__["default"])(val) && (0,_util_is_iso_date_string__WEBPACK_IMPORTED_MODULE_4__["default"])(val) && !(0,_util_is_digit_string__WEBPACK_IMPORTED_MODULE_3__["default"])(val)) {
            col[i] = new Date(val);
          }
        }
      }
    }
  }

  return new _table_column_table__WEBPACK_IMPORTED_MODULE_0__["default"](data, names);
}

/***/ }),

/***/ "../node_modules/arquero/src/format/from-text-rows.js":
/*!************************************************************!*\
  !*** ../node_modules/arquero/src/format/from-text-rows.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _util_identity__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/identity */ "../node_modules/arquero/src/util/identity.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_repeat__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/repeat */ "../node_modules/arquero/src/util/repeat.js");
/* harmony import */ var _util_parse_values__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/parse-values */ "../node_modules/arquero/src/util/parse-values.js");






function defaultNames(n, off = 0) {
  return (0,_util_repeat__WEBPACK_IMPORTED_MODULE_3__["default"])(n - off, i => `col${i + off + 1}`);
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(next, names, options) {
  let row = next();
  const n = row.length;
  const automax = +options.autoMax || 1000;
  const values = (0,_util_repeat__WEBPACK_IMPORTED_MODULE_3__["default"])(n, () => []);
  names = names
    ? names.length < n ? [...names, defaultNames(n, names.length)] : names
    : defaultNames(n);

  // read in initial rows to guess types
  let idx = 0;
  for (; idx < automax && row; ++idx, row = next()) {
    for (let i = 0; i < n; ++i) {
      values[i].push(row[i] === '' ? null : row[i]);
    }
  }

  // initialize parsers
  const parsers = getParsers(names, values, options);

  // apply parsers
  parsers.forEach((parse, i) => {
    if (parse === _util_identity__WEBPACK_IMPORTED_MODULE_1__["default"]) return;
    const v = values[i];
    for (let r = 0; r < idx; ++r) {
      if (v[r] != null) v[r] = parse(v[r]);
    }
  });

  // parse remainder of file
  for (; row; row = next()) {
    for (let i = 0; i < n; ++i) {
      values[i].push(row[i] ? parsers[i](row[i]) : null);
    }
  }

  const columns = {};
  names.forEach((name, i) => columns[name] = values[i]);
  return new _table_column_table__WEBPACK_IMPORTED_MODULE_0__["default"](columns, names);
}

function getParsers(names, values, options) {
  const { parse = {} } = options;
  const noParse = options.autoType === false;

  return names.map(
    (name, i) => (0,_util_is_function__WEBPACK_IMPORTED_MODULE_2__["default"])(parse[name]) ? parse[name]
      : noParse ? _util_identity__WEBPACK_IMPORTED_MODULE_1__["default"]
      : (0,_util_parse_values__WEBPACK_IMPORTED_MODULE_4__["default"])(values[i], options)
  );
}

/***/ }),

/***/ "../node_modules/arquero/src/format/infer.js":
/*!***************************************************!*\
  !*** ../node_modules/arquero/src/format/infer.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/is-date */ "../node_modules/arquero/src/util/is-date.js");


function isExactDateUTC(d) {
  return d.getUTCHours() === 0
    && d.getUTCMinutes() === 0
    && d.getUTCSeconds() === 0
    && d.getUTCMilliseconds() === 0;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(scan, options = {}) {
  let count = 0;
  let nulls = 0;
  let dates = 0;
  let dutcs = 0;
  let nums = 0;
  let digits = 0;

  scan(value => {
    ++count;
    if (value == null) {
      ++nulls;
      return;
    }

    const type = typeof value;
    if (type === 'object' && (0,_util_is_date__WEBPACK_IMPORTED_MODULE_0__["default"])(value)) {
      ++dates;
      if (isExactDateUTC(value)) ++dutcs;
    } else if (type === 'number') {
      ++nums;
      if (value === value &&  (value | 0) !== value) {
        const s = value + '';
        const p = s.indexOf('.');
        if (p >= 0) {
          const e = s.indexOf('e');
          const l = e > 0 ? e : s.length;
          digits = Math.max(digits, l - p - 1);
        }
      }
    }
  });

  return {
    align:  (nulls + nums + dates) / count > 0.5 ? 'r' : 'l',
    format: {
      utc:    dates === dutcs,
      digits: Math.min(digits, options.maxdigits || 6)
    }
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/format/load-url.js":
/*!******************************************************!*\
  !*** ../node_modules/arquero/src/format/load-url.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   load: () => (/* binding */ load),
/* harmony export */   loadArrow: () => (/* binding */ loadArrow),
/* harmony export */   loadCSV: () => (/* binding */ loadCSV),
/* harmony export */   loadFixed: () => (/* binding */ loadFixed),
/* harmony export */   loadJSON: () => (/* binding */ loadJSON)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _from_arrow__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./from-arrow */ "../node_modules/arquero/src/format/from-arrow.js");
/* harmony import */ var _from_csv__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./from-csv */ "../node_modules/arquero/src/format/from-csv.js");
/* harmony import */ var _from_fixed__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./from-fixed */ "../node_modules/arquero/src/format/from-fixed.js");
/* harmony import */ var _from_json__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./from-json */ "../node_modules/arquero/src/format/from-json.js");
/* harmony import */ var _table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../table */ "../node_modules/arquero/src/table/index.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-array */ "../node_modules/arquero/src/util/is-array.js");
 // eslint-disable-line no-unused-vars








/**
 * Options for file loading.
 * @typedef {object} LoadOptions
 * @property {'arrayBuffer'|'text'|'json'} [as='text'] A string indicating
 *  the data type of the file. One of 'arrayBuffer', 'json', or 'text'.
 * @property {(data: *, options?: object) => ColumnTable} [using] A function
 *  that accepts a data payload (e.g., string or buffer) and an options object
 *  as input and returns an Arquero table (such as fromCSV or fromJSON).
 * @property {object} [fetch] Options to pass to the HTTP fetch method
 *  when loading a URL.
 */

/**
 * Load data from a file and return a Promise for an Arquero table.
 * A specific format parser can be provided with the *using* option,
 * otherwise CSV format is assumed. The options to this method are
 * passed as the second argument to the format parser.
 * @param {string} url The URL to load.
 * @param {LoadOptions & object} options The loading and formatting options.
 * @return {Promise<ColumnTable>} A Promise for an Arquero table.
 * @example aq.load('data/table.csv')
 * @example aq.load('data/table.json', { using: aq.fromJSON })
 * @example aq.load('data/table.json', { using: aq.from })
 */
function load(url, options = {}) {
  const parse = options.using || _from_csv__WEBPACK_IMPORTED_MODULE_2__["default"];
  return fetch(url, options.fetch)
    .then(res => res[options.as || 'text']())
    .then(data => parse(data, options));
}

/**
 * Load an Arrow file from a URL and return a Promise for an Arquero table.
 * @param {string} url The URL to load.
 * @param {LoadOptions & import('./from-arrow').ArrowOptions} options Arrow format options.
 * @return {Promise<ColumnTable>} A Promise for an Arquero table.
 * @example aq.loadArrow('data/table.arrow')
 */
function loadArrow(url, options) {
  return load(url, { ...options, as: 'arrayBuffer', using: _from_arrow__WEBPACK_IMPORTED_MODULE_1__["default"] });
}

/**
 * Load a CSV file from a URL and return a Promise for an Arquero table.
 * @param {string} url The URL to load.
 * @param {LoadOptions & import('./from-csv').CSVParseOptions} options CSV format options.
 * @return {Promise<ColumnTable>} A Promise for an Arquero table.
 * @example aq.loadCSV('data/table.csv')
 * @example aq.loadTSV('data/table.tsv', { delimiter: '\t' })
 */
function loadCSV(url, options) {
  return load(url, { ...options, as: 'text', using: _from_csv__WEBPACK_IMPORTED_MODULE_2__["default"] });
}

/**
 * Load a fixed width file from a URL and return a Promise for an Arquero table.
 * @param {string} url The URL to load.
 * @param {LoadOptions & import('./from-fixed').FixedParseOptions} options Fixed width format options.
 * @return {Promise<ColumnTable>} A Promise for an Arquero table.
 * @example aq.loadFixedWidth('data/table.txt', { names: ['name', 'city', state'], widths: [10, 20, 2] })
 */
 function loadFixed(url, options) {
  return load(url, { ...options, as: 'text', using: _from_fixed__WEBPACK_IMPORTED_MODULE_3__["default"] });
}

/**
 * Load a JSON file from a URL and return a Promise for an Arquero table.
 * If the loaded JSON is array-valued, an array-of-objects format is assumed
 * and the aq.from method is used to construct the table. Otherwise, a
 * column object format is assumed and aq.fromJSON is applied.
 * @param {string} url The URL to load.
 * @param {LoadOptions & import('./from-json').JSONParseOptions} options JSON format options.
 * @return {Promise<ColumnTable>} A Promise for an Arquero table.
 * @example aq.loadJSON('data/table.json')
 */
function loadJSON(url, options) {
  return load(url, { ...options, as: 'json', using: parseJSON });
}

function parseJSON(data, options) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(data) ? (0,_table__WEBPACK_IMPORTED_MODULE_5__.from)(data) : (0,_from_json__WEBPACK_IMPORTED_MODULE_4__["default"])(data, options);
}

/***/ }),

/***/ "../node_modules/arquero/src/format/parse/constants.js":
/*!*************************************************************!*\
  !*** ../node_modules/arquero/src/format/parse/constants.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EOF: () => (/* binding */ EOF),
/* harmony export */   EOL: () => (/* binding */ EOL),
/* harmony export */   NEWLINE: () => (/* binding */ NEWLINE),
/* harmony export */   QUOTE: () => (/* binding */ QUOTE),
/* harmony export */   RETURN: () => (/* binding */ RETURN)
/* harmony export */ });
const EOL = {};
const EOF = {};
const QUOTE = 34;
const NEWLINE = 10;
const RETURN = 13;

/***/ }),

/***/ "../node_modules/arquero/src/format/parse/parse-delimited.js":
/*!*******************************************************************!*\
  !*** ../node_modules/arquero/src/format/parse/parse-delimited.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../node_modules/arquero/src/format/parse/constants.js");
/* harmony import */ var _text_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./text-filter */ "../node_modules/arquero/src/format/parse/text-filter.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/error */ "../node_modules/arquero/src/util/error.js");




// Adapted from d3-dsv: https://github.com/d3/d3-dsv/blob/master/src/dsv.js
// Copyright 2013-2016 Mike Bostock
// All rights reserved.
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, this
//   list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution.
// * Neither the name of the author nor the names of contributors may be used to
//   endorse or promote products derived from this software without specific prior
//   written permission.
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
// ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
// ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(text, { delimiter = ',', skip, comment }) {
  if (delimiter.length !== 1) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])(`Text "delimiter" should be a single character, found "${delimiter}"`);
  }
  const delimCode = delimiter.charCodeAt(0);

  let N = text.length;
  let I = 0; // current character index
  let t; // current token
  let eof = N <= 0; // current token followed by EOF?
  let eol = false; // current token followed by EOL?

  // Strip the trailing newline.
  if (text.charCodeAt(N - 1) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) --N;
  if (text.charCodeAt(N - 1) === _constants__WEBPACK_IMPORTED_MODULE_0__.RETURN) --N;

  function token() {
    if (eof) return _constants__WEBPACK_IMPORTED_MODULE_0__.EOF;
    if (eol) return eol = false, _constants__WEBPACK_IMPORTED_MODULE_0__.EOL;

    // Unescape quotes.
    const j = I;
    let i, c;
    if (text.charCodeAt(j) === _constants__WEBPACK_IMPORTED_MODULE_0__.QUOTE) {
      while (I++ < N && text.charCodeAt(I) !== _constants__WEBPACK_IMPORTED_MODULE_0__.QUOTE || text.charCodeAt(++I) === _constants__WEBPACK_IMPORTED_MODULE_0__.QUOTE);
      if ((i = I) >= N) eof = true;
      else if ((c = text.charCodeAt(I++)) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) eol = true;
      else if (c === _constants__WEBPACK_IMPORTED_MODULE_0__.RETURN) { eol = true; if (text.charCodeAt(I) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) ++I; }
      return text.slice(j + 1, i - 1).replace(/""/g, '"');
    }

    // Find next delimiter or newline.
    while (I < N) {
      if ((c = text.charCodeAt(i = I++)) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) eol = true;
      else if (c === _constants__WEBPACK_IMPORTED_MODULE_0__.RETURN) { eol = true; if (text.charCodeAt(I) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) ++I; }
      else if (c !== delimCode) continue;
      return text.slice(j, i);
    }

    // Return last token before EOF.
    return eof = true, text.slice(j, N);
  }

  function next() {
    if ((t = token()) !== _constants__WEBPACK_IMPORTED_MODULE_0__.EOF) {
      const row = [];
      while (t !== _constants__WEBPACK_IMPORTED_MODULE_0__.EOL && t !== _constants__WEBPACK_IMPORTED_MODULE_0__.EOF) row.push(t), t = token();
      return row;
    }
  }

  return (0,_text_filter__WEBPACK_IMPORTED_MODULE_1__["default"])(
    next, skip,
    comment && (x => (x && x[0] || '').startsWith(comment))
  );
}

/***/ }),

/***/ "../node_modules/arquero/src/format/parse/parse-lines.js":
/*!***************************************************************!*\
  !*** ../node_modules/arquero/src/format/parse/parse-lines.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../node_modules/arquero/src/format/parse/constants.js");
/* harmony import */ var _text_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./text-filter */ "../node_modules/arquero/src/format/parse/text-filter.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(text, { skip, comment }) {
  let N = text.length;
  let I = 0; // current character index

  // Strip the trailing newline.
  if (text.charCodeAt(N - 1) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) --N;
  if (text.charCodeAt(N - 1) === _constants__WEBPACK_IMPORTED_MODULE_0__.RETURN) --N;

  function read() {
    if (I >= N) return;

    const j = I;
    let eol = false;
    let i, c;

    // Find next newline.
    while (I < N) {
      if ((c = text.charCodeAt(i = I++)) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) eol = true;
      else if (c === _constants__WEBPACK_IMPORTED_MODULE_0__.RETURN) { eol = true; if (text.charCodeAt(I) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) ++I; }
      if (eol) return text.slice(j, i);
    }

    // Return last line before EOF.
    return text.slice(j, N);
  }

  return (0,_text_filter__WEBPACK_IMPORTED_MODULE_1__["default"])(
    read, skip,
    comment && (x => (x || '').startsWith(comment))
  );
}

/***/ }),

/***/ "../node_modules/arquero/src/format/parse/text-filter.js":
/*!***************************************************************!*\
  !*** ../node_modules/arquero/src/format/parse/text-filter.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(read, skip, drop) {
  // skip initial lines, if requested
  let s = +skip || 0;
  while (--s >= 0) read();

  // return filtered stream
  return drop ? () => {
    let line;
    while (!line) {
      if (drop(line = read())) line = null;
      else return line;
    }
  } : read;
}


/***/ }),

/***/ "../node_modules/arquero/src/format/to-arrow.js":
/*!******************************************************!*\
  !*** ../node_modules/arquero/src/format/to-arrow.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrow_encode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../arrow/encode */ "../node_modules/arquero/src/arrow/encode/index.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_arrow_encode__WEBPACK_IMPORTED_MODULE_0__["default"]);

/***/ }),

/***/ "../node_modules/arquero/src/format/to-csv.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/format/to-csv.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/format/util.js");
/* harmony import */ var _util_format_date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/format-date */ "../node_modules/arquero/src/util/format-date.js");
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-date */ "../node_modules/arquero/src/util/is-date.js");
 // eslint-disable-line no-unused-vars





/**
 * Options for CSV formatting.
 * @typedef {object} CSVFormatOptions
 * @property {string} [delimiter=','] The delimiter between values.
 * @property {number} [limit=Infinity] The maximum number of rows to print.
 * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
 * @property {import('./util').ColumnSelectOptions} [columns] Ordered list
 *  of column names to include. If function-valued, the function should
 *  accept a table as input and return an array of column name strings.
 * @property {Object.<string, (value: any) => any>} [format] Object of column
 *  format options. The object keys should be column names. The object values
 *  should be formatting functions to invoke to transform column values prior
 *  to output. If specified, these override automatically inferred options.
 */

/**
 * Format a table as a comma-separated values (CSV) string. Other
 * delimiters, such as tabs or pipes ('|'), can be specified using
 * the options argument.
 * @param {ColumnTable} table The table to format.
 * @param {CSVFormatOptions} options The formatting options.
 * @return {string} A delimited-value format string.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, options = {}) {
  const names = (0,_util__WEBPACK_IMPORTED_MODULE_1__.columns)(table, options.columns);
  const format = options.format || {};
  const delim = options.delimiter || ',';
  const reFormat = new RegExp(`["${delim}\n\r]`);

  const formatValue = value => value == null ? ''
    : (0,_util_is_date__WEBPACK_IMPORTED_MODULE_3__["default"])(value) ? (0,_util_format_date__WEBPACK_IMPORTED_MODULE_2__.formatUTCDate)(value, true)
    : reFormat.test(value += '') ? '"' + value.replace(/"/g, '""') + '"'
    : value;

  const vals = names.map(formatValue);
  let text = '';

  (0,_util__WEBPACK_IMPORTED_MODULE_1__.scan)(table, names, options.limit || Infinity, options.offset, {
    row() {
      text += vals.join(delim) + '\n';
    },
    cell(value, name, index) {
      vals[index] = formatValue(format[name] ? format[name](value) : value);
    }
  });

  return text + vals.join(delim);
}

/***/ }),

/***/ "../node_modules/arquero/src/format/to-html.js":
/*!*****************************************************!*\
  !*** ../node_modules/arquero/src/format/to-html.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _value__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./value */ "../node_modules/arquero/src/format/value.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/format/util.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_map_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/map-object */ "../node_modules/arquero/src/util/map-object.js");
 // eslint-disable-line no-unused-vars






/**
 * Null format function.
 * @callback NullFormat
 * @param {null|undefined} [value] The value to format.
 * @return {string} The formatted HTML string.
 */

/**
 * CSS style function.
 * @callback StyleFunction
 * @param {string} name The column name.
 * @param {number} row The table row index.
 * @return {string} A CSS style string.
 */

/**
 * CSS style options.
 * @typedef {Object.<string, string | StyleFunction>} StyleOptions
 */

/**
 * Options for HTML formatting.
 * @typedef {object} HTMLFormatOptions
 * @property {number} [limit=Infinity] The maximum number of rows to print.
 * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
 * @property {import('./util').ColumnSelectOptions} [columns] Ordered list
 *  of column names to include. If function-valued, the function should
 *  accept a table as input and return an array of column name strings.
 * @property {import('./util').ColumnAlignOptions} [align] Object of column
 *  alignment options. The object keys should be column names. The object
 *  values should be aligment strings, one of 'l' (left), 'c' (center), or
 *  'r' (right). If specified, these override automatically inferred options.
 * @property {import('./util').ColumnFormatOptions} [format] Object of column
 *  format options. The object keys should be column names. The object values
 *  should be formatting functions or specification objects. If specified,
 *  these override automatically inferred options.
 * @property {NullFormat} [null] Format function for null or undefined values.
 *  If specified, this function will be invoked with the null or undefined
 *  value as the sole input, and the return value will be used as the HTML
 *  output for the value.
 * @property {StyleOptions} [style] CSS styles to include in HTML output.
 *  The object keys should be HTML table tag names: 'table', 'thead',
 *  'tbody', 'tr', 'th', or 'td'. The object values should be strings of
 *  valid CSS style directives (such as "font-weight: bold;") or functions
 *  that take a column name and row as inputs and return a CSS string.
 * @property {number} [maxdigits=6] The maximum number of fractional digits
 *  to include when formatting numbers. This option is passed to the format
 *  inference method and is overridden by any explicit format options.
 */

/**
 * Format a table as an HTML table string.
 * @param {ColumnTable} table The table to format.
 * @param {HTMLFormatOptions} options The formatting options.
 * @return {string} An HTML table string.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, options = {}) {
  const names = (0,_util__WEBPACK_IMPORTED_MODULE_2__.columns)(table, options.columns);
  const { align, format } = (0,_util__WEBPACK_IMPORTED_MODULE_2__.formats)(table, names, options);
  const style = styles(options);
  const nullish = options.null;

  const alignValue = a => a === 'c' ? 'center' : a === 'r' ? 'right' : 'left';
  const escape = s => s.replace(/&/g, '&amp;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;');
  const baseFormat = (value, opt) => escape((0,_value__WEBPACK_IMPORTED_MODULE_1__["default"])(value, opt));
  const formatter = nullish
    ? (value, opt) => value == null ? nullish(value) : baseFormat(value, opt)
    : baseFormat;

  let r = -1;
  let idx = -1;

  const tag = (tag, name, shouldAlign) => {
    const a = shouldAlign ? alignValue(align[name]) : '';
    const s = style[tag] ? (style[tag](name, idx, r) || '') : '';
    const css = (a ? (`text-align: ${a};` + (s ? ' ' : '')) : '') + s;
    return `<${tag}${css ? ` style="${css}"` : ''}>`;
  };

  let text = tag('table')
    + tag('thead')
    + tag('tr', r)
    + names.map(name => `${tag('th', name, 1)}${name}</th>`).join('')
    + '</tr></thead>'
    + tag('tbody');

  (0,_util__WEBPACK_IMPORTED_MODULE_2__.scan)(table, names, options.limit, options.offset, {
    row(row) {
      r = row;
      text += (++idx ? '</tr>' : '') + tag('tr');
    },
    cell(value, name) {
      text += tag('td', name, 1)
        + formatter(value, format[name])
        + '</td>';
    }
  });

  return text + '</tr></tbody></table>';
}

function styles(options) {
  return (0,_util_map_object__WEBPACK_IMPORTED_MODULE_4__["default"])(
    options.style,
    value => (0,_util_is_function__WEBPACK_IMPORTED_MODULE_3__["default"])(value) ? value : () => value
  );
}

/***/ }),

/***/ "../node_modules/arquero/src/format/to-json.js":
/*!*****************************************************!*\
  !*** ../node_modules/arquero/src/format/to-json.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/format/util.js");
/* harmony import */ var _util_format_date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/format-date */ "../node_modules/arquero/src/util/format-date.js");
/* harmony import */ var _util_default_true__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/default-true */ "../node_modules/arquero/src/util/default-true.js");
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-date */ "../node_modules/arquero/src/util/is-date.js");
 // eslint-disable-line no-unused-vars






/**
 * Options for JSON formatting.
 * @typedef {object} JSONFormatOptions
 * @property {number} [limit=Infinity] The maximum number of rows to print.
 * @property {number} [offset=0] The row offset indicating how many initial
 *  rows to skip.
 * @property {boolean} [schema=true] Flag indicating if table schema metadata
 *  should be included in the JSON output. If false, only the data payload
 *  is included.
 * @property {import('./util').ColumnSelectOptions} [columns] Ordered list
 *  of column names to include. If function-valued, the function should
 *  accept a table as input and return an array of column name strings.
 * @property {Object.<string, (value: any) => any>} [format] Object of column
 *  format options. The object keys should be column names. The object values
 *  should be formatting functions to invoke to transform column values prior
 *  to output. If specified, these override automatically inferred options.
 */

const defaultFormatter = value => (0,_util_is_date__WEBPACK_IMPORTED_MODULE_4__["default"])(value)
  ? (0,_util_format_date__WEBPACK_IMPORTED_MODULE_2__.formatUTCDate)(value, true)
  : value;

/**
 * Format a table as a JavaScript Object Notation (JSON) string.
 * @param {ColumnTable} table The table to format.
 * @param {JSONFormatOptions} options The formatting options.
 * @return {string} A JSON string.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, options = {}) {
  const schema = (0,_util_default_true__WEBPACK_IMPORTED_MODULE_3__["default"])(options.schema);
  const format = options.format || {};
  const names = (0,_util__WEBPACK_IMPORTED_MODULE_1__.columns)(table, options.columns);
  let text = '{';

  if (schema) {
    text += '"schema":{"fields":'
      + JSON.stringify(names.map(name => ({ name })))
      + '},"data":{';
  }

  names.forEach((name, i) => {
    text += (i ? ',' : '') + JSON.stringify(name) + ':[';

    const column = table.column(name);
    const formatter = format[name] || defaultFormatter;
    let r = -1;
    table.scan(row => {
      const value = column.get(row);
      text += (++r ? ',' : '') + JSON.stringify(formatter(value));
    }, true, options.limit, options.offset);

    text += ']';
  });

  return text + '}' + (schema ? '}' : '');
}

/***/ }),

/***/ "../node_modules/arquero/src/format/to-markdown.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/format/to-markdown.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _value__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./value */ "../node_modules/arquero/src/format/value.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/format/util.js");
 // eslint-disable-line no-unused-vars




/**
 * Options for Markdown formatting.
 * @typedef {object} MarkdownFormatOptions
 * @property {number} [limit=Infinity] The maximum number of rows to print.
 * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
 * @property {import('./util').ColumnSelectOptions} [columns] Ordered list
 *  of column names to include. If function-valued, the function should
 *  accept a table as input and return an array of column name strings.
 * @property {import('./util').ColumnAlignOptions} [align] Object of column
 *  alignment options. The object keys should be column names. The object
 *  values should be aligment strings, one of 'l' (left), 'c' (center), or
 *  'r' (right). If specified, these override automatically inferred options.
 * @property {import('./util').ColumnFormatOptions} [format] Object of column
 *  format options. The object keys should be column names. The object values
 *  should be formatting functions or specification objects. If specified,
 *  these override automatically inferred options.
 * @property {number} [maxdigits=6] The maximum number of fractional digits
 *  to include when formatting numbers. This option is passed to the format
 *  inference method and is overridden by any explicit format options.
 */

/**
 * Format a table as a GitHub-Flavored Markdown table string.
 * @param {ColumnTable} table The table to format.
 * @param {MarkdownFormatOptions} options The formatting options.
 * @return {string} A GitHub-Flavored Markdown table string.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, options = {}) {
  const names = (0,_util__WEBPACK_IMPORTED_MODULE_2__.columns)(table, options.columns);
  const { align, format } = (0,_util__WEBPACK_IMPORTED_MODULE_2__.formats)(table, names, options);

  const alignValue = a => a === 'c' ? ':-:' : a === 'r' ? '-:' : ':-';
  const escape = s => s.replace(/\|/g, '\\|');

  let text = '|'
    + names.map(escape).join('|')
    + '|\n|'
    + names.map(name => alignValue(align[name])).join('|')
    + '|';

  (0,_util__WEBPACK_IMPORTED_MODULE_2__.scan)(table, names, options.limit, options.offset, {
    row() {
      text += '\n|';
    },
    cell(value, name) {
      text += escape((0,_value__WEBPACK_IMPORTED_MODULE_1__["default"])(value, format[name])) + '|';
    }
  });

  return text + '\n';
}

/***/ }),

/***/ "../node_modules/arquero/src/format/util.js":
/*!**************************************************!*\
  !*** ../node_modules/arquero/src/format/util.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   columns: () => (/* binding */ columns),
/* harmony export */   formats: () => (/* binding */ formats),
/* harmony export */   scan: () => (/* binding */ scan)
/* harmony export */ });
/* harmony import */ var _table_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/table */ "../node_modules/arquero/src/table/table.js");
/* harmony import */ var _infer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./infer */ "../node_modules/arquero/src/format/infer.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");
 // eslint-disable-line no-unused-vars




/**
 * Column selection function.
 * @typedef {(table: Table) => string[]} ColumnSelectFunction
 */

/**
 * Column selection options.
 * @typedef {string[]|ColumnSelectFunction} ColumnSelectOptions
 */

/**
 * Column format options. The object keys should be column names.
 * The object values should be formatting functions or objects.
 * If specified, these override any automatically inferred options.
 * @typedef {Object.<string, import('./value').ValueFormatOptions} ColumnFormatOptions
 */

/**
 * Column alignment options. The object keys should be column names.
 * The object values should be aligment strings, one of 'l' (left),
 * 'c' (center), or 'r' (right).
 * If specified, these override any automatically inferred options.
 * @typedef {Object.<string, 'l'|'c'|'r'>} ColumnAlignOptions
 */

function columns(table, names) {
  return (0,_util_is_function__WEBPACK_IMPORTED_MODULE_2__["default"])(names)
    ? names(table)
    : names || table.columnNames();
}

function formats(table, names, options) {
  const formatOpt = options.format || {};
  const alignOpt = options.align || {};
  const format = {};
  const align = {};

  names.forEach(name => {
    const auto = (0,_infer__WEBPACK_IMPORTED_MODULE_1__["default"])(values(table, name), options);
    align[name] = alignOpt[name] || auto.align;
    format[name] = formatOpt[name] || auto.format;
  });

  return { align, format };
}

function values(table, columnName) {
  const column = table.column(columnName);
  return fn => table.scan(row => fn(column.get(row)));
}

function scan(table, names, limit = 100, offset, ctx) {
  const data = table.data();
  const n = names.length;
  table.scan(row => {
    ctx.row(row);
    for (let i = 0; i < n; ++i) {
      const name = names[i];
      ctx.cell(data[names[i]].get(row), name, i);
    }
  }, true, limit, offset);
}

/***/ }),

/***/ "../node_modules/arquero/src/format/value.js":
/*!***************************************************!*\
  !*** ../node_modules/arquero/src/format/value.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_format_date__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/format-date */ "../node_modules/arquero/src/util/format-date.js");
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/is-date */ "../node_modules/arquero/src/util/is-date.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_typed_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-typed-array */ "../node_modules/arquero/src/util/is-typed-array.js");





/**
 * Column format object.
 * @typedef {object} ValueFormatObject
 * @property {boolean} [utc=false] If true, format dates in UTC time.
 * @property {number} [digits=0] The number of fractional digits to include
 *  when formatting numbers.
 * @property {number} [maxlen=30] The maximum string length for formatting
 *  nested object or array values.
 */

/**
 * @callback ValueFormatFunction
 * @param {*} value The value to format.
 * @return {*} A string-coercible or JSON-compatible formatted value.
 */

/**
 * Value format options.
 * @typedef {ValueFormatObject|ValueFormatFunction} ValueFormatOptions
 */

/**
 * Format a value as a string.
 * @param {*} v The value to format.
 * @param {ValueFormatOptions} options Formatting options.
 * @return {string} The formatted string.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(v, options = {}) {
  if ((0,_util_is_function__WEBPACK_IMPORTED_MODULE_2__["default"])(options)) {
    return options(v) + '';
  }

  const type = typeof v;

  if (type === 'object') {
    if ((0,_util_is_date__WEBPACK_IMPORTED_MODULE_1__["default"])(v)) {
      return options.utc ? (0,_util_format_date__WEBPACK_IMPORTED_MODULE_0__.formatUTCDate)(v) : (0,_util_format_date__WEBPACK_IMPORTED_MODULE_0__.formatDate)(v);
    } else {
      const s = JSON.stringify(
        v,
        (k, v) => (0,_util_is_typed_array__WEBPACK_IMPORTED_MODULE_3__["default"])(v) ? Array.from(v) : v
      );
      const maxlen = options.maxlen || 30;
      return s.length > maxlen
        ? s.slice(0, 28) + '\u2026' + (s[0] === '[' ? ']' : '}')
        : s;
    }
  } else if (type === 'number') {
    const digits = options.digits || 0;
    let a;
    return v !== 0 && ((a = Math.abs(v)) >= 1e18 || a < Math.pow(10, -digits))
      ? v.toExponential(digits)
      : v.toFixed(digits);
  } else {
    return v + '';
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/helpers/bin.js":
/*!**************************************************!*\
  !*** ../node_modules/arquero/src/helpers/bin.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Options for binning number values.
 * @typedef {object} BinOptions
 * @property {number} [maxbins] The maximum number of bins.
 * @property {number} [minstep] The minimum step size between bins.
 * @property {number} [step] The exact step size to use between bins.
 *  If specified, the maxbins and minstep options are ignored.
 * @property {boolean} [nice=true] Flag indicating if bins should
 *  snap to "nice" human-friendly values such as multiples of ten.
 * @property {number} [offset=0] Step offset for bin boundaries.
 *  The default floors to the lower bin boundary. A value of 1 snaps
 *  one step higher to the upper bin boundary, and so on.
 */

/**
 * Generate a table expression that performs uniform binning of
 * number values. The resulting string can be used as part of the
 * input to table transformation verbs.
 * @param {string} name The name of the column to bin.
 * @param {BinOptions} [options] Binning scheme options.
 * @return {string} A table expression string for binned values.
 * @example bin('colA', { maxbins: 20 })
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(name, options = {}) {
  const field = `d[${JSON.stringify(name)}]`;
  const { maxbins, nice, minstep, step, offset } = options;
  const args = [maxbins, nice, minstep, step];

  let n = args.length;
  while (n && args[--n] == null) args.pop();
  const a = args.length ? ', ' + args.map(a => a + '').join(', ') : '';

  return `d => op.bin(${field}, ...op.bins(${field}${a}), ${offset || 0})`;
}

/***/ }),

/***/ "../node_modules/arquero/src/helpers/desc.js":
/*!***************************************************!*\
  !*** ../node_modules/arquero/src/helpers/desc.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./wrap */ "../node_modules/arquero/src/helpers/wrap.js");


/**
 * Annotate a table expression to indicate descending sort order.
 * @param {string|Function|object} expr The table expression to annotate.
 * @return {object} A wrapped expression indicating descending sort.
 * @example desc('colA')
 * @example desc(d => d.colA)
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(expr) {
  return (0,_wrap__WEBPACK_IMPORTED_MODULE_0__["default"])(expr, { desc: true });
}

/***/ }),

/***/ "../node_modules/arquero/src/helpers/escape.js":
/*!*****************************************************!*\
  !*** ../node_modules/arquero/src/helpers/escape.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./wrap */ "../node_modules/arquero/src/helpers/wrap.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");



/**
 * Escape a function or value to prevent it from being parsed and recompiled.
 * This helper can be used in lieu of single-table table expressions (which
 * are internally parsed and rewritten) to apply a JavaScript function as-is,
 * including support for closures. It can also be used to pass a constant,
 * literal value as a table expression, bypassing the parser.
 * @param {*} value A function or value to escape.
 * @return {object} A wrapper object representing the escaped value.
 * @example escape(d => d.a.toFixed(2))
 * @example escape(d => d.a * -d.b)
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return (0,_wrap__WEBPACK_IMPORTED_MODULE_0__["default"])(value, {
    escape: true,
    toString() { (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Escaped values can not be serialized.'); }
  });
}

/***/ }),

/***/ "../node_modules/arquero/src/helpers/field.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/helpers/field.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./wrap */ "../node_modules/arquero/src/helpers/wrap.js");


/**
 * Annotate an expression to indicate it is a string field reference.
 * @param {string|object} expr The column name, or an existing wrapped
 *  expression for a column name.
 * @param {string} [name] The column name to use. If provided, will
 *  overwrite the input expression value.
 * @param {number} [table=0] The table index of the field, in case of
 *  expressions over multiple tables.
 * @return A wrapped expression for a named column.
 * @example field('colA')
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(expr, name, table = 0) {
  const props = table ? { field: true, table } : { field: true };
  return (0,_wrap__WEBPACK_IMPORTED_MODULE_0__["default"])(
    expr,
    name ? { expr: name, ...props } : props
  );
}

/***/ }),

/***/ "../node_modules/arquero/src/helpers/frac.js":
/*!***************************************************!*\
  !*** ../node_modules/arquero/src/helpers/frac.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Generate a table expression that computes the number of rows
 * corresponding to a given fraction for each group. The resulting
 * string can be used as part of the input to the sample verb.
 * @param {number} fraction The fractional value.
 * @return {string} A table expression string for computing row counts.
 * @example frac(0.5)
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(fraction) {
  return `() => op.round(${+fraction} * op.count())`;
}

/***/ }),

/***/ "../node_modules/arquero/src/helpers/names.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/helpers/names.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Select columns by index and rename them to the provided names. Returns a
 * selection helper function that takes a table as input and produces a
 * rename map as output. If the number of provided names is less than the
 * number of table columns, the rename map will only include entries for the
 * provided names. If the number of table columns is less than then number of
 * provided names, only the rename map will only include entries that cover
 * the existing columns.
 * @param {...(string|string[])} names An ordered list of column names.
 * @return {Function} Selection function compatible with {@link Table#select}.
 * @example table.rename(aq.names('a', 'b', 'c'))
 * @example table.select(aq.names(['a', 'b', 'c']))
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(...names) {
  names = names.flat();
  return table => {
    const m = new Map();
    const n = Math.min(names.length, table.numCols());
    for (let i = 0; i < n; ++i) {
      m.set(table.columnName(i), names[i]);
    }
    return m;
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/helpers/rolling.js":
/*!******************************************************!*\
  !*** ../node_modules/arquero/src/helpers/rolling.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./wrap */ "../node_modules/arquero/src/helpers/wrap.js");


/**
 * Annotate a table expression to compute rolling aggregate or window
 * functions within a sliding window frame. For example, to specify a
 * rolling 7-day average centered on the current day, use rolling with
 * a frame value of [-3, 3].
 * @param {string|Function|object} expr The table expression to annotate.
 * @param {[number?, number?]} [frame=[-Infinity, 0]] The sliding window frame
 *  offsets. Each entry indicates an offset from the current value. If an
 *  entry is non-finite, the frame will be unbounded in that direction,
 *  including all preceding or following values. If unspecified, the frame
 *  will include the current values and all preceding values.
 * @param {boolean} [includePeers=false] Indicates if the sliding window frame
 *  should ignore peer (tied) values. If false (the default), the window frame
 *  boundaries are insensitive to peer values. If `true`, the window frame
 *  expands to include all peers. This parameter only affects operations that
 *  depend on the window frame: aggregate functions and the first_value,
 *  last_value, and nth_value window functions.
 * @return A new wrapped expression annotated with rolling window parameters.
 * @example rolling(d => mean(d.colA), [-3, 3])
 * @example rolling(d => last_value(d.colA), null, true)
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(expr, frame, includePeers) {
  return (0,_wrap__WEBPACK_IMPORTED_MODULE_0__["default"])(expr, {
    window: {
      frame: frame || [-Infinity, 0],
      peers: !!includePeers
    }
  });
}

/***/ }),

/***/ "../node_modules/arquero/src/helpers/selection.js":
/*!********************************************************!*\
  !*** ../node_modules/arquero/src/helpers/selection.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   all: () => (/* binding */ all),
/* harmony export */   "default": () => (/* binding */ resolve),
/* harmony export */   endswith: () => (/* binding */ endswith),
/* harmony export */   matches: () => (/* binding */ matches),
/* harmony export */   not: () => (/* binding */ not),
/* harmony export */   range: () => (/* binding */ range),
/* harmony export */   startswith: () => (/* binding */ startswith)
/* harmony export */ });
/* harmony import */ var _util_assign__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/assign */ "../node_modules/arquero/src/util/assign.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_escape_regexp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/escape-regexp */ "../node_modules/arquero/src/util/escape-regexp.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-array */ "../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-number */ "../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-object */ "../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/is-string */ "../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util/to-string */ "../node_modules/arquero/src/util/to-string.js");










function resolve(table, sel, map = new Map()) {
  sel = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_5__["default"])(sel) ? table.columnName(sel) : sel;

  if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_7__["default"])(sel)) {
    map.set(sel, sel);
  } else if ((0,_util_is_array__WEBPACK_IMPORTED_MODULE_3__["default"])(sel)) {
    sel.forEach(r => resolve(table, r, map));
  } else if ((0,_util_is_function__WEBPACK_IMPORTED_MODULE_4__["default"])(sel)) {
    resolve(table, sel(table), map);
  } else if ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_6__["default"])(sel)) {
    (0,_util_assign__WEBPACK_IMPORTED_MODULE_0__["default"])(map, sel);
  } else {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])(`Invalid column selection: ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_8__["default"])(sel)}`);
  }

  return map;
}

function decorate(value, toObject) {
  value.toObject = toObject;
  return value;
}

function toObject(value) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_3__["default"])(value) ? value.map(toObject)
    : value && value.toObject ? value.toObject()
    : value;
}

/**
 * Proxy type for SelectHelper function.
 * @typedef {import('../table/transformable').SelectHelper} SelectHelper
 */

/**
 * Select all columns in a table.
 * Returns a function-valued selection compatible with {@link Table#select}.
 * @return {SelectHelper} Selection function compatible with select().
 */
function all() {
  return decorate(
    table => table.columnNames(),
    () => ({ all: [] })
  );
}

/**
 * Negate a column selection, selecting all other columns in a table.
 * Returns a function-valued selection compatible with {@link Table#select}.
 * @param {...any} selection The selection to negate. May be a column name,
 *  column index, array of either, or a selection function (e.g., from range).
 * @return {SelectHelper} Selection function compatible with select().
 */
function not(...selection) {
  selection = selection.flat();
  return decorate(
    table => {
      const drop = resolve(table, selection);
      return table.columnNames(name => !drop.has(name));
    },
    () => ({ not: toObject(selection) })
  );
}

/**
 * Select a contiguous range of columns.
 * @param {string|number} start The name/index of the first selected column.
 * @param {string|number} end The name/index of the last selected column.
 * @return {SelectHelper} Selection function compatible with select().
 */
function range(start, end) {
  return decorate(
    table => {
      let i = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_5__["default"])(start) ? start : table.columnIndex(start);
      let j = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_5__["default"])(end) ? end : table.columnIndex(end);
      if (j < i) { const t = j; j = i; i = t; }
      return table.columnNames().slice(i, j + 1);
    },
    () => ({ range: [start, end] })
  );
}

/**
 * Select all columns whose names match a pattern.
 * @param {string|RegExp} pattern A string or regular expression pattern to match.
 * @return {SelectHelper} Selection function compatible with select().
 */
function matches(pattern) {
  if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_7__["default"])(pattern)) pattern = RegExp((0,_util_escape_regexp__WEBPACK_IMPORTED_MODULE_2__["default"])(pattern));
  return decorate(
    table => table.columnNames(name => pattern.test(name)),
    () => ({ matches: [pattern.source, pattern.flags] })
  );
}

/**
 * Select all columns whose names start with a string.
 * @param {string} string The string to match at the start of the column name.
 * @return {SelectHelper} Selection function compatible with select().
 */
function startswith(string) {
  return matches(RegExp('^' + (0,_util_escape_regexp__WEBPACK_IMPORTED_MODULE_2__["default"])(string)));
}

/**
 * Select all columns whose names end with a string.
 * @param {string} string The string to match at the end of the column name.
 * @return {SelectHelper} Selection function compatible with select().
 */
function endswith(string) {
  return matches(RegExp((0,_util_escape_regexp__WEBPACK_IMPORTED_MODULE_2__["default"])(string) + '$'));
}

/***/ }),

/***/ "../node_modules/arquero/src/helpers/slice.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/helpers/slice.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Generate a table expression that filters a table based on ordered row
 * indices from start to end (end not included), where start and end
 * represent per-group ordered row numbers in the table. The resulting
 * string can be used as the input to the filter verb.
 * @param {number} [start] Zero-based index at which to start extraction.
 *  A negative index indicates an offset from the end of the group.
 *  If start is undefined, slice starts from the index 0.
 * @param {number} [end] Zero-based index before which to end extraction.
 *  A negative index indicates an offset from the end of the group.
 *  If end is omitted, slice extracts through the end of the group.
 * @return {string} A table expression string for slicing values.
 * @example slice(1, -1)
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(start = 0, end = Infinity) {
  return `${prep(start)} < row_number() && row_number() <= ${prep(end)}`;
}

function prep(index) {
  return index < 0 ? `count() + ${index}` : index;
}

/***/ }),

/***/ "../node_modules/arquero/src/helpers/wrap.js":
/*!***************************************************!*\
  !*** ../node_modules/arquero/src/helpers/wrap.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");


/**
 * Annotate an expression in an object wrapper.
 * @param {string|Function|object} expr An expression to annotate.
 * @param {object} properties The properties to annotate with.
 * @return {object} A new wrapped expression object.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(expr, properties) {
  return expr && expr.expr
    ? new Wrapper({ ...expr, ...properties })
    : new Wrapper(properties, expr);
}

class Wrapper {
  constructor(properties, expr) {
    this.expr = expr;
    Object.assign(this, properties);
  }
  toString() {
    return String(this.expr);
  }
  toObject() {
    return {
      ...this,
      expr: this.toString(),
      ...((0,_util_is_function__WEBPACK_IMPORTED_MODULE_0__["default"])(this.expr) ? { func: true } : {})
    };
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/index.js":
/*!********************************************!*\
  !*** ../node_modules/arquero/src/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Type: () => (/* reexport safe */ _arrow_arrow_types__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   addAggregateFunction: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addAggregateFunction),
/* harmony export */   addFunction: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addFunction),
/* harmony export */   addPackage: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addPackage),
/* harmony export */   addTableMethod: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addTableMethod),
/* harmony export */   addVerb: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addVerb),
/* harmony export */   addWindowFunction: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addWindowFunction),
/* harmony export */   agg: () => (/* reexport safe */ _verbs_helpers_agg__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   all: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.all),
/* harmony export */   bin: () => (/* reexport safe */ _helpers_bin__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   desc: () => (/* reexport safe */ _helpers_desc__WEBPACK_IMPORTED_MODULE_20__["default"]),
/* harmony export */   endswith: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.endswith),
/* harmony export */   escape: () => (/* reexport safe */ _helpers_escape__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   field: () => (/* reexport safe */ _helpers_field__WEBPACK_IMPORTED_MODULE_21__["default"]),
/* harmony export */   frac: () => (/* reexport safe */ _helpers_frac__WEBPACK_IMPORTED_MODULE_22__["default"]),
/* harmony export */   from: () => (/* reexport safe */ _table__WEBPACK_IMPORTED_MODULE_29__.from),
/* harmony export */   fromArrow: () => (/* reexport safe */ _format_from_arrow__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   fromCSV: () => (/* reexport safe */ _format_from_csv__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   fromFixed: () => (/* reexport safe */ _format_from_fixed__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   fromJSON: () => (/* reexport safe */ _format_from_json__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   internal: () => (/* binding */ internal),
/* harmony export */   load: () => (/* reexport safe */ _format_load_url__WEBPACK_IMPORTED_MODULE_16__.load),
/* harmony export */   loadArrow: () => (/* reexport safe */ _format_load_url__WEBPACK_IMPORTED_MODULE_16__.loadArrow),
/* harmony export */   loadCSV: () => (/* reexport safe */ _format_load_url__WEBPACK_IMPORTED_MODULE_16__.loadCSV),
/* harmony export */   loadFixed: () => (/* reexport safe */ _format_load_url__WEBPACK_IMPORTED_MODULE_16__.loadFixed),
/* harmony export */   loadJSON: () => (/* reexport safe */ _format_load_url__WEBPACK_IMPORTED_MODULE_16__.loadJSON),
/* harmony export */   matches: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.matches),
/* harmony export */   names: () => (/* reexport safe */ _helpers_names__WEBPACK_IMPORTED_MODULE_23__["default"]),
/* harmony export */   not: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.not),
/* harmony export */   op: () => (/* reexport safe */ _op_op_api__WEBPACK_IMPORTED_MODULE_27__["default"]),
/* harmony export */   query: () => (/* reexport safe */ _query_query__WEBPACK_IMPORTED_MODULE_7__.query),
/* harmony export */   queryFrom: () => (/* reexport safe */ _query_query__WEBPACK_IMPORTED_MODULE_7__.queryFrom),
/* harmony export */   range: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.range),
/* harmony export */   rolling: () => (/* reexport safe */ _helpers_rolling__WEBPACK_IMPORTED_MODULE_24__["default"]),
/* harmony export */   seed: () => (/* reexport safe */ _util_random__WEBPACK_IMPORTED_MODULE_10__.seed),
/* harmony export */   startswith: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.startswith),
/* harmony export */   table: () => (/* reexport safe */ _table__WEBPACK_IMPORTED_MODULE_29__.table),
/* harmony export */   toArrow: () => (/* reexport safe */ _arrow_encode__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   version: () => (/* binding */ version)
/* harmony export */ });
/* harmony import */ var _table_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./table/table */ "../node_modules/arquero/src/table/table.js");
/* harmony import */ var _table_column__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./table/column */ "../node_modules/arquero/src/table/column.js");
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _table_transformable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./table/transformable */ "../node_modules/arquero/src/table/transformable.js");
/* harmony import */ var _engine_reduce_reducer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./engine/reduce/reducer */ "../node_modules/arquero/src/engine/reduce/reducer.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./expression/parse */ "../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _expression_ast_walk__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./expression/ast/walk */ "../node_modules/arquero/src/expression/ast/walk.js");
/* harmony import */ var _query_query__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./query/query */ "../node_modules/arquero/src/query/query.js");
/* harmony import */ var _query_verb__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./query/verb */ "../node_modules/arquero/src/query/verb.js");
/* harmony import */ var _package_json__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../package.json */ "../node_modules/arquero/package.json");
/* harmony import */ var _util_random__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./util/random */ "../node_modules/arquero/src/util/random.js");
/* harmony import */ var _arrow_arrow_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./arrow/arrow-types */ "../node_modules/arquero/src/arrow/arrow-types.js");
/* harmony import */ var _format_from_arrow__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./format/from-arrow */ "../node_modules/arquero/src/format/from-arrow.js");
/* harmony import */ var _format_from_csv__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./format/from-csv */ "../node_modules/arquero/src/format/from-csv.js");
/* harmony import */ var _format_from_fixed__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./format/from-fixed */ "../node_modules/arquero/src/format/from-fixed.js");
/* harmony import */ var _format_from_json__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./format/from-json */ "../node_modules/arquero/src/format/from-json.js");
/* harmony import */ var _format_load_url__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./format/load-url */ "../node_modules/arquero/src/format/load-url.js");
/* harmony import */ var _arrow_encode__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./arrow/encode */ "../node_modules/arquero/src/arrow/encode/index.js");
/* harmony import */ var _helpers_bin__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./helpers/bin */ "../node_modules/arquero/src/helpers/bin.js");
/* harmony import */ var _helpers_escape__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./helpers/escape */ "../node_modules/arquero/src/helpers/escape.js");
/* harmony import */ var _helpers_desc__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./helpers/desc */ "../node_modules/arquero/src/helpers/desc.js");
/* harmony import */ var _helpers_field__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./helpers/field */ "../node_modules/arquero/src/helpers/field.js");
/* harmony import */ var _helpers_frac__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./helpers/frac */ "../node_modules/arquero/src/helpers/frac.js");
/* harmony import */ var _helpers_names__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./helpers/names */ "../node_modules/arquero/src/helpers/names.js");
/* harmony import */ var _helpers_rolling__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./helpers/rolling */ "../node_modules/arquero/src/helpers/rolling.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./helpers/selection */ "../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _verbs_helpers_agg__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./verbs/helpers/agg */ "../node_modules/arquero/src/verbs/helpers/agg.js");
/* harmony import */ var _op_op_api__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./op/op-api */ "../node_modules/arquero/src/op/op-api.js");
/* harmony import */ var _register__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./register */ "../node_modules/arquero/src/register.js");
/* harmony import */ var _table__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./table */ "../node_modules/arquero/src/table/index.js");
// export internal class definitions










const internal = {
  Table: _table_table__WEBPACK_IMPORTED_MODULE_0__["default"],
  ColumnTable: _table_column_table__WEBPACK_IMPORTED_MODULE_2__["default"],
  Transformable: _table_transformable__WEBPACK_IMPORTED_MODULE_3__["default"],
  Query: _query_query__WEBPACK_IMPORTED_MODULE_7__["default"],
  Reducer: _engine_reduce_reducer__WEBPACK_IMPORTED_MODULE_4__["default"],
  Verb: _query_verb__WEBPACK_IMPORTED_MODULE_8__.Verb,
  Verbs: _query_verb__WEBPACK_IMPORTED_MODULE_8__.Verbs,
  columnFactory: _table_column__WEBPACK_IMPORTED_MODULE_1__.columnFactory,
  parse: _expression_parse__WEBPACK_IMPORTED_MODULE_5__["default"],
  walk_ast: _expression_ast_walk__WEBPACK_IMPORTED_MODULE_6__["default"]
};

// export public API

const version = _package_json__WEBPACK_IMPORTED_MODULE_9__.version;























/***/ }),

/***/ "../node_modules/arquero/src/op/aggregate-functions.js":
/*!*************************************************************!*\
  !*** ../node_modules/arquero/src/op/aggregate-functions.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_bins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/bins */ "../node_modules/arquero/src/util/bins.js");
/* harmony import */ var _util_distinct_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/distinct-map */ "../node_modules/arquero/src/util/distinct-map.js");
/* harmony import */ var _util_is_bigint__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-bigint */ "../node_modules/arquero/src/util/is-bigint.js");
/* harmony import */ var _util_no_op__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/no-op */ "../node_modules/arquero/src/util/no-op.js");
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/null */ "../node_modules/arquero/src/util/null.js");
/* harmony import */ var _util_product__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/product */ "../node_modules/arquero/src/util/product.js");







/**
 * Initialize an aggregate operator.
 */
function initOp(op) {
  op.init = op.init || _util_no_op__WEBPACK_IMPORTED_MODULE_3__["default"];
  op.add = op.add || _util_no_op__WEBPACK_IMPORTED_MODULE_3__["default"];
  op.rem = op.rem || _util_no_op__WEBPACK_IMPORTED_MODULE_3__["default"];
  return op;
}

function initProduct(s, value) {
  s.product_v = false;
  return s.product = value;
}

/**
 * Initialize an aggregate operator.
 * @callback AggregateInit
 * @param {object} state The aggregate state object.
 * @return {void}
 */

/**
 * Add a value to an aggregate operator.
 * @callback AggregateAdd
 * @param {object} state The aggregate state object.
 * @param {*} value The value to add.
 * @return {void}
 */

/**
 * Remove a value from an aggregate operator.
 * @callback AggregateRem
 * @param {object} state The aggregate state object.
 * @param {*} value The value to remove.
 * @return {void}
 */

/**
 * Retrive an output value from an aggregate operator.
 * @callback AggregateValue
 * @param {object} state The aggregate state object.
 * @return {*} The output value.
 */

/**
 * An operator instance for an aggregate function.
 * @typedef {object} AggregateOperator
 * @property {AggregateInit} init Initialize the operator.
 * @property {AggregateAdd} add Add a value to the operator state.
 * @property {AggregateRem} rem Remove a value from the operator state.
 * @property {AggregateValue} value Retrieve an output value.
 */

/**
 * Create a new aggregate operator instance.
 * @callback AggregateCreate
 * @param {...any} params The aggregate operator parameters.
 * @return {AggregateOperator} The instantiated aggregate operator.
 */

/**
 * An operator definition for an aggregate function.
 * @typedef {object} AggregateDef
 * @property {AggregateCreate} create Create a new operator instance.
 * @property {number[]} param Two-element array containing the
 *  counts of input fields and additional parameters.
 * @property {string[]} [req] Names of operators required by this one.
 * @property {string[]} [stream] Names of operators required by this one
 *  for streaming operations (value removes).
 */

/**
 * Aggregate operator definitions.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /** @type {AggregateDef} */
  count: {
    create: () => initOp({
      value: s => s.count
    }),
    param: []
  },

  /** @type {AggregateDef} */
  array_agg: {
    create: () => initOp({
      init: s => s.values = true,
      value: s => s.list.values(s.stream)
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  object_agg: {
    create: () => initOp({
      init:  s => s.values = true,
      value: s => Object.fromEntries(s.list.values())
    }),
    param: [2]
  },

  /** @type {AggregateDef} */
  map_agg: {
    create: () => initOp({
      init:  s => s.values = true,
      value: s => new Map(s.list.values())
    }),
    param: [2]
  },

  /** @type {AggregateDef} */
  entries_agg: {
    create: () => initOp({
      init:  s => s.values = true,
      value: s => s.list.values(s.stream)
    }),
    param: [2]
  },

  /** @type {AggregateDef} */
  any: {
    create: () => initOp({
      add: (s, v) => { if (s.any == null) s.any = v; },
      value: s => s.valid ? s.any : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  valid: {
    create: () => initOp({
      value: s => s.valid
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  invalid: {
    create: () => initOp({
      value: s => s.count - s.valid
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  distinct: {
    create: () => ({
      init: s => s.distinct = (0,_util_distinct_map__WEBPACK_IMPORTED_MODULE_1__["default"])(),
      value: s => s.distinct.count() + (s.valid === s.count ? 0 : 1),
      add: (s, v) => s.distinct.increment(v),
      rem: (s, v) => s.distinct.decrement(v)
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  array_agg_distinct: {
    create: () => initOp({
      value: s => s.distinct.values()
    }),
    param: [1],
    req: ['distinct']
  },

  /** @type {AggregateDef} */
  mode: {
    create: () => initOp({
      value: s => {
        let mode = _util_null__WEBPACK_IMPORTED_MODULE_4__["default"];
        let max = 0;
        s.distinct.forEach((value, count) => {
          if (count > max) {
            max = count;
            mode = value;
          }
        });
        return mode;
      }
    }),
    param: [1],
    req: ['distinct']
  },

  /** @type {AggregateDef} */
  sum: {
    create: () => ({
      init:  s => s.sum = 0,
      value: s => s.valid ? s.sum : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      add: (s, v) => (0,_util_is_bigint__WEBPACK_IMPORTED_MODULE_2__["default"])(v)
        ? (s.sum === 0 ? s.sum = v : s.sum += v)
        : s.sum += +v,
      rem: (s, v) => s.sum -= v
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  product: {
    create: () => ({
      init:  s => initProduct(s, 1),
      value: s => s.valid
        ? (
            s.product_v
              ? initProduct(s, (0,_util_product__WEBPACK_IMPORTED_MODULE_5__["default"])(s.list.values()))
              : s.product
          )
        : undefined,
      add: (s, v) => (0,_util_is_bigint__WEBPACK_IMPORTED_MODULE_2__["default"])(v)
        ? (s.product === 1 ? s.product = v : s.product *= v)
        : s.product *= v,
      rem: (s, v) => (v == 0 || v === Infinity || v === -Infinity)
        ? s.product_v = true
        : s.product /= v
    }),
    param: [1],
    stream: ['array_agg']
  },

  /** @type {AggregateDef} */
  mean: {
    create: () => ({
      init: s => s.mean = 0,
      value: s => s.valid ? s.mean : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      add: (s, v) => {
        s.mean_d = v - s.mean;
        s.mean += s.mean_d / s.valid;
      },
      rem: (s, v) => {
        s.mean_d = v - s.mean;
        s.mean -= s.valid ? s.mean_d / s.valid : s.mean;
      }
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  average: {
    create: () => initOp({
      value: s => s.valid ? s.mean : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [1],
    req: ['mean']
  },

  /** @type {AggregateDef} */
  variance: {
    create: () => ({
      init:  s => s.dev = 0,
      value: s => s.valid > 1 ? s.dev / (s.valid - 1) : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      add: (s, v) => s.dev += s.mean_d * (v - s.mean),
      rem: (s, v) => s.dev -= s.mean_d * (v - s.mean)
    }),
    param: [1],
    req: ['mean']
  },

  /** @type {AggregateDef} */
  variancep: {
    create: () => initOp({
      value: s => s.valid > 1 ? s.dev / s.valid : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [1],
    req: ['variance']
  },

  /** @type {AggregateDef} */
  stdev: {
    create: () => initOp({
      value: s => s.valid > 1 ? Math.sqrt(s.dev / (s.valid - 1)) : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [1],
    req: ['variance']
  },

  /** @type {AggregateDef} */
  stdevp: {
    create: () => initOp({
      value: s => s.valid > 1 ? Math.sqrt(s.dev / s.valid) : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [1],
    req: ['variance']
  },

  /** @type {AggregateDef} */
  min: {
    create: () => ({
      init:  s => s.min = _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      value: s => s.min = (Number.isNaN(s.min) ? s.list.min() : s.min),
      add: (s, v) => { if (v < s.min || s.min === _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]) s.min = v; },
      rem: (s, v) => { if (v <= s.min) s.min = NaN; }
    }),
    param: [1],
    stream: ['array_agg']
  },

  /** @type {AggregateDef} */
  max: {
    create: () => ({
      init:  s => s.max = _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      value: s => s.max = (Number.isNaN(s.max) ? s.list.max() : s.max),
      add: (s, v) => { if (v > s.max || s.max === _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]) s.max = v; },
      rem: (s, v) => { if (v >= s.max) s.max = NaN; }
    }),
    param: [1],
    stream: ['array_agg']
  },

  /** @type {AggregateDef} */
  quantile: {
    create: (p) => initOp({
      value: s => s.list.quantile(p)
    }),
    param: [1, 1],
    req: ['array_agg']
  },

  /** @type {AggregateDef} */
  median: {
    create: () => initOp({
      value: s => s.list.quantile(0.5)
    }),
    param: [1],
    req: ['array_agg']
  },

  /** @type {AggregateDef} */
  covariance: {
    create: () => ({
      init:  s => {
        s.cov = s.mean_x = s.mean_y = s.dev_x = s.dev_y = 0;
      },
      value: s => s.valid > 1 ? s.cov / (s.valid - 1) : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      add: (s, x, y) => {
        const dx = x - s.mean_x;
        const dy = y - s.mean_y;
        s.mean_x += dx / s.valid;
        s.mean_y += dy / s.valid;
        const dy2 = y - s.mean_y;
        s.dev_x += dx * (x - s.mean_x);
        s.dev_y += dy * dy2;
        s.cov += dx * dy2;
      },
      rem: (s, x, y) => {
        const dx = x - s.mean_x;
        const dy = y - s.mean_y;
        s.mean_x -= s.valid ? dx / s.valid : s.mean_x;
        s.mean_y -= s.valid ? dy / s.valid : s.mean_y;
        const dy2 = y - s.mean_y;
        s.dev_x -= dx * (x - s.mean_x);
        s.dev_y -= dy * dy2;
        s.cov -= dx * dy2;
      }
    }),
    param: [2]
  },

  /** @type {AggregateDef} */
  covariancep: {
    create: () => initOp({
      value: s => s.valid > 1 ? s.cov / s.valid : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [2],
    req: ['covariance']
  },

  /** @type {AggregateDef} */
  corr: {
    create: () => initOp({
      value: s => s.valid > 1
        ? s.cov / (Math.sqrt(s.dev_x) * Math.sqrt(s.dev_y))
        : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [2],
    req: ['covariance']
  },

  /** @type {AggregateDef} */
  bins: {
    create: (maxbins, nice, minstep, step) => initOp({
      value: s => (0,_util_bins__WEBPACK_IMPORTED_MODULE_0__["default"])(s.min, s.max, maxbins, nice, minstep, step)
    }),
    param: [1, 4],
    req: ['min', 'max']
  }
});

/***/ }),

/***/ "../node_modules/arquero/src/op/functions/array.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/array.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/null */ "../node_modules/arquero/src/util/null.js");
/* harmony import */ var _util_is_array_type__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/is-array-type */ "../node_modules/arquero/src/util/is-array-type.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/is-string */ "../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_is_valid__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/is-valid */ "../node_modules/arquero/src/util/is-valid.js");





const isSeq = (seq) => (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_1__["default"])(seq) || (0,_util_is_string__WEBPACK_IMPORTED_MODULE_2__["default"])(seq);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  compact:      (arr) => (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_1__["default"])(arr) ? arr.filter(v => (0,_util_is_valid__WEBPACK_IMPORTED_MODULE_3__["default"])(v)) : arr,
  concat:       (...values) => [].concat(...values),
  includes:     (seq, value, index) => isSeq(seq)
                  ? seq.includes(value, index)
                  : false,
  indexof:      (seq, value) => isSeq(seq) ? seq.indexOf(value) : -1,
  join:         (arr, delim) => (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_1__["default"])(arr) ? arr.join(delim) : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"],
  lastindexof:  (seq, value) => isSeq(seq) ? seq.lastIndexOf(value) : -1,
  length:       (seq) => isSeq(seq) ? seq.length : 0,
  pluck:        (arr, prop) => (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_1__["default"])(arr)
                  ? arr.map(v => (0,_util_is_valid__WEBPACK_IMPORTED_MODULE_3__["default"])(v) ? v[prop] : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"])
                  : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"],
  reverse:      (seq) => (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_1__["default"])(seq) ? seq.slice().reverse()
                  : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_2__["default"])(seq) ? seq.split('').reverse().join('')
                  : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"],
  slice:        (seq, start, end) => isSeq(seq) ? seq.slice(start, end) : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"]
});


/***/ }),

/***/ "../node_modules/arquero/src/op/functions/bin.js":
/*!*******************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/bin.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Truncate a value to a bin boundary.
 * Useful for creating equal-width histograms.
 * Values outside the [min, max] range will be mapped to
 * -Infinity (< min) or +Infinity (> max).
 * @param {number} value - The value to bin.
 * @param {number} min - The minimum bin boundary.
 * @param {number} max - The maximum bin boundary.
 * @param {number} step - The step size between bin boundaries.
 * @param {number} [offset=0] - Offset in steps by which to adjust
 *  the bin value. An offset of 1 will return the next boundary.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value, min, max, step, offset) {
  return value == null ? null
    : value < min ? -Infinity
    : value > max ? +Infinity
    : (
        value = Math.max(min, Math.min(value, max)),
        min + step * Math.floor(1e-14 + (value - min) / step + (offset || 0))
      );
}

/***/ }),

/***/ "../node_modules/arquero/src/op/functions/date.js":
/*!********************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/date.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_format_date__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/format-date */ "../node_modules/arquero/src/util/format-date.js");
/* harmony import */ var _util_parse_iso_date__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/parse-iso-date */ "../node_modules/arquero/src/util/parse-iso-date.js");



const msMinute = 6e4;
const msDay = 864e5;
const msWeek = 6048e5;

const t0 = new Date();
const t1 = new Date();
const t = d => (
  t0.setTime(typeof d === 'string' ? (0,_util_parse_iso_date__WEBPACK_IMPORTED_MODULE_1__["default"])(d) : d),
  t0
);

/**
 * Function to create a new Date value.
 * If no arguments are provided, the current time is used.
 * @param {number} [year] The year.
 * @param {number} [month=0] The (zero-based) month.
 * @param {number} [date=1] The date within the month.
 * @param {number} [hours=0] The hour within the day.
 * @param {number} [minutes=0] The minute within the hour.
 * @param {number} [seconds=0] The second within the minute.
 * @param {number} [milliseconds=0] The milliseconds within the second.
 * @return {date} The resuting Date value.
 */
function datetime(year, month, date, hours, minutes, seconds, milliseconds) {
  return !arguments.length
    ? new Date(Date.now())
    : new Date(
        year,
        month || 0,
        date == null ? 1 : date,
        hours || 0,
        minutes || 0,
        seconds || 0,
        milliseconds || 0
      );
}

/**
 * Function to create a new Date value according to UTC time.
 * If no arguments are provided, the current time is used.
 * @param {number} [year] The year.
 * @param {number} [month=0] The (zero-based) month.
 * @param {number} [date=1] The date within the month.
 * @param {number} [hours=0] The hour within the day.
 * @param {number} [minutes=0] The minute within the hour.
 * @param {number} [seconds=0] The second within the minute.
 * @param {number} [milliseconds=0] The milliseconds within the second.
 * @return {date} The resuting Date value.
 */
function utcdatetime(year, month, date, hours, minutes, seconds, milliseconds) {
  return !arguments.length
    ? new Date(Date.now())
    : new Date(Date.UTC(
        year,
        month || 0,
        date == null ? 1 : date,
        hours || 0,
        minutes || 0,
        seconds || 0,
        milliseconds || 0
      ));
}

function dayofyear(date) {
  t1.setTime(+date);
  t1.setHours(0, 0, 0, 0);
  t0.setTime(+t1);
  t0.setMonth(0);
  t0.setDate(1);
  const tz = (t1.getTimezoneOffset() - t0.getTimezoneOffset()) * msMinute;
  return Math.floor(1 + ((t1 - t0) - tz) / msDay);
}

function utcdayofyear(date) {
  t1.setTime(+date);
  t1.setUTCHours(0, 0, 0, 0);
  const t0 = Date.UTC(t1.getUTCFullYear(), 0, 1);
  return Math.floor(1 + (t1 - t0) / msDay);
}

function week(date, firstday) {
  const i = firstday || 0;
  t1.setTime(+date);
  t1.setDate(t1.getDate() - (t1.getDay() + 7 - i) % 7);
  t1.setHours(0, 0, 0, 0);
  t0.setTime(+date);
  t0.setMonth(0);
  t0.setDate(1);
  t0.setDate(1 - (t0.getDay() + 7 - i) % 7);
  t0.setHours(0, 0, 0, 0);
  const tz = (t1.getTimezoneOffset() - t0.getTimezoneOffset()) * msMinute;
  return Math.floor((1 + (t1 - t0) - tz) / msWeek);
}

function utcweek(date, firstday) {
  const i = firstday || 0;
  t1.setTime(+date);
  t1.setUTCDate(t1.getUTCDate() - (t1.getUTCDay() + 7 - i) % 7);
  t1.setUTCHours(0, 0, 0, 0);
  t0.setTime(+date);
  t0.setUTCMonth(0);
  t0.setUTCDate(1);
  t0.setUTCDate(1 - (t0.getUTCDay() + 7 - i) % 7);
  t0.setUTCHours(0, 0, 0, 0);
  return Math.floor((1 + (t1 - t0)) / msWeek);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  format_date:     (date, shorten) => (0,_util_format_date__WEBPACK_IMPORTED_MODULE_0__.formatDate)(t(date), !shorten),
  format_utcdate:  (date, shorten) => (0,_util_format_date__WEBPACK_IMPORTED_MODULE_0__.formatUTCDate)(t(date), !shorten),
  timestamp:       (date) => +t(date),
  year:            (date) => t(date).getFullYear(),
  quarter:         (date) => Math.floor(t(date).getMonth() / 3),
  month:           (date) => t(date).getMonth(),
  date:            (date) => t(date).getDate(),
  dayofweek:       (date) => t(date).getDay(),
  hours:           (date) => t(date).getHours(),
  minutes:         (date) => t(date).getMinutes(),
  seconds:         (date) => t(date).getSeconds(),
  milliseconds:    (date) => t(date).getMilliseconds(),
  utcyear:         (date) => t(date).getUTCFullYear(),
  utcquarter:      (date) => Math.floor(t(date).getUTCMonth() / 3),
  utcmonth:        (date) => t(date).getUTCMonth(),
  utcdate:         (date) => t(date).getUTCDate(),
  utcdayofweek:    (date) => t(date).getUTCDay(),
  utchours:        (date) => t(date).getUTCHours(),
  utcminutes:      (date) => t(date).getUTCMinutes(),
  utcseconds:      (date) => t(date).getUTCSeconds(),
  utcmilliseconds: (date) => t(date).getUTCMilliseconds(),
  datetime,
  dayofyear,
  week,
  utcdatetime,
  utcdayofyear,
  utcweek,
  now: Date.now
});

/***/ }),

/***/ "../node_modules/arquero/src/op/functions/equal.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/equal.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ equal)
/* harmony export */ });
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/is-date */ "../node_modules/arquero/src/util/is-date.js");
/* harmony import */ var _util_is_regexp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/is-regexp */ "../node_modules/arquero/src/util/is-regexp.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/is-object */ "../node_modules/arquero/src/util/is-object.js");




/**
 * Compare two values for equality, using join semantics in which null
 * !== null. If the inputs are object-valued, a deep equality check
 * of array entries or object key-value pairs is performed.
 * @param {*} a The first input.
 * @param {*} b The second input.
 * @return {boolean} True if equal, false if not.
 */
function equal(a, b) {
  return (a == null || b == null || a !== a || b !== b) ? false
    : a === b ? true
    : ((0,_util_is_date__WEBPACK_IMPORTED_MODULE_0__["default"])(a) || (0,_util_is_date__WEBPACK_IMPORTED_MODULE_0__["default"])(b)) ? +a === +b
    : ((0,_util_is_regexp__WEBPACK_IMPORTED_MODULE_1__["default"])(a) && (0,_util_is_regexp__WEBPACK_IMPORTED_MODULE_1__["default"])(b)) ? a + '' === b + ''
    : ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_2__["default"])(a) && (0,_util_is_object__WEBPACK_IMPORTED_MODULE_2__["default"])(b)) ? deepEqual(a, b)
    : false;
}

function deepEqual(a, b) {
  if (Object.getPrototypeOf(a) !== Object.getPrototypeOf(b)) {
    return false;
  }

  if (a.length || b.length) {
    return arrayEqual(a, b);
  }

  const keysA = Object.keys(a);
  const keysB = Object.keys(b);
  if (keysA.length !== keysB.length) {
    return false;
  }
  keysA.sort();
  keysB.sort();

  if (!arrayEqual(keysA, keysB, (a, b) => a === b)) {
    return false;
  }

  const n = keysA.length;
  for (let i = 0; i < n; ++i) {
    const k = keysA[i];
    if (!equal(a[k], b[k])) {
      return false;
    }
  }

  return true;
}

function arrayEqual(a, b, test = equal) {
  const n = a.length;
  if (n !== b.length) return false;

  for (let i = 0; i < n; ++i) {
    if (!test(a[i], b[i])) {
      return false;
    }
  }

  return true;
}

/***/ }),

/***/ "../node_modules/arquero/src/op/functions/index.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./array */ "../node_modules/arquero/src/op/functions/array.js");
/* harmony import */ var _bin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bin */ "../node_modules/arquero/src/op/functions/bin.js");
/* harmony import */ var _date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./date */ "../node_modules/arquero/src/op/functions/date.js");
/* harmony import */ var _equal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./equal */ "../node_modules/arquero/src/op/functions/equal.js");
/* harmony import */ var _json__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./json */ "../node_modules/arquero/src/op/functions/json.js");
/* harmony import */ var _math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./math */ "../node_modules/arquero/src/op/functions/math.js");
/* harmony import */ var _object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./object */ "../node_modules/arquero/src/op/functions/object.js");
/* harmony import */ var _recode__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./recode */ "../node_modules/arquero/src/op/functions/recode.js");
/* harmony import */ var _sequence__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./sequence */ "../node_modules/arquero/src/op/functions/sequence.js");
/* harmony import */ var _string__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./string */ "../node_modules/arquero/src/op/functions/string.js");











/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  bin: _bin__WEBPACK_IMPORTED_MODULE_1__["default"],
  equal: _equal__WEBPACK_IMPORTED_MODULE_3__["default"],
  recode: _recode__WEBPACK_IMPORTED_MODULE_7__["default"],
  sequence: _sequence__WEBPACK_IMPORTED_MODULE_8__["default"],
  ..._array__WEBPACK_IMPORTED_MODULE_0__["default"],
  ..._date__WEBPACK_IMPORTED_MODULE_2__["default"],
  ..._json__WEBPACK_IMPORTED_MODULE_4__["default"],
  ..._math__WEBPACK_IMPORTED_MODULE_5__["default"],
  ..._object__WEBPACK_IMPORTED_MODULE_6__["default"],
  ..._string__WEBPACK_IMPORTED_MODULE_9__["default"]
});

/***/ }),

/***/ "../node_modules/arquero/src/op/functions/json.js":
/*!********************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/json.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  parse_json: (str) => JSON.parse(str),
  to_json:    (val) => JSON.stringify(val)
});

/***/ }),

/***/ "../node_modules/arquero/src/op/functions/math.js":
/*!********************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/math.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_random__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/random */ "../node_modules/arquero/src/util/random.js");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  random: _util_random__WEBPACK_IMPORTED_MODULE_0__.random,
  is_nan:    Number.isNaN,
  is_finite: Number.isFinite,

  abs:      Math.abs,
  cbrt:     Math.cbrt,
  ceil:     Math.ceil,
  clz32:    Math.clz32,
  exp:      Math.exp,
  expm1:    Math.expm1,
  floor:    Math.floor,
  fround:   Math.fround,
  greatest: Math.max,
  least:    Math.min,
  log:      Math.log,
  log10:    Math.log10,
  log1p:    Math.log1p,
  log2:     Math.log2,
  pow:      Math.pow,
  round:    Math.round,
  sign:     Math.sign,
  sqrt:     Math.sqrt,
  trunc:    Math.trunc,

  degrees:  (rad) => 180 * rad / Math.PI,
  radians:  (deg) => Math.PI * deg / 180,
  acos:     Math.acos,
  acosh:    Math.acosh,
  asin:     Math.asin,
  asinh:    Math.asinh,
  atan:     Math.atan,
  atan2:    Math.atan2,
  atanh:    Math.atanh,
  cos:      Math.cos,
  cosh:     Math.cosh,
  sin:      Math.sin,
  sinh:     Math.sinh,
  tan:      Math.tan,
  tanh:     Math.tanh
});

/***/ }),

/***/ "../node_modules/arquero/src/op/functions/object.js":
/*!**********************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/object.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/null */ "../node_modules/arquero/src/util/null.js");
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/has */ "../node_modules/arquero/src/util/has.js");
/* harmony import */ var _util_is_map__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/is-map */ "../node_modules/arquero/src/util/is-map.js");
/* harmony import */ var _util_is_map_or_set__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/is-map-or-set */ "../node_modules/arquero/src/util/is-map-or-set.js");





function array(iter) {
  return Array.from(iter);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  has:      (obj, key) => (0,_util_is_map_or_set__WEBPACK_IMPORTED_MODULE_3__["default"])(obj) ? obj.has(key)
              : obj != null ? (0,_util_has__WEBPACK_IMPORTED_MODULE_1__["default"])(obj, key)
              : false,
  keys:     (obj) => (0,_util_is_map__WEBPACK_IMPORTED_MODULE_2__["default"])(obj) ? array(obj.keys())
              : obj != null ? Object.keys(obj)
              : [],
  values:   (obj) => (0,_util_is_map_or_set__WEBPACK_IMPORTED_MODULE_3__["default"])(obj) ? array(obj.values())
              : obj != null ? Object.values(obj)
              : [],
  entries:  (obj) => (0,_util_is_map_or_set__WEBPACK_IMPORTED_MODULE_3__["default"])(obj) ? array(obj.entries())
              : obj != null ? Object.entries(obj)
              : [],
  object:   (entries) => entries ? Object.fromEntries(entries) : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"]
});

/***/ }),

/***/ "../node_modules/arquero/src/op/functions/recode.js":
/*!**********************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/recode.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/has */ "../node_modules/arquero/src/util/has.js");


/**
 * Recodes an input value to an alternative value, based on a provided
 * value map. If a fallback value is specified, it will be returned when
 * a matching value is not found in the map; otherwise, the input value
 * is returned unchanged.
 * @param {*} value The value to recode. The value must be safely
 *  coercible to a string for lookup against the value map.
 * @param {object|Map} map An object or Map with input values for keys and
 *  output recoded values as values. If a non-Map object, only the object's
 *  own properties will be considered.
 * @param {*} [fallback] A default fallback value to use if the input
 *  value is not found in the value map.
 * @return {*} The recoded value.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value, map, fallback) {
  if (map instanceof Map) {
    if (map.has(value)) return map.get(value);
  } else if ((0,_util_has__WEBPACK_IMPORTED_MODULE_0__["default"])(map, value)) {
    return map[value];
  }
  return fallback !== undefined ? fallback : value;
}

/***/ }),

/***/ "../node_modules/arquero/src/op/functions/sequence.js":
/*!************************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/sequence.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Returns an array containing an arithmetic sequence from the start value
 * to the stop value, in step increments. If step is positive, the last
 * element is the largest start + i * step less than stop; if step is
 * negative, the last element is the smallest start + i * step greater
 * than stop. If the returned array would contain an infinite number of
 * values, an empty range is returned.
 * @param {number} [start=0] The starting value of the sequence.
 * @param {number} [stop] The stopping value of the sequence.
 *  The stop value is exclusive; it is not included in the result.
 * @param {number} [step=1] The step increment between sequence values.
 * @return {number[]} The generated sequence.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(start, stop, step) {
  let n = arguments.length;
  start = +start;
  stop = +stop;
  step = n < 2
    ? (stop = start, start = 0, 1)
    : n < 3 ? 1 : +step;

  n = Math.max(0, Math.ceil((stop - start) / step)) | 0;
  const seq = new Array(n);

  for (let i = 0; i < n; ++i) {
    seq[i] = start + i * step;
  }

  return seq;
}

/***/ }),

/***/ "../node_modules/arquero/src/op/functions/string.js":
/*!**********************************************************!*\
  !*** ../node_modules/arquero/src/op/functions/string.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  parse_date:   (str) => str == null ? str : new Date(str),
  parse_float:  (str) => str == null ? str : Number.parseFloat(str),
  parse_int:    (str, radix) => str == null ? str : Number.parseInt(str, radix),
  endswith:     (str, search, length) => str == null ? false
                  : String(str).endsWith(search, length),
  match:        (str, regexp, index) => {
                  const m = str == null ? str : String(str).match(regexp);
                  return index == null || m == null ? m
                    : typeof index === 'number' ? m[index]
                    : m.groups ? m.groups[index]
                    : null;
                },
  normalize:    (str, form) => str == null ? str
                  : String(str).normalize(form),
  padend:       (str, len, fill) => str == null ? str
                  : String(str).padEnd(len, fill),
  padstart:     (str, len, fill) => str == null ? str
                  : String(str).padStart(len, fill),
  upper:        (str) => str == null ? str
                  : String(str).toUpperCase(),
  lower:        (str) => str == null ? str
                  : String(str).toLowerCase(),
  repeat:       (str, num) => str == null ? str
                  : String(str).repeat(num),
  replace:      (str, pattern, replacement) => str == null ? str
                  : String(str).replace(pattern, String(replacement)),
  substring:    (str, start, end) => str == null ? str
                  : String(str).substring(start, end),
  split:        (str, separator, limit) => str == null ? []
                  : String(str).split(separator, limit),
  startswith:   (str, search, length) => str == null ? false
                  : String(str).startsWith(search, length),
  trim:         (str) => str == null ? str
                  : String(str).trim()
});

/***/ }),

/***/ "../node_modules/arquero/src/op/index.js":
/*!***********************************************!*\
  !*** ../node_modules/arquero/src/op/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   aggregateFunctions: () => (/* reexport safe */ _aggregate_functions__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   functions: () => (/* reexport safe */ _functions__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   getAggregate: () => (/* binding */ getAggregate),
/* harmony export */   getFunction: () => (/* binding */ getFunction),
/* harmony export */   getWindow: () => (/* binding */ getWindow),
/* harmony export */   hasAggregate: () => (/* binding */ hasAggregate),
/* harmony export */   hasFunction: () => (/* binding */ hasFunction),
/* harmony export */   hasWindow: () => (/* binding */ hasWindow),
/* harmony export */   windowFunctions: () => (/* reexport safe */ _window_functions__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _aggregate_functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./aggregate-functions */ "../node_modules/arquero/src/op/aggregate-functions.js");
/* harmony import */ var _window_functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./window-functions */ "../node_modules/arquero/src/op/window-functions.js");
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./functions */ "../node_modules/arquero/src/op/functions/index.js");
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/has */ "../node_modules/arquero/src/util/has.js");







/**
 * Check if an aggregate function with the given name exists.
 * @param {string} name The name of the aggregate function.
 * @return {boolean} True if found, false otherwise.
 */
function hasAggregate(name) {
  return (0,_util_has__WEBPACK_IMPORTED_MODULE_3__["default"])(_aggregate_functions__WEBPACK_IMPORTED_MODULE_0__["default"], name);
}

/**
 * Check if a window function with the given name exists.
 * @param {string} name The name of the window function.
 * @return {boolean} True if found, false otherwise.
 */
function hasWindow(name) {
  return (0,_util_has__WEBPACK_IMPORTED_MODULE_3__["default"])(_window_functions__WEBPACK_IMPORTED_MODULE_1__["default"], name);
}

/**
 * Check if an expression function with the given name exists.
 * @param {string} name The name of the function.
 * @return {boolean} True if found, false otherwise.
 */
 function hasFunction(name) {
  return (0,_util_has__WEBPACK_IMPORTED_MODULE_3__["default"])(_functions__WEBPACK_IMPORTED_MODULE_2__["default"], name) || name === 'row_object';
}

/**
 * Get an aggregate function definition.
 * @param {string} name The name of the aggregate function.
 * @return {AggregateDef} The aggregate function definition,
 *  or undefined if not found.
 */
function getAggregate(name) {
  return hasAggregate(name) && _aggregate_functions__WEBPACK_IMPORTED_MODULE_0__["default"][name];
}

/**
 * Get a window function definition.
 * @param {string} name The name of the window function.
 * @return {WindowDef} The window function definition,
 *  or undefined if not found.
 */
function getWindow(name) {
  return hasWindow(name) && _window_functions__WEBPACK_IMPORTED_MODULE_1__["default"][name];
}

/**
 * Get an expression function definition.
 * @param {string} name The name of the function.
 * @return {Function} The function instance, or undefined if not found.
 */
function getFunction(name) {
  return hasFunction(name) && _functions__WEBPACK_IMPORTED_MODULE_2__["default"][name];
}

/***/ }),

/***/ "../node_modules/arquero/src/op/op-api.js":
/*!************************************************!*\
  !*** ../node_modules/arquero/src/op/op-api.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   any: () => (/* binding */ any),
/* harmony export */   array_agg: () => (/* binding */ array_agg),
/* harmony export */   array_agg_distinct: () => (/* binding */ array_agg_distinct),
/* harmony export */   count: () => (/* binding */ count),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   entries_agg: () => (/* binding */ entries_agg),
/* harmony export */   map_agg: () => (/* binding */ map_agg),
/* harmony export */   object_agg: () => (/* binding */ object_agg)
/* harmony export */ });
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./functions */ "../node_modules/arquero/src/op/functions/index.js");
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./op */ "../node_modules/arquero/src/op/op.js");



const any = (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('any', field);
const count = () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('count');
const array_agg = (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('array_agg', field);
const array_agg_distinct = (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('array_agg_distinct', field);
const map_agg = (key, value) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('map_agg', [key, value]);
const object_agg = (key, value) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('object_agg', [key, value]);
const entries_agg = (key, value) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('entries_agg', [key, value]);

/**
 * @typedef {import('../table/transformable').Struct} Struct
 */

/**
 * All table expression operations including normal functions,
 * aggregate functions, and window functions.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  ..._functions__WEBPACK_IMPORTED_MODULE_0__["default"],

  /**
   * Generate an object representing the current table row.
   * @param {...string} names The column names to include in the object.
   *  If unspecified, all columns are included.
   * @return {Struct} The generated row object.
   */
  row_object: (...names) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('row_object', null, names.flat()),

  /**
   * Aggregate function to count the number of records (rows).
   * @returns {number} The count of records.
   */
  count,

  /**
   * Aggregate function returning an arbitrary observed value.
   * @param {*} field The data field.
   * @return {*} An arbitrary observed value.
   */
  any,

  /**
   * Aggregate function to collect an array of values.
   * @param {*} field The data field.
   * @return {Array} A list of values.
   */
  array_agg,

  /**
   * Aggregate function to collect an array of distinct (unique) values.
   * @param {*} field The data field.
   * @return {Array} An array of unique values.
   */
  array_agg_distinct,

  /**
   * Aggregate function to create an object given input key and value fields.
   * @param {*} key The object key field.
   * @param {*} value The object value field.
   * @return {Struct} An object of key-value pairs.
   */
  object_agg,

  /**
   * Aggregate function to create a Map given input key and value fields.
   * @param {*} key The object key field.
   * @param {*} value The object value field.
   * @return {Map} A Map of key-value pairs.
   */
  map_agg,

  /**
   * Aggregate function to create an array in the style of Object.entries()
   * given input key and value fields.
   * @param {*} key The object key field.
   * @param {*} value The object value field.
   * @return {[[any, any]]} An array of [key, value] arrays.
   */
  entries_agg,

  /**
   * Aggregate function to count the number of valid values.
   * Invalid values are null, undefined, or NaN.
   * @param {*} field The data field.
   * @return {number} The count of valid values.
   */
  valid: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('valid', field),

  /**
   * Aggregate function to count the number of invalid values.
   * Invalid values are null, undefined, or NaN.
   * @param {*} field The data field.
   * @return {number} The count of invalid values.
   */
  invalid: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('invalid', field),

  /**
   * Aggregate function to count the number of distinct values.
   * @param {*} field The data field.
   * @return {number} The count of distinct values.
   */
  distinct: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('distinct', field),

  /**
   * Aggregate function to determine the mode (most frequent) value.
   * @param {*} field The data field.
   * @return {number} The mode value.
   */
  mode: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('mode', field),

  /**
   * Aggregate function to sum values.
   * @param {string} field The data field.
   * @return {number} The sum of the values.
   */
  sum: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('sum', field),

  /**
   * Aggregate function to multiply values.
   * @param {*} field The data field.
   * @return {number} The product of the values.
   */
  product: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('product', field),

  /**
   * Aggregate function for the mean (average) value.
   * @param {*} field The data field.
   * @return {number} The mean (average) of the values.
   */
  mean: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('mean', field),

  /**
   * Aggregate function for the average (mean) value.
   * @param {*} field The data field.
   * @return {number} The average (mean) of the values.
   */
  average: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('average', field),

  /**
   * Aggregate function for the sample variance.
   * @param {*} field The data field.
   * @return {number} The sample variance of the values.
   */
  variance: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('variance', field),

  /**
   * Aggregate function for the population variance.
   * @param {*} field The data field.
   * @return {number} The population variance of the values.
   */
  variancep: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('variancep', field),

  /**
   * Aggregate function for the sample standard deviation.
   * @param {*} field The data field.
   * @return {number} The sample standard deviation of the values.
   */
  stdev: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('stdev', field),

  /**
   * Aggregate function for the population standard deviation.
   * @param {*} field The data field.
   * @return {number} The population standard deviation of the values.
   */
  stdevp: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('stdevp', field),

  /**
   * Aggregate function for the minimum value.
   * @param {*} field The data field.
   * @return {number} The minimum value.
   */
  min: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('min', field),

  /**
   * Aggregate function for the maximum value.
   * @param {*} field The data field.
   * @return {number} The maximum value.
   */
  max: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('max', field),

  /**
   * Aggregate function to compute the quantile boundary
   * of a data field for a probability threshold.
   * @param {*} field The data field.
   * @param {number} p The probability threshold.
   * @return {number} The quantile value.
   */
  quantile: (field, p) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('quantile', field, p),

  /**
   * Aggregate function for the median value.
   * This is a shorthand for the 0.5 quantile value.
   * @param {*} field The data field.
   * @return {number} The median value.
   */
  median: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('median', field),

  /**
   * Aggregate function for the sample covariance between two variables.
   * @param {*} field1 The first data field.
   * @param {*} field2 The second data field.
   * @return {number} The sample covariance of the values.
   */
  covariance: (field1, field2) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('covariance', [field1, field2]),

  /**
   * Aggregate function for the population covariance between two variables.
   * @param {*} field1 The first data field.
   * @param {*} field2 The second data field.
   * @return {number} The population covariance of the values.
   */
  covariancep: (field1, field2) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('covariancep', [field1, field2]),

  /**
   * Aggregate function for the product-moment correlation between two variables.
   * To instead compute a rank correlation, compute the average ranks for each
   * variable and then apply this function to the result.
   * @param {*} field1 The first data field.
   * @param {*} field2 The second data field.
   * @return {number} The correlation between the field values.
   */
  corr: (field1, field2) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('corr', [field1, field2]),

  /**
   * Aggregate function for calculating a binning scheme in terms of
   * the minimum bin boundary, maximum bin boundary, and step size.
   * @param {*} field The data field.
   * @param {number} [maxbins=15] The maximum number of allowed bins.
   * @param {boolean} [nice=true] Flag indicating if the bin min and max
   *  should snap to "nice" human-friendly values.
   * @param {number} [minstep] The minimum allowed step size between bins.
   * @param {number} [step] The exact step size to use between bins.
   *  If specified, the maxbins and minstep arguments are ignored.
   * @return {[number, number, number]} The bin [min, max, and step] values.
   */
  bins: (field, maxbins, nice, minstep) =>
    (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('bins', field, [maxbins, nice, minstep]),

  /**
   * Window function to assign consecutive row numbers, starting from 1.
   * @return {number} The row number value.
   */
  row_number: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('row_number'),

  /**
   * Window function to assign a rank to each value in a group, starting
   * from 1. Peer values are assigned the same rank. Subsequent ranks
   * reflect the number of prior values: if the first two values tie for
   * rank 1, the third value is assigned rank 3.
   * @return {number} The rank value.
   */
  rank: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('rank'),

  /**
   * Window function to assign a fractional (average) rank to each value in
   * a group, starting from 1. Peer values are assigned the average of their
   * indices: if the first two values tie, both will be assigned rank 1.5.
   * @return {number} The peer-averaged rank value.
   */
  avg_rank: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('avg_rank'),

  /**
   * Window function to assign a dense rank to each value in a group,
   * starting from 1. Peer values are assigned the same rank. Subsequent
   * ranks do not reflect the number of prior values: if the first two
   * values tie for rank 1, the third value is assigned rank 2.
   * @return {number} The dense rank value.
   */
  dense_rank: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('dense_rank'),

  /**
   * Window function to assign a percentage rank to each value in a group.
   * The percent is calculated as (rank - 1) / (group_size - 1).
   * @return {number} The percentage rank value.
   */
  percent_rank: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('percent_rank'),

  /**
   * Window function to assign a cumulative distribution value between 0 and 1
   * to each value in a group.
   * @return {number} The cumulative distribution value.
   */
  cume_dist: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('cume_dist'),

  /**
   * Window function to assign a quantile (e.g., percentile) value to each
   * value in a group. Accepts an integer parameter indicating the number of
   * buckets to use (e.g., 100 for percentiles, 5 for quintiles).
   * @param {number} num The number of buckets for ntile calculation.
   * @return {number} The quantile value.
   */
  ntile: (num) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('ntile', null, num),

  /**
   * Window function to assign a value that precedes the current value by
   * a specified number of positions. If no such value exists, returns a
   * default value instead.
   * @param {*} field The data field.
   * @param {number} [offset=1] The lag offset from the current value.
   * @param {*} [defaultValue=undefined] The default value.
   * @return {*} The lagging value.
   */
  lag: (field, offset, defaultValue) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('lag', field, [offset, defaultValue]),

  /**
   * Window function to assign a value that follows the current value by
   * a specified number of positions. If no such value exists, returns a
   * default value instead.
   * @param {*} field The data field.
   * @param {number} [offset=1] The lead offset from the current value.
   * @param {*} [defaultValue=undefined] The default value.
   * @return {*} The leading value.
   */
  lead: (field, offset, defaultValue) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('lead', field, [offset, defaultValue]),

  /**
   * Window function to assign the first value in a sliding window frame.
   * @param {*} field The data field.
   * @return {*} The first value in the current frame.
   */
  first_value: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('first_value', field),

  /**
   * Window function to assign the last value in a sliding window frame.
   * @param {*} field The data field.
   * @return {*} The last value in the current frame.
   */
  last_value: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('last_value', field),

  /**
   * Window function to assign the nth value in a sliding window frame
   * (counting from 1), or undefined if no such value exists.
   * @param {*} field The data field.
   * @param {number} nth The nth position, starting from 1.
   * @return {*} The nth value in the current frame.
   */
  nth_value: (field, nth) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('nth_value', field, nth),

  /**
   * Window function to fill in missing values with preceding values.
   * @param {*} field The data field.
   * @param {*} [defaultValue=undefined] The default value.
   * @return {*} The current value if valid, otherwise the first preceding
   *  valid value. If no such value exists, returns the default value.
   */
  fill_down: (field, defaultValue) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('fill_down', field, defaultValue),

  /**
   * Window function to fill in missing values with subsequent values.
   * @param {*} field The data field.
   * @param {*} [defaultValue=undefined] The default value.
   * @return {*} The current value if valid, otherwise the first subsequent
   *  valid value. If no such value exists, returns the default value.
   */
  fill_up: (field, defaultValue) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('fill_up', field, defaultValue)
});

/***/ }),

/***/ "../node_modules/arquero/src/op/op.js":
/*!********************************************!*\
  !*** ../node_modules/arquero/src/op/op.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Op: () => (/* binding */ Op),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/to-array */ "../node_modules/arquero/src/util/to-array.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/to-string */ "../node_modules/arquero/src/util/to-string.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(name, fields = [], params = []) {
  return new Op(name, (0,_util_to_array__WEBPACK_IMPORTED_MODULE_0__["default"])(fields), (0,_util_to_array__WEBPACK_IMPORTED_MODULE_0__["default"])(params));
}

class Op {
  constructor(name, fields, params) {
    this.name = name;
    this.fields = fields;
    this.params = params;
  }
  toString() {
    const args = [
      ...this.fields.map(f => `d[${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_1__["default"])(f)}]`),
      ...this.params.map(_util_to_string__WEBPACK_IMPORTED_MODULE_1__["default"])
    ];
    return `d => op.${this.name}(${args})`;
  }
  toObject() {
    return { expr: this.toString(), func: true };
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/op/window-functions.js":
/*!**********************************************************!*\
  !*** ../node_modules/arquero/src/op/window-functions.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_valid__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/is-valid */ "../node_modules/arquero/src/util/is-valid.js");
/* harmony import */ var _util_no_op__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/no-op */ "../node_modules/arquero/src/util/no-op.js");
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/null */ "../node_modules/arquero/src/util/null.js");





/**
 * Initialize a window operator.
 * @callback WindowInit
 * @return {void}
 */

/**
 * Retrieve an output value from a window operator.
 * @callback WindowValue
 * @param {WindowState} state The window state object.
 * @return {*} The output value.
 */

/**
 * An operator instance for a window function.
 * @typedef {object} WindowOperator
 * @property {AggregateInit} init Initialize the operator.
 * @property {AggregateValue} value Retrieve an output value.
 */

/**
 * Create a new window operator instance.
 * @callback WindowCreate
 * @param {...any} params The aggregate operator parameters.
 * @return {WindowOperator} The instantiated window operator.
 */

/**
 * An operator definition for a window function.
 * @typedef {object} WindowDef
 * @property {AggregateCreate} create Create a new operator instance.
 * @property {number[]} param Two-element array containing the
 *  counts of input fields and additional parameters.
 */

const rank = {
  create() {
    let rank;
    return {
      init: () => rank = 1,
      value: w => {
        const i = w.index;
        return (i && !w.peer(i)) ? (rank = i + 1) : rank;
      }
    };
  },
  param: []
};

const cume_dist = {
  create() {
    let cume;
    return {
      init: () => cume = 0,
      value: w => {
        const { index, peer, size } = w;
        let i = index;
        if (cume < i) {
          while (i + 1 < size && peer(i + 1)) ++i;
          cume = i;
        }
        return (1 + cume) / size;
      }
    };
  },
  param: []
};

/**
 * Window operator definitions.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /** @type {WindowDef} */
  row_number: {
    create() {
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: w => w.index + 1
      };
    },
    param: []
  },

  /** @type {WindowDef} */
  rank,

  /** @type {WindowDef} */
  avg_rank: {
    create() {
      let j, rank;
      return {
        init: () => (j = -1, rank = 1),
        value: w => {
          const i = w.index;
          if (i >= j) {
            for (rank = j = i + 1; w.peer(j); rank += ++j);
            rank /= (j - i);
          }
          return rank;
        }
      };
    },
    param: []
  },

  /** @type {WindowDef} */
  dense_rank: {
    create() {
      let drank;
      return {
        init: () => drank = 1,
        value: w => {
          const i = w.index;
          return (i && !w.peer(i)) ? ++drank : drank;
        }
      };
    },
    param: []
  },

  /** @type {WindowDef} */
  percent_rank: {
    create() {
      const { init, value } = rank.create();
      return {
        init,
        value: w => (value(w) - 1) / (w.size - 1)
      };
    },
    param: []
  },

  /** @type {WindowDef} */
  cume_dist,

  /** @type {WindowDef} */
  ntile: {
    create(num) {
      num = +num;
      if (!(num > 0)) (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])('ntile num must be greater than zero.');
      const { init, value } = cume_dist.create();
      return {
        init,
        value: w => Math.ceil(num * value(w))
      };
    },
    param: [0, 1]
  },

  /** @type {WindowDef} */
  lag: {
    create(offset, defaultValue = _util_null__WEBPACK_IMPORTED_MODULE_3__["default"]) {
      offset = +offset || 1;
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: (w, f) => {
          const i = w.index - offset;
          return i >= 0 ? w.value(i, f) : defaultValue;
        }
      };
    },
    param: [1, 2]
  },

  /** @type {WindowDef} */
  lead: {
    create(offset, defaultValue = _util_null__WEBPACK_IMPORTED_MODULE_3__["default"]) {
      offset = +offset || 1;
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: (w, f) => {
          const i = w.index + offset;
          return i < w.size ? w.value(i, f) : defaultValue;
        }
      };
    },
    param: [1, 2]
  },

  /** @type {WindowDef} */
  first_value: {
    create() {
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: (w, f) => w.value(w.i0, f)
      };
    },
    param: [1]
  },

  /** @type {WindowDef} */
  last_value: {
    create() {
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: (w, f) => w.value(w.i1 - 1, f)
      };
    },
    param: [1]
  },

  /** @type {WindowDef} */
  nth_value: {
    create(nth) {
      nth = +nth;
      if (!(nth > 0)) (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])('nth_value nth must be greater than zero.');
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: (w, f) => {
          const i = w.i0 + (nth - 1);
          return i < w.i1 ? w.value(i, f) : _util_null__WEBPACK_IMPORTED_MODULE_3__["default"];
        }
      };
    },
    param: [1, 1]
  },

  /** @type {WindowDef} */
  fill_down: {
    create(defaultValue = _util_null__WEBPACK_IMPORTED_MODULE_3__["default"]) {
      let value;
      return {
        init: () => value = defaultValue,
        value: (w, f) => {
          const v = w.value(w.index, f);
          return (0,_util_is_valid__WEBPACK_IMPORTED_MODULE_1__["default"])(v) ? (value = v) : value;
        }
      };
    },
    param: [1, 1]
  },

  /** @type {WindowDef} */
  fill_up: {
    create(defaultValue = _util_null__WEBPACK_IMPORTED_MODULE_3__["default"]) {
      let value, idx;
      return {
        init: () => (value = defaultValue, idx = -1),
        value: (w, f) => w.index <= idx ? value
          : (idx = find(w, f, w.index)) >= 0 ? (value = w.value(idx, f))
          : (idx = w.size, value = defaultValue)
      };
    },
    param: [1, 1]
  }
});

function find(w, f, i) {
  for (const n = w.size; i < n; ++i) {
    if ((0,_util_is_valid__WEBPACK_IMPORTED_MODULE_1__["default"])(w.value(i, f))) return i;
  }
  return -1;
}


/***/ }),

/***/ "../node_modules/arquero/src/query/constants.js":
/*!******************************************************!*\
  !*** ../node_modules/arquero/src/query/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Descending: () => (/* binding */ Descending),
/* harmony export */   Expr: () => (/* binding */ Expr),
/* harmony export */   ExprList: () => (/* binding */ ExprList),
/* harmony export */   ExprNumber: () => (/* binding */ ExprNumber),
/* harmony export */   ExprObject: () => (/* binding */ ExprObject),
/* harmony export */   JoinKeys: () => (/* binding */ JoinKeys),
/* harmony export */   JoinValues: () => (/* binding */ JoinValues),
/* harmony export */   Options: () => (/* binding */ Options),
/* harmony export */   OrderbyKeys: () => (/* binding */ OrderbyKeys),
/* harmony export */   Query: () => (/* binding */ Query),
/* harmony export */   Selection: () => (/* binding */ Selection),
/* harmony export */   SelectionList: () => (/* binding */ SelectionList),
/* harmony export */   TableRef: () => (/* binding */ TableRef),
/* harmony export */   TableRefList: () => (/* binding */ TableRefList),
/* harmony export */   Verb: () => (/* binding */ Verb),
/* harmony export */   Window: () => (/* binding */ Window)
/* harmony export */ });
const Expr = 'Expr';
const ExprList = 'ExprList';
const ExprNumber = 'ExprNumber';
const ExprObject = 'ExprObject';
const JoinKeys = 'JoinKeys';
const JoinValues = 'JoinValues';
const Options = 'Options';
const OrderbyKeys = 'OrderKeys';
const SelectionList = 'SelectionList';
const TableRef = 'TableRef';
const TableRefList = 'TableRefList';

const Descending = 'Descending';
const Query = 'Query';
const Selection = 'Selection';
const Verb = 'Verb';
const Window = 'Window';

/***/ }),

/***/ "../node_modules/arquero/src/query/query.js":
/*!**************************************************!*\
  !*** ../node_modules/arquero/src/query/query.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addQueryVerb: () => (/* binding */ addQueryVerb),
/* harmony export */   "default": () => (/* binding */ Query),
/* harmony export */   query: () => (/* binding */ query),
/* harmony export */   queryFrom: () => (/* binding */ queryFrom)
/* harmony export */ });
/* harmony import */ var _table_transformable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/transformable */ "../node_modules/arquero/src/table/transformable.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../node_modules/arquero/src/query/constants.js");
/* harmony import */ var _verb__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./verb */ "../node_modules/arquero/src/query/verb.js");




/**
 * Create a new query instance. The query interface provides
 * a table-like verb API to construct a query that can be
 * serialized or evaluated against Arquero tables.
 * @param {string} [tableName] The name of the table to query. If
 *  provided, will be used as the default input table to pull from
 *  a provided catalog to run the query against.
 * @return {Query} A new builder instance.
 */
function query(tableName) {
  return new Query(null, null, tableName);
}

/**
 * Create a new query instance from a serialized object.
 * @param {object} object A serialized query representation, such as
 *  those generated by query(...).toObject().
 * @returns {Query} The instantiated query instance.
 */
function queryFrom(object) {
  return Query.from(object);
}

/**
 * Model a query as a collection of serializble verbs.
 * Provides a table-like interface for constructing queries.
 */
class Query extends _table_transformable__WEBPACK_IMPORTED_MODULE_0__["default"] {

  /**
   * Construct a new query instance.
   * @param {Verb[]} verbs An array of verb instances.
   * @param {object} [params] Optional query parameters, corresponding
   *  to parameter references in table expressions.
   * @param {string} [table] Optional name of the table to query.
   */
  constructor(verbs, params, table) {
    super(params);
    this._verbs = verbs || [];
    this._table = table;
  }

  /**
   * Create a new query instance from the given serialized object.
   * @param {QueryObject} object A serialized query representation, such as
   *  those generated by Query.toObject.
   * @returns {Query} The instantiated query.
   */
  static from({ verbs, table, params }) {
    return new Query(verbs.map(_verb__WEBPACK_IMPORTED_MODULE_2__.Verb.from), params, table);
  }

  /**
   * Provide an informative object string tag.
   */
  get [Symbol.toStringTag]() {
    if (!this._verbs) return 'Object'; // bail if called on prototype
    const ns = this._verbs.length;
    return `Query: ${ns} verbs` + (this._table ? ` on '${this._table}'` : '');
  }

  /**
   * Return the number of verbs in this query.
   */
  get length() {
    return this._verbs.length;
  }

  /**
   * Return the name of the table this query applies to.
   * @return {string} The name of the source table, or undefined.
   */
  get tableName() {
    return this._table;
  }

  /**
   * Get or set table expression parameter values.
   * If called with no arguments, returns the current parameter values
   * as an object. Otherwise, adds the provided parameters to this
   * query's parameter set and returns the table. Any prior parameters
   * with names matching the input parameters are overridden.
   * @param {object} values The parameter values.
   * @return {Query|object} The current parameter values (if called
   *  with no arguments) or this query.
   */
  params(values) {
    if (arguments.length) {
      this._params = { ...this._params, ...values };
      return this;
    } else {
      return this._params;
    }
  }

  /**
   * Evaluate this query against a given table and catalog.
   * @param {Table} table The Arquero table to process.
   * @param {Function} catalog A table lookup function that accepts a table
   *  name string as input and returns a corresponding Arquero table.
   * @returns {Table} The resulting Arquero table.
   */
  evaluate(table, catalog) {
    table = table || catalog(this._table);
    for (const verb of this._verbs) {
      table = verb.evaluate(table.params(this._params), catalog);
    }
    return table;
  }

  /**
   * Serialize this query as a JSON-compatible object. The resulting
   * object can be passed to Query.from to re-instantiate this query.
   * @returns {object} A JSON-compatible object representing this query.
   */
  toObject() {
    return serialize(this, 'toObject');
  }

  /**
   * Serialize this query as a JSON-compatible object. The resulting
   * object can be passed to Query.from to re-instantiate this query.
   * This method simply returns the result of toObject, but is provided
   * as a separate method to allow later customization of JSON export.
   * @returns {object} A JSON-compatible object representing this query.
   */
  toJSON() {
    return this.toObject();
  }

  /**
   * Serialize this query to a JSON-compatible abstract syntax tree.
   * All table expressions will be parsed and represented as AST instances
   * using a modified form of the Mozilla JavaScript AST format.
   * This method can be used to output parsed and serialized representations
   * to translate Arquero queries to alternative data processing platforms.
   * @returns {object} A JSON-compatible abstract syntax tree object.
   */
  toAST() {
    return serialize(this, 'toAST', { type: _constants__WEBPACK_IMPORTED_MODULE_1__.Query });
  }
}

/**
 * Serialized object representation of a query.
 * @typedef {object} QueryObject
 * @property {object[]} verbs An array of verb definitions.
 * @property {object} [params] An object of parameter values.
 * @property {string} [table] The name of the table to query.
 */

function serialize(query, method, props) {
  return {
    ...props,
    verbs: query._verbs.map(verb => verb[method]()),
    ...(query._params ? { params: query._params } : null),
    ...(query._table ? { table: query._table } : null)
  };
}

function append(qb, verb) {
  return new Query(
    qb._verbs.concat(verb),
    qb._params,
    qb._table
  );
}

function addQueryVerb(name, verb) {
  Query.prototype[name] = function(...args) {
    return append(this, verb(...args));
  };
}

// Internal verb handlers
for (const name in _verb__WEBPACK_IMPORTED_MODULE_2__.Verbs) {
  const verb = _verb__WEBPACK_IMPORTED_MODULE_2__.Verbs[name];
  Query.prototype['__' + name] = function(qb, ...args) {
    return append(qb, verb(...args));
  };
}

/***/ }),

/***/ "../node_modules/arquero/src/query/to-ast.js":
/*!***************************************************!*\
  !*** ../node_modules/arquero/src/query/to-ast.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/is-array */ "../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-number */ "../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-object */ "../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-string */ "../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/to-array */ "../node_modules/arquero/src/util/to-array.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../expression/parse */ "../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/query/util.js");
/* harmony import */ var _expression_ast_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../expression/ast/constants */ "../node_modules/arquero/src/expression/ast/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./constants */ "../node_modules/arquero/src/query/constants.js");













const Methods = {
  [_constants__WEBPACK_IMPORTED_MODULE_10__.Expr]: astExpr,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.ExprList]: astExprList,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.ExprNumber]: astExprNumber,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.ExprObject]: astExprObject,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.JoinKeys]: astJoinKeys,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.JoinValues]: astJoinValues,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.OrderbyKeys]: astExprList,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.SelectionList]: astSelectionList
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value, type, propTypes) {
  return type === _constants__WEBPACK_IMPORTED_MODULE_10__.TableRef ? astTableRef(value)
    : type === _constants__WEBPACK_IMPORTED_MODULE_10__.TableRefList ? value.map(astTableRef)
    : ast((0,_util__WEBPACK_IMPORTED_MODULE_8__.toObject)(value), type, propTypes);
}

function ast(value, type, propTypes) {
  return type === _constants__WEBPACK_IMPORTED_MODULE_10__.Options
    ? (value ? astOptions(value, propTypes) : value)
    : Methods[type](value);
}

function astOptions(value, types = {}) {
  const output = {};
  for (const key in value) {
    const prop = value[key];
    output[key] = types[key] ? ast(prop, types[key]) : prop;
  }
  return output;
}

function astParse(expr, opt) {
  return (0,_expression_parse__WEBPACK_IMPORTED_MODULE_7__["default"])({ expr }, { ...opt, ast: true }).exprs[0];
}

function astColumn(name) {
  return { type: _expression_ast_constants__WEBPACK_IMPORTED_MODULE_9__.Column, name };
}

function astColumnIndex(index) {
  return { type: _expression_ast_constants__WEBPACK_IMPORTED_MODULE_9__.Column, index };
}

function astExprObject(obj, opt) {
  if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_5__["default"])(obj)) {
    return astParse(obj, opt);
  }

  if (obj.expr) {
    let ast;
    if (obj.field === true) {
      ast = astColumn(obj.expr);
    } else if (obj.func === true) {
      ast = astExprObject(obj.expr, opt);
    }
    if (ast) {
      if (obj.desc) {
        ast = { type: _constants__WEBPACK_IMPORTED_MODULE_10__.Descending, expr: ast };
      }
      if (obj.window) {
        ast = { type: _constants__WEBPACK_IMPORTED_MODULE_10__.Window, expr: ast, ...obj.window };
      }
      return ast;
    }
  }

  return Object.keys(obj)
    .map(key => ({
      ...astExprObject(obj[key], opt),
      as: key
    }));
}

function astSelection(sel) {
  const type = _constants__WEBPACK_IMPORTED_MODULE_10__.Selection;
  return sel.all ? { type, operator: 'all' }
    : sel.not ? { type, operator: 'not', arguments: astExprList(sel.not) }
    : sel.range ? { type, operator: 'range', arguments: astExprList(sel.range) }
    : sel.matches ? { type, operator: 'matches', arguments: sel.matches }
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])('Invalid input');
}

function astSelectionList(arr) {
  return (0,_util_to_array__WEBPACK_IMPORTED_MODULE_6__["default"])(arr).map(astSelectionItem).flat();
}

function astSelectionItem(val) {
  return (0,_util__WEBPACK_IMPORTED_MODULE_8__.isSelection)(val) ? astSelection(val)
    : (0,_util_is_number__WEBPACK_IMPORTED_MODULE_3__["default"])(val) ? astColumnIndex(val)
    : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_5__["default"])(val) ? astColumn(val)
    : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_4__["default"])(val) ? Object.keys(val)
      .map(name => ({ type: _expression_ast_constants__WEBPACK_IMPORTED_MODULE_9__.Column, name, as: val[name] }))
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])('Invalid input');
}

function astExpr(val) {
  return (0,_util__WEBPACK_IMPORTED_MODULE_8__.isSelection)(val) ? astSelection(val)
    : (0,_util_is_number__WEBPACK_IMPORTED_MODULE_3__["default"])(val) ? astColumnIndex(val)
    : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_5__["default"])(val) ? astColumn(val)
    : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_4__["default"])(val) ? astExprObject(val)
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])('Invalid input');
}

function astExprList(arr) {
  return (0,_util_to_array__WEBPACK_IMPORTED_MODULE_6__["default"])(arr).map(astExpr).flat();
}

function astExprNumber(val) {
  return (0,_util_is_number__WEBPACK_IMPORTED_MODULE_3__["default"])(val) ? val : astExprObject(val);
}

function astJoinKeys(val) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_1__["default"])(val)
    ? val.map(astExprList)
    : astExprObject(val, { join: true });
}

function astJoinValues(val) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_1__["default"])(val)
    ? val.map((v, i) => i < 2
        ? astExprList(v)
        : astExprObject(v, { join: true })
      )
    : astExprObject(val, { join: true });
}

function astTableRef(value) {
  return value && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_2__["default"])(value.toAST)
    ? value.toAST()
    : value;
}

/***/ }),

/***/ "../node_modules/arquero/src/query/util.js":
/*!*************************************************!*\
  !*** ../node_modules/arquero/src/query/util.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fromObject: () => (/* binding */ fromObject),
/* harmony export */   getTable: () => (/* binding */ getTable),
/* harmony export */   isSelection: () => (/* binding */ isSelection),
/* harmony export */   joinKeys: () => (/* binding */ joinKeys),
/* harmony export */   joinValues: () => (/* binding */ joinValues),
/* harmony export */   orderbyKeys: () => (/* binding */ orderbyKeys),
/* harmony export */   toObject: () => (/* binding */ toObject)
/* harmony export */ });
/* harmony import */ var _helpers_desc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/desc */ "../node_modules/arquero/src/helpers/desc.js");
/* harmony import */ var _helpers_field__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/field */ "../node_modules/arquero/src/helpers/field.js");
/* harmony import */ var _helpers_rolling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../helpers/rolling */ "../node_modules/arquero/src/helpers/rolling.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../helpers/selection */ "../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _query__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./query */ "../node_modules/arquero/src/query/query.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-array */ "../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util/is-number */ "../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../util/is-object */ "../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../util/is-string */ "../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_map_object__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../util/map-object */ "../node_modules/arquero/src/util/map-object.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../util/to-array */ "../node_modules/arquero/src/util/to-array.js");














function func(expr) {
  const f = d => d;
  f.toString = () => expr;
  return f;
}

function getTable(catalog, ref) {
  ref = ref && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(ref.query) ? ref.query() : ref;
  return ref && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(ref.evaluate)
    ? ref.evaluate(null, catalog)
    : catalog(ref);
}

function isSelection(value) {
  return (0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(value) && (
    (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.all) ||
    (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.matches) ||
    (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.not) ||
    (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.range)
  );
}

function toObject(value) {
  return value && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(value.toObject) ? value.toObject()
    : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(value) ? { expr: String(value), func: true }
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value) ? value.map(toObject)
    : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(value) ? (0,_util_map_object__WEBPACK_IMPORTED_MODULE_11__["default"])(value, _ => toObject(_))
    : value;
}

function fromObject(value) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value) ? value.map(fromObject)
    : !(0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(value) ? value
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.verbs) ? _query__WEBPACK_IMPORTED_MODULE_4__["default"].from(value)
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.all) ? (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_3__.all)()
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.range) ? (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_3__.range)(...value.range)
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.match) ? (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_3__.matches)(RegExp(...value.match))
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.not) ? (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_3__.not)(value.not.map(toObject))
    : fromExprObject(value);
}

function fromExprObject(value) {
  let output = value;
  let expr = value.expr;

  if (expr != null) {
    if (value.field === true) {
      output = expr = (0,_helpers_field__WEBPACK_IMPORTED_MODULE_1__["default"])(expr);
    } else if (value.func === true) {
      output = expr = func(expr);
    }

    if ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(value.window)) {
      const { frame, peers } = value.window;
      output = expr = (0,_helpers_rolling__WEBPACK_IMPORTED_MODULE_2__["default"])(expr, frame, peers);
    }

    if (value.desc === true) {
      output = (0,_helpers_desc__WEBPACK_IMPORTED_MODULE_0__["default"])(expr);
    }
  }

  return value === output
    ? (0,_util_map_object__WEBPACK_IMPORTED_MODULE_11__["default"])(value, _ => fromObject(_))
    : output;
}

function joinKeys(keys) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(keys) ? keys.map(parseJoinKeys)
    : keys;
}

function parseJoinKeys(keys) {
  const list = [];

  (0,_util_to_array__WEBPACK_IMPORTED_MODULE_12__["default"])(keys).forEach(param => {
    (0,_util_is_number__WEBPACK_IMPORTED_MODULE_8__["default"])(param) ? list.push(param)
      : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_10__["default"])(param) ? list.push((0,_helpers_field__WEBPACK_IMPORTED_MODULE_1__["default"])(param, null))
      : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(param) && param.expr ? list.push(param)
      : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(param) ? list.push(param)
      : (0,_util_error__WEBPACK_IMPORTED_MODULE_5__["default"])(`Invalid key value: ${param+''}`);
  });

  return list;
}

function joinValues(values) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(values)
    ? values.map(parseJoinValues)
    : values;
}

function parseJoinValues(values, index) {
  return index < 2 ? (0,_util_to_array__WEBPACK_IMPORTED_MODULE_12__["default"])(values) : values;
}

function orderbyKeys(keys) {
  const list = [];

  keys.forEach(param => {
    const expr = param.expr != null ? param.expr : param;
    if ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(expr) && !(0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(expr)) {
      for (const key in expr) {
        list.push(expr[key]);
      }
    } else {
      param = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_8__["default"])(expr) ? expr
        : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_10__["default"])(expr) ? (0,_helpers_field__WEBPACK_IMPORTED_MODULE_1__["default"])(param)
        : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(expr) ? param
        : (0,_util_error__WEBPACK_IMPORTED_MODULE_5__["default"])(`Invalid orderby field: ${param+''}`);
      list.push(param);
    }
  });

  return list;
}

/***/ }),

/***/ "../node_modules/arquero/src/query/verb.js":
/*!*************************************************!*\
  !*** ../node_modules/arquero/src/query/verb.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Verb: () => (/* binding */ Verb),
/* harmony export */   Verbs: () => (/* binding */ Verbs),
/* harmony export */   createVerb: () => (/* binding */ createVerb)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../node_modules/arquero/src/query/constants.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "../node_modules/arquero/src/query/util.js");
/* harmony import */ var _to_ast__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./to-ast */ "../node_modules/arquero/src/query/to-ast.js");








/**
 * Model an Arquero verb as a serializable object.
 */
class Verb {

  /**
   * Construct a new verb instance.
   * @param {string} verb The verb name.
   * @param {object[]} schema Schema describing verb parameters.
   * @param {any[]} params Array of parameter values.
   */
  constructor(verb, schema = [], params = []) {
    this.verb = verb;
    this.schema = schema;
    schema.forEach((s, index) => {
      const type = s.type;
      const param = params[index];
      const value = type === _constants__WEBPACK_IMPORTED_MODULE_0__.JoinKeys ? (0,_util__WEBPACK_IMPORTED_MODULE_1__.joinKeys)(param)
        : type === _constants__WEBPACK_IMPORTED_MODULE_0__.JoinValues ? (0,_util__WEBPACK_IMPORTED_MODULE_1__.joinValues)(param)
        : type === _constants__WEBPACK_IMPORTED_MODULE_0__.OrderbyKeys ? (0,_util__WEBPACK_IMPORTED_MODULE_1__.orderbyKeys)(param)
        : param;
      this[s.name] = value !== undefined ? value : s.default;
    });
  }

  /**
   * Create new verb instance from the given serialized object.
   * @param {object} object A serialized verb representation, such as
   *  those generated by Verb.toObject.
   * @returns {Verb} The instantiated verb.
   */
  static from(object) {
    const verb = Verbs[object.verb];
    const params = (verb.schema || [])
      .map(({ name }) => (0,_util__WEBPACK_IMPORTED_MODULE_1__.fromObject)(object[name]));
    return verb(...params);
  }

  /**
   * Evaluate this verb against a given table and catalog.
   * @param {Table} table The Arquero table to process.
   * @param {Function} catalog A table lookup function that accepts a table
   *  name string as input and returns a corresponding Arquero table.
   * @returns {Table} The resulting Arquero table.
   */
  evaluate(table, catalog) {
    const params = this.schema.map(({ name, type }) => {
      const value = this[name];
      return type === _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef ? (0,_util__WEBPACK_IMPORTED_MODULE_1__.getTable)(catalog, value)
        : type === _constants__WEBPACK_IMPORTED_MODULE_0__.TableRefList ? value.map(t => (0,_util__WEBPACK_IMPORTED_MODULE_1__.getTable)(catalog, t))
        : value;
    });
    return table[this.verb](...params);
  }

  /**
   * Serialize this verb as a JSON-compatible object. The resulting
   * object can be passed to Verb.from to re-instantiate this verb.
   * @returns {object} A JSON-compatible object representing this verb.
   */
  toObject() {
    const obj = { verb: this.verb };
    this.schema.forEach(({ name }) => {
      obj[name] = (0,_util__WEBPACK_IMPORTED_MODULE_1__.toObject)(this[name]);
    });
    return obj;
  }

  /**
   * Serialize this verb to a JSON-compatible abstract syntax tree.
   * All table expressions will be parsed and represented as AST instances
   * using a modified form of the Mozilla JavaScript AST format.
   * This method can be used to output parsed and serialized representations
   * to translate Arquero verbs to alternative data processing platforms.
   * @returns {object} A JSON-compatible abstract syntax tree object.
   */
  toAST() {
    const obj = { type: _constants__WEBPACK_IMPORTED_MODULE_0__.Verb, verb: this.verb };
    this.schema.forEach(({ name, type, props }) => {
      obj[name] = (0,_to_ast__WEBPACK_IMPORTED_MODULE_2__["default"])(this[name], type, props);
    });
    return obj;
  }
}

/**
 * Verb parameter type.
 * @typedef {Expr|ExprList|ExprNumber|ExprObject|JoinKeys|JoinValues|Options|OrderbyKeys|SelectionList|TableRef|TableRefList} ParamType
 */

/**
 * Verb parameter schema.
 * @typedef {object} ParamDef
 * @property {string} name The name of the parameter.
 * @property {ParamType} type The type of the parameter.
 * @property {{ [key: string]: ParamType }} [props] Types for non-literal properties.
 */

/**
 * Create a new constructors.
 * @param {string} name The name of the verb.
 * @param {ParamDef[]} schema The verb parameter schema.
 * @return {Function} A verb constructor function.
 */
function createVerb(name, schema) {
  return Object.assign(
    (...params) => new Verb(name, schema, params),
    { schema }
  );
}

/**
 * A lookup table of verb classes.
 */
const Verbs = {
  count:      createVerb('count', [
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  derive:     createVerb('derive', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprObject },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options,
                  props: { before: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList, after: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList }
                }
              ]),
  filter:     createVerb('filter', [
                { name: 'criteria', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprObject }
              ]),
  groupby:    createVerb('groupby', [
                { name: 'keys', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList }
              ]),
  orderby:    createVerb('orderby', [
                { name: 'keys', type: _constants__WEBPACK_IMPORTED_MODULE_0__.OrderbyKeys }
              ]),
  relocate:   createVerb('relocate', [
                { name: 'columns', type: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options,
                  props: { before: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList, after: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList }
                }
              ]),
  rename:     createVerb('rename', [
                { name: 'columns', type: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList }
              ]),
  rollup:     createVerb('rollup', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprObject }
              ]),
  sample:     createVerb('sample', [
                { name: 'size', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprNumber },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options, props: { weight: _constants__WEBPACK_IMPORTED_MODULE_0__.Expr } }
              ]),
  select:     createVerb('select', [
                { name: 'columns', type: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList }
              ]),
  ungroup:    createVerb('ungroup'),
  unorder:    createVerb('unorder'),
  reify:      createVerb('reify'),
  dedupe:     createVerb('dedupe', [
                { name: 'keys', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList, default: [] }
              ]),
  impute:     createVerb('impute', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprObject },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options, props: { expand: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList } }
              ]),
  fold:       createVerb('fold', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  pivot:      createVerb('pivot', [
                { name: 'keys', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList },
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  spread:     createVerb('spread', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  unroll:     createVerb('unroll', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options, props: { drop: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList } }
              ]),
  lookup:     createVerb('lookup', [
                { name: 'table', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef },
                { name: 'on', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinKeys },
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList }
              ]),
  join:       createVerb('join', [
                { name: 'table', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef },
                { name: 'on', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinKeys },
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinValues },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  cross:      createVerb('cross', [
                { name: 'table', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef },
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinValues },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  semijoin:   createVerb('semijoin', [
                { name: 'table', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef },
                { name: 'on', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinKeys }
              ]),
  antijoin:   createVerb('antijoin', [
                { name: 'table', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef },
                { name: 'on', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinKeys }
              ]),
  concat:     createVerb('concat', [
                { name: 'tables', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRefList }
              ]),
  union:      createVerb('union', [
                { name: 'tables', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRefList }
              ]),
  intersect:  createVerb('intersect', [
                { name: 'tables', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRefList }
              ]),
  except:     createVerb('except', [
                { name: 'tables', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRefList }
              ])
};

/***/ }),

/***/ "../node_modules/arquero/src/register.js":
/*!***********************************************!*\
  !*** ../node_modules/arquero/src/register.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addAggregateFunction: () => (/* binding */ addAggregateFunction),
/* harmony export */   addFunction: () => (/* binding */ addFunction),
/* harmony export */   addPackage: () => (/* binding */ addPackage),
/* harmony export */   addTableMethod: () => (/* binding */ addTableMethod),
/* harmony export */   addVerb: () => (/* binding */ addVerb),
/* harmony export */   addWindowFunction: () => (/* binding */ addWindowFunction)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./table/column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _op_aggregate_functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./op/aggregate-functions */ "../node_modules/arquero/src/op/aggregate-functions.js");
/* harmony import */ var _op_window_functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./op/window-functions */ "../node_modules/arquero/src/op/window-functions.js");
/* harmony import */ var _op_functions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./op/functions */ "../node_modules/arquero/src/op/functions/index.js");
/* harmony import */ var _op_op__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./op/op */ "../node_modules/arquero/src/op/op.js");
/* harmony import */ var _op_op_api__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./op/op-api */ "../node_modules/arquero/src/op/op-api.js");
/* harmony import */ var _query_query__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./query/query */ "../node_modules/arquero/src/query/query.js");
/* harmony import */ var _query_verb__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./query/verb */ "../node_modules/arquero/src/query/verb.js");
/* harmony import */ var _expression_row_object__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./expression/row-object */ "../node_modules/arquero/src/expression/row-object.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./util/has */ "../node_modules/arquero/src/util/has.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./util/to-string */ "../node_modules/arquero/src/util/to-string.js");













const onIllegal = (name, type) =>
  (0,_util_error__WEBPACK_IMPORTED_MODULE_9__["default"])(`Illegal ${type} name: ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_11__["default"])(name)}`);

const onDefined = (name, type) =>
  (0,_util_error__WEBPACK_IMPORTED_MODULE_9__["default"])(`The ${type} ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_11__["default"])(name)} is already defined. Use override option?`);

const onReserve = (name, type) =>
  (0,_util_error__WEBPACK_IMPORTED_MODULE_9__["default"])(`The ${type} name ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_11__["default"])(name)} is reserved and can not be overridden.`);

function check(name, options, obj = _op_op_api__WEBPACK_IMPORTED_MODULE_5__["default"], type = 'function') {
  if (!name) onIllegal(name, type);
  if (!options.override && (0,_util_has__WEBPACK_IMPORTED_MODULE_10__["default"])(obj, name)) onDefined(name, type);
}

// -- Op Functions --------------------------------------------------

function verifyFunction(name, def, object, options) {
  return object[name] === def || check(name, options);
}

/**
 * Register an aggregate or window operation.
 * @param {string} name The name of the operation
 * @param {AggregateDef|WindowDef} def The operation definition.
 * @param {object} object The registry object to add the definition to.
 * @param {RegisterOptions} [options] Registration options.
 */
function addOp(name, def, object, options = {}) {
  if (verifyFunction(name, def, object, options)) return;
  const [nf = 0, np = 0] = def.param;
  object[name] = def;
  _op_op_api__WEBPACK_IMPORTED_MODULE_5__["default"][name] = (...params) => (0,_op_op__WEBPACK_IMPORTED_MODULE_4__["default"])(
    name,
    params.slice(0, nf),
    params.slice(nf, nf + np)
  );
}

/**
 * Register a custom aggregate function.
 * @param {string} name The name to use for the aggregate function.
 * @param {AggregateDef} def The aggregate operator definition.
 * @param {RegisterOptions} [options] Function registration options.
 * @throws If a function with the same name is already registered and
 *  the override option is not specified.
 */
function addAggregateFunction(name, def, options) {
  addOp(name, def, _op_aggregate_functions__WEBPACK_IMPORTED_MODULE_1__["default"], options);
}

/**
 * Register a custom window function.
 * @param {string} name The name to use for the window function.
 * @param {WindowDef} def The window operator definition.
 * @param {RegisterOptions} [options] Function registration options.
 * @throws If a function with the same name is already registered and
 *  the override option is not specified.
 */
function addWindowFunction(name, def, options) {
  addOp(name, def, _op_window_functions__WEBPACK_IMPORTED_MODULE_2__["default"], options);
}

/**
 * Register a function for use within table expressions.
 * If only a single argument is provided, it will be assumed to be a
 * function and the system will try to extract its name.
 * @param {string} name The name to use for the function.
 * @param {Function} fn A standard JavaScript function.
 * @param {RegisterOptions} [options] Function registration options.
 * @throws If a function with the same name is already registered and
 *  the override option is not specified, or if no name is provided
 *  and the input function is anonymous.
 */
function addFunction(name, fn, options = {}) {
  if (arguments.length === 1) {
    fn = name;
    name = fn.name;
    if (name === '' || name === 'anonymous') {
      (0,_util_error__WEBPACK_IMPORTED_MODULE_9__["default"])('Anonymous function provided, please include a name argument.');
    } else if (name === _expression_row_object__WEBPACK_IMPORTED_MODULE_8__.ROW_OBJECT) {
      onReserve(_expression_row_object__WEBPACK_IMPORTED_MODULE_8__.ROW_OBJECT, 'function');
    }
  }
  if (verifyFunction(name, fn, _op_functions__WEBPACK_IMPORTED_MODULE_3__["default"], options)) return;
  _op_functions__WEBPACK_IMPORTED_MODULE_3__["default"][name] = fn;
  _op_op_api__WEBPACK_IMPORTED_MODULE_5__["default"][name] = fn;
}

// -- Table Methods and Verbs ---------------------------------------

const proto = _table_column_table__WEBPACK_IMPORTED_MODULE_0__["default"].prototype;

/**
 * Reserved table/query methods that must not be overwritten.
 */
let RESERVED;

function addReserved(obj) {
  for (; obj; obj = Object.getPrototypeOf(obj)) {
    Object.getOwnPropertyNames(obj).forEach(name => RESERVED[name] = 1);
  }
}

function verifyTableMethod(name, fn, options) {
  const type = 'method';

  // exit early if duplicate re-assignment
  if (proto[name] && proto[name].fn === fn) return true;

  // initialize reserved properties to avoid overriding internals
  if (!RESERVED) {
    RESERVED = {};
    addReserved(proto);
    addReserved(_query_query__WEBPACK_IMPORTED_MODULE_6__["default"].prototype);
  }

  // perform name checks
  if (RESERVED[name]) onReserve(name, type);
  if ((name + '')[0] === '_') onIllegal(name, type);
  check(name, options, proto, type);
}

/**
 * Register a new table method. A new method will be added to the column
 * table prototype. When invoked from a table, the registered method will
 * be invoked with the table as the first argument, followed by all the
 * provided arguments.
 * @param {string} name The name of the table method.
 * @param {Function} method The table method.
 * @param {RegisterOptions} options
 */
function addTableMethod(name, method, options = {}) {
  if (verifyTableMethod(name, method, options)) return;
  proto[name] = function(...args) { return method(this, ...args); };
  proto[name].fn = method;
}

/**
 * Register a new transformation verb.
 * @param {string} name The name of the verb.
 * @param {Function} method The verb implementation.
 * @param {ParamDef[]} params The verb parameter schema.
 * @param {RegisterOptions} options Function registration options.
 */
function addVerb(name, method, params, options = {}) {
  // register table method first
  // if that doesn't throw, add serializable verb entry
  addTableMethod(name, method, options);
  (0,_query_query__WEBPACK_IMPORTED_MODULE_6__.addQueryVerb)(name, _query_verb__WEBPACK_IMPORTED_MODULE_7__.Verbs[name] = (0,_query_verb__WEBPACK_IMPORTED_MODULE_7__.createVerb)(name, params));
}

// -- Package Bundles -----------------------------------------------

const PACKAGE = 'arquero_package';

/**
 * Add an extension package of functions, table methods, and/or verbs.
 * @param {Package|PackageBundle} bundle The package of extensions.
 * @throws If package validation fails.
 */
function addPackage(bundle, options = {}) {
  const pkg = bundle && bundle[PACKAGE] || bundle;
  const parts = {
    functions: [
      (name, def, opt) => verifyFunction(name, def, _op_functions__WEBPACK_IMPORTED_MODULE_3__["default"], opt),
      addFunction
    ],
    aggregateFunctions: [
      (name, def, opt) => verifyFunction(name, def, _op_aggregate_functions__WEBPACK_IMPORTED_MODULE_1__["default"], opt),
      addAggregateFunction
    ],
    windowFunctions: [
      (name, def, opt) => verifyFunction(name, def, _op_window_functions__WEBPACK_IMPORTED_MODULE_2__["default"], opt),
      addWindowFunction
    ],
    tableMethods: [
      verifyTableMethod,
      addTableMethod
    ],
    verbs: [
      (name, obj, opt) => verifyTableMethod(name, obj.method, opt),
      (name, obj, opt) => addVerb(name, obj.method, obj.params, opt)
    ]
  };

  function scan(index) {
    for (const key in parts) {
      const part = parts[key];
      const p = pkg[key];
      for (const name in p) part[index](name, p[name], options);
    }
  }
  scan(0); // first validate package, throw if validation fails
  scan(1); // then add package content
}

/**
 * Aggregate function definition.
 * @typedef {import('./op/aggregate-functions').AggregateDef} AggregateDef
 */

/**
 * Window function definition.
 * @typedef {import('./op/window-functions').WindowDef} WindowDef
 */

/**
 * Verb parameter definition.
 * @typedef {import('./query/verb').ParamDef} ParamDef
 */

/**
 * Verb definition.
 * @typedef {object} VerbDef
 * @property {Function} method A function implementing the verb.
 * @property {ParamDef[]} params The verb parameter schema.
 */

/**
 * Verb parameter definition.
 * @typedef {object} ParamDef
 * @property {string} name The verb parameter name.
 * @property {ParamType} type The verb parameter type.
 */

/**
 * A package of op function and table method definitions.
 * @typedef {object} Package
 * @property {{[name: string]: Function}} [functions] Standard function entries.
 * @property {{[name: string]: AggregateDef}} [aggregateFunctions] Aggregate function entries.
 * @property {{[name: string]: WindowDef}} [windowFunctions] Window function entries.
 * @property {{[name: string]: Function}} [tableMethods] Table method entries.
 * @property {{[name: string]: VerbDef}} [verbs] Verb entries.
 */

/**
 * An object containing an extension package.
 * @typedef {object} PackageBundle
 * @property {Package} arquero.package The package bundle.
 */

/**
 * Options for registering new functions.
 * @typedef {object} RegisterOptions
 * @property {boolean} [override=false] Flag indicating if the added
 *  function can override an existing function with the same name.
 */

/***/ }),

/***/ "../node_modules/arquero/src/table/bit-set.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/table/bit-set.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BitSet)
/* harmony export */ });
const ONE = 0x80000000;
const ALL = 0xFFFFFFFF;

/**
 * Represent an indexable set of bits.
 */
class BitSet {
  /**
   * Instantiate a new BitSet instance.
   * @param {number} size The number of bits.
   */
  constructor(size) {
    this._size = size;
    this._bits = new Uint32Array(Math.ceil(size / 32));
  }

  /**
   * The number of bits.
   * @return {number}
   */
  get length() {
    return this._size;
  }

  /**
   * The number of bits set to one.
   * https://graphics.stanford.edu/~seander/bithacks.html#CountBitsSetKernighan
   * @return {number}
   */
  count() {
    const n = this._bits.length;
    let count = 0;
    for (let i = 0; i < n; ++i) {
      for (let b = this._bits[i]; b; ++count) {
        b &= b - 1;
      }
    }
    return count;
  }

  /**
   * Get the bit at a given index.
   * @param {number} i The bit index.
   */
  get(i) {
    return this._bits[i >> 5] & (ONE >>> i);
  }

  /**
   * Set the bit at a given index to one.
   * @param {number} i The bit index.
   */
  set(i) {
    this._bits[i >> 5] |= (ONE >>> i);
  }

  /**
   * Clear the bit at a given index to zero.
   * @param {number} i The bit index.
   */
  clear(i) {
    this._bits[i >> 5] &= ~(ONE >>> i);
  }

  /**
   * Scan the bits, invoking a callback function with the index of
   * each non-zero bit.
   * @param {(i: number) => void} fn A callback function.
   */
  scan(fn) {
    for (let i = this.next(0); i >= 0; i = this.next(i + 1)) {
      fn(i);
    }
  }

  /**
   * Get the next non-zero bit starting from a given index.
   * @param {number} i The bit index.
   */
  next(i) {
    const bits = this._bits;
    const n = bits.length;

    let index = i >> 5;
    let curr = bits[index] & (ALL >>> i);

    for (; index < n; curr = bits[++index]) {
      if (curr !== 0) {
        return (index << 5) + Math.clz32(curr);
      }
    }

    return -1;
  }

  /**
   * Return the index of the nth non-zero bit.
   * @param {number} n The number of non-zero bits to advance.
   * @return {number} The index of the nth non-zero bit.
   */
  nth(n) {
    let i = this.next(0);
    while (n-- && i >= 0) i = this.next(i + 1);
    return i;
  }

  /**
   * Negate all bits in this bitset.
   * Modifies this BitSet in place.
   * @return {this}
   */
  not() {
    const bits = this._bits;
    const n = bits.length;

    // invert all bits
    for (let i = 0; i < n; ++i) {
      bits[i] = ~bits[i];
    }

    // unset extraneous trailing bits
    const tail = this._size % 32;
    if (tail) {
      bits[n - 1] &= ONE >> (tail - 1);
    }

    return this;
  }

  /**
   * Compute the logical AND of this BitSet and another.
   * @param {BitSet} bitset The BitSet to combine with.
   * @return {BitSet} This BitSet updated with the logical AND.
   */
  and(bitset) {
    if (bitset) {
      const a = this._bits;
      const b = bitset._bits;
      const n = a.length;

      for (let i = 0; i < n; ++i) {
        a[i] &= b[i];
      }
    }
    return this;
  }

  /**
   * Compute the logical OR of this BitSet and another.
   * @param {BitSet} bitset The BitSet to combine with.
   * @return {BitSet} This BitSet updated with the logical OR.
   */
  or(bitset) {
    if (bitset) {
      const a = this._bits;
      const b = bitset._bits;
      const n = a.length;

      for (let i = 0; i < n; ++i) {
        a[i] |= b[i];
      }
    }
    return this;
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/table/column-set.js":
/*!*******************************************************!*\
  !*** ../node_modules/arquero/src/table/column-set.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/has */ "../node_modules/arquero/src/util/has.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table) {
  return table
    ? new ColumnSet({ ...table.data() }, table.columnNames())
    : new ColumnSet();
}

class ColumnSet {
  constructor(data, names) {
    this.data = data || {};
    this.names = names || [];
  }

  add(name, values) {
    if (!this.has(name)) this.names.push(name + '');
    return this.data[name] = values;
  }

  has(name) {
    return (0,_util_has__WEBPACK_IMPORTED_MODULE_0__["default"])(this.data, name);
  }

  new() {
    this.filter = null;
    this.groups = this.groups || null;
    this.order = null;
    return this;
  }

  groupby(groups) {
    this.groups = groups;
    return this;
  }
}

/***/ }),

/***/ "../node_modules/arquero/src/table/column-table.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/table/column-table.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ColumnTable)
/* harmony export */ });
/* harmony import */ var _column__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./column */ "../node_modules/arquero/src/table/column.js");
/* harmony import */ var _columns_from__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./columns-from */ "../node_modules/arquero/src/table/columns-from.js");
/* harmony import */ var _column_set__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./column-set */ "../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _table__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./table */ "../node_modules/arquero/src/table/table.js");
/* harmony import */ var _regroup__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./regroup */ "../node_modules/arquero/src/table/regroup.js");
/* harmony import */ var _expression_row_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../expression/row-object */ "../node_modules/arquero/src/expression/row-object.js");
/* harmony import */ var _format_to_arrow__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../format/to-arrow */ "../node_modules/arquero/src/format/to-arrow.js");
/* harmony import */ var _format_to_csv__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../format/to-csv */ "../node_modules/arquero/src/format/to-csv.js");
/* harmony import */ var _format_to_html__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../format/to-html */ "../node_modules/arquero/src/format/to-html.js");
/* harmony import */ var _format_to_json__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../format/to-json */ "../node_modules/arquero/src/format/to-json.js");
/* harmony import */ var _format_to_markdown__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../format/to-markdown */ "../node_modules/arquero/src/format/to-markdown.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../helpers/selection */ "../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _util_array_type__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../util/array-type */ "../node_modules/arquero/src/util/array-type.js");
/* harmony import */ var _util_entries__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../util/entries */ "../node_modules/arquero/src/util/entries.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_map_object__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../util/map-object */ "../node_modules/arquero/src/util/map-object.js");

















/**
 * Class representing a table backed by a named set of columns.
 */
class ColumnTable extends _table__WEBPACK_IMPORTED_MODULE_3__["default"] {

  /**
   * Create a new ColumnTable from existing input data.
   * @param {object[]|Iterable<object>|object|Map} values The backing table data values.
   *  If array-valued, should be a list of JavaScript objects with
   *  key-value properties for each column value.
   *  If object- or Map-valued, a table with two columns (one for keys,
   *  one for values) will be created.
   * @param {string[]} [names] The named columns to include.
   * @return {ColumnTable} A new ColumnTable instance.
   */
  static from(values, names) {
    return new ColumnTable((0,_columns_from__WEBPACK_IMPORTED_MODULE_1__["default"])(values, names), names);
  }

  /**
   * Create a new table for a set of named columns.
   * @param {object|Map} columns
   *  The set of named column arrays. Keys are column names.
   *  The enumeration order of the keys determines the column indices,
   *  unless the names parameter is specified.
   *  Values must be arrays (or array-like values) of identical length.
   * @param {string[]} [names] Ordered list of column names. If specified,
   *  this array determines the column indices. If not specified, the
   *  key enumeration order of the columns object is used.
   * @return {ColumnTable} the instantiated ColumnTable instance.
   */
  static new(columns, names) {
    if (columns instanceof ColumnTable) return columns;
    const data = {};
    const keys = [];
    for (const [key, value] of (0,_util_entries__WEBPACK_IMPORTED_MODULE_13__["default"])(columns)) {
      data[key] = value;
      keys.push(key);
    }
    return new ColumnTable(data, names || keys);
  }

  /**
   * Instantiate a new ColumnTable instance.
   * @param {object} columns An object mapping column names to values.
   * @param {string[]} [names] An ordered list of column names.
   * @param {BitSet} [filter] A filtering BitSet.
   * @param {GroupBySpec} [group] A groupby specification.
   * @param {RowComparator} [order] A row comparator function.
   * @param {Params} [params] An object mapping parameter names to values.
   */
  constructor(columns, names, filter, group, order, params) {
    (0,_util_map_object__WEBPACK_IMPORTED_MODULE_15__["default"])(columns, _column__WEBPACK_IMPORTED_MODULE_0__.defaultColumnFactory, columns);
    names = names || Object.keys(columns);
    const nrows = names.length ? columns[names[0]].length : 0;
    super(names, nrows, columns, filter, group, order, params);
  }

  /**
   * Create a new table with the same type as this table.
   * The new table may have different data, filter, grouping, or ordering
   * based on the values of the optional configuration argument. If a
   * setting is not specified, it is inherited from the current table.
   * @param {CreateOptions} [options] Creation options for the new table.
   * @return {ColumnTable} A newly created table.
   */
  create({ data, names, filter, groups, order }) {
    const f = filter !== undefined ? filter : this.mask();

    return new ColumnTable(
      data || this._data,
      names || (!data ? this._names : null),
      f,
      groups !== undefined ? groups : (0,_regroup__WEBPACK_IMPORTED_MODULE_4__.regroup)(this._group, filter && f),
      order !== undefined ? order : this._order,
      this._params
    );
  }

  /**
   * Create a new table with additional columns drawn from one or more input
   * tables. All tables must have the same numer of rows and are reified
   * prior to assignment. In the case of repeated column names, input table
   * columns overwrite existing columns.
   * @param {...ColumnTable} tables The tables to merge with this table.
   * @return {ColumnTable} A new table with merged columns.
   * @example table.assign(table1, table2)
   */
  assign(...tables) {
    const nrows = this.numRows();
    const base = this.reify();
    const cset = (0,_column_set__WEBPACK_IMPORTED_MODULE_2__["default"])(base).groupby(base.groups());
    tables.forEach(input => {
      input = ColumnTable.new(input);
      if (input.numRows() !== nrows) (0,_util_error__WEBPACK_IMPORTED_MODULE_14__["default"])('Assign row counts do not match');
      input = input.reify();
      input.columnNames(name => cset.add(name, input.column(name)));
    });
    return this.create(cset.new());
  }

  /**
   * Get the backing set of columns for this table.
   * @return {ColumnData} Object of named column instances.
   */
  columns() {
    return this._data;
  }

  /**
   * Get the column instance with the given name.
   * @param {string} name The column name.
   * @return {ColumnType | undefined} The named column, or undefined if it does not exist.
   */
  column(name) {
    return this._data[name];
  }

  /**
   * Get the column instance at the given index position.
   * @param {number} index The zero-based column index.
   * @return {ColumnType | undefined} The column, or undefined if it does not exist.
   */
  columnAt(index) {
    return this._data[this._names[index]];
  }

  /**
   * Get an array of values contained in a column. The resulting array
   * respects any table filter or orderby criteria.
   * @param {string} name The column name.
   * @param {ArrayConstructor|import('./table').TypedArrayConstructor} [constructor=Array]
   *  The array constructor for instantiating the output array.
   * @return {import('./table').DataValue[]|import('./table).TypedArray} The array of column values.
   */
  array(name, constructor = Array) {
    const column = this.column(name);
    const array = new constructor(this.numRows());
    let idx = -1;
    this.scan(row => array[++idx] = column.get(row), true);
    return array;
  }

  /**
   * Get the value for the given column and row.
   * @param {string} name The column name.
   * @param {number} [row=0] The row index, defaults to zero if not specified.
   * @return {import('./table').DataValue} The table value at (column, row).
   */
  get(name, row = 0) {
    const column = this.column(name);
    return this.isFiltered() || this.isOrdered()
      ? column.get(this.indices()[row])
      : column.get(row);
  }

  /**
   * Returns an accessor ("getter") function for a column. The returned
   * function takes a row index as its single argument and returns the
   * corresponding column value.
   * @param {string} name The column name.
   * @return {import('./table').ColumnGetter} The column getter function.
   */
  getter(name) {
    const column = this.column(name);
    const indices = this.isFiltered() || this.isOrdered() ? this.indices() : null;
    return indices ? row => column.get(indices[row])
      : column ? row => column.get(row)
      : (0,_util_error__WEBPACK_IMPORTED_MODULE_14__["default"])(`Unrecognized column: ${name}`);
  }

  /**
   * Returns an object representing a table row.
   * @param {number} [row=0] The row index, defaults to zero if not specified.
   * @return {object} A row object with named properties for each column.
   */
  object(row = 0) {
    return objectBuilder(this)(row);
  }

  /**
   * Returns an array of objects representing table rows.
   * @param {ObjectsOptions} [options] The options for row object generation.
   * @return {object[]} An array of row objects.
   */
  objects(options = {}) {
    const { grouped, limit, offset } = options;

    // generate array of row objects
    const names = (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_11__["default"])(this, options.columns || (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_11__.all)());
    const create = (0,_expression_row_object__WEBPACK_IMPORTED_MODULE_5__.rowObjectBuilder)(names);
    const obj = [];
    this.scan(
      (row, data) => obj.push(create(row, data)),
      true, limit, offset
    );

    // produce nested output as requested
    if (grouped && this.isGrouped()) {
      const idx = [];
      this.scan(row => idx.push(row), true, limit, offset);
      return (0,_regroup__WEBPACK_IMPORTED_MODULE_4__.nest)(this, idx, obj, grouped);
    }

    return obj;
  }

  /**
   * Returns an iterator over objects representing table rows.
   * @return {Iterator<object>} An iterator over row objects.
   */
  *[Symbol.iterator]() {
    const create = objectBuilder(this);
    const n = this.numRows();
    for (let i = 0; i < n; ++i) {
      yield create(i);
    }
  }

  /**
   * Create a new fully-materialized instance of this table.
   * All filter and orderby settings are removed from the new table.
   * Instead, the backing data itself is filtered and ordered as needed.
   * @param {number[]} [indices] Ordered row indices to materialize.
   *  If unspecified, all rows passing the table filter are used.
   * @return {ColumnTable} A reified table.
   */
  reify(indices) {
    const nrows = indices ? indices.length : this.numRows();
    const names = this._names;
    let data, groups;

    if (!indices && !this.isOrdered()) {
      if (!this.isFiltered()) {
        return this; // data already reified
      } else if (nrows === this.totalRows()) {
        data = this.data(); // all rows pass filter, skip copy
      }
    }

    if (!data) {
      const scan = indices ? f => indices.forEach(f) : f => this.scan(f, true);
      const ncols = names.length;
      data = {};

      for (let i = 0; i < ncols; ++i) {
        const name = names[i];
        const prev = this.column(name);
        const curr = data[name] = new ((0,_util_array_type__WEBPACK_IMPORTED_MODULE_12__["default"])(prev))(nrows);
        let r = -1;
        scan(row => curr[++r] = prev.get(row));
      }

      if (this.isGrouped()) {
        groups = (0,_regroup__WEBPACK_IMPORTED_MODULE_4__.reindex)(this.groups(), scan, !!indices, nrows);
      }
    }

    return this.create({ data, names, groups, filter: null, order: null });
  }

  /**
   * Apply a sequence of transformations to this table. The output
   * of each transform is passed as input to the next transform, and
   * the output of the last transform is then returned.
   * @param {...(Transform|Transform[])} transforms Transformation
   *  functions to apply to the table in sequence. Each function should
   *  take a single table as input and return a table as output.
   * @return {ColumnTable} The output of the last transform.
   */
  transform(...transforms) {
    return transforms.flat().reduce((t, f) => f(t), this);
  }

  /**
   * Format this table as an Apache Arrow table.
   * @param {ArrowFormatOptions} [options] The formatting options.
   * @return {import('apache-arrow').Table} An Apache Arrow table.
   */
  toArrow(options) {
    return (0,_format_to_arrow__WEBPACK_IMPORTED_MODULE_6__["default"])(this, options);
  }

  /**
   * Format this table as binary data in the Apache Arrow IPC format.
   * @param {ArrowFormatOptions} [options] The formatting options.
   * @return {Uint8Array} A new Uint8Array of Arrow-encoded binary data.
   */
  toArrowBuffer(options) {
    return (0,_format_to_arrow__WEBPACK_IMPORTED_MODULE_6__["default"])(this, options).serialize();
  }

  /**
   * Format this table as a comma-separated values (CSV) string. Other
   * delimiters, such as tabs or pipes ('|'), can be specified using
   * the options argument.
   * @param {CSVFormatOptions} [options] The formatting options.
   * @return {string} A delimited value string.
   */
  toCSV(options) {
    return (0,_format_to_csv__WEBPACK_IMPORTED_MODULE_7__["default"])(this, options);
  }

  /**
   * Format this table as an HTML table string.
   * @param {HTMLFormatOptions} [options] The formatting options.
   * @return {string} An HTML table string.
   */
  toHTML(options) {
    return (0,_format_to_html__WEBPACK_IMPORTED_MODULE_8__["default"])(this, options);
  }

  /**
   * Format this table as a JavaScript Object Notation (JSON) string.
   * @param {JSONFormatOptions} [options] The formatting options.
   * @return {string} A JSON string.
   */
  toJSON(options) {
    return (0,_format_to_json__WEBPACK_IMPORTED_MODULE_9__["default"])(this, options);
  }

  /**
   * Format this table as a GitHub-Flavored Markdown table string.
   * @param {MarkdownFormatOptions} [options] The formatting options.
   * @return {string} A GitHub-Flavored Markdown table string.
   */
  toMarkdown(options) {
    return (0,_format_to_markdown__WEBPACK_IMPORTED_MODULE_10__["default"])(this, options);
  }
}

function objectBuilder(table) {
  let b = table._builder;

  if (!b) {
    const create = (0,_expression_row_object__WEBPACK_IMPORTED_MODULE_5__.rowObjectBuilder)(table.columnNames());
    const data = table.data();
    if (table.isOrdered() || table.isFiltered()) {
      const indices = table.indices();
      b = row => create(indices[row], data);
    } else {
      b = row => create(row, data);
    }
    table._builder = b;
  }

  return b;
}

/**
 * A table transformation.
 * @typedef {(table: ColumnTable) => ColumnTable} Transform
 */

/**
 * Proxy type for BitSet class.
 * @typedef {import('./table').BitSet} BitSet
 */

/**
 * Proxy type for ColumnType interface.
 * @typedef {import('./column').ColumnType} ColumnType
 */

/**
 * A named collection of columns.
 * @typedef {{[key: string]: ColumnType}} ColumnData
 */

/**
 * Proxy type for GroupBySpec.
 * @typedef {import('./table').GroupBySpec} GroupBySpec
 */

/**
 * Proxy type for RowComparator.
 * @typedef {import('./table').RowComparator} RowComparator
 */

/**
 * Proxy type for Params.
 * @typedef {import('./table').Params} Params
 */

/**
 * Options for Arrow formatting.
 * @typedef {import('../arrow/encode').ArrowFormatOptions} ArrowFormatOptions
 */

/**
 * Options for CSV formatting.
 * @typedef {import('../format/to-csv').CSVFormatOptions} CSVFormatOptions
 */

/**
 * Options for HTML formatting.
 * @typedef {import('../format/to-html').HTMLFormatOptions} HTMLFormatOptions
 */

/**
 * Options for JSON formatting.
 * @typedef {import('../format/to-json').JSONFormatOptions} JSONFormatOptions
 */

/**
 * Options for Markdown formatting.
 * @typedef {import('../format/to-markdown').MarkdownFormatOptions} MarkdownFormatOptions
 */

/***/ }),

/***/ "../node_modules/arquero/src/table/column.js":
/*!***************************************************!*\
  !*** ../node_modules/arquero/src/table/column.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   columnFactory: () => (/* binding */ columnFactory),
/* harmony export */   "default": () => (/* binding */ Column),
/* harmony export */   defaultColumnFactory: () => (/* binding */ defaultColumnFactory)
/* harmony export */ });
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");


/**
 * Class representing an array-backed data column.
 */
class Column {
  /**
   * Create a new column instance.
   * @param {Array} data The backing array (or array-like object)
   *  containing the column data.
   */
  constructor(data) {
    this.data = data;
  }

  /**
   * Get the length (number of rows) of the column.
   * @return {number} The length of the column array.
   */
  get length() {
    return this.data.length;
  }

  /**
   * Get the column value at the given row index.
   * @param {number} row The row index of the value to retrieve.
   * @return {import('./table').DataValue} The column value.
   */
  get(row) {
    return this.data[row];
  }

  /**
   * Returns an iterator over the column values.
   * @return {Iterator<object>} An iterator over column values.
   */
  [Symbol.iterator]() {
    return this.data[Symbol.iterator]();
  }
}

/**
 * Column interface. Any object that adheres to this interface
 * can be used as a data column within a {@link ColumnTable}.
 * @typedef {object} ColumnType
 * @property {number} length
 *  The length (number of rows) of the column.
 * @property {import('./table').ColumnGetter} get
 *  Column value getter.
 */

/**
 * Column factory function interface.
 * @callback ColumnFactory
 * @param {*} data The input column data.
 * @return {ColumnType} A column instance.
 */

/**
 * Create a new column from the given input data.
 * @param {any} data The backing column data. If the value conforms to
 *  the Column interface it is returned directly. If the value is an
 *  array, it will be wrapped in a new Column instance.
 * @return {ColumnType} A compatible column instance.
 */
let defaultColumnFactory = function(data) {
  return data && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_0__["default"])(data.get) ? data : new Column(data);
};

/**
 * Get or set the default factory function for instantiating table columns.
 * @param {ColumnFactory} [factory] The new default factory.
 * @return {ColumnFactory} The current default column factory.
 */
function columnFactory(factory) {
  return arguments.length
    ? (defaultColumnFactory = factory)
    : defaultColumnFactory;
}

/***/ }),

/***/ "../node_modules/arquero/src/table/columns-from.js":
/*!*********************************************************!*\
  !*** ../node_modules/arquero/src/table/columns-from.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/is-array */ "../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-date */ "../node_modules/arquero/src/util/is-date.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-function */ "../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-object */ "../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_regexp__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-regexp */ "../node_modules/arquero/src/util/is-regexp.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-string */ "../node_modules/arquero/src/util/is-string.js");








/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(values, names) {
  const raise = type => (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])(`Illegal argument type: ${type || typeof values}`);
  return values instanceof Map ? fromKeyValuePairs(values.entries(), names)
    : (0,_util_is_date__WEBPACK_IMPORTED_MODULE_2__["default"])(values) ? raise('Date')
    : (0,_util_is_regexp__WEBPACK_IMPORTED_MODULE_5__["default"])(values) ? raise('RegExp')
    : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_6__["default"])(values) ? raise()
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_1__["default"])(values) ? fromArray(values, names)
    : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_3__["default"])(values[Symbol.iterator]) ? fromIterable(values, names)
    : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_4__["default"])(values) ? fromKeyValuePairs(Object.entries(values), names)
    : raise();
}

function fromKeyValuePairs(entries, names = ['key', 'value']) {
  const keys = [];
  const vals = [];

  for (const [key, val] of entries) {
    keys.push(key);
    vals.push(val);
  }

  const columns = {};
  if (names[0]) columns[names[0]] = keys;
  if (names[1]) columns[names[1]] = vals;
  return columns;
}

function fromArray(values, names) {
  const len = values.length;
  const columns = {};
  const add = name => columns[name] = Array(len);

  if (len) {
    names = names || Object.keys(values[0]);
    const cols = names.map(add);
    const n = cols.length;
    for (let idx = 0; idx < len; ++idx) {
      const row = values[idx];
      for (let i = 0; i < n; ++i) {
        cols[i][idx] = row[names[i]];
      }
    }
  } else if (names) {
    names.forEach(add);
  }

  return columns;
}

function fromIterable(values, names) {
  const columns = {};
  const add = name => columns[name] = [];

  let cols;
  let n;
  for (const row of values) {
    if (!cols) {
      names = names || Object.keys(row);
      cols = names.map(add);
      n = cols.length;
    }
    for (let i = 0; i < n; ++i) {
      cols[i].push(row[names[i]]);
    }
  }

  if (!cols && names) {
    names.forEach(add);
  }

  return columns;
}

/***/ }),

/***/ "../node_modules/arquero/src/table/index.js":
/*!**************************************************!*\
  !*** ../node_modules/arquero/src/table/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   from: () => (/* binding */ from),
/* harmony export */   table: () => (/* binding */ table)
/* harmony export */ });
/* harmony import */ var _column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./column-table */ "../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _verbs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../verbs */ "../node_modules/arquero/src/verbs/index.js");



// Add verb implementations to ColumnTable prototype
Object.assign(_column_table__WEBPACK_IMPORTED_MODULE_0__["default"].prototype, _verbs__WEBPACK_IMPORTED_MODULE_1__["default"]);

/**
 * Create a new table for a set of named columns.
 * @param {object|Map} columns
 *  The set of named column arrays. Keys are column names.
 *  The enumeration order of the keys determines the column indices,
 *  unless the names parameter is specified.
 *  Values must be arrays (or array-like values) of identical length.
 * @param {string[]} [names] Ordered list of column names. If specified,
 *  this array determines the column indices. If not specified, the
 *  key enumeration order of the columns object is used.
 * @return {ColumnTable} the instantiated table
 * @example table({ colA: ['a', 'b', 'c'], colB: [3, 4, 5] })
 */
function table(columns, names) {
  return _column_table__WEBPACK_IMPORTED_MODULE_0__["default"].new(columns, names);
}

/**
 * Create a new table from an existing object, such as an array of
 * objects or a set of key-value pairs.
 * @param {object|Array|Map} values Data values to populate the table.
 *  If array-valued or iterable, imports rows for each non-null value,
 *  using the provided column names as keys for each row object. If no
 *  names are provided, the first non-null object's own keys are used.
 *  If object- or Map-valued, create columns for the keys and values.
 * @param {string[]} [names] Column names to include.
 *  For object or Map values, specifies the key and value column names.
 *  Otherwise, specifies the keys to look up on each row object.
 * @return {ColumnTable} the instantiated table.
 * @example from([ { colA: 1, colB: 2 }, { colA: 3, colB: 4 } ])
 */
function from(values, names) {
  return _column_table__WEBPACK_IMPORTED_MODULE_0__["default"].from(values, names);
}

/***/ }),

/***/ "../node_modules/arquero/src/table/regroup.js":
/*!****************************************************!*\
  !*** ../node_modules/arquero/src/table/regroup.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   nest: () => (/* binding */ nest),
/* harmony export */   regroup: () => (/* binding */ regroup),
/* harmony export */   reindex: () => (/* binding */ reindex)
/* harmony export */ });
/* harmony import */ var _op_op_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../op/op-api */ "../node_modules/arquero/src/op/op-api.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_unique_name__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/unique-name */ "../node_modules/arquero/src/util/unique-name.js");




/**
 * Regroup table rows in response to a BitSet filter.
 * @param {GroupBySpec} groups The current groupby specification.
 * @param {BitSet} filter The filter to apply.
 */
function regroup(groups, filter) {
  if (!groups || !filter) return groups;

  // check for presence of rows for each group
  const { keys, rows, size } = groups;
  const map = new Int32Array(size);
  filter.scan(row => map[keys[row]] = 1);

  // check sum, exit early if all groups occur
  const sum = map.reduce((sum, val) => sum + val, 0);
  if (sum === size) return groups;

  // create group index map, filter exemplar rows
  const _rows = Array(sum);
  let _size = 0;
  for (let i = 0; i < size; ++i) {
    if (map[i]) _rows[map[i] = _size++] = rows[i];
  }

  // re-index the group keys
  const _keys = new Uint32Array(keys.length);
  filter.scan(row => _keys[row] = map[keys[row]]);

  return { ...groups, keys: _keys, rows: _rows, size: _size };
}

/**
 * Regroup table rows in response to a re-indexing.
 * This operation may or may not involve filtering of rows.
 * @param {GroupBySpec} groups The current groupby specification.
 * @param {Function} scan Function to scan new row indices.
 * @param {boolean} filter Flag indicating if filtering may occur.
 * @param {number} nrows The number of rows in the new table.
 */
function reindex(groups, scan, filter, nrows) {
  const { keys, rows, size } = groups;
  let _rows = rows;
  let _size = size;
  let map = null;

  if (filter) {
    // check for presence of rows for each group
    map = new Int32Array(size);
    scan(row => map[keys[row]] = 1);

    // check sum, regroup if not all groups occur
    const sum = map.reduce((sum, val) => sum + val, 0);
    if (sum !== size) {
      // create group index map, filter exemplar rows
      _rows = Array(sum);
      _size = 0;
      for (let i = 0; i < size; ++i) {
        if (map[i]) _rows[map[i] = _size++] = rows[i];
      }
    }
  }

  // re-index the group keys
  let r = -1;
  const _keys = new Uint32Array(nrows);
  const fn = _size !== size
    ? row => _keys[++r] = map[keys[row]]
    : row => _keys[++r] = keys[row];
  scan(fn);

  return { ...groups, keys: _keys, rows: _rows, size: _size };
}

function nest(table, idx, obj, type) {
  const agg = type === 'map' || type === true ? _op_op_api__WEBPACK_IMPORTED_MODULE_0__.map_agg
    : type === 'entries' ? _op_op_api__WEBPACK_IMPORTED_MODULE_0__.entries_agg
    : type === 'object' ? _op_op_api__WEBPACK_IMPORTED_MODULE_0__.object_agg
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('groups option must be "map", "entries", or "object".');

  const { names } = table.groups();
  const col = (0,_util_unique_name__WEBPACK_IMPORTED_MODULE_2__["default"])(table.columnNames(), '_');

  // create table with one column of row objects
  // then aggregate into per-group arrays
  let t = table
    .select()
    .reify(idx)
    .create({ data: { [col]: obj } })
    .rollup({ [col]: (0,_op_op_api__WEBPACK_IMPORTED_MODULE_0__.array_agg)(col) });

  // create nested structures for each level of grouping
  for (let i = names.length; --i >= 0;) {
    t = t
      .groupby(names.slice(0, i))
      .rollup({ [col]: agg(names[i], col) });
  }

  // return the final aggregated structure
  return t.get(col);
}

/***/ }),

/***/ "../node_modules/arquero/src/table/table.js":
/*!**************************************************!*\
  !*** ../node_modules/arquero/src/table/table.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Table)
/* harmony export */ });
/* harmony import */ var _transformable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./transformable */ "../node_modules/arquero/src/table/transformable.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-number */ "../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_repeat__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/repeat */ "../node_modules/arquero/src/util/repeat.js");





/**
 * Abstract class representing a data table.
 */
class Table extends _transformable__WEBPACK_IMPORTED_MODULE_0__["default"] {

  /**
   * Instantiate a new Table instance.
   * @param {string[]} names An ordered list of column names.
   * @param {number} nrows The number of rows.
   * @param {TableData} data The backing data, which can vary by implementation.
   * @param {BitSet} [filter] A bit mask for which rows to include.
   * @param {GroupBySpec} [groups] A groupby specification for grouping ows.
   * @param {RowComparator} [order] A comparator function for sorting rows.
   * @param {Params} [params] Parameter values for table expressions.
   */
  constructor(names, nrows, data, filter, groups, order, params) {
    super(params);
    this._names = Object.freeze(names);
    this._data = data;
    this._total = nrows;
    this._nrows = filter ? filter.count() : nrows;
    this._mask = (nrows !== this._nrows && filter) || null;
    this._group = groups || null;
    this._order = order || null;
  }

  /**
   * Create a new table with the same type as this table.
   * The new table may have different data, filter, grouping, or ordering
   * based on the values of the optional configuration argument. If a
   * setting is not specified, it is inherited from the current table.
   * @param {CreateOptions} [options] Creation options for the new table.
   * @return {this} A newly created table.
   */
  create(options) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Provide an informative object string tag.
   */
  get [Symbol.toStringTag]() {
    if (!this._names) return 'Object'; // bail if called on prototype
    const nr = this.numRows() + ' row' + (this.numRows() !== 1 ? 's' : '');
    const nc = this.numCols() + ' col' + (this.numCols() !== 1 ? 's' : '');
    return `Table: ${nc} x ${nr}`
      + (this.isFiltered() ? ` (${this.totalRows()} backing)` : '')
      + (this.isGrouped() ? `, ${this._group.size} groups` : '')
      + (this.isOrdered() ? ', ordered' : '');
  }

  /**
   * Indicates if the table has a filter applied.
   * @return {boolean} True if filtered, false otherwise.
   */
  isFiltered() {
    return !!this._mask;
  }

  /**
   * Indicates if the table has a groupby specification.
   * @return {boolean} True if grouped, false otherwise.
   */
  isGrouped() {
    return !!this._group;
  }

  /**
   * Indicates if the table has a row order comparator.
   * @return {boolean} True if ordered, false otherwise.
   */
  isOrdered() {
    return !!this._order;
  }

  /**
   * Returns the internal table storage data structure.
   * @return {TableData} The backing table storage data structure.
   */
  data() {
    return this._data;
  }

  /**
   * Returns the filter bitset mask, if defined.
   * @return {BitSet} The filter bitset mask.
   */
  mask() {
    return this._mask;
  }

  /**
   * Returns the groupby specification, if defined.
   * @return {GroupBySpec} The groupby specification.
   */
  groups() {
    return this._group;
  }

  /**
   * Returns the row order comparator function, if specified.
   * @return {RowComparator} The row order comparator function.
   */
  comparator() {
    return this._order;
  }

  /**
   * The total number of rows in this table, counting both
   * filtered and unfiltered rows.
   * @return {number} The number of total rows.
   */
  totalRows() {
    return this._total;
  }

  /**
   * The number of active rows in this table. This number may be
   * less than the total rows if the table has been filtered.
   * @see Table.totalRows
   * @return {number} The number of rows.
   */
  numRows() {
    return this._nrows;
  }

  /**
   * The number of active rows in this table. This number may be
   * less than the total rows if the table has been filtered.
   * @see Table.totalRows
   * @return {number} The number of rows.
   */
  get size() {
    return this._nrows;
  }

  /**
   * The number of columns in this table.
   * @return {number} The number of columns.
   */
  numCols() {
    return this._names.length;
  }

  /**
   * Filter function invoked for each column name.
   * @callback NameFilter
   * @param {string} name The column name.
   * @param {number} index The column index.
   * @param {string[]} array The array of names.
   * @return {boolean} Returns true to retain the column name.
   */

  /**
   * The table column names, optionally filtered.
   * @param {NameFilter} [filter] An optional filter function.
   *  If unspecified, all column names are returned.
   * @return {string[]} An array of matching column names.
   */
  columnNames(filter) {
    return filter ? this._names.filter(filter) : this._names.slice();
  }

  /**
   * The column name at the given index.
   * @param {number} index The column index.
   * @return {string} The column name,
   *  or undefined if the index is out of range.
   */
  columnName(index) {
    return this._names[index];
  }

  /**
   * The column index for the given name.
   * @param {string} name The column name.
   * @return {number} The column index, or -1 if the name is not found.
   */
  columnIndex(name) {
    return this._names.indexOf(name);
  }

  /**
   * Deprecated alias for the table array() method: use table.array()
   * instead. Get an array of values contained in a column. The resulting
   * array respects any table filter or orderby criteria.
   * @param {string} name The column name.
   * @param {ArrayConstructor|TypedArrayConstructor} [constructor=Array]
   *  The array constructor for instantiating the output array.
   * @return {DataValue[]|TypedArray} The array of column values.
   */
  columnArray(name, constructor) {
    return this.array(name, constructor);
  }

  /**
   * Get an array of values contained in a column. The resulting array
   * respects any table filter or orderby criteria.
   * @param {string} name The column name.
   * @param {ArrayConstructor|TypedArrayConstructor} [constructor=Array]
   *  The array constructor for instantiating the output array.
   * @return {DataValue[]|TypedArray} The array of column values.
   */
  array(name, constructor) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Returns an iterator over column values.
   * @return {Iterator<object>} An iterator over row objects.
   */
  *values(name) {
    const get = this.getter(name);
    const n = this.numRows();
    for (let i = 0; i < n; ++i) {
      yield get(i);
    }
  }

  /**
   * Get the value for the given column and row.
   * @param {string} name The column name.
   * @param {number} [row=0] The row index, defaults to zero if not specified.
   * @return {DataValue} The data value at (column, row).
   */
  get(name, row = 0) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Returns an accessor ("getter") function for a column. The returned
   * function takes a row index as its single argument and returns the
   * corresponding column value.
   * @param {string} name The column name.
   * @return {ColumnGetter} The column getter function.
   */
  getter(name) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Returns an array of objects representing table rows.
   * @param {ObjectsOptions} [options] The options for row object generation.
   * @return {RowObject[]} An array of row objects.
   */
  objects(options) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Returns an object representing a table row.
   * @param {number} [row=0] The row index, defaults to zero if not specified.
   * @return {object} A row object with named properties for each column.
   */
   object(row) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Returns an iterator over objects representing table rows.
   * @return {Iterator<object>} An iterator over row objects.
   */
  [Symbol.iterator]() {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Print the contents of this table using the console.table() method.
   * @param {PrintOptions|number} options The options for row object
   *  generation, determining which rows and columns are printed. If
   *  number-valued, specifies the row limit.
   */
  print(options = {}) {
    if ((0,_util_is_number__WEBPACK_IMPORTED_MODULE_2__["default"])(options)) {
      options = { limit: options };
    } else if (options.limit == null) {
      options.limit = 10;
    }

    const obj = this.objects({ ...options, grouped: false });
    const msg = `${this[Symbol.toStringTag]}. Showing ${obj.length} rows.`;

    console.log(msg);   // eslint-disable-line no-console
    console.table(obj); // eslint-disable-line no-console
  }

  /**
   * Returns an array of indices for all rows passing the table filter.
   * @param {boolean} [order=true] A flag indicating if the returned
   *  indices should be sorted if this table is ordered. If false, the
   *  returned indices may or may not be sorted.
   * @return {Uint32Array} An array of row indices.
   */
  indices(order = true) {
    if (this._index) return this._index;

    const n = this.numRows();
    const index = new Uint32Array(n);
    const ordered = this.isOrdered();
    const bits = this.mask();
    let row = -1;

    // inline the following for performance:
    // this.scan(row => index[++i] = row);
    if (bits) {
      for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
        index[++row] = i;
      }
    } else {
      for (let i = 0; i < n; ++i) {
        index[++row] = i;
      }
    }

    // sort index vector
    if (order && ordered) {
      const compare = this._order;
      const data = this._data;
      index.sort((a, b) => compare(a, b, data));
    }

    // save indices if they reflect table metadata
    if (order || !ordered) {
      this._index = index;
    }

    return index;
  }

  /**
   * Returns an array of indices for each group in the table.
   * If the table is not grouped, the result is the same as
   * {@link indices}, but wrapped within an array.
   * @param {boolean} [order=true] A flag indicating if the returned
   *  indices should be sorted if this table is ordered. If false, the
   *  returned indices may or may not be sorted.
   * @return {number[][]} An array of row index arrays, one per group.
   *  The indices will be filtered if the table is filtered.
   */
  partitions(order = true) {
    // return partitions if already generated
    if (this._partitions) {
      return this._partitions;
    }

    // if not grouped, return a single partition
    if (!this.isGrouped()) {
      return [ this.indices(order) ];
    }

    // generate partitions
    const { keys, size } = this._group;
    const part = (0,_util_repeat__WEBPACK_IMPORTED_MODULE_3__["default"])(size, () => []);

    // populate partitions, don't sort if indices don't exist
    // inline the following for performance:
    // this.scan(row => part[keys[row]].push(row), sort);
    const sort = this._index;
    const bits = this.mask();
    const n = this.numRows();
    if (sort && this.isOrdered()) {
      for (let i = 0, r; i < n; ++i) {
        r = sort[i];
        part[keys[r]].push(r);
      }
    } else if (bits) {
      for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
        part[keys[i]].push(i);
      }
    } else {
      for (let i = 0; i < n; ++i) {
        part[keys[i]].push(i);
      }
    }

    // if ordered but not yet sorted, sort partitions directly
    if (order && !sort && this.isOrdered()) {
      const compare = this._order;
      const data = this._data;
      for (let i = 0; i < size; ++i) {
        part[i].sort((a, b) => compare(a, b, data));
      }
    }

    // save partitions if they reflect table metadata
    if (order || !this.isOrdered()) {
      this._partitions = part;
    }

    return part;
  }

  /**
   * Callback function to cancel a table scan.
   * @callback ScanStop
   * @return {void}
   */

  /**
   * Callback function invoked for each row of a table scan.
   * @callback ScanVisitor
   * @param {number} [row] The table row index.
   * @param {TableData} [data] The backing table data store.
   * @param {ScanStop} [stop] Function to stop the scan early.
   *  Callees can invoke this function to prevent future calls.
   * @return {void}
   */

  /**
   * Perform a table scan, visiting each row of the table.
   * If this table is filtered, only rows passing the filter are visited.
   * @param {ScanVisitor} fn Callback invoked for each row of the table.
   * @param {boolean} [order=false] Indicates if the table should be
   *  scanned in the order determined by {@link Table#orderby}. This
   *  argument has no effect if the table is unordered.
   * @property {number} [limit=Infinity] The maximum number of objects to create.
   * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
   */
  scan(fn, order, limit = Infinity, offset = 0) {
    const filter = this._mask;
    const nrows = this._nrows;
    const data = this._data;

    let i = offset || 0;
    if (i > nrows) return;

    const n = Math.min(nrows, i + limit);
    const stop = () => i = this._total;

    if (order && this.isOrdered() || filter && this._index) {
      const index = this.indices();
      const data = this._data;
      for (; i < n; ++i) {
        fn(index[i], data, stop);
      }
    } else if (filter) {
      let c = n - i + 1;
      for (i = filter.nth(i); --c && i > -1; i = filter.next(i + 1)) {
        fn(i, data, stop);
      }
    } else {
      for (; i < n; ++i) {
        fn(i, data, stop);
      }
    }
  }

  /**
   * Extract rows with indices from start to end (end not included), where
   * start and end represent per-group ordered row numbers in the table.
   * @param {number} [start] Zero-based index at which to start extraction.
   *  A negative index indicates an offset from the end of the group.
   *  If start is undefined, slice starts from the index 0.
   * @param {number} [end] Zero-based index before which to end extraction.
   *  A negative index indicates an offset from the end of the group.
   *  If end is omitted, slice extracts through the end of the group.
   * @return {this} A new table with sliced rows.
   * @example table.slice(1, -1)
   */
  slice(start = 0, end = Infinity) {
    if (this.isGrouped()) return super.slice(start, end);

    // if not grouped, scan table directly
    const indices = [];
    const nrows = this.numRows();
    start = Math.max(0, start + (start < 0 ? nrows : 0));
    end = Math.min(nrows, Math.max(0, end + (end < 0 ? nrows : 0)));
    this.scan(row => indices.push(row), true, end - start, start);
    return this.reify(indices);
  }

  /**
   * Reduce a table, processing all rows to produce a new table.
   * To produce standard aggregate summaries, use {@link rollup}.
   * This method allows the use of custom reducer implementations,
   * for example to produce multiple rows for an aggregate.
   * @param {Reducer} reducer The reducer to apply.
   * @return {Table} A new table of reducer outputs.
   */
  reduce(reducer) {
    return this.__reduce(this, reducer);
  }
}

/**
 * A typed array constructor.
 * @typedef {Uint8ArrayConstructor|Uint16ArrayConstructor|Uint32ArrayConstructor|BigUint64ArrayConstructor|Int8ArrayConstructor|Int16ArrayConstructor|Int32ArrayConstructor|BigInt64ArrayConstructor|Float32ArrayConstructor|Float64ArrayConstructor} TypedArrayConstructor
 */

/**
 * A typed array instance.
 * @typedef {Uint8Array|Uint16Array|Uint32Array|BigUint64Array|Int8Array|Int16Array|Int32Array|BigInt64Array|Float32Array|Float64Array} TypedArray
 */

/**
 * Backing table data.
 * @typedef {object|Array} TableData
 */

/**
 * Table value.
 * @typedef {*} DataValue
 */

/**
 * Table row object.
 * @typedef {Object.<string, DataValue>} RowObject
 */

/**
 * Table expression parameters.
 * @typedef {import('./transformable').Params} Params
 */

/**
 * Proxy type for BitSet class.
 * @typedef {import('./bit-set').default} BitSet
 */

/**
 * A table groupby specification.
 * @typedef {object} GroupBySpec
 * @property {number} size The number of groups.
 * @property {string[]} names Column names for each group.
 * @property {RowExpression[]} get Value accessor functions for each group.
 * @property {number[]} rows Indices of an example table row for each group.
 * @property {number[]} keys Per-row group indices, length is total rows of table.
 */

/**
 * Column value accessor.
 * @callback ColumnGetter
 * @param {number} [row] The table row.
 * @return {DataValue}
 */

/**
 * An expression evaluated over a table row.
 * @callback RowExpression
 * @param {number} [row] The table row.
 * @param {TableData} [data] The backing table data store.
 * @return {DataValue}
 */

/**
 * Comparator function for sorting table rows.
 * @callback RowComparator
 * @param {number} rowA The table row index for the first row.
 * @param {number} rowB The table row index for the second row.
 * @param {TableData} data The backing table data store.
 * @return {number} Negative if rowA < rowB, positive if
 *  rowA > rowB, otherwise zero.
 */

/**
 * Options for derived table creation.
 * @typedef {object} CreateOptions
 * @property {TableData} [data] The backing column data.
 * @property {string[]} [names] An ordered list of column names.
 * @property {BitSet} [filter] An additional filter BitSet to apply.
 * @property {GroupBySpec} [groups] The groupby specification to use, or null for no groups.
 * @property {RowComparator} [order] The orderby comparator function to use, or null for no order.
 */

/**
 * Options for generating row objects.
 * @typedef {object} PrintOptions
 * @property {number} [limit=Infinity] The maximum number of objects to create.
 * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
 * @property {import('../table/transformable').Select} [columns]
 *  An ordered set of columns to include. The input may consist of column name
 *  strings, column integer indices, objects with current column names as keys
 *  and new column names as values (for renaming), or selection helper
 *  functions such as {@link all}, {@link not}, or {@link range}.
 */

/**
 * Options for generating row objects.
 * @typedef {object} ObjectsOptions
 * @property {number} [limit=Infinity] The maximum number of objects to create.
 * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
 * @property {import('../table/transformable').Select} [columns]
 *  An ordered set of columns to include. The input may consist of column name
 *  strings, column integer indices, objects with current column names as keys
 *  and new column names as values (for renaming), or selection helper
 *  functions such as {@link all}, {@link not}, or {@link range}.
 * @property {'map'|'entries'|'object'|boolean} [grouped=false]
 *  The export format for groups of rows. The default (false) is to ignore
 *  groups, returning a flat array of objects. The valid values are 'map' or
 *  true (for Map instances), 'object' (for standard objects), or 'entries'
 *  (for arrays in the style of Object.entries). For the 'object' format,
 *  groupby keys are coerced to strings to use as object property names; note
 *  that this can lead to undesirable behavior if the groupby keys are object
 *  values. The 'map' and 'entries' options preserve the groupby key values.
 */


/***/ }),

/***/ "../node_modules/arquero/src/table/transformable.js":
/*!**********************************************************!*\
  !*** ../node_modules/arquero/src/table/transformable.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Transformable)
/* harmony export */ });
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/to-array */ "../node_modules/arquero/src/util/to-array.js");
/* harmony import */ var _helpers_slice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/slice */ "../node_modules/arquero/src/helpers/slice.js");



/**
 * Abstract base class for transforming data.
 */
class Transformable {

  /**
   * Instantiate a new Transformable instance.
   * @param {Params} [params] The parameter values.
   */
  constructor(params) {
    if (params) this._params = params;
  }

  /**
   * Get or set table expression parameter values.
   * If called with no arguments, returns the current parameter values
   * as an object. Otherwise, adds the provided parameters to this
   * table's parameter set and returns the table. Any prior parameters
   * with names matching the input parameters are overridden.
   * @param {Params} [values] The parameter values.
   * @return {this|Params} The current parameters values (if called with
   *  no arguments) or this table.
   */
  params(values) {
    if (arguments.length) {
      if (values) {
        this._params = { ...this._params, ...values };
      }
      return this;
    } else {
      return this._params;
    }
  }

  /**
   * Create a new fully-materialized instance of this table.
   * All filter and orderby settings are removed from the new table.
   * Instead, the backing data itself is filtered and ordered as needed.
   * @param {number[]} [indices] Ordered row indices to materialize.
   *  If unspecified, all rows passing the table filter are used.
   * @return {this} A reified table.
   */
  reify(indices) {
    return this.__reify(this, indices);
  }

  // -- Transformation Verbs ------------------------------------------------

  /**
   * Count the number of values in a group. This method is a shorthand
   * for {@link Transformable#rollup} with a count aggregate function.
   * @param {CountOptions} [options] Options for the count.
   * @return {this} A new table with groupby and count columns.
   * @example table.groupby('colA').count()
   * @example table.groupby('colA').count({ as: 'num' })
   */
  count(options) {
    return this.__count(this, options);
  }

  /**
   * Derive new column values based on the provided expressions. By default,
   * new columns are added after (higher indices than) existing columns. Use
   * the before or after options to place new columns elsewhere.
   * @param {ExprObject} values Object of name-value pairs defining the
   *  columns to derive. The input object should have output column
   *  names for keys and table expressions for values.
   * @param {DeriveOptions} [options] Options for dropping or relocating
   *  derived columns. Use either a before or after property to indicate
   *  where to place derived columns. Specifying both before and after is an
   *  error. Unlike the relocate verb, this option affects only new columns;
   *  updated columns with existing names are excluded from relocation.
   * @return {this} A new table with derived columns added.
   * @example table.derive({ sumXY: d => d.x + d.y })
   * @example table.derive({ z: d => d.x * d.y }, { before: 'x' })
   */
  derive(values, options) {
    return this.__derive(this, values, options);
  }

  /**
   * Filter a table to a subset of rows based on the input criteria.
   * The resulting table provides a filtered view over the original data; no
   * data copy is made. To create a table that copies only filtered data to
   * new data structures, call {@link Transformable#reify} on the output table.
   * @param {TableExpr} criteria Filter criteria as a table expression.
   *  Both aggregate and window functions are permitted, taking into account
   *  {@link Transformable#groupby} or {@link Transformable#orderby} settings.
   * @return {this} A new table with filtered rows.
   * @example table.filter(d => abs(d.value) < 5)
   */
  filter(criteria) {
    return this.__filter(this, criteria);
  }

  /**
   * Extract rows with indices from start to end (end not included), where
   * start and end represent per-group ordered row numbers in the table.
   * @param {number} [start] Zero-based index at which to start extraction.
   *  A negative index indicates an offset from the end of the group.
   *  If start is undefined, slice starts from the index 0.
   * @param {number} [end] Zero-based index before which to end extraction.
   *  A negative index indicates an offset from the end of the group.
   *  If end is omitted, slice extracts through the end of the group.
   * @return {this} A new table with sliced rows.
   * @example table.slice(1, -1)
   */
  slice(start, end) {
    return this.filter((0,_helpers_slice__WEBPACK_IMPORTED_MODULE_1__["default"])(start, end)).reify();
  }

  /**
   * Group table rows based on a set of column values.
   * Subsequent operations that are sensitive to grouping (such as
   * aggregate functions) will operate over the grouped rows.
   * To undo grouping, use {@link Transformable#ungroup}.
   * @param  {...ExprList} keys Key column values to group by.
   *  The keys may be specified using column name strings, column index
   *  numbers, value objects with output column names for keys and table
   *  expressions for values, or selection helper functions.
   * @return {this} A new table with grouped rows.
   * @example table.groupby('colA', 'colB')
   * @example table.groupby({ key: d => d.colA + d.colB })
   */
  groupby(...keys) {
    return this.__groupby(this, keys.flat());
  }

  /**
   * Order table rows based on a set of column values.
   * Subsequent operations sensitive to ordering (such as window functions)
   * will operate over sorted values.
   * The resulting table provides an view over the original data, without
   * any copying. To create a table with sorted data copied to new data
   * strucures, call {@link Transformable#reify} on the result of this method.
   * To undo ordering, use {@link Transformable#unorder}.
   * @param  {...OrderKeys} keys Key values to sort by, in precedence order.
   *  By default, sorting is done in ascending order.
   *  To sort in descending order, wrap values using {@link desc}.
   *  If a string, order by the column with that name.
   *  If a number, order by the column with that index.
   *  If a function, must be a valid table expression; aggregate functions
   *  are permitted, but window functions are not.
   *  If an object, object values must be valid values parameters
   *  with output column names for keys and table expressions
   *  for values (the output names will be ignored).
   *  If an array, array values must be valid key parameters.
   * @return {this} A new ordered table.
   * @example table.orderby('a', desc('b'))
   * @example table.orderby({ a: 'a', b: desc('b') )})
   * @example table.orderby(desc(d => d.a))
   */
  orderby(...keys) {
    return this.__orderby(this, keys.flat());
  }

  /**
   * Relocate a subset of columns to change their positions, also
   * potentially renaming them.
   * @param {Selection} columns An ordered selection of columns to relocate.
   *  The input may consist of column name strings, column integer indices,
   *  rename objects with current column names as keys and new column names
   *  as values, or functions that take a table as input and returns a valid
   *  selection parameter (typically the output of selection helper functions
   *  such as {@link all}, {@link not}, or {@link range}).
   * @param {RelocateOptions} options Options for relocating. Must include
   *  either the before or after property to indicate where to place the
   *  relocated columns. Specifying both before and after is an error.
   * @return {this} A new table with relocated columns.
   * @example table.relocate(['colY', 'colZ'], { after: 'colX' })
   * @example table.relocate(not('colB', 'colC'), { before: 'colA' })
   * @example table.relocate({ colA: 'newA', colB: 'newB' }, { after: 'colC' })
   */
  relocate(columns, options) {
    return this.__relocate(this, (0,_util_to_array__WEBPACK_IMPORTED_MODULE_0__["default"])(columns), options);
  }

  /**
   * Rename one or more columns, preserving column order.
   * @param {...Select} columns One or more rename objects with current
   *  column names as keys and new column names as values.
   * @return {this} A new table with renamed columns.
   * @example table.rename({ oldName: 'newName' })
   * @example table.rename({ a: 'a2', b: 'b2' })
   */
  rename(...columns) {
    return this.__rename(this, columns.flat());
  }

  /**
   * Rollup a table to produce an aggregate summary.
   * Often used in conjunction with {@link Transformable#groupby}.
   * To produce counts only, {@link Transformable#count} is a shortcut.
   * @param {ExprObject} [values] Object of name-value pairs defining aggregate
   *  output columns. The input object should have output column names for
   *  keys and table expressions for values. The expressions must be valid
   *  aggregate expressions: window functions are not allowed and column
   *  references must be arguments to aggregate functions.
   * @return {this} A new table of aggregate summary values.
   * @example table.groupby('colA').rollup({ mean: d => mean(d.colB) })
   * @example table.groupby('colA').rollup({ mean: op.median('colB') })
   */
  rollup(values) {
    return this.__rollup(this, values);
  }

  /**
   * Generate a table from a random sample of rows.
   * If the table is grouped, performs a stratified sample by
   * sampling from each group separately.
   * @param {number|TableExpr} size The number of samples to draw per group.
   *  If number-valued, the same sample size is used for each group.
   *  If function-valued, the input should be an aggregate table
   *  expression compatible with {@link Transformable#rollup}.
   * @param {SampleOptions} [options] Options for sampling.
   * @return {this} A new table with sampled rows.
   * @example table.sample(50)
   * @example table.sample(100, { replace: true })
   * @example table.groupby('colA').sample(() => op.floor(0.5 * op.count()))
   */
  sample(size, options) {
    return this.__sample(this, size, options);
  }

  /**
   * Select a subset of columns into a new table, potentially renaming them.
   * @param {...Select} columns An ordered selection of columns.
   *  The input may consist of column name strings, column integer indices,
   *  rename objects with current column names as keys and new column names
   *  as values, or functions that take a table as input and returns a valid
   *  selection parameter (typically the output of selection helper functions
   *  such as {@link all}, {@link not}, or {@link range}).
   * @return {this} A new table of selected columns.
   * @example table.select('colA', 'colB')
   * @example table.select(not('colB', 'colC'))
   * @example table.select({ colA: 'newA', colB: 'newB' })
   */
  select(...columns) {
    return this.__select(this, columns.flat());
  }

  /**
   * Ungroup a table, removing any grouping criteria.
   * Undoes the effects of {@link Transformable#groupby}.
   * @return {this} A new ungrouped table, or this table if not grouped.
   * @example table.ungroup()
   */
  ungroup() {
    return this.__ungroup(this);
  }

  /**
   * Unorder a table, removing any sorting criteria.
   * Undoes the effects of {@link Transformable#orderby}.
   * @return {this} A new unordered table, or this table if not ordered.
   * @example table.unorder()
   */
  unorder() {
    return this.__unorder(this);
  }

  // -- Cleaning Verbs ------------------------------------------------------

  /**
   * De-duplicate table rows by removing repeated row values.
   * @param {...ExprList} keys Key columns to check for duplicates.
   *  Two rows are considered duplicates if they have matching values for
   *  all keys. If keys are unspecified, all columns are used.
   *  The keys may be specified using column name strings, column index
   *  numbers, value objects with output column names for keys and table
   *  expressions for values, or selection helper functions.
   * @return {this} A new de-duplicated table.
   * @example table.dedupe()
   * @example table.dedupe('a', 'b')
   * @example table.dedupe({ abs: d => op.abs(d.a) })
   */
  dedupe(...keys) {
    return this.__dedupe(this, keys.flat());
  }

  /**
   * Impute missing values or rows. Accepts a set of column-expression pairs
   * and evaluates the expressions to replace any missing (null, undefined,
   * or NaN) values in the original column.
   * If the expand option is specified, imputes new rows for missing
   * combinations of values. All combinations of key values (a full cross
   * product) are considered for each level of grouping (specified by
   * {@link Transformable#groupby}). New rows will be added for any combination
   * of key and groupby values not already contained in the table. For all
   * non-key and non-group columns the new rows are populated with imputation
   * values (first argument) if specified, otherwise undefined.
   * If the expand option is specified, any filter or orderby settings are
   * removed from the output table, but groupby settings persist.
   * @param {ExprObject} values Object of name-value pairs for the column values
   *  to impute. The input object should have existing column names for keys
   *  and table expressions for values. The expressions will be evaluated to
   *  determine replacements for any missing values.
   * @param {ImputeOptions} [options] Imputation options. The expand
   *  property specifies a set of column values to consider for imputing
   *  missing rows. All combinations of expanded values are considered, and
   *  new rows are added for each combination that does not appear in the
   *  input table.
   * @return {this} A new table with imputed values and/or rows.
   * @example table.impute({ v: () => 0 })
   * @example table.impute({ v: d => op.mean(d.v) })
   * @example table.impute({ v: () => 0 }, { expand: ['x', 'y'] })
   */
  impute(values, options) {
    return this.__impute(this, values, options);
  }

  // -- Reshaping Verbs -----------------------------------------------------

  /**
   * Fold one or more columns into two key-value pair columns.
   * The fold transform is an inverse of the {@link Transformable#pivot} transform.
   * The resulting table has two new columns, one containing the column
   * names (named "key") and the other the column values (named "value").
   * The number of output rows equals the original row count multiplied
   * by the number of folded columns.
   * @param {ExprList} values The columns to fold.
   *  The columns may be specified using column name strings, column index
   *  numbers, value objects with output column names for keys and table
   *  expressions for values, or selection helper functions.
   * @param {FoldOptions} [options] Options for folding.
   * @return {this} A new folded table.
   * @example table.fold('colA')
   * @example table.fold(['colA', 'colB'])
   * @example table.fold(range(5, 8))
   */
  fold(values, options) {
    return this.__fold(this, values, options);
  }

  /**
   * Pivot columns into a cross-tabulation.
   * The pivot transform is an inverse of the {@link Transformable#fold} transform.
   * The resulting table has new columns for each unique combination
   * of the provided *keys*, populated with the provided *values*.
   * The provided *values* must be aggregates, as a single set of keys may
   * include more than one row. If string-valued, the *any* aggregate is used.
   * If only one *values* column is defined, the new pivoted columns will
   * be named using key values directly. Otherwise, input value column names
   * will be included as a component of the output column names.
   * @param {ExprList} keys Key values to map to new column names.
   *  The keys may be specified using column name strings, column index
   *  numbers, value objects with output column names for keys and table
   *  expressions for values, or selection helper functions.
   * @param {ExprList} values Output values for pivoted columns.
   *  Column references will be wrapped in an *any* ag