/*! For license information please see index.js.LICENSE.txt */
define(["@jupyter-widgets/base"],(__WEBPACK_EXTERNAL_MODULE__2055__=>(()=>{var __webpack_modules__={4383:(e,t)=>{"use strict";t.mw={prefix:"fas",iconName:"chart-bar",icon:[512,512,[],"f080","M332.8 320h38.4c6.4 0 12.8-6.4 12.8-12.8V172.8c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v134.4c0 6.4 6.4 12.8 12.8 12.8zm96 0h38.4c6.4 0 12.8-6.4 12.8-12.8V76.8c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v230.4c0 6.4 6.4 12.8 12.8 12.8zm-288 0h38.4c6.4 0 12.8-6.4 12.8-12.8v-70.4c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v70.4c0 6.4 6.4 12.8 12.8 12.8zm96 0h38.4c6.4 0 12.8-6.4 12.8-12.8V108.8c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v198.4c0 6.4 6.4 12.8 12.8 12.8zM496 384H64V80c0-8.84-7.16-16-16-16H16C7.16 64 0 71.16 0 80v336c0 17.67 14.33 32 32 32h464c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16z"]},t.$F=t.mw},6705:(e,t)=>{"use strict";t.mw={prefix:"fas",iconName:"image",icon:[512,512,[],"f03e","M464 448H48c-26.51 0-48-21.49-48-48V112c0-26.51 21.49-48 48-48h416c26.51 0 48 21.49 48 48v288c0 26.51-21.49 48-48 48zM112 120c-30.928 0-56 25.072-56 56s25.072 56 56 56 56-25.072 56-56-25.072-56-56-56zM64 384h384V272l-87.515-87.515c-4.686-4.686-12.284-4.686-16.971 0L208 320l-55.515-55.515c-4.686-4.686-12.284-4.686-16.971 0L64 336v48z"]},t.jb=t.mw},2162:(e,t)=>{"use strict";t.mw={prefix:"fas",iconName:"pause",icon:[448,512,[],"f04c","M144 479H48c-26.5 0-48-21.5-48-48V79c0-26.5 21.5-48 48-48h96c26.5 0 48 21.5 48 48v352c0 26.5-21.5 48-48 48zm304-48V79c0-26.5-21.5-48-48-48h-96c-26.5 0-48 21.5-48 48v352c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48z"]},t.G1=t.mw},3852:(e,t)=>{"use strict";t.mw={prefix:"fas",iconName:"play",icon:[448,512,[],"f04b","M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z"]},t.ij=t.mw},3430:(e,t)=>{"use strict";t.mw={prefix:"fas",iconName:"question-circle",icon:[512,512,[],"f059","M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zM262.655 90c-54.497 0-89.255 22.957-116.549 63.758-3.536 5.286-2.353 12.415 2.715 16.258l34.699 26.31c5.205 3.947 12.621 3.008 16.665-2.122 17.864-22.658 30.113-35.797 57.303-35.797 20.429 0 45.698 13.148 45.698 32.958 0 14.976-12.363 22.667-32.534 33.976C247.128 238.528 216 254.941 216 296v4c0 6.627 5.373 12 12 12h56c6.627 0 12-5.373 12-12v-1.333c0-28.462 83.186-29.647 83.186-106.667 0-58.002-60.165-102-116.531-102zM256 338c-25.365 0-46 20.635-46 46 0 25.364 20.635 46 46 46s46-20.636 46-46c0-25.365-20.635-46-46-46z"]},t.wR=t.mw},7184:(e,t)=>{"use strict";t.mw={prefix:"fas",iconName:"table",icon:[512,512,[],"f0ce","M464 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V80c0-26.51-21.49-48-48-48zM224 416H64v-96h160v96zm0-160H64v-96h160v96zm224 160H288v-96h160v96zm0-160H288v-96h160v96z"]},t.w9=t.mw},9704:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ActivityMonitor=void 0;const r=n(3992);t.ActivityMonitor=class{constructor(e){this._timer=-1,this._timeout=-1,this._isDisposed=!1,this._activityStopped=new r.Signal(this),e.signal.connect(this._onSignalFired,this),this._timeout=e.timeout||1e3}get activityStopped(){return this._activityStopped}get timeout(){return this._timeout}set timeout(e){this._timeout=e}get isDisposed(){return this._isDisposed}dispose(){this._isDisposed||(this._isDisposed=!0,r.Signal.clearData(this))}_onSignalFired(e,t){clearTimeout(this._timer),this._sender=e,this._args=t,this._timer=setTimeout((()=>{this._activityStopped.emit({sender:this._sender,args:this._args})}),this._timeout)}}},8925:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(t,"__esModule",{value:!0}),A(n(9704),t),A(n(9269),t),A(n(1232),t),A(n(9547),t),A(n(5964),t),A(n(9830),t),A(n(7361),t),A(n(8126),t),A(n(1796),t),A(n(1692),t)},9269:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},1232:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.LruCache=void 0,t.LruCache=class{constructor(e={}){this._map=new Map,this._maxSize=(null==e?void 0:e.maxSize)||128}get size(){return this._map.size}clear(){this._map.clear()}get(e){const t=this._map.get(e)||null;return null!=t&&(this._map.delete(e),this._map.set(e,t)),t}set(e,t){this._map.size>=this._maxSize&&this._map.delete(this._map.keys().next().value),this._map.set(e,t)}}},9547:(e,t)=>{"use strict";var n;Object.defineProperty(t,"__esModule",{value:!0}),t.MarkdownCodeBlocks=void 0,function(e){e.CODE_BLOCK_MARKER="```";const t=[".markdown",".mdown",".mkdn",".md",".mkd",".mdwn",".mdtxt",".mdtext",".text",".txt",".Rmd"];class n{constructor(e){this.startLine=e,this.code="",this.endLine=-1}}e.MarkdownCodeBlock=n,e.isMarkdown=function(e){return t.indexOf(e)>-1},e.findMarkdownCodeBlocks=function(t){if(!t||""===t)return[];const r=t.split("\n"),A=[];let i=null;for(let t=0;t<r.length;t++){const s=r[t],a=0===s.indexOf(e.CODE_BLOCK_MARKER),o=null!=i;if(a||o)if(o)i&&(a?(i.endLine=t-1,A.push(i),i=null):i.code+=s+"\n");else{i=new n(t);const r=s.indexOf(e.CODE_BLOCK_MARKER),a=s.lastIndexOf(e.CODE_BLOCK_MARKER);r!==a&&(i.code=s.substring(r+e.CODE_BLOCK_MARKER.length,a),i.endLine=t,A.push(i),i=null)}}return A}}(n||(t.MarkdownCodeBlocks=n={}))},5964:function(__unused_webpack_module,exports,__webpack_require__){"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.PageConfig=void 0;const coreutils_1=__webpack_require__(5764),minimist_1=__importDefault(__webpack_require__(9600)),url_1=__webpack_require__(1692);var PageConfig;(function(PageConfig){function getOption(name){if(configData)return configData[name]||getBodyData(name);configData=Object.create(null);let found=!1;if("undefined"!=typeof document&&document){const e=document.getElementById("jupyter-config-data");e&&(configData=JSON.parse(e.textContent||""),found=!0)}if(!found&&"undefined"!=typeof process&&process.argv)try{const cli=(0,minimist_1.default)(process.argv.slice(2)),path=__webpack_require__(9942);let fullPath="";"jupyter-config-data"in cli?fullPath=path.resolve(cli["jupyter-config-data"]):"JUPYTER_CONFIG_DATA"in process.env&&(fullPath=path.resolve(process.env.JUPYTER_CONFIG_DATA)),fullPath&&(configData=eval("require")(fullPath))}catch(e){console.error(e)}if(coreutils_1.JSONExt.isObject(configData))for(const e in configData)"string"!=typeof configData[e]&&(configData[e]=JSON.stringify(configData[e]));else configData=Object.create(null);return configData[name]||getBodyData(name)}function setOption(e,t){const n=getOption(e);return configData[e]=t,n}function getBaseUrl(){return url_1.URLExt.normalize(getOption("baseUrl")||"/")}function getTreeUrl(){return url_1.URLExt.join(getBaseUrl(),getOption("treeUrl"))}function getShareUrl(){return url_1.URLExt.normalize(getOption("shareUrl")||getBaseUrl())}function getTreeShareUrl(){return url_1.URLExt.normalize(url_1.URLExt.join(getShareUrl(),getOption("treeUrl")))}function getUrl(e){var t,n,r,A;let i=e.toShare?getShareUrl():getBaseUrl();const s=null!==(t=e.mode)&&void 0!==t?t:getOption("mode"),a=null!==(n=e.workspace)&&void 0!==n?n:getOption("workspace"),o="single-document"===s?"doc":"lab";i=url_1.URLExt.join(i,o),a!==PageConfig.defaultWorkspace&&(i=url_1.URLExt.join(i,"workspaces",encodeURIComponent(null!==(r=getOption("workspace"))&&void 0!==r?r:PageConfig.defaultWorkspace)));const c=null!==(A=e.treePath)&&void 0!==A?A:getOption("treePath");return c&&(i=url_1.URLExt.join(i,"tree",url_1.URLExt.encodeParts(c))),i}function getWsUrl(e){let t=getOption("wsUrl");if(!t){if(0!==(e=e?url_1.URLExt.normalize(e):getBaseUrl()).indexOf("http"))return"";t="ws"+e.slice(4)}return url_1.URLExt.normalize(t)}function getNBConvertURL({path:e,format:t,download:n}){const r=url_1.URLExt.encodeParts(e),A=url_1.URLExt.join(getBaseUrl(),"nbconvert",t,r);return n?A+"?download=true":A}function getToken(){return getOption("token")||getBodyData("jupyterApiToken")}function getNotebookVersion(){const e=getOption("notebookVersion");return""===e?[0,0,0]:JSON.parse(e)}PageConfig.getOption=getOption,PageConfig.setOption=setOption,PageConfig.getBaseUrl=getBaseUrl,PageConfig.getTreeUrl=getTreeUrl,PageConfig.getShareUrl=getShareUrl,PageConfig.getTreeShareUrl=getTreeShareUrl,PageConfig.getUrl=getUrl,PageConfig.defaultWorkspace="default",PageConfig.getWsUrl=getWsUrl,PageConfig.getNBConvertURL=getNBConvertURL,PageConfig.getToken=getToken,PageConfig.getNotebookVersion=getNotebookVersion;let configData=null,Extension;function getBodyData(e){if("undefined"==typeof document||!document.body)return"";const t=document.body.dataset[e];return void 0===t?"":decodeURIComponent(t)}!function(e){function t(e){try{const t=getOption(e);if(t)return JSON.parse(t)}catch(t){console.warn(`Unable to parse ${e}.`,t)}return[]}e.deferred=t("deferredExtensions"),e.disabled=t("disabledExtensions"),e.isDeferred=function(t){const n=t.indexOf(":");let r="";return-1!==n&&(r=t.slice(0,n)),e.deferred.some((e=>e===t||r&&e===r))},e.isDisabled=function(t){const n=t.indexOf(":");let r="";return-1!==n&&(r=t.slice(0,n)),e.disabled.some((e=>e===t||r&&e===r))}}(Extension=PageConfig.Extension||(PageConfig.Extension={}))})(PageConfig||(exports.PageConfig=PageConfig={}))},9830:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.PathExt=void 0;const r=n(9942);var A;!function(e){function t(e){return 0===e.indexOf("/")&&(e=e.slice(1)),e}e.join=function(...e){const n=r.posix.join(...e);return"."===n?"":t(n)},e.joinWithLeadingSlash=function(...e){const t=r.posix.join(...e);return"."===t?"":t},e.basename=function(e,t){return r.posix.basename(e,t)},e.dirname=function(e){const n=t(r.posix.dirname(e));return"."===n?"":n},e.extname=function(e){return r.posix.extname(e)},e.normalize=function(e){return""===e?"":t(r.posix.normalize(e))},e.resolve=function(...e){return t(r.posix.resolve(...e))},e.relative=function(e,n){return t(r.posix.relative(e,n))},e.normalizeExtension=function(e){return e.length>0&&0!==e.indexOf(".")&&(e=`.${e}`),e},e.removeSlash=t}(A||(t.PathExt=A={}))},7361:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.signalToPromise=void 0;const r=n(5764);t.signalToPromise=function(e,t){const n=new r.PromiseDelegate;function A(){e.disconnect(i)}function i(e,t){A(),n.resolve([e,t])}return e.connect(i),(null!=t?t:0)>0&&setTimeout((()=>{A(),n.reject(`Signal not emitted within ${t} ms.`)}),t),n.promise}},8126:(e,t)=>{"use strict";var n;Object.defineProperty(t,"__esModule",{value:!0}),t.Text=void 0,function(e){e.jsIndexToCharIndex=function(e,t){return e},e.charIndexToJsIndex=function(e,t){return e},e.camelCase=function(e,t=!1){return e.replace(/^(\w)|[\s-_:]+(\w)/g,(function(e,n,r){return r?r.toUpperCase():t?n.toUpperCase():n.toLowerCase()}))},e.titleCase=function(e){return(e||"").toLowerCase().split(" ").map((e=>e.charAt(0).toUpperCase()+e.slice(1))).join(" ")}}(n||(t.Text=n={}))},1796:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Time=void 0;const n=[{name:"years",milliseconds:31536e6},{name:"months",milliseconds:2592e6},{name:"days",milliseconds:864e5},{name:"hours",milliseconds:36e5},{name:"minutes",milliseconds:6e4},{name:"seconds",milliseconds:1e3}];var r;!function(e){e.formatHuman=function(e,t="long"){const r=document.documentElement.lang||"en",A=new Intl.RelativeTimeFormat(r,{numeric:"auto",style:t}),i=new Date(e).getTime()-Date.now();for(let e of n){const t=Math.ceil(i/e.milliseconds);if(0!==t)return A.format(t,e.name)}return A.format(0,"seconds")},e.format=function(e){const t=document.documentElement.lang||"en";return new Intl.DateTimeFormat(t,{dateStyle:"short",timeStyle:"short"}).format(new Date(e))}}(r||(t.Time=r={}))},1692:function(e,t,n){"use strict";var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.URLExt=void 0;const A=n(9942),i=r(n(2225));var s;!function(e){function t(e){if("undefined"!=typeof document&&document){const t=document.createElement("a");return t.href=e,t}return(0,i.default)(e)}function n(...e){let t=(0,i.default)(e[0],{});const n=""===t.protocol&&t.slashes;n&&(t=(0,i.default)(e[0],"https:"+e[0]));const r=`${n?"":t.protocol}${t.slashes?"//":""}${t.auth}${t.auth?"@":""}${t.host}`,s=A.posix.join(`${r&&"/"!==t.pathname[0]?"/":""}${t.pathname}`,...e.slice(1));return`${r}${"."===s?"":s}`}e.parse=t,e.getHostName=function(e){return(0,i.default)(e).hostname},e.normalize=function(e){return e&&t(e).toString()},e.join=n,e.encodeParts=function(e){return n(...e.split("/").map(encodeURIComponent))},e.objectToQueryString=function(e){const t=Object.keys(e).filter((e=>e.length>0));return t.length?"?"+t.map((t=>{const n=encodeURIComponent(String(e[t]));return t+(n?"="+n:"")})).join("&"):""},e.queryStringToObject=function(e){return e.replace(/^\?/,"").split("&").reduce(((e,t)=>{const[n,r]=t.split("=");return n.length>0&&(e[n]=decodeURIComponent(r||"")),e}),{})},e.isLocal=function(e,n=!1){const{protocol:r}=t(e);return(!r||0!==e.toLowerCase().indexOf(r))&&(n?0!==e.indexOf("//"):0!==e.indexOf("/"))}}(s||(t.URLExt=s={}))},3867:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.BaseManager=void 0;const r=n(3992),A=n(2920);t.BaseManager=class{constructor(e){var t;this._isDisposed=!1,this._disposed=new r.Signal(this),this.serverSettings=null!==(t=e.serverSettings)&&void 0!==t?t:A.ServerConnection.makeSettings()}get disposed(){return this._disposed}get isDisposed(){return this._isDisposed}get isActive(){return!0}dispose(){this.isDisposed||(this._isDisposed=!0,this._disposed.emit(void 0),r.Signal.clearData(this))}}},4219:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.BuildManager=void 0;const r=n(8925),A=n(2920);t.BuildManager=class{constructor(e={}){var t;this._url="",this.serverSettings=null!==(t=e.serverSettings)&&void 0!==t?t:A.ServerConnection.makeSettings();const{baseUrl:n,appUrl:i}=this.serverSettings;this._url=r.URLExt.join(n,i,"api/build")}get isAvailable(){return"true"===r.PageConfig.getOption("buildAvailable").toLowerCase()}get shouldCheck(){return"true"===r.PageConfig.getOption("buildCheck").toLowerCase()}getStatus(){const{_url:e,serverSettings:t}=this;return A.ServerConnection.makeRequest(e,{},t).then((e=>{if(200!==e.status)throw new A.ServerConnection.ResponseError(e);return e.json()})).then((e=>{if("string"!=typeof e.status)throw new Error("Invalid data");if("string"!=typeof e.message)throw new Error("Invalid data");return e}))}build(){const{_url:e,serverSettings:t}=this;return A.ServerConnection.makeRequest(e,{method:"POST"},t).then((e=>{if(400===e.status)throw new A.ServerConnection.ResponseError(e,"Build aborted");if(200!==e.status){const t=`Build failed with ${e.status}.\n\n        If you are experiencing the build failure after installing an extension (or trying to include previously installed extension after updating JupyterLab) please check the extension repository for new installation instructions as many extensions migrated to the prebuilt extensions system which no longer requires rebuilding JupyterLab (but uses a different installation procedure, typically involving a package manager such as 'pip' or 'conda').\n\n        If you specifically intended to install a source extension, please run 'jupyter lab build' on the server for full output.`;throw new A.ServerConnection.ResponseError(e,t)}}))}cancel(){const{_url:e,serverSettings:t}=this;return A.ServerConnection.makeRequest(e,{method:"DELETE"},t).then((e=>{if(204!==e.status)throw new A.ServerConnection.ResponseError(e)}))}}},2170:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ConfigWithDefaults=t.ConfigSection=void 0;const r=n(8925),A=n(7883);var i;!function(e){e.create=function(e){const t=new s(e);return t.load().then((()=>t))}}(i||(t.ConfigSection=i={}));class s{constructor(e){var t;this._url="unknown";const n=this.serverSettings=null!==(t=e.serverSettings)&&void 0!==t?t:A.ServerConnection.makeSettings();this._url=r.URLExt.join(n.baseUrl,"api/config",encodeURIComponent(e.name))}get data(){return this._data}async load(){const e=await A.ServerConnection.makeRequest(this._url,{},this.serverSettings);if(200!==e.status)throw await A.ServerConnection.ResponseError.create(e);this._data=await e.json()}async update(e){this._data={...this._data,...e};const t={method:"PATCH",body:JSON.stringify(e)},n=await A.ServerConnection.makeRequest(this._url,t,this.serverSettings);if(200!==n.status)throw await A.ServerConnection.ResponseError.create(n);return this._data=await n.json(),this._data}}t.ConfigWithDefaults=class{constructor(e){var t,n;this._className="",this._section=e.section,this._defaults=null!==(t=e.defaults)&&void 0!==t?t:{},this._className=null!==(n=e.className)&&void 0!==n?n:""}get(e){const t=this._classData();return e in t?t[e]:this._defaults[e]}set(e,t){const n={};if(n[e]=t,this._className){const e={};return e[this._className]=n,this._section.update(e)}return this._section.update(n)}_classData(){const e=this._section.data;return this._className&&this._className in e?e[this._className]:e}}},8790:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return A(t,e),t};Object.defineProperty(t,"__esModule",{value:!0}),t.Drive=t.ContentsManager=t.Contents=void 0;const s=n(8925),a=n(3992),o=n(7883),c=i(n(2706));var l,u;!function(e){e.validateContentsModel=function(e){c.validateContentsModel(e)},e.validateCheckpointModel=function(e){c.validateCheckpointModel(e)}}(l||(t.Contents=l={})),t.ContentsManager=class{constructor(e={}){var t,n;this._isDisposed=!1,this._additionalDrives=new Map,this._fileChanged=new a.Signal(this);const r=this.serverSettings=null!==(t=e.serverSettings)&&void 0!==t?t:o.ServerConnection.makeSettings();this._defaultDrive=null!==(n=e.defaultDrive)&&void 0!==n?n:new h({serverSettings:r}),this._defaultDrive.fileChanged.connect(this._onFileChanged,this)}get fileChanged(){return this._fileChanged}get isDisposed(){return this._isDisposed}dispose(){this.isDisposed||(this._isDisposed=!0,a.Signal.clearData(this))}addDrive(e){this._additionalDrives.set(e.name,e),e.fileChanged.connect(this._onFileChanged,this)}getSharedModelFactory(e){var t;const[n]=this._driveForPath(e);return null!==(t=null==n?void 0:n.sharedModelFactory)&&void 0!==t?t:null}localPath(e){const t=e.split("/"),n=t[0].split(":");return 1!==n.length&&this._additionalDrives.has(n[0])?s.PathExt.join(n.slice(1).join(":"),...t.slice(1)):s.PathExt.removeSlash(e)}normalize(e){const t=e.split(":");return 1===t.length?s.PathExt.normalize(e):`${t[0]}:${s.PathExt.normalize(t.slice(1).join(":"))}`}resolvePath(e,t){const n=this.driveName(e),r=this.localPath(e),A=s.PathExt.resolve("/",r,t);return n?`${n}:${A}`:A}driveName(e){const t=e.split("/")[0].split(":");return 1===t.length?"":this._additionalDrives.has(t[0])?t[0]:""}get(e,t){const[n,r]=this._driveForPath(e);return n.get(r,t).then((e=>{const t=[];if("directory"===e.type&&e.content){for(const r of e.content)t.push({...r,path:this._toGlobalPath(n,r.path)});return{...e,path:this._toGlobalPath(n,r),content:t,serverPath:e.path}}return{...e,path:this._toGlobalPath(n,r),serverPath:e.path}}))}getDownloadUrl(e){const[t,n]=this._driveForPath(e);return t.getDownloadUrl(n)}newUntitled(e={}){if(e.path){const t=this.normalize(e.path),[n,r]=this._driveForPath(t);return n.newUntitled({...e,path:r}).then((e=>({...e,path:s.PathExt.join(t,e.name),serverPath:e.path})))}return this._defaultDrive.newUntitled(e)}delete(e){const[t,n]=this._driveForPath(e);return t.delete(n)}rename(e,t){const[n,r]=this._driveForPath(e),[A,i]=this._driveForPath(t);if(n!==A)throw Error("ContentsManager: renaming files must occur within a Drive");return n.rename(r,i).then((e=>({...e,path:this._toGlobalPath(n,i),serverPath:e.path})))}save(e,t={}){const n=this.normalize(e),[r,A]=this._driveForPath(e);return r.save(A,{...t,path:A}).then((e=>({...e,path:n,serverPath:e.path})))}copy(e,t){const[n,r]=this._driveForPath(e),[A,i]=this._driveForPath(t);if(n===A)return n.copy(r,i).then((e=>({...e,path:this._toGlobalPath(n,e.path),serverPath:e.path})));throw Error("Copying files between drives is not currently implemented")}createCheckpoint(e){const[t,n]=this._driveForPath(e);return t.createCheckpoint(n)}listCheckpoints(e){const[t,n]=this._driveForPath(e);return t.listCheckpoints(n)}restoreCheckpoint(e,t){const[n,r]=this._driveForPath(e);return n.restoreCheckpoint(r,t)}deleteCheckpoint(e,t){const[n,r]=this._driveForPath(e);return n.deleteCheckpoint(r,t)}_toGlobalPath(e,t){return e===this._defaultDrive?s.PathExt.removeSlash(t):`${e.name}:${s.PathExt.removeSlash(t)}`}_driveForPath(e){const t=this.driveName(e),n=this.localPath(e);return t?[this._additionalDrives.get(t),n]:[this._defaultDrive,n]}_onFileChanged(e,t){var n,r;if(e===this._defaultDrive)this._fileChanged.emit(t);else{let A=null,i=null;(null===(n=t.newValue)||void 0===n?void 0:n.path)&&(A={...t.newValue,path:this._toGlobalPath(e,t.newValue.path)}),(null===(r=t.oldValue)||void 0===r?void 0:r.path)&&(i={...t.oldValue,path:this._toGlobalPath(e,t.oldValue.path)}),this._fileChanged.emit({type:t.type,newValue:A,oldValue:i})}}};class h{constructor(e={}){var t,n,r;this._isDisposed=!1,this._fileChanged=new a.Signal(this),this.name=null!==(t=e.name)&&void 0!==t?t:"Default",this._apiEndpoint=null!==(n=e.apiEndpoint)&&void 0!==n?n:"api/contents",this.serverSettings=null!==(r=e.serverSettings)&&void 0!==r?r:o.ServerConnection.makeSettings()}get fileChanged(){return this._fileChanged}get isDisposed(){return this._isDisposed}dispose(){this.isDisposed||(this._isDisposed=!0,a.Signal.clearData(this))}async get(e,t){let n=this._getUrl(e);if(t){"notebook"===t.type&&delete t.format;const e=t.content?"1":"0",r=t.hash?"1":"0",A={...t,content:e,hash:r};n+=s.URLExt.objectToQueryString(A)}const r=this.serverSettings,A=await o.ServerConnection.makeRequest(n,{},r);if(200!==A.status)throw await o.ServerConnection.ResponseError.create(A);const i=await A.json();return c.validateContentsModel(i),i}getDownloadUrl(e){const t=this.serverSettings.baseUrl;let n=s.URLExt.join(t,"files",s.URLExt.encodeParts(e)),r="";try{r=document.cookie}catch(e){}const A=r.match("\\b_xsrf=([^;]*)\\b");if(A){const e=new URL(n);e.searchParams.append("_xsrf",A[1]),n=e.toString()}return Promise.resolve(n)}async newUntitled(e={}){var t;let n="{}";e&&(e.ext&&(e.ext=u.normalizeExtension(e.ext)),n=JSON.stringify(e));const r=this.serverSettings,A=this._getUrl(null!==(t=e.path)&&void 0!==t?t:""),i={method:"POST",body:n},s=await o.ServerConnection.makeRequest(A,i,r);if(201!==s.status)throw await o.ServerConnection.ResponseError.create(s);const a=await s.json();return c.validateContentsModel(a),this._fileChanged.emit({type:"new",oldValue:null,newValue:a}),a}async delete(e){const t=this._getUrl(e),n=this.serverSettings,r=await o.ServerConnection.makeRequest(t,{method:"DELETE"},n);if(204!==r.status)throw await o.ServerConnection.ResponseError.create(r);this._fileChanged.emit({type:"delete",oldValue:{path:e},newValue:null})}async rename(e,t){const n=this.serverSettings,r=this._getUrl(e),A={method:"PATCH",body:JSON.stringify({path:t})},i=await o.ServerConnection.makeRequest(r,A,n);if(200!==i.status)throw await o.ServerConnection.ResponseError.create(i);const s=await i.json();return c.validateContentsModel(s),this._fileChanged.emit({type:"rename",oldValue:{path:e},newValue:s}),s}async save(e,t={}){const n=this.serverSettings,r=this._getUrl(e),A={method:"PUT",body:JSON.stringify(t)},i=await o.ServerConnection.makeRequest(r,A,n);if(200!==i.status&&201!==i.status)throw await o.ServerConnection.ResponseError.create(i);const s=await i.json();return c.validateContentsModel(s),this._fileChanged.emit({type:"save",oldValue:null,newValue:s}),s}async copy(e,t){const n=this.serverSettings,r=this._getUrl(t),A={method:"POST",body:JSON.stringify({copy_from:e})},i=await o.ServerConnection.makeRequest(r,A,n);if(201!==i.status)throw await o.ServerConnection.ResponseError.create(i);const s=await i.json();return c.validateContentsModel(s),this._fileChanged.emit({type:"new",oldValue:null,newValue:s}),s}async createCheckpoint(e){const t=this._getUrl(e,"checkpoints"),n=await o.ServerConnection.makeRequest(t,{method:"POST"},this.serverSettings);if(201!==n.status)throw await o.ServerConnection.ResponseError.create(n);const r=await n.json();return c.validateCheckpointModel(r),r}async listCheckpoints(e){const t=this._getUrl(e,"checkpoints"),n=await o.ServerConnection.makeRequest(t,{},this.serverSettings);if(200!==n.status)throw await o.ServerConnection.ResponseError.create(n);const r=await n.json();if(!Array.isArray(r))throw new Error("Invalid Checkpoint list");for(let e=0;e<r.length;e++)c.validateCheckpointModel(r[e]);return r}async restoreCheckpoint(e,t){const n=this._getUrl(e,"checkpoints",t),r=await o.ServerConnection.makeRequest(n,{method:"POST"},this.serverSettings);if(204!==r.status)throw await o.ServerConnection.ResponseError.create(r)}async deleteCheckpoint(e,t){const n=this._getUrl(e,"checkpoints",t),r=await o.ServerConnection.makeRequest(n,{method:"DELETE"},this.serverSettings);if(204!==r.status)throw await o.ServerConnection.ResponseError.create(r)}_getUrl(...e){const t=e.map((e=>s.URLExt.encodeParts(e))),n=this.serverSettings.baseUrl;return s.URLExt.join(n,this._apiEndpoint,...t)}}t.Drive=h,function(e){e.normalizeExtension=function(e){return e.length>0&&0!==e.indexOf(".")&&(e=`.${e}`),e}}(u||(u={}))},2706:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.validateCheckpointModel=t.validateContentsModel=void 0;const r=n(7441);t.validateContentsModel=function(e){(0,r.validateProperty)(e,"name","string"),(0,r.validateProperty)(e,"path","string"),(0,r.validateProperty)(e,"type","string"),(0,r.validateProperty)(e,"created","string"),(0,r.validateProperty)(e,"last_modified","string"),(0,r.validateProperty)(e,"mimetype","object"),(0,r.validateProperty)(e,"content","object"),(0,r.validateProperty)(e,"format","object")},t.validateCheckpointModel=function(e){(0,r.validateProperty)(e,"id","string"),(0,r.validateProperty)(e,"last_modified","string")}},9480:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.EventManager=void 0;const r=n(8925),A=n(6049),i=n(3992),s=n(2920),a="api/events";t.EventManager=class{constructor(e={}){var t;this._socket=null,this.serverSettings=null!==(t=e.serverSettings)&&void 0!==t?t:s.ServerConnection.makeSettings(),this._poll=new A.Poll({factory:()=>this._subscribe()}),this._stream=new i.Stream(this),this._poll.start()}get isDisposed(){return this._poll.isDisposed}get stream(){return this._stream}dispose(){if(this.isDisposed)return;this._poll.dispose();const e=this._socket;e&&(this._socket=null,e.onopen=()=>{},e.onerror=()=>{},e.onmessage=()=>{},e.onclose=()=>{},e.close()),i.Signal.clearData(this),this._stream.stop()}async emit(e){const{serverSettings:t}=this,{baseUrl:n}=t,{makeRequest:A,ResponseError:i}=s.ServerConnection,o=r.URLExt.join(n,a),c={body:JSON.stringify(e),method:"POST"},l=await A(o,c,t);if(204!==l.status)throw new i(l)}_subscribe(){return new Promise(((e,t)=>{if(this.isDisposed)return;const{appendToken:n,token:A,WebSocket:i,wsUrl:s}=this.serverSettings;let o=r.URLExt.join(s,a,"subscribe");n&&""!==A&&(o+=`?token=${encodeURIComponent(A)}`);const c=this._socket=new i(o),l=this._stream;c.onclose=()=>t(new Error("EventManager socket closed")),c.onmessage=e=>e.data&&l.emit(JSON.parse(e.data))}))}}},7883:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(t,"__esModule",{value:!0}),A(n(3867),t),A(n(2170),t),A(n(8790),t),A(n(9480),t),A(n(973),t),A(n(2946),t),A(n(9740),t),A(n(2920),t),A(n(7668),t),A(n(7780),t),A(n(9040),t),A(n(9191),t),A(n(8053),t),A(n(8683),t)},7489:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return A(t,e),t};Object.defineProperty(t,"__esModule",{value:!0}),t.CommHandler=void 0;const s=n(7556),a=i(n(9909));class o extends s.DisposableDelegate{constructor(e,t,n,r){super(r),this._target="",this._id="",this._id=t,this._target=e,this._kernel=n}get commId(){return this._id}get targetName(){return this._target}get onClose(){return this._onClose}set onClose(e){this._onClose=e}get onMsg(){return this._onMsg}set onMsg(e){this._onMsg=e}open(e,t,n=[]){if(this.isDisposed||this._kernel.isDisposed)throw new Error("Cannot open");const r=a.createMessage({msgType:"comm_open",channel:"shell",username:this._kernel.username,session:this._kernel.clientId,content:{comm_id:this._id,target_name:this._target,data:null!=e?e:{}},metadata:t,buffers:n});return this._kernel.sendShellMessage(r,!1,!0)}send(e,t,n=[],r=!0){if(this.isDisposed||this._kernel.isDisposed)throw new Error("Cannot send");const A=a.createMessage({msgType:"comm_msg",channel:"shell",username:this._kernel.username,session:this._kernel.clientId,content:{comm_id:this._id,data:e},metadata:t,buffers:n});return this._kernel.sendShellMessage(A,!1,r)}close(e,t,n=[]){if(this.isDisposed||this._kernel.isDisposed)throw new Error("Cannot close");const r=a.createMessage({msgType:"comm_close",channel:"shell",username:this._kernel.username,session:this._kernel.clientId,content:{comm_id:this._id,data:null!=e?e:{}},metadata:t,buffers:n}),A=this._kernel.sendShellMessage(r,!1,!0),i=this._onClose;return i&&i(a.createMessage({msgType:"comm_close",channel:"iopub",username:this._kernel.username,session:this._kernel.clientId,content:{comm_id:this._id,data:null!=e?e:{}},metadata:t,buffers:n})),this.dispose(),A}}t.CommHandler=o},2456:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return A(t,e),t};Object.defineProperty(t,"__esModule",{value:!0}),t.KernelConnection=void 0;const s=n(8925),a=n(5764),o=n(3992),c=n(7883),l=n(7489),u=i(n(9909)),h=n(134),d=i(n(5855)),f=n(2946),p=i(n(8235)),g="_RESTARTING_";class m{constructor(e){var t,n,r,A;this._createSocket=(e=!0)=>{this._errorIfDisposed(),this._clearSocket(),this._updateConnectionStatus("connecting");const t=this.serverSettings,n=s.URLExt.join(t.wsUrl,p.KERNEL_SERVICE_URL,encodeURIComponent(this._id)),r=n.replace(/^((?:\w+:)?\/\/)(?:[^@\/]+@)/,"$1");console.debug(`Starting WebSocket: ${r}`);let A=s.URLExt.join(n,"channels?session_id="+encodeURIComponent(this._clientId));const i=t.token;t.appendToken&&""!==i&&(A+=`&token=${encodeURIComponent(i)}`);const a=e?this._supportedProtocols:[];this._ws=new t.WebSocket(A,a),this._ws.binaryType="arraybuffer";let o=!1;const l=async e=>{var n,r;if(!this._isDisposed){this._reason="",this._model=void 0;try{const n=await p.getKernelModel(this._id,t);this._model=n,"dead"===(null==n?void 0:n.execution_state)?this._updateStatus("dead"):this._onWSClose(e)}catch(t){if(t instanceof c.ServerConnection.NetworkError||503===(null===(n=t.response)||void 0===n?void 0:n.status)||424===(null===(r=t.response)||void 0===r?void 0:r.status)){const t=1e3*y.getRandomIntInclusive(10,30);setTimeout(l,t,e)}else this._reason="Kernel died unexpectedly",this._updateStatus("dead")}}},u=async e=>{o||(o=!0,await l(e))};this._ws.onmessage=this._onWSMessage,this._ws.onopen=this._onWSOpen,this._ws.onclose=u,this._ws.onerror=u},this._onWSOpen=e=>{if(""!==this._ws.protocol&&!this._supportedProtocols.includes(this._ws.protocol))throw console.log("Server selected unknown kernel wire protocol:",this._ws.protocol),this._updateStatus("dead"),new Error(`Unknown kernel wire protocol:  ${this._ws.protocol}`);this._selectedProtocol=this._ws.protocol,this._ws.onclose=this._onWSClose,this._ws.onerror=this._onWSClose,this._updateConnectionStatus("connected")},this._onWSMessage=e=>{let t;try{t=this.serverSettings.serializer.deserialize(e.data,this._ws.protocol),d.validateMessage(t)}catch(e){throw e.message=`Kernel message validation error: ${e.message}`,e}this._kernelSession=t.header.session,this._msgChain=this._msgChain.then((()=>this._handleMessage(t))).catch((e=>{e.message.startsWith("Canceled future for ")&&console.error(e)})),this._anyMessage.emit({msg:t,direction:"recv"})},this._onWSClose=e=>{this.isDisposed||this._reconnect()},this._id="",this._name="",this._status="unknown",this._connectionStatus="connecting",this._kernelSession="",this._isDisposed=!1,this._ws=null,this._username="",this._reconnectLimit=7,this._reconnectAttempt=0,this._reconnectTimeout=null,this._supportedProtocols=Object.values(u.supportedKernelWebSocketProtocols),this._selectedProtocol="",this._futures=new Map,this._comms=new Map,this._targetRegistry=Object.create(null),this._info=new a.PromiseDelegate,this._pendingMessages=[],this._statusChanged=new o.Signal(this),this._connectionStatusChanged=new o.Signal(this),this._disposed=new o.Signal(this),this._iopubMessage=new o.Signal(this),this._anyMessage=new o.Signal(this),this._pendingInput=new o.Signal(this),this._unhandledMessage=new o.Signal(this),this._displayIdToParentIds=new Map,this._msgIdToDisplayIds=new Map,this._msgChain=Promise.resolve(),this._hasPendingInput=!1,this._reason="",this._noOp=()=>{},this._name=e.model.name,this._id=e.model.id,this.serverSettings=null!==(t=e.serverSettings)&&void 0!==t?t:c.ServerConnection.makeSettings(),this._clientId=null!==(n=e.clientId)&&void 0!==n?n:a.UUID.uuid4(),this._username=null!==(r=e.username)&&void 0!==r?r:"",this.handleComms=null===(A=e.handleComms)||void 0===A||A,this._createSocket()}get disposed(){return this._disposed}get statusChanged(){return this._statusChanged}get connectionStatusChanged(){return this._connectionStatusChanged}get iopubMessage(){return this._iopubMessage}get unhandledMessage(){return this._unhandledMessage}get model(){return this._model||{id:this.id,name:this.name,reason:this._reason}}get anyMessage(){return this._anyMessage}get pendingInput(){return this._pendingInput}get id(){return this._id}get name(){return this._name}get username(){return this._username}get clientId(){return this._clientId}get status(){return this._status}get connectionStatus(){return this._connectionStatus}get isDisposed(){return this._isDisposed}get info(){return this._info.promise}get spec(){return this._specPromise||(this._specPromise=f.KernelSpecAPI.getSpecs(this.serverSettings).then((e=>e.kernelspecs[this._name]))),this._specPromise}clone(e={}){return new m({model:this.model,username:this.username,serverSettings:this.serverSettings,handleComms:!1,...e})}dispose(){this.isDisposed||(this._isDisposed=!0,this._disposed.emit(),this._updateConnectionStatus("disconnected"),this._clearKernelState(),this._pendingMessages=[],this._clearSocket(),o.Signal.clearData(this))}sendShellMessage(e,t=!1,n=!0){return this._sendKernelShellControl(h.KernelShellFutureHandler,e,t,n)}sendControlMessage(e,t=!1,n=!0){return this._sendKernelShellControl(h.KernelControlFutureHandler,e,t,n)}_sendKernelShellControl(e,t,n=!1,r=!0){this._sendMessage(t),this._anyMessage.emit({msg:t,direction:"send"});const A=new e((()=>{const e=t.header.msg_id;this._futures.delete(e);const n=this._msgIdToDisplayIds.get(e);n&&(n.forEach((t=>{const n=this._displayIdToParentIds.get(t);if(n){const r=n.indexOf(e);if(-1===r)return;1===n.length?this._displayIdToParentIds.delete(t):(n.splice(r,1),this._displayIdToParentIds.set(t,n))}})),this._msgIdToDisplayIds.delete(e))}),t,n,r,this);return this._futures.set(t.header.msg_id,A),A}_sendMessage(e,t=!0){if("dead"===this.status)throw new Error("Kernel is dead");if((""===this._kernelSession||this._kernelSession===g)&&u.isInfoRequestMsg(e)){if("connected"===this.connectionStatus)return void this._ws.send(this.serverSettings.serializer.serialize(e,this._ws.protocol));throw new Error("Could not send message: status is not connected")}if(t&&this._pendingMessages.length>0)this._pendingMessages.push(e);else if("connected"===this.connectionStatus&&this._kernelSession!==g)this._ws.send(this.serverSettings.serializer.serialize(e,this._ws.protocol));else{if(!t)throw new Error("Could not send message");this._pendingMessages.push(e)}}async interrupt(){if(this.hasPendingInput=!1,"dead"===this.status)throw new Error("Kernel is dead");return p.interruptKernel(this.id,this.serverSettings)}async restart(){if("dead"===this.status)throw new Error("Kernel is dead");this._updateStatus("restarting"),this._clearKernelState(),this._kernelSession=g,await p.restartKernel(this.id,this.serverSettings),await this.reconnect(),this.hasPendingInput=!1}reconnect(){this._errorIfDisposed();const e=new a.PromiseDelegate,t=(n,r)=>{"connected"===r?(e.resolve(),this.connectionStatusChanged.disconnect(t,this)):"disconnected"===r&&(e.reject(new Error("Kernel connection disconnected")),this.connectionStatusChanged.disconnect(t,this))};return this.connectionStatusChanged.connect(t,this),this._reconnectAttempt=0,this._reconnect(),e.promise}async shutdown(){"dead"!==this.status&&await p.shutdownKernel(this.id,this.serverSettings),this.handleShutdown()}handleShutdown(){this._updateStatus("dead"),this.dispose()}async requestKernelInfo(){const e=u.createMessage({msgType:"kernel_info_request",channel:"shell",username:this._username,session:this._clientId,content:{}});let t;try{t=await y.handleShellMessage(this,e)}catch(e){if(this.isDisposed)return;throw e}if(this._errorIfDisposed(),t)return void 0===t.content.status&&(t.content.status="ok"),"ok"!==t.content.status?(this._info.reject("Kernel info reply errored"),t):(this._info.resolve(t.content),this._kernelSession=t.header.session,t)}requestComplete(e){const t=u.createMessage({msgType:"complete_request",channel:"shell",username:this._username,session:this._clientId,content:e});return y.handleShellMessage(this,t)}requestInspect(e){const t=u.createMessage({msgType:"inspect_request",channel:"shell",username:this._username,session:this._clientId,content:e});return y.handleShellMessage(this,t)}requestHistory(e){const t=u.createMessage({msgType:"history_request",channel:"shell",username:this._username,session:this._clientId,content:e});return y.handleShellMessage(this,t)}requestExecute(e,t=!0,n){const r=u.createMessage({msgType:"execute_request",channel:"shell",username:this._username,session:this._clientId,content:{silent:!1,store_history:!0,user_expressions:{},allow_stdin:!0,stop_on_error:!1,...e},metadata:n});return this.sendShellMessage(r,!0,t)}requestDebug(e,t=!0){const n=u.createMessage({msgType:"debug_request",channel:"control",username:this._username,session:this._clientId,content:e});return this.sendControlMessage(n,!0,t)}requestIsComplete(e){const t=u.createMessage({msgType:"is_complete_request",channel:"shell",username:this._username,session:this._clientId,content:e});return y.handleShellMessage(this,t)}requestCommInfo(e){const t=u.createMessage({msgType:"comm_info_request",channel:"shell",username:this._username,session:this._clientId,content:e});return y.handleShellMessage(this,t)}sendInputReply(e,t){const n=u.createMessage({msgType:"input_reply",channel:"stdin",username:this._username,session:this._clientId,content:e});n.parent_header=t,this._sendMessage(n),this._anyMessage.emit({msg:n,direction:"send"}),this.hasPendingInput=!1}createComm(e,t=a.UUID.uuid4()){if(!this.handleComms)throw new Error("Comms are disabled on this kernel connection");if(this._comms.has(t))throw new Error("Comm is already created");const n=new l.CommHandler(e,t,this,(()=>{this._unregisterComm(t)}));return this._comms.set(t,n),n}hasComm(e){return this._comms.has(e)}registerCommTarget(e,t){this.handleComms&&(this._targetRegistry[e]=t)}removeCommTarget(e,t){this.handleComms&&(this.isDisposed||this._targetRegistry[e]!==t||delete this._targetRegistry[e])}registerMessageHook(e,t){var n;const r=null===(n=this._futures)||void 0===n?void 0:n.get(e);r&&r.registerMessageHook(t)}removeMessageHook(e,t){var n;const r=null===(n=this._futures)||void 0===n?void 0:n.get(e);r&&r.removeMessageHook(t)}removeInputGuard(){this.hasPendingInput=!1}async _handleDisplayId(e,t){var n,r;const A=t.parent_header.msg_id;let i=this._displayIdToParentIds.get(e);if(i){const e={header:a.JSONExt.deepCopy(t.header),parent_header:a.JSONExt.deepCopy(t.parent_header),metadata:a.JSONExt.deepCopy(t.metadata),content:a.JSONExt.deepCopy(t.content),channel:t.channel,buffers:t.buffers?t.buffers.slice():[]};e.header.msg_type="update_display_data",await Promise.all(i.map((async t=>{const n=this._futures&&this._futures.get(t);n&&await n.handleMsg(e)})))}if("update_display_data"===t.header.msg_type)return!0;i=null!==(n=this._displayIdToParentIds.get(e))&&void 0!==n?n:[],-1===i.indexOf(A)&&i.push(A),this._displayIdToParentIds.set(e,i);const s=null!==(r=this._msgIdToDisplayIds.get(A))&&void 0!==r?r:[];return-1===s.indexOf(A)&&s.push(A),this._msgIdToDisplayIds.set(A,s),!1}_clearSocket(){null!==this._ws&&(this._ws.onopen=this._noOp,this._ws.onclose=this._noOp,this._ws.onerror=this._noOp,this._ws.onmessage=this._noOp,this._ws.close(),this._ws=null)}_updateStatus(e){this._status!==e&&"dead"!==this._status&&(this._status=e,y.logKernelStatus(this),this._statusChanged.emit(e),"dead"===e&&this.dispose())}_sendPending(){for(;"connected"===this.connectionStatus&&this._kernelSession!==g&&this._pendingMessages.length>0;)this._sendMessage(this._pendingMessages[0],!1),this._pendingMessages.shift()}_clearKernelState(){this._kernelSession="",this._pendingMessages=[],this._futures.forEach((e=>{e.dispose()})),this._comms.forEach((e=>{e.dispose()})),this._msgChain=Promise.resolve(),this._futures=new Map,this._comms=new Map,this._displayIdToParentIds.clear(),this._msgIdToDisplayIds.clear()}_assertCurrentMessage(e){if(this._errorIfDisposed(),e.header.session!==this._kernelSession)throw new Error(`Canceling handling of old message: ${e.header.msg_type}`)}async _handleCommOpen(e){this._assertCurrentMessage(e);const t=e.content,n=new l.CommHandler(t.target_name,t.comm_id,this,(()=>{this._unregisterComm(t.comm_id)}));this._comms.set(t.comm_id,n);try{const r=await y.loadObject(t.target_name,t.target_module,this._targetRegistry);await r(n,e)}catch(e){throw n.close(),console.error("Exception opening new comm"),e}}async _handleCommClose(e){this._assertCurrentMessage(e);const t=e.content,n=this._comms.get(t.comm_id);if(!n)return void console.error("Comm not found for comm id "+t.comm_id);this._unregisterComm(n.commId);const r=n.onClose;r&&await r(e),n.dispose()}async _handleCommMsg(e){this._assertCurrentMessage(e);const t=e.content,n=this._comms.get(t.comm_id);if(!n)return;const r=n.onMsg;r&&await r(e)}_unregisterComm(e){this._comms.delete(e)}_updateConnectionStatus(e){if(this._connectionStatus!==e){if(this._connectionStatus=e,"connecting"!==e&&(this._reconnectAttempt=0,clearTimeout(this._reconnectTimeout)),"dead"!==this.status)if("connected"===e){let e=this._kernelSession===g,t=this.requestKernelInfo(),n=!1,r=()=>{n||(n=!0,e&&this._kernelSession===g&&(this._kernelSession=""),clearTimeout(A),this._pendingMessages.length>0&&this._sendPending())};t.then(r);let A=setTimeout(r,3e3)}else this._updateStatus("unknown");this._connectionStatusChanged.emit(e)}}async _handleMessage(e){var t,n;let r=!1;if(e.parent_header&&"iopub"===e.channel&&(u.isDisplayDataMsg(e)||u.isUpdateDisplayDataMsg(e)||u.isExecuteResultMsg(e))){const n=(null!==(t=e.content.transient)&&void 0!==t?t:{}).display_id;n&&(r=await this._handleDisplayId(n,e),this._assertCurrentMessage(e))}if(!r&&e.parent_header){const t=e.parent_header,r=null===(n=this._futures)||void 0===n?void 0:n.get(t.msg_id);if(r)await r.handleMsg(e),this._assertCurrentMessage(e);else{const n=t.session===this.clientId;"iopub"!==e.channel&&n&&this._unhandledMessage.emit(e)}}if("iopub"===e.channel){switch(e.header.msg_type){case"status":{const t=e.content.execution_state;"restarting"===t&&Promise.resolve().then((async()=>{this._updateStatus("autorestarting"),this._clearKernelState(),await this.reconnect()})),this._updateStatus(t);break}case"comm_open":this.handleComms&&await this._handleCommOpen(e);break;case"comm_msg":this.handleComms&&await this._handleCommMsg(e);break;case"comm_close":this.handleComms&&await this._handleCommClose(e)}this.isDisposed||(this._assertCurrentMessage(e),this._iopubMessage.emit(e))}}_reconnect(){if(this._errorIfDisposed(),clearTimeout(this._reconnectTimeout),this._reconnectAttempt<this._reconnectLimit){this._updateConnectionStatus("connecting");const e=y.getRandomIntInclusive(0,1e3*(Math.pow(2,this._reconnectAttempt)-1));console.warn(`Connection lost, reconnecting in ${Math.floor(e/1e3)} seconds.`);const t=""!==this._selectedProtocol;this._reconnectTimeout=setTimeout(this._createSocket,e,t),this._reconnectAttempt+=1}else this._updateConnectionStatus("disconnected");this._clearSocket()}_errorIfDisposed(){if(this.isDisposed)throw new Error("Kernel connection is disposed")}get hasPendingInput(){return this._hasPendingInput}set hasPendingInput(e){this._hasPendingInput=e,this._pendingInput.emit(e)}}var y;t.KernelConnection=m,function(e){e.logKernelStatus=function(e){switch(e.status){case"idle":case"busy":case"unknown":return;default:console.debug(`Kernel: ${e.status} (${e.id})`)}},e.handleShellMessage=async function(e,t){return e.sendShellMessage(t,!0).done},e.loadObject=function(e,t,n){return new Promise(((r,A)=>{if(t){if("undefined"==typeof requirejs)throw new Error("requirejs not found");requirejs([t],(n=>{void 0===n[e]?A(new Error(`Object '${e}' not found in module '${t}'`)):r(n[e])}),A)}else(null==n?void 0:n[e])?r(n[e]):A(new Error(`Object '${e}' not found in registry`))}))},e.getRandomIntInclusive=function(e,t){return e=Math.ceil(e),t=Math.floor(t),Math.floor(Math.random()*(t-e+1))+e}}(y||(y={}))},134:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return A(t,e),t};Object.defineProperty(t,"__esModule",{value:!0}),t.KernelShellFutureHandler=t.KernelControlFutureHandler=t.KernelFutureHandler=void 0;const s=n(5764),a=n(7556),o=i(n(9909));class c extends a.DisposableDelegate{constructor(e,t,n,r,A){super(e),this._status=0,this._stdin=l.noOp,this._iopub=l.noOp,this._reply=l.noOp,this._done=new s.PromiseDelegate,this._hooks=new l.HookList,this._disposeOnDone=!0,this._msg=t,n||this._setFlag(l.KernelFutureFlag.GotReply),this._disposeOnDone=r,this._kernel=A}get msg(){return this._msg}get done(){return this._done.promise}get onReply(){return this._reply}set onReply(e){this._reply=e}get onIOPub(){return this._iopub}set onIOPub(e){this._iopub=e}get onStdin(){return this._stdin}set onStdin(e){this._stdin=e}registerMessageHook(e){if(this.isDisposed)throw new Error("Kernel future is disposed");this._hooks.add(e)}removeMessageHook(e){this.isDisposed||this._hooks.remove(e)}sendInputReply(e,t){this._kernel.sendInputReply(e,t)}dispose(){this._stdin=l.noOp,this._iopub=l.noOp,this._reply=l.noOp,this._hooks=null,this._testFlag(l.KernelFutureFlag.IsDone)||(this._done.promise.catch((()=>{})),this._done.reject(new Error(`Canceled future for ${this.msg.header.msg_type} message before replies were done`))),super.dispose()}async handleMsg(e){switch(e.channel){case"control":case"shell":e.channel===this.msg.channel&&e.parent_header.msg_id===this.msg.header.msg_id&&await this._handleReply(e);break;case"stdin":await this._handleStdin(e);break;case"iopub":await this._handleIOPub(e)}}async _handleReply(e){const t=this._reply;t&&await t(e),this._replyMsg=e,this._setFlag(l.KernelFutureFlag.GotReply),this._testFlag(l.KernelFutureFlag.GotIdle)&&this._handleDone()}async _handleStdin(e){this._kernel.hasPendingInput=!0;const t=this._stdin;t&&await t(e)}async _handleIOPub(e){const t=await this._hooks.process(e),n=this._iopub;t&&n&&await n(e),o.isStatusMsg(e)&&"idle"===e.content.execution_state&&(this._setFlag(l.KernelFutureFlag.GotIdle),this._testFlag(l.KernelFutureFlag.GotReply)&&this._handleDone())}_handleDone(){this._testFlag(l.KernelFutureFlag.IsDone)||(this._setFlag(l.KernelFutureFlag.IsDone),this._done.resolve(this._replyMsg),this._disposeOnDone&&this.dispose())}_testFlag(e){return!!(this._status&e)}_setFlag(e){this._status|=e}}var l;t.KernelFutureHandler=c,t.KernelControlFutureHandler=class extends c{},t.KernelShellFutureHandler=class extends c{},function(e){e.noOp=()=>{};const t="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;let n;e.HookList=class{constructor(){this._hooks=[]}add(e){this.remove(e),this._hooks.push(e)}remove(e){const t=this._hooks.indexOf(e);t>=0&&(this._hooks[t]=null,this._scheduleCompact())}async process(e){await this._processing;const t=new s.PromiseDelegate;let n;this._processing=t.promise;for(let r=this._hooks.length-1;r>=0;r--){const A=this._hooks[r];if(null!==A){try{n=await A(e)}catch(e){n=!0,console.error(e)}if(!1===n)return t.resolve(void 0),!1}}return t.resolve(void 0),!0}_scheduleCompact(){this._compactScheduled||(this._compactScheduled=!0,t((()=>{this._processing=this._processing.then((()=>{this._compactScheduled=!1,this._compact()}))})))}_compact(){let e=0;for(let t=0,n=this._hooks.length;t<n;t++){const n=this._hooks[t];null===this._hooks[t]?e++:this._hooks[t-e]=n}this._hooks.length-=e}},function(e){e[e.GotReply=1]="GotReply",e[e.GotIdle=2]="GotIdle",e[e.IsDone=4]="IsDone",e[e.DisposeOnDone=8]="DisposeOnDone"}(n=e.KernelFutureFlag||(e.KernelFutureFlag={}))}(l||(l={}))},973:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return A(t,e),t},s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(t,"__esModule",{value:!0}),t.KernelConnection=t.KernelAPI=t.KernelMessage=t.Kernel=void 0;const a=i(n(2956));t.Kernel=a;const o=i(n(9909));t.KernelMessage=o;const c=i(n(8235));t.KernelAPI=c;const l=n(2456);Object.defineProperty(t,"KernelConnection",{enumerable:!0,get:function(){return l.KernelConnection}}),s(n(5198),t)},2956:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},5198:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.KernelManager=void 0;const r=n(6049),A=n(3992),i=n(7883),s=n(3867),a=n(8235),o=n(2456);class c extends s.BaseManager{constructor(e={}){var t;super(e),this._isReady=!1,this._kernelConnections=new Set,this._models=new Map,this._runningChanged=new A.Signal(this),this._connectionFailure=new A.Signal(this),this._pollModels=new r.Poll({auto:!1,factory:()=>this.requestRunning(),frequency:{interval:1e4,backoff:!0,max:3e5},name:"@jupyterlab/services:KernelManager#models",standby:null!==(t=e.standby)&&void 0!==t?t:"when-hidden"}),this._ready=(async()=>{await this._pollModels.start(),await this._pollModels.tick,this._isReady=!0})()}get isReady(){return this._isReady}get ready(){return this._ready}get runningChanged(){return this._runningChanged}get connectionFailure(){return this._connectionFailure}dispose(){this.isDisposed||(this._models.clear(),this._kernelConnections.forEach((e=>e.dispose())),this._pollModels.dispose(),super.dispose())}connectTo(e){var t;const{id:n}=e.model;let r=null===(t=e.handleComms)||void 0===t||t;if(void 0===e.handleComms)for(const e of this._kernelConnections)if(e.id===n&&e.handleComms){r=!1;break}const A=new o.KernelConnection({handleComms:r,...e,serverSettings:this.serverSettings});return this._onStarted(A),this._models.has(n)||this.refreshRunning().catch((()=>{})),A}running(){return this._models.values()}get runningCount(){return this._models.size}async refreshRunning(){await this._pollModels.refresh(),await this._pollModels.tick}async startNew(e={},t={}){const n=await(0,a.startNew)(e,this.serverSettings);return this.connectTo({...t,model:n})}async shutdown(e){await(0,a.shutdownKernel)(e,this.serverSettings),await this.refreshRunning()}async shutdownAll(){await this.refreshRunning(),await Promise.all([...this._models.keys()].map((e=>(0,a.shutdownKernel)(e,this.serverSettings)))),await this.refreshRunning()}async findById(e){return this._models.has(e)||await this.refreshRunning(),this._models.get(e)}async requestRunning(){var e,t;let n;try{n=await(0,a.listRunning)(this.serverSettings)}catch(n){throw(n instanceof i.ServerConnection.NetworkError||503===(null===(e=n.response)||void 0===e?void 0:e.status)||424===(null===(t=n.response)||void 0===t?void 0:t.status))&&this._connectionFailure.emit(n),n}this.isDisposed||this._models.size===n.length&&n.every((e=>{const t=this._models.get(e.id);return!!t&&t.connections===e.connections&&t.execution_state===e.execution_state&&t.last_activity===e.last_activity&&t.name===e.name&&t.reason===e.reason&&t.traceback===e.traceback}))||(this._models=new Map(n.map((e=>[e.id,e]))),this._kernelConnections.forEach((e=>{this._models.has(e.id)||e.handleShutdown()})),this._runningChanged.emit(n))}_onStarted(e){this._kernelConnections.add(e),e.statusChanged.connect(this._onStatusChanged,this),e.disposed.connect(this._onDisposed,this)}_onDisposed(e){this._kernelConnections.delete(e),this.refreshRunning().catch((()=>{}))}_onStatusChanged(e,t){"dead"===t&&this.refreshRunning().catch((()=>{}))}}t.KernelManager=c,function(e){e.NoopManager=class extends e{constructor(){super(...arguments),this._readyPromise=new Promise((()=>{}))}get isActive(){return!1}get parentReady(){return super.ready}async startNew(e={},t={}){return Promise.reject(new Error("Not implemented in no-op Kernel Manager"))}connectTo(e){throw new Error("Not implemented in no-op Kernel Manager")}async shutdown(e){return Promise.reject(new Error("Not implemented in no-op Kernel Manager"))}get ready(){return this.parentReady.then((()=>this._readyPromise))}async requestRunning(){return Promise.resolve()}}}(c||(t.KernelManager=c={}))},9909:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.supportedKernelWebSocketProtocols=t.isInputReplyMsg=t.isInputRequestMsg=t.isDebugReplyMsg=t.isDebugRequestMsg=t.isExecuteReplyMsg=t.isInfoRequestMsg=t.isCommMsgMsg=t.isCommCloseMsg=t.isCommOpenMsg=t.isDebugEventMsg=t.isClearOutputMsg=t.isStatusMsg=t.isErrorMsg=t.isExecuteResultMsg=t.isExecuteInputMsg=t.isUpdateDisplayDataMsg=t.isDisplayDataMsg=t.isStreamMsg=t.createMessage=void 0;const r=n(5764);var A;t.createMessage=function(e){var t,n,A,i,s;return{buffers:null!==(t=e.buffers)&&void 0!==t?t:[],channel:e.channel,content:e.content,header:{date:(new Date).toISOString(),msg_id:null!==(n=e.msgId)&&void 0!==n?n:r.UUID.uuid4(),msg_type:e.msgType,session:e.session,username:null!==(A=e.username)&&void 0!==A?A:"",version:"5.2"},metadata:null!==(i=e.metadata)&&void 0!==i?i:{},parent_header:null!==(s=e.parentHeader)&&void 0!==s?s:{}}},t.isStreamMsg=function(e){return"stream"===e.header.msg_type},t.isDisplayDataMsg=function(e){return"display_data"===e.header.msg_type},t.isUpdateDisplayDataMsg=function(e){return"update_display_data"===e.header.msg_type},t.isExecuteInputMsg=function(e){return"execute_input"===e.header.msg_type},t.isExecuteResultMsg=function(e){return"execute_result"===e.header.msg_type},t.isErrorMsg=function(e){return"error"===e.header.msg_type},t.isStatusMsg=function(e){return"status"===e.header.msg_type},t.isClearOutputMsg=function(e){return"clear_output"===e.header.msg_type},t.isDebugEventMsg=function(e){return"debug_event"===e.header.msg_type},t.isCommOpenMsg=function(e){return"comm_open"===e.header.msg_type},t.isCommCloseMsg=function(e){return"comm_close"===e.header.msg_type},t.isCommMsgMsg=function(e){return"comm_msg"===e.header.msg_type},t.isInfoRequestMsg=function(e){return"kernel_info_request"===e.header.msg_type},t.isExecuteReplyMsg=function(e){return"execute_reply"===e.header.msg_type},t.isDebugRequestMsg=function(e){return"debug_request"===e.header.msg_type},t.isDebugReplyMsg=function(e){return"debug_reply"===e.header.msg_type},t.isInputRequestMsg=function(e){return"input_request"===e.header.msg_type},t.isInputReplyMsg=function(e){return"input_reply"===e.header.msg_type},function(e){e.v1KernelWebsocketJupyterOrg="v1.kernel.websocket.jupyter.org"}(A||(t.supportedKernelWebSocketProtocols=A={}))},8235:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getKernelModel=t.shutdownKernel=t.interruptKernel=t.restartKernel=t.startNew=t.listRunning=t.KERNEL_SERVICE_URL=void 0;const r=n(2920),A=n(8925),i=n(5855);t.KERNEL_SERVICE_URL="api/kernels",t.listRunning=async function(e=r.ServerConnection.makeSettings()){const n=A.URLExt.join(e.baseUrl,t.KERNEL_SERVICE_URL),s=await r.ServerConnection.makeRequest(n,{},e);if(200!==s.status)throw await r.ServerConnection.ResponseError.create(s);const a=await s.json();return(0,i.validateModels)(a),a},t.startNew=async function(e={},n=r.ServerConnection.makeSettings()){const s=A.URLExt.join(n.baseUrl,t.KERNEL_SERVICE_URL),a={method:"POST",body:JSON.stringify(e)},o=await r.ServerConnection.makeRequest(s,a,n);if(201!==o.status)throw await r.ServerConnection.ResponseError.create(o);const c=await o.json();return(0,i.validateModel)(c),c},t.restartKernel=async function(e,n=r.ServerConnection.makeSettings()){const s=A.URLExt.join(n.baseUrl,t.KERNEL_SERVICE_URL,encodeURIComponent(e),"restart"),a=await r.ServerConnection.makeRequest(s,{method:"POST"},n);if(200!==a.status)throw await r.ServerConnection.ResponseError.create(a);const o=await a.json();(0,i.validateModel)(o)},t.interruptKernel=async function(e,n=r.ServerConnection.makeSettings()){const i=A.URLExt.join(n.baseUrl,t.KERNEL_SERVICE_URL,encodeURIComponent(e),"interrupt"),s=await r.ServerConnection.makeRequest(i,{method:"POST"},n);if(204!==s.status)throw await r.ServerConnection.ResponseError.create(s)},t.shutdownKernel=async function(e,n=r.ServerConnection.makeSettings()){const i=A.URLExt.join(n.baseUrl,t.KERNEL_SERVICE_URL,encodeURIComponent(e)),s=await r.ServerConnection.makeRequest(i,{method:"DELETE"},n);if(404===s.status){const t=`The kernel "${e}" does not exist on the server`;console.warn(t)}else if(204!==s.status)throw await r.ServerConnection.ResponseError.create(s)},t.getKernelModel=async function(e,n=r.ServerConnection.makeSettings()){const s=A.URLExt.join(n.baseUrl,t.KERNEL_SERVICE_URL,encodeURIComponent(e)),a=await r.ServerConnection.makeRequest(s,{},n);if(404===a.status)return;if(200!==a.status)throw await r.ServerConnection.ResponseError.create(a);const o=await a.json();return(0,i.validateModel)(o),o}},7179:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return A(t,e),t};Object.defineProperty(t,"__esModule",{value:!0}),t.deserialize=t.serialize=void 0;const s=i(n(9909));var a;t.serialize=function(e,t=""){return t===s.supportedKernelWebSocketProtocols.v1KernelWebsocketJupyterOrg?a.serializeV1KernelWebsocketJupyterOrg(e):a.serializeDefault(e)},t.deserialize=function(e,t=""){return t===s.supportedKernelWebSocketProtocols.v1KernelWebsocketJupyterOrg?a.deserializeV1KernelWebsocketJupyterOrg(e):a.deserializeDefault(e)},function(e){e.deserializeV1KernelWebsocketJupyterOrg=function(e){let t;const n=new DataView(e),r=Number(n.getBigUint64(0,!0));let A=[];for(let e=0;e<r;e++)A.push(Number(n.getBigUint64(8*(e+1),!0)));const i=new TextDecoder("utf8"),s=i.decode(e.slice(A[0],A[1])),a=JSON.parse(i.decode(e.slice(A[1],A[2]))),o=JSON.parse(i.decode(e.slice(A[2],A[3]))),c=JSON.parse(i.decode(e.slice(A[3],A[4]))),l=JSON.parse(i.decode(e.slice(A[4],A[5])));let u=[];for(let t=5;t<A.length-1;t++)u.push(new DataView(e.slice(A[t],A[t+1])));return t={channel:s,header:a,parent_header:o,metadata:c,content:l,buffers:u},t},e.serializeV1KernelWebsocketJupyterOrg=function(e){const t=JSON.stringify(e.header),n=null==e.parent_header?"{}":JSON.stringify(e.parent_header),r=JSON.stringify(e.metadata),A=JSON.stringify(e.content),i=void 0!==e.buffers?e.buffers:[],s=5+i.length+1;let a=[];a.push(8*(1+s)),a.push(e.channel.length+a[a.length-1]);const o=new TextEncoder,c=o.encode(e.channel),l=o.encode(t),u=o.encode(n),h=o.encode(r),d=o.encode(A),f=new Uint8Array(c.length+l.length+u.length+h.length+d.length);f.set(c),f.set(l,c.length),f.set(u,c.length+l.length),f.set(h,c.length+l.length+u.length),f.set(d,c.length+l.length+u.length+h.length);for(let e of[l.length,u.length,h.length,d.length])a.push(e+a[a.length-1]);let p=0;for(let e of i){let t=e.byteLength;a.push(t+a[a.length-1]),p+=t}const g=new Uint8Array(8*(1+s)+f.byteLength+p),m=new ArrayBuffer(8),y=new DataView(m);y.setBigUint64(0,BigInt(s),!0),g.set(new Uint8Array(m),0);for(let e=0;e<a.length;e++)y.setBigUint64(0,BigInt(a[e]),!0),g.set(new Uint8Array(m),8*(e+1));g.set(f,a[0]);for(let e=0;e<i.length;e++){const t=i[e];g.set(new Uint8Array(ArrayBuffer.isView(t)?t.buffer:t),a[5+e])}return g.buffer},e.deserializeDefault=function(e){let t;return t="string"==typeof e?JSON.parse(e):function(e){const t=new DataView(e),n=t.getUint32(0),r=[];if(n<2)throw new Error("Invalid incoming Kernel Message");for(let e=1;e<=n;e++)r.push(t.getUint32(4*e));const A=new Uint8Array(e.slice(r[0],r[1])),i=JSON.parse(new TextDecoder("utf8").decode(A));i.buffers=[];for(let t=1;t<n;t++){const n=r[t],A=r[t+1]||e.byteLength;i.buffers.push(new DataView(e.slice(n,A)))}return i}(e),t},e.serializeDefault=function(e){var t;let n;return n=(null===(t=e.buffers)||void 0===t?void 0:t.length)?function(e){const t=[],n=[],r=new TextEncoder;let A=[];void 0!==e.buffers&&(A=e.buffers,delete e.buffers);const i=r.encode(JSON.stringify(e));n.push(i.buffer);for(let e=0;e<A.length;e++){const t=A[e];n.push(ArrayBuffer.isView(t)?t.buffer:t)}const s=n.length;t.push(4*(s+1));for(let e=0;e+1<n.length;e++)t.push(t[t.length-1]+n[e].byteLength);const a=new Uint8Array(t[t.length-1]+n[n.length-1].byteLength),o=new DataView(a.buffer);o.setUint32(0,s);for(let e=0;e<t.length;e++)o.setUint32(4*(e+1),t[e]);for(let e=0;e<n.length;e++)a.set(new Uint8Array(n[e]),t[e]);return a.buffer}(e):JSON.stringify(e),n}}(a||(a={}))},5855:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.validateModels=t.validateModel=t.validateMessage=void 0;const r=n(7441),A=["username","version","session","msg_id","msg_type"],i={stream:{name:"string",text:"string"},display_data:{data:"object",metadata:"object"},execute_input:{code:"string",execution_count:"number"},execute_result:{execution_count:"number",data:"object",metadata:"object"},error:{ename:"string",evalue:"string",traceback:"object"},status:{execution_state:["string",["starting","idle","busy","restarting","dead"]]},clear_output:{wait:"boolean"},comm_open:{comm_id:"string",target_name:"string",data:"object"},comm_msg:{comm_id:"string",data:"object"},comm_close:{comm_id:"string"},shutdown_reply:{restart:"boolean"}};function s(e){(0,r.validateProperty)(e,"name","string"),(0,r.validateProperty)(e,"id","string")}t.validateMessage=function(e){(0,r.validateProperty)(e,"metadata","object"),(0,r.validateProperty)(e,"content","object"),(0,r.validateProperty)(e,"channel","string"),function(e){for(let t=0;t<A.length;t++)(0,r.validateProperty)(e,A[t],"string")}(e.header),"iopub"===e.channel&&function(e){if("iopub"===e.channel){const t=i[e.header.msg_type];if(void 0===t)return;const n=Object.keys(t),A=e.content;for(let e=0;e<n.length;e++){let i=t[n[e]];Array.isArray(i)||(i=[i]),(0,r.validateProperty)(A,n[e],...i)}}}(e)},t.validateModel=s,t.validateModels=function(e){if(!Array.isArray(e))throw new Error("Invalid kernel list");e.forEach((e=>s(e)))}},2946:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return A(t,e),t},s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(t,"__esModule",{value:!0}),t.KernelSpecAPI=t.KernelSpec=void 0;const a=i(n(4806));t.KernelSpec=a;const o=i(n(6492));t.KernelSpecAPI=o,s(n(733),t)},4806:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},733:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return A(t,e),t};Object.defineProperty(t,"__esModule",{value:!0}),t.KernelSpecManager=void 0;const s=n(5764),a=n(6049),o=n(3992),c=i(n(6492)),l=n(3867);class u extends l.BaseManager{constructor(e={}){var t;super(e),this._isReady=!1,this._connectionFailure=new o.Signal(this),this._specs=null,this._specsChanged=new o.Signal(this),this._ready=Promise.all([this.requestSpecs()]).then((e=>{})).catch((e=>{})).then((()=>{this.isDisposed||(this._isReady=!0)})),this._pollSpecs=new a.Poll({auto:!1,factory:()=>this.requestSpecs(),frequency:{interval:61e3,backoff:!0,max:3e5},name:"@jupyterlab/services:KernelSpecManager#specs",standby:null!==(t=e.standby)&&void 0!==t?t:"when-hidden"}),this.ready.then((()=>{this._pollSpecs.start()}))}get isReady(){return this._isReady}get ready(){return this._ready}get specs(){return this._specs}get specsChanged(){return this._specsChanged}get connectionFailure(){return this._connectionFailure}dispose(){this._pollSpecs.dispose(),super.dispose()}async refreshSpecs(){await this._pollSpecs.refresh(),await this._pollSpecs.tick}async requestSpecs(){const e=await c.getSpecs(this.serverSettings);this.isDisposed||s.JSONExt.deepEqual(e,this._specs)||(this._specs=e,this._specsChanged.emit(e))}}t.KernelSpecManager=u},6492:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getSpecs=void 0;const r=n(2920),A=n(2598),i=n(8925);t.getSpecs=async function(e=r.ServerConnection.makeSettings()){const t=i.URLExt.join(e.baseUrl,"api/kernelspecs"),n=await r.ServerConnection.makeRequest(t,{},e);if(200!==n.status)throw await r.ServerConnection.ResponseError.create(n);const s=await n.json();return(0,A.validateSpecModels)(s)}},2598:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.validateSpecModels=t.validateSpecModel=void 0;const r=n(7441);function A(e){const t=e.spec;if(!t)throw new Error("Invalid kernel spec");(0,r.validateProperty)(e,"name","string"),(0,r.validateProperty)(e,"resources","object"),(0,r.validateProperty)(t,"language","string"),(0,r.validateProperty)(t,"display_name","string"),(0,r.validateProperty)(t,"argv","array");let n=null;t.hasOwnProperty("metadata")&&((0,r.validateProperty)(t,"metadata","object"),n=t.metadata);let A=null;return t.hasOwnProperty("env")&&((0,r.validateProperty)(t,"env","object"),A=t.env),{name:e.name,resources:e.resources,language:t.language,display_name:t.display_name,argv:t.argv,metadata:n,env:A}}t.validateSpecModel=A,t.validateSpecModels=function(e){if(!e.hasOwnProperty("kernelspecs"))throw new Error("No kernelspecs found");let t=Object.keys(e.kernelspecs);const n=Object.create(null);let r=e.default;for(let r=0;r<t.length;r++){const i=e.kernelspecs[t[r]];try{n[t[r]]=A(i)}catch(e){console.warn(`Removing errant kernel spec: ${t[r]}`)}}if(t=Object.keys(n),!t.length)throw new Error("No valid kernelspecs found");return r&&"string"==typeof r&&r in n||(r=t[0],console.warn(`Default kernel not found, using '${t[0]}'`)),{default:r,kernelspecs:n}}},9740:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ServiceManager=void 0;const r=n(3992),A=n(4219),i=n(8790),s=n(9480),a=n(973),o=n(2946),c=n(8683),l=n(2920),u=n(7668),h=n(7780),d=n(9040),f=n(9191),p=n(8053);t.ServiceManager=class{constructor(e={}){var t,n;this._isDisposed=!1,this._connectionFailure=new r.Signal(this),this._isReady=!1;const g=e.defaultDrive,m=null!==(t=e.serverSettings)&&void 0!==t?t:l.ServerConnection.makeSettings(),y={defaultDrive:g,serverSettings:m,standby:null!==(n=e.standby)&&void 0!==n?n:"when-hidden"};this.serverSettings=m,this.contents=e.contents||new i.ContentsManager(y),this.events=e.events||new s.EventManager(y),this.kernels=e.kernels||new a.KernelManager(y),this.sessions=e.sessions||new u.SessionManager({...y,kernelManager:this.kernels}),this.settings=e.settings||new h.SettingManager(y),this.terminals=e.terminals||new d.TerminalManager(y),this.builder=e.builder||new A.BuildManager(y),this.workspaces=e.workspaces||new p.WorkspaceManager(y),this.nbconvert=e.nbconvert||new c.NbConvertManager(y),this.kernelspecs=e.kernelspecs||new o.KernelSpecManager(y),this.user=e.user||new f.UserManager(y),this.kernelspecs.connectionFailure.connect(this._onConnectionFailure,this),this.sessions.connectionFailure.connect(this._onConnectionFailure,this),this.terminals.connectionFailure.connect(this._onConnectionFailure,this);const w=[this.sessions.ready,this.kernelspecs.ready];this.terminals.isAvailable()&&w.push(this.terminals.ready),this._readyPromise=Promise.all(w).then((()=>{this._isReady=!0}))}get connectionFailure(){return this._connectionFailure}get isDisposed(){return this._isDisposed}dispose(){this.isDisposed||(this._isDisposed=!0,r.Signal.clearData(this),this.contents.dispose(),this.events.dispose(),this.sessions.dispose(),this.terminals.dispose())}get isReady(){return this._isReady}get ready(){return this._readyPromise}_onConnectionFailure(e,t){this._connectionFailure.emit(t)}}},8683:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.NbConvertManager=void 0;const r=n(8925),A=n(2920),i=n(5764);t.NbConvertManager=class{constructor(e={}){var t;this._exportFormats=null,this.serverSettings=null!==(t=e.serverSettings)&&void 0!==t?t:A.ServerConnection.makeSettings()}async fetchExportFormats(){this._requestingFormats=new i.PromiseDelegate,this._exportFormats=null;const e=this.serverSettings.baseUrl,t=r.URLExt.join(e,"api/nbconvert"),{serverSettings:n}=this,s=await A.ServerConnection.makeRequest(t,{},n);if(200!==s.status)throw await A.ServerConnection.ResponseError.create(s);const a=await s.json(),o={};return Object.keys(a).forEach((function(e){const t=a[e].output_mimetype;o[e]={output_mimetype:t}})),this._exportFormats=o,this._requestingFormats.resolve(o),o}async getExportFormats(e=!0){return this._requestingFormats?this._requestingFormats.promise:e||!this._exportFormats?await this.fetchExportFormats():this._exportFormats}}},2920:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ServerConnection=void 0;const r=n(8925),A=n(7179);let i;var s,a;i="undefined"==typeof window?n(7251):WebSocket,function(e){e.makeSettings=function(e){return a.makeSettings(e)},e.makeRequest=function(e,t,n){return a.handleRequest(e,t,n)};class t extends Error{static async create(e){try{const n=await e.json(),{message:r,traceback:A}=n;return A&&console.error(A),new t(e,null!=r?r:t._defaultMessage(e),null!=A?A:"")}catch(n){return console.debug(n),new t(e)}}constructor(e,n=t._defaultMessage(e),r=""){super(n),this.response=e,this.traceback=r}static _defaultMessage(e){return`Invalid response: ${e.status} ${e.statusText}`}}e.ResponseError=t;class n extends TypeError{constructor(e){super(e.message),this.stack=e.stack}}e.NetworkError=n}(s||(t.ServerConnection=s={})),function(e){e.makeSettings=function(e={}){var t;const n=r.PageConfig.getBaseUrl(),s=r.PageConfig.getWsUrl(),a=r.URLExt.normalize(e.baseUrl)||n;let o=e.wsUrl;o||a!==n||(o=s),o||0!==a.indexOf("http")||(o="ws"+a.slice(4)),o=null!=o?o:s;const c=r.PageConfig.getOption("appendToken").toLowerCase();let l;return l=""===c?"undefined"==typeof window||"undefined"!=typeof process&&void 0!==(null===(t=null===process||void 0===process?void 0:process.env)||void 0===t?void 0:t.JEST_WORKER_ID)||r.URLExt.getHostName(n)!==r.URLExt.getHostName(o):"true"===c,{init:{cache:"no-store",credentials:"same-origin"},fetch,Headers,Request,WebSocket:i,token:r.PageConfig.getToken(),appUrl:r.PageConfig.getOption("appUrl"),appendToken:l,serializer:{serialize:A.serialize,deserialize:A.deserialize},...e,baseUrl:a,wsUrl:o}},e.handleRequest=function(e,t,n){var r;if(0!==e.indexOf(n.baseUrl))throw new Error("Can only be used for notebook server requests");"no-store"===(null!==(r=t.cache)&&void 0!==r?r:n.init.cache)&&(e+=(/\?/.test(e)?"&":"?")+(new Date).getTime());const A=new n.Request(e,{...n.init,...t});let i=!1;if(n.token&&(i=!0,A.headers.append("Authorization",`token ${n.token}`)),"undefined"!=typeof document){const e=function(){let e="";try{e=document.cookie}catch(e){return}const t=e.match("\\b_xsrf=([^;]*)\\b");return null==t?void 0:t[1]}();void 0!==e&&(i=!0,A.headers.append("X-XSRFToken",e))}return!A.headers.has("Content-Type")&&i&&A.headers.set("Content-Type","application/json"),n.fetch.call(null,A).catch((e=>{throw new s.NetworkError(e)}))}}(a||(a={}))},5341:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SessionConnection=void 0;const r=n(3992),A=n(7883),i=n(7570),s=n(5764);t.SessionConnection=class{constructor(e){var t,n,i,a;this._id="",this._path="",this._name="",this._type="",this._kernel=null,this._isDisposed=!1,this._disposed=new r.Signal(this),this._kernelChanged=new r.Signal(this),this._statusChanged=new r.Signal(this),this._connectionStatusChanged=new r.Signal(this),this._pendingInput=new r.Signal(this),this._iopubMessage=new r.Signal(this),this._unhandledMessage=new r.Signal(this),this._anyMessage=new r.Signal(this),this._propertyChanged=new r.Signal(this),this._id=e.model.id,this._name=e.model.name,this._path=e.model.path,this._type=e.model.type,this._username=null!==(t=e.username)&&void 0!==t?t:"",this._clientId=null!==(n=e.clientId)&&void 0!==n?n:s.UUID.uuid4(),this._connectToKernel=e.connectToKernel,this._kernelConnectionOptions=null!==(i=e.kernelConnectionOptions)&&void 0!==i?i:{},this.serverSettings=null!==(a=e.serverSettings)&&void 0!==a?a:A.ServerConnection.makeSettings(),this.setupKernel(e.model.kernel)}get disposed(){return this._disposed}get kernelChanged(){return this._kernelChanged}get statusChanged(){return this._statusChanged}get connectionStatusChanged(){return this._connectionStatusChanged}get pendingInput(){return this._pendingInput}get iopubMessage(){return this._iopubMessage}get unhandledMessage(){return this._unhandledMessage}get anyMessage(){return this._anyMessage}get propertyChanged(){return this._propertyChanged}get id(){return this._id}get kernel(){return this._kernel}get path(){return this._path}get type(){return this._type}get name(){return this._name}get model(){return{id:this.id,kernel:this.kernel&&{id:this.kernel.id,name:this.kernel.name},path:this._path,type:this._type,name:this._name}}get isDisposed(){return this._isDisposed}update(e){const t=this.model;if(this._path=e.path,this._name=e.name,this._type=e.type,null===this._kernel&&null!==e.kernel||null!==this._kernel&&null===e.kernel||null!==this._kernel&&null!==e.kernel&&this._kernel.id!==e.kernel.id){null!==this._kernel&&this._kernel.dispose();const t=this._kernel||null;this.setupKernel(e.kernel);const n=this._kernel||null;this._kernelChanged.emit({name:"kernel",oldValue:t,newValue:n})}this._handleModelChange(t)}dispose(){if(!this.isDisposed){if(this._isDisposed=!0,this._disposed.emit(),this._kernel){this._kernel.dispose();const e=this._kernel;this._kernel=null;const t=this._kernel;this._kernelChanged.emit({name:"kernel",oldValue:e,newValue:t})}r.Signal.clearData(this)}}async setPath(e){if(this.isDisposed)throw new Error("Session is disposed");await this._patch({path:e})}async setName(e){if(this.isDisposed)throw new Error("Session is disposed");await this._patch({name:e})}async setType(e){if(this.isDisposed)throw new Error("Session is disposed");await this._patch({type:e})}async changeKernel(e){if(this.isDisposed)throw new Error("Session is disposed");return await this._patch({kernel:e}),this.kernel}async shutdown(){if(this.isDisposed)throw new Error("Session is disposed");await(0,i.shutdownSession)(this.id,this.serverSettings),this.dispose()}setupKernel(e){if(null===e)return void(this._kernel=null);const t=this._connectToKernel({...this._kernelConnectionOptions,model:e,username:this._username,clientId:this._clientId,serverSettings:this.serverSettings});this._kernel=t,t.statusChanged.connect(this.onKernelStatus,this),t.connectionStatusChanged.connect(this.onKernelConnectionStatus,this),t.pendingInput.connect(this.onPendingInput,this),t.unhandledMessage.connect(this.onUnhandledMessage,this),t.iopubMessage.connect(this.onIOPubMessage,this),t.anyMessage.connect(this.onAnyMessage,this)}onKernelStatus(e,t){this._statusChanged.emit(t)}onKernelConnectionStatus(e,t){this._connectionStatusChanged.emit(t)}onPendingInput(e,t){this._pendingInput.emit(t)}onIOPubMessage(e,t){this._iopubMessage.emit(t)}onUnhandledMessage(e,t){this._unhandledMessage.emit(t)}onAnyMessage(e,t){this._anyMessage.emit(t)}async _patch(e){const t=await(0,i.updateSession)({...e,id:this._id},this.serverSettings);return this.update(t),t}_handleModelChange(e){e.name!==this._name&&this._propertyChanged.emit("name"),e.type!==this._type&&this._propertyChanged.emit("type"),e.path!==this._path&&this._propertyChanged.emit("path")}}},7668:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return A(t,e),t},s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(t,"__esModule",{value:!0}),t.SessionAPI=t.Session=void 0;const a=i(n(7240));t.Session=a;const o=i(n(7570));t.SessionAPI=o,s(n(6919),t)},6919:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SessionManager=void 0;const r=n(6049),A=n(3992),i=n(2920),s=n(3867),a=n(5341),o=n(7570);class c extends s.BaseManager{constructor(e){var t;super(e),this._isReady=!1,this._sessionConnections=new Set,this._models=new Map,this._runningChanged=new A.Signal(this),this._connectionFailure=new A.Signal(this),this._connectToKernel=e=>this._kernelManager.connectTo(e),this._kernelManager=e.kernelManager,this._pollModels=new r.Poll({auto:!1,factory:()=>this.requestRunning(),frequency:{interval:1e4,backoff:!0,max:3e5},name:"@jupyterlab/services:SessionManager#models",standby:null!==(t=e.standby)&&void 0!==t?t:"when-hidden"}),this._ready=(async()=>{await this._pollModels.start(),await this._pollModels.tick,this._kernelManager.isActive&&await this._kernelManager.ready,this._isReady=!0})()}get isReady(){return this._isReady}get ready(){return this._ready}get runningChanged(){return this._runningChanged}get connectionFailure(){return this._connectionFailure}dispose(){this.isDisposed||(this._models.clear(),this._sessionConnections.forEach((e=>e.dispose())),this._pollModels.dispose(),super.dispose())}connectTo(e){const t=new a.SessionConnection({...e,connectToKernel:this._connectToKernel,serverSettings:this.serverSettings});return this._onStarted(t),this._models.has(e.model.id)||this.refreshRunning().catch((()=>{})),t}running(){return this._models.values()}async refreshRunning(){await this._pollModels.refresh(),await this._pollModels.tick}async startNew(e,t={}){const n=await(0,o.startSession)(e,this.serverSettings);return await this.refreshRunning(),this.connectTo({...t,model:n})}async shutdown(e){await(0,o.shutdownSession)(e,this.serverSettings),await this.refreshRunning()}async shutdownAll(){await this.refreshRunning(),await Promise.all([...this._models.keys()].map((e=>(0,o.shutdownSession)(e,this.serverSettings)))),await this.refreshRunning()}async stopIfNeeded(e){try{const t=(await(0,o.listRunning)(this.serverSettings)).filter((t=>t.path===e));if(1===t.length){const e=t[0].id;await this.shutdown(e)}}catch(e){}}async findById(e){return this._models.has(e)||await this.refreshRunning(),this._models.get(e)}async findByPath(e){for(const t of this._models.values())if(t.path===e)return t;await this.refreshRunning();for(const t of this._models.values())if(t.path===e)return t}async requestRunning(){var e,t;let n;try{n=await(0,o.listRunning)(this.serverSettings)}catch(n){throw(n instanceof i.ServerConnection.NetworkError||503===(null===(e=n.response)||void 0===e?void 0:e.status)||424===(null===(t=n.response)||void 0===t?void 0:t.status))&&this._connectionFailure.emit(n),n}this.isDisposed||this._models.size===n.length&&n.every((e=>{var t,n,r,A;const i=this._models.get(e.id);return!!i&&(null===(t=i.kernel)||void 0===t?void 0:t.id)===(null===(n=e.kernel)||void 0===n?void 0:n.id)&&(null===(r=i.kernel)||void 0===r?void 0:r.name)===(null===(A=e.kernel)||void 0===A?void 0:A.name)&&i.name===e.name&&i.path===e.path&&i.type===e.type}))||(this._models=new Map(n.map((e=>[e.id,e]))),this._sessionConnections.forEach((e=>{this._models.has(e.id)?e.update(this._models.get(e.id)):e.dispose()})),this._runningChanged.emit(n))}_onStarted(e){this._sessionConnections.add(e),e.disposed.connect(this._onDisposed,this),e.propertyChanged.connect(this._onChanged,this),e.kernelChanged.connect(this._onChanged,this)}_onDisposed(e){this._sessionConnections.delete(e),this.refreshRunning().catch((()=>{}))}_onChanged(){this.refreshRunning().catch((()=>{}))}}t.SessionManager=c,function(e){e.NoopManager=class extends e{constructor(){super(...arguments),this._readyPromise=new Promise((()=>{}))}get isActive(){return!1}get parentReady(){return super.ready}async startNew(e,t={}){return Promise.reject(new Error("Not implemented in no-op Session Manager"))}connectTo(e){throw Error("Not implemented in no-op Session Manager")}get ready(){return this.parentReady.then((()=>this._readyPromise))}async shutdown(e){return Promise.reject(new Error("Not implemented in no-op Session Manager"))}async requestRunning(){return Promise.resolve()}}}(c||(t.SessionManager=c={}))},7570:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.updateSession=t.startSession=t.getSessionModel=t.shutdownSession=t.getSessionUrl=t.listRunning=t.SESSION_SERVICE_URL=void 0;const r=n(2920),A=n(8925),i=n(5684);function s(e,n){const r=A.URLExt.join(e,t.SESSION_SERVICE_URL),i=A.URLExt.join(r,n);if(!i.startsWith(r))throw new Error("Can only be used for services requests");return i}t.SESSION_SERVICE_URL="api/sessions",t.listRunning=async function(e=r.ServerConnection.makeSettings()){const n=A.URLExt.join(e.baseUrl,t.SESSION_SERVICE_URL),s=await r.ServerConnection.makeRequest(n,{},e);if(200!==s.status)throw await r.ServerConnection.ResponseError.create(s);const a=await s.json();if(!Array.isArray(a))throw new Error("Invalid Session list");return a.forEach((e=>{(0,i.updateLegacySessionModel)(e),(0,i.validateModel)(e)})),a},t.getSessionUrl=s,t.shutdownSession=async function(e,t=r.ServerConnection.makeSettings()){var n;const A=s(t.baseUrl,e),i=await r.ServerConnection.makeRequest(A,{method:"DELETE"},t);if(404===i.status){const t=null!==(n=(await i.json()).message)&&void 0!==n?n:`The session "${e}"" does not exist on the server`;console.warn(t)}else{if(410===i.status)throw new r.ServerConnection.ResponseError(i,"The kernel was deleted but the session was not");if(204!==i.status)throw await r.ServerConnection.ResponseError.create(i)}},t.getSessionModel=async function(e,t=r.ServerConnection.makeSettings()){const n=s(t.baseUrl,e),A=await r.ServerConnection.makeRequest(n,{},t);if(200!==A.status)throw await r.ServerConnection.ResponseError.create(A);const a=await A.json();return(0,i.updateLegacySessionModel)(a),(0,i.validateModel)(a),a},t.startSession=async function(e,n=r.ServerConnection.makeSettings()){const s=A.URLExt.join(n.baseUrl,t.SESSION_SERVICE_URL),a={method:"POST",body:JSON.stringify(e)},o=await r.ServerConnection.makeRequest(s,a,n);if(201!==o.status)throw await r.ServerConnection.ResponseError.create(o);const c=await o.json();return(0,i.updateLegacySessionModel)(c),(0,i.validateModel)(c),c},t.updateSession=async function(e,t=r.ServerConnection.makeSettings()){const n=s(t.baseUrl,e.id),A={method:"PATCH",body:JSON.stringify(e)},a=await r.ServerConnection.makeRequest(n,A,t);if(200!==a.status)throw await r.ServerConnection.ResponseError.create(a);const o=await a.json();return(0,i.updateLegacySessionModel)(o),(0,i.validateModel)(o),o}},7240:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},5684:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.validateModels=t.updateLegacySessionModel=t.validateModel=void 0;const r=n(5855),A=n(7441);function i(e){(0,A.validateProperty)(e,"id","string"),(0,A.validateProperty)(e,"type","string"),(0,A.validateProperty)(e,"name","string"),(0,A.validateProperty)(e,"path","string"),(0,A.validateProperty)(e,"kernel","object"),(0,r.validateModel)(e.kernel)}t.validateModel=i,t.updateLegacySessionModel=function(e){void 0===e.path&&void 0!==e.notebook&&(e.path=e.notebook.path,e.type="notebook",e.name="")},t.validateModels=function(e){if(!Array.isArray(e))throw new Error("Invalid session list");e.forEach((e=>i(e)))}},7780:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SettingManager=void 0;const r=n(8925),A=n(1670),i=n(2920);class s extends A.DataConnector{constructor(e={}){var t;super(),this.serverSettings=null!==(t=e.serverSettings)&&void 0!==t?t:i.ServerConnection.makeSettings()}async fetch(e){if(!e)throw new Error("Plugin `id` parameter is required for settings fetch.");const{serverSettings:t}=this,{baseUrl:n,appUrl:r}=t,{makeRequest:A,ResponseError:s}=i.ServerConnection,o=n+r,c=a.url(o,e),l=await A(c,{},t);if(200!==l.status)throw await s.create(l);return l.json()}async list(e){var t,n,r,A;const{serverSettings:s}=this,{baseUrl:o,appUrl:c}=s,{makeRequest:l,ResponseError:u}=i.ServerConnection,h=o+c,d=a.url(h,"","ids"===e),f=await l(d,{},s);if(200!==f.status)throw new u(f);const p=await f.json(),g=null!==(n=null===(t=null==p?void 0:p.settings)||void 0===t?void 0:t.map((e=>e.id)))&&void 0!==n?n:[];let m=[];return e||(m=null!==(A=null===(r=null==p?void 0:p.settings)||void 0===r?void 0:r.map((e=>(e.data={composite:{},user:{}},e))))&&void 0!==A?A:[]),{ids:g,values:m}}async save(e,t){const{serverSettings:n}=this,{baseUrl:r,appUrl:A}=n,{makeRequest:s,ResponseError:o}=i.ServerConnection,c=r+A,l=a.url(c,e),u={body:JSON.stringify({raw:t}),method:"PUT"},h=await s(l,u,n);if(204!==h.status)throw new o(h)}}var a;t.SettingManager=s,function(e){e.url=function(e,t,n){const A=n?r.URLExt.objectToQueryString({ids_only:!0}):"",i=r.URLExt.join(e,"api/settings"),s=r.URLExt.join(i,t);if(!s.startsWith(i))throw new Error("Can only be used for workspaces requests");return`${s}${A}`}}(a||(a={}))},7251:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=WebSocket},9822:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.TerminalConnection=void 0;const r=n(8925),A=n(5764),i=n(3992),s=n(7883),a=n(6134);class o{constructor(e){var t;this._createSocket=()=>{this._errorIfDisposed(),this._clearSocket(),this._updateConnectionStatus("connecting");const e=this._name,t=this.serverSettings;let n=r.URLExt.join(t.wsUrl,"terminals","websocket",encodeURIComponent(e));const A=t.token;t.appendToken&&""!==A&&(n+=`?token=${encodeURIComponent(A)}`),this._ws=new t.WebSocket(n),this._ws.onmessage=this._onWSMessage,this._ws.onclose=this._onWSClose,this._ws.onerror=this._onWSClose},this._onWSMessage=e=>{if(this._isDisposed)return;const t=JSON.parse(e.data);"disconnect"===t[0]&&this.dispose(),"connecting"!==this._connectionStatus?this._messageReceived.emit({type:t[0],content:t.slice(1)}):"setup"===t[0]&&this._updateConnectionStatus("connected")},this._onWSClose=e=>{console.warn(`Terminal websocket closed: ${e.code}`),this.isDisposed||this._reconnect()},this._connectionStatus="connecting",this._connectionStatusChanged=new i.Signal(this),this._isDisposed=!1,this._disposed=new i.Signal(this),this._messageReceived=new i.Signal(this),this._reconnectTimeout=null,this._ws=null,this._noOp=()=>{},this._reconnectLimit=7,this._reconnectAttempt=0,this._pendingMessages=[],this._name=e.model.name,this.serverSettings=null!==(t=e.serverSettings)&&void 0!==t?t:s.ServerConnection.makeSettings(),this._createSocket()}get disposed(){return this._disposed}get messageReceived(){return this._messageReceived}get name(){return this._name}get model(){return{name:this._name}}get isDisposed(){return this._isDisposed}dispose(){this._isDisposed||(this._isDisposed=!0,this._disposed.emit(),this._updateConnectionStatus("disconnected"),this._clearSocket(),i.Signal.clearData(this))}send(e){this._sendMessage(e)}_sendMessage(e,t=!0){if(!this._isDisposed&&e.content)if("connected"===this.connectionStatus&&this._ws){const t=[e.type,...e.content];this._ws.send(JSON.stringify(t))}else{if(!t)throw new Error(`Could not send message: ${JSON.stringify(e)}`);this._pendingMessages.push(e)}}_sendPending(){for(;"connected"===this.connectionStatus&&this._pendingMessages.length>0;)this._sendMessage(this._pendingMessages[0],!1),this._pendingMessages.shift()}reconnect(){this._errorIfDisposed();const e=new A.PromiseDelegate,t=(n,r)=>{"connected"===r?(e.resolve(),this.connectionStatusChanged.disconnect(t,this)):"disconnected"===r&&(e.reject(new Error("Terminal connection disconnected")),this.connectionStatusChanged.disconnect(t,this))};return this.connectionStatusChanged.connect(t,this),this._reconnectAttempt=0,this._reconnect(),e.promise}_reconnect(){if(this._errorIfDisposed(),clearTimeout(this._reconnectTimeout),this._reconnectAttempt<this._reconnectLimit){this._updateConnectionStatus("connecting");const e=c.getRandomIntInclusive(0,1e3*(Math.pow(2,this._reconnectAttempt)-1));console.error(`Connection lost, reconnecting in ${Math.floor(e/1e3)} seconds.`),this._reconnectTimeout=setTimeout(this._createSocket,e),this._reconnectAttempt+=1}else this._updateConnectionStatus("disconnected");this._clearSocket()}_clearSocket(){null!==this._ws&&(this._ws.onopen=this._noOp,this._ws.onclose=this._noOp,this._ws.onerror=this._noOp,this._ws.onmessage=this._noOp,this._ws.close(),this._ws=null)}async shutdown(){await(0,a.shutdownTerminal)(this.name,this.serverSettings),this.dispose()}clone(){return new o(this)}_updateConnectionStatus(e){this._connectionStatus!==e&&(this._connectionStatus=e,"connecting"!==e&&(this._reconnectAttempt=0,clearTimeout(this._reconnectTimeout)),"connected"===e&&this._sendPending(),this._connectionStatusChanged.emit(e))}_errorIfDisposed(){if(this.isDisposed)throw new Error("Terminal connection is disposed")}get connectionStatusChanged(){return this._connectionStatusChanged}get connectionStatus(){return this._connectionStatus}}var c;t.TerminalConnection=o,function(e){e.getTermUrl=function(e,t){return r.URLExt.join(e,a.TERMINAL_SERVICE_URL,encodeURIComponent(t))},e.getRandomIntInclusive=function(e,t){return e=Math.ceil(e),t=Math.floor(t),Math.floor(Math.random()*(t-e+1))+e}}(c||(c={}))},9040:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return A(t,e),t},s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(t,"__esModule",{value:!0}),t.TerminalAPI=t.Terminal=void 0;const a=i(n(6994));t.Terminal=a;const o=i(n(6134));t.TerminalAPI=o,s(n(9883),t)},9883:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.TerminalManager=void 0;const r=n(6049),A=n(3992),i=n(7883),s=n(3867),a=n(6134),o=n(9822);class c extends s.BaseManager{constructor(e={}){var t;if(super(e),this._isReady=!1,this._names=[],this._terminalConnections=new Set,this._runningChanged=new A.Signal(this),this._connectionFailure=new A.Signal(this),!this.isAvailable())return this._ready=Promise.reject("Terminals unavailable"),void this._ready.catch((e=>{}));this._pollModels=new r.Poll({auto:!1,factory:()=>this.requestRunning(),frequency:{interval:1e4,backoff:!0,max:3e5},name:"@jupyterlab/services:TerminalManager#models",standby:null!==(t=e.standby)&&void 0!==t?t:"when-hidden"}),this._ready=(async()=>{await this._pollModels.start(),await this._pollModels.tick,this._isReady=!0})()}get isReady(){return this._isReady}get ready(){return this._ready}get runningChanged(){return this._runningChanged}get connectionFailure(){return this._connectionFailure}dispose(){this.isDisposed||(this._names.length=0,this._terminalConnections.forEach((e=>e.dispose())),this._pollModels.dispose(),super.dispose())}isAvailable(){return(0,a.isAvailable)()}connectTo(e){const t=new o.TerminalConnection({...e,serverSettings:this.serverSettings});return this._onStarted(t),this._names.includes(e.model.name)||this.refreshRunning().catch((()=>{})),t}running(){return this._models[Symbol.iterator]()}async refreshRunning(){await this._pollModels.refresh(),await this._pollModels.tick}async startNew(e){const t=await(0,a.startNew)(this.serverSettings,null==e?void 0:e.name,null==e?void 0:e.cwd);return await this.refreshRunning(),this.connectTo({model:t})}async shutdown(e){await(0,a.shutdownTerminal)(e,this.serverSettings),await this.refreshRunning()}async shutdownAll(){await this.refreshRunning(),await Promise.all(this._names.map((e=>(0,a.shutdownTerminal)(e,this.serverSettings)))),await this.refreshRunning()}async requestRunning(){var e,t;let n;try{n=await(0,a.listRunning)(this.serverSettings)}catch(n){throw(n instanceof i.ServerConnection.NetworkError||503===(null===(e=n.response)||void 0===e?void 0:e.status)||424===(null===(t=n.response)||void 0===t?void 0:t.status))&&this._connectionFailure.emit(n),n}if(this.isDisposed)return;const r=n.map((({name:e})=>e)).sort();r!==this._names&&(this._names=r,this._terminalConnections.forEach((e=>{r.includes(e.name)||e.dispose()})),this._runningChanged.emit(this._models))}_onStarted(e){this._terminalConnections.add(e),e.disposed.connect(this._onDisposed,this)}_onDisposed(e){this._terminalConnections.delete(e),this.refreshRunning().catch((()=>{}))}get _models(){return this._names.map((e=>({name:e})))}}t.TerminalManager=c,function(e){e.NoopManager=class extends e{constructor(){super(...arguments),this._readyPromise=new Promise((()=>{}))}get isActive(){return!1}get parentReady(){return super.ready}get ready(){return this.parentReady.then((()=>this._readyPromise))}async startNew(e){return Promise.reject(new Error("Not implemented in no-op Terminal Manager"))}connectTo(e){throw Error("Not implemented in no-op Terminal Manager")}async shutdown(e){return Promise.reject(new Error("Not implemented in no-op Terminal Manager"))}async requestRunning(){return Promise.resolve()}}}(c||(t.TerminalManager=c={}))},6134:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.shutdownTerminal=t.listRunning=t.startNew=t.isAvailable=t.TERMINAL_SERVICE_URL=void 0;const r=n(8925),A=n(2920);function i(){return"true"===String(r.PageConfig.getOption("terminalsAvailable")).toLowerCase()}var s;t.TERMINAL_SERVICE_URL="api/terminals",t.isAvailable=i,t.startNew=async function(e=A.ServerConnection.makeSettings(),n,i){s.errorIfNotAvailable();const a=r.URLExt.join(e.baseUrl,t.TERMINAL_SERVICE_URL),o={method:"POST",body:JSON.stringify({name:n,cwd:i})},c=await A.ServerConnection.makeRequest(a,o,e);if(200!==c.status)throw await A.ServerConnection.ResponseError.create(c);return await c.json()},t.listRunning=async function(e=A.ServerConnection.makeSettings()){s.errorIfNotAvailable();const n=r.URLExt.join(e.baseUrl,t.TERMINAL_SERVICE_URL),i=await A.ServerConnection.makeRequest(n,{},e);if(200!==i.status)throw await A.ServerConnection.ResponseError.create(i);const a=await i.json();if(!Array.isArray(a))throw new Error("Invalid terminal list");return a},t.shutdownTerminal=async function(e,n=A.ServerConnection.makeSettings()){var i;s.errorIfNotAvailable();const a=r.URLExt.join(n.baseUrl,t.TERMINAL_SERVICE_URL),o=r.URLExt.join(a,e);if(!o.startsWith(a))throw new Error("Can only be used for terminal requests");const c=await A.ServerConnection.makeRequest(o,{method:"DELETE"},n);if(404===c.status){const t=null!==(i=(await c.json()).message)&&void 0!==i?i:`The terminal session "${e}"" does not exist on the server`;console.warn(t)}else if(204!==c.status)throw await A.ServerConnection.ResponseError.create(c)},function(e){e.errorIfNotAvailable=function(){if(!i())throw new Error("Terminals Unavailable")}}(s||(s={}))},6994:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.isAvailable=void 0;const r=n(6134);Object.defineProperty(t,"isAvailable",{enumerable:!0,get:function(){return r.isAvailable}})},9191:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.UserManager=void 0;const r=n(8925),A=n(5764),i=n(6049),s=n(3992),a=n(2920),o=n(3867),c="@jupyterlab/services:UserManager#user";class l extends o.BaseManager{constructor(e={}){var t;super(e),this._isReady=!1,this._userChanged=new s.Signal(this),this._connectionFailure=new s.Signal(this),this._ready=this.requestUser().then((()=>{this.isDisposed||(this._isReady=!0)})).catch((e=>new Promise((()=>{})))),this._pollSpecs=new i.Poll({auto:!1,factory:()=>this.requestUser(),frequency:{interval:61e3,backoff:!0,max:3e5},name:c,standby:null!==(t=e.standby)&&void 0!==t?t:"when-hidden"}),this.ready.then((()=>{this._pollSpecs.start()}))}get isReady(){return this._isReady}get ready(){return this._ready}get identity(){return this._identity}get permissions(){return this._permissions}get userChanged(){return this._userChanged}get connectionFailure(){return this._connectionFailure}dispose(){this._pollSpecs.dispose(),super.dispose()}async refreshUser(){await this._pollSpecs.refresh(),await this._pollSpecs.tick}async requestUser(){if(this.isDisposed)return;const{baseUrl:e}=this.serverSettings,{makeRequest:t,ResponseError:n}=a.ServerConnection,i=r.URLExt.join(e,"api/me"),s=await t(i,{},this.serverSettings);if(200!==s.status)throw await n.create(s);const o={identity:this._identity,permissions:this._permissions},l=await s.json(),h=l.identity,{localStorage:d}=window,f=d.getItem(c);if(f&&(!h.initials||!h.color)){const e=JSON.parse(f);h.initials=h.initials||e.initials||h.name.substring(0,1),h.color=h.color||e.color||u.getRandomColor()}A.JSONExt.deepEqual(l,o)||(this._identity=h,this._permissions=l.permissions,d.setItem(c,JSON.stringify(h)),this._userChanged.emit(l))}}var u;t.UserManager=l,function(e){const t=["var(--jp-collaborator-color1)","var(--jp-collaborator-color2)","var(--jp-collaborator-color3)","var(--jp-collaborator-color4)","var(--jp-collaborator-color5)","var(--jp-collaborator-color6)","var(--jp-collaborator-color7)"];e.getRandomColor=()=>t[Math.floor(Math.random()*t.length)]}(u||(u={}))},7441:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.validateProperty=void 0,t.validateProperty=function(e,t,n,r=[]){if(!e.hasOwnProperty(t))throw Error(`Missing property '${t}'`);const A=e[t];if(void 0!==n){let e=!0;switch(n){case"array":e=Array.isArray(A);break;case"object":e=void 0!==A;break;default:e=typeof A===n}if(!e)throw new Error(`Property '${t}' is not of type '${n}'`);if(r.length>0){let e=!0;switch(n){case"string":case"number":case"boolean":e=r.includes(A);break;default:e=r.findIndex((e=>e===A))>=0}if(!e)throw new Error(`Property '${t}' is not one of the valid values ${JSON.stringify(r)}`)}}}},8053:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.WorkspaceManager=void 0;const r=n(8925),A=n(1670),i=n(2920);class s extends A.DataConnector{constructor(e={}){var t;super(),this.serverSettings=null!==(t=e.serverSettings)&&void 0!==t?t:i.ServerConnection.makeSettings()}async fetch(e){const{serverSettings:t}=this,{baseUrl:n,appUrl:r}=t,{makeRequest:A,ResponseError:s}=i.ServerConnection,o=n+r,c=a.url(o,e),l=await A(c,{},t);if(200!==l.status)throw await s.create(l);return l.json()}async list(){const{serverSettings:e}=this,{baseUrl:t,appUrl:n}=e,{makeRequest:r,ResponseError:A}=i.ServerConnection,s=t+n,o=a.url(s,""),c=await r(o,{},e);if(200!==c.status)throw await A.create(c);return(await c.json()).workspaces}async remove(e){const{serverSettings:t}=this,{baseUrl:n,appUrl:r}=t,{makeRequest:A,ResponseError:s}=i.ServerConnection,o=n+r,c=a.url(o,e),l=await A(c,{method:"DELETE"},t);if(204!==l.status)throw await s.create(l)}async save(e,t){const{serverSettings:n}=this,{baseUrl:r,appUrl:A}=n,{makeRequest:s,ResponseError:o}=i.ServerConnection,c=r+A,l=a.url(c,e),u={body:JSON.stringify(t),method:"PUT"},h=await s(l,u,n);if(204!==h.status)throw await o.create(h)}}var a;t.WorkspaceManager=s,function(e){e.url=function(e,t){const n=r.URLExt.join(e,"api/workspaces"),A=r.URLExt.join(n,t);if(!A.startsWith(n))throw new Error("Can only be used for workspaces requests");return A}}(a||(a={}))},4949:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.DataConnector=void 0,t.DataConnector=class{async list(e){throw new Error("DataConnector#list method has not been implemented.")}async remove(e){throw new Error("DataConnector#remove method has not been implemented.")}async save(e,t){throw new Error("DataConnector#save method has not been implemented.")}}},1670:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n);var A=Object.getOwnPropertyDescriptor(t,n);A&&!("get"in A?!t.__esModule:A.writable||A.configurable)||(A={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,A)}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),A=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(t,"__esModule",{value:!0}),A(n(4949),t),A(n(9708),t),A(n(4025),t),A(n(2133),t),A(n(8022),t)},9708:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},4025:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.RestorablePool=void 0;const r=n(5764),A=n(6573),i=n(3992);var s;t.RestorablePool=class{constructor(e){this._added=new i.Signal(this),this._current=null,this._currentChanged=new i.Signal(this),this._hasRestored=!1,this._isDisposed=!1,this._objects=new Set,this._restore=null,this._restored=new r.PromiseDelegate,this._updated=new i.Signal(this),this.namespace=e.namespace}get added(){return this._added}get current(){return this._current}set current(e){this._current!==e&&null!==e&&this._objects.has(e)&&(this._current=e,this._currentChanged.emit(this._current))}get currentChanged(){return this._currentChanged}get isDisposed(){return this._isDisposed}get restored(){return this._restored.promise}get size(){return this._objects.size}get updated(){return this._updated}async add(e){var t,n;if(e.isDisposed){const t="A disposed object cannot be added.";throw console.warn(t,e),new Error(t)}if(this._objects.has(e)){const t="This object already exists in the pool.";throw console.warn(t,e),new Error(t)}if(this._objects.add(e),e.disposed.connect(this._onInstanceDisposed,this),!s.injectedProperty.get(e)){if(this._restore){const{connector:r}=this._restore,A=this._restore.name(e);if(A){const i=`${this.namespace}:${A}`,a=null===(n=(t=this._restore).args)||void 0===n?void 0:n.call(t,e);s.nameProperty.set(e,i),await r.save(i,{data:a})}}this._added.emit(e)}}dispose(){this.isDisposed||(this._current=null,this._isDisposed=!0,this._objects.clear(),i.Signal.clearData(this))}find(e){const t=this._objects.values();for(const n of t)if(e(n))return n}forEach(e){this._objects.forEach(e)}filter(e){const t=[];return this.forEach((n=>{e(n)&&t.push(n)})),t}inject(e){return s.injectedProperty.set(e,!0),this.add(e)}has(e){return this._objects.has(e)}async restore(e){if(this._hasRestored)throw new Error("This pool has already been restored.");this._hasRestored=!0;const{command:t,connector:n,registry:r,when:A}=e,i=this.namespace,s=A?[n.list(i)].concat(A):[n.list(i)];this._restore=e;const[a]=await Promise.all(s),o=await Promise.all(a.ids.map((async(e,A)=>{const i=a.values[A],s=i&&i.data;return void 0===s?n.remove(e):r.execute(t,s).catch((()=>n.remove(e)))})));return this._restored.resolve(),o}async save(e){var t,n;const r=s.injectedProperty.get(e);if(!this._restore||!this.has(e)||r)return;const{connector:A}=this._restore,i=this._restore.name(e),a=s.nameProperty.get(e),o=i?`${this.namespace}:${i}`:"";if(a&&a!==o&&await A.remove(a),s.nameProperty.set(e,o),o){const r=null===(n=(t=this._restore).args)||void 0===n?void 0:n.call(t,e);await A.save(o,{data:r})}a!==o&&this._updated.emit(e)}_onInstanceDisposed(e){if(this._objects.delete(e),e===this._current&&(this._current=null,this._currentChanged.emit(this._current)),s.injectedProperty.get(e))return;if(!this._restore)return;const{connector:t}=this._restore,n=s.nameProperty.get(e);n&&t.remove(n)}},function(e){e.injectedProperty=new A.AttachedProperty({name:"injected",create:()=>!1}),e.nameProperty=new A.AttachedProperty({name:"name",create:()=>""})}(s||(s={}))},2133:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.StateDB=void 0;const r=n(3992);class A{constructor(e={}){this._changed=new r.Signal(this);const{connector:t,transform:n}=e;this._connector=t||new A.Connector,this._ready=n?n.then((e=>{const{contents:t,type:n}=e;switch(n){case"cancel":default:return;case"clear":return this._clear();case"merge":return this._merge(t||{});case"overwrite":return this._overwrite(t||{})}})):Promise.resolve(void 0)}get changed(){return this._changed}async clear(){await this._ready,await this._clear()}async fetch(e){return await this._ready,this._fetch(e)}async list(e){return await this._ready,this._list(e)}async remove(e){await this._ready,await this._remove(e),this._changed.emit({id:e,type:"remove"})}async save(e,t){await this._ready,await this._save(e,t),this._changed.emit({id:e,type:"save"})}async toJSON(){await this._ready;const{ids:e,values:t}=await this._list();return t.reduce(((t,n,r)=>(t[e[r]]=n,t)),{})}async _clear(){await Promise.all((await this._list()).ids.map((e=>this._remove(e))))}async _fetch(e){const t=await this._connector.fetch(e);if(t)return JSON.parse(t).v}async _list(e=""){const{ids:t,values:n}=await this._connector.list(e);return{ids:t,values:n.map((e=>JSON.parse(e).v))}}async _merge(e){await Promise.all(Object.keys(e).map((t=>e[t]&&this._save(t,e[t]))))}async _overwrite(e){await this._clear(),await this._merge(e)}async _remove(e){return this._connector.remove(e)}async _save(e,t){return this._connector.save(e,JSON.stringify({v:t}))}}t.StateDB=A,function(e){e.Connector=class{constructor(){this._storage={}}async fetch(e){return this._storage[e]}async list(e=""){return Object.keys(this._storage).reduce(((t,n)=>(""!==e&&e!==n.split(":")[0]||(t.ids.push(n),t.values.push(this._storage[n])),t)),{ids:[],values:[]})}async remove(e){delete this._storage[e]}async save(e,t){this._storage[e]=t}}}(A||(t.StateDB=A={}))},8022:(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.IStateDB=void 0;const r=n(5764);t.IStateDB=new r.Token("@jupyterlab/coreutils:IStateDB",'A service for the JupyterLab state database.\n  Use this if you want to store data that will persist across page loads.\n  See "state database" for more information.')},8135:(e,t,n)=>{"use strict";var r,A,i;function*s(...e){for(const t of e)yield*t}function*a(){}function*o(e,t=0){for(const n of e)yield[t++,n]}function*c(e,t){let n=0;for(const r of e)t(r,n++)&&(yield r)}function l(e,t){let n=0;for(const r of e)if(t(r,n++))return r}function u(e,t){let n=0;for(const r of e)if(t(r,n++))return n-1;return-1}function h(e,t){let n;for(const r of e)void 0!==n?t(r,n)<0&&(n=r):n=r;return n}function d(e,t){let n;for(const r of e)void 0!==n?t(r,n)>0&&(n=r):n=r;return n}function f(e,t){let n,r,A=!0;for(const i of e)A?(n=i,r=i,A=!1):t(i,n)<0?n=i:t(i,r)>0&&(r=i);return A?void 0:[n,r]}function p(e){return Array.from(e)}function g(e){const t={};for(const[n,r]of e)t[n]=r;return t}function m(e,t){let n=0;for(const r of e)if(!1===t(r,n++))return}function y(e,t){let n=0;for(const r of e)if(!1===t(r,n++))return!1;return!0}function w(e,t){let n=0;for(const r of e)if(t(r,n++))return!0;return!1}function*v(e,t){let n=0;for(const r of e)yield t(r,n++)}function*B(e,t,n){void 0===t?(t=e,e=0,n=1):void 0===n&&(n=1);const r=A.rangeLength(e,t,n);for(let t=0;t<r;t++)yield e+n*t}function b(e,t,n){const r=e[Symbol.iterator]();let A=0,i=r.next();if(i.done&&void 0===n)throw new TypeError("Reduce of empty iterable with no initial value.");if(i.done)return n;let s,a,o=r.next();if(o.done&&void 0===n)return i.value;if(o.done)return t(n,i.value,A++);for(s=t(void 0===n?i.value:t(n,i.value,A++),o.value,A++);!(a=r.next()).done;)s=t(s,a.value,A++);return s}function*_(e,t){for(;0<t--;)yield e}function*C(e){yield e}function*x(e){if("function"==typeof e.retro)yield*e.retro();else for(let t=e.length-1;t>-1;t--)yield e[t]}function U(e){let t=[],n=new Set,r=new Map;for(const t of e)A(t);for(const[e]of r)i(e);return t;function A(e){let[t,n]=e,A=r.get(n);A?A.push(t):r.set(n,[t])}function i(e){if(n.has(e))return;n.add(e);let A=r.get(e);if(A)for(const e of A)i(e);t.push(e)}}function*F(e,t){let n=0;for(const r of e)0==n++%t&&(yield r)}function*E(e,t){if(t<1)return;const n=e[Symbol.iterator]();let r;for(;0<t--&&!(r=n.next()).done;)yield r.value}function*Q(...e){const t=e.map((e=>e[Symbol.iterator]()));let n=t.map((e=>e.next()));for(;y(n,(e=>!e.done));n=t.map((e=>e.next())))yield n.map((e=>e.value))}n.r(t),n.d(t,{ArrayExt:()=>r,StringExt:()=>i,chain:()=>s,each:()=>m,empty:()=>a,enumerate:()=>o,every:()=>y,filter:()=>c,find:()=>l,findIndex:()=>u,map:()=>v,max:()=>d,min:()=>h,minmax:()=>f,once:()=>C,range:()=>B,reduce:()=>b,repeat:()=>_,retro:()=>x,some:()=>w,stride:()=>F,take:()=>E,toArray:()=>p,toObject:()=>g,topologicSort:()=>U,zip:()=>Q}),function(e){function t(e,t,n=0,r=-1){let A,i=e.length;if(0===i)return-1;n=n<0?Math.max(0,n+i):Math.min(n,i-1),A=(r=r<0?Math.max(0,r+i):Math.min(r,i-1))<n?r+1+(i-n):r-n+1;for(let r=0;r<A;++r){let A=(n+r)%i;if(e[A]===t)return A}return-1}function n(e,t,n=-1,r=0){let A,i=e.length;if(0===i)return-1;A=(n=n<0?Math.max(0,n+i):Math.min(n,i-1))<(r=r<0?Math.max(0,r+i):Math.min(r,i-1))?n+1+(i-r):n-r+1;for(let r=0;r<A;++r){let A=(n-r+i)%i;if(e[A]===t)return A}return-1}function r(e,t,n=0,r=-1){let A,i=e.length;if(0===i)return-1;n=n<0?Math.max(0,n+i):Math.min(n,i-1),A=(r=r<0?Math.max(0,r+i):Math.min(r,i-1))<n?r+1+(i-n):r-n+1;for(let r=0;r<A;++r){let A=(n+r)%i;if(t(e[A],A))return A}return-1}function A(e,t,n=-1,r=0){let A,i=e.length;if(0===i)return-1;A=(n=n<0?Math.max(0,n+i):Math.min(n,i-1))<(r=r<0?Math.max(0,r+i):Math.min(r,i-1))?n+1+(i-r):n-r+1;for(let r=0;r<A;++r){let A=(n-r+i)%i;if(t(e[A],A))return A}return-1}function i(e,t=0,n=-1){let r=e.length;if(!(r<=1))for(t=t<0?Math.max(0,t+r):Math.min(t,r-1),n=n<0?Math.max(0,n+r):Math.min(n,r-1);t<n;){let r=e[t],A=e[n];e[t++]=A,e[n--]=r}}function s(e,t){let n=e.length;if(t<0&&(t+=n),t<0||t>=n)return;let r=e[t];for(let r=t+1;r<n;++r)e[r-1]=e[r];return e.length=n-1,r}e.firstIndexOf=t,e.lastIndexOf=n,e.findFirstIndex=r,e.findLastIndex=A,e.findFirstValue=function(e,t,n=0,A=-1){let i=r(e,t,n,A);return-1!==i?e[i]:void 0},e.findLastValue=function(e,t,n=-1,r=0){let i=A(e,t,n,r);return-1!==i?e[i]:void 0},e.lowerBound=function(e,t,n,r=0,A=-1){let i=e.length;if(0===i)return 0;let s=r=r<0?Math.max(0,r+i):Math.min(r,i-1),a=(A=A<0?Math.max(0,A+i):Math.min(A,i-1))-r+1;for(;a>0;){let r=a>>1,A=s+r;n(e[A],t)<0?(s=A+1,a-=r+1):a=r}return s},e.upperBound=function(e,t,n,r=0,A=-1){let i=e.length;if(0===i)return 0;let s=r=r<0?Math.max(0,r+i):Math.min(r,i-1),a=(A=A<0?Math.max(0,A+i):Math.min(A,i-1))-r+1;for(;a>0;){let r=a>>1,A=s+r;n(e[A],t)>0?a=r:(s=A+1,a-=r+1)}return s},e.shallowEqual=function(e,t,n){if(e===t)return!0;if(e.length!==t.length)return!1;for(let r=0,A=e.length;r<A;++r)if(n?!n(e[r],t[r]):e[r]!==t[r])return!1;return!0},e.slice=function(e,t={}){let{start:n,stop:r,step:A}=t;if(void 0===A&&(A=1),0===A)throw new Error("Slice `step` cannot be zero.");let i,s=e.length;void 0===n?n=A<0?s-1:0:n<0?n=Math.max(n+s,A<0?-1:0):n>=s&&(n=A<0?s-1:s),void 0===r?r=A<0?-1:s:r<0?r=Math.max(r+s,A<0?-1:0):r>=s&&(r=A<0?s-1:s),i=A<0&&r>=n||A>0&&n>=r?0:A<0?Math.floor((r-n+1)/A+1):Math.floor((r-n-1)/A+1);let a=[];for(let t=0;t<i;++t)a[t]=e[n+t*A];return a},e.move=function(e,t,n){let r=e.length;if(r<=1)return;if((t=t<0?Math.max(0,t+r):Math.min(t,r-1))===(n=n<0?Math.max(0,n+r):Math.min(n,r-1)))return;let A=e[t],i=t<n?1:-1;for(let r=t;r!==n;r+=i)e[r]=e[r+i];e[n]=A},e.reverse=i,e.rotate=function(e,t,n=0,r=-1){let A=e.length;if(A<=1)return;if((n=n<0?Math.max(0,n+A):Math.min(n,A-1))>=(r=r<0?Math.max(0,r+A):Math.min(r,A-1)))return;let s=r-n+1;if(t>0?t%=s:t<0&&(t=(t%s+s)%s),0===t)return;let a=n+t;i(e,n,a-1),i(e,a,r),i(e,n,r)},e.fill=function(e,t,n=0,r=-1){let A,i=e.length;if(0!==i){n=n<0?Math.max(0,n+i):Math.min(n,i-1),A=(r=r<0?Math.max(0,r+i):Math.min(r,i-1))<n?r+1+(i-n):r-n+1;for(let r=0;r<A;++r)e[(n+r)%i]=t}},e.insert=function(e,t,n){let r=e.length;t=t<0?Math.max(0,t+r):Math.min(t,r);for(let n=r;n>t;--n)e[n]=e[n-1];e[t]=n},e.removeAt=s,e.removeFirstOf=function(e,n,r=0,A=-1){let i=t(e,n,r,A);return-1!==i&&s(e,i),i},e.removeLastOf=function(e,t,r=-1,A=0){let i=n(e,t,r,A);return-1!==i&&s(e,i),i},e.removeAllOf=function(e,t,n=0,r=-1){let A=e.length;if(0===A)return 0;n=n<0?Math.max(0,n+A):Math.min(n,A-1),r=r<0?Math.max(0,r+A):Math.min(r,A-1);let i=0;for(let s=0;s<A;++s)n<=r&&s>=n&&s<=r&&e[s]===t||r<n&&(s<=r||s>=n)&&e[s]===t?i++:i>0&&(e[s-i]=e[s]);return i>0&&(e.length=A-i),i},e.removeFirstWhere=function(e,t,n=0,A=-1){let i,a=r(e,t,n,A);return-1!==a&&(i=s(e,a)),{index:a,value:i}},e.removeLastWhere=function(e,t,n=-1,r=0){let i,a=A(e,t,n,r);return-1!==a&&(i=s(e,a)),{index:a,value:i}},e.removeAllWhere=function(e,t,n=0,r=-1){let A=e.length;if(0===A)return 0;n=n<0?Math.max(0,n+A):Math.min(n,A-1),r=r<0?Math.max(0,r+A):Math.min(r,A-1);let i=0;for(let s=0;s<A;++s)n<=r&&s>=n&&s<=r&&t(e[s],s)||r<n&&(s<=r||s>=n)&&t(e[s],s)?i++:i>0&&(e[s-i]=e[s]);return i>0&&(e.length=A-i),i}}(r||(r={})),function(e){e.rangeLength=function(e,t,n){return 0===n?1/0:e>t&&n>0||e<t&&n<0?0:Math.ceil((t-e)/n)}}(A||(A={})),function(e){function t(e,t,n=0){let r=new Array(t.length);for(let A=0,i=n,s=t.length;A<s;++A,++i){if(i=e.indexOf(t[A],i),-1===i)return null;r[A]=i}return r}e.findIndices=t,e.matchSumOfSquares=function(e,n,r=0){let A=t(e,n,r);if(!A)return null;let i=0;for(let e=0,t=A.length;e<t;++e){let t=A[e]-r;i+=t*t}return{score:i,indices:A}},e.matchSumOfDeltas=function(e,n,r=0){let A=t(e,n,r);if(!A)return null;let i=0,s=r-1;for(let e=0,t=A.length;e<t;++e){let t=A[e];i+=t-s-1,s=t}return{score:i,indices:A}},e.highlight=function(e,t,n){let r=[],A=0,i=0,s=t.length;for(;A<s;){let a=t[A],o=t[A];for(;++A<s&&t[A]===o+1;)o++;i<a&&r.push(e.slice(i,a)),a<o+1&&r.push(n(e.slice(a,o+1))),i=o+1}return i<e.length&&r.push(e.slice(i)),r},e.cmp=function(e,t){return e<t?-1:e>t?1:0}}(i||(i={}))},5764:function(e,t,n){!function(e,t){"use strict";e.JSONExt=void 0,function(e){function t(e){return null===e||"boolean"==typeof e||"number"==typeof e||"string"==typeof e}function n(e){return Array.isArray(e)}function r(e,A){if(e===A)return!0;if(t(e)||t(A))return!1;let i=n(e),s=n(A);return i===s&&(i&&s?function(e,t){if(e===t)return!0;if(e.length!==t.length)return!1;for(let n=0,A=e.length;n<A;++n)if(!r(e[n],t[n]))return!1;return!0}(e,A):function(e,t){if(e===t)return!0;for(let n in e)if(void 0!==e[n]&&!(n in t))return!1;for(let n in t)if(void 0!==t[n]&&!(n in e))return!1;for(let n in e){let A=e[n],i=t[n];if(void 0!==A||void 0!==i){if(void 0===A||void 0===i)return!1;if(!r(A,i))return!1}}return!0}(e,A))}function A(e){return t(e)?e:n(e)?function(e){let t=new Array(e.length);for(let n=0,r=e.length;n<r;++n)t[n]=A(e[n]);return t}(e):function(e){let t={};for(let n in e){let r=e[n];void 0!==r&&(t[n]=A(r))}return t}(e)}e.emptyObject=Object.freeze({}),e.emptyArray=Object.freeze([]),e.isPrimitive=t,e.isArray=n,e.isObject=function(e){return!t(e)&&!n(e)},e.deepEqual=r,e.deepCopy=A}(e.JSONExt||(e.JSONExt={}));var n;!function(e){class n{constructor(e){var t,n,r,A;this._activated=!1,this._promise=null,this._service=null,this.id=e.id,this.description=null!==(t=e.description)&&void 0!==t?t:"",this.activate=e.activate,this.deactivate=null!==(n=e.deactivate)&&void 0!==n?n:null,this.provides=null!==(r=e.provides)&&void 0!==r?r:null,this.autoStart=null!==(A=e.autoStart)&&void 0!==A&&A,this.requires=e.requires?e.requires.slice():[],this.optional=e.optional?e.optional.slice():[]}get activated(){return this._activated}set activated(e){this._activated=e}get service(){return this._service}set service(e){this._service=e}get promise(){return this._promise}set promise(e){this._promise=e}}e.createPluginData=function(e){return new n(e)},e.ensureNoCycle=function(e,t,n){const r=[...e.requires,...e.optional],A=r=>{if(r===e.provides)return!0;const s=n.get(r);if(!s)return!1;const a=t.get(s),o=[...a.requires,...a.optional];return 0!==o.length&&(i.push(s),!!o.some(A)||(i.pop(),!1))};if(!e.provides||0===r.length)return;const i=[e.id];if(r.some(A))throw new ReferenceError(`Cycle detected: ${i.join(" -> ")}.`)},e.findDependents=function(e,n,r){const A=new Array,i=e=>{const t=n.get(e),i=[...t.requires,...t.optional];A.push(...i.reduce(((t,n)=>{const A=r.get(n);return A&&t.push([e,A]),t}),[]))};for(const e of n.keys())i(e);const s=A.filter((t=>t[1]===e));let a=0;for(;s.length>a;){const e=s.length,t=new Set(s.map((e=>e[0])));for(const e of t)A.filter((t=>t[1]===e)).forEach((e=>{s.includes(e)||s.push(e)}));a=e}const o=t.topologicSort(s),c=o.findIndex((t=>t===e));return-1===c?[e]:o.slice(0,c+1)},e.collectStartupPlugins=function(e,t){const n=new Set;for(const t of e.keys())!0===e.get(t).autoStart&&n.add(t);if(t.startPlugins)for(const e of t.startPlugins)n.add(e);if(t.ignorePlugins)for(const e of t.ignorePlugins)n.delete(e);return Array.from(n)}}(n||(n={}));function r(e){let t=0;for(let n=0,r=e.length;n<r;++n)n%4==0&&(t=4294967295*Math.random()>>>0),e[n]=255&t,t>>>=8}e.Random=void 0,(e.Random||(e.Random={})).getRandomValues=(()=>{const e="undefined"!=typeof window&&(window.crypto||window.msCrypto)||null;return e&&"function"==typeof e.getRandomValues?function(t){return e.getRandomValues(t)}:r})(),e.UUID=void 0,(e.UUID||(e.UUID={})).uuid4=function(e){const t=new Uint8Array(16),n=new Array(256);for(let e=0;e<16;++e)n[e]="0"+e.toString(16);for(let e=16;e<256;++e)n[e]=e.toString(16);return function(){return e(t),t[6]=64|15&t[6],t[8]=128|63&t[8],n[t[0]]+n[t[1]]+n[t[2]]+n[t[3]]+"-"+n[t[4]]+n[t[5]]+"-"+n[t[6]]+n[t[7]]+"-"+n[t[8]]+n[t[9]]+"-"+n[t[10]]+n[t[11]]+n[t[12]]+n[t[13]]+n[t[14]]+n[t[15]]}}(e.Random.getRandomValues),e.MimeData=class{constructor(){this._types=[],this._values=[]}types(){return this._types.slice()}hasData(e){return-1!==this._types.indexOf(e)}getData(e){let t=this._types.indexOf(e);return-1!==t?this._values[t]:void 0}setData(e,t){this.clearData(e),this._types.push(e),this._values.push(t)}clearData(e){let t=this._types.indexOf(e);-1!==t&&(this._types.splice(t,1),this._values.splice(t,1))}clear(){this._types.length=0,this._values.length=0}},e.PluginRegistry=class{constructor(e={}){this._application=null,this._validatePlugin=()=>!0,this._plugins=new Map,this._services=new Map,e.validatePlugin&&(console.info("Plugins may be rejected by the custom validation plugin method."),this._validatePlugin=e.validatePlugin)}get application(){return this._application}set application(e){if(null!==this._application)throw Error("PluginRegistry.application is already set. It cannot be overridden.");this._application=e}get deferredPlugins(){return Array.from(this._plugins).filter((([e,t])=>"defer"===t.autoStart)).map((([e,t])=>e))}getPluginDescription(e){var t,n;return null!==(n=null===(t=this._plugins.get(e))||void 0===t?void 0:t.description)&&void 0!==n?n:""}hasPlugin(e){return this._plugins.has(e)}isPluginActivated(e){var t,n;return null!==(n=null===(t=this._plugins.get(e))||void 0===t?void 0:t.activated)&&void 0!==n&&n}listPlugins(){return Array.from(this._plugins.keys())}registerPlugin(e){if(this._plugins.has(e.id))throw new TypeError(`Plugin '${e.id}' is already registered.`);if(!this._validatePlugin(e))throw new Error(`Plugin '${e.id}' is not valid.`);const t=n.createPluginData(e);n.ensureNoCycle(t,this._plugins,this._services),t.provides&&this._services.set(t.provides,t.id),this._plugins.set(t.id,t)}registerPlugins(e){for(const t of e)this.registerPlugin(t)}deregisterPlugin(e,t){const n=this._plugins.get(e);if(n){if(n.activated&&!t)throw new Error(`Plugin '${e}' is still active.`);this._plugins.delete(e)}}async activatePlugin(e){const t=this._plugins.get(e);if(!t)throw new ReferenceError(`Plugin '${e}' is not registered.`);if(t.activated)return;if(t.promise)return t.promise;const n=t.requires.map((e=>this.resolveRequiredService(e))),r=t.optional.map((e=>this.resolveOptionalService(e)));return t.promise=Promise.all([...n,...r]).then((e=>t.activate.apply(void 0,[this.application,...e]))).then((e=>{t.service=e,t.activated=!0,t.promise=null})).catch((e=>{throw t.promise=null,e})),t.promise}async activatePlugins(e,t={}){switch(e){case"defer":{const e=this.deferredPlugins.filter((e=>this._plugins.get(e).autoStart)).map((e=>this.activatePlugin(e)));await Promise.all(e);break}case"startUp":{const e=n.collectStartupPlugins(this._plugins,t).map((async e=>{try{return await this.activatePlugin(e)}catch(t){console.error(`Plugin '${e}' failed to activate.`,t)}}));await Promise.all(e);break}}}async deactivatePlugin(e){const t=this._plugins.get(e);if(!t)throw new ReferenceError(`Plugin '${e}' is not registered.`);if(!t.activated)return[];if(!t.deactivate)throw new TypeError(`Plugin '${e}'#deactivate() method missing`);const r=n.findDependents(e,this._plugins,this._services),A=r.map((e=>this._plugins.get(e)));for(const t of A)if(!t.deactivate)throw new TypeError(`Plugin ${t.id}#deactivate() method missing (depends on ${e})`);for(const e of A){const t=[...e.requires,...e.optional].map((e=>{const t=this._services.get(e);return t?this._plugins.get(t).service:null}));await e.deactivate(this.application,...t),e.service=null,e.activated=!1}return r.pop(),r}async resolveRequiredService(e){const t=this._services.get(e);if(!t)throw new TypeError(`No provider for: ${e.name}.`);const n=this._plugins.get(t);return n.activated||await this.activatePlugin(t),n.service}async resolveOptionalService(e){const t=this._services.get(e);if(!t)return null;const n=this._plugins.get(t);if(!n.activated)try{await this.activatePlugin(t)}catch(e){return console.error(e),null}return n.service}},e.PromiseDelegate=class{constructor(){this.promise=new Promise(((e,t)=>{this._resolve=e,this._reject=t}))}resolve(e){(0,this._resolve)(e)}reject(e){(0,this._reject)(e)}},e.Token=class{constructor(e,t){this.name=e,this.description=null!=t?t:"",this._tokenStructuralPropertyT=null}}}(t,n(8135))},7556:(e,t,n)=>{"use strict";n.r(t),n.d(t,{DisposableDelegate:()=>A,DisposableSet:()=>s,ObservableDisposableDelegate:()=>i,ObservableDisposableSet:()=>a});var r=n(3992);class A{constructor(e){this._fn=e}get isDisposed(){return!this._fn}dispose(){if(!this._fn)return;let e=this._fn;this._fn=null,e()}}class i extends A{constructor(){super(...arguments),this._disposed=new r.Signal(this)}get disposed(){return this._disposed}dispose(){this.isDisposed||(super.dispose(),this._disposed.emit(void 0),r.Signal.clearData(this))}}class s{constructor(){this._isDisposed=!1,this._items=new Set}get isDisposed(){return this._isDisposed}dispose(){this._isDisposed||(this._isDisposed=!0,this._items.forEach((e=>{e.dispose()})),this._items.clear())}contains(e){return this._items.has(e)}add(e){this._items.add(e)}remove(e){this._items.delete(e)}clear(){this._items.clear()}}!function(e){e.from=function(t){let n=new e;for(const e of t)n.add(e);return n}}(s||(s={}));class a extends s{constructor(){super(...arguments),this._disposed=new r.Signal(this)}get disposed(){return this._disposed}dispose(){this.isDisposed||(super.dispose(),this._disposed.emit(void 0),r.Signal.clearData(this))}}!function(e){e.from=function(t){let n=new e;for(const e of t)n.add(e);return n}}(a||(a={}))},6049:(e,t,n)=>{"use strict";n.r(t),n.d(t,{Debouncer:()=>o,Poll:()=>s,RateLimiter:()=>a,Throttler:()=>c});var r,A=n(5764),i=n(3992);class s{constructor(e){var t;this._disposed=new i.Signal(this),this._lingered=0,this._tick=new A.PromiseDelegate,this._ticked=new i.Signal(this),this._factory=e.factory,this._linger=null!==(t=e.linger)&&void 0!==t?t:r.DEFAULT_LINGER,this._standby=e.standby||r.DEFAULT_STANDBY,this._state={...r.DEFAULT_STATE,timestamp:(new Date).getTime()};const n=e.frequency||{},s=Math.max(n.interval||0,n.max||0,r.DEFAULT_FREQUENCY.max);this.frequency={...r.DEFAULT_FREQUENCY,...n,max:s},this.name=e.name||r.DEFAULT_NAME,"auto"in e&&!e.auto||setTimeout((()=>this.start()))}get disposed(){return this._disposed}get frequency(){return this._frequency}set frequency(e){if(this.isDisposed||A.JSONExt.deepEqual(e,this.frequency||{}))return;let{backoff:t,interval:n,max:r}=e;if(n=Math.round(n),r=Math.round(r),"number"==typeof t&&t<1)throw new Error("Poll backoff growth factor must be at least 1");if((n<0||n>r)&&n!==s.NEVER)throw new Error("Poll interval must be between 0 and max");if(r>s.MAX_INTERVAL&&r!==s.NEVER)throw new Error(`Max interval must be less than ${s.MAX_INTERVAL}`);this._frequency={backoff:t,interval:n,max:r}}get isDisposed(){return"disposed"===this.state.phase}get standby(){return this._standby}set standby(e){this.isDisposed||this.standby===e||(this._standby=e)}get state(){return this._state}get tick(){return this._tick.promise}get ticked(){return this._ticked}async*[Symbol.asyncIterator](){for(;!this.isDisposed;)yield this.state,await this.tick.catch((()=>{}))}dispose(){this.isDisposed||(this._state={...r.DISPOSED_STATE,timestamp:(new Date).getTime()},this._tick.promise.catch((e=>{})),this._tick.reject(new Error(`Poll (${this.name}) is disposed.`)),this._disposed.emit(void 0),i.Signal.clearData(this))}refresh(){return this.schedule({cancel:({phase:e})=>"refreshed"===e,interval:s.IMMEDIATE,phase:"refreshed"})}async schedule(e={}){if(this.isDisposed)return;if(e.cancel&&e.cancel(this.state))return;const t=this._tick,n=new A.PromiseDelegate,r={interval:this.frequency.interval,payload:null,phase:"standby",timestamp:(new Date).getTime(),...e};this._state=r,this._tick=n,clearTimeout(this._timeout),this._ticked.emit(this.state),t.resolve(this),await t.promise,r.interval!==s.NEVER?this._timeout=setTimeout((()=>{this.isDisposed||this.tick!==n.promise||this._execute()}),r.interval):this._timeout=void 0}start(){return this.schedule({cancel:({phase:e})=>"constructed"!==e&&"standby"!==e&&"stopped"!==e,interval:s.IMMEDIATE,phase:"started"})}stop(){return this.schedule({cancel:({phase:e})=>"stopped"===e,interval:s.NEVER,phase:"stopped"})}get hidden(){return r.hidden}_execute(){let e="function"==typeof this.standby?this.standby():this.standby;if("never"===e?e=!1:"when-hidden"===e&&(this.hidden?e=++this._lingered>this._linger:(this._lingered=0,e=!1)),e)return void this.schedule();const t=this.tick;this._factory(this.state).then((e=>{this.isDisposed||this.tick!==t||this.schedule({payload:e,phase:"rejected"===this.state.phase?"reconnected":"resolved"})})).catch((e=>{this.isDisposed||this.tick!==t||this.schedule({interval:r.sleep(this.frequency,this.state),payload:e,phase:"rejected"})}))}}!function(e){e.IMMEDIATE=0,e.MAX_INTERVAL=2147483647,e.NEVER=1/0}(s||(s={})),function(e){e.DEFAULT_BACKOFF=3,e.DEFAULT_FREQUENCY={backoff:!0,interval:1e3,max:3e4},e.DEFAULT_LINGER=1,e.DEFAULT_NAME="unknown",e.DEFAULT_STANDBY="when-hidden",e.DEFAULT_STATE={interval:s.NEVER,payload:null,phase:"constructed",timestamp:new Date(0).getTime()},e.DISPOSED_STATE={interval:s.NEVER,payload:null,phase:"disposed",timestamp:new Date(0).getTime()},e.sleep=function(t,n){const{backoff:r,interval:A,max:i}=t;if(A===s.NEVER)return A;const a=!0===r?e.DEFAULT_BACKOFF:!1===r?1:r,o=function(e,t){return e=Math.ceil(e),t=Math.floor(t),Math.floor(Math.random()*(t-e+1))+e}(A,n.interval*a);return Math.min(i,o)},e.hidden="undefined"!=typeof document&&(document.addEventListener("visibilitychange",(()=>{e.hidden="hidden"===document.visibilityState})),document.addEventListener("pagehide",(()=>{e.hidden="hidden"===document.visibilityState})),"hidden"===document.visibilityState)}(r||(r={}));class a{constructor(e,t=500){this.args=void 0,this.payload=null,this.limit=t,this.poll=new s({auto:!1,factory:async()=>{const{args:t}=this;return this.args=void 0,e(...t)},frequency:{backoff:!1,interval:s.NEVER,max:s.NEVER},standby:"never"}),this.payload=new A.PromiseDelegate,this.poll.ticked.connect(((e,t)=>{const{payload:n}=this;return"resolved"===t.phase?(this.payload=new A.PromiseDelegate,void n.resolve(t.payload)):"rejected"===t.phase||"stopped"===t.phase?(this.payload=new A.PromiseDelegate,n.promise.catch((e=>{})),void n.reject(t.payload)):void 0}),this)}get isDisposed(){return null===this.payload}dispose(){this.isDisposed||(this.args=void 0,this.payload=null,this.poll.dispose())}async stop(){return this.poll.stop()}}class o extends a{invoke(...e){return this.args=e,this.poll.schedule({interval:this.limit,phase:"invoked"}),this.payload.promise}}class c extends a{constructor(e,t){super(e,"number"==typeof t?t:t&&t.limit),this._trailing=!1,"number"!=typeof t&&t&&"trailing"===t.edge&&(this._trailing=!0),this._interval=this._trailing?this.limit:s.IMMEDIATE}invoke(...e){const t="invoked"!==this.poll.state.phase;return(t||this._trailing)&&(this.args=e),t&&this.poll.schedule({interval:this._interval,phase:"invoked"}),this.payload.promise}}},6573:(e,t,n)=>{"use strict";n.r(t),n.d(t,{AttachedProperty:()=>r});class r{constructor(e){this._pid=A.nextPID(),this.name=e.name,this._create=e.create,this._coerce=e.coerce||null,this._compare=e.compare||null,this._changed=e.changed||null}get(e){let t,n=A.ensureMap(e);return t=this._pid in n?n[this._pid]:n[this._pid]=this._createValue(e),t}set(e,t){let n,r=A.ensureMap(e);n=this._pid in r?r[this._pid]:r[this._pid]=this._createValue(e);let i=this._coerceValue(e,t);this._maybeNotify(e,n,r[this._pid]=i)}coerce(e){let t,n=A.ensureMap(e);t=this._pid in n?n[this._pid]:n[this._pid]=this._createValue(e);let r=this._coerceValue(e,t);this._maybeNotify(e,t,n[this._pid]=r)}_createValue(e){return(0,this._create)(e)}_coerceValue(e,t){let n=this._coerce;return n?n(e,t):t}_compareValue(e,t){let n=this._compare;return n?n(e,t):e===t}_maybeNotify(e,t,n){let r=this._changed;r&&!this._compareValue(t,n)&&r(e,t,n)}}var A;!function(e){e.clearData=function(e){A.ownerData.delete(e)}}(r||(r={})),function(e){e.ownerData=new WeakMap,e.nextPID=(()=>{let e=0;return()=>`pid-${`${Math.random()}`.slice(2)}-${e++}`})(),e.ensureMap=function(t){let n=e.ownerData.get(t);return n||(n=Object.create(null),e.ownerData.set(t,n),n)}}(A||(A={}))},3992:(e,t,n)=>{"use strict";n.r(t),n.d(t,{Signal:()=>s,Stream:()=>a});var r,A=n(8135),i=n(5764);class s{constructor(e){this.sender=e}connect(e,t){return r.connect(this,e,t)}disconnect(e,t){return r.disconnect(this,e,t)}emit(e){r.emit(this,e)}}!function(e){e.disconnectBetween=function(e,t){r.disconnectBetween(e,t)},e.disconnectSender=function(e){r.disconnectSender(e)},e.disconnectReceiver=function(e){r.disconnectReceiver(e)},e.disconnectAll=function(e){r.disconnectAll(e)},e.clearData=function(e){r.disconnectAll(e)},e.getExceptionHandler=function(){return r.exceptionHandler},e.setExceptionHandler=function(e){let t=r.exceptionHandler;return r.exceptionHandler=e,t}}(s||(s={}));class a extends s{constructor(){super(...arguments),this._pending=new i.PromiseDelegate}async*[Symbol.asyncIterator](){let e=this._pending;for(;;)try{const{args:t,next:n}=await e.promise;e=n,yield t}catch(e){return}}emit(e){const t=this._pending,n=this._pending=new i.PromiseDelegate;t.resolve({args:e,next:n}),super.emit(e)}stop(){this._pending.promise.catch((()=>{})),this._pending.reject("stop"),this._pending=new i.PromiseDelegate}}!function(e){function t(e){let t=r.get(e);if(t&&0!==t.length){for(const e of t){if(!e.signal)continue;let t=e.thisArg||e.slot;e.signal=null,l(i.get(t))}l(t)}}function n(e){let t=i.get(e);if(t&&0!==t.length){for(const e of t){if(!e.signal)continue;let t=e.signal.sender;e.signal=null,l(r.get(t))}l(t)}}e.exceptionHandler=e=>{console.error(e)},e.connect=function(e,t,n){n=n||void 0;let A=r.get(e.sender);if(A||(A=[],r.set(e.sender,A)),o(A,e,t,n))return!1;let s=n||t,a=i.get(s);a||(a=[],i.set(s,a));let c={signal:e,slot:t,thisArg:n};return A.push(c),a.push(c),!0},e.disconnect=function(e,t,n){n=n||void 0;let A=r.get(e.sender);if(!A||0===A.length)return!1;let s=o(A,e,t,n);if(!s)return!1;let a=n||t,c=i.get(a);return s.signal=null,l(A),l(c),!0},e.disconnectBetween=function(e,t){let n=r.get(e);if(!n||0===n.length)return;let A=i.get(t);if(A&&0!==A.length){for(const t of A)t.signal&&t.signal.sender===e&&(t.signal=null);l(n),l(A)}},e.disconnectSender=t,e.disconnectReceiver=n,e.disconnectAll=function(e){t(e),n(e)},e.emit=function(e,t){let n=r.get(e.sender);if(n&&0!==n.length)for(let r=0,A=n.length;r<A;++r){let A=n[r];A.signal===e&&c(A,t)}};const r=new WeakMap,i=new WeakMap,s=new Set,a="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;function o(e,t,n,r){return(0,A.find)(e,(e=>e.signal===t&&e.slot===n&&e.thisArg===r))}function c(t,n){let{signal:r,slot:A,thisArg:i}=t;try{A.call(i,r.sender,n)}catch(t){e.exceptionHandler(t)}}function l(e){0===s.size&&a(u),s.add(e)}function u(){s.forEach(h),s.clear()}function h(e){A.ArrayExt.removeAllWhere(e,d)}function d(e){return null===e.signal}}(r||(r={}))},8571:(e,t,n)=>{"use strict";var r=n(9619);function A(){var e={},t=0,n=0,r=0;return{add:function(A,i){i||(i=A,A=0),A>n?n=A:A<r&&(r=A),e[A]||(e[A]=[]),e[A].push(i),t++},process:function(){for(var t=r;t<=n;t++)for(var A=e[t],i=0;i<A.length;i++)(0,A[i])()},size:function(){return t}}}e.exports=function(e){var t=(e=e||{}).reporter,n=r.getOption(e,"async",!0),i=r.getOption(e,"auto",!0);i&&!n&&(t&&t.warn("Invalid options combination. auto=true and async=false is invalid. Setting async=true."),n=!0);var s,a=A(),o=!1;function c(){for(o=!0;a.size();){var e=a;a=A(),e.process()}o=!1}function l(){s=setTimeout(c,0)}return{add:function(e,t){!o&&i&&n&&0===a.size()&&l(),a.add(e,t)},force:function(e){o||(void 0===e&&(e=n),s&&(clearTimeout(s),s=null),e?l():c())}}}},9619:e=>{"use strict";(e.exports={}).getOption=function(e,t,n){var r=e[t];return null==r&&void 0!==n?n:r}},4750:e=>{"use strict";var t=e.exports={};t.isIE=function(e){return!(-1===(t=navigator.userAgent.toLowerCase()).indexOf("msie")&&-1===t.indexOf("trident")&&-1===t.indexOf(" edge/")||e&&e!==function(){var e=3,t=document.createElement("div"),n=t.getElementsByTagName("i");do{t.innerHTML="\x3c!--[if gt IE "+ ++e+"]><i></i><![endif]--\x3e"}while(n[0]);return e>4?e:void 0}());var t},t.isLegacyOpera=function(){return!!window.opera}},5379:e=>{"use strict";(e.exports={}).forEach=function(e,t){for(var n=0;n<e.length;n++){var r=t(e[n]);if(r)return r}}},3712:(e,t,n)=>{"use strict";var r=n(4750);e.exports=function(e){var t=(e=e||{}).reporter,n=e.batchProcessor,A=e.stateHandler.getState;if(!t)throw new Error("Missing required dependency: reporter.");function i(t){var n=e.important?" !important; ":"; ";return(t.join(n)+n).trim()}function s(e){return A(e).object}return{makeDetectable:function(e,s,a){a||(a=s,s=e,e=null),(e=e||{}).debug,r.isIE(8)?a(s):function(s,a){var o=i(["display: block","position: absolute","top: 0","left: 0","width: 100%","height: 100%","border: none","padding: 0","margin: 0","opacity: 0","z-index: -1000","pointer-events: none"]),c=!1,l=window.getComputedStyle(s),u=s.offsetWidth,h=s.offsetHeight;function d(){function n(){if("static"===l.position){s.style.setProperty("position","relative",e.important?"important":"");var n=function(t,n,r,A){var i=r[A];"auto"!==i&&"0"!==function(e){return e.replace(/[^-\d\.]/g,"")}(i)&&(t.warn("An element that is positioned static has style."+A+"="+i+" which is ignored due to the static positioning. The element will need to be positioned relative, so the style."+A+" will be set to 0. Element: ",n),n.style.setProperty(A,"0",e.important?"important":""))};n(t,s,l,"top"),n(t,s,l,"right"),n(t,s,l,"bottom"),n(t,s,l,"left")}}""!==l.position&&(n(),c=!0);var i=document.createElement("object");i.style.cssText=o,i.tabIndex=-1,i.type="text/html",i.setAttribute("aria-hidden","true"),i.onload=function(){c||n(),function e(t,n){if(!t.contentDocument){var r=A(t);return r.checkForObjectDocumentTimeoutId&&window.clearTimeout(r.checkForObjectDocumentTimeoutId),void(r.checkForObjectDocumentTimeoutId=setTimeout((function(){r.checkForObjectDocumentTimeoutId=0,e(t,n)}),100))}n(t.contentDocument)}(this,(function(e){a(s)}))},r.isIE()||(i.data="about:blank"),A(s)&&(s.appendChild(i),A(s).object=i,r.isIE()&&(i.data="about:blank"))}A(s).startSize={width:u,height:h},n?n.add(d):d()}(s,a)},addListener:function(e,t){function n(){t(e)}if(r.isIE(8))A(e).object={proxy:n},e.attachEvent("onresize",n);else{var i=s(e);if(!i)throw new Error("Element is not detectable by this strategy.");i.contentDocument.defaultView.addEventListener("resize",n)}},uninstall:function(e){if(A(e)){var t=s(e);t&&(r.isIE(8)?e.detachEvent("onresize",t.proxy):e.removeChild(t),A(e).checkForObjectDocumentTimeoutId&&window.clearTimeout(A(e).checkForObjectDocumentTimeoutId),delete A(e).object)}}}}},9814:(e,t,n)=>{"use strict";var r=n(5379).forEach;e.exports=function(e){var t=(e=e||{}).reporter,n=e.batchProcessor,A=e.stateHandler.getState,i=(e.stateHandler.hasState,e.idHandler);if(!n)throw new Error("Missing required dependency: batchProcessor");if(!t)throw new Error("Missing required dependency: reporter.");var s=function(){var e=document.createElement("div");e.style.cssText=c(["position: absolute","width: 1000px","height: 1000px","visibility: hidden","margin: 0","padding: 0"]);var t=document.createElement("div");t.style.cssText=c(["position: absolute","width: 500px","height: 500px","overflow: scroll","visibility: none","top: -1500px","left: -1500px","visibility: hidden","margin: 0","padding: 0"]),t.appendChild(e),document.body.insertBefore(t,document.body.firstChild);var n=500-t.clientWidth,r=500-t.clientHeight;return document.body.removeChild(t),{width:n,height:r}}(),a="erd_scroll_detection_container";function o(e){!function(e,t,n){if(!e.getElementById(t)){var r=n+"_animation",A=n+"_animation_active",i="/* Created by the element-resize-detector library. */\n";i+="."+n+" > div::-webkit-scrollbar { "+c(["display: none"])+" }\n\n",i+="."+A+" { "+c(["-webkit-animation-duration: 0.1s","animation-duration: 0.1s","-webkit-animation-name: "+r,"animation-name: "+r])+" }\n",i+="@-webkit-keyframes "+r+" { 0% { opacity: 1; } 50% { opacity: 0; } 100% { opacity: 1; } }\n",function(n,r){r=r||function(t){e.head.appendChild(t)};var A=e.createElement("style");A.innerHTML=n,A.id=t,r(A)}(i+="@keyframes "+r+" { 0% { opacity: 1; } 50% { opacity: 0; } 100% { opacity: 1; } }")}}(e,"erd_scroll_detection_scrollbar_style",a)}function c(t){var n=e.important?" !important; ":"; ";return(t.join(n)+n).trim()}function l(e,n,r){if(e.addEventListener)e.addEventListener(n,r);else{if(!e.attachEvent)return t.error("[scroll] Don't know how to add event listeners.");e.attachEvent("on"+n,r)}}function u(e,n,r){if(e.removeEventListener)e.removeEventListener(n,r);else{if(!e.detachEvent)return t.error("[scroll] Don't know how to remove event listeners.");e.detachEvent("on"+n,r)}}function h(e){return A(e).container.childNodes[0].childNodes[0].childNodes[0]}function d(e){return A(e).container.childNodes[0].childNodes[0].childNodes[1]}return o(window.document),{makeDetectable:function(e,o,u){function f(){if(e.debug){var n=Array.prototype.slice.call(arguments);if(n.unshift(i.get(o),"Scroll: "),t.log.apply)t.log.apply(null,n);else for(var r=0;r<n.length;r++)t.log(n[r])}}function p(e){var t=A(e).container.childNodes[0],n=window.getComputedStyle(t);return!n.width||-1===n.width.indexOf("px")}function g(){var e=window.getComputedStyle(o),t={};return t.position=e.position,t.width=o.offsetWidth,t.height=o.offsetHeight,t.top=e.top,t.right=e.right,t.bottom=e.bottom,t.left=e.left,t.widthCSS=e.width,t.heightCSS=e.height,t}function m(){if(f("storeStyle invoked."),A(o)){var e=g();A(o).style=e}else f("Aborting because element has been uninstalled")}function y(e,t,n){A(e).lastWidth=t,A(e).lastHeight=n}function w(){return 2*s.width+1}function v(){return 2*s.height+1}function B(e){return e+10+w()}function b(e){return e+10+v()}function _(e,t,n){var r=h(e),A=d(e),i=B(t),s=b(n),a=function(e){return 2*e+w()}(t),o=function(e){return 2*e+v()}(n);r.scrollLeft=i,r.scrollTop=s,A.scrollLeft=a,A.scrollTop=o}function C(){var e=A(o).container;if(!e){(e=document.createElement("div")).className=a,e.style.cssText=c(["visibility: hidden","display: inline","width: 0px","height: 0px","z-index: -1","overflow: hidden","margin: 0","padding: 0"]),A(o).container=e,function(e){e.className+=" "+a+"_animation_active"}(e),o.appendChild(e);var t=function(){A(o).onRendered&&A(o).onRendered()};l(e,"animationstart",t),A(o).onAnimationStart=t}return e}function x(){if(f("Injecting elements"),A(o)){!function(){var n=A(o).style;if("static"===n.position){o.style.setProperty("position","relative",e.important?"important":"");var r=function(e,t,n,r){var A=n[r];"auto"!==A&&"0"!==function(e){return e.replace(/[^-\d\.]/g,"")}(A)&&(e.warn("An element that is positioned static has style."+r+"="+A+" which is ignored due to the static positioning. The element will need to be positioned relative, so the style."+r+" will be set to 0. Element: ",t),t.style[r]=0)};r(t,o,n,"top"),r(t,o,n,"right"),r(t,o,n,"bottom"),r(t,o,n,"left")}}();var n=A(o).container;n||(n=C());var r,i,u,h,d=s.width,p=s.height,g=c(["position: absolute","flex: none","overflow: hidden","z-index: -1","visibility: hidden","width: 100%","height: 100%","left: 0px","top: 0px"]),m=c(["position: absolute","flex: none","overflow: hidden","z-index: -1","visibility: hidden"].concat(["left: "+(r=(r=-(1+d))?r+"px":"0"),"top: "+(i=(i=-(1+p))?i+"px":"0"),"right: "+(h=(h=-d)?h+"px":"0"),"bottom: "+(u=(u=-p)?u+"px":"0")])),y=c(["position: absolute","flex: none","overflow: scroll","z-index: -1","visibility: hidden","width: 100%","height: 100%"]),w=c(["position: absolute","flex: none","overflow: scroll","z-index: -1","visibility: hidden","width: 100%","height: 100%"]),v=c(["position: absolute","left: 0","top: 0"]),B=c(["position: absolute","width: 200%","height: 200%"]),b=document.createElement("div"),_=document.createElement("div"),x=document.createElement("div"),U=document.createElement("div"),F=document.createElement("div"),E=document.createElement("div");b.dir="ltr",b.style.cssText=g,b.className=a,_.className=a,_.style.cssText=m,x.style.cssText=y,U.style.cssText=v,F.style.cssText=w,E.style.cssText=B,x.appendChild(U),F.appendChild(E),_.appendChild(x),_.appendChild(F),b.appendChild(_),n.appendChild(b),l(x,"scroll",Q),l(F,"scroll",S),A(o).onExpandScroll=Q,A(o).onShrinkScroll=S}else f("Aborting because element has been uninstalled");function Q(){var e=A(o);e&&e.onExpand?e.onExpand():f("Aborting expand scroll handler: element has been uninstalled")}function S(){var e=A(o);e&&e.onShrink?e.onShrink():f("Aborting shrink scroll handler: element has been uninstalled")}}function U(){function s(t,n,r){var A=function(e){return h(e).childNodes[0]}(t),i=B(n),s=b(r);A.style.setProperty("width",i+"px",e.important?"important":""),A.style.setProperty("height",s+"px",e.important?"important":"")}function a(r){var a=o.offsetWidth,l=o.offsetHeight,u=a!==A(o).lastWidth||l!==A(o).lastHeight;f("Storing current size",a,l),y(o,a,l),n.add(0,(function(){if(u)if(A(o))if(c()){if(e.debug){var n=o.offsetWidth,r=o.offsetHeight;n===a&&r===l||t.warn(i.get(o),"Scroll: Size changed before updating detector elements.")}s(o,a,l)}else f("Aborting because element container has not been initialized");else f("Aborting because element has been uninstalled")})),n.add(1,(function(){A(o)?c()?_(o,a,l):f("Aborting because element container has not been initialized"):f("Aborting because element has been uninstalled")})),u&&r&&n.add(2,(function(){A(o)?c()?r():f("Aborting because element container has not been initialized"):f("Aborting because element has been uninstalled")}))}function c(){return!!A(o).container}function l(){f("notifyListenersIfNeeded invoked");var e=A(o);return void 0===A(o).lastNotifiedWidth&&e.lastWidth===e.startSize.width&&e.lastHeight===e.startSize.height?f("Not notifying: Size is the same as the start size, and there has been no notification yet."):e.lastWidth===e.lastNotifiedWidth&&e.lastHeight===e.lastNotifiedHeight?f("Not notifying: Size already notified"):(f("Current size not notified, notifying..."),e.lastNotifiedWidth=e.lastWidth,e.lastNotifiedHeight=e.lastHeight,void r(A(o).listeners,(function(e){e(o)})))}function u(){f("Scroll detected."),p(o)?f("Scroll event fired while unrendered. Ignoring..."):a(l)}if(f("registerListenersAndPositionElements invoked."),A(o)){A(o).onRendered=function(){if(f("startanimation triggered."),p(o))f("Ignoring since element is still unrendered...");else{f("Element rendered.");var e=h(o),t=d(o);0!==e.scrollLeft&&0!==e.scrollTop&&0!==t.scrollLeft&&0!==t.scrollTop||(f("Scrollbars out of sync. Updating detector elements..."),a(l))}},A(o).onExpand=u,A(o).onShrink=u;var g=A(o).style;s(o,g.width,g.height)}else f("Aborting because element has been uninstalled")}function F(){if(f("finalizeDomMutation invoked."),A(o)){var e=A(o).style;y(o,e.width,e.height),_(o,e.width,e.height)}else f("Aborting because element has been uninstalled")}function E(){u(o)}function Q(){var e;f("Installing..."),A(o).listeners=[],e=g(),A(o).startSize={width:e.width,height:e.height},f("Element start size",A(o).startSize),n.add(0,m),n.add(1,x),n.add(2,U),n.add(3,F),n.add(4,E)}u||(u=o,o=e,e=null),e=e||{},f("Making detectable..."),function(e){return!function(e){var t=e.getRootNode&&e.getRootNode().contains(e);return e===e.ownerDocument.body||e.ownerDocument.body.contains(e)||t}(e)||null===window.getComputedStyle(e)}(o)?(f("Element is detached"),C(),f("Waiting until element is attached..."),A(o).onRendered=function(){f("Element is now attached"),Q()}):Q()},addListener:function(e,t){if(!A(e).listeners.push)throw new Error("Cannot add listener to an element that is not detectable.");A(e).listeners.push(t)},uninstall:function(e){var t=A(e);t&&(t.onExpandScroll&&u(h(e),"scroll",t.onExpandScroll),t.onShrinkScroll&&u(d(e),"scroll",t.onShrinkScroll),t.onAnimationStart&&u(t.container,"animationstart",t.onAnimationStart),t.container&&e.removeChild(t.container))},initDocument:o}}},2087:(e,t,n)=>{"use strict";var r=n(5379).forEach,A=n(5839),i=n(1850),s=n(9158),a=n(4651),o=n(3766),c=n(4750),l=n(8571),u=n(3787),h=n(3712),d=n(9814);function f(e){return Array.isArray(e)||void 0!==e.length}function p(e){if(Array.isArray(e))return e;var t=[];return r(e,(function(e){t.push(e)})),t}function g(e){return e&&1===e.nodeType}function m(e,t,n){var r=e[t];return null==r&&void 0!==n?n:r}e.exports=function(e){var t;if((e=e||{}).idHandler)t={get:function(t){return e.idHandler.get(t,!0)},set:e.idHandler.set};else{var n=s(),y=a({idGenerator:n,stateHandler:u});t=y}var w=e.reporter;w||(w=o(!1===w));var v=m(e,"batchProcessor",l({reporter:w})),B={};B.callOnAdd=!!m(e,"callOnAdd",!0),B.debug=!!m(e,"debug",!1);var b,_=i(t),C=A({stateHandler:u}),x=m(e,"strategy","object"),U=m(e,"important",!1),F={reporter:w,batchProcessor:v,stateHandler:u,idHandler:t,important:U};if("scroll"===x&&(c.isLegacyOpera()?(w.warn("Scroll strategy is not supported on legacy Opera. Changing to object strategy."),x="object"):c.isIE(9)&&(w.warn("Scroll strategy is not supported on IE9. Changing to object strategy."),x="object")),"scroll"===x)b=d(F);else{if("object"!==x)throw new Error("Invalid strategy name: "+x);b=h(F)}var E={};return{listenTo:function(e,n,A){function i(e){var t=_.get(e);r(t,(function(t){t(e)}))}function s(e,t,n){_.add(t,n),e&&n(t)}if(A||(A=n,n=e,e={}),!n)throw new Error("At least one element required.");if(!A)throw new Error("Listener required.");if(g(n))n=[n];else{if(!f(n))return w.error("Invalid arguments. Must be a DOM element or a collection of DOM elements.");n=p(n)}var a=0,o=m(e,"callOnAdd",B.callOnAdd),c=m(e,"onReady",(function(){})),l=m(e,"debug",B.debug);r(n,(function(e){u.getState(e)||(u.initState(e),t.set(e));var h=t.get(e);if(l&&w.log("Attaching listener to element",h,e),!C.isDetectable(e))return l&&w.log(h,"Not detectable."),C.isBusy(e)?(l&&w.log(h,"System busy making it detectable"),s(o,e,A),E[h]=E[h]||[],void E[h].push((function(){++a===n.length&&c()}))):(l&&w.log(h,"Making detectable..."),C.markBusy(e,!0),b.makeDetectable({debug:l,important:U},e,(function(e){if(l&&w.log(h,"onElementDetectable"),u.getState(e)){C.markAsDetectable(e),C.markBusy(e,!1),b.addListener(e,i),s(o,e,A);var t=u.getState(e);if(t&&t.startSize){var d=e.offsetWidth,f=e.offsetHeight;t.startSize.width===d&&t.startSize.height===f||i(e)}E[h]&&r(E[h],(function(e){e()}))}else l&&w.log(h,"Element uninstalled before being detectable.");delete E[h],++a===n.length&&c()})));l&&w.log(h,"Already detecable, adding listener."),s(o,e,A),a++})),a===n.length&&c()},removeListener:_.removeListener,removeAllListeners:_.removeAllListeners,uninstall:function(e){if(!e)return w.error("At least one element is required.");if(g(e))e=[e];else{if(!f(e))return w.error("Invalid arguments. Must be a DOM element or a collection of DOM elements.");e=p(e)}r(e,(function(e){_.removeAllListeners(e),b.uninstall(e),u.cleanState(e)}))},initDocument:function(e){b.initDocument&&b.initDocument(e)}}}},5839:e=>{"use strict";e.exports=function(e){var t=e.stateHandler.getState;return{isDetectable:function(e){var n=t(e);return n&&!!n.isDetectable},markAsDetectable:function(e){t(e).isDetectable=!0},isBusy:function(e){return!!t(e).busy},markBusy:function(e,n){t(e).busy=!!n}}}},9158:e=>{"use strict";e.exports=function(){var e=1;return{generate:function(){return e++}}}},4651:e=>{"use strict";e.exports=function(e){var t=e.idGenerator,n=e.stateHandler.getState;return{get:function(e){var t=n(e);return t&&void 0!==t.id?t.id:null},set:function(e){var r=n(e);if(!r)throw new Error("setId required the element to have a resize detection state.");var A=t.generate();return r.id=A,A}}}},1850:e=>{"use strict";e.exports=function(e){var t={};function n(n){var r=e.get(n);return void 0===r?[]:t[r]||[]}return{get:n,add:function(n,r){var A=e.get(n);t[A]||(t[A]=[]),t[A].push(r)},removeListener:function(e,t){for(var r=n(e),A=0,i=r.length;A<i;++A)if(r[A]===t){r.splice(A,1);break}},removeAllListeners:function(e){var t=n(e);t&&(t.length=0)}}}},3766:e=>{"use strict";e.exports=function(e){function t(){}var n={log:t,warn:t,error:t};if(!e&&window.console){var r=function(e,t){e[t]=function(){var e=console[t];if(e.apply)e.apply(console,arguments);else for(var n=0;n<arguments.length;n++)e(arguments[n])}};r(n,"log"),r(n,"warn"),r(n,"error")}return n}},3787:e=>{"use strict";var t="_erd";function n(e){return e[t]}e.exports={initState:function(e){return e[t]={},n(e)},getState:n,cleanState:function(e){delete e[t]}}},8317:function(e){e.exports=function(){"use strict";var e=function(t,n){return e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},e(t,n)};function t(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}var n=function(){return n=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var A in t=arguments[n])Object.prototype.hasOwnProperty.call(t,A)&&(e[A]=t[A]);return e},n.apply(this,arguments)};function r(e,t,n,r){return new(n||(n=Promise))((function(A,i){function s(e){try{o(r.next(e))}catch(e){i(e)}}function a(e){try{o(r.throw(e))}catch(e){i(e)}}function o(e){var t;e.done?A(e.value):(t=e.value,t instanceof n?t:new n((function(e){e(t)}))).then(s,a)}o((r=r.apply(e,t||[])).next())}))}function A(e,t){var n,r,A,i,s={label:0,sent:function(){if(1&A[0])throw A[1];return A[1]},trys:[],ops:[]};return i={next:a(0),throw:a(1),return:a(2)},"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function a(i){return function(a){return function(i){if(n)throw new TypeError("Generator is already executing.");for(;s;)try{if(n=1,r&&(A=2&i[0]?r.return:i[0]?r.throw||((A=r.return)&&A.call(r),0):r.next)&&!(A=A.call(r,i[1])).done)return A;switch(r=0,A&&(i=[2&i[0],A.value]),i[0]){case 0:case 1:A=i;break;case 4:return s.label++,{value:i[1],done:!1};case 5:s.label++,r=i[1],i=[0];continue;case 7:i=s.ops.pop(),s.trys.pop();continue;default:if(!((A=(A=s.trys).length>0&&A[A.length-1])||6!==i[0]&&2!==i[0])){s=0;continue}if(3===i[0]&&(!A||i[1]>A[0]&&i[1]<A[3])){s.label=i[1];break}if(6===i[0]&&s.label<A[1]){s.label=A[1],A=i;break}if(A&&s.label<A[2]){s.label=A[2],s.ops.push(i);break}A[2]&&s.ops.pop(),s.trys.pop();continue}i=t.call(e,s)}catch(e){i=[6,e],r=0}finally{n=A=0}if(5&i[0])throw i[1];return{value:i[0]?i[1]:void 0,done:!0}}([i,a])}}}function i(e,t,n){if(n||2===arguments.length)for(var r,A=0,i=t.length;A<i;A++)!r&&A in t||(r||(r=Array.prototype.slice.call(t,0,A)),r[A]=t[A]);return e.concat(r||t)}for(var s=function(){function e(e,t,n,r){this.left=e,this.top=t,this.width=n,this.height=r}return e.prototype.add=function(t,n,r,A){return new e(this.left+t,this.top+n,this.width+r,this.height+A)},e.fromClientRect=function(t,n){return new e(n.left+t.windowBounds.left,n.top+t.windowBounds.top,n.width,n.height)},e.fromDOMRectList=function(t,n){var r=Array.from(n).find((function(e){return 0!==e.width}));return r?new e(r.left+t.windowBounds.left,r.top+t.windowBounds.top,r.width,r.height):e.EMPTY},e.EMPTY=new e(0,0,0,0),e}(),a=function(e,t){return s.fromClientRect(e,t.getBoundingClientRect())},o=function(e){for(var t=[],n=0,r=e.length;n<r;){var A=e.charCodeAt(n++);if(A>=55296&&A<=56319&&n<r){var i=e.charCodeAt(n++);56320==(64512&i)?t.push(((1023&A)<<10)+(1023&i)+65536):(t.push(A),n--)}else t.push(A)}return t},c=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];if(String.fromCodePoint)return String.fromCodePoint.apply(String,e);var n=e.length;if(!n)return"";for(var r=[],A=-1,i="";++A<n;){var s=e[A];s<=65535?r.push(s):(s-=65536,r.push(55296+(s>>10),s%1024+56320)),(A+1===n||r.length>16384)&&(i+=String.fromCharCode.apply(String,r),r.length=0)}return i},l="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",u="undefined"==typeof Uint8Array?[]:new Uint8Array(256),h=0;h<64;h++)u[l.charCodeAt(h)]=h;for(var d="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",f="undefined"==typeof Uint8Array?[]:new Uint8Array(256),p=0;p<64;p++)f[d.charCodeAt(p)]=p;for(var g=function(e,t,n){return e.slice?e.slice(t,n):new Uint16Array(Array.prototype.slice.call(e,t,n))},m=function(){function e(e,t,n,r,A,i){this.initialValue=e,this.errorValue=t,this.highStart=n,this.highValueIndex=r,this.index=A,this.data=i}return e.prototype.get=function(e){var t;if(e>=0){if(e<55296||e>56319&&e<=65535)return t=((t=this.index[e>>5])<<2)+(31&e),this.data[t];if(e<=65535)return t=((t=this.index[2048+(e-55296>>5)])<<2)+(31&e),this.data[t];if(e<this.highStart)return t=2080+(e>>11),t=this.index[t],t+=e>>5&63,t=((t=this.index[t])<<2)+(31&e),this.data[t];if(e<=1114111)return this.data[this.highValueIndex]}return this.errorValue},e}(),y="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",w="undefined"==typeof Uint8Array?[]:new Uint8Array(256),v=0;v<64;v++)w[y.charCodeAt(v)]=v;var B=10,b=13,_=15,C=17,x=18,U=19,F=20,E=21,Q=22,S=24,I=25,k=26,D=27,M=28,T=30,O=32,L=33,P=34,H=35,R=37,N=38,V=39,K=40,j=42,$=[9001,65288],G="×",z="÷",W=function(e){var t,n,r,A=function(e){var t,n,r,A,i,s=.75*e.length,a=e.length,o=0;"="===e[e.length-1]&&(s--,"="===e[e.length-2]&&s--);var c="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array&&void 0!==Uint8Array.prototype.slice?new ArrayBuffer(s):new Array(s),l=Array.isArray(c)?c:new Uint8Array(c);for(t=0;t<a;t+=4)n=f[e.charCodeAt(t)],r=f[e.charCodeAt(t+1)],A=f[e.charCodeAt(t+2)],i=f[e.charCodeAt(t+3)],l[o++]=n<<2|r>>4,l[o++]=(15&r)<<4|A>>2,l[o++]=(3&A)<<6|63&i;return c}(e),i=Array.isArray(A)?function(e){for(var t=e.length,n=[],r=0;r<t;r+=4)n.push(e[r+3]<<24|e[r+2]<<16|e[r+1]<<8|e[r]);return n}(A):new Uint32Array(A),s=Array.isArray(A)?function(e){for(var t=e.length,n=[],r=0;r<t;r+=2)n.push(e[r+1]<<8|e[r]);return n}(A):new Uint16Array(A),a=g(s,12,i[4]/2),o=2===i[5]?g(s,(24+i[4])/2):(t=i,n=Math.ceil((24+i[4])/4),t.slice?t.slice(n,r):new Uint32Array(Array.prototype.slice.call(t,n,r)));return new m(i[0],i[1],i[2],i[3],a,o)}("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"),q=[T,36],J=[1,2,3,5],Y=[B,8],X=[D,k],Z=J.concat(Y),ee=[N,V,K,P,H],te=[_,b],ne=function(e,t,n,r){var A=r[n];if(Array.isArray(e)?-1!==e.indexOf(A):e===A)for(var i=n;i<=r.length;){if((o=r[++i])===t)return!0;if(o!==B)break}if(A===B)for(i=n;i>0;){var s=r[--i];if(Array.isArray(e)?-1!==e.indexOf(s):e===s)for(var a=n;a<=r.length;){var o;if((o=r[++a])===t)return!0;if(o!==B)break}if(s!==B)break}return!1},re=function(e,t){for(var n=e;n>=0;){var r=t[n];if(r!==B)return r;n--}return 0},Ae=function(e,t,n,r,A){if(0===n[r])return G;var i=r-1;if(Array.isArray(A)&&!0===A[i])return G;var s=i-1,a=i+1,o=t[i],c=s>=0?t[s]:0,l=t[a];if(2===o&&3===l)return G;if(-1!==J.indexOf(o))return"!";if(-1!==J.indexOf(l))return G;if(-1!==Y.indexOf(l))return G;if(8===re(i,t))return z;if(11===W.get(e[i]))return G;if((o===O||o===L)&&11===W.get(e[a]))return G;if(7===o||7===l)return G;if(9===o)return G;if(-1===[B,b,_].indexOf(o)&&9===l)return G;if(-1!==[C,x,U,S,M].indexOf(l))return G;if(re(i,t)===Q)return G;if(ne(23,Q,i,t))return G;if(ne([C,x],E,i,t))return G;if(ne(12,12,i,t))return G;if(o===B)return z;if(23===o||23===l)return G;if(16===l||16===o)return z;if(-1!==[b,_,E].indexOf(l)||14===o)return G;if(36===c&&-1!==te.indexOf(o))return G;if(o===M&&36===l)return G;if(l===F)return G;if(-1!==q.indexOf(l)&&o===I||-1!==q.indexOf(o)&&l===I)return G;if(o===D&&-1!==[R,O,L].indexOf(l)||-1!==[R,O,L].indexOf(o)&&l===k)return G;if(-1!==q.indexOf(o)&&-1!==X.indexOf(l)||-1!==X.indexOf(o)&&-1!==q.indexOf(l))return G;if(-1!==[D,k].indexOf(o)&&(l===I||-1!==[Q,_].indexOf(l)&&t[a+1]===I)||-1!==[Q,_].indexOf(o)&&l===I||o===I&&-1!==[I,M,S].indexOf(l))return G;if(-1!==[I,M,S,C,x].indexOf(l))for(var u=i;u>=0;){if((h=t[u])===I)return G;if(-1===[M,S].indexOf(h))break;u--}if(-1!==[D,k].indexOf(l))for(u=-1!==[C,x].indexOf(o)?s:i;u>=0;){var h;if((h=t[u])===I)return G;if(-1===[M,S].indexOf(h))break;u--}if(N===o&&-1!==[N,V,P,H].indexOf(l)||-1!==[V,P].indexOf(o)&&-1!==[V,K].indexOf(l)||-1!==[K,H].indexOf(o)&&l===K)return G;if(-1!==ee.indexOf(o)&&-1!==[F,k].indexOf(l)||-1!==ee.indexOf(l)&&o===D)return G;if(-1!==q.indexOf(o)&&-1!==q.indexOf(l))return G;if(o===S&&-1!==q.indexOf(l))return G;if(-1!==q.concat(I).indexOf(o)&&l===Q&&-1===$.indexOf(e[a])||-1!==q.concat(I).indexOf(l)&&o===x)return G;if(41===o&&41===l){for(var d=n[i],f=1;d>0&&41===t[--d];)f++;if(f%2!=0)return G}return o===O&&l===L?G:z},ie=function(e,t){t||(t={lineBreak:"normal",wordBreak:"normal"});var n=function(e,t){void 0===t&&(t="strict");var n=[],r=[],A=[];return e.forEach((function(e,i){var s=W.get(e);if(s>50?(A.push(!0),s-=50):A.push(!1),-1!==["normal","auto","loose"].indexOf(t)&&-1!==[8208,8211,12316,12448].indexOf(e))return r.push(i),n.push(16);if(4===s||11===s){if(0===i)return r.push(i),n.push(T);var a=n[i-1];return-1===Z.indexOf(a)?(r.push(r[i-1]),n.push(a)):(r.push(i),n.push(T))}return r.push(i),31===s?n.push("strict"===t?E:R):s===j||29===s?n.push(T):43===s?e>=131072&&e<=196605||e>=196608&&e<=262141?n.push(R):n.push(T):void n.push(s)})),[r,n,A]}(e,t.lineBreak),r=n[0],A=n[1],i=n[2];"break-all"!==t.wordBreak&&"break-word"!==t.wordBreak||(A=A.map((function(e){return-1!==[I,T,j].indexOf(e)?R:e})));var s="keep-all"===t.wordBreak?i.map((function(t,n){return t&&e[n]>=19968&&e[n]<=40959})):void 0;return[r,A,s]},se=function(){function e(e,t,n,r){this.codePoints=e,this.required="!"===t,this.start=n,this.end=r}return e.prototype.slice=function(){return c.apply(void 0,this.codePoints.slice(this.start,this.end))},e}(),ae=45,oe=43,ce=-1,le=function(e){return e>=48&&e<=57},ue=function(e){return le(e)||e>=65&&e<=70||e>=97&&e<=102},he=function(e){return 10===e||9===e||32===e},de=function(e){return function(e){return function(e){return e>=97&&e<=122}(e)||function(e){return e>=65&&e<=90}(e)}(e)||function(e){return e>=128}(e)||95===e},fe=function(e){return de(e)||le(e)||e===ae},pe=function(e){return e>=0&&e<=8||11===e||e>=14&&e<=31||127===e},ge=function(e,t){return 92===e&&10!==t},me=function(e,t,n){return e===ae?de(t)||ge(t,n):!!de(e)||!(92!==e||!ge(e,t))},ye=function(e,t,n){return e===oe||e===ae?!!le(t)||46===t&&le(n):le(46===e?t:e)},we=function(e){var t=0,n=1;e[t]!==oe&&e[t]!==ae||(e[t]===ae&&(n=-1),t++);for(var r=[];le(e[t]);)r.push(e[t++]);var A=r.length?parseInt(c.apply(void 0,r),10):0;46===e[t]&&t++;for(var i=[];le(e[t]);)i.push(e[t++]);var s=i.length,a=s?parseInt(c.apply(void 0,i),10):0;69!==e[t]&&101!==e[t]||t++;var o=1;e[t]!==oe&&e[t]!==ae||(e[t]===ae&&(o=-1),t++);for(var l=[];le(e[t]);)l.push(e[t++]);var u=l.length?parseInt(c.apply(void 0,l),10):0;return n*(A+a*Math.pow(10,-s))*Math.pow(10,o*u)},ve={type:2},Be={type:3},be={type:4},_e={type:13},Ce={type:8},xe={type:21},Ue={type:9},Fe={type:10},Ee={type:11},Qe={type:12},Se={type:14},Ie={type:23},ke={type:1},De={type:25},Me={type:24},Te={type:26},Oe={type:27},Le={type:28},Pe={type:29},He={type:31},Re={type:32},Ne=function(){function e(){this._value=[]}return e.prototype.write=function(e){this._value=this._value.concat(o(e))},e.prototype.read=function(){for(var e=[],t=this.consumeToken();t!==Re;)e.push(t),t=this.consumeToken();return e},e.prototype.consumeToken=function(){var e=this.consumeCodePoint();switch(e){case 34:return this.consumeStringToken(34);case 35:var t=this.peekCodePoint(0),n=this.peekCodePoint(1),r=this.peekCodePoint(2);if(fe(t)||ge(n,r)){var A=me(t,n,r)?2:1;return{type:5,value:this.consumeName(),flags:A}}break;case 36:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),_e;break;case 39:return this.consumeStringToken(39);case 40:return ve;case 41:return Be;case 42:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),Se;break;case oe:if(ye(e,this.peekCodePoint(0),this.peekCodePoint(1)))return this.reconsumeCodePoint(e),this.consumeNumericToken();break;case 44:return be;case ae:var i=e,s=this.peekCodePoint(0),a=this.peekCodePoint(1);if(ye(i,s,a))return this.reconsumeCodePoint(e),this.consumeNumericToken();if(me(i,s,a))return this.reconsumeCodePoint(e),this.consumeIdentLikeToken();if(s===ae&&62===a)return this.consumeCodePoint(),this.consumeCodePoint(),Me;break;case 46:if(ye(e,this.peekCodePoint(0),this.peekCodePoint(1)))return this.reconsumeCodePoint(e),this.consumeNumericToken();break;case 47:if(42===this.peekCodePoint(0))for(this.consumeCodePoint();;){var o=this.consumeCodePoint();if(42===o&&47===(o=this.consumeCodePoint()))return this.consumeToken();if(o===ce)return this.consumeToken()}break;case 58:return Te;case 59:return Oe;case 60:if(33===this.peekCodePoint(0)&&this.peekCodePoint(1)===ae&&this.peekCodePoint(2)===ae)return this.consumeCodePoint(),this.consumeCodePoint(),De;break;case 64:var l=this.peekCodePoint(0),u=this.peekCodePoint(1),h=this.peekCodePoint(2);if(me(l,u,h))return{type:7,value:this.consumeName()};break;case 91:return Le;case 92:if(ge(e,this.peekCodePoint(0)))return this.reconsumeCodePoint(e),this.consumeIdentLikeToken();break;case 93:return Pe;case 61:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),Ce;break;case 123:return Ee;case 125:return Qe;case 117:case 85:var d=this.peekCodePoint(0),f=this.peekCodePoint(1);return d!==oe||!ue(f)&&63!==f||(this.consumeCodePoint(),this.consumeUnicodeRangeToken()),this.reconsumeCodePoint(e),this.consumeIdentLikeToken();case 124:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),Ue;if(124===this.peekCodePoint(0))return this.consumeCodePoint(),xe;break;case 126:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),Fe;break;case ce:return Re}return he(e)?(this.consumeWhiteSpace(),He):le(e)?(this.reconsumeCodePoint(e),this.consumeNumericToken()):de(e)?(this.reconsumeCodePoint(e),this.consumeIdentLikeToken()):{type:6,value:c(e)}},e.prototype.consumeCodePoint=function(){var e=this._value.shift();return void 0===e?-1:e},e.prototype.reconsumeCodePoint=function(e){this._value.unshift(e)},e.prototype.peekCodePoint=function(e){return e>=this._value.length?-1:this._value[e]},e.prototype.consumeUnicodeRangeToken=function(){for(var e=[],t=this.consumeCodePoint();ue(t)&&e.length<6;)e.push(t),t=this.consumeCodePoint();for(var n=!1;63===t&&e.length<6;)e.push(t),t=this.consumeCodePoint(),n=!0;if(n)return{type:30,start:parseInt(c.apply(void 0,e.map((function(e){return 63===e?48:e}))),16),end:parseInt(c.apply(void 0,e.map((function(e){return 63===e?70:e}))),16)};var r=parseInt(c.apply(void 0,e),16);if(this.peekCodePoint(0)===ae&&ue(this.peekCodePoint(1))){this.consumeCodePoint(),t=this.consumeCodePoint();for(var A=[];ue(t)&&A.length<6;)A.push(t),t=this.consumeCodePoint();return{type:30,start:r,end:parseInt(c.apply(void 0,A),16)}}return{type:30,start:r,end:r}},e.prototype.consumeIdentLikeToken=function(){var e=this.consumeName();return"url"===e.toLowerCase()&&40===this.peekCodePoint(0)?(this.consumeCodePoint(),this.consumeUrlToken()):40===this.peekCodePoint(0)?(this.consumeCodePoint(),{type:19,value:e}):{type:20,value:e}},e.prototype.consumeUrlToken=function(){var e=[];if(this.consumeWhiteSpace(),this.peekCodePoint(0)===ce)return{type:22,value:""};var t=this.peekCodePoint(0);if(39===t||34===t){var n=this.consumeStringToken(this.consumeCodePoint());return 0===n.type&&(this.consumeWhiteSpace(),this.peekCodePoint(0)===ce||41===this.peekCodePoint(0))?(this.consumeCodePoint(),{type:22,value:n.value}):(this.consumeBadUrlRemnants(),Ie)}for(;;){var r=this.consumeCodePoint();if(r===ce||41===r)return{type:22,value:c.apply(void 0,e)};if(he(r))return this.consumeWhiteSpace(),this.peekCodePoint(0)===ce||41===this.peekCodePoint(0)?(this.consumeCodePoint(),{type:22,value:c.apply(void 0,e)}):(this.consumeBadUrlRemnants(),Ie);if(34===r||39===r||40===r||pe(r))return this.consumeBadUrlRemnants(),Ie;if(92===r){if(!ge(r,this.peekCodePoint(0)))return this.consumeBadUrlRemnants(),Ie;e.push(this.consumeEscapedCodePoint())}else e.push(r)}},e.prototype.consumeWhiteSpace=function(){for(;he(this.peekCodePoint(0));)this.consumeCodePoint()},e.prototype.consumeBadUrlRemnants=function(){for(;;){var e=this.consumeCodePoint();if(41===e||e===ce)return;ge(e,this.peekCodePoint(0))&&this.consumeEscapedCodePoint()}},e.prototype.consumeStringSlice=function(e){for(var t="";e>0;){var n=Math.min(5e4,e);t+=c.apply(void 0,this._value.splice(0,n)),e-=n}return this._value.shift(),t},e.prototype.consumeStringToken=function(e){for(var t="",n=0;;){var r=this._value[n];if(r===ce||void 0===r||r===e)return{type:0,value:t+=this.consumeStringSlice(n)};if(10===r)return this._value.splice(0,n),ke;if(92===r){var A=this._value[n+1];A!==ce&&void 0!==A&&(10===A?(t+=this.consumeStringSlice(n),n=-1,this._value.shift()):ge(r,A)&&(t+=this.consumeStringSlice(n),t+=c(this.consumeEscapedCodePoint()),n=-1))}n++}},e.prototype.consumeNumber=function(){var e=[],t=4,n=this.peekCodePoint(0);for(n!==oe&&n!==ae||e.push(this.consumeCodePoint());le(this.peekCodePoint(0));)e.push(this.consumeCodePoint());n=this.peekCodePoint(0);var r=this.peekCodePoint(1);if(46===n&&le(r))for(e.push(this.consumeCodePoint(),this.consumeCodePoint()),t=8;le(this.peekCodePoint(0));)e.push(this.consumeCodePoint());n=this.peekCodePoint(0),r=this.peekCodePoint(1);var A=this.peekCodePoint(2);if((69===n||101===n)&&((r===oe||r===ae)&&le(A)||le(r)))for(e.push(this.consumeCodePoint(),this.consumeCodePoint()),t=8;le(this.peekCodePoint(0));)e.push(this.consumeCodePoint());return[we(e),t]},e.prototype.consumeNumericToken=function(){var e=this.consumeNumber(),t=e[0],n=e[1],r=this.peekCodePoint(0),A=this.peekCodePoint(1),i=this.peekCodePoint(2);return me(r,A,i)?{type:15,number:t,flags:n,unit:this.consumeName()}:37===r?(this.consumeCodePoint(),{type:16,number:t,flags:n}):{type:17,number:t,flags:n}},e.prototype.consumeEscapedCodePoint=function(){var e=this.consumeCodePoint();if(ue(e)){for(var t=c(e);ue(this.peekCodePoint(0))&&t.length<6;)t+=c(this.consumeCodePoint());he(this.peekCodePoint(0))&&this.consumeCodePoint();var n=parseInt(t,16);return 0===n||function(e){return e>=55296&&e<=57343}(n)||n>1114111?65533:n}return e===ce?65533:e},e.prototype.consumeName=function(){for(var e="";;){var t=this.consumeCodePoint();if(fe(t))e+=c(t);else{if(!ge(t,this.peekCodePoint(0)))return this.reconsumeCodePoint(t),e;e+=c(this.consumeEscapedCodePoint())}}},e}(),Ve=function(){function e(e){this._tokens=e}return e.create=function(t){var n=new Ne;return n.write(t),new e(n.read())},e.parseValue=function(t){return e.create(t).parseComponentValue()},e.parseValues=function(t){return e.create(t).parseComponentValues()},e.prototype.parseComponentValue=function(){for(var e=this.consumeToken();31===e.type;)e=this.consumeToken();if(32===e.type)throw new SyntaxError("Error parsing CSS component value, unexpected EOF");this.reconsumeToken(e);var t=this.consumeComponentValue();do{e=this.consumeToken()}while(31===e.type);if(32===e.type)return t;throw new SyntaxError("Error parsing CSS component value, multiple values found when expecting only one")},e.prototype.parseComponentValues=function(){for(var e=[];;){var t=this.consumeComponentValue();if(32===t.type)return e;e.push(t),e.push()}},e.prototype.consumeComponentValue=function(){var e=this.consumeToken();switch(e.type){case 11:case 28:case 2:return this.consumeSimpleBlock(e.type);case 19:return this.consumeFunction(e)}return e},e.prototype.consumeSimpleBlock=function(e){for(var t={type:e,values:[]},n=this.consumeToken();;){if(32===n.type||Ye(n,e))return t;this.reconsumeToken(n),t.values.push(this.consumeComponentValue()),n=this.consumeToken()}},e.prototype.consumeFunction=function(e){for(var t={name:e.value,values:[],type:18};;){var n=this.consumeToken();if(32===n.type||3===n.type)return t;this.reconsumeToken(n),t.values.push(this.consumeComponentValue())}},e.prototype.consumeToken=function(){var e=this._tokens.shift();return void 0===e?Re:e},e.prototype.reconsumeToken=function(e){this._tokens.unshift(e)},e}(),Ke=function(e){return 15===e.type},je=function(e){return 17===e.type},$e=function(e){return 20===e.type},Ge=function(e){return 0===e.type},ze=function(e,t){return $e(e)&&e.value===t},We=function(e){return 31!==e.type},qe=function(e){return 31!==e.type&&4!==e.type},Je=function(e){var t=[],n=[];return e.forEach((function(e){if(4===e.type){if(0===n.length)throw new Error("Error parsing function args, zero tokens for arg");return t.push(n),void(n=[])}31!==e.type&&n.push(e)})),n.length&&t.push(n),t},Ye=function(e,t){return 11===t&&12===e.type||28===t&&29===e.type||2===t&&3===e.type},Xe=function(e){return 17===e.type||15===e.type},Ze=function(e){return 16===e.type||Xe(e)},et=function(e){return e.length>1?[e[0],e[1]]:[e[0]]},tt={type:17,number:0,flags:4},nt={type:16,number:50,flags:4},rt={type:16,number:100,flags:4},At=function(e,t,n){var r=e[0],A=e[1];return[it(r,t),it(void 0!==A?A:r,n)]},it=function(e,t){if(16===e.type)return e.number/100*t;if(Ke(e))switch(e.unit){case"rem":case"em":return 16*e.number;default:return e.number}return e.number},st="grad",at="turn",ot=function(e,t){if(15===t.type)switch(t.unit){case"deg":return Math.PI*t.number/180;case st:return Math.PI/200*t.number;case"rad":return t.number;case at:return 2*Math.PI*t.number}throw new Error("Unsupported angle type")},ct=function(e){return 15===e.type&&("deg"===e.unit||e.unit===st||"rad"===e.unit||e.unit===at)},lt=function(e){switch(e.filter($e).map((function(e){return e.value})).join(" ")){case"to bottom right":case"to right bottom":case"left top":case"top left":return[tt,tt];case"to top":case"bottom":return ut(0);case"to bottom left":case"to left bottom":case"right top":case"top right":return[tt,rt];case"to right":case"left":return ut(90);case"to top left":case"to left top":case"right bottom":case"bottom right":return[rt,rt];case"to bottom":case"top":return ut(180);case"to top right":case"to right top":case"left bottom":case"bottom left":return[rt,tt];case"to left":case"right":return ut(270)}return 0},ut=function(e){return Math.PI*e/180},ht=function(e,t){if(18===t.type){var n=vt[t.name];if(void 0===n)throw new Error('Attempting to parse an unsupported color function "'+t.name+'"');return n(e,t.values)}if(5===t.type){if(3===t.value.length){var r=t.value.substring(0,1),A=t.value.substring(1,2),i=t.value.substring(2,3);return pt(parseInt(r+r,16),parseInt(A+A,16),parseInt(i+i,16),1)}if(4===t.value.length){r=t.value.substring(0,1),A=t.value.substring(1,2),i=t.value.substring(2,3);var s=t.value.substring(3,4);return pt(parseInt(r+r,16),parseInt(A+A,16),parseInt(i+i,16),parseInt(s+s,16)/255)}if(6===t.value.length)return r=t.value.substring(0,2),A=t.value.substring(2,4),i=t.value.substring(4,6),pt(parseInt(r,16),parseInt(A,16),parseInt(i,16),1);if(8===t.value.length)return r=t.value.substring(0,2),A=t.value.substring(2,4),i=t.value.substring(4,6),s=t.value.substring(6,8),pt(parseInt(r,16),parseInt(A,16),parseInt(i,16),parseInt(s,16)/255)}if(20===t.type){var a=bt[t.value.toUpperCase()];if(void 0!==a)return a}return bt.TRANSPARENT},dt=function(e){return!(255&e)},ft=function(e){var t=255&e,n=255&e>>8,r=255&e>>16,A=255&e>>24;return t<255?"rgba("+A+","+r+","+n+","+t/255+")":"rgb("+A+","+r+","+n+")"},pt=function(e,t,n,r){return(e<<24|t<<16|n<<8|Math.round(255*r))>>>0},gt=function(e,t){if(17===e.type)return e.number;if(16===e.type){var n=3===t?1:255;return 3===t?e.number/100*n:Math.round(e.number/100*n)}return 0},mt=function(e,t){var n=t.filter(qe);if(3===n.length){var r=n.map(gt),A=r[0],i=r[1],s=r[2];return pt(A,i,s,1)}if(4===n.length){var a=n.map(gt),o=(A=a[0],i=a[1],s=a[2],a[3]);return pt(A,i,s,o)}return 0};function yt(e,t,n){return n<0&&(n+=1),n>=1&&(n-=1),n<1/6?(t-e)*n*6+e:n<.5?t:n<2/3?6*(t-e)*(2/3-n)+e:e}var wt=function(e,t){var n=t.filter(qe),r=n[0],A=n[1],i=n[2],s=n[3],a=(17===r.type?ut(r.number):ot(e,r))/(2*Math.PI),o=Ze(A)?A.number/100:0,c=Ze(i)?i.number/100:0,l=void 0!==s&&Ze(s)?it(s,1):1;if(0===o)return pt(255*c,255*c,255*c,1);var u=c<=.5?c*(o+1):c+o-c*o,h=2*c-u,d=yt(h,u,a+1/3),f=yt(h,u,a),p=yt(h,u,a-1/3);return pt(255*d,255*f,255*p,l)},vt={hsl:wt,hsla:wt,rgb:mt,rgba:mt},Bt=function(e,t){return ht(e,Ve.create(t).parseComponentValue())},bt={ALICEBLUE:4042850303,ANTIQUEWHITE:4209760255,AQUA:16777215,AQUAMARINE:2147472639,AZURE:4043309055,BEIGE:4126530815,BISQUE:4293182719,BLACK:255,BLANCHEDALMOND:4293643775,BLUE:65535,BLUEVIOLET:2318131967,BROWN:2771004159,BURLYWOOD:3736635391,CADETBLUE:1604231423,CHARTREUSE:2147418367,CHOCOLATE:3530104575,CORAL:4286533887,CORNFLOWERBLUE:1687547391,CORNSILK:4294499583,CRIMSON:3692313855,CYAN:16777215,DARKBLUE:35839,DARKCYAN:9145343,DARKGOLDENROD:3095837695,DARKGRAY:2846468607,DARKGREEN:6553855,DARKGREY:2846468607,DARKKHAKI:3182914559,DARKMAGENTA:2332068863,DARKOLIVEGREEN:1433087999,DARKORANGE:4287365375,DARKORCHID:2570243327,DARKRED:2332033279,DARKSALMON:3918953215,DARKSEAGREEN:2411499519,DARKSLATEBLUE:1211993087,DARKSLATEGRAY:793726975,DARKSLATEGREY:793726975,DARKTURQUOISE:13554175,DARKVIOLET:2483082239,DEEPPINK:4279538687,DEEPSKYBLUE:12582911,DIMGRAY:1768516095,DIMGREY:1768516095,DODGERBLUE:512819199,FIREBRICK:2988581631,FLORALWHITE:4294635775,FORESTGREEN:579543807,FUCHSIA:4278255615,GAINSBORO:3705462015,GHOSTWHITE:4177068031,GOLD:4292280575,GOLDENROD:3668254975,GRAY:2155905279,GREEN:8388863,GREENYELLOW:2919182335,GREY:2155905279,HONEYDEW:4043305215,HOTPINK:4285117695,INDIANRED:3445382399,INDIGO:1258324735,IVORY:4294963455,KHAKI:4041641215,LAVENDER:3873897215,LAVENDERBLUSH:4293981695,LAWNGREEN:2096890111,LEMONCHIFFON:4294626815,LIGHTBLUE:2916673279,LIGHTCORAL:4034953471,LIGHTCYAN:3774873599,LIGHTGOLDENRODYELLOW:4210742015,LIGHTGRAY:3553874943,LIGHTGREEN:2431553791,LIGHTGREY:3553874943,LIGHTPINK:4290167295,LIGHTSALMON:4288707327,LIGHTSEAGREEN:548580095,LIGHTSKYBLUE:2278488831,LIGHTSLATEGRAY:2005441023,LIGHTSLATEGREY:2005441023,LIGHTSTEELBLUE:2965692159,LIGHTYELLOW:4294959359,LIME:16711935,LIMEGREEN:852308735,LINEN:4210091775,MAGENTA:4278255615,MAROON:2147483903,MEDIUMAQUAMARINE:1724754687,MEDIUMBLUE:52735,MEDIUMORCHID:3126187007,MEDIUMPURPLE:2473647103,MEDIUMSEAGREEN:1018393087,MEDIUMSLATEBLUE:2070474495,MEDIUMSPRINGGREEN:16423679,MEDIUMTURQUOISE:1221709055,MEDIUMVIOLETRED:3340076543,MIDNIGHTBLUE:421097727,MINTCREAM:4127193855,MISTYROSE:4293190143,MOCCASIN:4293178879,NAVAJOWHITE:4292783615,NAVY:33023,OLDLACE:4260751103,OLIVE:2155872511,OLIVEDRAB:1804477439,ORANGE:4289003775,ORANGERED:4282712319,ORCHID:3664828159,PALEGOLDENROD:4008225535,PALEGREEN:2566625535,PALETURQUOISE:2951671551,PALEVIOLETRED:3681588223,PAPAYAWHIP:4293907967,PEACHPUFF:4292524543,PERU:3448061951,PINK:4290825215,PLUM:3718307327,POWDERBLUE:2967529215,PURPLE:2147516671,REBECCAPURPLE:1714657791,RED:4278190335,ROSYBROWN:3163525119,ROYALBLUE:1097458175,SADDLEBROWN:2336560127,SALMON:4202722047,SANDYBROWN:4104413439,SEAGREEN:780883967,SEASHELL:4294307583,SIENNA:2689740287,SILVER:3233857791,SKYBLUE:2278484991,SLATEBLUE:1784335871,SLATEGRAY:1887473919,SLATEGREY:1887473919,SNOW:4294638335,SPRINGGREEN:16744447,STEELBLUE:1182971135,TAN:3535047935,TEAL:8421631,THISTLE:3636451583,TOMATO:4284696575,TRANSPARENT:0,TURQUOISE:1088475391,VIOLET:4001558271,WHEAT:4125012991,WHITE:4294967295,WHITESMOKE:4126537215,YELLOW:4294902015,YELLOWGREEN:2597139199},_t={name:"background-clip",initialValue:"border-box",prefix:!1,type:1,parse:function(e,t){return t.map((function(e){if($e(e))switch(e.value){case"padding-box":return 1;case"content-box":return 2}return 0}))}},Ct={name:"background-color",initialValue:"transparent",prefix:!1,type:3,format:"color"},xt=function(e,t){var n=ht(e,t[0]),r=t[1];return r&&Ze(r)?{color:n,stop:r}:{color:n,stop:null}},Ut=function(e,t){var n=e[0],r=e[e.length-1];null===n.stop&&(n.stop=tt),null===r.stop&&(r.stop=rt);for(var A=[],i=0,s=0;s<e.length;s++){var a=e[s].stop;if(null!==a){var o=it(a,t);o>i?A.push(o):A.push(i),i=o}else A.push(null)}var c=null;for(s=0;s<A.length;s++){var l=A[s];if(null===l)null===c&&(c=s);else if(null!==c){for(var u=s-c,h=(l-A[c-1])/(u+1),d=1;d<=u;d++)A[c+d-1]=h*d;c=null}}return e.map((function(e,n){return{color:e.color,stop:Math.max(Math.min(1,A[n]/t),0)}}))},Ft=function(e,t,n){var r="number"==typeof e?e:function(e,t,n){var r=t/2,A=n/2,i=it(e[0],t)-r,s=A-it(e[1],n);return(Math.atan2(s,i)+2*Math.PI)%(2*Math.PI)}(e,t,n),A=Math.abs(t*Math.sin(r))+Math.abs(n*Math.cos(r)),i=t/2,s=n/2,a=A/2,o=Math.sin(r-Math.PI/2)*a,c=Math.cos(r-Math.PI/2)*a;return[A,i-c,i+c,s-o,s+o]},Et=function(e,t){return Math.sqrt(e*e+t*t)},Qt=function(e,t,n,r,A){return[[0,0],[0,t],[e,0],[e,t]].reduce((function(e,t){var i=t[0],s=t[1],a=Et(n-i,r-s);return(A?a<e.optimumDistance:a>e.optimumDistance)?{optimumCorner:t,optimumDistance:a}:e}),{optimumDistance:A?1/0:-1/0,optimumCorner:null}).optimumCorner},St=function(e,t){var n=ut(180),r=[];return Je(t).forEach((function(t,A){if(0===A){var i=t[0];if(20===i.type&&-1!==["top","left","right","bottom"].indexOf(i.value))return void(n=lt(t));if(ct(i))return void(n=(ot(e,i)+ut(270))%ut(360))}var s=xt(e,t);r.push(s)})),{angle:n,stops:r,type:1}},It="closest-side",kt="farthest-side",Dt="closest-corner",Mt="farthest-corner",Tt="circle",Ot="ellipse",Lt="cover",Pt="contain",Ht=function(e,t){var n=0,r=3,A=[],i=[];return Je(t).forEach((function(t,s){var a=!0;if(0===s?a=t.reduce((function(e,t){if($e(t))switch(t.value){case"center":return i.push(nt),!1;case"top":case"left":return i.push(tt),!1;case"right":case"bottom":return i.push(rt),!1}else if(Ze(t)||Xe(t))return i.push(t),!1;return e}),a):1===s&&(a=t.reduce((function(e,t){if($e(t))switch(t.value){case Tt:return n=0,!1;case Ot:return n=1,!1;case Pt:case It:return r=0,!1;case kt:return r=1,!1;case Dt:return r=2,!1;case Lt:case Mt:return r=3,!1}else if(Xe(t)||Ze(t))return Array.isArray(r)||(r=[]),r.push(t),!1;return e}),a)),a){var o=xt(e,t);A.push(o)}})),{size:r,shape:n,stops:A,position:i,type:2}},Rt=function(e,t){if(22===t.type){var n={url:t.value,type:0};return e.cache.addImage(t.value),n}if(18===t.type){var r=Vt[t.name];if(void 0===r)throw new Error('Attempting to parse an unsupported image function "'+t.name+'"');return r(e,t.values)}throw new Error("Unsupported image type "+t.type)};var Nt,Vt={"linear-gradient":function(e,t){var n=ut(180),r=[];return Je(t).forEach((function(t,A){if(0===A){var i=t[0];if(20===i.type&&"to"===i.value)return void(n=lt(t));if(ct(i))return void(n=ot(e,i))}var s=xt(e,t);r.push(s)})),{angle:n,stops:r,type:1}},"-moz-linear-gradient":St,"-ms-linear-gradient":St,"-o-linear-gradient":St,"-webkit-linear-gradient":St,"radial-gradient":function(e,t){var n=0,r=3,A=[],i=[];return Je(t).forEach((function(t,s){var a=!0;if(0===s){var o=!1;a=t.reduce((function(e,t){if(o)if($e(t))switch(t.value){case"center":return i.push(nt),e;case"top":case"left":return i.push(tt),e;case"right":case"bottom":return i.push(rt),e}else(Ze(t)||Xe(t))&&i.push(t);else if($e(t))switch(t.value){case Tt:return n=0,!1;case Ot:return n=1,!1;case"at":return o=!0,!1;case It:return r=0,!1;case Lt:case kt:return r=1,!1;case Pt:case Dt:return r=2,!1;case Mt:return r=3,!1}else if(Xe(t)||Ze(t))return Array.isArray(r)||(r=[]),r.push(t),!1;return e}),a)}if(a){var c=xt(e,t);A.push(c)}})),{size:r,shape:n,stops:A,position:i,type:2}},"-moz-radial-gradient":Ht,"-ms-radial-gradient":Ht,"-o-radial-gradient":Ht,"-webkit-radial-gradient":Ht,"-webkit-gradient":function(e,t){var n=ut(180),r=[],A=1;return Je(t).forEach((function(t,n){var i=t[0];if(0===n){if($e(i)&&"linear"===i.value)return void(A=1);if($e(i)&&"radial"===i.value)return void(A=2)}if(18===i.type)if("from"===i.name){var s=ht(e,i.values[0]);r.push({stop:tt,color:s})}else if("to"===i.name)s=ht(e,i.values[0]),r.push({stop:rt,color:s});else if("color-stop"===i.name){var a=i.values.filter(qe);if(2===a.length){s=ht(e,a[1]);var o=a[0];je(o)&&r.push({stop:{type:16,number:100*o.number,flags:o.flags},color:s})}}})),1===A?{angle:(n+ut(180))%ut(360),stops:r,type:A}:{size:3,shape:0,stops:r,position:[],type:A}}},Kt={name:"background-image",initialValue:"none",type:1,prefix:!1,parse:function(e,t){if(0===t.length)return[];var n=t[0];return 20===n.type&&"none"===n.value?[]:t.filter((function(e){return qe(e)&&function(e){return!(20===e.type&&"none"===e.value||18===e.type&&!Vt[e.name])}(e)})).map((function(t){return Rt(e,t)}))}},jt={name:"background-origin",initialValue:"border-box",prefix:!1,type:1,parse:function(e,t){return t.map((function(e){if($e(e))switch(e.value){case"padding-box":return 1;case"content-box":return 2}return 0}))}},$t={name:"background-position",initialValue:"0% 0%",type:1,prefix:!1,parse:function(e,t){return Je(t).map((function(e){return e.filter(Ze)})).map(et)}},Gt={name:"background-repeat",initialValue:"repeat",prefix:!1,type:1,parse:function(e,t){return Je(t).map((function(e){return e.filter($e).map((function(e){return e.value})).join(" ")})).map(zt)}},zt=function(e){switch(e){case"no-repeat":return 1;case"repeat-x":case"repeat no-repeat":return 2;case"repeat-y":case"no-repeat repeat":return 3;default:return 0}};!function(e){e.AUTO="auto",e.CONTAIN="contain",e.COVER="cover"}(Nt||(Nt={}));var Wt,qt={name:"background-size",initialValue:"0",prefix:!1,type:1,parse:function(e,t){return Je(t).map((function(e){return e.filter(Jt)}))}},Jt=function(e){return $e(e)||Ze(e)},Yt=function(e){return{name:"border-"+e+"-color",initialValue:"transparent",prefix:!1,type:3,format:"color"}},Xt=Yt("top"),Zt=Yt("right"),en=Yt("bottom"),tn=Yt("left"),nn=function(e){return{name:"border-radius-"+e,initialValue:"0 0",prefix:!1,type:1,parse:function(e,t){return et(t.filter(Ze))}}},rn=nn("top-left"),An=nn("top-right"),sn=nn("bottom-right"),an=nn("bottom-left"),on=function(e){return{name:"border-"+e+"-style",initialValue:"solid",prefix:!1,type:2,parse:function(e,t){switch(t){case"none":return 0;case"dashed":return 2;case"dotted":return 3;case"double":return 4}return 1}}},cn=on("top"),ln=on("right"),un=on("bottom"),hn=on("left"),dn=function(e){return{name:"border-"+e+"-width",initialValue:"0",type:0,prefix:!1,parse:function(e,t){return Ke(t)?t.number:0}}},fn=dn("top"),pn=dn("right"),gn=dn("bottom"),mn=dn("left"),yn={name:"color",initialValue:"transparent",prefix:!1,type:3,format:"color"},wn={name:"direction",initialValue:"ltr",prefix:!1,type:2,parse:function(e,t){return"rtl"===t?1:0}},vn={name:"display",initialValue:"inline-block",prefix:!1,type:1,parse:function(e,t){return t.filter($e).reduce((function(e,t){return e|Bn(t.value)}),0)}},Bn=function(e){switch(e){case"block":case"-webkit-box":return 2;case"inline":return 4;case"run-in":return 8;case"flow":return 16;case"flow-root":return 32;case"table":return 64;case"flex":case"-webkit-flex":return 128;case"grid":case"-ms-grid":return 256;case"ruby":return 512;case"subgrid":return 1024;case"list-item":return 2048;case"table-row-group":return 4096;case"table-header-group":return 8192;case"table-footer-group":return 16384;case"table-row":return 32768;case"table-cell":return 65536;case"table-column-group":return 131072;case"table-column":return 262144;case"table-caption":return 524288;case"ruby-base":return 1048576;case"ruby-text":return 2097152;case"ruby-base-container":return 4194304;case"ruby-text-container":return 8388608;case"contents":return 16777216;case"inline-block":return 33554432;case"inline-list-item":return 67108864;case"inline-table":return 134217728;case"inline-flex":return 268435456;case"inline-grid":return 536870912}return 0},bn={name:"float",initialValue:"none",prefix:!1,type:2,parse:function(e,t){switch(t){case"left":return 1;case"right":return 2;case"inline-start":return 3;case"inline-end":return 4}return 0}},_n={name:"letter-spacing",initialValue:"0",prefix:!1,type:0,parse:function(e,t){return 20===t.type&&"normal"===t.value?0:17===t.type||15===t.type?t.number:0}};!function(e){e.NORMAL="normal",e.STRICT="strict"}(Wt||(Wt={}));var Cn,xn={name:"line-break",initialValue:"normal",prefix:!1,type:2,parse:function(e,t){return"strict"===t?Wt.STRICT:Wt.NORMAL}},Un={name:"line-height",initialValue:"normal",prefix:!1,type:4},Fn=function(e,t){return $e(e)&&"normal"===e.value?1.2*t:17===e.type?t*e.number:Ze(e)?it(e,t):t},En={name:"list-style-image",initialValue:"none",type:0,prefix:!1,parse:function(e,t){return 20===t.type&&"none"===t.value?null:Rt(e,t)}},Qn={name:"list-style-position",initialValue:"outside",prefix:!1,type:2,parse:function(e,t){return"inside"===t?0:1}},Sn={name:"list-style-type",initialValue:"none",prefix:!1,type:2,parse:function(e,t){switch(t){case"disc":return 0;case"circle":return 1;case"square":return 2;case"decimal":return 3;case"cjk-decimal":return 4;case"decimal-leading-zero":return 5;case"lower-roman":return 6;case"upper-roman":return 7;case"lower-greek":return 8;case"lower-alpha":return 9;case"upper-alpha":return 10;case"arabic-indic":return 11;case"armenian":return 12;case"bengali":return 13;case"cambodian":return 14;case"cjk-earthly-branch":return 15;case"cjk-heavenly-stem":return 16;case"cjk-ideographic":return 17;case"devanagari":return 18;case"ethiopic-numeric":return 19;case"georgian":return 20;case"gujarati":return 21;case"gurmukhi":case"hebrew":return 22;case"hiragana":return 23;case"hiragana-iroha":return 24;case"japanese-formal":return 25;case"japanese-informal":return 26;case"kannada":return 27;case"katakana":return 28;case"katakana-iroha":return 29;case"khmer":return 30;case"korean-hangul-formal":return 31;case"korean-hanja-formal":return 32;case"korean-hanja-informal":return 33;case"lao":return 34;case"lower-armenian":return 35;case"malayalam":return 36;case"mongolian":return 37;case"myanmar":return 38;case"oriya":return 39;case"persian":return 40;case"simp-chinese-formal":return 41;case"simp-chinese-informal":return 42;case"tamil":return 43;case"telugu":return 44;case"thai":return 45;case"tibetan":return 46;case"trad-chinese-formal":return 47;case"trad-chinese-informal":return 48;case"upper-armenian":return 49;case"disclosure-open":return 50;case"disclosure-closed":return 51;default:return-1}}},In=function(e){return{name:"margin-"+e,initialValue:"0",prefix:!1,type:4}},kn=In("top"),Dn=In("right"),Mn=In("bottom"),Tn=In("left"),On={name:"overflow",initialValue:"visible",prefix:!1,type:1,parse:function(e,t){return t.filter($e).map((function(e){switch(e.value){case"hidden":return 1;case"scroll":return 2;case"clip":return 3;case"auto":return 4;default:return 0}}))}},Ln={name:"overflow-wrap",initialValue:"normal",prefix:!1,type:2,parse:function(e,t){return"break-word"===t?"break-word":"normal"}},Pn=function(e){return{name:"padding-"+e,initialValue:"0",prefix:!1,type:3,format:"length-percentage"}},Hn=Pn("top"),Rn=Pn("right"),Nn=Pn("bottom"),Vn=Pn("left"),Kn={name:"text-align",initialValue:"left",prefix:!1,type:2,parse:function(e,t){switch(t){case"right":return 2;case"center":case"justify":return 1;default:return 0}}},jn={name:"position",initialValue:"static",prefix:!1,type:2,parse:function(e,t){switch(t){case"relative":return 1;case"absolute":return 2;case"fixed":return 3;case"sticky":return 4}return 0}},$n={name:"text-shadow",initialValue:"none",type:1,prefix:!1,parse:function(e,t){return 1===t.length&&ze(t[0],"none")?[]:Je(t).map((function(t){for(var n={color:bt.TRANSPARENT,offsetX:tt,offsetY:tt,blur:tt},r=0,A=0;A<t.length;A++){var i=t[A];Xe(i)?(0===r?n.offsetX=i:1===r?n.offsetY=i:n.blur=i,r++):n.color=ht(e,i)}return n}))}},Gn={name:"text-transform",initialValue:"none",prefix:!1,type:2,parse:function(e,t){switch(t){case"uppercase":return 2;case"lowercase":return 1;case"capitalize":return 3}return 0}},zn={name:"transform",initialValue:"none",prefix:!0,type:0,parse:function(e,t){if(20===t.type&&"none"===t.value)return null;if(18===t.type){var n=Wn[t.name];if(void 0===n)throw new Error('Attempting to parse an unsupported transform function "'+t.name+'"');return n(t.values)}return null}},Wn={matrix:function(e){var t=e.filter((function(e){return 17===e.type})).map((function(e){return e.number}));return 6===t.length?t:null},matrix3d:function(e){var t=e.filter((function(e){return 17===e.type})).map((function(e){return e.number})),n=t[0],r=t[1];t[2],t[3];var A=t[4],i=t[5];t[6],t[7],t[8],t[9],t[10],t[11];var s=t[12],a=t[13];return t[14],t[15],16===t.length?[n,r,A,i,s,a]:null}},qn={type:16,number:50,flags:4},Jn=[qn,qn],Yn={name:"transform-origin",initialValue:"50% 50%",prefix:!0,type:1,parse:function(e,t){var n=t.filter(Ze);return 2!==n.length?Jn:[n[0],n[1]]}},Xn={name:"visible",initialValue:"none",prefix:!1,type:2,parse:function(e,t){switch(t){case"hidden":return 1;case"collapse":return 2;default:return 0}}};!function(e){e.NORMAL="normal",e.BREAK_ALL="break-all",e.KEEP_ALL="keep-all"}(Cn||(Cn={}));for(var Zn={name:"word-break",initialValue:"normal",prefix:!1,type:2,parse:function(e,t){switch(t){case"break-all":return Cn.BREAK_ALL;case"keep-all":return Cn.KEEP_ALL;default:return Cn.NORMAL}}},er={name:"z-index",initialValue:"auto",prefix:!1,type:0,parse:function(e,t){if(20===t.type)return{auto:!0,order:0};if(je(t))return{auto:!1,order:t.number};throw new Error("Invalid z-index number parsed")}},tr={name:"time",parse:function(e,t){if(15===t.type)switch(t.unit.toLowerCase()){case"s":return 1e3*t.number;case"ms":return t.number}throw new Error("Unsupported time type")}},nr={name:"opacity",initialValue:"1",type:0,prefix:!1,parse:function(e,t){return je(t)?t.number:1}},rr={name:"text-decoration-color",initialValue:"transparent",prefix:!1,type:3,format:"color"},Ar={name:"text-decoration-line",initialValue:"none",prefix:!1,type:1,parse:function(e,t){return t.filter($e).map((function(e){switch(e.value){case"underline":return 1;case"overline":return 2;case"line-through":return 3;case"none":return 4}return 0})).filter((function(e){return 0!==e}))}},ir={name:"font-family",initialValue:"",prefix:!1,type:1,parse:function(e,t){var n=[],r=[];return t.forEach((function(e){switch(e.type){case 20:case 0:n.push(e.value);break;case 17:n.push(e.number.toString());break;case 4:r.push(n.join(" ")),n.length=0}})),n.length&&r.push(n.join(" ")),r.map((function(e){return-1===e.indexOf(" ")?e:"'"+e+"'"}))}},sr={name:"font-size",initialValue:"0",prefix:!1,type:3,format:"length"},ar={name:"font-weight",initialValue:"normal",type:0,prefix:!1,parse:function(e,t){return je(t)?t.number:$e(t)&&"bold"===t.value?700:400}},or={name:"font-variant",initialValue:"none",type:1,prefix:!1,parse:function(e,t){return t.filter($e).map((function(e){return e.value}))}},cr={name:"font-style",initialValue:"normal",prefix:!1,type:2,parse:function(e,t){switch(t){case"oblique":return"oblique";case"italic":return"italic";default:return"normal"}}},lr=function(e,t){return!!(e&t)},ur={name:"content",initialValue:"none",type:1,prefix:!1,parse:function(e,t){if(0===t.length)return[];var n=t[0];return 20===n.type&&"none"===n.value?[]:t}},hr={name:"counter-increment",initialValue:"none",prefix:!0,type:1,parse:function(e,t){if(0===t.length)return null;var n=t[0];if(20===n.type&&"none"===n.value)return null;for(var r=[],A=t.filter(We),i=0;i<A.length;i++){var s=A[i],a=A[i+1];if(20===s.type){var o=a&&je(a)?a.number:1;r.push({counter:s.value,increment:o})}}return r}},dr={name:"counter-reset",initialValue:"none",prefix:!0,type:1,parse:function(e,t){if(0===t.length)return[];for(var n=[],r=t.filter(We),A=0;A<r.length;A++){var i=r[A],s=r[A+1];if($e(i)&&"none"!==i.value){var a=s&&je(s)?s.number:0;n.push({counter:i.value,reset:a})}}return n}},fr={name:"duration",initialValue:"0s",prefix:!1,type:1,parse:function(e,t){return t.filter(Ke).map((function(t){return tr.parse(e,t)}))}},pr={name:"quotes",initialValue:"none",prefix:!0,type:1,parse:function(e,t){if(0===t.length)return null;var n=t[0];if(20===n.type&&"none"===n.value)return null;var r=[],A=t.filter(Ge);if(A.length%2!=0)return null;for(var i=0;i<A.length;i+=2){var s=A[i].value,a=A[i+1].value;r.push({open:s,close:a})}return r}},gr=function(e,t,n){if(!e)return"";var r=e[Math.min(t,e.length-1)];return r?n?r.open:r.close:""},mr={name:"box-shadow",initialValue:"none",type:1,prefix:!1,parse:function(e,t){return 1===t.length&&ze(t[0],"none")?[]:Je(t).map((function(t){for(var n={color:255,offsetX:tt,offsetY:tt,blur:tt,spread:tt,inset:!1},r=0,A=0;A<t.length;A++){var i=t[A];ze(i,"inset")?n.inset=!0:Xe(i)?(0===r?n.offsetX=i:1===r?n.offsetY=i:2===r?n.blur=i:n.spread=i,r++):n.color=ht(e,i)}return n}))}},yr={name:"paint-order",initialValue:"normal",prefix:!1,type:1,parse:function(e,t){var n=[];return t.filter($e).forEach((function(e){switch(e.value){case"stroke":n.push(1);break;case"fill":n.push(0);break;case"markers":n.push(2)}})),[0,1,2].forEach((function(e){-1===n.indexOf(e)&&n.push(e)})),n}},wr={name:"-webkit-text-stroke-color",initialValue:"currentcolor",prefix:!1,type:3,format:"color"},vr={name:"-webkit-text-stroke-width",initialValue:"0",type:0,prefix:!1,parse:function(e,t){return Ke(t)?t.number:0}},Br=function(){function e(e,t){var n,r;this.animationDuration=Cr(e,fr,t.animationDuration),this.backgroundClip=Cr(e,_t,t.backgroundClip),this.backgroundColor=Cr(e,Ct,t.backgroundColor),this.backgroundImage=Cr(e,Kt,t.backgroundImage),this.backgroundOrigin=Cr(e,jt,t.backgroundOrigin),this.backgroundPosition=Cr(e,$t,t.backgroundPosition),this.backgroundRepeat=Cr(e,Gt,t.backgroundRepeat),this.backgroundSize=Cr(e,qt,t.backgroundSize),this.borderTopColor=Cr(e,Xt,t.borderTopColor),this.borderRightColor=Cr(e,Zt,t.borderRightColor),this.borderBottomColor=Cr(e,en,t.borderBottomColor),this.borderLeftColor=Cr(e,tn,t.borderLeftColor),this.borderTopLeftRadius=Cr(e,rn,t.borderTopLeftRadius),this.borderTopRightRadius=Cr(e,An,t.borderTopRightRadius),this.borderBottomRightRadius=Cr(e,sn,t.borderBottomRightRadius),this.borderBottomLeftRadius=Cr(e,an,t.borderBottomLeftRadius),this.borderTopStyle=Cr(e,cn,t.borderTopStyle),this.borderRightStyle=Cr(e,ln,t.borderRightStyle),this.borderBottomStyle=Cr(e,un,t.borderBottomStyle),this.borderLeftStyle=Cr(e,hn,t.borderLeftStyle),this.borderTopWidth=Cr(e,fn,t.borderTopWidth),this.borderRightWidth=Cr(e,pn,t.borderRightWidth),this.borderBottomWidth=Cr(e,gn,t.borderBottomWidth),this.borderLeftWidth=Cr(e,mn,t.borderLeftWidth),this.boxShadow=Cr(e,mr,t.boxShadow),this.color=Cr(e,yn,t.color),this.direction=Cr(e,wn,t.direction),this.display=Cr(e,vn,t.display),this.float=Cr(e,bn,t.cssFloat),this.fontFamily=Cr(e,ir,t.fontFamily),this.fontSize=Cr(e,sr,t.fontSize),this.fontStyle=Cr(e,cr,t.fontStyle),this.fontVariant=Cr(e,or,t.fontVariant),this.fontWeight=Cr(e,ar,t.fontWeight),this.letterSpacing=Cr(e,_n,t.letterSpacing),this.lineBreak=Cr(e,xn,t.lineBreak),this.lineHeight=Cr(e,Un,t.lineHeight),this.listStyleImage=Cr(e,En,t.listStyleImage),this.listStylePosition=Cr(e,Qn,t.listStylePosition),this.listStyleType=Cr(e,Sn,t.listStyleType),this.marginTop=Cr(e,kn,t.marginTop),this.marginRight=Cr(e,Dn,t.marginRight),this.marginBottom=Cr(e,Mn,t.marginBottom),this.marginLeft=Cr(e,Tn,t.marginLeft),this.opacity=Cr(e,nr,t.opacity);var A=Cr(e,On,t.overflow);this.overflowX=A[0],this.overflowY=A[A.length>1?1:0],this.overflowWrap=Cr(e,Ln,t.overflowWrap),this.paddingTop=Cr(e,Hn,t.paddingTop),this.paddingRight=Cr(e,Rn,t.paddingRight),this.paddingBottom=Cr(e,Nn,t.paddingBottom),this.paddingLeft=Cr(e,Vn,t.paddingLeft),this.paintOrder=Cr(e,yr,t.paintOrder),this.position=Cr(e,jn,t.position),this.textAlign=Cr(e,Kn,t.textAlign),this.textDecorationColor=Cr(e,rr,null!==(n=t.textDecorationColor)&&void 0!==n?n:t.color),this.textDecorationLine=Cr(e,Ar,null!==(r=t.textDecorationLine)&&void 0!==r?r:t.textDecoration),this.textShadow=Cr(e,$n,t.textShadow),this.textTransform=Cr(e,Gn,t.textTransform),this.transform=Cr(e,zn,t.transform),this.transformOrigin=Cr(e,Yn,t.transformOrigin),this.visibility=Cr(e,Xn,t.visibility),this.webkitTextStrokeColor=Cr(e,wr,t.webkitTextStrokeColor),this.webkitTextStrokeWidth=Cr(e,vr,t.webkitTextStrokeWidth),this.wordBreak=Cr(e,Zn,t.wordBreak),this.zIndex=Cr(e,er,t.zIndex)}return e.prototype.isVisible=function(){return this.display>0&&this.opacity>0&&0===this.visibility},e.prototype.isTransparent=function(){return dt(this.backgroundColor)},e.prototype.isTransformed=function(){return null!==this.transform},e.prototype.isPositioned=function(){return 0!==this.position},e.prototype.isPositionedWithZIndex=function(){return this.isPositioned()&&!this.zIndex.auto},e.prototype.isFloating=function(){return 0!==this.float},e.prototype.isInlineLevel=function(){return lr(this.display,4)||lr(this.display,33554432)||lr(this.display,268435456)||lr(this.display,536870912)||lr(this.display,67108864)||lr(this.display,134217728)},e}(),br=function(e,t){this.content=Cr(e,ur,t.content),this.quotes=Cr(e,pr,t.quotes)},_r=function(e,t){this.counterIncrement=Cr(e,hr,t.counterIncrement),this.counterReset=Cr(e,dr,t.counterReset)},Cr=function(e,t,n){var r=new Ne,A=null!=n?n.toString():t.initialValue;r.write(A);var i=new Ve(r.read());switch(t.type){case 2:var s=i.parseComponentValue();return t.parse(e,$e(s)?s.value:t.initialValue);case 0:return t.parse(e,i.parseComponentValue());case 1:return t.parse(e,i.parseComponentValues());case 4:return i.parseComponentValue();case 3:switch(t.format){case"angle":return ot(e,i.parseComponentValue());case"color":return ht(e,i.parseComponentValue());case"image":return Rt(e,i.parseComponentValue());case"length":var a=i.parseComponentValue();return Xe(a)?a:tt;case"length-percentage":var o=i.parseComponentValue();return Ze(o)?o:tt;case"time":return tr.parse(e,i.parseComponentValue())}}},xr=function(e,t){var n=function(e){switch(e.getAttribute("data-html2canvas-debug")){case"all":return 1;case"clone":return 2;case"parse":return 3;case"render":return 4;default:return 0}}(e);return 1===n||t===n},Ur=function(e,t){this.context=e,this.textNodes=[],this.elements=[],this.flags=0,xr(t,3),this.styles=new Br(e,window.getComputedStyle(t,null)),SA(t)&&(this.styles.animationDuration.some((function(e){return e>0}))&&(t.style.animationDuration="0s"),null!==this.styles.transform&&(t.style.transform="none")),this.bounds=a(this.context,t),xr(t,4)&&(this.flags|=16)},Fr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",Er="undefined"==typeof Uint8Array?[]:new Uint8Array(256),Qr=0;Qr<64;Qr++)Er[Fr.charCodeAt(Qr)]=Qr;for(var Sr=function(e,t,n){return e.slice?e.slice(t,n):new Uint16Array(Array.prototype.slice.call(e,t,n))},Ir=function(){function e(e,t,n,r,A,i){this.initialValue=e,this.errorValue=t,this.highStart=n,this.highValueIndex=r,this.index=A,this.data=i}return e.prototype.get=function(e){var t;if(e>=0){if(e<55296||e>56319&&e<=65535)return t=((t=this.index[e>>5])<<2)+(31&e),this.data[t];if(e<=65535)return t=((t=this.index[2048+(e-55296>>5)])<<2)+(31&e),this.data[t];if(e<this.highStart)return t=2080+(e>>11),t=this.index[t],t+=e>>5&63,t=((t=this.index[t])<<2)+(31&e),this.data[t];if(e<=1114111)return this.data[this.highValueIndex]}return this.errorValue},e}(),kr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",Dr="undefined"==typeof Uint8Array?[]:new Uint8Array(256),Mr=0;Mr<64;Mr++)Dr[kr.charCodeAt(Mr)]=Mr;var Tr,Or=8,Lr=9,Pr=11,Hr=12,Rr=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];if(String.fromCodePoint)return String.fromCodePoint.apply(String,e);var n=e.length;if(!n)return"";for(var r=[],A=-1,i="";++A<n;){var s=e[A];s<=65535?r.push(s):(s-=65536,r.push(55296+(s>>10),s%1024+56320)),(A+1===n||r.length>16384)&&(i+=String.fromCharCode.apply(String,r),r.length=0)}return i},Nr=function(e){var t,n,r,A=function(e){var t,n,r,A,i,s=.75*e.length,a=e.length,o=0;"="===e[e.length-1]&&(s--,"="===e[e.length-2]&&s--);var c="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array&&void 0!==Uint8Array.prototype.slice?new ArrayBuffer(s):new Array(s),l=Array.isArray(c)?c:new Uint8Array(c);for(t=0;t<a;t+=4)n=Er[e.charCodeAt(t)],r=Er[e.charCodeAt(t+1)],A=Er[e.charCodeAt(t+2)],i=Er[e.charCodeAt(t+3)],l[o++]=n<<2|r>>4,l[o++]=(15&r)<<4|A>>2,l[o++]=(3&A)<<6|63&i;return c}(e),i=Array.isArray(A)?function(e){for(var t=e.length,n=[],r=0;r<t;r+=4)n.push(e[r+3]<<24|e[r+2]<<16|e[r+1]<<8|e[r]);return n}(A):new Uint32Array(A),s=Array.isArray(A)?function(e){for(var t=e.length,n=[],r=0;r<t;r+=2)n.push(e[r+1]<<8|e[r]);return n}(A):new Uint16Array(A),a=Sr(s,12,i[4]/2),o=2===i[5]?Sr(s,(24+i[4])/2):(t=i,n=Math.ceil((24+i[4])/4),t.slice?t.slice(n,r):new Uint32Array(Array.prototype.slice.call(t,n,r)));return new Ir(i[0],i[1],i[2],i[3],a,o)}("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"),Vr="×",Kr=function(e){return Nr.get(e)},jr=function(e,t,n){var r=n-2,A=t[r],i=t[n-1],s=t[n];if(2===i&&3===s)return Vr;if(2===i||3===i||4===i)return"÷";if(2===s||3===s||4===s)return"÷";if(i===Or&&-1!==[Or,Lr,Pr,Hr].indexOf(s))return Vr;if(!(i!==Pr&&i!==Lr||s!==Lr&&10!==s))return Vr;if((i===Hr||10===i)&&10===s)return Vr;if(13===s||5===s)return Vr;if(7===s)return Vr;if(1===i)return Vr;if(13===i&&14===s){for(;5===A;)A=t[--r];if(14===A)return Vr}if(15===i&&15===s){for(var a=0;15===A;)a++,A=t[--r];if(a%2==0)return Vr}return"÷"},$r=function(e){var t=function(e){for(var t=[],n=0,r=e.length;n<r;){var A=e.charCodeAt(n++);if(A>=55296&&A<=56319&&n<r){var i=e.charCodeAt(n++);56320==(64512&i)?t.push(((1023&A)<<10)+(1023&i)+65536):(t.push(A),n--)}else t.push(A)}return t}(e),n=t.length,r=0,A=0,i=t.map(Kr);return{next:function(){if(r>=n)return{done:!0,value:null};for(var e=Vr;r<n&&(e=jr(0,i,++r))===Vr;);if(e!==Vr||r===n){var s=Rr.apply(null,t.slice(A,r));return A=r,{value:s,done:!1}}return{done:!0,value:null}}}},Gr=function(e){return 0===e[0]&&255===e[1]&&0===e[2]&&255===e[3]},zr=function(e,t,n,r,A){var i="http://www.w3.org/2000/svg",s=document.createElementNS(i,"svg"),a=document.createElementNS(i,"foreignObject");return s.setAttributeNS(null,"width",e.toString()),s.setAttributeNS(null,"height",t.toString()),a.setAttributeNS(null,"width","100%"),a.setAttributeNS(null,"height","100%"),a.setAttributeNS(null,"x",n.toString()),a.setAttributeNS(null,"y",r.toString()),a.setAttributeNS(null,"externalResourcesRequired","true"),s.appendChild(a),a.appendChild(A),s},Wr=function(e){return new Promise((function(t,n){var r=new Image;r.onload=function(){return t(r)},r.onerror=n,r.src="data:image/svg+xml;charset=utf-8,"+encodeURIComponent((new XMLSerializer).serializeToString(e))}))},qr={get SUPPORT_RANGE_BOUNDS(){var e=function(e){if(e.createRange){var t=e.createRange();if(t.getBoundingClientRect){var n=e.createElement("boundtest");n.style.height="123px",n.style.display="block",e.body.appendChild(n),t.selectNode(n);var r=t.getBoundingClientRect(),A=Math.round(r.height);if(e.body.removeChild(n),123===A)return!0}}return!1}(document);return Object.defineProperty(qr,"SUPPORT_RANGE_BOUNDS",{value:e}),e},get SUPPORT_WORD_BREAKING(){var e=qr.SUPPORT_RANGE_BOUNDS&&function(e){var t=e.createElement("boundtest");t.style.width="50px",t.style.display="block",t.style.fontSize="12px",t.style.letterSpacing="0px",t.style.wordSpacing="0px",e.body.appendChild(t);var n=e.createRange();t.innerHTML="function"==typeof"".repeat?"&#128104;".repeat(10):"";var r=t.firstChild,A=o(r.data).map((function(e){return c(e)})),i=0,s={},a=A.every((function(e,t){n.setStart(r,i),n.setEnd(r,i+e.length);var A=n.getBoundingClientRect();i+=e.length;var a=A.x>s.x||A.y>s.y;return s=A,0===t||a}));return e.body.removeChild(t),a}(document);return Object.defineProperty(qr,"SUPPORT_WORD_BREAKING",{value:e}),e},get SUPPORT_SVG_DRAWING(){var e=function(e){var t=new Image,n=e.createElement("canvas"),r=n.getContext("2d");if(!r)return!1;t.src="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg'></svg>";try{r.drawImage(t,0,0),n.toDataURL()}catch(e){return!1}return!0}(document);return Object.defineProperty(qr,"SUPPORT_SVG_DRAWING",{value:e}),e},get SUPPORT_FOREIGNOBJECT_DRAWING(){var e="function"==typeof Array.from&&"function"==typeof window.fetch?function(e){var t=e.createElement("canvas"),n=100;t.width=n,t.height=n;var r=t.getContext("2d");if(!r)return Promise.reject(!1);r.fillStyle="rgb(0, 255, 0)",r.fillRect(0,0,n,n);var A=new Image,i=t.toDataURL();A.src=i;var s=zr(n,n,0,0,A);return r.fillStyle="red",r.fillRect(0,0,n,n),Wr(s).then((function(t){r.drawImage(t,0,0);var A=r.getImageData(0,0,n,n).data;r.fillStyle="red",r.fillRect(0,0,n,n);var s=e.createElement("div");return s.style.backgroundImage="url("+i+")",s.style.height=n+"px",Gr(A)?Wr(zr(n,n,0,0,s)):Promise.reject(!1)})).then((function(e){return r.drawImage(e,0,0),Gr(r.getImageData(0,0,n,n).data)})).catch((function(){return!1}))}(document):Promise.resolve(!1);return Object.defineProperty(qr,"SUPPORT_FOREIGNOBJECT_DRAWING",{value:e}),e},get SUPPORT_CORS_IMAGES(){var e=void 0!==(new Image).crossOrigin;return Object.defineProperty(qr,"SUPPORT_CORS_IMAGES",{value:e}),e},get SUPPORT_RESPONSE_TYPE(){var e="string"==typeof(new XMLHttpRequest).responseType;return Object.defineProperty(qr,"SUPPORT_RESPONSE_TYPE",{value:e}),e},get SUPPORT_CORS_XHR(){var e="withCredentials"in new XMLHttpRequest;return Object.defineProperty(qr,"SUPPORT_CORS_XHR",{value:e}),e},get SUPPORT_NATIVE_TEXT_SEGMENTATION(){var e=!("undefined"==typeof Intl||!Intl.Segmenter);return Object.defineProperty(qr,"SUPPORT_NATIVE_TEXT_SEGMENTATION",{value:e}),e}},Jr=function(e,t){this.text=e,this.bounds=t},Yr=function(e,t){var n=t.ownerDocument;if(n){var r=n.createElement("html2canvaswrapper");r.appendChild(t.cloneNode(!0));var A=t.parentNode;if(A){A.replaceChild(r,t);var i=a(e,r);return r.firstChild&&A.replaceChild(r.firstChild,r),i}}return s.EMPTY},Xr=function(e,t,n){var r=e.ownerDocument;if(!r)throw new Error("Node has no owner document");var A=r.createRange();return A.setStart(e,t),A.setEnd(e,t+n),A},Zr=function(e){if(qr.SUPPORT_NATIVE_TEXT_SEGMENTATION){var t=new Intl.Segmenter(void 0,{granularity:"grapheme"});return Array.from(t.segment(e)).map((function(e){return e.segment}))}return function(e){for(var t,n=$r(e),r=[];!(t=n.next()).done;)t.value&&r.push(t.value.slice());return r}(e)},eA=function(e,t){return 0!==t.letterSpacing?Zr(e):function(e,t){if(qr.SUPPORT_NATIVE_TEXT_SEGMENTATION){var n=new Intl.Segmenter(void 0,{granularity:"word"});return Array.from(n.segment(e)).map((function(e){return e.segment}))}return nA(e,t)}(e,t)},tA=[32,160,4961,65792,65793,4153,4241],nA=function(e,t){for(var n,r=function(e,t){var n=o(e),r=ie(n,t),A=r[0],i=r[1],s=r[2],a=n.length,c=0,l=0;return{next:function(){if(l>=a)return{done:!0,value:null};for(var e=G;l<a&&(e=Ae(n,i,A,++l,s))===G;);if(e!==G||l===a){var t=new se(n,e,c,l);return c=l,{value:t,done:!1}}return{done:!0,value:null}}}}(e,{lineBreak:t.lineBreak,wordBreak:"break-word"===t.overflowWrap?"break-word":t.wordBreak}),A=[],i=function(){if(n.value){var e=n.value.slice(),t=o(e),r="";t.forEach((function(e){-1===tA.indexOf(e)?r+=c(e):(r.length&&A.push(r),A.push(c(e)),r="")})),r.length&&A.push(r)}};!(n=r.next()).done;)i();return A},rA=function(e,t,n){this.text=AA(t.data,n.textTransform),this.textBounds=function(e,t,n,r){var A=eA(t,n),i=[],a=0;return A.forEach((function(t){if(n.textDecorationLine.length||t.trim().length>0)if(qr.SUPPORT_RANGE_BOUNDS){var A=Xr(r,a,t.length).getClientRects();if(A.length>1){var o=Zr(t),c=0;o.forEach((function(t){i.push(new Jr(t,s.fromDOMRectList(e,Xr(r,c+a,t.length).getClientRects()))),c+=t.length}))}else i.push(new Jr(t,s.fromDOMRectList(e,A)))}else{var l=r.splitText(t.length);i.push(new Jr(t,Yr(e,r))),r=l}else qr.SUPPORT_RANGE_BOUNDS||(r=r.splitText(t.length));a+=t.length})),i}(e,this.text,n,t)},AA=function(e,t){switch(t){case 1:return e.toLowerCase();case 3:return e.replace(iA,sA);case 2:return e.toUpperCase();default:return e}},iA=/(^|\s|:|-|\(|\))([a-z])/g,sA=function(e,t,n){return e.length>0?t+n.toUpperCase():e},aA=function(e){function n(t,n){var r=e.call(this,t,n)||this;return r.src=n.currentSrc||n.src,r.intrinsicWidth=n.naturalWidth,r.intrinsicHeight=n.naturalHeight,r.context.cache.addImage(r.src),r}return t(n,e),n}(Ur),oA=function(e){function n(t,n){var r=e.call(this,t,n)||this;return r.canvas=n,r.intrinsicWidth=n.width,r.intrinsicHeight=n.height,r}return t(n,e),n}(Ur),cA=function(e){function n(t,n){var r=e.call(this,t,n)||this,A=new XMLSerializer,i=a(t,n);return n.setAttribute("width",i.width+"px"),n.setAttribute("height",i.height+"px"),r.svg="data:image/svg+xml,"+encodeURIComponent(A.serializeToString(n)),r.intrinsicWidth=n.width.baseVal.value,r.intrinsicHeight=n.height.baseVal.value,r.context.cache.addImage(r.svg),r}return t(n,e),n}(Ur),lA=function(e){function n(t,n){var r=e.call(this,t,n)||this;return r.value=n.value,r}return t(n,e),n}(Ur),uA=function(e){function n(t,n){var r=e.call(this,t,n)||this;return r.start=n.start,r.reversed="boolean"==typeof n.reversed&&!0===n.reversed,r}return t(n,e),n}(Ur),hA=[{type:15,flags:0,unit:"px",number:3}],dA=[{type:16,flags:0,number:50}],fA="checkbox",pA="radio",gA="password",mA=707406591,yA=function(e){function n(t,n){var r,A,i,a=e.call(this,t,n)||this;switch(a.type=n.type.toLowerCase(),a.checked=n.checked,a.value=0===(i=(A=n).type===gA?new Array(A.value.length+1).join("•"):A.value).length?A.placeholder||"":i,a.type!==fA&&a.type!==pA||(a.styles.backgroundColor=3739148031,a.styles.borderTopColor=a.styles.borderRightColor=a.styles.borderBottomColor=a.styles.borderLeftColor=2779096575,a.styles.borderTopWidth=a.styles.borderRightWidth=a.styles.borderBottomWidth=a.styles.borderLeftWidth=1,a.styles.borderTopStyle=a.styles.borderRightStyle=a.styles.borderBottomStyle=a.styles.borderLeftStyle=1,a.styles.backgroundClip=[0],a.styles.backgroundOrigin=[0],a.bounds=(r=a.bounds).width>r.height?new s(r.left+(r.width-r.height)/2,r.top,r.height,r.height):r.width<r.height?new s(r.left,r.top+(r.height-r.width)/2,r.width,r.width):r),a.type){case fA:a.styles.borderTopRightRadius=a.styles.borderTopLeftRadius=a.styles.borderBottomRightRadius=a.styles.borderBottomLeftRadius=hA;break;case pA:a.styles.borderTopRightRadius=a.styles.borderTopLeftRadius=a.styles.borderBottomRightRadius=a.styles.borderBottomLeftRadius=dA}return a}return t(n,e),n}(Ur),wA=function(e){function n(t,n){var r=e.call(this,t,n)||this,A=n.options[n.selectedIndex||0];return r.value=A&&A.text||"",r}return t(n,e),n}(Ur),vA=function(e){function n(t,n){var r=e.call(this,t,n)||this;return r.value=n.value,r}return t(n,e),n}(Ur),BA=function(e){function n(t,n){var r=e.call(this,t,n)||this;r.src=n.src,r.width=parseInt(n.width,10)||0,r.height=parseInt(n.height,10)||0,r.backgroundColor=r.styles.backgroundColor;try{if(n.contentWindow&&n.contentWindow.document&&n.contentWindow.document.documentElement){r.tree=xA(t,n.contentWindow.document.documentElement);var A=n.contentWindow.document.documentElement?Bt(t,getComputedStyle(n.contentWindow.document.documentElement).backgroundColor):bt.TRANSPARENT,i=n.contentWindow.document.body?Bt(t,getComputedStyle(n.contentWindow.document.body).backgroundColor):bt.TRANSPARENT;r.backgroundColor=dt(A)?dt(i)?r.styles.backgroundColor:i:A}}catch(e){}return r}return t(n,e),n}(Ur),bA=["OL","UL","MENU"],_A=function(e,t,n,r){for(var A=t.firstChild,i=void 0;A;A=i)if(i=A.nextSibling,EA(A)&&A.data.trim().length>0)n.textNodes.push(new rA(e,A,n.styles));else if(QA(A))if(jA(A)&&A.assignedNodes)A.assignedNodes().forEach((function(t){return _A(e,t,n,r)}));else{var s=CA(e,A);s.styles.isVisible()&&(UA(A,s,r)?s.flags|=4:FA(s.styles)&&(s.flags|=2),-1!==bA.indexOf(A.tagName)&&(s.flags|=8),n.elements.push(s),A.slot,A.shadowRoot?_A(e,A.shadowRoot,s,r):VA(A)||TA(A)||KA(A)||_A(e,A,s,r))}},CA=function(e,t){return HA(t)?new aA(e,t):LA(t)?new oA(e,t):TA(t)?new cA(e,t):kA(t)?new lA(e,t):DA(t)?new uA(e,t):MA(t)?new yA(e,t):KA(t)?new wA(e,t):VA(t)?new vA(e,t):RA(t)?new BA(e,t):new Ur(e,t)},xA=function(e,t){var n=CA(e,t);return n.flags|=4,_A(e,t,n,n),n},UA=function(e,t,n){return t.styles.isPositionedWithZIndex()||t.styles.opacity<1||t.styles.isTransformed()||OA(e)&&n.styles.isTransparent()},FA=function(e){return e.isPositioned()||e.isFloating()},EA=function(e){return e.nodeType===Node.TEXT_NODE},QA=function(e){return e.nodeType===Node.ELEMENT_NODE},SA=function(e){return QA(e)&&void 0!==e.style&&!IA(e)},IA=function(e){return"object"==typeof e.className},kA=function(e){return"LI"===e.tagName},DA=function(e){return"OL"===e.tagName},MA=function(e){return"INPUT"===e.tagName},TA=function(e){return"svg"===e.tagName},OA=function(e){return"BODY"===e.tagName},LA=function(e){return"CANVAS"===e.tagName},PA=function(e){return"VIDEO"===e.tagName},HA=function(e){return"IMG"===e.tagName},RA=function(e){return"IFRAME"===e.tagName},NA=function(e){return"STYLE"===e.tagName},VA=function(e){return"TEXTAREA"===e.tagName},KA=function(e){return"SELECT"===e.tagName},jA=function(e){return"SLOT"===e.tagName},$A=function(e){return e.tagName.indexOf("-")>0},GA=function(){function e(){this.counters={}}return e.prototype.getCounterValue=function(e){var t=this.counters[e];return t&&t.length?t[t.length-1]:1},e.prototype.getCounterValues=function(e){return this.counters[e]||[]},e.prototype.pop=function(e){var t=this;e.forEach((function(e){return t.counters[e].pop()}))},e.prototype.parse=function(e){var t=this,n=e.counterIncrement,r=e.counterReset,A=!0;null!==n&&n.forEach((function(e){var n=t.counters[e.counter];n&&0!==e.increment&&(A=!1,n.length||n.push(1),n[Math.max(0,n.length-1)]+=e.increment)}));var i=[];return A&&r.forEach((function(e){var n=t.counters[e.counter];i.push(e.counter),n||(n=t.counters[e.counter]=[]),n.push(e.reset)})),i},e}(),zA={integers:[1e3,900,500,400,100,90,50,40,10,9,5,4,1],values:["M","CM","D","CD","C","XC","L","XL","X","IX","V","IV","I"]},WA={integers:[9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,900,800,700,600,500,400,300,200,100,90,80,70,60,50,40,30,20,10,9,8,7,6,5,4,3,2,1],values:["Ք","Փ","Ւ","Ց","Ր","Տ","Վ","Ս","Ռ","Ջ","Պ","Չ","Ո","Շ","Ն","Յ","Մ","Ճ","Ղ","Ձ","Հ","Կ","Ծ","Խ","Լ","Ի","Ժ","Թ","Ը","Է","Զ","Ե","Դ","Գ","Բ","Ա"]},qA={integers:[1e4,9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,400,300,200,100,90,80,70,60,50,40,30,20,19,18,17,16,15,10,9,8,7,6,5,4,3,2,1],values:["י׳","ט׳","ח׳","ז׳","ו׳","ה׳","ד׳","ג׳","ב׳","א׳","ת","ש","ר","ק","צ","פ","ע","ס","נ","מ","ל","כ","יט","יח","יז","טז","טו","י","ט","ח","ז","ו","ה","ד","ג","ב","א"]},JA={integers:[1e4,9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,900,800,700,600,500,400,300,200,100,90,80,70,60,50,40,30,20,10,9,8,7,6,5,4,3,2,1],values:["ჵ","ჰ","ჯ","ჴ","ხ","ჭ","წ","ძ","ც","ჩ","შ","ყ","ღ","ქ","ფ","ჳ","ტ","ს","რ","ჟ","პ","ო","ჲ","ნ","მ","ლ","კ","ი","თ","ჱ","ზ","ვ","ე","დ","გ","ბ","ა"]},YA=function(e,t,n,r,A,i){return e<t||e>n?si(e,A,i.length>0):r.integers.reduce((function(t,n,A){for(;e>=n;)e-=n,t+=r.values[A];return t}),"")+i},XA=function(e,t,n,r){var A="";do{n||e--,A=r(e)+A,e/=t}while(e*t>=t);return A},ZA=function(e,t,n,r,A){var i=n-t+1;return(e<0?"-":"")+(XA(Math.abs(e),i,r,(function(e){return c(Math.floor(e%i)+t)}))+A)},ei=function(e,t,n){void 0===n&&(n=". ");var r=t.length;return XA(Math.abs(e),r,!1,(function(e){return t[Math.floor(e%r)]}))+n},ti=function(e,t,n,r,A,i){if(e<-9999||e>9999)return si(e,4,A.length>0);var s=Math.abs(e),a=A;if(0===s)return t[0]+a;for(var o=0;s>0&&o<=4;o++){var c=s%10;0===c&&lr(i,1)&&""!==a?a=t[c]+a:c>1||1===c&&0===o||1===c&&1===o&&lr(i,2)||1===c&&1===o&&lr(i,4)&&e>100||1===c&&o>1&&lr(i,8)?a=t[c]+(o>0?n[o-1]:"")+a:1===c&&o>0&&(a=n[o-1]+a),s=Math.floor(s/10)}return(e<0?r:"")+a},ni="十百千萬",ri="拾佰仟萬",Ai="マイナス",ii="마이너스",si=function(e,t,n){var r=n?". ":"",A=n?"、":"",i=n?", ":"",s=n?" ":"";switch(t){case 0:return"•"+s;case 1:return"◦"+s;case 2:return"◾"+s;case 5:var a=ZA(e,48,57,!0,r);return a.length<4?"0"+a:a;case 4:return ei(e,"〇一二三四五六七八九",A);case 6:return YA(e,1,3999,zA,3,r).toLowerCase();case 7:return YA(e,1,3999,zA,3,r);case 8:return ZA(e,945,969,!1,r);case 9:return ZA(e,97,122,!1,r);case 10:return ZA(e,65,90,!1,r);case 11:return ZA(e,1632,1641,!0,r);case 12:case 49:return YA(e,1,9999,WA,3,r);case 35:return YA(e,1,9999,WA,3,r).toLowerCase();case 13:return ZA(e,2534,2543,!0,r);case 14:case 30:return ZA(e,6112,6121,!0,r);case 15:return ei(e,"子丑寅卯辰巳午未申酉戌亥",A);case 16:return ei(e,"甲乙丙丁戊己庚辛壬癸",A);case 17:case 48:return ti(e,"零一二三四五六七八九",ni,"負",A,14);case 47:return ti(e,"零壹貳參肆伍陸柒捌玖",ri,"負",A,15);case 42:return ti(e,"零一二三四五六七八九",ni,"负",A,14);case 41:return ti(e,"零壹贰叁肆伍陆柒捌玖",ri,"负",A,15);case 26:return ti(e,"〇一二三四五六七八九","十百千万",Ai,A,0);case 25:return ti(e,"零壱弐参四伍六七八九","拾百千万",Ai,A,7);case 31:return ti(e,"영일이삼사오육칠팔구","십백천만",ii,i,7);case 33:return ti(e,"零一二三四五六七八九","十百千萬",ii,i,0);case 32:return ti(e,"零壹貳參四五六七八九","拾百千",ii,i,7);case 18:return ZA(e,2406,2415,!0,r);case 20:return YA(e,1,19999,JA,3,r);case 21:return ZA(e,2790,2799,!0,r);case 22:return ZA(e,2662,2671,!0,r);case 22:return YA(e,1,10999,qA,3,r);case 23:return ei(e,"あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまみむめもやゆよらりるれろわゐゑをん");case 24:return ei(e,"いろはにほへとちりぬるをわかよたれそつねならむうゐのおくやまけふこえてあさきゆめみしゑひもせす");case 27:return ZA(e,3302,3311,!0,r);case 28:return ei(e,"アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワヰヱヲン",A);case 29:return ei(e,"イロハニホヘトチリヌルヲワカヨタレソツネナラムウヰノオクヤマケフコエテアサキユメミシヱヒモセス",A);case 34:return ZA(e,3792,3801,!0,r);case 37:return ZA(e,6160,6169,!0,r);case 38:return ZA(e,4160,4169,!0,r);case 39:return ZA(e,2918,2927,!0,r);case 40:return ZA(e,1776,1785,!0,r);case 43:return ZA(e,3046,3055,!0,r);case 44:return ZA(e,3174,3183,!0,r);case 45:return ZA(e,3664,3673,!0,r);case 46:return ZA(e,3872,3881,!0,r);default:return ZA(e,48,57,!0,r)}},ai="data-html2canvas-ignore",oi=function(){function e(e,t,n){if(this.context=e,this.options=n,this.scrolledElements=[],this.referenceElement=t,this.counters=new GA,this.quoteDepth=0,!t.ownerDocument)throw new Error("Cloned element does not have an owner document");this.documentElement=this.cloneNode(t.ownerDocument.documentElement,!1)}return e.prototype.toIFrame=function(e,t){var n=this,i=li(e,t);if(!i.contentWindow)return Promise.reject("Unable to find iframe window");var s=e.defaultView.pageXOffset,a=e.defaultView.pageYOffset,o=i.contentWindow,c=o.document,l=di(i).then((function(){return r(n,void 0,void 0,(function(){var e,n;return A(this,(function(r){switch(r.label){case 0:return this.scrolledElements.forEach(yi),o&&(o.scrollTo(t.left,t.top),!/(iPad|iPhone|iPod)/g.test(navigator.userAgent)||o.scrollY===t.top&&o.scrollX===t.left||(this.context.logger.warn("Unable to restore scroll position for cloned document"),this.context.windowBounds=this.context.windowBounds.add(o.scrollX-t.left,o.scrollY-t.top,0,0))),e=this.options.onclone,void 0===(n=this.clonedReferenceElement)?[2,Promise.reject("Error finding the "+this.referenceElement.nodeName+" in the cloned document")]:c.fonts&&c.fonts.ready?[4,c.fonts.ready]:[3,2];case 1:r.sent(),r.label=2;case 2:return/(AppleWebKit)/g.test(navigator.userAgent)?[4,hi(c)]:[3,4];case 3:r.sent(),r.label=4;case 4:return"function"==typeof e?[2,Promise.resolve().then((function(){return e(c,n)})).then((function(){return i}))]:[2,i]}}))}))}));return c.open(),c.write(gi(document.doctype)+"<html></html>"),mi(this.referenceElement.ownerDocument,s,a),c.replaceChild(c.adoptNode(this.documentElement),c.documentElement),c.close(),l},e.prototype.createElementClone=function(e){if(xr(e,2),LA(e))return this.createCanvasClone(e);if(PA(e))return this.createVideoClone(e);if(NA(e))return this.createStyleClone(e);var t=e.cloneNode(!1);return HA(t)&&(HA(e)&&e.currentSrc&&e.currentSrc!==e.src&&(t.src=e.currentSrc,t.srcset=""),"lazy"===t.loading&&(t.loading="eager")),$A(t)?this.createCustomElementClone(t):t},e.prototype.createCustomElementClone=function(e){var t=document.createElement("html2canvascustomelement");return pi(e.style,t),t},e.prototype.createStyleClone=function(e){try{var t=e.sheet;if(t&&t.cssRules){var n=[].slice.call(t.cssRules,0).reduce((function(e,t){return t&&"string"==typeof t.cssText?e+t.cssText:e}),""),r=e.cloneNode(!1);return r.textContent=n,r}}catch(e){if(this.context.logger.error("Unable to access cssRules property",e),"SecurityError"!==e.name)throw e}return e.cloneNode(!1)},e.prototype.createCanvasClone=function(e){var t;if(this.options.inlineImages&&e.ownerDocument){var n=e.ownerDocument.createElement("img");try{return n.src=e.toDataURL(),n}catch(t){this.context.logger.info("Unable to inline canvas contents, canvas is tainted",e)}}var r=e.cloneNode(!1);try{r.width=e.width,r.height=e.height;var A=e.getContext("2d"),i=r.getContext("2d");if(i)if(!this.options.allowTaint&&A)i.putImageData(A.getImageData(0,0,e.width,e.height),0,0);else{var s=null!==(t=e.getContext("webgl2"))&&void 0!==t?t:e.getContext("webgl");if(s){var a=s.getContextAttributes();!1===(null==a?void 0:a.preserveDrawingBuffer)&&this.context.logger.warn("Unable to clone WebGL context as it has preserveDrawingBuffer=false",e)}i.drawImage(e,0,0)}return r}catch(t){this.context.logger.info("Unable to clone canvas as it is tainted",e)}return r},e.prototype.createVideoClone=function(e){var t=e.ownerDocument.createElement("canvas");t.width=e.offsetWidth,t.height=e.offsetHeight;var n=t.getContext("2d");try{return n&&(n.drawImage(e,0,0,t.width,t.height),this.options.allowTaint||n.getImageData(0,0,t.width,t.height)),t}catch(t){this.context.logger.info("Unable to clone video as it is tainted",e)}var r=e.ownerDocument.createElement("canvas");return r.width=e.offsetWidth,r.height=e.offsetHeight,r},e.prototype.appendChildNode=function(e,t,n){QA(t)&&("SCRIPT"===t.tagName||t.hasAttribute(ai)||"function"==typeof this.options.ignoreElements&&this.options.ignoreElements(t))||this.options.copyStyles&&QA(t)&&NA(t)||e.appendChild(this.cloneNode(t,n))},e.prototype.cloneChildNodes=function(e,t,n){for(var r=this,A=e.shadowRoot?e.shadowRoot.firstChild:e.firstChild;A;A=A.nextSibling)if(QA(A)&&jA(A)&&"function"==typeof A.assignedNodes){var i=A.assignedNodes();i.length&&i.forEach((function(e){return r.appendChildNode(t,e,n)}))}else this.appendChildNode(t,A,n)},e.prototype.cloneNode=function(e,t){if(EA(e))return document.createTextNode(e.data);if(!e.ownerDocument)return e.cloneNode(!1);var n=e.ownerDocument.defaultView;if(n&&QA(e)&&(SA(e)||IA(e))){var r=this.createElementClone(e);r.style.transitionProperty="none";var A=n.getComputedStyle(e),i=n.getComputedStyle(e,":before"),s=n.getComputedStyle(e,":after");this.referenceElement===e&&SA(r)&&(this.clonedReferenceElement=r),OA(r)&&bi(r);var a=this.counters.parse(new _r(this.context,A)),o=this.resolvePseudoContent(e,r,i,Tr.BEFORE);$A(e)&&(t=!0),PA(e)||this.cloneChildNodes(e,r,t),o&&r.insertBefore(o,r.firstChild);var c=this.resolvePseudoContent(e,r,s,Tr.AFTER);return c&&r.appendChild(c),this.counters.pop(a),(A&&(this.options.copyStyles||IA(e))&&!RA(e)||t)&&pi(A,r),0===e.scrollTop&&0===e.scrollLeft||this.scrolledElements.push([r,e.scrollLeft,e.scrollTop]),(VA(e)||KA(e))&&(VA(r)||KA(r))&&(r.value=e.value),r}return e.cloneNode(!1)},e.prototype.resolvePseudoContent=function(e,t,n,r){var A=this;if(n){var i=n.content,s=t.ownerDocument;if(s&&i&&"none"!==i&&"-moz-alt-content"!==i&&"none"!==n.display){this.counters.parse(new _r(this.context,n));var a=new br(this.context,n),o=s.createElement("html2canvaspseudoelement");pi(n,o),a.content.forEach((function(t){if(0===t.type)o.appendChild(s.createTextNode(t.value));else if(22===t.type){var n=s.createElement("img");n.src=t.value,n.style.opacity="1",o.appendChild(n)}else if(18===t.type){if("attr"===t.name){var r=t.values.filter($e);r.length&&o.appendChild(s.createTextNode(e.getAttribute(r[0].value)||""))}else if("counter"===t.name){var i=t.values.filter(qe),c=i[0],l=i[1];if(c&&$e(c)){var u=A.counters.getCounterValue(c.value),h=l&&$e(l)?Sn.parse(A.context,l.value):3;o.appendChild(s.createTextNode(si(u,h,!1)))}}else if("counters"===t.name){var d=t.values.filter(qe),f=(c=d[0],d[1]);if(l=d[2],c&&$e(c)){var p=A.counters.getCounterValues(c.value),g=l&&$e(l)?Sn.parse(A.context,l.value):3,m=f&&0===f.type?f.value:"",y=p.map((function(e){return si(e,g,!1)})).join(m);o.appendChild(s.createTextNode(y))}}}else if(20===t.type)switch(t.value){case"open-quote":o.appendChild(s.createTextNode(gr(a.quotes,A.quoteDepth++,!0)));break;case"close-quote":o.appendChild(s.createTextNode(gr(a.quotes,--A.quoteDepth,!1)));break;default:o.appendChild(s.createTextNode(t.value))}})),o.className=wi+" "+vi;var c=r===Tr.BEFORE?" "+wi:" "+vi;return IA(t)?t.className.baseValue+=c:t.className+=c,o}}},e.destroy=function(e){return!!e.parentNode&&(e.parentNode.removeChild(e),!0)},e}();!function(e){e[e.BEFORE=0]="BEFORE",e[e.AFTER=1]="AFTER"}(Tr||(Tr={}));var ci,li=function(e,t){var n=e.createElement("iframe");return n.className="html2canvas-container",n.style.visibility="hidden",n.style.position="fixed",n.style.left="-10000px",n.style.top="0px",n.style.border="0",n.width=t.width.toString(),n.height=t.height.toString(),n.scrolling="no",n.setAttribute(ai,"true"),e.body.appendChild(n),n},ui=function(e){return new Promise((function(t){e.complete?t():e.src?(e.onload=t,e.onerror=t):t()}))},hi=function(e){return Promise.all([].slice.call(e.images,0).map(ui))},di=function(e){return new Promise((function(t,n){var r=e.contentWindow;if(!r)return n("No window assigned for iframe");var A=r.document;r.onload=e.onload=function(){r.onload=e.onload=null;var n=setInterval((function(){A.body.childNodes.length>0&&"complete"===A.readyState&&(clearInterval(n),t(e))}),50)}}))},fi=["all","d","content"],pi=function(e,t){for(var n=e.length-1;n>=0;n--){var r=e.item(n);-1===fi.indexOf(r)&&t.style.setProperty(r,e.getPropertyValue(r))}return t},gi=function(e){var t="";return e&&(t+="<!DOCTYPE ",e.name&&(t+=e.name),e.internalSubset&&(t+=e.internalSubset),e.publicId&&(t+='"'+e.publicId+'"'),e.systemId&&(t+='"'+e.systemId+'"'),t+=">"),t},mi=function(e,t,n){e&&e.defaultView&&(t!==e.defaultView.pageXOffset||n!==e.defaultView.pageYOffset)&&e.defaultView.scrollTo(t,n)},yi=function(e){var t=e[0],n=e[1],r=e[2];t.scrollLeft=n,t.scrollTop=r},wi="___html2canvas___pseudoelement_before",vi="___html2canvas___pseudoelement_after",Bi='{\n    content: "" !important;\n    display: none !important;\n}',bi=function(e){_i(e,"."+wi+":before"+Bi+"\n         ."+vi+":after"+Bi)},_i=function(e,t){var n=e.ownerDocument;if(n){var r=n.createElement("style");r.textContent=t,e.appendChild(r)}},Ci=function(){function e(){}return e.getOrigin=function(t){var n=e._link;return n?(n.href=t,n.href=n.href,n.protocol+n.hostname+n.port):"about:blank"},e.isSameOrigin=function(t){return e.getOrigin(t)===e._origin},e.setContext=function(t){e._link=t.document.createElement("a"),e._origin=e.getOrigin(t.location.href)},e._origin="about:blank",e}(),xi=function(){function e(e,t){this.context=e,this._options=t,this._cache={}}return e.prototype.addImage=function(e){var t=Promise.resolve();return this.has(e)?t:ki(e)||Qi(e)?((this._cache[e]=this.loadImage(e)).catch((function(){})),t):t},e.prototype.match=function(e){return this._cache[e]},e.prototype.loadImage=function(e){return r(this,void 0,void 0,(function(){var t,n,r,i,s=this;return A(this,(function(A){switch(A.label){case 0:return t=Ci.isSameOrigin(e),n=!Si(e)&&!0===this._options.useCORS&&qr.SUPPORT_CORS_IMAGES&&!t,r=!Si(e)&&!t&&!ki(e)&&"string"==typeof this._options.proxy&&qr.SUPPORT_CORS_XHR&&!n,t||!1!==this._options.allowTaint||Si(e)||ki(e)||r||n?(i=e,r?[4,this.proxy(i)]:[3,2]):[2];case 1:i=A.sent(),A.label=2;case 2:return this.context.logger.debug("Added image "+e.substring(0,256)),[4,new Promise((function(e,t){var r=new Image;r.onload=function(){return e(r)},r.onerror=t,(Ii(i)||n)&&(r.crossOrigin="anonymous"),r.src=i,!0===r.complete&&setTimeout((function(){return e(r)}),500),s._options.imageTimeout>0&&setTimeout((function(){return t("Timed out ("+s._options.imageTimeout+"ms) loading image")}),s._options.imageTimeout)}))];case 3:return[2,A.sent()]}}))}))},e.prototype.has=function(e){return void 0!==this._cache[e]},e.prototype.keys=function(){return Promise.resolve(Object.keys(this._cache))},e.prototype.proxy=function(e){var t=this,n=this._options.proxy;if(!n)throw new Error("No proxy defined");var r=e.substring(0,256);return new Promise((function(A,i){var s=qr.SUPPORT_RESPONSE_TYPE?"blob":"text",a=new XMLHttpRequest;a.onload=function(){if(200===a.status)if("text"===s)A(a.response);else{var e=new FileReader;e.addEventListener("load",(function(){return A(e.result)}),!1),e.addEventListener("error",(function(e){return i(e)}),!1),e.readAsDataURL(a.response)}else i("Failed to proxy resource "+r+" with status code "+a.status)},a.onerror=i;var o=n.indexOf("?")>-1?"&":"?";if(a.open("GET",""+n+o+"url="+encodeURIComponent(e)+"&responseType="+s),"text"!==s&&a instanceof XMLHttpRequest&&(a.responseType=s),t._options.imageTimeout){var c=t._options.imageTimeout;a.timeout=c,a.ontimeout=function(){return i("Timed out ("+c+"ms) proxying "+r)}}a.send()}))},e}(),Ui=/^data:image\/svg\+xml/i,Fi=/^data:image\/.*;base64,/i,Ei=/^data:image\/.*/i,Qi=function(e){return qr.SUPPORT_SVG_DRAWING||!Di(e)},Si=function(e){return Ei.test(e)},Ii=function(e){return Fi.test(e)},ki=function(e){return"blob"===e.substr(0,4)},Di=function(e){return"svg"===e.substr(-3).toLowerCase()||Ui.test(e)},Mi=function(){function e(e,t){this.type=0,this.x=e,this.y=t}return e.prototype.add=function(t,n){return new e(this.x+t,this.y+n)},e}(),Ti=function(e,t,n){return new Mi(e.x+(t.x-e.x)*n,e.y+(t.y-e.y)*n)},Oi=function(){function e(e,t,n,r){this.type=1,this.start=e,this.startControl=t,this.endControl=n,this.end=r}return e.prototype.subdivide=function(t,n){var r=Ti(this.start,this.startControl,t),A=Ti(this.startControl,this.endControl,t),i=Ti(this.endControl,this.end,t),s=Ti(r,A,t),a=Ti(A,i,t),o=Ti(s,a,t);return n?new e(this.start,r,s,o):new e(o,a,i,this.end)},e.prototype.add=function(t,n){return new e(this.start.add(t,n),this.startControl.add(t,n),this.endControl.add(t,n),this.end.add(t,n))},e.prototype.reverse=function(){return new e(this.end,this.endControl,this.startControl,this.start)},e}(),Li=function(e){return 1===e.type},Pi=function(e){var t=e.styles,n=e.bounds,r=At(t.borderTopLeftRadius,n.width,n.height),A=r[0],i=r[1],s=At(t.borderTopRightRadius,n.width,n.height),a=s[0],o=s[1],c=At(t.borderBottomRightRadius,n.width,n.height),l=c[0],u=c[1],h=At(t.borderBottomLeftRadius,n.width,n.height),d=h[0],f=h[1],p=[];p.push((A+a)/n.width),p.push((d+l)/n.width),p.push((i+f)/n.height),p.push((o+u)/n.height);var g=Math.max.apply(Math,p);g>1&&(A/=g,i/=g,a/=g,o/=g,l/=g,u/=g,d/=g,f/=g);var m=n.width-a,y=n.height-u,w=n.width-l,v=n.height-f,B=t.borderTopWidth,b=t.borderRightWidth,_=t.borderBottomWidth,C=t.borderLeftWidth,x=it(t.paddingTop,e.bounds.width),U=it(t.paddingRight,e.bounds.width),F=it(t.paddingBottom,e.bounds.width),E=it(t.paddingLeft,e.bounds.width);this.topLeftBorderDoubleOuterBox=A>0||i>0?Hi(n.left+C/3,n.top+B/3,A-C/3,i-B/3,ci.TOP_LEFT):new Mi(n.left+C/3,n.top+B/3),this.topRightBorderDoubleOuterBox=A>0||i>0?Hi(n.left+m,n.top+B/3,a-b/3,o-B/3,ci.TOP_RIGHT):new Mi(n.left+n.width-b/3,n.top+B/3),this.bottomRightBorderDoubleOuterBox=l>0||u>0?Hi(n.left+w,n.top+y,l-b/3,u-_/3,ci.BOTTOM_RIGHT):new Mi(n.left+n.width-b/3,n.top+n.height-_/3),this.bottomLeftBorderDoubleOuterBox=d>0||f>0?Hi(n.left+C/3,n.top+v,d-C/3,f-_/3,ci.BOTTOM_LEFT):new Mi(n.left+C/3,n.top+n.height-_/3),this.topLeftBorderDoubleInnerBox=A>0||i>0?Hi(n.left+2*C/3,n.top+2*B/3,A-2*C/3,i-2*B/3,ci.TOP_LEFT):new Mi(n.left+2*C/3,n.top+2*B/3),this.topRightBorderDoubleInnerBox=A>0||i>0?Hi(n.left+m,n.top+2*B/3,a-2*b/3,o-2*B/3,ci.TOP_RIGHT):new Mi(n.left+n.width-2*b/3,n.top+2*B/3),this.bottomRightBorderDoubleInnerBox=l>0||u>0?Hi(n.left+w,n.top+y,l-2*b/3,u-2*_/3,ci.BOTTOM_RIGHT):new Mi(n.left+n.width-2*b/3,n.top+n.height-2*_/3),this.bottomLeftBorderDoubleInnerBox=d>0||f>0?Hi(n.left+2*C/3,n.top+v,d-2*C/3,f-2*_/3,ci.BOTTOM_LEFT):new Mi(n.left+2*C/3,n.top+n.height-2*_/3),this.topLeftBorderStroke=A>0||i>0?Hi(n.left+C/2,n.top+B/2,A-C/2,i-B/2,ci.TOP_LEFT):new Mi(n.left+C/2,n.top+B/2),this.topRightBorderStroke=A>0||i>0?Hi(n.left+m,n.top+B/2,a-b/2,o-B/2,ci.TOP_RIGHT):new Mi(n.left+n.width-b/2,n.top+B/2),this.bottomRightBorderStroke=l>0||u>0?Hi(n.left+w,n.top+y,l-b/2,u-_/2,ci.BOTTOM_RIGHT):new Mi(n.left+n.width-b/2,n.top+n.height-_/2),this.bottomLeftBorderStroke=d>0||f>0?Hi(n.left+C/2,n.top+v,d-C/2,f-_/2,ci.BOTTOM_LEFT):new Mi(n.left+C/2,n.top+n.height-_/2),this.topLeftBorderBox=A>0||i>0?Hi(n.left,n.top,A,i,ci.TOP_LEFT):new Mi(n.left,n.top),this.topRightBorderBox=a>0||o>0?Hi(n.left+m,n.top,a,o,ci.TOP_RIGHT):new Mi(n.left+n.width,n.top),this.bottomRightBorderBox=l>0||u>0?Hi(n.left+w,n.top+y,l,u,ci.BOTTOM_RIGHT):new Mi(n.left+n.width,n.top+n.height),this.bottomLeftBorderBox=d>0||f>0?Hi(n.left,n.top+v,d,f,ci.BOTTOM_LEFT):new Mi(n.left,n.top+n.height),this.topLeftPaddingBox=A>0||i>0?Hi(n.left+C,n.top+B,Math.max(0,A-C),Math.max(0,i-B),ci.TOP_LEFT):new Mi(n.left+C,n.top+B),this.topRightPaddingBox=a>0||o>0?Hi(n.left+Math.min(m,n.width-b),n.top+B,m>n.width+b?0:Math.max(0,a-b),Math.max(0,o-B),ci.TOP_RIGHT):new Mi(n.left+n.width-b,n.top+B),this.bottomRightPaddingBox=l>0||u>0?Hi(n.left+Math.min(w,n.width-C),n.top+Math.min(y,n.height-_),Math.max(0,l-b),Math.max(0,u-_),ci.BOTTOM_RIGHT):new Mi(n.left+n.width-b,n.top+n.height-_),this.bottomLeftPaddingBox=d>0||f>0?Hi(n.left+C,n.top+Math.min(v,n.height-_),Math.max(0,d-C),Math.max(0,f-_),ci.BOTTOM_LEFT):new Mi(n.left+C,n.top+n.height-_),this.topLeftContentBox=A>0||i>0?Hi(n.left+C+E,n.top+B+x,Math.max(0,A-(C+E)),Math.max(0,i-(B+x)),ci.TOP_LEFT):new Mi(n.left+C+E,n.top+B+x),this.topRightContentBox=a>0||o>0?Hi(n.left+Math.min(m,n.width+C+E),n.top+B+x,m>n.width+C+E?0:a-C+E,o-(B+x),ci.TOP_RIGHT):new Mi(n.left+n.width-(b+U),n.top+B+x),this.bottomRightContentBox=l>0||u>0?Hi(n.left+Math.min(w,n.width-(C+E)),n.top+Math.min(y,n.height+B+x),Math.max(0,l-(b+U)),u-(_+F),ci.BOTTOM_RIGHT):new Mi(n.left+n.width-(b+U),n.top+n.height-(_+F)),this.bottomLeftContentBox=d>0||f>0?Hi(n.left+C+E,n.top+v,Math.max(0,d-(C+E)),f-(_+F),ci.BOTTOM_LEFT):new Mi(n.left+C+E,n.top+n.height-(_+F))};!function(e){e[e.TOP_LEFT=0]="TOP_LEFT",e[e.TOP_RIGHT=1]="TOP_RIGHT",e[e.BOTTOM_RIGHT=2]="BOTTOM_RIGHT",e[e.BOTTOM_LEFT=3]="BOTTOM_LEFT"}(ci||(ci={}));var Hi=function(e,t,n,r,A){var i=(Math.sqrt(2)-1)/3*4,s=n*i,a=r*i,o=e+n,c=t+r;switch(A){case ci.TOP_LEFT:return new Oi(new Mi(e,c),new Mi(e,c-a),new Mi(o-s,t),new Mi(o,t));case ci.TOP_RIGHT:return new Oi(new Mi(e,t),new Mi(e+s,t),new Mi(o,c-a),new Mi(o,c));case ci.BOTTOM_RIGHT:return new Oi(new Mi(o,t),new Mi(o,t+a),new Mi(e+s,c),new Mi(e,c));case ci.BOTTOM_LEFT:default:return new Oi(new Mi(o,c),new Mi(o-s,c),new Mi(e,t+a),new Mi(e,t))}},Ri=function(e){return[e.topLeftBorderBox,e.topRightBorderBox,e.bottomRightBorderBox,e.bottomLeftBorderBox]},Ni=function(e){return[e.topLeftPaddingBox,e.topRightPaddingBox,e.bottomRightPaddingBox,e.bottomLeftPaddingBox]},Vi=function(e,t,n){this.offsetX=e,this.offsetY=t,this.matrix=n,this.type=0,this.target=6},Ki=function(e,t){this.path=e,this.target=t,this.type=1},ji=function(e){this.opacity=e,this.type=2,this.target=6},$i=function(e){return 1===e.type},Gi=function(e,t){return e.length===t.length&&e.some((function(e,n){return e===t[n]}))},zi=function(e){this.element=e,this.inlineLevel=[],this.nonInlineLevel=[],this.negativeZIndex=[],this.zeroOrAutoZIndexOrTransformedOrOpacity=[],this.positiveZIndex=[],this.nonPositionedFloats=[],this.nonPositionedInlineLevel=[]},Wi=function(){function e(e,t){if(this.container=e,this.parent=t,this.effects=[],this.curves=new Pi(this.container),this.container.styles.opacity<1&&this.effects.push(new ji(this.container.styles.opacity)),null!==this.container.styles.transform){var n=this.container.bounds.left+this.container.styles.transformOrigin[0].number,r=this.container.bounds.top+this.container.styles.transformOrigin[1].number,A=this.container.styles.transform;this.effects.push(new Vi(n,r,A))}if(0!==this.container.styles.overflowX){var i=Ri(this.curves),s=Ni(this.curves);Gi(i,s)?this.effects.push(new Ki(i,6)):(this.effects.push(new Ki(i,2)),this.effects.push(new Ki(s,4)))}}return e.prototype.getEffects=function(e){for(var t=-1===[2,3].indexOf(this.container.styles.position),n=this.parent,r=this.effects.slice(0);n;){var A=n.effects.filter((function(e){return!$i(e)}));if(t||0!==n.container.styles.position||!n.parent){if(r.unshift.apply(r,A),t=-1===[2,3].indexOf(n.container.styles.position),0!==n.container.styles.overflowX){var i=Ri(n.curves),s=Ni(n.curves);Gi(i,s)||r.unshift(new Ki(s,6))}}else r.unshift.apply(r,A);n=n.parent}return r.filter((function(t){return lr(t.target,e)}))},e}(),qi=function(e,t,n,r){e.container.elements.forEach((function(A){var i=lr(A.flags,4),s=lr(A.flags,2),a=new Wi(A,e);lr(A.styles.display,2048)&&r.push(a);var o=lr(A.flags,8)?[]:r;if(i||s){var c=i||A.styles.isPositioned()?n:t,l=new zi(a);if(A.styles.isPositioned()||A.styles.opacity<1||A.styles.isTransformed()){var u=A.styles.zIndex.order;if(u<0){var h=0;c.negativeZIndex.some((function(e,t){return u>e.element.container.styles.zIndex.order?(h=t,!1):h>0})),c.negativeZIndex.splice(h,0,l)}else if(u>0){var d=0;c.positiveZIndex.some((function(e,t){return u>=e.element.container.styles.zIndex.order?(d=t+1,!1):d>0})),c.positiveZIndex.splice(d,0,l)}else c.zeroOrAutoZIndexOrTransformedOrOpacity.push(l)}else A.styles.isFloating()?c.nonPositionedFloats.push(l):c.nonPositionedInlineLevel.push(l);qi(a,l,i?l:n,o)}else A.styles.isInlineLevel()?t.inlineLevel.push(a):t.nonInlineLevel.push(a),qi(a,t,n,o);lr(A.flags,8)&&Ji(A,o)}))},Ji=function(e,t){for(var n=e instanceof uA?e.start:1,r=e instanceof uA&&e.reversed,A=0;A<t.length;A++){var i=t[A];i.container instanceof lA&&"number"==typeof i.container.value&&0!==i.container.value&&(n=i.container.value),i.listValue=si(n,i.container.styles.listStyleType,!0),n+=r?-1:1}},Yi=function(e,t){switch(t){case 0:return Zi(e.topLeftBorderBox,e.topLeftPaddingBox,e.topRightBorderBox,e.topRightPaddingBox);case 1:return Zi(e.topRightBorderBox,e.topRightPaddingBox,e.bottomRightBorderBox,e.bottomRightPaddingBox);case 2:return Zi(e.bottomRightBorderBox,e.bottomRightPaddingBox,e.bottomLeftBorderBox,e.bottomLeftPaddingBox);default:return Zi(e.bottomLeftBorderBox,e.bottomLeftPaddingBox,e.topLeftBorderBox,e.topLeftPaddingBox)}},Xi=function(e,t){var n=[];return Li(e)?n.push(e.subdivide(.5,!1)):n.push(e),Li(t)?n.push(t.subdivide(.5,!0)):n.push(t),n},Zi=function(e,t,n,r){var A=[];return Li(e)?A.push(e.subdivide(.5,!1)):A.push(e),Li(n)?A.push(n.subdivide(.5,!0)):A.push(n),Li(r)?A.push(r.subdivide(.5,!0).reverse()):A.push(r),Li(t)?A.push(t.subdivide(.5,!1).reverse()):A.push(t),A},es=function(e){var t=e.bounds,n=e.styles;return t.add(n.borderLeftWidth,n.borderTopWidth,-(n.borderRightWidth+n.borderLeftWidth),-(n.borderTopWidth+n.borderBottomWidth))},ts=function(e){var t=e.styles,n=e.bounds,r=it(t.paddingLeft,n.width),A=it(t.paddingRight,n.width),i=it(t.paddingTop,n.width),s=it(t.paddingBottom,n.width);return n.add(r+t.borderLeftWidth,i+t.borderTopWidth,-(t.borderRightWidth+t.borderLeftWidth+r+A),-(t.borderTopWidth+t.borderBottomWidth+i+s))},ns=function(e,t,n){var r=function(e,t){return 0===e?t.bounds:2===e?ts(t):es(t)}(ss(e.styles.backgroundOrigin,t),e),A=function(e,t){return 0===e?t.bounds:2===e?ts(t):es(t)}(ss(e.styles.backgroundClip,t),e),i=is(ss(e.styles.backgroundSize,t),n,r),s=i[0],a=i[1],o=At(ss(e.styles.backgroundPosition,t),r.width-s,r.height-a);return[as(ss(e.styles.backgroundRepeat,t),o,i,r,A),Math.round(r.left+o[0]),Math.round(r.top+o[1]),s,a]},rs=function(e){return $e(e)&&e.value===Nt.AUTO},As=function(e){return"number"==typeof e},is=function(e,t,n){var r=t[0],A=t[1],i=t[2],s=e[0],a=e[1];if(!s)return[0,0];if(Ze(s)&&a&&Ze(a))return[it(s,n.width),it(a,n.height)];var o=As(i);if($e(s)&&(s.value===Nt.CONTAIN||s.value===Nt.COVER))return As(i)?n.width/n.height<i!=(s.value===Nt.COVER)?[n.width,n.width/i]:[n.height*i,n.height]:[n.width,n.height];var c=As(r),l=As(A),u=c||l;if(rs(s)&&(!a||rs(a)))return c&&l?[r,A]:o||u?u&&o?[c?r:A*i,l?A:r/i]:[c?r:n.width,l?A:n.height]:[n.width,n.height];if(o){var h=0,d=0;return Ze(s)?h=it(s,n.width):Ze(a)&&(d=it(a,n.height)),rs(s)?h=d*i:a&&!rs(a)||(d=h/i),[h,d]}var f=null,p=null;if(Ze(s)?f=it(s,n.width):a&&Ze(a)&&(p=it(a,n.height)),null===f||a&&!rs(a)||(p=c&&l?f/r*A:n.height),null!==p&&rs(s)&&(f=c&&l?p/A*r:n.width),null!==f&&null!==p)return[f,p];throw new Error("Unable to calculate background-size for element")},ss=function(e,t){var n=e[t];return void 0===n?e[0]:n},as=function(e,t,n,r,A){var i=t[0],s=t[1],a=n[0],o=n[1];switch(e){case 2:return[new Mi(Math.round(r.left),Math.round(r.top+s)),new Mi(Math.round(r.left+r.width),Math.round(r.top+s)),new Mi(Math.round(r.left+r.width),Math.round(o+r.top+s)),new Mi(Math.round(r.left),Math.round(o+r.top+s))];case 3:return[new Mi(Math.round(r.left+i),Math.round(r.top)),new Mi(Math.round(r.left+i+a),Math.round(r.top)),new Mi(Math.round(r.left+i+a),Math.round(r.height+r.top)),new Mi(Math.round(r.left+i),Math.round(r.height+r.top))];case 1:return[new Mi(Math.round(r.left+i),Math.round(r.top+s)),new Mi(Math.round(r.left+i+a),Math.round(r.top+s)),new Mi(Math.round(r.left+i+a),Math.round(r.top+s+o)),new Mi(Math.round(r.left+i),Math.round(r.top+s+o))];default:return[new Mi(Math.round(A.left),Math.round(A.top)),new Mi(Math.round(A.left+A.width),Math.round(A.top)),new Mi(Math.round(A.left+A.width),Math.round(A.height+A.top)),new Mi(Math.round(A.left),Math.round(A.height+A.top))]}},os="Hidden Text",cs=function(){function e(e){this._data={},this._document=e}return e.prototype.parseMetrics=function(e,t){var n=this._document.createElement("div"),r=this._document.createElement("img"),A=this._document.createElement("span"),i=this._document.body;n.style.visibility="hidden",n.style.fontFamily=e,n.style.fontSize=t,n.style.margin="0",n.style.padding="0",n.style.whiteSpace="nowrap",i.appendChild(n),r.src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7",r.width=1,r.height=1,r.style.margin="0",r.style.padding="0",r.style.verticalAlign="baseline",A.style.fontFamily=e,A.style.fontSize=t,A.style.margin="0",A.style.padding="0",A.appendChild(this._document.createTextNode(os)),n.appendChild(A),n.appendChild(r);var s=r.offsetTop-A.offsetTop+2;n.removeChild(A),n.appendChild(this._document.createTextNode(os)),n.style.lineHeight="normal",r.style.verticalAlign="super";var a=r.offsetTop-n.offsetTop+2;return i.removeChild(n),{baseline:s,middle:a}},e.prototype.getMetrics=function(e,t){var n=e+" "+t;return void 0===this._data[n]&&(this._data[n]=this.parseMetrics(e,t)),this._data[n]},e}(),ls=function(e,t){this.context=e,this.options=t},us=function(e){function n(t,n){var r=e.call(this,t,n)||this;return r._activeEffects=[],r.canvas=n.canvas?n.canvas:document.createElement("canvas"),r.ctx=r.canvas.getContext("2d"),n.canvas||(r.canvas.width=Math.floor(n.width*n.scale),r.canvas.height=Math.floor(n.height*n.scale),r.canvas.style.width=n.width+"px",r.canvas.style.height=n.height+"px"),r.fontMetrics=new cs(document),r.ctx.scale(r.options.scale,r.options.scale),r.ctx.translate(-n.x,-n.y),r.ctx.textBaseline="bottom",r._activeEffects=[],r.context.logger.debug("Canvas renderer initialized ("+n.width+"x"+n.height+") with scale "+n.scale),r}return t(n,e),n.prototype.applyEffects=function(e){for(var t=this;this._activeEffects.length;)this.popEffect();e.forEach((function(e){return t.applyEffect(e)}))},n.prototype.applyEffect=function(e){this.ctx.save(),function(e){return 2===e.type}(e)&&(this.ctx.globalAlpha=e.opacity),function(e){return 0===e.type}(e)&&(this.ctx.translate(e.offsetX,e.offsetY),this.ctx.transform(e.matrix[0],e.matrix[1],e.matrix[2],e.matrix[3],e.matrix[4],e.matrix[5]),this.ctx.translate(-e.offsetX,-e.offsetY)),$i(e)&&(this.path(e.path),this.ctx.clip()),this._activeEffects.push(e)},n.prototype.popEffect=function(){this._activeEffects.pop(),this.ctx.restore()},n.prototype.renderStack=function(e){return r(this,void 0,void 0,(function(){return A(this,(function(t){switch(t.label){case 0:return e.element.container.styles.isVisible()?[4,this.renderStackContent(e)]:[3,2];case 1:t.sent(),t.label=2;case 2:return[2]}}))}))},n.prototype.renderNode=function(e){return r(this,void 0,void 0,(function(){return A(this,(function(t){switch(t.label){case 0:return lr(e.container.flags,16),e.container.styles.isVisible()?[4,this.renderNodeBackgroundAndBorders(e)]:[3,3];case 1:return t.sent(),[4,this.renderNodeContent(e)];case 2:t.sent(),t.label=3;case 3:return[2]}}))}))},n.prototype.renderTextWithLetterSpacing=function(e,t,n){var r=this;0===t?this.ctx.fillText(e.text,e.bounds.left,e.bounds.top+n):Zr(e.text).reduce((function(t,A){return r.ctx.fillText(A,t,e.bounds.top+n),t+r.ctx.measureText(A).width}),e.bounds.left)},n.prototype.createFontStyle=function(e){var t=e.fontVariant.filter((function(e){return"normal"===e||"small-caps"===e})).join(""),n=gs(e.fontFamily).join(", "),r=Ke(e.fontSize)?""+e.fontSize.number+e.fontSize.unit:e.fontSize.number+"px";return[[e.fontStyle,t,e.fontWeight,r,n].join(" "),n,r]},n.prototype.renderTextNode=function(e,t){return r(this,void 0,void 0,(function(){var n,r,i,s,a,o,c,l,u=this;return A(this,(function(A){return n=this.createFontStyle(t),r=n[0],i=n[1],s=n[2],this.ctx.font=r,this.ctx.direction=1===t.direction?"rtl":"ltr",this.ctx.textAlign="left",this.ctx.textBaseline="alphabetic",a=this.fontMetrics.getMetrics(i,s),o=a.baseline,c=a.middle,l=t.paintOrder,e.textBounds.forEach((function(e){l.forEach((function(n){switch(n){case 0:u.ctx.fillStyle=ft(t.color),u.renderTextWithLetterSpacing(e,t.letterSpacing,o);var r=t.textShadow;r.length&&e.text.trim().length&&(r.slice(0).reverse().forEach((function(n){u.ctx.shadowColor=ft(n.color),u.ctx.shadowOffsetX=n.offsetX.number*u.options.scale,u.ctx.shadowOffsetY=n.offsetY.number*u.options.scale,u.ctx.shadowBlur=n.blur.number,u.renderTextWithLetterSpacing(e,t.letterSpacing,o)})),u.ctx.shadowColor="",u.ctx.shadowOffsetX=0,u.ctx.shadowOffsetY=0,u.ctx.shadowBlur=0),t.textDecorationLine.length&&(u.ctx.fillStyle=ft(t.textDecorationColor||t.color),t.textDecorationLine.forEach((function(t){switch(t){case 1:u.ctx.fillRect(e.bounds.left,Math.round(e.bounds.top+o),e.bounds.width,1);break;case 2:u.ctx.fillRect(e.bounds.left,Math.round(e.bounds.top),e.bounds.width,1);break;case 3:u.ctx.fillRect(e.bounds.left,Math.ceil(e.bounds.top+c),e.bounds.width,1)}})));break;case 1:t.webkitTextStrokeWidth&&e.text.trim().length&&(u.ctx.strokeStyle=ft(t.webkitTextStrokeColor),u.ctx.lineWidth=t.webkitTextStrokeWidth,u.ctx.lineJoin=window.chrome?"miter":"round",u.ctx.strokeText(e.text,e.bounds.left,e.bounds.top+o)),u.ctx.strokeStyle="",u.ctx.lineWidth=0,u.ctx.lineJoin="miter"}}))})),[2]}))}))},n.prototype.renderReplacedElement=function(e,t,n){if(n&&e.intrinsicWidth>0&&e.intrinsicHeight>0){var r=ts(e),A=Ni(t);this.path(A),this.ctx.save(),this.ctx.clip(),this.ctx.drawImage(n,0,0,e.intrinsicWidth,e.intrinsicHeight,r.left,r.top,r.width,r.height),this.ctx.restore()}},n.prototype.renderNodeContent=function(e){return r(this,void 0,void 0,(function(){var t,r,i,a,o,c,l,u,h,d,f,p,g,m,y,w,v,B;return A(this,(function(A){switch(A.label){case 0:this.applyEffects(e.getEffects(4)),t=e.container,r=e.curves,i=t.styles,a=0,o=t.textNodes,A.label=1;case 1:return a<o.length?(c=o[a],[4,this.renderTextNode(c,i)]):[3,4];case 2:A.sent(),A.label=3;case 3:return a++,[3,1];case 4:if(!(t instanceof aA))return[3,8];A.label=5;case 5:return A.trys.push([5,7,,8]),[4,this.context.cache.match(t.src)];case 6:return y=A.sent(),this.renderReplacedElement(t,r,y),[3,8];case 7:return A.sent(),this.context.logger.error("Error loading image "+t.src),[3,8];case 8:if(t instanceof oA&&this.renderReplacedElement(t,r,t.canvas),!(t instanceof cA))return[3,12];A.label=9;case 9:return A.trys.push([9,11,,12]),[4,this.context.cache.match(t.svg)];case 10:return y=A.sent(),this.renderReplacedElement(t,r,y),[3,12];case 11:return A.sent(),this.context.logger.error("Error loading svg "+t.svg.substring(0,255)),[3,12];case 12:return t instanceof BA&&t.tree?[4,new n(this.context,{scale:this.options.scale,backgroundColor:t.backgroundColor,x:0,y:0,width:t.width,height:t.height}).render(t.tree)]:[3,14];case 13:l=A.sent(),t.width&&t.height&&this.ctx.drawImage(l,0,0,t.width,t.height,t.bounds.left,t.bounds.top,t.bounds.width,t.bounds.height),A.label=14;case 14:if(t instanceof yA&&(u=Math.min(t.bounds.width,t.bounds.height),t.type===fA?t.checked&&(this.ctx.save(),this.path([new Mi(t.bounds.left+.39363*u,t.bounds.top+.79*u),new Mi(t.bounds.left+.16*u,t.bounds.top+.5549*u),new Mi(t.bounds.left+.27347*u,t.bounds.top+.44071*u),new Mi(t.bounds.left+.39694*u,t.bounds.top+.5649*u),new Mi(t.bounds.left+.72983*u,t.bounds.top+.23*u),new Mi(t.bounds.left+.84*u,t.bounds.top+.34085*u),new Mi(t.bounds.left+.39363*u,t.bounds.top+.79*u)]),this.ctx.fillStyle=ft(mA),this.ctx.fill(),this.ctx.restore()):t.type===pA&&t.checked&&(this.ctx.save(),this.ctx.beginPath(),this.ctx.arc(t.bounds.left+u/2,t.bounds.top+u/2,u/4,0,2*Math.PI,!0),this.ctx.fillStyle=ft(mA),this.ctx.fill(),this.ctx.restore())),hs(t)&&t.value.length){switch(h=this.createFontStyle(i),v=h[0],d=h[1],f=this.fontMetrics.getMetrics(v,d).baseline,this.ctx.font=v,this.ctx.fillStyle=ft(i.color),this.ctx.textBaseline="alphabetic",this.ctx.textAlign=fs(t.styles.textAlign),B=ts(t),p=0,t.styles.textAlign){case 1:p+=B.width/2;break;case 2:p+=B.width}g=B.add(p,0,0,-B.height/2+1),this.ctx.save(),this.path([new Mi(B.left,B.top),new Mi(B.left+B.width,B.top),new Mi(B.left+B.width,B.top+B.height),new Mi(B.left,B.top+B.height)]),this.ctx.clip(),this.renderTextWithLetterSpacing(new Jr(t.value,g),i.letterSpacing,f),this.ctx.restore(),this.ctx.textBaseline="alphabetic",this.ctx.textAlign="left"}if(!lr(t.styles.display,2048))return[3,20];if(null===t.styles.listStyleImage)return[3,19];if(0!==(m=t.styles.listStyleImage).type)return[3,18];y=void 0,w=m.url,A.label=15;case 15:return A.trys.push([15,17,,18]),[4,this.context.cache.match(w)];case 16:return y=A.sent(),this.ctx.drawImage(y,t.bounds.left-(y.width+10),t.bounds.top),[3,18];case 17:return A.sent(),this.context.logger.error("Error loading list-style-image "+w),[3,18];case 18:return[3,20];case 19:e.listValue&&-1!==t.styles.listStyleType&&(v=this.createFontStyle(i)[0],this.ctx.font=v,this.ctx.fillStyle=ft(i.color),this.ctx.textBaseline="middle",this.ctx.textAlign="right",B=new s(t.bounds.left,t.bounds.top+it(t.styles.paddingTop,t.bounds.width),t.bounds.width,Fn(i.lineHeight,i.fontSize.number)/2+1),this.renderTextWithLetterSpacing(new Jr(e.listValue,B),i.letterSpacing,Fn(i.lineHeight,i.fontSize.number)/2+2),this.ctx.textBaseline="bottom",this.ctx.textAlign="left"),A.label=20;case 20:return[2]}}))}))},n.prototype.renderStackContent=function(e){return r(this,void 0,void 0,(function(){var t,n,r,i,s,a,o,c,l,u,h,d,f,p,g;return A(this,(function(A){switch(A.label){case 0:return lr(e.element.container.flags,16),[4,this.renderNodeBackgroundAndBorders(e.element)];case 1:A.sent(),t=0,n=e.negativeZIndex,A.label=2;case 2:return t<n.length?(g=n[t],[4,this.renderStack(g)]):[3,5];case 3:A.sent(),A.label=4;case 4:return t++,[3,2];case 5:return[4,this.renderNodeContent(e.element)];case 6:A.sent(),r=0,i=e.nonInlineLevel,A.label=7;case 7:return r<i.length?(g=i[r],[4,this.renderNode(g)]):[3,10];case 8:A.sent(),A.label=9;case 9:return r++,[3,7];case 10:s=0,a=e.nonPositionedFloats,A.label=11;case 11:return s<a.length?(g=a[s],[4,this.renderStack(g)]):[3,14];case 12:A.sent(),A.label=13;case 13:return s++,[3,11];case 14:o=0,c=e.nonPositionedInlineLevel,A.label=15;case 15:return o<c.length?(g=c[o],[4,this.renderStack(g)]):[3,18];case 16:A.sent(),A.label=17;case 17:return o++,[3,15];case 18:l=0,u=e.inlineLevel,A.label=19;case 19:return l<u.length?(g=u[l],[4,this.renderNode(g)]):[3,22];case 20:A.sent(),A.label=21;case 21:return l++,[3,19];case 22:h=0,d=e.zeroOrAutoZIndexOrTransformedOrOpacity,A.label=23;case 23:return h<d.length?(g=d[h],[4,this.renderStack(g)]):[3,26];case 24:A.sent(),A.label=25;case 25:return h++,[3,23];case 26:f=0,p=e.positiveZIndex,A.label=27;case 27:return f<p.length?(g=p[f],[4,this.renderStack(g)]):[3,30];case 28:A.sent(),A.label=29;case 29:return f++,[3,27];case 30:return[2]}}))}))},n.prototype.mask=function(e){this.ctx.beginPath(),this.ctx.moveTo(0,0),this.ctx.lineTo(this.canvas.width,0),this.ctx.lineTo(this.canvas.width,this.canvas.height),this.ctx.lineTo(0,this.canvas.height),this.ctx.lineTo(0,0),this.formatPath(e.slice(0).reverse()),this.ctx.closePath()},n.prototype.path=function(e){this.ctx.beginPath(),this.formatPath(e),this.ctx.closePath()},n.prototype.formatPath=function(e){var t=this;e.forEach((function(e,n){var r=Li(e)?e.start:e;0===n?t.ctx.moveTo(r.x,r.y):t.ctx.lineTo(r.x,r.y),Li(e)&&t.ctx.bezierCurveTo(e.startControl.x,e.startControl.y,e.endControl.x,e.endControl.y,e.end.x,e.end.y)}))},n.prototype.renderRepeat=function(e,t,n,r){this.path(e),this.ctx.fillStyle=t,this.ctx.translate(n,r),this.ctx.fill(),this.ctx.translate(-n,-r)},n.prototype.resizeImage=function(e,t,n){var r;if(e.width===t&&e.height===n)return e;var A=(null!==(r=this.canvas.ownerDocument)&&void 0!==r?r:document).createElement("canvas");return A.width=Math.max(1,t),A.height=Math.max(1,n),A.getContext("2d").drawImage(e,0,0,e.width,e.height,0,0,t,n),A},n.prototype.renderBackgroundImage=function(e){return r(this,void 0,void 0,(function(){var t,n,r,i,s,a;return A(this,(function(o){switch(o.label){case 0:t=e.styles.backgroundImage.length-1,n=function(n){var i,s,a,o,c,l,u,h,d,f,p,g,m,y,w,v,B,b,_,C,x,U,F,E,Q,S,I,k,D,M,T;return A(this,(function(A){switch(A.label){case 0:if(0!==n.type)return[3,5];i=void 0,s=n.url,A.label=1;case 1:return A.trys.push([1,3,,4]),[4,r.context.cache.match(s)];case 2:return i=A.sent(),[3,4];case 3:return A.sent(),r.context.logger.error("Error loading background-image "+s),[3,4];case 4:return i&&(a=ns(e,t,[i.width,i.height,i.width/i.height]),v=a[0],U=a[1],F=a[2],_=a[3],C=a[4],y=r.ctx.createPattern(r.resizeImage(i,_,C),"repeat"),r.renderRepeat(v,y,U,F)),[3,6];case 5:1===n.type?(o=ns(e,t,[null,null,null]),v=o[0],U=o[1],F=o[2],_=o[3],C=o[4],c=Ft(n.angle,_,C),l=c[0],u=c[1],h=c[2],d=c[3],f=c[4],(p=document.createElement("canvas")).width=_,p.height=C,g=p.getContext("2d"),m=g.createLinearGradient(u,d,h,f),Ut(n.stops,l).forEach((function(e){return m.addColorStop(e.stop,ft(e.color))})),g.fillStyle=m,g.fillRect(0,0,_,C),_>0&&C>0&&(y=r.ctx.createPattern(p,"repeat"),r.renderRepeat(v,y,U,F))):function(e){return 2===e.type}(n)&&(w=ns(e,t,[null,null,null]),v=w[0],B=w[1],b=w[2],_=w[3],C=w[4],x=0===n.position.length?[nt]:n.position,U=it(x[0],_),F=it(x[x.length-1],C),E=function(e,t,n,r,A){var i=0,s=0;switch(e.size){case 0:0===e.shape?i=s=Math.min(Math.abs(t),Math.abs(t-r),Math.abs(n),Math.abs(n-A)):1===e.shape&&(i=Math.min(Math.abs(t),Math.abs(t-r)),s=Math.min(Math.abs(n),Math.abs(n-A)));break;case 2:if(0===e.shape)i=s=Math.min(Et(t,n),Et(t,n-A),Et(t-r,n),Et(t-r,n-A));else if(1===e.shape){var a=Math.min(Math.abs(n),Math.abs(n-A))/Math.min(Math.abs(t),Math.abs(t-r)),o=Qt(r,A,t,n,!0),c=o[0],l=o[1];s=a*(i=Et(c-t,(l-n)/a))}break;case 1:0===e.shape?i=s=Math.max(Math.abs(t),Math.abs(t-r),Math.abs(n),Math.abs(n-A)):1===e.shape&&(i=Math.max(Math.abs(t),Math.abs(t-r)),s=Math.max(Math.abs(n),Math.abs(n-A)));break;case 3:if(0===e.shape)i=s=Math.max(Et(t,n),Et(t,n-A),Et(t-r,n),Et(t-r,n-A));else if(1===e.shape){a=Math.max(Math.abs(n),Math.abs(n-A))/Math.max(Math.abs(t),Math.abs(t-r));var u=Qt(r,A,t,n,!1);c=u[0],l=u[1],s=a*(i=Et(c-t,(l-n)/a))}}return Array.isArray(e.size)&&(i=it(e.size[0],r),s=2===e.size.length?it(e.size[1],A):i),[i,s]}(n,U,F,_,C),Q=E[0],S=E[1],Q>0&&S>0&&(I=r.ctx.createRadialGradient(B+U,b+F,0,B+U,b+F,Q),Ut(n.stops,2*Q).forEach((function(e){return I.addColorStop(e.stop,ft(e.color))})),r.path(v),r.ctx.fillStyle=I,Q!==S?(k=e.bounds.left+.5*e.bounds.width,D=e.bounds.top+.5*e.bounds.height,T=1/(M=S/Q),r.ctx.save(),r.ctx.translate(k,D),r.ctx.transform(1,0,0,M,0,0),r.ctx.translate(-k,-D),r.ctx.fillRect(B,T*(b-D)+D,_,C*T),r.ctx.restore()):r.ctx.fill())),A.label=6;case 6:return t--,[2]}}))},r=this,i=0,s=e.styles.backgroundImage.slice(0).reverse(),o.label=1;case 1:return i<s.length?(a=s[i],[5,n(a)]):[3,4];case 2:o.sent(),o.label=3;case 3:return i++,[3,1];case 4:return[2]}}))}))},n.prototype.renderSolidBorder=function(e,t,n){return r(this,void 0,void 0,(function(){return A(this,(function(r){return this.path(Yi(n,t)),this.ctx.fillStyle=ft(e),this.ctx.fill(),[2]}))}))},n.prototype.renderDoubleBorder=function(e,t,n,i){return r(this,void 0,void 0,(function(){var r,s;return A(this,(function(A){switch(A.label){case 0:return t<3?[4,this.renderSolidBorder(e,n,i)]:[3,2];case 1:return A.sent(),[2];case 2:return r=function(e,t){switch(t){case 0:return Zi(e.topLeftBorderBox,e.topLeftBorderDoubleOuterBox,e.topRightBorderBox,e.topRightBorderDoubleOuterBox);case 1:return Zi(e.topRightBorderBox,e.topRightBorderDoubleOuterBox,e.bottomRightBorderBox,e.bottomRightBorderDoubleOuterBox);case 2:return Zi(e.bottomRightBorderBox,e.bottomRightBorderDoubleOuterBox,e.bottomLeftBorderBox,e.bottomLeftBorderDoubleOuterBox);default:return Zi(e.bottomLeftBorderBox,e.bottomLeftBorderDoubleOuterBox,e.topLeftBorderBox,e.topLeftBorderDoubleOuterBox)}}(i,n),this.path(r),this.ctx.fillStyle=ft(e),this.ctx.fill(),s=function(e,t){switch(t){case 0:return Zi(e.topLeftBorderDoubleInnerBox,e.topLeftPaddingBox,e.topRightBorderDoubleInnerBox,e.topRightPaddingBox);case 1:return Zi(e.topRightBorderDoubleInnerBox,e.topRightPaddingBox,e.bottomRightBorderDoubleInnerBox,e.bottomRightPaddingBox);case 2:return Zi(e.bottomRightBorderDoubleInnerBox,e.bottomRightPaddingBox,e.bottomLeftBorderDoubleInnerBox,e.bottomLeftPaddingBox);default:return Zi(e.bottomLeftBorderDoubleInnerBox,e.bottomLeftPaddingBox,e.topLeftBorderDoubleInnerBox,e.topLeftPaddingBox)}}(i,n),this.path(s),this.ctx.fill(),[2]}}))}))},n.prototype.renderNodeBackgroundAndBorders=function(e){return r(this,void 0,void 0,(function(){var t,n,r,i,s,a,o,c,l=this;return A(this,(function(A){switch(A.label){case 0:return this.applyEffects(e.getEffects(2)),t=e.container.styles,n=!dt(t.backgroundColor)||t.backgroundImage.length,r=[{style:t.borderTopStyle,color:t.borderTopColor,width:t.borderTopWidth},{style:t.borderRightStyle,color:t.borderRightColor,width:t.borderRightWidth},{style:t.borderBottomStyle,color:t.borderBottomColor,width:t.borderBottomWidth},{style:t.borderLeftStyle,color:t.borderLeftColor,width:t.borderLeftWidth}],i=ds(ss(t.backgroundClip,0),e.curves),n||t.boxShadow.length?(this.ctx.save(),this.path(i),this.ctx.clip(),dt(t.backgroundColor)||(this.ctx.fillStyle=ft(t.backgroundColor),this.ctx.fill()),[4,this.renderBackgroundImage(e.container)]):[3,2];case 1:A.sent(),this.ctx.restore(),t.boxShadow.slice(0).reverse().forEach((function(t){l.ctx.save();var n,r,A,i,s,a=Ri(e.curves),o=t.inset?0:1e4,c=(n=a,r=-o+(t.inset?1:-1)*t.spread.number,A=(t.inset?1:-1)*t.spread.number,i=t.spread.number*(t.inset?-2:2),s=t.spread.number*(t.inset?-2:2),n.map((function(e,t){switch(t){case 0:return e.add(r,A);case 1:return e.add(r+i,A);case 2:return e.add(r+i,A+s);case 3:return e.add(r,A+s)}return e})));t.inset?(l.path(a),l.ctx.clip(),l.mask(c)):(l.mask(a),l.ctx.clip(),l.path(c)),l.ctx.shadowOffsetX=t.offsetX.number+o,l.ctx.shadowOffsetY=t.offsetY.number,l.ctx.shadowColor=ft(t.color),l.ctx.shadowBlur=t.blur.number,l.ctx.fillStyle=t.inset?ft(t.color):"rgba(0,0,0,1)",l.ctx.fill(),l.ctx.restore()})),A.label=2;case 2:s=0,a=0,o=r,A.label=3;case 3:return a<o.length?0!==(c=o[a]).style&&!dt(c.color)&&c.width>0?2!==c.style?[3,5]:[4,this.renderDashedDottedBorder(c.color,c.width,s,e.curves,2)]:[3,11]:[3,13];case 4:return A.sent(),[3,11];case 5:return 3!==c.style?[3,7]:[4,this.renderDashedDottedBorder(c.color,c.width,s,e.curves,3)];case 6:return A.sent(),[3,11];case 7:return 4!==c.style?[3,9]:[4,this.renderDoubleBorder(c.color,c.width,s,e.curves)];case 8:return A.sent(),[3,11];case 9:return[4,this.renderSolidBorder(c.color,s,e.curves)];case 10:A.sent(),A.label=11;case 11:s++,A.label=12;case 12:return a++,[3,3];case 13:return[2]}}))}))},n.prototype.renderDashedDottedBorder=function(e,t,n,i,s){return r(this,void 0,void 0,(function(){var r,a,o,c,l,u,h,d,f,p,g,m,y,w,v,B;return A(this,(function(A){return this.ctx.save(),r=function(e,t){switch(t){case 0:return Xi(e.topLeftBorderStroke,e.topRightBorderStroke);case 1:return Xi(e.topRightBorderStroke,e.bottomRightBorderStroke);case 2:return Xi(e.bottomRightBorderStroke,e.bottomLeftBorderStroke);default:return Xi(e.bottomLeftBorderStroke,e.topLeftBorderStroke)}}(i,n),a=Yi(i,n),2===s&&(this.path(a),this.ctx.clip()),Li(a[0])?(o=a[0].start.x,c=a[0].start.y):(o=a[0].x,c=a[0].y),Li(a[1])?(l=a[1].end.x,u=a[1].end.y):(l=a[1].x,u=a[1].y),h=0===n||2===n?Math.abs(o-l):Math.abs(c-u),this.ctx.beginPath(),3===s?this.formatPath(r):this.formatPath(a.slice(0,2)),d=t<3?3*t:2*t,f=t<3?2*t:t,3===s&&(d=t,f=t),p=!0,h<=2*d?p=!1:h<=2*d+f?(d*=g=h/(2*d+f),f*=g):(m=Math.floor((h+f)/(d+f)),y=(h-m*d)/(m-1),f=(w=(h-(m+1)*d)/m)<=0||Math.abs(f-y)<Math.abs(f-w)?y:w),p&&(3===s?this.ctx.setLineDash([0,d+f]):this.ctx.setLineDash([d,f])),3===s?(this.ctx.lineCap="round",this.ctx.lineWidth=t):this.ctx.lineWidth=2*t+1.1,this.ctx.strokeStyle=ft(e),this.ctx.stroke(),this.ctx.setLineDash([]),2===s&&(Li(a[0])&&(v=a[3],B=a[0],this.ctx.beginPath(),this.formatPath([new Mi(v.end.x,v.end.y),new Mi(B.start.x,B.start.y)]),this.ctx.stroke()),Li(a[1])&&(v=a[1],B=a[2],this.ctx.beginPath(),this.formatPath([new Mi(v.end.x,v.end.y),new Mi(B.start.x,B.start.y)]),this.ctx.stroke())),this.ctx.restore(),[2]}))}))},n.prototype.render=function(e){return r(this,void 0,void 0,(function(){var t;return A(this,(function(n){switch(n.label){case 0:return this.options.backgroundColor&&(this.ctx.fillStyle=ft(this.options.backgroundColor),this.ctx.fillRect(this.options.x,this.options.y,this.options.width,this.options.height)),r=new Wi(e,null),A=new zi(r),qi(r,A,A,i=[]),Ji(r.container,i),t=A,[4,this.renderStack(t)];case 1:return n.sent(),this.applyEffects([]),[2,this.canvas]}var r,A,i}))}))},n}(ls),hs=function(e){return e instanceof vA||e instanceof wA||e instanceof yA&&e.type!==pA&&e.type!==fA},ds=function(e,t){switch(e){case 0:return Ri(t);case 2:return function(e){return[e.topLeftContentBox,e.topRightContentBox,e.bottomRightContentBox,e.bottomLeftContentBox]}(t);default:return Ni(t)}},fs=function(e){switch(e){case 1:return"center";case 2:return"right";default:return"left"}},ps=["-apple-system","system-ui"],gs=function(e){return/iPhone OS 15_(0|1)/.test(window.navigator.userAgent)?e.filter((function(e){return-1===ps.indexOf(e)})):e},ms=function(e){function n(t,n){var r=e.call(this,t,n)||this;return r.canvas=n.canvas?n.canvas:document.createElement("canvas"),r.ctx=r.canvas.getContext("2d"),r.options=n,r.canvas.width=Math.floor(n.width*n.scale),r.canvas.height=Math.floor(n.height*n.scale),r.canvas.style.width=n.width+"px",r.canvas.style.height=n.height+"px",r.ctx.scale(r.options.scale,r.options.scale),r.ctx.translate(-n.x,-n.y),r.context.logger.debug("EXPERIMENTAL ForeignObject renderer initialized ("+n.width+"x"+n.height+" at "+n.x+","+n.y+") with scale "+n.scale),r}return t(n,e),n.prototype.render=function(e){return r(this,void 0,void 0,(function(){var t,n;return A(this,(function(r){switch(r.label){case 0:return t=zr(this.options.width*this.options.scale,this.options.height*this.options.scale,this.options.scale,this.options.scale,e),[4,ys(t)];case 1:return n=r.sent(),this.options.backgroundColor&&(this.ctx.fillStyle=ft(this.options.backgroundColor),this.ctx.fillRect(0,0,this.options.width*this.options.scale,this.options.height*this.options.scale)),this.ctx.drawImage(n,-this.options.x*this.options.scale,-this.options.y*this.options.scale),[2,this.canvas]}}))}))},n}(ls),ys=function(e){return new Promise((function(t,n){var r=new Image;r.onload=function(){t(r)},r.onerror=n,r.src="data:image/svg+xml;charset=utf-8,"+encodeURIComponent((new XMLSerializer).serializeToString(e))}))},ws=function(){function e(e){var t=e.id,n=e.enabled;this.id=t,this.enabled=n,this.start=Date.now()}return e.prototype.debug=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.enabled&&("undefined"!=typeof window&&window.console&&"function"==typeof console.debug?console.debug.apply(console,i([this.id,this.getTime()+"ms"],e)):this.info.apply(this,e))},e.prototype.getTime=function(){return Date.now()-this.start},e.prototype.info=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.enabled&&"undefined"!=typeof window&&window.console&&"function"==typeof console.info&&console.info.apply(console,i([this.id,this.getTime()+"ms"],e))},e.prototype.warn=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.enabled&&("undefined"!=typeof window&&window.console&&"function"==typeof console.warn?console.warn.apply(console,i([this.id,this.getTime()+"ms"],e)):this.info.apply(this,e))},e.prototype.error=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.enabled&&("undefined"!=typeof window&&window.console&&"function"==typeof console.error?console.error.apply(console,i([this.id,this.getTime()+"ms"],e)):this.info.apply(this,e))},e.instances={},e}(),vs=function(){function e(t,n){var r;this.windowBounds=n,this.instanceName="#"+e.instanceCount++,this.logger=new ws({id:this.instanceName,enabled:t.logging}),this.cache=null!==(r=t.cache)&&void 0!==r?r:new xi(this,t)}return e.instanceCount=1,e}();"undefined"!=typeof window&&Ci.setContext(window);var Bs=function(e,t){return r(void 0,void 0,void 0,(function(){var r,i,o,c,l,u,h,d,f,p,g,m,y,w,v,B,b,_,C,x,U,F,E,Q,S,I,k,D,M,T,O,L,P,H,R,N,V,K;return A(this,(function(A){switch(A.label){case 0:if(!e||"object"!=typeof e)return[2,Promise.reject("Invalid element provided as first argument")];if(!(r=e.ownerDocument))throw new Error("Element is not attached to a Document");if(!(i=r.defaultView))throw new Error("Document is not attached to a Window");return o={allowTaint:null!==(F=t.allowTaint)&&void 0!==F&&F,imageTimeout:null!==(E=t.imageTimeout)&&void 0!==E?E:15e3,proxy:t.proxy,useCORS:null!==(Q=t.useCORS)&&void 0!==Q&&Q},c=n({logging:null===(S=t.logging)||void 0===S||S,cache:t.cache},o),l={windowWidth:null!==(I=t.windowWidth)&&void 0!==I?I:i.innerWidth,windowHeight:null!==(k=t.windowHeight)&&void 0!==k?k:i.innerHeight,scrollX:null!==(D=t.scrollX)&&void 0!==D?D:i.pageXOffset,scrollY:null!==(M=t.scrollY)&&void 0!==M?M:i.pageYOffset},u=new s(l.scrollX,l.scrollY,l.windowWidth,l.windowHeight),h=new vs(c,u),d=null!==(T=t.foreignObjectRendering)&&void 0!==T&&T,f={allowTaint:null!==(O=t.allowTaint)&&void 0!==O&&O,onclone:t.onclone,ignoreElements:t.ignoreElements,inlineImages:d,copyStyles:d},h.logger.debug("Starting document clone with size "+u.width+"x"+u.height+" scrolled to "+-u.left+","+-u.top),p=new oi(h,e,f),(g=p.clonedReferenceElement)?[4,p.toIFrame(r,u)]:[2,Promise.reject("Unable to find element in cloned iframe")];case 1:return m=A.sent(),y=OA(g)||"HTML"===g.tagName?function(e){var t=e.body,n=e.documentElement;if(!t||!n)throw new Error("Unable to get document size");var r=Math.max(Math.max(t.scrollWidth,n.scrollWidth),Math.max(t.offsetWidth,n.offsetWidth),Math.max(t.clientWidth,n.clientWidth)),A=Math.max(Math.max(t.scrollHeight,n.scrollHeight),Math.max(t.offsetHeight,n.offsetHeight),Math.max(t.clientHeight,n.clientHeight));return new s(0,0,r,A)}(g.ownerDocument):a(h,g),w=y.width,v=y.height,B=y.left,b=y.top,_=bs(h,g,t.backgroundColor),C={canvas:t.canvas,backgroundColor:_,scale:null!==(P=null!==(L=t.scale)&&void 0!==L?L:i.devicePixelRatio)&&void 0!==P?P:1,x:(null!==(H=t.x)&&void 0!==H?H:0)+B,y:(null!==(R=t.y)&&void 0!==R?R:0)+b,width:null!==(N=t.width)&&void 0!==N?N:Math.ceil(w),height:null!==(V=t.height)&&void 0!==V?V:Math.ceil(v)},d?(h.logger.debug("Document cloned, using foreign object rendering"),[4,new ms(h,C).render(g)]):[3,3];case 2:return x=A.sent(),[3,5];case 3:return h.logger.debug("Document cloned, element located at "+B+","+b+" with size "+w+"x"+v+" using computed rendering"),h.logger.debug("Starting DOM parsing"),U=xA(h,g),_===U.styles.backgroundColor&&(U.styles.backgroundColor=bt.TRANSPARENT),h.logger.debug("Starting renderer for element at "+C.x+","+C.y+" with size "+C.width+"x"+C.height),[4,new us(h,C).render(U)];case 4:x=A.sent(),A.label=5;case 5:return(null===(K=t.removeContainer)||void 0===K||K)&&(oi.destroy(m)||h.logger.error("Cannot detach cloned iframe as it is not in the DOM anymore")),h.logger.debug("Finished rendering"),[2,x]}}))}))},bs=function(e,t,n){var r=t.ownerDocument,A=r.documentElement?Bt(e,getComputedStyle(r.documentElement).backgroundColor):bt.TRANSPARENT,i=r.body?Bt(e,getComputedStyle(r.body).backgroundColor):bt.TRANSPARENT,s="string"==typeof n?Bt(e,n):null===n?bt.TRANSPARENT:4294967295;return t===r.documentElement?dt(A)?dt(i)?s:i:A:s};return function(e,t){return void 0===t&&(t={}),Bs(e,t)}}()},9600:e=>{"use strict";function t(e){return"number"==typeof e||!!/^0x[0-9a-f]+$/i.test(e)||/^[-+]?(?:\d+(?:\.\d*)?|\.\d+)(e[-+]?\d+)?$/.test(e)}function n(e,t){return"constructor"===t&&"function"==typeof e[t]||"__proto__"===t}e.exports=function(e,r){r||(r={});var A={bools:{},strings:{},unknownFn:null};"function"==typeof r.unknown&&(A.unknownFn=r.unknown),"boolean"==typeof r.boolean&&r.boolean?A.allBools=!0:[].concat(r.boolean).filter(Boolean).forEach((function(e){A.bools[e]=!0}));var i={};function s(e){return i[e].some((function(e){return A.bools[e]}))}Object.keys(r.alias||{}).forEach((function(e){i[e]=[].concat(r.alias[e]),i[e].forEach((function(t){i[t]=[e].concat(i[e].filter((function(e){return t!==e})))}))})),[].concat(r.string).filter(Boolean).forEach((function(e){A.strings[e]=!0,i[e]&&[].concat(i[e]).forEach((function(e){A.strings[e]=!0}))}));var a=r.default||{},o={_:[]};function c(e,t,r){for(var i=e,s=0;s<t.length-1;s++){var a=t[s];if(n(i,a))return;void 0===i[a]&&(i[a]={}),i[a]!==Object.prototype&&i[a]!==Number.prototype&&i[a]!==String.prototype||(i[a]={}),i[a]===Array.prototype&&(i[a]=[]),i=i[a]}var o=t[t.length-1];n(i,o)||(i!==Object.prototype&&i!==Number.prototype&&i!==String.prototype||(i={}),i===Array.prototype&&(i=[]),void 0===i[o]||A.bools[o]||"boolean"==typeof i[o]?i[o]=r:Array.isArray(i[o])?i[o].push(r):i[o]=[i[o],r])}function l(e,n,r){if(!r||!A.unknownFn||function(e,t){return A.allBools&&/^--[^=]+$/.test(t)||A.strings[e]||A.bools[e]||i[e]}(e,r)||!1!==A.unknownFn(r)){var s=!A.strings[e]&&t(n)?Number(n):n;c(o,e.split("."),s),(i[e]||[]).forEach((function(e){c(o,e.split("."),s)}))}}Object.keys(A.bools).forEach((function(e){l(e,void 0!==a[e]&&a[e])}));var u=[];-1!==e.indexOf("--")&&(u=e.slice(e.indexOf("--")+1),e=e.slice(0,e.indexOf("--")));for(var h=0;h<e.length;h++){var d,f,p=e[h];if(/^--.+=/.test(p)){var g=p.match(/^--([^=]+)=([\s\S]*)$/);d=g[1];var m=g[2];A.bools[d]&&(m="false"!==m),l(d,m,p)}else if(/^--no-.+/.test(p))l(d=p.match(/^--no-(.+)/)[1],!1,p);else if(/^--.+/.test(p))d=p.match(/^--(.+)/)[1],void 0===(f=e[h+1])||/^(-|--)[^-]/.test(f)||A.bools[d]||A.allBools||i[d]&&s(d)?/^(true|false)$/.test(f)?(l(d,"true"===f,p),h+=1):l(d,!A.strings[d]||"",p):(l(d,f,p),h+=1);else if(/^-[^-]+/.test(p)){for(var y=p.slice(1,-1).split(""),w=!1,v=0;v<y.length;v++)if("-"!==(f=p.slice(v+2))){if(/[A-Za-z]/.test(y[v])&&"="===f[0]){l(y[v],f.slice(1),p),w=!0;break}if(/[A-Za-z]/.test(y[v])&&/-?\d+(\.\d*)?(e-?\d+)?$/.test(f)){l(y[v],f,p),w=!0;break}if(y[v+1]&&y[v+1].match(/\W/)){l(y[v],p.slice(v+2),p),w=!0;break}l(y[v],!A.strings[y[v]]||"",p)}else l(y[v],f,p);d=p.slice(-1)[0],w||"-"===d||(!e[h+1]||/^(-|--)[^-]/.test(e[h+1])||A.bools[d]||i[d]&&s(d)?e[h+1]&&/^(true|false)$/.test(e[h+1])?(l(d,"true"===e[h+1],p),h+=1):l(d,!A.strings[d]||"",p):(l(d,e[h+1],p),h+=1))}else if(A.unknownFn&&!1===A.unknownFn(p)||o._.push(A.strings._||!t(p)?p:Number(p)),r.stopEarly){o._.push.apply(o._,e.slice(h+1));break}}return Object.keys(a).forEach((function(e){var t,n,r;t=o,n=e.split("."),r=t,n.slice(0,-1).forEach((function(e){r=r[e]||{}})),n[n.length-1]in r||(c(o,e.split("."),a[e]),(i[e]||[]).forEach((function(t){c(o,t.split("."),a[e])})))})),r["--"]?o["--"]=u.slice():u.forEach((function(e){o._.push(e)})),o}},9942:e=>{"use strict";function t(e){if("string"!=typeof e)throw new TypeError("Path must be a string. Received "+JSON.stringify(e))}function n(e,t){for(var n,r="",A=0,i=-1,s=0,a=0;a<=e.length;++a){if(a<e.length)n=e.charCodeAt(a);else{if(47===n)break;n=47}if(47===n){if(i===a-1||1===s);else if(i!==a-1&&2===s){if(r.length<2||2!==A||46!==r.charCodeAt(r.length-1)||46!==r.charCodeAt(r.length-2))if(r.length>2){var o=r.lastIndexOf("/");if(o!==r.length-1){-1===o?(r="",A=0):A=(r=r.slice(0,o)).length-1-r.lastIndexOf("/"),i=a,s=0;continue}}else if(2===r.length||1===r.length){r="",A=0,i=a,s=0;continue}t&&(r.length>0?r+="/..":r="..",A=2)}else r.length>0?r+="/"+e.slice(i+1,a):r=e.slice(i+1,a),A=a-i-1;i=a,s=0}else 46===n&&-1!==s?++s:s=-1}return r}var r={resolve:function(){for(var e,r="",A=!1,i=arguments.length-1;i>=-1&&!A;i--){var s;i>=0?s=arguments[i]:(void 0===e&&(e=process.cwd()),s=e),t(s),0!==s.length&&(r=s+"/"+r,A=47===s.charCodeAt(0))}return r=n(r,!A),A?r.length>0?"/"+r:"/":r.length>0?r:"."},normalize:function(e){if(t(e),0===e.length)return".";var r=47===e.charCodeAt(0),A=47===e.charCodeAt(e.length-1);return 0!==(e=n(e,!r)).length||r||(e="."),e.length>0&&A&&(e+="/"),r?"/"+e:e},isAbsolute:function(e){return t(e),e.length>0&&47===e.charCodeAt(0)},join:function(){if(0===arguments.length)return".";for(var e,n=0;n<arguments.length;++n){var A=arguments[n];t(A),A.length>0&&(void 0===e?e=A:e+="/"+A)}return void 0===e?".":r.normalize(e)},relative:function(e,n){if(t(e),t(n),e===n)return"";if((e=r.resolve(e))===(n=r.resolve(n)))return"";for(var A=1;A<e.length&&47===e.charCodeAt(A);++A);for(var i=e.length,s=i-A,a=1;a<n.length&&47===n.charCodeAt(a);++a);for(var o=n.length-a,c=s<o?s:o,l=-1,u=0;u<=c;++u){if(u===c){if(o>c){if(47===n.charCodeAt(a+u))return n.slice(a+u+1);if(0===u)return n.slice(a+u)}else s>c&&(47===e.charCodeAt(A+u)?l=u:0===u&&(l=0));break}var h=e.charCodeAt(A+u);if(h!==n.charCodeAt(a+u))break;47===h&&(l=u)}var d="";for(u=A+l+1;u<=i;++u)u!==i&&47!==e.charCodeAt(u)||(0===d.length?d+="..":d+="/..");return d.length>0?d+n.slice(a+l):(a+=l,47===n.charCodeAt(a)&&++a,n.slice(a))},_makeLong:function(e){return e},dirname:function(e){if(t(e),0===e.length)return".";for(var n=e.charCodeAt(0),r=47===n,A=-1,i=!0,s=e.length-1;s>=1;--s)if(47===(n=e.charCodeAt(s))){if(!i){A=s;break}}else i=!1;return-1===A?r?"/":".":r&&1===A?"//":e.slice(0,A)},basename:function(e,n){if(void 0!==n&&"string"!=typeof n)throw new TypeError('"ext" argument must be a string');t(e);var r,A=0,i=-1,s=!0;if(void 0!==n&&n.length>0&&n.length<=e.length){if(n.length===e.length&&n===e)return"";var a=n.length-1,o=-1;for(r=e.length-1;r>=0;--r){var c=e.charCodeAt(r);if(47===c){if(!s){A=r+1;break}}else-1===o&&(s=!1,o=r+1),a>=0&&(c===n.charCodeAt(a)?-1==--a&&(i=r):(a=-1,i=o))}return A===i?i=o:-1===i&&(i=e.length),e.slice(A,i)}for(r=e.length-1;r>=0;--r)if(47===e.charCodeAt(r)){if(!s){A=r+1;break}}else-1===i&&(s=!1,i=r+1);return-1===i?"":e.slice(A,i)},extname:function(e){t(e);for(var n=-1,r=0,A=-1,i=!0,s=0,a=e.length-1;a>=0;--a){var o=e.charCodeAt(a);if(47!==o)-1===A&&(i=!1,A=a+1),46===o?-1===n?n=a:1!==s&&(s=1):-1!==n&&(s=-1);else if(!i){r=a+1;break}}return-1===n||-1===A||0===s||1===s&&n===A-1&&n===r+1?"":e.slice(n,A)},format:function(e){if(null===e||"object"!=typeof e)throw new TypeError('The "pathObject" argument must be of type Object. Received type '+typeof e);return function(e,t){var n=t.dir||t.root,r=t.base||(t.name||"")+(t.ext||"");return n?n===t.root?n+r:n+"/"+r:r}(0,e)},parse:function(e){t(e);var n={root:"",dir:"",base:"",ext:"",name:""};if(0===e.length)return n;var r,A=e.charCodeAt(0),i=47===A;i?(n.root="/",r=1):r=0;for(var s=-1,a=0,o=-1,c=!0,l=e.length-1,u=0;l>=r;--l)if(47!==(A=e.charCodeAt(l)))-1===o&&(c=!1,o=l+1),46===A?-1===s?s=l:1!==u&&(u=1):-1!==s&&(u=-1);else if(!c){a=l+1;break}return-1===s||-1===o||0===u||1===u&&s===o-1&&s===a+1?-1!==o&&(n.base=n.name=0===a&&i?e.slice(1,o):e.slice(a,o)):(0===a&&i?(n.name=e.slice(1,s),n.base=e.slice(1,o)):(n.name=e.slice(a,s),n.base=e.slice(a,o)),n.ext=e.slice(s,o)),a>0?n.dir=e.slice(0,a-1):i&&(n.dir="/"),n},sep:"/",delimiter:":",win32:null,posix:null};r.posix=r,e.exports=r},1359:(e,t)=>{"use strict";var n=Object.prototype.hasOwnProperty;function r(e){try{return decodeURIComponent(e.replace(/\+/g," "))}catch(e){return null}}function A(e){try{return encodeURIComponent(e)}catch(e){return null}}t.stringify=function(e,t){t=t||"";var r,i,s=[];for(i in"string"!=typeof t&&(t="?"),e)if(n.call(e,i)){if((r=e[i])||null!=r&&!isNaN(r)||(r=""),i=A(i),r=A(r),null===i||null===r)continue;s.push(i+"="+r)}return s.length?t+s.join("&"):""},t.parse=function(e){for(var t,n=/([^=?#&]+)=?([^&]*)/g,A={};t=n.exec(e);){var i=r(t[1]),s=r(t[2]);null===i||null===s||i in A||(A[i]=s)}return A}},8643:function(e){e.exports=function(){"use strict";var e=function(e){return e instanceof Uint8Array||e instanceof Uint16Array||e instanceof Uint32Array||e instanceof Int8Array||e instanceof Int16Array||e instanceof Int32Array||e instanceof Float32Array||e instanceof Float64Array||e instanceof Uint8ClampedArray},t=function(e,t){for(var n=Object.keys(t),r=0;r<n.length;++r)e[n[r]]=t[n[r]];return e},n="\n";function r(e){var t=new Error("(regl) "+e);throw console.error(t),t}function A(e,t){e||r(t)}function i(e){return e?": "+e:""}function s(e,t){switch(t){case"number":return"number"==typeof e;case"object":return"object"==typeof e;case"string":return"string"==typeof e;case"boolean":return"boolean"==typeof e;case"function":return"function"==typeof e;case"undefined":return void 0===e;case"symbol":return"symbol"==typeof e}}function a(e,t,n){t.indexOf(e)<0&&r("invalid value"+i(n)+". must be one of: "+t)}var o=["gl","canvas","container","attributes","pixelRatio","extensions","optionalExtensions","profile","onDone"];function c(e,t){for(e+="";e.length<t;)e=" "+e;return e}function l(){this.name="unknown",this.lines=[],this.index={},this.hasErrors=!1}function u(e,t){this.number=e,this.line=t,this.errors=[]}function h(e,t,n){this.file=e,this.line=t,this.message=n}function d(){var e=new Error,t=(e.stack||e).toString(),n=/compileProcedure.*\n\s*at.*\((.*)\)/.exec(t);if(n)return n[1];var r=/compileProcedure.*\n\s*at\s+(.*)(\n|$)/.exec(t);return r?r[1]:"unknown"}function f(){var e=new Error,t=(e.stack||e).toString(),n=/at REGLCommand.*\n\s+at.*\((.*)\)/.exec(t);if(n)return n[1];var r=/at REGLCommand.*\n\s+at\s+(.*)\n/.exec(t);return r?r[1]:"unknown"}function p(e,t){var n,r=e.split("\n"),A=1,i=0,s={unknown:new l,0:new l};s.unknown.name=s[0].name=t||d(),s.unknown.lines.push(new u(0,""));for(var a=0;a<r.length;++a){var o=r[a],c=/^\s*#\s*(\w+)\s+(.+)\s*$/.exec(o);if(c)switch(c[1]){case"line":var h=/(\d+)(\s+\d+)?/.exec(c[2]);h&&(A=0|h[1],h[2]&&((i=0|h[2])in s||(s[i]=new l)));break;case"define":var f=/SHADER_NAME(_B64)?\s+(.*)$/.exec(c[2]);f&&(s[i].name=f[1]?(n=f[2],"undefined"!=typeof atob?atob(n):"base64:"+n):f[2])}s[i].lines.push(new u(A++,o))}return Object.keys(s).forEach((function(e){var t=s[e];t.lines.forEach((function(e){t.index[e.number]=e}))})),s}function g(e){e._commandRef=d()}function m(e,t){var n=f();r(e+" in command "+(t||d())+("unknown"===n?"":" called from "+n))}function y(e,t,n,r){s(e,t)||m("invalid parameter type"+i(n)+". expected "+t+", got "+typeof e,r||d())}var w=33071,v={};function B(e,t){return 32820===e||32819===e||33635===e?2:34042===e?4:v[e]*t}function b(e){return!(e&e-1||!e)}v[5120]=v[5121]=1,v[5122]=v[5123]=v[36193]=v[33635]=v[32819]=v[32820]=2,v[5124]=v[5125]=v[5126]=v[34042]=4;var _=t(A,{optional:function(e){e()},raise:r,commandRaise:m,command:function(e,t,n){e||m(t,n||d())},parameter:function(e,t,n){e in t||r("unknown parameter ("+e+")"+i(n)+". possible values: "+Object.keys(t).join())},commandParameter:function(e,t,n,r){e in t||m("unknown parameter ("+e+")"+i(n)+". possible values: "+Object.keys(t).join(),r||d())},constructor:function(e){Object.keys(e).forEach((function(e){o.indexOf(e)<0&&r('invalid regl constructor argument "'+e+'". must be one of '+o)}))},type:function(e,t,n){s(e,t)||r("invalid parameter type"+i(n)+". expected "+t+", got "+typeof e)},commandType:y,isTypedArray:function(t,n){e(t)||r("invalid parameter type"+i(n)+". must be a typed array")},nni:function(e,t){e>=0&&(0|e)===e||r("invalid parameter type, ("+e+")"+i(t)+". must be a nonnegative integer")},oneOf:a,shaderError:function(e,t,r,i,s){if(!e.getShaderParameter(t,e.COMPILE_STATUS)){var a=e.getShaderInfoLog(t),o=i===e.FRAGMENT_SHADER?"fragment":"vertex";y(r,"string",o+" shader source must be a string",s);var l=p(r,s),u=function(e){var t=[];return e.split("\n").forEach((function(e){if(!(e.length<5)){var n=/^ERROR:\s+(\d+):(\d+):\s*(.*)$/.exec(e);n?t.push(new h(0|n[1],0|n[2],n[3].trim())):e.length>0&&t.push(new h("unknown",0,e))}})),t}(a);(function(e,t){t.forEach((function(t){var n=e[t.file];if(n){var r=n.index[t.line];if(r)return r.errors.push(t),void(n.hasErrors=!0)}e.unknown.hasErrors=!0,e.unknown.lines[0].errors.push(t)}))})(l,u),Object.keys(l).forEach((function(e){var t=l[e];if(t.hasErrors){var r=[""],A=[""];i("file number "+e+": "+t.name+"\n","color:red;text-decoration:underline;font-weight:bold"),t.lines.forEach((function(e){if(e.errors.length>0){i(c(e.number,4)+"|  ","background-color:yellow; font-weight:bold"),i(e.line+n,"color:red; background-color:yellow; font-weight:bold");var t=0;e.errors.forEach((function(r){var A=r.message,s=/^\s*'(.*)'\s*:\s*(.*)$/.exec(A);if(s){var a=s[1];A=s[2],"assign"===a&&(a="="),t=Math.max(e.line.indexOf(a,t),0)}else t=0;i(c("| ",6)),i(c("^^^",t+3)+n,"font-weight:bold"),i(c("| ",6)),i(A+n,"font-weight:bold")})),i(c("| ",6)+n)}else i(c(e.number,4)+"|  "),i(e.line+n,"color:red")})),"undefined"==typeof document||window.chrome?console.log(r.join("")):(A[0]=r.join("%c"),console.log.apply(console,A))}function i(e,t){r.push(e),A.push(t||"")}})),A.raise("Error compiling "+o+" shader, "+l[0].name)}},linkError:function(e,t,r,i,s){if(!e.getProgramParameter(t,e.LINK_STATUS)){var a=e.getProgramInfoLog(t),o=p(r,s),c='Error linking program with vertex shader, "'+p(i,s)[0].name+'", and fragment shader "'+o[0].name+'"';"undefined"!=typeof document?console.log("%c"+c+"\n%c"+a,"color:red;text-decoration:underline;font-weight:bold","color:red"):console.log(c+n+a),A.raise(c)}},callSite:f,saveCommandRef:g,saveDrawInfo:function(e,t,n,r){function A(e){return e?r.id(e):0}function i(e,t){Object.keys(t).forEach((function(t){e[r.id(t)]=!0}))}g(e),e._fragId=A(e.static.frag),e._vertId=A(e.static.vert);var s=e._uniformSet={};i(s,t.static),i(s,t.dynamic);var a=e._attributeSet={};i(a,n.static),i(a,n.dynamic),e._hasCount="count"in e.static||"count"in e.dynamic||"elements"in e.static||"elements"in e.dynamic},framebufferFormat:function(e,t,n){e.texture?a(e.texture._texture.internalformat,t,"unsupported texture format for attachment"):a(e.renderbuffer._renderbuffer.format,n,"unsupported renderbuffer format for attachment")},guessCommand:d,texture2D:function(e,t,n){var r,i=t.width,s=t.height,a=t.channels;A(i>0&&i<=n.maxTextureSize&&s>0&&s<=n.maxTextureSize,"invalid texture shape"),e.wrapS===w&&e.wrapT===w||A(b(i)&&b(s),"incompatible wrap mode for texture, both width and height must be power of 2"),1===t.mipmask?1!==i&&1!==s&&A(9984!==e.minFilter&&9986!==e.minFilter&&9985!==e.minFilter&&9987!==e.minFilter,"min filter requires mipmap"):(A(b(i)&&b(s),"texture must be a square power of 2 to support mipmapping"),A(t.mipmask===(i<<1)-1,"missing or incomplete mipmap data")),5126===t.type&&(n.extensions.indexOf("oes_texture_float_linear")<0&&A(9728===e.minFilter&&9728===e.magFilter,"filter not supported, must enable oes_texture_float_linear"),A(!e.genMipmaps,"mipmap generation not supported with float textures"));var o=t.images;for(r=0;r<16;++r)if(o[r]){var c=i>>r,l=s>>r;A(t.mipmask&1<<r,"missing mipmap data");var u=o[r];if(A(u.width===c&&u.height===l,"invalid shape for mip images"),A(u.format===t.format&&u.internalformat===t.internalformat&&u.type===t.type,"incompatible type for mip image"),u.compressed);else if(u.data){var h=Math.ceil(B(u.type,a)*c/u.unpackAlignment)*u.unpackAlignment;A(u.data.byteLength===h*l,"invalid data for image, buffer size is inconsistent with image format")}else u.element||u.copy}else e.genMipmaps||A(!(t.mipmask&1<<r),"extra mipmap data");t.compressed&&A(!e.genMipmaps,"mipmap generation for compressed images not supported")},textureCube:function(e,t,n,r){var i=e.width,s=e.height,a=e.channels;A(i>0&&i<=r.maxTextureSize&&s>0&&s<=r.maxTextureSize,"invalid texture shape"),A(i===s,"cube map must be square"),A(t.wrapS===w&&t.wrapT===w,"wrap mode not supported by cube map");for(var o=0;o<n.length;++o){var c=n[o];A(c.width===i&&c.height===s,"inconsistent cube map face shape"),t.genMipmaps&&(A(!c.compressed,"can not generate mipmap for compressed textures"),A(1===c.mipmask,"can not specify mipmaps and generate mipmaps"));for(var l=c.images,u=0;u<16;++u){var h=l[u];if(h){var d=i>>u,f=s>>u;A(c.mipmask&1<<u,"missing mipmap data"),A(h.width===d&&h.height===f,"invalid shape for mip images"),A(h.format===e.format&&h.internalformat===e.internalformat&&h.type===e.type,"incompatible type for mip image"),h.compressed||(h.data?A(h.data.byteLength===d*f*Math.max(B(h.type,a),h.unpackAlignment),"invalid data for image, buffer size is inconsistent with image format"):h.element||h.copy)}}}}}),C=0;function x(e,t){this.id=C++,this.type=e,this.data=t}function U(e){return e.replace(/\\/g,"\\\\").replace(/"/g,'\\"')}function F(e){if(0===e.length)return[];var t=e.charAt(0),n=e.charAt(e.length-1);if(e.length>1&&t===n&&('"'===t||"'"===t))return['"'+U(e.substr(1,e.length-2))+'"'];var r=/\[(false|true|null|\d+|'[^']*'|"[^"]*")\]/.exec(e);if(r)return F(e.substr(0,r.index)).concat(F(r[1])).concat(F(e.substr(r.index+r[0].length)));var A=e.split(".");if(1===A.length)return['"'+U(e)+'"'];for(var i=[],s=0;s<A.length;++s)i=i.concat(F(A[s]));return i}function E(e){return"["+F(e).join("][")+"]"}var Q={DynamicVariable:x,define:function(e,t){return new x(e,E(t+""))},isDynamic:function(e){return"function"==typeof e&&!e._reglType||e instanceof x},unbox:function e(t,n){return"function"==typeof t?new x(0,t):"number"==typeof t||"boolean"==typeof t?new x(5,t):Array.isArray(t)?new x(6,t.map((function(t,r){return e(t,n+"["+r+"]")}))):t instanceof x?t:void _(!1,"invalid option type in uniform "+n)},accessor:E},S={next:"function"==typeof requestAnimationFrame?function(e){return requestAnimationFrame(e)}:function(e){return setTimeout(e,16)},cancel:"function"==typeof cancelAnimationFrame?function(e){return cancelAnimationFrame(e)}:clearTimeout},I="undefined"!=typeof performance&&performance.now?function(){return performance.now()}:function(){return+new Date};function k(e){return"string"==typeof e?e.split():(_(Array.isArray(e),"invalid extension array"),e)}function D(e){return"string"==typeof e?(_("undefined"!=typeof document,"not supported outside of DOM"),document.querySelector(e)):e}function M(e){var n,r,A,i,s,a=e||{},o={},c=[],l=[],u="undefined"==typeof window?1:window.devicePixelRatio,h=!1,d=function(e){e&&_.raise(e)},f=function(){};if("string"==typeof a?(_("undefined"!=typeof document,"selector queries only supported in DOM environments"),n=document.querySelector(a),_(n,"invalid query string for element")):"object"==typeof a?"string"==typeof(s=a).nodeName&&"function"==typeof s.appendChild&&"function"==typeof s.getBoundingClientRect?n=a:function(e){return"function"==typeof e.drawArrays||"function"==typeof e.drawElements}(a)?A=(i=a).canvas:(_.constructor(a),"gl"in a?i=a.gl:"canvas"in a?A=D(a.canvas):"container"in a&&(r=D(a.container)),"attributes"in a&&(o=a.attributes,_.type(o,"object","invalid context attributes")),"extensions"in a&&(c=k(a.extensions)),"optionalExtensions"in a&&(l=k(a.optionalExtensions)),"onDone"in a&&(_.type(a.onDone,"function","invalid or missing onDone callback"),d=a.onDone),"profile"in a&&(h=!!a.profile),"pixelRatio"in a&&(u=+a.pixelRatio,_(u>0,"invalid pixel ratio"))):_.raise("invalid arguments to regl"),n&&("canvas"===n.nodeName.toLowerCase()?A=n:r=n),!i){if(!A){_("undefined"!=typeof document,"must manually specify webgl context outside of DOM environments");var p=function(e,n,r){var A,i=document.createElement("canvas");function s(){var t=window.innerWidth,n=window.innerHeight;if(e!==document.body){var A=i.getBoundingClientRect();t=A.right-A.left,n=A.bottom-A.top}i.width=r*t,i.height=r*n}return t(i.style,{border:0,margin:0,padding:0,top:0,left:0,width:"100%",height:"100%"}),e.appendChild(i),e===document.body&&(i.style.position="absolute",t(e.style,{margin:0,padding:0})),e!==document.body&&"function"==typeof ResizeObserver?(A=new ResizeObserver((function(){setTimeout(s)}))).observe(e):window.addEventListener("resize",s,!1),s(),{canvas:i,onDestroy:function(){A?A.disconnect():window.removeEventListener("resize",s),e.removeChild(i)}}}(r||document.body,0,u);if(!p)return null;A=p.canvas,f=p.onDestroy}void 0===o.premultipliedAlpha&&(o.premultipliedAlpha=!0),i=function(e,t){function n(n){try{return e.getContext(n,t)}catch(e){return null}}return n("webgl")||n("experimental-webgl")||n("webgl-experimental")}(A,o)}return i?{gl:i,canvas:A,container:r,extensions:c,optionalExtensions:l,pixelRatio:u,profile:h,onDone:d,onDestroy:f}:(f(),d("webgl not supported, try upgrading your browser or graphics drivers http://get.webgl.org"),null)}function T(e,t){for(var n=Array(e),r=0;r<e;++r)n[r]=t(r);return n}function O(e){var t,n;return t=(e>65535)<<4,t|=n=((e>>>=t)>255)<<3,t|=n=((e>>>=n)>15)<<2,(t|=n=((e>>>=n)>3)<<1)|(e>>>=n)>>1}function L(){var e=T(8,(function(){return[]}));function t(t){var n=function(e){for(var t=16;t<=1<<28;t*=16)if(e<=t)return t;return 0}(t),r=e[O(n)>>2];return r.length>0?r.pop():new ArrayBuffer(n)}function n(t){e[O(t.byteLength)>>2].push(t)}return{alloc:t,free:n,allocType:function(e,n){var r=null;switch(e){case 5120:r=new Int8Array(t(n),0,n);break;case 5121:r=new Uint8Array(t(n),0,n);break;case 5122:r=new Int16Array(t(2*n),0,n);break;case 5123:r=new Uint16Array(t(2*n),0,n);break;case 5124:r=new Int32Array(t(4*n),0,n);break;case 5125:r=new Uint32Array(t(4*n),0,n);break;case 5126:r=new Float32Array(t(4*n),0,n);break;default:return null}return r.length!==n?r.subarray(0,n):r},freeType:function(e){n(e.buffer)}}}var P=L();P.zero=L();var H=3553,R=6408,N=5126,V=36160;function K(t){return!!t&&"object"==typeof t&&Array.isArray(t.shape)&&Array.isArray(t.stride)&&"number"==typeof t.offset&&t.shape.length===t.stride.length&&(Array.isArray(t.data)||e(t.data))}var j=function(e){return Object.keys(e).map((function(t){return e[t]}))},$={shape:function(e){for(var t=[],n=e;n.length;n=n[0])t.push(n.length);return t},flatten:function(e,t,n,r){var A=1;if(t.length)for(var i=0;i<t.length;++i)A*=t[i];else A=0;var s=r||P.allocType(n,A);switch(t.length){case 0:break;case 1:!function(e,t,n){for(var r=0;r<t;++r)n[r]=e[r]}(e,t[0],s);break;case 2:!function(e,t,n,r){for(var A=0,i=0;i<t;++i)for(var s=e[i],a=0;a<n;++a)r[A++]=s[a]}(e,t[0],t[1],s);break;case 3:G(e,t[0],t[1],t[2],s,0);break;default:z(e,t,0,s,0)}return s}};function G(e,t,n,r,A,i){for(var s=i,a=0;a<t;++a)for(var o=e[a],c=0;c<n;++c)for(var l=o[c],u=0;u<r;++u)A[s++]=l[u]}function z(e,t,n,r,A){for(var i=1,s=n+1;s<t.length;++s)i*=t[s];var a=t[n];if(t.length-n==4){var o=t[n+1],c=t[n+2],l=t[n+3];for(s=0;s<a;++s)G(e[s],o,c,l,r,A),A+=i}else for(s=0;s<a;++s)z(e[s],t,n+1,r,A),A+=i}var W={"[object Int8Array]":5120,"[object Int16Array]":5122,"[object Int32Array]":5124,"[object Uint8Array]":5121,"[object Uint8ClampedArray]":5121,"[object Uint16Array]":5123,"[object Uint32Array]":5125,"[object Float32Array]":5126,"[object Float64Array]":5121,"[object ArrayBuffer]":5121},q={int8:5120,int16:5122,int32:5124,uint8:5121,uint16:5123,uint32:5125,float:5126,float32:5126},J={dynamic:35048,stream:35040,static:35044},Y=$.flatten,X=$.shape,Z=5121,ee=5126,te=[];function ne(e){return 0|W[Object.prototype.toString.call(e)]}function re(e,t){for(var n=0;n<t.length;++n)e[n]=t[n]}function Ae(e,t,n,r,A,i,s){for(var a=0,o=0;o<n;++o)for(var c=0;c<r;++c)e[a++]=t[A*o+i*c+s]}te[5120]=1,te[5122]=2,te[5124]=4,te[5121]=1,te[5123]=2,te[5125]=4,te[5126]=4;var ie={points:0,point:0,lines:1,line:1,triangles:4,triangle:4,"line loop":2,"line strip":3,"triangle strip":5,"triangle fan":6},se=5121,ae=5123,oe=5125,ce=34963;var le=new Float32Array(1),ue=new Uint32Array(le.buffer);function he(e){for(var t=P.allocType(5123,e.length),n=0;n<e.length;++n)if(isNaN(e[n]))t[n]=65535;else if(e[n]===1/0)t[n]=31744;else if(e[n]===-1/0)t[n]=64512;else{le[0]=e[n];var r=ue[0],A=r>>>31<<15,i=(r<<1>>>24)-127,s=r>>13&1023;if(i<-24)t[n]=A;else if(i<-14){var a=-14-i;t[n]=A+(s+1024>>a)}else t[n]=i>15?A+31744:A+(i+15<<10)+s}return t}function de(t){return Array.isArray(t)||e(t)}var fe=function(e){return!(e&e-1||!e)},pe=3553,ge=34067,me=34069,ye=6408,we=6406,ve=6407,Be=6409,be=6410,_e=32855,Ce=6402,xe=34041,Ue=35904,Fe=35906,Ee=36193,Qe=33776,Se=33777,Ie=33778,ke=33779,De=5121,Me=5123,Te=5125,Oe=5126,Le=33071,Pe=9728,He=9984,Re=9987,Ne=4352,Ve=33984,Ke=[He,9986,9985,Re],je=[0,Be,be,ve,ye],$e={};function Ge(e){return"[object "+e+"]"}$e[6409]=$e[6406]=$e[6402]=1,$e[34041]=$e[6410]=2,$e[6407]=$e[35904]=3,$e[6408]=$e[35906]=4;var ze=Ge("HTMLCanvasElement"),We=Ge("OffscreenCanvas"),qe=Ge("CanvasRenderingContext2D"),Je=Ge("ImageBitmap"),Ye=Ge("HTMLImageElement"),Xe=Ge("HTMLVideoElement"),Ze=Object.keys(W).concat([ze,We,qe,Je,Ye,Xe]),et=[];et[5121]=1,et[5126]=4,et[36193]=2,et[5123]=2,et[5125]=4;var tt=[];function nt(e){return Array.isArray(e)&&(0===e.length||"number"==typeof e[0])}function rt(e){return!!Array.isArray(e)&&!(0===e.length||!de(e[0]))}function At(e){return Object.prototype.toString.call(e)}function it(e){return At(e)===ze}function st(e){return At(e)===We}function at(e){if(!e)return!1;var t=At(e);return Ze.indexOf(t)>=0||nt(e)||rt(e)||K(e)}function ot(e){return 0|W[Object.prototype.toString.call(e)]}function ct(e,t){return P.allocType(e.type===Ee?Oe:e.type,t)}function lt(e,t){e.type===Ee?(e.data=he(t),P.freeType(t)):e.data=t}function ut(e,t,n,r,A,i){var s;if(s=void 0!==tt[e]?tt[e]:$e[e]*et[t],i&&(s*=6),A){for(var a=0,o=n;o>=1;)a+=s*o*o,o/=2;return a}return s*n*r}function ht(n,r,A,i,s,a,o){var c={"don't care":Ne,"dont care":Ne,nice:4354,fast:4353},l={repeat:10497,clamp:Le,mirror:33648},u={nearest:Pe,linear:9729},h=t({mipmap:Re,"nearest mipmap nearest":He,"linear mipmap nearest":9985,"nearest mipmap linear":9986,"linear mipmap linear":Re},u),d={none:0,browser:37444},f={uint8:De,rgba4:32819,rgb565:33635,"rgb5 a1":32820},p={alpha:we,luminance:Be,"luminance alpha":be,rgb:ve,rgba:ye,rgba4:32854,"rgb5 a1":_e,rgb565:36194},g={};r.ext_srgb&&(p.srgb=Ue,p.srgba=Fe),r.oes_texture_float&&(f.float32=f.float=Oe),r.oes_texture_half_float&&(f.float16=f["half float"]=Ee),r.webgl_depth_texture&&(t(p,{depth:Ce,"depth stencil":xe}),t(f,{uint16:Me,uint32:Te,"depth stencil":34042})),r.webgl_compressed_texture_s3tc&&t(g,{"rgb s3tc dxt1":Qe,"rgba s3tc dxt1":Se,"rgba s3tc dxt3":Ie,"rgba s3tc dxt5":ke}),r.webgl_compressed_texture_atc&&t(g,{"rgb atc":35986,"rgba atc explicit alpha":35987,"rgba atc interpolated alpha":34798}),r.webgl_compressed_texture_pvrtc&&t(g,{"rgb pvrtc 4bppv1":35840,"rgb pvrtc 2bppv1":35841,"rgba pvrtc 4bppv1":35842,"rgba pvrtc 2bppv1":35843}),r.webgl_compressed_texture_etc1&&(g["rgb etc1"]=36196);var m=Array.prototype.slice.call(n.getParameter(34467));Object.keys(g).forEach((function(e){var t=g[e];m.indexOf(t)>=0&&(p[e]=t)}));var y=Object.keys(p);A.textureFormats=y;var w=[];Object.keys(p).forEach((function(e){var t=p[e];w[t]=e}));var v=[];Object.keys(f).forEach((function(e){var t=f[e];v[t]=e}));var B=[];Object.keys(u).forEach((function(e){B[u[e]]=e}));var b=[];Object.keys(h).forEach((function(e){var t=h[e];b[t]=e}));var C=[];Object.keys(l).forEach((function(e){C[l[e]]=e}));var x=y.reduce((function(e,t){var n=p[t];return n===Be||n===we||n===Be||n===be||n===Ce||n===xe||r.ext_srgb&&(n===Ue||n===Fe)?e[n]=n:n===_e||t.indexOf("rgba")>=0?e[n]=ye:e[n]=ve,e}),{});function U(){this.internalformat=ye,this.format=ye,this.type=De,this.compressed=!1,this.premultiplyAlpha=!1,this.flipY=!1,this.unpackAlignment=1,this.colorSpace=37444,this.width=0,this.height=0,this.channels=0}function F(e,t){e.internalformat=t.internalformat,e.format=t.format,e.type=t.type,e.compressed=t.compressed,e.premultiplyAlpha=t.premultiplyAlpha,e.flipY=t.flipY,e.unpackAlignment=t.unpackAlignment,e.colorSpace=t.colorSpace,e.width=t.width,e.height=t.height,e.channels=t.channels}function E(e,t){if("object"==typeof t&&t){if("premultiplyAlpha"in t&&(_.type(t.premultiplyAlpha,"boolean","invalid premultiplyAlpha"),e.premultiplyAlpha=t.premultiplyAlpha),"flipY"in t&&(_.type(t.flipY,"boolean","invalid texture flip"),e.flipY=t.flipY),"alignment"in t&&(_.oneOf(t.alignment,[1,2,4,8],"invalid texture unpack alignment"),e.unpackAlignment=t.alignment),"colorSpace"in t&&(_.parameter(t.colorSpace,d,"invalid colorSpace"),e.colorSpace=d[t.colorSpace]),"type"in t){var n=t.type;_(r.oes_texture_float||!("float"===n||"float32"===n),"you must enable the OES_texture_float extension in order to use floating point textures."),_(r.oes_texture_half_float||!("half float"===n||"float16"===n),"you must enable the OES_texture_half_float extension in order to use 16-bit floating point textures."),_(r.webgl_depth_texture||!("uint16"===n||"uint32"===n||"depth stencil"===n),"you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures."),_.parameter(n,f,"invalid texture type"),e.type=f[n]}var i=e.width,s=e.height,a=e.channels,o=!1;"shape"in t?(_(Array.isArray(t.shape)&&t.shape.length>=2,"shape must be an array"),i=t.shape[0],s=t.shape[1],3===t.shape.length&&(a=t.shape[2],_(a>0&&a<=4,"invalid number of channels"),o=!0),_(i>=0&&i<=A.maxTextureSize,"invalid width"),_(s>=0&&s<=A.maxTextureSize,"invalid height")):("radius"in t&&(i=s=t.radius,_(i>=0&&i<=A.maxTextureSize,"invalid radius")),"width"in t&&(i=t.width,_(i>=0&&i<=A.maxTextureSize,"invalid width")),"height"in t&&(s=t.height,_(s>=0&&s<=A.maxTextureSize,"invalid height")),"channels"in t&&(a=t.channels,_(a>0&&a<=4,"invalid number of channels"),o=!0)),e.width=0|i,e.height=0|s,e.channels=0|a;var c=!1;if("format"in t){var l=t.format;_(r.webgl_depth_texture||!("depth"===l||"depth stencil"===l),"you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures."),_.parameter(l,p,"invalid texture format");var u=e.internalformat=p[l];e.format=x[u],l in f&&("type"in t||(e.type=f[l])),l in g&&(e.compressed=!0),c=!0}!o&&c?e.channels=$e[e.format]:o&&!c?e.channels!==je[e.format]&&(e.format=e.internalformat=je[e.channels]):c&&o&&_(e.channels===$e[e.format],"number of channels inconsistent with specified format")}}function Q(e){n.pixelStorei(37440,e.flipY),n.pixelStorei(37441,e.premultiplyAlpha),n.pixelStorei(37443,e.colorSpace),n.pixelStorei(3317,e.unpackAlignment)}function S(){U.call(this),this.xOffset=0,this.yOffset=0,this.data=null,this.needsFree=!1,this.element=null,this.needsCopy=!1}function I(t,n){var r=null;if(at(n)?r=n:n&&(_.type(n,"object","invalid pixel data type"),E(t,n),"x"in n&&(t.xOffset=0|n.x),"y"in n&&(t.yOffset=0|n.y),at(n.data)&&(r=n.data)),_(!t.compressed||r instanceof Uint8Array,"compressed texture data must be stored in a uint8array"),n.copy){_(!r,"can not specify copy and data field for the same texture");var i=s.viewportWidth,a=s.viewportHeight;t.width=t.width||i-t.xOffset,t.height=t.height||a-t.yOffset,t.needsCopy=!0,_(t.xOffset>=0&&t.xOffset<i&&t.yOffset>=0&&t.yOffset<a&&t.width>0&&t.width<=i&&t.height>0&&t.height<=a,"copy texture read out of bounds")}else if(r){if(e(r))t.channels=t.channels||4,t.data=r,"type"in n||t.type!==De||(t.type=ot(r));else if(nt(r))t.channels=t.channels||4,function(e,t){var n=t.length;switch(e.type){case De:case Me:case Te:case Oe:var r=P.allocType(e.type,n);r.set(t),e.data=r;break;case Ee:e.data=he(t);break;default:_.raise("unsupported texture type, must specify a typed array")}}(t,r),t.alignment=1,t.needsFree=!0;else if(K(r)){var o=r.data;Array.isArray(o)||t.type!==De||(t.type=ot(o));var c,l,u,h,d,f,p=r.shape,g=r.stride;3===p.length?(u=p[2],f=g[2]):(_(2===p.length,"invalid ndarray pixel data, must be 2 or 3D"),u=1,f=1),c=p[0],l=p[1],h=g[0],d=g[1],t.alignment=1,t.width=c,t.height=l,t.channels=u,t.format=t.internalformat=je[u],t.needsFree=!0,function(e,t,n,r,A,i){for(var s=e.width,a=e.height,o=e.channels,c=ct(e,s*a*o),l=0,u=0;u<a;++u)for(var h=0;h<s;++h)for(var d=0;d<o;++d)c[l++]=t[n*h+r*u+A*d+i];lt(e,c)}(t,o,h,d,f,r.offset)}else if(it(r)||st(r)||At(r)===qe)it(r)||st(r)?t.element=r:t.element=r.canvas,t.width=t.element.width,t.height=t.element.height,t.channels=4;else if(function(e){return At(e)===Je}(r))t.element=r,t.width=r.width,t.height=r.height,t.channels=4;else if(function(e){return At(e)===Ye}(r))t.element=r,t.width=r.naturalWidth,t.height=r.naturalHeight,t.channels=4;else if(function(e){return At(e)===Xe}(r))t.element=r,t.width=r.videoWidth,t.height=r.videoHeight,t.channels=4;else if(rt(r)){var m=t.width||r[0].length,y=t.height||r.length,w=t.channels;w=de(r[0][0])?w||r[0][0].length:w||1;for(var v=$.shape(r),B=1,b=0;b<v.length;++b)B*=v[b];var C=ct(t,B);$.flatten(r,v,"",C),lt(t,C),t.alignment=1,t.width=m,t.height=y,t.channels=w,t.format=t.internalformat=je[w],t.needsFree=!0}}else t.width=t.width||1,t.height=t.height||1,t.channels=t.channels||4;t.type===Oe?_(A.extensions.indexOf("oes_texture_float")>=0,"oes_texture_float extension not enabled"):t.type===Ee&&_(A.extensions.indexOf("oes_texture_half_float")>=0,"oes_texture_half_float extension not enabled")}function k(e,t,r){var A=e.element,s=e.data,a=e.internalformat,o=e.format,c=e.type,l=e.width,u=e.height;Q(e),A?n.texImage2D(t,r,o,o,c,A):e.compressed?n.compressedTexImage2D(t,r,a,l,u,0,s):e.needsCopy?(i(),n.copyTexImage2D(t,r,o,e.xOffset,e.yOffset,l,u,0)):n.texImage2D(t,r,o,l,u,0,o,c,s||null)}function D(e,t,r,A,s){var a=e.element,o=e.data,c=e.internalformat,l=e.format,u=e.type,h=e.width,d=e.height;Q(e),a?n.texSubImage2D(t,s,r,A,l,u,a):e.compressed?n.compressedTexSubImage2D(t,s,r,A,c,h,d,o):e.needsCopy?(i(),n.copyTexSubImage2D(t,s,r,A,e.xOffset,e.yOffset,h,d)):n.texSubImage2D(t,s,r,A,h,d,l,u,o)}var M=[];function T(){return M.pop()||new S}function O(e){e.needsFree&&P.freeType(e.data),S.call(e),M.push(e)}function L(){U.call(this),this.genMipmaps=!1,this.mipmapHint=Ne,this.mipmask=0,this.images=Array(16)}function H(e,t,n){var r=e.images[0]=T();e.mipmask=1,r.width=e.width=t,r.height=e.height=n,r.channels=e.channels=4}function R(e,t){var n=null;if(at(t))F(n=e.images[0]=T(),e),I(n,t),e.mipmask=1;else if(E(e,t),Array.isArray(t.mipmap))for(var r=t.mipmap,A=0;A<r.length;++A)F(n=e.images[A]=T(),e),n.width>>=A,n.height>>=A,I(n,r[A]),e.mipmask|=1<<A;else F(n=e.images[0]=T(),e),I(n,t),e.mipmask=1;F(e,e.images[0]),!e.compressed||e.internalformat!==Qe&&e.internalformat!==Se&&e.internalformat!==Ie&&e.internalformat!==ke||_(e.width%4==0&&e.height%4==0,"for compressed texture formats, mipmap level 0 must have width and height that are a multiple of 4")}function N(e,t){for(var n=e.images,r=0;r<n.length;++r){if(!n[r])return;k(n[r],t,r)}}var V=[];function G(){var e=V.pop()||new L;U.call(e),e.mipmask=0;for(var t=0;t<16;++t)e.images[t]=null;return e}function z(e){for(var t=e.images,n=0;n<t.length;++n)t[n]&&O(t[n]),t[n]=null;V.push(e)}function W(){this.minFilter=Pe,this.magFilter=Pe,this.wrapS=Le,this.wrapT=Le,this.anisotropic=1,this.genMipmaps=!1,this.mipmapHint=Ne}function q(e,t){if("min"in t){var n=t.min;_.parameter(n,h),e.minFilter=h[n],Ke.indexOf(e.minFilter)>=0&&!("faces"in t)&&(e.genMipmaps=!0)}if("mag"in t){var r=t.mag;_.parameter(r,u),e.magFilter=u[r]}var i=e.wrapS,s=e.wrapT;if("wrap"in t){var a=t.wrap;"string"==typeof a?(_.parameter(a,l),i=s=l[a]):Array.isArray(a)&&(_.parameter(a[0],l),_.parameter(a[1],l),i=l[a[0]],s=l[a[1]])}else{if("wrapS"in t){var o=t.wrapS;_.parameter(o,l),i=l[o]}if("wrapT"in t){var d=t.wrapT;_.parameter(d,l),s=l[d]}}if(e.wrapS=i,e.wrapT=s,"anisotropic"in t){var f=t.anisotropic;_("number"==typeof f&&f>=1&&f<=A.maxAnisotropic,"aniso samples must be between 1 and "),e.anisotropic=t.anisotropic}if("mipmap"in t){var p=!1;switch(typeof t.mipmap){case"string":_.parameter(t.mipmap,c,"invalid mipmap hint"),e.mipmapHint=c[t.mipmap],e.genMipmaps=!0,p=!0;break;case"boolean":p=e.genMipmaps=t.mipmap;break;case"object":_(Array.isArray(t.mipmap),"invalid mipmap type"),e.genMipmaps=!1,p=!0;break;default:_.raise("invalid mipmap type")}p&&!("min"in t)&&(e.minFilter=He)}}function J(e,t){n.texParameteri(t,10241,e.minFilter),n.texParameteri(t,10240,e.magFilter),n.texParameteri(t,10242,e.wrapS),n.texParameteri(t,10243,e.wrapT),r.ext_texture_filter_anisotropic&&n.texParameteri(t,34046,e.anisotropic),e.genMipmaps&&(n.hint(33170,e.mipmapHint),n.generateMipmap(t))}var Y=0,X={},Z=A.maxTextureUnits,ee=Array(Z).map((function(){return null}));function te(e){U.call(this),this.mipmask=0,this.internalformat=ye,this.id=Y++,this.refCount=1,this.target=e,this.texture=n.createTexture(),this.unit=-1,this.bindCount=0,this.texInfo=new W,o.profile&&(this.stats={size:0})}function ne(e){n.activeTexture(Ve),n.bindTexture(e.target,e.texture)}function re(){var e=ee[0];e?n.bindTexture(e.target,e.texture):n.bindTexture(pe,null)}function Ae(e){var t=e.texture;_(t,"must not double destroy texture");var r=e.unit,A=e.target;r>=0&&(n.activeTexture(Ve+r),n.bindTexture(A,null),ee[r]=null),n.deleteTexture(t),e.texture=null,e.params=null,e.pixels=null,e.refCount=0,delete X[e.id],a.textureCount--}return t(te.prototype,{bind:function(){var e=this;e.bindCount+=1;var t=e.unit;if(t<0){for(var r=0;r<Z;++r){var A=ee[r];if(A){if(A.bindCount>0)continue;A.unit=-1}ee[r]=e,t=r;break}t>=Z&&_.raise("insufficient number of texture units"),o.profile&&a.maxTextureUnits<t+1&&(a.maxTextureUnits=t+1),e.unit=t,n.activeTexture(Ve+t),n.bindTexture(e.target,e.texture)}return t},unbind:function(){this.bindCount-=1},decRef:function(){--this.refCount<=0&&Ae(this)}}),o.profile&&(a.getTotalTextureSize=function(){var e=0;return Object.keys(X).forEach((function(t){e+=X[t].stats.size})),e}),{create2D:function(e,t){var r=new te(pe);function i(e,t){var n=r.texInfo;W.call(n);var s=G();return"number"==typeof e?H(s,0|e,"number"==typeof t?0|t:0|e):e?(_.type(e,"object","invalid arguments to regl.texture"),q(n,e),R(s,e)):H(s,1,1),n.genMipmaps&&(s.mipmask=(s.width<<1)-1),r.mipmask=s.mipmask,F(r,s),_.texture2D(n,s,A),r.internalformat=s.internalformat,i.width=s.width,i.height=s.height,ne(r),N(s,pe),J(n,pe),re(),z(s),o.profile&&(r.stats.size=ut(r.internalformat,r.type,s.width,s.height,n.genMipmaps,!1)),i.format=w[r.internalformat],i.type=v[r.type],i.mag=B[n.magFilter],i.min=b[n.minFilter],i.wrapS=C[n.wrapS],i.wrapT=C[n.wrapT],i}return X[r.id]=r,a.textureCount++,i(e,t),i.subimage=function(e,t,n,A){_(!!e,"must specify image data");var s=0|t,a=0|n,o=0|A,c=T();return F(c,r),c.width=0,c.height=0,I(c,e),c.width=c.width||(r.width>>o)-s,c.height=c.height||(r.height>>o)-a,_(r.type===c.type&&r.format===c.format&&r.internalformat===c.internalformat,"incompatible format for texture.subimage"),_(s>=0&&a>=0&&s+c.width<=r.width&&a+c.height<=r.height,"texture.subimage write out of bounds"),_(r.mipmask&1<<o,"missing mipmap data"),_(c.data||c.element||c.needsCopy,"missing image data"),ne(r),D(c,pe,s,a,o),re(),O(c),i},i.resize=function(e,t){var A=0|e,s=0|t||A;if(A===r.width&&s===r.height)return i;i.width=r.width=A,i.height=r.height=s,ne(r);for(var a=0;r.mipmask>>a;++a){var c=A>>a,l=s>>a;if(!c||!l)break;n.texImage2D(pe,a,r.format,c,l,0,r.format,r.type,null)}return re(),o.profile&&(r.stats.size=ut(r.internalformat,r.type,A,s,!1,!1)),i},i._reglType="texture2d",i._texture=r,o.profile&&(i.stats=r.stats),i.destroy=function(){r.decRef()},i},createCube:function(e,t,r,i,s,c){var l=new te(ge);X[l.id]=l,a.cubeCount++;var u=new Array(6);function h(e,t,n,r,i,s){var a,c=l.texInfo;for(W.call(c),a=0;a<6;++a)u[a]=G();if("number"!=typeof e&&e)if("object"==typeof e)if(t)R(u[0],e),R(u[1],t),R(u[2],n),R(u[3],r),R(u[4],i),R(u[5],s);else if(q(c,e),E(l,e),"faces"in e){var d=e.faces;for(_(Array.isArray(d)&&6===d.length,"cube faces must be a length 6 array"),a=0;a<6;++a)_("object"==typeof d[a]&&!!d[a],"invalid input for cube map face"),F(u[a],l),R(u[a],d[a])}else for(a=0;a<6;++a)R(u[a],e);else _.raise("invalid arguments to cube map");else{var f=0|e||1;for(a=0;a<6;++a)H(u[a],f,f)}for(F(l,u[0]),_.optional((function(){A.npotTextureCube||_(fe(l.width)&&fe(l.height),"your browser does not support non power or two texture dimensions")})),c.genMipmaps?l.mipmask=(u[0].width<<1)-1:l.mipmask=u[0].mipmask,_.textureCube(l,c,u,A),l.internalformat=u[0].internalformat,h.width=u[0].width,h.height=u[0].height,ne(l),a=0;a<6;++a)N(u[a],me+a);for(J(c,ge),re(),o.profile&&(l.stats.size=ut(l.internalformat,l.type,h.width,h.height,c.genMipmaps,!0)),h.format=w[l.internalformat],h.type=v[l.type],h.mag=B[c.magFilter],h.min=b[c.minFilter],h.wrapS=C[c.wrapS],h.wrapT=C[c.wrapT],a=0;a<6;++a)z(u[a]);return h}return h(e,t,r,i,s,c),h.subimage=function(e,t,n,r,A){_(!!t,"must specify image data"),_("number"==typeof e&&e===(0|e)&&e>=0&&e<6,"invalid face");var i=0|n,s=0|r,a=0|A,o=T();return F(o,l),o.width=0,o.height=0,I(o,t),o.width=o.width||(l.width>>a)-i,o.height=o.height||(l.height>>a)-s,_(l.type===o.type&&l.format===o.format&&l.internalformat===o.internalformat,"incompatible format for texture.subimage"),_(i>=0&&s>=0&&i+o.width<=l.width&&s+o.height<=l.height,"texture.subimage write out of bounds"),_(l.mipmask&1<<a,"missing mipmap data"),_(o.data||o.element||o.needsCopy,"missing image data"),ne(l),D(o,me+e,i,s,a),re(),O(o),h},h.resize=function(e){var t=0|e;if(t!==l.width){h.width=l.width=t,h.height=l.height=t,ne(l);for(var r=0;r<6;++r)for(var A=0;l.mipmask>>A;++A)n.texImage2D(me+r,A,l.format,t>>A,t>>A,0,l.format,l.type,null);return re(),o.profile&&(l.stats.size=ut(l.internalformat,l.type,h.width,h.height,!1,!0)),h}},h._reglType="textureCube",h._texture=l,o.profile&&(h.stats=l.stats),h.destroy=function(){l.decRef()},h},clear:function(){for(var e=0;e<Z;++e)n.activeTexture(Ve+e),n.bindTexture(pe,null),ee[e]=null;j(X).forEach(Ae),a.cubeCount=0,a.textureCount=0},getTexture:function(e){return null},restore:function(){for(var e=0;e<Z;++e){var t=ee[e];t&&(t.bindCount=0,t.unit=-1,ee[e]=null)}j(X).forEach((function(e){e.texture=n.createTexture(),n.bindTexture(e.target,e.texture);for(var t=0;t<32;++t)if(e.mipmask&1<<t)if(e.target===pe)n.texImage2D(pe,t,e.internalformat,e.width>>t,e.height>>t,0,e.internalformat,e.type,null);else for(var r=0;r<6;++r)n.texImage2D(me+r,t,e.internalformat,e.width>>t,e.height>>t,0,e.internalformat,e.type,null);J(e.texInfo,e.target)}))},refresh:function(){for(var e=0;e<Z;++e){var t=ee[e];t&&(t.bindCount=0,t.unit=-1,ee[e]=null),n.activeTexture(Ve+e),n.bindTexture(pe,null),n.bindTexture(ge,null)}}}}tt[32854]=2,tt[32855]=2,tt[36194]=2,tt[34041]=4,tt[33776]=.5,tt[33777]=.5,tt[33778]=1,tt[33779]=1,tt[35986]=.5,tt[35987]=1,tt[34798]=1,tt[35840]=.5,tt[35841]=.25,tt[35842]=.5,tt[35843]=.25,tt[36196]=.5;var dt=36161,ft=32854,pt=[];function gt(e,t,n){return pt[e]*t*n}pt[32854]=2,pt[32855]=2,pt[36194]=2,pt[33189]=2,pt[36168]=1,pt[34041]=4,pt[35907]=4,pt[34836]=16,pt[34842]=8,pt[34843]=6;var mt=36160,yt=36161,wt=3553,vt=34069,Bt=[6407,6408],bt=[];bt[6408]=4,bt[6407]=3;var _t=[];_t[5121]=1,_t[5126]=4,_t[36193]=2;var Ct=[32854,32855,36194,35907,34842,34843,34836],xt={};xt[36053]="complete",xt[36054]="incomplete attachment",xt[36057]="incomplete dimensions",xt[36055]="incomplete, missing attachment",xt[36061]="unsupported";var Ut=34963,Ft=["attributes","elements","offset","count","primitive","instances"];function Et(){this.state=0,this.x=0,this.y=0,this.z=0,this.w=0,this.buffer=null,this.size=0,this.normalized=!1,this.type=5126,this.offset=0,this.stride=0,this.divisor=0}var Qt=5121,St=5126;function It(t,n,r,A,i,s,a){function o(o){var c;null===n.next?(_(i.preserveDrawingBuffer,'you must create a webgl context with "preserveDrawingBuffer":true in order to read pixels from the drawing buffer'),c=Qt):(_(null!==n.next.colorAttachments[0].texture,"You cannot read from a renderbuffer"),c=n.next.colorAttachments[0].texture._texture.type,_.optional((function(){s.oes_texture_float?(_(c===Qt||c===St,"Reading from a framebuffer is only allowed for the types 'uint8' and 'float'"),c===St&&_(a.readFloat,"Reading 'float' values is not permitted in your browser. For a fallback, please see: https://www.npmjs.com/package/glsl-read-float")):_(c===Qt,"Reading from a framebuffer is only allowed for the type 'uint8'")})));var l=0,u=0,h=A.framebufferWidth,d=A.framebufferHeight,f=null;e(o)?f=o:o&&(_.type(o,"object","invalid arguments to regl.read()"),l=0|o.x,u=0|o.y,_(l>=0&&l<A.framebufferWidth,"invalid x offset for regl.read"),_(u>=0&&u<A.framebufferHeight,"invalid y offset for regl.read"),h=0|(o.width||A.framebufferWidth-l),d=0|(o.height||A.framebufferHeight-u),f=o.data||null),f&&(c===Qt?_(f instanceof Uint8Array,"buffer must be 'Uint8Array' when reading from a framebuffer of type 'uint8'"):c===St&&_(f instanceof Float32Array,"buffer must be 'Float32Array' when reading from a framebuffer of type 'float'")),_(h>0&&h+l<=A.framebufferWidth,"invalid width for read pixels"),_(d>0&&d+u<=A.framebufferHeight,"invalid height for read pixels"),r();var p=h*d*4;return f||(c===Qt?f=new Uint8Array(p):c===St&&(f=f||new Float32Array(p))),_.isTypedArray(f,"data buffer for regl.read() must be a typedarray"),_(f.byteLength>=p,"data buffer for regl.read() too small"),t.pixelStorei(3333,4),t.readPixels(l,u,h,d,6408,c,f),f}return function(e){return e&&"framebuffer"in e?function(e){var t;return n.setFBO({framebuffer:e.framebuffer},(function(){t=o(e)})),t}(e):o(e)}}function kt(e){return Array.prototype.slice.call(e)}function Dt(e){return kt(e).join("")}var Mt="xyzw".split(""),Tt="dither",Ot="blend.enable",Lt="blend.color",Pt="blend.equation",Ht="blend.func",Rt="depth.enable",Nt="depth.func",Vt="depth.range",Kt="depth.mask",jt="colorMask",$t="cull.enable",Gt="cull.face",zt="frontFace",Wt="lineWidth",qt="polygonOffset.enable",Jt="polygonOffset.offset",Yt="sample.alpha",Xt="sample.enable",Zt="sample.coverage",en="stencil.enable",tn="stencil.mask",nn="stencil.func",rn="stencil.opFront",An="stencil.opBack",sn="scissor.enable",an="scissor.box",on="viewport",cn="profile",ln="framebuffer",un="vert",hn="frag",dn="elements",fn="primitive",pn="count",gn="offset",mn="instances",yn="vao",wn="Width",vn="Height",Bn=ln+wn,bn=ln+vn,_n=on+wn,Cn=on+vn,xn="drawingBuffer",Un=xn+wn,Fn=xn+vn,En=[Ht,Pt,nn,rn,An,Zt,on,an,Jt],Qn=34962,Sn=34963,In=5126,kn=35664,Dn=35665,Mn=35666,Tn=5124,On=35667,Ln=35668,Pn=35669,Hn=35670,Rn=35671,Nn=35672,Vn=35673,Kn=35674,jn=35675,$n=35676,Gn=35678,zn=35680,Wn=1028,qn=1029,Jn=2305,Yn=7680,Xn={0:0,1:1,zero:0,one:1,"src color":768,"one minus src color":769,"src alpha":770,"one minus src alpha":771,"dst color":774,"one minus dst color":775,"dst alpha":772,"one minus dst alpha":773,"constant color":32769,"one minus constant color":32770,"constant alpha":32771,"one minus constant alpha":32772,"src alpha saturate":776},Zn=["constant color, constant alpha","one minus constant color, constant alpha","constant color, one minus constant alpha","one minus constant color, one minus constant alpha","constant alpha, constant color","constant alpha, one minus constant color","one minus constant alpha, constant color","one minus constant alpha, one minus constant color"],er={never:512,less:513,"<":513,equal:514,"=":514,"==":514,"===":514,lequal:515,"<=":515,greater:516,">":516,notequal:517,"!=":517,"!==":517,gequal:518,">=":518,always:519},tr={0:0,zero:0,keep:7680,replace:7681,increment:7682,decrement:7683,"increment wrap":34055,"decrement wrap":34056,invert:5386},nr={frag:35632,vert:35633},rr={cw:2304,ccw:Jn};function Ar(t){return Array.isArray(t)||e(t)||K(t)}function ir(e){return e.sort((function(e,t){return e===on?-1:t===on?1:e<t?-1:1}))}function sr(e,t,n,r){this.thisDep=e,this.contextDep=t,this.propDep=n,this.append=r}function ar(e){return e&&!(e.thisDep||e.contextDep||e.propDep)}function or(e){return new sr(!1,!1,!1,e)}function cr(e,t){var n=e.type;if(0===n){var r=e.data.length;return new sr(!0,r>=1,r>=2,t)}if(4===n){var A=e.data;return new sr(A.thisDep,A.contextDep,A.propDep,t)}if(5===n)return new sr(!1,!1,!1,t);if(6===n){for(var i=!1,s=!1,a=!1,o=0;o<e.data.length;++o){var c=e.data[o];if(1===c.type)a=!0;else if(2===c.type)s=!0;else if(3===c.type)i=!0;else if(0===c.type){i=!0;var l=c.data;l>=1&&(s=!0),l>=2&&(a=!0)}else 4===c.type&&(i=i||c.data.thisDep,s=s||c.data.contextDep,a=a||c.data.propDep)}return new sr(i,s,a,t)}return new sr(3===n,2===n,1===n,t)}var lr=new sr(!1,!1,!1,(function(){}));function ur(e,n,r,A,i,s,a,o,c,l,u,h,d,f,p){var g=l.Record,m={add:32774,subtract:32778,"reverse subtract":32779};r.ext_blend_minmax&&(m.min=32775,m.max=32776);var y=r.angle_instanced_arrays,w=r.webgl_draw_buffers,v=r.oes_vertex_array_object,B={dirty:!0,profile:p.profile},b={},C=[],x={},U={};function F(e){return e.replace(".","_")}function E(e,t,n){var r=F(e);C.push(e),b[r]=B[r]=!!n,x[r]=t}function S(e,t,n){var r=F(e);C.push(e),Array.isArray(n)?(B[r]=n.slice(),b[r]=n.slice()):B[r]=b[r]=n,U[r]=t}E(Tt,3024),E(Ot,3042),S(Lt,"blendColor",[0,0,0,0]),S(Pt,"blendEquationSeparate",[32774,32774]),S(Ht,"blendFuncSeparate",[1,0,1,0]),E(Rt,2929,!0),S(Nt,"depthFunc",513),S(Vt,"depthRange",[0,1]),S(Kt,"depthMask",!0),S(jt,jt,[!0,!0,!0,!0]),E($t,2884),S(Gt,"cullFace",qn),S(zt,zt,Jn),S(Wt,Wt,1),E(qt,32823),S(Jt,"polygonOffset",[0,0]),E(Yt,32926),E(Xt,32928),S(Zt,"sampleCoverage",[1,!1]),E(en,2960),S(tn,"stencilMask",-1),S(nn,"stencilFunc",[519,0,-1]),S(rn,"stencilOpSeparate",[Wn,Yn,Yn,Yn]),S(An,"stencilOpSeparate",[qn,Yn,Yn,Yn]),E(sn,3089),S(an,"scissor",[0,0,e.drawingBufferWidth,e.drawingBufferHeight]),S(on,on,[0,0,e.drawingBufferWidth,e.drawingBufferHeight]);var I={gl:e,context:d,strings:n,next:b,current:B,draw:h,elements:s,buffer:i,shader:u,attributes:l.state,vao:l,uniforms:c,framebuffer:o,extensions:r,timer:f,isBufferArgs:Ar},k={primTypes:ie,compareFuncs:er,blendFuncs:Xn,blendEquations:m,stencilOps:tr,glTypes:q,orientationType:rr};_.optional((function(){I.isArrayLike=de})),w&&(k.backBuffer=[qn],k.drawBuffer=T(A.maxDrawbuffers,(function(e){return 0===e?[0]:T(e,(function(e){return 36064+e}))})));var D=0;function M(){var e=function(){var e=0,n=[],r=[];function A(){var n=[],r=[];return t((function(){n.push.apply(n,kt(arguments))}),{def:function(){var t="v"+e++;return r.push(t),arguments.length>0&&(n.push(t,"="),n.push.apply(n,kt(arguments)),n.push(";")),t},toString:function(){return Dt([r.length>0?"var "+r.join(",")+";":"",Dt(n)])}})}function i(){var e=A(),n=A(),r=e.toString,i=n.toString;function s(t,r){n(t,r,"=",e.def(t,r),";")}return t((function(){e.apply(e,kt(arguments))}),{def:e.def,entry:e,exit:n,save:s,set:function(t,n,r){s(t,n),e(t,n,"=",r,";")},toString:function(){return r()+i()}})}var s=A(),a={};return{global:s,link:function(t){for(var A=0;A<r.length;++A)if(r[A]===t)return n[A];var i="g"+e++;return n.push(i),r.push(t),i},block:A,proc:function(e,n){var r=[];function A(){var e="a"+r.length;return r.push(e),e}n=n||0;for(var s=0;s<n;++s)A();var o=i(),c=o.toString;return a[e]=t(o,{arg:A,toString:function(){return Dt(["function(",r.join(),"){",c(),"}"])}})},scope:i,cond:function(){var e=Dt(arguments),n=i(),r=i(),A=n.toString,s=r.toString;return t(n,{then:function(){return n.apply(n,kt(arguments)),this},else:function(){return r.apply(r,kt(arguments)),this},toString:function(){var t=s();return t&&(t="else{"+t+"}"),Dt(["if(",e,"){",A(),"}",t])}})},compile:function(){var e=['"use strict";',s,"return {"];Object.keys(a).forEach((function(t){e.push('"',t,'":',a[t].toString(),",")})),e.push("}");var t=Dt(e).replace(/;/g,";\n").replace(/}/g,"}\n").replace(/{/g,"{\n");return Function.apply(null,n.concat(t)).apply(null,r)}}}(),r=e.link,A=e.global;e.id=D++,e.batchId="0";var i=r(I),s=e.shared={props:"a0"};Object.keys(I).forEach((function(e){s[e]=A.def(i,".",e)})),_.optional((function(){e.CHECK=r(_),e.commandStr=_.guessCommand(),e.command=r(e.commandStr),e.assert=function(e,t,n){e("if(!(",t,"))",this.CHECK,".commandRaise(",r(n),",",this.command,");")},k.invalidBlendCombinations=Zn}));var a=e.next={},o=e.current={};Object.keys(U).forEach((function(e){Array.isArray(B[e])&&(a[e]=A.def(s.next,".",e),o[e]=A.def(s.current,".",e))}));var c=e.constants={};Object.keys(k).forEach((function(e){c[e]=A.def(JSON.stringify(k[e]))})),e.invoke=function(t,n){switch(n.type){case 0:var A=["this",s.context,s.props,e.batchId];return t.def(r(n.data),".call(",A.slice(0,Math.max(n.data.length+1,4)),")");case 1:return t.def(s.props,n.data);case 2:return t.def(s.context,n.data);case 3:return t.def("this",n.data);case 4:return n.data.append(e,t),n.data.ref;case 5:return n.data.toString();case 6:return n.data.map((function(n){return e.invoke(t,n)}))}},e.attribCache={};var u={};return e.scopeAttrib=function(e){var t=n.id(e);if(t in u)return u[t];var A=l.scope[t];return A||(A=l.scope[t]=new g),u[t]=r(A)},e}function O(e,t,a,c,h){var d=e.static,f=e.dynamic;_.optional((function(){var e=[ln,un,hn,dn,fn,gn,pn,mn,cn,yn].concat(C);function t(t){Object.keys(t).forEach((function(t){_.command(e.indexOf(t)>=0,'unknown parameter "'+t+'"',h.commandStr)}))}t(d),t(f)}));var p=function(e,t){var n=e.static;if("string"==typeof n[hn]&&"string"==typeof n[un]){if(Object.keys(t.dynamic).length>0)return null;var r=t.static,A=Object.keys(r);if(A.length>0&&"number"==typeof r[A[0]]){for(var i=[],s=0;s<A.length;++s)_("number"==typeof r[A[s]],"must specify all vertex attribute locations when using vaos"),i.push([0|r[A[s]],A[s]]);return i}}return null}(e,t),w=function(e){var t=e.static,n=e.dynamic;if(ln in t){var r=t[ln];return r?(r=o.getFramebuffer(r),_.command(r,"invalid framebuffer object"),or((function(e,t){var n=e.link(r),A=e.shared;t.set(A.framebuffer,".next",n);var i=A.context;return t.set(i,"."+Bn,n+".width"),t.set(i,"."+bn,n+".height"),n}))):or((function(e,t){var n=e.shared;t.set(n.framebuffer,".next","null");var r=n.context;return t.set(r,"."+Bn,r+"."+Un),t.set(r,"."+bn,r+"."+Fn),"null"}))}if(ln in n){var A=n[ln];return cr(A,(function(e,t){var n=e.invoke(t,A),r=e.shared,i=r.framebuffer,s=t.def(i,".getFramebuffer(",n,")");_.optional((function(){e.assert(t,"!"+n+"||"+s,"invalid framebuffer object")})),t.set(i,".next",s);var a=r.context;return t.set(a,"."+Bn,s+"?"+s+".width:"+a+"."+Un),t.set(a,"."+bn,s+"?"+s+".height:"+a+"."+Fn),s}))}return null}(e),v=function(e,t,n){var r=e.static,A=e.dynamic;function i(e){if(e in r){var i=r[e];_.commandType(i,"object","invalid "+e,n.commandStr);var s,a,o=!0,c=0|i.x,l=0|i.y;return"width"in i?(s=0|i.width,_.command(s>=0,"invalid "+e,n.commandStr)):o=!1,"height"in i?(a=0|i.height,_.command(a>=0,"invalid "+e,n.commandStr)):o=!1,new sr(!o&&t&&t.thisDep,!o&&t&&t.contextDep,!o&&t&&t.propDep,(function(e,t){var n=e.shared.context,r=s;"width"in i||(r=t.def(n,".",Bn,"-",c));var A=a;return"height"in i||(A=t.def(n,".",bn,"-",l)),[c,l,r,A]}))}if(e in A){var u=A[e],h=cr(u,(function(t,n){var r=t.invoke(n,u);_.optional((function(){t.assert(n,r+"&&typeof "+r+'==="object"',"invalid "+e)}));var A=t.shared.context,i=n.def(r,".x|0"),s=n.def(r,".y|0"),a=n.def('"width" in ',r,"?",r,".width|0:","(",A,".",Bn,"-",i,")"),o=n.def('"height" in ',r,"?",r,".height|0:","(",A,".",bn,"-",s,")");return _.optional((function(){t.assert(n,a+">=0&&"+o+">=0","invalid "+e)})),[i,s,a,o]}));return t&&(h.thisDep=h.thisDep||t.thisDep,h.contextDep=h.contextDep||t.contextDep,h.propDep=h.propDep||t.propDep),h}return t?new sr(t.thisDep,t.contextDep,t.propDep,(function(e,t){var n=e.shared.context;return[0,0,t.def(n,".",Bn),t.def(n,".",bn)]})):null}var s=i(on);if(s){var a=s;s=new sr(s.thisDep,s.contextDep,s.propDep,(function(e,t){var n=a.append(e,t),r=e.shared.context;return t.set(r,"."+_n,n[2]),t.set(r,"."+Cn,n[3]),n}))}return{viewport:s,scissor_box:i(an)}}(e,w,h),B=function(e,t){var n=e.static,r=e.dynamic,A={},i=!1,a=function(){if(yn in n){var e=n[yn];return null!==e&&null===l.getVAO(e)&&(e=l.createVAO(e)),i=!0,A.vao=e,or((function(t){var n=l.getVAO(e);return n?t.link(n):"null"}))}if(yn in r){i=!0;var t=r[yn];return cr(t,(function(e,n){var r=e.invoke(n,t);return n.def(e.shared.vao+".getVAO("+r+")")}))}return null}(),o=!1,c=function(){if(dn in n){var e=n[dn];if(A.elements=e,Ar(e)){var c=A.elements=s.create(e,!0);e=s.getElements(c),o=!0}else e&&(e=s.getElements(e),o=!0,_.command(e,"invalid elements",t.commandStr));var l=or((function(t,n){if(e){var r=t.link(e);return t.ELEMENTS=r,r}return t.ELEMENTS=null,null}));return l.value=e,l}if(dn in r){o=!0;var u=r[dn];return cr(u,(function(e,t){var n=e.shared,r=n.isBufferArgs,A=n.elements,i=e.invoke(t,u),s=t.def("null"),a=t.def(r,"(",i,")"),o=e.cond(a).then(s,"=",A,".createStream(",i,");").else(s,"=",A,".getElements(",i,");");return _.optional((function(){e.assert(o.else,"!"+i+"||"+s,"invalid elements")})),t.entry(o),t.exit(e.cond(a).then(A,".destroyStream(",s,");")),e.ELEMENTS=s,s}))}return i?new sr(a.thisDep,a.contextDep,a.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.elements+".getElements("+e.shared.vao+".currentVAO.elements):null")})):null}();function u(e,s){if(e in n){var c=0|n[e];return s?A.offset=c:A.instances=c,_.command(!s||c>=0,"invalid "+e,t.commandStr),or((function(e,t){return s&&(e.OFFSET=c),c}))}if(e in r){var l=r[e];return cr(l,(function(t,n){var r=t.invoke(n,l);return s&&(t.OFFSET=r,_.optional((function(){t.assert(n,r+">=0","invalid "+e)}))),r}))}if(s){if(o)return or((function(e,t){return e.OFFSET=0,0}));if(i)return new sr(a.thisDep,a.contextDep,a.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.offset:0")}))}else if(i)return new sr(a.thisDep,a.contextDep,a.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.instances:-1")}));return null}var h=u(gn,!0),d=function(){if(fn in n){var e=n[fn];return A.primitive=e,_.commandParameter(e,ie,"invalid primitve",t.commandStr),or((function(t,n){return ie[e]}))}if(fn in r){var s=r[fn];return cr(s,(function(e,t){var n=e.constants.primTypes,r=e.invoke(t,s);return _.optional((function(){e.assert(t,r+" in "+n,"invalid primitive, must be one of "+Object.keys(ie))})),t.def(n,"[",r,"]")}))}return o?ar(c)?c.value?or((function(e,t){return t.def(e.ELEMENTS,".primType")})):or((function(){return 4})):new sr(c.thisDep,c.contextDep,c.propDep,(function(e,t){var n=e.ELEMENTS;return t.def(n,"?",n,".primType:",4)})):i?new sr(a.thisDep,a.contextDep,a.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.primitive:4")})):null}(),f=function(){if(pn in n){var e=0|n[pn];return A.count=e,_.command("number"==typeof e&&e>=0,"invalid vertex count",t.commandStr),or((function(){return e}))}if(pn in r){var s=r[pn];return cr(s,(function(e,t){var n=e.invoke(t,s);return _.optional((function(){e.assert(t,"typeof "+n+'==="number"&&'+n+">=0&&"+n+"===("+n+"|0)","invalid vertex count")})),n}))}if(o){if(ar(c)){if(c)return h?new sr(h.thisDep,h.contextDep,h.propDep,(function(e,t){var n=t.def(e.ELEMENTS,".vertCount-",e.OFFSET);return _.optional((function(){e.assert(t,n+">=0","invalid vertex offset/element buffer too small")})),n})):or((function(e,t){return t.def(e.ELEMENTS,".vertCount")}));var l=or((function(){return-1}));return _.optional((function(){l.MISSING=!0})),l}var u=new sr(c.thisDep||h.thisDep,c.contextDep||h.contextDep,c.propDep||h.propDep,(function(e,t){var n=e.ELEMENTS;return e.OFFSET?t.def(n,"?",n,".vertCount-",e.OFFSET,":-1"):t.def(n,"?",n,".vertCount:-1")}));return _.optional((function(){u.DYNAMIC=!0})),u}if(i){var d=new sr(a.thisDep,a.contextDep,a.propDep,(function(e,t){return t.def(e.shared.vao,".currentVAO?",e.shared.vao,".currentVAO.count:-1")}));return d}return null}(),p=u(mn,!1);return{elements:c,primitive:d,count:f,instances:p,offset:h,vao:a,vaoActive:i,elementsActive:o,static:A}}(e,h),b=function(e,t){var n=e.static,r=e.dynamic,i={};return C.forEach((function(e){var s=F(e);function a(t,A){if(e in n){var a=t(n[e]);i[s]=or((function(){return a}))}else if(e in r){var o=r[e];i[s]=cr(o,(function(e,t){return A(e,t,e.invoke(t,o))}))}}switch(e){case $t:case Ot:case Tt:case en:case Rt:case sn:case qt:case Yt:case Xt:case Kt:return a((function(n){return _.commandType(n,"boolean",e,t.commandStr),n}),(function(t,n,r){return _.optional((function(){t.assert(n,"typeof "+r+'==="boolean"',"invalid flag "+e,t.commandStr)})),r}));case Nt:return a((function(n){return _.commandParameter(n,er,"invalid "+e,t.commandStr),er[n]}),(function(t,n,r){var A=t.constants.compareFuncs;return _.optional((function(){t.assert(n,r+" in "+A,"invalid "+e+", must be one of "+Object.keys(er))})),n.def(A,"[",r,"]")}));case Vt:return a((function(e){return _.command(de(e)&&2===e.length&&"number"==typeof e[0]&&"number"==typeof e[1]&&e[0]<=e[1],"depth range is 2d array",t.commandStr),e}),(function(e,t,n){return _.optional((function(){e.assert(t,e.shared.isArrayLike+"("+n+")&&"+n+".length===2&&typeof "+n+'[0]==="number"&&typeof '+n+'[1]==="number"&&'+n+"[0]<="+n+"[1]","depth range must be a 2d array")})),[t.def("+",n,"[0]"),t.def("+",n,"[1]")]}));case Ht:return a((function(e){_.commandType(e,"object","blend.func",t.commandStr);var n="srcRGB"in e?e.srcRGB:e.src,r="srcAlpha"in e?e.srcAlpha:e.src,A="dstRGB"in e?e.dstRGB:e.dst,i="dstAlpha"in e?e.dstAlpha:e.dst;return _.commandParameter(n,Xn,s+".srcRGB",t.commandStr),_.commandParameter(r,Xn,s+".srcAlpha",t.commandStr),_.commandParameter(A,Xn,s+".dstRGB",t.commandStr),_.commandParameter(i,Xn,s+".dstAlpha",t.commandStr),_.command(-1===Zn.indexOf(n+", "+A),"unallowed blending combination (srcRGB, dstRGB) = ("+n+", "+A+")",t.commandStr),[Xn[n],Xn[A],Xn[r],Xn[i]]}),(function(t,n,r){var A=t.constants.blendFuncs;function i(i,s){var a=n.def('"',i,s,'" in ',r,"?",r,".",i,s,":",r,".",i);return _.optional((function(){t.assert(n,a+" in "+A,"invalid "+e+"."+i+s+", must be one of "+Object.keys(Xn))})),a}_.optional((function(){t.assert(n,r+"&&typeof "+r+'==="object"',"invalid blend func, must be an object")}));var s=i("src","RGB"),a=i("dst","RGB");_.optional((function(){var e=t.constants.invalidBlendCombinations;t.assert(n,e+".indexOf("+s+'+", "+'+a+") === -1 ","unallowed blending combination for (srcRGB, dstRGB)")}));var o=n.def(A,"[",s,"]"),c=n.def(A,"[",i("src","Alpha"),"]");return[o,n.def(A,"[",a,"]"),c,n.def(A,"[",i("dst","Alpha"),"]")]}));case Pt:return a((function(n){return"string"==typeof n?(_.commandParameter(n,m,"invalid "+e,t.commandStr),[m[n],m[n]]):"object"==typeof n?(_.commandParameter(n.rgb,m,e+".rgb",t.commandStr),_.commandParameter(n.alpha,m,e+".alpha",t.commandStr),[m[n.rgb],m[n.alpha]]):void _.commandRaise("invalid blend.equation",t.commandStr)}),(function(t,n,r){var A=t.constants.blendEquations,i=n.def(),s=n.def(),a=t.cond("typeof ",r,'==="string"');return _.optional((function(){function n(e,n,r){t.assert(e,r+" in "+A,"invalid "+n+", must be one of "+Object.keys(m))}n(a.then,e,r),t.assert(a.else,r+"&&typeof "+r+'==="object"',"invalid "+e),n(a.else,e+".rgb",r+".rgb"),n(a.else,e+".alpha",r+".alpha")})),a.then(i,"=",s,"=",A,"[",r,"];"),a.else(i,"=",A,"[",r,".rgb];",s,"=",A,"[",r,".alpha];"),n(a),[i,s]}));case Lt:return a((function(e){return _.command(de(e)&&4===e.length,"blend.color must be a 4d array",t.commandStr),T(4,(function(t){return+e[t]}))}),(function(e,t,n){return _.optional((function(){e.assert(t,e.shared.isArrayLike+"("+n+")&&"+n+".length===4","blend.color must be a 4d array")})),T(4,(function(e){return t.def("+",n,"[",e,"]")}))}));case tn:return a((function(e){return _.commandType(e,"number",s,t.commandStr),0|e}),(function(e,t,n){return _.optional((function(){e.assert(t,"typeof "+n+'==="number"',"invalid stencil.mask")})),t.def(n,"|0")}));case nn:return a((function(n){_.commandType(n,"object",s,t.commandStr);var r=n.cmp||"keep",A=n.ref||0,i="mask"in n?n.mask:-1;return _.commandParameter(r,er,e+".cmp",t.commandStr),_.commandType(A,"number",e+".ref",t.commandStr),_.commandType(i,"number",e+".mask",t.commandStr),[er[r],A,i]}),(function(e,t,n){var r=e.constants.compareFuncs;return _.optional((function(){function A(){e.assert(t,Array.prototype.join.call(arguments,""),"invalid stencil.func")}A(n+"&&typeof ",n,'==="object"'),A('!("cmp" in ',n,")||(",n,".cmp in ",r,")")})),[t.def('"cmp" in ',n,"?",r,"[",n,".cmp]",":",Yn),t.def(n,".ref|0"),t.def('"mask" in ',n,"?",n,".mask|0:-1")]}));case rn:case An:return a((function(n){_.commandType(n,"object",s,t.commandStr);var r=n.fail||"keep",A=n.zfail||"keep",i=n.zpass||"keep";return _.commandParameter(r,tr,e+".fail",t.commandStr),_.commandParameter(A,tr,e+".zfail",t.commandStr),_.commandParameter(i,tr,e+".zpass",t.commandStr),[e===An?qn:Wn,tr[r],tr[A],tr[i]]}),(function(t,n,r){var A=t.constants.stencilOps;function i(i){return _.optional((function(){t.assert(n,'!("'+i+'" in '+r+")||("+r+"."+i+" in "+A+")","invalid "+e+"."+i+", must be one of "+Object.keys(tr))})),n.def('"',i,'" in ',r,"?",A,"[",r,".",i,"]:",Yn)}return _.optional((function(){t.assert(n,r+"&&typeof "+r+'==="object"',"invalid "+e)})),[e===An?qn:Wn,i("fail"),i("zfail"),i("zpass")]}));case Jt:return a((function(e){_.commandType(e,"object",s,t.commandStr);var n=0|e.factor,r=0|e.units;return _.commandType(n,"number",s+".factor",t.commandStr),_.commandType(r,"number",s+".units",t.commandStr),[n,r]}),(function(t,n,r){return _.optional((function(){t.assert(n,r+"&&typeof "+r+'==="object"',"invalid "+e)})),[n.def(r,".factor|0"),n.def(r,".units|0")]}));case Gt:return a((function(e){var n=0;return"front"===e?n=Wn:"back"===e&&(n=qn),_.command(!!n,s,t.commandStr),n}),(function(e,t,n){return _.optional((function(){e.assert(t,n+'==="front"||'+n+'==="back"',"invalid cull.face")})),t.def(n,'==="front"?',Wn,":",qn)}));case Wt:return a((function(e){return _.command("number"==typeof e&&e>=A.lineWidthDims[0]&&e<=A.lineWidthDims[1],"invalid line width, must be a positive number between "+A.lineWidthDims[0]+" and "+A.lineWidthDims[1],t.commandStr),e}),(function(e,t,n){return _.optional((function(){e.assert(t,"typeof "+n+'==="number"&&'+n+">="+A.lineWidthDims[0]+"&&"+n+"<="+A.lineWidthDims[1],"invalid line width")})),n}));case zt:return a((function(e){return _.commandParameter(e,rr,s,t.commandStr),rr[e]}),(function(e,t,n){return _.optional((function(){e.assert(t,n+'==="cw"||'+n+'==="ccw"',"invalid frontFace, must be one of cw,ccw")})),t.def(n+'==="cw"?2304:'+Jn)}));case jt:return a((function(e){return _.command(de(e)&&4===e.length,"color.mask must be length 4 array",t.commandStr),e.map((function(e){return!!e}))}),(function(e,t,n){return _.optional((function(){e.assert(t,e.shared.isArrayLike+"("+n+")&&"+n+".length===4","invalid color.mask")})),T(4,(function(e){return"!!"+n+"["+e+"]"}))}));case Zt:return a((function(e){_.command("object"==typeof e&&e,s,t.commandStr);var n="value"in e?e.value:1,r=!!e.invert;return _.command("number"==typeof n&&n>=0&&n<=1,"sample.coverage.value must be a number between 0 and 1",t.commandStr),[n,r]}),(function(e,t,n){return _.optional((function(){e.assert(t,n+"&&typeof "+n+'==="object"',"invalid sample.coverage")})),[t.def('"value" in ',n,"?+",n,".value:1"),t.def("!!",n,".invert")]}))}})),i}(e,h),x=function(e,t,r){var A=e.static,i=e.dynamic;function s(e){if(e in A){var t=n.id(A[e]);_.optional((function(){u.shader(nr[e],t,_.guessCommand())}));var r=or((function(){return t}));return r.id=t,r}if(e in i){var s=i[e];return cr(s,(function(t,n){var r=t.invoke(n,s),A=n.def(t.shared.strings,".id(",r,")");return _.optional((function(){n(t.shared.shader,".shader(",nr[e],",",A,",",t.command,");")})),A}))}return null}var a,o=s(hn),c=s(un),l=null;return ar(o)&&ar(c)?(l=u.program(c.id,o.id,null,r),a=or((function(e,t){return e.link(l)}))):a=new sr(o&&o.thisDep||c&&c.thisDep,o&&o.contextDep||c&&c.contextDep,o&&o.propDep||c&&c.propDep,(function(e,t){var n,r=e.shared.shader;n=o?o.append(e,t):t.def(r,".",hn);var A=r+".program("+(c?c.append(e,t):t.def(r,".",un))+","+n;return _.optional((function(){A+=","+e.command})),t.def(A+")")})),{frag:o,vert:c,progVar:a,program:l}}(e,0,p);function U(e){var t=v[e];t&&(b[e]=t)}U(on),U(F(an));var E=Object.keys(b).length>0,Q={framebuffer:w,draw:B,shader:x,state:b,dirty:E,scopeVAO:null,drawVAO:null,useVAO:!1,attributes:{}};if(Q.profile=function(e){var t,n=e.static,r=e.dynamic;if(cn in n){var A=!!n[cn];(t=or((function(e,t){return A}))).enable=A}else if(cn in r){var i=r[cn];t=cr(i,(function(e,t){return e.invoke(t,i)}))}return t}(e),Q.uniforms=function(e,t){var n=e.static,r=e.dynamic,A={};return Object.keys(n).forEach((function(e){var r,i=n[e];if("number"==typeof i||"boolean"==typeof i)r=or((function(){return i}));else if("function"==typeof i){var s=i._reglType;"texture2d"===s||"textureCube"===s?r=or((function(e){return e.link(i)})):"framebuffer"===s||"framebufferCube"===s?(_.command(i.color.length>0,'missing color attachment for framebuffer sent to uniform "'+e+'"',t.commandStr),r=or((function(e){return e.link(i.color[0])}))):_.commandRaise('invalid data for uniform "'+e+'"',t.commandStr)}else de(i)?r=or((function(t){return t.global.def("[",T(i.length,(function(n){return _.command("number"==typeof i[n]||"boolean"==typeof i[n],"invalid uniform "+e,t.commandStr),i[n]})),"]")})):_.commandRaise('invalid or missing data for uniform "'+e+'"',t.commandStr);r.value=i,A[e]=r})),Object.keys(r).forEach((function(e){var t=r[e];A[e]=cr(t,(function(e,n){return e.invoke(n,t)}))})),A}(a,h),Q.drawVAO=Q.scopeVAO=B.vao,!Q.drawVAO&&x.program&&!p&&r.angle_instanced_arrays&&B.static.elements){var S=!0,I=x.program.attributes.map((function(e){var n=t.static[e];return S=S&&!!n,n}));if(S&&I.length>0){var k=l.getVAO(l.createVAO({attributes:I,elements:B.static.elements}));Q.drawVAO=new sr(null,null,null,(function(e,t){return e.link(k)})),Q.useVAO=!0}}return p?Q.useVAO=!0:Q.attributes=function(e,t){var r=e.static,A=e.dynamic,s={};return Object.keys(r).forEach((function(e){var A=r[e],a=n.id(e),o=new g;if(Ar(A))o.state=1,o.buffer=i.getBuffer(i.create(A,Qn,!1,!0)),o.type=0;else{var c=i.getBuffer(A);if(c)o.state=1,o.buffer=c,o.type=0;else if(_.command("object"==typeof A&&A,"invalid data for attribute "+e,t.commandStr),"constant"in A){var l=A.constant;o.buffer="null",o.state=2,"number"==typeof l?o.x=l:(_.command(de(l)&&l.length>0&&l.length<=4,"invalid constant for attribute "+e,t.commandStr),Mt.forEach((function(e,t){t<l.length&&(o[e]=l[t])})))}else{c=Ar(A.buffer)?i.getBuffer(i.create(A.buffer,Qn,!1,!0)):i.getBuffer(A.buffer),_.command(!!c,'missing buffer for attribute "'+e+'"',t.commandStr);var u=0|A.offset;_.command(u>=0,'invalid offset for attribute "'+e+'"',t.commandStr);var h=0|A.stride;_.command(h>=0&&h<256,'invalid stride for attribute "'+e+'", must be integer betweeen [0, 255]',t.commandStr);var d=0|A.size;_.command(!("size"in A)||d>0&&d<=4,'invalid size for attribute "'+e+'", must be 1,2,3,4',t.commandStr);var f=!!A.normalized,p=0;"type"in A&&(_.commandParameter(A.type,q,"invalid type for attribute "+e,t.commandStr),p=q[A.type]);var m=0|A.divisor;_.optional((function(){"divisor"in A&&(_.command(0===m||y,'cannot specify divisor for attribute "'+e+'", instancing not supported',t.commandStr),_.command(m>=0,'invalid divisor for attribute "'+e+'"',t.commandStr));var n=t.commandStr,r=["buffer","offset","divisor","normalized","type","size","stride"];Object.keys(A).forEach((function(t){_.command(r.indexOf(t)>=0,'unknown parameter "'+t+'" for attribute pointer "'+e+'" (valid parameters are '+r+")",n)}))})),o.buffer=c,o.state=1,o.size=d,o.normalized=f,o.type=p||c.dtype,o.offset=u,o.stride=h,o.divisor=m}}s[e]=or((function(e,t){var n=e.attribCache;if(a in n)return n[a];var r={isStream:!1};return Object.keys(o).forEach((function(e){r[e]=o[e]})),o.buffer&&(r.buffer=e.link(o.buffer),r.type=r.type||r.buffer+".dtype"),n[a]=r,r}))})),Object.keys(A).forEach((function(e){var t=A[e];s[e]=cr(t,(function(n,r){var A=n.invoke(r,t),i=n.shared,s=n.constants,a=i.isBufferArgs,o=i.buffer;_.optional((function(){n.assert(r,A+"&&(typeof "+A+'==="object"||typeof '+A+'==="function")&&('+a+"("+A+")||"+o+".getBuffer("+A+")||"+o+".getBuffer("+A+".buffer)||"+a+"("+A+'.buffer)||("constant" in '+A+"&&(typeof "+A+'.constant==="number"||'+i.isArrayLike+"("+A+".constant))))",'invalid dynamic attribute "'+e+'"')}));var c={isStream:r.def(!1)},l=new g;l.state=1,Object.keys(l).forEach((function(e){c[e]=r.def(""+l[e])}));var u=c.buffer,h=c.type;function d(e){r(c[e],"=",A,".",e,"|0;")}return r("if(",a,"(",A,")){",c.isStream,"=true;",u,"=",o,".createStream(",Qn,",",A,");",h,"=",u,".dtype;","}else{",u,"=",o,".getBuffer(",A,");","if(",u,"){",h,"=",u,".dtype;",'}else if("constant" in ',A,"){",c.state,"=",2,";","if(typeof "+A+'.constant === "number"){',c[Mt[0]],"=",A,".constant;",Mt.slice(1).map((function(e){return c[e]})).join("="),"=0;","}else{",Mt.map((function(e,t){return c[e]+"="+A+".constant.length>"+t+"?"+A+".constant["+t+"]:0;"})).join(""),"}}else{","if(",a,"(",A,".buffer)){",u,"=",o,".createStream(",Qn,",",A,".buffer);","}else{",u,"=",o,".getBuffer(",A,".buffer);","}",h,'="type" in ',A,"?",s.glTypes,"[",A,".type]:",u,".dtype;",c.normalized,"=!!",A,".normalized;"),d("size"),d("offset"),d("stride"),d("divisor"),r("}}"),r.exit("if(",c.isStream,"){",o,".destroyStream(",u,");","}"),c}))})),s}(t,h),Q.context=function(e){var t=e.static,n=e.dynamic,r={};return Object.keys(t).forEach((function(e){var n=t[e];r[e]=or((function(e,t){return"number"==typeof n||"boolean"==typeof n?""+n:e.link(n)}))})),Object.keys(n).forEach((function(e){var t=n[e];r[e]=cr(t,(function(e,n){return e.invoke(n,t)}))})),r}(c),Q}function L(e,t,n){var r=e.shared.context,A=e.scope();Object.keys(n).forEach((function(i){t.save(r,"."+i);var s=n[i].append(e,t);Array.isArray(s)?A(r,".",i,"=[",s.join(),"];"):A(r,".",i,"=",s,";")})),t(A)}function P(e,t,n,r){var A,i=e.shared,s=i.gl,a=i.framebuffer;w&&(A=t.def(i.extensions,".webgl_draw_buffers"));var o,c=e.constants,l=c.drawBuffer,u=c.backBuffer;o=n?n.append(e,t):t.def(a,".next"),r||t("if(",o,"!==",a,".cur){"),t("if(",o,"){",s,".bindFramebuffer(",36160,",",o,".framebuffer);"),w&&t(A,".drawBuffersWEBGL(",l,"[",o,".colorAttachments.length]);"),t("}else{",s,".bindFramebuffer(",36160,",null);"),w&&t(A,".drawBuffersWEBGL(",u,");"),t("}",a,".cur=",o,";"),r||t("}")}function H(e,t,n){var r=e.shared,A=r.gl,i=e.current,s=e.next,a=r.current,o=r.next,c=e.cond(a,".dirty");C.forEach((function(t){var r,l,u=F(t);if(!(u in n.state))if(u in s){r=s[u],l=i[u];var h=T(B[u].length,(function(e){return c.def(r,"[",e,"]")}));c(e.cond(h.map((function(e,t){return e+"!=="+l+"["+t+"]"})).join("||")).then(A,".",U[u],"(",h,");",h.map((function(e,t){return l+"["+t+"]="+e})).join(";"),";"))}else{r=c.def(o,".",u);var d=e.cond(r,"!==",a,".",u);c(d),u in x?d(e.cond(r).then(A,".enable(",x[u],");").else(A,".disable(",x[u],");"),a,".",u,"=",r,";"):d(A,".",U[u],"(",r,");",a,".",u,"=",r,";")}})),0===Object.keys(n.state).length&&c(a,".dirty=false;"),t(c)}function R(e,t,n,r){var A=e.shared,i=e.current,s=A.current,a=A.gl;ir(Object.keys(n)).forEach((function(A){var o=n[A];if(!r||r(o)){var c=o.append(e,t);if(x[A]){var l=x[A];ar(o)?t(a,c?".enable(":".disable(",l,");"):t(e.cond(c).then(a,".enable(",l,");").else(a,".disable(",l,");")),t(s,".",A,"=",c,";")}else if(de(c)){var u=i[A];t(a,".",U[A],"(",c,");",c.map((function(e,t){return u+"["+t+"]="+e})).join(";"),";")}else t(a,".",U[A],"(",c,");",s,".",A,"=",c,";")}}))}function N(e,t){y&&(e.instancing=t.def(e.shared.extensions,".angle_instanced_arrays"))}function V(e,t,n,r,A){var i,s,a,o=e.shared,c=e.stats,l=o.current,u=o.timer,h=n.profile;function d(){return"undefined"==typeof performance?"Date.now()":"performance.now()"}function p(e){e(i=t.def(),"=",d(),";"),"string"==typeof A?e(c,".count+=",A,";"):e(c,".count++;"),f&&(r?e(s=t.def(),"=",u,".getNumPendingQueries();"):e(u,".beginQuery(",c,");"))}function g(e){e(c,".cpuTime+=",d(),"-",i,";"),f&&(r?e(u,".pushScopeStats(",s,",",u,".getNumPendingQueries(),",c,");"):e(u,".endQuery();"))}function m(e){var n=t.def(l,".profile");t(l,".profile=",e,";"),t.exit(l,".profile=",n,";")}if(h){if(ar(h))return void(h.enable?(p(t),g(t.exit),m("true")):m("false"));m(a=h.append(e,t))}else a=t.def(l,".profile");var y=e.block();p(y),t("if(",a,"){",y,"}");var w=e.block();g(w),t.exit("if(",a,"){",w,"}")}function K(e,t,n,r,A){var i=e.shared;r.forEach((function(r){var s,a=r.name,o=n.attributes[a];if(o){if(!A(o))return;s=o.append(e,t)}else{if(!A(lr))return;var c=e.scopeAttrib(a);_.optional((function(){e.assert(t,c+".state","missing attribute "+a)})),s={},Object.keys(new g).forEach((function(e){s[e]=t.def(c,".",e)}))}!function(n,r,A){var s=i.gl,a=t.def(n,".location"),o=t.def(i.attributes,"[",a,"]"),c=A.state,l=A.buffer,u=[A.x,A.y,A.z,A.w],h=["buffer","normalized","offset","stride"];function d(){t("if(!",o,".buffer){",s,".enableVertexAttribArray(",a,");}");var n,i=A.type;if(n=A.size?t.def(A.size,"||",r):r,t("if(",o,".type!==",i,"||",o,".size!==",n,"||",h.map((function(e){return o+"."+e+"!=="+A[e]})).join("||"),"){",s,".bindBuffer(",Qn,",",l,".buffer);",s,".vertexAttribPointer(",[a,n,i,A.normalized,A.stride,A.offset],");",o,".type=",i,";",o,".size=",n,";",h.map((function(e){return o+"."+e+"="+A[e]+";"})).join(""),"}"),y){var c=A.divisor;t("if(",o,".divisor!==",c,"){",e.instancing,".vertexAttribDivisorANGLE(",[a,c],");",o,".divisor=",c,";}")}}function f(){t("if(",o,".buffer){",s,".disableVertexAttribArray(",a,");",o,".buffer=null;","}if(",Mt.map((function(e,t){return o+"."+e+"!=="+u[t]})).join("||"),"){",s,".vertexAttrib4f(",a,",",u,");",Mt.map((function(e,t){return o+"."+e+"="+u[t]+";"})).join(""),"}")}1===c?d():2===c?f():(t("if(",c,"===",1,"){"),d(),t("}else{"),f(),t("}"))}(e.link(r),function(e){switch(e){case kn:case On:case Rn:return 2;case Dn:case Ln:case Nn:return 3;case Mn:case Pn:case Vn:return 4;default:return 1}}(r.info.type),s)}))}function j(e,t,r,A,i,s){for(var a,o=e.shared,c=o.gl,l=0;l<A.length;++l){var u,h=A[l],d=h.name,f=h.info.type,p=r.uniforms[d],g=e.link(h)+".location";if(p){if(!i(p))continue;if(ar(p)){var m=p.value;if(_.command(null!=m,'missing uniform "'+d+'"',e.commandStr),f===Gn||f===zn){_.command("function"==typeof m&&(f===Gn&&("texture2d"===m._reglType||"framebuffer"===m._reglType)||f===zn&&("textureCube"===m._reglType||"framebufferCube"===m._reglType)),"invalid texture for uniform "+d,e.commandStr);var y=e.link(m._texture||m.color[0]._texture);t(c,".uniform1i(",g,",",y+".bind());"),t.exit(y,".unbind();")}else if(f===Kn||f===jn||f===$n){_.optional((function(){_.command(de(m),"invalid matrix for uniform "+d,e.commandStr),_.command(f===Kn&&4===m.length||f===jn&&9===m.length||f===$n&&16===m.length,"invalid length for matrix uniform "+d,e.commandStr)}));var w=e.global.def("new Float32Array(["+Array.prototype.slice.call(m)+"])"),v=2;f===jn?v=3:f===$n&&(v=4),t(c,".uniformMatrix",v,"fv(",g,",false,",w,");")}else{switch(f){case In:_.commandType(m,"number","uniform "+d,e.commandStr),a="1f";break;case kn:_.command(de(m)&&2===m.length,"uniform "+d,e.commandStr),a="2f";break;case Dn:_.command(de(m)&&3===m.length,"uniform "+d,e.commandStr),a="3f";break;case Mn:_.command(de(m)&&4===m.length,"uniform "+d,e.commandStr),a="4f";break;case Hn:_.commandType(m,"boolean","uniform "+d,e.commandStr),a="1i";break;case Tn:_.commandType(m,"number","uniform "+d,e.commandStr),a="1i";break;case Rn:case On:_.command(de(m)&&2===m.length,"uniform "+d,e.commandStr),a="2i";break;case Nn:case Ln:_.command(de(m)&&3===m.length,"uniform "+d,e.commandStr),a="3i";break;case Vn:case Pn:_.command(de(m)&&4===m.length,"uniform "+d,e.commandStr),a="4i"}t(c,".uniform",a,"(",g,",",de(m)?Array.prototype.slice.call(m):m,");")}continue}u=p.append(e,t)}else{if(!i(lr))continue;u=t.def(o.uniforms,"[",n.id(d),"]")}f===Gn?(_(!Array.isArray(u),"must specify a scalar prop for textures"),t("if(",u,"&&",u,'._reglType==="framebuffer"){',u,"=",u,".color[0];","}")):f===zn&&(_(!Array.isArray(u),"must specify a scalar prop for cube maps"),t("if(",u,"&&",u,'._reglType==="framebufferCube"){',u,"=",u,".color[0];","}")),_.optional((function(){function n(n,r){e.assert(t,n,'bad data or missing for uniform "'+d+'".  '+r)}function r(e){_(!Array.isArray(u),"must not specify an array type for uniform"),n("typeof "+u+'==="'+e+'"',"invalid type, expected "+e)}function A(t,r){Array.isArray(u)?_(u.length===t,"must have length "+t):n(o.isArrayLike+"("+u+")&&"+u+".length==="+t,"invalid vector, should have length "+t,e.commandStr)}function i(t){_(!Array.isArray(u),"must not specify a value type"),n("typeof "+u+'==="function"&&'+u+'._reglType==="texture'+(3553===t?"2d":"Cube")+'"',"invalid texture type",e.commandStr)}switch(f){case Tn:r("number");break;case On:A(2);break;case Ln:A(3);break;case Pn:A(4);break;case In:r("number");break;case kn:A(2);break;case Dn:A(3);break;case Mn:A(4);break;case Hn:r("boolean");break;case Rn:A(2);break;case Nn:A(3);break;case Vn:case Kn:A(4);break;case jn:A(9);break;case $n:A(16);break;case Gn:i(3553);break;case zn:i(34067)}}));var B=1;switch(f){case Gn:case zn:var b=t.def(u,"._texture");t(c,".uniform1i(",g,",",b,".bind());"),t.exit(b,".unbind();");continue;case Tn:case Hn:a="1i";break;case On:case Rn:a="2i",B=2;break;case Ln:case Nn:a="3i",B=3;break;case Pn:case Vn:a="4i",B=4;break;case In:a="1f";break;case kn:a="2f",B=2;break;case Dn:a="3f",B=3;break;case Mn:a="4f",B=4;break;case Kn:a="Matrix2fv";break;case jn:a="Matrix3fv";break;case $n:a="Matrix4fv"}if("M"===a.charAt(0)){t(c,".uniform",a,"(",g,",");var C=Math.pow(f-Kn+2,2),x=e.global.def("new Float32Array(",C,")");Array.isArray(u)?t("false,(",T(C,(function(e){return x+"["+e+"]="+u[e]})),",",x,")"):t("false,(Array.isArray(",u,")||",u," instanceof Float32Array)?",u,":(",T(C,(function(e){return x+"["+e+"]="+u+"["+e+"]"})),",",x,")"),t(");")}else if(B>1){for(var U=[],F=[],E=0;E<B;++E)Array.isArray(u)?F.push(u[E]):F.push(t.def(u+"["+E+"]")),s&&U.push(t.def());s&&t("if(!",e.batchId,"||",U.map((function(e,t){return e+"!=="+F[t]})).join("||"),"){",U.map((function(e,t){return e+"="+F[t]+";"})).join("")),t(c,".uniform",a,"(",g,",",F.join(","),");"),s&&t("}")}else{if(_(!Array.isArray(u),"uniform value must not be an array"),s){var Q=t.def();t("if(!",e.batchId,"||",Q,"!==",u,"){",Q,"=",u,";")}t(c,".uniform",a,"(",g,",",u,");"),s&&t("}")}}}function $(e,t,n,r){var A=e.shared,i=A.gl,s=A.draw,a=r.draw;var o=function(){var o,c=a.elements,l=t;return c?((c.contextDep&&r.contextDynamic||c.propDep)&&(l=n),o=c.append(e,l),a.elementsActive&&l("if("+o+")"+i+".bindBuffer("+Sn+","+o+".buffer.buffer);")):(o=l.def(),l(o,"=",s,".",dn,";","if(",o,"){",i,".bindBuffer(",Sn,",",o,".buffer.buffer);}","else if(",A.vao,".currentVAO){",o,"=",e.shared.elements+".getElements("+A.vao,".currentVAO.elements);",v?"":"if("+o+")"+i+".bindBuffer("+Sn+","+o+".buffer.buffer);","}")),o}();function c(A){var i=a[A];return i?i.contextDep&&r.contextDynamic||i.propDep?i.append(e,n):i.append(e,t):t.def(s,".",A)}var l,u,h=c(fn),d=c(gn),f=function(){var A,i=a.count,o=t;return i?((i.contextDep&&r.contextDynamic||i.propDep)&&(o=n),A=i.append(e,o),_.optional((function(){i.MISSING&&e.assert(t,"false","missing vertex count"),i.DYNAMIC&&e.assert(o,A+">=0","missing vertex count")}))):(A=o.def(s,".",pn),_.optional((function(){e.assert(o,A+">=0","missing vertex count")}))),A}();if("number"==typeof f){if(0===f)return}else n("if(",f,"){"),n.exit("}");y&&(l=c(mn),u=e.instancing);var p=o+".type",g=a.elements&&ar(a.elements)&&!a.vaoActive;function m(){function e(){n(u,".drawElementsInstancedANGLE(",[h,f,p,d+"<<(("+p+"-5121)>>1)",l],");")}function t(){n(u,".drawArraysInstancedANGLE(",[h,d,f,l],");")}o&&"null"!==o?g?e():(n("if(",o,"){"),e(),n("}else{"),t(),n("}")):t()}function w(){function e(){n(i+".drawElements("+[h,f,p,d+"<<(("+p+"-5121)>>1)"]+");")}function t(){n(i+".drawArrays("+[h,d,f]+");")}o&&"null"!==o?g?e():(n("if(",o,"){"),e(),n("}else{"),t(),n("}")):t()}y&&("number"!=typeof l||l>=0)?"string"==typeof l?(n("if(",l,">0){"),m(),n("}else if(",l,"<0){"),w(),n("}")):m():w()}function G(e,t,n,r,A){var i=M(),s=i.proc("body",A);return _.optional((function(){i.commandStr=t.commandStr,i.command=i.link(t.commandStr)})),y&&(i.instancing=s.def(i.shared.extensions,".angle_instanced_arrays")),e(i,s,n,r),i.compile().body}function z(e,t,n,r){N(e,t),n.useVAO?n.drawVAO?t(e.shared.vao,".setVAO(",n.drawVAO.append(e,t),");"):t(e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"):(t(e.shared.vao,".setVAO(null);"),K(e,t,n,r.attributes,(function(){return!0}))),j(e,t,n,r.uniforms,(function(){return!0}),!1),$(e,t,t,n)}function W(e,t,n,r){function A(){return!0}e.batchId="a1",N(e,t),K(e,t,n,r.attributes,A),j(e,t,n,r.uniforms,A,!1),$(e,t,t,n)}function J(e,t,n,r){N(e,t);var A=n.contextDep,i=t.def(),s=t.def();e.shared.props=s,e.batchId=i;var a=e.scope(),o=e.scope();function c(e){return e.contextDep&&A||e.propDep}function l(e){return!c(e)}if(t(a.entry,"for(",i,"=0;",i,"<","a1",";++",i,"){",s,"=","a0","[",i,"];",o,"}",a.exit),n.needsContext&&L(e,o,n.context),n.needsFramebuffer&&P(e,o,n.framebuffer),R(e,o,n.state,c),n.profile&&c(n.profile)&&V(e,o,n,!1,!0),r)n.useVAO?n.drawVAO?c(n.drawVAO)?o(e.shared.vao,".setVAO(",n.drawVAO.append(e,o),");"):a(e.shared.vao,".setVAO(",n.drawVAO.append(e,a),");"):a(e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"):(a(e.shared.vao,".setVAO(null);"),K(e,a,n,r.attributes,l),K(e,o,n,r.attributes,c)),j(e,a,n,r.uniforms,l,!1),j(e,o,n,r.uniforms,c,!0),$(e,a,o,n);else{var u=e.global.def("{}"),h=n.shader.progVar.append(e,o),d=o.def(h,".id"),f=o.def(u,"[",d,"]");o(e.shared.gl,".useProgram(",h,".program);","if(!",f,"){",f,"=",u,"[",d,"]=",e.link((function(t){return G(W,e,n,t,2)})),"(",h,");}",f,".call(this,a0[",i,"],",i,");")}}function Y(e,t,n){var r=t.static[n];if(r&&function(e){if("object"==typeof e&&!de(e)){for(var t=Object.keys(e),n=0;n<t.length;++n)if(Q.isDynamic(e[t[n]]))return!0;return!1}}(r)){var A=e.global,i=Object.keys(r),s=!1,a=!1,o=!1,c=e.global.def("{}");i.forEach((function(t){var n=r[t];if(Q.isDynamic(n)){"function"==typeof n&&(n=r[t]=Q.unbox(n));var i=cr(n,null);s=s||i.thisDep,o=o||i.propDep,a=a||i.contextDep}else{switch(A(c,".",t,"="),typeof n){case"number":A(n);break;case"string":A('"',n,'"');break;case"object":Array.isArray(n)&&A("[",n.join(),"]");break;default:A(e.link(n))}A(";")}})),t.dynamic[n]=new Q.DynamicVariable(4,{thisDep:s,contextDep:a,propDep:o,ref:c,append:function(e,t){i.forEach((function(n){var A=r[n];if(Q.isDynamic(A)){var i=e.invoke(t,A);t(c,".",n,"=",i,";")}}))}}),delete t.static[n]}}return{next:b,current:B,procs:function(){var e=M(),t=e.proc("poll"),n=e.proc("refresh"),i=e.block();t(i),n(i);var s,a=e.shared,o=a.gl,c=a.next,l=a.current;i(l,".dirty=false;"),P(e,t),P(e,n,null,!0),y&&(s=e.link(y)),r.oes_vertex_array_object&&n(e.link(r.oes_vertex_array_object),".bindVertexArrayOES(null);");for(var u=0;u<A.maxAttributes;++u){var h=n.def(a.attributes,"[",u,"]"),d=e.cond(h,".buffer");d.then(o,".enableVertexAttribArray(",u,");",o,".bindBuffer(",Qn,",",h,".buffer.buffer);",o,".vertexAttribPointer(",u,",",h,".size,",h,".type,",h,".normalized,",h,".stride,",h,".offset);").else(o,".disableVertexAttribArray(",u,");",o,".vertexAttrib4f(",u,",",h,".x,",h,".y,",h,".z,",h,".w);",h,".buffer=null;"),n(d),y&&n(s,".vertexAttribDivisorANGLE(",u,",",h,".divisor);")}return n(e.shared.vao,".currentVAO=null;",e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"),Object.keys(x).forEach((function(r){var A=x[r],s=i.def(c,".",r),a=e.block();a("if(",s,"){",o,".enable(",A,")}else{",o,".disable(",A,")}",l,".",r,"=",s,";"),n(a),t("if(",s,"!==",l,".",r,"){",a,"}")})),Object.keys(U).forEach((function(r){var A,s,a=U[r],u=B[r],h=e.block();if(h(o,".",a,"("),de(u)){var d=u.length;A=e.global.def(c,".",r),s=e.global.def(l,".",r),h(T(d,(function(e){return A+"["+e+"]"})),");",T(d,(function(e){return s+"["+e+"]="+A+"["+e+"];"})).join("")),t("if(",T(d,(function(e){return A+"["+e+"]!=="+s+"["+e+"]"})).join("||"),"){",h,"}")}else A=i.def(c,".",r),s=i.def(l,".",r),h(A,");",l,".",r,"=",A,";"),t("if(",A,"!==",s,"){",h,"}");n(h)})),e.compile()}(),compile:function(e,r,A,i,s){var a=M();a.stats=a.link(s),Object.keys(r.static).forEach((function(e){Y(a,r,e)})),En.forEach((function(t){Y(a,e,t)}));var o=O(e,r,A,i,a);return function(e,t){var n=e.proc("draw",1);N(e,n),L(e,n,t.context),P(e,n,t.framebuffer),H(e,n,t),R(e,n,t.state),V(e,n,t,!1,!0);var r=t.shader.progVar.append(e,n);if(n(e.shared.gl,".useProgram(",r,".program);"),t.shader.program)z(e,n,t,t.shader.program);else{n(e.shared.vao,".setVAO(null);");var A=e.global.def("{}"),i=n.def(r,".id"),s=n.def(A,"[",i,"]");n(e.cond(s).then(s,".call(this,a0);").else(s,"=",A,"[",i,"]=",e.link((function(n){return G(z,e,t,n,1)})),"(",r,");",s,".call(this,a0);"))}Object.keys(t.state).length>0&&n(e.shared.current,".dirty=true;"),e.shared.vao&&n(e.shared.vao,".setVAO(null);")}(a,o),function(e,t){var r=e.proc("scope",3);e.batchId="a2";var A=e.shared,i=A.current;function s(n){var i=t.shader[n];i&&r.set(A.shader,"."+n,i.append(e,r))}L(e,r,t.context),t.framebuffer&&t.framebuffer.append(e,r),ir(Object.keys(t.state)).forEach((function(n){var i=t.state[n].append(e,r);de(i)?i.forEach((function(t,A){r.set(e.next[n],"["+A+"]",t)})):r.set(A.next,"."+n,i)})),V(e,r,t,!0,!0),[dn,gn,pn,mn,fn].forEach((function(n){var i=t.draw[n];i&&r.set(A.draw,"."+n,""+i.append(e,r))})),Object.keys(t.uniforms).forEach((function(i){var s=t.uniforms[i].append(e,r);Array.isArray(s)&&(s="["+s.join()+"]"),r.set(A.uniforms,"["+n.id(i)+"]",s)})),Object.keys(t.attributes).forEach((function(n){var A=t.attributes[n].append(e,r),i=e.scopeAttrib(n);Object.keys(new g).forEach((function(e){r.set(i,"."+e,A[e])}))})),t.scopeVAO&&r.set(A.vao,".targetVAO",t.scopeVAO.append(e,r)),s(un),s(hn),Object.keys(t.state).length>0&&(r(i,".dirty=true;"),r.exit(i,".dirty=true;")),r("a1(",e.shared.context,",a0,",e.batchId,");")}(a,o),function(e,t){var n=e.proc("batch",2);e.batchId="0",N(e,n);var r=!1,A=!0;Object.keys(t.context).forEach((function(e){r=r||t.context[e].propDep})),r||(L(e,n,t.context),A=!1);var i=t.framebuffer,s=!1;function a(e){return e.contextDep&&r||e.propDep}i?(i.propDep?r=s=!0:i.contextDep&&r&&(s=!0),s||P(e,n,i)):P(e,n,null),t.state.viewport&&t.state.viewport.propDep&&(r=!0),H(e,n,t),R(e,n,t.state,(function(e){return!a(e)})),t.profile&&a(t.profile)||V(e,n,t,!1,"a1"),t.contextDep=r,t.needsContext=A,t.needsFramebuffer=s;var o=t.shader.progVar;if(o.contextDep&&r||o.propDep)J(e,n,t,null);else{var c=o.append(e,n);if(n(e.shared.gl,".useProgram(",c,".program);"),t.shader.program)J(e,n,t,t.shader.program);else{n(e.shared.vao,".setVAO(null);");var l=e.global.def("{}"),u=n.def(c,".id"),h=n.def(l,"[",u,"]");n(e.cond(h).then(h,".call(this,a0,a1);").else(h,"=",l,"[",u,"]=",e.link((function(n){return G(J,e,t,n,2)})),"(",c,");",h,".call(this,a0,a1);"))}}Object.keys(t.state).length>0&&n(e.shared.current,".dirty=true;"),e.shared.vao&&n(e.shared.vao,".setVAO(null);")}(a,o),t(a.compile(),{destroy:function(){o.shader.program.destroy()}})}}}var hr=function(e,t){if(!t.ext_disjoint_timer_query)return null;var n=[];function r(e){n.push(e)}var A=[];function i(){this.startQueryIndex=-1,this.endQueryIndex=-1,this.sum=0,this.stats=null}var s=[];function a(e){s.push(e)}var o=[];function c(e,t,n){var r=s.pop()||new i;r.startQueryIndex=e,r.endQueryIndex=t,r.sum=0,r.stats=n,o.push(r)}var l=[],u=[];return{beginQuery:function(e){var r=n.pop()||t.ext_disjoint_timer_query.createQueryEXT();t.ext_disjoint_timer_query.beginQueryEXT(35007,r),A.push(r),c(A.length-1,A.length,e)},endQuery:function(){t.ext_disjoint_timer_query.endQueryEXT(35007)},pushScopeStats:c,update:function(){var e,n,i=A.length;if(0!==i){u.length=Math.max(u.length,i+1),l.length=Math.max(l.length,i+1),l[0]=0,u[0]=0;var s=0;for(e=0,n=0;n<A.length;++n){var c=A[n];t.ext_disjoint_timer_query.getQueryObjectEXT(c,34919)?(s+=t.ext_disjoint_timer_query.getQueryObjectEXT(c,34918),r(c)):A[e++]=c,l[n+1]=s,u[n+1]=e}for(A.length=e,e=0,n=0;n<o.length;++n){var h=o[n],d=h.startQueryIndex,f=h.endQueryIndex;h.sum+=l[f]-l[d];var p=u[d],g=u[f];g===p?(h.stats.gpuTime+=h.sum/1e6,a(h)):(h.startQueryIndex=p,h.endQueryIndex=g,o[e++]=h)}o.length=e}},getNumPendingQueries:function(){return A.length},clear:function(){n.push.apply(n,A);for(var e=0;e<n.length;e++)t.ext_disjoint_timer_query.deleteQueryEXT(n[e]);A.length=0,n.length=0},restore:function(){A.length=0,n.length=0}}},dr="webglcontextlost",fr="webglcontextrestored";function pr(e,t){for(var n=0;n<e.length;++n)if(e[n]===t)return n;return-1}return function(n){var r=M(n);if(!r)return null;var A=r.gl,i=A.getContextAttributes(),s=A.isContextLost(),a=function(e,t){var n={};function r(t){_.type(t,"string","extension name must be string");var r,A=t.toLowerCase();try{r=n[A]=e.getExtension(A)}catch(e){}return!!r}for(var A=0;A<t.extensions.length;++A){var i=t.extensions[A];if(!r(i))return t.onDestroy(),t.onDone('"'+i+'" extension is not supported by the current WebGL context, try upgrading your system or a different browser'),null}return t.optionalExtensions.forEach(r),{extensions:n,restore:function(){Object.keys(n).forEach((function(e){if(n[e]&&!r(e))throw new Error("(regl): error restoring extension "+e)}))}}}(A,r);if(!a)return null;var o,c,l=(o={"":0},c=[""],{id:function(e){var t=o[e];return t||(t=o[e]=c.length,c.push(e),t)},str:function(e){return c[e]}}),u={vaoCount:0,bufferCount:0,elementsCount:0,framebufferCount:0,shaderCount:0,textureCount:0,cubeCount:0,renderbufferCount:0,maxTextureUnits:0},h=a.extensions,d=hr(0,h),f=I(),p=A.drawingBufferWidth,g=A.drawingBufferHeight,m={tick:0,time:0,viewportWidth:p,viewportHeight:g,framebufferWidth:p,framebufferHeight:g,drawingBufferWidth:p,drawingBufferHeight:g,pixelRatio:r.pixelRatio},y={elements:null,primitive:4,count:-1,offset:0,instances:-1},w=function(e,t){var n=1;t.ext_texture_filter_anisotropic&&(n=e.getParameter(34047));var r=1,A=1;t.webgl_draw_buffers&&(r=e.getParameter(34852),A=e.getParameter(36063));var i=!!t.oes_texture_float;if(i){var s=e.createTexture();e.bindTexture(H,s),e.texImage2D(H,0,R,1,1,0,R,N,null);var a=e.createFramebuffer();if(e.bindFramebuffer(V,a),e.framebufferTexture2D(V,36064,H,s,0),e.bindTexture(H,null),36053!==e.checkFramebufferStatus(V))i=!1;else{e.viewport(0,0,1,1),e.clearColor(1,0,0,1),e.clear(16384);var o=P.allocType(N,4);e.readPixels(0,0,1,1,R,N,o),e.getError()?i=!1:(e.deleteFramebuffer(a),e.deleteTexture(s),i=1===o[0]),P.freeType(o)}}var c=!0;if("undefined"==typeof navigator||!(/MSIE/.test(navigator.userAgent)||/Trident\//.test(navigator.appVersion)||/Edge/.test(navigator.userAgent))){var l=e.createTexture(),u=P.allocType(5121,36);e.activeTexture(33984),e.bindTexture(34067,l),e.texImage2D(34069,0,R,3,3,0,R,5121,u),P.freeType(u),e.bindTexture(34067,null),e.deleteTexture(l),c=!e.getError()}return{colorBits:[e.getParameter(3410),e.getParameter(3411),e.getParameter(3412),e.getParameter(3413)],depthBits:e.getParameter(3414),stencilBits:e.getParameter(3415),subpixelBits:e.getParameter(3408),extensions:Object.keys(t).filter((function(e){return!!t[e]})),maxAnisotropic:n,maxDrawbuffers:r,maxColorAttachments:A,pointSizeDims:e.getParameter(33901),lineWidthDims:e.getParameter(33902),maxViewportDims:e.getParameter(3386),maxCombinedTextureUnits:e.getParameter(35661),maxCubeMapSize:e.getParameter(34076),maxRenderbufferSize:e.getParameter(34024),maxTextureUnits:e.getParameter(34930),maxTextureSize:e.getParameter(3379),maxAttributes:e.getParameter(34921),maxVertexUniforms:e.getParameter(36347),maxVertexTextureUnits:e.getParameter(35660),maxVaryingVectors:e.getParameter(36348),maxFragmentUniforms:e.getParameter(36349),glsl:e.getParameter(35724),renderer:e.getParameter(7937),vendor:e.getParameter(7936),version:e.getParameter(7938),readFloat:i,npotTextureCube:c}}(A,h),v=function(t,n,r,A){var i=0,s={};function a(e){this.id=i++,this.buffer=t.createBuffer(),this.type=e,this.usage=35044,this.byteLength=0,this.dimension=1,this.dtype=Z,this.persistentData=null,r.profile&&(this.stats={size:0})}a.prototype.bind=function(){t.bindBuffer(this.type,this.buffer)},a.prototype.destroy=function(){u(this)};var o=[];function c(e,n,r){e.byteLength=n.byteLength,t.bufferData(e.type,n,r)}function l(t,n,r,A,i,s){var a,o;if(t.usage=r,Array.isArray(n)){if(t.dtype=A||ee,n.length>0)if(Array.isArray(n[0])){a=X(n);for(var l=1,u=1;u<a.length;++u)l*=a[u];t.dimension=l,c(t,o=Y(n,a,t.dtype),r),s?t.persistentData=o:P.freeType(o)}else if("number"==typeof n[0]){t.dimension=i;var h=P.allocType(t.dtype,n.length);re(h,n),c(t,h,r),s?t.persistentData=h:P.freeType(h)}else e(n[0])?(t.dimension=n[0].length,t.dtype=A||ne(n[0])||ee,c(t,o=Y(n,[n.length,n[0].length],t.dtype),r),s?t.persistentData=o:P.freeType(o)):_.raise("invalid buffer data")}else if(e(n))t.dtype=A||ne(n),t.dimension=i,c(t,n,r),s&&(t.persistentData=new Uint8Array(new Uint8Array(n.buffer)));else if(K(n)){a=n.shape;var d=n.stride,f=n.offset,p=0,g=0,m=0,y=0;1===a.length?(p=a[0],g=1,m=d[0],y=0):2===a.length?(p=a[0],g=a[1],m=d[0],y=d[1]):_.raise("invalid shape"),t.dtype=A||ne(n.data)||ee,t.dimension=g;var w=P.allocType(t.dtype,p*g);Ae(w,n.data,p,g,m,y,f),c(t,w,r),s?t.persistentData=w:P.freeType(w)}else n instanceof ArrayBuffer?(t.dtype=Z,t.dimension=i,c(t,n,r),s&&(t.persistentData=new Uint8Array(new Uint8Array(n)))):_.raise("invalid buffer data")}function u(e){n.bufferCount--,A(e);var r=e.buffer;_(r,"buffer must not be deleted already"),t.deleteBuffer(r),e.buffer=null,delete s[e.id]}return r.profile&&(n.getTotalBufferSize=function(){var e=0;return Object.keys(s).forEach((function(t){e+=s[t].stats.size})),e}),{create:function(A,i,o,c){n.bufferCount++;var h=new a(i);function d(n){var A=35044,i=null,s=0,a=0,o=1;return Array.isArray(n)||e(n)||K(n)||n instanceof ArrayBuffer?i=n:"number"==typeof n?s=0|n:n&&(_.type(n,"object","buffer arguments must be an object, a number or an array"),"data"in n&&(_(null===i||Array.isArray(i)||e(i)||K(i),"invalid data for buffer"),i=n.data),"usage"in n&&(_.parameter(n.usage,J,"invalid buffer usage"),A=J[n.usage]),"type"in n&&(_.parameter(n.type,q,"invalid buffer type"),a=q[n.type]),"dimension"in n&&(_.type(n.dimension,"number","invalid dimension"),o=0|n.dimension),"length"in n&&(_.nni(s,"buffer length must be a nonnegative integer"),s=0|n.length)),h.bind(),i?l(h,i,A,a,o,c):(s&&t.bufferData(h.type,s,A),h.dtype=a||Z,h.usage=A,h.dimension=o,h.byteLength=s),r.profile&&(h.stats.size=h.byteLength*te[h.dtype]),d}function f(e,n){_(n+e.byteLength<=h.byteLength,"invalid buffer subdata call, buffer is too small.  Can't write data of size "+e.byteLength+" starting from offset "+n+" to a buffer of size "+h.byteLength),t.bufferSubData(h.type,n,e)}return s[h.id]=h,o||d(A),d._reglType="buffer",d._buffer=h,d.subdata=function(t,n){var r,A=0|(n||0);if(h.bind(),e(t)||t instanceof ArrayBuffer)f(t,A);else if(Array.isArray(t)){if(t.length>0)if("number"==typeof t[0]){var i=P.allocType(h.dtype,t.length);re(i,t),f(i,A),P.freeType(i)}else if(Array.isArray(t[0])||e(t[0])){r=X(t);var s=Y(t,r,h.dtype);f(s,A),P.freeType(s)}else _.raise("invalid buffer data")}else if(K(t)){r=t.shape;var a=t.stride,o=0,c=0,l=0,u=0;1===r.length?(o=r[0],c=1,l=a[0],u=0):2===r.length?(o=r[0],c=r[1],l=a[0],u=a[1]):_.raise("invalid shape");var p=Array.isArray(t.data)?h.dtype:ne(t.data),g=P.allocType(p,o*c);Ae(g,t.data,o,c,l,u,t.offset),f(g,A),P.freeType(g)}else _.raise("invalid data for buffer subdata");return d},r.profile&&(d.stats=h.stats),d.destroy=function(){u(h)},d},createStream:function(e,t){var n=o.pop();return n||(n=new a(e)),n.bind(),l(n,t,35040,0,1,!1),n},destroyStream:function(e){o.push(e)},clear:function(){j(s).forEach(u),o.forEach(u)},getBuffer:function(e){return e&&e._buffer instanceof a?e._buffer:null},restore:function(){j(s).forEach((function(e){e.buffer=t.createBuffer(),t.bindBuffer(e.type,e.buffer),t.bufferData(e.type,e.persistentData||e.byteLength,e.usage)}))},_initBuffer:l}}(A,u,r,(function(e){return b.destroyBuffer(e)})),B=function(t,n,r,A){var i={},s=0,a={uint8:se,uint16:ae};function o(e){this.id=s++,i[this.id]=this,this.buffer=e,this.primType=4,this.vertCount=0,this.type=0}n.oes_element_index_uint&&(a.uint32=oe),o.prototype.bind=function(){this.buffer.bind()};var c=[];function l(A,i,s,a,o,c,l){var u;if(A.buffer.bind(),i){var h=l;l||e(i)&&(!K(i)||e(i.data))||(h=n.oes_element_index_uint?oe:ae),r._initBuffer(A.buffer,i,s,h,3)}else t.bufferData(ce,c,s),A.buffer.dtype=u||se,A.buffer.usage=s,A.buffer.dimension=3,A.buffer.byteLength=c;if(u=l,!l){switch(A.buffer.dtype){case se:case 5120:u=se;break;case ae:case 5122:u=ae;break;case oe:case 5124:u=oe;break;default:_.raise("unsupported type for element array")}A.buffer.dtype=u}A.type=u,_(u!==oe||!!n.oes_element_index_uint,"32 bit element buffers not supported, enable oes_element_index_uint first");var d=o;d<0&&(d=A.buffer.byteLength,u===ae?d>>=1:u===oe&&(d>>=2)),A.vertCount=d;var f=a;if(a<0){f=4;var p=A.buffer.dimension;1===p&&(f=0),2===p&&(f=1),3===p&&(f=4)}A.primType=f}function u(e){A.elementsCount--,_(null!==e.buffer,"must not double destroy elements"),delete i[e.id],e.buffer.destroy(),e.buffer=null}return{create:function(t,n){var i=r.create(null,ce,!0),s=new o(i._buffer);function c(t){if(t)if("number"==typeof t)i(t),s.primType=4,s.vertCount=0|t,s.type=se;else{var n=null,r=35044,A=-1,o=-1,u=0,h=0;Array.isArray(t)||e(t)||K(t)?n=t:(_.type(t,"object","invalid arguments for elements"),"data"in t&&(n=t.data,_(Array.isArray(n)||e(n)||K(n),"invalid data for element buffer")),"usage"in t&&(_.parameter(t.usage,J,"invalid element buffer usage"),r=J[t.usage]),"primitive"in t&&(_.parameter(t.primitive,ie,"invalid element buffer primitive"),A=ie[t.primitive]),"count"in t&&(_("number"==typeof t.count&&t.count>=0,"invalid vertex count for elements"),o=0|t.count),"type"in t&&(_.parameter(t.type,a,"invalid buffer type"),h=a[t.type]),"length"in t?u=0|t.length:(u=o,h===ae||5122===h?u*=2:h!==oe&&5124!==h||(u*=4))),l(s,n,r,A,o,u,h)}else i(),s.primType=4,s.vertCount=0,s.type=se;return c}return A.elementsCount++,c(t),c._reglType="elements",c._elements=s,c.subdata=function(e,t){return i.subdata(e,t),c},c.destroy=function(){u(s)},c},createStream:function(e){var t=c.pop();return t||(t=new o(r.create(null,ce,!0,!1)._buffer)),l(t,e,35040,-1,-1,0,0),t},destroyStream:function(e){c.push(e)},getElements:function(e){return"function"==typeof e&&e._elements instanceof o?e._elements:null},clear:function(){j(i).forEach(u)}}}(A,h,v,u),b=function(t,n,r,A,i,s,a){for(var o=r.maxAttributes,c=new Array(o),l=0;l<o;++l)c[l]=new Et;var u=0,h={},d={Record:Et,scope:{},state:c,currentVAO:null,targetVAO:null,restore:f()?function(){f()&&j(h).forEach((function(e){e.refresh()}))}:function(){},createVAO:function(t){var r=new g;function a(t){var A;if(Array.isArray(t))A=t,r.elements&&r.ownsElements&&r.elements.destroy(),r.elements=null,r.ownsElements=!1,r.offset=0,r.count=0,r.instances=-1,r.primitive=4;else{if(_("object"==typeof t,"invalid arguments for create vao"),_("attributes"in t,"must specify attributes for vao"),t.elements){var c=t.elements;r.ownsElements?"function"==typeof c&&"elements"===c._reglType?(r.elements.destroy(),r.ownsElements=!1):(r.elements(c),r.ownsElements=!1):s.getElements(t.elements)?(r.elements=t.elements,r.ownsElements=!1):(r.elements=s.create(t.elements),r.ownsElements=!0)}else r.elements=null,r.ownsElements=!1;A=t.attributes,r.offset=0,r.count=-1,r.instances=-1,r.primitive=4,r.elements&&(r.count=r.elements._elements.vertCount,r.primitive=r.elements._elements.primType),"offset"in t&&(r.offset=0|t.offset),"count"in t&&(r.count=0|t.count),"instances"in t&&(r.instances=0|t.instances),"primitive"in t&&(_(t.primitive in ie,"bad primitive type: "+t.primitive),r.primitive=ie[t.primitive]),_.optional((()=>{for(var e=Object.keys(t),n=0;n<e.length;++n)_(Ft.indexOf(e[n])>=0,'invalid option for vao: "'+e[n]+'" valid options are '+Ft)})),_(Array.isArray(A),"attributes must be an array")}_(A.length<o,"too many attributes"),_(A.length>0,"must specify at least one attribute");var l={},u=r.attributes;u.length=A.length;for(var h=0;h<A.length;++h){var d,f=A[h],p=u[h]=new Et,g=f.data||f;Array.isArray(g)||e(g)||K(g)?(r.buffers[h]&&(d=r.buffers[h],e(g)&&d._buffer.byteLength>=g.byteLength?d.subdata(g):(d.destroy(),r.buffers[h]=null)),r.buffers[h]||(d=r.buffers[h]=i.create(f,34962,!1,!0)),p.buffer=i.getBuffer(d),p.size=0|p.buffer.dimension,p.normalized=!1,p.type=p.buffer.dtype,p.offset=0,p.stride=0,p.divisor=0,p.state=1,l[h]=1):i.getBuffer(f)?(p.buffer=i.getBuffer(f),p.size=0|p.buffer.dimension,p.normalized=!1,p.type=p.buffer.dtype,p.offset=0,p.stride=0,p.divisor=0,p.state=1):i.getBuffer(f.buffer)?(p.buffer=i.getBuffer(f.buffer),p.size=0|(+f.size||p.buffer.dimension),p.normalized=!!f.normalized||!1,"type"in f?(_.parameter(f.type,q,"invalid buffer type"),p.type=q[f.type]):p.type=p.buffer.dtype,p.offset=0|(f.offset||0),p.stride=0|(f.stride||0),p.divisor=0|(f.divisor||0),p.state=1,_(p.size>=1&&p.size<=4,"size must be between 1 and 4"),_(p.offset>=0,"invalid offset"),_(p.stride>=0&&p.stride<=255,"stride must be between 0 and 255"),_(p.divisor>=0,"divisor must be positive"),_(!p.divisor||!!n.angle_instanced_arrays,"ANGLE_instanced_arrays must be enabled to use divisor")):"x"in f?(_(h>0,"first attribute must not be a constant"),p.x=+f.x||0,p.y=+f.y||0,p.z=+f.z||0,p.w=+f.w||0,p.state=2):_(!1,"invalid attribute spec for location "+h)}for(var m=0;m<r.buffers.length;++m)!l[m]&&r.buffers[m]&&(r.buffers[m].destroy(),r.buffers[m]=null);return r.refresh(),a}return A.vaoCount+=1,a.destroy=function(){for(var e=0;e<r.buffers.length;++e)r.buffers[e]&&r.buffers[e].destroy();r.buffers.length=0,r.ownsElements&&(r.elements.destroy(),r.elements=null,r.ownsElements=!1),r.destroy()},a._vao=r,a._reglType="vao",a(t)},getVAO:function(e){return"function"==typeof e&&e._vao?e._vao:null},destroyBuffer:function(e){for(var n=0;n<c.length;++n){var r=c[n];r.buffer===e&&(t.disableVertexAttribArray(n),r.buffer=null)}},setVAO:f()?function(e){if(e!==d.currentVAO){var t=f();e?t.bindVertexArrayOES(e.vao):t.bindVertexArrayOES(null),d.currentVAO=e}}:function(e){if(e!==d.currentVAO){if(e)e.bindAttrs();else{for(var n=p(),r=0;r<c.length;++r){var A=c[r];A.buffer?(t.enableVertexAttribArray(r),A.buffer.bind(),t.vertexAttribPointer(r,A.size,A.type,A.normalized,A.stride,A.offfset),n&&A.divisor&&n.vertexAttribDivisorANGLE(r,A.divisor)):(t.disableVertexAttribArray(r),t.vertexAttrib4f(r,A.x,A.y,A.z,A.w))}a.elements?t.bindBuffer(Ut,a.elements.buffer.buffer):t.bindBuffer(Ut,null)}d.currentVAO=e}},clear:f()?function(){j(h).forEach((function(e){e.destroy()}))}:function(){}};function f(){return n.oes_vertex_array_object}function p(){return n.angle_instanced_arrays}function g(){this.id=++u,this.attributes=[],this.elements=null,this.ownsElements=!1,this.count=0,this.offset=0,this.instances=-1,this.primitive=4;var e=f();this.vao=e?e.createVertexArrayOES():null,h[this.id]=this,this.buffers=[]}return g.prototype.bindAttrs=function(){for(var e=p(),n=this.attributes,r=0;r<n.length;++r){var A=n[r];A.buffer?(t.enableVertexAttribArray(r),t.bindBuffer(34962,A.buffer.buffer),t.vertexAttribPointer(r,A.size,A.type,A.normalized,A.stride,A.offset),e&&A.divisor&&e.vertexAttribDivisorANGLE(r,A.divisor)):(t.disableVertexAttribArray(r),t.vertexAttrib4f(r,A.x,A.y,A.z,A.w))}for(var i=n.length;i<o;++i)t.disableVertexAttribArray(i);var a=s.getElements(this.elements);a?t.bindBuffer(Ut,a.buffer.buffer):t.bindBuffer(Ut,null)},g.prototype.refresh=function(){var e=f();e&&(e.bindVertexArrayOES(this.vao),this.bindAttrs(),d.currentVAO=null,e.bindVertexArrayOES(null))},g.prototype.destroy=function(){if(this.vao){var e=f();this===d.currentVAO&&(d.currentVAO=null,e.bindVertexArrayOES(null)),e.deleteVertexArrayOES(this.vao),this.vao=null}this.ownsElements&&(this.elements.destroy(),this.elements=null,this.ownsElements=!1),h[this.id]&&(delete h[this.id],A.vaoCount-=1)},d}(A,h,w,u,v,B,y),C=function(e,n,r,A){var i={},s={};function a(e,t,n,r){this.name=e,this.id=t,this.location=n,this.info=r}function o(e,t){for(var n=0;n<e.length;++n)if(e[n].id===t.id)return void(e[n].location=t.location);e.push(t)}function c(t,r,A){var a=35632===t?i:s,o=a[r];if(!o){var c=n.str(r);o=e.createShader(t),e.shaderSource(o,c),e.compileShader(o),_.shaderError(e,o,c,t,A),a[r]=o}return o}var l={},u=[],h=0;function d(e,t){this.id=h++,this.fragId=e,this.vertId=t,this.program=null,this.uniforms=[],this.attributes=[],this.refCount=1,A.profile&&(this.stats={uniformsCount:0,attributesCount:0})}function f(t,r,i){var s,l,u=c(35632,t.fragId),h=c(35633,t.vertId),d=t.program=e.createProgram();if(e.attachShader(d,u),e.attachShader(d,h),i)for(s=0;s<i.length;++s){var f=i[s];e.bindAttribLocation(d,f[0],f[1])}e.linkProgram(d),_.linkError(e,d,n.str(t.fragId),n.str(t.vertId),r);var p=e.getProgramParameter(d,35718);A.profile&&(t.stats.uniformsCount=p);var g=t.uniforms;for(s=0;s<p;++s)if(l=e.getActiveUniform(d,s))if(l.size>1)for(var m=0;m<l.size;++m){var y=l.name.replace("[0]","["+m+"]");o(g,new a(y,n.id(y),e.getUniformLocation(d,y),l))}else o(g,new a(l.name,n.id(l.name),e.getUniformLocation(d,l.name),l));var w=e.getProgramParameter(d,35721);A.profile&&(t.stats.attributesCount=w);var v=t.attributes;for(s=0;s<w;++s)(l=e.getActiveAttrib(d,s))&&o(v,new a(l.name,n.id(l.name),e.getAttribLocation(d,l.name),l))}return A.profile&&(r.getMaxUniformsCount=function(){var e=0;return u.forEach((function(t){t.stats.uniformsCount>e&&(e=t.stats.uniformsCount)})),e},r.getMaxAttributesCount=function(){var e=0;return u.forEach((function(t){t.stats.attributesCount>e&&(e=t.stats.attributesCount)})),e}),{clear:function(){var t=e.deleteShader.bind(e);j(i).forEach(t),i={},j(s).forEach(t),s={},u.forEach((function(t){e.deleteProgram(t.program)})),u.length=0,l={},r.shaderCount=0},program:function(n,A,a,o){_.command(n>=0,"missing vertex shader",a),_.command(A>=0,"missing fragment shader",a);var c=l[A];c||(c=l[A]={});var h=c[n];if(h&&(h.refCount++,!o))return h;var p=new d(A,n);return r.shaderCount++,f(p,a,o),h||(c[n]=p),u.push(p),t(p,{destroy:function(){if(p.refCount--,p.refCount<=0){e.deleteProgram(p.program);var t=u.indexOf(p);u.splice(t,1),r.shaderCount--}c[p.vertId].refCount<=0&&(e.deleteShader(s[p.vertId]),delete s[p.vertId],delete l[p.fragId][p.vertId]),Object.keys(l[p.fragId]).length||(e.deleteShader(i[p.fragId]),delete i[p.fragId],delete l[p.fragId])}})},restore:function(){i={},s={};for(var e=0;e<u.length;++e)f(u[e],null,u[e].attributes.map((function(e){return[e.location,e.name]})))},shader:c,frag:-1,vert:-1}}(A,l,u,r),x=ht(A,h,w,(function(){E.procs.poll()}),m,u,r),U=function(e,t,n,r,A){var i={rgba4:ft,rgb565:36194,"rgb5 a1":32855,depth:33189,stencil:36168,"depth stencil":34041};t.ext_srgb&&(i.srgba=35907),t.ext_color_buffer_half_float&&(i.rgba16f=34842,i.rgb16f=34843),t.webgl_color_buffer_float&&(i.rgba32f=34836);var s=[];Object.keys(i).forEach((function(e){var t=i[e];s[t]=e}));var a=0,o={};function c(e){this.id=a++,this.refCount=1,this.renderbuffer=e,this.format=ft,this.width=0,this.height=0,A.profile&&(this.stats={size:0})}function l(t){var n=t.renderbuffer;_(n,"must not double destroy renderbuffer"),e.bindRenderbuffer(dt,null),e.deleteRenderbuffer(n),t.renderbuffer=null,t.refCount=0,delete o[t.id],r.renderbufferCount--}return c.prototype.decRef=function(){--this.refCount<=0&&l(this)},A.profile&&(r.getTotalRenderbufferSize=function(){var e=0;return Object.keys(o).forEach((function(t){e+=o[t].stats.size})),e}),{create:function(t,a){var l=new c(e.createRenderbuffer());function u(t,r){var a=0,o=0,c=ft;if("object"==typeof t&&t){var h=t;if("shape"in h){var d=h.shape;_(Array.isArray(d)&&d.length>=2,"invalid renderbuffer shape"),a=0|d[0],o=0|d[1]}else"radius"in h&&(a=o=0|h.radius),"width"in h&&(a=0|h.width),"height"in h&&(o=0|h.height);"format"in h&&(_.parameter(h.format,i,"invalid renderbuffer format"),c=i[h.format])}else"number"==typeof t?(a=0|t,o="number"==typeof r?0|r:a):t?_.raise("invalid arguments to renderbuffer constructor"):a=o=1;if(_(a>0&&o>0&&a<=n.maxRenderbufferSize&&o<=n.maxRenderbufferSize,"invalid renderbuffer size"),a!==l.width||o!==l.height||c!==l.format)return u.width=l.width=a,u.height=l.height=o,l.format=c,e.bindRenderbuffer(dt,l.renderbuffer),e.renderbufferStorage(dt,c,a,o),_(0===e.getError(),"invalid render buffer format"),A.profile&&(l.stats.size=gt(l.format,l.width,l.height)),u.format=s[l.format],u}return o[l.id]=l,r.renderbufferCount++,u(t,a),u.resize=function(t,r){var i=0|t,s=0|r||i;return i===l.width&&s===l.height||(_(i>0&&s>0&&i<=n.maxRenderbufferSize&&s<=n.maxRenderbufferSize,"invalid renderbuffer size"),u.width=l.width=i,u.height=l.height=s,e.bindRenderbuffer(dt,l.renderbuffer),e.renderbufferStorage(dt,l.format,i,s),_(0===e.getError(),"invalid render buffer format"),A.profile&&(l.stats.size=gt(l.format,l.width,l.height))),u},u._reglType="renderbuffer",u._renderbuffer=l,A.profile&&(u.stats=l.stats),u.destroy=function(){l.decRef()},u},clear:function(){j(o).forEach(l)},restore:function(){j(o).forEach((function(t){t.renderbuffer=e.createRenderbuffer(),e.bindRenderbuffer(dt,t.renderbuffer),e.renderbufferStorage(dt,t.format,t.width,t.height)})),e.bindRenderbuffer(dt,null)}}}(A,h,w,u,r),F=function(e,n,r,A,i,s){var a={cur:null,next:null,dirty:!1,setFBO:null},o=["rgba"],c=["rgba4","rgb565","rgb5 a1"];n.ext_srgb&&c.push("srgba"),n.ext_color_buffer_half_float&&c.push("rgba16f","rgb16f"),n.webgl_color_buffer_float&&c.push("rgba32f");var l=["uint8"];function u(e,t,n){this.target=e,this.texture=t,this.renderbuffer=n;var r=0,A=0;t?(r=t.width,A=t.height):n&&(r=n.width,A=n.height),this.width=r,this.height=A}function h(e){e&&(e.texture&&e.texture._texture.decRef(),e.renderbuffer&&e.renderbuffer._renderbuffer.decRef())}function d(e,t,n){if(e)if(e.texture){var r=e.texture._texture,A=Math.max(1,r.width),i=Math.max(1,r.height);_(A===t&&i===n,"inconsistent width/height for supplied texture"),r.refCount+=1}else{var s=e.renderbuffer._renderbuffer;_(s.width===t&&s.height===n,"inconsistent width/height for renderbuffer"),s.refCount+=1}}function f(t,n){n&&(n.texture?e.framebufferTexture2D(mt,t,n.target,n.texture._texture.texture,0):e.framebufferRenderbuffer(mt,t,yt,n.renderbuffer._renderbuffer.renderbuffer))}function p(e){var t=wt,n=null,r=null,A=e;"object"==typeof e&&(A=e.data,"target"in e&&(t=0|e.target)),_.type(A,"function","invalid attachment data");var i=A._reglType;return"texture2d"===i?(n=A,_(t===wt)):"textureCube"===i?(n=A,_(t>=vt&&t<34075,"invalid cube map target")):"renderbuffer"===i?(r=A,t=yt):_.raise("invalid regl object for attachment"),new u(t,n,r)}function g(e,t,n,r,s){if(n){var a=A.create2D({width:e,height:t,format:r,type:s});return a._texture.refCount=0,new u(wt,a,null)}var o=i.create({width:e,height:t,format:r});return o._renderbuffer.refCount=0,new u(yt,null,o)}function m(e){return e&&(e.texture||e.renderbuffer)}function y(e,t,n){e&&(e.texture?e.texture.resize(t,n):e.renderbuffer&&e.renderbuffer.resize(t,n),e.width=t,e.height=n)}n.oes_texture_half_float&&l.push("half float","float16"),n.oes_texture_float&&l.push("float","float32");var w=0,v={};function B(){this.id=w++,v[this.id]=this,this.framebuffer=e.createFramebuffer(),this.width=0,this.height=0,this.colorAttachments=[],this.depthAttachment=null,this.stencilAttachment=null,this.depthStencilAttachment=null}function b(e){e.colorAttachments.forEach(h),h(e.depthAttachment),h(e.stencilAttachment),h(e.depthStencilAttachment)}function C(t){var n=t.framebuffer;_(n,"must not double destroy framebuffer"),e.deleteFramebuffer(n),t.framebuffer=null,s.framebufferCount--,delete v[t.id]}function x(t){var n;e.bindFramebuffer(mt,t.framebuffer);var A=t.colorAttachments;for(n=0;n<A.length;++n)f(36064+n,A[n]);for(n=A.length;n<r.maxColorAttachments;++n)e.framebufferTexture2D(mt,36064+n,wt,null,0);e.framebufferTexture2D(mt,33306,wt,null,0),e.framebufferTexture2D(mt,36096,wt,null,0),e.framebufferTexture2D(mt,36128,wt,null,0),f(36096,t.depthAttachment),f(36128,t.stencilAttachment),f(33306,t.depthStencilAttachment);var i=e.checkFramebufferStatus(mt);e.isContextLost()||36053===i||_.raise("framebuffer configuration not supported, status = "+xt[i]),e.bindFramebuffer(mt,a.next?a.next.framebuffer:null),a.cur=a.next,e.getError()}function U(e,A){var i=new B;function u(e,t){var A;_(a.next!==i,"can not update framebuffer which is currently in use");var s=0,h=0,f=!0,y=!0,w=null,v=!0,B="rgba",C="uint8",U=1,F=null,E=null,Q=null,S=!1;if("number"==typeof e)s=0|e,h=0|t||s;else if(e){_.type(e,"object","invalid arguments for framebuffer");var I=e;if("shape"in I){var k=I.shape;_(Array.isArray(k)&&k.length>=2,"invalid shape for framebuffer"),s=k[0],h=k[1]}else"radius"in I&&(s=h=I.radius),"width"in I&&(s=I.width),"height"in I&&(h=I.height);("color"in I||"colors"in I)&&(w=I.color||I.colors,Array.isArray(w)&&_(1===w.length||n.webgl_draw_buffers,"multiple render targets not supported")),w||("colorCount"in I&&(U=0|I.colorCount,_(U>0,"invalid color buffer count")),"colorTexture"in I&&(v=!!I.colorTexture,B="rgba4"),"colorType"in I&&(C=I.colorType,v?(_(n.oes_texture_float||!("float"===C||"float32"===C),"you must enable OES_texture_float in order to use floating point framebuffer objects"),_(n.oes_texture_half_float||!("half float"===C||"float16"===C),"you must enable OES_texture_half_float in order to use 16-bit floating point framebuffer objects")):"half float"===C||"float16"===C?(_(n.ext_color_buffer_half_float,"you must enable EXT_color_buffer_half_float to use 16-bit render buffers"),B="rgba16f"):"float"!==C&&"float32"!==C||(_(n.webgl_color_buffer_float,"you must enable WEBGL_color_buffer_float in order to use 32-bit floating point renderbuffers"),B="rgba32f"),_.oneOf(C,l,"invalid color type")),"colorFormat"in I&&(B=I.colorFormat,o.indexOf(B)>=0?v=!0:c.indexOf(B)>=0?v=!1:_.optional((function(){v?_.oneOf(I.colorFormat,o,"invalid color format for texture"):_.oneOf(I.colorFormat,c,"invalid color format for renderbuffer")})))),("depthTexture"in I||"depthStencilTexture"in I)&&(S=!(!I.depthTexture&&!I.depthStencilTexture),_(!S||n.webgl_depth_texture,"webgl_depth_texture extension not supported")),"depth"in I&&("boolean"==typeof I.depth?f=I.depth:(F=I.depth,y=!1)),"stencil"in I&&("boolean"==typeof I.stencil?y=I.stencil:(E=I.stencil,f=!1)),"depthStencil"in I&&("boolean"==typeof I.depthStencil?f=y=I.depthStencil:(Q=I.depthStencil,f=!1,y=!1))}else s=h=1;var D=null,M=null,T=null,O=null;if(Array.isArray(w))D=w.map(p);else if(w)D=[p(w)];else for(D=new Array(U),A=0;A<U;++A)D[A]=g(s,h,v,B,C);_(n.webgl_draw_buffers||D.length<=1,"you must enable the WEBGL_draw_buffers extension in order to use multiple color buffers."),_(D.length<=r.maxColorAttachments,"too many color attachments, not supported"),s=s||D[0].width,h=h||D[0].height,F?M=p(F):f&&!y&&(M=g(s,h,S,"depth","uint32")),E?T=p(E):y&&!f&&(T=g(s,h,!1,"stencil","uint8")),Q?O=p(Q):!F&&!E&&y&&f&&(O=g(s,h,S,"depth stencil","depth stencil")),_(!!F+!!E+!!Q<=1,"invalid framebuffer configuration, can specify exactly one depth/stencil attachment");var L=null;for(A=0;A<D.length;++A)if(d(D[A],s,h),_(!D[A]||D[A].texture&&Bt.indexOf(D[A].texture._texture.format)>=0||D[A].renderbuffer&&Ct.indexOf(D[A].renderbuffer._renderbuffer.format)>=0,"framebuffer color attachment "+A+" is invalid"),D[A]&&D[A].texture){var P=bt[D[A].texture._texture.format]*_t[D[A].texture._texture.type];null===L?L=P:_(L===P,"all color attachments much have the same number of bits per pixel.")}return d(M,s,h),_(!M||M.texture&&6402===M.texture._texture.format||M.renderbuffer&&33189===M.renderbuffer._renderbuffer.format,"invalid depth attachment for framebuffer object"),d(T,s,h),_(!T||T.renderbuffer&&36168===T.renderbuffer._renderbuffer.format,"invalid stencil attachment for framebuffer object"),d(O,s,h),_(!O||O.texture&&34041===O.texture._texture.format||O.renderbuffer&&34041===O.renderbuffer._renderbuffer.format,"invalid depth-stencil attachment for framebuffer object"),b(i),i.width=s,i.height=h,i.colorAttachments=D,i.depthAttachment=M,i.stencilAttachment=T,i.depthStencilAttachment=O,u.color=D.map(m),u.depth=m(M),u.stencil=m(T),u.depthStencil=m(O),u.width=i.width,u.height=i.height,x(i),u}return s.framebufferCount++,u(e,A),t(u,{resize:function(e,t){_(a.next!==i,"can not resize a framebuffer which is currently in use");var n=Math.max(0|e,1),r=Math.max(0|t||n,1);if(n===i.width&&r===i.height)return u;for(var A=i.colorAttachments,s=0;s<A.length;++s)y(A[s],n,r);return y(i.depthAttachment,n,r),y(i.stencilAttachment,n,r),y(i.depthStencilAttachment,n,r),i.width=u.width=n,i.height=u.height=r,x(i),u},_reglType:"framebuffer",_framebuffer:i,destroy:function(){C(i),b(i)},use:function(e){a.setFBO({framebuffer:u},e)}})}return t(a,{getFramebuffer:function(e){if("function"==typeof e&&"framebuffer"===e._reglType){var t=e._framebuffer;if(t instanceof B)return t}return null},create:U,createCube:function(e){var i=Array(6);function s(e){var r;_(i.indexOf(a.next)<0,"can not update framebuffer which is currently in use");var c,u={color:null},h=0,d=null,f="rgba",p="uint8",g=1;if("number"==typeof e)h=0|e;else if(e){_.type(e,"object","invalid arguments for framebuffer");var m=e;if("shape"in m){var y=m.shape;_(Array.isArray(y)&&y.length>=2,"invalid shape for framebuffer"),_(y[0]===y[1],"cube framebuffer must be square"),h=y[0]}else"radius"in m&&(h=0|m.radius),"width"in m?(h=0|m.width,"height"in m&&_(m.height===h,"must be square")):"height"in m&&(h=0|m.height);("color"in m||"colors"in m)&&(d=m.color||m.colors,Array.isArray(d)&&_(1===d.length||n.webgl_draw_buffers,"multiple render targets not supported")),d||("colorCount"in m&&(g=0|m.colorCount,_(g>0,"invalid color buffer count")),"colorType"in m&&(_.oneOf(m.colorType,l,"invalid color type"),p=m.colorType),"colorFormat"in m&&(f=m.colorFormat,_.oneOf(m.colorFormat,o,"invalid color format for texture"))),"depth"in m&&(u.depth=m.depth),"stencil"in m&&(u.stencil=m.stencil),"depthStencil"in m&&(u.depthStencil=m.depthStencil)}else h=1;if(d)if(Array.isArray(d))for(c=[],r=0;r<d.length;++r)c[r]=d[r];else c=[d];else{c=Array(g);var w={radius:h,format:f,type:p};for(r=0;r<g;++r)c[r]=A.createCube(w)}for(u.color=Array(c.length),r=0;r<c.length;++r){var v=c[r];_("function"==typeof v&&"textureCube"===v._reglType,"invalid cube map"),h=h||v.width,_(v.width===h&&v.height===h,"invalid cube map shape"),u.color[r]={target:vt,data:c[r]}}for(r=0;r<6;++r){for(var B=0;B<c.length;++B)u.color[B].target=vt+r;r>0&&(u.depth=i[0].depth,u.stencil=i[0].stencil,u.depthStencil=i[0].depthStencil),i[r]?i[r](u):i[r]=U(u)}return t(s,{width:h,height:h,color:c})}return s(e),t(s,{faces:i,resize:function(e){var t,n=0|e;if(_(n>0&&n<=r.maxCubeMapSize,"invalid radius for cube fbo"),n===s.width)return s;var A=s.color;for(t=0;t<A.length;++t)A[t].resize(n);for(t=0;t<6;++t)i[t].resize(n);return s.width=s.height=n,s},_reglType:"framebufferCube",destroy:function(){i.forEach((function(e){e.destroy()}))}})},clear:function(){j(v).forEach(C)},restore:function(){a.cur=null,a.next=null,a.dirty=!0,j(v).forEach((function(t){t.framebuffer=e.createFramebuffer(),x(t)}))}})}(A,h,w,x,U,u),E=ur(A,l,h,w,v,B,0,F,{},b,C,y,m,d,r),k=It(A,F,E.procs.poll,m,i,h,w),D=E.next,T=A.canvas,O=[],L=[],$=[],G=[r.onDestroy],z=null;function W(){if(0===O.length)return d&&d.update(),void(z=null);z=S.next(W),we();for(var e=O.length-1;e>=0;--e){var t=O[e];t&&t(m,null,0)}A.flush(),d&&d.update()}function le(){!z&&O.length>0&&(z=S.next(W))}function ue(){z&&(S.cancel(W),z=null)}function he(e){e.preventDefault(),s=!0,ue(),L.forEach((function(e){e()}))}function de(e){A.getError(),s=!1,a.restore(),C.restore(),v.restore(),x.restore(),U.restore(),F.restore(),b.restore(),d&&d.restore(),E.procs.refresh(),le(),$.forEach((function(e){e()}))}function fe(e){function n(e,t){var n={},r={};return Object.keys(e).forEach((function(A){var i=e[A];if(Q.isDynamic(i))r[A]=Q.unbox(i,A);else{if(t&&Array.isArray(i))for(var s=0;s<i.length;++s)if(Q.isDynamic(i[s]))return void(r[A]=Q.unbox(i,A));n[A]=i}})),{dynamic:r,static:n}}_(!!e,"invalid args to regl({...})"),_.type(e,"object","invalid args to regl({...})");var r=n(e.context||{},!0),A=n(e.uniforms||{},!0),i=n(e.attributes||{},!1),a=n(function(e){var n=t({},e);function r(e){if(e in n){var t=n[e];delete n[e],Object.keys(t).forEach((function(r){n[e+"."+r]=t[r]}))}}return delete n.uniforms,delete n.attributes,delete n.context,delete n.vao,"stencil"in n&&n.stencil.op&&(n.stencil.opBack=n.stencil.opFront=n.stencil.op,delete n.stencil.op),r("blend"),r("depth"),r("cull"),r("stencil"),r("polygonOffset"),r("scissor"),r("sample"),"vao"in e&&(n.vao=e.vao),n}(e),!1),o={gpuTime:0,cpuTime:0,count:0},c=E.compile(a,i,A,r,o),l=c.draw,u=c.batch,h=c.scope,d=[];return t((function(e,t){var n;if(s&&_.raise("context lost"),"function"==typeof e)return h.call(this,null,e,0);if("function"==typeof t)if("number"==typeof e)for(n=0;n<e;++n)h.call(this,null,t,n);else{if(!Array.isArray(e))return h.call(this,e,t,0);for(n=0;n<e.length;++n)h.call(this,e[n],t,n)}else if("number"==typeof e){if(e>0)return u.call(this,function(e){for(;d.length<e;)d.push(null);return d}(0|e),0|e)}else{if(!Array.isArray(e))return l.call(this,e);if(e.length)return u.call(this,e,e.length)}}),{stats:o,destroy:function(){c.destroy()}})}T&&(T.addEventListener(dr,he,!1),T.addEventListener(fr,de,!1));var pe=F.setFBO=fe({framebuffer:Q.define.call(null,1,"framebuffer")});function ge(e,t){var n=0;E.procs.poll();var r=t.color;r&&(A.clearColor(+r[0]||0,+r[1]||0,+r[2]||0,+r[3]||0),n|=16384),"depth"in t&&(A.clearDepth(+t.depth),n|=256),"stencil"in t&&(A.clearStencil(0|t.stencil),n|=1024),_(!!n,"called regl.clear with no buffer specified"),A.clear(n)}function me(e){return _.type(e,"function","regl.frame() callback must be a function"),O.push(e),le(),{cancel:function(){var t=pr(O,e);_(t>=0,"cannot cancel a frame twice"),O[t]=function e(){var t=pr(O,e);O[t]=O[O.length-1],O.length-=1,O.length<=0&&ue()}}}}function ye(){var e=D.viewport,t=D.scissor_box;e[0]=e[1]=t[0]=t[1]=0,m.viewportWidth=m.framebufferWidth=m.drawingBufferWidth=e[2]=t[2]=A.drawingBufferWidth,m.viewportHeight=m.framebufferHeight=m.drawingBufferHeight=e[3]=t[3]=A.drawingBufferHeight}function we(){m.tick+=1,m.time=Be(),ye(),E.procs.poll()}function ve(){x.refresh(),ye(),E.procs.refresh(),d&&d.update()}function Be(){return(I()-f)/1e3}ve();var be=t(fe,{clear:function(e){if(_("object"==typeof e&&e,"regl.clear() takes an object as input"),"framebuffer"in e)if(e.framebuffer&&"framebufferCube"===e.framebuffer_reglType)for(var n=0;n<6;++n)pe(t({framebuffer:e.framebuffer.faces[n]},e),ge);else pe(e,ge);else ge(0,e)},prop:Q.define.bind(null,1),context:Q.define.bind(null,2),this:Q.define.bind(null,3),draw:fe({}),buffer:function(e){return v.create(e,34962,!1,!1)},elements:function(e){return B.create(e,!1)},texture:x.create2D,cube:x.createCube,renderbuffer:U.create,framebuffer:F.create,framebufferCube:F.createCube,vao:b.createVAO,attributes:i,frame:me,on:function(e,t){var n;switch(_.type(t,"function","listener callback must be a function"),e){case"frame":return me(t);case"lost":n=L;break;case"restore":n=$;break;case"destroy":n=G;break;default:_.raise("invalid event, must be one of frame,lost,restore,destroy")}return n.push(t),{cancel:function(){for(var e=0;e<n.length;++e)if(n[e]===t)return n[e]=n[n.length-1],void n.pop()}}},limits:w,hasExtension:function(e){return w.extensions.indexOf(e.toLowerCase())>=0},read:k,destroy:function(){O.length=0,ue(),T&&(T.removeEventListener(dr,he),T.removeEventListener(fr,de)),C.clear(),F.clear(),U.clear(),b.clear(),x.clear(),B.clear(),v.clear(),d&&d.clear(),G.forEach((function(e){e()}))},_gl:A,_refresh:ve,poll:function(){we(),d&&d.update()},now:Be,stats:u});return r.onDone(null,be),be}}()},3062:e=>{"use strict";e.exports=function(e,t){if(t=t.split(":")[0],!(e=+e))return!1;switch(t){case"http":case"ws":return 80!==e;case"https":case"wss":return 443!==e;case"ftp":return 21!==e;case"gopher":return 70!==e;case"file":return!1}return 0!==e}},2225:(e,t,n)=>{"use strict";var r=n(3062),A=n(1359),i=/^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/,s=/[\n\r\t]/g,a=/^[A-Za-z][A-Za-z0-9+-.]*:\/\//,o=/:\d+$/,c=/^([a-z][a-z0-9.+-]*:)?(\/\/)?([\\/]+)?([\S\s]*)/i,l=/^[a-zA-Z]:/;function u(e){return(e||"").toString().replace(i,"")}var h=[["#","hash"],["?","query"],function(e,t){return p(t.protocol)?e.replace(/\\/g,"/"):e},["/","pathname"],["@","auth",1],[NaN,"host",void 0,1,1],[/:(\d*)$/,"port",void 0,1],[NaN,"hostname",void 0,1,1]],d={hash:1,query:1};function f(e){var t,r=("undefined"!=typeof window?window:void 0!==n.g?n.g:"undefined"!=typeof self?self:{}).location||{},A={},i=typeof(e=e||r);if("blob:"===e.protocol)A=new m(unescape(e.pathname),{});else if("string"===i)for(t in A=new m(e,{}),d)delete A[t];else if("object"===i){for(t in e)t in d||(A[t]=e[t]);void 0===A.slashes&&(A.slashes=a.test(e.href))}return A}function p(e){return"file:"===e||"ftp:"===e||"http:"===e||"https:"===e||"ws:"===e||"wss:"===e}function g(e,t){e=(e=u(e)).replace(s,""),t=t||{};var n,r=c.exec(e),A=r[1]?r[1].toLowerCase():"",i=!!r[2],a=!!r[3],o=0;return i?a?(n=r[2]+r[3]+r[4],o=r[2].length+r[3].length):(n=r[2]+r[4],o=r[2].length):a?(n=r[3]+r[4],o=r[3].length):n=r[4],"file:"===A?o>=2&&(n=n.slice(2)):p(A)?n=r[4]:A?i&&(n=n.slice(2)):o>=2&&p(t.protocol)&&(n=r[4]),{protocol:A,slashes:i||p(A),slashesCount:o,rest:n}}function m(e,t,n){if(e=(e=u(e)).replace(s,""),!(this instanceof m))return new m(e,t,n);var i,a,o,c,d,y,w=h.slice(),v=typeof t,B=this,b=0;for("object"!==v&&"string"!==v&&(n=t,t=null),n&&"function"!=typeof n&&(n=A.parse),i=!(a=g(e||"",t=f(t))).protocol&&!a.slashes,B.slashes=a.slashes||i&&t.slashes,B.protocol=a.protocol||t.protocol||"",e=a.rest,("file:"===a.protocol&&(2!==a.slashesCount||l.test(e))||!a.slashes&&(a.protocol||a.slashesCount<2||!p(B.protocol)))&&(w[3]=[/(.*)/,"pathname"]);b<w.length;b++)"function"!=typeof(c=w[b])?(o=c[0],y=c[1],o!=o?B[y]=e:"string"==typeof o?~(d="@"===o?e.lastIndexOf(o):e.indexOf(o))&&("number"==typeof c[2]?(B[y]=e.slice(0,d),e=e.slice(d+c[2])):(B[y]=e.slice(d),e=e.slice(0,d))):(d=o.exec(e))&&(B[y]=d[1],e=e.slice(0,d.index)),B[y]=B[y]||i&&c[3]&&t[y]||"",c[4]&&(B[y]=B[y].toLowerCase())):e=c(e,B);n&&(B.query=n(B.query)),i&&t.slashes&&"/"!==B.pathname.charAt(0)&&(""!==B.pathname||""!==t.pathname)&&(B.pathname=function(e,t){if(""===e)return t;for(var n=(t||"/").split("/").slice(0,-1).concat(e.split("/")),r=n.length,A=n[r-1],i=!1,s=0;r--;)"."===n[r]?n.splice(r,1):".."===n[r]?(n.splice(r,1),s++):s&&(0===r&&(i=!0),n.splice(r,1),s--);return i&&n.unshift(""),"."!==A&&".."!==A||n.push(""),n.join("/")}(B.pathname,t.pathname)),"/"!==B.pathname.charAt(0)&&p(B.protocol)&&(B.pathname="/"+B.pathname),r(B.port,B.protocol)||(B.host=B.hostname,B.port=""),B.username=B.password="",B.auth&&(~(d=B.auth.indexOf(":"))?(B.username=B.auth.slice(0,d),B.username=encodeURIComponent(decodeURIComponent(B.username)),B.password=B.auth.slice(d+1),B.password=encodeURIComponent(decodeURIComponent(B.password))):B.username=encodeURIComponent(decodeURIComponent(B.auth)),B.auth=B.password?B.username+":"+B.password:B.username),B.origin="file:"!==B.protocol&&p(B.protocol)&&B.host?B.protocol+"//"+B.host:"null",B.href=B.toString()}m.prototype={set:function(e,t,n){var i=this;switch(e){case"query":"string"==typeof t&&t.length&&(t=(n||A.parse)(t)),i[e]=t;break;case"port":i[e]=t,r(t,i.protocol)?t&&(i.host=i.hostname+":"+t):(i.host=i.hostname,i[e]="");break;case"hostname":i[e]=t,i.port&&(t+=":"+i.port),i.host=t;break;case"host":i[e]=t,o.test(t)?(t=t.split(":"),i.port=t.pop(),i.hostname=t.join(":")):(i.hostname=t,i.port="");break;case"protocol":i.protocol=t.toLowerCase(),i.slashes=!n;break;case"pathname":case"hash":if(t){var s="pathname"===e?"/":"#";i[e]=t.charAt(0)!==s?s+t:t}else i[e]=t;break;case"username":case"password":i[e]=encodeURIComponent(t);break;case"auth":var a=t.indexOf(":");~a?(i.username=t.slice(0,a),i.username=encodeURIComponent(decodeURIComponent(i.username)),i.password=t.slice(a+1),i.password=encodeURIComponent(decodeURIComponent(i.password))):i.username=encodeURIComponent(decodeURIComponent(t))}for(var c=0;c<h.length;c++){var l=h[c];l[4]&&(i[l[1]]=i[l[1]].toLowerCase())}return i.auth=i.password?i.username+":"+i.password:i.username,i.origin="file:"!==i.protocol&&p(i.protocol)&&i.host?i.protocol+"//"+i.host:"null",i.href=i.toString(),i},toString:function(e){e&&"function"==typeof e||(e=A.stringify);var t,n=this,r=n.host,i=n.protocol;i&&":"!==i.charAt(i.length-1)&&(i+=":");var s=i+(n.protocol&&n.slashes||p(n.protocol)?"//":"");return n.username?(s+=n.username,n.password&&(s+=":"+n.password),s+="@"):n.password?(s+=":"+n.password,s+="@"):"file:"!==n.protocol&&p(n.protocol)&&!r&&"/"!==n.pathname&&(s+="@"),(":"===r[r.length-1]||o.test(n.hostname)&&!n.port)&&(r+=":"),s+=r+n.pathname,(t="object"==typeof n.query?e(n.query):n.query)&&(s+="?"!==t.charAt(0)?"?"+t:t),n.hash&&(s+=n.hash),s}},m.extractProtocol=g,m.location=f,m.trimLeft=u,m.qs=A,e.exports=m},7290:e=>{var t;self,t=function(){return(()=>{var e={"./src/drawer.canvasentry.js":(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var r=i(n("./src/util/style.js")),A=i(n("./src/util/get-id.js"));function i(e){return e&&e.__esModule?e:{default:e}}function s(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var a=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.wave=null,this.waveCtx=null,this.progress=null,this.progressCtx=null,this.start=0,this.end=1,this.id=(0,A.default)(void 0!==this.constructor.name?this.constructor.name.toLowerCase()+"_":"canvasentry_"),this.canvasContextAttributes={}}var t,n;return t=e,(n=[{key:"initWave",value:function(e){this.wave=e,this.waveCtx=this.wave.getContext("2d",this.canvasContextAttributes)}},{key:"initProgress",value:function(e){this.progress=e,this.progressCtx=this.progress.getContext("2d",this.canvasContextAttributes)}},{key:"updateDimensions",value:function(e,t,n,A){this.start=this.wave.offsetLeft/t||0,this.end=this.start+e/t,this.wave.width=n,this.wave.height=A;var i={width:e+"px"};(0,r.default)(this.wave,i),this.hasProgressCanvas&&(this.progress.width=n,this.progress.height=A,(0,r.default)(this.progress,i))}},{key:"clearWave",value:function(){this.waveCtx.clearRect(0,0,this.waveCtx.canvas.width,this.waveCtx.canvas.height),this.hasProgressCanvas&&this.progressCtx.clearRect(0,0,this.progressCtx.canvas.width,this.progressCtx.canvas.height)}},{key:"setFillStyles",value:function(e,t){this.waveCtx.fillStyle=e,this.hasProgressCanvas&&(this.progressCtx.fillStyle=t)}},{key:"applyCanvasTransforms",value:function(e){e&&(this.waveCtx.setTransform(0,1,1,0,0,0),this.hasProgressCanvas&&this.progressCtx.setTransform(0,1,1,0,0,0))}},{key:"fillRects",value:function(e,t,n,r,A){this.fillRectToContext(this.waveCtx,e,t,n,r,A),this.hasProgressCanvas&&this.fillRectToContext(this.progressCtx,e,t,n,r,A)}},{key:"fillRectToContext",value:function(e,t,n,r,A,i){e&&(i?this.drawRoundedRect(e,t,n,r,A,i):e.fillRect(t,n,r,A))}},{key:"drawRoundedRect",value:function(e,t,n,r,A,i){0!==A&&(A<0&&(n-=A*=-1),e.beginPath(),e.moveTo(t+i,n),e.lineTo(t+r-i,n),e.quadraticCurveTo(t+r,n,t+r,n+i),e.lineTo(t+r,n+A-i),e.quadraticCurveTo(t+r,n+A,t+r-i,n+A),e.lineTo(t+i,n+A),e.quadraticCurveTo(t,n+A,t,n+A-i),e.lineTo(t,n+i),e.quadraticCurveTo(t,n,t+i,n),e.closePath(),e.fill())}},{key:"drawLines",value:function(e,t,n,r,A,i){this.drawLineToContext(this.waveCtx,e,t,n,r,A,i),this.hasProgressCanvas&&this.drawLineToContext(this.progressCtx,e,t,n,r,A,i)}},{key:"drawLineToContext",value:function(e,t,n,r,A,i,s){if(e){var a,o,c,l=t.length/2,u=Math.round(l*this.start),h=u,d=Math.round(l*this.end)+1,f=this.wave.width/(d-h-1),p=r+A,g=n/r;for(e.beginPath(),e.moveTo((h-u)*f,p),e.lineTo((h-u)*f,p-Math.round((t[2*h]||0)/g)),a=h;a<d;a++)o=t[2*a]||0,c=Math.round(o/g),e.lineTo((a-u)*f+this.halfPixel,p-c);for(var m=d-1;m>=h;m--)o=t[2*m+1]||0,c=Math.round(o/g),e.lineTo((m-u)*f+this.halfPixel,p-c);e.lineTo((h-u)*f,p-Math.round((t[2*h+1]||0)/g)),e.closePath(),e.fill()}}},{key:"destroy",value:function(){this.waveCtx=null,this.wave=null,this.progressCtx=null,this.progress=null}},{key:"getImage",value:function(e,t,n){var r=this;return"blob"===n?new Promise((function(n){r.wave.toBlob(n,e,t)})):"dataURL"===n?this.wave.toDataURL(e,t):void 0}}])&&s(t.prototype,n),e}();t.default=a,e.exports=t.default},"./src/drawer.js":(e,t,n)=>{"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var A=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==r(e)&&"function"!=typeof e)return{default:e};var n=i(t);if(n&&n.has(e))return n.get(e);var A={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in e)if("default"!==a&&Object.prototype.hasOwnProperty.call(e,a)){var o=s?Object.getOwnPropertyDescriptor(e,a):null;o&&(o.get||o.set)?Object.defineProperty(A,a,o):A[a]=e[a]}return A.default=e,n&&n.set(e,A),A}(n("./src/util/index.js"));function i(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(i=function(e){return e?n:t})(e)}function s(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function a(e,t){return a=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},a(e,t)}function o(e){return o=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},o(e)}var c=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&a(e,t)}(u,e);var t,n,i,c,l=(i=u,c=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,t=o(i);if(c){var n=o(this).constructor;e=Reflect.construct(t,arguments,n)}else e=t.apply(this,arguments);return function(e,t){if(t&&("object"===r(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e)}(this,e)});function u(e,t){var n;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,u),(n=l.call(this)).container=A.withOrientation(e,t.vertical),n.params=t,n.width=0,n.height=t.height*n.params.pixelRatio,n.lastPos=0,n.wrapper=null,n}return t=u,(n=[{key:"style",value:function(e,t){return A.style(e,t)}},{key:"createWrapper",value:function(){this.wrapper=A.withOrientation(this.container.appendChild(document.createElement("wave")),this.params.vertical),this.style(this.wrapper,{display:"block",position:"relative",userSelect:"none",webkitUserSelect:"none",height:this.params.height+"px"}),(this.params.fillParent||this.params.scrollParent)&&this.style(this.wrapper,{width:"100%",overflowX:this.params.hideScrollbar?"hidden":"auto",overflowY:"hidden"}),this.setupWrapperEvents()}},{key:"handleEvent",value:function(e,t){!t&&e.preventDefault();var n,r=A.withOrientation(e.targetTouches?e.targetTouches[0]:e,this.params.vertical).clientX,i=this.wrapper.getBoundingClientRect(),s=this.width,a=this.getWidth(),o=this.getProgressPixels(i,r);return n=!this.params.fillParent&&s<a?o*(this.params.pixelRatio/s)||0:(o+this.wrapper.scrollLeft)/this.wrapper.scrollWidth||0,A.clamp(n,0,1)}},{key:"getProgressPixels",value:function(e,t){return this.params.rtl?e.right-t:t-e.left}},{key:"setupWrapperEvents",value:function(){var e=this;this.wrapper.addEventListener("click",(function(t){var n=A.withOrientation(t,e.params.vertical),r=e.wrapper.offsetHeight-e.wrapper.clientHeight;if(0!==r){var i=e.wrapper.getBoundingClientRect();if(n.clientY>=i.bottom-r)return}e.params.interact&&e.fireEvent("click",t,e.handleEvent(t))})),this.wrapper.addEventListener("dblclick",(function(t){e.params.interact&&e.fireEvent("dblclick",t,e.handleEvent(t))})),this.wrapper.addEventListener("scroll",(function(t){return e.fireEvent("scroll",t)}))}},{key:"drawPeaks",value:function(e,t,n,r){this.setWidth(t)||this.clearWave(),this.params.barWidth?this.drawBars(e,0,n,r):this.drawWave(e,0,n,r)}},{key:"resetScroll",value:function(){null!==this.wrapper&&(this.wrapper.scrollLeft=0)}},{key:"recenter",value:function(e){var t=this.wrapper.scrollWidth*e;this.recenterOnPosition(t,!0)}},{key:"recenterOnPosition",value:function(e,t){var n=this.wrapper.scrollLeft,r=~~(this.wrapper.clientWidth/2),A=this.wrapper.scrollWidth-this.wrapper.clientWidth,i=e-r,s=i-n;if(0!=A){if(!t&&-r<=s&&s<r){var a=this.params.autoCenterRate;a/=r,a*=A,i=n+(s=Math.max(-a,Math.min(a,s)))}(i=Math.max(0,Math.min(A,i)))!=n&&(this.wrapper.scrollLeft=i)}}},{key:"getScrollX",value:function(){var e=0;if(this.wrapper){var t=this.params.pixelRatio;if(e=Math.round(this.wrapper.scrollLeft*t),this.params.scrollParent){var n=~~(this.wrapper.scrollWidth*t-this.getWidth());e=Math.min(n,Math.max(0,e))}}return e}},{key:"getWidth",value:function(){return Math.round(this.container.clientWidth*this.params.pixelRatio)}},{key:"setWidth",value:function(e){if(this.width==e)return!1;if(this.width=e,this.params.fillParent||this.params.scrollParent)this.style(this.wrapper,{width:""});else{var t=~~(this.width/this.params.pixelRatio)+"px";this.style(this.wrapper,{width:t})}return this.updateSize(),!0}},{key:"setHeight",value:function(e){return e!=this.height&&(this.height=e,this.style(this.wrapper,{height:~~(this.height/this.params.pixelRatio)+"px"}),this.updateSize(),!0)}},{key:"progress",value:function(e){var t=1/this.params.pixelRatio,n=Math.round(e*this.width)*t;if(n<this.lastPos||n-this.lastPos>=t){if(this.lastPos=n,this.params.scrollParent&&this.params.autoCenter){var r=~~(this.wrapper.scrollWidth*e);this.recenterOnPosition(r,this.params.autoCenterImmediately)}this.updateProgress(n)}}},{key:"destroy",value:function(){this.unAll(),this.wrapper&&(this.wrapper.parentNode==this.container.domElement&&this.container.removeChild(this.wrapper.domElement),this.wrapper=null)}},{key:"updateCursor",value:function(){}},{key:"updateSize",value:function(){}},{key:"drawBars",value:function(e,t,n,r){}},{key:"drawWave",value:function(e,t,n,r){}},{key:"clearWave",value:function(){}},{key:"updateProgress",value:function(e){}}])&&s(t.prototype,n),u}(A.Observer);t.default=c,e.exports=t.default},"./src/drawer.multicanvas.js":(e,t,n)=>{"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var A=o(n("./src/drawer.js")),i=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==r(e)&&"function"!=typeof e)return{default:e};var n=a(t);if(n&&n.has(e))return n.get(e);var A={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in e)if("default"!==s&&Object.prototype.hasOwnProperty.call(e,s)){var o=i?Object.getOwnPropertyDescriptor(e,s):null;o&&(o.get||o.set)?Object.defineProperty(A,s,o):A[s]=e[s]}return A.default=e,n&&n.set(e,A),A}(n("./src/util/index.js")),s=o(n("./src/drawer.canvasentry.js"));function a(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(a=function(e){return e?n:t})(e)}function o(e){return e&&e.__esModule?e:{default:e}}function c(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function l(e,t){return l=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},l(e,t)}function u(e){return u=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},u(e)}var h=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&l(e,t)}(h,e);var t,n,A,a,o=(A=h,a=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,t=u(A);if(a){var n=u(this).constructor;e=Reflect.construct(t,arguments,n)}else e=t.apply(this,arguments);return function(e,t){if(t&&("object"===r(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e)}(this,e)});function h(e,t){var n;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,h),(n=o.call(this,e,t)).maxCanvasWidth=t.maxCanvasWidth,n.maxCanvasElementWidth=Math.round(t.maxCanvasWidth/t.pixelRatio),n.hasProgressCanvas=t.waveColor!=t.progressColor,n.halfPixel=.5/t.pixelRatio,n.canvases=[],n.progressWave=null,n.EntryClass=s.default,n.canvasContextAttributes=t.drawingContextAttributes,n.overlap=2*Math.ceil(t.pixelRatio/2),n.barRadius=t.barRadius||0,n.vertical=t.vertical,n}return t=h,n=[{key:"init",value:function(){this.createWrapper(),this.createElements()}},{key:"createElements",value:function(){this.progressWave=i.withOrientation(this.wrapper.appendChild(document.createElement("wave")),this.params.vertical),this.style(this.progressWave,{position:"absolute",zIndex:3,left:0,top:0,bottom:0,overflow:"hidden",width:"0",display:"none",boxSizing:"border-box",borderRightStyle:"solid",pointerEvents:"none"}),this.addCanvas(),this.updateCursor()}},{key:"updateCursor",value:function(){this.style(this.progressWave,{borderRightWidth:this.params.cursorWidth+"px",borderRightColor:this.params.cursorColor})}},{key:"updateSize",value:function(){for(var e=this,t=Math.round(this.width/this.params.pixelRatio),n=Math.ceil(t/(this.maxCanvasElementWidth+this.overlap));this.canvases.length<n;)this.addCanvas();for(;this.canvases.length>n;)this.removeCanvas();var r=this.maxCanvasWidth+this.overlap,A=this.canvases.length-1;this.canvases.forEach((function(t,n){n==A&&(r=e.width-e.maxCanvasWidth*A),e.updateDimensions(t,r,e.height),t.clearWave()}))}},{key:"addCanvas",value:function(){var e=new this.EntryClass;e.canvasContextAttributes=this.canvasContextAttributes,e.hasProgressCanvas=this.hasProgressCanvas,e.halfPixel=this.halfPixel;var t=this.maxCanvasElementWidth*this.canvases.length,n=i.withOrientation(this.wrapper.appendChild(document.createElement("canvas")),this.params.vertical);if(this.style(n,{position:"absolute",zIndex:2,left:t+"px",top:0,bottom:0,height:"100%",pointerEvents:"none"}),e.initWave(n),this.hasProgressCanvas){var r=i.withOrientation(this.progressWave.appendChild(document.createElement("canvas")),this.params.vertical);this.style(r,{position:"absolute",left:t+"px",top:0,bottom:0,height:"100%"}),e.initProgress(r)}this.canvases.push(e)}},{key:"removeCanvas",value:function(){var e=this.canvases[this.canvases.length-1];e.wave.parentElement.removeChild(e.wave.domElement),this.hasProgressCanvas&&e.progress.parentElement.removeChild(e.progress.domElement),e&&(e.destroy(),e=null),this.canvases.pop()}},{key:"updateDimensions",value:function(e,t,n){var r=Math.round(t/this.params.pixelRatio),A=Math.round(this.width/this.params.pixelRatio);e.updateDimensions(r,A,t,n),this.style(this.progressWave,{display:"block"})}},{key:"clearWave",value:function(){var e=this;i.frame((function(){e.canvases.forEach((function(e){return e.clearWave()}))}))()}},{key:"drawBars",value:function(e,t,n,r){var A=this;return this.prepareDraw(e,t,n,r,(function(e){var t=e.absmax,i=e.hasMinVals,s=(e.height,e.offsetY),a=e.halfH,o=e.peaks,c=e.channelIndex;if(void 0!==n)for(var l=i?2:1,u=o.length/l,h=A.params.barWidth*A.params.pixelRatio,d=h+(null===A.params.barGap?Math.max(A.params.pixelRatio,~~(h/2)):Math.max(A.params.pixelRatio,A.params.barGap*A.params.pixelRatio)),f=u/A.width,p=r,g=n;g<p;g+=d){var m=o[Math.floor(g*f*l)]||0,y=Math.round(m/t*a);0==y&&A.params.barMinHeight&&(y=A.params.barMinHeight),A.fillRect(g+A.halfPixel,a-y+s,h+A.halfPixel,2*y,A.barRadius,c)}}))}},{key:"drawWave",value:function(e,t,n,r){var A=this;return this.prepareDraw(e,t,n,r,(function(e){var t=e.absmax,i=e.hasMinVals,s=(e.height,e.offsetY),a=e.halfH,o=e.peaks,c=e.channelIndex;if(!i){for(var l=[],u=o.length,h=0;h<u;h++)l[2*h]=o[h],l[2*h+1]=-o[h];o=l}void 0!==n&&A.drawLine(o,t,a,s,n,r,c),A.fillRect(0,a+s-A.halfPixel,A.width,A.halfPixel,A.barRadius,c)}))}},{key:"drawLine",value:function(e,t,n,r,A,i,s){var a=this,o=this.params.splitChannelsOptions.channelColors[s]||{},c=o.waveColor,l=o.progressColor;this.canvases.forEach((function(s,o){a.setFillStyles(s,c,l),a.applyCanvasTransforms(s,a.params.vertical),s.drawLines(e,t,n,r,A,i)}))}},{key:"fillRect",value:function(e,t,n,r,A,i){for(var s=Math.floor(e/this.maxCanvasWidth),a=Math.min(Math.ceil((e+n)/this.maxCanvasWidth)+1,this.canvases.length),o=s;o<a;o++){var c=this.canvases[o],l=o*this.maxCanvasWidth,u={x1:Math.max(e,o*this.maxCanvasWidth),y1:t,x2:Math.min(e+n,o*this.maxCanvasWidth+c.wave.width),y2:t+r};if(u.x1<u.x2){var h=this.params.splitChannelsOptions.channelColors[i]||{},d=h.waveColor,f=h.progressColor;this.setFillStyles(c,d,f),this.applyCanvasTransforms(c,this.params.vertical),c.fillRects(u.x1-l,u.y1,u.x2-u.x1,u.y2-u.y1,A)}}}},{key:"hideChannel",value:function(e){return this.params.splitChannels&&this.params.splitChannelsOptions.filterChannels.includes(e)}},{key:"prepareDraw",value:function(e,t,n,r,A,s,a){var o=this;return i.frame((function(){if(e[0]instanceof Array){var c=e;if(o.params.splitChannels){var l,u=c.filter((function(e,t){return!o.hideChannel(t)}));return o.params.splitChannelsOptions.overlay||o.setHeight(Math.max(u.length,1)*o.params.height*o.params.pixelRatio),o.params.splitChannelsOptions&&o.params.splitChannelsOptions.relativeNormalization&&(l=i.max(c.map((function(e){return i.absMax(e)})))),c.forEach((function(e,t){return o.prepareDraw(e,t,n,r,A,u.indexOf(e),l)}))}e=c[0]}if(!o.hideChannel(t)){var h=1/o.params.barHeight;o.params.normalize&&(h=void 0===a?i.absMax(e):a);var d=[].some.call(e,(function(e){return e<0})),f=o.params.height*o.params.pixelRatio,p=f/2,g=f*s||0;return o.params.splitChannelsOptions&&o.params.splitChannelsOptions.overlay&&(g=0),A({absmax:h,hasMinVals:d,height:f,offsetY:g,halfH:p,peaks:e,channelIndex:t})}}))()}},{key:"setFillStyles",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.params.waveColor,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this.params.progressColor;e.setFillStyles(t,n)}},{key:"applyCanvasTransforms",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];e.applyCanvasTransforms(t)}},{key:"getImage",value:function(e,t,n){if("blob"===n)return Promise.all(this.canvases.map((function(r){return r.getImage(e,t,n)})));if("dataURL"===n){var r=this.canvases.map((function(r){return r.getImage(e,t,n)}));return r.length>1?r:r[0]}}},{key:"updateProgress",value:function(e){this.style(this.progressWave,{width:e+"px"})}}],n&&c(t.prototype,n),h}(A.default);t.default=h,e.exports=t.default},"./src/mediaelement-webaudio.js":(e,t,n)=>{"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}var A;function i(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function s(e,t,n){return s="undefined"!=typeof Reflect&&Reflect.get?Reflect.get:function(e,t,n){var r=function(e,t){for(;!Object.prototype.hasOwnProperty.call(e,t)&&null!==(e=o(e)););return e}(e,t);if(r){var A=Object.getOwnPropertyDescriptor(r,t);return A.get?A.get.call(n):A.value}},s(e,t,n||e)}function a(e,t){return a=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},a(e,t)}function o(e){return o=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},o(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var c=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&a(e,t)}(u,e);var t,n,A,c,l=(A=u,c=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,t=o(A);if(c){var n=o(this).constructor;e=Reflect.construct(t,arguments,n)}else e=t.apply(this,arguments);return function(e,t){if(t&&("object"===r(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e)}(this,e)});function u(e){var t;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,u),(t=l.call(this,e)).params=e,t.sourceMediaElement=null,t}return t=u,(n=[{key:"init",value:function(){this.setPlaybackRate(this.params.audioRate),this.createTimer(),this.createVolumeNode(),this.createScriptNode(),this.createAnalyserNode()}},{key:"_load",value:function(e,t,n){s(o(u.prototype),"_load",this).call(this,e,t,n),this.createMediaElementSource(e)}},{key:"createMediaElementSource",value:function(e){this.sourceMediaElement=this.ac.createMediaElementSource(e),this.sourceMediaElement.connect(this.analyser)}},{key:"play",value:function(e,t){return this.resumeAudioContext(),s(o(u.prototype),"play",this).call(this,e,t)}},{key:"destroy",value:function(){s(o(u.prototype),"destroy",this).call(this),this.destroyWebAudio()}}])&&i(t.prototype,n),u}(((A=n("./src/mediaelement.js"))&&A.__esModule?A:{default:A}).default);t.default=c,e.exports=t.default},"./src/mediaelement.js":(e,t,n)=>{"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var A,i=(A=n("./src/webaudio.js"))&&A.__esModule?A:{default:A},s=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==r(e)&&"function"!=typeof e)return{default:e};var n=a(t);if(n&&n.has(e))return n.get(e);var A={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in e)if("default"!==s&&Object.prototype.hasOwnProperty.call(e,s)){var o=i?Object.getOwnPropertyDescriptor(e,s):null;o&&(o.get||o.set)?Object.defineProperty(A,s,o):A[s]=e[s]}return A.default=e,n&&n.set(e,A),A}(n("./src/util/index.js"));function a(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(a=function(e){return e?n:t})(e)}function o(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function c(e,t,n){return c="undefined"!=typeof Reflect&&Reflect.get?Reflect.get:function(e,t,n){var r=function(e,t){for(;!Object.prototype.hasOwnProperty.call(e,t)&&null!==(e=u(e)););return e}(e,t);if(r){var A=Object.getOwnPropertyDescriptor(r,t);return A.get?A.get.call(n):A.value}},c(e,t,n||e)}function l(e,t){return l=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},l(e,t)}function u(e){return u=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},u(e)}var h=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&l(e,t)}(h,e);var t,n,A,i,a=(A=h,i=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,t=u(A);if(i){var n=u(this).constructor;e=Reflect.construct(t,arguments,n)}else e=t.apply(this,arguments);return function(e,t){if(t&&("object"===r(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e)}(this,e)});function h(e){var t;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,h),(t=a.call(this,e)).params=e,t.media={currentTime:0,duration:0,paused:!0,playbackRate:1,play:function(){},pause:function(){},volume:0},t.mediaType=e.mediaType.toLowerCase(),t.elementPosition=e.elementPosition,t.peaks=null,t.playbackRate=1,t.volume=1,t.isMuted=!1,t.buffer=null,t.onPlayEnd=null,t.mediaListeners={},t}return t=h,(n=[{key:"init",value:function(){this.setPlaybackRate(this.params.audioRate),this.createTimer()}},{key:"_setupMediaListeners",value:function(){var e=this;this.mediaListeners.error=function(){e.fireEvent("error","Error loading media element")},this.mediaListeners.canplay=function(){e.fireEvent("canplay")},this.mediaListeners.ended=function(){e.fireEvent("finish")},this.mediaListeners.play=function(){e.fireEvent("play")},this.mediaListeners.pause=function(){e.fireEvent("pause")},this.mediaListeners.seeked=function(t){e.fireEvent("seek")},this.mediaListeners.volumechange=function(t){e.isMuted=e.media.muted,e.isMuted?e.volume=0:e.volume=e.media.volume,e.fireEvent("volume")},Object.keys(this.mediaListeners).forEach((function(t){e.media.removeEventListener(t,e.mediaListeners[t]),e.media.addEventListener(t,e.mediaListeners[t])}))}},{key:"createTimer",value:function(){var e=this;this.on("play",(function t(){e.isPaused()||(e.fireEvent("audioprocess",e.getCurrentTime()),s.frame(t)())})),this.on("pause",(function(){e.fireEvent("audioprocess",e.getCurrentTime())}))}},{key:"load",value:function(e,t,n,r){var A=document.createElement(this.mediaType);A.controls=this.params.mediaControls,A.autoplay=this.params.autoplay||!1,A.preload=null==r?"auto":r,A.src=e,A.style.width="100%";var i=t.querySelector(this.mediaType);i&&t.removeChild(i),t.appendChild(A),this._load(A,n,r)}},{key:"loadElt",value:function(e,t){e.controls=this.params.mediaControls,e.autoplay=this.params.autoplay||!1,this._load(e,t,e.preload)}},{key:"_load",value:function(e,t,n){if(!(e instanceof HTMLMediaElement)||void 0===e.addEventListener)throw new Error("media parameter is not a valid media element");"function"!=typeof e.load||t&&"none"==n||e.load(),this.media=e,this._setupMediaListeners(),this.peaks=t,this.onPlayEnd=null,this.buffer=null,this.isMuted=e.muted,this.setPlaybackRate(this.playbackRate),this.setVolume(this.volume)}},{key:"isPaused",value:function(){return!this.media||this.media.paused}},{key:"getDuration",value:function(){if(this.explicitDuration)return this.explicitDuration;var e=(this.buffer||this.media).duration;return e>=1/0&&(e=this.media.seekable.end(0)),e}},{key:"getCurrentTime",value:function(){return this.media&&this.media.currentTime}},{key:"getPlayedPercents",value:function(){return this.getCurrentTime()/this.getDuration()||0}},{key:"getPlaybackRate",value:function(){return this.playbackRate||this.media.playbackRate}},{key:"setPlaybackRate",value:function(e){this.playbackRate=e||1,this.media.playbackRate=this.playbackRate}},{key:"seekTo",value:function(e){null!=e&&(this.media.currentTime=e),this.clearPlayEnd()}},{key:"play",value:function(e,t){this.seekTo(e);var n=this.media.play();return t&&this.setPlayEnd(t),n}},{key:"pause",value:function(){var e;return this.media&&(e=this.media.pause()),this.clearPlayEnd(),e}},{key:"setPlayEnd",value:function(e){var t=this;this.clearPlayEnd(),this._onPlayEnd=function(n){n>=e&&(t.pause(),t.seekTo(e))},this.on("audioprocess",this._onPlayEnd)}},{key:"clearPlayEnd",value:function(){this._onPlayEnd&&(this.un("audioprocess",this._onPlayEnd),this._onPlayEnd=null)}},{key:"getPeaks",value:function(e,t,n){return this.buffer?c(u(h.prototype),"getPeaks",this).call(this,e,t,n):this.peaks||[]}},{key:"setSinkId",value:function(e){return e?this.media.setSinkId?this.media.setSinkId(e):Promise.reject(new Error("setSinkId is not supported in your browser")):Promise.reject(new Error("Invalid deviceId: "+e))}},{key:"getVolume",value:function(){return this.volume}},{key:"setVolume",value:function(e){this.volume=e,this.media.volume!==this.volume&&(this.media.volume=this.volume)}},{key:"setMute",value:function(e){this.isMuted=this.media.muted=e}},{key:"destroy",value:function(){var e=this;this.pause(),this.unAll(),this.destroyed=!0,Object.keys(this.mediaListeners).forEach((function(t){e.media&&e.media.removeEventListener(t,e.mediaListeners[t])})),this.params.removeMediaElementOnDestroy&&this.media&&this.media.parentNode&&this.media.parentNode.removeChild(this.media),this.media=null}}])&&o(t.prototype,n),h}(i.default);t.default=h,e.exports=t.default},"./src/peakcache.js":(e,t)=>{"use strict";function n(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var r=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.clearPeakCache()}var t,r;return t=e,(r=[{key:"clearPeakCache",value:function(){this.peakCacheRanges=[],this.peakCacheLength=-1}},{key:"addRangeToPeakCache",value:function(e,t,n){e!=this.peakCacheLength&&(this.clearPeakCache(),this.peakCacheLength=e);for(var r=[],A=0;A<this.peakCacheRanges.length&&this.peakCacheRanges[A]<t;)A++;for(A%2==0&&r.push(t);A<this.peakCacheRanges.length&&this.peakCacheRanges[A]<=n;)r.push(this.peakCacheRanges[A]),A++;A%2==0&&r.push(n),r=r.filter((function(e,t,n){return 0==t?e!=n[t+1]:t==n.length-1?e!=n[t-1]:e!=n[t-1]&&e!=n[t+1]})),this.peakCacheRanges=this.peakCacheRanges.concat(r),this.peakCacheRanges=this.peakCacheRanges.sort((function(e,t){return e-t})).filter((function(e,t,n){return 0==t?e!=n[t+1]:t==n.length-1?e!=n[t-1]:e!=n[t-1]&&e!=n[t+1]}));var i=[];for(A=0;A<r.length;A+=2)i.push([r[A],r[A+1]]);return i}},{key:"getCacheRanges",value:function(){var e,t=[];for(e=0;e<this.peakCacheRanges.length;e+=2)t.push([this.peakCacheRanges[e],this.peakCacheRanges[e+1]]);return t}}])&&n(t.prototype,r),e}();t.default=r,e.exports=t.default},"./src/util/absMax.js":(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var t=(0,r.default)(e),n=(0,A.default)(e);return-n>t?-n:t};var r=i(n("./src/util/max.js")),A=i(n("./src/util/min.js"));function i(e){return e&&e.__esModule?e:{default:e}}e.exports=t.default},"./src/util/clamp.js":(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e,t,n){return Math.min(Math.max(t,e),n)},e.exports=t.default},"./src/util/fetch.js":(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){if(!e)throw new Error("fetch options missing");if(!e.url)throw new Error("fetch url missing");var t=new A.default,n=new Headers,r=new Request(e.url);t.controller=new AbortController,e&&e.requestHeaders&&e.requestHeaders.forEach((function(e){n.append(e.key,e.value)}));var i=e.responseType||"json",a={method:e.method||"GET",headers:n,mode:e.mode||"cors",credentials:e.credentials||"same-origin",cache:e.cache||"default",redirect:e.redirect||"follow",referrer:e.referrer||"client",signal:t.controller.signal};return fetch(r,a).then((function(e){t.response=e;var n=!0;e.body||(n=!1);var r=e.headers.get("content-length");return null===r&&(n=!1),n?(t.onProgress=function(e){t.fireEvent("progress",e)},new Response(new ReadableStream(new s(t,r,e)),a)):e})).then((function(e){var t;if(e.ok)switch(i){case"arraybuffer":return e.arrayBuffer();case"json":return e.json();case"blob":return e.blob();case"text":return e.text();default:t="Unknown responseType: "+i}throw t||(t="HTTP error status: "+e.status),new Error(t)})).then((function(e){t.fireEvent("success",e)})).catch((function(e){t.fireEvent("error",e)})),t.fetchRequest=r,t};var r,A=(r=n("./src/util/observer.js"))&&r.__esModule?r:{default:r};function i(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var s=function(){function e(t,n,r){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.instance=t,this.instance._reader=r.body.getReader(),this.total=parseInt(n,10),this.loaded=0}var t,n;return t=e,(n=[{key:"start",value:function(e){var t=this;!function n(){t.instance._reader.read().then((function(r){var A=r.done,i=r.value;if(A)return 0===t.total&&t.instance.onProgress.call(t.instance,{loaded:t.loaded,total:t.total,lengthComputable:!1}),void e.close();t.loaded+=i.byteLength,t.instance.onProgress.call(t.instance,{loaded:t.loaded,total:t.total,lengthComputable:!(0===t.total)}),e.enqueue(i),n()})).catch((function(t){e.error(t)}))}()}}])&&i(t.prototype,n),e}();e.exports=t.default},"./src/util/frame.js":(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){return function(){for(var t=arguments.length,n=new Array(t),r=0;r<t;r++)n[r]=arguments[r];return(0,A.default)((function(){return e.apply(void 0,n)}))}};var r,A=(r=n("./src/util/request-animation-frame.js"))&&r.__esModule?r:{default:r};e.exports=t.default},"./src/util/get-id.js":(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){return void 0===e&&(e="wavesurfer_"),e+Math.random().toString(32).substring(2)},e.exports=t.default},"./src/util/index.js":(e,t,n)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"getId",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(t,"max",{enumerable:!0,get:function(){return A.default}}),Object.defineProperty(t,"min",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(t,"absMax",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(t,"Observer",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(t,"style",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(t,"requestAnimationFrame",{enumerable:!0,get:function(){return c.default}}),Object.defineProperty(t,"frame",{enumerable:!0,get:function(){return l.default}}),Object.defineProperty(t,"debounce",{enumerable:!0,get:function(){return u.default}}),Object.defineProperty(t,"preventClick",{enumerable:!0,get:function(){return h.default}}),Object.defineProperty(t,"fetchFile",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(t,"clamp",{enumerable:!0,get:function(){return f.default}}),Object.defineProperty(t,"withOrientation",{enumerable:!0,get:function(){return p.default}}),Object.defineProperty(t,"ignoreSilenceMode",{enumerable:!0,get:function(){return g.default}});var r=m(n("./src/util/get-id.js")),A=m(n("./src/util/max.js")),i=m(n("./src/util/min.js")),s=m(n("./src/util/absMax.js")),a=m(n("./src/util/observer.js")),o=m(n("./src/util/style.js")),c=m(n("./src/util/request-animation-frame.js")),l=m(n("./src/util/frame.js")),u=m(n("./node_modules/debounce/index.js")),h=m(n("./src/util/prevent-click.js")),d=m(n("./src/util/fetch.js")),f=m(n("./src/util/clamp.js")),p=m(n("./src/util/orientation.js")),g=m(n("./src/util/silence-mode.js"));function m(e){return e&&e.__esModule?e:{default:e}}},"./src/util/max.js":(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var t=-1/0;return Object.keys(e).forEach((function(n){e[n]>t&&(t=e[n])})),t},e.exports=t.default},"./src/util/min.js":(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var t=Number(1/0);return Object.keys(e).forEach((function(n){e[n]<t&&(t=e[n])})),t},e.exports=t.default},"./src/util/observer.js":(e,t)=>{"use strict";function n(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var r=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this._disabledEventEmissions=[],this.handlers=null}var t,r;return t=e,r=[{key:"on",value:function(e,t){var n=this;this.handlers||(this.handlers={});var r=this.handlers[e];return r||(r=this.handlers[e]=[]),r.push(t),{name:e,callback:t,un:function(e,t){return n.un(e,t)}}}},{key:"un",value:function(e,t){if(this.handlers){var n,r=this.handlers[e];if(r)if(t)for(n=r.length-1;n>=0;n--)r[n]==t&&r.splice(n,1);else r.length=0}}},{key:"unAll",value:function(){this.handlers=null}},{key:"once",value:function(e,t){var n=this;return this.on(e,(function r(){for(var A=arguments.length,i=new Array(A),s=0;s<A;s++)i[s]=arguments[s];t.apply(n,i),setTimeout((function(){n.un(e,r)}),0)}))}},{key:"setDisabledEventEmissions",value:function(e){this._disabledEventEmissions=e}},{key:"_isDisabledEventEmission",value:function(e){return this._disabledEventEmissions&&this._disabledEventEmissions.includes(e)}},{key:"fireEvent",value:function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];if(this.handlers&&!this._isDisabledEventEmission(e)){var A=this.handlers[e];A&&A.forEach((function(e){e.apply(void 0,n)}))}}}],r&&n(t.prototype,r),e}();t.default=r,e.exports=t.default},"./src/util/orientation.js":(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function e(t,n){return t[A]?t:new Proxy(t,{get:function(t,i,s){if(i===A)return!0;if("domElement"===i)return t;if("style"===i)return e(t.style,n);if("canvas"===i)return e(t.canvas,n);if("getBoundingClientRect"===i)return function(){return e(t.getBoundingClientRect.apply(t,arguments),n)};if("getContext"===i)return function(){return e(t.getContext.apply(t,arguments),n)};var a=t[r(i,n)];return"function"==typeof a?a.bind(t):a},set:function(e,t,A){return e[r(t,n)]=A,!0}})};var n={width:"height",height:"width",overflowX:"overflowY",overflowY:"overflowX",clientWidth:"clientHeight",clientHeight:"clientWidth",clientX:"clientY",clientY:"clientX",scrollWidth:"scrollHeight",scrollLeft:"scrollTop",offsetLeft:"offsetTop",offsetTop:"offsetLeft",offsetHeight:"offsetWidth",offsetWidth:"offsetHeight",left:"top",right:"bottom",top:"left",bottom:"right",borderRightStyle:"borderBottomStyle",borderRightWidth:"borderBottomWidth",borderRightColor:"borderBottomColor"};function r(e,t){return Object.prototype.hasOwnProperty.call(n,e)&&t?n[e]:e}var A=Symbol("isProxy");e.exports=t.default},"./src/util/prevent-click.js":(e,t)=>{"use strict";function n(e){e.stopPropagation(),document.body.removeEventListener("click",n,!0)}Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){document.body.addEventListener("click",n,!0)},e.exports=t.default},"./src/util/request-animation-frame.js":(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var n=(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(e,t){return setTimeout(e,1e3/60)}).bind(window);t.default=n,e.exports=t.default},"./src/util/silence-mode.js":(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(){var e=document.createElement("div");e.innerHTML='<audio x-webkit-airplay="deny"></audio>';var t=e.children.item(0);t.src="data:audio/mpeg;base64,//uQxAAAAAAAAAAAAAAAAAAAAAAAWGluZwAAAA8AAAACAAACcQCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA//////////////////////////////////////////////////////////////////8AAABhTEFNRTMuMTAwA8MAAAAAAAAAABQgJAUHQQAB9AAAAnGMHkkIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//sQxAADgnABGiAAQBCqgCRMAAgEAH///////////////7+n/9FTuQsQH//////2NG0jWUGlio5gLQTOtIoeR2WX////X4s9Atb/JRVCbBUpeRUq//////////////////9RUi0f2jn/+xDECgPCjAEQAABN4AAANIAAAAQVTEFNRTMuMTAwVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVQ==",t.preload="auto",t.type="audio/mpeg",t.disableRemotePlayback=!0,t.play(),t.remove(),e.remove()},e.exports=t.default},"./src/util/style.js":(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e,t){return Object.keys(t).forEach((function(n){e.style[n]!==t[n]&&(e.style[n]=t[n])})),e},e.exports=t.default},"./src/wavesurfer.js":(e,t,n)=>{"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var A=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==r(e)&&"function"!=typeof e)return{default:e};var n=u(t);if(n&&n.has(e))return n.get(e);var A={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in e)if("default"!==s&&Object.prototype.hasOwnProperty.call(e,s)){var a=i?Object.getOwnPropertyDescriptor(e,s):null;a&&(a.get||a.set)?Object.defineProperty(A,s,a):A[s]=e[s]}return A.default=e,n&&n.set(e,A),A}(n("./src/util/index.js")),i=l(n("./src/drawer.multicanvas.js")),s=l(n("./src/webaudio.js")),a=l(n("./src/mediaelement.js")),o=l(n("./src/peakcache.js")),c=l(n("./src/mediaelement-webaudio.js"));function l(e){return e&&e.__esModule?e:{default:e}}function u(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(u=function(e){return e?n:t})(e)}function h(e,t){return h=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},h(e,t)}function d(e,t){if(t&&("object"===r(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return f(e)}function f(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function p(e){return p=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},p(e)}function g(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var m=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&h(e,t)}(y,e);var t,n,r,l,u,m=(t=y,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=p(t);if(n){var A=p(this).constructor;e=Reflect.construct(r,arguments,A)}else e=r.apply(this,arguments);return d(this,e)});function y(e){var t;if(function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,y),(t=m.call(this)).defaultParams={audioContext:null,audioScriptProcessor:null,audioRate:1,autoCenter:!0,autoCenterRate:5,autoCenterImmediately:!1,backend:"WebAudio",backgroundColor:null,barHeight:1,barRadius:0,barGap:null,barMinHeight:null,container:null,cursorColor:"#333",cursorWidth:1,dragSelection:!0,drawingContextAttributes:{desynchronized:!1},duration:null,fillParent:!0,forceDecode:!1,height:128,hideScrollbar:!1,ignoreSilenceMode:!1,interact:!0,loopSelection:!0,maxCanvasWidth:4e3,mediaContainer:null,mediaControls:!1,mediaType:"audio",minPxPerSec:20,normalize:!1,partialRender:!1,pixelRatio:window.devicePixelRatio||screen.deviceXDPI/screen.logicalXDPI,plugins:[],progressColor:"#555",removeMediaElementOnDestroy:!0,renderer:i.default,responsive:!1,rtl:!1,scrollParent:!1,skipLength:2,splitChannels:!1,splitChannelsOptions:{overlay:!1,channelColors:{},filterChannels:[],relativeNormalization:!1},vertical:!1,waveColor:"#999",xhr:{}},t.backends={MediaElement:a.default,WebAudio:s.default,MediaElementWebAudio:c.default},t.util=A,t.params=Object.assign({},t.defaultParams,e),t.params.splitChannelsOptions=Object.assign({},t.defaultParams.splitChannelsOptions,e.splitChannelsOptions),t.container="string"==typeof e.container?document.querySelector(t.params.container):t.params.container,!t.container)throw new Error("Container element not found");if(null==t.params.mediaContainer?t.mediaContainer=t.container:"string"==typeof t.params.mediaContainer?t.mediaContainer=document.querySelector(t.params.mediaContainer):t.mediaContainer=t.params.mediaContainer,!t.mediaContainer)throw new Error("Media Container element not found");if(t.params.maxCanvasWidth<=1)throw new Error("maxCanvasWidth must be greater than 1");if(t.params.maxCanvasWidth%2==1)throw new Error("maxCanvasWidth must be an even number");if(!0===t.params.rtl&&(!0===t.params.vertical?A.style(t.container,{transform:"rotateX(180deg)"}):A.style(t.container,{transform:"rotateY(180deg)"})),t.params.backgroundColor&&t.setBackgroundColor(t.params.backgroundColor),t.savedVolume=0,t.isMuted=!1,t.tmpEvents=[],t.currentRequest=null,t.arraybuffer=null,t.drawer=null,t.backend=null,t.peakCache=null,"function"!=typeof t.params.renderer)throw new Error("Renderer parameter is invalid");t.Drawer=t.params.renderer,"AudioElement"==t.params.backend&&(t.params.backend="MediaElement"),"WebAudio"!=t.params.backend&&"MediaElementWebAudio"!==t.params.backend||s.default.prototype.supportsWebAudio.call(null)||(t.params.backend="MediaElement"),t.Backend=t.backends[t.params.backend],t.initialisedPluginList={},t.isDestroyed=!1,t.isReady=!1;var n=0;return t._onResize=A.debounce((function(){n==t.drawer.wrapper.clientWidth||t.params.scrollParent||(n=t.drawer.wrapper.clientWidth,t.drawer.fireEvent("redraw"))}),"number"==typeof t.params.responsive?t.params.responsive:100),d(t,f(t))}return r=y,u=[{key:"create",value:function(e){return new y(e).init()}}],(l=[{key:"init",value:function(){return this.registerPlugins(this.params.plugins),this.createDrawer(),this.createBackend(),this.createPeakCache(),this}},{key:"registerPlugins",value:function(e){var t=this;return e.forEach((function(e){return t.addPlugin(e)})),e.forEach((function(e){e.deferInit||t.initPlugin(e.name)})),this.fireEvent("plugins-registered",e),this}},{key:"getActivePlugins",value:function(){return this.initialisedPluginList}},{key:"addPlugin",value:function(e){var t=this;if(!e.name)throw new Error("Plugin does not have a name!");if(!e.instance)throw new Error("Plugin ".concat(e.name," does not have an instance property!"));e.staticProps&&Object.keys(e.staticProps).forEach((function(n){t[n]=e.staticProps[n]}));var n=e.instance;return Object.getOwnPropertyNames(A.Observer.prototype).forEach((function(e){n.prototype[e]=A.Observer.prototype[e]})),this[e.name]=new n(e.params||{},this),this.fireEvent("plugin-added",e.name),this}},{key:"initPlugin",value:function(e){if(!this[e])throw new Error("Plugin ".concat(e," has not been added yet!"));return this.initialisedPluginList[e]&&this.destroyPlugin(e),this[e].init(),this.initialisedPluginList[e]=!0,this.fireEvent("plugin-initialised",e),this}},{key:"destroyPlugin",value:function(e){if(!this[e])throw new Error("Plugin ".concat(e," has not been added yet and cannot be destroyed!"));if(!this.initialisedPluginList[e])throw new Error("Plugin ".concat(e," is not active and cannot be destroyed!"));if("function"!=typeof this[e].destroy)throw new Error("Plugin ".concat(e," does not have a destroy function!"));return this[e].destroy(),delete this.initialisedPluginList[e],this.fireEvent("plugin-destroyed",e),this}},{key:"destroyAllPlugins",value:function(){var e=this;Object.keys(this.initialisedPluginList).forEach((function(t){return e.destroyPlugin(t)}))}},{key:"createDrawer",value:function(){var e=this;this.drawer=new this.Drawer(this.container,this.params),this.drawer.init(),this.fireEvent("drawer-created",this.drawer),!1!==this.params.responsive&&(window.addEventListener("resize",this._onResize,!0),window.addEventListener("orientationchange",this._onResize,!0)),this.drawer.on("redraw",(function(){e.drawBuffer(),e.drawer.progress(e.backend.getPlayedPercents())})),this.drawer.on("click",(function(t,n){setTimeout((function(){return e.seekTo(n)}),0)})),this.drawer.on("scroll",(function(t){e.params.partialRender&&e.drawBuffer(),e.fireEvent("scroll",t)}))}},{key:"createBackend",value:function(){var e=this;this.backend&&this.backend.destroy(),this.backend=new this.Backend(this.params),this.backend.init(),this.fireEvent("backend-created",this.backend),this.backend.on("finish",(function(){e.drawer.progress(e.backend.getPlayedPercents()),e.fireEvent("finish")})),this.backend.on("play",(function(){return e.fireEvent("play")})),this.backend.on("pause",(function(){return e.fireEvent("pause")})),this.backend.on("audioprocess",(function(t){e.drawer.progress(e.backend.getPlayedPercents()),e.fireEvent("audioprocess",t)})),"MediaElement"!==this.params.backend&&"MediaElementWebAudio"!==this.params.backend||(this.backend.on("seek",(function(){e.drawer.progress(e.backend.getPlayedPercents())})),this.backend.on("volume",(function(){var t=e.getVolume();e.fireEvent("volume",t),e.backend.isMuted!==e.isMuted&&(e.isMuted=e.backend.isMuted,e.fireEvent("mute",e.isMuted))})))}},{key:"createPeakCache",value:function(){this.params.partialRender&&(this.peakCache=new o.default)}},{key:"getDuration",value:function(){return this.backend.getDuration()}},{key:"getCurrentTime",value:function(){return this.backend.getCurrentTime()}},{key:"setCurrentTime",value:function(e){e>=this.getDuration()?this.seekTo(1):this.seekTo(e/this.getDuration())}},{key:"play",value:function(e,t){var n=this;return this.params.ignoreSilenceMode&&A.ignoreSilenceMode(),this.fireEvent("interaction",(function(){return n.play(e,t)})),this.backend.play(e,t)}},{key:"setPlayEnd",value:function(e){this.backend.setPlayEnd(e)}},{key:"pause",value:function(){if(!this.backend.isPaused())return this.backend.pause()}},{key:"playPause",value:function(){return this.backend.isPaused()?this.play():this.pause()}},{key:"isPlaying",value:function(){return!this.backend.isPaused()}},{key:"skipBackward",value:function(e){this.skip(-e||-this.params.skipLength)}},{key:"skipForward",value:function(e){this.skip(e||this.params.skipLength)}},{key:"skip",value:function(e){var t=this.getDuration()||1,n=this.getCurrentTime()||0;n=Math.max(0,Math.min(t,n+(e||0))),this.seekAndCenter(n/t)}},{key:"seekAndCenter",value:function(e){this.seekTo(e),this.drawer.recenter(e)}},{key:"seekTo",value:function(e){var t=this;if("number"!=typeof e||!isFinite(e)||e<0||e>1)throw new Error("Error calling wavesurfer.seekTo, parameter must be a number between 0 and 1!");this.fireEvent("interaction",(function(){return t.seekTo(e)}));var n="WebAudio"===this.params.backend,r=this.backend.isPaused();n&&!r&&this.backend.pause();var A=this.params.scrollParent;this.params.scrollParent=!1,this.backend.seekTo(e*this.getDuration()),this.drawer.progress(e),n&&!r&&this.backend.play(),this.params.scrollParent=A,this.fireEvent("seek",e)}},{key:"stop",value:function(){this.pause(),this.seekTo(0),this.drawer.progress(0)}},{key:"setSinkId",value:function(e){return this.backend.setSinkId(e)}},{key:"setVolume",value:function(e){this.backend.setVolume(e),this.fireEvent("volume",e)}},{key:"getVolume",value:function(){return this.backend.getVolume()}},{key:"setPlaybackRate",value:function(e){this.backend.setPlaybackRate(e)}},{key:"getPlaybackRate",value:function(){return this.backend.getPlaybackRate()}},{key:"toggleMute",value:function(){this.setMute(!this.isMuted)}},{key:"setMute",value:function(e){e!==this.isMuted?(this.backend.setMute?(this.backend.setMute(e),this.isMuted=e):e?(this.savedVolume=this.backend.getVolume(),this.backend.setVolume(0),this.isMuted=!0,this.fireEvent("volume",0)):(this.backend.setVolume(this.savedVolume),this.isMuted=!1,this.fireEvent("volume",this.savedVolume)),this.fireEvent("mute",this.isMuted)):this.fireEvent("mute",this.isMuted)}},{key:"getMute",value:function(){return this.isMuted}},{key:"getFilters",value:function(){return this.backend.filters||[]}},{key:"toggleScroll",value:function(){this.params.scrollParent=!this.params.scrollParent,this.drawBuffer()}},{key:"toggleInteraction",value:function(){this.params.interact=!this.params.interact}},{key:"getWaveColor",value:function(){return this.params.waveColor}},{key:"setWaveColor",value:function(e){this.params.waveColor=e,this.drawBuffer()}},{key:"getProgressColor",value:function(){return this.params.progressColor}},{key:"setProgressColor",value:function(e){this.params.progressColor=e,this.drawBuffer()}},{key:"getBackgroundColor",value:function(){return this.params.backgroundColor}},{key:"setBackgroundColor",value:function(e){this.params.backgroundColor=e,A.style(this.container,{background:this.params.backgroundColor})}},{key:"getCursorColor",value:function(){return this.params.cursorColor}},{key:"setCursorColor",value:function(e){this.params.cursorColor=e,this.drawer.updateCursor()}},{key:"getHeight",value:function(){return this.params.height}},{key:"setHeight",value:function(e){this.params.height=e,this.drawer.setHeight(e*this.params.pixelRatio),this.drawBuffer()}},{key:"setFilteredChannels",value:function(e){this.params.splitChannelsOptions.filterChannels=e,this.drawBuffer()}},{key:"drawBuffer",value:function(){var e,t=Math.round(this.getDuration()*this.params.minPxPerSec*this.params.pixelRatio),n=this.drawer.getWidth(),r=t,A=0,i=Math.max(A+n,r);if(this.params.fillParent&&(!this.params.scrollParent||t<n)&&(A=0,i=r=n),this.params.partialRender){var s,a=this.peakCache.addRangeToPeakCache(r,A,i);for(s=0;s<a.length;s++)e=this.backend.getPeaks(r,a[s][0],a[s][1]),this.drawer.drawPeaks(e,r,a[s][0],a[s][1])}else e=this.backend.getPeaks(r,A,i),this.drawer.drawPeaks(e,r,A,i);this.fireEvent("redraw",e,r)}},{key:"zoom",value:function(e){e?(this.params.minPxPerSec=e,this.params.scrollParent=!0):(this.params.minPxPerSec=this.defaultParams.minPxPerSec,this.params.scrollParent=!1),this.drawBuffer(),this.drawer.progress(this.backend.getPlayedPercents()),this.drawer.recenter(this.getCurrentTime()/this.getDuration()),this.fireEvent("zoom",e)}},{key:"loadArrayBuffer",value:function(e){var t=this;this.decodeArrayBuffer(e,(function(e){t.isDestroyed||t.loadDecodedBuffer(e)}))}},{key:"loadDecodedBuffer",value:function(e){this.backend.load(e),this.drawBuffer(),this.isReady=!0,this.fireEvent("ready")}},{key:"loadBlob",value:function(e){var t=this,n=new FileReader;n.addEventListener("progress",(function(e){return t.onProgress(e)})),n.addEventListener("load",(function(e){return t.loadArrayBuffer(e.target.result)})),n.addEventListener("error",(function(){return t.fireEvent("error","Error reading file")})),n.readAsArrayBuffer(e),this.empty()}},{key:"load",value:function(e,t,n,r){if(!e)throw new Error("url parameter cannot be empty");if(this.empty(),n){var A={"Preload is not 'auto', 'none' or 'metadata'":-1===["auto","metadata","none"].indexOf(n),"Peaks are not provided":!t,"Backend is not of type 'MediaElement' or 'MediaElementWebAudio'":-1===["MediaElement","MediaElementWebAudio"].indexOf(this.params.backend),"Url is not of type string":"string"!=typeof e},i=Object.keys(A).filter((function(e){return A[e]}));i.length&&(console.warn("Preload parameter of wavesurfer.load will be ignored because:\n\t- "+i.join("\n\t- ")),n=null)}switch("WebAudio"===this.params.backend&&e instanceof HTMLMediaElement&&(e=e.src),this.params.backend){case"WebAudio":return this.loadBuffer(e,t,r);case"MediaElement":case"MediaElementWebAudio":return this.loadMediaElement(e,t,n,r)}}},{key:"loadBuffer",value:function(e,t,n){var r=this,A=function(t){return t&&r.tmpEvents.push(r.once("ready",t)),r.getArrayBuffer(e,(function(e){return r.loadArrayBuffer(e)}))};if(!t)return A();this.backend.setPeaks(t,n),this.drawBuffer(),this.fireEvent("waveform-ready"),this.tmpEvents.push(this.once("interaction",A))}},{key:"loadMediaElement",value:function(e,t,n,r){var A=this,i=e;if("string"==typeof e)this.backend.load(i,this.mediaContainer,t,n);else{var s=e;this.backend.loadElt(s,t),i=s.src}this.tmpEvents.push(this.backend.once("canplay",(function(){A.backend.destroyed||(A.drawBuffer(),A.isReady=!0,A.fireEvent("ready"))})),this.backend.once("error",(function(e){return A.fireEvent("error",e)}))),t&&(this.backend.setPeaks(t,r),this.drawBuffer(),this.fireEvent("waveform-ready")),t&&!this.params.forceDecode||!this.backend.supportsWebAudio()||this.getArrayBuffer(i,(function(e){A.decodeArrayBuffer(e,(function(e){A.backend.buffer=e,A.backend.setPeaks(null),A.drawBuffer(),A.fireEvent("waveform-ready")}))}))}},{key:"decodeArrayBuffer",value:function(e,t){var n=this;this.isDestroyed||(this.arraybuffer=e,this.backend.decodeArrayBuffer(e,(function(r){n.isDestroyed||n.arraybuffer!=e||(t(r),n.arraybuffer=null)}),(function(){return n.fireEvent("error","Error decoding audiobuffer")})))}},{key:"getArrayBuffer",value:function(e,t){var n=this,r=Object.assign({url:e,responseType:"arraybuffer"},this.params.xhr),i=A.fetchFile(r);return this.currentRequest=i,this.tmpEvents.push(i.on("progress",(function(e){n.onProgress(e)})),i.on("success",(function(e){t(e),n.currentRequest=null})),i.on("error",(function(e){n.fireEvent("error",e),n.currentRequest=null}))),i}},{key:"onProgress",value:function(e){var t;t=e.lengthComputable?e.loaded/e.total:e.loaded/(e.loaded+1e6),this.fireEvent("loading",Math.round(100*t),e.target)}},{key:"exportPCM",value:function(e,t,n,r,A){e=e||1024,r=r||0,t=t||1e4,n=n||!1;var i=this.backend.getPeaks(e,r,A),s=[].map.call(i,(function(e){return Math.round(e*t)/t}));return new Promise((function(e,t){if(!n){var r=new Blob([JSON.stringify(s)],{type:"application/json;charset=utf-8"}),A=URL.createObjectURL(r);window.open(A),URL.revokeObjectURL(A)}e(s)}))}},{key:"exportImage",value:function(e,t,n){return e||(e="image/png"),t||(t=1),n||(n="dataURL"),this.drawer.getImage(e,t,n)}},{key:"cancelAjax",value:function(){this.currentRequest&&this.currentRequest.controller&&(this.currentRequest._reader&&this.currentRequest._reader.cancel().catch((function(e){})),this.currentRequest.controller.abort(),this.currentRequest=null)}},{key:"clearTmpEvents",value:function(){this.tmpEvents.forEach((function(e){return e.un()}))}},{key:"empty",value:function(){this.backend.isPaused()||(this.stop(),this.backend.disconnectSource()),this.isReady=!1,this.cancelAjax(),this.clearTmpEvents(),this.drawer.progress(0),this.drawer.setWidth(0),this.drawer.drawPeaks({length:this.drawer.getWidth()},0)}},{key:"destroy",value:function(){this.destroyAllPlugins(),this.fireEvent("destroy"),this.cancelAjax(),this.clearTmpEvents(),this.unAll(),!1!==this.params.responsive&&(window.removeEventListener("resize",this._onResize,!0),window.removeEventListener("orientationchange",this._onResize,!0)),this.backend&&(this.backend.destroy(),this.backend=null),this.drawer&&this.drawer.destroy(),this.isDestroyed=!0,this.isReady=!1,this.arraybuffer=null}}])&&g(r.prototype,l),u&&g(r,u),y}(A.Observer);t.default=m,m.VERSION="5.2.0",m.util=A,e.exports=t.default},"./src/webaudio.js":(e,t,n)=>{"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var A=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==r(e)&&"function"!=typeof e)return{default:e};var n=i(t);if(n&&n.has(e))return n.get(e);var A={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in e)if("default"!==a&&Object.prototype.hasOwnProperty.call(e,a)){var o=s?Object.getOwnPropertyDescriptor(e,a):null;o&&(o.get||o.set)?Object.defineProperty(A,a,o):A[a]=e[a]}return A.default=e,n&&n.set(e,A),A}(n("./src/util/index.js"));function i(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(i=function(e){return e?n:t})(e)}function s(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function a(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function o(e,t){return o=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},o(e,t)}function c(e){return c=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},c(e)}var l="playing",u="paused",h="finished",d=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&o(e,t)}(f,e);var t,n,A,i,d=(A=f,i=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,t=c(A);if(i){var n=c(this).constructor;e=Reflect.construct(t,arguments,n)}else e=t.apply(this,arguments);return function(e,t){if(t&&("object"===r(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e)}(this,e)});function f(e){var t,n,r;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,f),(r=d.call(this)).audioContext=null,r.offlineAudioContext=null,r.stateBehaviors=(s(t={},l,{init:function(){this.addOnAudioProcess()},getPlayedPercents:function(){var e=this.getDuration();return this.getCurrentTime()/e||0},getCurrentTime:function(){return this.startPosition+this.getPlayedTime()}}),s(t,u,{init:function(){this.removeOnAudioProcess()},getPlayedPercents:function(){var e=this.getDuration();return this.getCurrentTime()/e||0},getCurrentTime:function(){return this.startPosition}}),s(t,h,{init:function(){this.removeOnAudioProcess(),this.fireEvent("finish")},getPlayedPercents:function(){return 1},getCurrentTime:function(){return this.getDuration()}}),t),r.params=e,r.ac=e.audioContext||(r.supportsWebAudio()?r.getAudioContext():{}),r.lastPlay=r.ac.currentTime,r.startPosition=0,r.scheduledPause=null,r.states=(s(n={},l,Object.create(r.stateBehaviors[l])),s(n,u,Object.create(r.stateBehaviors[u])),s(n,h,Object.create(r.stateBehaviors[h])),n),r.buffer=null,r.filters=[],r.gainNode=null,r.mergedPeaks=null,r.offlineAc=null,r.peaks=null,r.playbackRate=1,r.analyser=null,r.scriptNode=null,r.source=null,r.splitPeaks=[],r.state=null,r.explicitDuration=e.duration,r.destroyed=!1,r}return t=f,n=[{key:"supportsWebAudio",value:function(){return!(!window.AudioContext&&!window.webkitAudioContext)}},{key:"getAudioContext",value:function(){return window.WaveSurferAudioContext||(window.WaveSurferAudioContext=new(window.AudioContext||window.webkitAudioContext)),window.WaveSurferAudioContext}},{key:"getOfflineAudioContext",value:function(e){return window.WaveSurferOfflineAudioContext||(window.WaveSurferOfflineAudioContext=new(window.OfflineAudioContext||window.webkitOfflineAudioContext)(1,2,e)),window.WaveSurferOfflineAudioContext}},{key:"init",value:function(){this.createVolumeNode(),this.createScriptNode(),this.createAnalyserNode(),this.setState(u),this.setPlaybackRate(this.params.audioRate),this.setLength(0)}},{key:"disconnectFilters",value:function(){this.filters&&(this.filters.forEach((function(e){e&&e.disconnect()})),this.filters=null,this.analyser.connect(this.gainNode))}},{key:"setState",value:function(e){this.state!==this.states[e]&&(this.state=this.states[e],this.state.init.call(this))}},{key:"setFilter",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];this.setFilters(t)}},{key:"setFilters",value:function(e){this.disconnectFilters(),e&&e.length&&(this.filters=e,this.analyser.disconnect(),e.reduce((function(e,t){return e.connect(t),t}),this.analyser).connect(this.gainNode))}},{key:"createScriptNode",value:function(){this.params.audioScriptProcessor?this.scriptNode=this.params.audioScriptProcessor:this.ac.createScriptProcessor?this.scriptNode=this.ac.createScriptProcessor(f.scriptBufferSize):this.scriptNode=this.ac.createJavaScriptNode(f.scriptBufferSize),this.scriptNode.connect(this.ac.destination)}},{key:"addOnAudioProcess",value:function(){var e=this;this.scriptNode.onaudioprocess=function(){var t=e.getCurrentTime();t>=e.getDuration()?(e.setState(h),e.fireEvent("pause")):t>=e.scheduledPause?e.pause():e.state===e.states[l]&&e.fireEvent("audioprocess",t)}}},{key:"removeOnAudioProcess",value:function(){this.scriptNode.onaudioprocess=null}},{key:"createAnalyserNode",value:function(){this.analyser=this.ac.createAnalyser(),this.analyser.connect(this.gainNode)}},{key:"createVolumeNode",value:function(){this.ac.createGain?this.gainNode=this.ac.createGain():this.gainNode=this.ac.createGainNode(),this.gainNode.connect(this.ac.destination)}},{key:"setSinkId",value:function(e){if(e){var t=new window.Audio;if(!t.setSinkId)return Promise.reject(new Error("setSinkId is not supported in your browser"));t.autoplay=!0;var n=this.ac.createMediaStreamDestination();return this.gainNode.disconnect(),this.gainNode.connect(n),t.srcObject=n.stream,t.setSinkId(e)}return Promise.reject(new Error("Invalid deviceId: "+e))}},{key:"setVolume",value:function(e){this.gainNode.gain.setValueAtTime(e,this.ac.currentTime)}},{key:"getVolume",value:function(){return this.gainNode.gain.value}},{key:"decodeArrayBuffer",value:function(e,t,n){this.offlineAc||(this.offlineAc=this.getOfflineAudioContext(this.ac&&this.ac.sampleRate?this.ac.sampleRate:44100)),"webkitAudioContext"in window?this.offlineAc.decodeAudioData(e,(function(e){return t(e)}),n):this.offlineAc.decodeAudioData(e).then((function(e){return t(e)})).catch((function(e){return n(e)}))}},{key:"setPeaks",value:function(e,t){null!=t&&(this.explicitDuration=t),this.peaks=e}},{key:"setLength",value:function(e){if(!this.mergedPeaks||e!=2*this.mergedPeaks.length-1+2){this.splitPeaks=[],this.mergedPeaks=[];var t,n=this.buffer?this.buffer.numberOfChannels:1;for(t=0;t<n;t++)this.splitPeaks[t]=[],this.splitPeaks[t][2*(e-1)]=0,this.splitPeaks[t][2*(e-1)+1]=0;this.mergedPeaks[2*(e-1)]=0,this.mergedPeaks[2*(e-1)+1]=0}}},{key:"getPeaks",value:function(e,t,n){if(this.peaks)return this.peaks;if(!this.buffer)return[];if(t=t||0,n=n||e-1,this.setLength(e),!this.buffer)return this.params.splitChannels?this.splitPeaks:this.mergedPeaks;if(!this.buffer.length){var r=this.createBuffer(1,4096,this.sampleRate);this.buffer=r.buffer}var A,i=this.buffer.length/e,s=~~(i/10)||1,a=this.buffer.numberOfChannels;for(A=0;A<a;A++){var o=this.splitPeaks[A],c=this.buffer.getChannelData(A),l=void 0;for(l=t;l<=n;l++){var u=~~(l*i),h=~~(u+i),d=c[u],f=d,p=void 0;for(p=u;p<h;p+=s){var g=c[p];g>f&&(f=g),g<d&&(d=g)}o[2*l]=f,o[2*l+1]=d,(0==A||f>this.mergedPeaks[2*l])&&(this.mergedPeaks[2*l]=f),(0==A||d<this.mergedPeaks[2*l+1])&&(this.mergedPeaks[2*l+1]=d)}}return this.params.splitChannels?this.splitPeaks:this.mergedPeaks}},{key:"getPlayedPercents",value:function(){return this.state.getPlayedPercents.call(this)}},{key:"disconnectSource",value:function(){this.source&&this.source.disconnect()}},{key:"destroyWebAudio",value:function(){this.disconnectFilters(),this.disconnectSource(),this.gainNode.disconnect(),this.scriptNode.disconnect(),this.analyser.disconnect(),this.params.closeAudioContext&&("function"==typeof this.ac.close&&"closed"!=this.ac.state&&this.ac.close(),this.ac=null,this.params.audioContext?this.params.audioContext=null:window.WaveSurferAudioContext=null,window.WaveSurferOfflineAudioContext=null)}},{key:"destroy",value:function(){this.isPaused()||this.pause(),this.unAll(),this.buffer=null,this.destroyed=!0,this.destroyWebAudio()}},{key:"load",value:function(e){this.startPosition=0,this.lastPlay=this.ac.currentTime,this.buffer=e,this.createSource()}},{key:"createSource",value:function(){this.disconnectSource(),this.source=this.ac.createBufferSource(),this.source.start=this.source.start||this.source.noteGrainOn,this.source.stop=this.source.stop||this.source.noteOff,this.setPlaybackRate(this.playbackRate),this.source.buffer=this.buffer,this.source.connect(this.analyser)}},{key:"resumeAudioContext",value:function(){"suspended"==this.ac.state&&this.ac.resume&&this.ac.resume()}},{key:"isPaused",value:function(){return this.state!==this.states[l]}},{key:"getDuration",value:function(){return this.explicitDuration?this.explicitDuration:this.buffer?this.buffer.duration:0}},{key:"seekTo",value:function(e,t){if(this.buffer)return this.scheduledPause=null,null==e&&(e=this.getCurrentTime())>=this.getDuration()&&(e=0),null==t&&(t=this.getDuration()),this.startPosition=e,this.lastPlay=this.ac.currentTime,this.state===this.states[h]&&this.setState(u),{start:e,end:t}}},{key:"getPlayedTime",value:function(){return(this.ac.currentTime-this.lastPlay)*this.playbackRate}},{key:"play",value:function(e,t){if(this.buffer){this.createSource();var n=this.seekTo(e,t);e=n.start,t=n.end,this.scheduledPause=t,this.source.start(0,e),this.resumeAudioContext(),this.setState(l),this.fireEvent("play")}}},{key:"pause",value:function(){this.scheduledPause=null,this.startPosition+=this.getPlayedTime();try{this.source&&this.source.stop(0)}catch(e){}this.setState(u),this.fireEvent("pause")}},{key:"getCurrentTime",value:function(){return this.state.getCurrentTime.call(this)}},{key:"getPlaybackRate",value:function(){return this.playbackRate}},{key:"setPlaybackRate",value:function(e){this.playbackRate=e||1,this.source&&this.source.playbackRate.setValueAtTime(this.playbackRate,this.ac.currentTime)}},{key:"setPlayEnd",value:function(e){this.scheduledPause=e}}],n&&a(t.prototype,n),f}(A.Observer);t.default=d,d.scriptBufferSize=256,e.exports=t.default},"./node_modules/debounce/index.js":e=>{function t(e,t,n){var r,A,i,s,a;function o(){var c=Date.now()-s;c<t&&c>=0?r=setTimeout(o,t-c):(r=null,n||(a=e.apply(i,A),i=A=null))}null==t&&(t=100);var c=function(){i=this,A=arguments,s=Date.now();var c=n&&!r;return r||(r=setTimeout(o,t)),c&&(a=e.apply(i,A),i=A=null),a};return c.clear=function(){r&&(clearTimeout(r),r=null)},c.flush=function(){r&&(a=e.apply(i,A),i=A=null,clearTimeout(r),r=null)},c}t.debounce=t,e.exports=t}},t={},n=function n(r){var A=t[r];if(void 0!==A)return A.exports;var i=t[r]={exports:{}};return e[r](i,i.exports,n),i.exports}("./src/wavesurfer.js");return n})()},e.exports=t()},2055:e=>{"use strict";e.exports=__WEBPACK_EXTERNAL_MODULE__2055__},8330:e=>{"use strict";e.exports=JSON.parse('{"name":"canvas-scatterplot","version":"1.0.2","description":"A scatterplot component based on Fritz Leschkas regl-scatterplot. Needs a projection column.","private":true,"keywords":["jupyter","jupyterlab","jupyterlab-extension","widgets"],"files":["lib/**/*.js","dist/*.js","standalone/*"],"main":"lib/index.js","types":"lib/index.d.ts","homepage":"https://github.com/satishlokkoju/deepview","bugs":{"url":"https://github.com/satishlokkoju/deepview/issues"},"author":"Satish Lokkoju","repository":{"type":"git","url":"https://github.com/satishlokkoju/deepview"},"scripts":{"build":"webpack --mode=development --progress && jupyter labextension build --development=True .","build:prod":"webpack --mode=production && jupyter labextension build .","clean":"yarn run clean:lib && yarn run clean:nbextension && yarn run clean:labextension && yarn run clean:standalone","clean:lib":"rimraf lib","clean:labextension":"rimraf canvas_scatterplot/labextension","clean:nbextension":"rimraf canvas_scatterplot/nbextension/static/index.js","clean:standalone":"rimraf canvas_scatterplot/standalone","lint":"eslint . --ext .ts,.tsx,.svelte --fix","lint:check":"eslint . --ext .ts,.tsx,.svelte","prepack":"yarn run build:prod","watch":"yarn run watch:nbextension","watch:nbextension":"webpack --watch --mode=development --progress","watch:labextension":"jupyter labextension watch .","dev":"yarn run watch & python -m http.server --directory ./canvas_scatterplot/standalone 8082"},"dependencies":{"@betterwithdata/canvas_viz":"^1.0.0","@jupyter-widgets/base":"^1.1.10 || ^2.0.0 || ^3.0.0 || ^4.0.0","arquero":"^4.7.2","regl-scatterplot":"^1.0.0","svelte-watch-resize":"^1.0.3"},"devDependencies":{"@fullhuman/postcss-purgecss":"^4.0.3","@jupyterlab/builder":"^3.1.12","@phosphor/application":"^1.6.0","@phosphor/widgets":"^1.6.0","@tailwindcss/forms":"^0.3.2","@tsconfig/svelte":"^2.0.1","@types/webpack-env":"^1.13.6","@typescript-eslint/eslint-plugin":"^4.31.1","@typescript-eslint/parser":"^4.31.1","@webpack-cli/serve":"^1.2.2","autoprefixer":"^10.3.4","commitizen":"^4.2.4","css-loader":"^6.2.0","css-minimizer-webpack-plugin":"^3.0.1","cz-conventional-changelog":"^3.3.0","eslint":"^7.4.0","eslint-config-prettier":"^8.1.0","eslint-plugin-prettier":"^4.0.0","mini-css-extract-plugin":"^2.3.0","mkdirp":"^1.0.4","postcss":"^8.2.10","postcss-extend":"^1.0.5","postcss-import":"^14.0.1","postcss-load-config":"^3.0.1","postcss-loader":"^6.1.0","precss":"^4.0.0","prettier":"^2.4.0","purgecss-from-svelte":"^2.0.2","rimraf":"^3.0.2","source-map-loader":"^3.0.0","style-loader":"^3.2.1","svelte":"^3.42.5","svelte-loader":"^3.1.1","svelte-preprocess":"^4.9.4","tailwindcss":"^2.2.15","ts-loader":"^9.1.0","typescript":"^4.9.0","webpack":"^5.52.1","webpack-cli":"^4.6.0","webpack-dev-server":"^4.2.1","yarn-run-all":"^3.1.1"},"jupyterlab":{"extension":"lib/index","outputDir":"canvas_scatterplot/labextension/","sharedPackages":{"@jupyter-widgets/base":{"bundled":false,"singleton":true}}},"config":{"commitizen":{"path":"./node_modules/cz-conventional-changelog"}}}')}},__webpack_module_cache__={};function __webpack_require__(e){var t=__webpack_module_cache__[e];if(void 0!==t)return t.exports;var n=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(n.exports,n,n.exports,__webpack_require__),n.exports}__webpack_require__.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=(e,t)=>{for(var n in t)__webpack_require__.o(t,n)&&!__webpack_require__.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var __webpack_exports__={};return(()=>{"use strict";__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,{default:()=>Yb});var e={};__webpack_require__.r(e),__webpack_require__.d(e,{compareArrayLike:()=>tA,joinUint8Arrays:()=>vr,memcpy:()=>wr,rebaseValueOffsets:()=>eA,toArrayBufferView:()=>Br,toArrayBufferViewAsyncIterator:()=>jr,toArrayBufferViewIterator:()=>Mr,toBigInt64Array:()=>xr,toBigUint64Array:()=>Qr,toFloat32Array:()=>Sr,toFloat32ArrayAsyncIterator:()=>Yr,toFloat32ArrayIterator:()=>Nr,toFloat64Array:()=>Ir,toFloat64ArrayAsyncIterator:()=>Xr,toFloat64ArrayIterator:()=>Vr,toInt16Array:()=>_r,toInt16ArrayAsyncIterator:()=>Gr,toInt16ArrayIterator:()=>Or,toInt32Array:()=>Cr,toInt32ArrayAsyncIterator:()=>zr,toInt32ArrayIterator:()=>Lr,toInt8Array:()=>br,toInt8ArrayAsyncIterator:()=>$r,toInt8ArrayIterator:()=>Tr,toUint16Array:()=>Fr,toUint16ArrayAsyncIterator:()=>qr,toUint16ArrayIterator:()=>Hr,toUint32Array:()=>Er,toUint32ArrayAsyncIterator:()=>Jr,toUint32ArrayIterator:()=>Rr,toUint8Array:()=>Ur,toUint8ArrayAsyncIterator:()=>Wr,toUint8ArrayIterator:()=>Pr,toUint8ClampedArray:()=>kr,toUint8ClampedArrayAsyncIterator:()=>Zr,toUint8ClampedArrayIterator:()=>Kr});var t={};__webpack_require__.r(t),__webpack_require__.d(t,{getBit:()=>xA,getBool:()=>CA,iterateBits:()=>QA,packBools:()=>EA,popcnt_array:()=>IA,popcnt_bit_range:()=>SA,popcnt_uint32:()=>kA,setBool:()=>UA,truncateBitmap:()=>FA});var n={};__webpack_require__.r(n),__webpack_require__.d(n,{float64ToUint16:()=>ns,uint16ToFloat64:()=>ts});var r={};__webpack_require__.r(r),__webpack_require__.d(r,{BN:()=>gs,bignumToBigInt:()=>fs,bignumToString:()=>ds,isArrowBigNumSymbol:()=>as});var A={};__webpack_require__.r(A),__webpack_require__.d(A,{clampIndex:()=>ea,clampRange:()=>na,createElementComparator:()=>ia});var i={};__webpack_require__.r(i),__webpack_require__.d(i,{BaseInt64:()=>Bo,Int128:()=>Co,Int64:()=>_o,Uint64:()=>bo});var s={};__webpack_require__.r(s),__webpack_require__.d(s,{CanvasScatterplotModel:()=>qb,CanvasScatterplotView:()=>Jb});var a=__webpack_require__(2055);const o=__webpack_require__(8330),c=o.version,l=o.name,u=Object.assign(Object.assign({},a.DOMWidgetModel.serializers),{table:{serialize:e=>new DataView(e.buffer.slice(0))}});function h(){}const d=e=>e;function f(e){return e()}function p(){return Object.create(null)}function g(e){e.forEach(f)}function m(e){return"function"==typeof e}function y(e,t){return e!=e?t==t:e!==t||e&&"object"==typeof e||"function"==typeof e}let w;function v(e,t){return w||(w=document.createElement("a")),w.href=t,e===w.href}function B(e){return 0===Object.keys(e).length}function b(e,...t){if(null==e)return h;const n=e.subscribe(...t);return n.unsubscribe?()=>n.unsubscribe():n}function _(e,t,n){e.$$.on_destroy.push(b(t,n))}function C(e,t,n,r){if(e){const A=x(e,t,n,r);return e[0](A)}}function x(e,t,n,r){return e[1]&&r?function(e,t){for(const n in t)e[n]=t[n];return e}(n.ctx.slice(),e[1](r(t))):n.ctx}function U(e,t,n,r){if(e[2]&&r){const A=e[2](r(n));if(void 0===t.dirty)return A;if("object"==typeof A){const e=[],n=Math.max(t.dirty.length,A.length);for(let r=0;r<n;r+=1)e[r]=t.dirty[r]|A[r];return e}return t.dirty|A}return t.dirty}function F(e,t,n,r,A,i){if(A){const s=x(t,n,r,i);e.p(s,A)}}function E(e){if(e.ctx.length>32){const t=[],n=e.ctx.length/32;for(let e=0;e<n;e++)t[e]=-1;return t}return-1}function Q(e){return null==e?"":e}const S="undefined"!=typeof window;let I=S?()=>window.performance.now():()=>Date.now(),k=S?e=>requestAnimationFrame(e):h;const D=new Set;function M(e){D.forEach((t=>{t.c(e)||(D.delete(t),t.f())})),0!==D.size&&k(M)}const T="undefined"!=typeof window?window:"undefined"!=typeof globalThis?globalThis:global;class O{constructor(e){this.options=e,this._listeners="WeakMap"in T?new WeakMap:void 0}observe(e,t){return this._listeners.set(e,t),this._getObserver().observe(e,this.options),()=>{this._listeners.delete(e),this._observer.unobserve(e)}}_getObserver(){var e;return null!==(e=this._observer)&&void 0!==e?e:this._observer=new ResizeObserver((e=>{var t;for(const n of e)O.entries.set(n.target,n),null===(t=this._listeners.get(n.target))||void 0===t||t(n)}))}}O.entries="WeakMap"in T?new WeakMap:void 0;let L,P=!1;function H(e,t){e.appendChild(t)}function R(e,t,n){const r=N(e);if(!r.getElementById(t)){const e=z("style");e.id=t,e.textContent=n,K(r,e)}}function N(e){if(!e)return document;const t=e.getRootNode?e.getRootNode():e.ownerDocument;return t&&t.host?t:e.ownerDocument}function V(e){const t=z("style");return K(N(e),t),t.sheet}function K(e,t){return H(e.head||e,t),t.sheet}function j(e,t,n){e.insertBefore(t,n||null)}function $(e){e.parentNode&&e.parentNode.removeChild(e)}function G(e,t){for(let n=0;n<e.length;n+=1)e[n]&&e[n].d(t)}function z(e){return document.createElement(e)}function W(e){return document.createElementNS("http://www.w3.org/2000/svg",e)}function q(e){return document.createTextNode(e)}function J(){return q(" ")}function Y(){return q("")}function X(e,t,n,r){return e.addEventListener(t,n,r),()=>e.removeEventListener(t,n,r)}function Z(e,t,n){null==n?e.removeAttribute(t):e.getAttribute(t)!==n&&e.setAttribute(t,n)}function ee(e,t){t=""+t,e.data!==t&&(e.data=t)}function te(e,t,n,r){null==n?e.style.removeProperty(t):e.style.setProperty(t,n,r?"important":"")}function ne(e,t,n){for(let n=0;n<e.options.length;n+=1){const r=e.options[n];if(r.__value===t)return void(r.selected=!0)}n&&void 0===t||(e.selectedIndex=-1)}function re(e,t){return new e(t)}const Ae=new Map;let ie,se=0;function ae(e,t,n,r,A,i,s,a=0){const o=16.666/r;let c="{\n";for(let e=0;e<=1;e+=o){const r=t+(n-t)*i(e);c+=100*e+`%{${s(r,1-r)}}\n`}const l=c+`100% {${s(n,1-n)}}\n}`,u=`__svelte_${function(e){let t=5381,n=e.length;for(;n--;)t=(t<<5)-t^e.charCodeAt(n);return t>>>0}(l)}_${a}`,h=N(e),{stylesheet:d,rules:f}=Ae.get(h)||function(e,t){const n={stylesheet:V(t),rules:{}};return Ae.set(e,n),n}(h,e);f[u]||(f[u]=!0,d.insertRule(`@keyframes ${u} ${l}`,d.cssRules.length));const p=e.style.animation||"";return e.style.animation=`${p?`${p}, `:""}${u} ${r}ms linear ${A}ms 1 both`,se+=1,u}function oe(e){ie=e}function ce(){if(!ie)throw new Error("Function called outside component initialization");return ie}function le(e,t){const n=e.$$.callbacks[t.type];n&&n.slice().forEach((e=>e.call(this,t)))}const ue=[],he=[];let de=[];const fe=[],pe=Promise.resolve();let ge=!1;function me(e){de.push(e)}function ye(e){fe.push(e)}const we=new Set;let ve,Be=0;function be(){if(0!==Be)return;const e=ie;do{try{for(;Be<ue.length;){const e=ue[Be];Be++,oe(e),_e(e.$$)}}catch(e){throw ue.length=0,Be=0,e}for(oe(null),ue.length=0,Be=0;he.length;)he.pop()();for(let e=0;e<de.length;e+=1){const t=de[e];we.has(t)||(we.add(t),t())}de.length=0}while(ue.length);for(;fe.length;)fe.pop()();ge=!1,we.clear(),oe(e)}function _e(e){if(null!==e.fragment){e.update(),g(e.before_update);const t=e.dirty;e.dirty=[-1],e.fragment&&e.fragment.p(e.ctx,t),e.after_update.forEach(me)}}function Ce(e,t,n){e.dispatchEvent(function(e,t,{bubbles:n=!1,cancelable:r=!1}={}){const A=document.createEvent("CustomEvent");return A.initCustomEvent(e,n,r,t),A}(`${t?"intro":"outro"}${n}`))}const xe=new Set;let Ue;function Fe(){Ue={r:0,c:[],p:Ue}}function Ee(){Ue.r||g(Ue.c),Ue=Ue.p}function Qe(e,t){e&&e.i&&(xe.delete(e),e.i(t))}function Se(e,t,n,r){if(e&&e.o){if(xe.has(e))return;xe.add(e),Ue.c.push((()=>{xe.delete(e),r&&(n&&e.d(1),r())})),e.o(t)}else r&&r()}const Ie={duration:0};function ke(e,t,n,r){const A={direction:"both"};let i=t(e,n,A),s=r?0:1,a=null,o=null,c=null;function l(){c&&function(e,t){const n=(e.style.animation||"").split(", "),r=n.filter(t?e=>e.indexOf(t)<0:e=>-1===e.indexOf("__svelte")),A=n.length-r.length;A&&(e.style.animation=r.join(", "),se-=A,se||k((()=>{se||(Ae.forEach((e=>{const{ownerNode:t}=e.stylesheet;t&&$(t)})),Ae.clear())})))}(e,c)}function u(e,t){const n=e.b-s;return t*=Math.abs(n),{a:s,b:e.b,d:n,duration:t,start:e.start,end:e.start+t,group:e.group}}function f(t){const{delay:n=0,duration:r=300,easing:A=d,tick:f=h,css:p}=i||Ie,m={start:I()+n,b:t};t||(m.group=Ue,Ue.r+=1),a||o?o=m:(p&&(l(),c=ae(e,s,t,r,n,A,p)),t&&f(0,1),a=u(m,r),me((()=>Ce(e,t,"start"))),function(e){let t;0===D.size&&k(M),new Promise((n=>{D.add(t={c:e,f:n})}))}((t=>{if(o&&t>o.start&&(a=u(o,r),o=null,Ce(e,a.b,"start"),p&&(l(),c=ae(e,s,a.b,a.duration,0,A,i.css))),a)if(t>=a.end)f(s=a.b,1-s),Ce(e,a.b,"end"),o||(a.b?l():--a.group.r||g(a.group.c)),a=null;else if(t>=a.start){const e=t-a.start;s=a.a+a.d*A(e/a.duration),f(s,1-s)}return!(!a&&!o)})))}return{run(e){m(i)?(ve||(ve=Promise.resolve(),ve.then((()=>{ve=null}))),ve).then((()=>{i=i(A),f(e)})):f(e)},end(){l(),a=o=null}}}function De(e,t){const n=t.token={};function r(e,r,A,i){if(t.token!==n)return;t.resolved=i;let s=t.ctx;void 0!==A&&(s=s.slice(),s[A]=i);const a=e&&(t.current=e)(s);let o=!1;t.block&&(t.blocks?t.blocks.forEach(((e,n)=>{n!==r&&e&&(Fe(),Se(e,1,1,(()=>{t.blocks[n]===e&&(t.blocks[n]=null)})),Ee())})):t.block.d(1),a.c(),Qe(a,1),a.m(t.mount(),t.anchor),o=!0),t.block=a,t.blocks&&(t.blocks[r]=a),o&&be()}if(!(A=e)||"object"!=typeof A&&"function"!=typeof A||"function"!=typeof A.then){if(t.current!==t.then)return r(t.then,1,t.value,e),!0;t.resolved=e}else{const n=ce();if(e.then((e=>{oe(n),r(t.then,1,t.value,e),oe(null)}),(e=>{if(oe(n),r(t.catch,2,t.error,e),oe(null),!t.hasCatch)throw e})),t.current!==t.pending)return r(t.pending,0),!0}var A}let Me;function Te(e,t,n){const r=e.$$.props[t];void 0!==r&&(e.$$.bound[r]=n,n(e.$$.ctx[r]))}function Oe(e){e&&e.c()}function Le(e,t,n,r){const{fragment:A,after_update:i}=e.$$;A&&A.m(t,n),r||me((()=>{const t=e.$$.on_mount.map(f).filter(m);e.$$.on_destroy?e.$$.on_destroy.push(...t):g(t),e.$$.on_mount=[]})),i.forEach(me)}function Pe(e,t){const n=e.$$;null!==n.fragment&&(function(e){const t=[],n=[];de.forEach((r=>-1===e.indexOf(r)?t.push(r):n.push(r))),n.forEach((e=>e())),de=t}(n.after_update),g(n.on_destroy),n.fragment&&n.fragment.d(t),n.on_destroy=n.fragment=null,n.ctx=[])}function He(e,t,n,r,A,i,s,a=[-1]){const o=ie;oe(e);const c=e.$$={fragment:null,ctx:[],props:i,update:h,not_equal:A,bound:p(),on_mount:[],on_destroy:[],on_disconnect:[],before_update:[],after_update:[],context:new Map(t.context||(o?o.$$.context:[])),callbacks:p(),dirty:a,skip_bound:!1,root:t.target||o.$$.root};s&&s(c.root);let l=!1;if(c.ctx=n?n(e,t.props||{},((t,n,...r)=>{const i=r.length?r[0]:n;return c.ctx&&A(c.ctx[t],c.ctx[t]=i)&&(!c.skip_bound&&c.bound[t]&&c.bound[t](i),l&&function(e,t){-1===e.$$.dirty[0]&&(ue.push(e),ge||(ge=!0,pe.then(be)),e.$$.dirty.fill(0)),e.$$.dirty[t/31|0]|=1<<t%31}(e,t)),n})):[],c.update(),l=!0,g(c.before_update),c.fragment=!!r&&r(c.ctx),t.target){if(t.hydrate){P=!0;const e=(u=t.target,Array.from(u.childNodes));c.fragment&&c.fragment.l(e),e.forEach($)}else c.fragment&&c.fragment.c();t.intro&&Qe(e.$$.fragment),Le(e,t.target,t.anchor,t.customElement),P=!1,be()}var u;oe(o)}new Set(["allowfullscreen","allowpaymentrequest","async","autofocus","autoplay","checked","controls","default","defer","disabled","formnovalidate","hidden","inert","ismap","loop","multiple","muted","nomodule","novalidate","open","playsinline","readonly","required","reversed","selected"]),"function"==typeof HTMLElement&&(Me=class extends HTMLElement{constructor(){super(),this.attachShadow({mode:"open"})}connectedCallback(){const{on_mount:e}=this.$$;this.$$.on_disconnect=e.map(f).filter(m);for(const e in this.$$.slotted)this.appendChild(this.$$.slotted[e])}attributeChangedCallback(e,t,n){this[e]=n}disconnectedCallback(){g(this.$$.on_disconnect)}$destroy(){Pe(this,1),this.$destroy=h}$on(e,t){if(!m(t))return h;const n=this.$$.callbacks[e]||(this.$$.callbacks[e]=[]);return n.push(t),()=>{const e=n.indexOf(t);-1!==e&&n.splice(e,1)}}$set(e){this.$$set&&!B(e)&&(this.$$.skip_bound=!0,this.$$set(e),this.$$.skip_bound=!1)}});class Re{$destroy(){Pe(this,1),this.$destroy=h}$on(e,t){if(!m(t))return h;const n=this.$$.callbacks[e]||(this.$$.callbacks[e]=[]);return n.push(t),()=>{const e=n.indexOf(t);-1!==e&&n.splice(e,1)}}$set(e){this.$$set&&!B(e)&&(this.$$.skip_bound=!0,this.$$set(e),this.$$.skip_bound=!1)}}const Ne=Array.isArray;function Ve(e){return null!=e?Ne(e)?e:[e]:[]}function Ke(e){return e<0?`count() + ${e}`:e}class je{constructor(e){e&&(this._params=e)}params(e){return arguments.length?(e&&(this._params={...this._params,...e}),this):this._params}reify(e){return this.__reify(this,e)}count(e){return this.__count(this,e)}derive(e,t){return this.__derive(this,e,t)}filter(e){return this.__filter(this,e)}slice(e,t){return this.filter(function(e=0,t=1/0){return`${Ke(e)} < row_number() && row_number() <= ${Ke(t)}`}(e,t)).reify()}groupby(...e){return this.__groupby(this,e.flat())}orderby(...e){return this.__orderby(this,e.flat())}relocate(e,t){return this.__relocate(this,Ve(e),t)}rename(...e){return this.__rename(this,e.flat())}rollup(e){return this.__rollup(this,e)}sample(e,t){return this.__sample(this,e,t)}select(...e){return this.__select(this,e.flat())}ungroup(){return this.__ungroup(this)}unorder(){return this.__unorder(this)}dedupe(...e){return this.__dedupe(this,e.flat())}impute(e,t){return this.__impute(this,e,t)}fold(e,t){return this.__fold(this,e,t)}pivot(e,t,n){return this.__pivot(this,e,t,n)}spread(e,t){return this.__spread(this,e,t)}unroll(e,t){return this.__unroll(this,e,t)}lookup(e,t,...n){return this.__lookup(this,e,t,n.flat())}join(e,t,n,r){return this.__join(this,e,t,n,r)}join_left(e,t,n,r){const A={...r,left:!0,right:!1};return this.__join(this,e,t,n,A)}join_right(e,t,n,r){const A={...r,left:!1,right:!0};return this.__join(this,e,t,n,A)}join_full(e,t,n,r){const A={...r,left:!0,right:!0};return this.__join(this,e,t,n,A)}cross(e,t,n){return this.__cross(this,e,t,n)}semijoin(e,t){return this.__semijoin(this,e,t)}antijoin(e,t){return this.__antijoin(this,e,t)}concat(...e){return this.__concat(this,e.flat())}union(...e){return this.__union(this,e.flat())}intersect(...e){return this.__intersect(this,e.flat())}except(...e){return this.__except(this,e.flat())}}function $e(e){throw Error(e)}function Ge(e){return"number"==typeof e}function ze(e){return"function"==typeof e}function We(e,t){const n=Array(e);if(ze(t))for(let r=0;r<e;++r)n[r]=t(r);else n.fill(t);return n}class qe extends je{constructor(e,t,n,r,A,i,s){super(s),this._names=Object.freeze(e),this._data=n,this._total=t,this._nrows=r?r.count():t,this._mask=t!==this._nrows&&r||null,this._group=A||null,this._order=i||null}create(e){$e("Not implemented")}get[Symbol.toStringTag](){if(!this._names)return"Object";const e=this.numRows()+" row"+(1!==this.numRows()?"s":"");return`Table: ${this.numCols()+" col"+(1!==this.numCols()?"s":"")} x ${e}`+(this.isFiltered()?` (${this.totalRows()} backing)`:"")+(this.isGrouped()?`, ${this._group.size} groups`:"")+(this.isOrdered()?", ordered":"")}isFiltered(){return!!this._mask}isGrouped(){return!!this._group}isOrdered(){return!!this._order}data(){return this._data}mask(){return this._mask}groups(){return this._group}comparator(){return this._order}totalRows(){return this._total}numRows(){return this._nrows}get size(){return this._nrows}numCols(){return this._names.length}columnNames(e){return e?this._names.filter(e):this._names.slice()}columnName(e){return this._names[e]}columnIndex(e){return this._names.indexOf(e)}columnArray(e,t){return this.array(e,t)}array(e,t){$e("Not implemented")}*values(e){const t=this.getter(e),n=this.numRows();for(let e=0;e<n;++e)yield t(e)}get(e,t=0){$e("Not implemented")}getter(e){$e("Not implemented")}objects(e){$e("Not implemented")}object(e){$e("Not implemented")}[Symbol.iterator](){$e("Not implemented")}print(e={}){Ge(e)?e={limit:e}:null==e.limit&&(e.limit=10);const t=this.objects({...e,grouped:!1}),n=`${this[Symbol.toStringTag]}. Showing ${t.length} rows.`;console.log(n),console.table(t)}indices(e=!0){if(this._index)return this._index;const t=this.numRows(),n=new Uint32Array(t),r=this.isOrdered(),A=this.mask();let i=-1;if(A)for(let e=A.next(0);e>=0;e=A.next(e+1))n[++i]=e;else for(let e=0;e<t;++e)n[++i]=e;if(e&&r){const e=this._order,t=this._data;n.sort(((n,r)=>e(n,r,t)))}return!e&&r||(this._index=n),n}partitions(e=!0){if(this._partitions)return this._partitions;if(!this.isGrouped())return[this.indices(e)];const{keys:t,size:n}=this._group,r=We(n,(()=>[])),A=this._index,i=this.mask(),s=this.numRows();if(A&&this.isOrdered())for(let e,n=0;n<s;++n)e=A[n],r[t[e]].push(e);else if(i)for(let e=i.next(0);e>=0;e=i.next(e+1))r[t[e]].push(e);else for(let e=0;e<s;++e)r[t[e]].push(e);if(e&&!A&&this.isOrdered()){const e=this._order,t=this._data;for(let A=0;A<n;++A)r[A].sort(((n,r)=>e(n,r,t)))}return!e&&this.isOrdered()||(this._partitions=r),r}scan(e,t,n=1/0,r=0){const A=this._mask,i=this._nrows,s=this._data;let a=r||0;if(a>i)return;const o=Math.min(i,a+n),c=()=>a=this._total;if(t&&this.isOrdered()||A&&this._index){const t=this.indices(),n=this._data;for(;a<o;++a)e(t[a],n,c)}else if(A){let t=o-a+1;for(a=A.nth(a);--t&&a>-1;a=A.next(a+1))e(a,s,c)}else for(;a<o;++a)e(a,s,c)}slice(e=0,t=1/0){if(this.isGrouped())return super.slice(e,t);const n=[],r=this.numRows();return e=Math.max(0,e+(e<0?r:0)),t=Math.min(r,Math.max(0,t+(t<0?r:0))),this.scan((e=>n.push(e)),!0,t-e,e),this.reify(n)}reduce(e){return this.__reduce(this,e)}}class Je{constructor(e){this.data=e}get length(){return this.data.length}get(e){return this.data[e]}[Symbol.iterator](){return this.data[Symbol.iterator]()}}let Ye=function(e){return e&&ze(e.get)?e:new Je(e)};function Xe(e){return e instanceof Date}function Ze(e){return e===Object(e)}function et(e){return e instanceof RegExp}function tt(e){return"string"==typeof e}function nt(e,t=["key","value"]){const n=[],r=[];for(const[t,A]of e)n.push(t),r.push(A);const A={};return t[0]&&(A[t[0]]=n),t[1]&&(A[t[1]]=r),A}const{hasOwnProperty:rt}=Object.prototype;function At(e,t){return rt.call(e,t)}function it(e){return e?new st({...e.data()},e.columnNames()):new st}class st{constructor(e,t){this.data=e||{},this.names=t||[]}add(e,t){return this.has(e)||this.names.push(e+""),this.data[e]=t}has(e){return At(this.data,e)}new(){return this.filter=null,this.groups=this.groups||null,this.order=null,this}groupby(e){return this.groups=e,this}}const at=void 0,ot=Object.getPrototypeOf(Int8Array);function ct(e){return e instanceof ot}function lt(e){return Ne(e)||ct(e)}function ut(e){return null!=e&&e==e}const ht=e=>lt(e)||tt(e),dt={compact:e=>lt(e)?e.filter((e=>ut(e))):e,concat:(...e)=>[].concat(...e),includes:(e,t,n)=>!!ht(e)&&e.includes(t,n),indexof:(e,t)=>ht(e)?e.indexOf(t):-1,join:(e,t)=>lt(e)?e.join(t):at,lastindexof:(e,t)=>ht(e)?e.lastIndexOf(t):-1,length:e=>ht(e)?e.length:0,pluck:(e,t)=>lt(e)?e.map((e=>ut(e)?e[t]:at)):at,reverse:e=>lt(e)?e.slice().reverse():tt(e)?e.split("").reverse().join(""):at,slice:(e,t,n)=>ht(e)?e.slice(t,n):at};function ft(e,t,n="0"){const r=e+"",A=r.length;return A<t?Array(t-A+1).join(n)+r:r}const pt=e=>(e<10?"0":"")+e;function gt(e,t,n,r,A,i,s,a,o){const c=a?"Z":"";return(e=>e<0?"-"+ft(-e,6):e>9999?"+"+ft(e,6):ft(e,4))(e)+"-"+pt(t+1)+"-"+pt(n)+(!o||s?"T"+pt(r)+":"+pt(A)+":"+pt(i)+"."+ft(s,3)+c:i?"T"+pt(r)+":"+pt(A)+":"+pt(i)+c:A||r||!a?"T"+pt(r)+":"+pt(A)+c:"")}function mt(e,t){return isNaN(e)?"Invalid Date":gt(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds(),!1,t)}function yt(e,t){return isNaN(e)?"Invalid Date":gt(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds(),!0,t)}const wt=/^([-+]\d{2})?\d{4}(-\d{2}(-\d{2})?)?(T\d{2}:\d{2}(:\d{2}(\.\d{3})?)?(Z|[-+]\d{2}:\d{2})?)?$/;const vt=864e5,Bt=6048e5,bt=new Date,_t=new Date,Ct=e=>(bt.setTime("string"==typeof e?function(e,t=Date.parse){return function(e){return e.match(wt)}(e)?t(e):e}(e):e),bt),xt={format_date:(e,t)=>mt(Ct(e),!t),format_utcdate:(e,t)=>yt(Ct(e),!t),timestamp:e=>+Ct(e),year:e=>Ct(e).getFullYear(),quarter:e=>Math.floor(Ct(e).getMonth()/3),month:e=>Ct(e).getMonth(),date:e=>Ct(e).getDate(),dayofweek:e=>Ct(e).getDay(),hours:e=>Ct(e).getHours(),minutes:e=>Ct(e).getMinutes(),seconds:e=>Ct(e).getSeconds(),milliseconds:e=>Ct(e).getMilliseconds(),utcyear:e=>Ct(e).getUTCFullYear(),utcquarter:e=>Math.floor(Ct(e).getUTCMonth()/3),utcmonth:e=>Ct(e).getUTCMonth(),utcdate:e=>Ct(e).getUTCDate(),utcdayofweek:e=>Ct(e).getUTCDay(),utchours:e=>Ct(e).getUTCHours(),utcminutes:e=>Ct(e).getUTCMinutes(),utcseconds:e=>Ct(e).getUTCSeconds(),utcmilliseconds:e=>Ct(e).getUTCMilliseconds(),datetime:function(e,t,n,r,A,i,s){return arguments.length?new Date(e,t||0,null==n?1:n,r||0,A||0,i||0,s||0):new Date(Date.now())},dayofyear:function(e){_t.setTime(+e),_t.setHours(0,0,0,0),bt.setTime(+_t),bt.setMonth(0),bt.setDate(1);const t=6e4*(_t.getTimezoneOffset()-bt.getTimezoneOffset());return Math.floor(1+(_t-bt-t)/vt)},week:function(e,t){const n=t||0;_t.setTime(+e),_t.setDate(_t.getDate()-(_t.getDay()+7-n)%7),_t.setHours(0,0,0,0),bt.setTime(+e),bt.setMonth(0),bt.setDate(1),bt.setDate(1-(bt.getDay()+7-n)%7),bt.setHours(0,0,0,0);const r=6e4*(_t.getTimezoneOffset()-bt.getTimezoneOffset());return Math.floor((_t-bt+1-r)/Bt)},utcdatetime:function(e,t,n,r,A,i,s){return arguments.length?new Date(Date.UTC(e,t||0,null==n?1:n,r||0,A||0,i||0,s||0)):new Date(Date.now())},utcdayofyear:function(e){_t.setTime(+e),_t.setUTCHours(0,0,0,0);const t=Date.UTC(_t.getUTCFullYear(),0,1);return Math.floor(1+(_t-t)/vt)},utcweek:function(e,t){const n=t||0;return _t.setTime(+e),_t.setUTCDate(_t.getUTCDate()-(_t.getUTCDay()+7-n)%7),_t.setUTCHours(0,0,0,0),bt.setTime(+e),bt.setUTCMonth(0),bt.setUTCDate(1),bt.setUTCDate(1-(bt.getUTCDay()+7-n)%7),bt.setUTCHours(0,0,0,0),Math.floor((_t-bt+1)/Bt)},now:Date.now};function Ut(e,t){return null!=e&&null!=t&&e==e&&t==t&&(e===t||(Xe(e)||Xe(t)?+e==+t:et(e)&&et(t)?e+""==t+"":!(!Ze(e)||!Ze(t))&&function(e,t){if(Object.getPrototypeOf(e)!==Object.getPrototypeOf(t))return!1;if(e.length||t.length)return Ft(e,t);const n=Object.keys(e),r=Object.keys(t);if(n.length!==r.length)return!1;if(n.sort(),r.sort(),!Ft(n,r,((e,t)=>e===t)))return!1;const A=n.length;for(let r=0;r<A;++r){const A=n[r];if(!Ut(e[A],t[A]))return!1}return!0}(e,t)))}function Ft(e,t,n=Ut){const r=e.length;if(r!==t.length)return!1;for(let A=0;A<r;++A)if(!n(e[A],t[A]))return!1;return!0}const Et={parse_json:e=>JSON.parse(e),to_json:e=>JSON.stringify(e)};let Qt=Math.random;function St(){return Qt()}function It(e){return e instanceof Map}function kt(e){return It(e)||function(e){return e instanceof Set}(e)}function Dt(e){return Array.from(e)}function Mt(e,t,n){let r=arguments.length;e=+e,t=+t,n=r<2?(t=e,e=0,1):r<3?1:+n,r=0|Math.max(0,Math.ceil((t-e)/n));const A=new Array(r);for(let t=0;t<r;++t)A[t]=e+t*n;return A}const Tt={bin:function(e,t,n,r,A){return null==e?null:e<t?-1/0:e>n?1/0:(e=Math.max(t,Math.min(e,n)),t+r*Math.floor(1e-14+(e-t)/r+(A||0)))},equal:Ut,recode:function(e,t,n){if(t instanceof Map){if(t.has(e))return t.get(e)}else if(At(t,e))return t[e];return void 0!==n?n:e},sequence:Mt,...dt,...xt,...Et,random:St,is_nan:Number.isNaN,is_finite:Number.isFinite,abs:Math.abs,cbrt:Math.cbrt,ceil:Math.ceil,clz32:Math.clz32,exp:Math.exp,expm1:Math.expm1,floor:Math.floor,fround:Math.fround,greatest:Math.max,least:Math.min,log:Math.log,log10:Math.log10,log1p:Math.log1p,log2:Math.log2,pow:Math.pow,round:Math.round,sign:Math.sign,sqrt:Math.sqrt,trunc:Math.trunc,degrees:e=>180*e/Math.PI,radians:e=>Math.PI*e/180,acos:Math.acos,acosh:Math.acosh,asin:Math.asin,asinh:Math.asinh,atan:Math.atan,atan2:Math.atan2,atanh:Math.atanh,cos:Math.cos,cosh:Math.cosh,sin:Math.sin,sinh:Math.sinh,tan:Math.tan,tanh:Math.tanh,has:(e,t)=>kt(e)?e.has(t):null!=e&&At(e,t),keys:e=>It(e)?Dt(e.keys()):null!=e?Object.keys(e):[],values:e=>kt(e)?Dt(e.values()):null!=e?Object.values(e):[],entries:e=>kt(e)?Dt(e.entries()):null!=e?Object.entries(e):[],object:e=>e?Object.fromEntries(e):at,parse_date:e=>null==e?e:new Date(e),parse_float:e=>null==e?e:Number.parseFloat(e),parse_int:(e,t)=>null==e?e:Number.parseInt(e,t),endswith:(e,t,n)=>null!=e&&String(e).endsWith(t,n),match:(e,t,n)=>{const r=null==e?e:String(e).match(t);return null==n||null==r?r:"number"==typeof n?r[n]:r.groups?r.groups[n]:null},normalize:(e,t)=>null==e?e:String(e).normalize(t),padend:(e,t,n)=>null==e?e:String(e).padEnd(t,n),padstart:(e,t,n)=>null==e?e:String(e).padStart(t,n),upper:e=>null==e?e:String(e).toUpperCase(),lower:e=>null==e?e:String(e).toLowerCase(),repeat:(e,t)=>null==e?e:String(e).repeat(t),replace:(e,t,n)=>null==e?e:String(e).replace(t,String(n)),substring:(e,t,n)=>null==e?e:String(e).substring(t,n),split:(e,t,n)=>null==e?[]:String(e).split(t,n),startswith:(e,t,n)=>null!=e&&String(e).startsWith(t,n),trim:e=>null==e?e:String(e).trim()};function Ot(e){return"bigint"==typeof e}function Lt(e){return void 0===e?e+"":Ot(e)?e+"n":JSON.stringify(e)}function Pt(e,t=[],n=[]){return new Ht(e,Ve(t),Ve(n))}class Ht{constructor(e,t,n){this.name=e,this.fields=t,this.params=n}toString(){const e=[...this.fields.map((e=>`d[${Lt(e)}]`)),...this.params.map(Lt)];return`d => op.${this.name}(${e})`}toObject(){return{expr:this.toString(),func:!0}}}const Rt=e=>Pt("any",e),Nt=()=>Pt("count"),Vt=e=>Pt("array_agg",e),Kt=e=>Pt("array_agg_distinct",e),jt=(e,t)=>Pt("map_agg",[e,t]),$t=(e,t)=>Pt("object_agg",[e,t]),Gt=(e,t)=>Pt("entries_agg",[e,t]),zt={...Tt,row_object:(...e)=>Pt("row_object",null,e.flat()),count:Nt,any:Rt,array_agg:Vt,array_agg_distinct:Kt,object_agg:$t,map_agg:jt,entries_agg:Gt,valid:e=>Pt("valid",e),invalid:e=>Pt("invalid",e),distinct:e=>Pt("distinct",e),mode:e=>Pt("mode",e),sum:e=>Pt("sum",e),product:e=>Pt("product",e),mean:e=>Pt("mean",e),average:e=>Pt("average",e),variance:e=>Pt("variance",e),variancep:e=>Pt("variancep",e),stdev:e=>Pt("stdev",e),stdevp:e=>Pt("stdevp",e),min:e=>Pt("min",e),max:e=>Pt("max",e),quantile:(e,t)=>Pt("quantile",e,t),median:e=>Pt("median",e),covariance:(e,t)=>Pt("covariance",[e,t]),covariancep:(e,t)=>Pt("covariancep",[e,t]),corr:(e,t)=>Pt("corr",[e,t]),bins:(e,t,n,r)=>Pt("bins",e,[t,n,r]),row_number:()=>Pt("row_number"),rank:()=>Pt("rank"),avg_rank:()=>Pt("avg_rank"),dense_rank:()=>Pt("dense_rank"),percent_rank:()=>Pt("percent_rank"),cume_dist:()=>Pt("cume_dist"),ntile:e=>Pt("ntile",null,e),lag:(e,t,n)=>Pt("lag",e,[t,n]),lead:(e,t,n)=>Pt("lead",e,[t,n]),first_value:e=>Pt("first_value",e),last_value:e=>Pt("last_value",e),nth_value:(e,t)=>Pt("nth_value",e,t),fill_down:(e,t)=>Pt("fill_down",e,t),fill_up:(e,t)=>Pt("fill_up",e,t)};const Wt="Identifier",qt="Literal",Jt="MemberExpression",Yt="ObjectPattern",Xt="Property",Zt="Column",en="Op",tn=(e,t)=>{const n=cn[e.type];return n?n(e,t):$e(`Unsupported expression construct: ${e.type}`)},nn=(e,t)=>"("+tn(e.left,t)+" "+e.operator+" "+tn(e.right,t)+")",rn=(e,t)=>"("+sn(e.params,t)+")=>"+tn(e.body,t),An=(e,t)=>tn(e.callee,t)+"("+sn(e.arguments,t)+")",sn=(e,t,n=",")=>e.map((e=>tn(e,t))).join(n),an=e=>e.computed?`[${Lt(e.name)}]`:`.${e.name}`,on=(e,t,n)=>{const r=e.table||"";return`data${r}${an(e)}.${n}(${t.index}${r})`},cn={Constant:e=>e.raw,Column:(e,t)=>on(e,t,"get"),Dictionary:(e,t)=>on(e,t,"key"),Function:e=>`fn.${e.name}`,Parameter:e=>`$${an(e)}`,Op:(e,t)=>`op(${Lt(e.name)},${t.op||t.index})`,Literal:e=>e.raw,Identifier:e=>e.name,TemplateLiteral:(e,t)=>{const{quasis:n,expressions:r}=e,A=r.length;let i=n[0].value.raw;for(let e=0;e<A;)i+="${"+tn(r[e],t)+"}"+n[++e].value.raw;return"`"+i+"`"},MemberExpression:(e,t)=>{const n=!e.computed,r=tn(e.object,t),A=tn(e.property,t);return r+(n?"."+A:"["+A+"]")},CallExpression:An,NewExpression:(e,t)=>"new "+An(e,t),ArrayExpression:(e,t)=>"["+sn(e.elements,t)+"]",AssignmentExpression:nn,BinaryExpression:nn,LogicalExpression:nn,UnaryExpression:(e,t)=>"("+e.operator+tn(e.argument,t)+")",ConditionalExpression:(e,t)=>"("+tn(e.test,t)+"?"+tn(e.consequent,t)+":"+tn(e.alternate,t)+")",ObjectExpression:(e,t)=>"({"+sn(e.properties,t)+"})",Property:(e,t)=>{const n=tn(e.key,t);return(e.computed?`[${n}]`:n)+":"+tn(e.value,t)},ArrowFunctionExpression:rn,FunctionExpression:rn,FunctionDeclaration:rn,ArrayPattern:(e,t)=>"["+sn(e.elements,t)+"]",ObjectPattern:(e,t)=>"{"+sn(e.properties,t)+"}",VariableDeclaration:(e,t)=>e.kind+" "+sn(e.declarations,t,","),VariableDeclarator:(e,t)=>tn(e.id,t)+"="+tn(e.init,t),SpreadElement:(e,t)=>"..."+tn(e.argument,t),BlockStatement:(e,t)=>"{"+sn(e.body,t,";")+";}",BreakStatement:()=>"break",ExpressionStatement:(e,t)=>tn(e.expression,t),IfStatement:(e,t)=>"if ("+tn(e.test,t)+")"+tn(e.consequent,t)+(e.alternate?" else "+tn(e.alternate,t):""),SwitchStatement:(e,t)=>"switch ("+tn(e.discriminant,t)+") {"+sn(e.cases,t,"")+"}",SwitchCase:(e,t)=>(e.test?"case "+tn(e.test,t):"default")+": "+sn(e.consequent,t,";")+";",ReturnStatement:(e,t)=>"return "+tn(e.argument,t),Program:(e,t)=>tn(e.body[0],t)};function ln(e,t={index:"row"}){return tn(e,t)}function un(e){const t=typeof e;return"string"===t?`"${e}"`:"object"===t&&e?Xe(e)?+e:Ne(e)||ct(e)?`[${e.map(un)}]`:et(e)?e+"":function(e){let t="{",n=-1;for(const r in e)++n>0&&(t+=","),t+=`"${r}":${un(e[r])}`;return t+="}",t}(e):e}function hn(e,t){const n=e.length;return 1===n?(t,n)=>un(e[0](t,n)):(r,A)=>{let i="";for(let s=0;s<n;++s){s>0&&(i+="|");const n=e[s](r,A);if(t&&(null==n||n!=n))return null;i+=un(n)}return i}}function dn(){}function fn(e){return e.init=e.init||dn,e.add=e.add||dn,e.rem=e.rem||dn,e}function pn(e,t){return e.product_v=!1,e.product=t}const gn={count:{create:()=>fn({value:e=>e.count}),param:[]},array_agg:{create:()=>fn({init:e=>e.values=!0,value:e=>e.list.values(e.stream)}),param:[1]},object_agg:{create:()=>fn({init:e=>e.values=!0,value:e=>Object.fromEntries(e.list.values())}),param:[2]},map_agg:{create:()=>fn({init:e=>e.values=!0,value:e=>new Map(e.list.values())}),param:[2]},entries_agg:{create:()=>fn({init:e=>e.values=!0,value:e=>e.list.values(e.stream)}),param:[2]},any:{create:()=>fn({add:(e,t)=>{null==e.any&&(e.any=t)},value:e=>e.valid?e.any:at}),param:[1]},valid:{create:()=>fn({value:e=>e.valid}),param:[1]},invalid:{create:()=>fn({value:e=>e.count-e.valid}),param:[1]},distinct:{create:()=>({init:e=>e.distinct=function(){const e=new Map;return{count:()=>e.size,values:()=>Array.from(e.values(),(e=>e.v)),increment(t){const n=un(t),r=e.get(n);r?++r.n:e.set(n,{v:t,n:1})},decrement(t){const n=un(t),r=e.get(n);1===r.n?e.delete(n):--r.n},forEach(t){e.forEach((({v:e,n})=>t(e,n)))}}}(),value:e=>e.distinct.count()+(e.valid===e.count?0:1),add:(e,t)=>e.distinct.increment(t),rem:(e,t)=>e.distinct.decrement(t)}),param:[1]},array_agg_distinct:{create:()=>fn({value:e=>e.distinct.values()}),param:[1],req:["distinct"]},mode:{create:()=>fn({value:e=>{let t=at,n=0;return e.distinct.forEach(((e,r)=>{r>n&&(n=r,t=e)})),t}}),param:[1],req:["distinct"]},sum:{create:()=>({init:e=>e.sum=0,value:e=>e.valid?e.sum:at,add:(e,t)=>Ot(t)?0===e.sum?e.sum=t:e.sum+=t:e.sum+=+t,rem:(e,t)=>e.sum-=t}),param:[1]},product:{create:()=>({init:e=>pn(e,1),value:e=>e.valid?e.product_v?pn(e,function(e,t=0,n=e.length){let r=e[t++];for(let A=t;A<n;++A)r*=e[A];return r}(e.list.values())):e.product:void 0,add:(e,t)=>Ot(t)&&1===e.product?e.product=t:e.product*=t,rem:(e,t)=>0==t||t===1/0||t===-1/0?e.product_v=!0:e.product/=t}),param:[1],stream:["array_agg"]},mean:{create:()=>({init:e=>e.mean=0,value:e=>e.valid?e.mean:at,add:(e,t)=>{e.mean_d=t-e.mean,e.mean+=e.mean_d/e.valid},rem:(e,t)=>{e.mean_d=t-e.mean,e.mean-=e.valid?e.mean_d/e.valid:e.mean}}),param:[1]},average:{create:()=>fn({value:e=>e.valid?e.mean:at}),param:[1],req:["mean"]},variance:{create:()=>({init:e=>e.dev=0,value:e=>e.valid>1?e.dev/(e.valid-1):at,add:(e,t)=>e.dev+=e.mean_d*(t-e.mean),rem:(e,t)=>e.dev-=e.mean_d*(t-e.mean)}),param:[1],req:["mean"]},variancep:{create:()=>fn({value:e=>e.valid>1?e.dev/e.valid:at}),param:[1],req:["variance"]},stdev:{create:()=>fn({value:e=>e.valid>1?Math.sqrt(e.dev/(e.valid-1)):at}),param:[1],req:["variance"]},stdevp:{create:()=>fn({value:e=>e.valid>1?Math.sqrt(e.dev/e.valid):at}),param:[1],req:["variance"]},min:{create:()=>({init:e=>e.min=at,value:e=>e.min=Number.isNaN(e.min)?e.list.min():e.min,add:(e,t)=>{(t<e.min||e.min===at)&&(e.min=t)},rem:(e,t)=>{t<=e.min&&(e.min=NaN)}}),param:[1],stream:["array_agg"]},max:{create:()=>({init:e=>e.max=at,value:e=>e.max=Number.isNaN(e.max)?e.list.max():e.max,add:(e,t)=>{(t>e.max||e.max===at)&&(e.max=t)},rem:(e,t)=>{t>=e.max&&(e.max=NaN)}}),param:[1],stream:["array_agg"]},quantile:{create:e=>fn({value:t=>t.list.quantile(e)}),param:[1,1],req:["array_agg"]},median:{create:()=>fn({value:e=>e.list.quantile(.5)}),param:[1],req:["array_agg"]},covariance:{create:()=>({init:e=>{e.cov=e.mean_x=e.mean_y=e.dev_x=e.dev_y=0},value:e=>e.valid>1?e.cov/(e.valid-1):at,add:(e,t,n)=>{const r=t-e.mean_x,A=n-e.mean_y;e.mean_x+=r/e.valid,e.mean_y+=A/e.valid;const i=n-e.mean_y;e.dev_x+=r*(t-e.mean_x),e.dev_y+=A*i,e.cov+=r*i},rem:(e,t,n)=>{const r=t-e.mean_x,A=n-e.mean_y;e.mean_x-=e.valid?r/e.valid:e.mean_x,e.mean_y-=e.valid?A/e.valid:e.mean_y;const i=n-e.mean_y;e.dev_x-=r*(t-e.mean_x),e.dev_y-=A*i,e.cov-=r*i}}),param:[2]},covariancep:{create:()=>fn({value:e=>e.valid>1?e.cov/e.valid:at}),param:[2],req:["covariance"]},corr:{create:()=>fn({value:e=>e.valid>1?e.cov/(Math.sqrt(e.dev_x)*Math.sqrt(e.dev_y)):at}),param:[2],req:["covariance"]},bins:{create:(e,t,n,r)=>fn({value:A=>function(e,t,n=15,r=!0,A=0,i){const s=Math.LN10;if(null==i){const r=Math.ceil(Math.log(n)/s),a=t-e||Math.abs(e)||1,o=[5,2];for(i=Math.max(A,Math.pow(10,Math.round(Math.log(a)/s)-r));Math.ceil(a/i)>n;)i*=10;const c=o.length;for(let e=0;e<c;++e){const t=i/o[e];t>=A&&a/t<=n&&(i=t)}}if(r){let n=Math.log(i);const r=n>=0?0:1+~~(-n/s),A=Math.pow(10,-r-1);n=Math.floor(e/i+A)*i,e=e<n?n-i:n,t=Math.ceil(t/i)*i}return[e,t===e?e+i:t,i]}(A.min,A.max,e,t,n,r)}),param:[1,4],req:["min","max"]}},mn={create(){let e;return{init:()=>e=1,value:t=>{const n=t.index;return n&&!t.peer(n)?e=n+1:e}}},param:[]},yn={create(){let e;return{init:()=>e=0,value:t=>{const{index:n,peer:r,size:A}=t;let i=n;if(e<i){for(;i+1<A&&r(i+1);)++i;e=i}return(1+e)/A}}},param:[]},wn={row_number:{create:()=>({init:dn,value:e=>e.index+1}),param:[]},rank:mn,avg_rank:{create(){let e,t;return{init:()=>(e=-1,t=1),value:n=>{const r=n.index;if(r>=e){for(t=e=r+1;n.peer(e);t+=++e);t/=e-r}return t}}},param:[]},dense_rank:{create(){let e;return{init:()=>e=1,value:t=>{const n=t.index;return n&&!t.peer(n)?++e:e}}},param:[]},percent_rank:{create(){const{init:e,value:t}=mn.create();return{init:e,value:e=>(t(e)-1)/(e.size-1)}},param:[]},cume_dist:yn,ntile:{create(e){(e=+e)>0||$e("ntile num must be greater than zero.");const{init:t,value:n}=yn.create();return{init:t,value:t=>Math.ceil(e*n(t))}},param:[0,1]},lag:{create:(e,t=at)=>(e=+e||1,{init:dn,value:(n,r)=>{const A=n.index-e;return A>=0?n.value(A,r):t}}),param:[1,2]},lead:{create:(e,t=at)=>(e=+e||1,{init:dn,value:(n,r)=>{const A=n.index+e;return A<n.size?n.value(A,r):t}}),param:[1,2]},first_value:{create:()=>({init:dn,value:(e,t)=>e.value(e.i0,t)}),param:[1]},last_value:{create:()=>({init:dn,value:(e,t)=>e.value(e.i1-1,t)}),param:[1]},nth_value:{create:e=>((e=+e)>0||$e("nth_value nth must be greater than zero."),{init:dn,value:(t,n)=>{const r=t.i0+(e-1);return r<t.i1?t.value(r,n):at}}),param:[1,1]},fill_down:{create(e=at){let t;return{init:()=>t=e,value:(e,n)=>{const r=e.value(e.index,n);return ut(r)?t=r:t}}},param:[1,1]},fill_up:{create(e=at){let t,n;return{init:()=>(t=e,n=-1),value:(r,A)=>r.index<=n?t:(n=function(e,t,n){for(const r=e.size;n<r;++n)if(ut(e.value(n,t)))return n;return-1}(r,A,r.index))>=0?t=r.value(n,A):(n=r.size,t=e)}},param:[1,1]}};function vn(e){return At(gn,e)}function Bn(e){return At(wn,e)}function bn(e){return At(Tt,e)||"row_object"===e}function _n(e){return vn(e)&&gn[e]}function Cn(e){return Bn(e)&&wn[e]}function xn(e,t,n){return e=`"use strict"; return ${e};`,Function("fn","$",e)(t,n)}const Un={escape:(e,t,n)=>xn(e,t,n),expr:(e,t)=>xn(`(row,data,op)=>${e}`,Tt,t),expr2:(e,t)=>xn(`(row0,data0,row,data)=>${e}`,Tt,t),join:(e,t)=>xn(`(row1,data1,row2,data2)=>${e}`,Tt,t),param:(e,t)=>xn(e,Tt,t)},Fn={"==":1,"!=":1,"===":1,"!==":1};function En(e,t,n=0,r,A){if(e.type=Zt,e.name=t,e.table=n,A&&r&&ze(r.keyFor)){const t=Fn[A.operator]?A.left===e?A.right:A.left:A.callee&&"equal"===A.callee.name?A.arguments[A.arguments[0]===e?1:0]:null;t&&t.type===qt&&function(e,t,n,r){r<0?(e.type=qt,e.value=!1,e.raw="false"):(t.type="Dictionary",n.value=r,n.raw=r+"")}(A,e,t,r.keyFor(t.value))}return e}function Qn(e){return Ne(e)?e:It(e)?e.entries():e?Object.entries(e):[]}const Sn="row_object";function In(e,t){e.type="ObjectExpression";const n=e.properties=[];for(const e of Qn(t)){const[t,r]=Ne(e)?e:[e,e];n.push({type:Xt,key:{type:qt,raw:Lt(r)},value:En({computed:!0},t)})}return e}function kn(e){return ln(In({},e))}function Dn(e){return Un.expr(kn(e))}var Mn={};function Tn(e,t,n){return t<=e&&e<=n}function On(e){if(void 0===e)return{};if(e===Object(e))return e;throw TypeError("Could not convert argument to dictionary")}function Ln(e){this.tokens=[].slice.call(e)}Mn.Offset,Mn.Table,Mn.SIZEOF_SHORT=2,Mn.SIZEOF_INT=4,Mn.FILE_IDENTIFIER_LENGTH=4,Mn.Encoding={UTF8_BYTES:1,UTF16_STRING:2},Mn.int32=new Int32Array(2),Mn.float32=new Float32Array(Mn.int32.buffer),Mn.float64=new Float64Array(Mn.int32.buffer),Mn.isLittleEndian=1===new Uint16Array(new Uint8Array([1,0]).buffer)[0],Mn.Long=function(e,t){this.low=0|e,this.high=0|t},Mn.Long.create=function(e,t){return 0==e&&0==t?Mn.Long.ZERO:new Mn.Long(e,t)},Mn.Long.prototype.toFloat64=function(){return(this.low>>>0)+4294967296*this.high},Mn.Long.prototype.equals=function(e){return this.low==e.low&&this.high==e.high},Mn.Long.ZERO=new Mn.Long(0,0),Mn.Builder=function(e){if(e)t=e;else var t=1024;this.bb=Mn.ByteBuffer.allocate(t),this.space=t,this.minalign=1,this.vtable=null,this.vtable_in_use=0,this.isNested=!1,this.object_start=0,this.vtables=[],this.vector_num_elems=0,this.force_defaults=!1},Mn.Builder.prototype.clear=function(){this.bb.clear(),this.space=this.bb.capacity(),this.minalign=1,this.vtable=null,this.vtable_in_use=0,this.isNested=!1,this.object_start=0,this.vtables=[],this.vector_num_elems=0,this.force_defaults=!1},Mn.Builder.prototype.forceDefaults=function(e){this.force_defaults=e},Mn.Builder.prototype.dataBuffer=function(){return this.bb},Mn.Builder.prototype.asUint8Array=function(){return this.bb.bytes().subarray(this.bb.position(),this.bb.position()+this.offset())},Mn.Builder.prototype.prep=function(e,t){e>this.minalign&&(this.minalign=e);for(var n=1+~(this.bb.capacity()-this.space+t)&e-1;this.space<n+e+t;){var r=this.bb.capacity();this.bb=Mn.Builder.growByteBuffer(this.bb),this.space+=this.bb.capacity()-r}this.pad(n)},Mn.Builder.prototype.pad=function(e){for(var t=0;t<e;t++)this.bb.writeInt8(--this.space,0)},Mn.Builder.prototype.writeInt8=function(e){this.bb.writeInt8(this.space-=1,e)},Mn.Builder.prototype.writeInt16=function(e){this.bb.writeInt16(this.space-=2,e)},Mn.Builder.prototype.writeInt32=function(e){this.bb.writeInt32(this.space-=4,e)},Mn.Builder.prototype.writeInt64=function(e){this.bb.writeInt64(this.space-=8,e)},Mn.Builder.prototype.writeFloat32=function(e){this.bb.writeFloat32(this.space-=4,e)},Mn.Builder.prototype.writeFloat64=function(e){this.bb.writeFloat64(this.space-=8,e)},Mn.Builder.prototype.addInt8=function(e){this.prep(1,0),this.writeInt8(e)},Mn.Builder.prototype.addInt16=function(e){this.prep(2,0),this.writeInt16(e)},Mn.Builder.prototype.addInt32=function(e){this.prep(4,0),this.writeInt32(e)},Mn.Builder.prototype.addInt64=function(e){this.prep(8,0),this.writeInt64(e)},Mn.Builder.prototype.addFloat32=function(e){this.prep(4,0),this.writeFloat32(e)},Mn.Builder.prototype.addFloat64=function(e){this.prep(8,0),this.writeFloat64(e)},Mn.Builder.prototype.addFieldInt8=function(e,t,n){(this.force_defaults||t!=n)&&(this.addInt8(t),this.slot(e))},Mn.Builder.prototype.addFieldInt16=function(e,t,n){(this.force_defaults||t!=n)&&(this.addInt16(t),this.slot(e))},Mn.Builder.prototype.addFieldInt32=function(e,t,n){(this.force_defaults||t!=n)&&(this.addInt32(t),this.slot(e))},Mn.Builder.prototype.addFieldInt64=function(e,t,n){!this.force_defaults&&t.equals(n)||(this.addInt64(t),this.slot(e))},Mn.Builder.prototype.addFieldFloat32=function(e,t,n){(this.force_defaults||t!=n)&&(this.addFloat32(t),this.slot(e))},Mn.Builder.prototype.addFieldFloat64=function(e,t,n){(this.force_defaults||t!=n)&&(this.addFloat64(t),this.slot(e))},Mn.Builder.prototype.addFieldOffset=function(e,t,n){(this.force_defaults||t!=n)&&(this.addOffset(t),this.slot(e))},Mn.Builder.prototype.addFieldStruct=function(e,t,n){t!=n&&(this.nested(t),this.slot(e))},Mn.Builder.prototype.nested=function(e){if(e!=this.offset())throw new Error("FlatBuffers: struct must be serialized inline.")},Mn.Builder.prototype.notNested=function(){if(this.isNested)throw new Error("FlatBuffers: object serialization must not be nested.")},Mn.Builder.prototype.slot=function(e){this.vtable[e]=this.offset()},Mn.Builder.prototype.offset=function(){return this.bb.capacity()-this.space},Mn.Builder.growByteBuffer=function(e){var t=e.capacity();if(3221225472&t)throw new Error("FlatBuffers: cannot grow buffer beyond 2 gigabytes.");var n=t<<1,r=Mn.ByteBuffer.allocate(n);return r.setPosition(n-t),r.bytes().set(e.bytes(),n-t),r},Mn.Builder.prototype.addOffset=function(e){this.prep(Mn.SIZEOF_INT,0),this.writeInt32(this.offset()-e+Mn.SIZEOF_INT)},Mn.Builder.prototype.startObject=function(e){this.notNested(),null==this.vtable&&(this.vtable=[]),this.vtable_in_use=e;for(var t=0;t<e;t++)this.vtable[t]=0;this.isNested=!0,this.object_start=this.offset()},Mn.Builder.prototype.endObject=function(){if(null==this.vtable||!this.isNested)throw new Error("FlatBuffers: endObject called without startObject");this.addInt32(0);for(var e=this.offset(),t=this.vtable_in_use-1;t>=0&&0==this.vtable[t];t--);for(var n=t+1;t>=0;t--)this.addInt16(0!=this.vtable[t]?e-this.vtable[t]:0);this.addInt16(e-this.object_start);var r=(n+2)*Mn.SIZEOF_SHORT;this.addInt16(r);var A=0,i=this.space;e:for(t=0;t<this.vtables.length;t++){var s=this.bb.capacity()-this.vtables[t];if(r==this.bb.readInt16(s)){for(var a=Mn.SIZEOF_SHORT;a<r;a+=Mn.SIZEOF_SHORT)if(this.bb.readInt16(i+a)!=this.bb.readInt16(s+a))continue e;A=this.vtables[t];break}}return A?(this.space=this.bb.capacity()-e,this.bb.writeInt32(this.space,A-e)):(this.vtables.push(this.offset()),this.bb.writeInt32(this.bb.capacity()-e,this.offset()-e)),this.isNested=!1,e},Mn.Builder.prototype.finish=function(e,t){if(t){var n=t;if(this.prep(this.minalign,Mn.SIZEOF_INT+Mn.FILE_IDENTIFIER_LENGTH),n.length!=Mn.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: file identifier must be length "+Mn.FILE_IDENTIFIER_LENGTH);for(var r=Mn.FILE_IDENTIFIER_LENGTH-1;r>=0;r--)this.writeInt8(n.charCodeAt(r))}this.prep(this.minalign,Mn.SIZEOF_INT),this.addOffset(e),this.bb.setPosition(this.space)},Mn.Builder.prototype.requiredField=function(e,t){var n=this.bb.capacity()-e,r=n-this.bb.readInt32(n);if(0==this.bb.readInt16(r+t))throw new Error("FlatBuffers: field "+t+" must be set")},Mn.Builder.prototype.startVector=function(e,t,n){this.notNested(),this.vector_num_elems=t,this.prep(Mn.SIZEOF_INT,e*t),this.prep(n,e*t)},Mn.Builder.prototype.endVector=function(){return this.writeInt32(this.vector_num_elems),this.offset()},Mn.Builder.prototype.createString=function(e){if(e instanceof Uint8Array)var t=e;else{t=[];for(var n=0;n<e.length;){var r,A=e.charCodeAt(n++);(r=A<55296||A>=56320?A:(A<<10)+e.charCodeAt(n++)+-56613888)<128?t.push(r):(r<2048?t.push(r>>6&31|192):(r<65536?t.push(r>>12&15|224):t.push(r>>18&7|240,r>>12&63|128),t.push(r>>6&63|128)),t.push(63&r|128))}}this.addInt8(0),this.startVector(1,t.length,1),this.bb.setPosition(this.space-=t.length),n=0;for(var i=this.space,s=this.bb.bytes();n<t.length;n++)s[i++]=t[n];return this.endVector()},Mn.Builder.prototype.createLong=function(e,t){return Mn.Long.create(e,t)},Mn.ByteBuffer=function(e){this.bytes_=e,this.position_=0},Mn.ByteBuffer.allocate=function(e){return new Mn.ByteBuffer(new Uint8Array(e))},Mn.ByteBuffer.prototype.clear=function(){this.position_=0},Mn.ByteBuffer.prototype.bytes=function(){return this.bytes_},Mn.ByteBuffer.prototype.position=function(){return this.position_},Mn.ByteBuffer.prototype.setPosition=function(e){this.position_=e},Mn.ByteBuffer.prototype.capacity=function(){return this.bytes_.length},Mn.ByteBuffer.prototype.readInt8=function(e){return this.readUint8(e)<<24>>24},Mn.ByteBuffer.prototype.readUint8=function(e){return this.bytes_[e]},Mn.ByteBuffer.prototype.readInt16=function(e){return this.readUint16(e)<<16>>16},Mn.ByteBuffer.prototype.readUint16=function(e){return this.bytes_[e]|this.bytes_[e+1]<<8},Mn.ByteBuffer.prototype.readInt32=function(e){return this.bytes_[e]|this.bytes_[e+1]<<8|this.bytes_[e+2]<<16|this.bytes_[e+3]<<24},Mn.ByteBuffer.prototype.readUint32=function(e){return this.readInt32(e)>>>0},Mn.ByteBuffer.prototype.readInt64=function(e){return new Mn.Long(this.readInt32(e),this.readInt32(e+4))},Mn.ByteBuffer.prototype.readUint64=function(e){return new Mn.Long(this.readUint32(e),this.readUint32(e+4))},Mn.ByteBuffer.prototype.readFloat32=function(e){return Mn.int32[0]=this.readInt32(e),Mn.float32[0]},Mn.ByteBuffer.prototype.readFloat64=function(e){return Mn.int32[Mn.isLittleEndian?0:1]=this.readInt32(e),Mn.int32[Mn.isLittleEndian?1:0]=this.readInt32(e+4),Mn.float64[0]},Mn.ByteBuffer.prototype.writeInt8=function(e,t){this.bytes_[e]=t},Mn.ByteBuffer.prototype.writeUint8=function(e,t){this.bytes_[e]=t},Mn.ByteBuffer.prototype.writeInt16=function(e,t){this.bytes_[e]=t,this.bytes_[e+1]=t>>8},Mn.ByteBuffer.prototype.writeUint16=function(e,t){this.bytes_[e]=t,this.bytes_[e+1]=t>>8},Mn.ByteBuffer.prototype.writeInt32=function(e,t){this.bytes_[e]=t,this.bytes_[e+1]=t>>8,this.bytes_[e+2]=t>>16,this.bytes_[e+3]=t>>24},Mn.ByteBuffer.prototype.writeUint32=function(e,t){this.bytes_[e]=t,this.bytes_[e+1]=t>>8,this.bytes_[e+2]=t>>16,this.bytes_[e+3]=t>>24},Mn.ByteBuffer.prototype.writeInt64=function(e,t){this.writeInt32(e,t.low),this.writeInt32(e+4,t.high)},Mn.ByteBuffer.prototype.writeUint64=function(e,t){this.writeUint32(e,t.low),this.writeUint32(e+4,t.high)},Mn.ByteBuffer.prototype.writeFloat32=function(e,t){Mn.float32[0]=t,this.writeInt32(e,Mn.int32[0])},Mn.ByteBuffer.prototype.writeFloat64=function(e,t){Mn.float64[0]=t,this.writeInt32(e,Mn.int32[Mn.isLittleEndian?0:1]),this.writeInt32(e+4,Mn.int32[Mn.isLittleEndian?1:0])},Mn.ByteBuffer.prototype.getBufferIdentifier=function(){if(this.bytes_.length<this.position_+Mn.SIZEOF_INT+Mn.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: ByteBuffer is too short to contain an identifier.");for(var e="",t=0;t<Mn.FILE_IDENTIFIER_LENGTH;t++)e+=String.fromCharCode(this.readInt8(this.position_+Mn.SIZEOF_INT+t));return e},Mn.ByteBuffer.prototype.__offset=function(e,t){var n=e-this.readInt32(e);return t<this.readInt16(n)?this.readInt16(n+t):0},Mn.ByteBuffer.prototype.__union=function(e,t){return e.bb_pos=t+this.readInt32(t),e.bb=this,e},Mn.ByteBuffer.prototype.__string=function(e,t){e+=this.readInt32(e);var n=this.readInt32(e),r="",A=0;if(e+=Mn.SIZEOF_INT,t===Mn.Encoding.UTF8_BYTES)return this.bytes_.subarray(e,e+n);for(;A<n;){var i,s=this.readUint8(e+A++);if(s<192)i=s;else{var a=this.readUint8(e+A++);if(s<224)i=(31&s)<<6|63&a;else{var o=this.readUint8(e+A++);i=s<240?(15&s)<<12|(63&a)<<6|63&o:(7&s)<<18|(63&a)<<12|(63&o)<<6|63&this.readUint8(e+A++)}}i<65536?r+=String.fromCharCode(i):(i-=65536,r+=String.fromCharCode(55296+(i>>10),56320+(1023&i)))}return r},Mn.ByteBuffer.prototype.__indirect=function(e){return e+this.readInt32(e)},Mn.ByteBuffer.prototype.__vector=function(e){return e+this.readInt32(e)+Mn.SIZEOF_INT},Mn.ByteBuffer.prototype.__vector_len=function(e){return this.readInt32(e+this.readInt32(e))},Mn.ByteBuffer.prototype.__has_identifier=function(e){if(e.length!=Mn.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: file identifier must be length "+Mn.FILE_IDENTIFIER_LENGTH);for(var t=0;t<Mn.FILE_IDENTIFIER_LENGTH;t++)if(e.charCodeAt(t)!=this.readInt8(this.position_+Mn.SIZEOF_INT+t))return!1;return!0},Mn.ByteBuffer.prototype.createLong=function(e,t){return Mn.Long.create(e,t)},Ln.prototype={endOfStream:function(){return!this.tokens.length},read:function(){return this.tokens.length?this.tokens.shift():-1},prepend:function(e){if(Array.isArray(e))for(var t=e;t.length;)this.tokens.unshift(t.pop());else this.tokens.unshift(e)},push:function(e){if(Array.isArray(e))for(var t=e;t.length;)this.tokens.push(t.shift());else this.tokens.push(e)}};var Pn=-1;function Hn(e,t){if(e)throw TypeError("Decoder error");return t||65533}var Rn="utf-8";function Nn(e,t){if(!(this instanceof Nn))return new Nn(e,t);if((e=void 0!==e?String(e).toLowerCase():Rn)!==Rn)throw new Error("Encoding not supported. Only utf-8 is supported");t=On(t),this._streaming=!1,this._BOMseen=!1,this._decoder=null,this._fatal=Boolean(t.fatal),this._ignoreBOM=Boolean(t.ignoreBOM),Object.defineProperty(this,"encoding",{value:"utf-8"}),Object.defineProperty(this,"fatal",{value:this._fatal}),Object.defineProperty(this,"ignoreBOM",{value:this._ignoreBOM})}function Vn(e,t){if(!(this instanceof Vn))return new Vn(e,t);if((e=void 0!==e?String(e).toLowerCase():Rn)!==Rn)throw new Error("Encoding not supported. Only utf-8 is supported");t=On(t),this._streaming=!1,this._encoder=null,this._options={fatal:Boolean(t.fatal)},Object.defineProperty(this,"encoding",{value:"utf-8"})}function Kn(e){var t=e.fatal,n=0,r=0,A=0,i=128,s=191;this.handler=function(e,a){if(-1===a&&0!==A)return A=0,Hn(t);if(-1===a)return Pn;if(0===A){if(Tn(a,0,127))return a;if(Tn(a,194,223))A=1,n=a-192;else if(Tn(a,224,239))224===a&&(i=160),237===a&&(s=159),A=2,n=a-224;else{if(!Tn(a,240,244))return Hn(t);240===a&&(i=144),244===a&&(s=143),A=3,n=a-240}return n<<=6*A,null}if(!Tn(a,i,s))return n=A=r=0,i=128,s=191,e.prepend(a),Hn(t);if(i=128,s=191,n+=a-128<<6*(A-(r+=1)),r!==A)return null;var o=n;return n=A=r=0,o}}function jn(e){e.fatal,this.handler=function(e,t){if(-1===t)return Pn;if(Tn(t,0,127))return t;var n,r;Tn(t,128,2047)?(n=1,r=192):Tn(t,2048,65535)?(n=2,r=224):Tn(t,65536,1114111)&&(n=3,r=240);for(var A=[(t>>6*n)+r];n>0;){var i=t>>6*(n-1);A.push(128|63&i),n-=1}return A}}Nn.prototype={decode:function(e,t){var n;n="object"==typeof e&&e instanceof ArrayBuffer?new Uint8Array(e):"object"==typeof e&&"buffer"in e&&e.buffer instanceof ArrayBuffer?new Uint8Array(e.buffer,e.byteOffset,e.byteLength):new Uint8Array(0),t=On(t),this._streaming||(this._decoder=new Kn({fatal:this._fatal}),this._BOMseen=!1),this._streaming=Boolean(t.stream);for(var r,A=new Ln(n),i=[];!A.endOfStream()&&(r=this._decoder.handler(A,A.read()))!==Pn;)null!==r&&(Array.isArray(r)?i.push.apply(i,r):i.push(r));if(!this._streaming){do{if((r=this._decoder.handler(A,A.read()))===Pn)break;null!==r&&(Array.isArray(r)?i.push.apply(i,r):i.push(r))}while(!A.endOfStream());this._decoder=null}return i.length&&(-1===["utf-8"].indexOf(this.encoding)||this._ignoreBOM||this._BOMseen||(65279===i[0]?(this._BOMseen=!0,i.shift()):this._BOMseen=!0)),function(e){for(var t="",n=0;n<e.length;++n){var r=e[n];r<=65535?t+=String.fromCharCode(r):(r-=65536,t+=String.fromCharCode(55296+(r>>10),56320+(1023&r)))}return t}(i)}},Vn.prototype={encode:function(e,t){e=e?String(e):"",t=On(t),this._streaming||(this._encoder=new jn(this._options)),this._streaming=Boolean(t.stream);for(var n,r=[],A=new Ln(function(e){for(var t=String(e),n=t.length,r=0,A=[];r<n;){var i=t.charCodeAt(r);if(i<55296||i>57343)A.push(i);else if(56320<=i&&i<=57343)A.push(65533);else if(55296<=i&&i<=56319)if(r===n-1)A.push(65533);else{var s=e.charCodeAt(r+1);if(56320<=s&&s<=57343){var a=1023&i,o=1023&s;A.push(65536+(a<<10)+o),r+=1}else A.push(65533)}r+=1}return A}(e));!A.endOfStream()&&(n=this._encoder.handler(A,A.read()))!==Pn;)Array.isArray(n)?r.push.apply(r,n):r.push(n);if(!this._streaming){for(;(n=this._encoder.handler(A,A.read()))!==Pn;)Array.isArray(n)?r.push.apply(r,n):r.push(n);this._encoder=null}return new Uint8Array(r)}};const $n="function"==typeof Buffer?Buffer:null,Gn="function"==typeof TextDecoder&&"function"==typeof TextEncoder,zn=(e=>{if(Gn||!$n){const t=new e("utf-8");return e=>t.decode(e)}return e=>{const{buffer:t,byteOffset:n,length:r}=Ur(e);return $n.from(t,n,r).toString()}})("undefined"!=typeof TextDecoder?TextDecoder:Nn),Wn=(e=>{if(Gn||!$n){const t=new e;return e=>t.encode(e)}return(e="")=>Ur($n.from(e,"utf8"))})("undefined"!=typeof TextEncoder?TextEncoder:Vn),qn=Object.freeze({done:!0,value:void 0});class Jn{constructor(e){this._json=e}get schema(){return this._json.schema}get batches(){return this._json.batches||[]}get dictionaries(){return this._json.dictionaries||[]}}class Yn{tee(){return this._getDOMStream().tee()}pipe(e,t){return this._getNodeStream().pipe(e,t)}pipeTo(e,t){return this._getDOMStream().pipeTo(e,t)}pipeThrough(e,t){return this._getDOMStream().pipeThrough(e,t)}_getDOMStream(){return this._DOMStream||(this._DOMStream=this.toDOMStream())}_getNodeStream(){return this._nodeStream||(this._nodeStream=this.toNodeStream())}}class Xn extends Yn{constructor(){super(),this._values=[],this.resolvers=[],this._closedPromise=new Promise((e=>this._closedPromiseResolve=e))}get closed(){return this._closedPromise}async cancel(e){await this.return(e)}write(e){this._ensureOpen()&&(this.resolvers.length<=0?this._values.push(e):this.resolvers.shift().resolve({done:!1,value:e}))}abort(e){this._closedPromiseResolve&&(this.resolvers.length<=0?this._error={error:e}:this.resolvers.shift().reject({done:!0,value:e}))}close(){if(this._closedPromiseResolve){const{resolvers:e}=this;for(;e.length>0;)e.shift().resolve(qn);this._closedPromiseResolve(),this._closedPromiseResolve=void 0}}[Symbol.asyncIterator](){return this}toDOMStream(e){return nA.toDOMStream(this._closedPromiseResolve||this._error?this:this._values,e)}toNodeStream(e){return nA.toNodeStream(this._closedPromiseResolve||this._error?this:this._values,e)}async throw(e){return await this.abort(e),qn}async return(e){return await this.close(),qn}async read(e){return(await this.next(e,"read")).value}async peek(e){return(await this.next(e,"peek")).value}next(...e){return this._values.length>0?Promise.resolve({done:!1,value:this._values.shift()}):this._error?Promise.reject({done:!0,value:this._error.error}):this._closedPromiseResolve?new Promise(((e,t)=>{this.resolvers.push({resolve:e,reject:t})})):Promise.resolve(qn)}_ensureOpen(){if(this._closedPromiseResolve)return!0;throw new Error(`${this} is closed`)}}const[Zn,er]=(()=>{const e=()=>{throw new Error("BigInt is not available in this environment")};function t(){throw e()}return t.asIntN=()=>{throw e()},t.asUintN=()=>{throw e()},"undefined"!=typeof BigInt?[BigInt,!0]:[t,!1]})(),[tr,nr]=(()=>{const e=()=>{throw new Error("BigInt64Array is not available in this environment")};return"undefined"!=typeof BigInt64Array?[BigInt64Array,!0]:[class{static get BYTES_PER_ELEMENT(){return 8}static of(){throw e()}static from(){throw e()}constructor(){throw e()}},!1]})(),[rr,Ar]=(()=>{const e=()=>{throw new Error("BigUint64Array is not available in this environment")};return"undefined"!=typeof BigUint64Array?[BigUint64Array,!0]:[class{static get BYTES_PER_ELEMENT(){return 8}static of(){throw e()}static from(){throw e()}constructor(){throw e()}},!1]})(),ir=e=>"boolean"==typeof e,sr=e=>"function"==typeof e,ar=e=>null!=e&&Object(e)===e,or=e=>ar(e)&&sr(e.then),cr=e=>ar(e)&&sr(e[Symbol.iterator]),lr=e=>ar(e)&&sr(e[Symbol.asyncIterator]),ur=e=>ar(e)&&ar(e.schema),hr=e=>ar(e)&&"done"in e&&"value"in e,dr=e=>ar(e)&&sr(e.stat)&&(e=>"number"==typeof e)(e.fd),fr=e=>ar(e)&&pr(e.body),pr=e=>ar(e)&&sr(e.cancel)&&sr(e.getReader)&&!(e instanceof Yn),gr=e=>ar(e)&&sr(e.read)&&sr(e.pipe)&&ir(e.readable)&&!(e instanceof Yn);var mr=Mn.ByteBuffer;const yr="undefined"!=typeof SharedArrayBuffer?SharedArrayBuffer:ArrayBuffer;function wr(e,t,n=0,r=t.byteLength){const A=e.byteLength,i=new Uint8Array(e.buffer,e.byteOffset,A),s=new Uint8Array(t.buffer,t.byteOffset,Math.min(r,A));return i.set(s,n),e}function vr(e,t){let n,r,A,i=function(e){let t,n,r,A,i=e[0]?[e[0]]:[];for(let s,a,o=0,c=0,l=e.length;++o<l;)s=i[c],a=e[o],!s||!a||s.buffer!==a.buffer||a.byteOffset<s.byteOffset?a&&(i[++c]=a):(({byteOffset:t,byteLength:r}=s),({byteOffset:n,byteLength:A}=a),t+r<n||n+A<t?a&&(i[++c]=a):i[c]=new Uint8Array(s.buffer,t,n-t+A));return i}(e),s=i.reduce(((e,t)=>e+t.byteLength),0),a=0,o=-1,c=Math.min(t||1/0,s);for(let e=i.length;++o<e;){if(n=i[o],r=n.subarray(0,Math.min(n.length,c-a)),c<=a+r.length){r.length<n.length?i[o]=n.subarray(r.length):r.length===n.length&&o++,A?wr(A,r,a):A=r;break}wr(A||(A=new Uint8Array(c)),r,a),a+=r.length}return[A||new Uint8Array(0),i.slice(o),s-(A?A.byteLength:0)]}function Br(e,t){let n=hr(t)?t.value:t;return n instanceof e?e===Uint8Array?new e(n.buffer,n.byteOffset,n.byteLength):n:n?("string"==typeof n&&(n=Wn(n)),n instanceof ArrayBuffer||n instanceof yr?new e(n):n instanceof mr?Br(e,n.bytes()):ArrayBuffer.isView(n)?n.byteLength<=0?new e(0):new e(n.buffer,n.byteOffset,n.byteLength/e.BYTES_PER_ELEMENT):e.from(n)):new e(0)}const br=e=>Br(Int8Array,e),_r=e=>Br(Int16Array,e),Cr=e=>Br(Int32Array,e),xr=e=>Br(tr,e),Ur=e=>Br(Uint8Array,e),Fr=e=>Br(Uint16Array,e),Er=e=>Br(Uint32Array,e),Qr=e=>Br(rr,e),Sr=e=>Br(Float32Array,e),Ir=e=>Br(Float64Array,e),kr=e=>Br(Uint8ClampedArray,e),Dr=e=>(e.next(),e);function*Mr(e,t){const n=function*(e){yield e},r="string"==typeof t||ArrayBuffer.isView(t)||t instanceof ArrayBuffer||t instanceof yr?n(t):cr(t)?t:n(t);return yield*Dr(function*(t){let n=null;do{n=t.next(yield Br(e,n))}while(!n.done)}(r[Symbol.iterator]())),new e}const Tr=e=>Mr(Int8Array,e),Or=e=>Mr(Int16Array,e),Lr=e=>Mr(Int32Array,e),Pr=e=>Mr(Uint8Array,e),Hr=e=>Mr(Uint16Array,e),Rr=e=>Mr(Uint32Array,e),Nr=e=>Mr(Float32Array,e),Vr=e=>Mr(Float64Array,e),Kr=e=>Mr(Uint8ClampedArray,e);async function*jr(e,t){if(or(t))return yield*jr(e,await t);const n=async function*(e){yield await e},r="string"==typeof t||ArrayBuffer.isView(t)||t instanceof ArrayBuffer||t instanceof yr?n(t):cr(t)?async function*(e){yield*Dr(function*(e){let t=null;do{t=e.next(yield t&&t.value)}while(!t.done)}(e[Symbol.iterator]()))}(t):lr(t)?t:n(t);return yield*Dr(async function*(t){let n=null;do{n=await t.next(yield Br(e,n))}while(!n.done)}(r[Symbol.asyncIterator]())),new e}const $r=e=>jr(Int8Array,e),Gr=e=>jr(Int16Array,e),zr=e=>jr(Int32Array,e),Wr=e=>jr(Uint8Array,e),qr=e=>jr(Uint16Array,e),Jr=e=>jr(Uint32Array,e),Yr=e=>jr(Float32Array,e),Xr=e=>jr(Float64Array,e),Zr=e=>jr(Uint8ClampedArray,e);function eA(e,t,n){if(0!==e){n=n.slice(0,t+1);for(let r=-1;++r<=t;)n[r]+=e}return n}function tA(e,t){let n=0,r=e.length;if(r!==t.length)return!1;if(r>0)do{if(e[n]!==t[n])return!1}while(++n<r);return!0}const nA={fromIterable:e=>rA(function*(e){let t,n,r,A,i=!1,s=[],a=0;({cmd:r,size:A}=yield null);let o=Pr(e)[Symbol.iterator]();try{do{if(({done:t,value:n}=isNaN(A-a)?o.next(void 0):o.next(A-a)),!t&&n.byteLength>0&&(s.push(n),a+=n.byteLength),t||A<=a)do{({cmd:r,size:A}=yield"peek"===r?vr(s,A)[0]:([n,s,a]=vr(s,A),n))}while(A<a)}while(!t)}catch(e){(i=!0)&&"function"==typeof o.throw&&o.throw(e)}finally{!1===i&&"function"==typeof o.return&&o.return(null)}return null}(e)),fromAsyncIterable:e=>rA(async function*(e){let t,n,r,A,i=!1,s=[],a=0;({cmd:r,size:A}=yield null);let o=Wr(e)[Symbol.asyncIterator]();try{do{if(({done:t,value:n}=isNaN(A-a)?await o.next(void 0):await o.next(A-a)),!t&&n.byteLength>0&&(s.push(n),a+=n.byteLength),t||A<=a)do{({cmd:r,size:A}=yield"peek"===r?vr(s,A)[0]:([n,s,a]=vr(s,A),n))}while(A<a)}while(!t)}catch(e){(i=!0)&&"function"==typeof o.throw&&await o.throw(e)}finally{!1===i&&"function"==typeof o.return&&await o.return(new Uint8Array(0))}return null}(e)),fromDOMStream:e=>rA(async function*(e){let t,n,r,A=!1,i=!1,s=[],a=0;({cmd:n,size:r}=yield null);let o=new AA(e);try{do{if(({done:A,value:t}=isNaN(r-a)?await o.read(void 0):await o.read(r-a)),!A&&t.byteLength>0&&(s.push(Ur(t)),a+=t.byteLength),A||r<=a)do{({cmd:n,size:r}=yield"peek"===n?vr(s,r)[0]:([t,s,a]=vr(s,r),t))}while(r<a)}while(!A)}catch(e){(i=!0)&&await o.cancel(e)}finally{!1===i?await o.cancel():e.locked&&o.releaseLock()}return null}(e)),fromNodeStream:e=>rA(async function*(e){let t,n,r,A=[],i="error",s=!1,a=null,o=0,c=[];if(({cmd:t,size:n}=yield null),e.isTTY)return yield new Uint8Array(0),null;try{A[0]=sA(e,"end"),A[1]=sA(e,"error");do{if(A[2]=sA(e,"readable"),[i,a]=await Promise.race(A.map((e=>e[2]))),"error"===i)break;if((s="end"===i)||(isFinite(n-o)?(r=Ur(e.read(n-o)),r.byteLength<n-o&&(r=Ur(e.read(void 0)))):r=Ur(e.read(void 0)),r.byteLength>0&&(c.push(r),o+=r.byteLength)),s||n<=o)do{({cmd:t,size:n}=yield"peek"===t?vr(c,n)[0]:([r,c,o]=vr(c,n),r))}while(n<o)}while(!s)}finally{await function(t,n){return r=c=null,new Promise((async(r,A)=>{for(const[n,r]of t)e.off(n,r);try{const t=e.destroy;t&&t.call(e,n),n=void 0}catch(e){n=e||n}finally{null!=n?A(n):r()}}))}(A,"error"===i?a:null)}return null}(e)),toDOMStream(e,t){throw new Error('"toDOMStream" not available in this environment')},toNodeStream(e,t){throw new Error('"toNodeStream" not available in this environment')}},rA=e=>(e.next(),e);class AA{constructor(e){this.source=e,this.byobReader=null,this.defaultReader=null;try{this.supportsBYOB=!!(this.reader=this.getBYOBReader())}catch(e){this.supportsBYOB=!(this.reader=this.getDefaultReader())}}get closed(){return this.reader?this.reader.closed.catch((()=>{})):Promise.resolve()}releaseLock(){this.reader&&this.reader.releaseLock(),this.reader=this.byobReader=this.defaultReader=null}async cancel(e){const{reader:t,source:n}=this;t&&await t.cancel(e).catch((()=>{})),n&&n.locked&&this.releaseLock()}async read(e){if(0===e)return{done:null==this.reader,value:new Uint8Array(0)};const t=this.supportsBYOB&&"number"==typeof e?await this.readFromBYOBReader(e):await this.getDefaultReader().read();return!t.done&&(t.value=Ur(t)),t}getDefaultReader(){return this.byobReader&&this.releaseLock(),this.defaultReader||(this.defaultReader=this.source.getReader(),this.defaultReader.closed.catch((()=>{}))),this.reader=this.defaultReader}getBYOBReader(){return this.defaultReader&&this.releaseLock(),this.byobReader||(this.byobReader=this.source.getReader({mode:"byob"}),this.byobReader.closed.catch((()=>{}))),this.reader=this.byobReader}async readFromBYOBReader(e){return await iA(this.getBYOBReader(),new ArrayBuffer(e),0,e)}}async function iA(e,t,n,r){if(n>=r)return{done:!1,value:new Uint8Array(t,0,r)};const{done:A,value:i}=await e.read(new Uint8Array(t,n,r-n));return(n+=i.byteLength)<r&&!A?await iA(e,i.buffer,n,r):{done:A,value:new Uint8Array(i.buffer,0,n)}}const sA=(e,t)=>{let n,r=e=>n([t,e]);return[t,r,new Promise((A=>(n=A)&&e.once(t,r)))]};class aA{}var oA,cA,lA,uA,hA;aA.prototype.data=null,function(e){let t;!function(e){e[e.V1=0]="V1",e[e.V2=1]="V2",e[e.V3=2]="V3",e[e.V4=3]="V4"}(t=e.MetadataVersion||(e.MetadataVersion={}))}((cA=(lA=(uA=oA||(oA={})).apache||(uA.apache={})).arrow||(lA.arrow={})).flatbuf||(cA.flatbuf={})),function(e){!function(e){!function(e){!function(e){let t;!function(e){e[e.Sparse=0]="Sparse",e[e.Dense=1]="Dense"}(t=e.UnionMode||(e.UnionMode={}))}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){let t;!function(e){e[e.HALF=0]="HALF",e[e.SINGLE=1]="SINGLE",e[e.DOUBLE=2]="DOUBLE"}(t=e.Precision||(e.Precision={}))}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){let t;!function(e){e[e.DAY=0]="DAY",e[e.MILLISECOND=1]="MILLISECOND"}(t=e.DateUnit||(e.DateUnit={}))}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){let t;!function(e){e[e.SECOND=0]="SECOND",e[e.MILLISECOND=1]="MILLISECOND",e[e.MICROSECOND=2]="MICROSECOND",e[e.NANOSECOND=3]="NANOSECOND"}(t=e.TimeUnit||(e.TimeUnit={}))}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){let t;!function(e){e[e.YEAR_MONTH=0]="YEAR_MONTH",e[e.DAY_TIME=1]="DAY_TIME"}(t=e.IntervalUnit||(e.IntervalUnit={}))}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){let t;!function(e){e[e.NONE=0]="NONE",e[e.Null=1]="Null",e[e.Int=2]="Int",e[e.FloatingPoint=3]="FloatingPoint",e[e.Binary=4]="Binary",e[e.Utf8=5]="Utf8",e[e.Bool=6]="Bool",e[e.Decimal=7]="Decimal",e[e.Date=8]="Date",e[e.Time=9]="Time",e[e.Timestamp=10]="Timestamp",e[e.Interval=11]="Interval",e[e.List=12]="List",e[e.Struct_=13]="Struct_",e[e.Union=14]="Union",e[e.FixedSizeBinary=15]="FixedSizeBinary",e[e.FixedSizeList=16]="FixedSizeList",e[e.Map=17]="Map",e[e.Duration=18]="Duration",e[e.LargeBinary=19]="LargeBinary",e[e.LargeUtf8=20]="LargeUtf8",e[e.LargeList=21]="LargeList"}(t=e.Type||(e.Type={}))}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){let t;!function(e){e[e.Little=0]="Little",e[e.Big=1]="Big"}(t=e.Endianness||(e.Endianness={}))}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsNull(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}static startNull(e){e.startObject(0)}static endNull(e){return e.endObject()}static createNull(e){return t.startNull(e),t.endNull(e)}}e.Null=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsStruct_(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}static startStruct_(e){e.startObject(0)}static endStruct_(e){return e.endObject()}static createStruct_(e){return t.startStruct_(e),t.endStruct_(e)}}e.Struct_=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsList(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}static startList(e){e.startObject(0)}static endList(e){return e.endObject()}static createList(e){return t.startList(e),t.endList(e)}}e.List=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsLargeList(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}static startLargeList(e){e.startObject(0)}static endLargeList(e){return e.endObject()}static createLargeList(e){return t.startLargeList(e),t.endLargeList(e)}}e.LargeList=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsFixedSizeList(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}listSize(){let e=this.bb.__offset(this.bb_pos,4);return e?this.bb.readInt32(this.bb_pos+e):0}static startFixedSizeList(e){e.startObject(1)}static addListSize(e,t){e.addFieldInt32(0,t,0)}static endFixedSizeList(e){return e.endObject()}static createFixedSizeList(e,n){return t.startFixedSizeList(e),t.addListSize(e,n),t.endFixedSizeList(e)}}e.FixedSizeList=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsMap(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}keysSorted(){let e=this.bb.__offset(this.bb_pos,4);return!!e&&!!this.bb.readInt8(this.bb_pos+e)}static startMap(e){e.startObject(1)}static addKeysSorted(e,t){e.addFieldInt8(0,+t,0)}static endMap(e){return e.endObject()}static createMap(e,n){return t.startMap(e),t.addKeysSorted(e,n),t.endMap(e)}}e.Map=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsUnion(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}mode(){let t=this.bb.__offset(this.bb_pos,4);return t?this.bb.readInt16(this.bb_pos+t):e.apache.arrow.flatbuf.UnionMode.Sparse}typeIds(e){let t=this.bb.__offset(this.bb_pos,6);return t?this.bb.readInt32(this.bb.__vector(this.bb_pos+t)+4*e):0}typeIdsLength(){let e=this.bb.__offset(this.bb_pos,6);return e?this.bb.__vector_len(this.bb_pos+e):0}typeIdsArray(){let e=this.bb.__offset(this.bb_pos,6);return e?new Int32Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+e),this.bb.__vector_len(this.bb_pos+e)):null}static startUnion(e){e.startObject(2)}static addMode(t,n){t.addFieldInt16(0,n,e.apache.arrow.flatbuf.UnionMode.Sparse)}static addTypeIds(e,t){e.addFieldOffset(1,t,0)}static createTypeIdsVector(e,t){e.startVector(4,t.length,4);for(let n=t.length-1;n>=0;n--)e.addInt32(t[n]);return e.endVector()}static startTypeIdsVector(e,t){e.startVector(4,t,4)}static endUnion(e){return e.endObject()}static createUnion(e,t,r){return n.startUnion(e),n.addMode(e,t),n.addTypeIds(e,r),n.endUnion(e)}}t.Union=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsInt(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}bitWidth(){let e=this.bb.__offset(this.bb_pos,4);return e?this.bb.readInt32(this.bb_pos+e):0}isSigned(){let e=this.bb.__offset(this.bb_pos,6);return!!e&&!!this.bb.readInt8(this.bb_pos+e)}static startInt(e){e.startObject(2)}static addBitWidth(e,t){e.addFieldInt32(0,t,0)}static addIsSigned(e,t){e.addFieldInt8(1,+t,0)}static endInt(e){return e.endObject()}static createInt(e,n,r){return t.startInt(e),t.addBitWidth(e,n),t.addIsSigned(e,r),t.endInt(e)}}e.Int=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsFloatingPoint(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}precision(){let t=this.bb.__offset(this.bb_pos,4);return t?this.bb.readInt16(this.bb_pos+t):e.apache.arrow.flatbuf.Precision.HALF}static startFloatingPoint(e){e.startObject(1)}static addPrecision(t,n){t.addFieldInt16(0,n,e.apache.arrow.flatbuf.Precision.HALF)}static endFloatingPoint(e){return e.endObject()}static createFloatingPoint(e,t){return n.startFloatingPoint(e),n.addPrecision(e,t),n.endFloatingPoint(e)}}t.FloatingPoint=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsUtf8(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}static startUtf8(e){e.startObject(0)}static endUtf8(e){return e.endObject()}static createUtf8(e){return t.startUtf8(e),t.endUtf8(e)}}e.Utf8=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsBinary(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}static startBinary(e){e.startObject(0)}static endBinary(e){return e.endObject()}static createBinary(e){return t.startBinary(e),t.endBinary(e)}}e.Binary=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsLargeUtf8(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}static startLargeUtf8(e){e.startObject(0)}static endLargeUtf8(e){return e.endObject()}static createLargeUtf8(e){return t.startLargeUtf8(e),t.endLargeUtf8(e)}}e.LargeUtf8=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsLargeBinary(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}static startLargeBinary(e){e.startObject(0)}static endLargeBinary(e){return e.endObject()}static createLargeBinary(e){return t.startLargeBinary(e),t.endLargeBinary(e)}}e.LargeBinary=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsFixedSizeBinary(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}byteWidth(){let e=this.bb.__offset(this.bb_pos,4);return e?this.bb.readInt32(this.bb_pos+e):0}static startFixedSizeBinary(e){e.startObject(1)}static addByteWidth(e,t){e.addFieldInt32(0,t,0)}static endFixedSizeBinary(e){return e.endObject()}static createFixedSizeBinary(e,n){return t.startFixedSizeBinary(e),t.addByteWidth(e,n),t.endFixedSizeBinary(e)}}e.FixedSizeBinary=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsBool(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}static startBool(e){e.startObject(0)}static endBool(e){return e.endObject()}static createBool(e){return t.startBool(e),t.endBool(e)}}e.Bool=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsDecimal(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}precision(){let e=this.bb.__offset(this.bb_pos,4);return e?this.bb.readInt32(this.bb_pos+e):0}scale(){let e=this.bb.__offset(this.bb_pos,6);return e?this.bb.readInt32(this.bb_pos+e):0}static startDecimal(e){e.startObject(2)}static addPrecision(e,t){e.addFieldInt32(0,t,0)}static addScale(e,t){e.addFieldInt32(1,t,0)}static endDecimal(e){return e.endObject()}static createDecimal(e,n,r){return t.startDecimal(e),t.addPrecision(e,n),t.addScale(e,r),t.endDecimal(e)}}e.Decimal=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsDate(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}unit(){let t=this.bb.__offset(this.bb_pos,4);return t?this.bb.readInt16(this.bb_pos+t):e.apache.arrow.flatbuf.DateUnit.MILLISECOND}static startDate(e){e.startObject(1)}static addUnit(t,n){t.addFieldInt16(0,n,e.apache.arrow.flatbuf.DateUnit.MILLISECOND)}static endDate(e){return e.endObject()}static createDate(e,t){return n.startDate(e),n.addUnit(e,t),n.endDate(e)}}t.Date=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsTime(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}unit(){let t=this.bb.__offset(this.bb_pos,4);return t?this.bb.readInt16(this.bb_pos+t):e.apache.arrow.flatbuf.TimeUnit.MILLISECOND}bitWidth(){let e=this.bb.__offset(this.bb_pos,6);return e?this.bb.readInt32(this.bb_pos+e):32}static startTime(e){e.startObject(2)}static addUnit(t,n){t.addFieldInt16(0,n,e.apache.arrow.flatbuf.TimeUnit.MILLISECOND)}static addBitWidth(e,t){e.addFieldInt32(1,t,32)}static endTime(e){return e.endObject()}static createTime(e,t,r){return n.startTime(e),n.addUnit(e,t),n.addBitWidth(e,r),n.endTime(e)}}t.Time=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsTimestamp(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}unit(){let t=this.bb.__offset(this.bb_pos,4);return t?this.bb.readInt16(this.bb_pos+t):e.apache.arrow.flatbuf.TimeUnit.SECOND}timezone(e){let t=this.bb.__offset(this.bb_pos,6);return t?this.bb.__string(this.bb_pos+t,e):null}static startTimestamp(e){e.startObject(2)}static addUnit(t,n){t.addFieldInt16(0,n,e.apache.arrow.flatbuf.TimeUnit.SECOND)}static addTimezone(e,t){e.addFieldOffset(1,t,0)}static endTimestamp(e){return e.endObject()}static createTimestamp(e,t,r){return n.startTimestamp(e),n.addUnit(e,t),n.addTimezone(e,r),n.endTimestamp(e)}}t.Timestamp=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsInterval(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}unit(){let t=this.bb.__offset(this.bb_pos,4);return t?this.bb.readInt16(this.bb_pos+t):e.apache.arrow.flatbuf.IntervalUnit.YEAR_MONTH}static startInterval(e){e.startObject(1)}static addUnit(t,n){t.addFieldInt16(0,n,e.apache.arrow.flatbuf.IntervalUnit.YEAR_MONTH)}static endInterval(e){return e.endObject()}static createInterval(e,t){return n.startInterval(e),n.addUnit(e,t),n.endInterval(e)}}t.Interval=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsDuration(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}unit(){let t=this.bb.__offset(this.bb_pos,4);return t?this.bb.readInt16(this.bb_pos+t):e.apache.arrow.flatbuf.TimeUnit.MILLISECOND}static startDuration(e){e.startObject(1)}static addUnit(t,n){t.addFieldInt16(0,n,e.apache.arrow.flatbuf.TimeUnit.MILLISECOND)}static endDuration(e){return e.endObject()}static createDuration(e,t){return n.startDuration(e),n.addUnit(e,t),n.endDuration(e)}}t.Duration=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){!function(e){class t{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsKeyValue(e,n){return(n||new t).__init(e.readInt32(e.position())+e.position(),e)}key(e){let t=this.bb.__offset(this.bb_pos,4);return t?this.bb.__string(this.bb_pos+t,e):null}value(e){let t=this.bb.__offset(this.bb_pos,6);return t?this.bb.__string(this.bb_pos+t,e):null}static startKeyValue(e){e.startObject(2)}static addKey(e,t){e.addFieldOffset(0,t,0)}static addValue(e,t){e.addFieldOffset(1,t,0)}static endKeyValue(e){return e.endObject()}static createKeyValue(e,n,r){return t.startKeyValue(e),t.addKey(e,n),t.addValue(e,r),t.endKeyValue(e)}}e.KeyValue=t}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsDictionaryEncoding(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}id(){let e=this.bb.__offset(this.bb_pos,4);return e?this.bb.readInt64(this.bb_pos+e):this.bb.createLong(0,0)}indexType(t){let n=this.bb.__offset(this.bb_pos,6);return n?(t||new e.apache.arrow.flatbuf.Int).__init(this.bb.__indirect(this.bb_pos+n),this.bb):null}isOrdered(){let e=this.bb.__offset(this.bb_pos,8);return!!e&&!!this.bb.readInt8(this.bb_pos+e)}static startDictionaryEncoding(e){e.startObject(3)}static addId(e,t){e.addFieldInt64(0,t,e.createLong(0,0))}static addIndexType(e,t){e.addFieldOffset(1,t,0)}static addIsOrdered(e,t){e.addFieldInt8(2,+t,0)}static endDictionaryEncoding(e){return e.endObject()}static createDictionaryEncoding(e,t,r,A){return n.startDictionaryEncoding(e),n.addId(e,t),n.addIndexType(e,r),n.addIsOrdered(e,A),n.endDictionaryEncoding(e)}}t.DictionaryEncoding=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsField(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}name(e){let t=this.bb.__offset(this.bb_pos,4);return t?this.bb.__string(this.bb_pos+t,e):null}nullable(){let e=this.bb.__offset(this.bb_pos,6);return!!e&&!!this.bb.readInt8(this.bb_pos+e)}typeType(){let t=this.bb.__offset(this.bb_pos,8);return t?this.bb.readUint8(this.bb_pos+t):e.apache.arrow.flatbuf.Type.NONE}type(e){let t=this.bb.__offset(this.bb_pos,10);return t?this.bb.__union(e,this.bb_pos+t):null}dictionary(t){let n=this.bb.__offset(this.bb_pos,12);return n?(t||new e.apache.arrow.flatbuf.DictionaryEncoding).__init(this.bb.__indirect(this.bb_pos+n),this.bb):null}children(t,n){let r=this.bb.__offset(this.bb_pos,14);return r?(n||new e.apache.arrow.flatbuf.Field).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+r)+4*t),this.bb):null}childrenLength(){let e=this.bb.__offset(this.bb_pos,14);return e?this.bb.__vector_len(this.bb_pos+e):0}customMetadata(t,n){let r=this.bb.__offset(this.bb_pos,16);return r?(n||new e.apache.arrow.flatbuf.KeyValue).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+r)+4*t),this.bb):null}customMetadataLength(){let e=this.bb.__offset(this.bb_pos,16);return e?this.bb.__vector_len(this.bb_pos+e):0}static startField(e){e.startObject(7)}static addName(e,t){e.addFieldOffset(0,t,0)}static addNullable(e,t){e.addFieldInt8(1,+t,0)}static addTypeType(t,n){t.addFieldInt8(2,n,e.apache.arrow.flatbuf.Type.NONE)}static addType(e,t){e.addFieldOffset(3,t,0)}static addDictionary(e,t){e.addFieldOffset(4,t,0)}static addChildren(e,t){e.addFieldOffset(5,t,0)}static createChildrenVector(e,t){e.startVector(4,t.length,4);for(let n=t.length-1;n>=0;n--)e.addOffset(t[n]);return e.endVector()}static startChildrenVector(e,t){e.startVector(4,t,4)}static addCustomMetadata(e,t){e.addFieldOffset(6,t,0)}static createCustomMetadataVector(e,t){e.startVector(4,t.length,4);for(let n=t.length-1;n>=0;n--)e.addOffset(t[n]);return e.endVector()}static startCustomMetadataVector(e,t){e.startVector(4,t,4)}static endField(e){return e.endObject()}static createField(e,t,r,A,i,s,a,o){return n.startField(e),n.addName(e,t),n.addNullable(e,r),n.addTypeType(e,A),n.addType(e,i),n.addDictionary(e,s),n.addChildren(e,a),n.addCustomMetadata(e,o),n.endField(e)}}t.Field=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){(e.flatbuf||(e.flatbuf={})).Buffer=class{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}offset(){return this.bb.readInt64(this.bb_pos)}length(){return this.bb.readInt64(this.bb_pos+8)}static createBuffer(e,t,n){return e.prep(8,16),e.writeInt64(n),e.writeInt64(t),e.offset()}}}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsSchema(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}endianness(){let t=this.bb.__offset(this.bb_pos,4);return t?this.bb.readInt16(this.bb_pos+t):e.apache.arrow.flatbuf.Endianness.Little}fields(t,n){let r=this.bb.__offset(this.bb_pos,6);return r?(n||new e.apache.arrow.flatbuf.Field).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+r)+4*t),this.bb):null}fieldsLength(){let e=this.bb.__offset(this.bb_pos,6);return e?this.bb.__vector_len(this.bb_pos+e):0}customMetadata(t,n){let r=this.bb.__offset(this.bb_pos,8);return r?(n||new e.apache.arrow.flatbuf.KeyValue).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+r)+4*t),this.bb):null}customMetadataLength(){let e=this.bb.__offset(this.bb_pos,8);return e?this.bb.__vector_len(this.bb_pos+e):0}static startSchema(e){e.startObject(3)}static addEndianness(t,n){t.addFieldInt16(0,n,e.apache.arrow.flatbuf.Endianness.Little)}static addFields(e,t){e.addFieldOffset(1,t,0)}static createFieldsVector(e,t){e.startVector(4,t.length,4);for(let n=t.length-1;n>=0;n--)e.addOffset(t[n]);return e.endVector()}static startFieldsVector(e,t){e.startVector(4,t,4)}static addCustomMetadata(e,t){e.addFieldOffset(2,t,0)}static createCustomMetadataVector(e,t){e.startVector(4,t.length,4);for(let n=t.length-1;n>=0;n--)e.addOffset(t[n]);return e.endVector()}static startCustomMetadataVector(e,t){e.startVector(4,t,4)}static endSchema(e){return e.endObject()}static finishSchemaBuffer(e,t){e.finish(t)}static createSchema(e,t,r,A){return n.startSchema(e),n.addEndianness(e,t),n.addFields(e,r),n.addCustomMetadata(e,A),n.endSchema(e)}}t.Schema=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(oA||(oA={})),function(e){!function(e){!function(e){(e.flatbuf||(e.flatbuf={})).Schema=oA.apache.arrow.flatbuf.Schema}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(hA||(hA={})),function(e){!function(e){!function(e){!function(e){let t;!function(e){e[e.NONE=0]="NONE",e[e.Schema=1]="Schema",e[e.DictionaryBatch=2]="DictionaryBatch",e[e.RecordBatch=3]="RecordBatch",e[e.Tensor=4]="Tensor",e[e.SparseTensor=5]="SparseTensor"}(t=e.MessageHeader||(e.MessageHeader={}))}(e.flatbuf||(e.flatbuf={}))}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(hA||(hA={})),function(e){!function(e){!function(e){(e.flatbuf||(e.flatbuf={})).FieldNode=class{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}length(){return this.bb.readInt64(this.bb_pos)}nullCount(){return this.bb.readInt64(this.bb_pos+8)}static createFieldNode(e,t,n){return e.prep(8,16),e.writeInt64(n),e.writeInt64(t),e.offset()}}}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(hA||(hA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsRecordBatch(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}length(){let e=this.bb.__offset(this.bb_pos,4);return e?this.bb.readInt64(this.bb_pos+e):this.bb.createLong(0,0)}nodes(t,n){let r=this.bb.__offset(this.bb_pos,6);return r?(n||new e.apache.arrow.flatbuf.FieldNode).__init(this.bb.__vector(this.bb_pos+r)+16*t,this.bb):null}nodesLength(){let e=this.bb.__offset(this.bb_pos,6);return e?this.bb.__vector_len(this.bb_pos+e):0}buffers(e,t){let n=this.bb.__offset(this.bb_pos,8);return n?(t||new oA.apache.arrow.flatbuf.Buffer).__init(this.bb.__vector(this.bb_pos+n)+16*e,this.bb):null}buffersLength(){let e=this.bb.__offset(this.bb_pos,8);return e?this.bb.__vector_len(this.bb_pos+e):0}static startRecordBatch(e){e.startObject(3)}static addLength(e,t){e.addFieldInt64(0,t,e.createLong(0,0))}static addNodes(e,t){e.addFieldOffset(1,t,0)}static startNodesVector(e,t){e.startVector(16,t,8)}static addBuffers(e,t){e.addFieldOffset(2,t,0)}static startBuffersVector(e,t){e.startVector(16,t,8)}static endRecordBatch(e){return e.endObject()}static createRecordBatch(e,t,r,A){return n.startRecordBatch(e),n.addLength(e,t),n.addNodes(e,r),n.addBuffers(e,A),n.endRecordBatch(e)}}t.RecordBatch=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(hA||(hA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsDictionaryBatch(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}id(){let e=this.bb.__offset(this.bb_pos,4);return e?this.bb.readInt64(this.bb_pos+e):this.bb.createLong(0,0)}data(t){let n=this.bb.__offset(this.bb_pos,6);return n?(t||new e.apache.arrow.flatbuf.RecordBatch).__init(this.bb.__indirect(this.bb_pos+n),this.bb):null}isDelta(){let e=this.bb.__offset(this.bb_pos,8);return!!e&&!!this.bb.readInt8(this.bb_pos+e)}static startDictionaryBatch(e){e.startObject(3)}static addId(e,t){e.addFieldInt64(0,t,e.createLong(0,0))}static addData(e,t){e.addFieldOffset(1,t,0)}static addIsDelta(e,t){e.addFieldInt8(2,+t,0)}static endDictionaryBatch(e){return e.endObject()}static createDictionaryBatch(e,t,r,A){return n.startDictionaryBatch(e),n.addId(e,t),n.addData(e,r),n.addIsDelta(e,A),n.endDictionaryBatch(e)}}t.DictionaryBatch=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(hA||(hA={})),function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsMessage(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}version(){let e=this.bb.__offset(this.bb_pos,4);return e?this.bb.readInt16(this.bb_pos+e):oA.apache.arrow.flatbuf.MetadataVersion.V1}headerType(){let t=this.bb.__offset(this.bb_pos,6);return t?this.bb.readUint8(this.bb_pos+t):e.apache.arrow.flatbuf.MessageHeader.NONE}header(e){let t=this.bb.__offset(this.bb_pos,8);return t?this.bb.__union(e,this.bb_pos+t):null}bodyLength(){let e=this.bb.__offset(this.bb_pos,10);return e?this.bb.readInt64(this.bb_pos+e):this.bb.createLong(0,0)}customMetadata(e,t){let n=this.bb.__offset(this.bb_pos,12);return n?(t||new oA.apache.arrow.flatbuf.KeyValue).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+n)+4*e),this.bb):null}customMetadataLength(){let e=this.bb.__offset(this.bb_pos,12);return e?this.bb.__vector_len(this.bb_pos+e):0}static startMessage(e){e.startObject(5)}static addVersion(e,t){e.addFieldInt16(0,t,oA.apache.arrow.flatbuf.MetadataVersion.V1)}static addHeaderType(t,n){t.addFieldInt8(1,n,e.apache.arrow.flatbuf.MessageHeader.NONE)}static addHeader(e,t){e.addFieldOffset(2,t,0)}static addBodyLength(e,t){e.addFieldInt64(3,t,e.createLong(0,0))}static addCustomMetadata(e,t){e.addFieldOffset(4,t,0)}static createCustomMetadataVector(e,t){e.startVector(4,t.length,4);for(let n=t.length-1;n>=0;n--)e.addOffset(t[n]);return e.endVector()}static startCustomMetadataVector(e,t){e.startVector(4,t,4)}static endMessage(e){return e.endObject()}static finishMessageBuffer(e,t){e.finish(t)}static createMessage(e,t,r,A,i,s){return n.startMessage(e),n.addVersion(e,t),n.addHeaderType(e,r),n.addHeader(e,A),n.addBodyLength(e,i),n.addCustomMetadata(e,s),n.endMessage(e)}}t.Message=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(hA||(hA={})),oA.apache.arrow.flatbuf.Type;var dA,fA,pA,gA,mA=oA.apache.arrow.flatbuf.DateUnit,yA=oA.apache.arrow.flatbuf.TimeUnit,wA=oA.apache.arrow.flatbuf.Precision,vA=oA.apache.arrow.flatbuf.UnionMode,BA=oA.apache.arrow.flatbuf.IntervalUnit,bA=hA.apache.arrow.flatbuf.MessageHeader,_A=oA.apache.arrow.flatbuf.MetadataVersion;function CA(e,t,n,r){return!!(n&1<<r)}function xA(e,t,n,r){return(n&1<<r)>>r}function UA(e,t,n){return n?!!(e[t>>3]|=1<<t%8)||!0:!(e[t>>3]&=~(1<<t%8))&&!1}function FA(e,t,n){const r=n.byteLength+7&-8;if(e>0||n.byteLength<r){const A=new Uint8Array(r);return A.set(e%8==0?n.subarray(e>>3):EA(QA(n,e,t,null,CA)).subarray(0,r)),A}return n}function EA(e){let t=[],n=0,r=0,A=0;for(const i of e)i&&(A|=1<<r),8==++r&&(t[n++]=A,A=r=0);(0===n||r>0)&&(t[n++]=A);let i=new Uint8Array(t.length+7&-8);return i.set(t),i}function*QA(e,t,n,r,A){let i=t%8,s=t>>3,a=0,o=n;for(;o>0;i=0){let t=e[s++];do{yield A(r,a++,t,i)}while(--o>0&&++i<8)}}function SA(e,t,n){if(n-t<=0)return 0;if(n-t<8){let r=0;for(const A of QA(e,t,n-t,e,xA))r+=A;return r}const r=n>>3<<3,A=t+(t%8==0?0:8-t%8);return SA(e,t,A)+SA(e,r,n)+IA(e,A>>3,r-A>>3)}function IA(e,t,n){let r=0,A=0|t;const i=new DataView(e.buffer,e.byteOffset,e.byteLength),s=void 0===n?e.byteLength:A+n;for(;s-A>=4;)r+=kA(i.getUint32(A)),A+=4;for(;s-A>=2;)r+=kA(i.getUint16(A)),A+=2;for(;s-A>=1;)r+=kA(i.getUint8(A)),A+=1;return r}function kA(e){let t=0|e;return t-=t>>>1&1431655765,t=(858993459&t)+(t>>>2&858993459),16843009*(t+(t>>>4)&252645135)>>>24}(fA=dA||(dA={}))[fA.NONE=0]="NONE",fA[fA.Null=1]="Null",fA[fA.Int=2]="Int",fA[fA.Float=3]="Float",fA[fA.Binary=4]="Binary",fA[fA.Utf8=5]="Utf8",fA[fA.Bool=6]="Bool",fA[fA.Decimal=7]="Decimal",fA[fA.Date=8]="Date",fA[fA.Time=9]="Time",fA[fA.Timestamp=10]="Timestamp",fA[fA.Interval=11]="Interval",fA[fA.List=12]="List",fA[fA.Struct=13]="Struct",fA[fA.Union=14]="Union",fA[fA.FixedSizeBinary=15]="FixedSizeBinary",fA[fA.FixedSizeList=16]="FixedSizeList",fA[fA.Map=17]="Map",fA[fA.Dictionary=-1]="Dictionary",fA[fA.Int8=-2]="Int8",fA[fA.Int16=-3]="Int16",fA[fA.Int32=-4]="Int32",fA[fA.Int64=-5]="Int64",fA[fA.Uint8=-6]="Uint8",fA[fA.Uint16=-7]="Uint16",fA[fA.Uint32=-8]="Uint32",fA[fA.Uint64=-9]="Uint64",fA[fA.Float16=-10]="Float16",fA[fA.Float32=-11]="Float32",fA[fA.Float64=-12]="Float64",fA[fA.DateDay=-13]="DateDay",fA[fA.DateMillisecond=-14]="DateMillisecond",fA[fA.TimestampSecond=-15]="TimestampSecond",fA[fA.TimestampMillisecond=-16]="TimestampMillisecond",fA[fA.TimestampMicrosecond=-17]="TimestampMicrosecond",fA[fA.TimestampNanosecond=-18]="TimestampNanosecond",fA[fA.TimeSecond=-19]="TimeSecond",fA[fA.TimeMillisecond=-20]="TimeMillisecond",fA[fA.TimeMicrosecond=-21]="TimeMicrosecond",fA[fA.TimeNanosecond=-22]="TimeNanosecond",fA[fA.DenseUnion=-23]="DenseUnion",fA[fA.SparseUnion=-24]="SparseUnion",fA[fA.IntervalDayTime=-25]="IntervalDayTime",fA[fA.IntervalYearMonth=-26]="IntervalYearMonth",(gA=pA||(pA={}))[gA.OFFSET=0]="OFFSET",gA[gA.DATA=1]="DATA",gA[gA.VALIDITY=2]="VALIDITY",gA[gA.TYPE=3]="TYPE";class DA{visitMany(e,...t){return e.map(((e,n)=>this.visit(e,...t.map((e=>e[n])))))}visit(...e){return this.getVisitFn(e[0],!1).apply(this,e)}getVisitFn(e,t=!0){return function(e,t,n=!0){let r=null,A=dA.NONE;switch(t instanceof Mi||t instanceof aA?A=MA(t.type):t instanceof GA?A=MA(t):"number"!=typeof(A=t)&&(A=dA[t]),A){case dA.Null:r=e.visitNull;break;case dA.Bool:r=e.visitBool;break;case dA.Int:r=e.visitInt;break;case dA.Int8:r=e.visitInt8||e.visitInt;break;case dA.Int16:r=e.visitInt16||e.visitInt;break;case dA.Int32:r=e.visitInt32||e.visitInt;break;case dA.Int64:r=e.visitInt64||e.visitInt;break;case dA.Uint8:r=e.visitUint8||e.visitInt;break;case dA.Uint16:r=e.visitUint16||e.visitInt;break;case dA.Uint32:r=e.visitUint32||e.visitInt;break;case dA.Uint64:r=e.visitUint64||e.visitInt;break;case dA.Float:r=e.visitFloat;break;case dA.Float16:r=e.visitFloat16||e.visitFloat;break;case dA.Float32:r=e.visitFloat32||e.visitFloat;break;case dA.Float64:r=e.visitFloat64||e.visitFloat;break;case dA.Utf8:r=e.visitUtf8;break;case dA.Binary:r=e.visitBinary;break;case dA.FixedSizeBinary:r=e.visitFixedSizeBinary;break;case dA.Date:r=e.visitDate;break;case dA.DateDay:r=e.visitDateDay||e.visitDate;break;case dA.DateMillisecond:r=e.visitDateMillisecond||e.visitDate;break;case dA.Timestamp:r=e.visitTimestamp;break;case dA.TimestampSecond:r=e.visitTimestampSecond||e.visitTimestamp;break;case dA.TimestampMillisecond:r=e.visitTimestampMillisecond||e.visitTimestamp;break;case dA.TimestampMicrosecond:r=e.visitTimestampMicrosecond||e.visitTimestamp;break;case dA.TimestampNanosecond:r=e.visitTimestampNanosecond||e.visitTimestamp;break;case dA.Time:r=e.visitTime;break;case dA.TimeSecond:r=e.visitTimeSecond||e.visitTime;break;case dA.TimeMillisecond:r=e.visitTimeMillisecond||e.visitTime;break;case dA.TimeMicrosecond:r=e.visitTimeMicrosecond||e.visitTime;break;case dA.TimeNanosecond:r=e.visitTimeNanosecond||e.visitTime;break;case dA.Decimal:r=e.visitDecimal;break;case dA.List:r=e.visitList;break;case dA.Struct:r=e.visitStruct;break;case dA.Union:r=e.visitUnion;break;case dA.DenseUnion:r=e.visitDenseUnion||e.visitUnion;break;case dA.SparseUnion:r=e.visitSparseUnion||e.visitUnion;break;case dA.Dictionary:r=e.visitDictionary;break;case dA.Interval:r=e.visitInterval;break;case dA.IntervalDayTime:r=e.visitIntervalDayTime||e.visitInterval;break;case dA.IntervalYearMonth:r=e.visitIntervalYearMonth||e.visitInterval;break;case dA.FixedSizeList:r=e.visitFixedSizeList;break;case dA.Map:r=e.visitMap}if("function"==typeof r)return r;if(!n)return()=>null;throw new Error(`Unrecognized type '${dA[A]}'`)}(this,e,t)}visitNull(e,...t){return null}visitBool(e,...t){return null}visitInt(e,...t){return null}visitFloat(e,...t){return null}visitUtf8(e,...t){return null}visitBinary(e,...t){return null}visitFixedSizeBinary(e,...t){return null}visitDate(e,...t){return null}visitTimestamp(e,...t){return null}visitTime(e,...t){return null}visitDecimal(e,...t){return null}visitList(e,...t){return null}visitStruct(e,...t){return null}visitUnion(e,...t){return null}visitDictionary(e,...t){return null}visitInterval(e,...t){return null}visitFixedSizeList(e,...t){return null}visitMap(e,...t){return null}}function MA(e){switch(e.typeId){case dA.Null:return dA.Null;case dA.Int:const{bitWidth:t,isSigned:n}=e;switch(t){case 8:return n?dA.Int8:dA.Uint8;case 16:return n?dA.Int16:dA.Uint16;case 32:return n?dA.Int32:dA.Uint32;case 64:return n?dA.Int64:dA.Uint64}return dA.Int;case dA.Float:switch(e.precision){case wA.HALF:return dA.Float16;case wA.SINGLE:return dA.Float32;case wA.DOUBLE:return dA.Float64}return dA.Float;case dA.Binary:return dA.Binary;case dA.Utf8:return dA.Utf8;case dA.Bool:return dA.Bool;case dA.Decimal:return dA.Decimal;case dA.Time:switch(e.unit){case yA.SECOND:return dA.TimeSecond;case yA.MILLISECOND:return dA.TimeMillisecond;case yA.MICROSECOND:return dA.TimeMicrosecond;case yA.NANOSECOND:return dA.TimeNanosecond}return dA.Time;case dA.Timestamp:switch(e.unit){case yA.SECOND:return dA.TimestampSecond;case yA.MILLISECOND:return dA.TimestampMillisecond;case yA.MICROSECOND:return dA.TimestampMicrosecond;case yA.NANOSECOND:return dA.TimestampNanosecond}return dA.Timestamp;case dA.Date:switch(e.unit){case mA.DAY:return dA.DateDay;case mA.MILLISECOND:return dA.DateMillisecond}return dA.Date;case dA.Interval:switch(e.unit){case BA.DAY_TIME:return dA.IntervalDayTime;case BA.YEAR_MONTH:return dA.IntervalYearMonth}return dA.Interval;case dA.Map:return dA.Map;case dA.List:return dA.List;case dA.Struct:return dA.Struct;case dA.Union:switch(e.mode){case vA.Dense:return dA.DenseUnion;case vA.Sparse:return dA.SparseUnion}return dA.Union;case dA.FixedSizeBinary:return dA.FixedSizeBinary;case dA.FixedSizeList:return dA.FixedSizeList;case dA.Dictionary:return dA.Dictionary}throw new Error(`Unrecognized type '${dA[e.typeId]}'`)}DA.prototype.visitInt8=null,DA.prototype.visitInt16=null,DA.prototype.visitInt32=null,DA.prototype.visitInt64=null,DA.prototype.visitUint8=null,DA.prototype.visitUint16=null,DA.prototype.visitUint32=null,DA.prototype.visitUint64=null,DA.prototype.visitFloat16=null,DA.prototype.visitFloat32=null,DA.prototype.visitFloat64=null,DA.prototype.visitDateDay=null,DA.prototype.visitDateMillisecond=null,DA.prototype.visitTimestampSecond=null,DA.prototype.visitTimestampMillisecond=null,DA.prototype.visitTimestampMicrosecond=null,DA.prototype.visitTimestampNanosecond=null,DA.prototype.visitTimeSecond=null,DA.prototype.visitTimeMillisecond=null,DA.prototype.visitTimeMicrosecond=null,DA.prototype.visitTimeNanosecond=null,DA.prototype.visitDenseUnion=null,DA.prototype.visitSparseUnion=null,DA.prototype.visitIntervalDayTime=null,DA.prototype.visitIntervalYearMonth=null;class TA extends DA{compareSchemas(e,t){return e===t||t instanceof e.constructor&&$A.compareFields(e.fields,t.fields)}compareFields(e,t){return e===t||Array.isArray(e)&&Array.isArray(t)&&e.length===t.length&&e.every(((e,n)=>$A.compareField(e,t[n])))}compareField(e,t){return e===t||t instanceof e.constructor&&e.name===t.name&&e.nullable===t.nullable&&$A.visit(e.type,t.type)}}function OA(e,t){return t instanceof e.constructor}function LA(e,t){return e===t||OA(e,t)}function PA(e,t){return e===t||OA(e,t)&&e.bitWidth===t.bitWidth&&e.isSigned===t.isSigned}function HA(e,t){return e===t||OA(e,t)&&e.precision===t.precision}function RA(e,t){return e===t||OA(e,t)&&e.unit===t.unit}function NA(e,t){return e===t||OA(e,t)&&e.unit===t.unit&&e.timezone===t.timezone}function VA(e,t){return e===t||OA(e,t)&&e.unit===t.unit&&e.bitWidth===t.bitWidth}function KA(e,t){return e===t||OA(e,t)&&e.mode===t.mode&&e.typeIds.every(((e,n)=>e===t.typeIds[n]))&&$A.compareFields(e.children,t.children)}function jA(e,t){return e===t||OA(e,t)&&e.unit===t.unit}TA.prototype.visitNull=LA,TA.prototype.visitBool=LA,TA.prototype.visitInt=PA,TA.prototype.visitInt8=PA,TA.prototype.visitInt16=PA,TA.prototype.visitInt32=PA,TA.prototype.visitInt64=PA,TA.prototype.visitUint8=PA,TA.prototype.visitUint16=PA,TA.prototype.visitUint32=PA,TA.prototype.visitUint64=PA,TA.prototype.visitFloat=HA,TA.prototype.visitFloat16=HA,TA.prototype.visitFloat32=HA,TA.prototype.visitFloat64=HA,TA.prototype.visitUtf8=LA,TA.prototype.visitBinary=LA,TA.prototype.visitFixedSizeBinary=function(e,t){return e===t||OA(e,t)&&e.byteWidth===t.byteWidth},TA.prototype.visitDate=RA,TA.prototype.visitDateDay=RA,TA.prototype.visitDateMillisecond=RA,TA.prototype.visitTimestamp=NA,TA.prototype.visitTimestampSecond=NA,TA.prototype.visitTimestampMillisecond=NA,TA.prototype.visitTimestampMicrosecond=NA,TA.prototype.visitTimestampNanosecond=NA,TA.prototype.visitTime=VA,TA.prototype.visitTimeSecond=VA,TA.prototype.visitTimeMillisecond=VA,TA.prototype.visitTimeMicrosecond=VA,TA.prototype.visitTimeNanosecond=VA,TA.prototype.visitDecimal=LA,TA.prototype.visitList=function(e,t){return e===t||OA(e,t)&&e.children.length===t.children.length&&$A.compareFields(e.children,t.children)},TA.prototype.visitStruct=function(e,t){return e===t||OA(e,t)&&e.children.length===t.children.length&&$A.compareFields(e.children,t.children)},TA.prototype.visitUnion=KA,TA.prototype.visitDenseUnion=KA,TA.prototype.visitSparseUnion=KA,TA.prototype.visitDictionary=function(e,t){return e===t||OA(e,t)&&e.id===t.id&&e.isOrdered===t.isOrdered&&$A.visit(e.indices,t.indices)&&$A.visit(e.dictionary,t.dictionary)},TA.prototype.visitInterval=jA,TA.prototype.visitIntervalDayTime=jA,TA.prototype.visitIntervalYearMonth=jA,TA.prototype.visitFixedSizeList=function(e,t){return e===t||OA(e,t)&&e.listSize===t.listSize&&e.children.length===t.children.length&&$A.compareFields(e.children,t.children)},TA.prototype.visitMap=function(e,t){return e===t||OA(e,t)&&e.keysSorted===t.keysSorted&&e.children.length===t.children.length&&$A.compareFields(e.children,t.children)};const $A=new TA;class GA{static isNull(e){return e&&e.typeId===dA.Null}static isInt(e){return e&&e.typeId===dA.Int}static isFloat(e){return e&&e.typeId===dA.Float}static isBinary(e){return e&&e.typeId===dA.Binary}static isUtf8(e){return e&&e.typeId===dA.Utf8}static isBool(e){return e&&e.typeId===dA.Bool}static isDecimal(e){return e&&e.typeId===dA.Decimal}static isDate(e){return e&&e.typeId===dA.Date}static isTime(e){return e&&e.typeId===dA.Time}static isTimestamp(e){return e&&e.typeId===dA.Timestamp}static isInterval(e){return e&&e.typeId===dA.Interval}static isList(e){return e&&e.typeId===dA.List}static isStruct(e){return e&&e.typeId===dA.Struct}static isUnion(e){return e&&e.typeId===dA.Union}static isFixedSizeBinary(e){return e&&e.typeId===dA.FixedSizeBinary}static isFixedSizeList(e){return e&&e.typeId===dA.FixedSizeList}static isMap(e){return e&&e.typeId===dA.Map}static isDictionary(e){return e&&e.typeId===dA.Dictionary}get typeId(){return dA.NONE}compareTo(e){return $A.visit(this,e)}}var zA;GA[Symbol.toStringTag]=((zA=GA.prototype).children=null,zA.ArrayType=Array,zA[Symbol.toStringTag]="DataType");class WA extends GA{toString(){return"Null"}get typeId(){return dA.Null}}WA[Symbol.toStringTag]=(e=>e[Symbol.toStringTag]="Null")(WA.prototype);class qA extends GA{constructor(e,t){super(),this.isSigned=e,this.bitWidth=t}get typeId(){return dA.Int}get ArrayType(){switch(this.bitWidth){case 8:return this.isSigned?Int8Array:Uint8Array;case 16:return this.isSigned?Int16Array:Uint16Array;case 32:case 64:return this.isSigned?Int32Array:Uint32Array}throw new Error(`Unrecognized ${this[Symbol.toStringTag]} type`)}toString(){return`${this.isSigned?"I":"Ui"}nt${this.bitWidth}`}}qA[Symbol.toStringTag]=(e=>(e.isSigned=null,e.bitWidth=null,e[Symbol.toStringTag]="Int"))(qA.prototype);class JA extends qA{constructor(){super(!0,8)}}class YA extends qA{constructor(){super(!0,16)}}class XA extends qA{constructor(){super(!0,32)}}class ZA extends qA{constructor(){super(!0,64)}}class ei extends qA{constructor(){super(!1,8)}}class ti extends qA{constructor(){super(!1,16)}}class ni extends qA{constructor(){super(!1,32)}}class ri extends qA{constructor(){super(!1,64)}}Object.defineProperty(JA.prototype,"ArrayType",{value:Int8Array}),Object.defineProperty(YA.prototype,"ArrayType",{value:Int16Array}),Object.defineProperty(XA.prototype,"ArrayType",{value:Int32Array}),Object.defineProperty(ZA.prototype,"ArrayType",{value:Int32Array}),Object.defineProperty(ei.prototype,"ArrayType",{value:Uint8Array}),Object.defineProperty(ti.prototype,"ArrayType",{value:Uint16Array}),Object.defineProperty(ni.prototype,"ArrayType",{value:Uint32Array}),Object.defineProperty(ri.prototype,"ArrayType",{value:Uint32Array});class Ai extends GA{constructor(e){super(),this.precision=e}get typeId(){return dA.Float}get ArrayType(){switch(this.precision){case wA.HALF:return Uint16Array;case wA.SINGLE:return Float32Array;case wA.DOUBLE:return Float64Array}throw new Error(`Unrecognized ${this[Symbol.toStringTag]} type`)}toString(){return`Float${this.precision<<5||16}`}}Ai[Symbol.toStringTag]=(e=>(e.precision=null,e[Symbol.toStringTag]="Float"))(Ai.prototype);class ii extends Ai{constructor(){super(wA.HALF)}}class si extends Ai{constructor(){super(wA.SINGLE)}}class ai extends Ai{constructor(){super(wA.DOUBLE)}}Object.defineProperty(ii.prototype,"ArrayType",{value:Uint16Array}),Object.defineProperty(si.prototype,"ArrayType",{value:Float32Array}),Object.defineProperty(ai.prototype,"ArrayType",{value:Float64Array});class oi extends GA{constructor(){super()}get typeId(){return dA.Binary}toString(){return"Binary"}}oi[Symbol.toStringTag]=(e=>(e.ArrayType=Uint8Array,e[Symbol.toStringTag]="Binary"))(oi.prototype);class ci extends GA{constructor(){super()}get typeId(){return dA.Utf8}toString(){return"Utf8"}}ci[Symbol.toStringTag]=(e=>(e.ArrayType=Uint8Array,e[Symbol.toStringTag]="Utf8"))(ci.prototype);class li extends GA{constructor(){super()}get typeId(){return dA.Bool}toString(){return"Bool"}}li[Symbol.toStringTag]=(e=>(e.ArrayType=Uint8Array,e[Symbol.toStringTag]="Bool"))(li.prototype);class ui extends GA{constructor(e,t){super(),this.scale=e,this.precision=t}get typeId(){return dA.Decimal}toString(){return`Decimal[${this.precision}e${this.scale>0?"+":""}${this.scale}]`}}ui[Symbol.toStringTag]=(e=>(e.scale=null,e.precision=null,e.ArrayType=Uint32Array,e[Symbol.toStringTag]="Decimal"))(ui.prototype);class hi extends GA{constructor(e){super(),this.unit=e}get typeId(){return dA.Date}toString(){return`Date${32*(this.unit+1)}<${mA[this.unit]}>`}}hi[Symbol.toStringTag]=(e=>(e.unit=null,e.ArrayType=Int32Array,e[Symbol.toStringTag]="Date"))(hi.prototype);class di extends hi{constructor(){super(mA.DAY)}}class fi extends hi{constructor(){super(mA.MILLISECOND)}}class pi extends GA{constructor(e,t){super(),this.unit=e,this.bitWidth=t}get typeId(){return dA.Time}toString(){return`Time${this.bitWidth}<${yA[this.unit]}>`}}pi[Symbol.toStringTag]=(e=>(e.unit=null,e.bitWidth=null,e.ArrayType=Int32Array,e[Symbol.toStringTag]="Time"))(pi.prototype);class gi extends pi{constructor(){super(yA.SECOND,32)}}class mi extends pi{constructor(){super(yA.MILLISECOND,32)}}class yi extends pi{constructor(){super(yA.MICROSECOND,64)}}class wi extends pi{constructor(){super(yA.NANOSECOND,64)}}class vi extends GA{constructor(e,t){super(),this.unit=e,this.timezone=t}get typeId(){return dA.Timestamp}toString(){return`Timestamp<${yA[this.unit]}${this.timezone?`, ${this.timezone}`:""}>`}}vi[Symbol.toStringTag]=(e=>(e.unit=null,e.timezone=null,e.ArrayType=Int32Array,e[Symbol.toStringTag]="Timestamp"))(vi.prototype);class Bi extends GA{constructor(e){super(),this.unit=e}get typeId(){return dA.Interval}toString(){return`Interval<${BA[this.unit]}>`}}Bi[Symbol.toStringTag]=(e=>(e.unit=null,e.ArrayType=Int32Array,e[Symbol.toStringTag]="Interval"))(Bi.prototype);class bi extends Bi{constructor(){super(BA.DAY_TIME)}}class _i extends Bi{constructor(){super(BA.YEAR_MONTH)}}class Ci extends GA{constructor(e){super(),this.children=[e]}get typeId(){return dA.List}toString(){return`List<${this.valueType}>`}get valueType(){return this.children[0].type}get valueField(){return this.children[0]}get ArrayType(){return this.valueType.ArrayType}}Ci[Symbol.toStringTag]=(e=>(e.children=null,e[Symbol.toStringTag]="List"))(Ci.prototype);class xi extends GA{constructor(e){super(),this.children=e}get typeId(){return dA.Struct}toString(){return`Struct<{${this.children.map((e=>`${e.name}:${e.type}`)).join(", ")}}>`}}xi[Symbol.toStringTag]=(e=>(e.children=null,e[Symbol.toStringTag]="Struct"))(xi.prototype);class Ui extends GA{constructor(e,t,n){super(),this.mode=e,this.children=n,this.typeIds=t=Int32Array.from(t),this.typeIdToChildIndex=t.reduce(((e,t,n)=>(e[t]=n)&&e||e),Object.create(null))}get typeId(){return dA.Union}toString(){return`${this[Symbol.toStringTag]}<${this.children.map((e=>`${e.type}`)).join(" | ")}>`}}Ui[Symbol.toStringTag]=(e=>(e.mode=null,e.typeIds=null,e.children=null,e.typeIdToChildIndex=null,e.ArrayType=Int8Array,e[Symbol.toStringTag]="Union"))(Ui.prototype);class Fi extends GA{constructor(e){super(),this.byteWidth=e}get typeId(){return dA.FixedSizeBinary}toString(){return`FixedSizeBinary[${this.byteWidth}]`}}Fi[Symbol.toStringTag]=(e=>(e.byteWidth=null,e.ArrayType=Uint8Array,e[Symbol.toStringTag]="FixedSizeBinary"))(Fi.prototype);class Ei extends GA{constructor(e,t){super(),this.listSize=e,this.children=[t]}get typeId(){return dA.FixedSizeList}get valueType(){return this.children[0].type}get valueField(){return this.children[0]}get ArrayType(){return this.valueType.ArrayType}toString(){return`FixedSizeList[${this.listSize}]<${this.valueType}>`}}Ei[Symbol.toStringTag]=(e=>(e.children=null,e.listSize=null,e[Symbol.toStringTag]="FixedSizeList"))(Ei.prototype);class Qi extends GA{constructor(e,t=!1){super(),this.children=[e],this.keysSorted=t}get typeId(){return dA.Map}get keyType(){return this.children[0].type.children[0].type}get valueType(){return this.children[0].type.children[1].type}toString(){return`Map<{${this.children[0].type.children.map((e=>`${e.name}:${e.type}`)).join(", ")}}>`}}Qi[Symbol.toStringTag]=(e=>(e.children=null,e.keysSorted=null,e[Symbol.toStringTag]="Map_"))(Qi.prototype);const Si=(Ii=-1,()=>++Ii);var Ii;class ki extends GA{constructor(e,t,n,r){super(),this.indices=t,this.dictionary=e,this.isOrdered=r||!1,this.id=null==n?Si():"number"==typeof n?n:n.low}get typeId(){return dA.Dictionary}get children(){return this.dictionary.children}get valueType(){return this.dictionary}get ArrayType(){return this.dictionary.ArrayType}toString(){return`Dictionary<${this.indices}, ${this.dictionary}>`}}function Di(e){let t=e;switch(e.typeId){case dA.Decimal:return 4;case dA.Timestamp:return 2;case dA.Date:case dA.Interval:return 1+t.unit;case dA.Int:case dA.Time:return+(t.bitWidth>32)+1;case dA.FixedSizeList:return t.listSize;case dA.FixedSizeBinary:return t.byteWidth;default:return 1}}ki[Symbol.toStringTag]=(e=>(e.id=null,e.indices=null,e.isOrdered=null,e.dictionary=null,e[Symbol.toStringTag]="Dictionary"))(ki.prototype);class Mi{constructor(e,t,n,r,A,i,s){let a;this.type=e,this.dictionary=s,this.offset=Math.floor(Math.max(t||0,0)),this.length=Math.floor(Math.max(n||0,0)),this._nullCount=Math.floor(Math.max(r||0,-1)),this.childData=(i||[]).map((e=>e instanceof Mi?e:e.data)),A instanceof Mi?(this.stride=A.stride,this.values=A.values,this.typeIds=A.typeIds,this.nullBitmap=A.nullBitmap,this.valueOffsets=A.valueOffsets):(this.stride=Di(e),A&&((a=A[0])&&(this.valueOffsets=a),(a=A[1])&&(this.values=a),(a=A[2])&&(this.nullBitmap=a),(a=A[3])&&(this.typeIds=a)))}get typeId(){return this.type.typeId}get ArrayType(){return this.type.ArrayType}get buffers(){return[this.valueOffsets,this.values,this.nullBitmap,this.typeIds]}get byteLength(){let e=0,{valueOffsets:t,values:n,nullBitmap:r,typeIds:A}=this;return t&&(e+=t.byteLength),n&&(e+=n.byteLength),r&&(e+=r.byteLength),A&&(e+=A.byteLength),this.childData.reduce(((e,t)=>e+t.byteLength),e)}get nullCount(){let e,t=this._nullCount;return t<=-1&&(e=this.nullBitmap)&&(this._nullCount=t=this.length-SA(e,this.offset,this.offset+this.length)),t}clone(e,t=this.offset,n=this.length,r=this._nullCount,A=this,i=this.childData){return new Mi(e,t,n,r,A,i,this.dictionary)}slice(e,t){const{stride:n,typeId:r,childData:A}=this,i=+(0===this._nullCount)-1,s=16===r?n:1,a=this._sliceBuffers(e,t,n,r);return this.clone(this.type,this.offset+e,t,i,a,!A.length||this.valueOffsets?A:this._sliceChildren(A,s*e,s*t))}_changeLengthAndBackfillNullBitmap(e){if(this.typeId===dA.Null)return this.clone(this.type,0,e,0);const{length:t,nullCount:n}=this,r=new Uint8Array((e+63&-64)>>3).fill(255,0,t>>3);r[t>>3]=(1<<t-(-8&t))-1,n>0&&r.set(FA(this.offset,t,this.nullBitmap),0);const A=this.buffers;return A[pA.VALIDITY]=r,this.clone(this.type,0,e,n+(e-t),A)}_sliceBuffers(e,t,n,r){let A,{buffers:i}=this;return(A=i[pA.TYPE])&&(i[pA.TYPE]=A.subarray(e,e+t)),(A=i[pA.OFFSET])&&(i[pA.OFFSET]=A.subarray(e,e+t+1))||(A=i[pA.DATA])&&(i[pA.DATA]=6===r?A:A.subarray(n*e,n*(e+t))),i}_sliceChildren(e,t,n){return e.map((e=>e.slice(t,n)))}static new(e,t,n,r,A,i,s){switch(A instanceof Mi?A=A.buffers:A||(A=[]),e.typeId){case dA.Null:return Mi.Null(e,t,n);case dA.Int:return Mi.Int(e,t,n,r||0,A[pA.VALIDITY],A[pA.DATA]||[]);case dA.Dictionary:return Mi.Dictionary(e,t,n,r||0,A[pA.VALIDITY],A[pA.DATA]||[],s);case dA.Float:return Mi.Float(e,t,n,r||0,A[pA.VALIDITY],A[pA.DATA]||[]);case dA.Bool:return Mi.Bool(e,t,n,r||0,A[pA.VALIDITY],A[pA.DATA]||[]);case dA.Decimal:return Mi.Decimal(e,t,n,r||0,A[pA.VALIDITY],A[pA.DATA]||[]);case dA.Date:return Mi.Date(e,t,n,r||0,A[pA.VALIDITY],A[pA.DATA]||[]);case dA.Time:return Mi.Time(e,t,n,r||0,A[pA.VALIDITY],A[pA.DATA]||[]);case dA.Timestamp:return Mi.Timestamp(e,t,n,r||0,A[pA.VALIDITY],A[pA.DATA]||[]);case dA.Interval:return Mi.Interval(e,t,n,r||0,A[pA.VALIDITY],A[pA.DATA]||[]);case dA.FixedSizeBinary:return Mi.FixedSizeBinary(e,t,n,r||0,A[pA.VALIDITY],A[pA.DATA]||[]);case dA.Binary:return Mi.Binary(e,t,n,r||0,A[pA.VALIDITY],A[pA.OFFSET]||[],A[pA.DATA]||[]);case dA.Utf8:return Mi.Utf8(e,t,n,r||0,A[pA.VALIDITY],A[pA.OFFSET]||[],A[pA.DATA]||[]);case dA.List:return Mi.List(e,t,n,r||0,A[pA.VALIDITY],A[pA.OFFSET]||[],(i||[])[0]);case dA.FixedSizeList:return Mi.FixedSizeList(e,t,n,r||0,A[pA.VALIDITY],(i||[])[0]);case dA.Struct:return Mi.Struct(e,t,n,r||0,A[pA.VALIDITY],i||[]);case dA.Map:return Mi.Map(e,t,n,r||0,A[pA.VALIDITY],A[pA.OFFSET]||[],(i||[])[0]);case dA.Union:return Mi.Union(e,t,n,r||0,A[pA.VALIDITY],A[pA.TYPE]||[],A[pA.OFFSET]||i,i)}throw new Error(`Unrecognized typeId ${e.typeId}`)}static Null(e,t,n){return new Mi(e,t,n,0)}static Int(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,Br(e.ArrayType,i),Ur(A)])}static Dictionary(e,t,n,r,A,i,s){return new Mi(e,t,n,r,[void 0,Br(e.indices.ArrayType,i),Ur(A)],[],s)}static Float(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,Br(e.ArrayType,i),Ur(A)])}static Bool(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,Br(e.ArrayType,i),Ur(A)])}static Decimal(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,Br(e.ArrayType,i),Ur(A)])}static Date(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,Br(e.ArrayType,i),Ur(A)])}static Time(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,Br(e.ArrayType,i),Ur(A)])}static Timestamp(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,Br(e.ArrayType,i),Ur(A)])}static Interval(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,Br(e.ArrayType,i),Ur(A)])}static FixedSizeBinary(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,Br(e.ArrayType,i),Ur(A)])}static Binary(e,t,n,r,A,i,s){return new Mi(e,t,n,r,[Cr(i),Ur(s),Ur(A)])}static Utf8(e,t,n,r,A,i,s){return new Mi(e,t,n,r,[Cr(i),Ur(s),Ur(A)])}static List(e,t,n,r,A,i,s){return new Mi(e,t,n,r,[Cr(i),void 0,Ur(A)],s?[s]:[])}static FixedSizeList(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,void 0,Ur(A)],i?[i]:[])}static Struct(e,t,n,r,A,i){return new Mi(e,t,n,r,[void 0,void 0,Ur(A)],i)}static Map(e,t,n,r,A,i,s){return new Mi(e,t,n,r,[Cr(i),void 0,Ur(A)],s?[s]:[])}static Union(e,t,n,r,A,i,s,a){const o=[void 0,void 0,Ur(A),Br(e.ArrayType,i)];return e.mode===vA.Sparse?new Mi(e,t,n,r,o,s):(o[pA.OFFSET]=Cr(s),new Mi(e,t,n,r,o,a))}}function Ti(e){if(null===e)return"null";if(void 0===e)return"undefined";switch(typeof e){case"number":case"bigint":return`${e}`;case"string":return`"${e}"`}return"function"==typeof e[Symbol.toPrimitive]?e[Symbol.toPrimitive]("string"):ArrayBuffer.isView(e)?`[${e}]`:JSON.stringify(e)}Mi.prototype.childData=Object.freeze([]);const Oi=(e,t)=>(e*t+63&-64||64)/t;class Li{constructor(e,t=1){this.buffer=e,this.stride=t,this.BYTES_PER_ELEMENT=e.BYTES_PER_ELEMENT,this.ArrayType=e.constructor,this._resize(this.length=e.length/t|0)}get byteLength(){return this.length*this.stride*this.BYTES_PER_ELEMENT|0}get reservedLength(){return this.buffer.length/this.stride}get reservedByteLength(){return this.buffer.byteLength}set(e,t){return this}append(e){return this.set(this.length,e)}reserve(e){if(e>0){this.length+=e;const t=this.stride,n=this.length*t,r=this.buffer.length;n>=r&&this._resize(Oi(0===r?1*n:2*n,this.BYTES_PER_ELEMENT))}return this}flush(e=this.length){e=Oi(e*this.stride,this.BYTES_PER_ELEMENT);const t=((e,t=0)=>e.length>=t?e.subarray(0,t):wr(new e.constructor(t),e,0))(this.buffer,e);return this.clear(),t}clear(){return this.length=0,this._resize(0),this}_resize(e){return this.buffer=wr(new this.ArrayType(e),this.buffer)}}Li.prototype.offset=0;class Pi extends Li{last(){return this.get(this.length-1)}get(e){return this.buffer[e]}set(e,t){return this.reserve(e-this.length+1),this.buffer[e*this.stride]=t,this}}class Hi extends Pi{constructor(e=new Uint8Array(0)){super(e,1/8),this.numValid=0}get numInvalid(){return this.length-this.numValid}get(e){return this.buffer[e>>3]>>e%8&1}set(e,t){const{buffer:n}=this.reserve(e-this.length+1),r=e>>3,A=e%8,i=n[r]>>A&1;return t?0===i&&(n[r]|=1<<A,++this.numValid):1===i&&(n[r]&=~(1<<A),--this.numValid),this}clear(){return this.numValid=0,super.clear()}}class Ri extends Pi{constructor(e=new Int32Array(1)){super(e,1)}append(e){return this.set(this.length-1,e)}set(e,t){const n=this.length-1,r=this.reserve(e-n+1).buffer;return n<e++&&r.fill(r[n],n,e),r[e]=r[e-1]+t,this}flush(e=this.length-1){return e>this.length&&this.set(e-1,0),super.flush(e+1)}}class Ni extends Li{get ArrayType64(){return this._ArrayType64||(this._ArrayType64=this.buffer instanceof Int32Array?tr:rr)}set(e,t){switch(this.reserve(e-this.length+1),typeof t){case"bigint":this.buffer64[e]=t;break;case"number":this.buffer[e*this.stride]=t;break;default:this.buffer.set(t,e*this.stride)}return this}_resize(e){const t=super._resize(e),n=t.byteLength/(this.BYTES_PER_ELEMENT*this.stride);return er&&(this.buffer64=new this.ArrayType64(t.buffer,t.byteOffset,n)),t}}class Vi{constructor({type:e,nullValues:t}){this.length=0,this.finished=!1,this.type=e,this.children=[],this.nullValues=t,this.stride=Di(e),this._nulls=new Hi,t&&t.length>0&&(this._isValid=function(e){if(!e||e.length<=0)return function(e){return!0};let t="",n=e.filter((e=>e==e));return n.length>0&&(t=`\n    switch (x) {${n.map((e=>`\n        case ${function(e){return"bigint"!=typeof e?Ti(e):er?`${Ti(e)}n`:`"${Ti(e)}"`}(e)}:`)).join("")}\n            return false;\n    }`),e.length!==n.length&&(t=`if (x !== x) return false;\n${t}`),new Function("x",`${t}\nreturn true;`)}(t))}static new(e){}static throughNode(e){throw new Error('"throughNode" not available in this environment')}static throughDOM(e){throw new Error('"throughDOM" not available in this environment')}static throughIterable(e){return function(e){const{queueingStrategy:t="count"}=e,{highWaterMark:n=("bytes"!==t?1e3:16384)}=e,r="bytes"!==t?"length":"byteLength";return function*(t){let A=0,i=Vi.new(e);for(const e of t)i.append(e)[r]>=n&&++A&&(yield i.toVector());(i.finish().length>0||0===A)&&(yield i.toVector())}}(e)}static throughAsyncIterable(e){return function(e){const{queueingStrategy:t="count"}=e,{highWaterMark:n=("bytes"!==t?1e3:16384)}=e,r="bytes"!==t?"length":"byteLength";return async function*(t){let A=0,i=Vi.new(e);for await(const e of t)i.append(e)[r]>=n&&++A&&(yield i.toVector());(i.finish().length>0||0===A)&&(yield i.toVector())}}(e)}toVector(){return aA.new(this.flush())}get ArrayType(){return this.type.ArrayType}get nullCount(){return this._nulls.numInvalid}get numChildren(){return this.children.length}get byteLength(){let e=0;return this._offsets&&(e+=this._offsets.byteLength),this._values&&(e+=this._values.byteLength),this._nulls&&(e+=this._nulls.byteLength),this._typeIds&&(e+=this._typeIds.byteLength),this.children.reduce(((e,t)=>e+t.byteLength),e)}get reservedLength(){return this._nulls.reservedLength}get reservedByteLength(){let e=0;return this._offsets&&(e+=this._offsets.reservedByteLength),this._values&&(e+=this._values.reservedByteLength),this._nulls&&(e+=this._nulls.reservedByteLength),this._typeIds&&(e+=this._typeIds.reservedByteLength),this.children.reduce(((e,t)=>e+t.reservedByteLength),e)}get valueOffsets(){return this._offsets?this._offsets.buffer:null}get values(){return this._values?this._values.buffer:null}get nullBitmap(){return this._nulls?this._nulls.buffer:null}get typeIds(){return this._typeIds?this._typeIds.buffer:null}append(e){return this.set(this.length,e)}isValid(e){return this._isValid(e)}set(e,t){return this.setValid(e,this.isValid(t))&&this.setValue(e,t),this}setValue(e,t){this._setValue(this,e,t)}setValid(e,t){return this.length=this._nulls.set(e,+t).length,t}addChild(e,t=`${this.numChildren}`){throw new Error(`Cannot append children to non-nested type "${this.type}"`)}getChildAt(e){return this.children[e]||null}flush(){const e=[],t=this._values,n=this._offsets,r=this._typeIds,{length:A,nullCount:i}=this;r?(e[pA.TYPE]=r.flush(A),n&&(e[pA.OFFSET]=n.flush(A))):n?(t&&(e[pA.DATA]=t.flush(n.last())),e[pA.OFFSET]=n.flush(A)):t&&(e[pA.DATA]=t.flush(A)),i>0&&(e[pA.VALIDITY]=this._nulls.flush(A));const s=Mi.new(this.type,0,A,i,e,this.children.map((e=>e.flush())));return this.clear(),s}finish(){return this.finished=!0,this.children.forEach((e=>e.finish())),this}clear(){return this.length=0,this._offsets&&this._offsets.clear(),this._values&&this._values.clear(),this._nulls&&this._nulls.clear(),this._typeIds&&this._typeIds.clear(),this.children.forEach((e=>e.clear())),this}}Vi.prototype.length=1,Vi.prototype.stride=1,Vi.prototype.children=null,Vi.prototype.finished=!1,Vi.prototype.nullValues=null,Vi.prototype._isValid=()=>!0;class Ki extends Vi{constructor(e){super(e),this._values=new Pi(new this.ArrayType(0),this.stride)}setValue(e,t){const n=this._values;return n.reserve(e-n.length+1),super.setValue(e,t)}}class ji extends Vi{constructor(e){super(e),this._pendingLength=0,this._offsets=new Ri}setValue(e,t){const n=this._pending||(this._pending=new Map),r=n.get(e);r&&(this._pendingLength-=r.length),this._pendingLength+=t.length,n.set(e,t)}setValid(e,t){return!!super.setValid(e,t)||((this._pending||(this._pending=new Map)).set(e,void 0),!1)}clear(){return this._pendingLength=0,this._pending=void 0,super.clear()}flush(){return this._flush(),super.flush()}finish(){return this._flush(),super.finish()}_flush(){const e=this._pending,t=this._pendingLength;return this._pendingLength=0,this._pending=void 0,e&&e.size>0&&this._flushPending(e,t),this}}class $i extends Vi{constructor(e){super(e),this._values=new Hi}setValue(e,t){this._values.set(e,+t)}}class Gi extends Vi{setValue(e,t){}setValid(e,t){return this.length=Math.max(e+1,this.length),t}}class zi extends Ki{}class Wi extends zi{}class qi extends zi{}class Ji extends Ki{}class Yi extends Vi{constructor({type:e,nullValues:t,dictionaryHashFunction:n}){super({type:new ki(e.dictionary,e.indices,e.id,e.isOrdered)}),this._nulls=null,this._dictionaryOffset=0,this._keysToIndices=Object.create(null),this.indices=Vi.new({type:this.type.indices,nullValues:t}),this.dictionary=Vi.new({type:this.type.dictionary,nullValues:null}),"function"==typeof n&&(this.valueToKey=n)}get values(){return this.indices.values}get nullCount(){return this.indices.nullCount}get nullBitmap(){return this.indices.nullBitmap}get byteLength(){return this.indices.byteLength+this.dictionary.byteLength}get reservedLength(){return this.indices.reservedLength+this.dictionary.reservedLength}get reservedByteLength(){return this.indices.reservedByteLength+this.dictionary.reservedByteLength}isValid(e){return this.indices.isValid(e)}setValid(e,t){const n=this.indices;return t=n.setValid(e,t),this.length=n.length,t}setValue(e,t){let n=this._keysToIndices,r=this.valueToKey(t),A=n[r];return void 0===A&&(n[r]=A=this._dictionaryOffset+this.dictionary.append(t).length-1),this.indices.setValue(e,A)}flush(){const e=this.type,t=this._dictionary,n=this.dictionary.toVector(),r=this.indices.flush().clone(e);return r.dictionary=t?t.concat(n):n,this.finished||(this._dictionaryOffset+=n.length),this._dictionary=r.dictionary,this.clear(),r}finish(){return this.indices.finish(),this.dictionary.finish(),this._dictionaryOffset=0,this._keysToIndices=Object.create(null),super.finish()}clear(){return this.indices.clear(),this.dictionary.clear(),super.clear()}valueToKey(e){return"string"==typeof e?e:`${e}`}}class Xi extends Ki{}const Zi=new Float64Array(1),es=new Uint32Array(Zi.buffer);function ts(e){let t=(31744&e)>>10,n=(1023&e)/1024,r=(-1)**((32768&e)>>15);switch(t){case 31:return r*(n?NaN:1/0);case 0:return r*(n?6103515625e-14*n:0)}return r*2**(t-15)*(1+n)}function ns(e){if(e!=e)return 32256;Zi[0]=e;let t=(2147483648&es[1])>>16&65535,n=2146435072&es[1],r=0;return n>=1089470464?es[0]>0?n=31744:(n=(2080374784&n)>>16,r=(1048575&es[1])>>10):n<=1056964608?(r=1048576+(1048575&es[1]),r=1048576+(r<<(n>>20)-998)>>21,n=0):(n=n-1056964608>>10,r=512+(1048575&es[1])>>10),t|n|65535&r}class rs extends Ki{}class As extends rs{setValue(e,t){this._values.set(e,ns(t))}}class is extends rs{setValue(e,t){this._values.set(e,t)}}class ss extends rs{setValue(e,t){this._values.set(e,t)}}const as=Symbol.for("isArrowBigNum");function os(e,...t){return 0===t.length?Object.setPrototypeOf(Br(this.TypedArray,e),this.constructor.prototype):Object.setPrototypeOf(new this.TypedArray(e,...t),this.constructor.prototype)}function cs(...e){return os.apply(this,e)}function ls(...e){return os.apply(this,e)}function us(...e){return os.apply(this,e)}function hs(e){let t,n,{buffer:r,byteOffset:A,length:i,signed:s}=e,a=new Int32Array(r,A,i),o=0,c=0,l=a.length;for(;c<l;)n=a[c++],t=a[c++],s||(t>>>=0),o+=(n>>>0)+t*c**32;return o}let ds,fs;function ps(e){let t="",n=new Uint32Array(2),r=new Uint16Array(e.buffer,e.byteOffset,e.byteLength/2),A=new Uint32Array((r=new Uint16Array(r).reverse()).buffer),i=-1,s=r.length-1;do{for(n[0]=r[i=0];i<s;)r[i++]=n[1]=n[0]/10,n[0]=(n[0]-10*n[1]<<16)+r[i];r[i]=n[1]=n[0]/10,n[0]=n[0]-10*n[1],t=`${n[0]}${t}`}while(A[0]||A[1]||A[2]||A[3]);return t||"0"}os.prototype[as]=!0,os.prototype.toJSON=function(){return`"${ds(this)}"`},os.prototype.valueOf=function(){return hs(this)},os.prototype.toString=function(){return ds(this)},os.prototype[Symbol.toPrimitive]=function(e="default"){switch(e){case"number":return hs(this);case"string":return ds(this);case"default":return fs(this)}return ds(this)},Object.setPrototypeOf(cs.prototype,Object.create(Int32Array.prototype)),Object.setPrototypeOf(ls.prototype,Object.create(Uint32Array.prototype)),Object.setPrototypeOf(us.prototype,Object.create(Uint32Array.prototype)),Object.assign(cs.prototype,os.prototype,{constructor:cs,signed:!0,TypedArray:Int32Array,BigIntArray:tr}),Object.assign(ls.prototype,os.prototype,{constructor:ls,signed:!1,TypedArray:Uint32Array,BigIntArray:rr}),Object.assign(us.prototype,os.prototype,{constructor:us,signed:!0,TypedArray:Uint32Array,BigIntArray:rr}),er?(fs=e=>8===e.byteLength?new e.BigIntArray(e.buffer,e.byteOffset,1)[0]:ps(e),ds=e=>8===e.byteLength?`${new e.BigIntArray(e.buffer,e.byteOffset,1)[0]}`:ps(e)):(ds=ps,fs=ds);class gs{static new(e,t){switch(t){case!0:return new cs(e);case!1:return new ls(e)}switch(e.constructor){case Int8Array:case Int16Array:case Int32Array:case tr:return new cs(e)}return 16===e.byteLength?new us(e):new ls(e)}static signed(e){return new cs(e)}static unsigned(e){return new ls(e)}static decimal(e){return new us(e)}constructor(e,t){return gs.new(e,t)}}class ms extends Ki{setValue(e,t){this._values.set(e,t)}}class ys extends ms{}class ws extends ms{}class vs extends ms{}class Bs extends ms{constructor(e){e.nullValues&&(e.nullValues=e.nullValues.map(Us)),super(e),this._values=new Ni(new Int32Array(0),2)}get values64(){return this._values.buffer64}isValid(e){return super.isValid(Us(e))}}class bs extends ms{}class _s extends ms{}class Cs extends ms{}class xs extends ms{constructor(e){e.nullValues&&(e.nullValues=e.nullValues.map(Us)),super(e),this._values=new Ni(new Uint32Array(0),2)}get values64(){return this._values.buffer64}isValid(e){return super.isValid(Us(e))}}const Us=(Fs={BigIntArray:tr},e=>(ArrayBuffer.isView(e)&&(Fs.buffer=e.buffer,Fs.byteOffset=e.byteOffset,Fs.byteLength=e.byteLength,e=fs(Fs),Fs.buffer=null),e));var Fs;class Es extends Ki{}class Qs extends Es{}class Ss extends Es{}class Is extends Es{}class ks extends Es{}class Ds extends Ki{}class Ms extends Ds{}class Ts extends Ds{}class Os extends Ds{}class Ls extends Ds{}class Ps extends Ki{}class Hs extends Ps{}class Rs extends Ps{}class Ns extends ji{constructor(e){super(e),this._values=new Li(new Uint8Array(0))}get byteLength(){let e=this._pendingLength+4*this.length;return this._offsets&&(e+=this._offsets.byteLength),this._values&&(e+=this._values.byteLength),this._nulls&&(e+=this._nulls.byteLength),e}setValue(e,t){return super.setValue(e,Ur(t))}_flushPending(e,t){const n=this._offsets,r=this._values.reserve(t).buffer;let A,i=0,s=0,a=0;for([i,A]of e)void 0===A?n.set(i,0):(s=A.length,r.set(A,a),n.set(i,s),a+=s)}}class Vs extends ji{constructor(e){super(e),this._values=new Li(new Uint8Array(0))}get byteLength(){let e=this._pendingLength+4*this.length;return this._offsets&&(e+=this._offsets.byteLength),this._values&&(e+=this._values.byteLength),this._nulls&&(e+=this._nulls.byteLength),e}setValue(e,t){return super.setValue(e,Wn(t))}_flushPending(e,t){}}Vs.prototype._flushPending=Ns.prototype._flushPending;class Ks{get length(){return this._values.length}get(e){return this._values[e]}clear(){return this._values=null,this}bind(e){return e instanceof aA?e:(this._values=e,this)}}const js=Symbol.for("parent"),$s=Symbol.for("rowIndex"),Gs=Symbol.for("keyToIdx"),zs=Symbol.for("idxToVal"),Ws=Symbol.for("nodejs.util.inspect.custom");class qs{constructor(e,t){this[js]=e,this.size=t}entries(){return this[Symbol.iterator]()}has(e){return void 0!==this.get(e)}get(e){let t;if(null!=e){const n=this[Gs]||(this[Gs]=new Map);let r=n.get(e);if(void 0!==r){const e=this[zs]||(this[zs]=new Array(this.size));void 0!==(t=e[r])||(e[r]=t=this.getValue(r))}else if((r=this.getIndex(e))>-1){n.set(e,r);const A=this[zs]||(this[zs]=new Array(this.size));void 0!==(t=A[r])||(A[r]=t=this.getValue(r))}}return t}set(e,t){if(null!=e){const n=this[Gs]||(this[Gs]=new Map);let r=n.get(e);void 0===r&&n.set(e,r=this.getIndex(e)),r>-1&&((this[zs]||(this[zs]=new Array(this.size)))[r]=this.setValue(r,t))}return this}clear(){throw new Error(`Clearing ${this[Symbol.toStringTag]} not supported.`)}delete(e){throw new Error(`Deleting ${this[Symbol.toStringTag]} values not supported.`)}*[Symbol.iterator](){const e=this.keys(),t=this.values(),n=this[Gs]||(this[Gs]=new Map),r=this[zs]||(this[zs]=new Array(this.size));for(let A,i,s,a,o=0;!(s=e.next()).done&&!(a=t.next()).done;++o)A=s.value,i=a.value,r[o]=i,n.has(A)||n.set(A,o),yield[A,i]}forEach(e,t){const n=this.keys(),r=this.values(),A=void 0===t?e:(n,r,A)=>e.call(t,n,r,A),i=this[Gs]||(this[Gs]=new Map),s=this[zs]||(this[zs]=new Array(this.size));for(let e,t,a,o,c=0;!(a=n.next()).done&&!(o=r.next()).done;++c)e=a.value,t=o.value,s[c]=t,i.has(e)||i.set(e,c),A(t,e,this)}toArray(){return[...this.values()]}toJSON(){const e={};return this.forEach(((t,n)=>e[n]=t)),e}inspect(){return this.toString()}[Ws](){return this.toString()}toString(){const e=[];return this.forEach(((t,n)=>{n=Ti(n),t=Ti(t),e.push(`${n}: ${t}`)})),`{ ${e.join(", ")} }`}}qs[Symbol.toStringTag]=(e=>(Object.defineProperties(e,{size:{writable:!0,enumerable:!1,configurable:!1,value:0},[js]:{writable:!0,enumerable:!1,configurable:!1,value:null},[$s]:{writable:!0,enumerable:!1,configurable:!1,value:-1}}),e[Symbol.toStringTag]="Row"))(qs.prototype);class Js extends qs{constructor(e){return super(e,e.length),Zs(this)}keys(){return this[js].getChildAt(0)[Symbol.iterator]()}values(){return this[js].getChildAt(1)[Symbol.iterator]()}getKey(e){return this[js].getChildAt(0).get(e)}getIndex(e){return this[js].getChildAt(0).indexOf(e)}getValue(e){return this[js].getChildAt(1).get(e)}setValue(e,t){this[js].getChildAt(1).set(e,t)}}class Ys extends qs{constructor(e){return super(e,e.type.children.length),Xs(this)}*keys(){for(const e of this[js].type.children)yield e.name}*values(){for(const e of this[js].type.children)yield this[e.name]}getKey(e){return this[js].type.children[e].name}getIndex(e){return this[js].type.children.findIndex((t=>t.name===e))}getValue(e){return this[js].getChildAt(e).get(this[$s])}setValue(e,t){return this[js].getChildAt(e).set(this[$s],t)}}Object.setPrototypeOf(qs.prototype,Map.prototype);const Xs=(()=>{const e={enumerable:!0,configurable:!1,get:null,set:null};return t=>{let n=-1,r=t[Gs]||(t[Gs]=new Map);const A=e=>function(){return this.get(e)},i=e=>function(t){return this.set(e,t)};for(const s of t.keys())r.set(s,++n),e.get=A(s),e.set=i(s),t.hasOwnProperty(s)||(e.enumerable=!0,Object.defineProperty(t,s,e)),t.hasOwnProperty(n)||(e.enumerable=!1,Object.defineProperty(t,n,e));return e.get=e.set=null,t}})(),Zs=(()=>{if("undefined"==typeof Proxy)return Xs;const e=qs.prototype.has,t=qs.prototype.get,n=qs.prototype.set,r=qs.prototype.getKey,A={isExtensible:()=>!1,deleteProperty:()=>!1,preventExtensions:()=>!0,ownKeys:e=>[...e.keys()].map((e=>`${e}`)),has(e,t){switch(t){case"getKey":case"getIndex":case"getValue":case"setValue":case"toArray":case"toJSON":case"inspect":case"constructor":case"isPrototypeOf":case"propertyIsEnumerable":case"toString":case"toLocaleString":case"valueOf":case"size":case"has":case"get":case"set":case"clear":case"delete":case"keys":case"values":case"entries":case"forEach":case"__proto__":case"__defineGetter__":case"__defineSetter__":case"hasOwnProperty":case"__lookupGetter__":case"__lookupSetter__":case Symbol.iterator:case Symbol.toStringTag:case js:case $s:case zs:case Gs:case Ws:return!0}return"number"!=typeof t||e.has(t)||(t=e.getKey(t)),e.has(t)},get(n,A,i){switch(A){case"getKey":case"getIndex":case"getValue":case"setValue":case"toArray":case"toJSON":case"inspect":case"constructor":case"isPrototypeOf":case"propertyIsEnumerable":case"toString":case"toLocaleString":case"valueOf":case"size":case"has":case"get":case"set":case"clear":case"delete":case"keys":case"values":case"entries":case"forEach":case"__proto__":case"__defineGetter__":case"__defineSetter__":case"hasOwnProperty":case"__lookupGetter__":case"__lookupSetter__":case Symbol.iterator:case Symbol.toStringTag:case js:case $s:case zs:case Gs:case Ws:return Reflect.get(n,A,i)}return"number"!=typeof A||e.call(i,A)||(A=r.call(i,A)),t.call(i,A)},set(t,A,i,s){switch(A){case js:case $s:case zs:case Gs:return Reflect.set(t,A,i,s);case"getKey":case"getIndex":case"getValue":case"setValue":case"toArray":case"toJSON":case"inspect":case"constructor":case"isPrototypeOf":case"propertyIsEnumerable":case"toString":case"toLocaleString":case"valueOf":case"size":case"has":case"get":case"set":case"clear":case"delete":case"keys":case"values":case"entries":case"forEach":case"__proto__":case"__defineGetter__":case"__defineSetter__":case"hasOwnProperty":case"__lookupGetter__":case"__lookupSetter__":case Symbol.iterator:case Symbol.toStringTag:return!1}return"number"!=typeof A||e.call(s,A)||(A=r.call(s,A)),!!e.call(s,A)&&!!n.call(s,A,i)}};return e=>new Proxy(e,A)})();function ea(e,t,n){const r=e.length,A=t>-1?t:r+t%r;return n?n(e,A):A}let ta;function na(e,t,n,r){let{length:A=0}=e,i="number"!=typeof t?0:t,s="number"!=typeof n?A:n;return i<0&&(i=(i%A+A)%A),s<0&&(s=(s%A+A)%A),s<i&&(ta=i,i=s,s=ta),s>A&&(s=A),r?r(e,i,s):[i,s]}const ra=er?Zn(0):0,Aa=e=>e!=e;function ia(e){let t=typeof e;if("object"!==t||null===e)return Aa(e)?Aa:"bigint"!==t?t=>t===e:t=>ra+t===e;if(e instanceof Date){const t=e.valueOf();return e=>e instanceof Date&&e.valueOf()===t}return ArrayBuffer.isView(e)?t=>!!t&&tA(e,t):e instanceof Map?function(e){let t=-1;const n=[];return e.forEach((e=>n[++t]=ia(e))),sa(n)}(e):Array.isArray(e)?function(e){const t=[];for(let n=-1,r=e.length;++n<r;)t[n]=ia(e[n]);return sa(t)}(e):e instanceof aA?function(e){const t=[];for(let n=-1,r=e.length;++n<r;)t[n]=ia(e.get(n));return sa(t)}(e):function(e){const t=Object.keys(e);if(0===t.length)return()=>!1;const n=[];for(let r=-1,A=t.length;++r<A;)n[r]=ia(e[t[r]]);return sa(n,t)}(e)}function sa(e,t){return n=>{if(!n||"object"!=typeof n)return!1;switch(n.constructor){case Array:return function(e,t){const n=e.length;if(t.length!==n)return!1;for(let r=-1;++r<n;)if(!e[r](t[r]))return!1;return!0}(e,n);case Map:case Js:case Ys:return aa(e,n,n.keys());case Object:case void 0:return aa(e,n,t||Object.keys(n))}return n instanceof aA&&function(e,t){const n=e.length;if(t.length!==n)return!1;for(let r=-1;++r<n;)if(!e[r](t.get(r)))return!1;return!0}(e,n)}}function aa(e,t,n){const r=n[Symbol.iterator](),A=t instanceof Map?t.keys():Object.keys(t)[Symbol.iterator](),i=t instanceof Map?t.values():Object.values(t)[Symbol.iterator]();let s=0,a=e.length,o=i.next(),c=r.next(),l=A.next();for(;s<a&&!c.done&&!l.done&&!o.done&&c.value===l.value&&e[s](o.value);++s,c=r.next(),l=A.next(),o=i.next());return!!(s===a&&c.done&&l.done&&o.done)||(r.return&&r.return(),A.return&&A.return(),i.return&&i.return(),!1)}class oa extends aA{constructor(e,t=[],n=function(e){let t=new Uint32Array((e||[]).length+1),n=t[0]=0,r=t.length;for(let A=0;++A<r;)t[A]=n+=e[A-1].length;return t}(t)){super(),this._nullCount=-1,this._type=e,this._chunks=t,this._chunkOffsets=n,this._length=n[n.length-1],this._numChildren=(this._type.children||[]).length}static flatten(...e){return ga(aA,e)}static concat(...e){const t=oa.flatten(...e);return new oa(t[0].type,t)}get type(){return this._type}get length(){return this._length}get chunks(){return this._chunks}get typeId(){return this._type.typeId}get VectorName(){return`Chunked<${this._type}>`}get data(){return this._chunks[0]?this._chunks[0].data:null}get ArrayType(){return this._type.ArrayType}get numChildren(){return this._numChildren}get stride(){return this._chunks[0]?this._chunks[0].stride:1}get byteLength(){return this._chunks.reduce(((e,t)=>e+t.byteLength),0)}get nullCount(){let e=this._nullCount;return e<0&&(this._nullCount=e=this._chunks.reduce(((e,{nullCount:t})=>e+t),0)),e}get indices(){if(GA.isDictionary(this._type)){if(!this._indices){const e=this._chunks;this._indices=1===e.length?e[0].indices:oa.concat(...e.map((e=>e.indices)))}return this._indices}return null}get dictionary(){return GA.isDictionary(this._type)?this._chunks[this._chunks.length-1].data.dictionary:null}*[Symbol.iterator](){for(const e of this._chunks)yield*e}clone(e=this._chunks){return new oa(this._type,e)}concat(...e){return this.clone(oa.flatten(this,...e))}slice(e,t){return na(this,e,t,this._sliceInternal)}getChildAt(e){if(e<0||e>=this._numChildren)return null;let t,n,r,A=this._children||(this._children=[]);return(t=A[e])?t:(n=(this._type.children||[])[e])&&(r=this._chunks.map((t=>t.getChildAt(e))).filter((e=>null!=e)),r.length>0)?A[e]=new oa(n.type,r):null}search(e,t){let n=e,r=this._chunkOffsets,A=r.length-1;if(n<0)return null;if(n>=r[A])return null;if(A<=1)return t?t(this,0,n):[0,n];let i=0,s=0,a=0;do{if(i+1===A)return t?t(this,i,n-s):[i,n-s];a=i+(A-i)/2|0,n>=r[a]?i=a:A=a}while(n<r[A]&&n>=(s=r[i]));return null}isValid(e){return!!this.search(e,this.isValidInternal)}get(e){return this.search(e,this.getInternal)}set(e,t){this.search(e,(({chunks:e},n,r)=>e[n].set(r,t)))}indexOf(e,t){return t&&"number"==typeof t?this.search(t,((t,n,r)=>this.indexOfInternal(t,n,r,e))):this.indexOfInternal(this,0,Math.max(0,t||0),e)}toArray(){const{chunks:e}=this,t=e.length;let n=this._type.ArrayType;if(t<=0)return new n(0);if(t<=1)return e[0].toArray();let r=0,A=new Array(t);for(let n=-1;++n<t;)r+=(A[n]=e[n].toArray()).length;n!==A[0].constructor&&(n=A[0].constructor);let i=new n(r),s=n===Array?la:ca;for(let e=-1,n=0;++e<t;)n=s(A[e],i,n);return i}getInternal({_chunks:e},t,n){return e[t].get(n)}isValidInternal({_chunks:e},t,n){return e[t].isValid(n)}indexOfInternal({_chunks:e},t,n,r){let A=t-1,i=e.length,s=n,a=0,o=-1;for(;++A<i;){if(~(o=e[A].indexOf(r,s)))return a+o;s=0,a+=e[A].length}return-1}_sliceInternal(e,t,n){const r=[],{chunks:A,_chunkOffsets:i}=e;for(let e=-1,s=A.length;++e<s;){const s=A[e],a=s.length,o=i[e];if(o>=n)break;if(t>=o+a)continue;if(o>=t&&o+a<=n){r.push(s);continue}const c=Math.max(0,t-o),l=Math.min(n-o,a);r.push(s.slice(c,l))}return e.clone(r)}}const ca=(e,t,n)=>(t.set(e,n),n+e.length),la=(e,t,n)=>{let r=n;for(let n=-1,A=e.length;++n<A;)t[r++]=e[n];return r};class ua extends oa{constructor(e,t=[],n){if(t=oa.flatten(...t),super(e.type,t,n),this._field=e,1===t.length&&!(this instanceof ha))return new ha(e,t[0],this._chunkOffsets)}static new(...e){let[t,n,...r]=e;"string"==typeof t||t instanceof Ca||(n=t,t="");const A=oa.flatten(Array.isArray(n)?[...n,...r]:n instanceof aA?[n,...r]:[aA.new(n,...r)]);if("string"==typeof t){const e=A[0].data.type;t=new Ca(t,e,!0)}else!t.nullable&&A.some((({nullCount:e})=>e>0))&&(t=t.clone({nullable:!0}));return new ua(t,A)}get field(){return this._field}get name(){return this._field.name}get nullable(){return this._field.nullable}get metadata(){return this._field.metadata}clone(e=this._chunks){return new ua(this._field,e)}getChildAt(e){if(e<0||e>=this.numChildren)return null;let t,n,r,A=this._children||(this._children=[]);return(t=A[e])?t:(n=(this.type.children||[])[e])&&(r=this._chunks.map((t=>t.getChildAt(e))).filter((e=>null!=e)),r.length>0)?A[e]=new ua(n,r):null}}class ha extends ua{constructor(e,t,n){super(e,[t],n),this._chunk=t}search(e,t){return t?t(this,0,e):[0,e]}isValid(e){return this._chunk.isValid(e)}get(e){return this._chunk.get(e)}set(e,t){this._chunk.set(e,t)}indexOf(e,t){return this._chunk.indexOf(e,t)}}const da=Array.isArray,fa=(e,t)=>ya(e,t,[],0),pa=e=>ba(e,[[],[]]),ga=(e,t)=>wa(e,t,[],0),ma=(e,t)=>va(e,t,[],0);function ya(e,t,n,r){let A,i=r,s=-1,a=t.length;for(;++s<a;)da(A=t[s])?i=ya(e,A,n,i).length:A instanceof e&&(n[i++]=A);return n}function wa(e,t,n,r){let A,i=r,s=-1,a=t.length;for(;++s<a;)da(A=t[s])?i=wa(e,A,n,i).length:A instanceof oa?i=wa(e,A.chunks,n,i).length:A instanceof e&&(n[i++]=A);return n}function va(e,t,n,r){let A,i=r,s=-1,a=t.length;for(;++s<a;)da(A=t[s])?i=va(e,A,n,i).length:A instanceof e?i=ya(aA,A.schema.fields.map(((e,t)=>A.getChildAt(t))),n,i).length:A instanceof aA&&(n[i++]=A);return n}const Ba=(e,[t,n],r)=>(e[0][r]=t,e[1][r]=n,e);function ba(e,t){let n,r;switch(r=e.length){case 0:return t;case 1:if(n=t[0],!e[0])return t;if(da(e[0]))return ba(e[0],t);e[0]instanceof Mi||e[0]instanceof aA||e[0]instanceof GA||([n,e]=Object.entries(e[0]).reduce(Ba,t));break;default:da(n=e[r-1])?e=da(e[0])?e[0]:e.slice(0,r-1):(e=da(e[0])?e[0]:e,n=[])}let A,i,s=-1,a=-1,o=-1,c=e.length,[l,u]=t;for(;++o<c;)i=e[o],i instanceof ua&&(u[++a]=i)?l[++s]=i.field.clone(n[o],i.type,!0):(({[o]:A=o}=n),i instanceof GA&&(u[++a]=i)?l[++s]=Ca.new(A,i,!0):i&&i.type&&(u[++a]=i)&&(i instanceof Mi&&(u[a]=i=aA.new(i)),l[++s]=Ca.new(A,i.type,!0)));return t}class _a{constructor(e=[],t,n){this.fields=e||[],this.metadata=t||new Map,n||(n=Ua(e)),this.dictionaries=n}static from(...e){return _a.new(e[0],e[1])}static new(...e){return new _a(pa(e)[0])}get[Symbol.toStringTag](){return"Schema"}toString(){return`Schema<{ ${this.fields.map(((e,t)=>`${t}: ${e}`)).join(", ")} }>`}compareTo(e){return $A.compareSchemas(this,e)}select(...e){const t=e.reduce(((e,t)=>(e[t]=!0)&&e),Object.create(null));return new _a(this.fields.filter((e=>t[e.name])),this.metadata)}selectAt(...e){return new _a(e.map((e=>this.fields[e])).filter(Boolean),this.metadata)}assign(...e){const t=e[0]instanceof _a?e[0]:new _a(fa(Ca,e)),n=[...this.fields],r=xa(xa(new Map,this.metadata),t.metadata),A=t.fields.filter((e=>{const t=n.findIndex((t=>t.name===e.name));return!~t||(n[t]=e.clone({metadata:xa(xa(new Map,n[t].metadata),e.metadata)}))&&!1})),i=Ua(A,new Map);return new _a([...n,...A],r,new Map([...this.dictionaries,...i]))}}class Ca{constructor(e,t,n=!1,r){this.name=e,this.type=t,this.nullable=n,this.metadata=r||new Map}static new(...e){let[t,n,r,A]=e;return e[0]&&"object"==typeof e[0]&&(({name:t}=e[0]),void 0===n&&(n=e[0].type),void 0===r&&(r=e[0].nullable),void 0===A&&(A=e[0].metadata)),new Ca(`${t}`,n,r,A)}get typeId(){return this.type.typeId}get[Symbol.toStringTag](){return"Field"}toString(){return`${this.name}: ${this.type}`}compareTo(e){return $A.compareField(this,e)}clone(...e){let[t,n,r,A]=e;return e[0]&&"object"==typeof e[0]?({name:t=this.name,type:n=this.type,nullable:r=this.nullable,metadata:A=this.metadata}=e[0]):[t=this.name,n=this.type,r=this.nullable,A=this.metadata]=e,Ca.new(t,n,r,A)}}function xa(e,t){return new Map([...e||new Map,...t||new Map])}function Ua(e,t=new Map){for(let n=-1,r=e.length;++n<r;){const r=e[n].type;if(GA.isDictionary(r))if(t.has(r.id)){if(t.get(r.id)!==r.dictionary)throw new Error("Cannot create Schema containing two different dictionaries with the same Id")}else t.set(r.id,r.dictionary);r.children&&r.children.length>0&&Ua(r.children,t)}return t}_a.prototype.fields=null,_a.prototype.metadata=null,_a.prototype.dictionaries=null,Ca.prototype.type=null,Ca.prototype.name=null,Ca.prototype.nullable=null,Ca.prototype.metadata=null;class Fa extends ji{constructor(e){super(e),this._run=new Ks,this._offsets=new Ri}addChild(e,t="0"){if(this.numChildren>0)throw new Error("ListBuilder can only have one child.");return this.children[this.numChildren]=e,this.type=new Ci(new Ca(t,e.type,!0)),this.numChildren-1}clear(){return this._run.clear(),super.clear()}_flushPending(e){const t=this._run,n=this._offsets,r=this._setValue;let A,i=0;for([i,A]of e)void 0===A?n.set(i,0):(n.set(i,A.length),r(this,i,t.bind(A)))}}class Ea extends Vi{constructor(){super(...arguments),this._run=new Ks}setValue(e,t){super.setValue(e,this._run.bind(t))}addChild(e,t="0"){if(this.numChildren>0)throw new Error("FixedSizeListBuilder can only have one child.");const n=this.children.push(e);return this.type=new Ei(this.type.listSize,new Ca(t,e.type,!0)),n}clear(){return this._run.clear(),super.clear()}}class Qa extends ji{set(e,t){return super.set(e,t)}setValue(e,t){t=t instanceof Map?t:new Map(Object.entries(t));const n=this._pending||(this._pending=new Map),r=n.get(e);r&&(this._pendingLength-=r.size),this._pendingLength+=t.size,n.set(e,t)}addChild(e,t=`${this.numChildren}`){if(this.numChildren>0)throw new Error("ListBuilder can only have one child.");return this.children[this.numChildren]=e,this.type=new Qi(new Ca(t,e.type,!0),this.type.keysSorted),this.numChildren-1}_flushPending(e){const t=this._offsets,n=this._setValue;e.forEach(((e,r)=>{void 0===e?t.set(r,0):(t.set(r,e.size),n(this,r,e))}))}}class Sa extends Vi{addChild(e,t=`${this.numChildren}`){const n=this.children.push(e);return this.type=new xi([...this.type.children,new Ca(t,e.type,!0)]),n}}class Ia extends Vi{constructor(e){super(e),this._typeIds=new Pi(new Int8Array(0),1),"function"==typeof e.valueToChildTypeId&&(this._valueToChildTypeId=e.valueToChildTypeId)}get typeIdToChildIndex(){return this.type.typeIdToChildIndex}append(e,t){return this.set(this.length,e,t)}set(e,t,n){return void 0===n&&(n=this._valueToChildTypeId(this,t,e)),this.setValid(e,this.isValid(t))&&this.setValue(e,t,n),this}setValue(e,t,n){this._typeIds.set(e,n),super.setValue(e,t)}addChild(e,t=`${this.children.length}`){const n=this.children.push(e),{type:{children:r,mode:A,typeIds:i}}=this,s=[...r,new Ca(t,e.type)];return this.type=new Ui(A,[...i,n],s),n}_valueToChildTypeId(e,t,n){throw new Error("Cannot map UnionBuilder value to child typeId. Pass the `childTypeId` as the second argument to unionBuilder.append(), or supply a `valueToChildTypeId` function as part of the UnionBuilder constructor options.")}}class ka extends Ia{}class Da extends Ia{constructor(e){super(e),this._offsets=new Pi(new Int32Array(0))}setValue(e,t,n){const r=this.type.typeIdToChildIndex[n];return this._offsets.set(e,this.getChildAt(r).length),super.setValue(e,t,n)}}class Ma extends DA{}const Ta=(e,t,n)=>{e[t]=n%4294967296|0,e[t+1]=n/4294967296|0},Oa=(e,t,n,r)=>{const{[n]:A,[n+1]:i}=t;null!=A&&null!=i&&e.set(r.subarray(0,i-A),A)},La=({values:e},t,n)=>{((e,t,n)=>{e[t]=n/864e5|0})(e,t,n.valueOf())},Pa=({values:e},t,n)=>{Ta(e,2*t,n.valueOf())},Ha=({stride:e,values:t},n,r)=>{t[e*n]=r},Ra=({stride:e,values:t},n,r)=>{t[e*n]=ns(r)},Na=(e,t,n)=>{switch(typeof n){case"bigint":e.values64[t]=n;break;case"number":e.values[t*e.stride]=n;break;default:const r=n,{stride:A,ArrayType:i}=e,s=Br(i,r);e.values.set(s.subarray(0,A),A*t)}},Va=({values:e},t,n)=>Ta(e,2*t,n/1e3),Ka=({values:e},t,n)=>Ta(e,2*t,n),ja=({values:e},t,n)=>((e,t,n)=>{e[t]=1e3*n%4294967296|0,e[t+1]=1e3*n/4294967296|0})(e,2*t,n),$a=({values:e},t,n)=>((e,t,n)=>{e[t]=1e6*n%4294967296|0,e[t+1]=1e6*n/4294967296|0})(e,2*t,n),Ga=({values:e,stride:t},n,r)=>{e[t*n]=r},za=({values:e,stride:t},n,r)=>{e[t*n]=r},Wa=({values:e},t,n)=>{e.set(n.subarray(0,2),2*t)},qa=({values:e},t,n)=>{e.set(n.subarray(0,2),2*t)},Ja=(e,t,n)=>{const r=e.typeIdToChildIndex[e.typeIds[t]],A=e.getChildAt(r);A&&A.set(e.valueOffsets[t],n)},Ya=(e,t,n)=>{const r=e.typeIdToChildIndex[e.typeIds[t]],A=e.getChildAt(r);A&&A.set(t,n)},Xa=({values:e},t,n)=>{e.set(n.subarray(0,2),2*t)},Za=({values:e},t,n)=>{e[t]=12*n[0]+n[1]%12};Ma.prototype.visitBool=({offset:e,values:t},n,r)=>{const A=e+n;r?t[A>>3]|=1<<A%8:t[A>>3]&=~(1<<A%8)},Ma.prototype.visitInt=(e,t,n)=>{e.type.bitWidth<64?Ha(e,t,n):Na(e,t,n)},Ma.prototype.visitInt8=Ha,Ma.prototype.visitInt16=Ha,Ma.prototype.visitInt32=Ha,Ma.prototype.visitInt64=Na,Ma.prototype.visitUint8=Ha,Ma.prototype.visitUint16=Ha,Ma.prototype.visitUint32=Ha,Ma.prototype.visitUint64=Na,Ma.prototype.visitFloat=(e,t,n)=>{e.type.precision!==wA.HALF?Ha(e,t,n):Ra(e,t,n)},Ma.prototype.visitFloat16=Ra,Ma.prototype.visitFloat32=Ha,Ma.prototype.visitFloat64=Ha,Ma.prototype.visitUtf8=({values:e,valueOffsets:t},n,r)=>{Oa(e,t,n,Wn(r))},Ma.prototype.visitBinary=({values:e,valueOffsets:t},n,r)=>Oa(e,t,n,r),Ma.prototype.visitFixedSizeBinary=({stride:e,values:t},n,r)=>{t.set(r.subarray(0,e),e*n)},Ma.prototype.visitDate=(e,t,n)=>{e.type.unit===mA.DAY?La(e,t,n):Pa(e,t,n)},Ma.prototype.visitDateDay=La,Ma.prototype.visitDateMillisecond=Pa,Ma.prototype.visitTimestamp=(e,t,n)=>{switch(e.type.unit){case yA.SECOND:return Va(e,t,n);case yA.MILLISECOND:return Ka(e,t,n);case yA.MICROSECOND:return ja(e,t,n);case yA.NANOSECOND:return $a(e,t,n)}},Ma.prototype.visitTimestampSecond=Va,Ma.prototype.visitTimestampMillisecond=Ka,Ma.prototype.visitTimestampMicrosecond=ja,Ma.prototype.visitTimestampNanosecond=$a,Ma.prototype.visitTime=(e,t,n)=>{switch(e.type.unit){case yA.SECOND:return Ga(e,t,n);case yA.MILLISECOND:return za(e,t,n);case yA.MICROSECOND:return Wa(e,t,n);case yA.NANOSECOND:return qa(e,t,n)}},Ma.prototype.visitTimeSecond=Ga,Ma.prototype.visitTimeMillisecond=za,Ma.prototype.visitTimeMicrosecond=Wa,Ma.prototype.visitTimeNanosecond=qa,Ma.prototype.visitDecimal=({values:e},t,n)=>{e.set(n.subarray(0,4),4*t)},Ma.prototype.visitList=(e,t,n)=>{const r=e.getChildAt(0),A=e.valueOffsets;for(let e=-1,i=A[t],s=A[t+1];i<s;)r.set(i++,n.get(++e))},Ma.prototype.visitStruct=(e,t,n)=>{const r=n instanceof Map?(A=t,i=n,(e,t,n)=>e&&e.set(A,i.get(t.name))):n instanceof aA?((e,t)=>(n,r,A)=>n&&n.set(e,t.get(A)))(t,n):Array.isArray(n)?((e,t)=>(n,r,A)=>n&&n.set(e,t[A]))(t,n):((e,t)=>(n,r,A)=>n&&n.set(e,t[r.name]))(t,n);var A,i;e.type.children.forEach(((t,n)=>r(e.getChildAt(n),t,n)))},Ma.prototype.visitUnion=(e,t,n)=>{e.type.mode===vA.Dense?Ja(e,t,n):Ya(e,t,n)},Ma.prototype.visitDenseUnion=Ja,Ma.prototype.visitSparseUnion=Ya,Ma.prototype.visitDictionary=(e,t,n)=>{const r=e.getKey(t);null!==r&&e.setValue(r,n)},Ma.prototype.visitInterval=(e,t,n)=>{e.type.unit===BA.DAY_TIME?Xa(e,t,n):Za(e,t,n)},Ma.prototype.visitIntervalDayTime=Xa,Ma.prototype.visitIntervalYearMonth=Za,Ma.prototype.visitFixedSizeList=(e,t,n)=>{const r=e.getChildAt(0),{stride:A}=e;for(let e=-1,i=t*A;++e<A;)r.set(i+e,n.get(e))},Ma.prototype.visitMap=(e,t,n)=>{const r=e.getChildAt(0),A=e.valueOffsets,i=n instanceof Map?[...n]:Object.entries(n);for(let e=-1,n=A[t],s=A[t+1];n<s;)r.set(n++,i[++e])};const eo=new Ma,to=new class extends DA{visitNull(){return Gi}visitBool(){return $i}visitInt(){return ms}visitInt8(){return ys}visitInt16(){return ws}visitInt32(){return vs}visitInt64(){return Bs}visitUint8(){return bs}visitUint16(){return _s}visitUint32(){return Cs}visitUint64(){return xs}visitFloat(){return rs}visitFloat16(){return As}visitFloat32(){return is}visitFloat64(){return ss}visitUtf8(){return Vs}visitBinary(){return Ns}visitFixedSizeBinary(){return Xi}visitDate(){return zi}visitDateDay(){return Wi}visitDateMillisecond(){return qi}visitTimestamp(){return Ds}visitTimestampSecond(){return Ms}visitTimestampMillisecond(){return Ts}visitTimestampMicrosecond(){return Os}visitTimestampNanosecond(){return Ls}visitTime(){return Es}visitTimeSecond(){return Qs}visitTimeMillisecond(){return Ss}visitTimeMicrosecond(){return Is}visitTimeNanosecond(){return ks}visitDecimal(){return Ji}visitList(){return Fa}visitStruct(){return Sa}visitUnion(){return Ia}visitDenseUnion(){return Da}visitSparseUnion(){return ka}visitDictionary(){return Yi}visitInterval(){return Ps}visitIntervalDayTime(){return Hs}visitIntervalYearMonth(){return Rs}visitFixedSizeList(){return Ea}visitMap(){return Qa}};var no;Vi.new=function e(t){const n=t.type,r=new(to.getVisitFn(n)())(t);if(n.children&&n.children.length>0){const A=t.children||[],i={nullValues:t.nullValues},s=Array.isArray(A)?(e,t)=>A[t]||i:({name:e})=>A[e]||i;n.children.forEach(((t,n)=>{const{type:A}=t,i=s(t,n);r.children.push(e({...i,type:A}))}))}return r},Object.keys(dA).map((e=>dA[e])).filter((e=>"number"==typeof e&&e!==dA.NONE)).forEach((e=>{to.visit(e).prototype._setValue=eo.getVisitFn(e)})),Vs.prototype._setValue=eo.visitBinary,function(e){!function(t){!function(t){!function(t){class n{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}static getRootAsFooter(e,t){return(t||new n).__init(e.readInt32(e.position())+e.position(),e)}version(){let e=this.bb.__offset(this.bb_pos,4);return e?this.bb.readInt16(this.bb_pos+e):oA.apache.arrow.flatbuf.MetadataVersion.V1}schema(e){let t=this.bb.__offset(this.bb_pos,6);return t?(e||new oA.apache.arrow.flatbuf.Schema).__init(this.bb.__indirect(this.bb_pos+t),this.bb):null}dictionaries(t,n){let r=this.bb.__offset(this.bb_pos,8);return r?(n||new e.apache.arrow.flatbuf.Block).__init(this.bb.__vector(this.bb_pos+r)+24*t,this.bb):null}dictionariesLength(){let e=this.bb.__offset(this.bb_pos,8);return e?this.bb.__vector_len(this.bb_pos+e):0}recordBatches(t,n){let r=this.bb.__offset(this.bb_pos,10);return r?(n||new e.apache.arrow.flatbuf.Block).__init(this.bb.__vector(this.bb_pos+r)+24*t,this.bb):null}recordBatchesLength(){let e=this.bb.__offset(this.bb_pos,10);return e?this.bb.__vector_len(this.bb_pos+e):0}static startFooter(e){e.startObject(4)}static addVersion(e,t){e.addFieldInt16(0,t,oA.apache.arrow.flatbuf.MetadataVersion.V1)}static addSchema(e,t){e.addFieldOffset(1,t,0)}static addDictionaries(e,t){e.addFieldOffset(2,t,0)}static startDictionariesVector(e,t){e.startVector(24,t,8)}static addRecordBatches(e,t){e.addFieldOffset(3,t,0)}static startRecordBatchesVector(e,t){e.startVector(24,t,8)}static endFooter(e){return e.endObject()}static finishFooterBuffer(e,t){e.finish(t)}static createFooter(e,t,r,A,i){return n.startFooter(e),n.addVersion(e,t),n.addSchema(e,r),n.addDictionaries(e,A),n.addRecordBatches(e,i),n.endFooter(e)}}t.Footer=n}(t.flatbuf||(t.flatbuf={}))}(t.arrow||(t.arrow={}))}(e.apache||(e.apache={}))}(no||(no={})),function(e){!function(e){!function(e){(e.flatbuf||(e.flatbuf={})).Block=class{constructor(){this.bb=null,this.bb_pos=0}__init(e,t){return this.bb_pos=e,this.bb=t,this}offset(){return this.bb.readInt64(this.bb_pos)}metaDataLength(){return this.bb.readInt32(this.bb_pos+8)}bodyLength(){return this.bb.readInt64(this.bb_pos+16)}static createBlock(e,t,n,r){return e.prep(8,24),e.writeInt64(r),e.pad(4),e.writeInt32(n),e.writeInt64(t),e.offset()}}}(e.arrow||(e.arrow={}))}(e.apache||(e.apache={}))}(no||(no={}));var ro=Mn.Long,Ao=Mn.Builder,io=Mn.ByteBuffer,so=no.apache.arrow.flatbuf.Block,ao=no.apache.arrow.flatbuf.Footer;class oo{constructor(e,t=_A.V4,n,r){this.schema=e,this.version=t,n&&(this._recordBatches=n),r&&(this._dictionaryBatches=r)}static decode(e){e=new io(Ur(e));const t=ao.getRootAsFooter(e),n=_a.decode(t.schema());return new co(n,t)}static encode(e){const t=new Ao,n=_a.encode(t,e.schema);ao.startRecordBatchesVector(t,e.numRecordBatches),[...e.recordBatches()].slice().reverse().forEach((e=>lo.encode(t,e)));const r=t.endVector();ao.startDictionariesVector(t,e.numDictionaries),[...e.dictionaryBatches()].slice().reverse().forEach((e=>lo.encode(t,e)));const A=t.endVector();return ao.startFooter(t),ao.addSchema(t,n),ao.addVersion(t,_A.V4),ao.addRecordBatches(t,r),ao.addDictionaries(t,A),ao.finishFooterBuffer(t,ao.endFooter(t)),t.asUint8Array()}get numRecordBatches(){return this._recordBatches.length}get numDictionaries(){return this._dictionaryBatches.length}*recordBatches(){for(let e,t=-1,n=this.numRecordBatches;++t<n;)(e=this.getRecordBatch(t))&&(yield e)}*dictionaryBatches(){for(let e,t=-1,n=this.numDictionaries;++t<n;)(e=this.getDictionaryBatch(t))&&(yield e)}getRecordBatch(e){return e>=0&&e<this.numRecordBatches&&this._recordBatches[e]||null}getDictionaryBatch(e){return e>=0&&e<this.numDictionaries&&this._dictionaryBatches[e]||null}}class co extends oo{constructor(e,t){super(e,t.version()),this._footer=t}get numRecordBatches(){return this._footer.recordBatchesLength()}get numDictionaries(){return this._footer.dictionariesLength()}getRecordBatch(e){if(e>=0&&e<this.numRecordBatches){const t=this._footer.recordBatches(e);if(t)return lo.decode(t)}return null}getDictionaryBatch(e){if(e>=0&&e<this.numDictionaries){const t=this._footer.dictionaries(e);if(t)return lo.decode(t)}return null}}class lo{constructor(e,t,n){this.metaDataLength=e,this.offset="number"==typeof n?n:n.low,this.bodyLength="number"==typeof t?t:t.low}static decode(e){return new lo(e.metaDataLength(),e.bodyLength(),e.offset())}static encode(e,t){const{metaDataLength:n}=t,r=new ro(t.offset,0),A=new ro(t.bodyLength,0);return so.createBlock(e,r,n,A)}}class uo extends Xn{write(e){if((e=Ur(e)).byteLength>0)return super.write(e)}toString(e=!1){return e?zn(this.toUint8Array(!0)):this.toUint8Array(!1).then(zn)}toUint8Array(e=!1){return e?vr(this._values)[0]:(async()=>{let e=[],t=0;for await(const n of this)e.push(n),t+=n.byteLength;return vr(e,t)[0]})()}}class ho{constructor(e){e&&(this.source=new po(nA.fromIterable(e)))}[Symbol.iterator](){return this}next(e){return this.source.next(e)}throw(e){return this.source.throw(e)}return(e){return this.source.return(e)}peek(e){return this.source.peek(e)}read(e){return this.source.read(e)}}class fo{constructor(e){e instanceof fo?this.source=e.source:e instanceof uo?this.source=new go(nA.fromAsyncIterable(e)):gr(e)?this.source=new go(nA.fromNodeStream(e)):pr(e)?this.source=new go(nA.fromDOMStream(e)):fr(e)?this.source=new go(nA.fromDOMStream(e.body)):cr(e)?this.source=new go(nA.fromIterable(e)):(or(e)||lr(e))&&(this.source=new go(nA.fromAsyncIterable(e)))}[Symbol.asyncIterator](){return this}next(e){return this.source.next(e)}throw(e){return this.source.throw(e)}return(e){return this.source.return(e)}get closed(){return this.source.closed}cancel(e){return this.source.cancel(e)}peek(e){return this.source.peek(e)}read(e){return this.source.read(e)}}class po{constructor(e){this.source=e}cancel(e){this.return(e)}peek(e){return this.next(e,"peek").value}read(e){return this.next(e,"read").value}next(e,t="read"){return this.source.next({cmd:t,size:e})}throw(e){return Object.create(this.source.throw&&this.source.throw(e)||qn)}return(e){return Object.create(this.source.return&&this.source.return(e)||qn)}}class go{constructor(e){this.source=e,this._closedPromise=new Promise((e=>this._closedPromiseResolve=e))}async cancel(e){await this.return(e)}get closed(){return this._closedPromise}async read(e){return(await this.next(e,"read")).value}async peek(e){return(await this.next(e,"peek")).value}async next(e,t="read"){return await this.source.next({cmd:t,size:e})}async throw(e){const t=this.source.throw&&await this.source.throw(e)||qn;return this._closedPromiseResolve&&this._closedPromiseResolve(),this._closedPromiseResolve=void 0,Object.create(t)}async return(e){const t=this.source.return&&await this.source.return(e)||qn;return this._closedPromiseResolve&&this._closedPromiseResolve(),this._closedPromiseResolve=void 0,Object.create(t)}}class mo extends ho{constructor(e,t){super(),this.position=0,this.buffer=Ur(e),this.size=void 0===t?this.buffer.byteLength:t}readInt32(e){const{buffer:t,byteOffset:n}=this.readAt(e,4);return new DataView(t,n).getInt32(0,!0)}seek(e){return this.position=Math.min(e,this.size),e<this.size}read(e){const{buffer:t,size:n,position:r}=this;return t&&r<n?("number"!=typeof e&&(e=1/0),this.position=Math.min(n,r+Math.min(n-r,e)),t.subarray(r,this.position)):null}readAt(e,t){const n=this.buffer,r=Math.min(this.size,e+t);return n?n.subarray(e,r):new Uint8Array(t)}close(){this.buffer&&(this.buffer=null)}throw(e){return this.close(),{done:!0,value:e}}return(e){return this.close(),{done:!0,value:e}}}class yo extends fo{constructor(e,t){super(),this.position=0,this._handle=e,"number"==typeof t?this.size=t:this._pending=(async()=>{this.size=(await e.stat()).size,delete this._pending})()}async readInt32(e){const{buffer:t,byteOffset:n}=await this.readAt(e,4);return new DataView(t,n).getInt32(0,!0)}async seek(e){return this._pending&&await this._pending,this.position=Math.min(e,this.size),e<this.size}async read(e){this._pending&&await this._pending;const{_handle:t,size:n,position:r}=this;if(t&&r<n){"number"!=typeof e&&(e=1/0);let A=r,i=0,s=0,a=Math.min(n,A+Math.min(n-A,e)),o=new Uint8Array(Math.max(0,(this.position=a)-A));for(;(A+=s)<a&&(i+=s)<o.byteLength;)({bytesRead:s}=await t.read(o,i,o.byteLength-i,A));return o}return null}async readAt(e,t){this._pending&&await this._pending;const{_handle:n,size:r}=this;if(n&&e+t<r){const A=Math.min(r,e+t),i=new Uint8Array(A-e);return(await n.read(i,0,t,e)).buffer}return new Uint8Array(t)}async close(){const e=this._handle;this._handle=null,e&&await e.close()}async throw(e){return await this.close(),{done:!0,value:e}}async return(e){return await this.close(),{done:!0,value:e}}}function wo(e){return e<0&&(e=4294967295+e+1),`0x${e.toString(16)}`}const vo=[1,10,100,1e3,1e4,1e5,1e6,1e7,1e8];class Bo{constructor(e){this.buffer=e}high(){return this.buffer[1]}low(){return this.buffer[0]}_times(e){const t=new Uint32Array([this.buffer[1]>>>16,65535&this.buffer[1],this.buffer[0]>>>16,65535&this.buffer[0]]),n=new Uint32Array([e.buffer[1]>>>16,65535&e.buffer[1],e.buffer[0]>>>16,65535&e.buffer[0]]);let r=t[3]*n[3];this.buffer[0]=65535&r;let A=r>>>16;return r=t[2]*n[3],A+=r,r=t[3]*n[2]>>>0,A+=r,this.buffer[0]+=A<<16,this.buffer[1]=A>>>0<r?65536:0,this.buffer[1]+=A>>>16,this.buffer[1]+=t[1]*n[3]+t[2]*n[2]+t[3]*n[1],this.buffer[1]+=t[0]*n[3]+t[1]*n[2]+t[2]*n[1]+t[3]*n[0]<<16,this}_plus(e){const t=this.buffer[0]+e.buffer[0]>>>0;this.buffer[1]+=e.buffer[1],t<this.buffer[0]>>>0&&++this.buffer[1],this.buffer[0]=t}lessThan(e){return this.buffer[1]<e.buffer[1]||this.buffer[1]===e.buffer[1]&&this.buffer[0]<e.buffer[0]}equals(e){return this.buffer[1]===e.buffer[1]&&this.buffer[0]==e.buffer[0]}greaterThan(e){return e.lessThan(this)}hex(){return`${wo(this.buffer[1])} ${wo(this.buffer[0])}`}}class bo extends Bo{times(e){return this._times(e),this}plus(e){return this._plus(e),this}static from(e,t=new Uint32Array(2)){return bo.fromString("string"==typeof e?e:e.toString(),t)}static fromNumber(e,t=new Uint32Array(2)){return bo.fromString(e.toString(),t)}static fromString(e,t=new Uint32Array(2)){const n=e.length;let r=new bo(t);for(let t=0;t<n;){const A=8<n-t?8:n-t,i=new bo(new Uint32Array([parseInt(e.substr(t,A),10),0])),s=new bo(new Uint32Array([vo[A],0]));r.times(s),r.plus(i),t+=A}return r}static convertArray(e){const t=new Uint32Array(2*e.length);for(let n=-1,r=e.length;++n<r;)bo.from(e[n],new Uint32Array(t.buffer,t.byteOffset+2*n*4,2));return t}static multiply(e,t){return new bo(new Uint32Array(e.buffer)).times(t)}static add(e,t){return new bo(new Uint32Array(e.buffer)).plus(t)}}class _o extends Bo{negate(){return this.buffer[0]=1+~this.buffer[0],this.buffer[1]=~this.buffer[1],0==this.buffer[0]&&++this.buffer[1],this}times(e){return this._times(e),this}plus(e){return this._plus(e),this}lessThan(e){const t=0|this.buffer[1],n=0|e.buffer[1];return t<n||t===n&&this.buffer[0]<e.buffer[0]}static from(e,t=new Uint32Array(2)){return _o.fromString("string"==typeof e?e:e.toString(),t)}static fromNumber(e,t=new Uint32Array(2)){return _o.fromString(e.toString(),t)}static fromString(e,t=new Uint32Array(2)){const n=e.startsWith("-"),r=e.length;let A=new _o(t);for(let t=n?1:0;t<r;){const n=8<r-t?8:r-t,i=new _o(new Uint32Array([parseInt(e.substr(t,n),10),0])),s=new _o(new Uint32Array([vo[n],0]));A.times(s),A.plus(i),t+=n}return n?A.negate():A}static convertArray(e){const t=new Uint32Array(2*e.length);for(let n=-1,r=e.length;++n<r;)_o.from(e[n],new Uint32Array(t.buffer,t.byteOffset+2*n*4,2));return t}static multiply(e,t){return new _o(new Uint32Array(e.buffer)).times(t)}static add(e,t){return new _o(new Uint32Array(e.buffer)).plus(t)}}class Co{constructor(e){this.buffer=e}high(){return new _o(new Uint32Array(this.buffer.buffer,this.buffer.byteOffset+8,2))}low(){return new _o(new Uint32Array(this.buffer.buffer,this.buffer.byteOffset,2))}negate(){return this.buffer[0]=1+~this.buffer[0],this.buffer[1]=~this.buffer[1],this.buffer[2]=~this.buffer[2],this.buffer[3]=~this.buffer[3],0==this.buffer[0]&&++this.buffer[1],0==this.buffer[1]&&++this.buffer[2],0==this.buffer[2]&&++this.buffer[3],this}times(e){const t=new bo(new Uint32Array([this.buffer[3],0])),n=new bo(new Uint32Array([this.buffer[2],0])),r=new bo(new Uint32Array([this.buffer[1],0])),A=new bo(new Uint32Array([this.buffer[0],0])),i=new bo(new Uint32Array([e.buffer[3],0])),s=new bo(new Uint32Array([e.buffer[2],0])),a=new bo(new Uint32Array([e.buffer[1],0])),o=new bo(new Uint32Array([e.buffer[0],0]));let c=bo.multiply(A,o);this.buffer[0]=c.low();let l=new bo(new Uint32Array([c.high(),0]));return c=bo.multiply(r,o),l.plus(c),c=bo.multiply(A,a),l.plus(c),this.buffer[1]=l.low(),this.buffer[3]=l.lessThan(c)?1:0,this.buffer[2]=l.high(),new bo(new Uint32Array(this.buffer.buffer,this.buffer.byteOffset+8,2)).plus(bo.multiply(n,o)).plus(bo.multiply(r,a)).plus(bo.multiply(A,s)),this.buffer[3]+=bo.multiply(t,o).plus(bo.multiply(n,a)).plus(bo.multiply(r,s)).plus(bo.multiply(A,i)).low(),this}plus(e){let t=new Uint32Array(4);return t[3]=this.buffer[3]+e.buffer[3]>>>0,t[2]=this.buffer[2]+e.buffer[2]>>>0,t[1]=this.buffer[1]+e.buffer[1]>>>0,t[0]=this.buffer[0]+e.buffer[0]>>>0,t[0]<this.buffer[0]>>>0&&++t[1],t[1]<this.buffer[1]>>>0&&++t[2],t[2]<this.buffer[2]>>>0&&++t[3],this.buffer[3]=t[3],this.buffer[2]=t[2],this.buffer[1]=t[1],this.buffer[0]=t[0],this}hex(){return`${wo(this.buffer[3])} ${wo(this.buffer[2])} ${wo(this.buffer[1])} ${wo(this.buffer[0])}`}static multiply(e,t){return new Co(new Uint32Array(e.buffer)).times(t)}static add(e,t){return new Co(new Uint32Array(e.buffer)).plus(t)}static from(e,t=new Uint32Array(4)){return Co.fromString("string"==typeof e?e:e.toString(),t)}static fromNumber(e,t=new Uint32Array(4)){return Co.fromString(e.toString(),t)}static fromString(e,t=new Uint32Array(4)){const n=e.startsWith("-"),r=e.length;let A=new Co(t);for(let t=n?1:0;t<r;){const n=8<r-t?8:r-t,i=new Co(new Uint32Array([parseInt(e.substr(t,n),10),0,0,0])),s=new Co(new Uint32Array([vo[n],0,0,0]));A.times(s),A.plus(i),t+=n}return n?A.negate():A}static convertArray(e){const t=new Uint32Array(4*e.length);for(let n=-1,r=e.length;++n<r;)Co.from(e[n],new Uint32Array(t.buffer,t.byteOffset+16*n,4));return t}}class xo extends DA{constructor(e,t,n,r){super(),this.nodesIndex=-1,this.buffersIndex=-1,this.bytes=e,this.nodes=t,this.buffers=n,this.dictionaries=r}visit(e){return super.visit(e instanceof Ca?e.type:e)}visitNull(e,{length:t}=this.nextFieldNode()){return Mi.Null(e,0,t)}visitBool(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Bool(e,0,t,n,this.readNullBitmap(e,n),this.readData(e))}visitInt(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Int(e,0,t,n,this.readNullBitmap(e,n),this.readData(e))}visitFloat(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Float(e,0,t,n,this.readNullBitmap(e,n),this.readData(e))}visitUtf8(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Utf8(e,0,t,n,this.readNullBitmap(e,n),this.readOffsets(e),this.readData(e))}visitBinary(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Binary(e,0,t,n,this.readNullBitmap(e,n),this.readOffsets(e),this.readData(e))}visitFixedSizeBinary(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.FixedSizeBinary(e,0,t,n,this.readNullBitmap(e,n),this.readData(e))}visitDate(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Date(e,0,t,n,this.readNullBitmap(e,n),this.readData(e))}visitTimestamp(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Timestamp(e,0,t,n,this.readNullBitmap(e,n),this.readData(e))}visitTime(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Time(e,0,t,n,this.readNullBitmap(e,n),this.readData(e))}visitDecimal(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Decimal(e,0,t,n,this.readNullBitmap(e,n),this.readData(e))}visitList(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.List(e,0,t,n,this.readNullBitmap(e,n),this.readOffsets(e),this.visit(e.children[0]))}visitStruct(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Struct(e,0,t,n,this.readNullBitmap(e,n),this.visitMany(e.children))}visitUnion(e){return e.mode===vA.Sparse?this.visitSparseUnion(e):this.visitDenseUnion(e)}visitDenseUnion(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Union(e,0,t,n,this.readNullBitmap(e,n),this.readTypeIds(e),this.readOffsets(e),this.visitMany(e.children))}visitSparseUnion(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Union(e,0,t,n,this.readNullBitmap(e,n),this.readTypeIds(e),this.visitMany(e.children))}visitDictionary(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Dictionary(e,0,t,n,this.readNullBitmap(e,n),this.readData(e.indices),this.readDictionary(e))}visitInterval(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Interval(e,0,t,n,this.readNullBitmap(e,n),this.readData(e))}visitFixedSizeList(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.FixedSizeList(e,0,t,n,this.readNullBitmap(e,n),this.visit(e.children[0]))}visitMap(e,{length:t,nullCount:n}=this.nextFieldNode()){return Mi.Map(e,0,t,n,this.readNullBitmap(e,n),this.readOffsets(e),this.visit(e.children[0]))}nextFieldNode(){return this.nodes[++this.nodesIndex]}nextBufferRange(){return this.buffers[++this.buffersIndex]}readNullBitmap(e,t,n=this.nextBufferRange()){return t>0&&this.readData(e,n)||new Uint8Array(0)}readOffsets(e,t){return this.readData(e,t)}readTypeIds(e,t){return this.readData(e,t)}readData(e,{length:t,offset:n}=this.nextBufferRange()){return this.bytes.subarray(n,n+t)}readDictionary(e){return this.dictionaries.get(e.id)}}class Uo extends xo{constructor(e,t,n,r){super(new Uint8Array(0),t,n,r),this.sources=e}readNullBitmap(e,t,{offset:n}=this.nextBufferRange()){return t<=0?new Uint8Array(0):EA(this.sources[n])}readOffsets(e,{offset:t}=this.nextBufferRange()){return Br(Uint8Array,Br(Int32Array,this.sources[t]))}readTypeIds(e,{offset:t}=this.nextBufferRange()){return Br(Uint8Array,Br(e.ArrayType,this.sources[t]))}readData(e,{offset:t}=this.nextBufferRange()){const{sources:n}=this;return GA.isTimestamp(e)||(GA.isInt(e)||GA.isTime(e))&&64===e.bitWidth||GA.isDate(e)&&e.unit===mA.MILLISECOND?Br(Uint8Array,_o.convertArray(n[t])):GA.isDecimal(e)?Br(Uint8Array,Co.convertArray(n[t])):GA.isBinary(e)||GA.isFixedSizeBinary(e)?function(e){const t=e.join(""),n=new Uint8Array(t.length/2);for(let e=0;e<t.length;e+=2)n[e>>1]=parseInt(t.substr(e,2),16);return n}(n[t]):GA.isBool(e)?EA(n[t]):GA.isUtf8(e)?Wn(n[t].join("")):Br(Uint8Array,Br(e.ArrayType,n[t].map((e=>+e))))}}var Fo=Mn.Long,Eo=oA.apache.arrow.flatbuf.Null,Qo=oA.apache.arrow.flatbuf.Int,So=oA.apache.arrow.flatbuf.FloatingPoint,Io=oA.apache.arrow.flatbuf.Binary,ko=oA.apache.arrow.flatbuf.Bool,Do=oA.apache.arrow.flatbuf.Utf8,Mo=oA.apache.arrow.flatbuf.Decimal,To=oA.apache.arrow.flatbuf.Date,Oo=oA.apache.arrow.flatbuf.Time,Lo=oA.apache.arrow.flatbuf.Timestamp,Po=oA.apache.arrow.flatbuf.Interval,Ho=oA.apache.arrow.flatbuf.List,Ro=oA.apache.arrow.flatbuf.Struct_,No=oA.apache.arrow.flatbuf.Union,Vo=oA.apache.arrow.flatbuf.DictionaryEncoding,Ko=oA.apache.arrow.flatbuf.FixedSizeBinary,jo=oA.apache.arrow.flatbuf.FixedSizeList,$o=oA.apache.arrow.flatbuf.Map;const Go=new class extends DA{visit(e,t){return null==e||null==t?void 0:super.visit(e,t)}visitNull(e,t){return Eo.startNull(t),Eo.endNull(t)}visitInt(e,t){return Qo.startInt(t),Qo.addBitWidth(t,e.bitWidth),Qo.addIsSigned(t,e.isSigned),Qo.endInt(t)}visitFloat(e,t){return So.startFloatingPoint(t),So.addPrecision(t,e.precision),So.endFloatingPoint(t)}visitBinary(e,t){return Io.startBinary(t),Io.endBinary(t)}visitBool(e,t){return ko.startBool(t),ko.endBool(t)}visitUtf8(e,t){return Do.startUtf8(t),Do.endUtf8(t)}visitDecimal(e,t){return Mo.startDecimal(t),Mo.addScale(t,e.scale),Mo.addPrecision(t,e.precision),Mo.endDecimal(t)}visitDate(e,t){return To.startDate(t),To.addUnit(t,e.unit),To.endDate(t)}visitTime(e,t){return Oo.startTime(t),Oo.addUnit(t,e.unit),Oo.addBitWidth(t,e.bitWidth),Oo.endTime(t)}visitTimestamp(e,t){const n=e.timezone&&t.createString(e.timezone)||void 0;return Lo.startTimestamp(t),Lo.addUnit(t,e.unit),void 0!==n&&Lo.addTimezone(t,n),Lo.endTimestamp(t)}visitInterval(e,t){return Po.startInterval(t),Po.addUnit(t,e.unit),Po.endInterval(t)}visitList(e,t){return Ho.startList(t),Ho.endList(t)}visitStruct(e,t){return Ro.startStruct_(t),Ro.endStruct_(t)}visitUnion(e,t){No.startTypeIdsVector(t,e.typeIds.length);const n=No.createTypeIdsVector(t,e.typeIds);return No.startUnion(t),No.addMode(t,e.mode),No.addTypeIds(t,n),No.endUnion(t)}visitDictionary(e,t){const n=this.visit(e.indices,t);return Vo.startDictionaryEncoding(t),Vo.addId(t,new Fo(e.id,0)),Vo.addIsOrdered(t,e.isOrdered),void 0!==n&&Vo.addIndexType(t,n),Vo.endDictionaryEncoding(t)}visitFixedSizeBinary(e,t){return Ko.startFixedSizeBinary(t),Ko.addByteWidth(t,e.byteWidth),Ko.endFixedSizeBinary(t)}visitFixedSizeList(e,t){return jo.startFixedSizeList(t),jo.addListSize(t,e.listSize),jo.endFixedSizeList(t)}visitMap(e,t){return $o.startMap(t),$o.addKeysSorted(t,e.keysSorted),$o.endMap(t)}};function zo(e){return new fc(e.count,qo(e.columns),Jo(e.columns))}function Wo(e,t){return(e.children||[]).filter(Boolean).map((e=>Ca.fromJSON(e,t)))}function qo(e){return(e||[]).reduce(((e,t)=>{return[...e,new mc(t.count,(n=t.VALIDITY,(n||[]).reduce(((e,t)=>e+ +(0===t)),0))),...qo(t.children)];var n}),[])}function Jo(e,t=[]){for(let n=-1,r=(e||[]).length;++n<r;){const r=e[n];r.VALIDITY&&t.push(new gc(t.length,r.VALIDITY.length)),r.TYPE&&t.push(new gc(t.length,r.TYPE.length)),r.OFFSET&&t.push(new gc(t.length,r.OFFSET.length)),r.DATA&&t.push(new gc(t.length,r.DATA.length)),t=Jo(r.children,t)}return t}function Yo(e){return new Map(Object.entries(e||{}))}function Xo(e){return new qA(e.isSigned,e.bitWidth)}function Zo(e,t){const n=e.type.name;switch(n){case"NONE":case"null":return new WA;case"binary":return new oi;case"utf8":return new ci;case"bool":return new li;case"list":return new Ci((t||[])[0]);case"struct":case"struct_":return new xi(t||[])}switch(n){case"int":{const t=e.type;return new qA(t.isSigned,t.bitWidth)}case"floatingpoint":{const t=e.type;return new Ai(wA[t.precision])}case"decimal":{const t=e.type;return new ui(t.scale,t.precision)}case"date":{const t=e.type;return new hi(mA[t.unit])}case"time":{const t=e.type;return new pi(yA[t.unit],t.bitWidth)}case"timestamp":{const t=e.type;return new vi(yA[t.unit],t.timezone)}case"interval":{const t=e.type;return new Bi(BA[t.unit])}case"union":{const n=e.type;return new Ui(vA[n.mode],n.typeIds||[],t||[])}case"fixedsizebinary":{const t=e.type;return new Fi(t.byteWidth)}case"fixedsizelist":{const n=e.type;return new Ei(n.listSize,(t||[])[0])}case"map":{const n=e.type;return new Qi((t||[])[0],n.keysSorted)}}throw new Error(`Unrecognized type: "${n}"`)}var ec=Mn.Long,tc=Mn.Builder,nc=Mn.ByteBuffer,rc=oA.apache.arrow.flatbuf.Type,Ac=oA.apache.arrow.flatbuf.Field,ic=oA.apache.arrow.flatbuf.Schema,sc=oA.apache.arrow.flatbuf.Buffer,ac=hA.apache.arrow.flatbuf.Message,oc=oA.apache.arrow.flatbuf.KeyValue,cc=hA.apache.arrow.flatbuf.FieldNode,lc=oA.apache.arrow.flatbuf.Endianness,uc=hA.apache.arrow.flatbuf.RecordBatch,hc=hA.apache.arrow.flatbuf.DictionaryBatch;class dc{constructor(e,t,n,r){this._version=t,this._headerType=n,this.body=new Uint8Array(0),r&&(this._createHeader=()=>r),this._bodyLength="number"==typeof e?e:e.low}static fromJSON(e,t){const n=new dc(0,_A.V4,t);return n._createHeader=function(e,t){return()=>{switch(t){case bA.Schema:return _a.fromJSON(e);case bA.RecordBatch:return fc.fromJSON(e);case bA.DictionaryBatch:return pc.fromJSON(e)}throw new Error(`Unrecognized Message type: { name: ${bA[t]}, type: ${t} }`)}}(e,t),n}static decode(e){e=new nc(Ur(e));const t=ac.getRootAsMessage(e),n=t.bodyLength(),r=t.version(),A=t.headerType(),i=new dc(n,r,A);return i._createHeader=function(e,t){return()=>{switch(t){case bA.Schema:return _a.decode(e.header(new ic));case bA.RecordBatch:return fc.decode(e.header(new uc),e.version());case bA.DictionaryBatch:return pc.decode(e.header(new hc),e.version())}throw new Error(`Unrecognized Message type: { name: ${bA[t]}, type: ${t} }`)}}(t,A),i}static encode(e){let t=new tc,n=-1;return e.isSchema()?n=_a.encode(t,e.header()):e.isRecordBatch()?n=fc.encode(t,e.header()):e.isDictionaryBatch()&&(n=pc.encode(t,e.header())),ac.startMessage(t),ac.addVersion(t,_A.V4),ac.addHeader(t,n),ac.addHeaderType(t,e.headerType),ac.addBodyLength(t,new ec(e.bodyLength,0)),ac.finishMessageBuffer(t,ac.endMessage(t)),t.asUint8Array()}static from(e,t=0){if(e instanceof _a)return new dc(0,_A.V4,bA.Schema,e);if(e instanceof fc)return new dc(t,_A.V4,bA.RecordBatch,e);if(e instanceof pc)return new dc(t,_A.V4,bA.DictionaryBatch,e);throw new Error(`Unrecognized Message header: ${e}`)}get type(){return this.headerType}get version(){return this._version}get headerType(){return this._headerType}get bodyLength(){return this._bodyLength}header(){return this._createHeader()}isSchema(){return this.headerType===bA.Schema}isRecordBatch(){return this.headerType===bA.RecordBatch}isDictionaryBatch(){return this.headerType===bA.DictionaryBatch}}class fc{constructor(e,t,n){this._nodes=t,this._buffers=n,this._length="number"==typeof e?e:e.low}get nodes(){return this._nodes}get length(){return this._length}get buffers(){return this._buffers}}class pc{constructor(e,t,n=!1){this._data=e,this._isDelta=n,this._id="number"==typeof t?t:t.low}get id(){return this._id}get data(){return this._data}get isDelta(){return this._isDelta}get length(){return this.data.length}get nodes(){return this.data.nodes}get buffers(){return this.data.buffers}}class gc{constructor(e,t){this.offset="number"==typeof e?e:e.low,this.length="number"==typeof t?t:t.low}}class mc{constructor(e,t){this.length="number"==typeof e?e:e.low,this.nullCount="number"==typeof t?t:t.low}}function yc(e,t){const n=[];for(let r,A=-1,i=-1,s=e.childrenLength();++A<s;)(r=e.children(A))&&(n[++i]=Ca.decode(r,t));return n}function wc(e){const t=new Map;if(e)for(let n,r,A=-1,i=0|e.customMetadataLength();++A<i;)(n=e.customMetadata(A))&&null!=(r=n.key())&&t.set(r,n.value());return t}function vc(e){return new qA(e.isSigned(),e.bitWidth())}function Bc(e,t){const n=e.typeType();switch(n){case rc.NONE:case rc.Null:return new WA;case rc.Binary:return new oi;case rc.Utf8:return new ci;case rc.Bool:return new li;case rc.List:return new Ci((t||[])[0]);case rc.Struct_:return new xi(t||[])}switch(n){case rc.Int:{const t=e.type(new oA.apache.arrow.flatbuf.Int);return new qA(t.isSigned(),t.bitWidth())}case rc.FloatingPoint:{const t=e.type(new oA.apache.arrow.flatbuf.FloatingPoint);return new Ai(t.precision())}case rc.Decimal:{const t=e.type(new oA.apache.arrow.flatbuf.Decimal);return new ui(t.scale(),t.precision())}case rc.Date:{const t=e.type(new oA.apache.arrow.flatbuf.Date);return new hi(t.unit())}case rc.Time:{const t=e.type(new oA.apache.arrow.flatbuf.Time);return new pi(t.unit(),t.bitWidth())}case rc.Timestamp:{const t=e.type(new oA.apache.arrow.flatbuf.Timestamp);return new vi(t.unit(),t.timezone())}case rc.Interval:{const t=e.type(new oA.apache.arrow.flatbuf.Interval);return new Bi(t.unit())}case rc.Union:{const n=e.type(new oA.apache.arrow.flatbuf.Union);return new Ui(n.mode(),n.typeIdsArray()||[],t||[])}case rc.FixedSizeBinary:{const t=e.type(new oA.apache.arrow.flatbuf.FixedSizeBinary);return new Fi(t.byteWidth())}case rc.FixedSizeList:{const n=e.type(new oA.apache.arrow.flatbuf.FixedSizeList);return new Ei(n.listSize(),(t||[])[0])}case rc.Map:{const n=e.type(new oA.apache.arrow.flatbuf.Map);return new Qi((t||[])[0],n.keysSorted())}}throw new Error(`Unrecognized type: "${rc[n]}" (${n})`)}Ca.encode=function(e,t){let n=-1,r=-1,A=-1,i=t.type,s=t.typeId;GA.isDictionary(i)?(s=i.dictionary.typeId,A=Go.visit(i,e),r=Go.visit(i.dictionary,e)):r=Go.visit(i,e);const a=(i.children||[]).map((t=>Ca.encode(e,t))),o=Ac.createChildrenVector(e,a),c=t.metadata&&t.metadata.size>0?Ac.createCustomMetadataVector(e,[...t.metadata].map((([t,n])=>{const r=e.createString(`${t}`),A=e.createString(`${n}`);return oc.startKeyValue(e),oc.addKey(e,r),oc.addValue(e,A),oc.endKeyValue(e)}))):-1;return t.name&&(n=e.createString(t.name)),Ac.startField(e),Ac.addType(e,r),Ac.addTypeType(e,s),Ac.addChildren(e,o),Ac.addNullable(e,!!t.nullable),-1!==n&&Ac.addName(e,n),-1!==A&&Ac.addDictionary(e,A),-1!==c&&Ac.addCustomMetadata(e,c),Ac.endField(e)},Ca.decode=function(e,t){let n,r,A,i,s,a;return t&&(a=e.dictionary())?t.has(n=a.id().low)?(i=(i=a.indexType())?vc(i):new XA,s=new ki(t.get(n),i,n,a.isOrdered()),r=new Ca(e.name(),s,e.nullable(),wc(e))):(i=(i=a.indexType())?vc(i):new XA,t.set(n,A=Bc(e,yc(e,t))),s=new ki(A,i,n,a.isOrdered()),r=new Ca(e.name(),s,e.nullable(),wc(e))):(A=Bc(e,yc(e,t)),r=new Ca(e.name(),A,e.nullable(),wc(e))),r||null},Ca.fromJSON=function(e,t){let n,r,A,i,s,a;return t&&(i=e.dictionary)?t.has(n=i.id)?(r=(r=i.indexType)?Xo(r):new XA,a=new ki(t.get(n),r,n,i.isOrdered),A=new Ca(e.name,a,e.nullable,Yo(e.customMetadata))):(r=(r=i.indexType)?Xo(r):new XA,t.set(n,s=Zo(e,Wo(e,t))),a=new ki(s,r,n,i.isOrdered),A=new Ca(e.name,a,e.nullable,Yo(e.customMetadata))):(s=Zo(e,Wo(e,t)),A=new Ca(e.name,s,e.nullable,Yo(e.customMetadata))),A||null},_a.encode=function(e,t){const n=t.fields.map((t=>Ca.encode(e,t)));ic.startFieldsVector(e,n.length);const r=ic.createFieldsVector(e,n),A=t.metadata&&t.metadata.size>0?ic.createCustomMetadataVector(e,[...t.metadata].map((([t,n])=>{const r=e.createString(`${t}`),A=e.createString(`${n}`);return oc.startKeyValue(e),oc.addKey(e,r),oc.addValue(e,A),oc.endKeyValue(e)}))):-1;return ic.startSchema(e),ic.addFields(e,r),ic.addEndianness(e,bc?lc.Little:lc.Big),-1!==A&&ic.addCustomMetadata(e,A),ic.endSchema(e)},_a.decode=function(e,t=new Map){const n=function(e,t){const n=[];for(let r,A=-1,i=-1,s=e.fieldsLength();++A<s;)(r=e.fields(A))&&(n[++i]=Ca.decode(r,t));return n}(e,t);return new _a(n,wc(e),t)},_a.fromJSON=function(e,t=new Map){return new _a(function(e,t){return(e.fields||[]).filter(Boolean).map((e=>Ca.fromJSON(e,t)))}(e,t),Yo(e.customMetadata),t)},fc.encode=function(e,t){const n=t.nodes||[],r=t.buffers||[];uc.startNodesVector(e,n.length),n.slice().reverse().forEach((t=>mc.encode(e,t)));const A=e.endVector();uc.startBuffersVector(e,r.length),r.slice().reverse().forEach((t=>gc.encode(e,t)));const i=e.endVector();return uc.startRecordBatch(e),uc.addLength(e,new ec(t.length,0)),uc.addNodes(e,A),uc.addBuffers(e,i),uc.endRecordBatch(e)},fc.decode=function(e,t=_A.V4){return new fc(e.length(),function(e){const t=[];for(let n,r=-1,A=-1,i=e.nodesLength();++r<i;)(n=e.nodes(r))&&(t[++A]=mc.decode(n));return t}(e),function(e,t){const n=[];for(let r,A=-1,i=-1,s=e.buffersLength();++A<s;)(r=e.buffers(A))&&(t<_A.V4&&(r.bb_pos+=8*(A+1)),n[++i]=gc.decode(r));return n}(e,t))},fc.fromJSON=zo,pc.encode=function(e,t){const n=fc.encode(e,t.data);return hc.startDictionaryBatch(e),hc.addId(e,new ec(t.id,0)),hc.addIsDelta(e,t.isDelta),hc.addData(e,n),hc.endDictionaryBatch(e)},pc.decode=function(e,t=_A.V4){return new pc(fc.decode(e.data(),t),e.id(),e.isDelta())},pc.fromJSON=function(e){return new pc(zo(e.data),e.id,e.isDelta)},mc.encode=function(e,t){return cc.createFieldNode(e,new ec(t.length,0),new ec(t.nullCount,0))},mc.decode=function(e){return new mc(e.length(),e.nullCount())},gc.encode=function(e,t){return sc.createBuffer(e,new ec(t.offset,0),new ec(t.length,0))},gc.decode=function(e){return new gc(e.offset(),e.length())};const bc=function(){const e=new ArrayBuffer(2);return new DataView(e).setInt16(0,256,!0),256===new Int16Array(e)[0]}();var _c=Mn.ByteBuffer;const Cc=e=>`Expected ${bA[e]} Message in stream, but was null or length 0.`,xc=e=>`Header pointer of flatbuffer-encoded ${bA[e]} Message is null or length 0.`,Uc=(e,t)=>`Expected to read ${e} metadata bytes, but only read ${t}.`,Fc=(e,t)=>`Expected to read ${e} bytes for message body, but only read ${t}.`;class Ec{constructor(e){this.source=e instanceof ho?e:new ho(e)}[Symbol.iterator](){return this}next(){let e;return(e=this.readMetadataLength()).done||-1===e.value&&(e=this.readMetadataLength()).done||(e=this.readMetadata(e.value)).done?qn:e}throw(e){return this.source.throw(e)}return(e){return this.source.return(e)}readMessage(e){let t;if((t=this.next()).done)return null;if(null!=e&&t.value.headerType!==e)throw new Error(Cc(e));return t.value}readMessageBody(e){if(e<=0)return new Uint8Array(0);const t=Ur(this.source.read(e));if(t.byteLength<e)throw new Error(Fc(e,t.byteLength));return t.byteOffset%8==0&&t.byteOffset+t.byteLength<=t.buffer.byteLength?t:t.slice()}readSchema(e=!1){const t=bA.Schema,n=this.readMessage(t),r=n&&n.header();if(e&&!r)throw new Error(xc(t));return r}readMetadataLength(){const e=this.source.read(Ic),t=e&&new _c(e),n=t&&t.readInt32(0)||0;return{done:0===n,value:n}}readMetadata(e){const t=this.source.read(e);if(!t)return qn;if(t.byteLength<e)throw new Error(Uc(e,t.byteLength));return{done:!1,value:dc.decode(t)}}}class Qc{constructor(e,t){this.source=e instanceof fo?e:dr(e)?new yo(e,t):new fo(e)}[Symbol.asyncIterator](){return this}async next(){let e;return(e=await this.readMetadataLength()).done||-1===e.value&&(e=await this.readMetadataLength()).done||(e=await this.readMetadata(e.value)).done?qn:e}async throw(e){return await this.source.throw(e)}async return(e){return await this.source.return(e)}async readMessage(e){let t;if((t=await this.next()).done)return null;if(null!=e&&t.value.headerType!==e)throw new Error(Cc(e));return t.value}async readMessageBody(e){if(e<=0)return new Uint8Array(0);const t=Ur(await this.source.read(e));if(t.byteLength<e)throw new Error(Fc(e,t.byteLength));return t.byteOffset%8==0&&t.byteOffset+t.byteLength<=t.buffer.byteLength?t:t.slice()}async readSchema(e=!1){const t=bA.Schema,n=await this.readMessage(t),r=n&&n.header();if(e&&!r)throw new Error(xc(t));return r}async readMetadataLength(){const e=await this.source.read(Ic),t=e&&new _c(e),n=t&&t.readInt32(0)||0;return{done:0===n,value:n}}async readMetadata(e){const t=await this.source.read(e);if(!t)return qn;if(t.byteLength<e)throw new Error(Uc(e,t.byteLength));return{done:!1,value:dc.decode(t)}}}class Sc extends Ec{constructor(e){super(new Uint8Array(0)),this._schema=!1,this._body=[],this._batchIndex=0,this._dictionaryIndex=0,this._json=e instanceof Jn?e:new Jn(e)}next(){const{_json:e}=this;if(!this._schema)return this._schema=!0,{done:!1,value:dc.fromJSON(e.schema,bA.Schema)};if(this._dictionaryIndex<e.dictionaries.length){const t=e.dictionaries[this._dictionaryIndex++];return this._body=t.data.columns,{done:!1,value:dc.fromJSON(t,bA.DictionaryBatch)}}if(this._batchIndex<e.batches.length){const t=e.batches[this._batchIndex++];return this._body=t.columns,{done:!1,value:dc.fromJSON(t,bA.RecordBatch)}}return this._body=[],qn}readMessageBody(e){return function e(t){return(t||[]).reduce(((t,n)=>[...t,...n.VALIDITY&&[n.VALIDITY]||[],...n.TYPE&&[n.TYPE]||[],...n.OFFSET&&[n.OFFSET]||[],...n.DATA&&[n.DATA]||[],...e(n.children)]),[])}(this._body)}readMessage(e){let t;if((t=this.next()).done)return null;if(null!=e&&t.value.headerType!==e)throw new Error(Cc(e));return t.value}readSchema(){const e=bA.Schema,t=this.readMessage(e),n=t&&t.header();if(!t||!n)throw new Error(xc(e));return n}}const Ic=4,kc=new Uint8Array(6);for(let e=0;e<6;e+=1)kc[e]="ARROW1".charCodeAt(e);function Dc(e,t=0){for(let n=-1,r=kc.length;++n<r;)if(kc[n]!==e[t+n])return!1;return!0}const Mc=kc.length,Tc=Mc+Ic,Oc=2*Mc+Ic;class Lc extends DA{constructor(){super(),this._byteLength=0,this._nodes=[],this._buffers=[],this._bufferRegions=[]}static assemble(...e){const t=new Lc,n=ma(Tu,e),[r=t]=t.visitMany(n);return r}visit(e){if(!GA.isDictionary(e.type)){const{data:t,length:n,nullCount:r}=e;if(n>2147483647)throw new RangeError("Cannot write arrays larger than 2^31 - 1 in length");GA.isNull(e.type)||Pc.call(this,r<=0?new Uint8Array(0):FA(t.offset,n,t.nullBitmap)),this.nodes.push(new mc(n,r))}return super.visit(e)}visitNull(e){return this}visitDictionary(e){return this.visit(e.indices)}get nodes(){return this._nodes}get buffers(){return this._buffers}get byteLength(){return this._byteLength}get bufferRegions(){return this._bufferRegions}}function Pc(e){const t=e.byteLength+7&-8;return this.buffers.push(e),this.bufferRegions.push(new gc(this._byteLength,t)),this._byteLength+=t,this}function Hc(e){return Pc.call(this,e.values.subarray(0,e.length*e.stride))}function Rc(e){const{length:t,values:n,valueOffsets:r}=e,A=r[0],i=r[t],s=Math.min(i-A,n.byteLength-A);return Pc.call(this,eA(-r[0],t,r)),Pc.call(this,n.subarray(A,A+s)),this}function Nc(e){const{length:t,valueOffsets:n}=e;return n&&Pc.call(this,eA(n[0],t,n)),this.visit(e.getChildAt(0))}function Vc(e){return this.visitMany(e.type.children.map(((t,n)=>e.getChildAt(n))).filter(Boolean))[0]}Lc.prototype.visitBool=function(e){let t;return e.nullCount>=e.length?Pc.call(this,new Uint8Array(0)):(t=e.values)instanceof Uint8Array?Pc.call(this,FA(e.offset,e.length,t)):Pc.call(this,EA(e))},Lc.prototype.visitInt=Hc,Lc.prototype.visitFloat=Hc,Lc.prototype.visitUtf8=Rc,Lc.prototype.visitBinary=Rc,Lc.prototype.visitFixedSizeBinary=Hc,Lc.prototype.visitDate=Hc,Lc.prototype.visitTimestamp=Hc,Lc.prototype.visitTime=Hc,Lc.prototype.visitDecimal=Hc,Lc.prototype.visitList=Nc,Lc.prototype.visitStruct=Vc,Lc.prototype.visitUnion=function(e){const{type:t,length:n,typeIds:r,valueOffsets:A}=e;if(Pc.call(this,r),t.mode===vA.Sparse)return Vc.call(this,e);if(t.mode===vA.Dense){if(e.offset<=0)return Pc.call(this,A),Vc.call(this,e);{const i=r.reduce(((e,t)=>Math.max(e,t)),r[0]),s=new Int32Array(i+1),a=new Int32Array(i+1).fill(-1),o=new Int32Array(n),c=eA(-A[0],n,A);for(let e,t,A=-1;++A<n;)-1===(t=a[e=r[A]])&&(t=a[e]=c[e]),o[A]=c[A]-t,++s[e];Pc.call(this,o);for(let r,A=-1,i=t.children.length;++A<i;)if(r=e.getChildAt(A)){const e=t.typeIds[A],i=Math.min(n,s[e]);this.visit(r.slice(a[e],i))}}}return this},Lc.prototype.visitInterval=Hc,Lc.prototype.visitFixedSizeList=Nc,Lc.prototype.visitMap=Nc;class Kc extends Yn{constructor(e){super(),this._position=0,this._started=!1,this._sink=new uo,this._schema=null,this._dictionaryBlocks=[],this._recordBatchBlocks=[],this._dictionaryDeltaOffsets=new Map,ar(e)||(e={autoDestroy:!0,writeLegacyIpcFormat:!1}),this._autoDestroy="boolean"!=typeof e.autoDestroy||e.autoDestroy,this._writeLegacyIpcFormat="boolean"==typeof e.writeLegacyIpcFormat&&e.writeLegacyIpcFormat}static throughNode(e){throw new Error('"throughNode" not available in this environment')}static throughDOM(e,t){throw new Error('"throughDOM" not available in this environment')}toString(e=!1){return this._sink.toString(e)}toUint8Array(e=!1){return this._sink.toUint8Array(e)}writeAll(e){return or(e)?e.then((e=>this.writeAll(e))):lr(e)?zc(this,e):Gc(this,e)}get closed(){return this._sink.closed}[Symbol.asyncIterator](){return this._sink[Symbol.asyncIterator]()}toDOMStream(e){return this._sink.toDOMStream(e)}toNodeStream(e){return this._sink.toNodeStream(e)}close(){return this.reset()._sink.close()}abort(e){return this.reset()._sink.abort(e)}finish(){return this._autoDestroy?this.close():this.reset(this._sink,this._schema),this}reset(e=this._sink,t=null){var n;return e===this._sink||e instanceof uo?this._sink=e:(this._sink=new uo,e&&ar(n=e)&&sr(n.abort)&&sr(n.getWriter)&&!(n instanceof Yn)?this.toDOMStream({type:"bytes"}).pipeTo(e):e&&(e=>ar(e)&&sr(e.end)&&sr(e.write)&&ir(e.writable)&&!(e instanceof Yn))(e)&&this.toNodeStream({objectMode:!1}).pipe(e)),this._started&&this._schema&&this._writeFooter(this._schema),this._started=!1,this._dictionaryBlocks=[],this._recordBatchBlocks=[],this._dictionaryDeltaOffsets=new Map,t&&t.compareTo(this._schema)||(null===t?(this._position=0,this._schema=null):(this._started=!0,this._schema=t,this._writeSchema(t))),this}write(e){let t=null;if(!this._sink)throw new Error("RecordBatchWriter is closed");if(null==e)return this.finish()&&void 0;if(e instanceof Mu&&!(t=e.schema))return this.finish()&&void 0;if(e instanceof Tu&&!(t=e.schema))return this.finish()&&void 0;if(t&&!t.compareTo(this._schema)){if(this._started&&this._autoDestroy)return this.close();this.reset(this._sink,t)}e instanceof Tu?e instanceof Ou||this._writeRecordBatch(e):e instanceof Mu?this.writeAll(e.chunks):cr(e)&&this.writeAll(e)}_writeMessage(e,t=8){const n=t-1,r=dc.encode(e),A=r.byteLength,i=this._writeLegacyIpcFormat?4:8,s=A+i+n&~n,a=s-A-i;return e.headerType===bA.RecordBatch?this._recordBatchBlocks.push(new lo(s,e.bodyLength,this._position)):e.headerType===bA.DictionaryBatch&&this._dictionaryBlocks.push(new lo(s,e.bodyLength,this._position)),this._writeLegacyIpcFormat||this._write(Int32Array.of(-1)),this._write(Int32Array.of(s-i)),A>0&&this._write(r),this._writePadding(a)}_write(e){if(this._started){const t=Ur(e);t&&t.byteLength>0&&(this._sink.write(t),this._position+=t.byteLength)}return this}_writeSchema(e){return this._writeMessage(dc.from(e))}_writeFooter(e){return this._writeLegacyIpcFormat?this._write(Int32Array.of(0)):this._write(Int32Array.of(-1,0))}_writeMagic(){return this._write(kc)}_writePadding(e){return e>0?this._write(new Uint8Array(e)):this}_writeRecordBatch(e){const{byteLength:t,nodes:n,bufferRegions:r,buffers:A}=Lc.assemble(e),i=new fc(e.length,n,r),s=dc.from(i,t);return this._writeDictionaries(e)._writeMessage(s)._writeBodyBuffers(A)}_writeDictionaryBatch(e,t,n=!1){this._dictionaryDeltaOffsets.set(t,e.length+(this._dictionaryDeltaOffsets.get(t)||0));const{byteLength:r,nodes:A,bufferRegions:i,buffers:s}=Lc.assemble(e),a=new fc(e.length,A,i),o=new pc(a,t,n),c=dc.from(o,r);return this._writeMessage(c)._writeBodyBuffers(s)}_writeBodyBuffers(e){let t,n,r;for(let A=-1,i=e.length;++A<i;)(t=e[A])&&(n=t.byteLength)>0&&(this._write(t),(r=(n+7&-8)-n)>0&&this._writePadding(r));return this}_writeDictionaries(e){for(let[t,n]of e.dictionaries){let e=this._dictionaryDeltaOffsets.get(t)||0;if(0===e||(n=n.slice(e)).length>0){const r="chunks"in n?n.chunks:[n];for(const n of r)this._writeDictionaryBatch(n,t,e>0),e+=n.length}}return this}}class jc extends Kc{static writeAll(e,t){const n=new jc(t);return or(e)?e.then((e=>n.writeAll(e))):lr(e)?zc(n,e):Gc(n,e)}}class $c extends Kc{static writeAll(e){const t=new $c;return or(e)?e.then((e=>t.writeAll(e))):lr(e)?zc(t,e):Gc(t,e)}constructor(){super(),this._autoDestroy=!0}_writeSchema(e){return this._writeMagic()._writePadding(2)}_writeFooter(e){const t=oo.encode(new oo(e,_A.V4,this._recordBatchBlocks,this._dictionaryBlocks));return super._writeFooter(e)._write(t)._write(Int32Array.of(t.byteLength))._writeMagic()}}function Gc(e,t){let n=t;t instanceof Mu&&(n=t.chunks,e.reset(void 0,t.schema));for(const t of n)e.write(t);return e.finish()}async function zc(e,t){for await(const n of t)e.write(n);return e.finish()}const Wc=new Uint8Array(0),qc=e=>[Wc,Wc,new Uint8Array(e),Wc];function Jc(e,t){return function(e,t){const n=[...e.fields],r=[],A={numBatches:t.reduce(((e,t)=>Math.max(e,t.length)),0)};let i,s=0,a=0,o=-1,c=t.length,l=[];for(;A.numBatches-- >0;){for(a=Number.POSITIVE_INFINITY,o=-1;++o<c;)l[o]=i=t[o].shift(),a=Math.min(a,i?i.length:a);isFinite(a)&&(l=Yc(n,a,l,t,A),a>0&&(r[s++]=[a,l.slice()]))}return[e=new _a(n,e.metadata),r.map((t=>new Tu(e,...t)))]}(e,t.map((e=>e instanceof oa?e.chunks.map((e=>e.data)):[e.data])))}function Yc(e,t,n,r,A){let i,s,a=0,o=-1,c=r.length;const l=(t+63&-64)>>3;for(;++o<c;)(i=n[o])&&(a=i.length)>=t?a===t?n[o]=i:(n[o]=i.slice(0,t),i=i.slice(t,a-t),A.numBatches=Math.max(A.numBatches,r[o].unshift(i))):((s=e[o]).nullable||(e[o]=s.clone({nullable:!0})),n[o]=i?i._changeLengthAndBackfillNullBitmap(t):Mi.new(s.type,0,t,t,qc(l)));return n}class Xc extends aA{constructor(e,t){super(),this._children=t,this.numChildren=e.childData.length,this._bindDataAccessors(this.data=e)}get type(){return this.data.type}get typeId(){return this.data.typeId}get length(){return this.data.length}get offset(){return this.data.offset}get stride(){return this.data.stride}get nullCount(){return this.data.nullCount}get byteLength(){return this.data.byteLength}get VectorName(){return`${dA[this.typeId]}Vector`}get ArrayType(){return this.type.ArrayType}get values(){return this.data.values}get typeIds(){return this.data.typeIds}get nullBitmap(){return this.data.nullBitmap}get valueOffsets(){return this.data.valueOffsets}get[Symbol.toStringTag](){return`${this.VectorName}<${this.type[Symbol.toStringTag]}>`}clone(e,t=this._children){return aA.new(e,t)}concat(...e){return oa.concat(this,...e)}slice(e,t){return na(this,e,t,this._sliceInternal)}isValid(e){if(this.nullCount>0){const t=this.offset+e;return!!(this.nullBitmap[t>>3]&1<<t%8)}return!0}getChildAt(e){return e<0||e>=this.numChildren?null:(this._children||(this._children=[]))[e]||(this._children[e]=aA.new(this.data.childData[e]))}toJSON(){return[...this]}_sliceInternal(e,t,n){return e.clone(e.data.slice(t,n-t),null)}_bindDataAccessors(e){}}Xc.prototype[Symbol.isConcatSpreadable]=!0;class Zc extends Xc{asUtf8(){return aA.new(this.data.clone(new ci))}}class el extends Xc{static from(e){return Du((()=>new li),e)}}class tl extends Xc{static from(...e){return 2===e.length?Du((()=>e[1]===mA.DAY?new di:new fi),e[0]):Du((()=>new fi),e[0])}}class nl extends tl{}class rl extends tl{}class Al extends Xc{}class il extends Xc{constructor(e){super(e),this.indices=aA.new(e.clone(this.type.indices))}static from(...e){if(3===e.length){const[t,n,r]=e,A=new ki(t.type,n,null,null);return aA.new(Mi.Dictionary(A,0,r.length,0,null,r,t))}return Du((()=>e[0].type),e[0])}get dictionary(){return this.data.dictionary}reverseLookup(e){return this.dictionary.indexOf(e)}getKey(e){return this.indices.get(e)}getValue(e){return this.dictionary.get(e)}setKey(e,t){return this.indices.set(e,t)}setValue(e,t){return this.dictionary.set(e,t)}}il.prototype.indices=null;class sl extends Xc{}class al extends Xc{}class ol extends Xc{static from(e){let t=fl(this);if(e instanceof ArrayBuffer||ArrayBuffer.isView(e)){let n=dl(e.constructor)||t;if(null===t&&(t=n),t&&t===n){let n=new t,r=e.byteLength/n.ArrayType.BYTES_PER_ELEMENT;if(!hl(t,e.constructor))return aA.new(Mi.Float(n,0,r,0,null,e))}}if(t)return Du((()=>new t),e);if(e instanceof DataView||e instanceof ArrayBuffer)throw new TypeError(`Cannot infer float type from instance of ${e.constructor.name}`);throw new TypeError("Unrecognized FloatVector input")}}class cl extends ol{toFloat32Array(){return new Float32Array(this)}toFloat64Array(){return new Float64Array(this)}}class ll extends ol{}class ul extends ol{}const hl=(e,t)=>e===ii&&t!==Uint16Array,dl=e=>{switch(e){case Uint16Array:return ii;case Float32Array:return si;case Float64Array:return ai;default:return null}},fl=e=>{switch(e){case cl:return ii;case ll:return si;case ul:return ai;default:return null}};class pl extends Xc{}class gl extends pl{}class ml extends pl{}class yl extends Xc{static from(...e){let[t,n=!1]=e,r=Ql(this,n);if(t instanceof ArrayBuffer||ArrayBuffer.isView(t)){let e=El(t.constructor,n)||r;if(null===r&&(r=e),r&&r===e){let e=new r,n=t.byteLength/e.ArrayType.BYTES_PER_ELEMENT;return Fl(r,t.constructor)&&(n*=.5),aA.new(Mi.Int(e,0,n,0,null,t))}}if(r)return Du((()=>new r),t);if(t instanceof DataView||t instanceof ArrayBuffer)throw new TypeError(`Cannot infer integer type from instance of ${t.constructor.name}`);throw new TypeError("Unrecognized IntVector input")}}class wl extends yl{}class vl extends yl{}class Bl extends yl{}class bl extends yl{toBigInt64Array(){return xr(this.values)}get values64(){return this._values64||(this._values64=this.toBigInt64Array())}}class _l extends yl{}class Cl extends yl{}class xl extends yl{}class Ul extends yl{toBigUint64Array(){return Qr(this.values)}get values64(){return this._values64||(this._values64=this.toBigUint64Array())}}const Fl=(e,t)=>!(e!==ZA&&e!==ri||t!==Int32Array&&t!==Uint32Array),El=(e,t)=>{switch(e){case Int8Array:return JA;case Int16Array:return YA;case Int32Array:return t?ZA:XA;case tr:return ZA;case Uint8Array:return ei;case Uint16Array:return ti;case Uint32Array:return t?ri:ni;case rr:return ri;default:return null}},Ql=(e,t)=>{switch(e){case wl:return JA;case vl:return YA;case Bl:return t?ZA:XA;case bl:return ZA;case _l:return ei;case Cl:return ti;case xl:return t?ri:ni;case Ul:return ri;default:return null}};class Sl extends Xc{}class Il extends Xc{asList(){const e=this.type.children[0];return aA.new(this.data.clone(new Ci(e)))}bind(e){const t=this.getChildAt(0),{[e]:n,[e+1]:r}=this.valueOffsets;return new Js(t.slice(n,r))}}class kl extends Xc{}const Dl=Symbol.for("rowIndex");class Ml extends Xc{bind(e){const t=this._row||(this._row=new Ys(this)),n=Object.create(t);return n[Dl]=e,n}}class Tl extends Xc{}class Ol extends Tl{}class Ll extends Tl{}class Pl extends Tl{}class Hl extends Tl{}class Rl extends Xc{}class Nl extends Rl{}class Vl extends Rl{}class Kl extends Rl{}class jl extends Rl{}class $l extends Xc{get typeIdToChildIndex(){return this.data.type.typeIdToChildIndex}}class Gl extends $l{get valueOffsets(){return this.data.valueOffsets}}class zl extends $l{}class Wl extends Xc{static from(e){return Du((()=>new ci),e)}asBinary(){return aA.new(this.data.clone(new oi))}}function ql(e){return function(){return e(this)}}function Jl(e){return function(t,n){return e(this,t,n)}}class Yl extends DA{}const Xl=(e,t)=>4294967296*e[t+1]+(e[t]>>>0),Zl=e=>new Date(e),eu=(e,t,n)=>{const{[n]:r,[n+1]:A}=t;return null!=r&&null!=A?e.subarray(r,A):null},tu=({values:e},t)=>((e,t)=>Zl(((e,t)=>864e5*e[t])(e,t)))(e,t),nu=({values:e},t)=>((e,t)=>Zl(Xl(e,t)))(e,2*t),ru=({stride:e,values:t},n)=>t[e*n],Au=({stride:e,values:t},n)=>ts(t[e*n]),iu=({stride:e,values:t,type:n},r)=>gs.new(t.subarray(e*r,e*(r+1)),n.isSigned),su=({values:e},t)=>1e3*Xl(e,2*t),au=({values:e},t)=>Xl(e,2*t),ou=({values:e},t)=>((e,t)=>e[t+1]/1e3*4294967296+(e[t]>>>0)/1e3)(e,2*t),cu=({values:e},t)=>((e,t)=>e[t+1]/1e6*4294967296+(e[t]>>>0)/1e6)(e,2*t),lu=({values:e,stride:t},n)=>e[t*n],uu=({values:e,stride:t},n)=>e[t*n],hu=({values:e},t)=>gs.signed(e.subarray(2*t,2*(t+1))),du=({values:e},t)=>gs.signed(e.subarray(2*t,2*(t+1))),fu=(e,t)=>{const n=e.typeIdToChildIndex[e.typeIds[t]],r=e.getChildAt(n);return r?r.get(e.valueOffsets[t]):null},pu=(e,t)=>{const n=e.typeIdToChildIndex[e.typeIds[t]],r=e.getChildAt(n);return r?r.get(t):null},gu=({values:e},t)=>e.subarray(2*t,2*(t+1)),mu=({values:e},t)=>{const n=e[t],r=new Int32Array(2);return r[0]=n/12|0,r[1]=n%12|0,r};Yl.prototype.visitNull=(e,t)=>null,Yl.prototype.visitBool=({offset:e,values:t},n)=>{const r=e+n;return!!(t[r>>3]&1<<r%8)},Yl.prototype.visitInt=(e,t)=>e.type.bitWidth<64?ru(e,t):iu(e,t),Yl.prototype.visitInt8=ru,Yl.prototype.visitInt16=ru,Yl.prototype.visitInt32=ru,Yl.prototype.visitInt64=iu,Yl.prototype.visitUint8=ru,Yl.prototype.visitUint16=ru,Yl.prototype.visitUint32=ru,Yl.prototype.visitUint64=iu,Yl.prototype.visitFloat=(e,t)=>e.type.precision!==wA.HALF?ru(e,t):Au(e,t),Yl.prototype.visitFloat16=Au,Yl.prototype.visitFloat32=ru,Yl.prototype.visitFloat64=ru,Yl.prototype.visitUtf8=({values:e,valueOffsets:t},n)=>{const r=eu(e,t,n);return null!==r?zn(r):null},Yl.prototype.visitBinary=({values:e,valueOffsets:t},n)=>eu(e,t,n),Yl.prototype.visitFixedSizeBinary=({stride:e,values:t},n)=>t.subarray(e*n,e*(n+1)),Yl.prototype.visitDate=(e,t)=>e.type.unit===mA.DAY?tu(e,t):nu(e,t),Yl.prototype.visitDateDay=tu,Yl.prototype.visitDateMillisecond=nu,Yl.prototype.visitTimestamp=(e,t)=>{switch(e.type.unit){case yA.SECOND:return su(e,t);case yA.MILLISECOND:return au(e,t);case yA.MICROSECOND:return ou(e,t);case yA.NANOSECOND:return cu(e,t)}},Yl.prototype.visitTimestampSecond=su,Yl.prototype.visitTimestampMillisecond=au,Yl.prototype.visitTimestampMicrosecond=ou,Yl.prototype.visitTimestampNanosecond=cu,Yl.prototype.visitTime=(e,t)=>{switch(e.type.unit){case yA.SECOND:return lu(e,t);case yA.MILLISECOND:return uu(e,t);case yA.MICROSECOND:return hu(e,t);case yA.NANOSECOND:return du(e,t)}},Yl.prototype.visitTimeSecond=lu,Yl.prototype.visitTimeMillisecond=uu,Yl.prototype.visitTimeMicrosecond=hu,Yl.prototype.visitTimeNanosecond=du,Yl.prototype.visitDecimal=({values:e},t)=>gs.decimal(e.subarray(4*t,4*(t+1))),Yl.prototype.visitList=(e,t)=>{const n=e.getChildAt(0),{valueOffsets:r,stride:A}=e;return n.slice(r[t*A],r[t*A+1])},Yl.prototype.visitStruct=(e,t)=>e.bind(t),Yl.prototype.visitUnion=(e,t)=>e.type.mode===vA.Dense?fu(e,t):pu(e,t),Yl.prototype.visitDenseUnion=fu,Yl.prototype.visitSparseUnion=pu,Yl.prototype.visitDictionary=(e,t)=>e.getValue(e.getKey(t)),Yl.prototype.visitInterval=(e,t)=>e.type.unit===BA.DAY_TIME?gu(e,t):mu(e,t),Yl.prototype.visitIntervalDayTime=gu,Yl.prototype.visitIntervalYearMonth=mu,Yl.prototype.visitFixedSizeList=(e,t)=>{const n=e.getChildAt(0),{stride:r}=e;return n.slice(t*r,(t+1)*r)},Yl.prototype.visitMap=(e,t)=>e.bind(t);const yu=new Yl;class wu extends DA{}function vu(e,t,n){if(void 0===t)return-1;if(null===t)return function(e,t){const{nullBitmap:n}=e.data;if(!n||e.nullCount<=0)return-1;let r=0;for(const A of QA(n,e.data.offset+(t||0),e.length,n,CA)){if(!A)return r;++r}return-1}(e,n);const r=ia(t);for(let t=(n||0)-1,A=e.length;++t<A;)if(r(e.get(t)))return t;return-1}function Bu(e,t,n){const r=ia(t);for(let t=(n||0)-1,A=e.length;++t<A;)if(r(e.get(t)))return t;return-1}wu.prototype.visitNull=function(e,t){return null===t&&e.length>0?0:-1},wu.prototype.visitBool=vu,wu.prototype.visitInt=vu,wu.prototype.visitInt8=vu,wu.prototype.visitInt16=vu,wu.prototype.visitInt32=vu,wu.prototype.visitInt64=vu,wu.prototype.visitUint8=vu,wu.prototype.visitUint16=vu,wu.prototype.visitUint32=vu,wu.prototype.visitUint64=vu,wu.prototype.visitFloat=vu,wu.prototype.visitFloat16=vu,wu.prototype.visitFloat32=vu,wu.prototype.visitFloat64=vu,wu.prototype.visitUtf8=vu,wu.prototype.visitBinary=vu,wu.prototype.visitFixedSizeBinary=vu,wu.prototype.visitDate=vu,wu.prototype.visitDateDay=vu,wu.prototype.visitDateMillisecond=vu,wu.prototype.visitTimestamp=vu,wu.prototype.visitTimestampSecond=vu,wu.prototype.visitTimestampMillisecond=vu,wu.prototype.visitTimestampMicrosecond=vu,wu.prototype.visitTimestampNanosecond=vu,wu.prototype.visitTime=vu,wu.prototype.visitTimeSecond=vu,wu.prototype.visitTimeMillisecond=vu,wu.prototype.visitTimeMicrosecond=vu,wu.prototype.visitTimeNanosecond=vu,wu.prototype.visitDecimal=vu,wu.prototype.visitList=vu,wu.prototype.visitStruct=vu,wu.prototype.visitUnion=vu,wu.prototype.visitDenseUnion=Bu,wu.prototype.visitSparseUnion=Bu,wu.prototype.visitDictionary=vu,wu.prototype.visitInterval=vu,wu.prototype.visitIntervalDayTime=vu,wu.prototype.visitIntervalYearMonth=vu,wu.prototype.visitFixedSizeList=vu,wu.prototype.visitMap=vu;const bu=new wu;class _u extends DA{}function Cu(e){if(e.nullCount>0)return function(e){const t=yu.getVisitFn(e);return QA(e.data.nullBitmap,e.data.offset,e.length,e,((e,n,r,A)=>r&1<<A?t(e,n):null))}(e);const{type:t,typeId:n,length:r}=e;return 1===e.stride&&(n===dA.Timestamp||n===dA.Int&&64!==t.bitWidth||n===dA.Time&&64!==t.bitWidth||n===dA.Float&&t.precision>0)?e.data.values.subarray(0,r)[Symbol.iterator]():function*(t){for(let n=-1;++n<r;)yield t(e,n)}(yu.getVisitFn(e))}_u.prototype.visitNull=Cu,_u.prototype.visitBool=Cu,_u.prototype.visitInt=Cu,_u.prototype.visitInt8=Cu,_u.prototype.visitInt16=Cu,_u.prototype.visitInt32=Cu,_u.prototype.visitInt64=Cu,_u.prototype.visitUint8=Cu,_u.prototype.visitUint16=Cu,_u.prototype.visitUint32=Cu,_u.prototype.visitUint64=Cu,_u.prototype.visitFloat=Cu,_u.prototype.visitFloat16=Cu,_u.prototype.visitFloat32=Cu,_u.prototype.visitFloat64=Cu,_u.prototype.visitUtf8=Cu,_u.prototype.visitBinary=Cu,_u.prototype.visitFixedSizeBinary=Cu,_u.prototype.visitDate=Cu,_u.prototype.visitDateDay=Cu,_u.prototype.visitDateMillisecond=Cu,_u.prototype.visitTimestamp=Cu,_u.prototype.visitTimestampSecond=Cu,_u.prototype.visitTimestampMillisecond=Cu,_u.prototype.visitTimestampMicrosecond=Cu,_u.prototype.visitTimestampNanosecond=Cu,_u.prototype.visitTime=Cu,_u.prototype.visitTimeSecond=Cu,_u.prototype.visitTimeMillisecond=Cu,_u.prototype.visitTimeMicrosecond=Cu,_u.prototype.visitTimeNanosecond=Cu,_u.prototype.visitDecimal=Cu,_u.prototype.visitList=Cu,_u.prototype.visitStruct=Cu,_u.prototype.visitUnion=Cu,_u.prototype.visitDenseUnion=Cu,_u.prototype.visitSparseUnion=Cu,_u.prototype.visitDictionary=Cu,_u.prototype.visitInterval=Cu,_u.prototype.visitIntervalDayTime=Cu,_u.prototype.visitIntervalYearMonth=Cu,_u.prototype.visitFixedSizeList=Cu,_u.prototype.visitMap=Cu;const xu=new _u;class Uu extends DA{}function Fu(e){const{type:t,length:n,stride:r}=e;switch(t.typeId){case dA.Int:case dA.Float:case dA.Decimal:case dA.Time:case dA.Timestamp:return e.data.values.subarray(0,n*r)}return[...xu.visit(e)]}Uu.prototype.visitNull=Fu,Uu.prototype.visitBool=Fu,Uu.prototype.visitInt=Fu,Uu.prototype.visitInt8=Fu,Uu.prototype.visitInt16=Fu,Uu.prototype.visitInt32=Fu,Uu.prototype.visitInt64=Fu,Uu.prototype.visitUint8=Fu,Uu.prototype.visitUint16=Fu,Uu.prototype.visitUint32=Fu,Uu.prototype.visitUint64=Fu,Uu.prototype.visitFloat=Fu,Uu.prototype.visitFloat16=Fu,Uu.prototype.visitFloat32=Fu,Uu.prototype.visitFloat64=Fu,Uu.prototype.visitUtf8=Fu,Uu.prototype.visitBinary=Fu,Uu.prototype.visitFixedSizeBinary=Fu,Uu.prototype.visitDate=Fu,Uu.prototype.visitDateDay=Fu,Uu.prototype.visitDateMillisecond=Fu,Uu.prototype.visitTimestamp=Fu,Uu.prototype.visitTimestampSecond=Fu,Uu.prototype.visitTimestampMillisecond=Fu,Uu.prototype.visitTimestampMicrosecond=Fu,Uu.prototype.visitTimestampNanosecond=Fu,Uu.prototype.visitTime=Fu,Uu.prototype.visitTimeSecond=Fu,Uu.prototype.visitTimeMillisecond=Fu,Uu.prototype.visitTimeMicrosecond=Fu,Uu.prototype.visitTimeNanosecond=Fu,Uu.prototype.visitDecimal=Fu,Uu.prototype.visitList=Fu,Uu.prototype.visitStruct=Fu,Uu.prototype.visitUnion=Fu,Uu.prototype.visitDenseUnion=Fu,Uu.prototype.visitSparseUnion=Fu,Uu.prototype.visitDictionary=Fu,Uu.prototype.visitInterval=Fu,Uu.prototype.visitIntervalDayTime=Fu,Uu.prototype.visitIntervalYearMonth=Fu,Uu.prototype.visitFixedSizeList=Fu,Uu.prototype.visitMap=Fu;const Eu=new Uu,Qu=(e,t)=>e+t,Su=e=>`Cannot compute the byte width of variable-width column ${e}`,Iu=new class extends DA{visitNull(e){return 0}visitInt(e){return e.bitWidth/8}visitFloat(e){return e.ArrayType.BYTES_PER_ELEMENT}visitBinary(e){throw new Error(Su(e))}visitUtf8(e){throw new Error(Su(e))}visitBool(e){return 1/8}visitDecimal(e){return 16}visitDate(e){return 4*(e.unit+1)}visitTime(e){return e.bitWidth/8}visitTimestamp(e){return e.unit===yA.SECOND?4:8}visitInterval(e){return 4*(e.unit+1)}visitList(e){throw new Error(Su(e))}visitStruct(e){return this.visitFields(e.children).reduce(Qu,0)}visitUnion(e){return this.visitFields(e.children).reduce(Qu,0)}visitFixedSizeBinary(e){return e.byteWidth}visitFixedSizeList(e){return e.listSize*this.visitFields(e.children).reduce(Qu,0)}visitMap(e){return this.visitFields(e.children).reduce(Qu,0)}visitDictionary(e){return this.visit(e.indices)}visitFields(e){return(e||[]).map((e=>this.visit(e.type)))}visitSchema(e){return this.visitFields(e.fields).reduce(Qu,0)}},ku=new class extends DA{visitNull(){return kl}visitBool(){return el}visitInt(){return yl}visitInt8(){return wl}visitInt16(){return vl}visitInt32(){return Bl}visitInt64(){return bl}visitUint8(){return _l}visitUint16(){return Cl}visitUint32(){return xl}visitUint64(){return Ul}visitFloat(){return ol}visitFloat16(){return cl}visitFloat32(){return ll}visitFloat64(){return ul}visitUtf8(){return Wl}visitBinary(){return Zc}visitFixedSizeBinary(){return sl}visitDate(){return tl}visitDateDay(){return nl}visitDateMillisecond(){return rl}visitTimestamp(){return Tl}visitTimestampSecond(){return Ol}visitTimestampMillisecond(){return Ll}visitTimestampMicrosecond(){return Pl}visitTimestampNanosecond(){return Hl}visitTime(){return Rl}visitTimeSecond(){return Nl}visitTimeMillisecond(){return Vl}visitTimeMicrosecond(){return Kl}visitTimeNanosecond(){return jl}visitDecimal(){return Al}visitList(){return Sl}visitStruct(){return Ml}visitUnion(){return $l}visitDenseUnion(){return Gl}visitSparseUnion(){return zl}visitDictionary(){return il}visitInterval(){return pl}visitIntervalDayTime(){return gl}visitIntervalYearMonth(){return ml}visitFixedSizeList(){return al}visitMap(){return Il}};function Du(e,t){if(cr(t))return aA.from({nullValues:[null,void 0],type:e(),values:t});if(lr(t))return aA.from({nullValues:[null,void 0],type:e(),values:t});const{values:n=[],type:r=e(),nullValues:A=[null,void 0]}={...t};return cr(n),aA.from({nullValues:A,...t,type:r})}aA.new=function(e,...t){return new(ku.getVisitFn(e)())(e,...t)},aA.from=function(e){const{values:t=[],...n}={nullValues:[null,void 0],...e};if(cr(t)){const e=[...Vi.throughIterable(n)(t)];return 1===e.length?e[0]:oa.concat(e)}return(async e=>{const r=Vi.throughAsyncIterable(n);for await(const n of r(t))e.push(n);return 1===e.length?e[0]:oa.concat(e)})([])},Xc.prototype.get=function(e){return yu.visit(this,e)},Xc.prototype.set=function(e,t){return eo.visit(this,e,t)},Xc.prototype.indexOf=function(e,t){return bu.visit(this,e,t)},Xc.prototype.toArray=function(){return Eu.visit(this)},Xc.prototype.getByteWidth=function(){return Iu.visit(this.type)},Xc.prototype[Symbol.iterator]=function(){return xu.visit(this)},Xc.prototype._bindDataAccessors=function(){const e=this.nullBitmap;var t;e&&e.byteLength>0&&(this.get=(t=this.get,function(e){return this.isValid(e)?t.call(this,e):null}),this.set=function(e){return function(t,n){UA(this.nullBitmap,this.offset+t,!(null==n))&&e.call(this,t,n)}}(this.set))},Object.keys(dA).map((e=>dA[e])).filter((e=>"number"==typeof e)).filter((e=>e!==dA.NONE)).forEach((e=>{const t=ku.visit(e);var n;t.prototype.get=(n=yu.getVisitFn(e),function(e){return n(this,e)}),t.prototype.set=Jl(eo.getVisitFn(e)),t.prototype.indexOf=Jl(bu.getVisitFn(e)),t.prototype.toArray=ql(Eu.getVisitFn(e)),t.prototype.getByteWidth=function(e){return function(){return e(this.type)}}(Iu.getVisitFn(e)),t.prototype[Symbol.iterator]=ql(xu.getVisitFn(e))}));class Mu extends oa{constructor(...e){let t=null;e[0]instanceof _a&&(t=e.shift());let n=fa(Tu,e);if(!t&&!(t=n[0]&&n[0].schema))throw new TypeError("Table must be initialized with a Schema or at least one RecordBatch");n[0]||(n[0]=new Ou(t)),super(new xi(t.fields),n),this._schema=t,this._chunks=n}static empty(e=new _a([])){return new Mu(e,[])}static from(e){if(!e)return Mu.empty();if("object"==typeof e){let t=cr(e.values)?function(e){const{type:t}=e;return t instanceof xi?Mu.fromStruct(Ml.from(e)):null}(e):lr(e.values)?function(e){const{type:t}=e;return t instanceof xi?Ml.from(e).then((e=>Mu.fromStruct(e))):null}(e):null;if(null!==t)return t}let t=Pu.from(e);return or(t)?(async()=>await Mu.from(await t))():t.isSync()&&(t=t.open())?t.schema?new Mu(t.schema,[...t]):Mu.empty():(async e=>{const t=await e,n=t.schema,r=[];if(n){for await(let e of t)r.push(e);return new Mu(n,r)}return Mu.empty()})(t.open())}static async fromAsync(e){return await Mu.from(e)}static fromStruct(e){return Mu.new(e.data.childData,e.type.children)}static new(...e){return new Mu(...(t=(e=>{const[t,n]=ba(e,[[],[]]);return n.map(((e,n)=>e instanceof ua?ua.new(e.field.clone(t[n]),e):e instanceof aA?ua.new(t[n],e):ua.new(t[n],[])))})(e),Jc(new _a(t.map((({field:e})=>e))),t)));var t}get schema(){return this._schema}get length(){return this._length}get chunks(){return this._chunks}get numCols(){return this._numChildren}clone(e=this._chunks){return new Mu(this._schema,e)}getColumn(e){return this.getColumnAt(this.getColumnIndex(e))}getColumnAt(e){return this.getChildAt(e)}getColumnIndex(e){return this._schema.fields.findIndex((t=>t.name===e))}getChildAt(e){if(e<0||e>=this.numChildren)return null;let t,n;const r=this._schema.fields,A=this._children||(this._children=[]);if(n=A[e])return n;if(t=r[e]){const n=this._chunks.map((t=>t.getChildAt(e))).filter((e=>null!=e));if(n.length>0)return A[e]=new ua(t,n)}return null}serialize(e="binary",t=!0){return(t?jc:$c).writeAll(this).toUint8Array(!0)}count(){return this._length}select(...e){const t=this._schema.fields.reduce(((e,t,n)=>e.set(t.name,n)),new Map);return this.selectAt(...e.map((e=>t.get(e))).filter((e=>e>-1)))}selectAt(...e){const t=this._schema.selectAt(...e);return new Mu(t,this._chunks.map((({length:n,data:{childData:r}})=>new Tu(t,n,e.map((e=>r[e])).filter(Boolean)))))}assign(e){const t=this._schema.fields,[n,r]=e.schema.fields.reduce(((e,n,r)=>{const[A,i]=e,s=t.findIndex((e=>e.name===n.name));return~s?i[s]=r:A.push(r),e}),[[],[]]),A=this._schema.assign(e.schema),i=[...t.map(((t,n,A,i=r[n])=>void 0===i?this.getColumnAt(n):e.getColumnAt(i))),...n.map((t=>e.getColumnAt(t)))].filter(Boolean);return new Mu(...Jc(A,i))}}class Tu extends Ml{constructor(...e){let t,n,r=e[0];if(e[1]instanceof Mi)[,t,n]=e;else{const n=r.fields,[,A,i]=e;t=Mi.Struct(new xi(n),0,A,0,null,i)}super(t,n),this._schema=r}static from(e){return cr(e.values),Mu.from(e)}static new(...e){const[t,n]=pa(e),r=n.filter((e=>e instanceof aA));return new Tu(...function(e,t,n=t.reduce(((e,t)=>Math.max(e,t.length)),0)){let r,A,i=-1,s=t.length;const a=[...e.fields],o=[],c=(n+63&-64)>>3;for(;++i<s;)(r=t[i])&&r.length===n?o[i]=r:((A=a[i]).nullable||(a[i]=a[i].clone({nullable:!0})),o[i]=r?r._changeLengthAndBackfillNullBitmap(n):Mi.new(A.type,0,n,n,qc(c)));return[new _a(a),n,o]}(new _a(t),r.map((e=>e.data))))}clone(e,t=this._children){return new Tu(this._schema,e,t)}concat(...e){const t=this._schema,n=oa.flatten(this,...e);return new Mu(t,n.map((({data:e})=>new Tu(t,e))))}get schema(){return this._schema}get numCols(){return this._schema.fields.length}get dictionaries(){return this._dictionaries||(this._dictionaries=Lu.collect(this))}select(...e){const t=this._schema.fields.reduce(((e,t,n)=>e.set(t.name,n)),new Map);return this.selectAt(...e.map((e=>t.get(e))).filter((e=>e>-1)))}selectAt(...e){const t=this._schema.selectAt(...e),n=e.map((e=>this.data.childData[e])).filter(Boolean);return new Tu(t,this.length,n)}}class Ou extends Tu{constructor(e){super(e,0,e.fields.map((e=>Mi.new(e.type,0,0,0))))}}class Lu extends DA{constructor(){super(...arguments),this.dictionaries=new Map}static collect(e){return(new Lu).visit(e.data,new xi(e.schema.fields)).dictionaries}visit(e,t){return GA.isDictionary(t)?this.visitDictionary(e,t):(e.childData.forEach(((e,n)=>this.visit(e,t.children[n].type))),this)}visitDictionary(e,t){const n=e.dictionary;return n&&n.length>0&&this.dictionaries.set(t.id,n),this}}class Pu extends Yn{constructor(e){super(),this._impl=e}get closed(){return this._impl.closed}get schema(){return this._impl.schema}get autoDestroy(){return this._impl.autoDestroy}get dictionaries(){return this._impl.dictionaries}get numDictionaries(){return this._impl.numDictionaries}get numRecordBatches(){return this._impl.numRecordBatches}get footer(){return this._impl.isFile()?this._impl.footer:null}isSync(){return this._impl.isSync()}isAsync(){return this._impl.isAsync()}isFile(){return this._impl.isFile()}isStream(){return this._impl.isStream()}next(){return this._impl.next()}throw(e){return this._impl.throw(e)}return(e){return this._impl.return(e)}cancel(){return this._impl.cancel()}reset(e){return this._impl.reset(e),this._DOMStream=void 0,this._nodeStream=void 0,this}open(e){const t=this._impl.open(e);return or(t)?t.then((()=>this)):this}readRecordBatch(e){return this._impl.isFile()?this._impl.readRecordBatch(e):null}[Symbol.iterator](){return this._impl[Symbol.iterator]()}[Symbol.asyncIterator](){return this._impl[Symbol.asyncIterator]()}toDOMStream(){return nA.toDOMStream(this.isSync()?{[Symbol.iterator]:()=>this}:{[Symbol.asyncIterator]:()=>this})}toNodeStream(){return nA.toNodeStream(this.isSync()?{[Symbol.iterator]:()=>this}:{[Symbol.asyncIterator]:()=>this},{objectMode:!0})}static throughNode(e){throw new Error('"throughNode" not available in this environment')}static throughDOM(e,t){throw new Error('"throughDOM" not available in this environment')}static from(e){return e instanceof Pu?e:ur(e)?function(e){return new Hu(new Wu(e))}(e):dr(e)?async function(e){const{size:t}=await e.stat(),n=new yo(e,t);return t>=Oc&&Dc(await n.readAt(0,Mc+7&-8))?new Vu(new zu(n)):new Ru(new $u(n))}(e):or(e)?(async()=>await Pu.from(await e))():fr(e)||pr(e)||gr(e)||lr(e)?async function(e){const t=await e.peek(Mc+7&-8);return t&&t.byteLength>=4?Dc(t)?new Nu(new Gu(await e.read())):new Ru(new $u(e)):new Ru(new $u(async function*(){}()))}(new fo(e)):function(e){const t=e.peek(Mc+7&-8);return t&&t.byteLength>=4?Dc(t)?new Nu(new Gu(e.read())):new Hu(new ju(e)):new Hu(new ju(function*(){}()))}(new ho(e))}static readAll(e){return e instanceof Pu?e.isSync()?Ju(e):Yu(e):ur(e)||ArrayBuffer.isView(e)||cr(e)||hr(e)?Ju(e):Yu(e)}}class Hu extends Pu{constructor(e){super(e),this._impl=e}[Symbol.iterator](){return this._impl[Symbol.iterator]()}async*[Symbol.asyncIterator](){yield*this[Symbol.iterator]()}}class Ru extends Pu{constructor(e){super(e),this._impl=e}[Symbol.iterator](){throw new Error("AsyncRecordBatchStreamReader is not Iterable")}[Symbol.asyncIterator](){return this._impl[Symbol.asyncIterator]()}}class Nu extends Hu{constructor(e){super(e),this._impl=e}}class Vu extends Ru{constructor(e){super(e),this._impl=e}}class Ku{constructor(e=new Map){this.closed=!1,this.autoDestroy=!0,this._dictionaryIndex=0,this._recordBatchIndex=0,this.dictionaries=e}get numDictionaries(){return this._dictionaryIndex}get numRecordBatches(){return this._recordBatchIndex}isSync(){return!1}isAsync(){return!1}isFile(){return!1}isStream(){return!1}reset(e){return this._dictionaryIndex=0,this._recordBatchIndex=0,this.schema=e,this.dictionaries=new Map,this}_loadRecordBatch(e,t){return new Tu(this.schema,e.length,this._loadVectors(e,t,this.schema.fields))}_loadDictionaryBatch(e,t){const{id:n,isDelta:r,data:A}=e,{dictionaries:i,schema:s}=this,a=i.get(n);if(r||!a){const e=s.dictionaries.get(n);return a&&r?a.concat(aA.new(this._loadVectors(A,t,[e])[0])):aA.new(this._loadVectors(A,t,[e])[0])}return a}_loadVectors(e,t,n){return new xo(t,e.nodes,e.buffers,this.dictionaries).visitMany(n)}}class ju extends Ku{constructor(e,t){super(t),this._reader=ur(e)?new Sc(this._handle=e):new Ec(this._handle=e)}isSync(){return!0}isStream(){return!0}[Symbol.iterator](){return this}cancel(){!this.closed&&(this.closed=!0)&&(this.reset()._reader.return(),this._reader=null,this.dictionaries=null)}open(e){return this.closed||(this.autoDestroy=qu(this,e),this.schema||(this.schema=this._reader.readSchema())||this.cancel()),this}throw(e){return!this.closed&&this.autoDestroy&&(this.closed=!0)?this.reset()._reader.throw(e):qn}return(e){return!this.closed&&this.autoDestroy&&(this.closed=!0)?this.reset()._reader.return(e):qn}next(){if(this.closed)return qn;let e,{_reader:t}=this;for(;e=this._readNextMessageAndValidate();)if(e.isSchema())this.reset(e.header());else{if(e.isRecordBatch()){this._recordBatchIndex++;const n=e.header(),r=t.readMessageBody(e.bodyLength);return{done:!1,value:this._loadRecordBatch(n,r)}}if(e.isDictionaryBatch()){this._dictionaryIndex++;const n=e.header(),r=t.readMessageBody(e.bodyLength),A=this._loadDictionaryBatch(n,r);this.dictionaries.set(n.id,A)}}return this.schema&&0===this._recordBatchIndex?(this._recordBatchIndex++,{done:!1,value:new Ou(this.schema)}):this.return()}_readNextMessageAndValidate(e){return this._reader.readMessage(e)}}class $u extends Ku{constructor(e,t){super(t),this._reader=new Qc(this._handle=e)}isAsync(){return!0}isStream(){return!0}[Symbol.asyncIterator](){return this}async cancel(){!this.closed&&(this.closed=!0)&&(await this.reset()._reader.return(),this._reader=null,this.dictionaries=null)}async open(e){return this.closed||(this.autoDestroy=qu(this,e),this.schema||(this.schema=await this._reader.readSchema())||await this.cancel()),this}async throw(e){return!this.closed&&this.autoDestroy&&(this.closed=!0)?await this.reset()._reader.throw(e):qn}async return(e){return!this.closed&&this.autoDestroy&&(this.closed=!0)?await this.reset()._reader.return(e):qn}async next(){if(this.closed)return qn;let e,{_reader:t}=this;for(;e=await this._readNextMessageAndValidate();)if(e.isSchema())await this.reset(e.header());else{if(e.isRecordBatch()){this._recordBatchIndex++;const n=e.header(),r=await t.readMessageBody(e.bodyLength);return{done:!1,value:this._loadRecordBatch(n,r)}}if(e.isDictionaryBatch()){this._dictionaryIndex++;const n=e.header(),r=await t.readMessageBody(e.bodyLength),A=this._loadDictionaryBatch(n,r);this.dictionaries.set(n.id,A)}}return this.schema&&0===this._recordBatchIndex?(this._recordBatchIndex++,{done:!1,value:new Ou(this.schema)}):await this.return()}async _readNextMessageAndValidate(e){return await this._reader.readMessage(e)}}class Gu extends ju{constructor(e,t){super(e instanceof mo?e:new mo(e),t)}get footer(){return this._footer}get numDictionaries(){return this._footer?this._footer.numDictionaries:0}get numRecordBatches(){return this._footer?this._footer.numRecordBatches:0}isSync(){return!0}isFile(){return!0}open(e){if(!this.closed&&!this._footer){this.schema=(this._footer=this._readFooter()).schema;for(const e of this._footer.dictionaryBatches())e&&this._readDictionaryBatch(this._dictionaryIndex++)}return super.open(e)}readRecordBatch(e){if(this.closed)return null;this._footer||this.open();const t=this._footer&&this._footer.getRecordBatch(e);if(t&&this._handle.seek(t.offset)){const e=this._reader.readMessage(bA.RecordBatch);if(e&&e.isRecordBatch()){const t=e.header(),n=this._reader.readMessageBody(e.bodyLength);return this._loadRecordBatch(t,n)}}return null}_readDictionaryBatch(e){const t=this._footer&&this._footer.getDictionaryBatch(e);if(t&&this._handle.seek(t.offset)){const e=this._reader.readMessage(bA.DictionaryBatch);if(e&&e.isDictionaryBatch()){const t=e.header(),n=this._reader.readMessageBody(e.bodyLength),r=this._loadDictionaryBatch(t,n);this.dictionaries.set(t.id,r)}}}_readFooter(){const{_handle:e}=this,t=e.size-Tc,n=e.readInt32(t),r=e.readAt(t-n,n);return oo.decode(r)}_readNextMessageAndValidate(e){if(this._footer||this.open(),this._footer&&this._recordBatchIndex<this.numRecordBatches){const t=this._footer&&this._footer.getRecordBatch(this._recordBatchIndex);if(t&&this._handle.seek(t.offset))return this._reader.readMessage(e)}return null}}class zu extends $u{constructor(e,...t){const n="number"!=typeof t[0]?t.shift():void 0,r=t[0]instanceof Map?t.shift():void 0;super(e instanceof yo?e:new yo(e,n),r)}get footer(){return this._footer}get numDictionaries(){return this._footer?this._footer.numDictionaries:0}get numRecordBatches(){return this._footer?this._footer.numRecordBatches:0}isFile(){return!0}isAsync(){return!0}async open(e){if(!this.closed&&!this._footer){this.schema=(this._footer=await this._readFooter()).schema;for(const e of this._footer.dictionaryBatches())e&&await this._readDictionaryBatch(this._dictionaryIndex++)}return await super.open(e)}async readRecordBatch(e){if(this.closed)return null;this._footer||await this.open();const t=this._footer&&this._footer.getRecordBatch(e);if(t&&await this._handle.seek(t.offset)){const e=await this._reader.readMessage(bA.RecordBatch);if(e&&e.isRecordBatch()){const t=e.header(),n=await this._reader.readMessageBody(e.bodyLength);return this._loadRecordBatch(t,n)}}return null}async _readDictionaryBatch(e){const t=this._footer&&this._footer.getDictionaryBatch(e);if(t&&await this._handle.seek(t.offset)){const e=await this._reader.readMessage(bA.DictionaryBatch);if(e&&e.isDictionaryBatch()){const t=e.header(),n=await this._reader.readMessageBody(e.bodyLength),r=this._loadDictionaryBatch(t,n);this.dictionaries.set(t.id,r)}}}async _readFooter(){const{_handle:e}=this;e._pending&&await e._pending;const t=e.size-Tc,n=await e.readInt32(t),r=await e.readAt(t-n,n);return oo.decode(r)}async _readNextMessageAndValidate(e){if(this._footer||await this.open(),this._footer&&this._recordBatchIndex<this.numRecordBatches){const t=this._footer.getRecordBatch(this._recordBatchIndex);if(t&&await this._handle.seek(t.offset))return await this._reader.readMessage(e)}return null}}class Wu extends ju{constructor(e,t){super(e,t)}_loadVectors(e,t,n){return new Uo(t,e.nodes,e.buffers,this.dictionaries).visitMany(n)}}function qu(e,t){return t&&"boolean"==typeof t.autoDestroy?t.autoDestroy:e.autoDestroy}function*Ju(e){const t=Pu.from(e);try{if(!t.open({autoDestroy:!1}).closed)do{yield t}while(!t.reset().open().closed)}finally{t.cancel()}}async function*Yu(e){const t=await Pu.from(e);try{if(!(await t.open({autoDestroy:!1})).closed)do{yield t}while(!(await t.reset().open()).closed)}finally{await t.cancel()}}class Xu{constructor(e){this._numChunks=0,this._finished=!1,this._bufferedSize=0;const{readableStrategy:t,writableStrategy:n,queueingStrategy:r="count",...A}=e;this._controller=null,this._builder=Vi.new(A),this._getSize="bytes"!==r?Zu:eh;const{highWaterMark:i=("bytes"===r?16384:1e3)}={...t},{highWaterMark:s=("bytes"===r?16384:1e3)}={...n};this.readable=new ReadableStream({cancel:()=>{this._builder.clear()},pull:e=>{this._maybeFlush(this._builder,this._controller=e)},start:e=>{this._maybeFlush(this._builder,this._controller=e)}},{highWaterMark:i,size:"bytes"!==r?Zu:eh}),this.writable=new WritableStream({abort:()=>{this._builder.clear()},write:()=>{this._maybeFlush(this._builder,this._controller)},close:()=>{this._maybeFlush(this._builder.finish(),this._controller)}},{highWaterMark:s,size:e=>this._writeValueAndReturnChunkSize(e)})}_writeValueAndReturnChunkSize(e){const t=this._bufferedSize;return this._bufferedSize=this._getSize(this._builder.append(e)),this._bufferedSize-t}_maybeFlush(e,t){null!==t&&(this._bufferedSize>=t.desiredSize&&++this._numChunks&&this._enqueue(t,e.toVector()),e.finished&&((e.length>0||0===this._numChunks)&&++this._numChunks&&this._enqueue(t,e.toVector()),!this._finished&&(this._finished=!0)&&this._enqueue(t,null)))}_enqueue(e,t){this._bufferedSize=0,this._controller=null,null===t?e.close():e.enqueue(t)}}const Zu=e=>e.length,eh=e=>e.byteLength;class th{eq(e){return e instanceof th||(e=new nh(e)),new ch(this,e)}le(e){return e instanceof th||(e=new nh(e)),new lh(this,e)}ge(e){return e instanceof th||(e=new nh(e)),new uh(this,e)}lt(e){return new hh(this.ge(e))}gt(e){return new hh(this.le(e))}ne(e){return new hh(this.eq(e))}}class nh extends th{constructor(e){super(),this.v=e}}class rh extends th{constructor(e){super(),this.name=e}bind(e){if(!this.colidx){this.colidx=-1;const t=e.schema.fields;for(let e=-1;++e<t.length;)if(t[e].name===this.name){this.colidx=e;break}if(this.colidx<0)throw new Error(`Failed to bind Col "${this.name}"`)}const t=this.vector=e.getChildAt(this.colidx);return e=>t.get(e)}}class Ah{and(...e){return new ah(this,...e)}or(...e){return new oh(this,...e)}not(){return new hh(this)}}class ih extends Ah{constructor(e,t){super(),this.left=e,this.right=t}bind(e){return this.left instanceof nh?this.right instanceof nh?this._bindLitLit(e,this.left,this.right):this._bindLitCol(e,this.left,this.right):this.right instanceof nh?this._bindColLit(e,this.left,this.right):this._bindColCol(e,this.left,this.right)}}class sh extends Ah{constructor(...e){super(),this.children=e}}sh.prototype.children=Object.freeze([]);class ah extends sh{constructor(...e){e=e.reduce(((e,t)=>e.concat(t instanceof ah?t.children:t)),[]),super(...e)}bind(e){const t=this.children.map((t=>t.bind(e)));return(e,n)=>t.every((t=>t(e,n)))}}class oh extends sh{constructor(...e){e=e.reduce(((e,t)=>e.concat(t instanceof oh?t.children:t)),[]),super(...e)}bind(e){const t=this.children.map((t=>t.bind(e)));return(e,n)=>t.some((t=>t(e,n)))}}class ch extends ih{_bindLitLit(e,t,n){const r=t.v==n.v;return()=>r}_bindColCol(e,t,n){const r=t.bind(e),A=n.bind(e);return(e,t)=>r(e,t)==A(e,t)}_bindColLit(e,t,n){const r=t.bind(e);if(t.vector instanceof il){let e;const r=t.vector;return r.dictionary!==this.lastDictionary?(e=r.reverseLookup(n.v),this.lastDictionary=r.dictionary,this.lastKey=e):e=this.lastKey,-1===e?()=>!1:t=>r.getKey(t)===e}return(e,t)=>r(e,t)==n.v}_bindLitCol(e,t,n){return this._bindColLit(e,n,t)}}class lh extends ih{_bindLitLit(e,t,n){const r=t.v<=n.v;return()=>r}_bindColCol(e,t,n){const r=t.bind(e),A=n.bind(e);return(e,t)=>r(e,t)<=A(e,t)}_bindColLit(e,t,n){const r=t.bind(e);return(e,t)=>r(e,t)<=n.v}_bindLitCol(e,t,n){const r=n.bind(e);return(e,n)=>t.v<=r(e,n)}}class uh extends ih{_bindLitLit(e,t,n){const r=t.v>=n.v;return()=>r}_bindColCol(e,t,n){const r=t.bind(e),A=n.bind(e);return(e,t)=>r(e,t)>=A(e,t)}_bindColLit(e,t,n){const r=t.bind(e);return(e,t)=>r(e,t)>=n.v}_bindLitCol(e,t,n){const r=n.bind(e);return(e,n)=>t.v>=r(e,n)}}class hh extends Ah{constructor(e){super(),this.child=e}bind(e){const t=this.child.bind(e);return(e,n)=>!t(e,n)}}Mu.prototype.countBy=function(e){return new dh(this.chunks).countBy(e)},Mu.prototype.scan=function(e,t){return new dh(this.chunks).scan(e,t)},Mu.prototype.scanReverse=function(e,t){return new dh(this.chunks).scanReverse(e,t)},Mu.prototype.filter=function(e){return new dh(this.chunks).filter(e)};class dh extends Mu{filter(e){return new ph(this.chunks,e)}scan(e,t){const n=this.chunks,r=n.length;for(let A=-1;++A<r;){const r=n[A];t&&t(r);for(let t=-1,n=r.length;++t<n;)e(t,r)}}scanReverse(e,t){const n=this.chunks;for(let r=n.length;--r>=0;){const A=n[r];t&&t(A);for(let t=A.length;--t>=0;)e(t,A)}}countBy(e){const t=this.chunks,n=t.length,r="string"==typeof e?new rh(e):e;r.bind(t[n-1]);const A=r.vector;if(!GA.isDictionary(A.type))throw new Error("countBy currently only supports dictionary-encoded columns");const i=Math.ceil(Math.log(A.length)/Math.log(256)),s=new(4==i?Uint32Array:i>=2?Uint16Array:Uint8Array)(A.dictionary.length);for(let e=-1;++e<n;){const n=t[e];r.bind(n);const A=r.vector.indices;for(let e=-1,t=n.length;++e<t;){let t=A.get(e);null!==t&&s[t]++}}return new fh(A.dictionary,yl.from(s))}}class fh extends Mu{constructor(e,t){const n=new _a([new Ca("values",e.type),new Ca("counts",t.type)]);super(new Tu(n,t.length,[e,t]))}toJSON(){const e=this.getColumnAt(0),t=this.getColumnAt(1),n={};for(let r=-1;++r<this.length;)n[e.get(r)]=t.get(r);return n}}class ph extends dh{constructor(e,t){super(e),this._predicate=t}scan(e,t){const n=this._chunks,r=n.length;for(let A=-1;++A<r;){const r=n[A],i=this._predicate.bind(r);let s=!1;for(let n=-1,A=r.length;++n<A;)i(n,r)&&(t&&!s&&(t(r),s=!0),e(n,r))}}scanReverse(e,t){const n=this._chunks;for(let r=n.length;--r>=0;){const A=n[r],i=this._predicate.bind(A);let s=!1;for(let n=A.length;--n>=0;)i(n,A)&&(t&&!s&&(t(A),s=!0),e(n,A))}}count(){let e=0;const t=this._chunks,n=t.length;for(let r=-1;++r<n;){const n=t[r],A=this._predicate.bind(n);for(let t=-1,r=n.length;++t<r;)A(t,n)&&++e}return e}*[Symbol.iterator](){const e=this._chunks,t=e.length;for(let n=-1;++n<t;){const t=e[n],r=this._predicate.bind(t);for(let e=-1,n=t.length;++e<n;)r(e,t)&&(yield t.get(e))}}filter(e){return new ph(this._chunks,this._predicate.and(e))}countBy(e){const t=this._chunks,n=t.length,r="string"==typeof e?new rh(e):e;r.bind(t[n-1]);const A=r.vector;if(!GA.isDictionary(A.type))throw new Error("countBy currently only supports dictionary-encoded columns");const i=Math.ceil(Math.log(A.length)/Math.log(256)),s=new(4==i?Uint32Array:i>=2?Uint16Array:Uint8Array)(A.dictionary.length);for(let e=-1;++e<n;){const n=t[e],A=this._predicate.bind(n);r.bind(n);const i=r.vector.indices;for(let e=-1,t=n.length;++e<t;){let t=i.get(e);null!==t&&A(e,n)&&s[t]++}}return new fh(A.dictionary,yl.from(s))}}nA.toDOMStream=function(e,t){if(lr(e))return function(e,t){let n=null;const r=t&&"bytes"===t.type||!1,A=t&&t.highWaterMark||2**24;return new ReadableStream({...t,async start(t){await i(t,n||(n=e[Symbol.asyncIterator]()))},async pull(e){n?await i(e,n):e.close()},async cancel(){n&&n.return&&await n.return(),n=null}},{highWaterMark:r?A:void 0,...t});async function i(e,t){let n,A=null,i=e.desiredSize||null;for(;!(A=await t.next(r?i:null)).done;)if(ArrayBuffer.isView(A.value)&&(n=Ur(A.value))&&(null!=i&&r&&(i=i-n.byteLength+1),A.value=n),e.enqueue(A.value),null!=i&&--i<=0)return;e.close()}}(e,t);if(cr(e))return function(e,t){let n=null;const r=t&&"bytes"===t.type||!1,A=t&&t.highWaterMark||2**24;return new ReadableStream({...t,start(t){i(t,n||(n=e[Symbol.iterator]()))},pull(e){n?i(e,n):e.close()},cancel(){n&&n.return&&n.return(),n=null}},{highWaterMark:r?A:void 0,...t});function i(e,t){let n,A=null,i=e.desiredSize||null;for(;!(A=t.next(r?i:null)).done;)if(ArrayBuffer.isView(A.value)&&(n=Ur(A.value))&&(null!=i&&r&&(i=i-n.byteLength+1),A.value=n),e.enqueue(A.value),null!=i&&--i<=0)return;e.close()}}(e,t);throw new Error("toDOMStream() must be called with an Iterable or AsyncIterable")},Vi.throughDOM=function(e){return new Xu(e)},Pu.throughDOM=function(e,t){const n=new uo;let r=null;const A=new ReadableStream({async cancel(){await n.close()},async start(e){await i(e,r||(r=await async function(){return await(await Pu.from(n)).open(t)}()))},async pull(e){r?await i(e,r):e.close()}});return{writable:new WritableStream(n,{highWaterMark:16384,...e}),readable:A};async function i(e,t){let n=e.desiredSize,r=null;for(;!(r=await t.next()).done;)if(e.enqueue(r.value),null!=n&&--n<=0)return;e.close()}},Kc.throughDOM=function(e,t){const n=new this(e),r=new fo(n),A=new ReadableStream({type:"bytes",async cancel(){await r.cancel()},async pull(e){await i(e)},async start(e){await i(e)}},{highWaterMark:16384,...t});return{writable:new WritableStream(n,e),readable:A};async function i(e){let t=null,n=e.desiredSize;for(;t=await r.read(n||null);)if(e.enqueue(t),null!=n&&(n-=t.byteLength)<=0)return;e.close()}};const gh=-12;function mh(e,t=1){return(e*t+63&-64||64)/t}function yh(e,t,n=e.BYTES_PER_ELEMENT){return new e(mh(t,n))}function wh(e){return e instanceof Mi?e:Mi.new(e.type,0,e.length,e.nulls,e.buffers,null,e.dict)}const vh=new TextEncoder,Bh=vh.encodeInto?function(e,t,n){return vh.encodeInto(n,e.subarray(t)).written}:function(e,t,n){const r=vh.encode(n);return e.set(r,t),r.length};function bh(e,t){const n=yh(e.ArrayType,t);return{set(e,t){n[t]=e},data:()=>({type:e,length:t,buffers:[null,n]})}}function _h(e,t){const n=yh(e.ArrayType,t/8);return{set(e,t){e&&(n[t>>3]|=1<<t%8)},data:()=>({type:e,length:t,buffers:[null,n]})}}function Ch(e,t){const n=yh(e.ArrayType,t);return{set(e,t){n[t]=e/864e5|0},data:()=>({type:e,length:t,buffers:[null,n]})}}function xh(e,t){const n=yh(e.ArrayType,t<<1);return{set(e,t){const r=t<<1;n[r]=e%4294967296|0,n[r+1]=e/4294967296|0},data:()=>({type:e,length:t,buffers:[null,n]})}}function Uh(e,t){const n=[],r=yh(e.indices.ArrayType,t),A=Object.create(null);let i=-1,s=0;return{set(e,t){const a=String(e);let o=A[a];void 0===o&&(s+=a.length,A[a]=o=++i,n.push(a)),r[t]=o},data:()=>({type:e,length:t,buffers:[null,r],dict:Fh(e.dictionary,n,s)})}}function Fh(e,t,n){const r=function(e,t,n){const r=yh(Int32Array,t+1),A=yh(Uint8Array,3*n);let i=0;return{set(e,t){i+=Bh(A,i,e),r[t+1]=i},data:()=>{const n=mh(i),s=A.length>n?A.subarray(0,n):A;return{type:e,length:t,buffers:[r,s]}}}}(e,t.length,n);return t.forEach(r.set),A=r.data(),aA.new(wh(A));var A}function Eh(e,t,n,r,A=!0){const i=function(e,t,n=!0){let r;switch(e.typeId){case 2:r=e.bitWidth<64?bh:null;break;case 3:r=e.precision>0?bh:null;break;case-1:r=5===e.dictionary.typeId&&2===e.indices.typeId&&e.indices.bitWidth<64?Uh:null;break;case 6:r=_h;break;case 8:r=e.unit?xh:Ch}return null==r?function(e){const t=Vi.new({type:e,nullValues:[null,void 0],highWaterMark:1/0});return{set(e,n){t.set(n,e)},data:()=>t.finish().flush()}}(e):n?function(e,t){const n=yh(Uint8Array,t/8);let r=0;return{set(t,A){null==t?++r:(e.set(t,A),n[A>>3]|=1<<A%8)},data:()=>{const t=e.data();return r&&(t.nulls=r,t.buffers[2]=n),t}}}(r(e,t),t):r(e,t)}(r,e,A);return t(n,i.set),wh(i.data())}function Qh(e){if(e instanceof GA||null==e)return e;switch(e){case 4:return new oi;case 6:return new li;case-13:return new di;case-14:case 8:return new fi;case-1:return new ki(new ci,new XA);case-10:return new ii;case-11:return new si;case gh:case 3:return new ai;case-2:return new JA;case-3:return new YA;case-4:case 2:return new XA;case-5:return new ZA;case-25:return new bi;case 11:case-26:return new _i;case 1:return new WA;case-21:return new yi;case-20:case 9:return new mi;case-22:return new wi;case-19:return new gi;case-6:return new ei;case-7:return new ti;case-8:return new ni;case-9:return new ri;case 5:return new ci;default:$e(`Unsupported type code: ${Lt(e)}. Use a data type constructor instead?`)}}function Sh(e,t){const n=Ih();return e(t,n.add),n}function Ih(){const e={count:0,nulls:0,bools:0,nums:0,ints:0,bigints:0,min:1/0,max:-1/0,digits:0,dates:0,utcdays:0,strings:0,strlen:0,arrays:0,minlen:1/0,maxlen:0,structs:0,add(t){if(++e.count,null==t)return void++e.nulls;const n=typeof t;if("string"===n)++e.strings;else if("number"===n)++e.nums,t<e.min&&(e.min=t),t>e.max&&(e.max=t),Number.isInteger(t)&&++e.ints;else if("boolean"===n)++e.bools;else if("object"===n)if(Xe(t))++e.dates,0===(r=t).getUTCHours()&&0===r.getUTCMinutes()&&0===r.getUTCSeconds()&&0===r.getUTCMilliseconds()&&++e.utcdays;else if(lt(t)){++e.arrays,t.length<e.minlen&&(e.minlen=t.length),t.length>e.maxlen&&(e.maxlen=t.length);const n=e.array_prof||(e.array_prof=Ih());t.forEach(n.add)}else{++e.structs;const n=e.struct_prof||(e.struct_prof={});for(const e in t)(n[e]||(n[e]=Ih())).add(t[e])}else"bigint"===n&&(++e.bigints,t<e.min&&(e.min=t),t>e.max&&(e.max=t));var r},type:()=>Qh(function(e){const t=e.count-e.nulls;if(0===t)return 1;if(e.ints===t){const t=Math.max(Math.abs(e.min)-1,e.max);return e.min<0?t>=2**31?gh:t<128?-2:t<32768?-3:-4:t>=2**32?gh:t<256?-6:t<65536?-7:-8}if(e.nums===t)return gh;if(e.bigints===t){const t=-e.min>e.max?-e.min-1n:e.max;return e.min<0?t<2**63?-5:$e(`BigInt exceeds 64 bits: ${t}`):e.max<2**64?-9:$e(`BigInt exceeds 64 bits: ${e.max}`)}if(e.bools===t)return 6;if(e.utcdays===t)return-13;if(e.dates===t)return-14;if(e.arrays===t){const t=Ca.new("value",e.array_prof.type(),!0);return e.minlen===e.maxlen?new Ei(e.minlen,t):new Ci(t)}if(e.structs===t){const t=e.struct_prof;return new xi(Object.keys(t).map((e=>Ca.new(e,t[e].type(),!0))))}if(e.strings>0)return-1;$e("Type inference failure")}(e))};return e}function kh(e,t,n,r,A,i=!0){if(!(A=Qh(A))){const e=Sh(r,t);i=e.nulls>0,A=e.type()}return Eh(n,r,t,A,i)}function Dh(e,t,n,r,A,i=!0){A=Qh(A);const s=e.column(t),a=!(e.isFiltered()||e.isOrdered()),o=(c=s)instanceof aA?c:c.vector instanceof aA?c.vector:null;var c;if(o&&a&&Mh(o.type,A))return o;const l=s.data;if(ct(l)){const e=function(e){const t={Float32Array:si,Float64Array:ai,Int8Array:JA,Int16Array:YA,Int32Array:XA,Uint8Array:ei,Uint16Array:ti,Uint32Array:ni,BigInt64Array:ZA,BigUint64Array:ri}[e.constructor.name];return t?new t:null}(l);if(a&&e&&Mh(e,A))return function(e,t){const n=e.length,r=mh(n,e.BYTES_PER_ELEMENT);let A=e;return n!==r&&(A=new e.constructor(r),A.set(e)),wh({type:t,length:n,buffers:[null,A]})}(l,e);A=A||e,i=!1}if(!A){const e=Sh(r,s);i=e.nulls>0,A=e.type()}return Eh(n,r,s,A,i)}function Mh(e,t){return!e||!t||e.compareTo(t)}function Th(e,t,n){const r=Math.min(e.length,n+t);return(t,A)=>{for(let i=n;i<r;++i)A(e[i][t],i)}}function Oh(e,t,n){const r=0===n&&e.numRows()<=t&&!e.isFiltered()&&!e.isOrdered();return(A,i)=>{let s=-1;r&&lt(A.data)?A.data.forEach(i):e.scan((e=>i(A.get(e),++s)),!0,t,n)}}function Lh(){try{return Mu}catch(e){$e("Apache Arrow not imported, see https://github.com/uwdata/arquero#usage")}}const Ph=function(e,t={}){const{types:n={}}=t,{dataFrom:r,names:A,nrows:i,scan:s}=function(e,t){const{columns:n,limit:r=1/0,offset:A=0}=t,i=ze(n)?n(e):Ne(n)?n:null;return Ne(e)?{dataFrom:kh,names:i||Object.keys(e[0]),nrows:Math.min(r,e.length-A),scan:Th(e,r,A)}:function(e){return e&&ze(e.reify)}(e)?{dataFrom:Dh,names:i||e.columnNames(),nrows:Math.min(r,e.numRows()-A),scan:Oh(e,r,A)}:void $e("Unsupported input data type")}(e,t);return Lh().new(A.map((t=>{const A=r(e,t,i,s,n[t]);return A.length===i?A:$e("Column length mismatch")})),A)};function Hh(e,t){return ze(t)?t(e):t||e.columnNames()}function Rh(e,t,n){const r=n.format||{},A=n.align||{},i={},s={};return t.forEach((t=>{const a=function(e,t={}){let n=0,r=0,A=0,i=0,s=0,a=0;return e((e=>{if(++n,null==e)return void++r;const t=typeof e;if("object"===t&&Xe(e))++A,0===(o=e).getUTCHours()&&0===o.getUTCMinutes()&&0===o.getUTCSeconds()&&0===o.getUTCMilliseconds()&&++i;else if("number"===t&&(++s,e==e&&(0|e)!==e)){const t=e+"",n=t.indexOf(".");if(n>=0){const e=t.indexOf("e"),r=e>0?e:t.length;a=Math.max(a,r-n-1)}}var o})),{align:(r+s+A)/n>.5?"r":"l",format:{utc:A===i,digits:Math.min(a,t.maxdigits||6)}}}(function(e,t){const n=e.column(t);return t=>e.scan((e=>t(n.get(e))))}(e,t),n);s[t]=A[t]||a.align,i[t]=r[t]||a.format})),{align:s,format:i}}function Nh(e,t,n=100,r,A){const i=e.data(),s=t.length;e.scan((e=>{A.row(e);for(let n=0;n<s;++n){const r=t[n];A.cell(i[t[n]].get(e),r,n)}}),!0,n,r)}function Vh(e,t={}){if(ze(t))return t(e)+"";const n=typeof e;if("object"===n){if(Xe(e))return t.utc?yt(e):mt(e);{const n=JSON.stringify(e,((e,t)=>ct(t)?Array.from(t):t)),r=t.maxlen||30;return n.length>r?n.slice(0,28)+"…"+("["===n[0]?"]":"}"):n}}if("number"===n){const n=t.digits||0;let r;return 0!==e&&((r=Math.abs(e))>=1e18||r<Math.pow(10,-n))?e.toExponential(n):e.toFixed(n)}return e+""}function Kh(e,t,n={}){for(const r in e)n[r]=t(e[r],r);return n}const jh=e=>Xe(e)?yt(e,!0):e;function $h(e,t){for(const[n,r]of Qn(t))e.set(n,r);return e}function Gh(e,t,n=new Map){return tt(t=Ge(t)?e.columnName(t):t)?n.set(t,t):Ne(t)?t.forEach((t=>Gh(e,t,n))):ze(t)?Gh(e,t(e),n):Ze(t)?$h(n,t):$e(`Invalid column selection: ${Lt(t)}`),n}function zh(e,t){return e.toObject=t,e}function Wh(e){return Ne(e)?e.map(Wh):e&&e.toObject?e.toObject():e}function qh(){return zh((e=>e.columnNames()),(()=>({all:[]})))}function Jh(...e){return e=e.flat(),zh((t=>{const n=Gh(t,e);return t.columnNames((e=>!n.has(e)))}),(()=>({not:Wh(e)})))}class Yh extends qe{static from(e,t){return new Yh(function(e,t){const n=t=>$e(`Illegal argument type: ${t||typeof e}`);return e instanceof Map?nt(e.entries(),t):Xe(e)?n("Date"):et(e)?n("RegExp"):tt(e)?n():Ne(e)?function(e,t){const n=e.length,r={},A=e=>r[e]=Array(n);if(n){const r=(t=t||Object.keys(e[0])).map(A),i=r.length;for(let A=0;A<n;++A){const n=e[A];for(let e=0;e<i;++e)r[e][A]=n[t[e]]}}else t&&t.forEach(A);return r}(e,t):ze(e[Symbol.iterator])?function(e,t){const n={},r=e=>n[e]=[];let A,i;for(const n of e){A||(A=(t=t||Object.keys(n)).map(r),i=A.length);for(let e=0;e<i;++e)A[e].push(n[t[e]])}return!A&&t&&t.forEach(r),n}(e,t):Ze(e)?nt(Object.entries(e),t):n()}(e,t),t)}static new(e,t){if(e instanceof Yh)return e;const n={},r=[];for(const[t,A]of Qn(e))n[t]=A,r.push(t);return new Yh(n,t||r)}constructor(e,t,n,r,A,i){Kh(e,Ye,e),super(t=t||Object.keys(e),t.length?e[t[0]].length:0,e,n,r,A,i)}create({data:e,names:t,filter:n,groups:r,order:A}){const i=void 0!==n?n:this.mask();return new Yh(e||this._data,t||(e?null:this._names),i,void 0!==r?r:function(e,t){if(!e||!t)return e;const{keys:n,rows:r,size:A}=e,i=new Int32Array(A);t.scan((e=>i[n[e]]=1));const s=i.reduce(((e,t)=>e+t),0);if(s===A)return e;const a=Array(s);let o=0;for(let e=0;e<A;++e)i[e]&&(a[i[e]=o++]=r[e]);const c=new Uint32Array(n.length);return t.scan((e=>c[e]=i[n[e]])),{...e,keys:c,rows:a,size:o}}(this._group,n&&i),void 0!==A?A:this._order,this._params)}assign(...e){const t=this.numRows(),n=this.reify(),r=it(n).groupby(n.groups());return e.forEach((e=>{(e=Yh.new(e)).numRows()!==t&&$e("Assign row counts do not match"),(e=e.reify()).columnNames((t=>r.add(t,e.column(t))))})),this.create(r.new())}columns(){return this._data}column(e){return this._data[e]}columnAt(e){return this._data[this._names[e]]}array(e,t=Array){const n=this.column(e),r=new t(this.numRows());let A=-1;return this.scan((e=>r[++A]=n.get(e)),!0),r}get(e,t=0){const n=this.column(e);return this.isFiltered()||this.isOrdered()?n.get(this.indices()[t]):n.get(t)}getter(e){const t=this.column(e),n=this.isFiltered()||this.isOrdered()?this.indices():null;return n?e=>t.get(n[e]):t?e=>t.get(e):$e(`Unrecognized column: ${e}`)}object(e=0){return Xh(this)(e)}objects(e={}){const{grouped:t,limit:n,offset:r}=e,A=Dn(Gh(this,e.columns||qh())),i=[];if(this.scan(((e,t)=>i.push(A(e,t))),!0,n,r),t&&this.isGrouped()){const e=[];return this.scan((t=>e.push(t)),!0,n,r),function(e,t,n,r){const A="map"===r||!0===r?jt:"entries"===r?Gt:"object"===r?$t:$e('groups option must be "map", "entries", or "object".'),{names:i}=e.groups(),s=function(e){e=kt(e)?e:new Set(e);let t="_",n=0;for(;e.has(t);)t="_"+ ++n;return t}(e.columnNames());let a=e.select().reify(t).create({data:{[s]:n}}).rollup({[s]:Vt(s)});for(let e=i.length;--e>=0;)a=a.groupby(i.slice(0,e)).rollup({[s]:A(i[e],s)});return a.get(s)}(this,e,i,t)}return i}*[Symbol.iterator](){const e=Xh(this),t=this.numRows();for(let n=0;n<t;++n)yield e(n)}reify(e){const t=e?e.length:this.numRows(),n=this._names;let r,A;if(!e&&!this.isOrdered()){if(!this.isFiltered())return this;t===this.totalRows()&&(r=this.data())}if(!r){const s=e?t=>e.forEach(t):e=>this.scan(e,!0),a=n.length;r={};for(let e=0;e<a;++e){const A=n[e],a=this.column(A),o=r[A]=new(ct((i=a).data)?i.data.constructor:Array)(t);let c=-1;s((e=>o[++c]=a.get(e)))}this.isGrouped()&&(A=function(e,t,n,r){const{keys:A,rows:i,size:s}=e;let a=i,o=s,c=null;if(n){c=new Int32Array(s),t((e=>c[A[e]]=1));const e=c.reduce(((e,t)=>e+t),0);if(e!==s){a=Array(e),o=0;for(let e=0;e<s;++e)c[e]&&(a[c[e]=o++]=i[e])}}let l=-1;const u=new Uint32Array(r);return t(o!==s?e=>u[++l]=c[A[e]]:e=>u[++l]=A[e]),{...e,keys:u,rows:a,size:o}}(this.groups(),s,!!e,t))}var i;return this.create({data:r,names:n,groups:A,filter:null,order:null})}transform(...e){return e.flat().reduce(((e,t)=>t(e)),this)}toArrow(e){return Ph(this,e)}toArrowBuffer(e){return Ph(this,e).serialize()}toCSV(e){return function(e,t={}){const n=Hh(e,t.columns),r=t.format||{},A=t.delimiter||",",i=new RegExp(`["${A}\n\r]`),s=e=>null==e?"":Xe(e)?yt(e,!0):i.test(e+="")?'"'+e.replace(/"/g,'""')+'"':e,a=n.map(s);let o="";return Nh(e,n,t.limit||1/0,t.offset,{row(){o+=a.join(A)+"\n"},cell(e,t,n){a[n]=s(r[t]?r[t](e):e)}}),o+a.join(A)}(this,e)}toHTML(e){return function(e,t={}){const n=Hh(e,t.columns),{align:r,format:A}=Rh(e,n,t),i=function(e){return Kh(e.style,(e=>ze(e)?e:()=>e))}(t),s=t.null,a=(e,t)=>Vh(e,t).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),o=s?(e,t)=>null==e?s(e):a(e,t):a;let c=-1,l=-1;const u=(e,t,n)=>{const A=n?(e=>"c"===e?"center":"r"===e?"right":"left")(r[t]):"",s=i[e]&&i[e](t,l,c)||"",a=(A?`text-align: ${A};`+(s?" ":""):"")+s;return`<${e}${a?` style="${a}"`:""}>`};let h=u("table")+u("thead")+u("tr",c)+n.map((e=>`${u("th",e,1)}${e}</th>`)).join("")+"</tr></thead>"+u("tbody");return Nh(e,n,t.limit,t.offset,{row(e){c=e,h+=(++l?"</tr>":"")+u("tr")},cell(e,t){h+=u("td",t,1)+o(e,A[t])+"</td>"}}),h+"</tr></tbody></table>"}(this,e)}toJSON(e){return function(e,t={}){const n=function(e,t=!0,n=!1){return void 0===e||e?t:n}(t.schema),r=t.format||{},A=Hh(e,t.columns);let i="{";return n&&(i+='"schema":{"fields":'+JSON.stringify(A.map((e=>({name:e}))))+'},"data":{'),A.forEach(((n,A)=>{i+=(A?",":"")+JSON.stringify(n)+":[";const s=e.column(n),a=r[n]||jh;let o=-1;e.scan((e=>{const t=s.get(e);i+=(++o?",":"")+JSON.stringify(a(t))}),!0,t.limit,t.offset),i+="]"})),i+"}"+(n?"}":"")}(this,e)}toMarkdown(e){return function(e,t={}){const n=Hh(e,t.columns),{align:r,format:A}=Rh(e,n,t),i=e=>e.replace(/\|/g,"\\|");let s="|"+n.map(i).join("|")+"|\n|"+n.map((e=>{return"c"===(t=r[e])?":-:":"r"===t?"-:":":-";var t})).join("|")+"|";return Nh(e,n,t.limit,t.offset,{row(){s+="\n|"},cell(e,t){s+=i(Vh(e,A[t]))+"|"}}),s+"\n"}(this,e)}}function Xh(e){let t=e._builder;if(!t){const n=Dn(e.columnNames()),r=e.data();if(e.isOrdered()||e.isFiltered()){const A=e.indices();t=e=>n(A[e],r)}else t=e=>n(e,r);e._builder=t}return t}class Zh{constructor(e){this._outputs=e}size(){return this._outputs.length}outputs(){return this._outputs}init(){return{}}add(){}rem(){}write(){}}function ed(e,t,n,r){const A=n[e.type]||n.Default;if(A&&!1===A(e,t,r))return;const i=ad[e.type];i&&i(e,t,n)}const td=(e,t,n)=>{ed(e.argument,t,n,e)},nd=(e,t,n)=>{ed(e.left,t,n,e),ed(e.right,t,n,e)},rd=(e,t,n)=>{ed(e.test,t,n,e),ed(e.consequent,t,n,e),e.alternate&&ed(e.alternate,t,n,e)},Ad=(e,t,n)=>{sd(e.params,t,n,e),ed(e.body,t,n,e)},id=(e,t,n)=>{ed(e.callee,t,n,e),sd(e.arguments,t,n,e)},sd=(e,t,n,r)=>{e.forEach((e=>ed(e,t,n,r)))},ad={TemplateLiteral:(e,t,n)=>{sd(e.expressions,t,n,e),sd(e.quasis,t,n,e)},MemberExpression:(e,t,n)=>{ed(e.object,t,n,e),ed(e.property,t,n,e)},CallExpression:id,NewExpression:id,ArrayExpression:(e,t,n)=>{sd(e.elements,t,n,e)},AssignmentExpression:nd,AwaitExpression:td,BinaryExpression:nd,LogicalExpression:nd,UnaryExpression:td,UpdateExpression:td,ConditionalExpression:rd,ObjectExpression:(e,t,n)=>{sd(e.properties,t,n,e)},Property:(e,t,n)=>{ed(e.key,t,n,e),ed(e.value,t,n,e)},ArrowFunctionExpression:Ad,FunctionExpression:Ad,FunctionDeclaration:Ad,VariableDeclaration:(e,t,n)=>{sd(e.declarations,t,n,e)},VariableDeclarator:(e,t,n)=>{ed(e.id,t,n,e),ed(e.init,t,n,e)},SpreadElement:(e,t,n)=>{ed(e.argument,t,n,e)},BlockStatement:(e,t,n)=>{sd(e.body,t,n,e)},ExpressionStatement:(e,t,n)=>{ed(e.expression,t,n,e)},IfStatement:rd,ForStatement:(e,t,n)=>{ed(e.init,t,n,e),ed(e.test,t,n,e),ed(e.update,t,n,e),ed(e.body,t,n,e)},WhileStatement:(e,t,n)=>{ed(e.test,t,n,e),ed(e.body,t,n,e)},DoWhileStatement:(e,t,n)=>{ed(e.body,t,n,e),ed(e.test,t,n,e)},SwitchStatement:(e,t,n)=>{ed(e.discriminant,t,n,e),sd(e.cases,t,n,e)},SwitchCase:(e,t,n)=>{e.test&&ed(e.test,t,n,e),sd(e.consequent,t,n,e)},ReturnStatement:td,Program:(e,t,n)=>{ed(e.body[0],t,n,e)}};function od(e){delete e.start,delete e.end,delete e.optional}function cd(e){od(e),delete e.object,delete e.property,delete e.computed,e.table||delete e.table}function ld(e,t){return t&&t.type===e}function ud(e,t,n){e.aggronly&&$e("Escaped functions are not valid as rollup or pivot values.");const r="(row,data)=>fn("+kn(e.table.columnNames())+",$)";return{escape:Un.escape(r,(A=t.expr,ze(A)?A:()=>A),n)};var A}var hd=[509,0,227,0,150,4,294,9,1368,2,2,1,6,3,41,2,5,0,166,1,574,3,9,9,7,9,32,4,318,1,80,3,71,10,50,3,123,2,54,14,32,10,3,1,11,3,46,10,8,0,46,9,7,2,37,13,2,9,6,1,45,0,13,2,49,13,9,3,2,11,83,11,7,0,3,0,158,11,6,9,7,3,56,1,2,6,3,1,3,2,10,0,11,1,3,6,4,4,68,8,2,0,3,0,2,3,2,4,2,0,15,1,83,17,10,9,5,0,82,19,13,9,214,6,3,8,28,1,83,16,16,9,82,12,9,9,7,19,58,14,5,9,243,14,166,9,71,5,2,1,3,3,2,0,2,1,13,9,120,6,3,6,4,0,29,9,41,6,2,3,9,0,10,10,47,15,343,9,54,7,2,7,17,9,57,21,2,13,123,5,4,0,2,1,2,6,2,0,9,9,49,4,2,1,2,4,9,9,330,3,10,1,2,0,49,6,4,4,14,10,5350,0,7,14,11465,27,2343,9,87,9,39,4,60,6,26,9,535,9,470,0,2,54,8,3,82,0,12,1,19628,1,4178,9,519,45,3,22,543,4,4,5,9,7,3,6,31,3,149,2,1418,49,513,54,5,49,9,0,15,0,23,4,2,14,1361,6,2,16,3,6,2,1,2,4,101,0,161,6,10,9,357,0,62,13,499,13,245,1,2,9,726,6,110,6,6,9,4759,9,787719,239],dd=[0,11,2,25,2,18,2,1,2,14,3,13,35,122,70,52,268,28,4,48,48,31,14,29,6,37,11,29,3,35,5,7,2,4,43,157,19,35,5,35,5,39,9,51,13,10,2,14,2,6,2,1,2,10,2,14,2,6,2,1,4,51,13,310,10,21,11,7,25,5,2,41,2,8,70,5,3,0,2,43,2,1,4,0,3,22,11,22,10,30,66,18,2,1,11,21,11,25,71,55,7,1,65,0,16,3,2,2,2,28,43,28,4,28,36,7,2,27,28,53,11,21,11,18,14,17,111,72,56,50,14,50,14,35,39,27,10,22,251,41,7,1,17,2,60,28,11,0,9,21,43,17,47,20,28,22,13,52,58,1,3,0,14,44,33,24,27,35,30,0,3,0,9,34,4,0,13,47,15,3,22,0,2,0,36,17,2,24,20,1,64,6,2,0,2,3,2,14,2,9,8,46,39,7,3,1,3,21,2,6,2,1,2,4,4,0,19,0,13,4,31,9,2,0,3,0,2,37,2,0,26,0,2,0,45,52,19,3,21,2,31,47,21,1,2,0,185,46,42,3,37,47,21,0,60,42,14,0,72,26,38,6,186,43,117,63,32,7,3,0,3,7,2,1,2,23,16,0,2,0,95,7,3,38,17,0,2,0,29,0,11,39,8,0,22,0,12,45,20,0,19,72,200,32,32,8,2,36,18,0,50,29,113,6,2,1,2,37,22,0,26,5,2,1,2,31,15,0,328,18,16,0,2,12,2,33,125,0,80,921,103,110,18,195,2637,96,16,1071,18,5,26,3994,6,582,6842,29,1763,568,8,30,18,78,18,29,19,47,17,3,32,20,6,18,433,44,212,63,129,74,6,0,67,12,65,1,2,0,29,6135,9,1237,42,9,8936,3,2,6,2,1,2,290,16,0,30,2,3,0,15,3,9,395,2309,106,6,12,4,8,8,9,5991,84,2,70,2,1,3,0,3,1,3,3,2,11,2,0,2,6,2,64,2,3,3,7,2,6,2,27,2,3,2,4,2,0,4,6,2,339,3,24,2,24,2,30,2,24,2,30,2,24,2,30,2,24,2,30,2,24,2,7,1845,30,7,5,262,61,147,44,11,6,17,0,322,29,19,43,485,27,229,29,3,0,496,6,2,3,2,1,2,14,2,196,60,67,8,0,1205,3,2,26,2,1,2,0,3,0,2,9,2,3,2,0,2,0,7,0,5,0,2,0,2,0,2,2,2,1,2,0,3,0,2,0,2,0,2,0,2,0,2,1,2,0,3,3,2,6,2,3,2,3,2,0,2,9,2,16,6,2,2,4,2,16,4421,42719,33,4153,7,221,3,5761,15,7472,16,621,2467,541,1507,4938,6,4191],fd="ªµºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬˮͰ-ʹͶͷͺ-ͽͿΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙՠ-ֈא-תׯ-ײؠ-يٮٯٱ-ۓەۥۦۮۯۺ-ۼۿܐܒ-ܯݍ-ޥޱߊ-ߪߴߵߺࠀ-ࠕࠚࠤࠨࡀ-ࡘࡠ-ࡪࡰ-ࢇࢉ-ࢎࢠ-ࣉऄ-हऽॐक़-ॡॱ-ঀঅ-ঌএঐও-নপ-রলশ-হঽৎড়ঢ়য়-ৡৰৱৼਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽૐૠૡૹଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽଡ଼ଢ଼ୟ-ୡୱஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹௐఅ-ఌఎ-ఐఒ-నప-హఽౘ-ౚౝౠౡಀಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽೝೞೠೡೱೲഄ-ഌഎ-ഐഒ-ഺഽൎൔ-ൖൟ-ൡൺ-ൿඅ-ඖක-නඳ-රලව-ෆก-ะาำเ-ๆກຂຄຆ-ຊຌ-ຣລວ-ະາຳຽເ-ໄໆໜ-ໟༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿၐ-ၕၚ-ၝၡၥၦၮ-ၰၵ-ႁႎႠ-ჅჇჍა-ჺჼ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛮ-ᛸᜀ-ᜑᜟ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗៜᠠ-ᡸᢀ-ᢨᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧᬅ-ᬳᭅ-ᭌᮃ-ᮠᮮᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᲀ-ᲊᲐ-ᲺᲽ-Ჿᳩ-ᳬᳮ-ᳳᳵᳶᳺᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱⁿₐ-ₜℂℇℊ-ℓℕ℘-ℝℤΩℨK-ℹℼ-ℿⅅ-ⅉⅎⅠ-ↈⰀ-ⳤⳫ-ⳮⳲⳳⴀ-ⴥⴧⴭⴰ-ⵧⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞ々-〇〡-〩〱-〵〸-〼ぁ-ゖ゛-ゟァ-ヺー-ヿㄅ-ㄯㄱ-ㆎㆠ-ㆿㇰ-ㇿ㐀-䶿一-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪꘫꙀ-ꙮꙿ-ꚝꚠ-ꛯꜗ-ꜟꜢ-ꞈꞋ-ꟍꟐꟑꟓꟕ-Ƛꟲ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻꣽꣾꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺꩾ-ꪯꪱꪵꪶꪹ-ꪽꫀꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭩꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִײַ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ",pd={3:"abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile",5:"class enum extends super const export import",6:"enum",strict:"implements interface let package private protected public static yield",strictBind:"eval arguments"},gd="break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this",md={5:gd,"5module":gd+" export import",6:gd+" const class extends export import super"},yd=/^in(stanceof)?$/,wd=new RegExp("["+fd+"]"),vd=new RegExp("["+fd+"‌‍·̀-ͯ·҃-֑҇-ׇֽֿׁׂׅׄؐ-ًؚ-٩ٰۖ-ۜ۟-۪ۤۧۨ-ۭ۰-۹ܑܰ-݊ަ-ް߀-߉߫-߽߳ࠖ-࠙ࠛ-ࠣࠥ-ࠧࠩ-࡙࠭-࡛ࢗ-࢟࣊-ࣣ࣡-ःऺ-़ा-ॏ॑-ॗॢॣ०-९ঁ-ঃ়া-ৄেৈো-্ৗৢৣ০-৯৾ਁ-ਃ਼ਾ-ੂੇੈੋ-੍ੑ੦-ੱੵઁ-ઃ઼ા-ૅે-ૉો-્ૢૣ૦-૯ૺ-૿ଁ-ଃ଼ା-ୄେୈୋ-୍୕-ୗୢୣ୦-୯ஂா-ூெ-ைொ-்ௗ௦-௯ఀ-ఄ఼ా-ౄె-ైొ-్ౕౖౢౣ౦-౯ಁ-ಃ಼ಾ-ೄೆ-ೈೊ-್ೕೖೢೣ೦-೯ೳഀ-ഃ഻഼ാ-ൄെ-ൈൊ-്ൗൢൣ൦-൯ඁ-ඃ්ා-ුූෘ-ෟ෦-෯ෲෳัิ-ฺ็-๎๐-๙ັິ-ຼ່-໎໐-໙༘༙༠-༩༹༵༷༾༿ཱ-྄྆྇ྍ-ྗྙ-ྼ࿆ါ-ှ၀-၉ၖ-ၙၞ-ၠၢ-ၤၧ-ၭၱ-ၴႂ-ႍႏ-ႝ፝-፟፩-፱ᜒ-᜕ᜲ-᜴ᝒᝓᝲᝳ឴-៓៝០-៩᠋-᠍᠏-᠙ᢩᤠ-ᤫᤰ-᤻᥆-᥏᧐-᧚ᨗ-ᨛᩕ-ᩞ᩠-᩿᩼-᪉᪐-᪙᪰-᪽ᪿ-ᫎᬀ-ᬄ᬴-᭄᭐-᭙᭫-᭳ᮀ-ᮂᮡ-ᮭ᮰-᮹᯦-᯳ᰤ-᰷᱀-᱉᱐-᱙᳐-᳔᳒-᳨᳭᳴᳷-᳹᷀-᷿‌‍‿⁀⁔⃐-⃥⃜⃡-⃰⳯-⵿⳱ⷠ-〪ⷿ-゙゚〯・꘠-꘩꙯ꙴ-꙽ꚞꚟ꛰꛱ꠂ꠆ꠋꠣ-ꠧ꠬ꢀꢁꢴ-ꣅ꣐-꣙꣠-꣱ꣿ-꤉ꤦ-꤭ꥇ-꥓ꦀ-ꦃ꦳-꧀꧐-꧙ꧥ꧰-꧹ꨩ-ꨶꩃꩌꩍ꩐-꩙ꩻ-ꩽꪰꪲ-ꪴꪷꪸꪾ꪿꫁ꫫ-ꫯꫵ꫶ꯣ-ꯪ꯬꯭꯰-꯹ﬞ︀-️︠-︯︳︴﹍-﹏０-９＿･]");function Bd(e,t){for(var n=65536,r=0;r<t.length;r+=2){if((n+=t[r])>e)return!1;if((n+=t[r+1])>=e)return!0}return!1}function bd(e,t){return e<65?36===e:e<91||(e<97?95===e:e<123||(e<=65535?e>=170&&wd.test(String.fromCharCode(e)):!1!==t&&Bd(e,dd)))}function _d(e,t){return e<48?36===e:e<58||!(e<65)&&(e<91||(e<97?95===e:e<123||(e<=65535?e>=170&&vd.test(String.fromCharCode(e)):!1!==t&&(Bd(e,dd)||Bd(e,hd)))))}var Cd=function(e,t){void 0===t&&(t={}),this.label=e,this.keyword=t.keyword,this.beforeExpr=!!t.beforeExpr,this.startsExpr=!!t.startsExpr,this.isLoop=!!t.isLoop,this.isAssign=!!t.isAssign,this.prefix=!!t.prefix,this.postfix=!!t.postfix,this.binop=t.binop||null,this.updateContext=null};function xd(e,t){return new Cd(e,{beforeExpr:!0,binop:t})}var Ud={beforeExpr:!0},Fd={startsExpr:!0},Ed={};function Qd(e,t){return void 0===t&&(t={}),t.keyword=e,Ed[e]=new Cd(e,t)}var Sd={num:new Cd("num",Fd),regexp:new Cd("regexp",Fd),string:new Cd("string",Fd),name:new Cd("name",Fd),privateId:new Cd("privateId",Fd),eof:new Cd("eof"),bracketL:new Cd("[",{beforeExpr:!0,startsExpr:!0}),bracketR:new Cd("]"),braceL:new Cd("{",{beforeExpr:!0,startsExpr:!0}),braceR:new Cd("}"),parenL:new Cd("(",{beforeExpr:!0,startsExpr:!0}),parenR:new Cd(")"),comma:new Cd(",",Ud),semi:new Cd(";",Ud),colon:new Cd(":",Ud),dot:new Cd("."),question:new Cd("?",Ud),questionDot:new Cd("?."),arrow:new Cd("=>",Ud),template:new Cd("template"),invalidTemplate:new Cd("invalidTemplate"),ellipsis:new Cd("...",Ud),backQuote:new Cd("`",Fd),dollarBraceL:new Cd("${",{beforeExpr:!0,startsExpr:!0}),eq:new Cd("=",{beforeExpr:!0,isAssign:!0}),assign:new Cd("_=",{beforeExpr:!0,isAssign:!0}),incDec:new Cd("++/--",{prefix:!0,postfix:!0,startsExpr:!0}),prefix:new Cd("!/~",{beforeExpr:!0,prefix:!0,startsExpr:!0}),logicalOR:xd("||",1),logicalAND:xd("&&",2),bitwiseOR:xd("|",3),bitwiseXOR:xd("^",4),bitwiseAND:xd("&",5),equality:xd("==/!=/===/!==",6),relational:xd("</>/<=/>=",7),bitShift:xd("<</>>/>>>",8),plusMin:new Cd("+/-",{beforeExpr:!0,binop:9,prefix:!0,startsExpr:!0}),modulo:xd("%",10),star:xd("*",10),slash:xd("/",10),starstar:new Cd("**",{beforeExpr:!0}),coalesce:xd("??",1),_break:Qd("break"),_case:Qd("case",Ud),_catch:Qd("catch"),_continue:Qd("continue"),_debugger:Qd("debugger"),_default:Qd("default",Ud),_do:Qd("do",{isLoop:!0,beforeExpr:!0}),_else:Qd("else",Ud),_finally:Qd("finally"),_for:Qd("for",{isLoop:!0}),_function:Qd("function",Fd),_if:Qd("if"),_return:Qd("return",Ud),_switch:Qd("switch"),_throw:Qd("throw",Ud),_try:Qd("try"),_var:Qd("var"),_const:Qd("const"),_while:Qd("while",{isLoop:!0}),_with:Qd("with"),_new:Qd("new",{beforeExpr:!0,startsExpr:!0}),_this:Qd("this",Fd),_super:Qd("super",Fd),_class:Qd("class",Fd),_extends:Qd("extends",Ud),_export:Qd("export"),_import:Qd("import",Fd),_null:Qd("null",Fd),_true:Qd("true",Fd),_false:Qd("false",Fd),_in:Qd("in",{beforeExpr:!0,binop:7}),_instanceof:Qd("instanceof",{beforeExpr:!0,binop:7}),_typeof:Qd("typeof",{beforeExpr:!0,prefix:!0,startsExpr:!0}),_void:Qd("void",{beforeExpr:!0,prefix:!0,startsExpr:!0}),_delete:Qd("delete",{beforeExpr:!0,prefix:!0,startsExpr:!0})},Id=/\r\n?|\n|\u2028|\u2029/,kd=new RegExp(Id.source,"g");function Dd(e){return 10===e||13===e||8232===e||8233===e}function Md(e,t,n){void 0===n&&(n=e.length);for(var r=t;r<n;r++){var A=e.charCodeAt(r);if(Dd(A))return r<n-1&&13===A&&10===e.charCodeAt(r+1)?r+2:r+1}return-1}var Td=/[\u1680\u2000-\u200a\u202f\u205f\u3000\ufeff]/,Od=/(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g,Ld=Object.prototype,Pd=Ld.hasOwnProperty,Hd=Ld.toString,Rd=Object.hasOwn||function(e,t){return Pd.call(e,t)},Nd=Array.isArray||function(e){return"[object Array]"===Hd.call(e)},Vd=Object.create(null);function Kd(e){return Vd[e]||(Vd[e]=new RegExp("^(?:"+e.replace(/ /g,"|")+")$"))}function jd(e){return e<=65535?String.fromCharCode(e):(e-=65536,String.fromCharCode(55296+(e>>10),56320+(1023&e)))}var $d=/(?:[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])/,Gd=function(e,t){this.line=e,this.column=t};Gd.prototype.offset=function(e){return new Gd(this.line,this.column+e)};var zd=function(e,t,n){this.start=t,this.end=n,null!==e.sourceFile&&(this.source=e.sourceFile)};function Wd(e,t){for(var n=1,r=0;;){var A=Md(e,r,t);if(A<0)return new Gd(n,t-r);++n,r=A}}var qd={ecmaVersion:null,sourceType:"script",onInsertedSemicolon:null,onTrailingComma:null,allowReserved:null,allowReturnOutsideFunction:!1,allowImportExportEverywhere:!1,allowAwaitOutsideFunction:null,allowSuperOutsideMethod:null,allowHashBang:!1,checkPrivateFields:!0,locations:!1,onToken:null,onComment:null,ranges:!1,program:null,sourceFile:null,directSourceFile:null,preserveParens:!1},Jd=!1;function Yd(e,t){return 2|(e?4:0)|(t?8:0)}var Xd=function(e,t,n){this.options=e=function(e){var t={};for(var n in qd)t[n]=e&&Rd(e,n)?e[n]:qd[n];if("latest"===t.ecmaVersion?t.ecmaVersion=1e8:null==t.ecmaVersion?(!Jd&&"object"==typeof console&&console.warn&&(Jd=!0,console.warn("Since Acorn 8.0.0, options.ecmaVersion is required.\nDefaulting to 2020, but this will stop working in the future.")),t.ecmaVersion=11):t.ecmaVersion>=2015&&(t.ecmaVersion-=2009),null==t.allowReserved&&(t.allowReserved=t.ecmaVersion<5),e&&null!=e.allowHashBang||(t.allowHashBang=t.ecmaVersion>=14),Nd(t.onToken)){var r=t.onToken;t.onToken=function(e){return r.push(e)}}return Nd(t.onComment)&&(t.onComment=function(e,t){return function(n,r,A,i,s,a){var o={type:n?"Block":"Line",value:r,start:A,end:i};e.locations&&(o.loc=new zd(this,s,a)),e.ranges&&(o.range=[A,i]),t.push(o)}}(t,t.onComment)),t}(e),this.sourceFile=e.sourceFile,this.keywords=Kd(md[e.ecmaVersion>=6?6:"module"===e.sourceType?"5module":5]);var r="";!0!==e.allowReserved&&(r=pd[e.ecmaVersion>=6?6:5===e.ecmaVersion?5:3],"module"===e.sourceType&&(r+=" await")),this.reservedWords=Kd(r);var A=(r?r+" ":"")+pd.strict;this.reservedWordsStrict=Kd(A),this.reservedWordsStrictBind=Kd(A+" "+pd.strictBind),this.input=String(t),this.containsEsc=!1,n?(this.pos=n,this.lineStart=this.input.lastIndexOf("\n",n-1)+1,this.curLine=this.input.slice(0,this.lineStart).split(Id).length):(this.pos=this.lineStart=0,this.curLine=1),this.type=Sd.eof,this.value=null,this.start=this.end=this.pos,this.startLoc=this.endLoc=this.curPosition(),this.lastTokEndLoc=this.lastTokStartLoc=null,this.lastTokStart=this.lastTokEnd=this.pos,this.context=this.initialContext(),this.exprAllowed=!0,this.inModule="module"===e.sourceType,this.strict=this.inModule||this.strictDirective(this.pos),this.potentialArrowAt=-1,this.potentialArrowInForAwait=!1,this.yieldPos=this.awaitPos=this.awaitIdentPos=0,this.labels=[],this.undefinedExports=Object.create(null),0===this.pos&&e.allowHashBang&&"#!"===this.input.slice(0,2)&&this.skipLineComment(2),this.scopeStack=[],this.enterScope(1),this.regexpState=null,this.privateNameStack=[]},Zd={inFunction:{configurable:!0},inGenerator:{configurable:!0},inAsync:{configurable:!0},canAwait:{configurable:!0},allowSuper:{configurable:!0},allowDirectSuper:{configurable:!0},treatFunctionsAsVar:{configurable:!0},allowNewDotTarget:{configurable:!0},inClassStaticBlock:{configurable:!0}};Xd.prototype.parse=function(){var e=this.options.program||this.startNode();return this.nextToken(),this.parseTopLevel(e)},Zd.inFunction.get=function(){return(2&this.currentVarScope().flags)>0},Zd.inGenerator.get=function(){return(8&this.currentVarScope().flags)>0&&!this.currentVarScope().inClassFieldInit},Zd.inAsync.get=function(){return(4&this.currentVarScope().flags)>0&&!this.currentVarScope().inClassFieldInit},Zd.canAwait.get=function(){for(var e=this.scopeStack.length-1;e>=0;e--){var t=this.scopeStack[e];if(t.inClassFieldInit||256&t.flags)return!1;if(2&t.flags)return(4&t.flags)>0}return this.inModule&&this.options.ecmaVersion>=13||this.options.allowAwaitOutsideFunction},Zd.allowSuper.get=function(){var e=this.currentThisScope(),t=e.flags,n=e.inClassFieldInit;return(64&t)>0||n||this.options.allowSuperOutsideMethod},Zd.allowDirectSuper.get=function(){return(128&this.currentThisScope().flags)>0},Zd.treatFunctionsAsVar.get=function(){return this.treatFunctionsAsVarInScope(this.currentScope())},Zd.allowNewDotTarget.get=function(){var e=this.currentThisScope(),t=e.flags,n=e.inClassFieldInit;return(258&t)>0||n},Zd.inClassStaticBlock.get=function(){return(256&this.currentVarScope().flags)>0},Xd.extend=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];for(var n=this,r=0;r<e.length;r++)n=e[r](n);return n},Xd.parse=function(e,t){return new this(t,e).parse()},Xd.parseExpressionAt=function(e,t,n){var r=new this(n,e,t);return r.nextToken(),r.parseExpression()},Xd.tokenizer=function(e,t){return new this(t,e)},Object.defineProperties(Xd.prototype,Zd);var ef=Xd.prototype,tf=/^(?:'((?:\\[^]|[^'\\])*?)'|"((?:\\[^]|[^"\\])*?)")/;ef.strictDirective=function(e){if(this.options.ecmaVersion<5)return!1;for(;;){Od.lastIndex=e,e+=Od.exec(this.input)[0].length;var t=tf.exec(this.input.slice(e));if(!t)return!1;if("use strict"===(t[1]||t[2])){Od.lastIndex=e+t[0].length;var n=Od.exec(this.input),r=n.index+n[0].length,A=this.input.charAt(r);return";"===A||"}"===A||Id.test(n[0])&&!(/[(`.[+\-/*%<>=,?^&]/.test(A)||"!"===A&&"="===this.input.charAt(r+1))}e+=t[0].length,Od.lastIndex=e,e+=Od.exec(this.input)[0].length,";"===this.input[e]&&e++}},ef.eat=function(e){return this.type===e&&(this.next(),!0)},ef.isContextual=function(e){return this.type===Sd.name&&this.value===e&&!this.containsEsc},ef.eatContextual=function(e){return!!this.isContextual(e)&&(this.next(),!0)},ef.expectContextual=function(e){this.eatContextual(e)||this.unexpected()},ef.canInsertSemicolon=function(){return this.type===Sd.eof||this.type===Sd.braceR||Id.test(this.input.slice(this.lastTokEnd,this.start))},ef.insertSemicolon=function(){if(this.canInsertSemicolon())return this.options.onInsertedSemicolon&&this.options.onInsertedSemicolon(this.lastTokEnd,this.lastTokEndLoc),!0},ef.semicolon=function(){this.eat(Sd.semi)||this.insertSemicolon()||this.unexpected()},ef.afterTrailingComma=function(e,t){if(this.type===e)return this.options.onTrailingComma&&this.options.onTrailingComma(this.lastTokStart,this.lastTokStartLoc),t||this.next(),!0},ef.expect=function(e){this.eat(e)||this.unexpected()},ef.unexpected=function(e){this.raise(null!=e?e:this.start,"Unexpected token")};var nf=function(){this.shorthandAssign=this.trailingComma=this.parenthesizedAssign=this.parenthesizedBind=this.doubleProto=-1};ef.checkPatternErrors=function(e,t){if(e){e.trailingComma>-1&&this.raiseRecoverable(e.trailingComma,"Comma is not permitted after the rest element");var n=t?e.parenthesizedAssign:e.parenthesizedBind;n>-1&&this.raiseRecoverable(n,t?"Assigning to rvalue":"Parenthesized pattern")}},ef.checkExpressionErrors=function(e,t){if(!e)return!1;var n=e.shorthandAssign,r=e.doubleProto;if(!t)return n>=0||r>=0;n>=0&&this.raise(n,"Shorthand property assignments are valid only in destructuring patterns"),r>=0&&this.raiseRecoverable(r,"Redefinition of __proto__ property")},ef.checkYieldAwaitInDefaultParams=function(){this.yieldPos&&(!this.awaitPos||this.yieldPos<this.awaitPos)&&this.raise(this.yieldPos,"Yield expression cannot be a default value"),this.awaitPos&&this.raise(this.awaitPos,"Await expression cannot be a default value")},ef.isSimpleAssignTarget=function(e){return"ParenthesizedExpression"===e.type?this.isSimpleAssignTarget(e.expression):"Identifier"===e.type||"MemberExpression"===e.type};var rf=Xd.prototype;rf.parseTopLevel=function(e){var t=Object.create(null);for(e.body||(e.body=[]);this.type!==Sd.eof;){var n=this.parseStatement(null,!0,t);e.body.push(n)}if(this.inModule)for(var r=0,A=Object.keys(this.undefinedExports);r<A.length;r+=1){var i=A[r];this.raiseRecoverable(this.undefinedExports[i].start,"Export '"+i+"' is not defined")}return this.adaptDirectivePrologue(e.body),this.next(),e.sourceType=this.options.sourceType,this.finishNode(e,"Program")};var Af={kind:"loop"},sf={kind:"switch"};rf.isLet=function(e){if(this.options.ecmaVersion<6||!this.isContextual("let"))return!1;Od.lastIndex=this.pos;var t=Od.exec(this.input),n=this.pos+t[0].length,r=this.input.charCodeAt(n);if(91===r||92===r)return!0;if(e)return!1;if(123===r||r>55295&&r<56320)return!0;if(bd(r,!0)){for(var A=n+1;_d(r=this.input.charCodeAt(A),!0);)++A;if(92===r||r>55295&&r<56320)return!0;var i=this.input.slice(n,A);if(!yd.test(i))return!0}return!1},rf.isAsyncFunction=function(){if(this.options.ecmaVersion<8||!this.isContextual("async"))return!1;Od.lastIndex=this.pos;var e,t=Od.exec(this.input),n=this.pos+t[0].length;return!(Id.test(this.input.slice(this.pos,n))||"function"!==this.input.slice(n,n+8)||n+8!==this.input.length&&(_d(e=this.input.charCodeAt(n+8))||e>55295&&e<56320))},rf.parseStatement=function(e,t,n){var r,A=this.type,i=this.startNode();switch(this.isLet(e)&&(A=Sd._var,r="let"),A){case Sd._break:case Sd._continue:return this.parseBreakContinueStatement(i,A.keyword);case Sd._debugger:return this.parseDebuggerStatement(i);case Sd._do:return this.parseDoStatement(i);case Sd._for:return this.parseForStatement(i);case Sd._function:return e&&(this.strict||"if"!==e&&"label"!==e)&&this.options.ecmaVersion>=6&&this.unexpected(),this.parseFunctionStatement(i,!1,!e);case Sd._class:return e&&this.unexpected(),this.parseClass(i,!0);case Sd._if:return this.parseIfStatement(i);case Sd._return:return this.parseReturnStatement(i);case Sd._switch:return this.parseSwitchStatement(i);case Sd._throw:return this.parseThrowStatement(i);case Sd._try:return this.parseTryStatement(i);case Sd._const:case Sd._var:return r=r||this.value,e&&"var"!==r&&this.unexpected(),this.parseVarStatement(i,r);case Sd._while:return this.parseWhileStatement(i);case Sd._with:return this.parseWithStatement(i);case Sd.braceL:return this.parseBlock(!0,i);case Sd.semi:return this.parseEmptyStatement(i);case Sd._export:case Sd._import:if(this.options.ecmaVersion>10&&A===Sd._import){Od.lastIndex=this.pos;var s=Od.exec(this.input),a=this.pos+s[0].length,o=this.input.charCodeAt(a);if(40===o||46===o)return this.parseExpressionStatement(i,this.parseExpression())}return this.options.allowImportExportEverywhere||(t||this.raise(this.start,"'import' and 'export' may only appear at the top level"),this.inModule||this.raise(this.start,"'import' and 'export' may appear only with 'sourceType: module'")),A===Sd._import?this.parseImport(i):this.parseExport(i,n);default:if(this.isAsyncFunction())return e&&this.unexpected(),this.next(),this.parseFunctionStatement(i,!0,!e);var c=this.value,l=this.parseExpression();return A===Sd.name&&"Identifier"===l.type&&this.eat(Sd.colon)?this.parseLabeledStatement(i,c,l,e):this.parseExpressionStatement(i,l)}},rf.parseBreakContinueStatement=function(e,t){var n="break"===t;this.next(),this.eat(Sd.semi)||this.insertSemicolon()?e.label=null:this.type!==Sd.name?this.unexpected():(e.label=this.parseIdent(),this.semicolon());for(var r=0;r<this.labels.length;++r){var A=this.labels[r];if(null==e.label||A.name===e.label.name){if(null!=A.kind&&(n||"loop"===A.kind))break;if(e.label&&n)break}}return r===this.labels.length&&this.raise(e.start,"Unsyntactic "+t),this.finishNode(e,n?"BreakStatement":"ContinueStatement")},rf.parseDebuggerStatement=function(e){return this.next(),this.semicolon(),this.finishNode(e,"DebuggerStatement")},rf.parseDoStatement=function(e){return this.next(),this.labels.push(Af),e.body=this.parseStatement("do"),this.labels.pop(),this.expect(Sd._while),e.test=this.parseParenExpression(),this.options.ecmaVersion>=6?this.eat(Sd.semi):this.semicolon(),this.finishNode(e,"DoWhileStatement")},rf.parseForStatement=function(e){this.next();var t=this.options.ecmaVersion>=9&&this.canAwait&&this.eatContextual("await")?this.lastTokStart:-1;if(this.labels.push(Af),this.enterScope(0),this.expect(Sd.parenL),this.type===Sd.semi)return t>-1&&this.unexpected(t),this.parseFor(e,null);var n=this.isLet();if(this.type===Sd._var||this.type===Sd._const||n){var r=this.startNode(),A=n?"let":this.value;return this.next(),this.parseVar(r,!0,A),this.finishNode(r,"VariableDeclaration"),(this.type===Sd._in||this.options.ecmaVersion>=6&&this.isContextual("of"))&&1===r.declarations.length?(this.options.ecmaVersion>=9&&(this.type===Sd._in?t>-1&&this.unexpected(t):e.await=t>-1),this.parseForIn(e,r)):(t>-1&&this.unexpected(t),this.parseFor(e,r))}var i=this.isContextual("let"),s=!1,a=this.containsEsc,o=new nf,c=this.start,l=t>-1?this.parseExprSubscripts(o,"await"):this.parseExpression(!0,o);return this.type===Sd._in||(s=this.options.ecmaVersion>=6&&this.isContextual("of"))?(t>-1?(this.type===Sd._in&&this.unexpected(t),e.await=!0):s&&this.options.ecmaVersion>=8&&(l.start!==c||a||"Identifier"!==l.type||"async"!==l.name?this.options.ecmaVersion>=9&&(e.await=!1):this.unexpected()),i&&s&&this.raise(l.start,"The left-hand side of a for-of loop may not start with 'let'."),this.toAssignable(l,!1,o),this.checkLValPattern(l),this.parseForIn(e,l)):(this.checkExpressionErrors(o,!0),t>-1&&this.unexpected(t),this.parseFor(e,l))},rf.parseFunctionStatement=function(e,t,n){return this.next(),this.parseFunction(e,of|(n?0:cf),!1,t)},rf.parseIfStatement=function(e){return this.next(),e.test=this.parseParenExpression(),e.consequent=this.parseStatement("if"),e.alternate=this.eat(Sd._else)?this.parseStatement("if"):null,this.finishNode(e,"IfStatement")},rf.parseReturnStatement=function(e){return this.inFunction||this.options.allowReturnOutsideFunction||this.raise(this.start,"'return' outside of function"),this.next(),this.eat(Sd.semi)||this.insertSemicolon()?e.argument=null:(e.argument=this.parseExpression(),this.semicolon()),this.finishNode(e,"ReturnStatement")},rf.parseSwitchStatement=function(e){var t;this.next(),e.discriminant=this.parseParenExpression(),e.cases=[],this.expect(Sd.braceL),this.labels.push(sf),this.enterScope(0);for(var n=!1;this.type!==Sd.braceR;)if(this.type===Sd._case||this.type===Sd._default){var r=this.type===Sd._case;t&&this.finishNode(t,"SwitchCase"),e.cases.push(t=this.startNode()),t.consequent=[],this.next(),r?t.test=this.parseExpression():(n&&this.raiseRecoverable(this.lastTokStart,"Multiple default clauses"),n=!0,t.test=null),this.expect(Sd.colon)}else t||this.unexpected(),t.consequent.push(this.parseStatement(null));return this.exitScope(),t&&this.finishNode(t,"SwitchCase"),this.next(),this.labels.pop(),this.finishNode(e,"SwitchStatement")},rf.parseThrowStatement=function(e){return this.next(),Id.test(this.input.slice(this.lastTokEnd,this.start))&&this.raise(this.lastTokEnd,"Illegal newline after throw"),e.argument=this.parseExpression(),this.semicolon(),this.finishNode(e,"ThrowStatement")};var af=[];rf.parseCatchClauseParam=function(){var e=this.parseBindingAtom(),t="Identifier"===e.type;return this.enterScope(t?32:0),this.checkLValPattern(e,t?4:2),this.expect(Sd.parenR),e},rf.parseTryStatement=function(e){if(this.next(),e.block=this.parseBlock(),e.handler=null,this.type===Sd._catch){var t=this.startNode();this.next(),this.eat(Sd.parenL)?t.param=this.parseCatchClauseParam():(this.options.ecmaVersion<10&&this.unexpected(),t.param=null,this.enterScope(0)),t.body=this.parseBlock(!1),this.exitScope(),e.handler=this.finishNode(t,"CatchClause")}return e.finalizer=this.eat(Sd._finally)?this.parseBlock():null,e.handler||e.finalizer||this.raise(e.start,"Missing catch or finally clause"),this.finishNode(e,"TryStatement")},rf.parseVarStatement=function(e,t,n){return this.next(),this.parseVar(e,!1,t,n),this.semicolon(),this.finishNode(e,"VariableDeclaration")},rf.parseWhileStatement=function(e){return this.next(),e.test=this.parseParenExpression(),this.labels.push(Af),e.body=this.parseStatement("while"),this.labels.pop(),this.finishNode(e,"WhileStatement")},rf.parseWithStatement=function(e){return this.strict&&this.raise(this.start,"'with' in strict mode"),this.next(),e.object=this.parseParenExpression(),e.body=this.parseStatement("with"),this.finishNode(e,"WithStatement")},rf.parseEmptyStatement=function(e){return this.next(),this.finishNode(e,"EmptyStatement")},rf.parseLabeledStatement=function(e,t,n,r){for(var A=0,i=this.labels;A<i.length;A+=1)i[A].name===t&&this.raise(n.start,"Label '"+t+"' is already declared");for(var s=this.type.isLoop?"loop":this.type===Sd._switch?"switch":null,a=this.labels.length-1;a>=0;a--){var o=this.labels[a];if(o.statementStart!==e.start)break;o.statementStart=this.start,o.kind=s}return this.labels.push({name:t,kind:s,statementStart:this.start}),e.body=this.parseStatement(r?-1===r.indexOf("label")?r+"label":r:"label"),this.labels.pop(),e.label=n,this.finishNode(e,"LabeledStatement")},rf.parseExpressionStatement=function(e,t){return e.expression=t,this.semicolon(),this.finishNode(e,"ExpressionStatement")},rf.parseBlock=function(e,t,n){for(void 0===e&&(e=!0),void 0===t&&(t=this.startNode()),t.body=[],this.expect(Sd.braceL),e&&this.enterScope(0);this.type!==Sd.braceR;){var r=this.parseStatement(null);t.body.push(r)}return n&&(this.strict=!1),this.next(),e&&this.exitScope(),this.finishNode(t,"BlockStatement")},rf.parseFor=function(e,t){return e.init=t,this.expect(Sd.semi),e.test=this.type===Sd.semi?null:this.parseExpression(),this.expect(Sd.semi),e.update=this.type===Sd.parenR?null:this.parseExpression(),this.expect(Sd.parenR),e.body=this.parseStatement("for"),this.exitScope(),this.labels.pop(),this.finishNode(e,"ForStatement")},rf.parseForIn=function(e,t){var n=this.type===Sd._in;return this.next(),"VariableDeclaration"===t.type&&null!=t.declarations[0].init&&(!n||this.options.ecmaVersion<8||this.strict||"var"!==t.kind||"Identifier"!==t.declarations[0].id.type)&&this.raise(t.start,(n?"for-in":"for-of")+" loop variable declaration may not have an initializer"),e.left=t,e.right=n?this.parseExpression():this.parseMaybeAssign(),this.expect(Sd.parenR),e.body=this.parseStatement("for"),this.exitScope(),this.labels.pop(),this.finishNode(e,n?"ForInStatement":"ForOfStatement")},rf.parseVar=function(e,t,n,r){for(e.declarations=[],e.kind=n;;){var A=this.startNode();if(this.parseVarId(A,n),this.eat(Sd.eq)?A.init=this.parseMaybeAssign(t):r||"const"!==n||this.type===Sd._in||this.options.ecmaVersion>=6&&this.isContextual("of")?r||"Identifier"===A.id.type||t&&(this.type===Sd._in||this.isContextual("of"))?A.init=null:this.raise(this.lastTokEnd,"Complex binding patterns require an initialization value"):this.unexpected(),e.declarations.push(this.finishNode(A,"VariableDeclarator")),!this.eat(Sd.comma))break}return e},rf.parseVarId=function(e,t){e.id=this.parseBindingAtom(),this.checkLValPattern(e.id,"var"===t?1:2,!1)};var of=1,cf=2;function lf(e,t){var n=t.key.name,r=e[n],A="true";return"MethodDefinition"!==t.type||"get"!==t.kind&&"set"!==t.kind||(A=(t.static?"s":"i")+t.kind),"iget"===r&&"iset"===A||"iset"===r&&"iget"===A||"sget"===r&&"sset"===A||"sset"===r&&"sget"===A?(e[n]="true",!1):!!r||(e[n]=A,!1)}function uf(e,t){var n=e.computed,r=e.key;return!n&&("Identifier"===r.type&&r.name===t||"Literal"===r.type&&r.value===t)}rf.parseFunction=function(e,t,n,r,A){this.initFunction(e),(this.options.ecmaVersion>=9||this.options.ecmaVersion>=6&&!r)&&(this.type===Sd.star&&t&cf&&this.unexpected(),e.generator=this.eat(Sd.star)),this.options.ecmaVersion>=8&&(e.async=!!r),t&of&&(e.id=4&t&&this.type!==Sd.name?null:this.parseIdent(),!e.id||t&cf||this.checkLValSimple(e.id,this.strict||e.generator||e.async?this.treatFunctionsAsVar?1:2:3));var i=this.yieldPos,s=this.awaitPos,a=this.awaitIdentPos;return this.yieldPos=0,this.awaitPos=0,this.awaitIdentPos=0,this.enterScope(Yd(e.async,e.generator)),t&of||(e.id=this.type===Sd.name?this.parseIdent():null),this.parseFunctionParams(e),this.parseFunctionBody(e,n,!1,A),this.yieldPos=i,this.awaitPos=s,this.awaitIdentPos=a,this.finishNode(e,t&of?"FunctionDeclaration":"FunctionExpression")},rf.parseFunctionParams=function(e){this.expect(Sd.parenL),e.params=this.parseBindingList(Sd.parenR,!1,this.options.ecmaVersion>=8),this.checkYieldAwaitInDefaultParams()},rf.parseClass=function(e,t){this.next();var n=this.strict;this.strict=!0,this.parseClassId(e,t),this.parseClassSuper(e);var r=this.enterClassBody(),A=this.startNode(),i=!1;for(A.body=[],this.expect(Sd.braceL);this.type!==Sd.braceR;){var s=this.parseClassElement(null!==e.superClass);s&&(A.body.push(s),"MethodDefinition"===s.type&&"constructor"===s.kind?(i&&this.raiseRecoverable(s.start,"Duplicate constructor in the same class"),i=!0):s.key&&"PrivateIdentifier"===s.key.type&&lf(r,s)&&this.raiseRecoverable(s.key.start,"Identifier '#"+s.key.name+"' has already been declared"))}return this.strict=n,this.next(),e.body=this.finishNode(A,"ClassBody"),this.exitClassBody(),this.finishNode(e,t?"ClassDeclaration":"ClassExpression")},rf.parseClassElement=function(e){if(this.eat(Sd.semi))return null;var t=this.options.ecmaVersion,n=this.startNode(),r="",A=!1,i=!1,s="method",a=!1;if(this.eatContextual("static")){if(t>=13&&this.eat(Sd.braceL))return this.parseClassStaticBlock(n),n;this.isClassElementNameStart()||this.type===Sd.star?a=!0:r="static"}if(n.static=a,!r&&t>=8&&this.eatContextual("async")&&(!this.isClassElementNameStart()&&this.type!==Sd.star||this.canInsertSemicolon()?r="async":i=!0),!r&&(t>=9||!i)&&this.eat(Sd.star)&&(A=!0),!r&&!i&&!A){var o=this.value;(this.eatContextual("get")||this.eatContextual("set"))&&(this.isClassElementNameStart()?s=o:r=o)}if(r?(n.computed=!1,n.key=this.startNodeAt(this.lastTokStart,this.lastTokStartLoc),n.key.name=r,this.finishNode(n.key,"Identifier")):this.parseClassElementName(n),t<13||this.type===Sd.parenL||"method"!==s||A||i){var c=!n.static&&uf(n,"constructor"),l=c&&e;c&&"method"!==s&&this.raise(n.key.start,"Constructor can't have get/set modifier"),n.kind=c?"constructor":s,this.parseClassMethod(n,A,i,l)}else this.parseClassField(n);return n},rf.isClassElementNameStart=function(){return this.type===Sd.name||this.type===Sd.privateId||this.type===Sd.num||this.type===Sd.string||this.type===Sd.bracketL||this.type.keyword},rf.parseClassElementName=function(e){this.type===Sd.privateId?("constructor"===this.value&&this.raise(this.start,"Classes can't have an element named '#constructor'"),e.computed=!1,e.key=this.parsePrivateIdent()):this.parsePropertyName(e)},rf.parseClassMethod=function(e,t,n,r){var A=e.key;"constructor"===e.kind?(t&&this.raise(A.start,"Constructor can't be a generator"),n&&this.raise(A.start,"Constructor can't be an async method")):e.static&&uf(e,"prototype")&&this.raise(A.start,"Classes may not have a static property named prototype");var i=e.value=this.parseMethod(t,n,r);return"get"===e.kind&&0!==i.params.length&&this.raiseRecoverable(i.start,"getter should have no params"),"set"===e.kind&&1!==i.params.length&&this.raiseRecoverable(i.start,"setter should have exactly one param"),"set"===e.kind&&"RestElement"===i.params[0].type&&this.raiseRecoverable(i.params[0].start,"Setter cannot use rest params"),this.finishNode(e,"MethodDefinition")},rf.parseClassField=function(e){if(uf(e,"constructor")?this.raise(e.key.start,"Classes can't have a field named 'constructor'"):e.static&&uf(e,"prototype")&&this.raise(e.key.start,"Classes can't have a static field named 'prototype'"),this.eat(Sd.eq)){var t=this.currentThisScope(),n=t.inClassFieldInit;t.inClassFieldInit=!0,e.value=this.parseMaybeAssign(),t.inClassFieldInit=n}else e.value=null;return this.semicolon(),this.finishNode(e,"PropertyDefinition")},rf.parseClassStaticBlock=function(e){e.body=[];var t=this.labels;for(this.labels=[],this.enterScope(320);this.type!==Sd.braceR;){var n=this.parseStatement(null);e.body.push(n)}return this.next(),this.exitScope(),this.labels=t,this.finishNode(e,"StaticBlock")},rf.parseClassId=function(e,t){this.type===Sd.name?(e.id=this.parseIdent(),t&&this.checkLValSimple(e.id,2,!1)):(!0===t&&this.unexpected(),e.id=null)},rf.parseClassSuper=function(e){e.superClass=this.eat(Sd._extends)?this.parseExprSubscripts(null,!1):null},rf.enterClassBody=function(){var e={declared:Object.create(null),used:[]};return this.privateNameStack.push(e),e.declared},rf.exitClassBody=function(){var e=this.privateNameStack.pop(),t=e.declared,n=e.used;if(this.options.checkPrivateFields)for(var r=this.privateNameStack.length,A=0===r?null:this.privateNameStack[r-1],i=0;i<n.length;++i){var s=n[i];Rd(t,s.name)||(A?A.used.push(s):this.raiseRecoverable(s.start,"Private field '#"+s.name+"' must be declared in an enclosing class"))}},rf.parseExportAllDeclaration=function(e,t){return this.options.ecmaVersion>=11&&(this.eatContextual("as")?(e.exported=this.parseModuleExportName(),this.checkExport(t,e.exported,this.lastTokStart)):e.exported=null),this.expectContextual("from"),this.type!==Sd.string&&this.unexpected(),e.source=this.parseExprAtom(),this.options.ecmaVersion>=16&&(e.attributes=this.parseWithClause()),this.semicolon(),this.finishNode(e,"ExportAllDeclaration")},rf.parseExport=function(e,t){if(this.next(),this.eat(Sd.star))return this.parseExportAllDeclaration(e,t);if(this.eat(Sd._default))return this.checkExport(t,"default",this.lastTokStart),e.declaration=this.parseExportDefaultDeclaration(),this.finishNode(e,"ExportDefaultDeclaration");if(this.shouldParseExportStatement())e.declaration=this.parseExportDeclaration(e),"VariableDeclaration"===e.declaration.type?this.checkVariableExport(t,e.declaration.declarations):this.checkExport(t,e.declaration.id,e.declaration.id.start),e.specifiers=[],e.source=null;else{if(e.declaration=null,e.specifiers=this.parseExportSpecifiers(t),this.eatContextual("from"))this.type!==Sd.string&&this.unexpected(),e.source=this.parseExprAtom(),this.options.ecmaVersion>=16&&(e.attributes=this.parseWithClause());else{for(var n=0,r=e.specifiers;n<r.length;n+=1){var A=r[n];this.checkUnreserved(A.local),this.checkLocalExport(A.local),"Literal"===A.local.type&&this.raise(A.local.start,"A string literal cannot be used as an exported binding without `from`.")}e.source=null}this.semicolon()}return this.finishNode(e,"ExportNamedDeclaration")},rf.parseExportDeclaration=function(e){return this.parseStatement(null)},rf.parseExportDefaultDeclaration=function(){var e;if(this.type===Sd._function||(e=this.isAsyncFunction())){var t=this.startNode();return this.next(),e&&this.next(),this.parseFunction(t,4|of,!1,e)}if(this.type===Sd._class){var n=this.startNode();return this.parseClass(n,"nullableID")}var r=this.parseMaybeAssign();return this.semicolon(),r},rf.checkExport=function(e,t,n){e&&("string"!=typeof t&&(t="Identifier"===t.type?t.name:t.value),Rd(e,t)&&this.raiseRecoverable(n,"Duplicate export '"+t+"'"),e[t]=!0)},rf.checkPatternExport=function(e,t){var n=t.type;if("Identifier"===n)this.checkExport(e,t,t.start);else if("ObjectPattern"===n)for(var r=0,A=t.properties;r<A.length;r+=1){var i=A[r];this.checkPatternExport(e,i)}else if("ArrayPattern"===n)for(var s=0,a=t.elements;s<a.length;s+=1){var o=a[s];o&&this.checkPatternExport(e,o)}else"Property"===n?this.checkPatternExport(e,t.value):"AssignmentPattern"===n?this.checkPatternExport(e,t.left):"RestElement"===n&&this.checkPatternExport(e,t.argument)},rf.checkVariableExport=function(e,t){if(e)for(var n=0,r=t;n<r.length;n+=1){var A=r[n];this.checkPatternExport(e,A.id)}},rf.shouldParseExportStatement=function(){return"var"===this.type.keyword||"const"===this.type.keyword||"class"===this.type.keyword||"function"===this.type.keyword||this.isLet()||this.isAsyncFunction()},rf.parseExportSpecifier=function(e){var t=this.startNode();return t.local=this.parseModuleExportName(),t.exported=this.eatContextual("as")?this.parseModuleExportName():t.local,this.checkExport(e,t.exported,t.exported.start),this.finishNode(t,"ExportSpecifier")},rf.parseExportSpecifiers=function(e){var t=[],n=!0;for(this.expect(Sd.braceL);!this.eat(Sd.braceR);){if(n)n=!1;else if(this.expect(Sd.comma),this.afterTrailingComma(Sd.braceR))break;t.push(this.parseExportSpecifier(e))}return t},rf.parseImport=function(e){return this.next(),this.type===Sd.string?(e.specifiers=af,e.source=this.parseExprAtom()):(e.specifiers=this.parseImportSpecifiers(),this.expectContextual("from"),e.source=this.type===Sd.string?this.parseExprAtom():this.unexpected()),this.options.ecmaVersion>=16&&(e.attributes=this.parseWithClause()),this.semicolon(),this.finishNode(e,"ImportDeclaration")},rf.parseImportSpecifier=function(){var e=this.startNode();return e.imported=this.parseModuleExportName(),this.eatContextual("as")?e.local=this.parseIdent():(this.checkUnreserved(e.imported),e.local=e.imported),this.checkLValSimple(e.local,2),this.finishNode(e,"ImportSpecifier")},rf.parseImportDefaultSpecifier=function(){var e=this.startNode();return e.local=this.parseIdent(),this.checkLValSimple(e.local,2),this.finishNode(e,"ImportDefaultSpecifier")},rf.parseImportNamespaceSpecifier=function(){var e=this.startNode();return this.next(),this.expectContextual("as"),e.local=this.parseIdent(),this.checkLValSimple(e.local,2),this.finishNode(e,"ImportNamespaceSpecifier")},rf.parseImportSpecifiers=function(){var e=[],t=!0;if(this.type===Sd.name&&(e.push(this.parseImportDefaultSpecifier()),!this.eat(Sd.comma)))return e;if(this.type===Sd.star)return e.push(this.parseImportNamespaceSpecifier()),e;for(this.expect(Sd.braceL);!this.eat(Sd.braceR);){if(t)t=!1;else if(this.expect(Sd.comma),this.afterTrailingComma(Sd.braceR))break;e.push(this.parseImportSpecifier())}return e},rf.parseWithClause=function(){var e=[];if(!this.eat(Sd._with))return e;this.expect(Sd.braceL);for(var t={},n=!0;!this.eat(Sd.braceR);){if(n)n=!1;else if(this.expect(Sd.comma),this.afterTrailingComma(Sd.braceR))break;var r=this.parseImportAttribute(),A="Identifier"===r.key.type?r.key.name:r.key.value;Rd(t,A)&&this.raiseRecoverable(r.key.start,"Duplicate attribute key '"+A+"'"),t[A]=!0,e.push(r)}return e},rf.parseImportAttribute=function(){var e=this.startNode();return e.key=this.type===Sd.string?this.parseExprAtom():this.parseIdent("never"!==this.options.allowReserved),this.expect(Sd.colon),this.type!==Sd.string&&this.unexpected(),e.value=this.parseExprAtom(),this.finishNode(e,"ImportAttribute")},rf.parseModuleExportName=function(){if(this.options.ecmaVersion>=13&&this.type===Sd.string){var e=this.parseLiteral(this.value);return $d.test(e.value)&&this.raise(e.start,"An export name cannot include a lone surrogate."),e}return this.parseIdent(!0)},rf.adaptDirectivePrologue=function(e){for(var t=0;t<e.length&&this.isDirectiveCandidate(e[t]);++t)e[t].directive=e[t].expression.raw.slice(1,-1)},rf.isDirectiveCandidate=function(e){return this.options.ecmaVersion>=5&&"ExpressionStatement"===e.type&&"Literal"===e.expression.type&&"string"==typeof e.expression.value&&('"'===this.input[e.start]||"'"===this.input[e.start])};var hf=Xd.prototype;hf.toAssignable=function(e,t,n){if(this.options.ecmaVersion>=6&&e)switch(e.type){case"Identifier":this.inAsync&&"await"===e.name&&this.raise(e.start,"Cannot use 'await' as identifier inside an async function");break;case"ObjectPattern":case"ArrayPattern":case"AssignmentPattern":case"RestElement":break;case"ObjectExpression":e.type="ObjectPattern",n&&this.checkPatternErrors(n,!0);for(var r=0,A=e.properties;r<A.length;r+=1){var i=A[r];this.toAssignable(i,t),"RestElement"!==i.type||"ArrayPattern"!==i.argument.type&&"ObjectPattern"!==i.argument.type||this.raise(i.argument.start,"Unexpected token")}break;case"Property":"init"!==e.kind&&this.raise(e.key.start,"Object pattern can't contain getter or setter"),this.toAssignable(e.value,t);break;case"ArrayExpression":e.type="ArrayPattern",n&&this.checkPatternErrors(n,!0),this.toAssignableList(e.elements,t);break;case"SpreadElement":e.type="RestElement",this.toAssignable(e.argument,t),"AssignmentPattern"===e.argument.type&&this.raise(e.argument.start,"Rest elements cannot have a default value");break;case"AssignmentExpression":"="!==e.operator&&this.raise(e.left.end,"Only '=' operator can be used for specifying default value."),e.type="AssignmentPattern",delete e.operator,this.toAssignable(e.left,t);break;case"ParenthesizedExpression":this.toAssignable(e.expression,t,n);break;case"ChainExpression":this.raiseRecoverable(e.start,"Optional chaining cannot appear in left-hand side");break;case"MemberExpression":if(!t)break;default:this.raise(e.start,"Assigning to rvalue")}else n&&this.checkPatternErrors(n,!0);return e},hf.toAssignableList=function(e,t){for(var n=e.length,r=0;r<n;r++){var A=e[r];A&&this.toAssignable(A,t)}if(n){var i=e[n-1];6===this.options.ecmaVersion&&t&&i&&"RestElement"===i.type&&"Identifier"!==i.argument.type&&this.unexpected(i.argument.start)}return e},hf.parseSpread=function(e){var t=this.startNode();return this.next(),t.argument=this.parseMaybeAssign(!1,e),this.finishNode(t,"SpreadElement")},hf.parseRestBinding=function(){var e=this.startNode();return this.next(),6===this.options.ecmaVersion&&this.type!==Sd.name&&this.unexpected(),e.argument=this.parseBindingAtom(),this.finishNode(e,"RestElement")},hf.parseBindingAtom=function(){if(this.options.ecmaVersion>=6)switch(this.type){case Sd.bracketL:var e=this.startNode();return this.next(),e.elements=this.parseBindingList(Sd.bracketR,!0,!0),this.finishNode(e,"ArrayPattern");case Sd.braceL:return this.parseObj(!0)}return this.parseIdent()},hf.parseBindingList=function(e,t,n,r){for(var A=[],i=!0;!this.eat(e);)if(i?i=!1:this.expect(Sd.comma),t&&this.type===Sd.comma)A.push(null);else{if(n&&this.afterTrailingComma(e))break;if(this.type===Sd.ellipsis){var s=this.parseRestBinding();this.parseBindingListItem(s),A.push(s),this.type===Sd.comma&&this.raiseRecoverable(this.start,"Comma is not permitted after the rest element"),this.expect(e);break}A.push(this.parseAssignableListItem(r))}return A},hf.parseAssignableListItem=function(e){var t=this.parseMaybeDefault(this.start,this.startLoc);return this.parseBindingListItem(t),t},hf.parseBindingListItem=function(e){return e},hf.parseMaybeDefault=function(e,t,n){if(n=n||this.parseBindingAtom(),this.options.ecmaVersion<6||!this.eat(Sd.eq))return n;var r=this.startNodeAt(e,t);return r.left=n,r.right=this.parseMaybeAssign(),this.finishNode(r,"AssignmentPattern")},hf.checkLValSimple=function(e,t,n){void 0===t&&(t=0);var r=0!==t;switch(e.type){case"Identifier":this.strict&&this.reservedWordsStrictBind.test(e.name)&&this.raiseRecoverable(e.start,(r?"Binding ":"Assigning to ")+e.name+" in strict mode"),r&&(2===t&&"let"===e.name&&this.raiseRecoverable(e.start,"let is disallowed as a lexically bound name"),n&&(Rd(n,e.name)&&this.raiseRecoverable(e.start,"Argument name clash"),n[e.name]=!0),5!==t&&this.declareName(e.name,t,e.start));break;case"ChainExpression":this.raiseRecoverable(e.start,"Optional chaining cannot appear in left-hand side");break;case"MemberExpression":r&&this.raiseRecoverable(e.start,"Binding member expression");break;case"ParenthesizedExpression":return r&&this.raiseRecoverable(e.start,"Binding parenthesized expression"),this.checkLValSimple(e.expression,t,n);default:this.raise(e.start,(r?"Binding":"Assigning to")+" rvalue")}},hf.checkLValPattern=function(e,t,n){switch(void 0===t&&(t=0),e.type){case"ObjectPattern":for(var r=0,A=e.properties;r<A.length;r+=1){var i=A[r];this.checkLValInnerPattern(i,t,n)}break;case"ArrayPattern":for(var s=0,a=e.elements;s<a.length;s+=1){var o=a[s];o&&this.checkLValInnerPattern(o,t,n)}break;default:this.checkLValSimple(e,t,n)}},hf.checkLValInnerPattern=function(e,t,n){switch(void 0===t&&(t=0),e.type){case"Property":this.checkLValInnerPattern(e.value,t,n);break;case"AssignmentPattern":this.checkLValPattern(e.left,t,n);break;case"RestElement":this.checkLValPattern(e.argument,t,n);break;default:this.checkLValPattern(e,t,n)}};var df=function(e,t,n,r,A){this.token=e,this.isExpr=!!t,this.preserveSpace=!!n,this.override=r,this.generator=!!A},ff={b_stat:new df("{",!1),b_expr:new df("{",!0),b_tmpl:new df("${",!1),p_stat:new df("(",!1),p_expr:new df("(",!0),q_tmpl:new df("`",!0,!0,(function(e){return e.tryReadTemplateToken()})),f_stat:new df("function",!1),f_expr:new df("function",!0),f_expr_gen:new df("function",!0,!1,null,!0),f_gen:new df("function",!1,!1,null,!0)},pf=Xd.prototype;pf.initialContext=function(){return[ff.b_stat]},pf.curContext=function(){return this.context[this.context.length-1]},pf.braceIsBlock=function(e){var t=this.curContext();return t===ff.f_expr||t===ff.f_stat||(e!==Sd.colon||t!==ff.b_stat&&t!==ff.b_expr?e===Sd._return||e===Sd.name&&this.exprAllowed?Id.test(this.input.slice(this.lastTokEnd,this.start)):e===Sd._else||e===Sd.semi||e===Sd.eof||e===Sd.parenR||e===Sd.arrow||(e===Sd.braceL?t===ff.b_stat:e!==Sd._var&&e!==Sd._const&&e!==Sd.name&&!this.exprAllowed):!t.isExpr)},pf.inGeneratorContext=function(){for(var e=this.context.length-1;e>=1;e--){var t=this.context[e];if("function"===t.token)return t.generator}return!1},pf.updateContext=function(e){var t,n=this.type;n.keyword&&e===Sd.dot?this.exprAllowed=!1:(t=n.updateContext)?t.call(this,e):this.exprAllowed=n.beforeExpr},pf.overrideContext=function(e){this.curContext()!==e&&(this.context[this.context.length-1]=e)},Sd.parenR.updateContext=Sd.braceR.updateContext=function(){if(1!==this.context.length){var e=this.context.pop();e===ff.b_stat&&"function"===this.curContext().token&&(e=this.context.pop()),this.exprAllowed=!e.isExpr}else this.exprAllowed=!0},Sd.braceL.updateContext=function(e){this.context.push(this.braceIsBlock(e)?ff.b_stat:ff.b_expr),this.exprAllowed=!0},Sd.dollarBraceL.updateContext=function(){this.context.push(ff.b_tmpl),this.exprAllowed=!0},Sd.parenL.updateContext=function(e){var t=e===Sd._if||e===Sd._for||e===Sd._with||e===Sd._while;this.context.push(t?ff.p_stat:ff.p_expr),this.exprAllowed=!0},Sd.incDec.updateContext=function(){},Sd._function.updateContext=Sd._class.updateContext=function(e){!e.beforeExpr||e===Sd._else||e===Sd.semi&&this.curContext()!==ff.p_stat||e===Sd._return&&Id.test(this.input.slice(this.lastTokEnd,this.start))||(e===Sd.colon||e===Sd.braceL)&&this.curContext()===ff.b_stat?this.context.push(ff.f_stat):this.context.push(ff.f_expr),this.exprAllowed=!1},Sd.colon.updateContext=function(){"function"===this.curContext().token&&this.context.pop(),this.exprAllowed=!0},Sd.backQuote.updateContext=function(){this.curContext()===ff.q_tmpl?this.context.pop():this.context.push(ff.q_tmpl),this.exprAllowed=!1},Sd.star.updateContext=function(e){if(e===Sd._function){var t=this.context.length-1;this.context[t]===ff.f_expr?this.context[t]=ff.f_expr_gen:this.context[t]=ff.f_gen}this.exprAllowed=!0},Sd.name.updateContext=function(e){var t=!1;this.options.ecmaVersion>=6&&e!==Sd.dot&&("of"===this.value&&!this.exprAllowed||"yield"===this.value&&this.inGeneratorContext())&&(t=!0),this.exprAllowed=t};var gf=Xd.prototype;function mf(e){return"Identifier"===e.type||"ParenthesizedExpression"===e.type&&mf(e.expression)}function yf(e){return"MemberExpression"===e.type&&"PrivateIdentifier"===e.property.type||"ChainExpression"===e.type&&yf(e.expression)||"ParenthesizedExpression"===e.type&&yf(e.expression)}gf.checkPropClash=function(e,t,n){if(!(this.options.ecmaVersion>=9&&"SpreadElement"===e.type||this.options.ecmaVersion>=6&&(e.computed||e.method||e.shorthand))){var r,A=e.key;switch(A.type){case"Identifier":r=A.name;break;case"Literal":r=String(A.value);break;default:return}var i=e.kind;if(this.options.ecmaVersion>=6)"__proto__"===r&&"init"===i&&(t.proto&&(n?n.doubleProto<0&&(n.doubleProto=A.start):this.raiseRecoverable(A.start,"Redefinition of __proto__ property")),t.proto=!0);else{var s=t[r="$"+r];s?("init"===i?this.strict&&s.init||s.get||s.set:s.init||s[i])&&this.raiseRecoverable(A.start,"Redefinition of property"):s=t[r]={init:!1,get:!1,set:!1},s[i]=!0}}},gf.parseExpression=function(e,t){var n=this.start,r=this.startLoc,A=this.parseMaybeAssign(e,t);if(this.type===Sd.comma){var i=this.startNodeAt(n,r);for(i.expressions=[A];this.eat(Sd.comma);)i.expressions.push(this.parseMaybeAssign(e,t));return this.finishNode(i,"SequenceExpression")}return A},gf.parseMaybeAssign=function(e,t,n){if(this.isContextual("yield")){if(this.inGenerator)return this.parseYield(e);this.exprAllowed=!1}var r=!1,A=-1,i=-1,s=-1;t?(A=t.parenthesizedAssign,i=t.trailingComma,s=t.doubleProto,t.parenthesizedAssign=t.trailingComma=-1):(t=new nf,r=!0);var a=this.start,o=this.startLoc;this.type!==Sd.parenL&&this.type!==Sd.name||(this.potentialArrowAt=this.start,this.potentialArrowInForAwait="await"===e);var c=this.parseMaybeConditional(e,t);if(n&&(c=n.call(this,c,a,o)),this.type.isAssign){var l=this.startNodeAt(a,o);return l.operator=this.value,this.type===Sd.eq&&(c=this.toAssignable(c,!1,t)),r||(t.parenthesizedAssign=t.trailingComma=t.doubleProto=-1),t.shorthandAssign>=c.start&&(t.shorthandAssign=-1),this.type===Sd.eq?this.checkLValPattern(c):this.checkLValSimple(c),l.left=c,this.next(),l.right=this.parseMaybeAssign(e),s>-1&&(t.doubleProto=s),this.finishNode(l,"AssignmentExpression")}return r&&this.checkExpressionErrors(t,!0),A>-1&&(t.parenthesizedAssign=A),i>-1&&(t.trailingComma=i),c},gf.parseMaybeConditional=function(e,t){var n=this.start,r=this.startLoc,A=this.parseExprOps(e,t);if(this.checkExpressionErrors(t))return A;if(this.eat(Sd.question)){var i=this.startNodeAt(n,r);return i.test=A,i.consequent=this.parseMaybeAssign(),this.expect(Sd.colon),i.alternate=this.parseMaybeAssign(e),this.finishNode(i,"ConditionalExpression")}return A},gf.parseExprOps=function(e,t){var n=this.start,r=this.startLoc,A=this.parseMaybeUnary(t,!1,!1,e);return this.checkExpressionErrors(t)||A.start===n&&"ArrowFunctionExpression"===A.type?A:this.parseExprOp(A,n,r,-1,e)},gf.parseExprOp=function(e,t,n,r,A){var i=this.type.binop;if(null!=i&&(!A||this.type!==Sd._in)&&i>r){var s=this.type===Sd.logicalOR||this.type===Sd.logicalAND,a=this.type===Sd.coalesce;a&&(i=Sd.logicalAND.binop);var o=this.value;this.next();var c=this.start,l=this.startLoc,u=this.parseExprOp(this.parseMaybeUnary(null,!1,!1,A),c,l,i,A),h=this.buildBinary(t,n,e,u,o,s||a);return(s&&this.type===Sd.coalesce||a&&(this.type===Sd.logicalOR||this.type===Sd.logicalAND))&&this.raiseRecoverable(this.start,"Logical expressions and coalesce expressions cannot be mixed. Wrap either by parentheses"),this.parseExprOp(h,t,n,r,A)}return e},gf.buildBinary=function(e,t,n,r,A,i){"PrivateIdentifier"===r.type&&this.raise(r.start,"Private identifier can only be left side of binary expression");var s=this.startNodeAt(e,t);return s.left=n,s.operator=A,s.right=r,this.finishNode(s,i?"LogicalExpression":"BinaryExpression")},gf.parseMaybeUnary=function(e,t,n,r){var A,i=this.start,s=this.startLoc;if(this.isContextual("await")&&this.canAwait)A=this.parseAwait(r),t=!0;else if(this.type.prefix){var a=this.startNode(),o=this.type===Sd.incDec;a.operator=this.value,a.prefix=!0,this.next(),a.argument=this.parseMaybeUnary(null,!0,o,r),this.checkExpressionErrors(e,!0),o?this.checkLValSimple(a.argument):this.strict&&"delete"===a.operator&&mf(a.argument)?this.raiseRecoverable(a.start,"Deleting local variable in strict mode"):"delete"===a.operator&&yf(a.argument)?this.raiseRecoverable(a.start,"Private fields can not be deleted"):t=!0,A=this.finishNode(a,o?"UpdateExpression":"UnaryExpression")}else if(t||this.type!==Sd.privateId){if(A=this.parseExprSubscripts(e,r),this.checkExpressionErrors(e))return A;for(;this.type.postfix&&!this.canInsertSemicolon();){var c=this.startNodeAt(i,s);c.operator=this.value,c.prefix=!1,c.argument=A,this.checkLValSimple(A),this.next(),A=this.finishNode(c,"UpdateExpression")}}else(r||0===this.privateNameStack.length)&&this.options.checkPrivateFields&&this.unexpected(),A=this.parsePrivateIdent(),this.type!==Sd._in&&this.unexpected();return n||!this.eat(Sd.starstar)?A:t?void this.unexpected(this.lastTokStart):this.buildBinary(i,s,A,this.parseMaybeUnary(null,!1,!1,r),"**",!1)},gf.parseExprSubscripts=function(e,t){var n=this.start,r=this.startLoc,A=this.parseExprAtom(e,t);if("ArrowFunctionExpression"===A.type&&")"!==this.input.slice(this.lastTokStart,this.lastTokEnd))return A;var i=this.parseSubscripts(A,n,r,!1,t);return e&&"MemberExpression"===i.type&&(e.parenthesizedAssign>=i.start&&(e.parenthesizedAssign=-1),e.parenthesizedBind>=i.start&&(e.parenthesizedBind=-1),e.trailingComma>=i.start&&(e.trailingComma=-1)),i},gf.parseSubscripts=function(e,t,n,r,A){for(var i=this.options.ecmaVersion>=8&&"Identifier"===e.type&&"async"===e.name&&this.lastTokEnd===e.end&&!this.canInsertSemicolon()&&e.end-e.start==5&&this.potentialArrowAt===e.start,s=!1;;){var a=this.parseSubscript(e,t,n,r,i,s,A);if(a.optional&&(s=!0),a===e||"ArrowFunctionExpression"===a.type){if(s){var o=this.startNodeAt(t,n);o.expression=a,a=this.finishNode(o,"ChainExpression")}return a}e=a}},gf.shouldParseAsyncArrow=function(){return!this.canInsertSemicolon()&&this.eat(Sd.arrow)},gf.parseSubscriptAsyncArrow=function(e,t,n,r){return this.parseArrowExpression(this.startNodeAt(e,t),n,!0,r)},gf.parseSubscript=function(e,t,n,r,A,i,s){var a=this.options.ecmaVersion>=11,o=a&&this.eat(Sd.questionDot);r&&o&&this.raise(this.lastTokStart,"Optional chaining cannot appear in the callee of new expressions");var c=this.eat(Sd.bracketL);if(c||o&&this.type!==Sd.parenL&&this.type!==Sd.backQuote||this.eat(Sd.dot)){var l=this.startNodeAt(t,n);l.object=e,c?(l.property=this.parseExpression(),this.expect(Sd.bracketR)):this.type===Sd.privateId&&"Super"!==e.type?l.property=this.parsePrivateIdent():l.property=this.parseIdent("never"!==this.options.allowReserved),l.computed=!!c,a&&(l.optional=o),e=this.finishNode(l,"MemberExpression")}else if(!r&&this.eat(Sd.parenL)){var u=new nf,h=this.yieldPos,d=this.awaitPos,f=this.awaitIdentPos;this.yieldPos=0,this.awaitPos=0,this.awaitIdentPos=0;var p=this.parseExprList(Sd.parenR,this.options.ecmaVersion>=8,!1,u);if(A&&!o&&this.shouldParseAsyncArrow())return this.checkPatternErrors(u,!1),this.checkYieldAwaitInDefaultParams(),this.awaitIdentPos>0&&this.raise(this.awaitIdentPos,"Cannot use 'await' as identifier inside an async function"),this.yieldPos=h,this.awaitPos=d,this.awaitIdentPos=f,this.parseSubscriptAsyncArrow(t,n,p,s);this.checkExpressionErrors(u,!0),this.yieldPos=h||this.yieldPos,this.awaitPos=d||this.awaitPos,this.awaitIdentPos=f||this.awaitIdentPos;var g=this.startNodeAt(t,n);g.callee=e,g.arguments=p,a&&(g.optional=o),e=this.finishNode(g,"CallExpression")}else if(this.type===Sd.backQuote){(o||i)&&this.raise(this.start,"Optional chaining cannot appear in the tag of tagged template expressions");var m=this.startNodeAt(t,n);m.tag=e,m.quasi=this.parseTemplate({isTagged:!0}),e=this.finishNode(m,"TaggedTemplateExpression")}return e},gf.parseExprAtom=function(e,t,n){this.type===Sd.slash&&this.readRegexp();var r,A=this.potentialArrowAt===this.start;switch(this.type){case Sd._super:return this.allowSuper||this.raise(this.start,"'super' keyword outside a method"),r=this.startNode(),this.next(),this.type!==Sd.parenL||this.allowDirectSuper||this.raise(r.start,"super() call outside constructor of a subclass"),this.type!==Sd.dot&&this.type!==Sd.bracketL&&this.type!==Sd.parenL&&this.unexpected(),this.finishNode(r,"Super");case Sd._this:return r=this.startNode(),this.next(),this.finishNode(r,"ThisExpression");case Sd.name:var i=this.start,s=this.startLoc,a=this.containsEsc,o=this.parseIdent(!1);if(this.options.ecmaVersion>=8&&!a&&"async"===o.name&&!this.canInsertSemicolon()&&this.eat(Sd._function))return this.overrideContext(ff.f_expr),this.parseFunction(this.startNodeAt(i,s),0,!1,!0,t);if(A&&!this.canInsertSemicolon()){if(this.eat(Sd.arrow))return this.parseArrowExpression(this.startNodeAt(i,s),[o],!1,t);if(this.options.ecmaVersion>=8&&"async"===o.name&&this.type===Sd.name&&!a&&(!this.potentialArrowInForAwait||"of"!==this.value||this.containsEsc))return o=this.parseIdent(!1),!this.canInsertSemicolon()&&this.eat(Sd.arrow)||this.unexpected(),this.parseArrowExpression(this.startNodeAt(i,s),[o],!0,t)}return o;case Sd.regexp:var c=this.value;return(r=this.parseLiteral(c.value)).regex={pattern:c.pattern,flags:c.flags},r;case Sd.num:case Sd.string:return this.parseLiteral(this.value);case Sd._null:case Sd._true:case Sd._false:return(r=this.startNode()).value=this.type===Sd._null?null:this.type===Sd._true,r.raw=this.type.keyword,this.next(),this.finishNode(r,"Literal");case Sd.parenL:var l=this.start,u=this.parseParenAndDistinguishExpression(A,t);return e&&(e.parenthesizedAssign<0&&!this.isSimpleAssignTarget(u)&&(e.parenthesizedAssign=l),e.parenthesizedBind<0&&(e.parenthesizedBind=l)),u;case Sd.bracketL:return r=this.startNode(),this.next(),r.elements=this.parseExprList(Sd.bracketR,!0,!0,e),this.finishNode(r,"ArrayExpression");case Sd.braceL:return this.overrideContext(ff.b_expr),this.parseObj(!1,e);case Sd._function:return r=this.startNode(),this.next(),this.parseFunction(r,0);case Sd._class:return this.parseClass(this.startNode(),!1);case Sd._new:return this.parseNew();case Sd.backQuote:return this.parseTemplate();case Sd._import:return this.options.ecmaVersion>=11?this.parseExprImport(n):this.unexpected();default:return this.parseExprAtomDefault()}},gf.parseExprAtomDefault=function(){this.unexpected()},gf.parseExprImport=function(e){var t=this.startNode();if(this.containsEsc&&this.raiseRecoverable(this.start,"Escape sequence in keyword import"),this.next(),this.type===Sd.parenL&&!e)return this.parseDynamicImport(t);if(this.type===Sd.dot){var n=this.startNodeAt(t.start,t.loc&&t.loc.start);return n.name="import",t.meta=this.finishNode(n,"Identifier"),this.parseImportMeta(t)}this.unexpected()},gf.parseDynamicImport=function(e){if(this.next(),e.source=this.parseMaybeAssign(),this.options.ecmaVersion>=16)this.eat(Sd.parenR)?e.options=null:(this.expect(Sd.comma),this.afterTrailingComma(Sd.parenR)?e.options=null:(e.options=this.parseMaybeAssign(),this.eat(Sd.parenR)||(this.expect(Sd.comma),this.afterTrailingComma(Sd.parenR)||this.unexpected())));else if(!this.eat(Sd.parenR)){var t=this.start;this.eat(Sd.comma)&&this.eat(Sd.parenR)?this.raiseRecoverable(t,"Trailing comma is not allowed in import()"):this.unexpected(t)}return this.finishNode(e,"ImportExpression")},gf.parseImportMeta=function(e){this.next();var t=this.containsEsc;return e.property=this.parseIdent(!0),"meta"!==e.property.name&&this.raiseRecoverable(e.property.start,"The only valid meta property for import is 'import.meta'"),t&&this.raiseRecoverable(e.start,"'import.meta' must not contain escaped characters"),"module"===this.options.sourceType||this.options.allowImportExportEverywhere||this.raiseRecoverable(e.start,"Cannot use 'import.meta' outside a module"),this.finishNode(e,"MetaProperty")},gf.parseLiteral=function(e){var t=this.startNode();return t.value=e,t.raw=this.input.slice(this.start,this.end),110===t.raw.charCodeAt(t.raw.length-1)&&(t.bigint=t.raw.slice(0,-1).replace(/_/g,"")),this.next(),this.finishNode(t,"Literal")},gf.parseParenExpression=function(){this.expect(Sd.parenL);var e=this.parseExpression();return this.expect(Sd.parenR),e},gf.shouldParseArrow=function(e){return!this.canInsertSemicolon()},gf.parseParenAndDistinguishExpression=function(e,t){var n,r=this.start,A=this.startLoc,i=this.options.ecmaVersion>=8;if(this.options.ecmaVersion>=6){this.next();var s,a=this.start,o=this.startLoc,c=[],l=!0,u=!1,h=new nf,d=this.yieldPos,f=this.awaitPos;for(this.yieldPos=0,this.awaitPos=0;this.type!==Sd.parenR;){if(l?l=!1:this.expect(Sd.comma),i&&this.afterTrailingComma(Sd.parenR,!0)){u=!0;break}if(this.type===Sd.ellipsis){s=this.start,c.push(this.parseParenItem(this.parseRestBinding())),this.type===Sd.comma&&this.raiseRecoverable(this.start,"Comma is not permitted after the rest element");break}c.push(this.parseMaybeAssign(!1,h,this.parseParenItem))}var p=this.lastTokEnd,g=this.lastTokEndLoc;if(this.expect(Sd.parenR),e&&this.shouldParseArrow(c)&&this.eat(Sd.arrow))return this.checkPatternErrors(h,!1),this.checkYieldAwaitInDefaultParams(),this.yieldPos=d,this.awaitPos=f,this.parseParenArrowList(r,A,c,t);c.length&&!u||this.unexpected(this.lastTokStart),s&&this.unexpected(s),this.checkExpressionErrors(h,!0),this.yieldPos=d||this.yieldPos,this.awaitPos=f||this.awaitPos,c.length>1?((n=this.startNodeAt(a,o)).expressions=c,this.finishNodeAt(n,"SequenceExpression",p,g)):n=c[0]}else n=this.parseParenExpression();if(this.options.preserveParens){var m=this.startNodeAt(r,A);return m.expression=n,this.finishNode(m,"ParenthesizedExpression")}return n},gf.parseParenItem=function(e){return e},gf.parseParenArrowList=function(e,t,n,r){return this.parseArrowExpression(this.startNodeAt(e,t),n,!1,r)};var wf=[];gf.parseNew=function(){this.containsEsc&&this.raiseRecoverable(this.start,"Escape sequence in keyword new");var e=this.startNode();if(this.next(),this.options.ecmaVersion>=6&&this.type===Sd.dot){var t=this.startNodeAt(e.start,e.loc&&e.loc.start);t.name="new",e.meta=this.finishNode(t,"Identifier"),this.next();var n=this.containsEsc;return e.property=this.parseIdent(!0),"target"!==e.property.name&&this.raiseRecoverable(e.property.start,"The only valid meta property for new is 'new.target'"),n&&this.raiseRecoverable(e.start,"'new.target' must not contain escaped characters"),this.allowNewDotTarget||this.raiseRecoverable(e.start,"'new.target' can only be used in functions and class static block"),this.finishNode(e,"MetaProperty")}var r=this.start,A=this.startLoc;return e.callee=this.parseSubscripts(this.parseExprAtom(null,!1,!0),r,A,!0,!1),this.eat(Sd.parenL)?e.arguments=this.parseExprList(Sd.parenR,this.options.ecmaVersion>=8,!1):e.arguments=wf,this.finishNode(e,"NewExpression")},gf.parseTemplateElement=function(e){var t=e.isTagged,n=this.startNode();return this.type===Sd.invalidTemplate?(t||this.raiseRecoverable(this.start,"Bad escape sequence in untagged template literal"),n.value={raw:this.value.replace(/\r\n?/g,"\n"),cooked:null}):n.value={raw:this.input.slice(this.start,this.end).replace(/\r\n?/g,"\n"),cooked:this.value},this.next(),n.tail=this.type===Sd.backQuote,this.finishNode(n,"TemplateElement")},gf.parseTemplate=function(e){void 0===e&&(e={});var t=e.isTagged;void 0===t&&(t=!1);var n=this.startNode();this.next(),n.expressions=[];var r=this.parseTemplateElement({isTagged:t});for(n.quasis=[r];!r.tail;)this.type===Sd.eof&&this.raise(this.pos,"Unterminated template literal"),this.expect(Sd.dollarBraceL),n.expressions.push(this.parseExpression()),this.expect(Sd.braceR),n.quasis.push(r=this.parseTemplateElement({isTagged:t}));return this.next(),this.finishNode(n,"TemplateLiteral")},gf.isAsyncProp=function(e){return!e.computed&&"Identifier"===e.key.type&&"async"===e.key.name&&(this.type===Sd.name||this.type===Sd.num||this.type===Sd.string||this.type===Sd.bracketL||this.type.keyword||this.options.ecmaVersion>=9&&this.type===Sd.star)&&!Id.test(this.input.slice(this.lastTokEnd,this.start))},gf.parseObj=function(e,t){var n=this.startNode(),r=!0,A={};for(n.properties=[],this.next();!this.eat(Sd.braceR);){if(r)r=!1;else if(this.expect(Sd.comma),this.options.ecmaVersion>=5&&this.afterTrailingComma(Sd.braceR))break;var i=this.parseProperty(e,t);e||this.checkPropClash(i,A,t),n.properties.push(i)}return this.finishNode(n,e?"ObjectPattern":"ObjectExpression")},gf.parseProperty=function(e,t){var n,r,A,i,s=this.startNode();if(this.options.ecmaVersion>=9&&this.eat(Sd.ellipsis))return e?(s.argument=this.parseIdent(!1),this.type===Sd.comma&&this.raiseRecoverable(this.start,"Comma is not permitted after the rest element"),this.finishNode(s,"RestElement")):(s.argument=this.parseMaybeAssign(!1,t),this.type===Sd.comma&&t&&t.trailingComma<0&&(t.trailingComma=this.start),this.finishNode(s,"SpreadElement"));this.options.ecmaVersion>=6&&(s.method=!1,s.shorthand=!1,(e||t)&&(A=this.start,i=this.startLoc),e||(n=this.eat(Sd.star)));var a=this.containsEsc;return this.parsePropertyName(s),!e&&!a&&this.options.ecmaVersion>=8&&!n&&this.isAsyncProp(s)?(r=!0,n=this.options.ecmaVersion>=9&&this.eat(Sd.star),this.parsePropertyName(s)):r=!1,this.parsePropertyValue(s,e,n,r,A,i,t,a),this.finishNode(s,"Property")},gf.parseGetterSetter=function(e){e.kind=e.key.name,this.parsePropertyName(e),e.value=this.parseMethod(!1);var t="get"===e.kind?0:1;if(e.value.params.length!==t){var n=e.value.start;"get"===e.kind?this.raiseRecoverable(n,"getter should have no params"):this.raiseRecoverable(n,"setter should have exactly one param")}else"set"===e.kind&&"RestElement"===e.value.params[0].type&&this.raiseRecoverable(e.value.params[0].start,"Setter cannot use rest params")},gf.parsePropertyValue=function(e,t,n,r,A,i,s,a){(n||r)&&this.type===Sd.colon&&this.unexpected(),this.eat(Sd.colon)?(e.value=t?this.parseMaybeDefault(this.start,this.startLoc):this.parseMaybeAssign(!1,s),e.kind="init"):this.options.ecmaVersion>=6&&this.type===Sd.parenL?(t&&this.unexpected(),e.kind="init",e.method=!0,e.value=this.parseMethod(n,r)):t||a||!(this.options.ecmaVersion>=5)||e.computed||"Identifier"!==e.key.type||"get"!==e.key.name&&"set"!==e.key.name||this.type===Sd.comma||this.type===Sd.braceR||this.type===Sd.eq?this.options.ecmaVersion>=6&&!e.computed&&"Identifier"===e.key.type?((n||r)&&this.unexpected(),this.checkUnreserved(e.key),"await"!==e.key.name||this.awaitIdentPos||(this.awaitIdentPos=A),e.kind="init",t?e.value=this.parseMaybeDefault(A,i,this.copyNode(e.key)):this.type===Sd.eq&&s?(s.shorthandAssign<0&&(s.shorthandAssign=this.start),e.value=this.parseMaybeDefault(A,i,this.copyNode(e.key))):e.value=this.copyNode(e.key),e.shorthand=!0):this.unexpected():((n||r)&&this.unexpected(),this.parseGetterSetter(e))},gf.parsePropertyName=function(e){if(this.options.ecmaVersion>=6){if(this.eat(Sd.bracketL))return e.computed=!0,e.key=this.parseMaybeAssign(),this.expect(Sd.bracketR),e.key;e.computed=!1}return e.key=this.type===Sd.num||this.type===Sd.string?this.parseExprAtom():this.parseIdent("never"!==this.options.allowReserved)},gf.initFunction=function(e){e.id=null,this.options.ecmaVersion>=6&&(e.generator=e.expression=!1),this.options.ecmaVersion>=8&&(e.async=!1)},gf.parseMethod=function(e,t,n){var r=this.startNode(),A=this.yieldPos,i=this.awaitPos,s=this.awaitIdentPos;return this.initFunction(r),this.options.ecmaVersion>=6&&(r.generator=e),this.options.ecmaVersion>=8&&(r.async=!!t),this.yieldPos=0,this.awaitPos=0,this.awaitIdentPos=0,this.enterScope(64|Yd(t,r.generator)|(n?128:0)),this.expect(Sd.parenL),r.params=this.parseBindingList(Sd.parenR,!1,this.options.ecmaVersion>=8),this.checkYieldAwaitInDefaultParams(),this.parseFunctionBody(r,!1,!0,!1),this.yieldPos=A,this.awaitPos=i,this.awaitIdentPos=s,this.finishNode(r,"FunctionExpression")},gf.parseArrowExpression=function(e,t,n,r){var A=this.yieldPos,i=this.awaitPos,s=this.awaitIdentPos;return this.enterScope(16|Yd(n,!1)),this.initFunction(e),this.options.ecmaVersion>=8&&(e.async=!!n),this.yieldPos=0,this.awaitPos=0,this.awaitIdentPos=0,e.params=this.toAssignableList(t,!0),this.parseFunctionBody(e,!0,!1,r),this.yieldPos=A,this.awaitPos=i,this.awaitIdentPos=s,this.finishNode(e,"ArrowFunctionExpression")},gf.parseFunctionBody=function(e,t,n,r){var A=t&&this.type!==Sd.braceL,i=this.strict,s=!1;if(A)e.body=this.parseMaybeAssign(r),e.expression=!0,this.checkParams(e,!1);else{var a=this.options.ecmaVersion>=7&&!this.isSimpleParamList(e.params);i&&!a||(s=this.strictDirective(this.end))&&a&&this.raiseRecoverable(e.start,"Illegal 'use strict' directive in function with non-simple parameter list");var o=this.labels;this.labels=[],s&&(this.strict=!0),this.checkParams(e,!i&&!s&&!t&&!n&&this.isSimpleParamList(e.params)),this.strict&&e.id&&this.checkLValSimple(e.id,5),e.body=this.parseBlock(!1,void 0,s&&!i),e.expression=!1,this.adaptDirectivePrologue(e.body.body),this.labels=o}this.exitScope()},gf.isSimpleParamList=function(e){for(var t=0,n=e;t<n.length;t+=1)if("Identifier"!==n[t].type)return!1;return!0},gf.checkParams=function(e,t){for(var n=Object.create(null),r=0,A=e.params;r<A.length;r+=1){var i=A[r];this.checkLValInnerPattern(i,1,t?null:n)}},gf.parseExprList=function(e,t,n,r){for(var A=[],i=!0;!this.eat(e);){if(i)i=!1;else if(this.expect(Sd.comma),t&&this.afterTrailingComma(e))break;var s=void 0;n&&this.type===Sd.comma?s=null:this.type===Sd.ellipsis?(s=this.parseSpread(r),r&&this.type===Sd.comma&&r.trailingComma<0&&(r.trailingComma=this.start)):s=this.parseMaybeAssign(!1,r),A.push(s)}return A},gf.checkUnreserved=function(e){var t=e.start,n=e.end,r=e.name;this.inGenerator&&"yield"===r&&this.raiseRecoverable(t,"Cannot use 'yield' as identifier inside a generator"),this.inAsync&&"await"===r&&this.raiseRecoverable(t,"Cannot use 'await' as identifier inside an async function"),this.currentThisScope().inClassFieldInit&&"arguments"===r&&this.raiseRecoverable(t,"Cannot use 'arguments' in class field initializer"),!this.inClassStaticBlock||"arguments"!==r&&"await"!==r||this.raise(t,"Cannot use "+r+" in class static initialization block"),this.keywords.test(r)&&this.raise(t,"Unexpected keyword '"+r+"'"),this.options.ecmaVersion<6&&-1!==this.input.slice(t,n).indexOf("\\")||(this.strict?this.reservedWordsStrict:this.reservedWords).test(r)&&(this.inAsync||"await"!==r||this.raiseRecoverable(t,"Cannot use keyword 'await' outside an async function"),this.raiseRecoverable(t,"The keyword '"+r+"' is reserved"))},gf.parseIdent=function(e){var t=this.parseIdentNode();return this.next(!!e),this.finishNode(t,"Identifier"),e||(this.checkUnreserved(t),"await"!==t.name||this.awaitIdentPos||(this.awaitIdentPos=t.start)),t},gf.parseIdentNode=function(){var e=this.startNode();return this.type===Sd.name?e.name=this.value:this.type.keyword?(e.name=this.type.keyword,"class"!==e.name&&"function"!==e.name||this.lastTokEnd===this.lastTokStart+1&&46===this.input.charCodeAt(this.lastTokStart)||this.context.pop(),this.type=Sd.name):this.unexpected(),e},gf.parsePrivateIdent=function(){var e=this.startNode();return this.type===Sd.privateId?e.name=this.value:this.unexpected(),this.next(),this.finishNode(e,"PrivateIdentifier"),this.options.checkPrivateFields&&(0===this.privateNameStack.length?this.raise(e.start,"Private field '#"+e.name+"' must be declared in an enclosing class"):this.privateNameStack[this.privateNameStack.length-1].used.push(e)),e},gf.parseYield=function(e){this.yieldPos||(this.yieldPos=this.start);var t=this.startNode();return this.next(),this.type===Sd.semi||this.canInsertSemicolon()||this.type!==Sd.star&&!this.type.startsExpr?(t.delegate=!1,t.argument=null):(t.delegate=this.eat(Sd.star),t.argument=this.parseMaybeAssign(e)),this.finishNode(t,"YieldExpression")},gf.parseAwait=function(e){this.awaitPos||(this.awaitPos=this.start);var t=this.startNode();return this.next(),t.argument=this.parseMaybeUnary(null,!0,!1,e),this.finishNode(t,"AwaitExpression")};var vf=Xd.prototype;vf.raise=function(e,t){var n=Wd(this.input,e);t+=" ("+n.line+":"+n.column+")";var r=new SyntaxError(t);throw r.pos=e,r.loc=n,r.raisedAt=this.pos,r},vf.raiseRecoverable=vf.raise,vf.curPosition=function(){if(this.options.locations)return new Gd(this.curLine,this.pos-this.lineStart)};var Bf=Xd.prototype,bf=function(e){this.flags=e,this.var=[],this.lexical=[],this.functions=[],this.inClassFieldInit=!1};Bf.enterScope=function(e){this.scopeStack.push(new bf(e))},Bf.exitScope=function(){this.scopeStack.pop()},Bf.treatFunctionsAsVarInScope=function(e){return 2&e.flags||!this.inModule&&1&e.flags},Bf.declareName=function(e,t,n){var r=!1;if(2===t){var A=this.currentScope();r=A.lexical.indexOf(e)>-1||A.functions.indexOf(e)>-1||A.var.indexOf(e)>-1,A.lexical.push(e),this.inModule&&1&A.flags&&delete this.undefinedExports[e]}else if(4===t)this.currentScope().lexical.push(e);else if(3===t){var i=this.currentScope();r=this.treatFunctionsAsVar?i.lexical.indexOf(e)>-1:i.lexical.indexOf(e)>-1||i.var.indexOf(e)>-1,i.functions.push(e)}else for(var s=this.scopeStack.length-1;s>=0;--s){var a=this.scopeStack[s];if(a.lexical.indexOf(e)>-1&&!(32&a.flags&&a.lexical[0]===e)||!this.treatFunctionsAsVarInScope(a)&&a.functions.indexOf(e)>-1){r=!0;break}if(a.var.push(e),this.inModule&&1&a.flags&&delete this.undefinedExports[e],259&a.flags)break}r&&this.raiseRecoverable(n,"Identifier '"+e+"' has already been declared")},Bf.checkLocalExport=function(e){-1===this.scopeStack[0].lexical.indexOf(e.name)&&-1===this.scopeStack[0].var.indexOf(e.name)&&(this.undefinedExports[e.name]=e)},Bf.currentScope=function(){return this.scopeStack[this.scopeStack.length-1]},Bf.currentVarScope=function(){for(var e=this.scopeStack.length-1;;e--){var t=this.scopeStack[e];if(259&t.flags)return t}},Bf.currentThisScope=function(){for(var e=this.scopeStack.length-1;;e--){var t=this.scopeStack[e];if(259&t.flags&&!(16&t.flags))return t}};var _f=function(e,t,n){this.type="",this.start=t,this.end=0,e.options.locations&&(this.loc=new zd(e,n)),e.options.directSourceFile&&(this.sourceFile=e.options.directSourceFile),e.options.ranges&&(this.range=[t,0])},Cf=Xd.prototype;function xf(e,t,n,r){return e.type=t,e.end=n,this.options.locations&&(e.loc.end=r),this.options.ranges&&(e.range[1]=n),e}Cf.startNode=function(){return new _f(this,this.start,this.startLoc)},Cf.startNodeAt=function(e,t){return new _f(this,e,t)},Cf.finishNode=function(e,t){return xf.call(this,e,t,this.lastTokEnd,this.lastTokEndLoc)},Cf.finishNodeAt=function(e,t,n,r){return xf.call(this,e,t,n,r)},Cf.copyNode=function(e){var t=new _f(this,e.start,this.startLoc);for(var n in e)t[n]=e[n];return t};for(var Uf,Ff,Ef="ASCII ASCII_Hex_Digit AHex Alphabetic Alpha Any Assigned Bidi_Control Bidi_C Bidi_Mirrored Bidi_M Case_Ignorable CI Cased Changes_When_Casefolded CWCF Changes_When_Casemapped CWCM Changes_When_Lowercased CWL Changes_When_NFKC_Casefolded CWKCF Changes_When_Titlecased CWT Changes_When_Uppercased CWU Dash Default_Ignorable_Code_Point DI Deprecated Dep Diacritic Dia Emoji Emoji_Component Emoji_Modifier Emoji_Modifier_Base Emoji_Presentation Extender Ext Grapheme_Base Gr_Base Grapheme_Extend Gr_Ext Hex_Digit Hex IDS_Binary_Operator IDSB IDS_Trinary_Operator IDST ID_Continue IDC ID_Start IDS Ideographic Ideo Join_Control Join_C Logical_Order_Exception LOE Lowercase Lower Math Noncharacter_Code_Point NChar Pattern_Syntax Pat_Syn Pattern_White_Space Pat_WS Quotation_Mark QMark Radical Regional_Indicator RI Sentence_Terminal STerm Soft_Dotted SD Terminal_Punctuation Term Unified_Ideograph UIdeo Uppercase Upper Variation_Selector VS White_Space space XID_Continue XIDC XID_Start XIDS",Qf=Ef+" Extended_Pictographic",Sf=Qf+" EBase EComp EMod EPres ExtPict",If={9:Ef,10:Qf,11:Qf,12:Sf,13:Sf,14:Sf},kf={9:"",10:"",11:"",12:"",13:"",14:"Basic_Emoji Emoji_Keycap_Sequence RGI_Emoji_Modifier_Sequence RGI_Emoji_Flag_Sequence RGI_Emoji_Tag_Sequence RGI_Emoji_ZWJ_Sequence RGI_Emoji"},Df="Cased_Letter LC Close_Punctuation Pe Connector_Punctuation Pc Control Cc cntrl Currency_Symbol Sc Dash_Punctuation Pd Decimal_Number Nd digit Enclosing_Mark Me Final_Punctuation Pf Format Cf Initial_Punctuation Pi Letter L Letter_Number Nl Line_Separator Zl Lowercase_Letter Ll Mark M Combining_Mark Math_Symbol Sm Modifier_Letter Lm Modifier_Symbol Sk Nonspacing_Mark Mn Number N Open_Punctuation Ps Other C Other_Letter Lo Other_Number No Other_Punctuation Po Other_Symbol So Paragraph_Separator Zp Private_Use Co Punctuation P punct Separator Z Space_Separator Zs Spacing_Mark Mc Surrogate Cs Symbol S Titlecase_Letter Lt Unassigned Cn Uppercase_Letter Lu",Mf="Adlam Adlm Ahom Anatolian_Hieroglyphs Hluw Arabic Arab Armenian Armn Avestan Avst Balinese Bali Bamum Bamu Bassa_Vah Bass Batak Batk Bengali Beng Bhaiksuki Bhks Bopomofo Bopo Brahmi Brah Braille Brai Buginese Bugi Buhid Buhd Canadian_Aboriginal Cans Carian Cari Caucasian_Albanian Aghb Chakma Cakm Cham Cham Cherokee Cher Common Zyyy Coptic Copt Qaac Cuneiform Xsux Cypriot Cprt Cyrillic Cyrl Deseret Dsrt Devanagari Deva Duployan Dupl Egyptian_Hieroglyphs Egyp Elbasan Elba Ethiopic Ethi Georgian Geor Glagolitic Glag Gothic Goth Grantha Gran Greek Grek Gujarati Gujr Gurmukhi Guru Han Hani Hangul Hang Hanunoo Hano Hatran Hatr Hebrew Hebr Hiragana Hira Imperial_Aramaic Armi Inherited Zinh Qaai Inscriptional_Pahlavi Phli Inscriptional_Parthian Prti Javanese Java Kaithi Kthi Kannada Knda Katakana Kana Kayah_Li Kali Kharoshthi Khar Khmer Khmr Khojki Khoj Khudawadi Sind Lao Laoo Latin Latn Lepcha Lepc Limbu Limb Linear_A Lina Linear_B Linb Lisu Lisu Lycian Lyci Lydian Lydi Mahajani Mahj Malayalam Mlym Mandaic Mand Manichaean Mani Marchen Marc Masaram_Gondi Gonm Meetei_Mayek Mtei Mende_Kikakui Mend Meroitic_Cursive Merc Meroitic_Hieroglyphs Mero Miao Plrd Modi Mongolian Mong Mro Mroo Multani Mult Myanmar Mymr Nabataean Nbat New_Tai_Lue Talu Newa Newa Nko Nkoo Nushu Nshu Ogham Ogam Ol_Chiki Olck Old_Hungarian Hung Old_Italic Ital Old_North_Arabian Narb Old_Permic Perm Old_Persian Xpeo Old_South_Arabian Sarb Old_Turkic Orkh Oriya Orya Osage Osge Osmanya Osma Pahawh_Hmong Hmng Palmyrene Palm Pau_Cin_Hau Pauc Phags_Pa Phag Phoenician Phnx Psalter_Pahlavi Phlp Rejang Rjng Runic Runr Samaritan Samr Saurashtra Saur Sharada Shrd Shavian Shaw Siddham Sidd SignWriting Sgnw Sinhala Sinh Sora_Sompeng Sora Soyombo Soyo Sundanese Sund Syloti_Nagri Sylo Syriac Syrc Tagalog Tglg Tagbanwa Tagb Tai_Le Tale Tai_Tham Lana Tai_Viet Tavt Takri Takr Tamil Taml Tangut Tang Telugu Telu Thaana Thaa Thai Thai Tibetan Tibt Tifinagh Tfng Tirhuta Tirh Ugaritic Ugar Vai Vaii Warang_Citi Wara Yi Yiii Zanabazar_Square Zanb",Tf=Mf+" Dogra Dogr Gunjala_Gondi Gong Hanifi_Rohingya Rohg Makasar Maka Medefaidrin Medf Old_Sogdian Sogo Sogdian Sogd",Of=Tf+" Elymaic Elym Nandinagari Nand Nyiakeng_Puachue_Hmong Hmnp Wancho Wcho",Lf=Of+" Chorasmian Chrs Diak Dives_Akuru Khitan_Small_Script Kits Yezi Yezidi",Pf=Lf+" Cypro_Minoan Cpmn Old_Uyghur Ougr Tangsa Tnsa Toto Vithkuqi Vith",Hf={9:Mf,10:Tf,11:Of,12:Lf,13:Pf,14:Pf+" Gara Garay Gukh Gurung_Khema Hrkt Katakana_Or_Hiragana Kawi Kirat_Rai Krai Nag_Mundari Nagm Ol_Onal Onao Sunu Sunuwar Todhri Todr Tulu_Tigalari Tutg Unknown Zzzz"},Rf={},Nf=0,Vf=[9,10,11,12,13,14];Nf<Vf.length;Nf+=1)Ff=void 0,(Ff=Rf[Uf=Vf[Nf]]={binary:Kd(If[Uf]+" "+Df),binaryOfStrings:Kd(kf[Uf]),nonBinary:{General_Category:Kd(Df),Script:Kd(Hf[Uf])}}).nonBinary.Script_Extensions=Ff.nonBinary.Script,Ff.nonBinary.gc=Ff.nonBinary.General_Category,Ff.nonBinary.sc=Ff.nonBinary.Script,Ff.nonBinary.scx=Ff.nonBinary.Script_Extensions;var Kf=Xd.prototype,jf=function(e,t){this.parent=e,this.base=t||this};jf.prototype.separatedFrom=function(e){for(var t=this;t;t=t.parent)for(var n=e;n;n=n.parent)if(t.base===n.base&&t!==n)return!0;return!1},jf.prototype.sibling=function(){return new jf(this.parent,this.base)};var $f=function(e){this.parser=e,this.validFlags="gim"+(e.options.ecmaVersion>=6?"uy":"")+(e.options.ecmaVersion>=9?"s":"")+(e.options.ecmaVersion>=13?"d":"")+(e.options.ecmaVersion>=15?"v":""),this.unicodeProperties=Rf[e.options.ecmaVersion>=14?14:e.options.ecmaVersion],this.source="",this.flags="",this.start=0,this.switchU=!1,this.switchV=!1,this.switchN=!1,this.pos=0,this.lastIntValue=0,this.lastStringValue="",this.lastAssertionIsQuantifiable=!1,this.numCapturingParens=0,this.maxBackReference=0,this.groupNames=Object.create(null),this.backReferenceNames=[],this.branchID=null};function Gf(e){return 105===e||109===e||115===e}function zf(e){return 36===e||e>=40&&e<=43||46===e||63===e||e>=91&&e<=94||e>=123&&e<=125}function Wf(e){return e>=65&&e<=90||e>=97&&e<=122}function qf(e){return Wf(e)||95===e}function Jf(e){return qf(e)||Yf(e)}function Yf(e){return e>=48&&e<=57}function Xf(e){return e>=48&&e<=57||e>=65&&e<=70||e>=97&&e<=102}function Zf(e){return e>=65&&e<=70?e-65+10:e>=97&&e<=102?e-97+10:e-48}function ep(e){return e>=48&&e<=55}$f.prototype.reset=function(e,t,n){var r=-1!==n.indexOf("v"),A=-1!==n.indexOf("u");this.start=0|e,this.source=t+"",this.flags=n,r&&this.parser.options.ecmaVersion>=15?(this.switchU=!0,this.switchV=!0,this.switchN=!0):(this.switchU=A&&this.parser.options.ecmaVersion>=6,this.switchV=!1,this.switchN=A&&this.parser.options.ecmaVersion>=9)},$f.prototype.raise=function(e){this.parser.raiseRecoverable(this.start,"Invalid regular expression: /"+this.source+"/: "+e)},$f.prototype.at=function(e,t){void 0===t&&(t=!1);var n=this.source,r=n.length;if(e>=r)return-1;var A=n.charCodeAt(e);if(!t&&!this.switchU||A<=55295||A>=57344||e+1>=r)return A;var i=n.charCodeAt(e+1);return i>=56320&&i<=57343?(A<<10)+i-56613888:A},$f.prototype.nextIndex=function(e,t){void 0===t&&(t=!1);var n=this.source,r=n.length;if(e>=r)return r;var A,i=n.charCodeAt(e);return!t&&!this.switchU||i<=55295||i>=57344||e+1>=r||(A=n.charCodeAt(e+1))<56320||A>57343?e+1:e+2},$f.prototype.current=function(e){return void 0===e&&(e=!1),this.at(this.pos,e)},$f.prototype.lookahead=function(e){return void 0===e&&(e=!1),this.at(this.nextIndex(this.pos,e),e)},$f.prototype.advance=function(e){void 0===e&&(e=!1),this.pos=this.nextIndex(this.pos,e)},$f.prototype.eat=function(e,t){return void 0===t&&(t=!1),this.current(t)===e&&(this.advance(t),!0)},$f.prototype.eatChars=function(e,t){void 0===t&&(t=!1);for(var n=this.pos,r=0,A=e;r<A.length;r+=1){var i=A[r],s=this.at(n,t);if(-1===s||s!==i)return!1;n=this.nextIndex(n,t)}return this.pos=n,!0},Kf.validateRegExpFlags=function(e){for(var t=e.validFlags,n=e.flags,r=!1,A=!1,i=0;i<n.length;i++){var s=n.charAt(i);-1===t.indexOf(s)&&this.raise(e.start,"Invalid regular expression flag"),n.indexOf(s,i+1)>-1&&this.raise(e.start,"Duplicate regular expression flag"),"u"===s&&(r=!0),"v"===s&&(A=!0)}this.options.ecmaVersion>=15&&r&&A&&this.raise(e.start,"Invalid regular expression flag")},Kf.validateRegExpPattern=function(e){this.regexp_pattern(e),!e.switchN&&this.options.ecmaVersion>=9&&function(e){for(var t in e)return!0;return!1}(e.groupNames)&&(e.switchN=!0,this.regexp_pattern(e))},Kf.regexp_pattern=function(e){e.pos=0,e.lastIntValue=0,e.lastStringValue="",e.lastAssertionIsQuantifiable=!1,e.numCapturingParens=0,e.maxBackReference=0,e.groupNames=Object.create(null),e.backReferenceNames.length=0,e.branchID=null,this.regexp_disjunction(e),e.pos!==e.source.length&&(e.eat(41)&&e.raise("Unmatched ')'"),(e.eat(93)||e.eat(125))&&e.raise("Lone quantifier brackets")),e.maxBackReference>e.numCapturingParens&&e.raise("Invalid escape");for(var t=0,n=e.backReferenceNames;t<n.length;t+=1){var r=n[t];e.groupNames[r]||e.raise("Invalid named capture referenced")}},Kf.regexp_disjunction=function(e){var t=this.options.ecmaVersion>=16;for(t&&(e.branchID=new jf(e.branchID,null)),this.regexp_alternative(e);e.eat(124);)t&&(e.branchID=e.branchID.sibling()),this.regexp_alternative(e);t&&(e.branchID=e.branchID.parent),this.regexp_eatQuantifier(e,!0)&&e.raise("Nothing to repeat"),e.eat(123)&&e.raise("Lone quantifier brackets")},Kf.regexp_alternative=function(e){for(;e.pos<e.source.length&&this.regexp_eatTerm(e););},Kf.regexp_eatTerm=function(e){return this.regexp_eatAssertion(e)?(e.lastAssertionIsQuantifiable&&this.regexp_eatQuantifier(e)&&e.switchU&&e.raise("Invalid quantifier"),!0):!!(e.switchU?this.regexp_eatAtom(e):this.regexp_eatExtendedAtom(e))&&(this.regexp_eatQuantifier(e),!0)},Kf.regexp_eatAssertion=function(e){var t=e.pos;if(e.lastAssertionIsQuantifiable=!1,e.eat(94)||e.eat(36))return!0;if(e.eat(92)){if(e.eat(66)||e.eat(98))return!0;e.pos=t}if(e.eat(40)&&e.eat(63)){var n=!1;if(this.options.ecmaVersion>=9&&(n=e.eat(60)),e.eat(61)||e.eat(33))return this.regexp_disjunction(e),e.eat(41)||e.raise("Unterminated group"),e.lastAssertionIsQuantifiable=!n,!0}return e.pos=t,!1},Kf.regexp_eatQuantifier=function(e,t){return void 0===t&&(t=!1),!!this.regexp_eatQuantifierPrefix(e,t)&&(e.eat(63),!0)},Kf.regexp_eatQuantifierPrefix=function(e,t){return e.eat(42)||e.eat(43)||e.eat(63)||this.regexp_eatBracedQuantifier(e,t)},Kf.regexp_eatBracedQuantifier=function(e,t){var n=e.pos;if(e.eat(123)){var r=0,A=-1;if(this.regexp_eatDecimalDigits(e)&&(r=e.lastIntValue,e.eat(44)&&this.regexp_eatDecimalDigits(e)&&(A=e.lastIntValue),e.eat(125)))return-1!==A&&A<r&&!t&&e.raise("numbers out of order in {} quantifier"),!0;e.switchU&&!t&&e.raise("Incomplete quantifier"),e.pos=n}return!1},Kf.regexp_eatAtom=function(e){return this.regexp_eatPatternCharacters(e)||e.eat(46)||this.regexp_eatReverseSolidusAtomEscape(e)||this.regexp_eatCharacterClass(e)||this.regexp_eatUncapturingGroup(e)||this.regexp_eatCapturingGroup(e)},Kf.regexp_eatReverseSolidusAtomEscape=function(e){var t=e.pos;if(e.eat(92)){if(this.regexp_eatAtomEscape(e))return!0;e.pos=t}return!1},Kf.regexp_eatUncapturingGroup=function(e){var t=e.pos;if(e.eat(40)){if(e.eat(63)){if(this.options.ecmaVersion>=16){var n=this.regexp_eatModifiers(e),r=e.eat(45);if(n||r){for(var A=0;A<n.length;A++){var i=n.charAt(A);n.indexOf(i,A+1)>-1&&e.raise("Duplicate regular expression modifiers")}if(r){var s=this.regexp_eatModifiers(e);n||s||58!==e.current()||e.raise("Invalid regular expression modifiers");for(var a=0;a<s.length;a++){var o=s.charAt(a);(s.indexOf(o,a+1)>-1||n.indexOf(o)>-1)&&e.raise("Duplicate regular expression modifiers")}}}}if(e.eat(58)){if(this.regexp_disjunction(e),e.eat(41))return!0;e.raise("Unterminated group")}}e.pos=t}return!1},Kf.regexp_eatCapturingGroup=function(e){if(e.eat(40)){if(this.options.ecmaVersion>=9?this.regexp_groupSpecifier(e):63===e.current()&&e.raise("Invalid group"),this.regexp_disjunction(e),e.eat(41))return e.numCapturingParens+=1,!0;e.raise("Unterminated group")}return!1},Kf.regexp_eatModifiers=function(e){for(var t="",n=0;-1!==(n=e.current())&&Gf(n);)t+=jd(n),e.advance();return t},Kf.regexp_eatExtendedAtom=function(e){return e.eat(46)||this.regexp_eatReverseSolidusAtomEscape(e)||this.regexp_eatCharacterClass(e)||this.regexp_eatUncapturingGroup(e)||this.regexp_eatCapturingGroup(e)||this.regexp_eatInvalidBracedQuantifier(e)||this.regexp_eatExtendedPatternCharacter(e)},Kf.regexp_eatInvalidBracedQuantifier=function(e){return this.regexp_eatBracedQuantifier(e,!0)&&e.raise("Nothing to repeat"),!1},Kf.regexp_eatSyntaxCharacter=function(e){var t=e.current();return!!zf(t)&&(e.lastIntValue=t,e.advance(),!0)},Kf.regexp_eatPatternCharacters=function(e){for(var t=e.pos,n=0;-1!==(n=e.current())&&!zf(n);)e.advance();return e.pos!==t},Kf.regexp_eatExtendedPatternCharacter=function(e){var t=e.current();return!(-1===t||36===t||t>=40&&t<=43||46===t||63===t||91===t||94===t||124===t||(e.advance(),0))},Kf.regexp_groupSpecifier=function(e){if(e.eat(63)){this.regexp_eatGroupName(e)||e.raise("Invalid group");var t=this.options.ecmaVersion>=16,n=e.groupNames[e.lastStringValue];if(n)if(t)for(var r=0,A=n;r<A.length;r+=1)A[r].separatedFrom(e.branchID)||e.raise("Duplicate capture group name");else e.raise("Duplicate capture group name");t?(n||(e.groupNames[e.lastStringValue]=[])).push(e.branchID):e.groupNames[e.lastStringValue]=!0}},Kf.regexp_eatGroupName=function(e){if(e.lastStringValue="",e.eat(60)){if(this.regexp_eatRegExpIdentifierName(e)&&e.eat(62))return!0;e.raise("Invalid capture group name")}return!1},Kf.regexp_eatRegExpIdentifierName=function(e){if(e.lastStringValue="",this.regexp_eatRegExpIdentifierStart(e)){for(e.lastStringValue+=jd(e.lastIntValue);this.regexp_eatRegExpIdentifierPart(e);)e.lastStringValue+=jd(e.lastIntValue);return!0}return!1},Kf.regexp_eatRegExpIdentifierStart=function(e){var t=e.pos,n=this.options.ecmaVersion>=11,r=e.current(n);return e.advance(n),92===r&&this.regexp_eatRegExpUnicodeEscapeSequence(e,n)&&(r=e.lastIntValue),function(e){return bd(e,!0)||36===e||95===e}(r)?(e.lastIntValue=r,!0):(e.pos=t,!1)},Kf.regexp_eatRegExpIdentifierPart=function(e){var t=e.pos,n=this.options.ecmaVersion>=11,r=e.current(n);return e.advance(n),92===r&&this.regexp_eatRegExpUnicodeEscapeSequence(e,n)&&(r=e.lastIntValue),function(e){return _d(e,!0)||36===e||95===e||8204===e||8205===e}(r)?(e.lastIntValue=r,!0):(e.pos=t,!1)},Kf.regexp_eatAtomEscape=function(e){return!!(this.regexp_eatBackReference(e)||this.regexp_eatCharacterClassEscape(e)||this.regexp_eatCharacterEscape(e)||e.switchN&&this.regexp_eatKGroupName(e))||(e.switchU&&(99===e.current()&&e.raise("Invalid unicode escape"),e.raise("Invalid escape")),!1)},Kf.regexp_eatBackReference=function(e){var t=e.pos;if(this.regexp_eatDecimalEscape(e)){var n=e.lastIntValue;if(e.switchU)return n>e.maxBackReference&&(e.maxBackReference=n),!0;if(n<=e.numCapturingParens)return!0;e.pos=t}return!1},Kf.regexp_eatKGroupName=function(e){if(e.eat(107)){if(this.regexp_eatGroupName(e))return e.backReferenceNames.push(e.lastStringValue),!0;e.raise("Invalid named reference")}return!1},Kf.regexp_eatCharacterEscape=function(e){return this.regexp_eatControlEscape(e)||this.regexp_eatCControlLetter(e)||this.regexp_eatZero(e)||this.regexp_eatHexEscapeSequence(e)||this.regexp_eatRegExpUnicodeEscapeSequence(e,!1)||!e.switchU&&this.regexp_eatLegacyOctalEscapeSequence(e)||this.regexp_eatIdentityEscape(e)},Kf.regexp_eatCControlLetter=function(e){var t=e.pos;if(e.eat(99)){if(this.regexp_eatControlLetter(e))return!0;e.pos=t}return!1},Kf.regexp_eatZero=function(e){return 48===e.current()&&!Yf(e.lookahead())&&(e.lastIntValue=0,e.advance(),!0)},Kf.regexp_eatControlEscape=function(e){var t=e.current();return 116===t?(e.lastIntValue=9,e.advance(),!0):110===t?(e.lastIntValue=10,e.advance(),!0):118===t?(e.lastIntValue=11,e.advance(),!0):102===t?(e.lastIntValue=12,e.advance(),!0):114===t&&(e.lastIntValue=13,e.advance(),!0)},Kf.regexp_eatControlLetter=function(e){var t=e.current();return!!Wf(t)&&(e.lastIntValue=t%32,e.advance(),!0)},Kf.regexp_eatRegExpUnicodeEscapeSequence=function(e,t){void 0===t&&(t=!1);var n,r=e.pos,A=t||e.switchU;if(e.eat(117)){if(this.regexp_eatFixedHexDigits(e,4)){var i=e.lastIntValue;if(A&&i>=55296&&i<=56319){var s=e.pos;if(e.eat(92)&&e.eat(117)&&this.regexp_eatFixedHexDigits(e,4)){var a=e.lastIntValue;if(a>=56320&&a<=57343)return e.lastIntValue=1024*(i-55296)+(a-56320)+65536,!0}e.pos=s,e.lastIntValue=i}return!0}if(A&&e.eat(123)&&this.regexp_eatHexDigits(e)&&e.eat(125)&&(n=e.lastIntValue)>=0&&n<=1114111)return!0;A&&e.raise("Invalid unicode escape"),e.pos=r}return!1},Kf.regexp_eatIdentityEscape=function(e){if(e.switchU)return!!this.regexp_eatSyntaxCharacter(e)||!!e.eat(47)&&(e.lastIntValue=47,!0);var t=e.current();return!(99===t||e.switchN&&107===t||(e.lastIntValue=t,e.advance(),0))},Kf.regexp_eatDecimalEscape=function(e){e.lastIntValue=0;var t=e.current();if(t>=49&&t<=57){do{e.lastIntValue=10*e.lastIntValue+(t-48),e.advance()}while((t=e.current())>=48&&t<=57);return!0}return!1},Kf.regexp_eatCharacterClassEscape=function(e){var t=e.current();if(function(e){return 100===e||68===e||115===e||83===e||119===e||87===e}(t))return e.lastIntValue=-1,e.advance(),1;var n=!1;if(e.switchU&&this.options.ecmaVersion>=9&&((n=80===t)||112===t)){var r;if(e.lastIntValue=-1,e.advance(),e.eat(123)&&(r=this.regexp_eatUnicodePropertyValueExpression(e))&&e.eat(125))return n&&2===r&&e.raise("Invalid property name"),r;e.raise("Invalid property name")}return 0},Kf.regexp_eatUnicodePropertyValueExpression=function(e){var t=e.pos;if(this.regexp_eatUnicodePropertyName(e)&&e.eat(61)){var n=e.lastStringValue;if(this.regexp_eatUnicodePropertyValue(e)){var r=e.lastStringValue;return this.regexp_validateUnicodePropertyNameAndValue(e,n,r),1}}if(e.pos=t,this.regexp_eatLoneUnicodePropertyNameOrValue(e)){var A=e.lastStringValue;return this.regexp_validateUnicodePropertyNameOrValue(e,A)}return 0},Kf.regexp_validateUnicodePropertyNameAndValue=function(e,t,n){Rd(e.unicodeProperties.nonBinary,t)||e.raise("Invalid property name"),e.unicodeProperties.nonBinary[t].test(n)||e.raise("Invalid property value")},Kf.regexp_validateUnicodePropertyNameOrValue=function(e,t){return e.unicodeProperties.binary.test(t)?1:e.switchV&&e.unicodeProperties.binaryOfStrings.test(t)?2:void e.raise("Invalid property name")},Kf.regexp_eatUnicodePropertyName=function(e){var t=0;for(e.lastStringValue="";qf(t=e.current());)e.lastStringValue+=jd(t),e.advance();return""!==e.lastStringValue},Kf.regexp_eatUnicodePropertyValue=function(e){var t=0;for(e.lastStringValue="";Jf(t=e.current());)e.lastStringValue+=jd(t),e.advance();return""!==e.lastStringValue},Kf.regexp_eatLoneUnicodePropertyNameOrValue=function(e){return this.regexp_eatUnicodePropertyValue(e)},Kf.regexp_eatCharacterClass=function(e){if(e.eat(91)){var t=e.eat(94),n=this.regexp_classContents(e);return e.eat(93)||e.raise("Unterminated character class"),t&&2===n&&e.raise("Negated character class may contain strings"),!0}return!1},Kf.regexp_classContents=function(e){return 93===e.current()?1:e.switchV?this.regexp_classSetExpression(e):(this.regexp_nonEmptyClassRanges(e),1)},Kf.regexp_nonEmptyClassRanges=function(e){for(;this.regexp_eatClassAtom(e);){var t=e.lastIntValue;if(e.eat(45)&&this.regexp_eatClassAtom(e)){var n=e.lastIntValue;!e.switchU||-1!==t&&-1!==n||e.raise("Invalid character class"),-1!==t&&-1!==n&&t>n&&e.raise("Range out of order in character class")}}},Kf.regexp_eatClassAtom=function(e){var t=e.pos;if(e.eat(92)){if(this.regexp_eatClassEscape(e))return!0;if(e.switchU){var n=e.current();(99===n||ep(n))&&e.raise("Invalid class escape"),e.raise("Invalid escape")}e.pos=t}var r=e.current();return 93!==r&&(e.lastIntValue=r,e.advance(),!0)},Kf.regexp_eatClassEscape=function(e){var t=e.pos;if(e.eat(98))return e.lastIntValue=8,!0;if(e.switchU&&e.eat(45))return e.lastIntValue=45,!0;if(!e.switchU&&e.eat(99)){if(this.regexp_eatClassControlLetter(e))return!0;e.pos=t}return this.regexp_eatCharacterClassEscape(e)||this.regexp_eatCharacterEscape(e)},Kf.regexp_classSetExpression=function(e){var t,n=1;if(this.regexp_eatClassSetRange(e));else if(t=this.regexp_eatClassSetOperand(e)){2===t&&(n=2);for(var r=e.pos;e.eatChars([38,38]);)38!==e.current()&&(t=this.regexp_eatClassSetOperand(e))?2!==t&&(n=1):e.raise("Invalid character in character class");if(r!==e.pos)return n;for(;e.eatChars([45,45]);)this.regexp_eatClassSetOperand(e)||e.raise("Invalid character in character class");if(r!==e.pos)return n}else e.raise("Invalid character in character class");for(;;)if(!this.regexp_eatClassSetRange(e)){if(!(t=this.regexp_eatClassSetOperand(e)))return n;2===t&&(n=2)}},Kf.regexp_eatClassSetRange=function(e){var t=e.pos;if(this.regexp_eatClassSetCharacter(e)){var n=e.lastIntValue;if(e.eat(45)&&this.regexp_eatClassSetCharacter(e)){var r=e.lastIntValue;return-1!==n&&-1!==r&&n>r&&e.raise("Range out of order in character class"),!0}e.pos=t}return!1},Kf.regexp_eatClassSetOperand=function(e){return this.regexp_eatClassSetCharacter(e)?1:this.regexp_eatClassStringDisjunction(e)||this.regexp_eatNestedClass(e)},Kf.regexp_eatNestedClass=function(e){var t=e.pos;if(e.eat(91)){var n=e.eat(94),r=this.regexp_classContents(e);if(e.eat(93))return n&&2===r&&e.raise("Negated character class may contain strings"),r;e.pos=t}if(e.eat(92)){var A=this.regexp_eatCharacterClassEscape(e);if(A)return A;e.pos=t}return null},Kf.regexp_eatClassStringDisjunction=function(e){var t=e.pos;if(e.eatChars([92,113])){if(e.eat(123)){var n=this.regexp_classStringDisjunctionContents(e);if(e.eat(125))return n}else e.raise("Invalid escape");e.pos=t}return null},Kf.regexp_classStringDisjunctionContents=function(e){for(var t=this.regexp_classString(e);e.eat(124);)2===this.regexp_classString(e)&&(t=2);return t},Kf.regexp_classString=function(e){for(var t=0;this.regexp_eatClassSetCharacter(e);)t++;return 1===t?1:2},Kf.regexp_eatClassSetCharacter=function(e){var t=e.pos;if(e.eat(92))return!(!this.regexp_eatCharacterEscape(e)&&!this.regexp_eatClassSetReservedPunctuator(e)&&(e.eat(98)?(e.lastIntValue=8,0):(e.pos=t,1)));var n=e.current();return!(n<0||n===e.lookahead()&&function(e){return 33===e||e>=35&&e<=38||e>=42&&e<=44||46===e||e>=58&&e<=64||94===e||96===e||126===e}(n)||function(e){return 40===e||41===e||45===e||47===e||e>=91&&e<=93||e>=123&&e<=125}(n)||(e.advance(),e.lastIntValue=n,0))},Kf.regexp_eatClassSetReservedPunctuator=function(e){var t=e.current();return!!function(e){return 33===e||35===e||37===e||38===e||44===e||45===e||e>=58&&e<=62||64===e||96===e||126===e}(t)&&(e.lastIntValue=t,e.advance(),!0)},Kf.regexp_eatClassControlLetter=function(e){var t=e.current();return!(!Yf(t)&&95!==t||(e.lastIntValue=t%32,e.advance(),0))},Kf.regexp_eatHexEscapeSequence=function(e){var t=e.pos;if(e.eat(120)){if(this.regexp_eatFixedHexDigits(e,2))return!0;e.switchU&&e.raise("Invalid escape"),e.pos=t}return!1},Kf.regexp_eatDecimalDigits=function(e){var t=e.pos,n=0;for(e.lastIntValue=0;Yf(n=e.current());)e.lastIntValue=10*e.lastIntValue+(n-48),e.advance();return e.pos!==t},Kf.regexp_eatHexDigits=function(e){var t=e.pos,n=0;for(e.lastIntValue=0;Xf(n=e.current());)e.lastIntValue=16*e.lastIntValue+Zf(n),e.advance();return e.pos!==t},Kf.regexp_eatLegacyOctalEscapeSequence=function(e){if(this.regexp_eatOctalDigit(e)){var t=e.lastIntValue;if(this.regexp_eatOctalDigit(e)){var n=e.lastIntValue;t<=3&&this.regexp_eatOctalDigit(e)?e.lastIntValue=64*t+8*n+e.lastIntValue:e.lastIntValue=8*t+n}else e.lastIntValue=t;return!0}return!1},Kf.regexp_eatOctalDigit=function(e){var t=e.current();return ep(t)?(e.lastIntValue=t-48,e.advance(),!0):(e.lastIntValue=0,!1)},Kf.regexp_eatFixedHexDigits=function(e,t){var n=e.pos;e.lastIntValue=0;for(var r=0;r<t;++r){var A=e.current();if(!Xf(A))return e.pos=n,!1;e.lastIntValue=16*e.lastIntValue+Zf(A),e.advance()}return!0};var tp=function(e){this.type=e.type,this.value=e.value,this.start=e.start,this.end=e.end,e.options.locations&&(this.loc=new zd(e,e.startLoc,e.endLoc)),e.options.ranges&&(this.range=[e.start,e.end])},np=Xd.prototype;function rp(e){return"function"!=typeof BigInt?null:BigInt(e.replace(/_/g,""))}np.next=function(e){!e&&this.type.keyword&&this.containsEsc&&this.raiseRecoverable(this.start,"Escape sequence in keyword "+this.type.keyword),this.options.onToken&&this.options.onToken(new tp(this)),this.lastTokEnd=this.end,this.lastTokStart=this.start,this.lastTokEndLoc=this.endLoc,this.lastTokStartLoc=this.startLoc,this.nextToken()},np.getToken=function(){return this.next(),new tp(this)},"undefined"!=typeof Symbol&&(np[Symbol.iterator]=function(){var e=this;return{next:function(){var t=e.getToken();return{done:t.type===Sd.eof,value:t}}}}),np.nextToken=function(){var e=this.curContext();return e&&e.preserveSpace||this.skipSpace(),this.start=this.pos,this.options.locations&&(this.startLoc=this.curPosition()),this.pos>=this.input.length?this.finishToken(Sd.eof):e.override?e.override(this):void this.readToken(this.fullCharCodeAtPos())},np.readToken=function(e){return bd(e,this.options.ecmaVersion>=6)||92===e?this.readWord():this.getTokenFromCode(e)},np.fullCharCodeAtPos=function(){var e=this.input.charCodeAt(this.pos);if(e<=55295||e>=56320)return e;var t=this.input.charCodeAt(this.pos+1);return t<=56319||t>=57344?e:(e<<10)+t-56613888},np.skipBlockComment=function(){var e=this.options.onComment&&this.curPosition(),t=this.pos,n=this.input.indexOf("*/",this.pos+=2);if(-1===n&&this.raise(this.pos-2,"Unterminated comment"),this.pos=n+2,this.options.locations)for(var r=void 0,A=t;(r=Md(this.input,A,this.pos))>-1;)++this.curLine,A=this.lineStart=r;this.options.onComment&&this.options.onComment(!0,this.input.slice(t+2,n),t,this.pos,e,this.curPosition())},np.skipLineComment=function(e){for(var t=this.pos,n=this.options.onComment&&this.curPosition(),r=this.input.charCodeAt(this.pos+=e);this.pos<this.input.length&&!Dd(r);)r=this.input.charCodeAt(++this.pos);this.options.onComment&&this.options.onComment(!1,this.input.slice(t+e,this.pos),t,this.pos,n,this.curPosition())},np.skipSpace=function(){e:for(;this.pos<this.input.length;){var e=this.input.charCodeAt(this.pos);switch(e){case 32:case 160:++this.pos;break;case 13:10===this.input.charCodeAt(this.pos+1)&&++this.pos;case 10:case 8232:case 8233:++this.pos,this.options.locations&&(++this.curLine,this.lineStart=this.pos);break;case 47:switch(this.input.charCodeAt(this.pos+1)){case 42:this.skipBlockComment();break;case 47:this.skipLineComment(2);break;default:break e}break;default:if(!(e>8&&e<14||e>=5760&&Td.test(String.fromCharCode(e))))break e;++this.pos}}},np.finishToken=function(e,t){this.end=this.pos,this.options.locations&&(this.endLoc=this.curPosition());var n=this.type;this.type=e,this.value=t,this.updateContext(n)},np.readToken_dot=function(){var e=this.input.charCodeAt(this.pos+1);if(e>=48&&e<=57)return this.readNumber(!0);var t=this.input.charCodeAt(this.pos+2);return this.options.ecmaVersion>=6&&46===e&&46===t?(this.pos+=3,this.finishToken(Sd.ellipsis)):(++this.pos,this.finishToken(Sd.dot))},np.readToken_slash=function(){var e=this.input.charCodeAt(this.pos+1);return this.exprAllowed?(++this.pos,this.readRegexp()):61===e?this.finishOp(Sd.assign,2):this.finishOp(Sd.slash,1)},np.readToken_mult_modulo_exp=function(e){var t=this.input.charCodeAt(this.pos+1),n=1,r=42===e?Sd.star:Sd.modulo;return this.options.ecmaVersion>=7&&42===e&&42===t&&(++n,r=Sd.starstar,t=this.input.charCodeAt(this.pos+2)),61===t?this.finishOp(Sd.assign,n+1):this.finishOp(r,n)},np.readToken_pipe_amp=function(e){var t=this.input.charCodeAt(this.pos+1);return t===e?this.options.ecmaVersion>=12&&61===this.input.charCodeAt(this.pos+2)?this.finishOp(Sd.assign,3):this.finishOp(124===e?Sd.logicalOR:Sd.logicalAND,2):61===t?this.finishOp(Sd.assign,2):this.finishOp(124===e?Sd.bitwiseOR:Sd.bitwiseAND,1)},np.readToken_caret=function(){return 61===this.input.charCodeAt(this.pos+1)?this.finishOp(Sd.assign,2):this.finishOp(Sd.bitwiseXOR,1)},np.readToken_plus_min=function(e){var t=this.input.charCodeAt(this.pos+1);return t===e?45!==t||this.inModule||62!==this.input.charCodeAt(this.pos+2)||0!==this.lastTokEnd&&!Id.test(this.input.slice(this.lastTokEnd,this.pos))?this.finishOp(Sd.incDec,2):(this.skipLineComment(3),this.skipSpace(),this.nextToken()):61===t?this.finishOp(Sd.assign,2):this.finishOp(Sd.plusMin,1)},np.readToken_lt_gt=function(e){var t=this.input.charCodeAt(this.pos+1),n=1;return t===e?(n=62===e&&62===this.input.charCodeAt(this.pos+2)?3:2,61===this.input.charCodeAt(this.pos+n)?this.finishOp(Sd.assign,n+1):this.finishOp(Sd.bitShift,n)):33!==t||60!==e||this.inModule||45!==this.input.charCodeAt(this.pos+2)||45!==this.input.charCodeAt(this.pos+3)?(61===t&&(n=2),this.finishOp(Sd.relational,n)):(this.skipLineComment(4),this.skipSpace(),this.nextToken())},np.readToken_eq_excl=function(e){var t=this.input.charCodeAt(this.pos+1);return 61===t?this.finishOp(Sd.equality,61===this.input.charCodeAt(this.pos+2)?3:2):61===e&&62===t&&this.options.ecmaVersion>=6?(this.pos+=2,this.finishToken(Sd.arrow)):this.finishOp(61===e?Sd.eq:Sd.prefix,1)},np.readToken_question=function(){var e=this.options.ecmaVersion;if(e>=11){var t=this.input.charCodeAt(this.pos+1);if(46===t){var n=this.input.charCodeAt(this.pos+2);if(n<48||n>57)return this.finishOp(Sd.questionDot,2)}if(63===t)return e>=12&&61===this.input.charCodeAt(this.pos+2)?this.finishOp(Sd.assign,3):this.finishOp(Sd.coalesce,2)}return this.finishOp(Sd.question,1)},np.readToken_numberSign=function(){var e=35;if(this.options.ecmaVersion>=13&&(++this.pos,bd(e=this.fullCharCodeAtPos(),!0)||92===e))return this.finishToken(Sd.privateId,this.readWord1());this.raise(this.pos,"Unexpected character '"+jd(e)+"'")},np.getTokenFromCode=function(e){switch(e){case 46:return this.readToken_dot();case 40:return++this.pos,this.finishToken(Sd.parenL);case 41:return++this.pos,this.finishToken(Sd.parenR);case 59:return++this.pos,this.finishToken(Sd.semi);case 44:return++this.pos,this.finishToken(Sd.comma);case 91:return++this.pos,this.finishToken(Sd.bracketL);case 93:return++this.pos,this.finishToken(Sd.bracketR);case 123:return++this.pos,this.finishToken(Sd.braceL);case 125:return++this.pos,this.finishToken(Sd.braceR);case 58:return++this.pos,this.finishToken(Sd.colon);case 96:if(this.options.ecmaVersion<6)break;return++this.pos,this.finishToken(Sd.backQuote);case 48:var t=this.input.charCodeAt(this.pos+1);if(120===t||88===t)return this.readRadixNumber(16);if(this.options.ecmaVersion>=6){if(111===t||79===t)return this.readRadixNumber(8);if(98===t||66===t)return this.readRadixNumber(2)}case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:return this.readNumber(!1);case 34:case 39:return this.readString(e);case 47:return this.readToken_slash();case 37:case 42:return this.readToken_mult_modulo_exp(e);case 124:case 38:return this.readToken_pipe_amp(e);case 94:return this.readToken_caret();case 43:case 45:return this.readToken_plus_min(e);case 60:case 62:return this.readToken_lt_gt(e);case 61:case 33:return this.readToken_eq_excl(e);case 63:return this.readToken_question();case 126:return this.finishOp(Sd.prefix,1);case 35:return this.readToken_numberSign()}this.raise(this.pos,"Unexpected character '"+jd(e)+"'")},np.finishOp=function(e,t){var n=this.input.slice(this.pos,this.pos+t);return this.pos+=t,this.finishToken(e,n)},np.readRegexp=function(){for(var e,t,n=this.pos;;){this.pos>=this.input.length&&this.raise(n,"Unterminated regular expression");var r=this.input.charAt(this.pos);if(Id.test(r)&&this.raise(n,"Unterminated regular expression"),e)e=!1;else{if("["===r)t=!0;else if("]"===r&&t)t=!1;else if("/"===r&&!t)break;e="\\"===r}++this.pos}var A=this.input.slice(n,this.pos);++this.pos;var i=this.pos,s=this.readWord1();this.containsEsc&&this.unexpected(i);var a=this.regexpState||(this.regexpState=new $f(this));a.reset(n,A,s),this.validateRegExpFlags(a),this.validateRegExpPattern(a);var o=null;try{o=new RegExp(A,s)}catch(e){}return this.finishToken(Sd.regexp,{pattern:A,flags:s,value:o})},np.readInt=function(e,t,n){for(var r=this.options.ecmaVersion>=12&&void 0===t,A=n&&48===this.input.charCodeAt(this.pos),i=this.pos,s=0,a=0,o=0,c=null==t?1/0:t;o<c;++o,++this.pos){var l=this.input.charCodeAt(this.pos),u=void 0;if(r&&95===l)A&&this.raiseRecoverable(this.pos,"Numeric separator is not allowed in legacy octal numeric literals"),95===a&&this.raiseRecoverable(this.pos,"Numeric separator must be exactly one underscore"),0===o&&this.raiseRecoverable(this.pos,"Numeric separator is not allowed at the first of digits"),a=l;else{if((u=l>=97?l-97+10:l>=65?l-65+10:l>=48&&l<=57?l-48:1/0)>=e)break;a=l,s=s*e+u}}return r&&95===a&&this.raiseRecoverable(this.pos-1,"Numeric separator is not allowed at the last of digits"),this.pos===i||null!=t&&this.pos-i!==t?null:s},np.readRadixNumber=function(e){var t=this.pos;this.pos+=2;var n=this.readInt(e);return null==n&&this.raise(this.start+2,"Expected number in radix "+e),this.options.ecmaVersion>=11&&110===this.input.charCodeAt(this.pos)?(n=rp(this.input.slice(t,this.pos)),++this.pos):bd(this.fullCharCodeAtPos())&&this.raise(this.pos,"Identifier directly after number"),this.finishToken(Sd.num,n)},np.readNumber=function(e){var t=this.pos;e||null!==this.readInt(10,void 0,!0)||this.raise(t,"Invalid number");var n=this.pos-t>=2&&48===this.input.charCodeAt(t);n&&this.strict&&this.raise(t,"Invalid number");var r=this.input.charCodeAt(this.pos);if(!n&&!e&&this.options.ecmaVersion>=11&&110===r){var A=rp(this.input.slice(t,this.pos));return++this.pos,bd(this.fullCharCodeAtPos())&&this.raise(this.pos,"Identifier directly after number"),this.finishToken(Sd.num,A)}n&&/[89]/.test(this.input.slice(t,this.pos))&&(n=!1),46!==r||n||(++this.pos,this.readInt(10),r=this.input.charCodeAt(this.pos)),69!==r&&101!==r||n||(43!==(r=this.input.charCodeAt(++this.pos))&&45!==r||++this.pos,null===this.readInt(10)&&this.raise(t,"Invalid number")),bd(this.fullCharCodeAtPos())&&this.raise(this.pos,"Identifier directly after number");var i,s=(i=this.input.slice(t,this.pos),n?parseInt(i,8):parseFloat(i.replace(/_/g,"")));return this.finishToken(Sd.num,s)},np.readCodePoint=function(){var e;if(123===this.input.charCodeAt(this.pos)){this.options.ecmaVersion<6&&this.unexpected();var t=++this.pos;e=this.readHexChar(this.input.indexOf("}",this.pos)-this.pos),++this.pos,e>1114111&&this.invalidStringToken(t,"Code point out of bounds")}else e=this.readHexChar(4);return e},np.readString=function(e){for(var t="",n=++this.pos;;){this.pos>=this.input.length&&this.raise(this.start,"Unterminated string constant");var r=this.input.charCodeAt(this.pos);if(r===e)break;92===r?(t+=this.input.slice(n,this.pos),t+=this.readEscapedChar(!1),n=this.pos):8232===r||8233===r?(this.options.ecmaVersion<10&&this.raise(this.start,"Unterminated string constant"),++this.pos,this.options.locations&&(this.curLine++,this.lineStart=this.pos)):(Dd(r)&&this.raise(this.start,"Unterminated string constant"),++this.pos)}return t+=this.input.slice(n,this.pos++),this.finishToken(Sd.string,t)};var Ap={};np.tryReadTemplateToken=function(){this.inTemplateElement=!0;try{this.readTmplToken()}catch(e){if(e!==Ap)throw e;this.readInvalidTemplateToken()}this.inTemplateElement=!1},np.invalidStringToken=function(e,t){if(this.inTemplateElement&&this.options.ecmaVersion>=9)throw Ap;this.raise(e,t)},np.readTmplToken=function(){for(var e="",t=this.pos;;){this.pos>=this.input.length&&this.raise(this.start,"Unterminated template");var n=this.input.charCodeAt(this.pos);if(96===n||36===n&&123===this.input.charCodeAt(this.pos+1))return this.pos!==this.start||this.type!==Sd.template&&this.type!==Sd.invalidTemplate?(e+=this.input.slice(t,this.pos),this.finishToken(Sd.template,e)):36===n?(this.pos+=2,this.finishToken(Sd.dollarBraceL)):(++this.pos,this.finishToken(Sd.backQuote));if(92===n)e+=this.input.slice(t,this.pos),e+=this.readEscapedChar(!0),t=this.pos;else if(Dd(n)){switch(e+=this.input.slice(t,this.pos),++this.pos,n){case 13:10===this.input.charCodeAt(this.pos)&&++this.pos;case 10:e+="\n";break;default:e+=String.fromCharCode(n)}this.options.locations&&(++this.curLine,this.lineStart=this.pos),t=this.pos}else++this.pos}},np.readInvalidTemplateToken=function(){for(;this.pos<this.input.length;this.pos++)switch(this.input[this.pos]){case"\\":++this.pos;break;case"$":if("{"!==this.input[this.pos+1])break;case"`":return this.finishToken(Sd.invalidTemplate,this.input.slice(this.start,this.pos));case"\r":"\n"===this.input[this.pos+1]&&++this.pos;case"\n":case"\u2028":case"\u2029":++this.curLine,this.lineStart=this.pos+1}this.raise(this.start,"Unterminated template")},np.readEscapedChar=function(e){var t=this.input.charCodeAt(++this.pos);switch(++this.pos,t){case 110:return"\n";case 114:return"\r";case 120:return String.fromCharCode(this.readHexChar(2));case 117:return jd(this.readCodePoint());case 116:return"\t";case 98:return"\b";case 118:return"\v";case 102:return"\f";case 13:10===this.input.charCodeAt(this.pos)&&++this.pos;case 10:return this.options.locations&&(this.lineStart=this.pos,++this.curLine),"";case 56:case 57:if(this.strict&&this.invalidStringToken(this.pos-1,"Invalid escape sequence"),e){var n=this.pos-1;this.invalidStringToken(n,"Invalid escape sequence in template string")}default:if(t>=48&&t<=55){var r=this.input.substr(this.pos-1,3).match(/^[0-7]+/)[0],A=parseInt(r,8);return A>255&&(r=r.slice(0,-1),A=parseInt(r,8)),this.pos+=r.length-1,t=this.input.charCodeAt(this.pos),"0"===r&&56!==t&&57!==t||!this.strict&&!e||this.invalidStringToken(this.pos-1-r.length,e?"Octal literal in template string":"Octal literal in strict mode"),String.fromCharCode(A)}return Dd(t)?(this.options.locations&&(this.lineStart=this.pos,++this.curLine),""):String.fromCharCode(t)}},np.readHexChar=function(e){var t=this.pos,n=this.readInt(16,e);return null===n&&this.invalidStringToken(t,"Bad character escape sequence"),n},np.readWord1=function(){this.containsEsc=!1;for(var e="",t=!0,n=this.pos,r=this.options.ecmaVersion>=6;this.pos<this.input.length;){var A=this.fullCharCodeAtPos();if(_d(A,r))this.pos+=A<=65535?1:2;else{if(92!==A)break;this.containsEsc=!0,e+=this.input.slice(n,this.pos);var i=this.pos;117!==this.input.charCodeAt(++this.pos)&&this.invalidStringToken(this.pos,"Expecting Unicode escape sequence \\uXXXX"),++this.pos;var s=this.readCodePoint();(t?bd:_d)(s,r)||this.invalidStringToken(i,"Invalid Unicode escape"),e+=jd(s),n=this.pos}t=!1}return e+this.input.slice(n,this.pos)},np.readWord=function(){var e=this.readWord1(),t=Sd.name;return this.keywords.test(e)&&(t=Ed[e]),this.finishToken(t,e)},Xd.acorn={Parser:Xd,version:"8.14.0",defaultOptions:qd,Position:Gd,SourceLocation:zd,getLineInfo:Wd,Node:_f,TokenType:Cd,tokTypes:Sd,keywordTypes:Ed,TokContext:df,tokContexts:ff,isIdentifierChar:_d,isIdentifierStart:bd,Token:tp,isNewLine:Dd,lineBreak:Id,lineBreakG:kd,nonASCIIwhitespace:Td};const ip={undefined:"void(0)",Infinity:"Number.POSITIVE_INFINITY",NaN:"Number.NaN",E:"Math.E",LN2:"Math.LN2",LN10:"Math.LN10",LOG2E:"Math.LOG2E",LOG10E:"Math.LOG10E",PI:"Math.PI",SQRT1_2:"Math.SQRT1_2",SQRT2:"Math.SQRT2"},sp={ecmaVersion:11},ap=e=>(t,n)=>n.error(t,e+" not allowed"),op=ap("Aggregate function"),cp=ap("Window function"),lp="Invalid column reference",up=lp+" (must be input to an aggregate function)",hp="Invalid function call",dp="Table expressions do not support closures",fp="Use aq.escape(fn) to use a function as-is (including closures)",pp=`\nNote: ${dp}. ${fp}, or use table.params({ name: value }) to define dynamic parameters.`,gp=`\nNote: ${dp}. ${fp}, or use aq.addFunction(name, fn) to add new op functions.`,mp=`The ${Sn} method is not valid in multi-table expressions.`;function yp(e,t){const n=function(e){try{return(t=`expr=(${e.field?function(e){const t=JSON.stringify(e+"");return e.table?`(a,b)=>b[${t}]`:`d=>d[${t}]`}(e):Ne(e)?Lt(e):e})`,n=sp,Xd.parse(t,n)).body[0].expression.right}catch(t){$e("Expression parse error: "+e)}var t,n}(t);let r=e.root=n;return e.spec=t,e.tuple=null,e.tuple1=null,e.tuple2=null,e.$param=null,e.$op=0,e.scope=new Set,e.paramsRef=new Map,e.columnRef=new Map,function(e){return ld("FunctionExpression",e)||ld("ArrowFunctionExpression",e)}(r)?(function(e,t){e.generator&&ap("Generator functions")(e,t),e.async&&ap("Async functions")(e,t);const{params:n}=e,r=n.length,A=e=>(n,r)=>t.columnRef.set(n,[r,e]),i=(e,n)=>t.paramsRef.set(e,n);r&&(t.join?(bp(t,n[0],"tuple1",A(1)),r>1&&bp(t,n[1],"tuple2",A(2)),r>2&&bp(t,n[2],"$param",i)):(bp(t,n[0],"tuple",A(0)),r>1&&bp(t,n[1],"$param",i))),t.root=e.body}(r,e),r=r.body):e.join?(e.scope.add(e.tuple1="d1"),e.scope.add(e.tuple2="d2"),e.scope.add(e.$param="$")):(e.scope.add(e.tuple="d"),e.scope.add(e.$param="$")),ed(r,e,wp),e.root}const wp={FunctionDeclaration:ap("Function definitions"),ForStatement:ap("For loops"),ForOfStatement:ap("For-of loops"),ForInStatement:ap("For-in loops"),WhileStatement:ap("While loops"),DoWhileStatement:ap("Do-while loops"),AwaitExpression:ap("Await expressions"),ArrowFunctionExpression:ap("Function definitions"),AssignmentExpression:ap("Assignments"),FunctionExpression:ap("Function definitions"),NewExpression:ap('Use of "new"'),UpdateExpression:ap("Update expressions"),VariableDeclarator(e,t){kp(e.id,t)},Identifier(e,t,n){xp(e,t,n)&&!t.scope.has(e.name)&&t.error(e,"Invalid variable reference",pp)},CallExpression(e,t){const n=_p(e.callee),r=_n(n)||Cn(n);if(r){if((t.join||!1===t.aggregate)&&vn(r)&&op(e,t),(t.join||!1===t.window)&&Bn(r)&&cp(e,t),t.$op=1,t.ast)Ip(e,n,t),e.arguments.forEach((e=>ed(e,t,Bp)));else{const A=t.op(function(e,t,n,r){const A=[],i=[],s=t.param[0]||0,a=s+(t.param[1]||0);return r.forEach(((t,n)=>{n<s?(ed(t,e,Bp),A.push(e.field(t))):n<a?(ed(t,e,Bp),i.push(e.param(t))):e.error(t,"Invalid operator parameter")})),{name:n,fields:A,params:i,...e.spec.window||{}}}(t,r,n,e.arguments));Object.assign(e,{type:"Op",name:A.id})}return t.$op=0,!1}bn(n)?Ip(e,n,t):t.error(e,hp,gp)},MemberExpression(e,t,n){const{object:r,property:A}=e;if(!ld(Wt,r))return;const{name:i}=r;if(Cp(e)&&ld(Wt,A)&&At(ip,A.name))return void Sp(e,A.name);const s=i===t.tuple?0:i===t.tuple1?1:i===t.tuple2?2:-1;return s>=0?vp(e,s,t,Up,n):i===t.$param?vp(e,s,t,Ep):void(t.paramsRef.has(i)?Qp(e,t.paramsRef.get(i)):t.columnRef.has(i)?Fp(r,i,t,e):At(t.params,i)&&Qp(r,i))}};function vp(e,t,n,r,A){const{property:i,computed:s}=e;let a;if(s)if(ld(qt,i))a=i.value;else try{a=n.param(i)}catch(t){n.error(e,"Invalid member expression")}else a=i.name;return r(e,a,t,n,A),!1}const Bp={...wp,VariableDeclarator:ap("Variable declaration in operator call"),Identifier(e,t,n){xp(e,t,n)&&t.error(e,"Variable not accessible in operator call")},CallExpression(e,t){const n=_p(e.callee);bn(n)?Ip(e,n,t):t.error(e,hp,gp)}};function bp(e,t,n,r){ld(Wt,t)?(e.scope.add(t.name),e[n]=t.name):ld(Yt,t)&&t.properties.forEach((t=>{const n=ld(Wt,t.key)?t.key.name:ld(qt,t.key)?t.key.value:e.error(t,"Invalid argument");ld(Wt,t.value)||e.error(t.value,"Unsupported destructuring pattern"),r(t.value.name,n)}))}function _p(e){return ld(Wt,e)?e.name:ld(Jt,e)?Cp(e)?"max"===(t=e.property.name)?"greatest":"min"===t?"least":t:e.property.name:null;var t}function Cp(e){return ld(Wt,e.object)&&"Math"===e.object.name}function xp(e,t,n){const{name:r}=e;if(ld(Jt,n)&&n.property===e);else if(ld(Xt,n)&&n.key===e);else if(t.paramsRef.has(r))Qp(e,t.paramsRef.get(r));else if(t.columnRef.has(r))Fp(e,r,t,n);else if(At(t.params,r))Qp(e,r);else{if(!At(ip,r))return!0;Sp(e,r)}}function Up(e,t,n,r,A){const i=0===n?r.table:n>0?r.join[n-1]:null,s=i&&i.column(t);i&&!s&&r.error(e,lp),r.aggronly&&!r.$op&&r.error(e,up),En(e,t,n,s,A)}function Fp(e,t,n,r){const[A,i]=n.columnRef.get(t);Up(e,A,i,n,r)}function Ep(e,t,n,r){r.params&&!At(r.params,t)&&r.error(e,"Invalid param reference"),Qp(e,t)}function Qp(e,t){e.type="Parameter",e.name=t}function Sp(e,t){e.type="Constant",e.name=t,e.raw=ip[t]}function Ip(e,t,n){if(t===Sn){const t=n.table;t||n.error(e,mp),In(e,e.arguments.length?e.arguments.map((e=>{const r=n.param(e),A=Ge(r)?t.columnName(r):r;return t.column(A)||n.error(e,lp),A})):t.columnNames())}else e.callee={type:"Function",name:t}}function kp(e,t){ld(Wt,e)?t.scope.add(e.name):ld("ArrayPattern",e)?e.elements.forEach((e=>kp(e,t))):ld(Yt,e)?e.properties.forEach((e=>kp(e.value,t))):t.error(e.id,"Unsupported variable declaration")}const Dp={[Zt]:1,[en]:1};function Mp(e,t={}){const n=t.generate||ln,r=t.compiler||Un,A=function(e){return(e.table?Tp(e.table):e.join?{...Tp(e.join[1]),...Tp(e.join[0])}:{})||{}}(t),i={},s={},a=[],o=[];let c=0,l=-1;const u=t.join?r.join:1==t.index?r.expr2:r.expr,h={op(e){const t=function(e){let t=`${e.name}(${e.fields.concat(e.params).join(",")})`;return e.frame&&(t+=`[${e.frame.map((e=>Number.isFinite(e)?Math.abs(e):-1))},${!!e.peers}]`),t}(e);return s[t]||(e.id=++l,s[t]=e)},field(e){const t=n(e);return i[t]||(i[t]=++c)},param:e=>ld(qt,e)?e.value:r.param(n(e),A),value(e,r){a.push(e);const i=r.escape||(t.ast?(ed(s=r,null,{Column:cd,Constant:cd,Default:od}),s):u(n(r),A));var s;o.push(i),Dp[r.type]&&i!==r&&Ze(i)&&(i.field=r.name)},error(e,t,n=""){const r=e.start-6,A=e.end-6;$e(`${t}: "${String(h.spec).slice(r,A)}"${n}`)}};Object.assign(h,t,{params:A});for(const[t,n]of Qn(e))h.value(t+"",n.escape?ud(h,n,A):yp(h,n));if(t.ast)return{names:a,exprs:o};const d=[];for(const e in i)d[i[e]]=r.expr(e,A);const f=Object.values(s);return f.forEach((e=>e.fields=e.fields.map((e=>d[e])))),{names:a,exprs:o,ops:f}}function Tp(e){return e&&ze(e.params)?e.params():{}}const Op="Expr",Lp="ExprList",Pp="ExprNumber",Hp="ExprObject",Rp="JoinKeys",Np="JoinValues",Vp="Options",Kp="OrderKeys",jp="SelectionList",$p="TableRef",Gp="TableRefList";function zp(e,t){return e&&e.expr?new Wp({...e,...t}):new Wp(t,e)}class Wp{constructor(e,t){this.expr=t,Object.assign(this,e)}toString(){return String(this.expr)}toObject(){return{...this,expr:this.toString(),...ze(this.expr)?{func:!0}:{}}}}function qp(e,t,n=0){const r=n?{field:!0,table:n}:{field:!0};return zp(e,t?{expr:t,...r}:r)}function Jp(e,t){return(t=t&&ze(t.query)?t.query():t)&&ze(t.evaluate)?t.evaluate(null,e):e(t)}function Yp(e){return Ze(e)&&(Ne(e.all)||Ne(e.matches)||Ne(e.not)||Ne(e.range))}function Xp(e){return e&&ze(e.toObject)?e.toObject():ze(e)?{expr:String(e),func:!0}:Ne(e)?e.map(Xp):Ze(e)?Kh(e,(e=>Xp(e))):e}function Zp(e){return Ne(e)?e.map(Zp):Ze(e)?Ne(e.verbs)?pg.from(e):Ne(e.all)?qh():Ne(e.range)?function(e,t){return zh((n=>{let r=Ge(e)?e:n.columnIndex(e),A=Ge(t)?t:n.columnIndex(t);if(A<r){const e=A;A=r,r=e}return n.columnNames().slice(r,A+1)}),(()=>({range:[e,t]})))}(...e.range):Ne(e.match)?(tt(t=RegExp(...e.match))&&(t=RegExp(t.replace(/[.*+\-?^${}()|[\]\\]/g,"\\$&"))),zh((e=>e.columnNames((e=>t.test(e)))),(()=>({matches:[t.source,t.flags]})))):Ne(e.not)?Jh(e.not.map(Xp)):function(e){let t=e,n=e.expr;if(null!=n){if(!0===e.field?t=n=qp(n):!0===e.func&&(t=n=function(e){const t=e=>e;return t.toString=()=>e,t}(n)),Ze(e.window)){const{frame:r,peers:A}=e.window;t=n=function(e,t,n){return zp(e,{window:{frame:t||[-1/0,0],peers:!!n}})}(n,r,A)}!0===e.desc&&(t=function(e){return zp(e,{desc:!0})}(n))}return e===t?Kh(e,(e=>Zp(e))):t}(e):e;var t}function eg(e){const t=[];return Ve(e).forEach((e=>{Ge(e)?t.push(e):tt(e)?t.push(qp(e,null)):Ze(e)&&e.expr||ze(e)?t.push(e):$e("Invalid key value: "+e)})),t}function tg(e,t){return t<2?Ve(e):e}const ng={[Op]:cg,[Lp]:lg,[Pp]:function(e){return Ge(e)?e:sg(e)},[Hp]:sg,[Rp]:function(e){return Ne(e)?e.map(lg):sg(e,{join:!0})},[Np]:function(e){return Ne(e)?e.map(((e,t)=>t<2?lg(e):sg(e,{join:!0}))):sg(e,{join:!0})},[Kp]:lg,[jp]:function(e){return Ve(e).map(og).flat()}};function rg(e,t,n){return t===Vp?e?function(e,t={}){const n={};for(const r in e){const A=e[r];n[r]=t[r]?rg(A,t[r]):A}return n}(e,n):e:ng[t](e)}function Ag(e){return{type:Zt,name:e}}function ig(e){return{type:Zt,index:e}}function sg(e,t){if(tt(e))return function(e,t){return Mp({expr:e},{...t,ast:!0}).exprs[0]}(e,t);if(e.expr){let n;if(!0===e.field?n=Ag(e.expr):!0===e.func&&(n=sg(e.expr,t)),n)return e.desc&&(n={type:"Descending",expr:n}),e.window&&(n={type:"Window",expr:n,...e.window}),n}return Object.keys(e).map((n=>({...sg(e[n],t),as:n})))}function ag(e){const t="Selection";return e.all?{type:t,operator:"all"}:e.not?{type:t,operator:"not",arguments:lg(e.not)}:e.range?{type:t,operator:"range",arguments:lg(e.range)}:e.matches?{type:t,operator:"matches",arguments:e.matches}:$e("Invalid input")}function og(e){return Yp(e)?ag(e):Ge(e)?ig(e):tt(e)?Ag(e):Ze(e)?Object.keys(e).map((t=>({type:Zt,name:t,as:e[t]}))):$e("Invalid input")}function cg(e){return Yp(e)?ag(e):Ge(e)?ig(e):tt(e)?Ag(e):Ze(e)?sg(e):$e("Invalid input")}function lg(e){return Ve(e).map(cg).flat()}function ug(e){return e&&ze(e.toAST)?e.toAST():e}class hg{constructor(e,t=[],n=[]){this.verb=e,this.schema=t,t.forEach(((e,t)=>{const r=e.type,A=n[t],i=r===Rp?Ne(a=A)?a.map(eg):a:r===Np?Ne(s=A)?s.map(tg):s:r===Kp?function(e){const t=[];return e.forEach((e=>{const n=null!=e.expr?e.expr:e;if(Ze(n)&&!ze(n))for(const e in n)t.push(n[e]);else e=Ge(n)?n:tt(n)?qp(e):ze(n)?e:$e("Invalid orderby field: "+e),t.push(e)})),t}(A):A;var s,a;this[e.name]=void 0!==i?i:e.default}))}static from(e){const t=fg[e.verb];return t(...(t.schema||[]).map((({name:t})=>Zp(e[t]))))}evaluate(e,t){const n=this.schema.map((({name:e,type:n})=>{const r=this[e];return n===$p?Jp(t,r):n===Gp?r.map((e=>Jp(t,e))):r}));return e[this.verb](...n)}toObject(){const e={verb:this.verb};return this.schema.forEach((({name:t})=>{e[t]=Xp(this[t])})),e}toAST(){const e={type:"Verb",verb:this.verb};return this.schema.forEach((({name:t,type:n,props:r})=>{e[t]=function(e,t,n){return t===$p?ug(e):t===Gp?e.map(ug):rg(Xp(e),t,n)}(this[t],n,r)})),e}}function dg(e,t){return Object.assign(((...n)=>new hg(e,t,n)),{schema:t})}const fg={count:dg("count",[{name:"options",type:Vp}]),derive:dg("derive",[{name:"values",type:Hp},{name:"options",type:Vp,props:{before:jp,after:jp}}]),filter:dg("filter",[{name:"criteria",type:Hp}]),groupby:dg("groupby",[{name:"keys",type:Lp}]),orderby:dg("orderby",[{name:"keys",type:Kp}]),relocate:dg("relocate",[{name:"columns",type:jp},{name:"options",type:Vp,props:{before:jp,after:jp}}]),rename:dg("rename",[{name:"columns",type:jp}]),rollup:dg("rollup",[{name:"values",type:Hp}]),sample:dg("sample",[{name:"size",type:Pp},{name:"options",type:Vp,props:{weight:Op}}]),select:dg("select",[{name:"columns",type:jp}]),ungroup:dg("ungroup"),unorder:dg("unorder"),reify:dg("reify"),dedupe:dg("dedupe",[{name:"keys",type:Lp,default:[]}]),impute:dg("impute",[{name:"values",type:Hp},{name:"options",type:Vp,props:{expand:Lp}}]),fold:dg("fold",[{name:"values",type:Lp},{name:"options",type:Vp}]),pivot:dg("pivot",[{name:"keys",type:Lp},{name:"values",type:Lp},{name:"options",type:Vp}]),spread:dg("spread",[{name:"values",type:Lp},{name:"options",type:Vp}]),unroll:dg("unroll",[{name:"values",type:Lp},{name:"options",type:Vp,props:{drop:Lp}}]),lookup:dg("lookup",[{name:"table",type:$p},{name:"on",type:Rp},{name:"values",type:Lp}]),join:dg("join",[{name:"table",type:$p},{name:"on",type:Rp},{name:"values",type:Np},{name:"options",type:Vp}]),cross:dg("cross",[{name:"table",type:$p},{name:"values",type:Np},{name:"options",type:Vp}]),semijoin:dg("semijoin",[{name:"table",type:$p},{name:"on",type:Rp}]),antijoin:dg("antijoin",[{name:"table",type:$p},{name:"on",type:Rp}]),concat:dg("concat",[{name:"tables",type:Gp}]),union:dg("union",[{name:"tables",type:Gp}]),intersect:dg("intersect",[{name:"tables",type:Gp}]),except:dg("except",[{name:"tables",type:Gp}])};class pg extends je{constructor(e,t,n){super(t),this._verbs=e||[],this._table=n}static from({verbs:e,table:t,params:n}){return new pg(e.map(hg.from),n,t)}get[Symbol.toStringTag](){return this._verbs?`Query: ${this._verbs.length} verbs`+(this._table?` on '${this._table}'`:""):"Object"}get length(){return this._verbs.length}get tableName(){return this._table}params(e){return arguments.length?(this._params={...this._params,...e},this):this._params}evaluate(e,t){e=e||t(this._table);for(const n of this._verbs)e=n.evaluate(e.params(this._params),t);return e}toObject(){return gg(this,"toObject")}toJSON(){return this.toObject()}toAST(){return gg(this,"toAST",{type:"Query"})}}function gg(e,t,n){return{...n,verbs:e._verbs.map((e=>e[t]())),...e._params?{params:e._params}:null,...e._table?{table:e._table}:null}}function mg(e,t){return new pg(e._verbs.concat(t),e._params,e._table)}for(const e in fg){const t=fg[e];pg.prototype["__"+e]=function(e,...n){return mg(e,t(...n))}}function yg(e,t,...n){const r=["_","$"],A=r.slice(0,n.length);return A.push('"use strict"; const '+n.map(((e,t)=>e.map(((e,n)=>`${r[t]}${n} = ${r[t]}[${n}]`)).join(", "))).join(", ")+`; return (${e}) => ${t};`),Function(...A)(...n)}function wg(e,t){if(e.dictionary)return function(e){const{chunks:t,dictionary:n,length:r,nullCount:A}=e,i=n.length,s=function(e,t,n,r){const A=e.length>1||n?function(e,t,n){const r=new n.ArrayType(t),A=e.length;for(let t,n=0,i=0;n<A;++n)t=e[n].length,r.set(e[n].values.subarray(0,t),i),i+=t;return r}(e,t,e[0].type.indices):e[0].values;return n?function(e,t,n){const r=e.length;for(let A,i,s,a,o=0,c=0;o<r;++o){if(s=e[o].nullBitmap,A=e[o].length>>3,s&&s.length)for(let e=0;e<=A;++e)255!==(a=s[e])&&(i=c+(e<<3),1&a||(t[i+0]=n),2&a||(t[i+1]=n),4&a||(t[i+2]=n),8&a||(t[i+3]=n),16&a||(t[i+4]=n),32&a||(t[i+5]=n),64&a||(t[i+6]=n),128&a||(t[i+7]=n));c+=e[o].length}return t}(e,A,r):A}(t||[e],r,A,i),a=Array(i),o=e=>null==e||e<0||e>=i?null:void 0!==a[e]?a[e]:a[e]=n.get(e);return{vector:e,length:r,get:e=>o(s[e]),key:e=>s[e],keyFor(e){if(null===e)return A?i:-1;for(let t=0;t<i;++t)if(void 0===a[t]&&(a[t]=n.get(t)),a[t]===e)return t;return-1},groups(e){const t=i+(A?1:0);return{keys:s,get:[o],names:e,rows:Mt(0,t),size:t}},[Symbol.iterator]:()=>e[Symbol.iterator]()}}(e);const{typeId:n,chunks:r,length:A,numChildren:i}=e,s=r&&1===r.length?r[0]:e,a=i&&t?bg(s):i?vg(bg(s)):5===n?vg((e=>s.get(e))):null;return a?{vector:s,length:A,get:a,[Symbol.iterator]:()=>function*(e,t){for(let n=0;n<e;++n)yield t(n)}(A,a)}:s}function vg(e){const t=[];return n=>{const r=t[n];return void 0!==r?r:t[n]=e(n)}}const Bg=e=>e.numChildren?We(e.length,bg(e)):e.nullCount?[...e]:e.toArray(),bg=e=>{return 12===(t=e.typeId)||16===t?_g(e):13===e.typeId?function(e){const t=[],n=[];e.type.children.forEach(((r,A)=>{t.push(wg(e.getChildAt(A),!0)),n.push(`${Lt(r.name)}:_${A}.get(row)`)}));const r=yg("row","({"+n+"})",t);return e.nullCount?t=>e.isValid(t)?r(t):null:r}(e):$e(`Unsupported Arrow type: ${Lt(e.VectorName)}`);var t},_g=e=>e.nullCount?t=>e.isValid(t)?Bg(e.get(t)):null:t=>Bg(e.get(t)),Cg=2147483648;class xg{constructor(e){this._size=e,this._bits=new Uint32Array(Math.ceil(e/32))}get length(){return this._size}count(){const e=this._bits.length;let t=0;for(let n=0;n<e;++n)for(let e=this._bits[n];e;++t)e&=e-1;return t}get(e){return this._bits[e>>5]&Cg>>>e}set(e){this._bits[e>>5]|=Cg>>>e}clear(e){this._bits[e>>5]&=~(Cg>>>e)}scan(e){for(let t=this.next(0);t>=0;t=this.next(t+1))e(t)}next(e){const t=this._bits,n=t.length;let r=e>>5,A=t[r]&4294967295>>>e;for(;r<n;A=t[++r])if(0!==A)return(r<<5)+Math.clz32(A);return-1}nth(e){let t=this.next(0);for(;e--&&t>=0;)t=this.next(t+1);return t}not(){const e=this._bits,t=e.length;for(let n=0;n<t;++n)e[n]=~e[n];const n=this._size%32;return n&&(e[t-1]&=Cg>>n-1),this}and(e){if(e){const t=this._bits,n=e._bits,r=t.length;for(let e=0;e<r;++e)t[e]&=n[e]}return this}or(e){if(e){const t=this._bits,n=e._bits,r=t.length;for(let e=0;e<r;++e)t[e]|=n[e]}return this}}function Ug(e,t){const n=it();return t.forEach(((t,r)=>{const A=tt(t)?t:r;if(A){const t=e.column(r)||$e(`Unrecognized column: ${r}`);n.add(A,t)}})),e.create(n)}function Fg(e,t,{before:n,after:r}={}){const A=null!=n,i=null!=r;A||i||$e("relocate requires a before or after option."),A&&i&&$e("relocate accepts only one of the before or after options."),t=Gh(e,t);const s=[...Gh(e,A?n:r).keys()],a=A?s[0]:s.pop(),o=new Map;return e.columnNames().forEach((e=>{const n=!t.has(e);if(e===a){i&&n&&o.set(e,e);for(const[e,n]of t)o.set(e,n);if(i)return}n&&o.set(e,e)})),Ug(e,o)}function Eg(e,t=e=>e,n=""){const r=e.length;if(!r)return"";let A=t(e[0],0);for(let i=1;i<r;++i)A+=n+t(e[i],i);return A}function Qg(e,t){return e<t?-1:e>t?1:e>=t?0:NaN}function Sg(e){return Ot(e)?e:+e}class Ig{constructor(e){this._values=e||[],this._sorted=null,this._start=0}values(e){return this._start&&(this._values=this._values.slice(this._start),this._start=0),e?this._values.slice():this._values}add(e){this._values.push(e),this._sorted=null}rem(){this._start+=1,this._sorted=null}min(){return this._sorted&&this._sorted.length?this._sorted[0]:function(e,t=0,n=e.length){let r=n?e[t++]:at;for(let A=t;A<n;++A)r>e[A]&&(r=e[A]);return r}(this._values,this._start)}max(){return this._sorted&&this._sorted.length?this._sorted[this._sorted.length-1]:function(e,t=0,n=e.length){let r=n?e[t++]:at;for(let A=t;A<n;++A)r<e[A]&&(r=e[A]);return r}(this._values,this._start)}quantile(e){return this._sorted||(this._sorted=this.values(!0),this._sorted.sort(Qg)),function(e,t){const n=e.length;if(!n)return at;if((t=+t)<=0||n<2)return Sg(e[0]);if(t>=1)return Sg(e[n-1]);const r=(n-1)*t,A=Math.floor(r),i=Sg(e[A]);return Ot(i)?i:i+(Sg(e[A+1])-i)*(r-A)}(this._sorted,e)}}const kg=(e,t,n)=>yg(t,"{"+Eg(e,((e,r)=>`_${r}.${n}(${t});`))+"}",e);function Dg(e,t){const{ops:n,output:r}=function(e,t){const n={},r=[];function A(e,i=[]){const s=e+":"+i;if(n[s])return n[s];const a=_n(e),o=a.create(...i);return t<0&&a.stream&&a.stream.forEach((e=>A(e,[]))),a.req&&a.req.forEach((e=>A(e,[]))),n[s]=o,r.push(o),o}const i=e.map((e=>{const t=A(e.name,e.params);return t.output=e.id,t}));return{ops:r,output:i}}(e,t),A=e[0].fields,i=A.length;return new(0===i?Mg:1===i?Tg:2===i?Og:$e("Unsupported field count: "+i))(A,n,r,t)}class Mg extends Zh{constructor(e,t,n,r){super(n),this._op=t,this._fields=e,this._stream=!!r}init(){const e={count:0,valid:0,stream:this._stream};return this._op.forEach((t=>t.init(e))),e.values&&(e.list=new Ig),e}write(e,t,n){const r=this._outputs,A=r.length;for(let i=0;i<A;++i)t[r[i].output][n]=r[i].value(e);return 1}_add(){}_rem(){}add(e){++e.count}rem(e){--e.count}}class Tg extends Mg{constructor(e,t,n,r){super(e,t,n,r);const A=["state","v1","v2"];this._add=kg(t,A,"add"),this._rem=kg(t,A,"rem")}add(e,t,n){const r=this._fields[0](t,n);++e.count,ut(r)&&(++e.valid,e.list&&e.list.add(r),this._add(e,r))}rem(e,t,n){const r=this._fields[0](t,n);--e.count,ut(r)&&(--e.valid,e.list&&e.list.rem(),this._rem(e,r))}}class Og extends Mg{constructor(e,t,n,r){super(e,t,n,r);const A=["state","v1","v2"];this._add=kg(t,A,"add"),this._rem=kg(t,A,"rem")}add(e,t,n){const r=this._fields[0](t,n),A=this._fields[1](t,n);++e.count,ut(r)&&ut(A)&&(++e.valid,e.list&&e.list.add([r,A]),this._add(e,r,A))}rem(e,t,n){const r=this._fields[0](t,n),A=this._fields[1](t,n);--e.count,ut(r)&&ut(A)&&(--e.valid,e.list&&e.list.rem(),this._rem(e,r,A))}}function Lg(e,t,n){if(t.length){const r=e.data(),{keys:A}=e.groups()||{},i=Pg(e,t),s=A?(e,t)=>i[e][A[t]]:e=>i[e][0];n=n.map((e=>t=>e(t,r,s)))}return n}function Pg(e,t,n){if(!t.length)return n;const r=Hg(t),A=e.groups(),i=A?A.size:1;return n=n||We(t.length,(()=>Array(i))),i>1?r.forEach((t=>{const r=Ng(e,t,A);for(let e=0;e<i;++e)t.write(r[e],n,e)})):r.forEach((t=>{const r=Rg(e,t);t.write(r,n,0)})),n}function Hg(e,t){const n=[],r={};for(const t of e){const e=t.fields.map((e=>e+"")).join(",");(r[e]||(r[e]=[])).push(t)}for(const e in r)n.push(Dg(r[e],t));return n}function Rg(e,t){const n=t.init(),r=e.totalRows(),A=e.data(),i=e.mask();if(e.isOrdered()){const i=e.indices();for(let e=0;e<r;++e)t.add(n,i[e],A)}else if(i)for(let e=i.next(0);e>=0;e=i.next(e+1))t.add(n,e,A);else for(let e=0;e<r;++e)t.add(n,e,A);return n}function Ng(e,t,n){const{keys:r,size:A}=n,i=We(A,(()=>t.init())),s=e.data();if(e.isOrdered()){const n=e.indices(),A=n.length;for(let e=0;e<A;++e){const A=n[e];t.add(i[r[A]],A,s)}}else if(e.isFiltered()){const n=e.mask();for(let e=n.next(0);e>=0;e=n.next(e+1))t.add(i[r[e]],e,s)}else{const n=e.totalRows();for(let e=0;e<n;++e)t.add(i[r[e]],e,s)}return i}function Vg(e,t){const{get:n,names:r,rows:A,size:i}=t,s=r.length;for(let t=0;t<s;++t){const s=e.add(r[t],Array(i)),a=n[t];for(let e=0;e<i;++e)s[e]=a(A[e])}}function Kg(e){return{left(t,n,r,A){for(null==r&&(r=0),null==A&&(A=t.length);r<A;){const i=r+A>>>1;e(t[i],n)<0?r=i+1:A=i}return r},right(t,n,r,A){for(null==r&&(r=0),null==A&&(A=t.length);r<A;){const i=r+A>>>1;e(t[i],n)>0?A=i:r=i+1}return r}}}const jg=Kg(Qg);function $g(e){return Bn(e.name)||e.frame&&(Number.isFinite(e.frame[0])||Number.isFinite(e.frame[1]))}function Gg(e,{names:t,exprs:n,ops:r},A={}){const i=e.totalRows(),s=it(A.drop?null:e),a=t.map((e=>s.add(e,Array(i)))),[o,c]=function(e){const t=[],n=[],r=e.length;for(let A=0;A<r;++A){const r=e[A];r.id=A,($g(r)?n:t).push(r)}return[t,n]}(r),l=e.isGrouped()?e.groups().size:1,u=Pg(e,o,We(r.length,(()=>Array(l))));return c.length?function(e,t,n,r={},A){const i=e.data(),s=function(e,t){const n={};return e.forEach((e=>{const t=(e=>(e.frame||[null,null]).map((e=>Number.isFinite(e)?Math.abs(e):null)))(e),r=(e=>!!e.peers)(e),A=`${t},${r}`,{aggOps:i,winOps:s}=n[A]||(n[A]={frame:t,peers:r,aggOps:[],winOps:[]});vn(e.name)?i.push(e):s.push(function(e){const{id:t,name:n,fields:r=[],params:A=[]}=e,i=Cn(n).create(...A);return r.length&&(i.get=r[0]),i.id=t,i}(e))})),Object.values(n).map((e=>function(e,t,n,r,A){let i,s,a,o,c;const l=e=>s[e-1]===s[e],u=r.length,h=A.length,d=r.length?yg(["w","r","k"],"{"+Eg(r,((e,t)=>`r[_${t}.id][k]=_${t}.value(w,_${t}.get);`))+"}",r):()=>{},f={i0:0,i1:0,index:0,size:0,peer:l,init(e,t,n,l){f.index=f.i0=f.i1=0,f.size=t.length,i=e,s=t,o=n,c=l,a=A?A.map((e=>e.init())):null;for(let e=0;e<u;++e)r[e].init();return f},value:(t,n)=>n(i[t],e),step(r){const[u,p]=t,g=f.size,m=f.i0,y=f.i1;f.i0=null!=u?Math.max(0,r-Math.abs(u)):0,f.i1=null!=p?Math.min(g,r+Math.abs(p)+1):g,f.index=r,n&&(f.i0>0&&l(f.i0)&&(f.i0=jg.left(s,s[f.i0])),f.i1<g&&l(f.i1)&&(f.i1=jg.right(s,s[f.i1-1])));for(let t=0;t<h;++t){const n=A[t],r=a[t];for(let t=m;t<f.i0;++t)n.rem(r,i[t],e);for(let t=y;t<f.i1;++t)n.add(r,i[t],e);n.write(r,o,c)}return d(f,o,c),o}};return f}(t,e.frame,e.peers,e.winOps,Hg(e.aggOps,null!=e.frame[0]?-1:1))))}(A,i),a=s.length,o=yg(["r","d","op"],"{"+Eg(t,((e,t)=>`_${t}[r] = $${t}(r, d, op);`))+"}",t,n);e.partitions().forEach(((t,n)=>{const A=t.length,c=function(e,t){if(e.isOrdered()){const n=e.comparator(),r=e.data(),A=t.length,i=new Uint32Array(A);for(let e=1,s=0;e<A;++e)i[e]=n(t[e-1],t[e],r)?++s:s;return i}return t}(e,t);for(let e=0;e<a;++e)s[e].init(t,c,r,n);const l=e=>r[e][n];for(let e=0;e<A;++e){for(let t=0;t<a;++t)s[t].step(e);o(t[e],i,l)}}))}(e,a,n,u,c):function(e,t,n,r){const A=e.mask(),i=e.data(),{keys:s}=e.groups()||{},a=s?(e,t)=>r[e][s[t]]:e=>r[e][0],o=t.length;for(let r=0;r<o;++r){const s=n[r],o=t[r];if(A)for(let e=A.next(0);e>=0;e=A.next(e+1))o[e]=s(e,i,a);else{const t=e.totalRows();for(let e=0;e<t;++e)o[e]=s(e,i,a)}}}(e,a,n,u),e.create(s)}function zg(e,{names:t=[],exprs:n=[],ops:r=[]},A={}){if(!t.length)return e;const i=A.limit>0?+A.limit:1/0,s=A.index?!0===A.index?"index":A.index+"":null,a=new Set(A.drop),o=Lg(e,r,n),c=it(),l=new Set(t),u=[],h=[],d=[];e.columnNames().forEach((t=>{if(!a.has(t)){const n=c.add(t,[]);l.has(t)||(u.push(e.column(t)),h.push(n))}})),t.forEach((e=>{a.has(e)||(c.has(e)||c.add(e,[]),d.push(c.data[e]))}));const f=s?c.add(s,[]):null;let p=0;const g=u.length,m=d.length,y=(e,t)=>{for(let n=0;n<g;++n)h[n].length=p+t,h[n].fill(u[n].get(e),p,p+t)},w=f?(e,t)=>{for(let n=0;n<t;++n)f[e+n]=n}:()=>{};if(1===m){const t=o[0],n=d[0];e.scan(((e,r)=>{const A=Ve(t(e,r)),s=Math.min(A.length,i);y(e,s);for(let e=0;e<s;++e)n[p+e]=A[e];w(p,s),p+=s}))}else e.scan(((e,t)=>{let n=0;const r=o.map((r=>{const A=Ve(r(e,t));return n=Math.min(Math.max(n,A.length),i),A}));y(e,n);for(let e=0;e<m;++e){const t=d[e],A=r[e];for(let e=0;e<n;++e)t[p+e]=A[e]}w(p,n),p+=n}));return e.create(c.new())}function Wg(e,t,n,r={window:!1}){const A=new Map,i=n=>{tt(n=Ge(n)?t.columnName(n):n)?A.set(n,qp(n)):ze(n)?Gh(t,n).forEach(i):Ze(n)?$h(A,n):$e(`Invalid ${e} value: ${n+""}`)};return Ve(n).forEach(i),r.preparse&&r.preparse(A),Mp(A,{table:t,...r})}function qg(e,t,n,r){const A=n&&n.length;return function(e,{names:t,exprs:n,ops:r},A){const i=Lg(e,r,n),s=A?null:it(e),a=e.totalRows();return t.forEach(((t,n)=>{const r=e.column(t),o=A?r.data:s.add(t,Array(a)),c=i[n];e.scan((e=>{const t=r.get(e);o[e]=ut(t)?t:c(e)}))})),A?e:e.create(s)}(A?function(e,t,n){const r=e.groups(),A=e.data(),i=(r?r.names:[]).concat(t),s=(r?r.get:[]).concat(t.map((t=>e.getter(t)))),a=new Set,o=hn(s);e.scan(((e,t)=>a.add(o(e,t))));const c=e.columnNames(),l=it(),u=c.map((e=>l.add(e,[])));c.forEach(((t,n)=>{const r=A[t],i=u[n];e.scan((e=>i.push(r.get(e))))}));const h=hn(s.map(((e,t)=>e=>e[t]))),d=yg("v","{"+u.map(((e,t)=>`_${t}.push(v[$${t}]);`)).join("")+"}",u,c.map((e=>i.indexOf(e))));if(r){let e=r.keys.length;const t=n.reduce(((e,t)=>e*t.length),r.size),A=new Uint32Array(t+(e-a.size));A.set(r.keys),Jg(r,n,((t,n)=>{a.has(h(t))||(d(t),A[e++]=n[0])})),l.groupby({...r,keys:A})}else Jg(r,n,(e=>{a.has(h(e))||d(e)}));return e.create(l.new())}(e,n,r):e,t,A)}function Jg(e,t,n){const r=e?e.get.length:0,A=e?1:0,i=A+t.length,s=new Int32Array(i),a=new Int32Array(i),o=[];if(e){const{get:t,rows:n,size:A}=e;s[0]=A,o.push(((e,A)=>{const i=n[A];for(let n=0;n<r;++n)e[n]=t[n](i)}))}t.forEach(((e,t)=>{const n=t+r;s[t+A]=e.length,o.push(((t,r)=>t[n]=e[r]))}));const c=Array(r+t.length);for(let e=0;e<i;++e)o[e](c,0);n(c,a);for(let e=i-1;e>=0;){const t=++a[e];t<s[e]?(o[e](c,t),n(c,a),e=i-1):(a[e]=0,o[e](c,0),--e)}}function Yg(e,{names:t,exprs:n,ops:r}){const A=it(),i=e.groups();return i&&Vg(A,i),function(e,t,n,r=[],A){if(!t.length)return;const i=n?n.size:1,s=(e,t)=>r[e][t],a=e.length;for(let n=0;n<a;++n){const a=t[n];if(null!=a.field)A.add(e[n],r[a.field]);else if(i>1){const t=A.add(e[n],Array(i));for(let e=0;e<i;++e)t[e]=a(e,null,s)}else A.add(e[n],[a(0,null,s)])}}(t,n,i,Pg(e,r),A),e.create(A.new())}function Xg(e){e.forEach(((t,n)=>t.field?e.set(n,Kt(t+"")):0))}function Zg(e,t){const n=new Map;return e.scan(((e,r)=>{const A=t(e,r);null!=A&&A==A&&n.set(A,e)})),n}function em(e,t,n,{names:r,exprs:A},i={}){const s=e.data(),a=e.indices(!1),o=a.length,c=new Int32Array(o),l=t.data(),u=t.indices(!1),h=u.length,d=new Int32Array(h),f=r.length,p=it(),g=Array(f),m=Array(f);for(let e=0;e<r.length;++e)g[e]=p.add(r[e],[]),m[e]=A[e];const y=function(e,t){const n=["i","a","j","b"];return yg(n,"{"+Eg(e,((e,t)=>`_${t}.push($${t}(${n}));`))+"}",e,t)}(g,m);if((Ne(n)?nm:tm)(y,n,s,l,a,u,c,d,o,h),i.left)for(let e=0;e<o;++e)c[e]||y(a[e],s,-1,l);if(i.right)for(let e=0;e<h;++e)d[e]||y(-1,s,u[e],l);return e.create(p.new())}function tm(e,t,n,r,A,i,s,a,o,c){for(let l=0;l<o;++l){const o=A[l];for(let A=0;A<c;++A){const c=i[A];t(o,n,c,r)&&(e(o,n,c,r),s[l]=1,a[A]=1)}}}function nm(e,[t,n],r,A,i,s,a,o,c,l){let u,h,d,f,p,g,m,y,w=e;c>=l?(u=r,h=t,d=a,f=i,p=A,g=n,m=o,y=s):(u=A,h=n,d=o,f=s,p=r,g=t,m=a,y=i,w=(t,n,r,A)=>e(r,A,t,n));const v=function(e,t,n){const r=new Map,A=e.length;for(let i=0;i<A;++i){const A=n(e[i],t);null!=A&&A==A&&(r.has(A)?r.get(A).push(i):r.set(A,[i]))}return r}(y,p,g),B=f.length;for(let e=0;e<B;++e){const t=f[e],n=v.get(h(t,u));if(n){const r=n.length;for(let e=0;e<r;++e){const r=n[e];w(t,u,y[r],p),m[r]=1}d[e]=1}}}function rm(e,t,n){const r=new Map;return Ve(n).forEach(((n,A)=>{tt(n=Ge(n)?t.columnName(n):n)?r.set(A,qp(n)):ze(n)||Ze(n)&&n.expr?r.set(A,n):$e(`Invalid ${e} key value: ${n+""}`)})),hn(Mp(r,{table:t,aggregate:!1,window:!1}).exprs,!0)}function Am(e,t,n){if(n)tt(n)?n=[n,n]:Ne(n)&&1===n.length&&(n=[n[0],n[0]]);else{const r=function(e,t){const n=new Set(t);return e.filter((e=>n.has(e)))}(e.columnNames(),t.columnNames());r.length||$e("Natural join requires shared column names."),n=[r,r]}return n}function im(e,t,n,r){return n.length!==r.length&&$e("Mismatched number of join keys"),[rm("join",e,n),rm("join",t,r)]}const sm={aggregate:!1,window:!1,index:1};function am(e,t,n,r,A={}){n=Am(e,t,n);const i={join:[e,t]};let s;if(Ne(n)){const[i,a]=n.map(Ve);s=im(e,t,i,a),r||(r=function(e,t,n,r){const A=[];t.forEach(((e,t)=>tt(e)&&e===n[t]?A.push(e):0));const i=Jh(A);if(r.left&&r.right){const t=new Set(A);return[e.columnNames().map((e=>{const n=`[${Lt(e)}]`;return t.has(e)?{[e]:`(a, b) => a${n} == null ? b${n} : a${n}`}:e})),i]}return r.right?[i,qh()]:[qh(),i]}(e,i,a,A))}else s=Mp({on:n},i).exprs[0],r||(r=[qh(),qh()]);return em(e,t,s,function(e,t,n,r,A=[]){if(Ne(n)){let i,s,a,o=n.length;i=s=a={names:[],exprs:[]},o--&&(i=Wg("join",e,n[0],r)),o--&&(s=Wg("join",t,n[1],sm)),o--&&(a=Mp(n[2],r));const c=new Set,l=new Set(i.names);return s.names.forEach((e=>{l.has(e)&&c.add(e)})),c.size&&(om(i.names,c,A[0]||"_1"),om(s.names,c,A[1]||"_2")),{names:i.names.concat(s.names,a.names),exprs:i.exprs.concat(s.exprs,a.exprs)}}return Mp(n,r)}(e,t,r,i,A&&A.suffix),A)}function om(e,t,n){e.forEach(((r,A)=>t.has(r)?e[A]=r+n:0))}function cm(e,t,n,[r,A]){const i=Zg(n,A);t.scan(((t,n)=>{i.get(r(t,n))>=0&&e.set(t)}))}function lm(e,t,n,r){const A=t.numRows(),i=n.numRows(),s=t.data(),a=n.data();if(t.isFiltered()||n.isFiltered()){const o=t.indices(!1),c=n.indices(!1);for(let t=0;t<A;++t){const n=o[t];for(let t=0;t<i;++t)if(r(n,s,c[t],a)){e.set(n);break}}}else for(let t=0;t<A;++t)for(let n=0;n<i;++n)if(r(t,s,n,a)){e.set(t);break}}function um(e,t,n,r){return n=Am(e,t,n),function(e,t,n,r={}){const A=new xg(e.totalRows());return(Ne(n)?cm:lm)(A,e,t,n),r.anti&&A.not().and(e.mask()),e.create({filter:A})}(e,t,Ne(n)?im(e,t,...n.map(Ve)):Mp({on:n},{join:[e,t]}).exprs[0],r)}const hm=(e,t)=>null!=e?e:t;function dm(e){e.forEach(((t,n)=>t.field?e.set(n,Rt(t+"")):0))}function fm(e,t){return Yg(e,Mp(t,{table:e,aggronly:!0}))}function pm(e,t,n,r){return(t?r?mm:gm:r?wm:ym)(e.length,e,n,r)}function gm(e,t,n){const r=n.length;for(let A=0;A<e;++A)t[A]=n[r*St()|0];return t}function mm(e,t,n,r){const A=n.length,i=new Float64Array(A);let s=0;for(let e=0;e<A;++e)i[e]=s+=r(n[e]);const a=Kg(Qg).right;for(let r=0;r<e;++r)t[r]=n[a(i,s*St())];return t}function ym(e,t,n){const r=n.length;if(e>=r)return n;for(let r=0;r<e;++r)t[r]=n[r];for(let A=e;A<r;++A){const r=A*St();r<e&&(t[0|r]=n[A])}return t}function wm(e,t,n,r){const A=n.length;if(e>=A)return n;const i=new Float32Array(A),s=new Uint32Array(A);for(let e=0;e<A;++e)s[e]=e,i[e]=-Math.log(St())/r(n[e]);s.sort(((e,t)=>i[e]-i[t]));for(let r=0;r<e;++r)t[r]=n[s[r]];return t}const vm=e=>t=>e.get(t)||0;function Bm(e,{names:t=[],exprs:n=[],ops:r=[]}){const A=t.length;if(0===A)return null;if(1===A&&!e.isFiltered()&&n[0].field){const r=e.column(n[0].field);if(r.groups)return r.groups(t)}let i=Lg(e,r,n);const s=hn(i),a=e.totalRows(),o=new Uint32Array(a),c={},l=[],u=e.data(),h=e.mask();if(h)for(let e=h.next(0);e>=0;e=h.next(e+1)){const t=s(e,u)+"",n=c[t];o[e]=null!=n?n:c[t]=l.push(e)-1}else for(let e=0;e<a;++e){const t=s(e,u)+"",n=c[t];o[e]=null!=n?n:c[t]=l.push(e)-1}return r.length||(i=i.map((e=>t=>e(t,u)))),{keys:o,get:i,names:t,rows:l,size:l.length}}const bm=(e,t,n,r)=>`((u = ${e}) < (v = ${t}) || u == null) && v != null ? ${n}\n    : (u > v || v == null) && u != null ? ${r}\n    : ((v = v instanceof Date ? +v : v), (u = u instanceof Date ? +u : u)) !== u && v === v ? ${n}\n    : v !== v && u === u ? ${r} : `,_m={__antijoin:(e,t,n)=>um(e,t,n,{anti:!0}),__count:(e,t={})=>fm(e,{[t.as||"count"]:Nt()}),__cross:(e,t,n,r)=>am(e,t,(()=>!0),n,{...r,left:!0,right:!0}),__concat:function(e,t){const n=e.numRows(),r=n+t.reduce(((e,t)=>e+t.numRows()),0);if(n===r)return e;const A=[e,...t],i=it();return e.columnNames().forEach((e=>{const t=Array(r);let n=0;A.forEach((r=>{const A=r.column(e)||{get:()=>at};r.scan((e=>t[n++]=A.get(e)))})),i.add(e,t)})),e.create(i.new())},__dedupe:function(e,t=[]){return e.groupby(t.length?t:e.columnNames()).filter("row_number() === 1").ungroup().reify()},__derive:function(e,t,n={}){const r=Gg(e,Mp(t,{table:e}),n);return n.drop||null==n.before&&null==n.after?r:Fg(r,Object.keys(t).filter((t=>!e.column(t))),n)},__except:function(e,t){if(0===t.length)return e;const n=e.columnNames();return t.reduce(((e,t)=>e.antijoin(t.select(n))),e).dedupe()},__filter:function(e,t){const n=Mp({p:t},{table:e});let r=n.exprs[0];if(n.ops.length){const{data:t}=Gg(e,n,{drop:!0}).column("p");r=e=>t[e]}return function(e,t){const n=e.totalRows(),r=e.mask(),A=e.data(),i=new xg(n);if(r)for(let e=r.next(0);e>=0;e=r.next(e+1))t(e,A)&&i.set(e);else for(let e=0;e<n;++e)t(e,A)&&i.set(e);return e.create({filter:i})}(e,r)},__fold:function(e,t,n){return function(e,{names:t=[],exprs:n=[],ops:r=[]},A={}){if(0===t.length)return e;const[i="key",s="value"]=A.as||[],a=Lg(e,r,n);return zg(e,{names:[i,s],exprs:[()=>t,(e,t)=>a.map((n=>n(e,t)))]},{...A,drop:t})}(e,Wg("fold",e,t),n)},__impute:function(e,t,n={}){if((t=Mp(t,{table:e})).names.forEach((t=>e.column(t)?0:$e(`Invalid impute column ${Lt(t)}`))),n.expand){const r={preparse:Xg,aggronly:!0},A=Wg("impute",e,n.expand,r),i=Yg(e.ungroup(),A);return qg(e,t,A.names,A.names.map((e=>i.get(e,0))))}return qg(e,t)},__intersect:function(e,t){const n=e.columnNames();return t.length?t.reduce(((e,t)=>e.semijoin(t.select(n))),e).dedupe():e.reify([])},__join:am,__lookup:function(e,t,n,r){return function(e,t,[n,r],{names:A,exprs:i,ops:s}){const a=it(e),o=e.totalRows();A.forEach((e=>a.add(e,Array(o).fill(at))));const c=Zg(t,r),l=yg(["lr","rr","data"],"{"+Eg(A,((e,t)=>`_[${t}][lr] = $[${t}](rr, data);`))+"}",A.map((e=>a.data[e])),Lg(t,s,i)),u=t.data();return e.scan(((e,t)=>{const r=c.get(n(e,t));r>=0&&l(e,r,u)})),e.create(a)}(e,t,[rm("lookup",e,(n=Am(e,t,n))[0]),rm("lookup",t,n[1])],Wg("lookup",t,r))},__pivot:function(e,t,n,r){return function(e,t,n,r={}){const{keys:A,keyColumn:i}=function(e,t,n){const r=n.limit>0?+n.limit:1/0,A=hm(n.sort,!0),i=hm(n.keySeparator,"_"),s=Lg(e,t.ops,t.exprs),a=1===s.length?s[0]:(e,t)=>s.map((n=>n(e,t))).join(i),o=Array(e.totalRows());e.scan(((e,t)=>o[e]=a(e,t)));const c=Pg(e.ungroup(),[{id:0,name:"array_agg_distinct",fields:[e=>o[e]],params:[]}])[0][0],l=A?c.sort():c;return{keys:Number.isFinite(r)?l.slice(0,r):l,keyColumn:o}}(e,t,r),s=hm(r.valueSeparator,"_"),a=n.names.length>1?(e,t)=>t+s+A[e]:e=>A[e],o=A.map((t=>Pg(e,n.ops.map((e=>{const n=e.fields.map((e=>{const n=(n,r)=>t===i[n]?e(n,r):NaN;return n.toString=()=>t+":"+e,n}));return{...e,fields:n}})))));return e.create(function({names:e,exprs:t},n,r,A){const i=r?r.size:1,s=it(),a=A.length,o=e.length;let c;const l=(e,t)=>c[e][t];r&&Vg(s,r);for(let r=0;r<o;++r){const o=t[r];if(null!=o.field)for(let t=0;t<a;++t)s.add(n(t,e[r]),A[t][o.field]);else if(i>1)for(let t=0;t<a;++t){c=A[t];const a=s.add(n(t,e[r]),Array(i));for(let e=0;e<i;++e)a[e]=o(e,null,l)}else for(let t=0;t<a;++t)c=A[t],s.add(n(t,e[r]),[o(0,null,l)])}return s.new()}(n,a,e.groups(),o))}(e,Wg("fold",e,t),Wg("fold",e,n,{preparse:dm,aggronly:!0}),r)},__relocate:Fg,__rename:function(e,t){const n=new Map;return e.columnNames((e=>(n.set(e,e),0))),Ug(e,Gh(e,t,n))},__rollup:fm,__sample:function(e,t,n={}){return function(e,t,n,r={}){const{replace:A,shuffle:i}=r,s=e.partitions(!1);let a=0;t=s.map(((e,n)=>{let r=t(n);return a+=r=A?r:Math.min(e.length,r),r}));const o=new Uint32Array(a);let c=0;return s.forEach(((e,r)=>{const i=t[r],s=o.subarray(c,c+=i);A||i!==e.length?pm(s,A,e,n):s.set(e)})),!1!==i&&(s.length>1||!A)&&function(e,t=0,n=e.length){let r=n-(t=+t);for(;r;){const n=St()*r--|0,A=e[r+t];e[r+t]=e[n+t],e[n+t]=A}}(o),e.reify(o)}(e,function(e,t){return Ge(t)?()=>t:vm(Yg(e,Mp({size:t},{table:e})).column("size"))}(e,t),function(e,t){return null==t?null:(t=Ge(t)?e.columnName(t):t,vm(tt(t)?e.column(t):Gg(e,Mp({w:t},{table:e}),{drop:!0}).column("w")))}(e,n.weight),n)},__select:function(e,t){return Ug(e,Gh(e,t))},__semijoin:um,__spread:function(e,t,n){return function(e,{names:t,exprs:n,ops:r=[]},A={}){if(0===t.length)return e;const i=1===t.length&&A.as||[],s=null==A.drop||!!A.drop,a=null==A.limit?i.length||1/0:Math.max(1,+A.limit||1),o=Lg(e,r,n),c=it(),l=t.reduce(((e,t,n)=>e.set(t,n)),new Map),u=(t,n)=>{const r=function(e,t,n){const r=e.totalRows(),A=[];return e.scan(((e,i)=>{const s=Ve(t(e,i)),a=Math.min(s.length,n);for(;A.length<a;)A.push(Array(r).fill(at));for(let t=0;t<a;++t)A[t][e]=s[t]})),A}(e,o[t],a),A=r.length;for(let e=0;e<A;++e)c.add(i[e]||`${n}_${e+1}`,r[e])};return e.columnNames().forEach((t=>{l.has(t)?(s||c.add(t,e.column(t)),u(l.get(t),t),l.delete(t)):c.add(t,e.column(t))})),l.forEach(u),e.create(c)}(e,Wg("spread",e,t),n)},__union:function(e,t){return e.concat(t).dedupe()},__unroll:function(e,t,n){return zg(e,Wg("unroll",e,t),n&&n.drop?{...n,drop:Wg("unroll",e,n.drop).names}:n)},__groupby:function(e,t){return function(e,t){return e.create({groups:Bm(e,t)})}(e,Wg("groupby",e,t))},__orderby:function(e,t){return function(e,t){return e.create({order:t})}(e,function(e,t){let n=-1;const r=new Map,A=e=>r.set(++n+"",e);return t.forEach((t=>{const n=null!=t.expr?t.expr:t;if(Ze(n)&&!ze(n))for(const e in n)A(n[e]);else A(Ge(n)?qp(t,e.columnName(n)):tt(n)?qp(t):ze(n)?t:$e("Invalid orderby field: "+t))})),function(e,t){const n=[],r=[],A=[];let i=null,s="0",a="0";e.isGrouped()&&(i=e.groups().keys,s="ka",a="kb");const{ops:o}=Mp(t,{table:e,value:(e,t)=>{if(n.push(e),t.escape){const e=e=>`fn[${A.length}](${e}, data)`;r.push([e("a"),e("b")]),A.push(t.escape)}else r.push([ln(t,{index:"a",op:s}),ln(t,{index:"b",op:a})])},window:!1}),c=Pg(e,o),l=(e,t)=>c[e][t],u=n.length;let h="return (a, b) => {"+(l&&e.isGrouped()?"const ka = keys[a], kb = keys[b];":"")+"let u, v; return ";for(let e=0;e<u;++e){const A=t.get(n[e]).desc?-1:1,[i,s]=r[e];h+=bm(i,s,-A,A)}return h+="0;};",Function("op","keys","fn","data",h)(l,i,A,e.data())}(e,r)}(e,t))},__ungroup:function(e){return e.isGrouped()?e.create({groups:null}):e},__unorder:function(e){return e.isOrdered()?e.create({order:null}):e},__reduce:function(e,t){const n=it(),r=e.groups(),{get:A,names:i=[],rows:s,size:a=1}=r||{},o=new Uint32Array(a+1);i.forEach((e=>n.add(e,null)));const c=r?Ng(e,t,r):[Rg(e,t)];t.outputs().map((e=>n.add(e,[])));const l=o.length-1;let u=0;for(let e=0;e<l;++e)u+=o[e+1]=t.write(c[e],n.data,o[e]);if(r){const t=e.data();i.forEach(((e,r)=>{const i=n.data[e]=Array(u),c=A[r];for(let e=0,n=0;e<a;++e)i.fill(c(s[e],t),n,n+=o[e+1])}))}return e.create(n.new())}};Object.assign(Yh.prototype,_m),Yh.prototype;const Cm=[];function xm(e,t=h){let n;const r=new Set;function A(t){if(y(e,t)&&(e=t,n)){const t=!Cm.length;for(const t of r)t[1](),Cm.push(t,e);if(t){for(let e=0;e<Cm.length;e+=2)Cm[e][0](Cm[e+1]);Cm.length=0}}}return{set:A,update:function(t){A(t(e))},subscribe:function(i,s=h){const a=[i,s];return r.add(a),1===r.size&&(n=t(A)||h),i(e),()=>{r.delete(a),0===r.size&&n&&(n(),n=null)}}}}function Um(e,t,n){const r=!Array.isArray(e),A=r?[e]:e,i=t.length<2;return{subscribe:xm(n,(e=>{let n=!1;const s=[];let a=0,o=h;const c=()=>{if(a)return;o();const n=t(r?s[0]:s,e);i?e(n):o=m(n)?n:h},l=A.map(((e,t)=>b(e,(e=>{s[t]=e,a&=~(1<<t),n&&c()}),(()=>{a|=1<<t}))));return n=!0,c(),function(){g(l),o(),n=!1}})).subscribe}}function Fm(e,t){const n=e,r=xm(t);let A;return{set:e=>{r.set(e),A&&(A.set(n,e),A.save_changes())},setModel:e=>{A=e,r.set(A.get(n)),A.on("change:"+n,(()=>r.set(A.get(n))),null)},subscribe:r.subscribe,update:e=>{r.update((t=>{const r=e(t);return A&&(A.set(n,""),A.set(n,r),A.save_changes()),r}))}}}const Em=Fm("canvas_spec",{}),Qm=(Fm("widgetSpecs",{}),Fm("table",new DataView(new ArrayBuffer(0)))),Sm=Fm("selected",[]),Im=Fm("group_columns",[]),km=Fm("filter",""),Dm=Fm("filter_error",""),Mm=Fm("tooltip",{hover:!1,mousePos:{x:0,y:0},fetchPrefix:"",instance:void 0,number:0}),Tm=Um(Qm,(e=>function(e,t={}){e=function(e){return e&&e.chunks?e:Lh().from(e)}(e);const{chunks:n,length:r,schema:A}=e,i=A.fields.map((e=>e.name)),s=Gh({columnNames:e=>e?i.filter(e):i.slice(),columnIndex:e=>i.indexOf(e)},t.columns||qh()),a=it();s.forEach(((t,n)=>{a.add(t,wg(e.getColumn(n)))}));const o=e.count()!==r?new xg(r):null;if(o){let t=0,r=0;e.scan((e=>o.set(t+e)),(e=>{for(;n[r]!==e;)t+=n[r++].length}))}return new Yh(a.data,a.names,o)}(e))),Om=Um([Tm,km],(([e,t])=>{Dm.set("");let n=e;if(t)try{n=n.filter(t)}catch(e){Dm.set(e)}return n})),Lm=Um([Om,Im],(([e,t])=>{if(t.length>0){const n=t.map((t=>e.rollup({col:zt.array_agg_distinct(t)}).object().col));return 1===n.length?n[0].map((e=>[e])):((...e)=>e.reduce(((e,t)=>e.flatMap((e=>t.map((t=>[e,t].reduce(((e,t)=>e.concat(t)),[]))))))))(...n)}return[]})),Pm=Um([Om,Im,Lm,Em],(([e,t,n,r])=>void 0!==t&&void 0!==e&&void 0!==n&&t.length>0&&n.length>0?e.groupby(...t).partitions().map((t=>e.reify(t))):[])),Hm=parseFloat;function Rm(e,t=";"){let n;if(Array.isArray(e))n=e.filter((e=>e));else{n=[];for(const t in e)e[t]&&n.push(`${t}:${e[t]}`)}return n.join(t)}function Nm(e){R(e,"svelte-q6amlk",".spin.svelte-q6amlk{-webkit-animation:svelte-q6amlk-spin 2s 0s infinite linear;animation:svelte-q6amlk-spin 2s 0s infinite linear}.pulse.svelte-q6amlk{-webkit-animation:svelte-q6amlk-spin 1s infinite steps(8);animation:svelte-q6amlk-spin 1s infinite steps(8)}@-webkit-keyframes svelte-q6amlk-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes svelte-q6amlk-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}")}function Vm(e){let t,n,r,A,i,s,a;function o(e,t){return"string"==typeof e[7][4]?jm:Km}let c=o(e),l=c(e);return{c(){t=W("svg"),n=W("g"),r=W("g"),l.c(),Z(r,"transform",e[10]),Z(n,"transform",A=`translate(${e[7][0]/2} ${e[7][1]/2})`),Z(n,"transform-origin",i=e[7][0]/4+" 0"),Z(t,"id",e[0]),Z(t,"class",s=Q(e[8])+" svelte-q6amlk"),Z(t,"style",e[9]),Z(t,"viewBox",a=`0 0 ${e[7][0]} ${e[7][1]}`),Z(t,"aria-hidden","true"),Z(t,"role","img"),Z(t,"xmlns","http://www.w3.org/2000/svg")},m(e,A){j(e,t,A),H(t,n),H(n,r),l.m(r,null)},p(e,u){c===(c=o(e))&&l?l.p(e,u):(l.d(1),l=c(e),l&&(l.c(),l.m(r,null))),1024&u&&Z(r,"transform",e[10]),128&u&&A!==(A=`translate(${e[7][0]/2} ${e[7][1]/2})`)&&Z(n,"transform",A),128&u&&i!==(i=e[7][0]/4+" 0")&&Z(n,"transform-origin",i),1&u&&Z(t,"id",e[0]),256&u&&s!==(s=Q(e[8])+" svelte-q6amlk")&&Z(t,"class",s),512&u&&Z(t,"style",e[9]),128&u&&a!==(a=`0 0 ${e[7][0]} ${e[7][1]}`)&&Z(t,"viewBox",a)},d(e){e&&$(t),l.d()}}}function Km(e){let t,n,r,A,i,s,a,o,c,l;return{c(){t=W("path"),s=W("path"),Z(t,"d",n=e[7][4][0]),Z(t,"fill",r=e[3]||e[1]||"currentColor"),Z(t,"fill-opacity",A=0!=e[6]?e[4]:e[5]),Z(t,"transform",i=`translate(${e[7][0]/-2} ${e[7][1]/-2})`),Z(s,"d",a=e[7][4][1]),Z(s,"fill",o=e[2]||e[1]||"currentColor"),Z(s,"fill-opacity",c=0!=e[6]?e[5]:e[4]),Z(s,"transform",l=`translate(${e[7][0]/-2} ${e[7][1]/-2})`)},m(e,n){j(e,t,n),j(e,s,n)},p(e,u){128&u&&n!==(n=e[7][4][0])&&Z(t,"d",n),10&u&&r!==(r=e[3]||e[1]||"currentColor")&&Z(t,"fill",r),112&u&&A!==(A=0!=e[6]?e[4]:e[5])&&Z(t,"fill-opacity",A),128&u&&i!==(i=`translate(${e[7][0]/-2} ${e[7][1]/-2})`)&&Z(t,"transform",i),128&u&&a!==(a=e[7][4][1])&&Z(s,"d",a),6&u&&o!==(o=e[2]||e[1]||"currentColor")&&Z(s,"fill",o),112&u&&c!==(c=0!=e[6]?e[5]:e[4])&&Z(s,"fill-opacity",c),128&u&&l!==(l=`translate(${e[7][0]/-2} ${e[7][1]/-2})`)&&Z(s,"transform",l)},d(e){e&&$(t),e&&$(s)}}}function jm(e){let t,n,r,A;return{c(){t=W("path"),Z(t,"d",n=e[7][4]),Z(t,"fill",r=e[1]||e[2]||"currentColor"),Z(t,"transform",A=`translate(${e[7][0]/-2} ${e[7][1]/-2})`)},m(e,n){j(e,t,n)},p(e,i){128&i&&n!==(n=e[7][4])&&Z(t,"d",n),6&i&&r!==(r=e[1]||e[2]||"currentColor")&&Z(t,"fill",r),128&i&&A!==(A=`translate(${e[7][0]/-2} ${e[7][1]/-2})`)&&Z(t,"transform",A)},d(e){e&&$(t)}}}function $m(e){let t,n=e[7][4]&&Vm(e);return{c(){n&&n.c(),t=Y()},m(e,r){n&&n.m(e,r),j(e,t,r)},p(e,[r]){e[7][4]?n?n.p(e,r):(n=Vm(e),n.c(),n.m(t.parentNode,t)):n&&(n.d(1),n=null)},i:h,o:h,d(e){n&&n.d(e),e&&$(t)}}}function Gm(e,t,n){let r,A,i,s,{class:a=""}=t,{id:o=""}=t,{style:c=""}=t,{icon:l}=t,{size:u=""}=t,{color:h=""}=t,{fw:d=!1}=t,{pull:f=""}=t,{scale:p=1}=t,{translateX:g=0}=t,{translateY:m=0}=t,{rotate:y=""}=t,{flip:w=!1}=t,{spin:v=!1}=t,{pulse:B=!1}=t,{primaryColor:b=""}=t,{secondaryColor:_=""}=t,{primaryOpacity:C=1}=t,{secondaryOpacity:x=.4}=t,{swapOpacity:U=!1}=t;return e.$$set=e=>{"class"in e&&n(11,a=e.class),"id"in e&&n(0,o=e.id),"style"in e&&n(12,c=e.style),"icon"in e&&n(13,l=e.icon),"size"in e&&n(14,u=e.size),"color"in e&&n(1,h=e.color),"fw"in e&&n(15,d=e.fw),"pull"in e&&n(16,f=e.pull),"scale"in e&&n(17,p=e.scale),"translateX"in e&&n(18,g=e.translateX),"translateY"in e&&n(19,m=e.translateY),"rotate"in e&&n(20,y=e.rotate),"flip"in e&&n(21,w=e.flip),"spin"in e&&n(22,v=e.spin),"pulse"in e&&n(23,B=e.pulse),"primaryColor"in e&&n(2,b=e.primaryColor),"secondaryColor"in e&&n(3,_=e.secondaryColor),"primaryOpacity"in e&&n(4,C=e.primaryOpacity),"secondaryOpacity"in e&&n(5,x=e.secondaryOpacity),"swapOpacity"in e&&n(6,U=e.swapOpacity)},e.$$.update=()=>{8192&e.$$.dirty&&n(7,r=l&&l.icon||[0,0,"",[],""]),12584960&e.$$.dirty&&n(8,A=Rm([a,"svelte-fa",v&&"spin",B&&"pulse"]," ")),118784&e.$$.dirty&&n(9,i=function(e,t,n,r){let A,i,s,a,o,c="-.125em";return r&&(o="center",i="1.25em"),n&&(A=n),t&&("lg"==t?(a="1.33333em",s=".75em",c="-.225em"):a="xs"==t?".75em":"sm"==t?".875em":t.replace("x","em")),Rm([Rm({float:A,width:i,height:"1em","line-height":s,"font-size":a,"text-align":o,"vertical-align":c,"transform-origin":"center",overflow:"visible"}),e])}(c,u,f,d)),4063232&e.$$.dirty&&n(10,s=function(e,t,n,r,A,i=1,s="",a=""){let o=1,c=1;return A&&("horizontal"==A?o=-1:"vertical"==A?c=-1:o=c=-1),Rm([`translate(${Hm(t)*i}${s},${Hm(n)*i}${s})`,`scale(${o*Hm(e)},${c*Hm(e)})`,r&&`rotate(${r}${a})`]," ")}(p,g,m,y,w,512))},[o,h,b,_,C,x,U,r,A,i,s,a,c,l,u,d,f,p,g,m,y,w,v,B]}const zm=class extends Re{constructor(e){super(),He(this,e,Gm,$m,y,{class:11,id:0,style:12,icon:13,size:14,color:1,fw:15,pull:16,scale:17,translateX:18,translateY:19,rotate:20,flip:21,spin:22,pulse:23,primaryColor:2,secondaryColor:3,primaryOpacity:4,secondaryOpacity:5,swapOpacity:6},Nm)}};function Wm(e,{delay:t=0,duration:n=400,easing:r=d}={}){const A=+getComputedStyle(e).opacity;return{delay:t,duration:n,easing:r,css:e=>"opacity: "+e*A}}var qm,Jm,Ym,Xm,Zm=__webpack_require__(4383);function ey(...e){let t=[];if(0===e.length)return"";if(e.forEach((e=>{if("string"!=typeof e)throw new TypeError(`Url components must be of type string. \n                    The ${e} component is of type ${typeof e}`)})),e[0].match(/^[^/:]+:\/*$/)&&e.length>1){var n=e.shift();e[0]=n+e[0]}e[0].match(/^file:\/\/\//)?e[0]=e[0].replace(/^([^/:]+):\/*/,"$1:///"):e[0]=e[0].replace(/^([^/:]+):\/*/,"$1://"),e.forEach(((n,r)=>{""!==n&&(r>0&&(n=n.replace(/^[\/]+/,"")),n=r<e.length-1?n.replace(/[\/]+$/,""):n.replace(/[\/]+$/,"/"),t.push(n))}));let r=t.join("/");r=r.replace(/\/(\?|&|#[^!])/g,"$1");var A=r.split("?");return r=A.shift()+(A.length>0?"?":"")+A.join("&"),r}(Jm=qm||(qm={}))[Jm.TABULAR=1]="TABULAR",Jm[Jm.IMAGE=2]="IMAGE",Jm[Jm.AUDIO=3]="AUDIO",(Xm=Ym||(Ym={}))[Xm.BINNED_STRING=0]="BINNED_STRING",Xm[Xm.NUMBER=1]="NUMBER";var ty=__webpack_require__(7883);class ny{constructor(){var e;const t=new ty.ContentsManager;this.contentsManager=t,this.baseServerPath=(null===(e=t.serverSettings)||void 0===e?void 0:e.baseUrl)||process.env.JUPYTER_SERVER_ROOT||""}static getInstance(){return this.instance||(this.instance=new ny),this.instance}async save(e,t){try{return await this.contentsManager.save(e,t)}catch(e){throw console.error("Error saving file/directory:",e),e}}async readContent(e){try{const t=await this.contentsManager.get(e);if("string"!=typeof t.content)throw new Error("Unable to read the image");return`data:${t.mimetype};${t.format},${t.content}`}catch(e){throw console.error("Error reading file/directory:",e),e}}async readAudioContent(e){try{const t=await this.contentsManager.get(e);if("string"!=typeof t.content)throw new Error("Unable to read the Audio data");return`${t.content}`}catch(e){throw console.error("Error reading file/directory:",e),e}}getLocalPath(e){const t=this.contentsManager.localPath(e);return this.baseServerPath?`${this.baseServerPath}/${t}`.replace(/\/+/g,"/"):(console.warn("Base server path not available, returning relative path"),t)}getServerPath(e){return this.contentsManager.normalize(e)}resolvePath(e,t){return this.contentsManager.resolvePath(e,t)}}function ry(e){let t,n,r=e[9].message+"";return{c(){t=z("p"),n=q(r),Z(t,"class","error")},m(e,r){j(e,t,r),H(t,n)},p(e,t){8&t&&r!==(r=e[9].message+"")&&ee(n,r)},d(e){e&&$(t)}}}function Ay(e){let t,n,r,A,i,s,a;return{c(){t=z("img"),Z(t,"id","imageSample"),v(t.src,n=e[8])||Z(t,"src",n),Z(t,"alt",r="Image with title: "+e[0]),Z(t,"class",A=e[2]?"mx-1":"w-12 m-1"),Z(t,"style",i="background: black; max-width: "+(e[2]?"256px":"128px"))},m(e,n){j(e,t,n),s||(a=X(t,"error",ay),s=!0)},p(e,s){8&s&&!v(t.src,n=e[8])&&Z(t,"src",n),1&s&&r!==(r="Image with title: "+e[0])&&Z(t,"alt",r),4&s&&A!==(A=e[2]?"mx-1":"w-12 m-1")&&Z(t,"class",A),4&s&&i!==(i="background: black; max-width: "+(e[2]?"256px":"128px"))&&Z(t,"style",i)},d(e){e&&$(t),s=!1,a()}}}function iy(e){let t;return{c(){t=z("p"),t.textContent="Loading...",Z(t,"class","loading")},m(e,n){j(e,t,n)},p:h,d(e){e&&$(t)}}}function sy(e){let t,n,r={ctx:e,current:null,token:null,hasCatch:!0,pending:iy,then:Ay,catch:ry,value:8,error:9};return De(n=e[3],r),{c(){t=z("div"),r.block.c()},m(e,n){j(e,t,n),r.block.m(t,r.anchor=null),r.mount=()=>t,r.anchor=null},p(t,[A]){e=t,r.ctx=e,8&A&&n!==(n=e[3])&&De(n,r)||function(e,t,n){const r=t.slice(),{resolved:A}=e;e.current===e.then&&(r[e.value]=A),e.current===e.catch&&(r[e.error]=A),e.block.p(r,n)}(r,e,A)},i:h,o:h,d(e){e&&$(t),r.block.d(),r.token=null,r=null}}}function ay(e){console.error("Error loading image:",e),e.target.alt="Image failed to load"}function oy(e,t,n){let r,A=h,i=()=>(A(),A=b(a,(e=>n(5,r=e))),a);e.$$.on_destroy.push((()=>A()));let{id:s}=t,{canvasSpec:a}=t;i();let o,{large:c=!1}=t,{storybook:l=!1}=t;const u=ny.getInstance();return e.$$set=e=>{"id"in e&&n(0,s=e.id),"canvasSpec"in e&&i(n(1,a=e.canvasSpec)),"large"in e&&n(2,c=e.large),"storybook"in e&&n(4,l=e.storybook)},e.$$.update=()=>{33&e.$$.dirty&&n(3,o=async function(e,t){if(l)return ey(e,t);try{const n=ey(e,t),r=await u.readContent(n);if("string"!=typeof r)throw new Error("Unexpected content type");return r}catch(e){throw console.error("Error reading image file:",e),new Error(`Failed to load image: ${t}`)}}(r.filesPath,s))},[s,a,c,o,l,r]}const cy=class extends Re{constructor(e){super(),He(this,e,oy,sy,y,{id:0,canvasSpec:1,large:2,storybook:4})}};var ly=__webpack_require__(7290),uy=__webpack_require__.n(ly);const hy=e=>({}),dy=e=>({}),fy=e=>({}),py=e=>({});function gy(e){let t,n,r;const A=e[3].icon,i=C(A,e,e[2],py);return{c(){t=z("div"),i&&i.c(),Z(t,"class",n=e[1].text?"pr-2 flex":"flex")},m(e,n){j(e,t,n),i&&i.m(t,null),r=!0},p(e,s){i&&i.p&&(!r||4&s)&&F(i,A,e,e[2],r?U(A,e[2],s,fy):E(e[2]),py),(!r||2&s&&n!==(n=e[1].text?"pr-2 flex":"flex"))&&Z(t,"class",n)},i(e){r||(Qe(i,e),r=!0)},o(e){Se(i,e),r=!1},d(e){e&&$(t),i&&i.d(e)}}}function my(e){let t,n,r,A,i,s,a,o=e[1].icon&&gy(e);const c=e[3].text,l=C(c,e,e[2],dy);return{c(){t=z("button"),n=z("div"),o&&o.c(),r=J(),l&&l.c(),Z(n,"class","flex items-center"),Z(t,"class",A=(e[0]?"bg-button hover:bg-button_hover text-text-dark":"bg-white text-button border border-button hover:bg-button hover:text-white")+" rounded-md py-1 px-2 transition")},m(A,c){j(A,t,c),H(t,n),o&&o.m(n,null),H(n,r),l&&l.m(n,null),i=!0,s||(a=[X(t,"click",e[4]),X(t,"mouseleave",e[5])],s=!0)},p(e,[s]){e[1].icon?o?(o.p(e,s),2&s&&Qe(o,1)):(o=gy(e),o.c(),Qe(o,1),o.m(n,r)):o&&(Fe(),Se(o,1,1,(()=>{o=null})),Ee()),l&&l.p&&(!i||4&s)&&F(l,c,e,e[2],i?U(c,e[2],s,hy):E(e[2]),dy),(!i||1&s&&A!==(A=(e[0]?"bg-button hover:bg-button_hover text-text-dark":"bg-white text-button border border-button hover:bg-button hover:text-white")+" rounded-md py-1 px-2 transition"))&&Z(t,"class",A)},i(e){i||(Qe(o),Qe(l,e),i=!0)},o(e){Se(o),Se(l,e),i=!1},d(e){e&&$(t),o&&o.d(),l&&l.d(e),s=!1,g(a)}}}function yy(e,t,n){let{$$slots:r={},$$scope:A}=t;const i=function(e){const t={};for(const n in e)t[n]=!0;return t}(r);let{filled:s=!1}=t;return e.$$set=e=>{"filled"in e&&n(0,s=e.filled),"$$scope"in e&&n(2,A=e.$$scope)},[s,i,A,r,function(t){le.call(this,e,t)},function(t){le.call(this,e,t)}]}const wy=class extends Re{constructor(e){super(),He(this,e,yy,my,y,{filled:0})}};var vy=__webpack_require__(3852),By=__webpack_require__(2162);function by(e){let t,n;return t=new zm({props:{icon:e[3]?By.G1:vy.ij,slot:"icon"}}),{c(){Oe(t.$$.fragment)},m(e,r){Le(t,e,r),n=!0},p(e,n){const r={};8&n&&(r.icon=e[3]?By.G1:vy.ij),t.$set(r)},i(e){n||(Qe(t.$$.fragment,e),n=!0)},o(e){Se(t.$$.fragment,e),n=!1},d(e){Pe(t,e)}}}function _y(e){let t,n,r,A,i,s,a,o,c;return i=new wy({props:{$$slots:{icon:[by]},$$scope:{ctx:e}}}),i.$on("click",e[4]),{c(){t=z("div"),n=z("div"),r=J(),A=z("div"),Oe(i.$$.fragment),Z(t,"class",s="flex flex-col "+(e[1]?"w-48 mx-1":"w-24 m-1"))},m(s,l){j(s,t,l),H(t,n),e[11](n),H(t,r),H(t,A),Le(i,A,null),a=!0,o||(c=X(n,"click",e[10]),o=!0)},p(e,[n]){const r={};8200&n&&(r.$$scope={dirty:n,ctx:e}),i.$set(r),(!a||2&n&&s!==(s="flex flex-col "+(e[1]?"w-48 mx-1":"w-24 m-1")))&&Z(t,"class",s)},i(e){a||(Qe(i.$$.fragment,e),a=!0)},o(e){Se(i.$$.fragment,e),a=!1},d(n){n&&$(t),e[11](null),Pe(i),o=!1,c()}}}function Cy(e,t,n){let r,A=h,i=()=>(A(),A=b(a,(e=>n(9,r=e))),a);e.$$.on_destroy.push((()=>A()));let{id:s}=t,{canvasSpec:a}=t;i();let{large:o=!1}=t,{storybook:c=!1}=t;const l=ny.getInstance();let u,d,f=!1,p="";var g;return g=()=>{d&&d.destroy()},ce().$$.on_destroy.push(g),e.$$set=e=>{"id"in e&&n(5,s=e.id),"canvasSpec"in e&&i(n(0,a=e.canvasSpec)),"large"in e&&n(1,o=e.large),"storybook"in e&&n(6,c=e.storybook)},e.$$.update=()=>{if(996&e.$$.dirty&&void 0!==u&&s!==p){void 0!==d&&d.destroy(),n(2,u.innerHTML="",u),n(7,d=uy().create({container:u,waveColor:"#cfcfcf",progressColor:"#0071e3"}));const e=ey(r.filesPath,s);c?d.load(e):l.readAudioContent(e).then((e=>{const t=function(e){try{const t=e.trim(),n=atob(t),r=new Uint8Array(n.length);for(let e=0;e<n.length;e++)r[e]=n.charCodeAt(e);return r.buffer}catch(t){throw console.error("Failed to decode base64 string:",t),console.log("Problematic base64 string:",e),t}}(e);d.loadArrayBuffer(t)})).catch((e=>{console.error("Unable to load the audio data",e)})),n(3,f=!1),n(8,p=s)}},[a,o,u,f,function(){f?(d.pause(),n(3,f=!1)):(d.play(),n(3,f=!0))},s,c,d,p,r,function(t){le.call(this,e,t)},function(e){he[e?"unshift":"push"]((()=>{u=e,n(2,u),n(5,s),n(8,p),n(7,d),n(9,r),n(6,c)}))}]}const xy=class extends Re{constructor(e){super(),He(this,e,Cy,_y,y,{id:5,canvasSpec:0,large:1,storybook:6})}};var Uy=__webpack_require__(7184);function Fy(e){let t,n,r,A,i;return n=new zm({props:{icon:Uy.w9}}),{c(){t=z("div"),Oe(n.$$.fragment),Z(t,"class","p-2")},m(s,a){j(s,t,a),Le(n,t,null),r=!0,A||(i=X(t,"click",e[1]),A=!0)},p:h,i(e){r||(Qe(n.$$.fragment,e),r=!0)},o(e){Se(n.$$.fragment,e),r=!1},d(e){e&&$(t),Pe(n),A=!1,i()}}}function Ey(e,t,n){let{storybook:r=!1}=t;return e.$$set=e=>{"storybook"in e&&n(0,r=e.storybook)},[r,function(t){le.call(this,e,t)}]}const Qy=class extends Re{constructor(e){super(),He(this,e,Ey,Fy,y,{storybook:0})}};function Sy(e){switch(e){case qm.AUDIO:return xy;case qm.IMAGE:return cy;default:return Qy}}function Iy(e,t,n){const r=e.slice();return r[15]=t[n][0],r[16]=t[n][1],r}function ky(e){let t,n,r,A,i,s,a,o,c,l,u,h,d=e[7].instance[e[9].idColumn]+"";var f=Sy(e[9].dataType);function p(e){return{props:{id:e[7].instance[e[9].idColumn],canvasSpec:e[0],storybook:e[2],large:!0}}}f&&(r=re(f,p(e)));let g=void 0!==e[7].number&&Dy(e),m=Object.entries(e[7].instance),y=[];for(let t=0;t<m.length;t+=1)y[t]=Ty(Iy(e,m,t));return{c(){t=z("div"),n=z("div"),r&&Oe(r.$$.fragment),A=J(),i=z("div"),s=z("div"),a=q(d),o=J(),g&&g.c(),c=J();for(let e=0;e<y.length;e+=1)y[e].c();Z(n,"class","flex flex-shrink-0"),Z(s,"class","flex font-bold"),Z(i,"class","flex flex-col pl-2 pr-4 m-2 mt-0 break-all"),Z(t,"class","text-sm fixed p-1 rounded text-text-dark shadow z-10 flex mt-4 mb-4"),Z(t,"style",e[8]),me((()=>e[14].call(t)))},m(u,d){j(u,t,d),H(t,n),r&&Le(r,n,null),H(t,A),H(t,i),H(i,s),H(s,a),H(i,o),g&&g.m(i,null),H(i,c);for(let e=0;e<y.length;e+=1)y[e]&&y[e].m(i,null);l=function(e,t){"static"===getComputedStyle(e).position&&(e.style.position="relative");const n=z("iframe");n.setAttribute("style","display: block; position: absolute; top: 0; left: 0; width: 100%; height: 100%; overflow: hidden; border: 0; opacity: 0; pointer-events: none; z-index: -1;"),n.setAttribute("aria-hidden","true"),n.tabIndex=-1;const r=function(){if(void 0===L){L=!1;try{"undefined"!=typeof window&&window.parent&&window.parent.document}catch(e){L=!0}}return L}();let A;return r?(n.src="data:text/html,<script>onresize=function(){parent.postMessage(0,'*')}<\/script>",A=X(window,"message",(e=>{e.source===n.contentWindow&&t()}))):(n.src="about:blank",n.onload=()=>{A=X(n.contentWindow,"resize",t),t()}),H(e,n),()=>{(r||A&&n.contentWindow)&&A(),$(n)}}(t,e[14].bind(t)),h=!0},p(e,A){const s={};if(640&A&&(s.id=e[7].instance[e[9].idColumn]),1&A&&(s.canvasSpec=e[0]),4&A&&(s.storybook=e[2]),512&A&&f!==(f=Sy(e[9].dataType))){if(r){Fe();const e=r;Se(e.$$.fragment,1,0,(()=>{Pe(e,1)})),Ee()}f?(r=re(f,p(e)),Oe(r.$$.fragment),Qe(r.$$.fragment,1),Le(r,n,null)):r=null}else f&&r.$set(s);if((!h||640&A)&&d!==(d=e[7].instance[e[9].idColumn]+"")&&ee(a,d),void 0!==e[7].number?g?(g.p(e,A),128&A&&Qe(g,1)):(g=Dy(e),g.c(),Qe(g,1),g.m(i,c)):g&&(Fe(),Se(g,1,1,(()=>{g=null})),Ee()),1664&A){let t;for(m=Object.entries(e[7].instance),t=0;t<m.length;t+=1){const n=Iy(e,m,t);y[t]?y[t].p(n,A):(y[t]=Ty(n),y[t].c(),y[t].m(i,null))}for(;t<y.length;t+=1)y[t].d(1);y.length=m.length}(!h||256&A)&&Z(t,"style",e[8])},i(e){h||(r&&Qe(r.$$.fragment,e),Qe(g),me((()=>{h&&(u||(u=ke(t,Wm,{},!0)),u.run(1))})),h=!0)},o(e){r&&Se(r.$$.fragment,e),Se(g),u||(u=ke(t,Wm,{},!1)),u.run(0),h=!1},d(e){e&&$(t),r&&Pe(r),g&&g.d(),G(y,e),l(),e&&u&&u.end()}}}function Dy(e){let t,n,r,A,i,s,a=e[7].number+"";return n=new zm({props:{icon:Zm.$F}}),{c(){t=z("div"),Oe(n.$$.fragment),r=J(),A=z("span"),i=q(a),Z(A,"class","ml-2"),Z(t,"class","flex flex-nowrap")},m(e,a){j(e,t,a),Le(n,t,null),H(t,r),H(t,A),H(A,i),s=!0},p(e,t){(!s||128&t)&&a!==(a=e[7].number+"")&&ee(i,a)},i(e){s||(Qe(n.$$.fragment,e),s=!0)},o(e){Se(n.$$.fragment,e),s=!1},d(e){e&&$(t),Pe(n)}}}function My(e){let t,n,r,A,i,s,a,o,c=e[15]+"",l=e[10](e[16])+"";return{c(){t=z("div"),n=z("span"),r=q(c),A=q(":"),i=J(),s=z("span"),a=q(l),o=J(),Z(n,"class","font-bold"),Z(s,"class","ml-2"),Z(t,"class","flex flex-nowrap")},m(e,c){j(e,t,c),H(t,n),H(n,r),H(n,A),H(t,i),H(t,s),H(s,a),H(t,o)},p(e,t){128&t&&c!==(c=e[15]+"")&&ee(r,c),128&t&&l!==(l=e[10](e[16])+"")&&ee(a,l)},d(e){e&&$(t)}}}function Ty(e){let t,n=!(e[15]===e[9].idColumn||e[15].startsWith("familiarity_")||e[15].startsWith("duplicates_")||e[15].startsWith("projection_")||e[15].startsWith("splitFamiliarity")),r=n&&My(e);return{c(){r&&r.c(),t=Y()},m(e,n){r&&r.m(e,n),j(e,t,n)},p(e,A){640&A&&(n=!(e[15]===e[9].idColumn||e[15].startsWith("familiarity_")||e[15].startsWith("duplicates_")||e[15].startsWith("projection_")||e[15].startsWith("splitFamiliarity"))),n?r?r.p(e,A):(r=My(e),r.c(),r.m(t.parentNode,t)):r&&(r.d(1),r=null)},d(e){r&&r.d(e),e&&$(t)}}}function Oy(e){let t,n,r,A;me(e[13]);let i=e[7].hover&&void 0!==e[7].instance&&ky(e);return{c(){i&&i.c(),t=Y()},m(s,a){i&&i.m(s,a),j(s,t,a),n=!0,r||(A=X(window,"resize",e[13]),r=!0)},p(e,[n]){e[7].hover&&void 0!==e[7].instance?i?(i.p(e,n),128&n&&Qe(i,1)):(i=ky(e),i.c(),Qe(i,1),i.m(t.parentNode,t)):i&&(Fe(),Se(i,1,1,(()=>{i=null})),Ee())},i(e){n||(Qe(i),n=!0)},o(e){Se(i),n=!1},d(e){i&&i.d(e),e&&$(t),r=!1,A()}}}function Ly(e,t,n){let r,A,i,s,a,o=h,c=()=>(o(),o=b(f,(e=>n(7,s=e))),f),l=h,u=()=>(l(),l=b(d,(e=>n(9,a=e))),d);e.$$.on_destroy.push((()=>o())),e.$$.on_destroy.push((()=>l()));let{canvasSpec:d}=t;u();let{tooltip:f}=t;c();let{storybook:p=!1}=t,g=0,m=0,y=0,w=0;return e.$$set=e=>{"canvasSpec"in e&&u(n(0,d=e.canvasSpec)),"tooltip"in e&&c(n(1,f=e.tooltip)),"storybook"in e&&n(2,p=e.storybook)},e.$$.update=()=>{208&e.$$.dirty&&n(12,r=m>s.mousePos.y+w?s.mousePos.y:s.mousePos.y-w-20),168&e.$$.dirty&&n(11,A=g>s.mousePos.x+y+10?`left: ${s.mousePos.x}px;`:"right: 10px;"),6144&e.$$.dirty&&n(8,i=`top: ${r}px; ${A}; background: black`)},[d,f,p,g,m,y,w,s,i,a,e=>Array.isArray(e)?e.toString():"number"==typeof e?e.toFixed(2):e,A,r,function(){n(3,g=window.innerWidth),n(4,m=window.innerHeight)},function(){y=this.offsetWidth,w=this.offsetHeight,n(5,y),n(6,w)}]}const Py=class extends Re{constructor(e){super(),He(this,e,Ly,Oy,y,{canvasSpec:0,tooltip:1,storybook:2})}};function Hy(e){let t;return{c(){t=q("No data to show.")},m(e,n){j(e,t,n)},p:h,i:h,o:h,d(e){e&&$(t)}}}function Ry(e){let t,n,r,A;var i=e[0];function s(e){return{props:{widgetSpec:e[2],selected:Sm,filter:km,groupColumns:Im,groupNames:Lm,canvasSpec:Em,dataTable:Qm,filterError:Dm,tooltip:Mm,table:Tm,filteredTable:Om,groupedTables:Pm,notebook:!0}}}return i&&(n=re(i,s(e)),n.$on("specChanged",e[4])),{c(){t=z("div"),n&&Oe(n.$$.fragment),Z(t,"class",r=("toolbar"===e[2].name?"border-midgrey border-2":"")+" mt-2 h-full"),te(t,"min-height","350px")},m(e,r){j(e,t,r),n&&Le(n,t,null),A=!0},p(e,a){const o={};if(4&a&&(o.widgetSpec=e[2]),1&a&&i!==(i=e[0])){if(n){Fe();const e=n;Se(e.$$.fragment,1,0,(()=>{Pe(e,1)})),Ee()}i?(n=re(i,s(e)),n.$on("specChanged",e[4]),Oe(n.$$.fragment),Qe(n.$$.fragment,1),Le(n,t,null)):n=null}else i&&n.$set(o);(!A||4&a&&r!==(r=("toolbar"===e[2].name?"border-midgrey border-2":"")+" mt-2 h-full"))&&Z(t,"class",r)},i(e){A||(n&&Qe(n.$$.fragment,e),A=!0)},o(e){n&&Se(n.$$.fragment,e),A=!1},d(e){e&&$(t),n&&Pe(n)}}}function Ny(e){let t,n,r,A,i;const s=[Ry,Hy],a=[];function o(e,t){return e[1]&&e[2]?0:1}return t=o(e),n=a[t]=s[t](e),A=new Py({props:{tooltip:Mm,canvasSpec:Em}}),{c(){n.c(),r=J(),Oe(A.$$.fragment)},m(e,n){a[t].m(e,n),j(e,r,n),Le(A,e,n),i=!0},p(e,[A]){let i=t;t=o(e),t===i?a[t].p(e,A):(Fe(),Se(a[i],1,1,(()=>{a[i]=null})),Ee(),n=a[t],n?n.p(e,A):(n=a[t]=s[t](e),n.c()),Qe(n,1),n.m(r.parentNode,r))},i(e){i||(Qe(n),Qe(A.$$.fragment,e),i=!0)},o(e){Se(n),Se(A.$$.fragment,e),i=!1},d(e){a[t].d(e),e&&$(r),Pe(A,e)}}}function Vy(e,t,n){let r,A;_(e,Tm,(e=>n(1,r=e)));let{model:i}=t,{widget:s}=t;!function(e){Sm.setModel(e),km.setModel(e),Im.setModel(e),Em.setModel(e),Qm.setModel(e)}(i);let a=Fm("widget_spec",i.attributes.widget_spec);return _(e,a,(e=>n(2,A=e))),a.setModel(i),e.$$set=e=>{"model"in e&&n(5,i=e.model),"widget"in e&&n(0,s=e.widget)},[s,r,A,a,function(e){a.set(e.detail.spec)},i]}const Ky=class extends Re{constructor(e){super(),He(this,e,Vy,Ny,y,{model:5,widget:0})}},jy=new window.BroadcastChannel("pub-sub-es"),$y=(e,t)=>"string"==typeof e&&t?e.toLowerCase():e,Gy=(e,t)=>(n,r,A=Number.POSITIVE_INFINITY)=>{const i=$y(n,t?.caseInsensitive),s=e[i]||[];return s.push({handler:r,times:+A||Number.POSITIVE_INFINITY}),e[i]=s,{event:i,handler:r}};function zy(e,t){return function(n,r){let A,i;(e=>"object"==typeof e)(n)?(i=n.handler,A=n.event):(A=n,i=r);const s=$y(A,t?.caseInsensitive),a=e[s];if(!a)return;const o=a.findIndex((e=>e.handler===i));-1===o||o>=a.length||a.splice(o,1)}}const Wy=(e,t)=>{const n=zy(e);return(...r)=>{const[A,i,s]=r,a=$y(A,t?.caseInsensitive),o=e[a];if(!(e=>Boolean(e))(o))return;const c=[...o];for(const e of c)--e.times<1&&n(a,e.handler);const l=()=>{for(const e of c)e.handler(i)};if((void 0!==s?.async?s.async:t?.async)?setTimeout(l,0):l(),t?.isGlobal&&!s?.isNoGlobalBroadcast)try{jy.postMessage({event:a,news:i})}catch(e){if(!(e instanceof Error&&"DataCloneError"===e.name))throw e;console.warn(`Could not broadcast '${a.toString()}' globally. Payload is not clonable.`)}}},qy=e=>()=>{for(const n of(t=e,Object.keys(t)))delete e[n];var t},Jy={},Yy={publish:Wy(Jy,{isGlobal:!0}),subscribe:Gy(Jy),unsubscribe:zy(Jy),clear:qy(Jy),stack:Jy};jy.onmessage=({data:{event:e,news:t}})=>Yy.publish(e,t,{isNoGlobalBroadcast:!0});var Xy=__webpack_require__(8643);const Zy=e=>e<.5?4*e*e*e:(e-1)*(2*e-2)*(2*e-2)+1,ew=e=>e,tw=(e,t=e=>e)=>{const n=[];for(let r=0;r<e;r++)n.push(t(r,e));return n},nw=(e,...t)=>(t.forEach((t=>{const n=Object.keys(t).reduce(((e,n)=>(e[n]=Object.getOwnPropertyDescriptor(t,n),e)),{});Object.getOwnPropertySymbols(t).forEach((e=>{const r=Object.getOwnPropertyDescriptor(t,e);r.enumerable&&(n[e]=r)})),Object.defineProperties(e,n)})),e),rw=(e,t)=>n=>nw(n,{get[e](){return t}}),Aw=(e=1)=>new Promise((t=>{let n=0;const r=()=>requestAnimationFrame((()=>{n++,n<e?r():t()}));r()})),iw=(e,t,n=null)=>{let r,A=0;n=null===n?t:n;const i=(...t)=>{clearTimeout(r),r=setTimeout((()=>{A>0&&(e(...t),A=0)}),n)};let s=!1;const a=(...n)=>{s?(A++,i(...n)):(e(...n),i(...n),s=!0,A=0,setTimeout((()=>{s=!1}),t))};return a.reset=()=>{s=!1},a.cancel=()=>{clearTimeout(r)},a.now=(...t)=>e(...t),a};var sw,aw="undefined"!=typeof Float32Array?Float32Array:Array;function ow(){var e=new aw(16);return aw!=Float32Array&&(e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0),e[0]=1,e[5]=1,e[10]=1,e[15]=1,e}function cw(e){var t=new aw(16);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function lw(e,t){var n=t[0],r=t[1],A=t[2],i=t[3],s=t[4],a=t[5],o=t[6],c=t[7],l=t[8],u=t[9],h=t[10],d=t[11],f=t[12],p=t[13],g=t[14],m=t[15],y=n*a-r*s,w=n*o-A*s,v=n*c-i*s,B=r*o-A*a,b=r*c-i*a,_=A*c-i*o,C=l*p-u*f,x=l*g-h*f,U=l*m-d*f,F=u*g-h*p,E=u*m-d*p,Q=h*m-d*g,S=y*Q-w*E+v*F+B*U-b*x+_*C;return S?(S=1/S,e[0]=(a*Q-o*E+c*F)*S,e[1]=(A*E-r*Q-i*F)*S,e[2]=(p*_-g*b+m*B)*S,e[3]=(h*b-u*_-d*B)*S,e[4]=(o*U-s*Q-c*x)*S,e[5]=(n*Q-A*U+i*x)*S,e[6]=(g*v-f*_-m*w)*S,e[7]=(l*_-h*v+d*w)*S,e[8]=(s*E-a*U+c*C)*S,e[9]=(r*U-n*E-i*C)*S,e[10]=(f*b-p*v+m*y)*S,e[11]=(u*v-l*b-d*y)*S,e[12]=(a*x-s*F-o*C)*S,e[13]=(n*F-r*x+A*C)*S,e[14]=(p*w-f*B-g*y)*S,e[15]=(l*B-u*w+h*y)*S,e):null}function uw(e,t,n){var r=t[0],A=t[1],i=t[2],s=t[3],a=t[4],o=t[5],c=t[6],l=t[7],u=t[8],h=t[9],d=t[10],f=t[11],p=t[12],g=t[13],m=t[14],y=t[15],w=n[0],v=n[1],B=n[2],b=n[3];return e[0]=w*r+v*a+B*u+b*p,e[1]=w*A+v*o+B*h+b*g,e[2]=w*i+v*c+B*d+b*m,e[3]=w*s+v*l+B*f+b*y,w=n[4],v=n[5],B=n[6],b=n[7],e[4]=w*r+v*a+B*u+b*p,e[5]=w*A+v*o+B*h+b*g,e[6]=w*i+v*c+B*d+b*m,e[7]=w*s+v*l+B*f+b*y,w=n[8],v=n[9],B=n[10],b=n[11],e[8]=w*r+v*a+B*u+b*p,e[9]=w*A+v*o+B*h+b*g,e[10]=w*i+v*c+B*d+b*m,e[11]=w*s+v*l+B*f+b*y,w=n[12],v=n[13],B=n[14],b=n[15],e[12]=w*r+v*a+B*u+b*p,e[13]=w*A+v*o+B*h+b*g,e[14]=w*i+v*c+B*d+b*m,e[15]=w*s+v*l+B*f+b*y,e}function hw(e,t){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=t[0],e[13]=t[1],e[14]=t[2],e[15]=1,e}function dw(e,t){return e[0]=t[0],e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t[1],e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t[2],e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e}function fw(e,t,n){var r=t[0],A=t[1],i=t[2],s=t[3];return e[0]=n[0]*r+n[4]*A+n[8]*i+n[12]*s,e[1]=n[1]*r+n[5]*A+n[9]*i+n[13]*s,e[2]=n[2]*r+n[6]*A+n[10]*i+n[14]*s,e[3]=n[3]*r+n[7]*A+n[11]*i+n[15]*s,e}Math.hypot||(Math.hypot=function(){for(var e=0,t=arguments.length;t--;)e+=arguments[t]*arguments[t];return Math.sqrt(e)}),sw=new aw(4),aw!=Float32Array&&(sw[0]=0,sw[1]=0,sw[2]=0,sw[3]=0),function(){var e=new aw(2);aw!=Float32Array&&(e[0]=0,e[1]=0)}();const pw=["pan","rotate"],gw={alt:"altKey",cmd:"metaKey",ctrl:"ctrlKey",meta:"metaKey",shift:"shiftKey"},mw=(e,{distance:t=1,target:n=[0,0],rotation:r=0,isNdc:A=!0,isFixed:i=!1,isPan:s=!0,isPanInverted:a=[!1,!0],panSpeed:o=1,isRotate:c=!0,rotateSpeed:l=1,defaultMouseDownMoveAction:u="pan",mouseDownMoveModKey:h="alt",isZoom:d=!0,zoomSpeed:f=1,viewCenter:p,scaleBounds:g,translationBounds:m,onKeyDown:y=()=>{},onKeyUp:w=()=>{},onMouseDown:v=()=>{},onMouseUp:B=()=>{},onMouseMove:b=()=>{},onWheel:_=()=>{}}={})=>{let C=((e=[0,0],t=1,n=0,r=[0,0],A=[[0