---
name: Bug report
about: Create a report to help us improve
title: '[BUG] '
labels: ['bug']
assignees: ''

---

**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Steps to reproduce the behavior:
1. Go to '...'
2. Click on '....'
3. Scroll down to '....'
4. See error

**Expected behavior**
A clear and concise description of what you expected to happen.

**Code Sample**
```python
# Minimal code sample that reproduces the issue
from cardinity import Cardinity

sdk = Cardinity('consumer_key', 'consumer_secret')
# ... rest of the code that causes the issue
```

**Error Message/Stack Trace**
```
Paste the full error message and stack trace here
```

**Environment (please complete the following information):**
- OS: [e.g. macOS 12.0, Ubuntu 20.04, Windows 10]
- Python version: [e.g. 3.9.7]
- cardinity-python version: [e.g. 1.0.0]
- Installation method: [e.g. pip, uv, poetry]

**Additional context**
Add any other context about the problem here.

**Checklist**
- [ ] I have searched for similar issues before creating this one
- [ ] I have provided all the required information above
- [ ] I have tested with the latest version of cardinity-python
- [ ] I have included a minimal code sample that reproduces the issue 
