---
name: Feature request
about: Suggest an idea for this project
title: '[FEATURE] '
labels: ['enhancement']
assignees: ''

---

**Is your feature request related to a problem? Please describe.**
A clear and concise description of what the problem is. Ex. I'm always frustrated when [...]

**Describe the solution you'd like**
A clear and concise description of what you want to happen.

**Describe alternatives you've considered**
A clear and concise description of any alternative solutions or features you've considered.

**Use Case**
Describe the specific use case or scenario where this feature would be beneficial.

**API Design (if applicable)**
```python
# Example of how you envision the new API would work
from cardinity import Cardinity

sdk = Cardinity('consumer_key', 'consumer_secret')
result = sdk.new_feature(param1='value1', param2='value2')
```

**Additional context**
Add any other context or screenshots about the feature request here.

**Compatibility Considerations**
- [ ] This feature should be backward compatible
- [ ] This feature may introduce breaking changes (please explain why necessary)
- [ ] This feature should be optional/configurable

**Checklist**
- [ ] I have searched for similar feature requests before creating this one
- [ ] I have considered how this feature would fit with the existing API
- [ ] I have provided clear use cases for this feature 
