## Description

Please include a summary of the changes and the related issue. Please also include relevant motivation and context.

Fixes # (issue)

## Type of change

Please delete options that are not relevant.

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)  
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] This change requires a documentation update

## Changes Made

Please describe the changes made in this PR.

- 
- 
- 

## Testing

Please describe the tests that you ran to verify your changes. Provide instructions so we can reproduce.

- [ ] Unit tests pass locally (`uv run pytest`)
- [ ] Linting passes (`uv run ruff check .`)
- [ ] Formatting passes (`uv run ruff format --check .`)
- [ ] Type checking passes (`uv run mypy cardinity/`)
- [ ] Integration tests pass (if applicable)
- [ ] Manual testing performed (describe below)

**Manual Testing Details:**
```
Describe any manual testing you performed
```

## Code Quality

- [ ] My code follows the style guidelines of this project
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes

## Documentation

- [ ] I have updated the README.md if needed
- [ ] I have updated the API documentation if needed
- [ ] I have updated the CHANGELOG.md if needed
- [ ] I have added/updated examples if needed

## Security

- [ ] I have not introduced any security vulnerabilities
- [ ] I have not exposed any sensitive information
- [ ] I have validated all user inputs appropriately
- [ ] I have considered potential security implications

## Performance

- [ ] I have considered the performance impact of my changes
- [ ] I have added performance tests if needed
- [ ] My changes do not significantly degrade performance

## Backward Compatibility

- [ ] My changes are backward compatible
- [ ] If breaking changes are introduced, I have documented them clearly

## Additional Notes

Add any other notes about the PR here. 
