# CARP PYTHON CLIENT API

![CACHET](cachet.png)

##
The Copenhagen Center for Health Technology (CACHET) Research Platform (CARP) enables researchers to run mobile health (mHealth) studies where data is collected on participant's smartphones and wearable devices. Data is securely uploaded and managed in a hosting infrastructure managed by the Technical University of Denmark.

CARP is a platform for running research studies in the health domain – also known as Digital Phenotyping. Such studies range from technical feasibility studies of novel technology to large-scale clinical studies. The platform is very versatile both in terms of support for different types of health domains, as well as in terms of technical support and configuration.

CARP PYTHON CLIENT API - ASYNC
-----------------
To support researchers using the [CARP Webservices API](https://carp.cachet.dk) with the Python programming language, we implemented a [CARP PYTHON CLIENT API - ASYNC](https://pypi.org/project/carp-python-api-async/) to consume all existing endpoints such as authenticating, creating studies, deployments, protocols, consents, data points, documents|collections, summaries, and other endpoints.

Note
-----------------
To use this client with any of the CARP environments listed below, [contact us](https://carp.cachet.dk/#contact) to create a researcher account to use the [CARP Web Services] endpoints.

Environments 
-----------------

|CARP Environments      | Path |
| :------------  |:------------ |
| **test** | https://cans.cachet.dk:443/test |
| **development** | https://cans.cachet.dk:443/dev |
| **staging** | https://cans.cachet.dk:443/stage |
| **production**| https://cans.cachet.dk:443 |
 
|Local Environment      | Path |
| :------------  |:------------ |
| **local** | http://localhost:8091 |

References
-----------------
- Copenhagen Center for Health Technology [CACHET](https://cachet.dk)
- [CARP Webpage](https://carp.cachet.dk).
- [CANS Management Dashboard](https://cans.cachet.dk).
- [CARP Core](https://carp.cachet.dk/core/)

