"""Tools for VASP input and output"""
from casm.vasp.io.io import \
    VASP_INPUT_FILE_LIST,\
    DEFAULT_VASP_MOVE_LIST,\
    DEFAULT_VASP_COPY_LIST,\
    DEFAULT_VASP_REMOVE_LIST,\
    VaspIOError,\
    job_complete,\
    get_incar_tag,\
    set_incar_tag,\
    ionic_steps,\
    write_potcar,\
    write_stopcar,\
    write_vasp_input
from casm.vasp.io.incar import \
    VASP_TAG_INT_LIST,\
    VASP_TAG_FLOAT_LIST,\
    VASP_TAG_BOOL_LIST,\
    VASP_TAG_SITEF_LIST,\
    VASP_TAG_SPECF_LIST,\
    VASP_TAG_SPECI_LIST,\
    VASP_TAG_STRING_LIST,\
    VASP_TAG_LIST,\
    IncarError,\
    Incar
from casm.vasp.io.kpoints import KpointsError, Kpoints
from casm.vasp.io.outcar import OutcarError, Outcar
from casm.vasp.io.oszicar import OszicarError, Oszicar
from casm.vasp.io.poscar import Site, PoscarError, Poscar
from casm.vasp.io.species import SpeciesError, SpeciesDict, IndividualSpecies,\
    species_settings, write_species_settings
from casm.vasp.io.vaspio import VaspIO
from casm.vasp.io.vasprun import VasprunError, Vasprun
from casm.vasp.io.orbital_occupation import OrbitalOccupationError, OrbitalOccupation, write_occupations
from casm.vasp.io.attribute_classes import CmagspinAttr
__all__ = [
    'VASP_INPUT_FILE_LIST', 'DEFAULT_VASP_MOVE_LIST', 'DEFAULT_VASP_COPY_LIST',
    'DEFAULT_VASP_REMOVE_LIST', 'VaspIOError', 'job_complete', 'get_incar_tag',
    'set_incar_tag', 'ionic_steps', 'write_potcar', 'write_stopcar',
    'write_vasp_input', 'VASP_TAG_INT_LIST', 'VASP_TAG_FLOAT_LIST',
    'VASP_TAG_BOOL_LIST', 'VASP_TAG_SITEF_LIST', 'VASP_TAG_SPECF_LIST',
    'VASP_TAG_SPECI_LIST', 'VASP_TAG_STRING_LIST', 'VASP_TAG_LIST',
    'IncarError', 'Incar', 'KpointsError', 'Kpoints', 'OutcarError', 'Outcar',
    'OszicarError', 'Oszicar', 'Site', 'PoscarError', 'Poscar', 'SpeciesError',
    'SpeciesDict', 'IndividualSpecies', 'species_settings',
    'write_species_settings', 'VaspIO', 'VasprunError', 'Vasprun',
    'OrbitalOccupationError', 'OrbitalOccupation', 'write_occupations',
    'CmagspinAttr'
]
