# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Literal, Optional
from uuid import UUID

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, RootModel, constr

from .. import GlobalObjectReference
from ..ListMeta import ListMeta


class ApiVersion(Enum):
    pim_v1 = 'pim/v1'


class Kind(Enum):
    integration = 'Integration'


class Usage(RootModel[AnyUrl]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: AnyUrl = Field(
        ...,
        description='crn that specifies the resource using this integration',
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-456xy/cloud-cluster=lkc-123abc/connector=my_datagen_connector'
        ],
    )


class AwsIntegrationConfig(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    iam_role_arn: Optional[constr(min_length=20, max_length=2048)] = Field(
        None,
        description='Amazon Resource Name (ARN) that identifies the Amazon Web Services (AWS)\nIdentity and Access Management (IAM) role that Confluent Cloud uses to assume\ncustomer IAM role when it accesses resources in your AWS account.\n',
        examples=['arn:aws:iam::000000000000:role/my-test-aws-role'],
    )
    external_id: Optional[UUID] = Field(
        None,
        description='Unique external ID that Confluent Cloud uses when it assumes the IAM role\nin your Amazon Web Services (AWS) account.\n',
    )
    customer_iam_role_arn: Optional[constr(min_length=20, max_length=2048)] = Field(
        None,
        description='Amazon Resource Name (ARN) that identifies the Amazon Web Services (AWS)\nIdentity and Access Management (IAM) role that Confluent Cloud assumes when\nit accesses resources in your AWS account.\n',
        examples=['arn:aws:iam::000000000000:role/my-test-aws-role'],
    )
    kind: Literal['AwsIntegrationConfig'] = Field(
        ...,
        description='Cloud provider specific config to which access is provided through provider integration.',
        examples=['AwsIntegrationConfig'],
    )


class Kind1Model(Enum):
    integration_list = 'IntegrationList'


class Metadata(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/pim/v1/integrations']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/pim/v1/integrations?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/pim/v1/integrations?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/pim/v1/integrations?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Integration(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    display_name: Optional[constr(max_length=60)] = Field(
        None,
        description='Display name of Provider Integration.',
        examples=['s3_provider_integration'],
    )
    provider: Optional[str] = Field(
        'AWS',
        description='Cloud provider to which access is provided through provider integration.',
        examples=['AWS'],
    )
    config: Optional[AwsIntegrationConfig] = Field(
        None,
        description='Cloud provider specific configs for provider integration',
        discriminator='kind',
    )
    usages: Optional[List[Usage]] = Field(
        None,
        description='List of resource crns where this integration is being used.',
        min_length=0,
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class IntegrationList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata
    data: List[Integration] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
