# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Literal, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, constr

from ..ListMeta import ListMeta
from ..ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    byok_v1 = 'byok/v1'


class Kind(Enum):
    key = 'Key'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/byok/v1/keys/cck-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/key=cck-12345'
        ],
    )


class Kind1Model(Enum):
    aws_key = 'AwsKey'


class AwsKey(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    key_arn: str = Field(
        ...,
        description='The Amazon Resource Name (ARN) of an AWS KMS key.\n',
        examples=[
            'arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab'
        ],
    )
    roles: Optional[List[str]] = Field(
        None,
        description='The Amazon Resource Names (ARNs) of IAM Roles created for this key-environment combination.\n',
        examples=[
            [
                'arn:aws:iam::123456789876:role/block_storage_manager',
                'arn:aws:iam::987654321234:role/cc-kafka-1111aaaa-11aa-11aa-11aa-111111aaaaaa',
            ]
        ],
    )
    kind: Literal['AwsKey'] = Field(..., description='BYOK kind type.\n')


class Kind1Model1(Enum):
    azure_key = 'AzureKey'


class AzureKey(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    application_id: Optional[str] = Field(
        None,
        description='The Application ID created for this key-environment combination.\n',
    )
    key_id: str = Field(
        ...,
        description='The unique Key Object Identifier URL without version of an Azure Key Vault key.\n',
        examples=['https://vault-name.vault.azure.net/keys/key-name'],
    )
    key_vault_id: str = Field(
        ...,
        description='Key Vault ID containing the key\n',
        examples=[
            '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup-name/providers/Microsoft.KeyVault/vaults/vault-name'
        ],
    )
    kind: Literal['AzureKey'] = Field(..., description='BYOK kind type.\n')
    tenant_id: str = Field(
        ...,
        description='Tenant ID (uuid) hosting the Key Vault containing the key\n',
        examples=['00000000-0000-0000-0000-000000000000'],
    )


class Kind1Model2(Enum):
    gcp_key = 'GcpKey'


class GcpKey(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    key_id: str = Field(
        ...,
        description='The Google Cloud Platform key ID.\n',
        examples=[
            'projects/exampleproject/locations/us-central1/keyRings/testkeyring/cryptoKeys/testbyokkey/cryptoKeyVersions/3'
        ],
    )
    security_group: Optional[str] = Field(
        None,
        description='The Google security group created for this key.\n',
        examples=['testgroupid@domain.com'],
    )
    kind: Literal['GcpKey'] = Field(..., description='BYOK kind type.\n')


class Kind1Model3(Enum):
    key_list = 'KeyList'


class Metadata1Model(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/byok/v1/keys']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/byok/v1/keys?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/byok/v1/keys?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/byok/v1/keys?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Key(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    key: Optional[Union[AwsKey, AzureKey, GcpKey]] = Field(
        None,
        description='The cloud-specific key details.\n\nFor AWS, provide the corresponding `key_arn`.\n\nFor Azure, provide the corresponding `key_id`.\n\nFor GCP, provide the corresponding `key_id`.\n',
        discriminator='kind',
    )
    provider: Optional[str] = Field(
        None, description='The cloud provider of the Key.', examples=['AWS']
    )
    state: Optional[str] = Field(
        None,
        description='The state of the key:\n  AVAILABLE: key can be used for a Kafka cluster provisioning\n  IN_USE: key is already in use by a Kafka cluster provisioning\n',
        examples=['IN_USE'],
    )


class KeyList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model3 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model
    data: List[Key] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
