# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Literal, Optional

from pydantic import BaseModel, ConfigDict, Field, constr

from ...ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    artifact_v1_upload_source = 'artifact.v1/UploadSource'


class Kind(Enum):
    presigned_url = 'PresignedUrl'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/artifact.v1/UploadSource/presigned-urls/pu-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/presigned-url=pu-12345'
        ],
    )


class PresignedUrl(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    location: Literal['PRESIGNED_URL_LOCATION'] = Field(
        ...,
        description='Location of the Flink Artifact source.\n',
        examples=['PRESIGNED_URL_LOCATION'],
    )
    upload_id: Optional[str] = Field(
        None,
        description='Upload ID returned by the `/presigned-upload-url` API. This field returns an empty string in all responses.',
        examples=['e53bb2e8-8de3-49fa-9fb1-4e3fd9a16b66'],
    )
