# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, constr

from ...ListMeta import ListMeta
from ...ObjectMeta import ObjectMeta
from .. import UploadSource


class ApiVersion(Enum):
    artifact_v1 = 'artifact/v1'


class Kind(Enum):
    flink_artifact = 'FlinkArtifact'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/artifact/v1/flink-artifacts/fa-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/flink-artifact=fa-12345'
        ],
    )


class Kind1Model(Enum):
    presigned_url = 'PresignedUrl'


class PresignedUrl(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    content_format: Optional[str] = Field(
        None,
        description='Content format of the Flink Artifact archive.',
        examples=['JAR'],
    )
    cloud: Optional[str] = Field(
        None,
        description='Cloud provider where the Flink Artifact archive is uploaded.',
        examples=['AWS'],
    )
    region: Optional[str] = Field(
        None,
        description='The Cloud provider region the Flink Artifact archive is uploaded.',
        examples=['us-east-1'],
    )
    environment: Optional[str] = Field(
        None,
        description='The Environment the uploaded Flink Artifact belongs to.',
        examples=['env-00000'],
    )
    upload_id: Optional[str] = Field(
        None,
        description='Unique identifier of this upload.',
        examples=['e53bb2e8-8de3-49fa-9fb1-4e3fd9a16b66'],
    )
    upload_url: Optional[AnyUrl] = Field(
        None,
        description='Upload URL for the Flink Artifact archive.',
        examples=[
            'https://confluent-flink-artifacts-stag-us-west-2.s3.dualstack.us-west-2.amazonaws.com/'
        ],
    )
    upload_form_data: Optional[Dict[str, Any]] = Field(
        None,
        description='Upload form data of the Flink Artifact. All values should be strings.',
        examples=[
            {
                'bucket': 'confluent-flink-artifacts-stag-us-west-2',
                'key': 'staging/flink-artifact/2f37f0b6-f8da-4e8b-bc5f-282ebb0511be/flink-e53bb2e8-8de3-49fa-9fb1-4e3fd9a16b66/artifact.jar',
                'policy': 'string',
                'x-amz-algorithm': 'AWS4-HMAC-SHA256',
                'x-amz-credential': 'string',
                'x-amz-date': '20230725T013857Z',
                'x-amz-security-token': 'string',
                'x-amz-signature': 'string',
            }
        ],
    )


class Kind1Model1(Enum):
    presigned_url_request = 'PresignedUrlRequest'


class Metadata1Model(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/artifact/v1/presigned-url-requests/pur-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/presigned-url-request=pur-12345'
        ],
    )


class PresignedUrlRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model] = None
    content_format: Optional[str] = Field(
        None, description='Archive format of the Flink Artifact.', examples=['JAR']
    )
    cloud: Optional[str] = Field(
        None,
        description='Cloud provider where the Flink Artifact archive is uploaded.',
        examples=['AWS'],
    )
    region: Optional[constr(max_length=60)] = Field(
        None,
        description='The Cloud provider region the Flink Artifact archive is uploaded.',
        examples=['us-east-1'],
    )
    environment: Optional[constr(max_length=255)] = Field(
        None,
        description='The Environment the uploaded Flink Artifact belongs to.',
        examples=['env-00000'],
    )


class Kind1Model2(Enum):
    flink_artifact_list = 'FlinkArtifactList'


class Metadata1Model1(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/artifact/v1/flink-artifacts']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/artifact/v1/flink-artifacts?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/artifact/v1/flink-artifacts?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/artifact/v1/flink-artifacts?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Kind1Model3(Enum):
    flink_artifact = 'FlinkArtifact'


class Metadata1Model2(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/artifact/v1/flink-artifacts/fa-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/flink-artifact=fa-12345'
        ],
    )


class FlinkArtifact(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    cloud: Optional[constr(max_length=60)] = Field(
        None,
        description='Cloud provider where the Flink Artifact archive is uploaded.',
        examples=['AWS'],
    )
    region: Optional[constr(max_length=60)] = Field(
        None,
        description='The Cloud provider region the Flink Artifact archive is uploaded.',
        examples=['us-east-1'],
    )
    environment: Optional[constr(max_length=255)] = Field(
        None,
        description='Environment the Flink Artifact belongs to.',
        examples=['env-00000'],
    )
    display_name: Optional[constr(max_length=60)] = Field(
        None,
        description='Unique name of the Flink Artifact per cloud, region, environment scope.',
    )
    class_: Optional[
        constr(
            pattern=r'^(([a-zA-Z][a-zA-Z_$0-9]*(\.[a-zA-Z][a-zA-Z_$0-9]*)*)\.)?([a-zA-Z][a-zA-Z_$0-9]*)$',
            max_length=150,
        )
    ] = Field(
        None,
        alias='class',
        description='Java class or alias for the artifact as provided by developer. Deprecated',
        examples=['io.confluent.example.SumScalarFunction'],
    )
    content_format: Optional[str] = Field(
        None, description='Archive format of the Flink Artifact.', examples=['JAR']
    )
    description: Optional[constr(max_length=256)] = Field(
        None, description='Description of the Flink Artifact.'
    )
    documentation_link: Optional[
        constr(pattern=r'^$|^(http://|https://).+', max_length=512)
    ] = Field(None, description='Documentation link of the Flink Artifact.')
    runtime_language: Optional[str] = Field(
        'JAVA', description='Runtime language of the Flink Artifact.', examples=['JAVA']
    )
    versions: Optional[List[FlinkArtifactVersion]] = Field(
        None, description='Versions associated with this Flink Artifact.'
    )


class FlinkArtifactVersion(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    version: constr(max_length=60) = Field(
        ..., description='Version id of the Flink Artifact.', examples=['cfa-ver-001']
    )
    release_notes: Optional[constr(max_length=256)] = Field(
        None, description='Release Notes of the Flink Artifact version.'
    )
    is_beta: Optional[bool] = Field(
        None, description='Flag to specify stability of the version'
    )
    artifact_id: FlinkArtifact = Field(
        ..., description='The Flink Artifact this version belongs to.'
    )
    upload_source: UploadSource.PresignedUrl = Field(
        ...,
        description='Upload source of the Flink Artifact Version.',
        discriminator='location',
    )


class FlinkArtifactList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model2 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model1
    data: List[FlinkArtifact] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class FlinkArtifactUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model3] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model2] = None
    cloud: Optional[constr(max_length=60)] = Field(
        None,
        description='Cloud provider where the Flink Artifact archive is uploaded.',
        examples=['AWS'],
    )
    region: Optional[constr(max_length=60)] = Field(
        None,
        description='The Cloud provider region the Flink Artifact archive is uploaded.',
        examples=['us-east-1'],
    )
    environment: Optional[constr(max_length=255)] = Field(
        None,
        description='Environment the Flink Artifact belongs to.',
        examples=['env-00000'],
    )
    display_name: Optional[constr(max_length=60)] = Field(
        None,
        description='Unique name of the Flink Artifact per cloud, region, environment scope.',
    )
    content_format: Optional[str] = Field(
        None, description='Archive format of the Flink Artifact.', examples=['JAR']
    )
    description: Optional[constr(max_length=256)] = Field(
        None, description='Description of the Flink Artifact.'
    )
    documentation_link: Optional[
        constr(pattern=r'^$|^(http://|https://).+', max_length=512)
    ] = Field(None, description='Documentation link of the Flink Artifact.')
    runtime_language: Optional[str] = Field(
        'JAVA', description='Runtime language of the Flink Artifact.', examples=['JAVA']
    )
    versions: Optional[List[FlinkArtifactVersion]] = Field(
        None, description='Versions associated with this Flink Artifact.'
    )


FlinkArtifact.model_rebuild()
