# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, conint, constr

from .. import EnvScopedObjectReference, GlobalObjectReference
from ..ListMeta import ListMeta
from ..ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    cmk_v2 = 'cmk/v2'


class Kind(Enum):
    cluster = 'Cluster'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cmk/v2/clusters/lkc-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/cloud-cluster=lkc-12345'
        ],
    )


class ClusterStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecyle phase of the cluster:\n  PROVISIONED:  cluster is provisioned;\n  PROVISIONING:  cluster provisioning is in progress;\n  FAILED:  provisioning failed\n',
        examples=['PROVISIONED'],
    )
    cku: Optional[conint(ge=1)] = Field(
        None,
        description='The number of Confluent Kafka Units (CKUs) the Dedicated cluster currently has.\n',
        examples=[2],
    )


class KindModel(Enum):
    basic = 'Basic'


class Basic(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Basic'] = Field(..., description='Basic cluster type.\n')


class KindModel1(Enum):
    standard = 'Standard'


class Standard(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Standard'] = Field(..., description='Standard cluster type.\n')


class KindModel2(Enum):
    enterprise = 'Enterprise'


class Enterprise(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Enterprise'] = Field(..., description='Enterprise cluster type.\n')


class KindModel3(Enum):
    dedicated = 'Dedicated'


class Dedicated(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Dedicated'] = Field(..., description='Dedicated cluster type.\n')
    cku: conint(ge=1) = Field(
        ...,
        description='The number of Confluent Kafka Units (CKUs) for Dedicated cluster types.\nMULTI_ZONE dedicated clusters must have at least two CKUs.\n',
        examples=[2],
    )
    encryption_key: Optional[str] = Field(
        None,
        description='The id of the encryption key that is used to encrypt the data in the Kafka cluster.\n(e.g. for Amazon Web Services, the Amazon Resource Name of the key).\n',
        examples=[
            'arn:aws:kms:us-west-2:000000000000:key/0000xxxx-00xx-00xx-00xx-0000000000xx'
        ],
    )
    zones: Optional[List[str]] = Field(
        None,
        description='The list of zones the cluster is in.\n\nOn AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html)\n (e.g. use1-az3)\n\nOn GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones)\n (e.g. us-central1-c).\n',
        examples=[['us-central1-a', 'us-central1-b', 'us-central1-c']],
        max_length=3,
        min_length=1,
    )


class KindModel4(Enum):
    freight = 'Freight'


class Freight(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Freight'] = Field(..., description='Freight cluster type.\n')
    zones: Optional[List[str]] = Field(
        None,
        description='The list of zones the cluster is in.\n\nOn AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html)\n (e.g. use1-az3)\n\nOn GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones)\n (e.g. us-central1-c).\n',
        examples=[['us-central1-a', 'us-central1-b', 'us-central1-c']],
        max_length=3,
        min_length=1,
    )


class KindModel5(Enum):
    cluster_list = 'ClusterList'


class MetadataModel(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cmk/v2/clusters']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cmk/v2/clusters?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cmk/v2/clusters?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cmk/v2/clusters?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class ClusterSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the cluster.', examples=['ProdKafkaCluster']
    )
    availability: Optional[str] = Field(
        None,
        description='The availability zone configuration of the cluster\n',
        examples=['SINGLE_ZONE'],
    )
    config: Optional[Union[Basic, Standard, Dedicated, Enterprise, Freight]] = Field(
        {'kind': 'Basic'},
        description='The configuration of the Kafka cluster.\n\nNote: Clusters can be upgraded from Basic to Standard, but cannot be downgraded from Standard to Basic.\n',
        discriminator='kind',
        examples=[{'kind': 'Basic'}],
    )
    environment: Optional[EnvScopedObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1(Enum):
    cluster = 'Cluster'


class Metadata1(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cmk/v2/clusters/lkc-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/cloud-cluster=lkc-12345'
        ],
    )


class ClusterUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1] = None
    spec: Optional[ClusterSpecUpdate] = None
    status: Optional[ClusterStatus] = None


class ClusterSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the cluster.', examples=['ProdKafkaCluster']
    )
    availability: Optional[str] = Field(
        None,
        description='The availability zone configuration of the cluster\n',
        examples=['SINGLE_ZONE'],
    )
    cloud: Optional[str] = Field(
        None,
        description='The cloud service provider in which the cluster is running.',
        examples=['GCP'],
    )
    region: Optional[str] = Field(
        None,
        description='The cloud service provider region where the cluster is running.',
        examples=['us-east4'],
    )
    config: Optional[Union[Basic, Standard, Dedicated, Enterprise, Freight]] = Field(
        {'kind': 'Basic'},
        description='The configuration of the Kafka cluster.\n\nNote: Clusters can be upgraded from Basic to Standard, but cannot be downgraded from Standard to Basic.\n',
        discriminator='kind',
        examples=[{'kind': 'Basic'}],
    )
    kafka_bootstrap_endpoint: Optional[str] = Field(
        None,
        description='The bootstrap endpoint used by Kafka clients to connect to the cluster.',
        examples=['lkc-00000-00000.us-central1.gcp.glb.confluent.cloud:9092'],
    )
    http_endpoint: Optional[AnyUrl] = Field(
        None,
        description='The cluster HTTP request URL.',
        examples=['https://lkc-00000-00000.us-central1.gcp.glb.confluent.cloud'],
    )
    api_endpoint: Optional[str] = Field(
        None,
        description='The Kafka API cluster endpoint used by Kafka clients to connect to the cluster.',
        examples=['https://pkac-00000.us-west-2.aws.confluent.cloud'],
    )
    environment: Optional[EnvScopedObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    network: Optional[EnvScopedObjectReference] = Field(
        None, description='The network associated with this object.'
    )
    byok: Optional[GlobalObjectReference] = Field(
        None, description='The byok associated with this object.'
    )


class Cluster(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    spec: Optional[ClusterSpec] = None
    status: Optional[ClusterStatus] = None


class Datum(Cluster):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class ClusterList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel5 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel
    data: List[Datum] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
