# 001 Architectural Design Record (ADR):  Drop Table Plus

<!-- toc -->
+ [**Status**](#status)
+ [**Context**](#context)
+ [**Decision**](#decision)
+ [**Y-Statement**](#y-statement)
+ [**Consequences**](#consequences)
+ [**Positive**](#positive)
+ [**Negative/Trade-off(s)**](#negativetrade-offs)
<!-- tocstop -->

## Status
Development - **DONE**

## Context
While developing a recent CCAF app, I learned that the `DROP TABLE` statement only removes a table definition from Apache Flink. It may delete associated resources, such as the Kafka topic and schemas in the Schema Registry, depending on the table type. However, the `RUNNING` statement must be stopped manually through the Dashboard, CLI, or REST API. Additionally, the `DROP TABLE` operation is not atomic; if the deletion of the Kafka topic or schema fails, the operation may only complete partially. It's important to note that dropping a table permanently deletes the data in the Kafka topic. Any running statements that depend on a dropped table will shift to `DEGRADED` status. A `DEGRADED` statement will not produce results but will continue to consume data from the source. Therefore, it is advisable to stop dependent statements before dropping a table. When using the `TopicNameStrategy`, dropping a table will result in deleting schemas, even if other topics use them.

There must be a way to automate the process of halting the running statements before dropping the table. Additionally, to ensure the table is dropped successfully, including, if applicable, the associated resources such as the Kafka topic and schemas in the Schema Registry.

## Decision
Develop a library that ensures data integrity and seamless resource management. This solution proactively terminates all active statements related to a table before safely executing its deletion. Beyond just removing the table, the application also purges all linked resources—such as Kafka topics and Schema Registry schemas—to maintain system consistency. In instances where these actions cannot be fully completed, it promptly alerts the calling application, ensuring robust error handling and transparent operations.

## Y-Statement
To build a cutting-edge CI/CD pipeline for the CCAF Table API App, we’re automating the teardown and buildup of Flink statements along with their associated Kafka resources—such as topics and schemas—and any continuously executing statements. This robust automation ensures that every deployment and test cycle is performed with unmatched consistency and reliability, paving the way for a truly dynamic and resilient application infrastructure.

## Consequences

### Positive
- Automated process for managing Flink statements and their associated resources
- Maintains system integrity

### Negative/Trade-off(s)
- Requires additional development time and resources
