"""Default model metadata and mapping rules for GitHub Copilot provider."""

from __future__ import annotations

from ccproxy.models.provider import ModelCard, ModelMappingRule


# Note: The actual model list is fetched remotely from the Copilot API.
# This list serves as fallback/default metadata for model cards.
DEFAULT_COPILOT_MODEL_CARDS: list[ModelCard] = [
    ModelCard(
        id="gpt-4.1",
        created=1745020800,
        owned_by="openai",
        permission=[],
        root="gpt-4.1",
        parent=None,
    ),
    ModelCard(
        id="gpt-5-mini",
        created=1730419200,
        owned_by="openai",
        permission=[],
        root="gpt-5-mini",
        parent=None,
    ),
    ModelCard(
        id="gpt-5",
        created=1723075200,
        owned_by="openai",
        permission=[],
        root="gpt-5",
        parent=None,
    ),
    ModelCard(
        id="gpt-3.5-turbo",
        created=1677628800,
        owned_by="openai",
        permission=[],
        root="gpt-3.5-turbo",
        parent=None,
    ),
    ModelCard(
        id="gpt-3.5-turbo-0613",
        created=1677628800,
        owned_by="openai",
        permission=[],
        root="gpt-3.5-turbo-0613",
        parent=None,
    ),
    ModelCard(
        id="gpt-4o-mini",
        created=1721260800,
        owned_by="openai",
        permission=[],
        root="gpt-4o-mini",
        parent=None,
    ),
    ModelCard(
        id="gpt-4o-mini-2024-07-18",
        created=1721260800,
        owned_by="openai",
        permission=[],
        root="gpt-4o-mini-2024-07-18",
        parent=None,
    ),
    ModelCard(
        id="gpt-4",
        created=1678924800,
        owned_by="openai",
        permission=[],
        root="gpt-4",
        parent=None,
    ),
    ModelCard(
        id="gpt-4-0613",
        created=1678924800,
        owned_by="openai",
        permission=[],
        root="gpt-4-0613",
        parent=None,
    ),
    ModelCard(
        id="gpt-4-0125-preview",
        created=1706054400,
        owned_by="openai",
        permission=[],
        root="gpt-4-0125-preview",
        parent=None,
    ),
    ModelCard(
        id="gpt-4o",
        created=1715040000,
        owned_by="openai",
        permission=[],
        root="gpt-4o",
        parent=None,
    ),
    ModelCard(
        id="gpt-4o-2024-11-20",
        created=1732060800,
        owned_by="openai",
        permission=[],
        root="gpt-4o-2024-11-20",
        parent=None,
    ),
    ModelCard(
        id="gpt-4o-2024-05-13",
        created=1715558400,
        owned_by="openai",
        permission=[],
        root="gpt-4o-2024-05-13",
        parent=None,
    ),
    ModelCard(
        id="gpt-4-o-preview",
        created=1715040000,
        owned_by="openai",
        permission=[],
        root="gpt-4-o-preview",
        parent=None,
    ),
    ModelCard(
        id="gpt-4o-2024-08-06",
        created=1722988800,
        owned_by="openai",
        permission=[],
        root="gpt-4o-2024-08-06",
        parent=None,
    ),
    ModelCard(
        id="o3-mini",
        created=1735689600,
        owned_by="openai",
        permission=[],
        root="o3-mini",
        parent=None,
    ),
    ModelCard(
        id="o3-mini-2025-01-31",
        created=1738368000,
        owned_by="openai",
        permission=[],
        root="o3-mini-2025-01-31",
        parent=None,
    ),
    ModelCard(
        id="o3-mini-paygo",
        created=1735689600,
        owned_by="openai",
        permission=[],
        root="o3-mini-paygo",
        parent=None,
    ),
    ModelCard(
        id="gpt-41-copilot",
        created=1745020800,
        owned_by="openai",
        permission=[],
        root="gpt-41-copilot",
        parent=None,
    ),
    ModelCard(
        id="grok-code-fast-1",
        created=1735689600,
        owned_by="xai",
        permission=[],
        root="grok-code-fast-1",
        parent=None,
    ),
    ModelCard(
        id="gpt-5-codex",
        created=1726444800,
        owned_by="openai",
        permission=[],
        root="gpt-5-codex",
        parent=None,
    ),
    ModelCard(
        id="text-embedding-ada-002",
        created=1671148800,
        owned_by="openai",
        permission=[],
        root="text-embedding-ada-002",
        parent=None,
    ),
    ModelCard(
        id="text-embedding-3-small",
        created=1704067200,
        owned_by="openai",
        permission=[],
        root="text-embedding-3-small",
        parent=None,
    ),
    ModelCard(
        id="text-embedding-3-small-inference",
        created=1704067200,
        owned_by="openai",
        permission=[],
        root="text-embedding-3-small-inference",
        parent=None,
    ),
    ModelCard(
        id="claude-3.5-sonnet",
        created=1696000000,
        owned_by="anthropic",
        permission=[],
        root="claude-3.5-sonnet",
        parent=None,
    ),
    ModelCard(
        id="claude-3.7-sonnet",
        created=1708819200,
        owned_by="anthropic",
        permission=[],
        root="claude-3.7-sonnet",
        parent=None,
    ),
    ModelCard(
        id="claude-3.7-sonnet-thought",
        created=1738368000,
        owned_by="anthropic",
        permission=[],
        root="claude-3.7-sonnet-thought",
        parent=None,
    ),
    ModelCard(
        id="claude-sonnet-4",
        created=1716336000,
        owned_by="anthropic",
        permission=[],
        root="claude-sonnet-4",
        parent=None,
    ),
    ModelCard(
        id="gemini-2.0-flash-001",
        created=1735689600,
        owned_by="google",
        permission=[],
        root="gemini-2.0-flash-001",
        parent=None,
    ),
    ModelCard(
        id="gemini-2.5-pro",
        created=1738368000,
        owned_by="google",
        permission=[],
        root="gemini-2.5-pro",
        parent=None,
    ),
    ModelCard(
        id="o4-mini",
        created=1745884800,
        owned_by="openai",
        permission=[],
        root="o4-mini",
        parent=None,
    ),
    ModelCard(
        id="o4-mini-2025-04-16",
        created=1745884800,
        owned_by="openai",
        permission=[],
        root="o4-mini-2025-04-16",
        parent=None,
    ),
    ModelCard(
        id="gpt-4.1-2025-04-14",
        created=1745020800,
        owned_by="openai",
        permission=[],
        root="gpt-4.1-2025-04-14",
        parent=None,
    ),
]


DEFAULT_COPILOT_MODEL_MAPPINGS: list[ModelMappingRule] = []


__all__ = [
    "DEFAULT_COPILOT_MODEL_CARDS",
    "DEFAULT_COPILOT_MODEL_MAPPINGS",
]
