import { aws_lambda as lambda } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Properties for Powertools layer for python.
 */
export interface PowertoolsLayerProps {
    /**
     * The powertools package version from pypi repository.
     */
    readonly version?: string;
    /**
     * A flag for the extras dependencies (pydantic, aws-xray-sdk, etc.)
     * This will increase the size of the layer significantly. If you don't use parsing, ignore it.
     */
    readonly includeExtras?: boolean;
    /**
     * the name of the layer, will be randomised if empty
     */
    readonly layerVersionName?: string;
    /**
     * the runtime of the layer
     */
    readonly runtimeFamily?: lambda.RuntimeFamily;
    /**
     * The compatible architectures for the layer
     */
    readonly compatibleArchitectures?: lambda.Architecture[];
}
/**
 * Defines a new Lambda Layer with Powertools for python library.
 */
export declare class LambdaPowertoolsLayer extends lambda.LayerVersion {
    /**
     * creates build argument for the Dockerfile.
     * There are multiple combinations between version and extras package that results in different suffix for the installation.
     * With and without version, with and without extras flag.
     * We construct one suffix here because it is easier to do in code than inside the Dockerfile with bash commands.
     * For example, if we set `includeExtras=true` and `version=1.22.0` we get '[all]==1.22.0'.
     *
     */
    static constructBuildArgs(runtimeFamily: lambda.RuntimeFamily, includeExtras: boolean | undefined, version: string | undefined): string;
    constructor(scope: Construct, id: string, props?: PowertoolsLayerProps);
}
