"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const ts_deepmerge_1 = require("ts-deepmerge");
const yaml_1 = require("yaml");
/**
 * GitLab Helm Chart construct for Kubernetes on AWS
 */
class GitlabConstruct extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.cluster = props.cluster;
        // defaults
        this.domainName = props.domainName ?? 'gitlab.example.com';
        this.namespace = props.namespace ?? 'default';
        this.name = props.chartName ?? 'gitlab';
        this._version = props.chartVersion ?? 'latest';
        // set initial default values
        this.defaultValues = {
            'certmanager-issuer': {
                email: 'administrator@' + this.domainName,
            },
            'global': {
                hosts: {
                    domain: this.domainName,
                },
                email: {
                    from: 'gitlab@' + this.domainName,
                    display_name: `GitLab (${this.domainName})`,
                },
            },
        };
        // load and merge values from yaml file if given
        this.yamlValues = props.valuesYamlFile ? (0, yaml_1.parse)((0, fs_1.readFileSync)(props.valuesYamlFile, 'utf8')) : {};
        this.mergedValues = (0, ts_deepmerge_1.merge)(this.defaultValues, this.yamlValues);
        if (props.valuesOverride) {
            for (let key in props.valuesOverride) {
                const keys = key.split('.');
                let values = this.mergedValues;
                let key_part;
                while (key_part = keys.shift()) {
                    if (keys.length == 0) {
                        values[key_part] = props.valuesOverride[key];
                    }
                    else if (values[key_part] === undefined) {
                        values[key_part] = {};
                    }
                    values = values[key_part];
                }
            }
        }
        this.chart = new aws_cdk_lib_1.aws_eks.HelmChart(this, id + 'Chart', {
            cluster: this.cluster,
            chart: this.name,
            repository: 'https://charts.gitlab.io/',
            namespace: this.namespace,
            version: this._version,
            values: this.mergedValues,
        });
    }
    get fqdn() {
        return this.domainName;
    }
    get version() {
        return this._version;
    }
    get values() {
        return this.mergedValues;
    }
}
exports.GitlabConstruct = GitlabConstruct;
_a = JSII_RTTI_SYMBOL_1;
GitlabConstruct[_a] = { fqn: "cdk-dev-cloud-constructs.GitlabConstruct", version: "0.0.21" };
//# sourceMappingURL=data:application/json;base64,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