import { aws_eks as eks } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Properties for the GitLab Helm Chart construct
 */
export interface GitlabProps {
    /**
     * Gitlab full qualified domain name
     */
    readonly cluster: eks.ICluster;
    readonly namespace?: string;
    readonly domainName?: string;
    readonly chartName?: string;
    readonly releaseName?: string;
    readonly chartVersion?: string;
    readonly valuesOverride?: {
        [key: string]: string;
    };
    readonly valuesYamlFile?: string;
}
/**
 * GitLab Helm Chart construct for Kubernetes on AWS
 */
export declare class GitlabConstruct extends Construct {
    readonly cluster: eks.ICluster;
    readonly namespace: string;
    readonly chart: eks.HelmChart;
    readonly name: string;
    readonly release: string;
    readonly domainName: string;
    readonly defaultValues: {
        [key: string]: any;
    };
    readonly mergedValues: {
        [key: string]: any;
    };
    readonly yamlValues: {
        [key: string]: any;
    };
    private _version;
    constructor(scope: Construct, id: string, props: GitlabProps);
    get fqdn(): string;
    get version(): string;
    get values(): {
        [key: string]: any;
    };
}
