"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const index_1 = require("./index");
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const mockApp = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(mockApp, 'testing-stack', { env });
const role = new aws_iam_1.Role(stack, 'runner-role', {
    assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
    description: 'For Gitlab EC2 Runner Test Role',
    roleName: 'TestRole',
});
const vpc = aws_ec2_1.Vpc.fromLookup(stack, 'defaultVpc', {
    isDefault: true,
});
const runner = new index_1.GitlabContainerRunner(stack, 'testing', {
    gitlabtoken: stack.node.tryGetContext('GITLAB_TOKEN') ?? 'glrt-GITLAB_TOKEN',
    ec2type: 't3.large',
    ec2iamrole: role,
    ebsSize: 100,
    selfvpc: vpc,
    // spotFleet: true,
    dockerVolumes: [
        {
            hostPath: '/tmp/cahce',
            containerPath: '/tmp/cahce',
        },
    ],
    gitlabRunnerVersion: '15.10',
    enabledIMDSv2: true,
});
//runner.expireAfter(Duration.hours(1));
runner.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3ReadOnlyAccess'));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(80));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(443));
//runner.runnerEc2.connections.allowFrom(Peer.ipv4('0.0.0.0/0'), Port.tcp(8080));
new aws_cdk_lib_1.CfnOutput(stack, 'role', { value: runner.runnerRole.roleArn });
//new CfnOutput(stack, 'InstanceID', { value: runner.runnerEc2.instanceId });
//# sourceMappingURL=data:application/json;base64,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