"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Gitpod = exports.GitpodPortVisibility = exports.GitpodOnOpen = exports.GitpodOpenIn = exports.GitpodOpenMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const yaml_1 = require("./yaml");
/**
  * Relative path of Gitpod file to generate
  */
const GITPOD_FILE = '.gitpod.yml';
/**
 * (experimental) Configure how the terminal should be opened relative to the previous task.
 *
 * @experimental
 */
var GitpodOpenMode;
(function (GitpodOpenMode) {
    GitpodOpenMode["TAB_AFTER"] = "tab-after";
    GitpodOpenMode["TAB_BEFORE"] = "tab-before";
    GitpodOpenMode["SPLIT_RIGHT"] = "split-right";
    GitpodOpenMode["SPLIT_LEFT"] = "split-left";
    GitpodOpenMode["SPLIT_TOP"] = "split-top";
    GitpodOpenMode["SPLIT_BOTTOM"] = "split-bottom";
})(GitpodOpenMode = exports.GitpodOpenMode || (exports.GitpodOpenMode = {}));
/**
 * (experimental) Configure where in the IDE the terminal should be opened.
 *
 * @experimental
 */
var GitpodOpenIn;
(function (GitpodOpenIn) {
    GitpodOpenIn["BOTTOM"] = "bottom";
    GitpodOpenIn["LEFT"] = "left";
    GitpodOpenIn["RIGHT"] = "right";
    GitpodOpenIn["MAIN"] = "main";
})(GitpodOpenIn = exports.GitpodOpenIn || (exports.GitpodOpenIn = {}));
/**
 * (experimental) What to do when a service on a port is detected.
 *
 * @experimental
 */
var GitpodOnOpen;
(function (GitpodOnOpen) {
    GitpodOnOpen["OPEN_BROWSER"] = "open-browser";
    GitpodOnOpen["OPEN_PREVIEW"] = "open-preview";
    GitpodOnOpen["NOTIFY"] = "notify";
    GitpodOnOpen["IGNORE"] = "ignore";
})(GitpodOnOpen = exports.GitpodOnOpen || (exports.GitpodOnOpen = {}));
/**
 * (experimental) Whether the port visibility should be private or public.
 *
 * @experimental
 */
var GitpodPortVisibility;
(function (GitpodPortVisibility) {
    GitpodPortVisibility["PUBLIC"] = "public";
    GitpodPortVisibility["PRIVATE"] = "private";
})(GitpodPortVisibility = exports.GitpodPortVisibility || (exports.GitpodPortVisibility = {}));
/**
 * (experimental) The Gitpod component which emits .gitpod.yml.
 *
 * @experimental
 */
class Gitpod extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        super(project);
        this.tasks = new Array();
        this.ports = new Array();
        this.vscodeExtensions = new Array();
        this.dockerImage = options === null || options === void 0 ? void 0 : options.dockerImage;
        if (options === null || options === void 0 ? void 0 : options.tasks) {
            for (const task of options.tasks) {
                this.addTasks(task);
            }
        }
        if (options === null || options === void 0 ? void 0 : options.prebuilds) {
            this.addPrebuilds(options === null || options === void 0 ? void 0 : options.prebuilds);
        }
        this.config = {
            image: () => this.renderDockerImage(),
            tasks: this.tasks,
            github: () => this.renderPrebuilds(),
            ports: this.ports,
            vscode: {
                extensions: this.vscodeExtensions,
            },
        };
        new yaml_1.YamlFile(this.project, GITPOD_FILE, { obj: this.config, omitEmpty: true, marker: true });
    }
    /**
     * (experimental) Add a custom Docker image or Dockerfile for the container.
     *
     * @param image The Docker image.
     * @experimental
     */
    addDockerImage(image) {
        if (this.dockerImage) {
            throw new Error('dockerImage cannot be redefined.');
        }
        this.dockerImage = image;
    }
    /**
     * (experimental) Add tasks to run when gitpod starts.
     *
     * By default, all tasks will be run in parallel. To run tasks in sequence,
     * create a new `Task` and specify the other tasks as subtasks.
     *
     * @param tasks The new tasks.
     * @experimental
     */
    addTasks(...tasks) {
        this.tasks.push(...tasks.map(task => ({
            name: task.name,
            command: `npx projen ${task.name}`,
        })));
    }
    /**
     * (experimental) Add a prebuilds configuration for the Gitpod App.
     *
     * @param config The configuration.
     * @experimental
     */
    addPrebuilds(config) {
        this.prebuilds = config;
    }
    /**
     * (experimental) Add a task with more granular options.
     *
     * By default, all tasks will be run in parallel. To run tasks in sequence,
     * create a new `Task` and set the other tasks as subtasks.
     *
     * @param options The task parameters.
     * @experimental
     */
    addCustomTask(options) {
        this.tasks.push({
            name: options.name,
            command: options.command,
            openMode: options.openMode,
            openIn: options.openIn,
            before: options.before,
            init: options.init,
            prebuild: options.prebuild,
        });
    }
    /**
     * (experimental) Add ports that should be exposed (forwarded) from the container.
     *
     * @param ports The new ports.
     * @experimental
     */
    addPorts(...ports) {
        this.ports.push(...ports.map(port => ({ port: port })));
    }
    /**
     * (experimental) Add a list of VSCode extensions that should be automatically installed in the container.
     *
     * These must be in the format defined in the Open VSX registry.
     *
     * @param extensions The extension IDs.
     * @see https://www.gitpod.io/docs/vscode-extensions/
     * @experimental
     * @example
     *
     * 'scala-lang.scala@0.3.9:O5XmjwY5Gz+0oDZAmqneJw=='
     */
    addVscodeExtensions(...extensions) {
        this.vscodeExtensions.push(...extensions);
    }
    renderDockerImage() {
        var _b, _c;
        if ((_b = this.dockerImage) === null || _b === void 0 ? void 0 : _b.image) {
            return this.dockerImage.image;
        }
        else if ((_c = this.dockerImage) === null || _c === void 0 ? void 0 : _c.dockerFile) {
            return {
                file: this.dockerImage.dockerFile,
            };
        }
        else {
            return undefined;
        }
    }
    renderPrebuilds() {
        if (this.prebuilds) {
            return {
                prebuilds: this.prebuilds,
            };
        }
        else {
            return undefined;
        }
    }
}
exports.Gitpod = Gitpod;
_a = JSII_RTTI_SYMBOL_1;
Gitpod[_a] = { fqn: "projen.Gitpod", version: "0.16.42" };
//# sourceMappingURL=data:application/json;base64,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