"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Publisher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const JSII_RELEASE_VERSION = 'latest';
/**
 * (experimental) Implements GitHub jobs for publishing modules to package managers.
 *
 * kw
 * Under the hood, it uses https://github.com/aws/jsii-release
 *
 * @experimental
 */
class Publisher extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b;
        super(project);
        this.workflow = options.workflow;
        this.buildJobId = options.buildJobId;
        this.artifactName = options.artifactName;
        this.jsiiReleaseVersion = (_b = options.jsiiReleaseVersion) !== null && _b !== void 0 ? _b : JSII_RELEASE_VERSION;
    }
    /**
     * (experimental) Publishes artifacts from `js/**` to npm.
     *
     * @param options Options.
     * @experimental
     */
    publishToNpm(options) {
        var _b;
        const npmTokenSecret = (_b = options.npmTokenSecret) !== null && _b !== void 0 ? _b : 'NPM_TOKEN';
        this.workflow.addJobs({
            release_npm: {
                'name': 'Release to NPM',
                'needs': this.buildJobId,
                'runs-on': 'ubuntu-latest',
                'container': {
                    image: 'jsii/superchain',
                },
                'steps': [
                    this.renderDownloadArtifactStep(),
                    {
                        name: 'Release',
                        run: this.renderJsiiReleaseCommand('jsii-release-npm'),
                        env: {
                            NPM_TOKEN: `\${{ secrets.${npmTokenSecret} }}`,
                            NPM_DIST_TAG: options.distTag,
                            NPM_REGISTRY: options.registry,
                        },
                    },
                ],
            },
        });
    }
    /**
     * (experimental) Publishes artifacts from `dotnet/**` to NuGet Gallary.
     *
     * @param options Options.
     * @experimental
     */
    publishToNuget(options) {
        var _b;
        const nugetApiKeySecret = (_b = options.nugetApiKeySecret) !== null && _b !== void 0 ? _b : 'NUGET_API_KEY';
        this.workflow.addJobs({
            release_nuget: {
                'name': 'Release to Nuget',
                'needs': this.buildJobId,
                'runs-on': 'ubuntu-latest',
                'container': {
                    image: 'jsii/superchain',
                },
                'steps': [
                    this.renderDownloadArtifactStep(),
                    {
                        name: 'Release',
                        run: this.renderJsiiReleaseCommand('jsii-release-nuget'),
                        env: {
                            NUGET_API_KEY: `\${{ secrets.${nugetApiKeySecret} }}`,
                        },
                    },
                ],
            },
        });
    }
    /**
     * (experimental) Publishes artifacts from `java/**` to Maven.
     *
     * @param options Options.
     * @experimental
     */
    publishToMaven(options) {
        var _b, _c, _d, _e, _f;
        const mavenGpgPrivateKeySecret = (_b = options.mavenGpgPrivateKeySecret) !== null && _b !== void 0 ? _b : 'MAVEN_GPG_PRIVATE_KEY';
        const mavenGpgPrivateKeyPassphrase = (_c = options.mavenGpgPrivateKeyPassphrase) !== null && _c !== void 0 ? _c : 'MAVEN_GPG_PRIVATE_KEY_PASSPHRASE';
        const mavenUsername = (_d = options.mavenUsername) !== null && _d !== void 0 ? _d : 'MAVEN_USERNAME';
        const mavenPassword = (_e = options.mavenPassword) !== null && _e !== void 0 ? _e : 'MAVEN_PASSWORD';
        const mavenStagingProfileId = (_f = options.mavenStagingProfileId) !== null && _f !== void 0 ? _f : 'MAVEN_STAGING_PROFILE_ID';
        this.workflow.addJobs({
            release_maven: {
                'name': 'Release to Maven',
                'needs': this.buildJobId,
                'runs-on': 'ubuntu-latest',
                'container': {
                    image: 'jsii/superchain',
                },
                'steps': [
                    this.renderDownloadArtifactStep(),
                    {
                        name: 'Release',
                        run: this.renderJsiiReleaseCommand('jsii-release-maven'),
                        env: {
                            MAVEN_SERVER_ID: options.mavenServerId,
                            MAVEN_REPOSITORY_URL: options.mavenRepositoryUrl,
                            MAVEN_GPG_PRIVATE_KEY: `\${{ secrets.${mavenGpgPrivateKeySecret} }}`,
                            MAVEN_GPG_PRIVATE_KEY_PASSPHRASE: `\${{ secrets.${mavenGpgPrivateKeyPassphrase} }}`,
                            MAVEN_PASSWORD: `\${{ secrets.${mavenPassword} }}`,
                            MAVEN_USERNAME: `\${{ secrets.${mavenUsername} }}`,
                            MAVEN_STAGING_PROFILE_ID: `\${{ secrets.${mavenStagingProfileId} }}`,
                        },
                    },
                ],
            },
        });
    }
    /**
     * (experimental) Publishes wheel artifacts from `python` to PyPI.
     *
     * @param options Options.
     * @experimental
     */
    publishToPyPi(options) {
        var _b, _c;
        const twineUsername = (_b = options.twineUsernameSecret) !== null && _b !== void 0 ? _b : 'TWINE_USERNAME';
        const twinePassword = (_c = options.twinePasswordSecret) !== null && _c !== void 0 ? _c : 'TWINE_PASSWORD';
        this.workflow.addJobs({
            release_pypi: {
                'name': 'Release to PyPi',
                'needs': this.buildJobId,
                'runs-on': 'ubuntu-latest',
                'container': {
                    image: 'jsii/superchain',
                },
                'steps': [
                    this.renderDownloadArtifactStep(),
                    {
                        name: 'Release',
                        run: this.renderJsiiReleaseCommand('jsii-release-pypi'),
                        env: {
                            TWINE_USERNAME: `\${{ secrets.${twineUsername} }}`,
                            TWINE_PASSWORD: `\${{ secrets.${twinePassword} }}`,
                            ...(options.twineRegistryUrl && { TWINE_REPOSITORY_URL: options.twineRegistryUrl }),
                        },
                    },
                ],
            },
        });
    }
    /**
     * (experimental) Adds a go publishing job.
     *
     * @param options Options.
     * @experimental
     */
    publishToGo(options) {
        var _b, _c, _d;
        const githubTokenSecret = (_b = options.githubTokenSecret) !== null && _b !== void 0 ? _b : 'GO_GITHUB_TOKEN';
        this.workflow.addJobs({
            release_golang: {
                'name': 'Release to Go',
                'needs': this.buildJobId,
                'runs-on': 'ubuntu-latest',
                'container': {
                    image: 'jsii/superchain',
                },
                'steps': [
                    this.renderDownloadArtifactStep(),
                    {
                        name: 'Release',
                        run: this.renderJsiiReleaseCommand('jsii-release-golang'),
                        env: {
                            GITHUB_REPO: options.githubRepo,
                            GITHUB_TOKEN: `\${{ secrets.${githubTokenSecret} }}`,
                            GIT_BRANCH: options.gitBranch,
                            GIT_USER_NAME: (_c = options.gitUserName) !== null && _c !== void 0 ? _c : 'GitHub Actions',
                            GIT_USER_EMAIL: (_d = options.gitUserEmail) !== null && _d !== void 0 ? _d : 'github-actions@github.com',
                            GIT_COMMIT_MESSAGE: options.gitCommitMessage,
                        },
                    },
                ],
            },
        });
    }
    renderJsiiReleaseCommand(subcommand) {
        return `npx -p jsii-release@${this.jsiiReleaseVersion} ${subcommand}`;
    }
    renderDownloadArtifactStep() {
        return {
            name: 'Download build artifacts',
            uses: 'actions/download-artifact@v2',
            with: {
                name: this.artifactName,
                path: 'dist',
            },
        };
    }
}
exports.Publisher = Publisher;
_a = JSII_RTTI_SYMBOL_1;
Publisher[_a] = { fqn: "projen.Publisher", version: "0.16.42" };
//# sourceMappingURL=data:application/json;base64,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