import * as lambda from '@aws-cdk/aws-lambda';
import { Construct } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface BashExecFunctionProps {
    /**
     * The path of the shell script to be executed.
     *
     * @stability stable
     */
    readonly script: string;
    /**
     * The path of your custom dockerfile.
     *
     * @stability stable
     */
    readonly dockerfile?: string;
}
/**
 * @stability stable
 */
export declare class BashExecFunction extends Construct {
    /**
     * @stability stable
     */
    readonly handler: lambda.DockerImageFunction;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: BashExecFunctionProps);
    /**
     * @stability stable
     */
    run(): void;
}
