"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BashExecFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @stability stable
 */
class BashExecFunction extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        if ((props === null || props === void 0 ? void 0 : props.dockerfile) && fs.existsSync(props === null || props === void 0 ? void 0 : props.dockerfile)) {
            // Copy your Dockerfile to Dockerfile.custom.
            fs.copyFileSync(props === null || props === void 0 ? void 0 : props.dockerfile, path.join(__dirname, '../docker.d/Dockerfile.custom'));
        }
        const dockerDirPath = path.join(__dirname, '../docker.d');
        const scriptPath = props.script;
        // copy the user script to the docker.d directory as main.sh so we can bundle it up into a new docker image
        const mainFile = path.join(dockerDirPath, '/main.sh');
        fs.copyFileSync(scriptPath, mainFile);
        this.handler = new lambda.DockerImageFunction(this, 'BashExecFunction', {
            code: lambda.DockerImageCode.fromImageAsset(dockerDirPath, {
                file: (props === null || props === void 0 ? void 0 : props.dockerfile) && fs.existsSync(props === null || props === void 0 ? void 0 : props.dockerfile) ? 'Dockerfile.custom' : undefined,
            }),
            timeout: core_1.Duration.seconds(60),
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        new core_1.CfnOutput(this, 'LogGroup', { value: this.handler.logGroup.logGroupName });
    }
    /**
     * @stability stable
     */
    run() {
        const onEvent = new lambda.DockerImageFunction(this, 'OnEventHandler', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../docker.d'), {
                cmd: ['function.sh.onEvent'],
            }),
            environment: {
                LAMBDA_FUNCTION_ARN: this.handler.functionArn,
            },
            timeout: core_1.Duration.seconds(60),
        });
        const myProvider = new cr.Provider(this, 'MyProvider', {
            onEventHandler: onEvent,
        });
        new core_1.CustomResource(this, 'RunLambdaBash', { serviceToken: myProvider.serviceToken });
        this.handler.grantInvoke(onEvent.grantPrincipal);
    }
}
exports.BashExecFunction = BashExecFunction;
_a = JSII_RTTI_SYMBOL_1;
BashExecFunction[_a] = { fqn: "cdk-lambda-bash.BashExecFunction", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFpbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEseUJBQXlCO0FBQ3pCLDZCQUE2QjtBQUM3Qiw4Q0FBOEM7QUFDOUMsMENBQTBDO0FBQzFDLHdDQUErRTtBQUMvRSxnREFBZ0Q7Ozs7QUFjaEQsTUFBYSxnQkFBaUIsU0FBUSxnQkFBUzs7OztJQUU3QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFBLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxVQUFVLEtBQUksRUFBRSxDQUFDLFVBQVUsQ0FBQyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsVUFBVSxDQUFDLEVBQUU7WUFDekQsNkNBQTZDO1lBQzdDLEVBQUUsQ0FBQyxZQUFZLENBQUMsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFVBQVUsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSwrQkFBK0IsQ0FBQyxDQUFDLENBQUM7U0FDM0Y7UUFDRCxNQUFNLGFBQWEsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxhQUFhLENBQUMsQ0FBQztRQUMxRCxNQUFNLFVBQVUsR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1FBRWhDLDJHQUEyRztRQUMzRyxNQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxVQUFVLENBQUMsQ0FBQztRQUN0RCxFQUFFLENBQUMsWUFBWSxDQUFDLFVBQVUsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUV0QyxJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksTUFBTSxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRSxrQkFBa0IsRUFBRTtZQUN0RSxJQUFJLEVBQUUsTUFBTSxDQUFDLGVBQWUsQ0FBQyxjQUFjLENBQUMsYUFBYSxFQUFFO2dCQUN6RCxJQUFJLEVBQUUsQ0FBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsVUFBVSxLQUFJLEVBQUUsQ0FBQyxVQUFVLENBQUMsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQSxDQUFDLENBQUMsU0FBUzthQUM3RixDQUFDO1lBQ0YsT0FBTyxFQUFFLGVBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1lBQzdCLFlBQVksRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU87U0FDekMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxnQkFBUyxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUUsRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQztJQUNqRixDQUFDOzs7O0lBQ00sR0FBRztRQUNSLE1BQU0sT0FBTyxHQUFHLElBQUksTUFBTSxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRTtZQUNyRSxJQUFJLEVBQUUsTUFBTSxDQUFDLGVBQWUsQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsYUFBYSxDQUFDLEVBQUU7Z0JBQy9FLEdBQUcsRUFBRSxDQUFDLHFCQUFxQixDQUFDO2FBQzdCLENBQUM7WUFDRixXQUFXLEVBQUU7Z0JBQ1gsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxXQUFXO2FBQzlDO1lBQ0QsT0FBTyxFQUFFLGVBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1NBQzlCLENBQUMsQ0FBQztRQUNILE1BQU0sVUFBVSxHQUFHLElBQUksRUFBRSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFO1lBQ3JELGNBQWMsRUFBRSxPQUFPO1NBQ3hCLENBQUMsQ0FBQztRQUNILElBQUkscUJBQWMsQ0FBQyxJQUFJLEVBQUUsZUFBZSxFQUFFLEVBQUUsWUFBWSxFQUFFLFVBQVUsQ0FBQyxZQUFZLEVBQUUsQ0FBQyxDQUFDO1FBQ3JGLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNuRCxDQUFDOztBQXhDSCw0Q0EwQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBmcyBmcm9tICdmcyc7XG5pbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgbG9ncyBmcm9tICdAYXdzLWNkay9hd3MtbG9ncyc7XG5pbXBvcnQgeyBDZm5PdXRwdXQsIENvbnN0cnVjdCwgQ3VzdG9tUmVzb3VyY2UsIER1cmF0aW9uIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBjciBmcm9tICdAYXdzLWNkay9jdXN0b20tcmVzb3VyY2VzJztcblxuZXhwb3J0IGludGVyZmFjZSBCYXNoRXhlY0Z1bmN0aW9uUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzY3JpcHQ6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkb2NrZXJmaWxlPzogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgQmFzaEV4ZWNGdW5jdGlvbiBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHJlYWRvbmx5IGhhbmRsZXI6IGxhbWJkYS5Eb2NrZXJJbWFnZUZ1bmN0aW9uO1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQmFzaEV4ZWNGdW5jdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGlmIChwcm9wcz8uZG9ja2VyZmlsZSAmJiBmcy5leGlzdHNTeW5jKHByb3BzPy5kb2NrZXJmaWxlKSkge1xuICAgICAgLy8gQ29weSB5b3VyIERvY2tlcmZpbGUgdG8gRG9ja2VyZmlsZS5jdXN0b20uXG4gICAgICBmcy5jb3B5RmlsZVN5bmMocHJvcHM/LmRvY2tlcmZpbGUsIHBhdGguam9pbihfX2Rpcm5hbWUsICcuLi9kb2NrZXIuZC9Eb2NrZXJmaWxlLmN1c3RvbScpKTtcbiAgICB9XG4gICAgY29uc3QgZG9ja2VyRGlyUGF0aCA9IHBhdGguam9pbihfX2Rpcm5hbWUsICcuLi9kb2NrZXIuZCcpO1xuICAgIGNvbnN0IHNjcmlwdFBhdGggPSBwcm9wcy5zY3JpcHQ7XG5cbiAgICAvLyBjb3B5IHRoZSB1c2VyIHNjcmlwdCB0byB0aGUgZG9ja2VyLmQgZGlyZWN0b3J5IGFzIG1haW4uc2ggc28gd2UgY2FuIGJ1bmRsZSBpdCB1cCBpbnRvIGEgbmV3IGRvY2tlciBpbWFnZVxuICAgIGNvbnN0IG1haW5GaWxlID0gcGF0aC5qb2luKGRvY2tlckRpclBhdGgsICcvbWFpbi5zaCcpO1xuICAgIGZzLmNvcHlGaWxlU3luYyhzY3JpcHRQYXRoLCBtYWluRmlsZSk7XG5cbiAgICB0aGlzLmhhbmRsZXIgPSBuZXcgbGFtYmRhLkRvY2tlckltYWdlRnVuY3Rpb24odGhpcywgJ0Jhc2hFeGVjRnVuY3Rpb24nLCB7XG4gICAgICBjb2RlOiBsYW1iZGEuRG9ja2VySW1hZ2VDb2RlLmZyb21JbWFnZUFzc2V0KGRvY2tlckRpclBhdGgsIHtcbiAgICAgICAgZmlsZTogcHJvcHM/LmRvY2tlcmZpbGUgJiYgZnMuZXhpc3RzU3luYyhwcm9wcz8uZG9ja2VyZmlsZSkgPyAnRG9ja2VyZmlsZS5jdXN0b20nOiB1bmRlZmluZWQsXG4gICAgICB9KSxcbiAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLnNlY29uZHMoNjApLFxuICAgICAgbG9nUmV0ZW50aW9uOiBsb2dzLlJldGVudGlvbkRheXMuT05FX0RBWSxcbiAgICB9KTtcbiAgICBuZXcgQ2ZuT3V0cHV0KHRoaXMsICdMb2dHcm91cCcsIHsgdmFsdWU6IHRoaXMuaGFuZGxlci5sb2dHcm91cC5sb2dHcm91cE5hbWUgfSk7XG4gIH1cbiAgcHVibGljIHJ1bigpIHtcbiAgICBjb25zdCBvbkV2ZW50ID0gbmV3IGxhbWJkYS5Eb2NrZXJJbWFnZUZ1bmN0aW9uKHRoaXMsICdPbkV2ZW50SGFuZGxlcicsIHtcbiAgICAgIGNvZGU6IGxhbWJkYS5Eb2NrZXJJbWFnZUNvZGUuZnJvbUltYWdlQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJy4uL2RvY2tlci5kJyksIHtcbiAgICAgICAgY21kOiBbJ2Z1bmN0aW9uLnNoLm9uRXZlbnQnXSxcbiAgICAgIH0pLFxuICAgICAgZW52aXJvbm1lbnQ6IHtcbiAgICAgICAgTEFNQkRBX0ZVTkNUSU9OX0FSTjogdGhpcy5oYW5kbGVyLmZ1bmN0aW9uQXJuLFxuICAgICAgfSxcbiAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLnNlY29uZHMoNjApLFxuICAgIH0pO1xuICAgIGNvbnN0IG15UHJvdmlkZXIgPSBuZXcgY3IuUHJvdmlkZXIodGhpcywgJ015UHJvdmlkZXInLCB7XG4gICAgICBvbkV2ZW50SGFuZGxlcjogb25FdmVudCxcbiAgICB9KTtcbiAgICBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgJ1J1bkxhbWJkYUJhc2gnLCB7IHNlcnZpY2VUb2tlbjogbXlQcm92aWRlci5zZXJ2aWNlVG9rZW4gfSk7XG4gICAgdGhpcy5oYW5kbGVyLmdyYW50SW52b2tlKG9uRXZlbnQuZ3JhbnRQcmluY2lwYWwpO1xuICB9XG5cbn1cbiJdfQ==