"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const TOML = require("@iarna/toml");
const __1 = require("..");
const util_1 = require("./util");
test('toml object can be mutated before synthesis', () => {
    const prj = new util_1.TestProject();
    const obj = {
        hello: 'world',
    };
    new __1.TomlFile(prj, 'my/toml/file.toml', { obj });
    // mutate obj (should be reflected in the output)
    obj.anotherField = {
        foo: 1234,
    };
    const out = util_1.synthSnapshot(prj);
    expect(TOML.parse(out['my/toml/file.toml'])).toStrictEqual({
        hello: 'world',
        anotherField: { foo: 1234 },
    });
});
test('toml file can contain projen marker', () => {
    const prj = new util_1.TestProject();
    const obj = {};
    new __1.TomlFile(prj, 'my/toml/file-marker.toml', { obj, marker: true });
    const output = util_1.synthSnapshot(prj)['my/toml/file-marker.toml'];
    const firstLine = output.split('\n')[0];
    expect(firstLine).toBe(`# ${__1.TomlFile.PROJEN_MARKER}`);
});
//# sourceMappingURL=data:application/json;base64,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