"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const path = require("path");
const cdk = require("@aws-cdk/core");
const _1 = require(".");
class IntegTesting {
    constructor() {
        const devEnv = {
            account: process.env.CDK_DEFAULT_ACCOUNT,
            region: process.env.CDK_DEFAULT_REGION,
        };
        const app = new cdk.App();
        const stack = new cdk.Stack(app, 'lambda-bash-dev', { env: devEnv });
        const fn = new _1.BashExecFunction(stack, 'Demo', {
            script: path.join(__dirname, '../demo.sh'),
            dockerfile: path.join(__dirname, '../Dockerfile'),
            environment: {
                FOO: 'BAR',
            },
        });
        fn.run();
        app.synth();
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZCQUE2QjtBQUM3QixxQ0FBcUM7QUFDckMsd0JBQXFDO0FBR3JDLE1BQWEsWUFBWTtJQUV2QjtRQUNFLE1BQU0sTUFBTSxHQUFHO1lBQ2IsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO1lBQ3hDLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGtCQUFrQjtTQUN2QyxDQUFDO1FBRUYsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7UUFFMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxpQkFBaUIsRUFBRSxFQUFFLEdBQUcsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO1FBRXJFLE1BQU0sRUFBRSxHQUFHLElBQUksbUJBQWdCLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRTtZQUM3QyxNQUFNLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsWUFBWSxDQUFDO1lBQzFDLFVBQVUsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxlQUFlLENBQUM7WUFDakQsV0FBVyxFQUFFO2dCQUNYLEdBQUcsRUFBRSxLQUFLO2FBQ1g7U0FDRixDQUFDLENBQUM7UUFFSCxFQUFFLENBQUMsR0FBRyxFQUFFLENBQUM7UUFFVCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDWixJQUFJLENBQUMsS0FBSyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDdkIsQ0FBQztDQUNGO0FBekJELG9DQXlCQztBQUVELElBQUksWUFBWSxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQmFzaEV4ZWNGdW5jdGlvbiB9IGZyb20gJy4nO1xuXG5cbmV4cG9ydCBjbGFzcyBJbnRlZ1Rlc3Rpbmcge1xuICByZWFkb25seSBzdGFjazogY2RrLlN0YWNrW107XG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIGNvbnN0IGRldkVudiA9IHtcbiAgICAgIGFjY291bnQ6IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX0FDQ09VTlQsXG4gICAgICByZWdpb246IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX1JFR0lPTixcbiAgICB9O1xuXG4gICAgY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcblxuICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdsYW1iZGEtYmFzaC1kZXYnLCB7IGVudjogZGV2RW52IH0pO1xuXG4gICAgY29uc3QgZm4gPSBuZXcgQmFzaEV4ZWNGdW5jdGlvbihzdGFjaywgJ0RlbW8nLCB7XG4gICAgICBzY3JpcHQ6IHBhdGguam9pbihfX2Rpcm5hbWUsICcuLi9kZW1vLnNoJyksXG4gICAgICBkb2NrZXJmaWxlOiBwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vRG9ja2VyZmlsZScpLFxuICAgICAgZW52aXJvbm1lbnQ6IHtcbiAgICAgICAgRk9POiAnQkFSJyxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBmbi5ydW4oKTtcblxuICAgIGFwcC5zeW50aCgpO1xuICAgIHRoaXMuc3RhY2sgPSBbc3RhY2tdO1xuICB9XG59XG5cbm5ldyBJbnRlZ1Rlc3RpbmcoKTtcblxuXG4iXX0=