"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Automation = void 0;
class Automation {
    constructor(project, props = {}) {
        var _a;
        this.project = project;
        this.automationToken = (_a = props.automationToken) !== null && _a !== void 0 ? _a : 'GITHUB_TOKEN';
    }
    autoMerge() {
        if (this.project.github) {
            // auto merge workflow
            const autoMerge = this.project.github.addWorkflow('AutoMerge');
            autoMerge.on({
                pull_request: {
                    types: ['labeled', 'opened', 'reopened'],
                },
                check_suite: {
                    types: ['completed'],
                },
                status: {},
            });
            autoMerge.addJobs({
                automerge: {
                    'runs-on': 'ubuntu-latest',
                    'steps': [
                        {
                            name: 'automerge',
                            uses: 'pascalgn/automerge-action@v0.13.1',
                            env: {
                                GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                                MERGE_LABELS: 'auto-merge,!wip,!work in progress,!do-not-merge',
                                MERGE_RETRY_SLEEP: '60000',
                                MERGE_DELETE_BRANCH: 'true',
                                MERGE_METHOD: 'squash',
                            },
                        },
                    ],
                },
            });
        }
        ;
    }
    ;
    autoApprove() {
        if (this.project.github) {
            const autoApprove = this.project.github.addWorkflow('AutoApprove');
            autoApprove.on({
                pull_request_target: {
                    types: ['assigned', 'opened', 'synchronize', 'reopened'],
                },
            });
            autoApprove.addJobs({
                'auto-approve': {
                    'runs-on': 'ubuntu-latest',
                    'steps': [
                        {
                            uses: 'hmarr/auto-approve-action@v2.0.0',
                            if: "github.actor == 'pahud' || contains( github.event.pull_request.labels.*.name, 'auto-approve')",
                            with: {
                                'github-token': '${{ secrets.GITHUB_TOKEN }}',
                            },
                        },
                    ],
                },
            });
        }
        ;
    }
    ;
    projenYarnUpgrade(id = 'ProjenYarnUpgrade', opts = {}) {
        if (this.project.github) {
            const projenYarnUpgrade = this.project.github.addWorkflow(id);
            projenYarnUpgrade.on({
                schedule: [{
                        cron: '11 0 * * *',
                    }],
                workflow_dispatch: {}, // allow manual triggering
            });
            const steps = [];
            steps.push({ uses: 'actions/checkout@v2' });
            steps.push({
                uses: 'actions/setup-node@v1',
                with: { 'node-version': '10.17.0' },
            });
            steps.push({ run: 'yarn upgrade' });
            steps.push({ run: 'yarn projen:upgrade' });
            // conditionally run the test
            if (opts.yarnTest) {
                steps.push({ run: 'yarn test' });
            }
            // submit a PR
            steps.push({
                name: 'Create Pull Request',
                uses: 'peter-evans/create-pull-request@v3',
                with: {
                    'token': '${{ secrets.' + this.automationToken + ' }}',
                    'commit-message': 'chore: upgrade projen',
                    'branch': 'auto/projen-upgrade',
                    'title': 'chore: upgrade projen and yarn',
                    'body': 'This PR upgrades projen and yarn upgrade to the latest version',
                    'labels': 'auto-merge,auto-approve',
                },
            });
            projenYarnUpgrade.addJobs({
                upgrade: {
                    'runs-on': 'ubuntu-latest',
                    'steps': steps,
                },
            });
        }
    }
}
exports.Automation = Automation;
//# sourceMappingURL=data:application/json;base64,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