"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BashExecFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @stability stable
 */
class BashExecFunction extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        if ((props === null || props === void 0 ? void 0 : props.dockerfile) && fs.existsSync(props === null || props === void 0 ? void 0 : props.dockerfile)) {
            // Copy your Dockerfile to Dockerfile.custom.
            fs.copyFileSync(props === null || props === void 0 ? void 0 : props.dockerfile, path.join(__dirname, '../docker.d/Dockerfile.custom'));
        }
        const dockerDirPath = path.join(__dirname, '../docker.d');
        const scriptPath = props.script;
        // copy the user script to the docker.d directory as main.sh so we can bundle it up into a new docker image
        const mainFile = path.join(dockerDirPath, '/main.sh');
        fs.copyFileSync(scriptPath, mainFile);
        this.handler = new lambda.DockerImageFunction(this, 'BashExecFunction', {
            code: lambda.DockerImageCode.fromImageAsset(dockerDirPath, {
                file: (props === null || props === void 0 ? void 0 : props.dockerfile) && fs.existsSync(props === null || props === void 0 ? void 0 : props.dockerfile) ? 'Dockerfile.custom' : undefined,
            }),
            timeout: core_1.Duration.seconds(60),
            logRetention: logs.RetentionDays.ONE_DAY,
            environment: props.environment,
        });
        new core_1.CfnOutput(this, 'LogGroup', { value: this.handler.logGroup.logGroupName });
    }
    /**
     * @stability stable
     */
    run(ops = {}) {
        const onEvent = new lambda.DockerImageFunction(this, 'OnEventHandler', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../docker.d'), {
                cmd: ['function.sh.onEvent'],
            }),
            environment: {
                LAMBDA_FUNCTION_ARN: this.handler.functionArn,
            },
            timeout: core_1.Duration.seconds(60),
        });
        const myProvider = new cr.Provider(this, 'MyProvider', {
            onEventHandler: onEvent,
        });
        const staging = new core_1.AssetStaging(this, 'Staging', {
            sourcePath: path.join(__dirname, '../docker.d'),
        });
        new core_1.CustomResource(this, 'RunLambdaBash', {
            serviceToken: myProvider.serviceToken,
            properties: {
                assetHash: ops.runOnUpdate ? staging.assetHash : undefined,
            },
        });
        this.handler.grantInvoke(onEvent.grantPrincipal);
    }
}
exports.BashExecFunction = BashExecFunction;
_a = JSII_RTTI_SYMBOL_1;
BashExecFunction[_a] = { fqn: "cdk-lambda-bash.BashExecFunction", version: "0.5.1" };
//# sourceMappingURL=data:application/json;base64,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