"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const common_1 = require("../common");
const typescript_1 = require("../typescript");
const util_1 = require("./util");
describe('mergeTsconfigOptions', () => {
    test('merging includes', () => {
        const mergedTsconfigOptions = typescript_1.mergeTsconfigOptions([
            {
                include: ['typescript.test.ts'],
                compilerOptions: {},
            },
            {
                include: ['abc'],
                compilerOptions: {},
            },
        ]);
        expect(mergedTsconfigOptions).toEqual(expect.objectContaining({
            include: ['typescript.test.ts', 'abc'],
        }));
    });
    test('merging excludes', () => {
        const mergedTsconfigOptions = typescript_1.mergeTsconfigOptions([
            {
                exclude: ['typescript.test.ts'],
                compilerOptions: {},
            },
            {
                exclude: ['abc'],
                compilerOptions: {},
            },
        ]);
        expect(mergedTsconfigOptions).toEqual(expect.objectContaining({
            exclude: ['typescript.test.ts', 'abc'],
        }));
    });
    test('merging compilerOptions', () => {
        const mergedTsconfigOptions = typescript_1.mergeTsconfigOptions([
            {
                compilerOptions: {
                    esModuleInterop: false,
                },
            },
            {
                compilerOptions: {
                    esModuleInterop: true,
                },
            },
        ]);
        expect(mergedTsconfigOptions).toEqual(expect.objectContaining({
            compilerOptions: {
                esModuleInterop: true,
            },
        }));
    });
});
test('tsconfig prop is propagated to eslint and jest tsconfigs', () => {
    const prj = new typescript_1.TypeScriptProject({
        name: 'test',
        outdir: util_1.mkdtemp(),
        defaultReleaseBranch: 'test',
        tsconfig: {
            include: ['typescript.test.ts'],
            compilerOptions: {
                esModuleInterop: true,
            },
        },
    });
    const out = util_1.synthSnapshot(prj);
    expect(out['tsconfig.json']).toEqual(expect.objectContaining({
        include: expect.arrayContaining([
            `${prj.srcdir}/**/*.ts`,
            'typescript.test.ts',
        ]),
        compilerOptions: expect.objectContaining({
            esModuleInterop: true,
        }),
    }));
    expect(out['tsconfig.eslint.json']).toEqual(expect.objectContaining({
        include: expect.arrayContaining([
            common_1.PROJEN_RC,
            `${prj.srcdir}/**/*.ts`,
            `${prj.testdir}/**/*.ts`,
            'typescript.test.ts',
        ]),
        compilerOptions: expect.objectContaining({
            esModuleInterop: true,
        }),
    }));
    expect(out['tsconfig.jest.json']).toEqual(expect.objectContaining({
        include: expect.arrayContaining([
            common_1.PROJEN_RC,
            `${prj.srcdir}/**/*.ts`,
            `${prj.testdir}/**/*.ts`,
            'typescript.test.ts',
        ]),
        compilerOptions: expect.objectContaining({
            esModuleInterop: true,
        }),
    }));
});
//# sourceMappingURL=data:application/json;base64,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