import * as lambda from '@aws-cdk/aws-lambda';
import { Construct, CustomResource } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface BashExecFunctionProps {
    /**
     * The path of the shell script to be executed.
     *
     * @stability stable
     */
    readonly script: string;
    /**
     * The path of your custom dockerfile.
     *
     * @stability stable
     */
    readonly dockerfile?: string;
    /**
     * Lambda environment variables.
     *
     * @stability stable
     */
    readonly environment?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface RunOps {
    /**
     * whether to run the lambda function again on the provider update.
     *
     * @default false;
     * @stability stable
     */
    readonly runOnUpdate?: boolean;
}
/**
 * @stability stable
 */
export declare class BashExecFunction extends Construct {
    /**
     * @stability stable
     */
    readonly handler: lambda.DockerImageFunction;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: BashExecFunctionProps);
    /**
     * @stability stable
     */
    run(ops?: RunOps): CustomResource;
}
