"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BashExecFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class BashExecFunction extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props?.dockerfile && fs.existsSync(props?.dockerfile)) {
            // Copy your Dockerfile to Dockerfile.custom.
            fs.copyFileSync(props?.dockerfile, path.join(__dirname, '../docker.d/Dockerfile.custom'));
        }
        const dockerDirPath = path.join(__dirname, '../docker.d');
        const scriptPath = props.script;
        // copy the user script to the docker.d directory as main.sh so we can bundle it up into a new docker image
        const mainFile = path.join(dockerDirPath, '/main.sh');
        fs.copyFileSync(scriptPath, mainFile);
        this.handler = new aws_cdk_lib_1.aws_lambda.DockerImageFunction(this, 'BashExecFunction', {
            code: aws_cdk_lib_1.aws_lambda.DockerImageCode.fromImageAsset(dockerDirPath, {
                file: props?.dockerfile && fs.existsSync(props?.dockerfile) ? 'Dockerfile.custom' : undefined,
            }),
            timeout: props.timeout ?? aws_cdk_lib_1.Duration.seconds(60),
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
            environment: props.environment,
            role: props.role,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'LogGroup', { value: this.handler.logGroup.logGroupName });
    }
    run(ops = {}) {
        const onEvent = new aws_cdk_lib_1.aws_lambda.DockerImageFunction(this, 'OnEventHandler', {
            code: aws_cdk_lib_1.aws_lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../docker.d'), {
                cmd: ['function.sh.onEvent'],
            }),
            environment: {
                LAMBDA_FUNCTION_ARN: this.handler.functionArn,
            },
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
        const myProvider = new aws_cdk_lib_1.custom_resources.Provider(this, 'MyProvider', {
            onEventHandler: onEvent,
        });
        const staging = new aws_cdk_lib_1.AssetStaging(this, 'Staging', {
            sourcePath: path.join(__dirname, '../docker.d'),
        });
        const resource = new aws_cdk_lib_1.CustomResource(this, 'RunLambdaBash', {
            resourceType: 'Custom::RunLambdaBash',
            serviceToken: myProvider.serviceToken,
            properties: {
                assetHash: ops.runOnUpdate ? staging.assetHash : undefined,
            },
        });
        this.handler.grantInvoke(onEvent.grantPrincipal);
        return resource;
    }
}
exports.BashExecFunction = BashExecFunction;
_a = JSII_RTTI_SYMBOL_1;
BashExecFunction[_a] = { fqn: "cdk-lambda-bash.BashExecFunction", version: "2.0.215" };
//# sourceMappingURL=data:application/json;base64,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