"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaPowertoolsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Defines a new Lambda Layer with Powertools for python library.
 *
 * @stability stable
 */
class LambdaPowertoolsLayer extends aws_cdk_lib_1.aws_lambda.LayerVersion {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            code: aws_cdk_lib_1.aws_lambda.Code.fromDockerBuild(path.join(__dirname, '../layer'), {
                buildArgs: {
                    PACKAGE_SUFFIX: LambdaPowertoolsLayer.constructBuildArgs(props === null || props === void 0 ? void 0 : props.includeExtras, props === null || props === void 0 ? void 0 : props.version),
                },
            }),
            license: 'MIT-0',
            compatibleRuntimes: [
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_6,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_7,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            ],
            description: `Lambda Powertools for Python${(props === null || props === void 0 ? void 0 : props.includeExtras) ? ' with Pydantic' : ''} ${(props === null || props === void 0 ? void 0 : props.version) ? `version ${props.version}` : 'latest version'}`.trim(),
        });
    }
    /**
     * creates build argument for the Dockerfile.
     *
     * We have multiple combinations between version and extras package that results in different suffix for the installation.
     * With and without version, with and without extras flag.
     * We construct one suffix here because it is easier to do than inside the Dockerfile with bash commands.
     * For example, if we set extras=true and version=1.22.0 we get '[pydantic]==1.22.0'.
     *
     * @stability stable
     */
    static constructBuildArgs(includeExtras, version) {
        let suffix = '';
        if (includeExtras) {
            suffix = '[pydantic]';
        }
        if (version) {
            suffix = `${suffix}==${version}`;
        }
        return suffix;
    }
    ;
}
exports.LambdaPowertoolsLayer = LambdaPowertoolsLayer;
_a = JSII_RTTI_SYMBOL_1;
LambdaPowertoolsLayer[_a] = { fqn: "cdk-lambda-powertools-python-layer.LambdaPowertoolsLayer", version: "2.0.4" };
//# sourceMappingURL=data:application/json;base64,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