import { aws_lambda as lambda } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Properties necessary to create Powertools layer for python.
 *
 * @stability stable
 */
export interface PowertoolsLayerProps {
    /**
     * The powertools package version form pypi repository.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * A flag to decide wether to include the extras package, used for parsing.
     *
     * This will increase the size of the layer significantly. If you don't use parsing, ignore it.
     *
     * @stability stable
     */
    readonly includeExtras?: boolean;
}
/**
 * Defines a new Lambda Layer with Powertools for python library.
 *
 * @stability stable
 */
export declare class LambdaPowertoolsLayer extends lambda.LayerVersion {
    /**
     * creates build argument for the Dockerfile.
     *
     * We have multiple combinations between version and extras package that results in different suffix for the installation.
     * With and without version, with and without extras flag.
     * We construct one suffix here because it is easier to do than inside the Dockerfile with bash commands.
     * For example, if we set extras=true and version=1.22.0 we get '[pydantic]==1.22.0'.
     *
     * @stability stable
     */
    static constructBuildArgs(includeExtras: boolean | undefined, version: string | undefined): string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: PowertoolsLayerProps);
}
