#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// import 'source-map-support/register';
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const cdk = require("aws-cdk-lib/core");
const cdk_lambda_subminute_1 = require("../../cdk-lambda-subminute");
class TypescriptStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const targetLabmda = new aws_lambda_1.Function(this, 'targetFunction', {
            code: aws_lambda_1.Code.fromInline('exports.handler = function(event, ctx, cb) { return cb(null, "hi"); })'),
            functionName: 'testTargetFunction',
            runtime: aws_lambda_1.Runtime.NODEJS_18_X,
            handler: 'index.handler',
        });
        const cronJobExample = 'cron(50/1 3-4 ? * SUN-SAT *)';
        const subminuteMaster = new cdk_lambda_subminute_1.LambdaSubminute(this, 'LambdaSubminute', {
            targetFunction: targetLabmda,
            cronjobExpression: cronJobExample,
            frequency: 10,
            intervalTime: 6,
        });
        new cdk.CfnOutput(this, 'OStateMachineArn', { value: subminuteMaster.stateMachineArn });
        new cdk.CfnOutput(this, 'OIteratorFunctionArn', { value: subminuteMaster.iteratorFunction.functionArn });
    }
}
const app = new cdk.App();
new TypescriptStack(app, 'TypescriptStack', {
/* If you don't specify 'env', this stack will be environment-agnostic.
       * Account/Region-dependent features and context lookups will not work,
       * but a single synthesized template can be deployed anywhere. */
/* Uncomment the next line to specialize this stack for the AWS Account
       * and Region that are implied by the current CLI configuration. */
// env: { account: process.env.CDK_DEFAULT_ACCOUNT, region: process.env.CDK_DEFAULT_REGION },
/* Uncomment the next line if you know exactly what Account and Region you
       * want to deploy the stack to. */
// env: { account: '123456789012', region: 'us-east-1' },
/* For more information, see https://docs.aws.amazon.com/cdk/latest/guide/environments.html */
});
//# sourceMappingURL=data:application/json;base64,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