import { IFunction } from 'aws-cdk-lib/aws-lambda';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export interface LambdaSubminuteProps {
    /**
     * The Lambda function that is going to be executed per time unit less than one minute.
     */
    readonly targetFunction: IFunction;
    /**
     * A pattern you want this statemachine to be executed.
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html
     *
     * @default cron(50/1 15-17 ? * * *) UTC+0 being run every minute starting from 15:00 PM to 17:00 PM.
     */
    readonly cronjobExpression?: string;
    /**
     * How many times you intent to execute in a minute.
     *
     * @default 6
     */
    readonly frequency?: number;
    /**
     * Seconds for an interval, the product of `frequency` and `intervalTime` should be approximagely 1 minute.
     *
     * @default 10
     */
    readonly intervalTime?: number;
}
export declare class LambdaSubminute extends Construct {
    /**
     * The Lambda function that plays the role of the iterator.
     */
    readonly iteratorFunction: IFunction;
    /**
     * The ARN of the state machine that executes the target Lambda function per time unit less than one minute.
     */
    readonly stateMachineArn: string;
    constructor(parent: Construct, name: string, props: LambdaSubminuteProps);
}
export interface IteratorLambdaProps {
    /**
       * The Lambda function that is going to be executed per time unit less than one minute.
       */
    readonly targetFunction: IFunction;
}
export declare class IteratorLambda extends Construct {
    /**
       * A Lambda function that plays the role of the iterator.
       */
    readonly function: IFunction;
    constructor(scope: Construct, name: string, props: IteratorLambdaProps);
}
export interface SubminuteStateMachineProps {
    /**
     * the name of the state machine.
     */
    readonly stateMachineName: string;
    /**
     * the Lambda function that executes your intention.
     */
    readonly targetFunction: IFunction;
    /**
     * the iterator Lambda function for the target Lambda function.
     */
    readonly iteratorFunction: IFunction;
    /**
     * Seconds for an interval, the product of `frequency` and `intervalTime` should be approximagely 1 minute.
     *
     * @default 10
     */
    readonly intervalTime: number;
    /**
     * How many times you intent to execute in a minute.
     *
     * @default 6
     */
    readonly frequency: number;
}
export declare class SubminuteStateMachine extends Construct {
    readonly stateMachine: sfn.StateMachine;
    constructor(scope: Construct, id: string, props: SubminuteStateMachineProps);
    /**
     * Creates a state machine for breaking the limit of 1 minute with the CloudWatch Rules.
     *
     * @param iteratorFunction The iterator Lambda function for the target Labmda funciton.
     * @param intervalTime Seconds for an interval, the product of `frequency` and `intervalTime` should be approximagely 1 minute.
     * @param frequency How many times you intent to execute in a minute.
     * @returns THe job definition for the state machine.
     */
    private createJobDefinition;
    /**
     * Creates a role and corresponding policies for the subminute state machine.
     *
     * @param targetFunctionArn the ARN of the Lambda function that executes your intention.
     * @param iteratorFunctionArn the ARN of the iterator Lambda function for the target Lambda function.
     * @returns the role as the documentation indicates.
     */
    private _createWorkFlowRole;
}
