#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// import 'source-map-support/register';
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const cdk = require("aws-cdk-lib/core");
const cdk_lambda_subminute_1 = require("../../cdk-lambda-subminute");
class TypescriptStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const targetLabmda = new aws_lambda_1.Function(this, 'targetFunction', {
            code: aws_lambda_1.Code.fromInline('exports.handler = function(event, ctx, cb) { return cb(null, "hi"); })'),
            functionName: 'testTargetFunction',
            runtime: aws_lambda_1.Runtime.NODEJS_LATEST,
            handler: 'index.handler',
        });
        const cronJobExample = 'cron(50/1 3-4 ? * SUN-SAT *)';
        const subminuteMaster = new cdk_lambda_subminute_1.LambdaSubminute(this, 'LambdaSubminute', {
            targetFunction: targetLabmda,
            cronjobExpression: cronJobExample,
            frequency: 10,
            intervalTime: 6,
        });
        new cdk.CfnOutput(this, 'OStateMachineArn', { value: subminuteMaster.stateMachineArn });
        new cdk.CfnOutput(this, 'OIteratorFunctionArn', { value: subminuteMaster.iteratorFunction.functionArn });
    }
}
const app = new cdk.App();
new TypescriptStack(app, 'TypescriptStack', {
/* If you don't specify 'env', this stack will be environment-agnostic.
       * Account/Region-dependent features and context lookups will not work,
       * but a single synthesized template can be deployed anywhere. */
/* Uncomment the next line to specialize this stack for the AWS Account
       * and Region that are implied by the current CLI configuration. */
// env: { account: process.env.CDK_DEFAULT_ACCOUNT, region: process.env.CDK_DEFAULT_REGION },
/* Uncomment the next line if you know exactly what Account and Region you
       * want to deploy the stack to. */
// env: { account: '123456789012', region: 'us-east-1' },
/* For more information, see https://docs.aws.amazon.com/cdk/latest/guide/environments.html */
});
//# sourceMappingURL=data:application/json;base64,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